/*
 * Decompiled with CFR 0.152.
 */
package com.apporiented.algorithm.clustering;

import com.apporiented.algorithm.clustering.Cluster;
import com.apporiented.algorithm.clustering.ClusterPair;
import com.apporiented.algorithm.clustering.DistanceMap;
import org.junit.Assert;
import org.junit.Test;

public class DistanceMapTest {
    DistanceMap map = new DistanceMap();
    ClusterPair ab = new ClusterPair(new Cluster("a"), new Cluster("b"), 1.0);
    ClusterPair bc = new ClusterPair(new Cluster("b"), new Cluster("c"), 2.0);
    ClusterPair ca = new ClusterPair(new Cluster("c"), new Cluster("a"), 3.0);

    @Test
    public void testMapWorksWithSameDistance() throws Exception {
        this.map.add(this.ab);
        this.map.add(this.ab);
        Assert.assertEquals((long)1L, (long)this.map.list().size());
        ClusterPair remove = this.map.removeFirst();
        Assert.assertNotNull((Object)remove);
        Assert.assertEquals((long)0L, (long)this.map.list().size());
        ClusterPair remove2 = this.map.removeFirst();
        Assert.assertNull((Object)remove2);
    }

    @Test
    public void testMapRemovalFront() throws Exception {
        this.map.add(this.ca);
        this.map.add(this.bc);
        this.map.add(this.ab);
        ClusterPair removeFirst = this.map.removeFirst();
        Assert.assertEquals((Object)this.ab, (Object)removeFirst);
    }

    @Test
    public void testMapRemovalByObjectPollLoop() throws Exception {
        this.map.add(this.ca);
        this.map.add(this.bc);
        this.map.add(this.ab);
        Assert.assertTrue((boolean)this.map.remove(this.ab));
        ClusterPair removeFirst = this.map.removeFirst();
        Assert.assertEquals((Object)this.bc, (Object)removeFirst);
    }

    @Test
    public void testMapRemovalByObjectPollLoopHandlesAllEmpty() throws Exception {
        this.map.add(this.ca);
        this.map.add(this.bc);
        this.map.add(this.ab);
        Assert.assertTrue((boolean)this.map.remove(this.ab));
        Assert.assertTrue((boolean)this.map.remove(this.bc));
        Assert.assertTrue((boolean)this.map.remove(this.ca));
        Assert.assertFalse((boolean)this.map.remove(this.ab));
        ClusterPair removeFirst = this.map.removeFirst();
        Assert.assertNull((Object)removeFirst);
    }
}

