/*
 * Decompiled with CFR 0.152.
 */
package com.apporiented.algorithm.clustering;

import com.apporiented.algorithm.clustering.AverageLinkageStrategy;
import com.apporiented.algorithm.clustering.Cluster;
import com.apporiented.algorithm.clustering.DefaultClusteringAlgorithm;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class ClusterPerfTest {
    Cluster randomCluster(int n) {
        DefaultClusteringAlgorithm alg = new DefaultClusteringAlgorithm();
        return alg.performClustering(this.randomDataDist(n), this.randomDataNames(n), new AverageLinkageStrategy());
    }

    private double[][] randomDataDist(int n) {
        Random rnd = new Random();
        double[][] mat = new double[n][n];
        int i = 0;
        while (i < n) {
            mat[i][i] = 0.0;
            int j = i + 1;
            while (j < n) {
                double r;
                mat[i][j] = r = Math.floor(rnd.nextDouble() * 100.0) * 0.1;
                mat[j][i] = r;
                ++j;
            }
            ++i;
        }
        return mat;
    }

    private String[] randomDataNames(int n) {
        String[] ret = new String[n];
        int i = 0;
        while (i < n) {
            ret[i] = "" + i;
            ++i;
        }
        return ret;
    }

    @Test
    public void testRandomDataDist() throws Exception {
        double[][] dist = this.randomDataDist(4);
        Assert.assertEquals((long)dist.length, (long)4L);
    }

    @Test
    public void testRandomDataNames() throws Exception {
        Object[] names = this.randomDataNames(4);
        Assert.assertEquals((long)names.length, (long)4L);
        Object[] exp = new String[]{"0", "1", "2", "3"};
        Assert.assertArrayEquals((Object[])names, (Object[])exp);
    }

    private Long timeN(int n) {
        Long t0 = System.currentTimeMillis();
        Cluster cluster = this.randomCluster(n);
        return System.currentTimeMillis() - t0;
    }

    @Test
    public void testn() throws Exception {
        int n = 2;
        while (n < 513) {
            Long t = this.timeN(n);
            System.out.println(String.format("%3d nodes -> %5d ms", n, t));
            n *= 2;
        }
    }
}

