# Cataclysm: Dark Days Ahead Sierra Madre mod

A mod for the Cataclysm: Dark Days Ahead roguelike adding Sierra Madre location from Fallout New Vegas add-on Dead Money, serving as a tribute to the best Fallout DLC ever made.

For those who did not play Dead Money themselves the author of this mod strongly encourages them to do so before trying out this mod since the mod is obviously very spoiler-heavy, meant primarily for players who know Dead Money already.

# Content and Features

<ul>
<li>New locations - Sierra Madre Villa, Casino and Vault</li>
<li>New enemies known from Dead Money - 3 types of Ghost People and security holograms</li>
<li>New consumables known from Dead Money and Fallout New Vegas in general - stimpacks, couple of other drugs and Sierra Madre Martini to name a few</li>
<li>New healing mechanic - some items (for example stimpacks) instantly heal all limbs upon consuming</li>
<li>New guns from Dead Money - the famous holorifle, gauss rifle and laser pistol as well as new types of ammo and modifications for them</li>
<li>New melee weapons iconic to Dead Money - a new wariant of knife spear, bearfist, cosmic knife, throwing knife spear</li>
<li>Various misc items, for example Cloud Kiss which allows the player to craft poisonous variants of the weapons listed in the previous point or a portable hologram emitter allowing spawning of a player-friendly hologram for a short time</li>
<li>Crafting recipes and a few books containing them for many introduced items</li>
<li>Clothes and armor, for example Sierra Madre security armor</li>
<li>A bunch of NPCs and unique lines of dialogue as well as quasi-mission system (technically they aren't missions because they don't appear in the mission window, however at some points in dialogue the player is being told what to do next in order to progress through the mod)</li>
<li>Achievements</li>
<li>Unique mechanics known from Dead Money - pockets of toxic gas draining health, Sierra Madre Cloud inducing slight health drain while the player hangs around the Sierra Madre Villa, vending machines, terminals, Gala Event</li>
<li>Notes and grafittis scattered around telling the lore of Dead Money meant as a tribute to this awesome DLC</li>
<li>Custom challenging scenario meant to be the best way to experience the mod</li>
</ul>

# Difficulty

This mod is meant to be hard and the player will take a lot of damage while exploring Sierra Madre - this is by design. The mod provides access to instahealing items and strong painkillers as well as some good armor and weapons to help with that. Approach this mod as you'd any other game that is based on quickly losing, but also quickly regenerating HP (for example Fallout New Vegas itself) compared to how you'd normally approach CDDA with its long-term healing mechanics.

# Tips

In order to get access to the mod's crafting recipes, the most important skills to consider are as follows:

<ul>
<li>applied science (only in CDDA - doesn't exist in BN)</li>
<li>food handling (in BN it's called cooking)</li>
<li>fabrication</li>
<li>electronics</li>
</ul>

As far as the mod progression goes, at the begining of mod's custom scenario you'll encounter an NPC who'll start a conversation with you. While due to some hardcoded, forced blocks of dialogue ruining immersion there are no missions assigned by NPCs in this mod, in practice the NPCs will tell you everything you need to do, I tried to make their dialogue as clear as possible in that regard, so make sure to read through it carefully, otherwise you might get stuck.

Another thing to consider is that sometimes you'll have to run straight past an enemy that deals heavy damage - don't worry, just keep running and injecting stimpacks to instantly regain health as you take hits, it is a perfectly valid way of dealing with enemies in this mod.

# Installation

Download the mod for the game version you're using:

If you play Cataclysm DDA then click on the green "Code" button and select "Download ZIP".

If you play Cataclysm BN then you need to first switch to the branch "bright-nights-version" (click on the "master" button to open the list of available branches), then click on the code button and download zip like explained above.

Once the mod is downloaded simply extract the contents of the archive to the following directory:

main_game_dir/data/mods

Then you'll be able to choose this mod in the world creation menu. If you wish to add the mod to your existing save then open the following file:

main_game_dir/save/name_of_your_world/mods.json

In this file add the string "sierra_madre" to the list you'll see there. Note that the new locations won't spawn on the already generated terrain and you'll need to travel beyond your already explored map to find the Sierra Madre.

# IMPORTANT NOTE

Due to the technical limitations of CDDA modding porting the mechanics of hologram emitters and forcing the player to stay in the Sierra Madre until breaking into the vault has proven to be impossible.
That means that there's no way to switch the security holograms off and since they're invincible the player must evade them or escape from them, it's impossible to get rid of them.
Also if the player chooses to play through the mod's custom scenario the author strongly encourages playing with a self-imposed rule of not leaving the location at any circumstances unless the vault has been entered and the mod "completed". This is the way this mod was meant to be played and, as stated above, only technical limitations prevented enforcing this on the player. So if you start the custom scenario then simply treat leaving Sierra Madre prematurely as cheating. At least this is how the mod author treats it.

# Credits

Special thanks to everyone involved with creating and releasing Fallout New Vegas: Dead Money for making the best Fallout DLC ever and to anyone involved with Fallout New Vegas in general.

Also thanks to Kenan2000 and Axema Vales, two CDDA contributors that helped a lot with design ideas and dozens of bugfixes as well as providing all kinds of help in general. Be sure to check out their mods and contributions as well, links are included below.

And thanks to all those good people that all of them can't be listed here who provided some form of support or bugfixes at one point or another on reddit CDDA community, official Cataclysm: Dark Days Ahead discord server and CDDA Modding Community discord server.

# Links

Mod screenshots: https://imgur.com/a/uzrd1aE

Fallout New Vegas Steam page: https://store.steampowered.com/app/22380/Fallout_New_Vegas

Fallout New Vegas: Dead Money Steam page: https://store.steampowered.com/app/72730/Fallout_New_Vegas_Dead_Money

Cataclysm DDA website: https://cataclysmdda.org/

Cataclysm DDA reddit: https://www.reddit.com/r/cataclysmdda/

Cataclysm DDA repository: https://github.com/CleverRaven/Cataclysm-DDA

Cataclysm: Bright Nights (awesome sci-fi focused fork of CDDA) repository: https://github.com/cataclysmbnteam/Cataclysm-BN

Cataclysm: Dark Days Ahead discord server: https://discord.gg/jFEc7Yp

CDDA Modding Community discord server: https://discord.com/invite/xj9E3Sp

Kenan2000 git repository containing all his awesome CDDA contributions: https://github.com/Kenan2000

Axema Vales git repository containing all his awesome CDDA contributions: https://github.com/AxemaVales