# Summary and Background

Arcana and Magic Items focuses mainly on the aftermath of a few small, local groups whose discoveries led to rapid development in the field of the arcane. Using power from other worlds, they clashed with each other until, by the time of the Cataclysm, they were already all but wiped out.

These events date back a decade before the Cataclysm at most, with the most notable events occurring during the few years right before. They weren't the first groups to piece together insight into how things work in other worlds, the Beyond or beyond the Veil as they called it. There were always flaws in the fabric of reality even before the labs weakened the barrier between worlds, and this allowed information to pass through. But before these recent events, nearly every previous development was a false start, lost to history for all manner of reasons.

These arcanist orders, some of which existed as mundane cults or other groups as far back as thirty years pre-Cataclysm, were very small and isolated. Some had already been in conflict before any magic was involved. They warred among themselves for various reasons, preferring to stay beneath the notice of the wider world, and their conflict likely never spread beyond a single state, or beyond New England at most.

Working with contacts more closely involved in civilization at large, and the occasional wealthy patron with esoteric interests, these orders came and went with only a few incidents risking exposure to the wider world.

There were people who knew of these groups, and authorities who knew of the arcanists, largely ignorant of their true nature. A few small groups clashing in rural backwoods were ultimately of little importance, and by the time these orders were at their peak, the government had the looming threat of the imminent Cataclysm to deal with. In turn, they knew nothing of top secret laboratories that did far more to bring about the Cataclysm than their actions, and any discoveries of such a threat came too late to prevent what was to come. But even their arcane powers couldn't shield them from the Cataclysm, their powers being as much a threat to themselves as to their enemies. The player can find signs of their centers of power, and piece together what happened.

Time will tell whether their discoveries will persist to aid mankind's survival, whether their knowledge will fade into the darkness, or whether power from Beyond will only bring humanity another step closer to extinction.

# Fundamental Principles

The magic these arcane orders developed relies on a few different sources of power. These are commonly known as essence, blood essence, and dull essence. All of these are drawn from some initial source to be used as fuel, instead of tapped directly like spells using mana. Directly drawing upon life force or mana was a very late development, within the last year pre-Cataclysm, thus the majority of magic used by arcanists used essence of some sort.

Magic items, as the mod's title implies, are a key focus of the mods lore as well as gameplay. Anybody can use these items, each purpose-built for a specific function and designed to be intuitive to use. This made magic accessible, which allowed a limited number of specialists to provide for a larger number of combatants and offering a powerful logistical advantage.

Powerful an advantage as this is, there is always a price, always an energy source. Even if an item or spell makes a mockery of the laws of physics, some cost is incurred. Passive magical items are few and far between, many are relics whose origins are questionable or potentially unearthly. Even then, passive benefits usually have some form of downside, some counterbalance that draws upon energy in some way. This informs not just the mod's lore, but also its gameplay balance.

# Magic Signs and Arcane Blessings

By the time these orders developed true natural magic, actual spells powered from within, they were already in decline. The world was also already nearing its end. Every such spell is just as purpose-built as the magic items used by the people who developed those spells, and all of them are sparked by otherworldly influence. Growing awareness of the Beyond, and the exotic principles their denizens operate on, enabled those who study the Interlopers to develop rudimentary, primitive perhaps, forms of magic.

These Magic Signs, as they came to be known, have a much more physical cost to pay than the spiritual energy that fuels mana. It draws upon the connections that form the mind, tethering body and soul together. Rooted in blood magic and sacrificial rite, such raw magic exerts a heavy toll on the mental fortitude of its users.

However, there are other methods. Through otherworldly patronage, a method of true magic, drawing upon mana, did exist. But it was tied to otherworldly relics with specific purpose, most of which have been lost. Those gifts were granted sparingly, and geared towards eldritch goals. If such a relic was rediscovered, in this world of monsters and tears in reality, the being responsible might be more free with their gifts in exchange for furthering those objectives.

Others studied the power inherent in otherworldly monsters, and sought a method to emulate them as an alternative to developing natural magic. With hidden labs exploring means of using otherworldly means to alter human subjects, there was a valid logic behind this line of thinking, even if they weren't quite aware that less supernatural mutations were already being explored by others. Unfortunately, the only group to make a breakthrough in that area was destroyed before they could make use of their findings, but one could retrace their steps and complete what was started.

# Factions

Before these arcane developments, two events needed to happen to facilitate this explosion of magical research. A foundation, which was provided by a local group of mystics, combining a host of esoteric knowledge and theorizing on potential applications for the esoteric knowledge they compiled. What they lacked was a catalyst, a spark of otherworldly power that would let them actually put their ideas to the test, and roughly a decade before the Cataclysm they parted ways, taking their collected knowledge with them, in what was almost another false start.

When they dispersed, other factions were waiting. People who received these texts, and provided the spark that this foundation required. Local cults and other esoteric groups were active in the area as well, with the Sanguine Order being one such group. A murderous cult of sorts, preying upon local mystics and rural religious communities. The focus of their practice was power, and the belief that all living things had power within them that could be exploited. Through ritual murders and blood magic, they had begun to develop some inkling that this might, in fact, lead to supernatural developments, but this philosophy had yet to solidify into anything of practical value.

When they snatched up stray members of those mystics and their texts however, things fell into place. The Foundation, theoretical texts on practical utility of powers beyond humanity's grasp. And the Spark, a glimpse into something beyond the context of normal reality, that provided what was missing from the former. The Sanguine Order was not alone in this, and they weren't unopposed. Though isolated and rural, secretive in their criminal activities, they had made enemies. Vigilantes from small religious communities the Sanguine Order had wronged had already been attempting to hunt them down, beyond the reach of the law. United by a common enemy, this group would develop their own practices to counter the renewed threat the Sanguine Order posed. The ritual nature of these discoveries would lead to increasingly syncretic practices, a necessity among a group who counted devout Catholics, Neo-Pagans of various stripes, Muslims, and other faiths among their founders. Thus, the Cleansing Flame was born.

As these local, small-scale clashes escalated, scattered groups making their own independent developments, another major faction would develop in the ensuing chaos. By this point in time, the scientific community had already began to deepen the wounds in the Veil with their experiments. More knowledge could be gleaned by those who had the means to gaze into the Beyond, and another isolated cult saw something within. And it saw them, in turn. Forged by a pact with this interloper, they brought with them an understanding of how to use power from Beyond in the same way that the Sanguine Order used blood magic.

This threw the balance of power between these isolated groups into chaos. It was now full-on war, with these three factions coming to dominate. The Keepers of The Oath, as they came to be known, was at times ally and enemy to either of the two parties. Always trying to keep their clashes far from urban centers, yet increasingly dependent on contacts more connected to the world at large, the arcane orders soon went into decline. The deteriorating state of the world around them, the Cataclysm looming closer with every day, exacerbated this.

# Interlopers

In the wake of the Cataclysm, the world is now infested with beings that simply do not belong in this reality. The blob, the triffids, the Mycus, and more. It matters not whether some are merely from beyond the stars rather than beyond the Veil, attracted by this planet having become a powder keg of dimensional instability. Nor does it matter if they are mundane beings of thoroughly not-mundane realities, nor even if they are truly supernatural beings evocative of cosmic horror, from the nightmares of imaginative authors. That these beings survive, even thrive, in a world so burdened by hazards like Thermodynamics or Relativity, is a mystery of science. Whoever might have some inkling of the truth is likely dead by now, and the Interlopers themselves are unlikely to be very helpful about answering those questions.

However, one thing in humanity's favor is a mutual disadvantage, shared with all these invaders who have set up shop in this reality. They can be hunted, fought, killed. If not exterminated, then at least driven back and kept in check, though humanity is in no position to attempt such a thing on a large enough scale, and it's likely no one of this generation will live to see whether humanity rebuilds and adapts. The greater threats are those who have no physical presence on this world. There are things out there, who have no need to exist in this realm of matter and energy, for they can pursue their goals just fine where they are.

As with the powers warring physically on the post-Cataclysm world, their numbers and strength vary, and many of these beings are entirely beyond human understanding. Only a handful of them have even had enough interaction with humanity to have any sort of identity, to be named. One is the patron entity aiding the Keepers of The Oath, who they call He From Beyond The Veil. This being's true intent is still just as unknown as any other entity, though several of His goals are compatible enough with humanity's survival to explain why the Keepers saw this figure as a deity, with humanity's long-term interests in mind. There are hints that keeping rival powers in check are perhaps among His goals, along with warnings about potential consequences of the growing dimensional instability.

His followers preach that the fate of reality itself, of the Veil, even the survival of other Interlopers, is at stake, that the worst-case scenario may mean entirely planes of reality being cast into the abyss. They preach of the Veil as more than just a metaphorical barrier between worlds, but as literal threads woven into a support structure, without which entire universes may collapse. Whether His long-term plans are merely antagonistic towards other powers that dwell Beyond, whether the conquest of this world may follow from the Keepers pursuing this goal, or whether the true objectives are entirely beyond the context of this world and its stability, the Keepers are right in that, for now at least, this Interloper's short-term goals (however many centuries may be "short term" to such a being) are useful for survival in the wake of the Cataclysm.

The other powers involved in meddling from Beyond are significantly less-involved in humanity's affairs, with a being known as The Archon being a distant second place in terms of humanity's awareness of this being. This one was in part responsible for the downfall of the Keepers of The Oath. Other than an affinity for possessing those who call upon it, some degree of otherworldly influence on people while running amok with a physical host, and apparent rivalry with He From Beyond The Veil, nothing else is known about this being's goals or true nature.

# Interaction With Other Mods

In general, Arcana is fully intended to be compatible with Magiclysm and any other prominent magic-focused mods to be developed, and even strives to make combining them a more interesting experience, as much as possible within the limits of mod interaction. This applies from a lore perspective as well as gameplay, as Arcana's side-story is largely self-contained, written to avoid disrupting vanilla lore too severely.

In the context of Magiclysm specifically, the arcanist orders form a New Tradition, developing independently of the Old Tradition. Where declining magical orders refined natural magic from Foundation and Spark of a distant past, built up centuries of cautious development, the New Tradition made sporadic leaps and bounds, assisted by the worsening condition of the Veil permitting new knowledge to be gleamed from Beyond. It's most likely that the arcanists at least knew that other mages had come before, but almost no one among the major orders knew of any extant orders, assuming this knowledge to be lost.

In functional terms, the only difference in lore between Arcana alone and Arcana plus Magiclysm is that these glimpses into the Beyond had yielded results in the distant past, successfully developed into a useful practice without needing the wounds in the Veil. But as with Magiclysm's established lore, by the decades just before the Cataclysm this knowledge was increasingly rare. The only arcanists likely to have known much about the Old Tradition were the mystics whose writing provided the Foundation. Even then it was mixed in with eccentric religious texts, alchemical writings, exotic philosophy and other information that made its practical applications no longer easily understood, until the Sanguine Order provided the Spark that brought the New Tradition to life.
