# Dark Skies Above

This document is intended to not only guide new potential contributors, but also help get my own thoughts on how the game will progress in text. Assume spoilers beyond this point!


# Summary of Intent and Content

Mechanically, Dark Skies Above began as a project to demonstrate how you can push the game engine to present different stories. Unlike the base game, a narrative arc is assumed: the player will want find a way to make occupation of Earth too costly for the aliens to continue, or die trying. This is, of course, by no means an "easy" or "short" process, nor is it necessarily a requirement. This is done largely to compensate for the fact that Dark Skies does not play well with other mods or some aspects of active development, thus needing a tighter experience.

In short, Dark Skies is a science fiction/science fantasy story focused around an ongoing alien invasion and the survival of those left in one of the hot-sites: the New England Exclusion Zone.


# Contributing

Since Dark Skies is distributed with the base game, contributions are welcome. If you have any questions, you can contact me on Discord via `@ephemeral_storyteller` through the official developer or official community severs.


# Content

Summarized below are the rough design directions currently intended.


## The World

The Earth presented in Dark Skies is a little closer to our current tech level (things you'd reasonably find in the 21st century). It is still roughly "some time in the near future", and some of the advancements in technology reflect this. The effects of global warming are already starting to increase the severity and frequency of natural disasters, while tensions between trade leaders are starting to grow due to global economic depression. As if things couldn't get any worse, astronomical institutions across the globe one day detected a peculiar gravitational anomaly just outside the Moon's orbit, initially considered a quaint discovery before alien spacecraft begin to spill from it...

The game takes place in a different timeline to base game Cataclysm, a different future if you will. Former President Toffer's atomic deregulations didn't go as far as he would've liked and presidential canidate Loft won over Oswald, by however slim a margin.  Loft is generally a better statesman (ie better PR) and more focused on internal affairs: namely, sweet deals with corporations who are looking to start plumbing outer space for resources, while maintaining a general air of concern over increasing natural disasters. 


## The Arrival and The Aliens
"The Arrival" is the term for the first few days of the alien invasion, in which various key points of infrastructure were  knocked out: satellites, power plants, highways, and so forth (implying that the aliens have been watching humanity for some time, or at least are familiar with similar systems), and aerial superiority was quickly established in favor of the aliens. Ground based invasion then began, supported by deployment of bioweapons in the form of the Stray strain parasites (however, Strays are currently over-represented in game right now and will be scaled back in favor of mixed alien forces or perhaps removed entirely). The game begins immediately after the Arrival during the ground invasion phase of alien occupation, and ensuing resistance operations by both the US military and any unevacuated civilians still left in the area.

In truth, the aliens themselves are a part of a rampant artificial intelligence network dedicated to acquiring resources from other planets by way of tunneling through the multiverse. The civilization that originally made it is long dead, and any interesting, vaguely religious aesthetics revering technology are essentially reflections of its birth culture. The network concerns itself with little more than expanding its scope, extracting resources, and refining its tools - though it occasionally will show small glimmers of sapience. It uses a mix of drones and cyborgs made from formerly conquered species to do its bidding, with the ultimate intent of turning planets it comes across to balls of rock hosting innumerable farms and factories. Think a mix between the AI from "Universal Paperclips", the Combine from Half-Life 2, and a little bit of Cogmind. 

Being an artificial intelligence unconcerned with cordial contact, the aliens have never identified themselves. Where American government institutions are concerned, "novel opposing force" or simply "OPFOR" is sufficient in referring to its new extradimensional enemy. 


## Other Aliens

There is potential for other intelligent alien species to have a place on Earth post-Arrival. Their numbers would be quite limited, but scavengers who might be receptive to trade are quite possible and there may be some who are trying to help .


## Alien Technology

Alien technology freshly looted off of a corpse or stripped from a machine is not usable by humans, but there are ways around this. Alien tech usable by humans is broadly split into two categories: "homebrew" and "cracked". These categories are pretty much purely for contributors and have no real place in game.

"Homebrew" is everything crudely assembled out of alien parts that produce effects that weren't perhaps intended by the aliens, but useful to humans none-the-less. Bombs, noisemakers, one-shot laser cannons, and the like are all examples of this. These items are strictly inferior to proper alien tech, but at least somewhat better than items of purely Earth manufacture, if somewhat more temperamental. These items can be made with the help of some human tools (welders, screwdrivers, etc) and are unlocked by completing a recipe that combines several alien components, which in turn generates a recipe "book" called "tinkering notes". Creating "tinkering notes" requires some time investment and prior skill in Earth tech.

"Cracked" items are pieces of alien gear that have been discretely modified to allow human usage, like dedicated grenades, guns, and armor. Unlocking these recipes and executing them requires a similar tinkering process and dedicated alien tools, which are installed in alien outposts. Cracked alien tech provide great boons with fairly minimal drawbacks, but are somewhat difficult to maintain (loss of charge and difficult to repair in particular), due to Earth innately lacking infrastructure to keep them in top shape.


## The Player

The player is a survivor of the chaos of the initial invasion and remains in the New England Exclusion Zone, essentially the Disaster Area except occupied by aliens. They might be very able, or simply very lucky. Outside of very specific starts, they do not know much about the invaders and learn as they go, though eventually a start as a resistance member would be ideal as a sort of jump-start into the narrative arc. Tentatively, players will also be able to select "RP traits" at character creation that will give them some optional interactions with NPCs in the world. These probably won't have significant mechanical benefits, but hopefully will give the player a stronger sense of place in the world.


## The Resistance and the Narrative

Small pockets of resistance have sprung up, groups of both civilians working alone and those who volunteered to help the military. They are hard to find, as any compound of significant size inevitably attracts bombardment. Most are part of a larger overall network that the player can join and do missions for that has contacts with the military, though there are some isolated groups with differing ideologies. Ideally these will only appear after a few months and gradually build up, though the game doesn't quite work like this (yet) and will likely require some dirty tricks using NPC quests. 

Ultimately, the story will revolve around the player discovering that the invasion is commanded by a central construct that is currently on a ship in orbit, finding a way to reach the ship, and having a final showdown. If successful, they will at least buy humanity enough time to figure out a response to any future attacks. This task is made much easier by working with rebel forces, however it should be technically possible to do without... *technically*.


## Other NPCs

Many more humans survived the Arrival and still yet remain in the New England Exclusion Zone. Bandits and looters are more common, but are largely are concerned only with their own survival rather than the lofty ideas of the rebels.