--
-- PostgreSQL database dump
--

-- Dumped from database version 16.4 (Ubuntu 16.4-1.pgdg22.04+1)
-- Dumped by pg_dump version 16.4 (Ubuntu 16.4-1.pgdg22.04+1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: core_condobuilding; Type: TABLE; Schema: public; Owner: gurra
--

CREATE TABLE public.core_condobuilding (
    id bigint NOT NULL,
    address character varying(255) NOT NULL,
    alt_name character varying(255),
    year_built integer,
    residential boolean,
    floors integer,
    units integer,
    lat double precision,
    lon double precision,
    unit_range bigint[],
    total_sf integer,
    folio_count integer,
    li_unitmix character varying(10)[],
    li_unitmix_count integer[],
    unit_counts integer[],
    val_ownership_exclude double precision NOT NULL,
    top_owner_one character varying(255),
    top_ownership_one double precision,
    top_percent_owned_one double precision,
    top_owner_two character varying(255),
    top_ownership_two double precision,
    top_percent_owned_two double precision,
    top_owner_three character varying(255),
    top_ownership_three double precision,
    top_percent_owned_three double precision,
    ave_sf integer[],
    last_updated timestamp with time zone,
    market_id bigint,
    zip_code character varying(30),
    pie_labels character varying(10)[],
    pie_values double precision[],
    s3_excel_link character varying(200),
    s3_remarks_link character varying(200),
    common_remarks character varying(100)[],
    s3_gmaps_link character varying(200),
    sales_volume double precision[],
    ave_unit_line_sf double precision[],
    ave_unit_line_sf_labels character varying(10)[],
    unit_line_count integer[],
    unit_line_count_labels character varying(10)[],
    subdivision character varying(255),
    approved boolean NOT NULL
);


ALTER TABLE public.core_condobuilding OWNER TO gurra;

--
-- Name: core_condobuilding_id_seq; Type: SEQUENCE; Schema: public; Owner: gurra
--

ALTER TABLE public.core_condobuilding ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.core_condobuilding_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: core_condomarket; Type: TABLE; Schema: public; Owner: gurra
--

CREATE TABLE public.core_condomarket (
    id bigint NOT NULL,
    name character varying(255) NOT NULL,
    sales_volume double precision[],
    years_built double precision[],
    years_built_counts double precision[]
);


ALTER TABLE public.core_condomarket OWNER TO gurra;

--
-- Name: core_condomarket_id_seq; Type: SEQUENCE; Schema: public; Owner: gurra
--

ALTER TABLE public.core_condomarket ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.core_condomarket_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: core_condomarket_id_seq1; Type: SEQUENCE; Schema: public; Owner: gurra
--

CREATE SEQUENCE public.core_condomarket_id_seq1
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.core_condomarket_id_seq1 OWNER TO gurra;

--
-- Name: core_condomarket_id_seq1; Type: SEQUENCE OWNED BY; Schema: public; Owner: gurra
--

ALTER SEQUENCE public.core_condomarket_id_seq1 OWNED BY public.core_condomarket.id;


--
-- Name: core_condosale; Type: TABLE; Schema: public; Owner: gurra
--

CREATE TABLE public.core_condosale (
    id character varying(255) NOT NULL,
    sale_price integer,
    seller character varying(255),
    closing_date date,
    condo_unit_id bigint NOT NULL,
    buyers_arr character varying(255)[],
    sellers_arr character varying(255)[],
    blacklist boolean NOT NULL,
    qualification_description character varying(255),
    "order" integer NOT NULL
);


ALTER TABLE public.core_condosale OWNER TO gurra;

--
-- Name: core_condosale_buyers; Type: TABLE; Schema: public; Owner: gurra
--

CREATE TABLE public.core_condosale_buyers (
    id bigint NOT NULL,
    condosale_id character varying(255) NOT NULL,
    principal_id bigint NOT NULL
);


ALTER TABLE public.core_condosale_buyers OWNER TO gurra;

--
-- Name: core_condosale_buyers_id_seq; Type: SEQUENCE; Schema: public; Owner: gurra
--

ALTER TABLE public.core_condosale_buyers ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.core_condosale_buyers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: core_condosale_sellers; Type: TABLE; Schema: public; Owner: gurra
--

CREATE TABLE public.core_condosale_sellers (
    id bigint NOT NULL,
    condosale_id character varying(255) NOT NULL,
    principal_id bigint NOT NULL
);


ALTER TABLE public.core_condosale_sellers OWNER TO gurra;

--
-- Name: core_condosale_sellers_id_seq; Type: SEQUENCE; Schema: public; Owner: gurra
--

ALTER TABLE public.core_condosale_sellers ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.core_condosale_sellers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: core_condounit; Type: TABLE; Schema: public; Owner: gurra
--

CREATE TABLE public.core_condounit (
    id bigint NOT NULL,
    folio_id character varying(23) NOT NULL,
    unit_no character varying(10),
    current_owner character varying(255),
    beds integer,
    full_baths integer,
    half_baths integer,
    assessed_value integer,
    sf integer,
    blacklist boolean NOT NULL,
    last_updated timestamp with time zone,
    building_id bigint,
    current_owners_arr character varying(255)[],
    floor character varying(10),
    unit_line character varying(50),
    penthouse boolean NOT NULL
);


ALTER TABLE public.core_condounit OWNER TO gurra;

--
-- Name: core_condounit_current_owners; Type: TABLE; Schema: public; Owner: gurra
--

CREATE TABLE public.core_condounit_current_owners (
    id bigint NOT NULL,
    condounit_id bigint NOT NULL,
    principal_id bigint NOT NULL
);


ALTER TABLE public.core_condounit_current_owners OWNER TO gurra;

--
-- Name: core_condounit_current_owners_id_seq; Type: SEQUENCE; Schema: public; Owner: gurra
--

ALTER TABLE public.core_condounit_current_owners ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.core_condounit_current_owners_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: core_condounit_id_seq; Type: SEQUENCE; Schema: public; Owner: gurra
--

ALTER TABLE public.core_condounit ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.core_condounit_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Name: core_condounit_id_seq1; Type: SEQUENCE; Schema: public; Owner: gurra
--

CREATE SEQUENCE public.core_condounit_id_seq1
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER SEQUENCE public.core_condounit_id_seq1 OWNER TO gurra;

--
-- Name: core_condounit_id_seq1; Type: SEQUENCE OWNED BY; Schema: public; Owner: gurra
--

ALTER SEQUENCE public.core_condounit_id_seq1 OWNED BY public.core_condounit.id;


--
-- Name: core_principal; Type: TABLE; Schema: public; Owner: gurra
--

CREATE TABLE public.core_principal (
    id bigint NOT NULL,
    name character varying(255) NOT NULL,
    s3_remarks_link character varying(200)
);


ALTER TABLE public.core_principal OWNER TO gurra;

--
-- Name: core_principal_id_seq; Type: SEQUENCE; Schema: public; Owner: gurra
--

ALTER TABLE public.core_principal ALTER COLUMN id ADD GENERATED BY DEFAULT AS IDENTITY (
    SEQUENCE NAME public.core_principal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- Data for Name: core_condobuilding; Type: TABLE DATA; Schema: public; Owner: gurra
--

COPY public.core_condobuilding (id, address, alt_name, year_built, residential, floors, units, lat, lon, unit_range, total_sf, folio_count, li_unitmix, li_unitmix_count, unit_counts, val_ownership_exclude, top_owner_one, top_ownership_one, top_percent_owned_one, top_owner_two, top_ownership_two, top_percent_owned_two, top_owner_three, top_ownership_three, top_percent_owned_three, ave_sf, last_updated, market_id, zip_code, pie_labels, pie_values, s3_excel_link, s3_remarks_link, common_remarks, s3_gmaps_link, sales_volume, ave_unit_line_sf, ave_unit_line_sf_labels, unit_line_count, unit_line_count_labels, subdivision, approved) FROM stdin;
209	6365 COLLINS AVE	Akoya	2004	t	45	384	25.8460686	-80.11969669999999	{1,2,3}	471877	384	{1/1/0,1/1/1,1/2/0,2/2/0,2/2/1,3/2/1,3/3/1}	{44,88,60,109,4,74,5}	{0,192,113,79,0,0,0}	0.015	NEMONADA CORP	5	1.3	CAMEL GROUP LLC	3	0.78	ORLANDO P FERNANDEZ TRS	3	0.78	{0,886,1381,1843,0,0,0}	2024-07-18 13:33:59.66489+02	8	\N	{Other,"NEMONADA C","CAMEL GROU","ORLANDO P ","CHUNA LLC"}	{366,5,3,3,2}	https://estategy-main.s3.amazonaws.com/condo_csv/6365 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/6365 COLLINS AVE.jpg	{16089500,19113600,19430000,26078500,34763500,18027200}	{1803.53,1803.53,1429.43,1364.11,1363,991.66,987.13,979.05,979.05,683,683}	{01,03,02,08,07,04,06,11,09,05,10}	{38,38,38,38,38,38,38,37,37,22,22}	{07,11,01,03,06,04,09,02,08,05,10}	\N	t
220	6301 COLLINS AVE	La Gorce Palace	1995	t	34	208	25.8445198	-80.1197839	{1,2,3}	307440	208	{1/1/1,2/2/0,2/2/1,3/3/0}	{26,130,26,26}	{0,26,156,26,0,0,16}	0.015	PER MIKAEL OHLEN TRS	2	0.96	SARSSO LLC	2	0.96	PLATE PROPERTY LLC	2	0.96	{0,940,1391,1690,0,0,1372}	2024-07-18 15:13:10.857345+02	8	\N	{Other,"PER MIKAEL","SARSSO LLC","PLATE PROP","HUMBERTO B"}	{201,2,2,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/6301 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/6301 COLLINS AVE.jpg	{11798000,10142500,8197000,21234300,30828700,23635000}	{1700,1700,1700,1690,1690,1690,1440,1440,1440,1400,1400,1400,1340,1340,1340,1250,1250,1250,1220,1220,1220,940,940,940}	{03,H3,S3,01,S1,H1,05,H5,S5,02,S2,H2,H7,07,S7,08,S8,H8,06,H6,S6,04,H4,S4}	{23,23,23,23,23,23,23,23,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1}	{06,01,08,03,05,07,02,04,H7,H3,H1,H5,H8,H2,H4,H6,S8,S1,S2,S4,S3,S5,S6,S7}	\N	t
223	4701 N MERIDIAN AVE	Ritz-Carlton Residences Miami Beach	2019	t	8	52	25.8227618	-80.13216160000002	{1,2,3,4,5}	173912	52	{1/1/1,2/2/1,2/3/1,3/3/1,4/3/1,4/4/1,5/5/1}	{3,20,1,18,2,7,1}	{0,3,21,18,9,1,5}	0.015	220 MERIDIAN LLC	1	1.92	2723672 ONTARIO INC	1	1.92	JULIE BAER	1	1.92	{0,1632,2219,3269,4247,3985,4269}	2024-07-18 15:18:12.790868+02	8	\N	{Other}	{52}	https://estategy-main.s3.amazonaws.com/condo_csv/4701 N MERIDIAN AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/4701 N MERIDIAN AVE.jpg	{0,56497600,45628500,102860000,31955000,19290000}	{4097.67,3769,3687,3552,3547.5,3114.67,3095.5,3057,3034,2944.5,2748.67,2668,2569,2489.67,2426.67,2401,2269,2043,1825.67,1686.33}	{01,02,17,27,12,21,19,09,20,24,11,04,10,13,14,25,16,22,15,08}	{6,5,4,3,3,3,3,3,3,3,3,3,2,2,1,1,1,1,1,1}	{01,16,12,11,13,27,02,14,08,20,21,15,24,19,04,10,09,22,25,17}	\N	t
224	6000 COLLINS AVE	Terra Beachside Villas	2010	t	6	116	25.8430972	-80.121049	{1,2,3}	199069	116	{1/1/0,2/2/0,3/3/0,3/4/0}	{12,78,25,1}	{0,12,78,26,0,0,0}	0.015	GARDEN GROVE CAPITAL LLC	8	6.9	ARRKAN LLC	2	1.72	LUSAM INTERNATIONAL LLC	2	1.72	{0,1011,1700,2089,0,0,0}	2024-07-18 15:19:58.375926+02	8	\N	{Other,"GARDEN GRO","ARRKAN LLC","LUSAM INTE"}	{107,8,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/6000 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/6000 COLLINS AVE.jpg	{3794000,5840500,4659000,10126900,8726900,7377500}	{2170.67,1816.33,1816.33,1816.33,1816.33,1816.33,1816.33,1816.33,1816.33,1816.33,1816.33,1816.33,1816.33,1816.33,1816.33,1816.33,1816.33,1816.33,1816.33,1816.33,1816.33,1816.33,1816.33,1816.33,1816.33,1816.33,1700,1470.33,1470.33,1470.33,1470.33,1470.33,1470.33,1470.33,1470.33,1470.33,1470.33,1470.33,1470.33}	{14,18,23,44,25,12,13,26,32,42,07,29,05,08,17,19,24,36,38,48,01,02,06,30,20,11,16,21,22,04,27,28,03,10,40,46,09,15,34}	{3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2}	{18,21,22,04,23,44,25,27,28,12,13,26,32,42,07,03,10,29,40,46,05,08,09,14,15,17,19,24,34,36,38,48,01,02,06,30,20,11,16}	\N	t
225	5959 COLLINS AVE	The Bath Club	2005	t	20	112	25.8420137	-80.1200908	{1,2,3,4,7}	370966	112	{1/2/1,2/3/1,2/4/1,3/4/1,3/5/0,3/5/1,4/3/1,4/4/1,4/4/2,4/5/1,7/10/1}	{12,24,12,41,3,2,1,14,1,1,1}	{0,12,36,46,17,0,0}	0.015	5959 COLLINS LLC	2	1.79	ALESSANDRO NESTA	2	1.79	CHRISTOPHER E ENGEL	2	1.79	{0,1904,2530,4117,3979,0,0}	2024-07-18 15:21:51.780986+02	8	\N	{Other,"5959 COLLI",ALESSANDRO,CHRISTOPHE,"STEVEN BUN"}	{107,2,2,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/5959 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/5959 COLLINS AVE.jpg	{13550000,8150000,3500000,42092000,49014300,34890000}	{4238.33,4095.53,3807,3786.07,3231,2886.33,2811.46,1904}	{06,04,05,03,07,01,02,08}	{15,15,15,14,14,14,13,12}	{01,04,06,07,05,03,02,08}	\N	t
337	5775 COLLINS AVE	57 Ocean	2021	t	18	69	25.8392568	-80.12039469999999	{2,3,4,5}	159570	69	{2/2/1,2/3/0,3/3/1,4/4/1,4/5/1,5/6/0}	{24,14,11,2,16,2}	{0,0,38,11,18,2,2}	0.015	OCEAN 57 LLC	2	2.9	1403 OCEAN LLC	1	1.45	NORMA BARFIELD TRS	1	1.45	{0,0,1364,1996,3261,6767,6767}	2024-07-18 15:29:21.99017+02	8	\N	{Other,"OCEAN 57 L"}	{68,2}	https://estategy-main.s3.amazonaws.com/condo_csv/5775 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/5775 COLLINS AVE.jpg	{0,0,0,286040700,66705000,36115000}	{7456,6079,2962.47,2587.64,1612,1276,1262,1176}	{-1,-2,03,01,02,06,04,05}	{15,14,14,13,7,4,1,1}	{03,02,01,05,06,04,-1,-2}	\N	t
343	2301 COLLINS AVE	Roney Palace	1926	t	18	555	25.798778	-80.127191	{0,1,2,3,4}	519560	682	{0/1/0,0/2/0,1/1/0,1/1/1,1/2/0,1/3/1,2/2/0,2/4/0,3/3/0,4/4/0}	{226,1,169,63,45,1,46,1,2,1}	{227,278,47,2,1,0,20}	0.015	CARNETT INDUSTRIES LLC	6	1.08	GREYBAR PASSING LLC	6	1.08	SOUTHVIEW LLC	6	1.08	{686,965,1378,2330,2520,0,1167}	2024-07-18 15:38:23.421131+02	8	\N	{Other,"CARNETT IN","GREYBAR PA","SOUTHVIEW ","SUPERIOR P"}	{463,6,6,6,5}	https://estategy-main.s3.amazonaws.com/condo_csv/2301 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/2301 COLLINS AVE.jpg	{26446900,18323800,14075200,49949400,44852500,32966500}	{2520,1480,1480,1480,1324.62,1230,1230,1230,1230,1230,1230,1230,1180,1040,1018.46,1002.92,998.62,960,960,960,960,942.86,934.29,900,900,900,892.31,880,880,880,876.92,870,850,844.29,828.57,780,760,760,760,760,760,700.71,660.71,660,660,660,644.62,631.43,600,600,600}	{H9,09,10,H8,07,H7,06,08,H6,H5,H3,H4,26,H2,37,38,40,33,39,03,05,19,16,24,01,H1,32,34,02,04,15,18,25,17,14,12,27,28,35,31,36,22,20,23,42,43,21,11,30,41,29}	{14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,1,1,1,1,1,1,1,1,1}	{20,22,11,14,17,12,16,19,26,23,24,25,27,28,30,34,38,40,09,18,35,37,01,02,03,04,06,07,05,10,21,15,29,32,33,39,41,42,43,08,31,36,H7,H9,H6,H8,H1,H5,H3,H2,H4}	\N	t
344	100 LINCOLN RD	The Decoplage	1965	t	16	610	25.7904391	-80.1296945	{0,1,2,3}	446145	657	{0/1/0,0/2/0,1/1/0,1/1/1,1/2/0,1/2/1,2/2/0,3/2/0,3/3/0,3/3/1}	{366,2,114,60,1,2,62,1,1,1}	{368,177,62,3,0,0,11}	0.015	2001 ENTERPRISES CORP	5	0.82	SONIA VERA TRS	4	0.66	DPCBAM LLC	4	0.66	{543,819,1255,2168,0,0,1510}	2024-07-18 15:40:59.380827+02	8	\N	{Other,"2001 ENTER","SONIA VERA","DPCBAM LLC","VINCENT CR"}	{549,5,4,4,4}	https://estategy-main.s3.amazonaws.com/condo_csv/100 LINCOLN RD.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/100 LINCOLN RD.jpg	{10219000,9326400,5494800,14645300,32800900,12601900}	{2000,1900,1570,1500,1500,1490,1295.77,1190,1190,1169.29,1130,1010,1010,960,933.46,890,881.79,865,850,850,845,845,820,700,680,675,623.33,608.46,590.77,572.31,565,565,554.23,550,550,550,550,550,550,545,545,535,535,530,530,530,530,530,530,530,525,525,520,520,515}	{H3,H4,H2,H7,H5,H6,47,11,48,14,H1,42,41,H8,23,33,10,08,22,21,43,44,02,34,15,35,39,29,04,40,31,25,24,30,27,28,26,38,01,32,16,18,36,45,06,37,07,03,12,05,19,20,46,17,09}	{14,14,14,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,11,11,1,1,1,1,1,1,1,1}	{15,10,14,30,34,18,19,46,24,27,28,47,40,08,09,11,16,22,26,29,33,35,37,42,48,36,07,17,01,02,03,04,20,21,23,12,05,31,32,43,45,39,06,38,25,44,41,H1,H3,H7,H4,H5,H6,H2,H8}	\N	t
264	321 OCEAN DR	321 Ocean	2015	t	9	21	25.7722958	-80.1319008	{3,4,7}	51710	21	{3/2/1,3/3/1,3/4/1,4/4/1,4/5/1,4/5/2,7/7/2}	{2,10,1,5,1,1,1}	{0,0,0,13,7,0,0}	0.015	TIMOTHY GORDON	2	9.52	DCK SOUTH BEACH LLC	2	9.52	MATTHEW SANFORD	1	4.76	{0,0,0,2313,3091,0,0}	2024-07-18 17:01:49.036927+02	4	\N	{Other,"TIMOTHY GO","DCK SOUTH "}	{19,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/321 OCEAN DR.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/321 OCEAN DR.jpg	{6750000,4290000,27750000,20600000,9000000,0}	{3326,2756.43,1973.5,1705}	{00,01,02,03}	{8,7,4,2}	{00,01,02,03}	\N	t
342	1700 MERIDIAN AVE	Montclair Lofts	2005	t	5	40	25.7925427	-80.1368832	{2,3}	44301	40	{2/2/0,3/2/1,3/3/0}	{36,1,3}	{0,0,36,4,0,0,0}	0.015	ORLAN BOSTON TRS	2	5	401 MONTCLAIR LLC	1	2.5	MARCOS CASASSA	1	2.5	{0,0,1014,1944,0,0,0}	2024-07-18 15:36:04.893302+02	8	\N	{Other,"ORLAN BOST"}	{39,2}	https://estategy-main.s3.amazonaws.com/condo_csv/1700 MERIDIAN AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/1700 MERIDIAN AVE.jpg	{3084000,1034000,500000,2655000,7102000,715000}	{1368.6,1302,1180.2,1025,1018,1018,1014,1014,1014,995}	{02,06,01,08,10,04,05,03,07,12}	{5,5,4,4,4,4,4,4,3,3}	{01,02,05,10,06,12,03,07,04,08}	\N	t
260	1900 SUNSET HARBOUR DR	Sunset Harbour North	1996	t	26	219	25.7950664	-80.14463839999999	{1,2,3,4}	302290	219	{1/1/0,1/1/1,1/2/0,2/2/0,2/2/1,2/3/0,2/3/1,3/2/1,3/2/2,3/3/0,3/3/1,4/3/0,4/4/0,4/4/1}	{1,36,1,133,6,4,2,18,1,4,8,2,2,1}	{0,38,145,31,5,0,6}	0.015	VIRTUS MASCAGNI INC	3	1.37	SPLIT REAL ESTATE LLC	2	0.91	PETER MULLEN	2	0.91	{0,747,1238,2010,3316,0,2568}	2024-07-18 16:47:08.48976+02	5	\N	{Other,"VIRTUS MAS","SPLIT REAL","PETER MULL","JAY LEVINE"}	{213,3,2,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/1900 SUNSET HARBOUR DR.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/1900 SUNSET HARBOUR DR.jpg	{1485100,1125300,1590000,8502000,10346000,4645000}	{2650,2406.43,2346.67,2040,1559.38,1462.78,1276.88,1276.47,1267.89,1168,1141.18,1137.06,1065.29,1000,919.33,835.38}	{04,/4,02,/5,08,03,12,11,01,07,14,09,15,05,06,10}	{19,18,17,17,17,17,17,16,16,15,15,14,13,4,3,1}	{01,03,15,09,11,14,05,12,08,06,07,/4,10,04,02,/5}	\N	t
244	102 24 ST	1 Hotel & Homes South Beach	2015	t	16	239	25.7998295	-80.1267512	{1,2,3}	330394	239	{1/1/0,1/1/1,2/2/0,2/2/1,3/3/0,3/3/1}	{38,118,12,15,42,14}	{0,156,27,56,0,0,29}	0.015	SB HOTEL OWNER LP	84	35.15	SB HOTEL OWNER L P	7	2.93	DEW1014 INVESTMENTS LLC	2	0.84	{0,760,1400,2006,0,0,2122}	2024-07-18 16:19:01.197098+02	5	\N	{Other,"SB HOTEL O","SB HOTEL O","DEW1014 IN","CARL FREDE"}	{148,84,7,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/102 24 ST.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/102 24 ST.jpg	{56778500,57205000,21125900,88866300,60207500,28684500}	{1992.17,1952,1761.71,1685.38,1680.25,1581.75,1550.17,1506,1471,1376,1362.17,1268.88,1222.14,1219.86,1217,1116.67,1106.75,1082.88,1070.14,1037.57,985.38,943.5,941.4,918.75,893,893,866,865.33,820,693,693,693,693,693,693,592,592,580,580}	{40,19,15,04,20,07,44,09,22,02,17,08,13,10,06,45,18,21,12,01,03,24,11,05,31,14,16,27,46,33,43,25,35,41,23,34,36,37,39}	{8,8,8,8,8,8,8,8,7,7,7,7,7,7,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,5,3,3,1,1}	{21,07,20,03,05,08,18,04,06,15,01,10,13,12,24,33,43,44,25,40,37,45,19,39,17,34,16,27,31,35,41,22,23,14,11,02,09,36,46}	\N	t
253	1455 OCEAN DR	Il Villaggio	1999	t	17	120	25.7873417	-80.129359	{1,2,3,4,5}	260210	120	{1/1/1,2/2/1,2/3/1,3/3/0,3/3/1,3/4/1,4/3/1,4/4/1,4/6/1,5/6/1}	{22,39,12,17,1,24,1,2,1,1}	{0,22,51,42,4,1,7}	0.015	WILLIAM H ROEDY	3	2.5	JONATHAN PLUTZIK	2	1.67	STEVEN D BALAAM	2	1.67	{0,1302,1875,2292,3812,3970,2911}	2024-07-18 16:33:38.932892+02	5	\N	{Other,"WILLIAM H ","JONATHAN P","STEVEN D B","LUC PLAMON"}	{108,3,2,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/1455 OCEAN DR.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/1455 OCEAN DR.jpg	{4900000,13200000,8750000,31460000,19074000,12886000}	{3222,2352.73,2250,2236.67,1964.55,1930,1881.54,1813,1556.67,1450,1370}	{08,05,09,02,04,06,03,07,01,10,11}	{13,12,12,11,11,11,11,10,10,10,9}	{03,02,06,04,05,10,11,07,08,09,01}	\N	t
255	1000 WEST AVE	Mirador 1000 (South Tower)	1968	t	17	446	25.7808649	-80.14272749999999	{0,1,2,3}	399395	446	{0/1/0,0/2/0,1/1/0,1/1/1,1/2/0,2/2/0,2/2/1,3/2/0,3/2/1}	{181,1,151,59,3,45,4,1,1}	{182,213,49,2,0,0,31}	0.015	CARGO PLUS MIAMI LLC	4	0.9	BIG BEN 1000 LLC	3	0.67	SUNWIND GROUP LLC	3	0.67	{638,897,1288,1966,0,0,810}	2024-07-18 16:37:43.705071+02	5	\N	{Other,"CARGO PLUS","BIG BEN 10","SUNWIND GR","1000 INVES"}	{417,4,3,3,2}	https://estategy-main.s3.amazonaws.com/condo_csv/1000 WEST AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/1000 WEST AVE.jpg	{2515500,5771800,9420500,22795800,29652800,14821500}	{3577,2353,2096,1710,1623.5,1328,1249.5,1197,1173,1172.36,1144.73,969,960.64,947.33,920.86,914.13,890.79,867.13,854.4,852,852,852,852,843.85,835.36,829.93,787,780.87,769.87,764.86,709,682,648.31,579.87,572.93,565.07,543,543,543}	{/6,S7,S4,S8,S1,S9,S3,11,S2,25,02,29,24,10,23,03,17,07,08,26,27,14,09,16,15,18,30,04,05,21,01,32,22,06,12,19,31,20,28}	{15,15,15,15,15,15,15,15,15,15,14,14,14,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,2,2,2,1,1,1,1,1}	{03,04,08,07,01,02,05,09,06,10,18,19,23,21,14,20,12,24,15,11,17,25,26,27,31,32,30,29,16,28,22,S1,S2,S3,S4,S7,S8,/6,S9}	\N	t
256	1300 MONAD TER	Monad Terrace	2021	t	14	56	25.78411	-80.14244	{2,3,4,5}	135897	56	{2/2/1,3/3/1,4/4/1,4/4/2,5/5/1}	{19,31,2,1,3}	{0,0,19,31,3,3,2}	0.015	1300 MONAD TERRACE 10E LLC	1	1.79	2555 MT LLC	1	1.79	MOMDAD HEIRS LLC	1	1.79	{0,0,1727,2353,3477,3841,4082}	2024-07-18 16:39:35.502001+02	5	\N	{Other}	{56}	https://estategy-main.s3.amazonaws.com/condo_csv/1300 MONAD TER.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/1300 MONAD TER.jpg	{0,0,6099000,186812500,52825000,11625000}	{4330,3845,3845,3835,2830,2374,2374,2374,2374,2357,2357,2357,2351,2269,2269,2000,2000,1910,1910,1324,1324}	{-A,1E,2E,-E,A,F,0F,1F,2F,0B,2B,1B,B,D,0D,E,0E,2C,1C,C,0C}	{8,8,7,7,7,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}	{B,F,D,C,E,A,0E,0B,2C,1E,-A,-E,2B,1C,2E,0F,1B,0C,0D,1F,2F}	\N	t
259	101 20 ST	Setai South Beach	2004	t	40	160	25.7959041595459	-80.13002014160156	{1,2,3,4}	239951	160	{1/1/0,1/1/1,2/2/0,2/2/1,3/3/0,4/4/1}	{1,32,112,1,13,1}	{0,33,113,13,1,0,5}	0.015	JOLIA LLC	3	1.88	DTD 3509 LLC	3	1.88	NAKASH PROPERTIES LLC	3	1.88	{0,823,1422,2707,5324,0,2303}	2024-07-18 16:45:11.342035+02	5	\N	{Other,"JOLIA LLC","DTD 3509 L","NAKASH PRO","GRAUS INTE"}	{147,3,3,3,3}	https://estategy-main.s3.amazonaws.com/condo_csv/101 20 ST.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/101 20 ST.jpg	{46630000,8425000,39960000,56473000,37139500,11975000}	{3543,3498,2521,2151,1696.09,1691.69,1576.5,1565,1361.8,1316,1303.06,1145.67,962.48,821}	{" A"," B",09," C",01,07," D"," E",08,06,02,04,03,05}	{22,21,19,18,16,16,16,15,4,3,3,3,2,1}	{01,03,06,04,02,05,07,08,09," A"," C"," B"," D"," E"}	\N	t
339	1560 LENOX AVE	Industry Lofts	2004	t	3	17	40.8096347	-73.9442166	{0}	21457	18	{0/1/0}	{17}	{17,0,0,0,0,0,0}	0.015	ZUDY OFFICE LLC	2	11.76	1560 LENOX AVE LLC	1	5.88	1560 LENOX LLC	1	5.88	{1262,0,0,0,0,0,0}	2024-07-18 15:32:31.540025+02	8	\N	{Other,"ZUDY OFFIC"}	{16,2}	https://estategy-main.s3.amazonaws.com/condo_csv/1560 LENOX AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/1560 LENOX AVE.jpg	{0,500000,900000,475000,0,2075000}	{1931.33,1597,1097,1025,996,959,906}	{03,01,06,07,04,05,02}	{3,3,3,2,2,2,2}	{02,03,01,05,04,06,07}	\N	t
247	540 WEST AVE	Bentley Bay North	2004	t	24	87	25.7752309	-80.1419425	{1,2}	83259	87	{1/1/0,2/2/0}	{45,42}	{0,45,42,0,0,0,0}	0.015	BENEDIKT LEX TRS	2	2.3	0901 MATAMANOA LLC	1	1.15	REBECCA BELL	1	1.15	{0,777,1148,0,0,0,0}	2024-07-18 16:24:09.783315+02	5	\N	{Other,"BENEDIKT L"}	{86,2}	https://estategy-main.s3.amazonaws.com/condo_csv/540 WEST AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/540 WEST AVE.jpg	{2142000,4633000,2903500,10492000,8000000,2335000}	{1205.91,1058.1,789.68,778.91}	{11,14,13,12}	{22,22,22,21}	{12,13,11,14}	\N	t
261	650 WEST AVE	The Floridian	1997	t	34	333	25.7770107	-80.1425531	{1,2,3}	380299	333	{1/1/0,2/2/0,2/2/1,3/2/0}	{73,195,16,49}	{0,73,211,49,0,0,16}	0.015	GGC ASSOC LC	3	0.9	FLORIDIAN INVEST LLC	2	0.6	WILLIAM COX	2	0.6	{0,736,1148,1202,0,0,1578}	2024-07-18 16:49:14.425894+02	5	\N	{Other,"GGC ASSOC ","FLORIDIAN ","WILLIAM CO","DADES HOLD"}	{320,3,2,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/650 WEST AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/650 WEST AVE.jpg	{12165000,14773500,8594700,21229800,37958000,20719800}	{2147,2102,2095,2076,1186.96,1159.36,1158.04,1156.04,1134.25,1101.72,1088.92,1087.92,1039.24,1033.48,775.69,770.48}	{16,14,15,17,07,12,01,11,08,02,09,10,04,03,05,06}	{29,29,29,29,29,28,28,28,25,25,25,25,1,1,1,1}	{04,05,03,06,02,08,07,01,10,12,09,11,16,15,17,14}	\N	t
262	1330 WEST AVE	The Waverly at South Beach	2001	t	36	395	25.7847323	-80.14244769999999	{1,2,3,4}	436867	396	{1/1/0,1/1/1,2/2/0,3/3/0,4/4/0}	{116,1,275,1,2}	{0,117,275,1,2,0,0}	0.015	MICHAEL VESOLE	3	0.76	CAVANAUGH CHARTERS INC	3	0.76	MARILIN HERNANDEZ	2	0.51	{0,811,1213,2582,2736,0,0}	2024-07-18 16:51:34.910734+02	5	\N	{Other,"MICHAEL VE","CAVANAUGH ","MARILIN HE","EMIR BOYDA"}	{377,3,3,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/1330 WEST AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/1330 WEST AVE.jpg	{13253000,14985700,6936000,33040100,33556100,19319000}	{1384,1338.17,1310.54,1304.58,1262,1256.29,1127,1127,1085.35,1084,818.42,813.68,806,793}	{08,07,13,01,14,02,06,09,04,11,05,03,12,10}	{31,31,31,31,31,30,30,26,26,26,26,26,25,25}	{02,04,05,03,01,06,07,12,11,10,13,09,14,08}	\N	t
338	1428 WEST AVE	Alliage Lofts	2004	t	5	12	25.78635	-80.1425	{2}	14464	12	{2/2/0}	{12}	{0,0,12,0,0,0,0}	0.015	CHARLES F LESKO	1	8.33	DANO CONSULTING INC	1	8.33	HARRY BODAN	1	8.33	{0,0,1205,0,0,0,0}	2024-07-18 15:30:59.699715+02	8	\N	{Other}	{12}	https://estategy-main.s3.amazonaws.com/condo_csv/1428 WEST AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/1428 WEST AVE.jpg	{730000,0,552000,2994000,800000,0}	{1256,1256,1194,1194,1166,1166}	{01,06,02,05,03,04}	{2,2,2,2,2,2}	{03,02,04,01,05,06}	\N	t
251	1500 BAY RD	Flamingo South Beach	1960	t	15	560	25.7864019	-80.14435519999999	{0,1,2,3,4}	483980	560	{0/1/0,1/1/0,1/1/1,2/1/1,2/2/0,3/2/1,4/4/0}	{79,267,15,13,172,13,1}	{79,282,185,13,1,0,0}	0.015	FLAMINGO SOUTH ACQUISITIONS LLC	249	44.46	MB CONDO INVESTMENTS LLC	3	0.54	AYSE OLGUN	3	0.54	{493,764,1086,2026,2175,0,0}	2024-07-18 16:29:49.788076+02	5	\N	{Other,"FLAMINGO S","MB CONDO I","AYSE OLGUN","BAYVIEW 15"}	{283,249,3,3,3}	https://estategy-main.s3.amazonaws.com/condo_csv/1500 BAY RD.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/1500 BAY RD.jpg	{10723000,9265900,4243000,15975700,25524900,13245000}	{951.42,925.58,832.18,821.44,793.15}	{8S,4S,0S,6S,2S}	{120,118,109,107,106}	{2S,4S,0S,8S,6S}	\N	t
349	1200 WEST AVE	Mirador 1200 (North Tower)	1965	t	17	408	25.782981	-80.14290199999999	{0,1,2,3,4}	363982	421	{0/1/0,1/1/0,1/1/1,2/2/0,3/3/0,4/4/1}	{95,239,41,28,4,1}	{95,280,28,4,1,0,30}	0.015	FLORIDA BAYVIEW LLC	3	0.74	JV PRA MIAMI LLC	2	0.49	RONALD DANIEL	2	0.49	{587,857,1164,1895,3604,0,813}	2024-07-18 16:55:55.437173+02	5	\N	{Other,"FLORIDA BA","JV PRA MIA","RONALD DAN","FACUNDO GU"}	{397,3,2,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/1200 WEST AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/1200 WEST AVE.jpg	{5713500,5576000,7870300,21539100,16782100,10235500}	{2080,1908,1908,1273,1226,1071,999.5,990,985.64,970,906.21,901.38,837,837,837,837,837,837,837,837,837,837,837,837,837,816.64,702.43,691.21,634.79,585.36,572.36,552,552,552}	{S1,S4,S5,S3,26,25,06,15,07,31,05,21,22,23,18,10,08,29,30,03,09,16,17,20,19,04,12,14,01,11,02,24,27,28}	{14,14,14,14,14,14,14,14,14,14,14,14,14,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,12,2,2,1,1}	{04,05,10,11,12,01,02,06,08,03,07,09,14,15,23,24,25,26,27,18,29,30,31,21,16,17,20,19,28,22,S1,S3,S4,S5}	\N	t
268	120 OCEAN DR	Glass Miami Beach	2015	t	10	9	25.7700669	-80.1332729	{2,3}	27599	9	{2/2/1,3/3/1}	{2,7}	{0,0,2,7,0,0,0}	0.015	120 OCEAN DRIVE 1400 LLC	1	11.11	BRAGI HENNINGSSON TRS	1	11.11	GLENN J KREVLIN	1	11.11	{0,0,1938,3389,0,0,0}	2024-07-18 17:09:26.969734+02	4	\N	{Other}	{9}	https://estategy-main.s3.amazonaws.com/condo_csv/120 OCEAN DR.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/120 OCEAN DR.jpg	{0,7500000,6750000,14650000,0,0}	{3066.56}	{00}	{9}	{00}	\N	t
269	101 OCEAN DR	Hilton Bentley Miami Beach	2003	t	10	109	25.7696802	-80.13230329999999	{0,1,2}	58851	109	{0/1/0,1/1/0,2/2/0}	{55,47,7}	{55,47,7,0,0,0,0}	0.015	JJN REAL ESTATE LLC	13	11.93	JJN REAL ESTATE 2 LLC	7	6.42	BENTLEY BEACH 713 LLC	6	5.5	{376,635,1180,0,0,0,0}	2024-07-18 17:11:05.836781+02	4	\N	{Other,"JJN REAL E","JJN REAL E","BENTLEY BE","BENTLEY BE"}	{69,13,7,6,5}	https://estategy-main.s3.amazonaws.com/condo_csv/101 OCEAN DR.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/101 OCEAN DR.jpg	{905000,0,0,2300000,1715000,4614000}	{1064.17,903.29,710,685.43,639.71,634,617.71,532.57,515,434.43,416,415,400,383.5,365,301}	{07,01,11,17,16,05,06,02,12,03,14,04,13,5B,18,5A}	{12,12,7,7,7,7,7,7,6,6,6,6,6,6,6,1}	{5B,5A,06,01,16,02,17,03,18,07,11,04,13,12,14,05}	\N	t
272	1000 S POINTE DR	Murano at Portofino	2001	t	37	189	25.7685268	-80.1375906	{1,2,3}	415318	189	{1/1/1,2/2/0,2/2/1,3/3/0,3/3/1,3/4/1}	{23,24,42,25,34,41}	{0,23,66,100,0,0,0}	0.015	MARK W DAVIS TRS	2	1.06	NURIA S ROBLES	2	1.06	ALAN M TRAGER	2	1.06	{0,1094,1703,2777,0,0,0}	2024-07-18 17:16:41.056126+02	4	\N	{Other,"MARK W DAV","NURIA S RO","ALAN M TRA","JANET E GO"}	{183,2,2,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/1000 S POINTE DR.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/1000 S POINTE DR.jpg	{30455000,27618000,27445000,68475000,30975000,36500000}	{3301.46,2786,2786,2786,2786,2618,2216.4,2008,1791,1407,1390,1207,1207,1207,1207,1207,1207,1207,1207,1207,1207,1008}	{01,M1,M3,M4,M2,02,04,03,08,05,07,A1,A3,10,A7,A2,A6,A8,A9,A4,A5,06}	{37,34,25,24,14,14,14,13,1,1,1,1,1,1,1,1,1,1,1,1,1,1}	{01,02,04,03,05,07,08,06,A1,A3,10,M1,A7,A2,A6,M3,M4,A8,A9,A4,M2,A5}	\N	t
252	10 VENETIAN WAY	Grand Venetian	2001	t	25	122	25.7911251	-80.1466308	{1,2,3,4}	176687	122	{1/1/1,1/2/0,2/2/0,3/3/0,3/3/1,3/4/0,3/4/1,4/4/0}	{35,32,44,6,1,2,1,1}	{0,67,44,10,1,0,0}	0.015	THOMAS J BERKOVIC	3	2.46	ANTHONY R HOGAN TRS	2	1.64	SANDRA MONTEVERDE	2	1.64	{0,1142,1474,2882,6422,0,0}	2024-07-18 16:31:49.252098+02	5	\N	{Other,"THOMAS J B","ANTHONY R ","SANDRA MON","HOWARD GUT"}	{114,3,2,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/10 VENETIAN WAY.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/10 VENETIAN WAY.jpg	{12037800,9240300,13617500,24522800,10918000,19245800}	{1807.22,1754.91,1704.68,1463,850,850}	{04,02,01,03,05,06}	{23,22,22,20,19,16}	{04,02,01,03,06,05}	\N	t
350	1800 SUNSET HARBOUR DR	Sunset Harbour South	1998	t	26	208	25.7944878	-80.14480089999999	{1,2,3,4}	305890	770	{1/1/1,1/2/0,2/2/0,2/2/1,3/2/0,3/2/1,3/3/0,3/3/1,4/4/0}	{34,1,82,32,1,17,20,2,19}	{0,35,114,40,19,0,6}	0.015	SANFELIU BRICKELL LLC	2	0.96	JAMES ESSHAKI	2	0.96	1800 MB LLC	1	0.48	{0,814,1160,1943,2711,0,2643}	2024-07-18 16:58:12.386308+02	5	\N	{Other,"SANFELIU B","JAMES ESSH"}	{206,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/1800 SUNSET HARBOUR DR.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/1800 SUNSET HARBOUR DR.jpg	{823500,5140000,2070000,4766000,3041000,3962600}	{4650,4635,2660,2660,2650,2650,2246,2246,1855.29,1770,1271.25,1220,1187.12,1140,1140,1130,1128.87,1120,1110,820,800}	{-1,-2,-6,-5,-4,-3,/4,04,12,07,06,08,03,15,14,11,01,10,02,05,09}	{17,17,17,17,17,17,17,16,16,16,15,14,2,2,2,1,1,1,1,1,1}	{03,05,07,11,12,15,09,08,10,06,01,/4,-1,-2,04,-4,14,-3,-6,-5,02}	\N	t
351	1030 15TH ST	Ten30 South Beach	2022	t	3	32	25.78702	-80.139297	{1,2,3}	41341	33	{1/1/1,2/1/0,2/2/0,2/2/1,3/3/1}	{14,2,11,2,3}	{0,14,15,3,0,0,4}	0.015	1030 BEAM LLC	1	3.12	ALEXANDER CHRISTIAN WINTER	1	3.12	TWIN CITIES PROPERTIES GROUP LLC	1	3.12	{0,737,1190,2024,0,0,1774}	2024-07-18 16:59:58.697501+02	5	\N	{Other}	{32}	https://estategy-main.s3.amazonaws.com/condo_csv/1030 15TH ST.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/1030 15TH ST.jpg	{0,0,0,0,31560800,0}	{2216,1928,1928,1476,1476,1476,1476,1190,1101,1101,1081.5,975,886,751,751,751,751,738,738,714,714}	{H1,20,H4,04,14,H2,H3,08,21,09,00,01,13,03,17,15,05,06,16,19,07}	{2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1}	{01,17,19,21,08,15,13,06,16,09,00,03,04,20,07,05,14,H1,H2,H3,H4}	\N	t
246	435 21 ST	ArteCity	2008	t	6	61	25.797101974487305	-80.13096618652344	{1,2}	38373	61	{1/1/0,1/1/1,2/2/0}	{56,2,3}	{0,58,3,0,0,0,0}	0.015	GABRIEL BEDOYA	2	3.28	SOBE DEALS INC	2	3.28	ALBBAS LLC	1	1.64	{0,612,940,0,0,0,0}	2024-07-18 16:22:29.304292+02	5	\N	{Other,"GABRIEL BE","SOBE DEALS"}	{59,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/435 21 ST.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/435 21 ST.jpg	{942400,529500,754000,1545000,3197800,1401800}	{869.67,804,727.67,635.67,628,624,624,624,613,610.33,610.33,603,596,596,587.67,587.67,587.67,587.67,587.67,579,556,556,556}	{01,14,12,02,24,16,07,08,22,15,11,03,18,19,04,06,05,09,10,23,17,20,21}	{3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,2,2,2}	{03,04,14,16,12,01,06,05,07,09,10,15,02,11,08,22,24,17,18,19,20,23,21}	\N	t
265	800 S POINTE DR	Apogee South Beach	2008	t	22	67	25.7680133	-80.1363104	{3,4}	225994	67	{3/3/1,4/3/1,4/4/1,4/5/1}	{32,32,2,1}	{0,0,0,32,35,0,0}	0.015	JOEL J HOROWITZ	2	2.99	100H INVESTMENTS LLC	1	1.49	MARIE CHRISTINE NELSON TRS	1	1.49	{0,0,0,2756,3937,0,0}	2024-07-18 17:03:32.570521+02	4	\N	{Other,"JOEL J HOR"}	{66,2}	https://estategy-main.s3.amazonaws.com/condo_csv/800 S POINTE DR.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/800 S POINTE DR.jpg	{47300000,18550000,0,167466000,78150000,53225000}	{3934.47,3858.29,2907.12,2756}	{04,01,02,03}	{17,17,17,16}	{02,04,01,03}	\N	t
267	100 S POINTE DR	Continuum South Beach South Tower	2002	t	42	294	25.7673201	-80.1327592	{1,2,3,4,5,6,7}	659780	294	{1/1/1,1/2/0,2/2/0,2/2/1,2/3/0,2/3/1,2/4/1,3/2/1,3/3/1,3/3/2,3/4/0,3/4/1,3/5/1,4/5/1,4/7/1,5/5/1,5/6/1,5/6/3,5/7/1,6/6/0,7/10/1}	{25,2,1,168,24,1,6,1,33,2,6,9,1,3,1,6,1,1,1,1,1}	{0,27,200,52,4,9,3}	0.015	TRAVEL CHARTER BUSINESS LTD	3	1.02	ESSEMATICA HOLDING LLC	3	1.02	ZACK HOLDINGS LLC	2	0.68	{0,1301,1899,2863,6697,5145,7595}	2024-07-18 17:07:45.474961+02	4	\N	{Other,"TRAVEL CHA",ESSEMATICA,"ZACK HOLDI","ALEKSANDR "}	{271,3,3,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/100 S POINTE DR.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/100 S POINTE DR.jpg	{56737500,105367500,37130000,231878200,104168400,78780300}	{10750,4946,4848.5,2900,2666.03,2583.04,2578.13,2365,2365,2365,2365,2365,2248.94,2224.39,2202,2202,2202,2202,2167.76,2072,1778.3,1769.5,1714.21,1584.97}	{-2,-1,-3,-4,03,04,06,-5,-9,-6,-7,-8,05,07,12,11,13,14,10,15,09,08,01,02}	{34,32,31,31,30,29,27,24,23,17,2,2,1,1,1,1,1,1,1,1,1,1,1,1}	{01,05,07,03,06,02,04,08,09,10,-1,-3,-4,12,-5,-2,15,-9,11,-6,-7,13,14,-8}	\N	t
270	450 ALTON RD	Icon South Beach	2005	t	40	274	25.773308	-80.1404051	{1,2,3,4,5,6,8}	489646	274	{1/1/1,2/2/0,2/2/1,3/3/0,3/3/1,4/4/0,4/4/1,5/5/0,6/7/1,8/9/1}	{30,87,88,28,33,1,3,2,1,1}	{0,30,175,61,4,2,2}	0.015	GANG WARILY HOLDINGS LLC	2	0.73	DSG ICON LLC	2	0.73	ROBERT LAPLANTE TRS	2	0.73	{0,862,1660,2208,3535,3694,8457}	2024-07-18 17:13:02.398037+02	4	\N	{Other,"GANG WARIL","DSG ICON L","ROBERT LAP","SALAH IZZE"}	{264,2,2,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/450 ALTON RD.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/450 ALTON RD.jpg	{26414200,9145000,26470000,61245300,52634000,41442500}	{9039,7875,2287.78,2268.97,1933,1909.48,1750,1660.66,1443.31,1370,851}	{H1,H2,03,01,02,07,05,04,06,10,08}	{33,32,32,32,29,29,29,29,27,1,1}	{01,02,03,04,07,05,06,08,10,H1,H2}	\N	t
275	1 COLLINS AVE	One Ocean	2016	t	7	49	25.7688098	-80.1338069	{1,2,3,4,5}	130014	49	{1/1/0,1/2/0,2/2/1,3/3/1,4/4/1,5/5/1}	{1,1,4,21,1,21}	{0,2,4,21,1,21,0}	0.015	MARTIN E FRANKLIN TRS	2	4.08	606 ONE OCEAN DRIVE LLC	1	2.04	7782 GROUP LLC	1	2.04	{0,963,1602,2320,5586,3207,0}	2024-07-18 17:21:57.734094+02	4	\N	{Other,"MARTIN E F"}	{48,2}	https://estategy-main.s3.amazonaws.com/condo_csv/1 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/1 COLLINS AVE.jpg	{15460000,3537500,6875000,52790000,57829000,0}	{3346.8,3127.57,3050.86,2671.5,2574.67,2547,2026,1922.33,1608}	{01,07,06,08,03,04,02,05,09}	{7,7,6,6,6,6,5,5,1}	{06,07,04,05,08,03,01,02,09}	\N	t
248	520 WEST AVE	Bentley Bay South	2004	t	25	80	25.7753821	-80.142156	{1,2,3,4}	116544	80	{1/1/0,1/2/0,2/2/0,2/2/1,2/3/0,3/3/0,3/3/1,4/4/0}	{19,9,24,1,8,2,16,1}	{0,28,33,18,1,0,0}	0.015	CHARLES T WEISS TRS	4	5	ALBERT GARNER JR	2	2.5	520 WEST AVE 905 LLC	1	1.25	{0,911,1466,2106,4711,0,0}	2024-07-18 16:25:51.868634+02	5	\N	{Other,"CHARLES T ","ALBERT GAR"}	{76,4,2}	https://estategy-main.s3.amazonaws.com/condo_csv/520 WEST AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/520 WEST AVE.jpg	{2885000,1645000,5299000,19757600,19566000,8725000}	{2087.56,1793.56,1210,1047.68,1005.76}	{01,02,05,03,04}	{19,18,18,17,8}	{03,02,01,04,05}	\N	t
826	61 COLLINS AVE	61 Collins	1970	t	\N	17	25.7694542	-80.13379979999999	{1,2}	11812	\N	{1/1/0,2/1/0}	{15,1}	{0,15,1,0,0,0,0}	0.015	ST ANDREWS PROPERTIES LLC	2	11.76	61 PENTHOUSE LLC	1	5.88	ALVARO E NARANJO	1	5.88	{0,739,719,0,0,0,0}	2024-07-28 21:28:18.240243+02	4	\N	{Other,"ST ANDREWS"}	{16,2}	\N	\N	\N	\N	{601000,302000,0,689000,360000,804000}	{781,781,719,672}	{02,03,04,01}	{4,4,4,4}	{01,02,03,04}	\N	f
276	300 S POINTE DR	Portofino Tower	1996	t	44	215	25.7677055	-80.1348768	{1,2,3,4,5,9}	506654	215	{1/1/1,2/2/0,2/2/1,3/2/1,3/3/1,3/4/1,4/4/1,4/6/1,5/4/1,5/5/1,5/6/1,9/9/2}	{20,7,79,71,22,3,4,3,1,3,1,1}	{0,20,86,96,7,5,3}	0.015	MARILA LOMBROZO TRS	2	0.93	ANDREA MAGGIONI	2	0.93	ANIL SHARMA	2	0.93	{0,1158,1998,2485,4875,4374,5680}	2024-07-18 17:23:49.208701+02	4	\N	{Other,"MARILA LOM","ANDREA MAG","ANIL SHARM","MONIKA CHA"}	{209,2,2,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/300 S POINTE DR.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/300 S POINTE DR.jpg	{13607100,24594000,4940000,61050000,41065000,37240400}	{5680,5680,5680,2763.71,2716.76,2532.86,1982.86,1961.74,1908.79,1160,1090,1090}	{-5,-1,-3,01,05,03,04,02,06,07,08,09}	{35,35,35,34,33,31,3,3,3,1,1,1}	{03,04,01,05,06,02,07,08,09,-5,-1,-3}	\N	t
352	311 MERIDIAN AVE	Louver House	2016	t	4	11	25.7725042	-80.1359264	{3,6}	27229	11	{3/3/1,6/6/1}	{9,2}	{0,0,0,9,0,0,4}	0.015	CLAUDIA CISNEROS	2	18.18	PATRICK J DWYER	2	18.18	GINO BERTUCCIO	1	9.09	{0,0,0,2099,0,0,2083}	2024-07-18 17:33:20.343712+02	4	\N	{Other,"CLAUDIA CI","PATRICK J "}	{9,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/311 MERIDIAN AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/311 MERIDIAN AVE.jpg	{7775000,5700000,9250000,2600000,0,0}	{4137,3150,2224,2224,2163,1974,1974,1974}	{03,04,01,HI,H4,02,H2,H3}	{2,2,2,1,1,1,1,1}	{02,04,01,HI,H2,03,H3,H4}	\N	t
226	6801 COLLINS AVE	The Carillon Center Tower	2008	t	16	229	25.8528544	-80.1199584	{1,2,3}	224524	229	{1/1/0,1/1/1,2/2/0,2/2/1,3/3/0}	{174,6,45,3,1}	{0,180,48,1,0,0,31}	0.015	Z CAPITAL FLORIDA RESORT LLC	42	18.34	FLORIDA CONDO HOLDING CO LLC	15	6.55	CARILLON HOTEL LLC	15	6.55	{0,769,1114,2096,0,0,979}	2024-07-18 15:23:41.766566+02	8	\N	{Other,"Z CAPITAL ","FLORIDA CO","CARILLON H","TATIANA VA"}	{151,42,15,15,2}	https://estategy-main.s3.amazonaws.com/condo_csv/6801 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/6801 COLLINS AVE.jpg	{5994300,2774500,3147000,21109500,20010000,5329000}	{1228.07,1057.3,924.86,919.15,890.21,887,876.67,862.62,850.93,846,821.9,819.5,819.5,816.89,797.69,662,662,662,662}	{05,12,01,15,07,18,04,16,08,19,14,10,06,13,11,09,03,17,02}	{15,14,14,14,14,14,14,14,14,14,13,13,13,10,10,9,8,6,6}	{04,10,05,06,09,03,07,01,08,02,16,15,11,12,14,13,19,18,17}	\N	t
210	3651 COLLINS AVE	Beach House 8	2015	t	10	7	25.8101605	-80.1229249	{4,5,7}	26329	7	{4/4/0,5/5/0,7/7/2}	{5,1,1}	{0,0,0,0,5,1,1}	0.015	AVALON ASSETS LLC	1	14.29	BEACH HOUSE 500 LLC	1	14.29	DJS REAL PROPERTY LLC	1	14.29	{0,0,0,0,3409,4642,4642}	2024-07-18 13:35:37.493432+02	8	\N	{Other}	{7}	https://estategy-main.s3.amazonaws.com/condo_csv/3651 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/3651 COLLINS AVE.jpg	{7200000,0,0,6000000,0,0}	{4642,3953.83}	{H,00}	{6,1}	{00,H}	\N	t
266	50 S POINTE DR	Continuum South Beach North Tower	2008	t	37	202	25.767875	-80.132756	{0,1,2,3,4,5,6}	382603	202	{0/1/0,1/1/0,1/1/1,1/2/0,2/2/1,2/3/0,2/3/1,3/3/1,3/4/1,4/3/1,4/4/0,4/4/1,4/4/2,4/5/1,5/4/0,5/5/1,6/6/1}	{8,15,12,2,92,10,8,26,14,1,1,6,1,1,1,2,2}	{8,29,110,40,10,3,2}	0.015	801 CONTINUUM LLC	4	1.98	DAGAN KASAVANA	2	0.99	IURII TRUDOVOI	2	0.99	{686,957,1671,2642,3101,5312,6417}	2024-07-18 17:05:34.68166+02	4	\N	{Other,"801 CONTIN","DAGAN KASA","IURII TRUD","SANDRA L J"}	{181,4,2,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/50 S POINTE DR.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/50 S POINTE DR.jpg	{54488000,33520500,10498000,112310000,77480000,55240000}	{6702,6133,3101,2779,2775,2775,2766,2566.24,2478,2470,2470,2447,2429.93,1689.8,1616.5,1584,1584,1582.19,1555,1546,1524.38,1517.87,1357.87,825.5,759,718.5,699,695,654,652,609}	{-2,-1,T6,N7,N5,N6,N4,01,N1,N3,N2,T1,02,03,05,T3,T4,04,T2,T5,08,06,07,10,11,12,15,09,13,14,16}	{30,29,26,25,20,15,15,13,2,2,2,2,2,2,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}	{02,01,04,03,05,06,07,08,14,10,11,09,12,13,N5,-1,T3,N1,T2,15,16,N3,N4,N6,N7,-2,T4,N2,T1,T5,T6}	\N	t
216	4401 COLLINS AVE	Fontainebleau II	2005	t	36	460	25.8170079	-80.12229529999999	{0,1,4}	368740	460	{0/1/0,1/2/0,4/5/1}	{228,230,2}	{228,230,0,0,2,0,2}	0.015	936 SOURCE REALTY LLC	11	2.39	FOUNTAIN II LLC	8	1.74	LORNGLEN PROPERTIES INC	7	1.52	{514,1014,0,0,4500,0,4500}	2024-07-18 15:07:43.05722+02	8	\N	{Other,"936 SOURCE","FOUNTAIN I","LORNGLEN P","JONAS FAMI"}	{343,11,8,7,6}	https://estategy-main.s3.amazonaws.com/condo_csv/4401 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/4401 COLLINS AVE.jpg	{18981500,12617000,6364000,12363000,11613000,33729000}	{4500,4500,1066,1066,1020.14,1002,1002,1002,980,980,526,526,526,526,516,516,491,491}	{NO,SO,15,14,11,05,06,12,04,03,07,08,10,09,02,01,16,17}	{29,29,29,29,29,29,29,29,29,29,29,28,28,28,28,27,1,1}	{04,03,05,07,11,15,16,02,17,14,01,06,10,12,09,08,NO,SO}	\N	t
245	1500 OCEAN DR	1500 Ocean Drive	1998	t	16	113	25.787952	-80.12908700000001	{0,1,2,3,6}	204271	113	{0/1/0,1/2/0,2/2/0,2/2/1,3/3/0,3/3/1,3/5/0,6/6/0,6/7/0}	{2,22,43,2,39,1,2,1,1}	{2,22,45,42,0,0,19}	0.015	25 OCEAN LLC	3	2.65	JEFFREY B KINDLER TRS	2	1.77	ALBERT R LEPAGE	2	1.77	{510,940,1367,2148,0,0,1620}	2024-07-18 16:20:45.777721+02	5	\N	{Other,"25 OCEAN L","JEFFREY B ","ALBERT R L"}	{109,3,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/1500 OCEAN DR.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/1500 OCEAN DR.jpg	{4044000,14075000,7257500,19714500,16564000,3080000}	{4630,4586,3699,3650,2552,2320,1789,1789,1740,1620,1530,1530,1530,1425,1170,1170,1170,1170,940,940,940}	{-2,2,8,7,01,02,-4,-3,03,04,05,-5,-6,06,-8,08,07,-7,10,09,-9}	{11,10,10,10,10,10,10,10,10,9,2,2,1,1,1,1,1,1,1,1,1}	{10,05,03,08,04,06,01,07,09,02,-4,-3,-8,-5,2,7,8,-2,-7,-9,-6}	\N	t
280	90 ALTON RD	Yacht Club at Portofino	1999	t	34	359	25.7699498	-80.1382789	{1,2,3,4,5}	398990	359	{1/1/0,1/1/1,2/2/0,2/2/1,3/2/0,3/2/1,3/3/0,4/3/0,5/5/1}	{115,4,217,2,7,8,4,1,1}	{0,119,219,19,1,1,19}	0.015	CHELSEA PROPERTY GROUP LLC	4	1.11	AR ALTON RD LLC	3	0.84	ARTHUR ALVAREZ &W SUSAN	2	0.56	{0,772,1111,1696,2230,3350,1355}	2024-07-18 17:31:29.602161+02	4	\N	{Other,"CHELSEA PR","AR ALTON R","ARTHUR ALV","11783068 C"}	{346,4,3,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/90 ALTON RD.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/90 ALTON RD.jpg	{16965500,15001000,8352200,29166000,34865000,17035500}	{2210,1750,1410,1410,1315,1315,1153.85,1147.33,1145,1145,1141.07,1136.9,1135.48,1130,1118.89,1111.61,1070,831.79,823.33,780,778.71}	{-4,-9,-6,-5,-8,-7,12,11,-1,-2,10,01,03,02,04,09,-3,08,06,05,07}	{31,31,31,30,30,29,28,28,27,27,26,25,2,2,2,2,2,2,2,1,1}	{09,07,03,11,05,01,10,08,06,04,12,02,-6,-8,-1,-4,-5,-7,-2,-9,-3}	\N	t
228	6799 COLLINS AVE	The Carillon South Tower	2008	t	21	141	25.8526255	-80.11975	{0,1,2,3,4}	190813	141	{0/2/0,1/1/0,2/2/0,2/2/1,3/2/1,3/3/0,3/3/1,4/3/0}	{1,66,44,15,10,3,1,1}	{1,66,59,14,1,0,14}	0.015	WILLIAM E RACOLIN TRS	3	2.13	ANNAEL JOSEPHINE FLEISCHER	2	1.42	ORION MIAMI LLC	2	1.42	{1084,897,1330,2102,2987,0,1398}	2024-07-18 15:27:41.34368+02	8	\N	{Other,"WILLIAM E ","ANNAEL JOS","ORION MIAM","AMFRAN EST"}	{136,3,2,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/6799 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/6799 COLLINS AVE.jpg	{8297500,9393500,5350000,20008000,11669000,11770000}	{1530,1529.68,1321.25,1289.5,1051,1035,988.8,988.35,871,871,871,837}	{05,02,04,06,10,12,03,01,07,08,09,11}	{20,20,20,20,19,15,5,5,5,4,4,4}	{06,01,05,04,02,03,07,08,09,10,12,11}	\N	t
213	3737 COLLINS AVENUE	Caribbean	2008	t	19	68	25.810647	-80.122714	{2,3,4}	146548	68	{2/2/1,3/3/1,4/4/1}	{48,16,4}	{0,0,48,16,4,0,4}	0.015	LEON KALVARIA	3	4.41	JAMES A STAR TRS	2	2.94	STEPHEN SADOVE	2	2.94	{0,0,1626,2326,3908,0,3908}	2024-07-18 15:02:37.151481+02	8	\N	{Other,"LEON KALVA","JAMES A ST","STEPHEN SA"}	{64,3,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/3737 COLLINS AVENUE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/3737 COLLINS AVENUE.jpg	{3700000,11425000,9100000,27535000,12285000,6175000}	{3911,3911,3906,3906,2326,1837,1621,1421}	{-1,-3,-2,-4,02,01,03,04}	{16,16,16,16,1,1,1,1}	{01,02,03,04,-1,-2,-3,-4}	\N	t
258	1201 20TH ST	Palau Sunset Harbour	2016	t	5	43	25.7959235	-80.1418546	{1,2,3}	86995	43	{1/1/0,1/1/1,2/2/1,3/2/1,3/3/1}	{3,9,14,3,14}	{0,12,14,17,0,0,8}	0.015	OSSEN CORP	2	4.65	POLUSA INC	2	4.65	1201 PALAU LLC	1	2.33	{0,967,1397,2143,0,0,2423}	2024-07-18 16:43:19.547043+02	5	\N	{Other,"OSSEN CORP","POLUSA INC"}	{41,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/1201 20TH ST.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/1201 20TH ST.jpg	{4310700,7025000,3460000,4370000,16625000,4355000}	{2222,2206.5,2008.25,1730.5,1658,1543.25,1481,1397.75,1334,1203,1085,780,701}	{05,04,01,02,03,06,10,07,14,09,08,12,13}	{4,4,4,4,4,4,4,4,3,2,2,2,2}	{08,03,04,07,01,02,05,06,09,10,12,13,14}	\N	t
271	801 S POINTE DR	Marea	2015	t	7	30	25.7684937	-80.136642	{1,2,3,4}	55273	30	{1/1/1,2/2/1,3/2/1,3/3/1,4/4/1}	{2,16,8,3,1}	{0,2,16,11,1,0,0}	0.015	514522 LLC	1	3.33	ALFRED J DECAROLIS TRS	1	3.33	STEVEN H TISHMAN	1	3.33	{0,872,1557,2351,2748,0,0}	2024-07-18 17:14:49.091694+02	4	\N	{Other}	{30}	https://estategy-main.s3.amazonaws.com/condo_csv/801 S POINTE DR.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/801 S POINTE DR.jpg	{9315000,1650000,1225000,36163000,20382800,7715000}	{2244.5,2030,1763,1728,1662.6,1662.4}	{06,01,02,05,04,03}	{6,6,5,5,4,4}	{01,02,03,04,06,05}	\N	t
249	1445-1470 16 ST	Capri South Beach	2008	t	15	59	25.788860321044922	-80.14299774169922	{1,2,3,5}	106779	59	{1/1/1,2/2/0,2/2/1,2/3/1,3/2/1,3/3/0,3/3/1,3/4/0,5/5/0}	{9,7,10,12,5,12,2,1,1}	{0,9,29,20,0,1,4}	0.015	LOUIS A COSTANZO	2	3.39	ISTVAN BESSENYEI	2	3.39	CALVIN DOUGLAS FOWLER	2	3.39	{0,783,1547,2143,0,2970,2257}	2024-07-18 16:27:31.377691+02	5	\N	{Other,"LOUIS A CO","ISTVAN BES","CALVIN DOU"}	{56,2,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/1445-1470 16 ST.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/1445-1470 16 ST.jpg	{6313600,5040000,3258000,10760000,28750000,7177500}	{2721,1919,1919,1916,1573.92,1396,1396,1243.67,1093.22}	{-1,03,-3,02,01,05,-5,-4,04}	{13,9,9,9,7,4,3,3,2}	{01,02,04,03,05,-1,-3,-4,-5}	\N	t
215	3315 COLLINS AVE	Faena House	2015	t	18	44	25.8078488	-80.1232302	{1,2,3,4,5}	172357	44	{1/2/0,2/2/1,2/2/2,3/4/0,4/5/1,4/6/1,5/5/1}	{9,10,1,1,10,12,1}	{0,9,11,1,22,1,5}	0.015	JOHN BURGESS	3	6.82	INW MIAMI PROPERTIES LLC	2	4.55	14C MIAMI INVESTMENT LLC	1	2.27	{0,1131,2541,3889,4383,5055,5770}	2024-07-18 15:05:51.542189+02	8	\N	{Other,"JOHN BURGE","INW MIAMI "}	{41,3,2}	https://estategy-main.s3.amazonaws.com/condo_csv/3315 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/3315 COLLINS AVE.jpg	{7900000,16425000,51650000,47650000,45600000,2025000}	{7443,7169,5978,5055,4381,4381,4381,4381,4381,4374,3889,3869,3869,3869,3869,2111,2030,2030,2030,2030,1185,1185,1185,1104}	{H,-D,-A,BD,2A,A,1A,0A,4A,-C,-B,4B,B,0B,2B,C,4C,0C,1C,2C,4D,0D,2D,D}	{6,6,6,6,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}	{C,A,D,B,4B,2A,4C,1A,H,0B,0A,0C,1C,2C,4D,-C,4A,BD,2B,0D,2D,-D,-A,-B}	\N	t
222	3801 COLLINS AVE	Mosaic	2006	t	20	85	25.8111488	-80.1226631	{2,3,4,6}	155382	85	{2/2/0,3/3/0,3/3/1,3/4/1,4/4/1,6/6/1}	{18,56,5,4,1,1}	{0,0,18,65,1,0,3}	0.015	SETH M GREENBERG	2	2.35	STEPHANE MANOS TRS	2	2.35	RICARDO DRI	1	1.18	{0,0,1246,1833,3200,0,3531}	2024-07-18 15:16:37.442698+02	8	\N	{Other,"SETH M GRE","STEPHANE M"}	{83,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/3801 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/3801 COLLINS AVE.jpg	{5850000,6570000,10460000,23150000,21220000,12651000}	{3424,3051.5,3004,2808,1824,1820,1730.71,1525,1507,1212}	{-2,-3,-1,-4,01,06,03,05,02,04}	{15,14,14,13,13,9,2,2,2,1}	{06,03,05,02,01,04,-2,-3,-1,-4}	\N	t
219	6901 COLLINS AVE	L'Atelier Miami Beach	2019	t	18	25	25.8543395	-80.1199543	{2,3,4,6}	58206	25	{2/2/1,3/3/1,4/4/1,6/6/1}	{2,20,2,1}	{0,0,2,20,2,0,1}	0.015	SMGW GOLDEN SANDS LLC	2	8	ASHLEY HANRAHAN	1	4	CHARLES S SHAMIEH	1	4	{0,0,1622,2133,2604,0,7094}	2024-07-18 15:11:21.994762+02	8	\N	{Other,"SMGW GOLDE"}	{24,2}	https://estategy-main.s3.amazonaws.com/condo_csv/6901 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/6901 COLLINS AVE.jpg	{0,103125000,3467300,36000000,18750000,3600000}	{2604,2584,2133,1622}	{04,01,02,03}	{11,10,2,2}	{01,02,03,04}	\N	t
212	4779 COLLINS AVE	Blue Diamond	2000	t	44	309	25.82322	-80.12153099999999	{1,2,3,5}	535270	309	{1/2/0,2/2/0,2/3/0,3/3/0,3/3/1,3/4/0,5/4/0,5/5/0}	{39,185,2,73,1,5,1,3}	{0,39,187,79,0,4,23}	0.015	MARK SILBER	8	2.59	PAINTER PALLET CAPITAL CORP	3	0.97	CARLOS FERREIRA DE MELO	3	0.97	{0,1106,1481,2075,0,3385,1634}	2024-07-18 13:39:03.093518+02	8	\N	{Other,"MARK SILBE","PAINTER PA","CARLOS FER","REUVEN MOS"}	{290,8,3,3,2}	https://estategy-main.s3.amazonaws.com/condo_csv/4779 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/4779 COLLINS AVE.jpg	{15484400,14568000,19696500,29503000,35620500,17908400}	{2196.67,2005.25,1588.06,1578.68,1551.79,1442.82,1402.82,1106.15}	{03,01,02,04,08,05,07,06}	{40,39,39,39,39,39,38,36}	{01,03,05,07,08,06,04,02}	\N	t
277	400 S POINTE DR	South Pointe Towers	1987	t	25	202	25.767292	-80.13417890000001	{1,2,3,4}	256154	202	{1/1/1,1/2/0,2/2/0,2/2/1,3/2/0,3/2/1,3/3/0,3/3/1,4/3/1,4/4/0}	{40,1,110,4,3,19,18,1,4,2}	{0,41,114,41,6,0,0}	0.015	GASTON LEVY	2	0.99	GATHED PROPERTIES LIMITED	2	0.99	FLORENCIO SANCHEZ LOPEZ	2	0.99	{0,870,1183,1704,2605,0,0}	2024-07-18 17:25:44.383298+02	4	\N	{Other,"GASTON LEV","GATHED PRO","FLORENCIO "}	{199,2,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/400 S POINTE DR.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/400 S POINTE DR.jpg	{9035000,11042500,8055000,31705000,20246167,15684000}	{1876.37,1559,1416.11,1277.29,1262.55,1178.53,1169,1168.55,1140.38,1058,959.11,924}	{04,10,03,01,09,02,-1,05,06,11,08,07}	{22,21,21,21,20,19,19,19,19,19,1,1}	{05,06,07,01,09,04,08,02,03,10,11,-1}	\N	t
229	2901 COLLINS AVE	The Residences at The Miami Beach EDITION	2014	t	18	26	25.805542	-80.1242772	{0,4}	4592	25	{0/0/0,4/4/1}	{25,1}	{0,0,0,0,1,0,0}	0.015	COLLINS CONDO UNIT 1202 LLC	2	7.69	POONAM KHUBANI TRS	2	7.69	ALISON MASS	1	3.85	{0,0,0,0,4592,0,0}	\N	8	\N	{Other,"COLLINS CO","POONAM KHU"}	{24,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/2901 COLLINS AVE.xlsx	\N	\N	https://estategy-main.s3.amazonaws.com/maps_img/2901 COLLINS AVE.jpg	{0,0,0,0,0,0}	{3475.5,3155.38,2609,2475.5,1776,1739.5,1139.33,1087,1030}	{02,01,04,07,06,05,03,08,09}	{8,3,2,2,2,2,2,2,1}	{01,03,02,04,06,07,05,08,09}	\N	t
217	4391 COLLINS AVE	Fontainebleau III	2008	t	18	287	25.816138	-80.1220524	{0}	0	287	{0/0/0}	{287}	{0,0,0,0,0,0,0}	0.015	JONAS FAMILY LTD PARTNERSHIP	7	2.44	936 SOURCE REALTY LLC	7	2.44	ORCHIDEA REAL ESTATE US CORP	6	2.09	{0,0,0,0,0,0,0}	\N	8	\N	{Other,"JONAS FAMI","936 SOURCE","ORCHIDEA R","AZURE 3061"}	{199,7,7,6,5}	https://estategy-main.s3.amazonaws.com/condo_csv/4391 COLLINS AVE.xlsx	\N	\N	https://estategy-main.s3.amazonaws.com/maps_img/4391 COLLINS AVE.jpg	{0,0,0,0,0,0}	{149846,1063,958,931.73,822.86,801.38,779.08,606.4,593.88,590.25,588,588,571.07,570.92,568,544,544,544,544,544,523.57,521.14,521.13}	{IT,23,07,12,14,09,19,16,10,01,21,22,17,18,20,05,02,04,03,06,15,13,11}	{16,16,16,16,16,16,16,16,15,15,15,15,15,14,14,14,13,13,5,3,3,3,1}	{05,09,01,07,04,03,06,10,02,16,12,11,17,14,15,13,18,19,20,21,22,23,IT}	\N	t
211	6515 COLLINS AVE	Bel Aire on the Ocean	2005	t	19	129	25.8483225	-80.1196867	{1,2}	120948	129	{1/1/1,2/2/0,2/2/1}	{78,50,1}	{0,78,51,0,0,0,0}	0.015	CLOVER PROPERTIES GROUP CORP	2	1.55	JOHN OHRNBERGER	2	1.55	THE CUT ABOVE LIMITED	2	1.55	{0,801,1145,0,0,0,0}	2024-07-18 13:37:14.485683+02	8	\N	{Other,"CLOVER PRO","JOHN OHRNB","THE CUT AB","BERNARDO L"}	{124,2,2,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/6515 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/6515 COLLINS AVE.jpg	{1172000,4319000,3690500,9450500,10590400,6610000}	{1230.31,1128,1126,1097,881,819,819,818,805,667}	{02,09,03,08,10,05,01,07,06,04}	{13,13,13,13,13,13,13,13,13,12}	{05,06,07,08,09,10,01,02,04,03}	\N	t
218	4775 COLLINS AVE	Green Diamond	2000	t	44	310	25.8224195	-80.12161619999999	{1,2,3,4}	535270	310	{1/1/0,1/2/0,2/2/0,2/3/0,3/3/0,3/3/1,3/4/0,3/5/0,4/5/0}	{1,38,188,2,74,1,4,1,1}	{0,39,190,80,1,0,24}	0.015	BARRY SKOLNICK	3	0.97	AKWABA LLC	3	0.97	TOVA SCHONKOPF TRS	2	0.65	{0,1106,1481,2118,3540,0,1566}	2024-07-18 15:09:39.072721+02	8	\N	{Other,"BARRY SKOL","AKWABA LLC","TOVA SCHON","BARRY OLIV"}	{293,3,3,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/4775 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/4775 COLLINS AVE.jpg	{18372500,15287000,17145000,37876000,31956800,7450000}	{2120,2005.9,1691.05,1577.95,1551.79,1403.08,1402.82,1106.15}	{01,03,02,08,04,07,05,06}	{39,39,39,39,39,39,38,38}	{06,08,05,07,03,04,01,02}	\N	t
274	125 OCEAN DR	Ocean House	2011	t	7	30	25.7700546	-80.1325729	{0,1,2,4}	88105	30	{0/1/0,1/1/0,1/1/1,2/2/1,4/4/1}	{2,1,8,1,18}	{2,9,1,0,18,0,0}	0.015	TOTTAL INVESTMENTS LLC	2	6.67	JFW REAL ESTATE HOLDINGS LLC	2	6.67	MANUEL GARCIADIAZ	2	6.67	{552,1451,1370,0,4031,0,0}	2024-07-18 17:20:20.201723+02	4	\N	{Other,"TOTTAL INV","JFW REAL E","MANUEL GAR"}	{27,2,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/125 OCEAN DR.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/125 OCEAN DR.jpg	{1650000,0,10250000,31759000,67000000,0}	{3522,2979.44,2965.56,1703.33,1314}	{02,01,03,04,05}	{9,9,8,3,1}	{03,01,02,04,05}	\N	t
221	4201 COLLINS AVE	La Tour Condo	1995	t	26	64	25.8138751	-80.1224014	{2,3,4}	98022	64	{2/2/0,3/3/0,4/4/0,4/4/1}	{43,18,2,1}	{0,0,43,18,3,0,0}	0.015	KIM MOGULL	2	3.12	MAURO E BRACA	2	3.12	PAUL BROWN	1	1.56	{0,0,1255,1980,2794,0,0}	2024-07-18 15:14:50.952535+02	8	\N	{Other,"KIM MOGULL","MAURO E BR"}	{62,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/4201 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/4201 COLLINS AVE.jpg	{950000,5475000,0,13298800,6428000,3065000}	{3230,1944.21,1375.09,1254.55}	{/3,03,02,01}	{22,22,19,1}	{01,02,03,/3}	\N	t
254	2001 MERIDIAN AVE	Meridian Lofts	2005	t	6	111	25.7964715	-80.1361417	{1,2}	164245	111	{1/1/0,1/1/1,2/1/1,2/2/1}	{17,54,1,39}	{0,71,40,0,0,0,19}	0.015	YVETTE SPENCER TRS	2	1.8	DENNIS SCHOLL	2	1.8	PETER D MERL TRS	2	1.8	{0,951,1722,0,0,0,1463}	2024-07-18 16:35:28.913694+02	5	\N	{Other,"YVETTE SPE","DENNIS SCH","PETER D ME","MIO DANILO"}	{107,2,2,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/2001 MERIDIAN AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/2001 MERIDIAN AVE.jpg	{6513800,3708800,1511500,9815500,10552500,7272500}	{2266.8,2090,1910.4,1465,1450,1424,1405.2,1349.4,1247.75,1176.75,1145,1139.25,1127.75,1056.75,1046,1010,970,966,966,966,966,966,966,966,964.5,962,864,815,802}	{01,14,07,23,11,05,03,09,04,16,22,18,02,20,08,29,25,19,21,24,26,06,17,28,12,27,10,30,15}	{5,5,5,5,5,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,3,3,3,3,3,3,3,3,3}	{01,03,07,09,05,12,23,14,19,21,16,18,25,15,02,20,11,04,17,29,24,10,26,06,08,22,30,27,28}	\N	t
279	300 COLLINS AVE	Three Hundred Collins	2018	t	5	15	25.7724895	-80.1335976	{1,2,3,4}	34394	15	{1/1/1,2/2/0,2/2/1,3/3/1,4/4/1}	{1,4,3,5,2}	{0,1,7,5,2,0,2}	0.015	300 COLLINS 3C INC	1	6.67	9052305 CANADA INC	1	6.67	ALAN AARON	1	6.67	{0,996,1414,2610,2300,0,2921}	2024-07-18 17:29:24.144672+02	4	\N	{Other}	{15}	https://estategy-main.s3.amazonaws.com/condo_csv/300 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/300 COLLINS AVE.jpg	{37625500,4500000,0,6365000,4725000,1222100}	{3143,2699,2374,1979.67,1702.33,1461,1266.5}	{H1,H2,A,B,C,E,D}	{3,3,3,2,2,1,1}	{B,E,C,D,A,H2,H1}	\N	t
214	8701 COLLINS AVE	Eighty Seven Park	2019	t	18	63	25.8720993	-80.1218779	{1,2,3,4,5}	126520	63	{1/1/1,2/2/1,3/3/1,4/3/1,5/5/1,5/5/4}	{9,25,22,3,3,1}	{0,9,25,22,3,4,0}	0.015	FRANCO BIANCHI	2	3.17	DANIEL GLASS	2	3.17	701 PROPERTY HOLDINGS LLC	1	1.59	{0,851,1574,2496,3121,3804,0}	2024-07-18 15:04:16.581996+02	8	\N	{Other,"FRANCO BIA","DANIEL GLA"}	{61,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/8701 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/8701 COLLINS AVE.jpg	{0,92844400,188700567,79295500,61937700,23600000}	{2828.08,2436.85,2122.31,1717.33,1457,851}	{02,01,05,06,04,03}	{13,13,12,9,9,7}	{01,05,02,03,06,04}	\N	t
380	5225 Collins Avenue	The Alexander	1962	t	17	227	25.82987	-80.121094	{1,2,5}	265860	\N	{1/1/0,1/2/0,2/2/0,2/2/1,2/4/0,5/4/2}	{12,4,205,4,1,1}	{0,16,210,0,0,1,8}	0.015	BEACH RESORT SUITES LLC	16	7.05	SOUTH BEACH RESORTS LLC	6	2.64	RS REALTY INVESTMENTS LLC	3	1.32	{0,887,1072,0,0,8280,2270}	2024-07-18 15:43:01.958293+02	8	33140	{Other,"BEACH RESO","SOUTH BEAC","RS REALTY ","RHAYZA INV"}	{186,16,6,3,3}	\N	\N	\N	https://estategy-main.s3.amazonaws.com/maps_img/5225 Collins Avenue.jpg	{3708000,4003500,1465000,7978000,15316700,11005500}	{8280,1520,1490,1490,1490,1490,1254.55,1253.33,1220,1200,1200,1180,1112.73,1091.67,1086.67,1071.67,1045.45,960,960,960,960,960,960,960,960,955.83,940.83}	{H8,H7,H6,H4,H5,H3,21,19,H1,18,20,H2,01,03,02,04,15,14,17,06,07,05,10,16,11,09,08}	{12,12,12,12,12,12,12,12,12,12,12,12,12,11,11,11,11,10,9,1,1,1,1,1,1,1,1}	{14,18,19,20,06,07,02,03,04,05,09,16,08,17,01,15,21,10,11,H1,H2,H6,H4,H5,H8,H3,H7}	\N	t
340	5875 COLLINS AVE	Mei	2008	t	22	132	25.8408912	-80.12022019999999	{1,2,3,4}	184403	132	{1/1/1,2/2/0,2/2/1,3/3/1,4/4/2}	{24,1,73,33,1}	{0,24,74,33,1,0,8}	0.015	CALIOPE HOLDINGS LLC	2	1.52	MEI HOLDINGS 1702 LLC	2	1.52	NICOLE ANNA MARIE BOKOR TRS	2	1.52	{0,828,1253,1733,3047,0,1440}	2024-07-18 15:34:19.547821+02	8	\N	{Other,"CALIOPE HO","MEI HOLDIN","NICOLE ANN","THUNDER MO"}	{128,2,2,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/5875 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/5875 COLLINS AVE.jpg	{7700000,7662400,12020000,44277500,30131000,10500000}	{1742,1742,1725,1684.94,1667,1556,1451.61,1323,1323,1322,1097,1097,1094,1094,961.31,897.69}	{08," 8",-2,02," 6"," 4",01,07,-7," 1",05," 5",03," 3",06,04}	{18,16,16,16,16,16,13,13,1,1,1,1,1,1,1,1}	{01,03,05,07,02,08,06,04," 3"," 8",-7," 1"," 6",-2," 4"," 5"}	\N	t
257	1100 WEST AVE	Mondrian South Beach	2007	t	15	329	25.784833908081055	-80.14227294921875	{0,1,2,3}	218576	329	{0/1/0,1/1/0,1/1/1,1/2/0,2/2/0,2/2/1,3/2/1}	{136,138,24,1,27,2,1}	{136,163,29,1,0,0,0}	0.015	1100 WEST UNITS LLC	147	44.68	1100 WEST INVESTMENTS LLC	58	17.63	DPCBAM LLC	3	0.91	{516,700,1113,1826,0,0,0}	2024-07-18 16:41:32.958545+02	5	\N	{Other,"1100 WEST ","1100 WEST ","DPCBAM LLC","SOUTH SECO"}	{116,147,58,3,3}	https://estategy-main.s3.amazonaws.com/condo_csv/1100 WEST AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/1100 WEST AVE.jpg	{7789000,11368500,6524100,23852000,19238000,5310000}	{1826,1474,1370,1159,1088,1088,809,741,736.77,700,696,694,694,694,694,694,676,676,675,610,530,530,508,502,493,493,485,485,477,466}	{-2,-3,-4,-1,16,26,02,04,20,01,10,11,17,23,24,14,09,21,05,27,08,18,07,19,22,12,15,25,06,03}	{13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,12,12,12,12,12,12,12,12,11,10,1,1,1,1}	{22,11,17,19,23,25,09,16,20,21,26,24,27,14,10,12,15,02,04,07,08,01,03,05,18,06,-3,-4,-1,-2}	\N	t
273	400 ALTON RD	Murano Grande	2003	t	37	265	25.7732967	-80.1403323	{1,2,3,4,5}	552373	265	{1/1/1,2/2/0,2/2/1,2/4/0,2/4/1,3/3/0,3/3/1,4/4/0,4/4/1,4/5/1,5/5/1}	{7,67,91,5,1,32,41,1,1,17,2}	{0,7,164,73,19,2,0}	0.015	EDWARD L GEOPFERT TRS	2	0.75	ELIZABETH M ORDAN TRS	2	0.75	MURANO GRANDE 607 LLC	2	0.75	{0,1310,1640,2595,4066,3682,0}	2024-07-18 17:18:38.271057+02	4	\N	{Other,"EDWARD L G","ELIZABETH ","MURANO GRA","TIMONTHY S"}	{261,2,2,2,2}	https://estategy-main.s3.amazonaws.com/condo_csv/400 ALTON RD.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/400 ALTON RD.jpg	{30720000,22015000,25554000,99287600,50897000,25011000}	{3220.47,3061.12,2174.77,2044.6,1912,1912,1912,1912,1874,1864,1678.2,1649,1630.45,1600,1494.43,1400,1310,1310,1310,1310,1310,1310,1310}	{03,01,06,04,5A,2A,3A,4A,02,1A,07,11,10,08,09,05,1M,7M,2M,6M,4M,3M,5M}	{33,32,26,25,25,21,21,20,19,16,15,1,1,1,1,1,1,1,1,1,1,1,1}	{01,03,06,04,07,11,09,10,08,02,05,5A,1M,2A,7M,2M,6M,1A,4M,3M,5M,3A,4A}	\N	t
227	6899 COLLINS AVE	The Carillon North Tower	2008	t	35	199	25.8537321	-80.12008929999999	{1,2,3,4,5}	339352	199	{1/1/0,2/2/0,2/2/1,2/3/0,2/3/1,3/2/1,3/3/0,3/3/1,4/4/1,4/5/1,5/5/1}	{27,64,44,29,4,13,9,3,2,3,1}	{0,27,141,25,5,1,0}	0.015	ANTONIO C ALVAREZ	3	1.51	JACK SCHWARTZ TRS	3	1.51	MNST LLC	3	1.51	{0,825,1639,2509,3601,5106,0}	2024-07-18 15:25:44.583159+02	8	\N	{Other,"ANTONIO C ","JACK SCHWA","MNST LLC","DARYL ROTH"}	{191,3,3,3,2}	https://estategy-main.s3.amazonaws.com/condo_csv/6899 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/6899 COLLINS AVE.jpg	{8012900,25245000,13667000,63097600,39673000,34100200}	{2274.41,2245.62,1892.29,1851.04,1796.38,1658.18,1625.38,1384.76,1290.56,820}	{02,06,04,01,07,08,05,03,10,09}	{28,28,22,21,21,18,17,16,15,13}	{04,01,08,07,03,10,02,06,09,05}	\N	t
278	110 WASHINGTON AVE	The Cosmopolitan	2004	t	8	221	25.770626	-80.13544379999999	{1,2,3}	207068	221	{1/1/0,1/1/1,2/2/0,2/2/1,3/3/0}	{60,65,71,24,1}	{0,125,95,1,0,0,0}	0.015	TIMOTHY SYKES	3	1.36	MUR INVEST GRP INC	3	1.36	BARNIA LLC	3	1.36	{0,766,1145,2392,0,0,0}	2024-07-18 17:27:42.608851+02	4	\N	{Other,"TIMOTHY SY","MUR INVEST","BARNIA LLC","JORGE H AR"}	{212,3,3,3,2}	https://estategy-main.s3.amazonaws.com/condo_csv/110 WASHINGTON AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/110 WASHINGTON AVE.jpg	{3793000,6249400,7902500,19166000,10136000,12345000}	{1366.86,1196,1196,1152.2,1103.5,1102.82,1027.4,1022.6,1011,954.8,936.4,928.22,917,910.4,907.78,899.6,826,826,808.8,742,742,721,703.5,686}	{01,21,24,08,09,17,15,14,07,16,05,04,20,06,03,19,23,02,13,18,22,11,10,12}	{11,10,10,10,10,10,10,10,10,10,10,10,10,10,10,9,9,9,8,8,8,7,6,6}	{17,15,08,10,12,13,18,19,22,16,21,14,11,06,05,02,03,04,20,07,09,01,23,24}	\N	t
263	2201 COLLINS AVE	W South Beach	2009	t	20	407	25.7979013	-80.1275924	{0,1,2,3}	354150	407	{0/1/0,1/1/0,1/1/1,2/2/0,2/2/1,2/3/0,3/3/1}	{242,12,96,24,24,1,8}	{242,108,49,8,0,0,30}	0.015	2201 COLLINS FEE LLC	212	52.09	THOMAS MICHAEL ROBERT	3	0.74	WALLEY PROPERTIES INC	3	0.74	{524,922,1427,2647,0,0,1213}	2024-07-18 16:53:36.773495+02	5	\N	{Other,"2201 COLLI","THOMAS MIC","WALLEY PRO","W FELDEX P"}	{178,212,3,3,2}	https://estategy-main.s3.amazonaws.com/condo_csv/2201 COLLINS AVE.xlsx		{}	https://estategy-main.s3.amazonaws.com/maps_img/2201 COLLINS AVE.jpg	{17905000,21700000,4310000,39765000,34388700,20170000}	{2912,2647,2642,2408,2314,2259,2185,1719.25,1693,1543,1306,1282,1282,1282,1279,1121,1026,1026,1026,1026,948,933,738.25,730,716,716,716,716,716,716,702.25,563,546,497,493,493,493,491,491,490,490,490,490,490,490,490,473}	{-5,-2,-1,-6,-3,-7,-8,28,-4,04," 1"," 4"," 2"," 3"," 5",11,15,22,19,14,29,31,38,09,37,35,36,34,32,33,01,26,10,30,18,08,13,25,27,20,23,02,07,03,21,17,12}	{16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,15,13,12,12,12,8,4,4,4,4,4,4,4,4,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1}	{10,20,22,23,25,26,09,28,12,01,02,04,07,18,27,14,08,03,19,15,11,29,13,30,37,35,36,34,31,32,33,38,-1," 4",-3,21,-7,17,-2,-4,-5,-6,-8," 1"," 2"," 3"," 5"}	\N	t
\.


--
-- Data for Name: core_condomarket; Type: TABLE DATA; Schema: public; Owner: gurra
--

COPY public.core_condomarket (id, name, sales_volume, years_built, years_built_counts) FROM stdin;
13	Aventura	{220582400,113578700,130126500,367250600,312900533,194139000}	\N	\N
12	Bal Harbour	{238155100,231854500,205765900,602645000,569043100,354201600}	{1977,1982,1994,1998,2004,2007,2010,2011,2016}	{10,5,5,5,5,10,10,5,5}
2	Brickell	{1100203080,823757600,689329267,1834149567,1771219000,1064222033}	{1995}	{5}
3	Coconut Grove	{440382100,149193000,402458700,437817400,304043300,315225400}	{}	{}
6	Downtown	{232323000,754678400,325878050,768329500,996063700,709973780}	{}	{}
1	Edgewater	{1420778299,568415700,202866700,727283400,776400900,435441100}	{}	{}
7	Key Biscayne	{206230700,144328900,196693800,533187300,350899400,225800900}	{}	{}
14	Little Havana	{8314500,10870800,9125200,17848233,22179700,16825000}	\N	\N
8	Miami Beach	{199034500,461837700,448859367,1037743500,680349900,377211200}	{}	{}
15	Miami River	{9556900,8939300,8471000,14510500,21391100,15446000}	\N	\N
10	Midtown	{250727898,40280900,42364300,212589700,152267400,80360600}	{}	{}
5	South Beach	{220025400,214468300,165589500,656395100,524887700,231326500}	{}	{}
4	South of Fifth	{368995800,300280400,218446700,1048976100,661268367,369854800}	{}	{}
9	Surfside	{448557200,198383400,295819100,421406600,346432800,241503100}	{}	{}
11	Wynwood	{850000,880000,1345000,3162500,4989000,0}	{}	{}
16	Miami-Dade	\N	\N	\N
\.


--
-- Data for Name: core_condosale; Type: TABLE DATA; Schema: public; Owner: gurra
--

COPY public.core_condosale (id, sale_price, seller, closing_date, condo_unit_id, buyers_arr, sellers_arr, blacklist, qualification_description, "order") FROM stdin;
130032_7800.0_2009-05-01	780000	\N	2009-05-01	130032	\N	\N	f	Qual by exam of deed	0
130032_9580.0_2012-04-26	958000	\N	2012-04-26	130032	\N	\N	f	Qual by exam of deed	0
130033_16000.0_2016-06-24	1600000	\N	2016-06-24	130033	\N	\N	f	Qual by exam of deed	0
130033_23880.0_2022-04-26	2388000	\N	2022-04-26	130033	\N	\N	f	Qual by exam of deed	0
130033_8500.0_2009-05-14	850000	\N	2009-05-14	130033	\N	\N	f	Qual by exam of deed	0
130034_3976.91_2012-12-21	397691	\N	2012-12-21	130034	\N	\N	f	Qual by exam of deed	0
130034_9482.0_2009-02-26	948200	\N	2009-02-26	130034	\N	\N	f	Qual by exam of deed	0
130035_12500.0_2020-09-02	1250000	\N	2020-09-02	130035	\N	\N	f	Qual by exam of deed	0
130035_12650.0_2013-04-17	1265000	\N	2013-04-17	130035	\N	\N	f	Qual by exam of deed	0
130035_15950.0_2021-04-09	1595000	\N	2021-04-09	130035	\N	\N	f	Qual by exam of deed	0
130035_7950.0_2009-07-17	795000	\N	2009-07-17	130035	\N	\N	f	Qual by exam of deed	0
130036_8400.0_2009-07-01	840000	\N	2009-07-01	130036	\N	\N	f	Qual by exam of deed	0
130037_13250.0_2020-12-15	1325000	\N	2020-12-15	130037	\N	\N	f	Qual by exam of deed	0
130037_16850.0_2013-08-05	1685000	\N	2013-08-05	130037	\N	\N	f	Qual by exam of deed	0
130037_8300.0_2009-07-27	830000	\N	2009-07-27	130037	\N	\N	f	Qual by exam of deed	0
130038_8550.0_2009-08-19	855000	\N	2009-08-19	130038	\N	\N	f	Qual by exam of deed	0
130038_8750.0_2010-06-18	875000	\N	2010-06-18	130038	\N	\N	f	Qual by exam of deed	0
130039_11000.0_2019-09-25	1100000	\N	2019-09-25	130039	\N	\N	f	Qual by exam of deed	0
130039_15000.0_2020-05-05	1500000	\N	2020-05-05	130039	\N	\N	f	Qual by exam of deed	0
130039_8600.0_2009-12-14	860000	\N	2009-12-14	130039	\N	\N	f	Qual by exam of deed	0
130040_8250.0_2009-05-22	825000	\N	2009-05-22	130040	\N	\N	f	Qual by exam of deed	0
130041_25500.0_2015-02-27	2550000	\N	2015-02-27	130041	\N	\N	f	Qual by exam of deed	0
130041_50000.0_2021-05-01	5000000	\N	2021-05-01	130041	\N	\N	f	Qual by exam of deed	0
130041_8500.0_2009-06-26	850000	\N	2009-06-26	130041	\N	\N	f	Qual by exam of deed	0
130042_14600.0_2021-06-16	1460000	\N	2021-06-16	130042	\N	\N	f	Qual by exam of deed	0
130042_15500.0_2017-03-15	1550000	\N	2017-03-15	130042	\N	\N	f	Qual by exam of deed	0
130042_18000.0_2008-06-11	1800000	\N	2008-06-11	130042	\N	\N	f	Sales which are qualified	0
130043_10200.0_2012-03-20	1020000	\N	2012-03-20	130043	\N	\N	f	Qual by exam of deed	0
130043_13850.0_2018-04-13	1385000	\N	2018-04-13	130043	\N	\N	f	Qual by exam of deed	0
130043_9750.0_2010-05-04	975000	\N	2010-05-04	130043	\N	\N	f	Qual by exam of deed	0
130044_13000.0_2020-07-02	1300000	\N	2020-07-02	130044	\N	\N	f	Qual by exam of deed	0
130044_15147.0_2008-08-15	1514700	\N	2008-08-15	130044	\N	\N	f	Sales which are qualified	0
130044_15500.0_2013-06-24	1550000	\N	2013-06-24	130044	\N	\N	f	Qual by exam of deed	0
133933_5900.0_2005-08-01	590000	\N	2005-08-01	133933	\N	\N	f	Sales which are qualified	0
133933_6250.0_2007-03-01	625000	\N	2007-03-01	133933	\N	\N	f	Sales which are qualified	0
133933_7100.0_2016-09-01	710000	\N	2016-09-01	133933	\N	\N	f	Qual by exam of deed	0
133934_4900.0_2005-08-01	490000	\N	2005-08-01	133934	\N	\N	f	Sales which are qualified	0
133934_4950.0_2021-05-03	495000	\N	2021-05-03	133934	\N	\N	f	Qual by exam of deed	0
133935_3672.5_2005-09-01	367250	\N	2005-09-01	133935	\N	\N	f	Sales which are qualified	0
133936_4850.0_2005-08-01	485000	\N	2005-08-01	133936	\N	\N	f	Sales which are qualified	0
133937_5400.0_2005-08-01	540000	\N	2005-08-01	133937	\N	\N	f	Sales which are qualified	0
133937_6200.0_2007-03-01	620000	\N	2007-03-01	133937	\N	\N	f	Sales which are qualified	0
133938_3750.0_2005-07-01	375000	\N	2005-07-01	133938	\N	\N	f	Sales which are qualified	0
133938_5220.0_2014-08-28	522000	\N	2014-08-28	133938	\N	\N	f	Qual by exam of deed	0
133938_7150.0_2023-03-22	715000	\N	2023-03-22	133938	\N	\N	f	Qual by exam of deed	0
133939_3990.9_2005-09-01	399090	\N	2005-09-01	133939	\N	\N	f	Sales which are qualified	0
133939_5000.0_2005-10-01	500000	\N	2005-10-01	133939	\N	\N	f	Sales which are qualified	0
133939_6650.0_2022-03-22	665000	\N	2022-03-22	133939	\N	\N	f	Qual by exam of deed	0
129146_2849.0_2002-08-01	284900	\N	2002-08-01	129146	\N	\N	f	Sales which are qualified	0
129146_2870.0_2004-05-01	287000	\N	2004-05-01	129146	\N	\N	f	Sales which are qualified	0
129147_11000.0_2022-03-16	1100000	\N	2022-03-16	129147	\N	\N	f	Qual by exam of deed	0
129147_2900.0_2009-04-07	290000	\N	2009-04-07	129147	\N	\N	f	Qual by exam of deed	0
129147_4900.0_2005-10-01	490000	\N	2005-10-01	129147	\N	\N	f	Sales which are qualified	0
129584_2250.0_2012-08-31	225000	\N	2012-08-31	129584	\N	\N	f	Qual by exam of deed	0
129584_2999.0_2002-10-01	299900	\N	2002-10-01	129584	\N	\N	f	Sales which are qualified	0
129584_3550.0_2013-01-18	355000	\N	2013-01-18	129584	\N	\N	f	Qual by exam of deed	0
129584_6250.0_2006-11-01	625000	\N	2006-11-01	129584	\N	\N	f	Sales which are qualified	0
129584_6350.0_2021-02-15	635000	\N	2021-02-15	129584	\N	\N	f	Qual by exam of deed	0
129585_2500.0_2002-10-01	250000	\N	2002-10-01	129585	\N	\N	f	Sales which are qualified	0
129585_3040.0_2012-05-29	304000	\N	2012-05-29	129585	\N	\N	f	Qual by exam of deed	0
129586_2675.0_2010-03-19	267500	\N	2010-03-19	129586	\N	\N	f	Qual by exam of deed	0
129586_2730.0_2011-08-11	273000	\N	2011-08-11	129586	\N	\N	f	Qual by exam of deed	0
129586_2745.0_2003-01-01	274500	\N	2003-01-01	129586	\N	\N	f	Sales which are qualified	0
129586_4600.0_2013-12-18	460000	\N	2013-12-18	129586	\N	\N	f	Qual by exam of deed	0
129586_7500.0_2021-03-08	750000	\N	2021-03-08	129586	\N	\N	f	Qual by exam of deed	0
129588_11000.0_2019-11-21	1100000	\N	2019-11-21	129588	\N	\N	t	Qual on DOS, multi-parcel sale	0
129590_1440.0_2002-08-01	144000	\N	2002-08-01	129590	\N	\N	f	Sales which are qualified	0
129590_1890.0_2004-08-01	189000	\N	2004-08-01	129590	\N	\N	f	Sales which are qualified	0
129590_3536.0_2021-06-30	353600	\N	2021-06-30	129590	\N	\N	f	Qual by exam of deed	0
129592_1890.0_2010-03-03	189000	\N	2010-03-03	129592	\N	\N	f	Qual by exam of deed	0
129592_3900.0_2020-08-03	390000	\N	2020-08-03	129592	\N	\N	f	Qual by exam of deed	0
129582_1530.0_1999-03-01	153000	\N	1999-03-01	129582	\N	\N	f	Sales which are qualified	0
129582_2525.0_2003-05-01	252500	\N	2003-05-01	129582	\N	\N	f	Sales which are qualified	0
129583_1579.0_1999-08-01	157900	\N	1999-08-01	129583	\N	\N	f	Sales which are qualified	0
129583_1875.0_2003-10-01	187500	\N	2003-10-01	129583	\N	\N	f	Sales which are qualified	0
129583_2400.0_2011-11-30	240000	\N	2011-11-30	129583	\N	\N	f	Qual by exam of deed	0
129583_4600.0_2013-05-17	460000	\N	2013-05-17	129583	\N	\N	f	Qual by exam of deed	0
129587_13100.0_2023-07-05	1310000	\N	2023-07-05	129587	\N	\N	f	Qual by exam of deed	0
129587_2750.0_2002-10-01	275000	\N	2002-10-01	129587	\N	\N	f	Sales which are qualified	0
129587_5050.0_2018-03-26	505000	\N	2018-03-26	129587	\N	\N	f	Qual by exam of deed	0
129587_7500.0_2019-06-28	750000	\N	2019-06-28	129587	\N	\N	f	Qual by exam of deed	0
129589_1050.0_1999-06-01	105000	\N	1999-06-01	129589	\N	\N	f	Sales which are qualified	0
129589_2050.0_2012-12-10	205000	\N	2012-12-10	129589	\N	\N	f	Qual by exam of deed	0
129589_2450.0_2013-03-08	245000	\N	2013-03-08	129589	\N	\N	f	Qual by exam of deed	0
129589_3350.0_2019-06-14	335000	\N	2019-06-14	129589	\N	\N	f	Qual by exam of deed	0
129591_2900.0_2017-08-29	290000	\N	2017-08-29	129591	\N	\N	f	Qual by exam of deed	0
129591_4390.0_2021-08-27	439000	\N	2021-08-27	129591	\N	\N	f	Qual by exam of deed	0
132012_36000.0_2021-10-20	3600000	\N	2021-10-20	132012	\N	\N	f	Qual by exam of deed	0
132013_39500.0_2021-10-27	3950000	\N	2021-10-27	132013	\N	\N	f	Qual by exam of deed	0
132013_51500.0_2022-04-04	5150000	\N	2022-04-04	132013	\N	\N	f	Qual by exam of deed	0
132014_40000.0_2021-10-29	4000000	\N	2021-10-29	132014	\N	\N	f	Qual by exam of deed	0
132015_37500.0_2021-10-19	3750000	\N	2021-10-19	132015	\N	\N	f	Qual by exam of deed	0
132016_43375.0_2021-10-27	4337500	\N	2021-10-27	132016	\N	\N	f	Qual by exam of deed	0
132017_45350.0_2021-10-22	4535000	\N	2021-10-22	132017	\N	\N	f	Qual by exam of deed	0
132018_54000.0_2021-11-12	5400000	\N	2021-11-12	132018	\N	\N	f	Qual by exam of deed	0
132019_46000.0_2021-11-01	4600000	\N	2021-11-01	132019	\N	\N	f	Qual by exam of deed	0
132020_41000.0_2021-12-01	4100000	\N	2021-12-01	132020	\N	\N	f	Qual by exam of deed	0
132021_56000.0_2021-11-09	5600000	\N	2021-11-09	132021	\N	\N	f	Qual by exam of deed	0
132022_41500.0_2021-11-16	4150000	\N	2021-11-16	132022	\N	\N	f	Qual by exam of deed	0
132022_61000.0_2022-06-02	6100000	\N	2022-06-02	132022	\N	\N	f	Qual by exam of deed	0
132023_67170.0_2021-11-05	6717000	\N	2021-11-05	132023	\N	\N	f	Qual by exam of deed	0
132024_71500.0_2021-10-21	7150000	\N	2021-10-21	132024	\N	\N	f	Qual by exam of deed	0
132025_78500.0_2021-11-01	7850000	\N	2021-11-01	132025	\N	\N	f	Qual by exam of deed	0
132026_93250.0_2021-10-22	9325000	\N	2021-10-22	132026	\N	\N	f	Qual by exam of deed	0
132027_87250.0_2021-10-28	8725000	\N	2021-10-28	132027	\N	\N	f	Qual by exam of deed	0
132029_63500.0_2021-11-11	6350000	\N	2021-11-11	132029	\N	\N	f	Qual by exam of deed	0
132030_66500.0_2021-10-21	6650000	\N	2021-10-21	132030	\N	\N	f	Qual by exam of deed	0
132031_77000.0_2021-10-27	7700000	\N	2021-10-27	132031	\N	\N	f	Qual by exam of deed	0
132032_81000.0_2021-10-20	8100000	\N	2021-10-20	132032	\N	\N	f	Qual by exam of deed	0
132033_17000.0_2021-11-01	1700000	\N	2021-11-01	132033	\N	\N	f	Qual by exam of deed	0
132034_17350.0_2021-10-19	1735000	\N	2021-10-19	132034	\N	\N	f	Qual by exam of deed	0
133640_38000.0_2017-08-18	3800000	\N	2017-08-18	133640	\N	\N	f	Qual by exam of deed	0
133640_39000.0_2020-01-31	3900000	\N	2020-01-31	133640	\N	\N	f	Qual by exam of deed	0
133641_21000.0_2018-11-30	2100000	\N	2018-11-30	133641	\N	\N	f	Qual by exam of deed	0
133641_26000.0_2021-05-13	2600000	\N	2021-05-13	133641	\N	\N	f	Qual by exam of deed	0
133642_21250.0_2017-08-22	2125000	\N	2017-08-22	133642	\N	\N	f	Qual by exam of deed	0
133643_25000.0_2019-02-07	2500000	\N	2019-02-07	133643	\N	\N	f	Qual by exam of deed	0
133644_20000.0_2017-08-22	2000000	\N	2017-08-22	133644	\N	\N	f	Qual by exam of deed	0
133644_24000.0_2020-11-30	2400000	\N	2020-11-30	133644	\N	\N	f	Qual by exam of deed	0
133645_28500.0_2017-08-25	2850000	\N	2017-08-25	133645	\N	\N	f	Qual by exam of deed	0
133646_29000.0_2018-02-28	2900000	\N	2018-02-28	133646	\N	\N	f	Qual by exam of deed	0
133646_29500.0_2020-03-17	2950000	\N	2020-03-17	133646	\N	\N	f	Qual by exam of deed	0
133647_29000.0_2017-08-05	2900000	\N	2017-08-05	133647	\N	\N	f	Qual by exam of deed	0
133647_32000.0_2019-12-02	3200000	\N	2019-12-02	133647	\N	\N	f	Qual by exam of deed	0
133648_32500.0_2017-08-25	3250000	\N	2017-08-25	133648	\N	\N	f	Qual by exam of deed	0
132844_3725.0_2004-06-01	372500	\N	2004-06-01	132844	\N	\N	f	Sales which are qualified	0
132844_6400.0_2014-09-11	640000	\N	2014-09-11	132844	\N	\N	f	Qual by exam of deed	0
132845_4190.0_2004-04-01	419000	\N	2004-04-01	132845	\N	\N	f	Sales which are qualified	0
132845_5250.0_2010-05-03	525000	\N	2010-05-03	132845	\N	\N	f	Qual by exam of deed	0
132845_7300.0_2015-09-28	730000	\N	2015-09-28	132845	\N	\N	f	Qual by exam of deed	0
132845_8100.0_2021-01-12	810000	\N	2021-01-12	132845	\N	\N	f	Qual by exam of deed	0
132846_4000.0_2004-06-01	400000	\N	2004-06-01	132846	\N	\N	f	Sales which are qualified	0
132846_4950.0_2005-01-01	495000	\N	2005-01-01	132846	\N	\N	f	Sales which are qualified	0
132846_5150.0_2011-06-29	515000	\N	2011-06-29	132846	\N	\N	f	Qual by exam of deed	0
132847_4085.0_2004-04-01	408500	\N	2004-04-01	132847	\N	\N	f	Sales which are qualified	0
132847_5950.0_2008-05-31	595000	\N	2008-05-31	132847	\N	\N	f	Sales which are qualified	0
132848_3667.0_2011-04-26	366700	\N	2011-04-26	132848	\N	\N	f	Qual by exam of deed	0
132848_3900.0_2004-06-01	390000	\N	2004-06-01	132848	\N	\N	f	Sales which are qualified	0
132848_6200.0_2013-09-27	620000	\N	2013-09-27	132848	\N	\N	f	Qual by exam of deed	0
132848_6300.0_2005-10-01	630000	\N	2005-10-01	132848	\N	\N	f	Sales which are qualified	0
132848_7200.0_2021-04-30	720000	\N	2021-04-30	132848	\N	\N	f	Qual by exam of deed	0
132849_3928.5_2004-05-01	392850	\N	2004-05-01	132849	\N	\N	f	Sales which are qualified	0
132850_4150.0_2004-05-01	415000	\N	2004-05-01	132850	\N	\N	f	Sales which are qualified	0
132850_5850.0_2006-03-01	585000	\N	2006-03-01	132850	\N	\N	f	Sales which are qualified	0
132850_6000.0_2014-03-21	600000	\N	2014-03-21	132850	\N	\N	f	Qual by exam of deed	0
132850_6990.0_2021-03-18	699000	\N	2021-03-18	132850	\N	\N	f	Qual by exam of deed	0
129592_1401.0_2009-07-03	140100	\N	2009-07-03	129592	\N	\N	f	Qual by exam of deed	0
129592_1500.0_2000-09-01	150000	\N	2000-09-01	129592	\N	\N	f	Sales which are qualified	0
129593_1179.0_1999-11-01	117900	\N	1999-11-01	129593	\N	\N	f	Sales which are qualified	0
129593_1450.0_2000-12-01	145000	\N	2000-12-01	129593	\N	\N	f	Sales which are qualified	0
127920_1975.0_2011-03-04	197500	\N	2011-03-04	127920	\N	\N	f	Qual by exam of deed	0
127920_2689.0_2005-09-01	268900	\N	2005-09-01	127920	\N	\N	f	Sales which are qualified	0
127921_2450.0_2016-12-11	245000	\N	2016-12-11	127921	\N	\N	f	Qual by exam of deed	0
127921_2729.0_2005-10-01	272900	\N	2005-10-01	127921	\N	\N	f	Sales which are qualified	0
127922_2550.0_2013-04-05	255000	\N	2013-04-05	127922	\N	\N	f	Qual by exam of deed	0
127922_2629.0_2005-07-01	262900	\N	2005-07-01	127922	\N	\N	f	Sales which are qualified	0
127922_3040.0_2013-08-30	304000	\N	2013-08-30	127922	\N	\N	f	Qual by exam of deed	0
127923_1230.0_2012-10-11	123000	\N	2012-10-11	127923	\N	\N	f	Qual by exam of deed	0
127923_2369.0_2005-07-01	236900	\N	2005-07-01	127923	\N	\N	f	Sales which are qualified	0
127923_3900.0_2007-08-01	390000	\N	2007-08-01	127923	\N	\N	f	Sales which are qualified	0
127924_1300.0_2014-11-19	130000	\N	2014-11-19	127924	\N	\N	f	Qual by exam of deed	0
127924_1869.0_2005-07-01	186900	\N	2005-07-01	127924	\N	\N	f	Sales which are qualified	0
127924_1980.4_2005-06-01	198040	\N	2005-06-01	127924	\N	\N	f	Sales which are qualified	0
127924_2400.0_2006-08-01	240000	\N	2006-08-01	127924	\N	\N	f	Sales which are qualified	0
127924_2595.0_2016-09-12	259500	\N	2016-09-12	127924	\N	\N	f	Qual by exam of deed	0
127925_2189.0_2005-08-01	218900	\N	2005-08-01	127925	\N	\N	f	Sales which are qualified	0
127942_2179.0_2005-08-01	217900	\N	2005-08-01	127942	\N	\N	f	Sales which are qualified	0
127943_2369.0_2005-08-01	236900	\N	2005-08-01	127943	\N	\N	f	Sales which are qualified	0
127944_2229.0_2005-07-01	222900	\N	2005-07-01	127944	\N	\N	f	Sales which are qualified	0
127944_3540.0_2023-08-11	354000	\N	2023-08-11	127944	\N	\N	f	Qual by exam of deed	0
127945_2339.0_2005-07-01	233900	\N	2005-07-01	127945	\N	\N	f	Sales which are qualified	0
127946_2309.0_2005-07-01	230900	\N	2005-07-01	127946	\N	\N	f	Sales which are qualified	0
127946_2750.0_2015-04-29	275000	\N	2015-04-29	127946	\N	\N	f	Qual by exam of deed	0
127946_2990.0_2007-02-01	299000	\N	2007-02-01	127946	\N	\N	f	Sales which are qualified	0
127947_2739.37_2005-08-01	273937	\N	2005-08-01	127947	\N	\N	f	Sales which are qualified	0
127947_2950.0_2014-08-18	295000	\N	2014-08-18	127947	\N	\N	f	Qual by exam of deed	0
127947_3270.0_2016-12-19	327000	\N	2016-12-19	127947	\N	\N	f	Qual by exam of deed	0
127947_4770.0_2023-01-17	477000	\N	2023-01-17	127947	\N	\N	f	Qual by exam of deed	0
127948_2450.0_2019-03-13	245000	\N	2019-03-13	127948	\N	\N	f	Qual by exam of deed	0
127948_2729.0_2005-08-01	272900	\N	2005-08-01	127948	\N	\N	f	Sales which are qualified	0
127949_1350.0_2009-01-15	135000	\N	2009-01-15	127949	\N	\N	f	Qual by exam of deed	0
127949_2250.0_2013-01-10	225000	\N	2013-01-10	127949	\N	\N	f	Qual by exam of deed	0
127949_2730.0_2014-06-04	273000	\N	2014-06-04	127949	\N	\N	f	Qual by exam of deed	0
127949_2769.0_2005-08-01	276900	\N	2005-08-01	127949	\N	\N	f	Sales which are qualified	0
127950_2849.0_2005-07-01	284900	\N	2005-07-01	127950	\N	\N	f	Sales which are qualified	0
127950_2950.0_2014-07-15	295000	\N	2014-07-15	127950	\N	\N	f	Qual by exam of deed	0
127951_2200.0_2021-02-16	220000	\N	2021-02-16	127951	\N	\N	f	Qual by exam of deed	0
127951_2699.0_2005-07-01	269900	\N	2005-07-01	127951	\N	\N	f	Sales which are qualified	0
127952_2450.0_2011-11-18	245000	\N	2011-11-18	127952	\N	\N	f	Qual by exam of deed	0
127952_2739.0_2005-08-01	273900	\N	2005-08-01	127952	\N	\N	f	Sales which are qualified	0
127952_3300.0_2019-12-13	330000	\N	2019-12-13	127952	\N	\N	f	Qual by exam of deed	0
127953_1700.0_2010-06-30	170000	\N	2010-06-30	127953	\N	\N	f	Qual by exam of deed	0
127953_2759.0_2005-07-01	275900	\N	2005-07-01	127953	\N	\N	f	Sales which are qualified	0
127953_3520.0_2018-06-12	352000	\N	2018-06-12	127953	\N	\N	f	Qual by exam of deed	0
127954_2989.0_2005-08-01	298900	\N	2005-08-01	127954	\N	\N	f	Sales which are qualified	0
127955_3710.0_2014-09-02	371000	\N	2014-09-02	127955	\N	\N	f	Qual by exam of deed	0
127969_3730.0_2005-12-01	373000	\N	2005-12-01	127969	\N	\N	f	Sales which are qualified	0
126594_2270.0_1998-08-01	227000	\N	1998-08-01	126594	\N	\N	t	Deeds that include more than one parcel	0
126594_6690.0_2015-12-14	669000	\N	2015-12-14	126594	\N	\N	t	Qual on DOS, multi-parcel sale	0
126595_2150.0_1999-04-01	215000	\N	1999-04-01	126595	\N	\N	t	Deeds that include more than one parcel	0
126595_2500.0_2002-07-01	250000	\N	2002-07-01	126595	\N	\N	f	Sales which are qualified	0
126595_3750.0_2011-05-02	375000	\N	2011-05-02	126595	\N	\N	f	Qual by exam of deed	0
126596_2360.0_1999-04-01	236000	\N	1999-04-01	126596	\N	\N	t	Deeds that include more than one parcel	0
126596_4550.0_2005-01-01	455000	\N	2005-01-01	126596	\N	\N	t	Deeds that include more than one parcel	0
126597_2390.0_1998-08-01	239000	\N	1998-08-01	126597	\N	\N	t	Deeds that include more than one parcel	0
126597_3250.0_2001-07-01	325000	\N	2001-07-01	126597	\N	\N	f	Sales which are qualified	0
126598_2420.0_1998-10-01	242000	\N	1998-10-01	126598	\N	\N	t	Deeds that include more than one parcel	0
126598_4000.0_2010-09-30	400000	\N	2010-09-30	126598	\N	\N	t	Qual on DOS, multi-parcel sale	0
126599_2500.0_1998-10-01	250000	\N	1998-10-01	126599	\N	\N	t	Deeds that include more than one parcel	0
126667_10750.0_2018-03-19	1075000	\N	2018-03-19	126667	\N	\N	t	Qual on DOS, multi-parcel sale	0
126730_3320.0_2002-09-01	332000	\N	2002-09-01	126730	\N	\N	t	Deeds that include more than one parcel	0
126742_1780.0_1998-07-01	178000	\N	1998-07-01	126742	\N	\N	t	Deeds that include more than one parcel	0
126789_3225.0_2002-03-01	322500	\N	2002-03-01	126789	\N	\N	f	Sales which are qualified	0
126947_18000.0_2015-06-10	1800000	\N	2015-06-10	126947	\N	\N	t	Qual on DOS, multi-parcel sale	0
126947_6700.0_2000-09-01	670000	\N	2000-09-01	126947	\N	\N	t	Deeds that include more than one parcel	0
126950_16550.0_2015-06-08	1655000	\N	2015-06-08	126950	\N	\N	t	Qual on DOS, multi-parcel sale	0
126950_3160.0_1998-04-01	316000	\N	1998-04-01	126950	\N	\N	t	Deeds that include more than one parcel	0
126950_90.0_2007-04-01	9000	\N	2007-04-01	126950	\N	\N	f	Sales which are qualified	0
126950_9170.0_2007-11-01	917000	\N	2007-11-01	126950	\N	\N	t	Deeds that include more than one parcel	0
126951_11350.0_2006-02-01	1135000	\N	2006-02-01	126951	\N	\N	t	Deeds that include more than one parcel	0
126951_17000.0_2017-02-24	1700000	\N	2017-02-24	126951	\N	\N	t	Qual on DOS, multi-parcel sale	0
126951_900.0_2023-06-22	90000	\N	2023-06-22	126951	\N	\N	t	Qual on DOS, multi-parcel sale	0
126953_1870.0_1998-08-01	187000	\N	1998-08-01	126953	\N	\N	t	Deeds that include more than one parcel	0
126953_2880.0_2002-05-01	288000	\N	2002-05-01	126953	\N	\N	t	Deeds that include more than one parcel	0
126953_5700.0_2006-01-01	570000	\N	2006-01-01	126953	\N	\N	t	Deeds that include more than one parcel	0
126954_13400.0_2013-05-08	1340000	\N	2013-05-08	126954	\N	\N	t	Qual on DOS, multi-parcel sale	0
126957_120.0_2007-04-01	12000	\N	2007-04-01	126957	\N	\N	f	Sales which are qualified	0
126957_3950.0_1998-04-01	395000	\N	1998-04-01	126957	\N	\N	t	Deeds that include more than one parcel	0
126957_4100.0_1999-01-01	410000	\N	1999-01-01	126957	\N	\N	t	Deeds that include more than one parcel	0
126969_150.0_2008-04-01	15000	\N	2008-04-01	126969	\N	\N	f	Sales which are qualified	0
127008_100.0_2002-10-01	10000	\N	2002-10-01	127008	\N	\N	f	Sales which are qualified	0
127021_2200.0_1999-03-01	220000	\N	1999-03-01	127021	\N	\N	t	Deeds that include more than one parcel	0
127021_3500.0_2004-05-01	350000	\N	2004-05-01	127021	\N	\N	t	Deeds that include more than one parcel	0
127021_3700.0_2009-11-05	370000	\N	2009-11-05	127021	\N	\N	t	Qual on DOS, multi-parcel sale	0
127023_100.0_2002-10-01	10000	\N	2002-10-01	127023	\N	\N	f	Sales which are qualified	0
127024_200.0_2015-09-02	20000	\N	2015-09-02	127024	\N	\N	f	Qual by exam of deed	0
127024_2110.0_1998-09-01	211000	\N	1998-09-01	127024	\N	\N	t	Deeds that include more than one parcel	0
127029_1910.0_1998-10-01	191000	\N	1998-10-01	127029	\N	\N	t	Deeds that include more than one parcel	0
127029_2850.0_2002-08-01	285000	\N	2002-08-01	127029	\N	\N	t	Deeds that include more than one parcel	0
127029_3500.0_2010-01-04	350000	\N	2010-01-04	127029	\N	\N	t	Qual on DOS, multi-parcel sale	0
127029_5950.0_2016-06-21	595000	\N	2016-06-21	127029	\N	\N	t	Qual on DOS, multi-parcel sale	0
127032_10150.0_2016-06-06	1015000	\N	2016-06-06	127032	\N	\N	t	Qual on DOS, multi-parcel sale	0
127032_13950.0_2021-10-27	1395000	\N	2021-10-27	127032	\N	\N	t	Qual on DOS, multi-parcel sale	0
127032_14500.0_2023-06-19	1450000	\N	2023-06-19	127032	\N	\N	t	Qual on DOS, multi-parcel sale	0
127032_2420.0_1998-09-01	242000	\N	1998-09-01	127032	\N	\N	t	Deeds that include more than one parcel	0
127032_2750.0_2010-09-15	275000	\N	2010-09-15	127032	\N	\N	t	Qual on DOS, multi-parcel sale	0
127033_2234.0_1998-10-01	223400	\N	1998-10-01	127033	\N	\N	t	Deeds that include more than one parcel	0
127034_2150.0_1999-04-01	215000	\N	1999-04-01	127034	\N	\N	t	Deeds that include more than one parcel	0
127034_300.0_2017-06-26	30000	\N	2017-06-26	127034	\N	\N	f	Qual by exam of deed	0
127034_4250.0_2010-04-08	425000	\N	2010-04-08	127034	\N	\N	t	Qual on DOS, multi-parcel sale	0
127051_1102.5_2006-09-01	110250	\N	2006-09-01	127051	\N	\N	t	Deeds that include more than one parcel	0
127020_3500.0_2004-05-01	350000	\N	2004-05-01	127020	\N	\N	t	Deeds that include more than one parcel	0
127022_2500.0_1998-10-01	250000	\N	1998-10-01	127022	\N	\N	t	Deeds that include more than one parcel	0
127022_3240.0_2002-03-01	324000	\N	2002-03-01	127022	\N	\N	t	Deeds that include more than one parcel	0
127025_150.0_2010-12-02	15000	\N	2010-12-02	127025	\N	\N	f	Qual by exam of deed	0
127042_100.0_2002-10-01	10000	\N	2002-10-01	127042	\N	\N	f	Sales which are qualified	0
127070_150.0_2018-02-19	15000	\N	2018-02-19	127070	\N	\N	f	Qual by exam of deed	0
33423_9750.0_2011-01-25	975000	\N	2011-01-25	33423	\N	\N	f	Qual by exam of deed	0
127089_102.5_2005-12-01	10250	\N	2005-12-01	127089	\N	\N	f	Sales which are qualified	0
127144_4140.0_2010-12-14	414000	\N	2010-12-14	127144	\N	\N	t	Qual on DOS, multi-parcel sale	0
127223_2250.0_2000-09-01	225000	\N	2000-09-01	127223	\N	\N	t	Deeds that include more than one parcel	0
127258_3000.0_2005-10-01	300000	\N	2005-10-01	127258	\N	\N	t	Deeds that include more than one parcel	0
127264_2750.0_2009-04-23	275000	\N	2009-04-23	127264	\N	\N	t	Qual on DOS, multi-parcel sale	0
127264_2850.0_2004-11-01	285000	\N	2004-11-01	127264	\N	\N	t	Deeds that include more than one parcel	0
126564_6164.0_2022-03-14	616400	\N	2022-03-14	126564	\N	\N	f	Qual by exam of deed	0
126565_6299.0_2022-02-18	629900	\N	2022-02-18	126565	\N	\N	f	Qual by exam of deed	0
126565_7400.0_2022-10-14	740000	\N	2022-10-14	126565	\N	\N	f	Qual by exam of deed	0
126566_15909.0_2022-02-17	1590900	\N	2022-02-17	126566	\N	\N	f	Qual by exam of deed	0
126567_9589.0_2022-02-16	958900	\N	2022-02-16	126567	\N	\N	f	Qual by exam of deed	0
126568_5700.0_2022-02-11	570000	\N	2022-02-11	126568	\N	\N	f	Qual by exam of deed	0
126569_8109.0_2022-02-18	810900	\N	2022-02-18	126569	\N	\N	f	Qual by exam of deed	0
126570_6149.0_2022-03-04	614900	\N	2022-03-04	126570	\N	\N	f	Qual by exam of deed	0
126571_12000.0_2022-06-30	1200000	\N	2022-06-30	126571	\N	\N	f	Qual by exam of deed	0
126571_9799.0_2022-02-25	979900	\N	2022-02-25	126571	\N	\N	f	Qual by exam of deed	0
126572_14200.0_2022-06-17	1420000	\N	2022-06-17	126572	\N	\N	f	Qual by exam of deed	0
126573_7699.0_2022-03-02	769900	\N	2022-03-02	126573	\N	\N	f	Qual by exam of deed	0
126574_6199.0_2022-03-07	619900	\N	2022-03-07	126574	\N	\N	f	Qual by exam of deed	0
126575_5990.0_2022-02-16	599000	\N	2022-02-16	126575	\N	\N	f	Qual by exam of deed	0
126576_5999.0_2022-03-07	599900	\N	2022-03-07	126576	\N	\N	f	Qual by exam of deed	0
126577_6299.0_2022-03-14	629900	\N	2022-03-14	126577	\N	\N	f	Qual by exam of deed	0
126577_8000.0_2022-05-02	800000	\N	2022-05-02	126577	\N	\N	f	Qual by exam of deed	0
126578_9699.0_2022-04-18	969900	\N	2022-04-18	126578	\N	\N	f	Qual by exam of deed	0
126579_18409.0_2022-03-03	1840900	\N	2022-03-03	126579	\N	\N	f	Qual by exam of deed	0
126580_12850.0_2022-02-18	1285000	\N	2022-02-18	126580	\N	\N	f	Qual by exam of deed	0
126581_12859.0_2022-02-18	1285900	\N	2022-02-18	126581	\N	\N	f	Qual by exam of deed	0
126582_15148.0_2022-02-14	1514800	\N	2022-02-14	126582	\N	\N	f	Qual by exam of deed	0
126583_1325.0_1993-11-01	132500	\N	1993-11-01	126583	\N	\N	f	Sales which are qualified	0
126583_1800.0_2000-06-01	180000	\N	2000-06-01	126583	\N	\N	f	Sales which are qualified	0
129288_1229.0_1997-10-01	122900	\N	1997-10-01	129288	\N	\N	f	Sales which are qualified	0
130252_626.0_1993-02-01	62600	\N	1993-02-01	130252	\N	\N	f	Sales which are qualified	0
33470_6550.0_2009-12-31	655000	\N	2009-12-31	33470	\N	\N	f	Qual by exam of deed	0
33470_7900.0_2013-11-07	790000	\N	2013-11-07	33470	\N	\N	f	Qual by exam of deed	0
133638_27750.0_2018-04-09	2775000	\N	2018-04-09	133638	\N	\N	f	Qual by exam of deed	0
133639_32000.0_2017-09-11	3200000	\N	2017-09-11	133639	\N	\N	f	Qual by exam of deed	0
130387_750.0_1995-10-01	75000	\N	1995-10-01	130387	\N	\N	f	Sales which are qualified	0
130507_675.0_1993-05-01	67500	\N	1993-05-01	130507	\N	\N	f	Sales which are qualified	0
33509_2550.0_2013-07-18	255000	\N	2013-07-18	33509	\N	\N	f	Qual by exam of deed	0
33573_3300.0_2009-09-11	330000	\N	2009-09-11	33573	\N	\N	f	Qual by exam of deed	0
88176_3750.0_2004-05-01	375000	\N	2004-05-01	88176	\N	\N	f	Sales which are qualified	0
88176_7000.0_2020-02-04	700000	\N	2020-02-04	88176	\N	\N	f	Qual by exam of deed	0
88177_9000.0_2023-03-10	900000	\N	2023-03-10	88177	\N	\N	f	Qual by exam of deed	0
129656_4190.0_2012-07-17	419000	\N	2012-07-17	129656	\N	\N	f	Qual by exam of deed	0
130236_1220.0_1993-07-01	122000	\N	1993-07-01	130236	\N	\N	f	Sales which are qualified	0
33882_3550.0_2012-08-24	355000	\N	2012-08-24	33882	\N	\N	f	Qual by exam of deed	0
130407_678.33_1993-03-01	67833	\N	1993-03-01	130407	\N	\N	f	Sales which are qualified	0
130491_4400.0_2005-03-01	440000	\N	2005-03-01	130491	\N	\N	f	Sales which are qualified	0
33914_5300.0_2022-03-22	530000	\N	2022-03-22	33914	\N	\N	f	Qual by exam of deed	0
34015_4300.0_2015-05-22	430000	\N	2015-05-22	34015	\N	\N	f	Qual by exam of deed	0
130521_2200.0_2011-05-25	220000	\N	2011-05-25	130521	\N	\N	f	Qual by exam of deed	0
34050_5400.0_2023-02-14	540000	\N	2023-02-14	34050	\N	\N	f	Qual by exam of deed	0
130735_8300.0_2019-05-09	830000	\N	2019-05-09	130735	\N	\N	f	Qual by exam of deed	0
34051_1750.0_2013-02-15	175000	\N	2013-02-15	34051	\N	\N	f	Qual by exam of deed	0
34051_2650.0_2018-01-18	265000	\N	2018-01-18	34051	\N	\N	f	Qual by exam of deed	0
133924_10250.0_2005-10-01	1025000	\N	2005-10-01	133924	\N	\N	f	Sales which are qualified	0
88177_4000.0_2004-05-01	400000	\N	2004-05-01	88177	\N	\N	f	Sales which are qualified	0
88177_4500.0_2010-05-25	450000	\N	2010-05-25	88177	\N	\N	f	Qual by exam of deed	0
88186_3400.0_2004-07-01	340000	\N	2004-07-01	88186	\N	\N	f	Sales which are qualified	0
88187_3730.0_2004-05-01	373000	\N	2004-05-01	88187	\N	\N	f	Sales which are qualified	0
88187_7990.0_2022-02-23	799000	\N	2022-02-23	88187	\N	\N	f	Qual by exam of deed	0
126586_2030.0_1998-04-01	203000	\N	1998-04-01	126586	\N	\N	t	Deeds that include more than one parcel	0
126704_6250.0_2000-05-01	625000	\N	2000-05-01	126704	\N	\N	f	Sales which are qualified	0
126774_5750.0_2014-09-29	575000	\N	2014-09-29	126774	\N	\N	f	Qual by exam of deed	0
127952_3850.0_2014-07-10	385000	\N	2014-07-10	127952	\N	\N	f	Qual by exam of deed	0
127970_3900.0_2014-08-25	390000	\N	2014-08-25	127970	\N	\N	f	Qual by exam of deed	0
127990_3803.0_2021-07-22	380300	\N	2021-07-22	127990	\N	\N	f	Qual by exam of deed	0
128234_950.0_2010-11-23	95000	\N	2010-11-23	128234	\N	\N	f	Qual by exam of deed	0
34252_4500.0_2022-08-16	450000	\N	2022-08-16	34252	\N	\N	f	Qual by exam of deed	0
34288_1900.0_2012-03-19	190000	\N	2012-03-19	34288	\N	\N	f	Qual by exam of deed	0
34288_3350.0_2012-06-01	335000	\N	2012-06-01	34288	\N	\N	f	Qual by exam of deed	0
128313_3190.0_2007-01-01	319000	\N	2007-01-01	128313	\N	\N	f	Sales which are qualified	0
128313_3409.0_2005-09-01	340900	\N	2005-09-01	128313	\N	\N	f	Sales which are qualified	0
126551_11559.0_2022-02-25	1155900	\N	2022-02-25	126551	\N	\N	f	Qual by exam of deed	0
34322_2225.0_2019-03-27	222500	\N	2019-03-27	34322	\N	\N	f	Qual by exam of deed	0
34322_2500.0_2019-04-18	250000	\N	2019-04-18	34322	\N	\N	f	Qual by exam of deed	0
34347_5400.0_2014-04-09	540000	\N	2014-04-09	34347	\N	\N	f	Qual by exam of deed	0
34347_6650.0_2014-10-02	665000	\N	2014-10-02	34347	\N	\N	f	Qual by exam of deed	0
34372_6400.0_2012-08-02	640000	\N	2012-08-02	34372	\N	\N	f	Qual by exam of deed	0
34372_8100.0_2017-11-28	810000	\N	2017-11-28	34372	\N	\N	f	Qual by exam of deed	0
34397_8200.0_2021-06-09	820000	\N	2021-06-09	34397	\N	\N	f	Qual by exam of deed	0
34907_3900.0_2022-01-03	390000	\N	2022-01-03	34907	\N	\N	f	Qual by exam of deed	0
34998_1520.0_2011-08-16	152000	\N	2011-08-16	34998	\N	\N	f	Qual by exam of deed	0
35025_3100.0_2022-10-26	310000	\N	2022-10-26	35025	\N	\N	f	Qual by exam of deed	0
87916_9230.0_2005-06-01	923000	\N	2005-06-01	87916	\N	\N	f	Sales which are qualified	0
35367_2699.0_2012-04-16	269900	\N	2012-04-16	35367	\N	\N	f	Qual by exam of deed	0
35367_2850.0_2017-08-24	285000	\N	2017-08-24	35367	\N	\N	f	Qual by exam of deed	0
35416_2881.3_2012-04-24	288130	\N	2012-04-24	35416	\N	\N	f	Qual by exam of deed	0
87867_7160.0_2004-03-01	716000	\N	2004-03-01	87867	\N	\N	f	Sales which are qualified	0
87867_7300.0_2009-08-26	730000	\N	2009-08-26	87867	\N	\N	f	Qual by exam of deed	0
87867_8850.0_2004-12-01	885000	\N	2004-12-01	87867	\N	\N	f	Sales which are qualified	0
87933_2424.0_2004-12-01	242400	\N	2004-12-01	87933	\N	\N	f	Sales which are qualified	0
36817_3900.0_2009-02-10	390000	\N	2009-02-10	36817	\N	\N	f	Qual by exam of deed	0
36950_2250.0_2013-01-04	225000	\N	2013-01-04	36950	\N	\N	f	Qual by exam of deed	0
36975_3900.0_2010-09-28	390000	\N	2010-09-28	36975	\N	\N	f	Qual by exam of deed	0
36975_4158.0_2011-03-01	415800	\N	2011-03-01	36975	\N	\N	f	Qual by exam of deed	0
36975_7750.0_2022-02-23	775000	\N	2022-02-23	36975	\N	\N	f	Qual by exam of deed	0
37085_2800.0_2019-07-25	280000	\N	2019-07-25	37085	\N	\N	f	Qual by exam of deed	0
37112_4000.0_2019-02-28	400000	\N	2019-02-28	37112	\N	\N	f	Qual by exam of deed	0
37220_9500.0_2019-10-11	950000	\N	2019-10-11	37220	\N	\N	f	Qual by exam of deed	0
37221_9200.0_2011-07-15	920000	\N	2011-07-15	37221	\N	\N	f	Qual by exam of deed	0
35424_6800.0_2021-07-26	680000	\N	2021-07-26	35424	\N	\N	f	Qual by exam of deed	0
53373_5900.0_2008-11-26	590000	\N	2008-11-26	53373	\N	\N	f	Sales which are qualified	0
53373_7500.0_2013-08-08	750000	\N	2013-08-08	53373	\N	\N	f	Qual by exam of deed	0
53375_6200.0_2008-11-26	620000	\N	2008-11-26	53375	\N	\N	f	Sales which are qualified	0
53393_3700.0_2010-12-16	370000	\N	2010-12-16	53393	\N	\N	f	Qual by exam of deed	0
53393_4950.0_2015-02-05	495000	\N	2015-02-05	53393	\N	\N	f	Qual by exam of deed	0
53394_3250.0_2010-06-01	325000	\N	2010-06-01	53394	\N	\N	f	Qual by exam of deed	0
53402_5850.0_2008-10-28	585000	\N	2008-10-28	53402	\N	\N	f	Sales which are qualified	0
53403_5500.0_2010-09-03	550000	\N	2010-09-03	53403	\N	\N	f	Qual by exam of deed	0
53403_6990.0_2012-05-31	699000	\N	2012-05-31	53403	\N	\N	f	Qual by exam of deed	0
53405_2500.0_2010-04-19	250000	\N	2010-04-19	53405	\N	\N	f	Qual by exam of deed	0
88562_27884.0_2015-05-19	2788400	\N	2015-05-19	88562	\N	\N	f	Qual by exam of deed	0
88562_42250.0_2021-09-30	4225000	\N	2021-09-30	88562	\N	\N	f	Qual by exam of deed	0
88563_16000.0_2015-05-19	1600000	\N	2015-05-19	88563	\N	\N	f	Qual by exam of deed	0
88564_16750.0_2015-05-19	1675000	\N	2015-05-19	88564	\N	\N	f	Qual by exam of deed	0
89553_136500.0_2021-03-22	13650000	\N	2021-03-22	89553	\N	\N	f	Qual by exam of deed	0
89553_53149.0_2008-03-01	5314900	\N	2008-03-01	89553	\N	\N	f	Sales which are qualified	0
89554_51709.0_2008-03-06	5170900	\N	2008-03-06	89554	\N	\N	f	Sales which are qualified	0
89557_128000.0_2021-08-26	12800000	\N	2021-08-26	89557	\N	\N	f	Qual by exam of deed	0
89557_51500.0_2008-03-21	5150000	\N	2008-03-21	89557	\N	\N	f	Sales which are qualified	0
89341_33320.0_2008-07-01	3332000	\N	2008-07-01	89341	\N	\N	f	Sales which are qualified	0
89341_50000.0_2016-01-09	5000000	\N	2016-01-09	89341	\N	\N	f	Qual by exam of deed	0
89341_55000.0_2021-09-29	5500000	\N	2021-09-29	89341	\N	\N	f	Qual by exam of deed	0
89342_26510.0_2008-03-01	2651000	\N	2008-03-01	89342	\N	\N	f	Sales which are qualified	0
89342_26550.0_2012-10-26	2655000	\N	2012-10-26	89342	\N	\N	f	Qual by exam of deed	0
89344_33500.0_2008-04-30	3350000	\N	2008-04-30	89344	\N	\N	f	Sales which are qualified	0
89344_34500.0_2008-05-19	3450000	\N	2008-05-19	89344	\N	\N	f	Sales which are qualified	0
89345_37750.0_2013-03-25	3775000	\N	2013-03-25	89345	\N	\N	f	Qual by exam of deed	0
89345_60000.0_2019-03-21	6000000	\N	2019-03-21	89345	\N	\N	f	Qual by exam of deed	0
89345_63500.0_2023-05-19	6350000	\N	2023-05-19	89345	\N	\N	f	Qual by exam of deed	0
89346_34824.0_2010-01-29	3482400	\N	2010-01-29	89346	\N	\N	f	Qual by exam of deed	0
89346_41500.0_2010-09-21	4150000	\N	2010-09-21	89346	\N	\N	f	Qual by exam of deed	0
89347_46000.0_2014-01-17	4600000	\N	2014-01-17	89347	\N	\N	f	Qual by exam of deed	0
89347_56000.0_2021-06-07	5600000	\N	2021-06-07	89347	\N	\N	f	Qual by exam of deed	0
89348_19650.0_2008-05-01	1965000	\N	2008-05-01	89348	\N	\N	f	Sales which are qualified	0
89349_18500.0_2014-10-31	1850000	\N	2014-10-31	89349	\N	\N	f	Qual by exam of deed	0
89349_19590.0_2008-05-01	1959000	\N	2008-05-01	89349	\N	\N	f	Sales which are qualified	0
89350_11000.0_2013-06-25	1100000	\N	2013-06-25	89350	\N	\N	f	Qual by exam of deed	0
89351_15000.0_2013-07-26	1500000	\N	2013-07-26	89351	\N	\N	f	Qual by exam of deed	0
89352_12000.0_2013-08-09	1200000	\N	2013-08-09	89352	\N	\N	f	Qual by exam of deed	0
89352_14950.0_2008-08-01	1495000	\N	2008-08-01	89352	\N	\N	f	Sales which are qualified	0
89353_24000.0_2013-02-11	2400000	\N	2013-02-11	89353	\N	\N	t	Qual on DOS, multi-parcel sale	0
89353_67200.0_2022-06-29	6720000	\N	2022-06-29	89353	\N	\N	f	Qual by exam of deed	0
89354_14000.0_2023-08-24	1400000	\N	2023-08-24	89354	\N	\N	f	Qual by exam of deed	0
89354_3980.0_2008-04-01	398000	\N	2008-04-01	89354	\N	\N	f	Sales which are qualified	0
89354_7450.0_2019-03-19	745000	\N	2019-03-19	89354	\N	\N	f	Qual by exam of deed	0
89355_4950.0_2008-03-01	495000	\N	2008-03-01	89355	\N	\N	f	Sales which are qualified	0
89356_9310.0_2008-04-01	931000	\N	2008-04-01	89356	\N	\N	t	Deeds that include more than one parcel	0
89357_153000.0_2016-11-15	15300000	\N	2016-11-15	89357	\N	\N	t	Qual on DOS, multi-parcel sale	0
89357_28311.5_2008-04-01	2831150	\N	2008-04-01	89357	\N	\N	t	Deeds that include more than one parcel	0
89357_32000.0_2009-08-19	3200000	\N	2009-08-19	89357	\N	\N	t	Qual on DOS, multi-parcel sale	0
87567_21400.0_2002-12-01	2140000	\N	2002-12-01	87567	\N	\N	f	Sales which are qualified	0
87568_23590.0_2003-01-01	2359000	\N	2003-01-01	87568	\N	\N	f	Sales which are qualified	0
87568_27000.0_2012-06-15	2700000	\N	2012-06-15	87568	\N	\N	f	Qual by exam of deed	0
87569_26100.0_2003-01-01	2610000	\N	2003-01-01	87569	\N	\N	f	Sales which are qualified	0
87569_63000.0_2017-08-04	6300000	\N	2017-08-04	87569	\N	\N	f	Qual by exam of deed	0
87570_17500.0_2009-11-24	1750000	\N	2009-11-24	87570	\N	\N	f	Qual by exam of deed	0
87570_23390.0_2003-01-01	2339000	\N	2003-01-01	87570	\N	\N	f	Sales which are qualified	0
87570_28000.0_2003-07-01	2800000	\N	2003-07-01	87570	\N	\N	f	Sales which are qualified	0
87848_19000.0_2011-02-03	1900000	\N	2011-02-03	87848	\N	\N	f	Qual by exam of deed	0
87848_35000.0_2018-06-19	3500000	\N	2018-06-19	87848	\N	\N	f	Qual by exam of deed	0
87848_6990.0_2003-03-01	699000	\N	2003-03-01	87848	\N	\N	f	Sales which are qualified	0
87849_16150.0_2009-09-18	1615000	\N	2009-09-18	87849	\N	\N	f	Qual by exam of deed	0
87849_26250.0_2012-12-31	2625000	\N	2012-12-31	87849	\N	\N	f	Qual by exam of deed	0
87849_8180.0_2002-11-01	818000	\N	2002-11-01	87849	\N	\N	f	Sales which are qualified	0
87850_12000.0_2004-05-01	1200000	\N	2004-05-01	87850	\N	\N	f	Sales which are qualified	0
87850_7250.0_2002-12-01	725000	\N	2002-12-01	87850	\N	\N	f	Sales which are qualified	0
87851_22000.0_2012-02-10	2200000	\N	2012-02-10	87851	\N	\N	f	Qual by exam of deed	0
87851_42000.0_2014-01-17	4200000	\N	2014-01-17	87851	\N	\N	f	Qual by exam of deed	0
87862_10000.0_2006-03-01	1000000	\N	2006-03-01	87862	\N	\N	f	Sales which are qualified	0
87862_6450.0_2004-03-01	645000	\N	2004-03-01	87862	\N	\N	f	Sales which are qualified	0
87863_5250.0_2004-02-01	525000	\N	2004-02-01	87863	\N	\N	f	Sales which are qualified	0
87863_5750.0_2013-03-15	575000	\N	2013-03-15	87863	\N	\N	f	Qual by exam of deed	0
87863_8850.0_2005-07-01	885000	\N	2005-07-01	87863	\N	\N	f	Sales which are qualified	0
87864_15700.0_2017-07-27	1570000	\N	2017-07-27	87864	\N	\N	f	Qual by exam of deed	0
87864_5968.87_2003-12-01	596887	\N	2003-12-01	87864	\N	\N	f	Sales which are qualified	0
87864_6100.0_2011-09-29	610000	\N	2011-09-29	87864	\N	\N	f	Qual by exam of deed	0
87865_6650.0_2013-03-15	665000	\N	2013-03-15	87865	\N	\N	f	Qual by exam of deed	0
87865_7600.0_2004-10-01	760000	\N	2004-10-01	87865	\N	\N	f	Sales which are qualified	0
87866_7290.0_2004-01-01	729000	\N	2004-01-01	87866	\N	\N	f	Sales which are qualified	0
87866_8750.0_2007-11-01	875000	\N	2007-11-01	87866	\N	\N	f	Sales which are qualified	0
87866_9100.0_2010-06-30	910000	\N	2010-06-30	87866	\N	\N	f	Qual by exam of deed	0
87868_15760.2_2004-10-01	1576020	\N	2004-10-01	87868	\N	\N	f	Sales which are qualified	0
87868_36000.0_2010-10-12	3600000	\N	2010-10-12	87868	\N	\N	f	Qual by exam of deed	0
87868_59000.0_2016-03-10	5900000	\N	2016-03-10	87868	\N	\N	f	Qual by exam of deed	0
87869_3050.0_2004-01-01	305000	\N	2004-01-01	87869	\N	\N	f	Sales which are qualified	0
87870_2185.2_2004-10-01	218520	\N	2004-10-01	87870	\N	\N	f	Sales which are qualified	0
87870_4000.0_2005-12-01	400000	\N	2005-12-01	87870	\N	\N	f	Sales which are qualified	0
87870_5300.0_2014-12-14	530000	\N	2014-12-14	87870	\N	\N	f	Qual by exam of deed	0
87871_2260.9_2004-05-01	226090	\N	2004-05-01	87871	\N	\N	f	Sales which are qualified	0
87872_3060.0_2004-01-01	306000	\N	2004-01-01	87872	\N	\N	f	Sales which are qualified	0
87872_3750.0_2010-03-10	375000	\N	2010-03-10	87872	\N	\N	f	Qual by exam of deed	0
87872_4250.0_2011-12-14	425000	\N	2011-12-14	87872	\N	\N	f	Qual by exam of deed	0
87872_7650.0_2022-05-20	765000	\N	2022-05-20	87872	\N	\N	f	Qual by exam of deed	0
87873_2855.85_2004-10-01	285585	\N	2004-10-01	87873	\N	\N	f	Sales which are qualified	0
87873_4500.0_2008-01-01	450000	\N	2008-01-01	87873	\N	\N	f	Sales which are qualified	0
87874_4070.0_2004-04-01	407000	\N	2004-04-01	87874	\N	\N	f	Sales which are qualified	0
87874_5357.5_2014-07-31	535750	\N	2014-07-31	87874	\N	\N	f	Qual by exam of deed	0
89066_12800.0_2010-02-11	1280000	\N	2010-02-11	89066	\N	\N	f	Qual by exam of deed	0
89066_13350.0_2005-04-01	1335000	\N	2005-04-01	89066	\N	\N	f	Sales which are qualified	0
89067_11393.8_2005-03-01	1139380	\N	2005-03-01	89067	\N	\N	f	Sales which are qualified	0
89067_16500.0_2006-03-01	1650000	\N	2006-03-01	89067	\N	\N	f	Sales which are qualified	0
89067_29000.0_2022-02-15	2900000	\N	2022-02-15	89067	\N	\N	f	Qual by exam of deed	0
89067_31000.0_2023-04-06	3100000	\N	2023-04-06	89067	\N	\N	f	Qual by exam of deed	0
89068_14000.0_2005-03-01	1400000	\N	2005-03-01	89068	\N	\N	f	Sales which are qualified	0
89068_16000.0_2008-05-01	1600000	\N	2008-05-01	89068	\N	\N	f	Sales which are qualified	0
89069_17560.0_2005-07-01	1756000	\N	2005-07-01	89069	\N	\N	f	Sales which are qualified	0
89069_18000.0_2012-04-23	1800000	\N	2012-04-23	89069	\N	\N	f	Qual by exam of deed	0
89070_10459.0_2005-03-01	1045900	\N	2005-03-01	89070	\N	\N	f	Sales which are qualified	0
89070_16500.0_2005-11-01	1650000	\N	2005-11-01	89070	\N	\N	f	Sales which are qualified	0
89071_14650.0_2011-01-05	1465000	\N	2011-01-05	89071	\N	\N	f	Qual by exam of deed	0
89071_27000.0_2012-10-22	2700000	\N	2012-10-22	89071	\N	\N	f	Qual by exam of deed	0
89071_9974.05_2005-03-01	997405	\N	2005-03-01	89071	\N	\N	f	Sales which are qualified	0
89073_13150.0_2005-04-01	1315000	\N	2005-04-01	89073	\N	\N	f	Sales which are qualified	0
89073_27200.0_2012-12-03	2720000	\N	2012-12-03	89073	\N	\N	f	Qual by exam of deed	0
89073_33350.0_2021-12-17	3335000	\N	2021-12-17	89073	\N	\N	f	Qual by exam of deed	0
89074_10299.0_2005-03-01	1029900	\N	2005-03-01	89074	\N	\N	f	Sales which are qualified	0
89074_15900.0_2008-04-01	1590000	\N	2008-04-01	89074	\N	\N	f	Sales which are qualified	0
89075_14550.0_2005-05-01	1455000	\N	2005-05-01	89075	\N	\N	f	Sales which are qualified	0
89075_16500.0_2011-05-20	1650000	\N	2011-05-20	89075	\N	\N	f	Qual by exam of deed	0
89075_17500.0_2006-03-01	1750000	\N	2006-03-01	89075	\N	\N	f	Sales which are qualified	0
89075_35000.0_2021-02-25	3500000	\N	2021-02-25	89075	\N	\N	f	Qual by exam of deed	0
89076_27250.0_2005-06-01	2725000	\N	2005-06-01	89076	\N	\N	f	Sales which are qualified	0
89076_34000.0_2011-06-13	3400000	\N	2011-06-13	89076	\N	\N	f	Qual by exam of deed	0
89076_56500.0_2015-07-24	5650000	\N	2015-07-24	89076	\N	\N	f	Qual by exam of deed	0
89077_14270.0_2005-06-01	1427000	\N	2005-06-01	89077	\N	\N	f	Sales which are qualified	0
89077_14900.0_2010-06-29	1490000	\N	2010-06-29	89077	\N	\N	f	Qual by exam of deed	0
89077_18000.0_2005-06-01	1800000	\N	2005-06-01	89077	\N	\N	f	Sales which are qualified	0
89077_84000.0_2015-10-14	8400000	\N	2015-10-14	89077	\N	\N	f	Qual by exam of deed	0
89078_13900.0_2005-03-01	1390000	\N	2005-03-01	89078	\N	\N	f	Sales which are qualified	0
89078_19450.0_2007-05-01	1945000	\N	2007-05-01	89078	\N	\N	f	Sales which are qualified	0
89079_13000.0_2010-03-10	1300000	\N	2010-03-10	89079	\N	\N	f	Qual by exam of deed	0
89107_9200.0_2005-03-01	920000	\N	2005-03-01	89107	\N	\N	f	Sales which are qualified	0
88833_5150.0_2006-10-01	515000	\N	2006-10-01	88833	\N	\N	f	Sales which are qualified	0
89210_17250.0_2013-05-15	1725000	\N	2013-05-15	89210	\N	\N	f	Qual by exam of deed	0
89210_18000.0_2021-10-21	1800000	\N	2021-10-21	89210	\N	\N	f	Qual by exam of deed	0
89612_9000.0_2015-11-05	900000	\N	2015-11-05	89612	\N	\N	f	Qual by exam of deed	0
89613_28801.0_2015-10-20	2880100	\N	2015-10-20	89613	\N	\N	f	Qual by exam of deed	0
89613_33000.0_2021-08-12	3300000	\N	2021-08-12	89613	\N	\N	f	Qual by exam of deed	0
89614_30316.0_2015-10-20	3031600	\N	2015-10-20	89614	\N	\N	f	Qual by exam of deed	0
89615_30000.0_2016-04-21	3000000	\N	2016-04-21	89615	\N	\N	f	Qual by exam of deed	0
89615_30500.0_2021-03-12	3050000	\N	2021-03-12	89615	\N	\N	f	Qual by exam of deed	0
87377_2459.0_2002-07-01	245900	\N	2002-07-01	87377	\N	\N	f	Sales which are qualified	0
87378_2359.0_2002-08-01	235900	\N	2002-08-01	87378	\N	\N	f	Sales which are qualified	0
87379_2350.0_2002-06-01	235000	\N	2002-06-01	87379	\N	\N	f	Sales which are qualified	0
87379_3500.0_2002-06-01	350000	\N	2002-06-01	87379	\N	\N	f	Sales which are qualified	0
87379_3990.0_2002-06-01	399000	\N	2002-06-01	87379	\N	\N	f	Sales which are qualified	0
87379_9650.0_2014-11-20	965000	\N	2014-11-20	87379	\N	\N	f	Qual by exam of deed	0
87379_9880.0_2017-06-23	988000	\N	2017-06-23	87379	\N	\N	f	Qual by exam of deed	0
87380_2459.0_2002-06-01	245900	\N	2002-06-01	87380	\N	\N	f	Sales which are qualified	0
87380_3820.0_2002-09-01	382000	\N	2002-09-01	87380	\N	\N	f	Sales which are qualified	0
87380_4300.0_2003-08-01	430000	\N	2003-08-01	87380	\N	\N	f	Sales which are qualified	0
87381_11000.0_2021-08-12	1100000	\N	2021-08-12	87381	\N	\N	f	Qual by exam of deed	0
87381_11000.0_2022-04-15	1100000	\N	2022-04-15	87381	\N	\N	f	Qual by exam of deed	0
87381_3780.0_2002-06-01	378000	\N	2002-06-01	87381	\N	\N	f	Sales which are qualified	0
87381_5400.0_2011-05-23	540000	\N	2011-05-23	87381	\N	\N	f	Qual by exam of deed	0
87381_6050.0_2005-11-01	605000	\N	2005-11-01	87381	\N	\N	f	Sales which are qualified	0
87382_11300.0_2021-11-01	1130000	\N	2021-11-01	87382	\N	\N	f	Qual by exam of deed	0
87382_2459.0_2002-06-01	245900	\N	2002-06-01	87382	\N	\N	f	Sales which are qualified	0
87382_3159.0_2002-06-01	315900	\N	2002-06-01	87382	\N	\N	f	Sales which are qualified	0
87382_4000.0_2002-09-01	400000	\N	2002-09-01	87382	\N	\N	f	Sales which are qualified	0
87382_4350.0_2003-12-01	435000	\N	2003-12-01	87382	\N	\N	f	Sales which are qualified	0
87382_5300.0_2005-02-01	530000	\N	2005-02-01	87382	\N	\N	f	Sales which are qualified	0
87382_5300.0_2011-03-01	530000	\N	2011-03-01	87382	\N	\N	f	Qual by exam of deed	0
87382_5550.0_2012-04-20	555000	\N	2012-04-20	87382	\N	\N	f	Qual by exam of deed	0
87383_2459.0_2002-07-01	245900	\N	2002-07-01	87383	\N	\N	f	Sales which are qualified	0
88567_11850.0_2021-12-03	1185000	\N	2021-12-03	88567	\N	\N	f	Qual by exam of deed	0
88567_5500.0_2003-11-01	550000	\N	2003-11-01	88567	\N	\N	f	Sales which are qualified	0
88568_17000.0_2023-07-13	1700000	\N	2023-07-13	88568	\N	\N	f	Qual by exam of deed	0
88568_6800.0_2004-02-01	680000	\N	2004-02-01	88568	\N	\N	f	Sales which are qualified	0
88569_11250.0_2006-12-01	1125000	\N	2006-12-01	88569	\N	\N	f	Sales which are qualified	0
88569_6950.0_2003-12-01	695000	\N	2003-12-01	88569	\N	\N	f	Sales which are qualified	0
88570_19200.0_2022-09-30	1920000	\N	2022-09-30	88570	\N	\N	f	Qual by exam of deed	0
88570_6260.0_2004-01-01	626000	\N	2004-01-01	88570	\N	\N	f	Sales which are qualified	0
88571_5216.25_2004-07-01	521625	\N	2004-07-01	88571	\N	\N	f	Sales which are qualified	0
88572_5600.0_2004-08-01	560000	\N	2004-08-01	88572	\N	\N	f	Sales which are qualified	0
88573_5600.0_2003-11-01	560000	\N	2003-11-01	88573	\N	\N	f	Sales which are qualified	0
88574_5264.0_2003-11-01	526400	\N	2003-11-01	88574	\N	\N	f	Sales which are qualified	0
88575_11500.0_2014-03-24	1150000	\N	2014-03-24	88575	\N	\N	f	Qual by exam of deed	0
88727_12050.0_2023-01-14	1205000	\N	2023-01-14	88727	\N	\N	f	Qual by exam of deed	0
88727_4186.46_2003-10-01	418646	\N	2003-10-01	88727	\N	\N	f	Sales which are qualified	0
88727_4950.0_2004-04-01	495000	\N	2004-04-01	88727	\N	\N	f	Sales which are qualified	0
88728_10950.0_2013-10-15	1095000	\N	2013-10-15	88728	\N	\N	f	Qual by exam of deed	0
88728_4409.0_2003-08-01	440900	\N	2003-08-01	88728	\N	\N	f	Sales which are qualified	0
88728_5850.0_2004-07-01	585000	\N	2004-07-01	88728	\N	\N	f	Sales which are qualified	0
88834_1160.0_1988-04-01	116000	\N	1988-04-01	88834	\N	\N	f	Sales which are qualified	0
88834_6600.0_2013-06-28	660000	\N	2013-06-28	88834	\N	\N	f	Qual by exam of deed	0
88745_16500.0_2015-02-20	1650000	\N	2015-02-20	88745	\N	\N	f	Qual by exam of deed	0
88793_10500.0_2007-10-01	1050000	\N	2007-10-01	88793	\N	\N	f	Sales which are qualified	0
88812_5850.0_2004-08-01	585000	\N	2004-08-01	88812	\N	\N	f	Sales which are qualified	0
88812_7200.0_2020-10-08	720000	\N	2020-10-08	88812	\N	\N	f	Qual by exam of deed	0
88812_8500.0_2011-11-15	850000	\N	2011-11-15	88812	\N	\N	f	Qual by exam of deed	0
88813_4700.0_2003-06-01	470000	\N	2003-06-01	88813	\N	\N	f	Sales which are qualified	0
88814_4930.0_2003-12-01	493000	\N	2003-12-01	88814	\N	\N	f	Sales which are qualified	0
88814_6000.0_2011-01-24	600000	\N	2011-01-24	88814	\N	\N	f	Qual by exam of deed	0
88814_6080.0_2004-08-01	608000	\N	2004-08-01	88814	\N	\N	f	Sales which are qualified	0
88815_4749.0_2003-10-01	474900	\N	2003-10-01	88815	\N	\N	f	Sales which are qualified	0
88815_5267.1_2004-04-01	526710	\N	2004-04-01	88815	\N	\N	f	Sales which are qualified	0
88815_7250.0_2012-04-06	725000	\N	2012-04-06	88815	\N	\N	f	Qual by exam of deed	0
88815_7500.0_2019-10-15	750000	\N	2019-10-15	88815	\N	\N	f	Qual by exam of deed	0
88816_13250.0_2015-01-14	1325000	\N	2015-01-14	88816	\N	\N	f	Qual by exam of deed	0
88816_5050.0_2003-06-01	505000	\N	2003-06-01	88816	\N	\N	f	Sales which are qualified	0
88817_5609.0_2003-11-01	560900	\N	2003-11-01	88817	\N	\N	f	Sales which are qualified	0
88817_8000.0_2008-10-10	800000	\N	2008-10-10	88817	\N	\N	f	Sales which are qualified	0
88817_8750.0_2005-09-01	875000	\N	2005-09-01	88817	\N	\N	f	Sales which are qualified	0
88817_9800.0_2018-06-14	980000	\N	2018-06-14	88817	\N	\N	f	Qual by exam of deed	0
88818_5500.0_2012-03-24	550000	\N	2012-03-24	88818	\N	\N	f	Qual by exam of deed	0
88225_12500.0_2013-11-20	1250000	\N	2013-11-20	88225	\N	\N	f	Qual by exam of deed	0
88226_15950.0_2014-03-13	1595000	\N	2014-03-13	88226	\N	\N	f	Qual by exam of deed	0
88226_17500.0_2021-06-15	1750000	\N	2021-06-15	88226	\N	\N	f	Qual by exam of deed	0
88226_23000.0_2016-05-31	2300000	\N	2016-05-31	88226	\N	\N	f	Qual by exam of deed	0
88226_25250.0_2015-03-17	2525000	\N	2015-03-17	88226	\N	\N	f	Qual by exam of deed	0
88227_11039.89_2014-04-03	1103989	\N	2014-04-03	88227	\N	\N	f	Qual by exam of deed	0
88227_16990.0_2021-02-19	1699000	\N	2021-02-19	88227	\N	\N	f	Qual by exam of deed	0
88228_10420.55_2012-05-25	1042055	\N	2012-05-25	88228	\N	\N	f	Qual by exam of deed	0
88229_18500.0_2016-04-07	1850000	\N	2016-04-07	88229	\N	\N	f	Qual by exam of deed	0
88229_9310.0_2012-08-02	931000	\N	2012-08-02	88229	\N	\N	f	Qual by exam of deed	0
88232_142500.0_2022-06-22	14250000	\N	2022-06-22	88232	\N	\N	f	Qual by exam of deed	0
88232_150600.0_2021-02-18	15060000	\N	2021-02-18	88232	\N	\N	f	Qual by exam of deed	0
88232_80000.0_2013-04-15	8000000	\N	2013-04-15	88232	\N	\N	f	Qual by exam of deed	0
88233_105000.0_2022-07-11	10500000	\N	2022-07-11	88233	\N	\N	f	Qual by exam of deed	0
88233_47000.0_2012-05-21	4700000	\N	2012-05-21	88233	\N	\N	f	Qual by exam of deed	0
88234_120000.0_2021-12-21	12000000	\N	2021-12-21	88234	\N	\N	f	Qual by exam of deed	0
88234_67000.0_2012-10-16	6700000	\N	2012-10-16	88234	\N	\N	f	Qual by exam of deed	0
88235_47860.0_2012-12-18	4786000	\N	2012-12-18	88235	\N	\N	f	Qual by exam of deed	0
88236_61000.0_2012-12-27	6100000	\N	2012-12-27	88236	\N	\N	f	Qual by exam of deed	0
88237_55000.0_2012-05-04	5500000	\N	2012-05-04	88237	\N	\N	f	Qual by exam of deed	0
88238_75500.0_2012-05-18	7550000	\N	2012-05-18	88238	\N	\N	f	Qual by exam of deed	0
88239_43000.0_2011-11-22	4300000	\N	2011-11-22	88239	\N	\N	f	Qual by exam of deed	0
88239_90000.0_2015-03-20	9000000	\N	2015-03-20	88239	\N	\N	f	Qual by exam of deed	0
88240_45000.0_2012-03-30	4500000	\N	2012-03-30	88240	\N	\N	f	Qual by exam of deed	0
88241_64100.0_2013-05-03	6410000	\N	2013-05-03	88241	\N	\N	f	Qual by exam of deed	0
88243_150000.0_2013-05-30	15000000	\N	2013-05-30	88243	\N	\N	f	Qual by exam of deed	0
88243_68000.0_2009-06-29	6800000	\N	2009-06-29	88243	\N	\N	f	Qual by exam of deed	0
88244_120500.0_2015-03-04	12050000	\N	2015-03-04	88244	\N	\N	f	Qual by exam of deed	0
88245_67000.0_2013-01-28	6700000	\N	2013-01-28	88245	\N	\N	f	Qual by exam of deed	0
88246_107000.0_2017-08-01	10700000	\N	2017-08-01	88246	\N	\N	f	Qual by exam of deed	0
88246_165000.0_2022-03-03	16500000	\N	2022-03-03	88246	\N	\N	f	Qual by exam of deed	0
88246_67500.0_2012-06-18	6750000	\N	2012-06-18	88246	\N	\N	f	Qual by exam of deed	0
88247_53000.0_2012-08-29	5300000	\N	2012-08-29	88247	\N	\N	f	Qual by exam of deed	0
88247_75000.0_2017-10-02	7500000	\N	2017-10-02	88247	\N	\N	f	Qual by exam of deed	0
88247_95500.0_2022-01-10	9550000	\N	2022-01-10	88247	\N	\N	f	Qual by exam of deed	0
88253_42530.0_2016-04-26	4253000	\N	2016-04-26	88253	\N	\N	f	Qual by exam of deed	0
88254_41000.0_2016-03-29	4100000	\N	2016-03-29	88254	\N	\N	f	Qual by exam of deed	0
88254_67500.0_2022-01-26	6750000	\N	2022-01-26	88254	\N	\N	f	Qual by exam of deed	0
88255_63500.0_2021-07-13	6350000	\N	2021-07-13	88255	\N	\N	f	Qual by exam of deed	0
88328_25000.0_2013-12-27	2500000	\N	2013-12-27	88328	\N	\N	f	Qual by exam of deed	0
88328_4250.0_1997-02-01	425000	\N	1997-02-01	88328	\N	\N	f	Sales which are qualified	0
88835_12500.0_2022-03-04	1250000	\N	2022-03-04	88835	\N	\N	f	Qual by exam of deed	0
88339_16250.0_2011-07-06	1625000	\N	2011-07-06	88339	\N	\N	f	Qual by exam of deed	0
88833_1140.0_1989-09-01	114000	\N	1989-09-01	88833	\N	\N	f	Sales which are qualified	0
88833_1240.0_1991-03-01	124000	\N	1991-03-01	88833	\N	\N	f	Sales which are qualified	0
88833_1650.0_1993-05-01	165000	\N	1993-05-01	88833	\N	\N	f	Sales which are qualified	0
88833_1740.0_1994-04-01	174000	\N	1994-04-01	88833	\N	\N	f	Sales which are qualified	0
88833_1740.0_1999-03-01	174000	\N	1999-03-01	88833	\N	\N	f	Sales which are qualified	0
88833_1900.0_2000-10-01	190000	\N	2000-10-01	88833	\N	\N	f	Sales which are qualified	0
88833_2700.0_2002-07-01	270000	\N	2002-07-01	88833	\N	\N	f	Sales which are qualified	0
88835_8250.0_2016-08-08	825000	\N	2016-08-08	88835	\N	\N	f	Qual by exam of deed	0
88835_8750.0_2017-05-04	875000	\N	2017-05-04	88835	\N	\N	f	Qual by exam of deed	0
88836_1650.0_1993-10-01	165000	\N	1993-10-01	88836	\N	\N	f	Sales which are qualified	0
88904_3100.0_1990-12-01	310000	\N	1990-12-01	88904	\N	\N	f	Sales which are qualified	0
88924_3250.0_2001-04-01	325000	\N	2001-04-01	88924	\N	\N	f	Sales which are qualified	0
88945_6050.0_2006-07-01	605000	\N	2006-07-01	88945	\N	\N	f	Sales which are qualified	0
87977_4650.0_2010-09-23	465000	\N	2010-09-23	87977	\N	\N	f	Qual by exam of deed	0
88001_4900.0_2018-02-14	490000	\N	2018-02-14	88001	\N	\N	f	Qual by exam of deed	0
88032_654.0_2019-07-20	65400	\N	2019-07-20	88032	\N	\N	f	Qual by exam of deed	0
88308_30775.0_2018-07-17	3077500	\N	2018-07-17	88308	\N	\N	f	Qual by exam of deed	0
88309_20500.0_2018-06-08	2050000	\N	2018-06-08	88309	\N	\N	f	Qual by exam of deed	0
88309_25000.0_2019-10-01	2500000	\N	2019-10-01	88309	\N	\N	f	Qual by exam of deed	0
88314_11880.0_2018-06-08	1188000	\N	2018-06-08	88314	\N	\N	f	Qual by exam of deed	0
88320_28250.0_2018-06-11	2825000	\N	2018-06-11	88320	\N	\N	f	Qual by exam of deed	0
88320_28500.0_2018-09-26	2850000	\N	2018-09-26	88320	\N	\N	f	Qual by exam of deed	0
89647_2400.0_2000-05-01	240000	\N	2000-05-01	89647	\N	\N	f	Sales which are qualified	0
89842_3650.0_2010-02-22	365000	\N	2010-02-22	89842	\N	\N	f	Qual by exam of deed	0
89852_1947.0_1999-12-01	194700	\N	1999-12-01	89852	\N	\N	f	Sales which are qualified	0
89852_2800.0_2003-12-01	280000	\N	2003-12-01	89852	\N	\N	f	Sales which are qualified	0
89852_4350.0_2007-11-01	435000	\N	2007-11-01	89852	\N	\N	f	Sales which are qualified	0
89852_4450.0_2013-08-01	445000	\N	2013-08-01	89852	\N	\N	f	Qual by exam of deed	0
89871_2005.0_2000-01-01	200500	\N	2000-01-01	89871	\N	\N	f	Sales which are qualified	0
89871_2619.0_2001-02-01	261900	\N	2001-02-01	89871	\N	\N	f	Sales which are qualified	0
89871_2650.0_2001-12-01	265000	\N	2001-12-01	89871	\N	\N	f	Sales which are qualified	0
89871_4850.0_2012-06-15	485000	\N	2012-06-15	89871	\N	\N	f	Qual by exam of deed	0
89873_2043.0_1999-12-01	204300	\N	1999-12-01	89873	\N	\N	f	Sales which are qualified	0
89873_2850.0_2003-05-01	285000	\N	2003-05-01	89873	\N	\N	f	Sales which are qualified	0
89864_2450.0_2002-09-01	245000	\N	2002-09-01	89864	\N	\N	f	Sales which are qualified	0
89864_4175.0_2009-05-15	417500	\N	2009-05-15	89864	\N	\N	f	Qual by exam of deed	0
89865_1891.0_1999-11-01	189100	\N	1999-11-01	89865	\N	\N	f	Sales which are qualified	0
89865_4880.0_2020-12-14	488000	\N	2020-12-14	89865	\N	\N	f	Qual by exam of deed	0
89866_1800.0_1999-10-01	180000	\N	1999-10-01	89866	\N	\N	f	Sales which are qualified	0
89866_2445.0_2000-06-01	244500	\N	2000-06-01	89866	\N	\N	f	Sales which are qualified	0
89866_5250.0_2016-12-22	525000	\N	2016-12-22	89866	\N	\N	f	Qual by exam of deed	0
89867_2112.0_1999-12-01	211200	\N	1999-12-01	89867	\N	\N	f	Sales which are qualified	0
89868_2233.0_2000-05-01	223300	\N	2000-05-01	89868	\N	\N	f	Sales which are qualified	0
89868_4900.0_2008-03-01	490000	\N	2008-03-01	89868	\N	\N	f	Sales which are qualified	0
89868_6200.0_2022-03-09	620000	\N	2022-03-09	89868	\N	\N	f	Qual by exam of deed	0
89869_1967.0_1999-11-01	196700	\N	1999-11-01	89869	\N	\N	f	Sales which are qualified	0
89869_4750.0_2012-06-22	475000	\N	2012-06-22	89869	\N	\N	f	Qual by exam of deed	0
89898_3500.0_2003-12-01	350000	\N	2003-12-01	89898	\N	\N	f	Sales which are qualified	0
90000_5000.0_2000-02-01	500000	\N	2000-02-01	90000	\N	\N	f	Sales which are qualified	0
90000_5750.0_2003-11-01	575000	\N	2003-11-01	90000	\N	\N	f	Sales which are qualified	0
90000_8488.88_2008-07-01	848888	\N	2008-07-01	90000	\N	\N	f	Sales which are qualified	0
90000_9300.0_2010-08-04	930000	\N	2010-08-04	90000	\N	\N	f	Qual by exam of deed	0
90001_4820.0_1999-12-01	482000	\N	1999-12-01	90001	\N	\N	f	Sales which are qualified	0
90001_6000.0_2003-01-01	600000	\N	2003-01-01	90001	\N	\N	f	Sales which are qualified	0
90003_5360.0_2000-01-01	536000	\N	2000-01-01	90003	\N	\N	f	Sales which are qualified	0
90003_7350.0_2003-04-01	735000	\N	2003-04-01	90003	\N	\N	f	Sales which are qualified	0
89999_2240.0_2000-02-01	224000	\N	2000-02-01	89999	\N	\N	f	Sales which are qualified	0
89999_3150.0_2001-02-01	315000	\N	2001-02-01	89999	\N	\N	f	Sales which are qualified	0
89999_3480.0_2004-08-01	348000	\N	2004-08-01	89999	\N	\N	f	Sales which are qualified	0
89999_6050.0_2014-05-06	605000	\N	2014-05-06	89999	\N	\N	f	Qual by exam of deed	0
89999_6120.0_2019-02-01	612000	\N	2019-02-01	89999	\N	\N	f	Qual by exam of deed	0
89999_6190.0_2017-11-22	619000	\N	2017-11-22	89999	\N	\N	f	Qual by exam of deed	0
90002_5060.0_2000-02-01	506000	\N	2000-02-01	90002	\N	\N	f	Sales which are qualified	0
90004_5060.0_2000-02-01	506000	\N	2000-02-01	90004	\N	\N	f	Sales which are qualified	0
90005_19000.0_2011-11-28	1900000	\N	2011-11-28	90005	\N	\N	f	Qual by exam of deed	0
90005_22000.0_2020-01-10	2200000	\N	2020-01-10	90005	\N	\N	f	Qual by exam of deed	0
90005_25000.0_2022-02-15	2500000	\N	2022-02-15	90005	\N	\N	f	Qual by exam of deed	0
90005_5170.0_2000-01-01	517000	\N	2000-01-01	90005	\N	\N	f	Sales which are qualified	0
90005_7250.0_2000-06-01	725000	\N	2000-06-01	90005	\N	\N	f	Sales which are qualified	0
90005_8200.0_2001-09-01	820000	\N	2001-09-01	90005	\N	\N	f	Sales which are qualified	0
82081_7450.0_2005-01-01	745000	\N	2005-01-01	82081	\N	\N	f	Sales which are qualified	0
82611_2900.0_2011-08-01	290000	\N	2011-08-01	82611	\N	\N	f	Qual by exam of deed	0
82085_9900.0_2011-06-07	990000	\N	2011-06-07	82085	\N	\N	f	Qual by exam of deed	0
82257_4270.0_2005-03-01	427000	\N	2005-03-01	82257	\N	\N	f	Sales which are qualified	0
82257_5600.0_2009-02-25	560000	\N	2009-02-25	82257	\N	\N	f	Qual by exam of deed	0
82257_7850.0_2018-07-16	785000	\N	2018-07-16	82257	\N	\N	f	Qual by exam of deed	0
82258_4340.0_2005-01-01	434000	\N	2005-01-01	82258	\N	\N	f	Sales which are qualified	0
82258_7350.0_2020-09-03	735000	\N	2020-09-03	82258	\N	\N	f	Qual by exam of deed	0
82258_7500.0_2018-12-17	750000	\N	2018-12-17	82258	\N	\N	f	Qual by exam of deed	0
82259_4510.0_2005-01-01	451000	\N	2005-01-01	82259	\N	\N	f	Sales which are qualified	0
82260_6200.0_2005-04-01	620000	\N	2005-04-01	82260	\N	\N	f	Sales which are qualified	0
82261_4650.0_2005-03-01	465000	\N	2005-03-01	82261	\N	\N	f	Sales which are qualified	0
82261_5100.0_2009-11-02	510000	\N	2009-11-02	82261	\N	\N	f	Qual by exam of deed	0
82261_8990.0_2022-04-27	899000	\N	2022-04-27	82261	\N	\N	f	Qual by exam of deed	0
82262_5170.0_2005-03-01	517000	\N	2005-03-01	82262	\N	\N	f	Sales which are qualified	0
82262_6500.0_2019-02-24	650000	\N	2019-02-24	82262	\N	\N	f	Qual by exam of deed	0
82263_5040.0_2005-03-01	504000	\N	2005-03-01	82263	\N	\N	f	Sales which are qualified	0
82263_6900.0_2019-05-21	690000	\N	2019-05-21	82263	\N	\N	f	Qual by exam of deed	0
82263_7100.0_2014-04-24	710000	\N	2014-04-24	82263	\N	\N	f	Qual by exam of deed	0
82264_4860.0_2005-03-01	486000	\N	2005-03-01	82264	\N	\N	f	Sales which are qualified	0
82264_6100.0_2005-03-01	610000	\N	2005-03-01	82264	\N	\N	f	Sales which are qualified	0
82265_6570.0_2005-03-01	657000	\N	2005-03-01	82265	\N	\N	t	Deeds that include more than one parcel	0
82265_7100.0_2005-06-01	710000	\N	2005-06-01	82265	\N	\N	f	Sales which are qualified	0
82265_7550.0_2018-08-31	755000	\N	2018-08-31	82265	\N	\N	f	Qual by exam of deed	0
82266_4750.0_2010-03-19	475000	\N	2010-03-19	82266	\N	\N	f	Qual by exam of deed	0
82477_3400.0_2008-08-01	340000	\N	2008-08-01	82477	\N	\N	f	Sales which are qualified	0
82477_3680.0_2005-02-01	368000	\N	2005-02-01	82477	\N	\N	f	Sales which are qualified	0
82477_5500.0_2022-06-16	550000	\N	2022-06-16	82477	\N	\N	f	Qual by exam of deed	0
82478_2420.0_2005-02-01	242000	\N	2005-02-01	82478	\N	\N	f	Sales which are qualified	0
82478_3100.0_2012-08-01	310000	\N	2012-08-01	82478	\N	\N	f	Qual by verifiable & documented evidence	0
82478_3750.0_2005-05-01	375000	\N	2005-05-01	82478	\N	\N	f	Sales which are qualified	0
82478_4170.0_2008-01-01	417000	\N	2008-01-01	82478	\N	\N	f	Sales which are qualified	0
82478_5410.0_2022-01-28	541000	\N	2022-01-28	82478	\N	\N	f	Qual by exam of deed	0
82479_2500.0_2010-04-20	250000	\N	2010-04-20	82479	\N	\N	f	Qual by exam of deed	0
82479_2555.0_2005-02-01	255500	\N	2005-02-01	82479	\N	\N	f	Sales which are qualified	0
82479_3990.0_2005-07-01	399000	\N	2005-07-01	82479	\N	\N	f	Sales which are qualified	0
88210_34000.0_2015-10-23	3400000	\N	2015-10-23	88210	\N	\N	f	Qual by exam of deed	0
88210_45000.0_2016-12-15	4500000	\N	2016-12-15	88210	\N	\N	f	Qual by exam of deed	0
88210_45750.0_2016-02-22	4575000	\N	2016-02-22	88210	\N	\N	f	Qual by exam of deed	0
88211_40000.0_2015-11-09	4000000	\N	2015-11-09	88211	\N	\N	f	Qual by exam of deed	0
88212_64000.0_2015-11-02	6400000	\N	2015-11-02	88212	\N	\N	f	Qual by exam of deed	0
88213_68000.0_2015-10-23	6800000	\N	2015-10-23	88213	\N	\N	f	Qual by exam of deed	0
88214_72000.0_2021-09-09	7200000	\N	2021-09-09	88214	\N	\N	f	Qual by exam of deed	0
88214_78000.0_2015-10-14	7800000	\N	2015-10-14	88214	\N	\N	f	Qual by exam of deed	0
88215_73350.0_2015-10-26	7335000	\N	2015-10-26	88215	\N	\N	f	Qual by exam of deed	0
88215_74500.0_2021-04-30	7450000	\N	2021-04-30	88215	\N	\N	f	Qual by exam of deed	0
88216_67500.0_2020-05-28	6750000	\N	2020-05-28	88216	\N	\N	f	Qual by exam of deed	0
88216_78650.0_2015-10-26	7865000	\N	2015-10-26	88216	\N	\N	f	Qual by exam of deed	0
88217_84000.0_2015-10-23	8400000	\N	2015-10-23	88217	\N	\N	f	Qual by exam of deed	0
88218_75000.0_2019-09-24	7500000	\N	2019-09-24	88218	\N	\N	f	Qual by exam of deed	0
88218_89000.0_2015-10-13	8900000	\N	2015-10-13	88218	\N	\N	f	Qual by exam of deed	0
82604_4055.0_2005-01-01	405500	\N	2005-01-01	82604	\N	\N	f	Sales which are qualified	0
82604_5100.0_2014-03-05	510000	\N	2014-03-05	82604	\N	\N	f	Qual by exam of deed	0
82604_5850.0_2016-06-27	585000	\N	2016-06-27	82604	\N	\N	f	Qual by exam of deed	0
79857_10656.38_2010-07-29	1065638	\N	2010-07-29	79857	\N	\N	f	Qual by exam of deed	0
79859_12200.0_2010-06-01	1220000	\N	2010-06-01	79859	\N	\N	f	Qual by exam of deed	0
79859_26000.0_2019-12-20	2600000	\N	2019-12-20	79859	\N	\N	f	Qual by exam of deed	0
79860_11206.0_2010-01-28	1120600	\N	2010-01-28	79860	\N	\N	f	Qual by exam of deed	0
79861_11297.55_2010-06-15	1129755	\N	2010-06-15	79861	\N	\N	f	Qual by exam of deed	0
79861_15250.0_2011-06-17	1525000	\N	2011-06-17	79861	\N	\N	f	Qual by exam of deed	0
79862_11389.4_2010-01-20	1138940	\N	2010-01-20	79862	\N	\N	f	Qual by exam of deed	0
79863_11297.55_2010-03-24	1129755	\N	2010-03-24	79863	\N	\N	f	Qual by exam of deed	0
79863_13000.0_2013-01-03	1300000	\N	2013-01-03	79863	\N	\N	f	Qual by exam of deed	0
79863_13300.0_2010-06-03	1330000	\N	2010-06-03	79863	\N	\N	f	Qual by exam of deed	0
79864_11021.6_2009-12-17	1102160	\N	2009-12-17	79864	\N	\N	f	Qual by exam of deed	0
79865_11665.0_2010-01-04	1166500	\N	2010-01-04	79865	\N	\N	f	Qual by exam of deed	0
79865_18000.0_2012-06-26	1800000	\N	2012-06-26	79865	\N	\N	f	Qual by exam of deed	0
83207_36000.0_2021-03-26	3600000	\N	2021-03-26	83207	\N	\N	f	Qual by exam of deed	0
83208_55000.0_2019-12-13	5500000	\N	2019-12-13	83208	\N	\N	f	Qual by exam of deed	0
83208_55000.0_2022-04-25	5500000	\N	2022-04-25	83208	\N	\N	f	Qual by exam of deed	0
83209_58250.0_2019-11-21	5825000	\N	2019-11-21	83209	\N	\N	f	Qual by exam of deed	0
83211_57250.0_2020-03-31	5725000	\N	2020-03-31	83211	\N	\N	f	Qual by exam of deed	0
83212_62170.0_2019-12-30	6217000	\N	2019-12-30	83212	\N	\N	f	Qual by exam of deed	0
83213_57704.0_2019-11-25	5770400	\N	2019-11-25	83213	\N	\N	f	Qual by exam of deed	0
83213_60000.0_2021-06-11	6000000	\N	2021-06-11	83213	\N	\N	f	Qual by exam of deed	0
83214_61840.0_2019-12-03	6184000	\N	2019-12-03	83214	\N	\N	f	Qual by exam of deed	0
83214_61850.0_2021-04-22	6185000	\N	2021-04-22	83214	\N	\N	f	Qual by exam of deed	0
83214_65500.0_2023-03-09	6550000	\N	2023-03-09	83214	\N	\N	f	Qual by exam of deed	0
83215_53500.0_2020-12-18	5350000	\N	2020-12-18	83215	\N	\N	f	Qual by exam of deed	0
83217_75000.0_2020-01-22	7500000	\N	2020-01-22	83217	\N	\N	f	Qual by exam of deed	0
79806_115000.0_2020-11-28	11500000	\N	2020-11-28	79806	\N	\N	f	Qual by exam of deed	0
79806_115500.0_2015-11-20	11550000	\N	2015-11-20	79806	\N	\N	f	Qual by exam of deed	0
79807_117500.0_2015-09-25	11750000	\N	2015-09-25	79807	\N	\N	f	Qual by exam of deed	0
79807_130000.0_2017-12-21	13000000	\N	2017-12-21	79807	\N	\N	f	Qual by exam of deed	0
79807_155000.0_2022-05-04	15500000	\N	2022-05-04	79807	\N	\N	f	Qual by exam of deed	0
79808_105000.0_2015-09-01	10500000	\N	2015-09-01	79808	\N	\N	f	Qual by exam of deed	0
80368_9300.0_2005-02-01	930000	\N	2005-02-01	80368	\N	\N	t	Deeds that include more than one parcel	0
80369_4080.0_2005-02-01	408000	\N	2005-02-01	80369	\N	\N	f	Sales which are qualified	0
80375_3850.0_2005-02-01	385000	\N	2005-02-01	80375	\N	\N	f	Sales which are qualified	0
80375_7200.0_2015-11-06	720000	\N	2015-11-06	80375	\N	\N	f	Qual by exam of deed	0
80376_4250.0_2007-05-01	425000	\N	2007-05-01	80376	\N	\N	f	Sales which are qualified	0
80376_9700.0_2005-02-01	970000	\N	2005-02-01	80376	\N	\N	t	Deeds that include more than one parcel	0
80377_13250.0_2005-02-01	1325000	\N	2005-02-01	80377	\N	\N	t	Deeds that include more than one parcel	0
80378_11500.0_2005-03-01	1150000	\N	2005-03-01	80378	\N	\N	t	Deeds that include more than one parcel	0
80378_7000.0_2005-03-01	700000	\N	2005-03-01	80378	\N	\N	t	Deeds that include more than one parcel	0
80378_7500.0_2018-08-27	750000	\N	2018-08-27	80378	\N	\N	f	Qual by exam of deed	0
80379_3200.0_2005-03-01	320000	\N	2005-03-01	80379	\N	\N	f	Sales which are qualified	0
80379_4100.0_2005-03-01	410000	\N	2005-03-01	80379	\N	\N	f	Sales which are qualified	0
80379_7200.0_2015-05-11	720000	\N	2015-05-11	80379	\N	\N	f	Qual by exam of deed	0
80382_5000.0_2005-03-01	500000	\N	2005-03-01	80382	\N	\N	f	Sales which are qualified	0
80383_3700.0_2011-07-20	370000	\N	2011-07-20	80383	\N	\N	f	Qual by exam of deed	0
80383_3900.0_2005-03-01	390000	\N	2005-03-01	80383	\N	\N	f	Sales which are qualified	0
80383_4500.0_2005-03-01	450000	\N	2005-03-01	80383	\N	\N	f	Sales which are qualified	0
80383_7460.0_2015-05-11	746000	\N	2015-05-11	80383	\N	\N	f	Qual by exam of deed	0
80384_3970.0_2005-03-01	397000	\N	2005-03-01	80384	\N	\N	f	Sales which are qualified	0
80384_7250.0_2017-11-20	725000	\N	2017-11-20	80384	\N	\N	f	Qual by exam of deed	0
80385_3000.0_2005-03-01	300000	\N	2005-03-01	80385	\N	\N	f	Sales which are qualified	0
80386_4350.0_2005-04-01	435000	\N	2005-04-01	80386	\N	\N	f	Sales which are qualified	0
80387_4540.0_2005-04-01	454000	\N	2005-04-01	80387	\N	\N	f	Sales which are qualified	0
80388_4120.0_2011-04-16	412000	\N	2011-04-16	80388	\N	\N	f	Qual by exam of deed	0
80388_4180.0_2005-03-01	418000	\N	2005-03-01	80388	\N	\N	f	Sales which are qualified	0
80389_4400.0_2005-04-01	440000	\N	2005-04-01	80389	\N	\N	f	Sales which are qualified	0
80390_4400.0_2005-04-01	440000	\N	2005-04-01	80390	\N	\N	f	Sales which are qualified	0
80391_4290.0_2005-04-01	429000	\N	2005-04-01	80391	\N	\N	f	Sales which are qualified	0
80391_4600.0_2012-06-01	460000	\N	2012-06-01	80391	\N	\N	f	Qual by exam of deed	0
80391_7830.0_2015-05-07	783000	\N	2015-05-07	80391	\N	\N	f	Qual by exam of deed	0
80420_3784.8_2005-07-01	378480	\N	2005-07-01	80420	\N	\N	f	Sales which are qualified	0
80420_4380.0_2012-06-12	438000	\N	2012-06-12	80420	\N	\N	f	Qual by exam of deed	0
80420_5350.0_2006-07-01	535000	\N	2006-07-01	80420	\N	\N	f	Sales which are qualified	0
80421_14000.0_2005-06-01	1400000	\N	2005-06-01	80421	\N	\N	t	Deeds that include more than one parcel	0
80422_4100.0_2005-07-01	410000	\N	2005-07-01	80422	\N	\N	f	Sales which are qualified	0
80422_5750.0_2013-09-20	575000	\N	2013-09-20	80422	\N	\N	f	Qual by exam of deed	0
80423_4750.0_2005-05-01	475000	\N	2005-05-01	80423	\N	\N	f	Sales which are qualified	0
80424_5300.0_2005-06-01	530000	\N	2005-06-01	80424	\N	\N	f	Sales which are qualified	0
80425_5000.0_2005-06-01	500000	\N	2005-06-01	80425	\N	\N	f	Sales which are qualified	0
80426_9300.0_2005-02-01	930000	\N	2005-02-01	80426	\N	\N	t	Deeds that include more than one parcel	0
80427_13000.0_2017-03-02	1300000	\N	2017-03-02	80427	\N	\N	f	Qual by exam of deed	0
80427_7650.0_2005-02-01	765000	\N	2005-02-01	80427	\N	\N	f	Sales which are qualified	0
80428_9000.0_2005-03-01	900000	\N	2005-03-01	80428	\N	\N	f	Sales which are qualified	0
80429_5161.5_2005-02-01	516150	\N	2005-02-01	80429	\N	\N	f	Sales which are qualified	0
80429_6500.0_2008-02-01	650000	\N	2008-02-01	80429	\N	\N	f	Sales which are qualified	0
80429_7750.0_2005-06-01	775000	\N	2005-06-01	80429	\N	\N	f	Sales which are qualified	0
80430_7000.0_2005-04-01	700000	\N	2005-04-01	80430	\N	\N	f	Sales which are qualified	0
80431_6500.0_2011-04-11	650000	\N	2011-04-11	80431	\N	\N	f	Qual by exam of deed	0
80431_8000.0_2005-03-01	800000	\N	2005-03-01	80431	\N	\N	f	Sales which are qualified	0
80432_5550.0_2005-03-01	555000	\N	2005-03-01	80432	\N	\N	f	Sales which are qualified	0
80432_5550.0_2012-11-08	555000	\N	2012-11-08	80432	\N	\N	f	Qual by exam of deed	0
52300_25000.0_2015-07-27	2500000	\N	2015-07-27	52300	\N	\N	f	Qual by exam of deed	0
52300_4200.0_2001-03-01	420000	\N	2001-03-01	52300	\N	\N	f	Sales which are qualified	0
52300_4200.0_2002-03-01	420000	\N	2002-03-01	52300	\N	\N	f	Sales which are qualified	0
52301_3300.0_2001-04-01	330000	\N	2001-04-01	52301	\N	\N	f	Sales which are qualified	0
52301_3680.0_2001-04-01	368000	\N	2001-04-01	52301	\N	\N	f	Sales which are qualified	0
52301_8200.0_2008-08-18	820000	\N	2008-08-18	52301	\N	\N	f	Sales which are qualified	0
52302_16750.0_2019-04-02	1675000	\N	2019-04-02	52302	\N	\N	f	Qual by exam of deed	0
52302_3780.0_2001-04-01	378000	\N	2001-04-01	52302	\N	\N	f	Sales which are qualified	0
52303_3600.0_2002-08-01	360000	\N	2002-08-01	52303	\N	\N	f	Sales which are qualified	0
52304_2480.0_2001-03-01	248000	\N	2001-03-01	52304	\N	\N	f	Sales which are qualified	0
52304_3150.0_2001-05-01	315000	\N	2001-05-01	52304	\N	\N	f	Sales which are qualified	0
52306_2580.0_2001-02-01	258000	\N	2001-02-01	52306	\N	\N	f	Sales which are qualified	0
52306_9375.0_2019-06-26	937500	\N	2019-06-26	52306	\N	\N	f	Qual by exam of deed	0
52307_3200.0_2001-02-01	320000	\N	2001-02-01	52307	\N	\N	f	Sales which are qualified	0
52307_4000.0_2001-09-01	400000	\N	2001-09-01	52307	\N	\N	f	Sales which are qualified	0
52307_9550.0_2020-11-12	955000	\N	2020-11-12	52307	\N	\N	f	Qual by exam of deed	0
52308_4010.0_2001-03-01	401000	\N	2001-03-01	52308	\N	\N	f	Sales which are qualified	0
52309_3680.0_2001-04-01	368000	\N	2001-04-01	52309	\N	\N	f	Sales which are qualified	0
52309_4790.0_2001-05-01	479000	\N	2001-05-01	52309	\N	\N	f	Sales which are qualified	0
52309_7600.0_2004-07-01	760000	\N	2004-07-01	52309	\N	\N	f	Sales which are qualified	0
52309_8550.0_2010-12-17	855000	\N	2010-12-17	52309	\N	\N	f	Qual by exam of deed	0
52310_15125.0_2017-08-15	1512500	\N	2017-08-15	52310	\N	\N	f	Qual by exam of deed	0
52310_5250.0_2001-03-01	525000	\N	2001-03-01	52310	\N	\N	f	Sales which are qualified	0
88307_29900.0_2018-06-20	2990000	\N	2018-06-20	88307	\N	\N	f	Qual by exam of deed	0
88310_13300.0_2018-06-15	1330000	\N	2018-06-15	88310	\N	\N	f	Qual by exam of deed	0
88311_16250.0_2021-05-27	1625000	\N	2021-05-27	88311	\N	\N	f	Qual by exam of deed	0
88311_16400.0_2018-06-15	1640000	\N	2018-06-15	88311	\N	\N	f	Qual by exam of deed	0
88315_16000.0_2018-06-11	1600000	\N	2018-06-11	88315	\N	\N	f	Qual by exam of deed	0
88315_17250.0_2022-08-11	1725000	\N	2022-08-11	88315	\N	\N	f	Qual by exam of deed	0
88316_18250.0_2018-06-21	1825000	\N	2018-06-21	88316	\N	\N	f	Qual by exam of deed	0
88316_20000.0_2019-02-26	2000000	\N	2019-02-26	88316	\N	\N	f	Qual by exam of deed	0
88317_12221.0_2023-05-23	1222100	\N	2023-05-23	88317	\N	\N	f	Qual by exam of deed	0
88317_14750.0_2018-06-11	1475000	\N	2018-06-11	88317	\N	\N	f	Qual by exam of deed	0
88317_18000.0_2021-12-17	1800000	\N	2021-12-17	88317	\N	\N	f	Qual by exam of deed	0
88318_29400.0_2021-04-15	2940000	\N	2021-04-15	88318	\N	\N	f	Qual by exam of deed	0
88318_37000.0_2018-06-11	3700000	\N	2018-06-11	88318	\N	\N	f	Qual by exam of deed	0
88319_32500.0_2018-06-18	3250000	\N	2018-06-18	88319	\N	\N	f	Qual by exam of deed	0
88322_20250.0_2018-09-10	2025000	\N	2018-09-10	88322	\N	\N	f	Qual by exam of deed	0
88323_58000.0_2018-06-19	5800000	\N	2018-06-19	88323	\N	\N	f	Qual by exam of deed	0
52529_7800.0_2002-10-01	780000	\N	2002-10-01	52529	\N	\N	f	Sales which are qualified	0
52666_15600.0_2023-05-03	1560000	\N	2023-05-03	52666	\N	\N	f	Qual by exam of deed	0
52666_3450.0_1996-04-01	345000	\N	1996-04-01	52666	\N	\N	f	Sales which are qualified	0
52666_3700.0_1999-05-01	370000	\N	1999-05-01	52666	\N	\N	f	Sales which are qualified	0
52666_4000.0_2000-04-01	400000	\N	2000-04-01	52666	\N	\N	f	Sales which are qualified	0
52666_9300.0_2013-11-25	930000	\N	2013-11-25	52666	\N	\N	f	Qual by exam of deed	0
52667_11500.0_2019-03-27	1150000	\N	2019-03-27	52667	\N	\N	f	Qual by exam of deed	0
52667_2670.0_1996-08-01	267000	\N	1996-08-01	52667	\N	\N	f	Sales which are qualified	0
52667_2675.0_1996-10-01	267500	\N	1996-10-01	52667	\N	\N	f	Sales which are qualified	0
52667_8800.0_2015-05-11	880000	\N	2015-05-11	52667	\N	\N	f	Qual by exam of deed	0
52668_3500.0_1996-02-01	350000	\N	1996-02-01	52668	\N	\N	f	Sales which are qualified	0
52668_4450.0_2003-02-01	445000	\N	2003-02-01	52668	\N	\N	f	Sales which are qualified	0
52668_9500.0_2023-01-10	950000	\N	2023-01-10	52668	\N	\N	f	Qual by exam of deed	0
52669_1600.0_1995-12-01	160000	\N	1995-12-01	52669	\N	\N	f	Sales which are qualified	0
52670_2300.0_1997-01-01	230000	\N	1997-01-01	52670	\N	\N	f	Sales which are qualified	0
52670_3800.0_2004-02-01	380000	\N	2004-02-01	52670	\N	\N	f	Sales which are qualified	0
52670_6050.0_2014-11-20	605000	\N	2014-11-20	52670	\N	\N	f	Qual by exam of deed	0
52671_1810.0_1996-03-01	181000	\N	1996-03-01	52671	\N	\N	f	Sales which are qualified	0
52671_7250.0_2022-08-31	725000	\N	2022-08-31	52671	\N	\N	f	Qual by exam of deed	0
52672_2250.0_1995-12-01	225000	\N	1995-12-01	52672	\N	\N	f	Sales which are qualified	0
52673_2030.0_1995-12-01	203000	\N	1995-12-01	52673	\N	\N	f	Sales which are qualified	0
52673_2200.0_1999-07-01	220000	\N	1999-07-01	52673	\N	\N	f	Sales which are qualified	0
52673_3400.0_2002-08-01	340000	\N	2002-08-01	52673	\N	\N	f	Sales which are qualified	0
52673_5050.0_2012-12-13	505000	\N	2012-12-13	52673	\N	\N	f	Qual by exam of deed	0
52673_9200.0_2016-02-12	920000	\N	2016-02-12	52673	\N	\N	f	Qual by exam of deed	0
52674_3400.0_1999-02-01	340000	\N	1999-02-01	52674	\N	\N	f	Sales which are qualified	0
52766_5500.0_2011-03-11	550000	\N	2011-03-11	52766	\N	\N	f	Qual by exam of deed	0
52766_9200.0_2021-03-15	920000	\N	2021-03-15	52766	\N	\N	f	Qual by exam of deed	0
52767_2150.0_1996-03-01	215000	\N	1996-03-01	52767	\N	\N	f	Sales which are qualified	0
52767_2350.0_1998-12-01	235000	\N	1998-12-01	52767	\N	\N	f	Sales which are qualified	0
52768_2460.0_1995-12-01	246000	\N	1995-12-01	52768	\N	\N	f	Sales which are qualified	0
52768_7650.0_2006-04-01	765000	\N	2006-04-01	52768	\N	\N	f	Sales which are qualified	0
52769_2220.0_1997-07-01	222000	\N	1997-07-01	52769	\N	\N	f	Sales which are qualified	0
52769_2390.0_1996-02-01	239000	\N	1996-02-01	52769	\N	\N	f	Sales which are qualified	0
52783_2100.0_1996-03-01	210000	\N	1996-03-01	52783	\N	\N	f	Sales which are qualified	0
52804_3590.0_1996-01-01	359000	\N	1996-01-01	52804	\N	\N	f	Sales which are qualified	0
83080_1.0_2014-03-30	100	\N	2014-03-30	83080	\N	\N	t	Qual by exam of deed	0
52872_4250.0_2002-09-01	425000	\N	2002-09-01	52872	\N	\N	f	Sales which are qualified	0
52872_5000.0_2009-01-27	500000	\N	2009-01-27	52872	\N	\N	f	Qual by exam of deed	0
52872_5700.0_2008-05-01	570000	\N	2008-05-01	52872	\N	\N	f	Sales which are qualified	0
52872_9290.0_2022-06-16	929000	\N	2022-06-16	52872	\N	\N	f	Qual by exam of deed	0
52873_3230.0_1996-03-01	323000	\N	1996-03-01	52873	\N	\N	f	Sales which are qualified	0
52873_4950.0_2004-07-01	495000	\N	2004-07-01	52873	\N	\N	f	Sales which are qualified	0
52873_9000.0_2015-05-22	900000	\N	2015-05-22	52873	\N	\N	f	Qual by exam of deed	0
52873_9800.0_2022-06-07	980000	\N	2022-06-07	52873	\N	\N	f	Qual by exam of deed	0
52875_2313.0_1995-08-01	231300	\N	1995-08-01	52875	\N	\N	f	Sales which are qualified	0
52876_2575.0_1995-10-01	257500	\N	1995-10-01	52876	\N	\N	f	Sales which are qualified	0
52877_3754.0_1995-11-01	375400	\N	1995-11-01	52877	\N	\N	f	Sales which are qualified	0
52877_6480.0_1999-09-01	648000	\N	1999-09-01	52877	\N	\N	f	Sales which are qualified	0
52877_7900.0_2001-08-01	790000	\N	2001-08-01	52877	\N	\N	f	Sales which are qualified	0
52877_8500.0_2003-04-01	850000	\N	2003-04-01	52877	\N	\N	f	Sales which are qualified	0
52878_2500.0_1995-11-01	250000	\N	1995-11-01	52878	\N	\N	f	Sales which are qualified	0
52878_4300.0_2003-02-01	430000	\N	2003-02-01	52878	\N	\N	f	Sales which are qualified	0
52879_2350.0_1995-11-01	235000	\N	1995-11-01	52879	\N	\N	f	Sales which are qualified	0
52879_2700.0_1998-03-01	270000	\N	1998-03-01	52879	\N	\N	f	Sales which are qualified	0
52879_6100.0_2012-04-30	610000	\N	2012-04-30	52879	\N	\N	f	Qual by exam of deed	0
52879_8750.0_2019-04-12	875000	\N	2019-04-12	52879	\N	\N	f	Qual by exam of deed	0
52880_24000.0_2015-06-08	2400000	\N	2015-06-08	52880	\N	\N	f	Qual by exam of deed	0
52880_5000.0_1995-08-01	500000	\N	1995-08-01	52880	\N	\N	f	Sales which are qualified	0
52881_2350.0_1997-01-01	235000	\N	1997-01-01	52881	\N	\N	f	Sales which are qualified	0
52881_2355.0_1999-05-01	235500	\N	1999-05-01	52881	\N	\N	f	Sales which are qualified	0
52882_2400.0_1996-06-01	240000	\N	1996-06-01	52882	\N	\N	f	Sales which are qualified	0
52882_5570.0_2005-03-01	557000	\N	2005-03-01	52882	\N	\N	f	Sales which are qualified	0
52882_5950.0_2010-03-01	595000	\N	2010-03-01	52882	\N	\N	f	Qual by exam of deed	0
52887_2112.0_1995-10-01	211200	\N	1995-10-01	52887	\N	\N	f	Sales which are qualified	0
52887_2450.0_1997-11-01	245000	\N	1997-11-01	52887	\N	\N	f	Sales which are qualified	0
52888_5200.0_1995-11-01	520000	\N	1995-11-01	52888	\N	\N	f	Sales which are qualified	0
52888_6170.0_1998-09-01	617000	\N	1998-09-01	52888	\N	\N	f	Sales which are qualified	0
52889_14700.0_2022-04-14	1470000	\N	2022-04-14	52889	\N	\N	f	Qual by exam of deed	0
52889_2680.0_1995-09-01	268000	\N	1995-09-01	52889	\N	\N	f	Sales which are qualified	0
52889_4750.0_2003-07-01	475000	\N	2003-07-01	52889	\N	\N	f	Sales which are qualified	0
52939_11500.0_2008-05-01	1150000	\N	2008-05-01	52939	\N	\N	f	Sales which are qualified	0
52939_12000.0_2007-01-01	1200000	\N	2007-01-01	52939	\N	\N	f	Sales which are qualified	0
52940_10000.0_2006-12-01	1000000	\N	2006-12-01	52940	\N	\N	f	Sales which are qualified	0
52941_9400.0_2006-12-01	940000	\N	2006-12-01	52941	\N	\N	f	Sales which are qualified	0
52942_12500.0_2021-06-01	1250000	\N	2021-06-01	52942	\N	\N	f	Qual by exam of deed	0
52942_9460.0_2006-12-01	946000	\N	2006-12-01	52942	\N	\N	f	Sales which are qualified	0
52942_9750.0_2007-04-01	975000	\N	2007-04-01	52942	\N	\N	f	Sales which are qualified	0
52943_10250.0_2006-12-01	1025000	\N	2006-12-01	52943	\N	\N	f	Sales which are qualified	0
52943_13132.0_2017-09-25	1313200	\N	2017-09-25	52943	\N	\N	f	Qual by exam of deed	0
52943_13250.0_2020-07-28	1325000	\N	2020-07-28	52943	\N	\N	f	Qual by exam of deed	0
52943_7800.0_2009-12-16	780000	\N	2009-12-16	52943	\N	\N	f	Qual by exam of deed	0
52944_13750.0_2007-01-01	1375000	\N	2007-01-01	52944	\N	\N	f	Sales which are qualified	0
52944_16850.0_2007-04-01	1685000	\N	2007-04-01	52944	\N	\N	f	Sales which are qualified	0
52945_12450.0_2001-12-01	1245000	\N	2001-12-01	52945	\N	\N	f	Sales which are qualified	0
52945_16150.0_2013-12-19	1615000	\N	2013-12-19	52945	\N	\N	f	Qual by exam of deed	0
52945_17000.0_2020-10-30	1700000	\N	2020-10-30	52945	\N	\N	f	Qual by exam of deed	0
52945_25000.0_2015-02-25	2500000	\N	2015-02-25	52945	\N	\N	f	Qual by exam of deed	0
52946_7500.0_2010-04-14	750000	\N	2010-04-14	52946	\N	\N	f	Qual by exam of deed	0
52946_9950.0_2006-12-01	995000	\N	2006-12-01	52946	\N	\N	f	Sales which are qualified	0
52947_10750.0_2013-05-16	1075000	\N	2013-05-16	52947	\N	\N	f	Qual by exam of deed	0
52947_11500.0_2021-03-05	1150000	\N	2021-03-05	52947	\N	\N	f	Qual by exam of deed	0
52947_9850.0_2006-12-01	985000	\N	2006-12-01	52947	\N	\N	f	Sales which are qualified	0
52948_12850.0_2015-09-30	1285000	\N	2015-09-30	52948	\N	\N	f	Qual by exam of deed	0
52948_13850.0_2021-03-15	1385000	\N	2021-03-15	52948	\N	\N	f	Qual by exam of deed	0
52948_6750.0_2009-09-29	675000	\N	2009-09-29	52948	\N	\N	f	Qual by exam of deed	0
52948_7200.0_2011-05-10	720000	\N	2011-05-10	52948	\N	\N	f	Qual by exam of deed	0
52948_9001.0_2007-01-01	900100	\N	2007-01-01	52948	\N	\N	f	Sales which are qualified	0
52948_9700.0_2007-01-01	970000	\N	2007-01-01	52948	\N	\N	f	Sales which are qualified	0
52949_10500.0_2007-01-01	1050000	\N	2007-01-01	52949	\N	\N	f	Sales which are qualified	0
52949_9000.0_2009-05-13	900000	\N	2009-05-13	52949	\N	\N	f	Qual by exam of deed	0
52950_13950.0_2006-12-01	1395000	\N	2006-12-01	52950	\N	\N	f	Sales which are qualified	0
52950_15250.0_2007-10-01	1525000	\N	2007-10-01	52950	\N	\N	f	Sales which are qualified	0
53029_48000.0_2019-09-11	4800000	\N	2019-09-11	53029	\N	\N	f	Qual by exam of deed	0
53030_35000.0_2020-01-21	3500000	\N	2020-01-21	53030	\N	\N	f	Qual by exam of deed	0
53030_50750.0_2023-06-26	5075000	\N	2023-06-26	53030	\N	\N	f	Qual by exam of deed	0
53034_26350.0_2019-10-03	2635000	\N	2019-10-03	53034	\N	\N	f	Qual by exam of deed	0
53037_42000.0_2020-06-30	4200000	\N	2020-06-30	53037	\N	\N	f	Qual by exam of deed	0
53044_18500.0_2019-11-08	1850000	\N	2019-11-08	53044	\N	\N	f	Qual by exam of deed	0
53048_26070.0_2019-10-10	2607000	\N	2019-10-10	53048	\N	\N	f	Qual by exam of deed	0
53049_13100.0_2019-10-04	1310000	\N	2019-10-04	53049	\N	\N	f	Qual by exam of deed	0
53141_3550.0_2011-04-04	355000	\N	2011-04-04	53141	\N	\N	f	Qual by exam of deed	0
53141_7750.0_2022-04-05	775000	\N	2022-04-05	53141	\N	\N	f	Qual by exam of deed	0
53143_4400.0_2011-12-30	440000	\N	2011-12-30	53143	\N	\N	f	Qual by exam of deed	0
53143_5650.0_2013-07-17	565000	\N	2013-07-17	53143	\N	\N	f	Qual by exam of deed	0
53143_6500.0_2021-11-04	650000	\N	2021-11-04	53143	\N	\N	f	Qual by exam of deed	0
53144_4000.0_2010-10-18	400000	\N	2010-10-18	53144	\N	\N	f	Qual by exam of deed	0
53146_4000.0_2010-10-18	400000	\N	2010-10-18	53146	\N	\N	f	Qual by exam of deed	0
53147_4432.0_2011-09-23	443200	\N	2011-09-23	53147	\N	\N	f	Qual by exam of deed	0
53150_4000.0_2010-10-18	400000	\N	2010-10-18	53150	\N	\N	f	Qual by exam of deed	0
53151_4000.0_2011-03-18	400000	\N	2011-03-18	53151	\N	\N	f	Qual by exam of deed	0
53152_4000.0_2010-10-18	400000	\N	2010-10-18	53152	\N	\N	f	Qual by exam of deed	0
53153_4000.0_2011-03-15	400000	\N	2011-03-15	53153	\N	\N	f	Qual by exam of deed	0
53154_4000.0_2010-10-18	400000	\N	2010-10-18	53154	\N	\N	f	Qual by exam of deed	0
53155_4300.0_2012-02-22	430000	\N	2012-02-22	53155	\N	\N	f	Qual by exam of deed	0
53155_5400.0_2018-04-02	540000	\N	2018-04-02	53155	\N	\N	f	Qual by exam of deed	0
53155_5900.0_2021-06-29	590000	\N	2021-06-29	53155	\N	\N	f	Qual by exam of deed	0
53156_4000.0_2010-10-18	400000	\N	2010-10-18	53156	\N	\N	f	Qual by exam of deed	0
53156_5700.0_2017-04-27	570000	\N	2017-04-27	53156	\N	\N	f	Qual by exam of deed	0
53156_5900.0_2021-03-05	590000	\N	2021-03-05	53156	\N	\N	f	Qual by exam of deed	0
53156_7750.0_2021-11-15	775000	\N	2021-11-15	53156	\N	\N	f	Qual by exam of deed	0
53158_4000.0_2010-10-18	400000	\N	2010-10-18	53158	\N	\N	f	Qual by exam of deed	0
53158_5280.0_2018-10-29	528000	\N	2018-10-29	53158	\N	\N	f	Qual by exam of deed	0
53159_4200.0_2011-10-31	420000	\N	2011-10-31	53159	\N	\N	f	Qual by exam of deed	0
53159_7550.0_2023-03-10	755000	\N	2023-03-10	53159	\N	\N	f	Qual by exam of deed	0
53160_4000.0_2010-10-18	400000	\N	2010-10-18	53160	\N	\N	f	Qual by exam of deed	0
53160_5300.0_2018-02-08	530000	\N	2018-02-08	53160	\N	\N	f	Qual by exam of deed	0
53161_4380.0_2012-03-01	438000	\N	2012-03-01	53161	\N	\N	f	Qual by exam of deed	0
53162_4000.0_2010-10-18	400000	\N	2010-10-18	53162	\N	\N	f	Qual by exam of deed	0
53162_5100.0_2019-03-22	510000	\N	2019-03-22	53162	\N	\N	f	Qual by exam of deed	0
53259_10500.0_2013-02-22	1050000	\N	2013-02-22	53259	\N	\N	f	Qual by exam of deed	0
53259_11500.0_2007-02-01	1150000	\N	2007-02-01	53259	\N	\N	f	Sales which are qualified	0
53259_15000.0_2017-09-19	1500000	\N	2017-09-19	53259	\N	\N	f	Qual by exam of deed	0
53259_7430.0_2005-11-01	743000	\N	2005-11-01	53259	\N	\N	f	Sales which are qualified	0
53259_8250.0_2010-07-13	825000	\N	2010-07-13	53259	\N	\N	f	Qual by exam of deed	0
53260_8150.0_2005-11-01	815000	\N	2005-11-01	53260	\N	\N	f	Sales which are qualified	0
53261_16200.0_2005-10-01	1620000	\N	2005-10-01	53261	\N	\N	f	Sales which are qualified	0
53261_37000.0_2021-04-12	3700000	\N	2021-04-12	53261	\N	\N	f	Qual by exam of deed	0
53262_18000.0_2009-10-15	1800000	\N	2009-10-15	53262	\N	\N	f	Qual by exam of deed	0
53290_9300.0_2005-12-01	930000	\N	2005-12-01	53290	\N	\N	f	Sales which are qualified	0
53374_3000.0_2009-08-26	300000	\N	2009-08-26	53374	\N	\N	f	Qual by exam of deed	0
53374_3500.0_2020-08-11	350000	\N	2020-08-11	53374	\N	\N	f	Qual by exam of deed	0
53374_5438.0_2022-10-14	543800	\N	2022-10-14	53374	\N	\N	f	Qual by exam of deed	0
53376_9150.0_2018-10-13	915000	\N	2018-10-13	53376	\N	\N	f	Qual by exam of deed	0
53377_11500.0_2008-12-19	1150000	\N	2008-12-19	53377	\N	\N	f	Sales which are qualified	0
53377_14500.0_2021-06-23	1450000	\N	2021-06-23	53377	\N	\N	f	Qual by exam of deed	0
53378_4800.0_2011-06-21	480000	\N	2011-06-21	53378	\N	\N	f	Qual by exam of deed	0
53378_6700.0_2008-11-06	670000	\N	2008-11-06	53378	\N	\N	f	Sales which are qualified	0
53379_4450.0_2012-07-30	445000	\N	2012-07-30	53379	\N	\N	f	Qual by exam of deed	0
53380_4175.0_2012-07-13	417500	\N	2012-07-13	53380	\N	\N	f	Qual by exam of deed	0
53381_4085.0_2011-04-15	408500	\N	2011-04-15	53381	\N	\N	f	Qual by exam of deed	0
53381_4450.0_2012-03-05	445000	\N	2012-03-05	53381	\N	\N	f	Qual by exam of deed	0
53381_5583.0_2018-04-26	558300	\N	2018-04-26	53381	\N	\N	f	Qual by exam of deed	0
53381_6060.0_2014-06-25	606000	\N	2014-06-25	53381	\N	\N	f	Qual by exam of deed	0
53381_7400.0_2013-08-19	740000	\N	2013-08-19	53381	\N	\N	f	Qual by exam of deed	0
53382_4450.0_2012-04-09	445000	\N	2012-04-09	53382	\N	\N	f	Qual by exam of deed	0
53382_5990.0_2014-05-22	599000	\N	2014-05-22	53382	\N	\N	f	Qual by exam of deed	0
53383_4360.0_2012-06-28	436000	\N	2012-06-28	53383	\N	\N	f	Qual by exam of deed	0
53384_4400.0_2012-06-28	440000	\N	2012-06-28	53384	\N	\N	f	Qual by exam of deed	0
53384_5090.0_2018-04-24	509000	\N	2018-04-24	53384	\N	\N	f	Qual by exam of deed	0
53386_5568.0_2010-01-14	556800	\N	2010-01-14	53386	\N	\N	f	Qual by exam of deed	0
53386_8150.0_2021-05-14	815000	\N	2021-05-14	53386	\N	\N	f	Qual by exam of deed	0
53387_3050.0_2010-04-13	305000	\N	2010-04-13	53387	\N	\N	f	Qual by exam of deed	0
53387_3550.0_2019-11-26	355000	\N	2019-11-26	53387	\N	\N	f	Qual by exam of deed	0
53387_6250.0_2023-04-07	625000	\N	2023-04-07	53387	\N	\N	f	Qual by exam of deed	0
53388_2835.0_2010-03-15	283500	\N	2010-03-15	53388	\N	\N	f	Qual by exam of deed	0
53388_3030.0_2012-01-03	303000	\N	2012-01-03	53388	\N	\N	f	Qual by exam of deed	0
53388_3990.0_2021-12-15	399000	\N	2021-12-15	53388	\N	\N	f	Qual by exam of deed	0
53389_2800.0_2010-04-19	280000	\N	2010-04-19	53389	\N	\N	f	Qual by exam of deed	0
53390_4380.0_2011-04-11	438000	\N	2011-04-11	53390	\N	\N	f	Qual by exam of deed	0
53392_4120.0_2011-06-08	412000	\N	2011-06-08	53392	\N	\N	f	Qual by exam of deed	0
53392_4500.0_2008-11-19	450000	\N	2008-11-19	53392	\N	\N	f	Sales which are qualified	0
53395_6500.0_2010-04-09	650000	\N	2010-04-09	53395	\N	\N	f	Qual by exam of deed	0
53396_13000.0_2021-05-20	1300000	\N	2021-05-20	53396	\N	\N	f	Qual by exam of deed	0
53396_6340.0_2009-05-27	634000	\N	2009-05-27	53396	\N	\N	f	Qual by exam of deed	0
53397_6200.0_2010-01-12	620000	\N	2010-01-12	53397	\N	\N	f	Qual by exam of deed	0
53398_5600.0_2010-12-15	560000	\N	2010-12-15	53398	\N	\N	f	Qual by exam of deed	0
82981_13450.0_2011-08-22	1345000	\N	2011-08-22	82981	\N	\N	f	Qual by exam of deed	0
82983_12700.0_2020-02-20	1270000	\N	2020-02-20	82983	\N	\N	f	Qual by exam of deed	0
82983_14200.0_2009-02-17	1420000	\N	2009-02-17	82983	\N	\N	f	Qual by exam of deed	0
82983_17000.0_2014-05-16	1700000	\N	2014-05-16	82983	\N	\N	f	Qual by exam of deed	0
82984_13250.0_2021-05-14	1325000	\N	2021-05-14	82984	\N	\N	f	Qual by exam of deed	0
82984_13400.0_2021-12-29	1340000	\N	2021-12-29	82984	\N	\N	f	Qual by exam of deed	0
83077_8850.0_2009-08-04	885000	\N	2009-08-04	83077	\N	\N	f	Qual by exam of deed	0
82606_3650.0_2011-01-14	365000	\N	2011-01-14	82606	\N	\N	f	Qual by exam of deed	0
82607_5150.0_2020-08-12	515000	\N	2020-08-12	82607	\N	\N	f	Qual by exam of deed	0
82607_5200.0_2008-04-01	520000	\N	2008-04-01	82607	\N	\N	f	Sales which are qualified	0
82608_5250.0_2010-02-26	525000	\N	2010-02-26	82608	\N	\N	f	Qual by exam of deed	0
139412_2565.0_2000-11-01	256500	\N	2000-11-01	139412	\N	\N	f	Sales which are qualified	0
139412_2565.0_2002-06-01	256500	\N	2002-06-01	139412	\N	\N	f	Sales which are qualified	0
81331_2870.0_2000-05-01	287000	\N	2000-05-01	81331	\N	\N	f	Sales which are qualified	0
139412_5150.0_2018-08-31	515000	\N	2018-08-31	139412	\N	\N	f	Qual by exam of deed	0
81331_4050.0_2000-05-01	405000	\N	2000-05-01	81331	\N	\N	f	Sales which are qualified	0
139413_2300.0_1998-02-01	230000	\N	1998-02-01	139413	\N	\N	f	Sales which are qualified	0
81365_5100.0_2000-05-01	510000	\N	2000-05-01	81365	\N	\N	f	Sales which are qualified	0
129514_7300.0_2023-08-08	730000	\N	2023-08-08	129514	\N	\N	f	Qual by exam of deed	0
130530_3050.0_2023-08-21	305000	\N	2023-08-21	130530	\N	\N	f	Qual by exam of deed	0
139413_2880.0_1992-06-01	288000	\N	1992-06-01	139413	\N	\N	f	Sales which are qualified	0
34798_2500.0_2023-08-14	250000	\N	2023-08-14	34798	\N	\N	f	Qual by exam of deed	0
35916_8800.0_2023-08-07	880000	\N	2023-08-07	35916	\N	\N	f	Qual by exam of deed	0
128272_3230.0_2023-07-27	323000	\N	2023-07-27	128272	\N	\N	f	Qual by exam of deed	0
35201_3550.0_2016-08-15	355000	\N	2016-08-15	35201	\N	\N	f	Qual by exam of deed	0
88192_6000.0_2023-08-18	600000	\N	2023-08-18	88192	\N	\N	f	Qual by exam of deed	0
81283_5000.0_2000-05-01	500000	\N	2000-05-01	81283	\N	\N	f	Sales which are qualified	0
81290_4620.0_2000-09-01	462000	\N	2000-09-01	81290	\N	\N	t	Deeds that include more than one parcel	0
81290_5400.0_2001-02-01	540000	\N	2001-02-01	81290	\N	\N	f	Sales which are qualified	0
81295_12480.0_2013-04-09	1248000	\N	2013-04-09	81295	\N	\N	f	Qual by exam of deed	0
81295_4260.0_2001-03-01	426000	\N	2001-03-01	81295	\N	\N	f	Sales which are qualified	0
81311_21500.0_2014-05-21	2150000	\N	2014-05-21	81311	\N	\N	f	Qual by exam of deed	0
81311_7450.0_2000-09-01	745000	\N	2000-09-01	81311	\N	\N	f	Sales which are qualified	0
81332_3760.0_2000-09-01	376000	\N	2000-09-01	81332	\N	\N	f	Sales which are qualified	0
81363_13250.0_2007-03-01	1325000	\N	2007-03-01	81363	\N	\N	f	Sales which are qualified	0
81363_3830.0_2000-07-01	383000	\N	2000-07-01	81363	\N	\N	f	Sales which are qualified	0
81363_7000.0_2002-07-01	700000	\N	2002-07-01	81363	\N	\N	f	Sales which are qualified	0
81364_4040.0_2000-06-01	404000	\N	2000-06-01	81364	\N	\N	f	Sales which are qualified	0
81364_5000.0_2000-07-01	500000	\N	2000-07-01	81364	\N	\N	f	Sales which are qualified	0
81373_4310.0_2000-08-01	431000	\N	2000-08-01	81373	\N	\N	f	Sales which are qualified	0
81373_8100.0_2003-09-01	810000	\N	2003-09-01	81373	\N	\N	f	Sales which are qualified	0
81412_11500.0_2014-02-28	1150000	\N	2014-02-28	81412	\N	\N	f	Qual by exam of deed	0
81412_12650.0_2018-11-15	1265000	\N	2018-11-15	81412	\N	\N	f	Qual by exam of deed	0
81412_3278.0_2000-07-01	327800	\N	2000-07-01	81412	\N	\N	f	Sales which are qualified	0
81415_3830.0_2000-10-01	383000	\N	2000-10-01	81415	\N	\N	t	Deeds that include more than one parcel	0
81415_4500.0_2000-10-01	450000	\N	2000-10-01	81415	\N	\N	t	Deeds that include more than one parcel	0
81415_5200.0_2003-04-01	520000	\N	2003-04-01	81415	\N	\N	f	Sales which are qualified	0
81415_7600.0_2008-05-01	760000	\N	2008-05-01	81415	\N	\N	f	Sales which are qualified	0
81574_2920.0_2000-07-01	292000	\N	2000-07-01	81574	\N	\N	f	Sales which are qualified	0
81366_10500.0_2004-11-01	1050000	\N	2004-11-01	81366	\N	\N	f	Sales which are qualified	0
81421_13500.0_2021-11-30	1350000	\N	2021-11-30	81421	\N	\N	f	Qual by exam of deed	0
81495_4290.0_2004-05-01	429000	\N	2004-05-01	81495	\N	\N	f	Sales which are qualified	0
34702_3550.0_2019-05-31	355000	\N	2019-05-31	34702	\N	\N	f	Qual by exam of deed	0
35201_4127.2_2011-02-14	412720	\N	2011-02-14	35201	\N	\N	f	Qual by exam of deed	0
35201_5000.0_2022-05-24	500000	\N	2022-05-24	35201	\N	\N	f	Qual by exam of deed	0
35202_2650.0_2013-03-26	265000	\N	2013-03-26	35202	\N	\N	f	Qual by exam of deed	0
35202_2658.0_2017-02-21	265800	\N	2017-02-21	35202	\N	\N	f	Qual by exam of deed	0
35202_2990.0_2021-11-16	299000	\N	2021-11-16	35202	\N	\N	f	Qual by exam of deed	0
35202_4200.0_2009-03-18	420000	\N	2009-03-18	35202	\N	\N	f	Qual by exam of deed	0
35208_3150.0_2021-08-18	315000	\N	2021-08-18	35208	\N	\N	f	Qual by verifiable & documented evidence	0
35208_5562.58_2008-05-01	556258	\N	2008-05-01	35208	\N	\N	f	Sales which are qualified	0
35209_6000.0_2015-08-17	600000	\N	2015-08-17	35209	\N	\N	f	Qual by exam of deed	0
35209_6950.0_2009-09-16	695000	\N	2009-09-16	35209	\N	\N	f	Qual by exam of deed	0
35220_3870.0_2019-05-29	387000	\N	2019-05-29	35220	\N	\N	f	Qual by exam of deed	0
35220_3958.98_2012-04-30	395898	\N	2012-04-30	35220	\N	\N	f	Qual by exam of deed	0
35231_3560.0_2022-06-30	356000	\N	2022-06-30	35231	\N	\N	f	Qual by exam of deed	0
35231_3810.0_2015-04-29	381000	\N	2015-04-29	35231	\N	\N	f	Qual by exam of deed	0
35233_3850.0_2022-08-18	385000	\N	2022-08-18	35233	\N	\N	f	Qual by exam of deed	0
35254_3186.0_2013-09-30	318600	\N	2013-09-30	35254	\N	\N	f	Qual by exam of deed	0
35355_3800.0_2019-01-25	380000	\N	2019-01-25	35355	\N	\N	f	Qual by exam of deed	0
35355_4450.0_2021-12-06	445000	\N	2021-12-06	35355	\N	\N	f	Qual by exam of deed	0
126694_7710.0_2014-01-21	771000	\N	2014-01-21	126694	\N	\N	f	Qual by exam of deed	0
126694_8520.0_2021-06-03	852000	\N	2021-06-03	126694	\N	\N	f	Qual by exam of deed	0
126695_11936.0_2023-07-21	1193600	\N	2023-07-21	126695	\N	\N	f	Qual by exam of deed	0
126695_2210.0_1998-11-01	221000	\N	1998-11-01	126695	\N	\N	t	Deeds that include more than one parcel	0
126695_2350.0_1998-12-01	235000	\N	1998-12-01	126695	\N	\N	t	Deeds that include more than one parcel	0
126695_3300.0_2002-06-01	330000	\N	2002-06-01	126695	\N	\N	f	Sales which are qualified	0
126695_5750.0_2012-05-29	575000	\N	2012-05-29	126695	\N	\N	t	Qual on DOS, multi-parcel sale	0
126695_9850.0_2015-04-23	985000	\N	2015-04-23	126695	\N	\N	t	Qual on DOS, multi-parcel sale	0
126697_2270.0_1998-08-01	227000	\N	1998-08-01	126697	\N	\N	t	Deeds that include more than one parcel	0
126698_2300.0_1998-08-01	230000	\N	1998-08-01	126698	\N	\N	t	Deeds that include more than one parcel	0
126698_3300.0_2002-03-01	330000	\N	2002-03-01	126698	\N	\N	t	Deeds that include more than one parcel	0
126696_2240.0_1998-08-01	224000	\N	1998-08-01	126696	\N	\N	t	Deeds that include more than one parcel	0
126696_5350.0_2007-09-01	535000	\N	2007-09-01	126696	\N	\N	t	Deeds that include more than one parcel	0
126696_8570.0_2018-07-16	857000	\N	2018-07-16	126696	\N	\N	t	Qual on DOS, multi-parcel sale	0
139381_2250.0_1992-01-01	225000	\N	1992-01-01	139381	\N	\N	f	Sales which are qualified	0
139552_1100.0_1998-03-01	110000	\N	1998-03-01	139552	\N	\N	f	Sales which are qualified	0
139569_2400.0_1992-07-01	240000	\N	1992-07-01	139569	\N	\N	f	Sales which are qualified	0
139615_10000.0_1992-07-01	1000000	\N	1992-07-01	139615	\N	\N	t	Deeds that include more than one parcel	0
139381_5500.0_2017-01-19	550000	\N	2017-01-19	139381	\N	\N	f	Qual by exam of deed	0
139407_5500.0_2005-03-01	550000	\N	2005-03-01	139407	\N	\N	f	Sales which are qualified	0
139407_5599.5_2007-01-01	559950	\N	2007-01-01	139407	\N	\N	f	Sales which are qualified	0
139408_2080.0_2000-04-01	208000	\N	2000-04-01	139408	\N	\N	f	Sales which are qualified	0
139408_2100.0_1992-04-01	210000	\N	1992-04-01	139408	\N	\N	f	Sales which are qualified	0
139408_2147.0_1992-11-01	214700	\N	1992-11-01	139408	\N	\N	f	Sales which are qualified	0
139408_4900.0_2016-11-28	490000	\N	2016-11-28	139408	\N	\N	f	Qual by exam of deed	0
139409_2150.0_1996-02-01	215000	\N	1996-02-01	139409	\N	\N	f	Sales which are qualified	0
139409_2400.0_1992-04-01	240000	\N	1992-04-01	139409	\N	\N	f	Sales which are qualified	0
139409_4300.0_2010-12-09	430000	\N	2010-12-09	139409	\N	\N	f	Qual by exam of deed	0
139410_2200.0_1996-02-01	220000	\N	1996-02-01	139410	\N	\N	f	Sales which are qualified	0
139410_4000.0_1993-12-01	400000	\N	1993-12-01	139410	\N	\N	f	Sales which are qualified	0
139411_2230.0_2000-07-01	223000	\N	2000-07-01	139411	\N	\N	f	Sales which are qualified	0
139411_2250.0_1996-02-01	225000	\N	1996-02-01	139411	\N	\N	f	Sales which are qualified	0
139411_2300.0_1992-05-01	230000	\N	1992-05-01	139411	\N	\N	f	Sales which are qualified	0
139412_2010.0_1992-04-01	201000	\N	1992-04-01	139412	\N	\N	f	Sales which are qualified	0
139412_2055.0_1992-11-01	205500	\N	1992-11-01	139412	\N	\N	f	Sales which are qualified	0
139615_37500.0_2015-01-07	3750000	\N	2015-01-07	139615	\N	\N	t	Qual on DOS, multi-parcel sale	0
139616_37500.0_2015-01-07	3750000	\N	2015-01-07	139616	\N	\N	t	Qual on DOS, multi-parcel sale	0
139617_10000.0_1992-07-01	1000000	\N	1992-07-01	139617	\N	\N	t	Deeds that include more than one parcel	0
139617_37500.0_2015-01-07	3750000	\N	2015-01-07	139617	\N	\N	t	Qual on DOS, multi-parcel sale	0
139618_10000.0_1992-07-01	1000000	\N	1992-07-01	139618	\N	\N	t	Deeds that include more than one parcel	0
139618_37500.0_2015-01-07	3750000	\N	2015-01-07	139618	\N	\N	t	Qual on DOS, multi-parcel sale	0
139619_10000.0_1992-07-01	1000000	\N	1992-07-01	139619	\N	\N	t	Deeds that include more than one parcel	0
139619_37500.0_2015-01-07	3750000	\N	2015-01-07	139619	\N	\N	t	Qual on DOS, multi-parcel sale	0
139620_10000.0_1992-07-01	1000000	\N	1992-07-01	139620	\N	\N	t	Deeds that include more than one parcel	0
139620_37500.0_2015-01-07	3750000	\N	2015-01-07	139620	\N	\N	t	Qual on DOS, multi-parcel sale	0
139621_10000.0_1992-07-01	1000000	\N	1992-07-01	139621	\N	\N	t	Deeds that include more than one parcel	0
142853_1500.0_1993-09-01	150000	\N	1993-09-01	142853	\N	\N	t	Deeds that include more than one parcel	0
142853_4750.0_1994-09-01	475000	\N	1994-09-01	142853	\N	\N	f	Sales which are qualified	0
142853_692.0_1986-06-01	69200	\N	1986-06-01	142853	\N	\N	t	Deeds that include more than one parcel	0
88832_1800.0_1988-08-01	180000	\N	1988-08-01	88832	\N	\N	f	Sales which are qualified	0
88835_4500.0_2011-03-04	450000	\N	2011-03-04	88835	\N	\N	f	Qual by exam of deed	0
33109_26000.0_2006-10-01	2600000	\N	2006-10-01	33109	\N	\N	f	Sales which are qualified	0
82087_26800.0_2023-08-29	2680000	\N	2023-08-29	82087	\N	\N	f	Qual by exam of deed	0
52713_10800.0_2023-10-02	1080000	\N	2023-10-02	52713	\N	\N	f	Qual by exam of deed	0
52743_7650.0_2023-09-13	765000	\N	2023-09-13	52743	\N	\N	f	Qual by exam of deed	0
52865_11690.0_2023-08-22	1169000	\N	2023-08-22	52865	\N	\N	f	Qual by exam of deed	0
83055_7150.0_2023-08-12	715000	\N	2023-08-12	83055	\N	\N	f	Qual by exam of deed	0
82626_13250.0_2023-10-09	1325000	\N	2023-10-09	82626	\N	\N	f	Qual by exam of deed	0
53153_8425.0_2023-08-29	842500	\N	2023-08-29	53153	\N	\N	f	Qual by exam of deed	0
130084_8500.0_2023-08-24	850000	\N	2023-08-24	130084	\N	\N	f	Qual by exam of deed	0
139480_5350.0_2023-09-28	535000	\N	2023-09-28	139480	\N	\N	f	Qual by exam of deed	0
79840_20250.0_2023-08-21	2025000	\N	2023-08-21	79840	\N	\N	f	Qual by exam of deed	0
52375_12900.0_2023-09-14	1290000	\N	2023-09-14	52375	\N	\N	f	Qual by exam of deed	0
52938_30650.0_2023-09-05	3065000	\N	2023-09-05	52938	\N	\N	f	Qual by exam of deed	0
129286_10000.0_2023-09-26	1000000	\N	2023-09-26	129286	\N	\N	f	Qual by exam of deed	0
129417_5750.0_2023-09-15	575000	\N	2023-09-15	129417	\N	\N	f	Qual by exam of deed	0
130557_4950.0_2023-09-08	495000	\N	2023-09-08	130557	\N	\N	f	Qual by exam of deed	0
130219_3100.0_2023-09-05	310000	\N	2023-09-05	130219	\N	\N	f	Qual by exam of deed	0
130587_4000.0_2023-08-30	400000	\N	2023-08-30	130587	\N	\N	f	Qual by exam of deed	0
32876_22500.0_2023-09-27	2250000	\N	2023-09-27	32876	\N	\N	f	Qual by exam of deed	0
32940_20720.0_2023-09-29	2072000	\N	2023-09-29	32940	\N	\N	f	Qual by exam of deed	0
33421_15250.0_2012-12-18	1525000	\N	2012-12-18	33421	\N	\N	f	Qual by exam of deed	0
36873_5350.0_2023-10-05	535000	\N	2023-10-05	36873	\N	\N	f	Qual by exam of deed	0
126588_8990.0_2023-09-08	899000	\N	2023-09-08	126588	\N	\N	f	Qual by exam of deed	0
33882_5650.0_2023-08-27	565000	\N	2023-08-27	33882	\N	\N	f	Qual by exam of deed	0
34697_5350.0_2023-10-10	535000	\N	2023-10-10	34697	\N	\N	f	Qual by exam of deed	0
34723_3950.0_2023-09-12	395000	\N	2023-09-12	34723	\N	\N	f	Qual by exam of deed	0
34869_2800.0_2023-08-28	280000	\N	2023-08-28	34869	\N	\N	f	Qual by exam of deed	0
35365_2250.0_2023-09-01	225000	\N	2023-09-01	35365	\N	\N	f	Qual by exam of deed	0
35669_65000.0_2023-08-25	6500000	\N	2023-08-25	35669	\N	\N	t	Qual on DOS, multi-parcel sale	0
35670_65000.0_2023-08-25	6500000	\N	2023-08-25	35670	\N	\N	t	Qual on DOS, multi-parcel sale	0
36530_10850.0_2023-09-26	1085000	\N	2023-09-26	36530	\N	\N	f	Qual by exam of deed	0
36548_10700.0_2023-10-05	1070000	\N	2023-10-05	36548	\N	\N	f	Qual by exam of deed	0
37004_12900.0_2023-10-02	1290000	\N	2023-10-02	37004	\N	\N	f	Qual by exam of deed	0
37472_12250.0_2023-08-30	1225000	\N	2023-08-30	37472	\N	\N	f	Qual by exam of deed	0
37543_23250.0_2023-09-05	2325000	\N	2023-09-05	37543	\N	\N	f	Qual by exam of deed	0
127993_5490.0_2023-09-13	549000	\N	2023-09-13	127993	\N	\N	f	Qual by exam of deed	0
128109_4530.0_2023-09-01	453000	\N	2023-09-01	128109	\N	\N	f	Qual by exam of deed	0
128169_3200.0_2023-09-08	320000	\N	2023-09-08	128169	\N	\N	f	Qual by exam of deed	0
89580_82750.0_2023-09-27	8275000	\N	2023-09-27	89580	\N	\N	f	Qual by exam of deed	0
87726_51500.0_2023-10-06	5150000	\N	2023-10-06	87726	\N	\N	f	Qual by exam of deed	0
88091_9700.0_2023-09-29	970000	\N	2023-09-29	88091	\N	\N	f	Qual by exam of deed	0
88106_6900.0_2023-08-24	690000	\N	2023-08-24	88106	\N	\N	f	Qual by exam of deed	0
88201_6750.0_2023-08-23	675000	\N	2023-08-23	88201	\N	\N	f	Qual by exam of deed	0
89811_7250.0_2023-09-06	725000	\N	2023-09-06	89811	\N	\N	f	Qual by exam of deed	0
89875_7900.0_2023-10-05	790000	\N	2023-10-05	89875	\N	\N	f	Qual by exam of deed	0
33388_22500.0_2010-09-03	2250000	\N	2010-09-03	33388	\N	\N	f	Qual by exam of deed	0
80454_8000.0_2005-06-01	800000	\N	2005-06-01	80454	\N	\N	f	Sales which are qualified	0
80492_4417.5_2005-03-01	441750	\N	2005-03-01	80492	\N	\N	f	Sales which are qualified	0
82166_3352.0_2023-10-18	335200	\N	2023-10-18	82166	\N	\N	f	Qual by exam of deed	0
81313_33500.0_2023-12-07	3350000	\N	2023-12-07	81313	\N	\N	f	Qual by exam of deed	0
79899_28000.0_2023-12-14	2800000	\N	2023-12-14	79899	\N	\N	f	Qual by exam of deed	0
83252_38500.0_2023-11-15	3850000	\N	2023-11-15	83252	\N	\N	f	Qual by exam of deed	0
83271_52000.0_2023-11-14	5200000	\N	2023-11-14	83271	\N	\N	f	Qual by exam of deed	0
52575_9500.0_2023-10-07	950000	\N	2023-10-07	52575	\N	\N	f	Qual by exam of deed	0
52672_6760.0_2023-10-26	676000	\N	2023-10-26	52672	\N	\N	f	Qual by exam of deed	0
53072_37250.0_2023-11-17	3725000	\N	2023-11-17	53072	\N	\N	f	Qual by exam of deed	0
53246_13000.0_2023-10-26	1300000	\N	2023-10-26	53246	\N	\N	f	Qual by exam of deed	0
83033_11378.0_2023-11-02	1137800	\N	2023-11-02	83033	\N	\N	f	Qual by exam of deed	0
82640_17250.0_2023-10-10	1725000	\N	2023-10-10	82640	\N	\N	f	Qual by exam of deed	0
132018_87650.0_2023-12-07	8765000	\N	2023-12-07	132018	\N	\N	f	Qual by exam of deed	0
129376_8650.0_2023-09-29	865000	\N	2023-09-29	129376	\N	\N	f	Qual by exam of deed	0
129460_13500.0_2023-10-24	1350000	\N	2023-10-24	129460	\N	\N	f	Qual by exam of deed	0
130228_4510.0_2023-10-24	451000	\N	2023-10-24	130228	\N	\N	f	Qual by exam of deed	0
32920_60000.0_2023-10-24	6000000	\N	2023-10-24	32920	\N	\N	f	Qual by exam of deed	0
32927_18200.0_2023-05-01	1820000	\N	2023-05-01	32927	\N	\N	f	Qual by exam of deed	0
34340_22950.0_2023-10-31	2295000	\N	2023-10-31	34340	\N	\N	f	Qual by exam of deed	0
35864_7900.0_2023-10-30	790000	\N	2023-10-30	35864	\N	\N	f	Qual by exam of deed	0
35910_10175.0_2023-10-26	1017500	\N	2023-10-26	35910	\N	\N	t	Qual on DOS, multi-parcel sale	0
37125_4750.0_2023-10-12	475000	\N	2023-10-12	37125	\N	\N	f	Qual by exam of deed	0
33651_24000.0_2023-12-12	2400000	\N	2023-12-12	33651	\N	\N	f	Qual by exam of deed	0
33738_22000.0_2023-10-02	2200000	\N	2023-10-02	33738	\N	\N	f	Qual by exam of deed	0
33827_5200.0_2023-10-14	520000	\N	2023-10-14	33827	\N	\N	f	Qual by exam of deed	0
34488_16500.0_2023-09-25	1650000	\N	2023-09-25	34488	\N	\N	f	Qual by exam of deed	0
34810_6100.0_2023-10-23	610000	\N	2023-10-23	34810	\N	\N	f	Qual by exam of deed	0
34982_3100.0_2023-11-01	310000	\N	2023-11-01	34982	\N	\N	f	Qual by exam of deed	0
35035_3250.0_2023-10-18	325000	\N	2023-10-18	35035	\N	\N	f	Qual by exam of deed	0
35406_2450.0_2023-08-01	245000	\N	2023-08-01	35406	\N	\N	f	Qual by exam of deed	0
35475_2450.0_2023-08-01	245000	\N	2023-08-01	35475	\N	\N	f	Qual by exam of deed	0
36557_11100.0_2023-10-03	1110000	\N	2023-10-03	36557	\N	\N	f	Qual by exam of deed	0
128040_3950.0_2023-10-10	395000	\N	2023-10-10	128040	\N	\N	f	Qual by exam of deed	0
128239_7225.0_2023-10-04	722500	\N	2023-10-04	128239	\N	\N	f	Qual by exam of deed	0
89601_192500.0_2023-11-27	19250000	\N	2023-11-27	89601	\N	\N	f	Qual by exam of deed	0
87824_57000.0_2023-11-27	5700000	\N	2023-11-27	87824	\N	\N	f	Qual by exam of deed	0
87924_7300.0_2023-09-14	730000	\N	2023-09-14	87924	\N	\N	f	Qual by exam of deed	0
87961_10640.0_2023-10-25	1064000	\N	2023-10-25	87961	\N	\N	f	Qual by exam of deed	0
89219_24875.0_2023-12-05	2487500	\N	2023-12-05	89219	\N	\N	f	Qual by exam of deed	0
89639_35400.0_2023-11-20	3540000	\N	2023-11-20	89639	\N	\N	f	Qual by exam of deed	0
87426_80000.0_2023-10-02	8000000	\N	2023-10-02	87426	\N	\N	f	Qual by exam of deed	0
88680_37000.0_2023-10-19	3700000	\N	2023-10-19	88680	\N	\N	f	Qual by exam of deed	0
88495_48000.0_2023-10-26	4800000	\N	2023-10-26	88495	\N	\N	f	Qual by exam of deed	0
89033_25000.0_2023-10-20	2500000	\N	2023-10-20	89033	\N	\N	f	Qual by exam of deed	0
80622_4850.0_2005-07-01	485000	\N	2005-07-01	80622	\N	\N	f	Sales which are qualified	0
80622_5200.0_2006-07-01	520000	\N	2006-07-01	80622	\N	\N	f	Sales which are qualified	0
82237_7700.0_2023-12-01	770000	\N	2023-12-01	82237	\N	\N	f	Qual by exam of deed	0
82280_13600.0_2023-11-13	1360000	\N	2023-11-13	82280	\N	\N	f	Qual by exam of deed	0
82284_18750.0_2024-01-12	1875000	\N	2024-01-12	82284	\N	\N	f	Qual by exam of deed	0
82496_12500.0_2024-01-08	1250000	\N	2024-01-08	82496	\N	\N	f	Qual by exam of deed	0
80399_8100.0_2023-12-01	810000	\N	2023-12-01	80399	\N	\N	f	Qual by exam of deed	0
80801_8500.0_2024-01-05	850000	\N	2024-01-05	80801	\N	\N	f	Qual by exam of deed	0
52329_9600.0_2024-01-02	960000	\N	2024-01-02	52329	\N	\N	f	Qual by exam of deed	0
52403_27200.0_2024-01-05	2720000	\N	2024-01-05	52403	\N	\N	f	Qual by exam of deed	0
52668_15300.0_2023-12-01	1530000	\N	2023-12-01	52668	\N	\N	f	Qual by exam of deed	0
52723_14500.0_2023-12-22	1450000	\N	2023-12-22	52723	\N	\N	f	Qual by exam of deed	0
52879_14000.0_2024-01-16	1400000	\N	2024-01-16	52879	\N	\N	f	Qual by exam of deed	0
53187_8420.0_2024-01-11	842000	\N	2024-01-11	53187	\N	\N	f	Qual by exam of deed	0
53206_8000.0_2023-11-27	800000	\N	2023-11-27	53206	\N	\N	f	Qual by exam of deed	0
53365_40500.0_2023-12-28	4050000	\N	2023-12-28	53365	\N	\N	f	Qual by exam of deed	0
53405_5600.0_2024-01-15	560000	\N	2024-01-15	53405	\N	\N	f	Qual by exam of deed	0
53471_2425.0_2024-01-17	242500	\N	2024-01-17	53471	\N	\N	f	Qual by exam of deed	0
83084_21000.0_2024-01-19	2100000	\N	2024-01-19	83084	\N	\N	f	Qual by exam of deed	0
130211_5150.0_2023-12-27	515000	\N	2023-12-27	130211	\N	\N	f	Qual by exam of deed	0
129329_12700.0_2023-11-13	1270000	\N	2023-11-13	129329	\N	\N	f	Qual by exam of deed	0
130383_3000.0_2023-10-27	300000	\N	2023-10-27	130383	\N	\N	f	Qual by exam of deed	0
130577_3750.0_2023-12-12	375000	\N	2023-12-12	130577	\N	\N	f	Qual by exam of deed	0
130606_3500.0_2023-11-09	350000	\N	2023-11-09	130606	\N	\N	f	Qual by exam of deed	0
139568_10000.0_2023-11-06	1000000	\N	2023-11-06	139568	\N	\N	f	Qual by exam of deed	0
33481_4000.0_2024-01-04	400000	\N	2024-01-04	33481	\N	\N	f	Qual by exam of deed	0
33489_3850.0_2023-12-21	385000	\N	2023-12-21	33489	\N	\N	f	Qual by exam of deed	0
33499_3518.0_2023-11-07	351800	\N	2023-11-07	33499	\N	\N	f	Qual by exam of deed	0
34422_7535.0_2024-01-11	753500	\N	2024-01-11	34422	\N	\N	f	Qual by exam of deed	0
34715_2700.0_2023-12-14	270000	\N	2023-12-14	34715	\N	\N	f	Qual by exam of deed	0
34890_3250.0_2023-12-18	325000	\N	2023-12-18	34890	\N	\N	f	Qual by exam of deed	0
34917_8000.0_2024-01-12	800000	\N	2024-01-12	34917	\N	\N	f	Qual by exam of deed	0
34926_6000.0_2023-11-27	600000	\N	2023-11-27	34926	\N	\N	f	Qual by exam of deed	0
35006_3050.0_2023-12-23	305000	\N	2023-12-23	35006	\N	\N	f	Qual by exam of deed	0
35115_9350.0_2023-12-26	935000	\N	2023-12-26	35115	\N	\N	f	Qual by exam of deed	0
35807_8500.0_2023-09-13	850000	\N	2023-09-13	35807	\N	\N	f	Qual by exam of deed	0
36749_9200.0_2023-12-27	920000	\N	2023-12-27	36749	\N	\N	f	Qual by exam of deed	0
36887_5300.0_2024-01-09	530000	\N	2024-01-09	36887	\N	\N	f	Qual by exam of deed	0
36911_11600.0_2023-11-28	1160000	\N	2023-11-28	36911	\N	\N	f	Qual by exam of deed	0
36944_8287.0_2024-01-25	828700	\N	2024-01-25	36944	\N	\N	f	Qual by exam of deed	0
37036_5000.0_2024-01-16	500000	\N	2024-01-16	37036	\N	\N	f	Qual by exam of deed	0
37138_6650.0_2024-01-05	665000	\N	2024-01-05	37138	\N	\N	f	Qual by exam of deed	0
128053_3800.0_2023-09-17	380000	\N	2023-09-17	128053	\N	\N	f	Qual by exam of deed	0
126705_4300.0_2023-11-15	430000	\N	2023-11-15	126705	\N	\N	t	Qual on DOS, multi-parcel sale	0
126818_900.0_2023-11-22	90000	\N	2023-11-22	126818	\N	\N	t	Qual on DOS, multi-parcel sale	0
126819_900.0_2023-11-22	90000	\N	2023-11-22	126819	\N	\N	t	Qual on DOS, multi-parcel sale	0
127228_4300.0_2023-11-15	430000	\N	2023-11-15	127228	\N	\N	t	Qual on DOS, multi-parcel sale	0
34176_5000.0_2023-11-30	500000	\N	2023-11-30	34176	\N	\N	f	Qual by exam of deed	0
34506_45110.0_2023-12-20	4511000	\N	2023-12-20	34506	\N	\N	f	Qual by exam of deed	0
34651_6800.0_2023-12-02	680000	\N	2023-12-02	34651	\N	\N	f	Qual by exam of deed	0
35155_65000.0_2024-01-24	6500000	\N	2024-01-24	35155	\N	\N	f	Qual by exam of deed	0
35408_3600.0_2023-11-22	360000	\N	2023-11-22	35408	\N	\N	f	Qual by exam of deed	0
35580_23000.0_2024-01-18	2300000	\N	2024-01-18	35580	\N	\N	f	Qual by exam of deed	0
35680_2550.0_2005-12-28	255000	\N	2005-12-28	35680	\N	\N	f	Sales which are qualified	0
35680_3400.0_2004-11-05	340000	\N	2004-11-05	35680	\N	\N	f	Sales which are qualified	0
35680_7100.0_2004-06-03	710000	\N	2004-06-03	35680	\N	\N	f	Sales which are qualified	0
35711_25250.0_2023-11-30	2525000	\N	2023-11-30	35711	\N	\N	f	Qual by exam of deed	0
36433_9450.0_2024-01-09	945000	\N	2024-01-09	36433	\N	\N	f	Qual by exam of deed	0
36437_11000.0_2023-11-20	1100000	\N	2023-11-20	36437	\N	\N	f	Qual by exam of deed	0
36444_13500.0_2023-11-11	1350000	\N	2023-11-11	36444	\N	\N	f	Qual by exam of deed	0
36482_10750.0_2023-12-14	1075000	\N	2023-12-14	36482	\N	\N	f	Qual by exam of deed	0
37449_13200.0_2023-12-22	1320000	\N	2023-12-22	37449	\N	\N	f	Qual by exam of deed	0
128152_3700.0_2024-01-30	370000	\N	2024-01-30	128152	\N	\N	f	Qual by exam of deed	0
128233_3150.0_2023-12-26	315000	\N	2023-12-26	128233	\N	\N	f	Qual by exam of deed	0
128254_9955.0_2024-01-17	995500	\N	2024-01-17	128254	\N	\N	f	Qual by exam of deed	0
128264_3750.0_2024-01-09	375000	\N	2024-01-09	128264	\N	\N	f	Qual by exam of deed	0
128304_4350.0_2023-12-28	435000	\N	2023-12-28	128304	\N	\N	f	Qual by exam of deed	0
128325_4000.0_2023-12-21	400000	\N	2023-12-21	128325	\N	\N	f	Qual by exam of deed	0
126579_20000.0_2024-01-05	2000000	\N	2024-01-05	126579	\N	\N	f	Qual by exam of deed	0
87521_28000.0_2024-01-04	2800000	\N	2024-01-04	87521	\N	\N	f	Qual by exam of deed	0
89791_5700.0_2023-11-22	570000	\N	2023-11-22	89791	\N	\N	f	Qual by exam of deed	0
89814_7990.0_2023-12-19	799000	\N	2023-12-19	89814	\N	\N	f	Qual by exam of deed	0
89828_8590.0_2023-11-27	859000	\N	2023-11-27	89828	\N	\N	f	Qual by exam of deed	0
34210_5000.0_2024-01-03	500000	\N	2024-01-03	34210	\N	\N	f	Qual by exam of deed	0
87583_42000.0_2024-01-09	4200000	\N	2024-01-09	87583	\N	\N	f	Qual by exam of deed	0
88213_72000.0_2024-01-09	7200000	\N	2024-01-09	88213	\N	\N	f	Qual by exam of deed	0
89160_26500.0_2024-01-12	2650000	\N	2024-01-12	89160	\N	\N	f	Qual by exam of deed	0
89635_22500.0_2024-01-02	2250000	\N	2024-01-02	89635	\N	\N	f	Qual by exam of deed	0
88593_30000.0_2024-01-25	3000000	\N	2024-01-25	88593	\N	\N	f	Qual by exam of deed	0
88400_27000.0_2024-01-08	2700000	\N	2024-01-08	88400	\N	\N	f	Qual by exam of deed	0
88431_16500.0_2023-11-09	1650000	\N	2023-11-09	88431	\N	\N	f	Qual by exam of deed	0
88925_10650.0_2024-01-11	1065000	\N	2024-01-11	88925	\N	\N	f	Qual by exam of deed	0
88955_10700.0_2023-12-19	1070000	\N	2023-12-19	88955	\N	\N	f	Qual by exam of deed	0
88121_12000.0_2023-12-11	1200000	\N	2023-12-11	88121	\N	\N	f	Qual by exam of deed	0
88143_9150.0_2023-06-02	915000	\N	2023-06-02	88143	\N	\N	f	Qual by exam of deed	0
133643_27000.0_2024-01-04	2700000	\N	2024-01-04	133643	\N	\N	f	Qual by exam of deed	0
33578_7300.0_2024-01-18	730000	\N	2024-01-18	33578	\N	\N	f	Qual by exam of deed	0
34247_5000.0_2021-09-15	500000	\N	2021-09-15	34247	\N	\N	f	Qual by exam of deed	0
34305_1850.0_2023-11-28	185000	\N	2023-11-28	34305	\N	\N	f	Qual by exam of deed	0
80370_9000.0_2005-03-01	900000	\N	2005-03-01	80370	\N	\N	f	Sales which are qualified	0
80371_3400.0_2005-02-01	340000	\N	2005-02-01	80371	\N	\N	f	Sales which are qualified	0
80382_3000.0_2010-11-30	300000	\N	2010-11-30	80382	\N	\N	f	Qual by exam of deed	0
80607_3350.0_2005-04-01	335000	\N	2005-04-01	80607	\N	\N	f	Sales which are qualified	0
79867_16500.0_2011-11-01	1650000	\N	2011-11-01	79867	\N	\N	f	Qual by exam of deed	0
80475_8890.0_2005-03-01	889000	\N	2005-03-01	80475	\N	\N	f	Sales which are qualified	0
80476_15890.0_2023-05-08	1589000	\N	2023-05-08	80476	\N	\N	f	Qual by exam of deed	0
80476_7496.0_2005-03-01	749600	\N	2005-03-01	80476	\N	\N	f	Sales which are qualified	0
80603_2680.0_2005-01-01	268000	\N	2005-01-01	80603	\N	\N	f	Sales which are qualified	0
80603_6860.0_2019-03-06	686000	\N	2019-03-06	80603	\N	\N	f	Qual by exam of deed	0
80604_3750.0_2005-04-01	375000	\N	2005-04-01	80604	\N	\N	f	Sales which are qualified	0
80604_4450.0_2005-05-01	445000	\N	2005-05-01	80604	\N	\N	f	Sales which are qualified	0
80604_6900.0_2014-11-25	690000	\N	2014-11-25	80604	\N	\N	f	Qual by exam of deed	0
80607_4000.0_2009-01-02	400000	\N	2009-01-02	80607	\N	\N	f	Qual by exam of deed	0
80607_5800.0_2014-01-30	580000	\N	2014-01-30	80607	\N	\N	f	Qual by exam of deed	0
80609_3174.0_2005-02-01	317400	\N	2005-02-01	80609	\N	\N	f	Sales which are qualified	0
80609_3900.0_2008-05-01	390000	\N	2008-05-01	80609	\N	\N	f	Sales which are qualified	0
79858_10746.45_2010-03-30	1074645	\N	2010-03-30	79858	\N	\N	f	Qual by exam of deed	0
88221_10000.0_2015-03-20	1000000	\N	2015-03-20	88221	\N	\N	f	Qual by exam of deed	0
142852_1500.0_1993-09-01	150000	\N	1993-09-01	142852	\N	\N	t	Deeds that include more than one parcel	0
142852_692.0_1986-06-01	69200	\N	1986-06-01	142852	\N	\N	t	Deeds that include more than one parcel	0
53045_23416.0_2019-10-04	2341600	\N	2019-10-04	53045	\N	\N	f	Qual by exam of deed	0
53042_13500.0_2019-10-22	1350000	\N	2019-10-22	53042	\N	\N	f	Qual by exam of deed	0
88917_9780.0_2016-09-30	978000	\N	2016-09-30	88917	\N	\N	f	Qual by exam of deed	0
140457_16000.0_2018-06-14	1600000	\N	2018-06-14	140457	\N	\N	f	Qual by exam of deed	0
140458_2000.0_2011-05-09	200000	\N	2011-05-09	140458	\N	\N	f	Qual by exam of deed	0
140458_2200.0_2003-07-01	220000	\N	2003-07-01	140458	\N	\N	f	Sales which are qualified	0
140458_400.0_1984-11-01	40000	\N	1984-11-01	140458	\N	\N	t	Deeds that include more than one parcel	0
140458_429.09_1988-07-01	42909	\N	1988-07-01	140458	\N	\N	f	Sales which are qualified	0
142851_1390.0_2001-09-01	139000	\N	2001-09-01	142851	\N	\N	f	Sales which are qualified	0
142851_1900.0_2002-07-01	190000	\N	2002-07-01	142851	\N	\N	f	Sales which are qualified	0
142851_33000.0_2017-09-22	3300000	\N	2017-09-22	142851	\N	\N	t	Qual on DOS, multi-parcel sale	0
142851_920000.0_2022-06-30	92000000	\N	2022-06-30	142851	\N	\N	f	Qual by exam of deed	0
88888_2400.0_1989-05-01	240000	\N	1989-05-01	88888	\N	\N	f	Sales which are qualified	0
88888_3100.0_1990-02-01	310000	\N	1990-02-01	88888	\N	\N	f	Sales which are qualified	0
88888_8200.0_2007-04-01	820000	\N	2007-04-01	88888	\N	\N	f	Sales which are qualified	0
88970_4320.0_2005-04-01	432000	\N	2005-04-01	88970	\N	\N	f	Sales which are qualified	0
88990_3150.0_1999-11-01	315000	\N	1999-11-01	88990	\N	\N	f	Sales which are qualified	0
88863_8150.0_2013-11-15	815000	\N	2013-11-15	88863	\N	\N	f	Qual by exam of deed	0
89022_18250.0_2015-01-09	1825000	\N	2015-01-09	89022	\N	\N	f	Qual by exam of deed	0
89022_1910.0_1987-11-01	191000	\N	1987-11-01	89022	\N	\N	t	Deeds that include more than one parcel	0
89022_23000.0_2016-09-23	2300000	\N	2016-09-23	89022	\N	\N	f	Qual by exam of deed	0
89022_9200.0_2010-10-28	920000	\N	2010-10-28	89022	\N	\N	t	Qual on DOS, multi-parcel sale	0
89031_10000.0_2012-04-06	1000000	\N	2012-04-06	89031	\N	\N	f	Qual by exam of deed	0
89031_10500.0_2006-05-01	1050000	\N	2006-05-01	89031	\N	\N	f	Sales which are qualified	0
89031_21000.0_2023-05-24	2100000	\N	2023-05-24	89031	\N	\N	f	Qual by exam of deed	0
89031_2700.0_1999-09-01	270000	\N	1999-09-01	89031	\N	\N	f	Sales which are qualified	0
89031_2930.0_1996-03-01	293000	\N	1996-03-01	89031	\N	\N	f	Sales which are qualified	0
89031_3300.0_1996-03-01	330000	\N	1996-03-01	89031	\N	\N	f	Sales which are qualified	0
89031_4800.0_2003-06-01	480000	\N	2003-06-01	89031	\N	\N	f	Sales which are qualified	0
89032_10000.0_2005-09-01	1000000	\N	2005-09-01	89032	\N	\N	f	Sales which are qualified	0
89032_12000.0_2007-03-01	1200000	\N	2007-03-01	89032	\N	\N	f	Sales which are qualified	0
89032_15500.0_2013-05-06	1550000	\N	2013-05-06	89032	\N	\N	f	Qual by exam of deed	0
89032_4230.0_1992-12-01	423000	\N	1992-12-01	89032	\N	\N	f	Sales which are qualified	0
89032_5100.0_2004-05-01	510000	\N	2004-05-01	89032	\N	\N	f	Sales which are qualified	0
89033_20500.0_2020-11-13	2050000	\N	2020-11-13	89033	\N	\N	f	Qual by exam of deed	0
89033_2800.0_1992-07-01	280000	\N	1992-07-01	89033	\N	\N	f	Sales which are qualified	0
89033_4950.0_2004-05-01	495000	\N	2004-05-01	89033	\N	\N	f	Sales which are qualified	0
82316_14650.0_2024-02-08	1465000	\N	2024-02-08	82316	\N	\N	f	Qual by exam of deed	0
81318_32500.0_2023-08-07	3250000	\N	2023-08-07	81318	\N	\N	f	Qual by exam of deed	0
79831_67000.0_2024-02-13	6700000	\N	2024-02-13	79831	\N	\N	f	Qual by exam of deed	0
80742_12180.0_2024-02-16	1218000	\N	2024-02-16	80742	\N	\N	f	Qual by exam of deed	0
80743_12500.0_2024-02-06	1250000	\N	2024-02-06	80743	\N	\N	f	Qual by exam of deed	0
52401_13200.0_2024-02-27	1320000	\N	2024-02-27	52401	\N	\N	f	Qual by exam of deed	0
52653_45000.0_2024-02-05	4500000	\N	2024-02-05	52653	\N	\N	f	Qual by exam of deed	0
52697_9850.0_2024-03-08	985000	\N	2024-03-08	52697	\N	\N	f	Qual by exam of deed	0
52947_10.0_2023-08-31	1000	\N	2023-08-31	52947	\N	\N	f	Qual by exam of deed	0
52985_38000.0_2024-03-11	3800000	\N	2024-03-11	52985	\N	\N	f	Qual by exam of deed	0
53108_78000.0_2024-02-15	7800000	\N	2024-02-15	53108	\N	\N	f	Qual by exam of deed	0
53114_58000.0_2024-02-24	5800000	\N	2024-02-24	53114	\N	\N	f	Qual by exam of deed	0
53160_8800.0_2024-02-14	880000	\N	2024-02-14	53160	\N	\N	f	Qual by exam of deed	0
53171_8750.0_2024-03-04	875000	\N	2024-03-04	53171	\N	\N	f	Qual by exam of deed	0
53261_61000.0_2024-02-23	6100000	\N	2024-02-23	53261	\N	\N	f	Qual by exam of deed	0
53448_5400.0_2024-02-12	540000	\N	2024-02-12	53448	\N	\N	f	Qual by exam of deed	0
53575_8500.0_2024-02-12	850000	\N	2024-02-12	53575	\N	\N	f	Qual by exam of deed	0
83058_7750.0_2024-01-29	775000	\N	2024-01-29	83058	\N	\N	f	Qual by exam of deed	0
83106_17850.0_2024-02-12	1785000	\N	2024-02-12	83106	\N	\N	f	Qual by exam of deed	0
130043_24750.0_2024-02-06	2475000	\N	2024-02-06	130043	\N	\N	f	Qual by exam of deed	0
130124_22000.0_2024-02-02	2200000	\N	2024-02-02	130124	\N	\N	f	Qual by exam of deed	0
129496_6700.0_2024-02-29	670000	\N	2024-02-29	129496	\N	\N	f	Qual by exam of deed	0
129630_18000.0_2024-02-09	1800000	\N	2024-02-09	129630	\N	\N	f	Qual by exam of deed	0
130439_4690.0_2024-02-15	469000	\N	2024-02-15	130439	\N	\N	f	Qual by exam of deed	0
33510_3300.0_2024-02-16	330000	\N	2024-02-16	33510	\N	\N	f	Qual by verifiable & documented evidence	0
33789_4300.0_2024-01-23	430000	\N	2024-01-23	33789	\N	\N	f	Qual by exam of deed	0
33797_4890.0_2024-03-04	489000	\N	2024-03-04	33797	\N	\N	f	Qual by exam of deed	0
33824_5900.0_2024-02-26	590000	\N	2024-02-26	33824	\N	\N	f	Qual by exam of deed	0
33879_3450.0_2024-02-20	345000	\N	2024-02-20	33879	\N	\N	f	Qual by exam of deed	0
34332_20000.0_2024-02-28	2000000	\N	2024-02-28	34332	\N	\N	f	Qual by exam of deed	0
34623_7750.0_2024-03-11	775000	\N	2024-03-11	34623	\N	\N	f	Qual by exam of deed	0
34659_6750.0_2024-03-01	675000	\N	2024-03-01	34659	\N	\N	f	Qual by exam of deed	0
34862_3750.0_2024-03-08	375000	\N	2024-03-08	34862	\N	\N	f	Qual by exam of deed	0
34828_2700.0_2024-02-29	270000	\N	2024-02-29	34828	\N	\N	f	Qual by exam of deed	0
35027_4750.0_2024-02-27	475000	\N	2024-02-27	35027	\N	\N	f	Qual by exam of deed	0
35145_33500.0_2024-02-29	3350000	\N	2024-02-29	35145	\N	\N	f	Qual by exam of deed	0
35675_41500.0_2024-02-20	4150000	\N	2024-02-20	35675	\N	\N	f	Qual by exam of deed	0
35733_27500.0_2024-03-07	2750000	\N	2024-03-07	35733	\N	\N	f	Qual by exam of deed	0
36922_5250.0_2024-02-23	525000	\N	2024-02-23	36922	\N	\N	f	Qual by exam of deed	0
37233_33475.0_2024-02-13	3347500	\N	2024-02-13	37233	\N	\N	f	Qual by exam of deed	0
127970_5000.0_2024-03-12	500000	\N	2024-03-12	127970	\N	\N	f	Qual by exam of deed	0
127972_5030.0_2024-02-22	503000	\N	2024-02-22	127972	\N	\N	f	Qual by exam of deed	0
128103_2950.0_2024-02-27	295000	\N	2024-02-27	128103	\N	\N	f	Qual by exam of deed	0
128134_3800.0_2024-02-15	380000	\N	2024-02-15	128134	\N	\N	f	Qual by exam of deed	0
128245_7590.0_2024-03-04	759000	\N	2024-03-04	128245	\N	\N	f	Qual by exam of deed	0
128279_3250.0_2024-02-08	325000	\N	2024-02-08	128279	\N	\N	f	Qual by exam of deed	0
34107_3850.0_2024-02-20	385000	\N	2024-02-20	34107	\N	\N	f	Qual by exam of deed	0
33706_11000.0_2024-02-12	1100000	\N	2024-02-12	33706	\N	\N	f	Qual by exam of deed	0
35559_7700.0_2024-02-06	770000	\N	2024-02-06	35559	\N	\N	f	Qual by exam of deed	0
89450_92800.0_2024-03-13	9280000	\N	2024-03-13	89450	\N	\N	t	Qual on DOS, multi-parcel sale	0
89210_25200.0_2024-03-13	2520000	\N	2024-03-13	89210	\N	\N	f	Qual by exam of deed	0
88626_20000.0_2024-02-14	2000000	\N	2024-02-14	88626	\N	\N	f	Qual by exam of deed	0
88814_12360.0_2024-02-09	1236000	\N	2024-02-09	88814	\N	\N	f	Qual by exam of deed	0
88838_11500.0_2024-02-13	1150000	\N	2024-02-13	88838	\N	\N	f	Qual by exam of deed	0
88967_11500.0_2021-03-23	1150000	\N	2021-03-23	88967	\N	\N	f	Qual by exam of deed	0
88051_9750.0_2023-08-16	975000	\N	2023-08-16	88051	\N	\N	f	Qual by exam of deed	0
88130_7750.0_2024-02-22	775000	\N	2024-02-22	88130	\N	\N	f	Qual by exam of deed	0
89716_15400.0_2024-03-01	1540000	\N	2024-03-01	89716	\N	\N	f	Qual by exam of deed	0
89896_9600.0_2023-04-08	960000	\N	2023-04-08	89896	\N	\N	f	Qual by exam of deed	0
33565_7500.0_2024-02-29	750000	\N	2024-02-29	33565	\N	\N	f	Qual by exam of deed	0
35776_1750.0_1999-02-01	175000	\N	1999-02-01	35776	\N	\N	t	Deeds that include more than one parcel	0
35790_14000.0_2013-07-18	1400000	\N	2013-07-18	35790	\N	\N	t	Qual on DOS, multi-parcel sale	0
52305_1985.0_2001-02-01	198500	\N	2001-02-01	52305	\N	\N	f	Sales which are qualified	0
52337_7200.0_2021-06-29	720000	\N	2021-06-29	52337	\N	\N	f	Qual by exam of deed	0
82476_3000.0_2009-02-12	300000	\N	2009-02-12	82476	\N	\N	f	Qual by exam of deed	0
79809_95000.0_2015-09-10	9500000	\N	2015-09-10	79809	\N	\N	f	Qual by exam of deed	0
79805_145000.0_2015-10-05	14500000	\N	2015-10-05	79805	\N	\N	f	Qual by exam of deed	0
33477_3150.0_2008-03-14	315000	\N	2008-03-14	33477	\N	\N	f	Sales which are qualified	0
33477_3530.0_2013-08-27	353000	\N	2013-08-27	33477	\N	\N	f	Qual by exam of deed	0
33478_1850.0_2010-06-24	185000	\N	2010-06-24	33478	\N	\N	f	Qual by exam of deed	0
33478_2900.0_2008-02-01	290000	\N	2008-02-01	33478	\N	\N	f	Sales which are qualified	0
33478_2930.0_2021-04-30	293000	\N	2021-04-30	33478	\N	\N	f	Qual by exam of deed	0
33478_3050.0_2018-04-05	305000	\N	2018-04-05	33478	\N	\N	f	Qual by exam of deed	0
33478_3250.0_2015-10-08	325000	\N	2015-10-08	33478	\N	\N	f	Qual by exam of deed	0
33479_2750.0_2013-02-20	275000	\N	2013-02-20	33479	\N	\N	f	Qual by exam of deed	0
33479_3000.0_2008-02-11	300000	\N	2008-02-11	33479	\N	\N	f	Sales which are qualified	0
33480_3700.0_2008-02-07	370000	\N	2008-02-07	33480	\N	\N	f	Sales which are qualified	0
33481_1500.0_2012-03-27	150000	\N	2012-03-27	33481	\N	\N	f	Qual by exam of deed	0
33481_2570.0_2020-10-23	257000	\N	2020-10-23	33481	\N	\N	f	Qual by exam of deed	0
33481_3000.0_2017-01-10	300000	\N	2017-01-10	33481	\N	\N	f	Qual by exam of deed	0
33481_3350.0_2008-02-27	335000	\N	2008-02-27	33481	\N	\N	f	Sales which are qualified	0
33482_3150.0_2008-02-11	315000	\N	2008-02-11	33482	\N	\N	f	Sales which are qualified	0
33540_7500.0_2005-05-01	750000	\N	2005-05-01	33540	\N	\N	f	Sales which are qualified	0
33540_9650.0_2021-08-31	965000	\N	2021-08-31	33540	\N	\N	f	Qual by exam of deed	0
33541_3850.0_2005-04-01	385000	\N	2005-04-01	33541	\N	\N	f	Sales which are qualified	0
33542_3600.0_2011-06-07	360000	\N	2011-06-07	33542	\N	\N	f	Qual by exam of deed	0
33542_4142.0_2005-04-01	414200	\N	2005-04-01	33542	\N	\N	f	Sales which are qualified	0
33543_11000.0_2007-02-01	1100000	\N	2007-02-01	33543	\N	\N	f	Sales which are qualified	0
33543_4550.0_2009-04-07	455000	\N	2009-04-07	33543	\N	\N	f	Qual by exam of deed	0
33543_5370.0_2005-04-01	537000	\N	2005-04-01	33543	\N	\N	f	Sales which are qualified	0
33543_5400.0_2012-08-21	540000	\N	2012-08-21	33543	\N	\N	f	Qual by exam of deed	0
33543_7400.0_2005-06-01	740000	\N	2005-06-01	33543	\N	\N	f	Sales which are qualified	0
33544_7203.0_2005-04-01	720300	\N	2005-04-01	33544	\N	\N	f	Sales which are qualified	0
33544_7505.0_2020-07-02	750500	\N	2020-07-02	33544	\N	\N	f	Qual by exam of deed	0
33545_3100.0_2012-08-21	310000	\N	2012-08-21	33545	\N	\N	f	Qual by exam of deed	0
33545_3850.0_2005-05-01	385000	\N	2005-05-01	33545	\N	\N	f	Sales which are qualified	0
33545_5570.0_2005-07-01	557000	\N	2005-07-01	33545	\N	\N	f	Sales which are qualified	0
33546_3700.0_2005-04-01	370000	\N	2005-04-01	33546	\N	\N	f	Sales which are qualified	0
33547_5100.0_2009-06-16	510000	\N	2009-06-16	33547	\N	\N	f	Qual by exam of deed	0
33547_5370.0_2005-09-01	537000	\N	2005-09-01	33547	\N	\N	f	Sales which are qualified	0
33547_9700.0_2021-09-16	970000	\N	2021-09-16	33547	\N	\N	f	Qual by exam of deed	0
33548_4100.0_2010-08-30	410000	\N	2010-08-30	33548	\N	\N	f	Qual by exam of deed	0
33548_5300.0_2005-05-01	530000	\N	2005-05-01	33548	\N	\N	f	Sales which are qualified	0
33548_5650.0_2011-12-19	565000	\N	2011-12-19	33548	\N	\N	f	Qual by exam of deed	0
33548_8500.0_2019-04-30	850000	\N	2019-04-30	33548	\N	\N	f	Qual by exam of deed	0
33548_8860.0_2005-07-01	886000	\N	2005-07-01	33548	\N	\N	f	Sales which are qualified	0
33549_3890.0_2005-06-01	389000	\N	2005-06-01	33549	\N	\N	f	Sales which are qualified	0
33549_5500.0_2014-02-07	550000	\N	2014-02-07	33549	\N	\N	f	Qual by exam of deed	0
33627_16850.0_2018-06-29	1685000	\N	2018-06-29	33627	\N	\N	f	Qual by exam of deed	0
33627_18500.0_2021-11-30	1850000	\N	2021-11-30	33627	\N	\N	f	Qual by exam of deed	0
33627_9920.0_2005-07-01	992000	\N	2005-07-01	33627	\N	\N	f	Sales which are qualified	0
33628_18000.0_2023-03-15	1800000	\N	2023-03-15	33628	\N	\N	f	Qual by exam of deed	0
33628_8002.5_2013-02-25	800250	\N	2013-02-25	33628	\N	\N	f	Qual by exam of deed	0
33628_9870.0_2005-09-01	987000	\N	2005-09-01	33628	\N	\N	f	Sales which are qualified	0
33629_3470.0_2010-05-14	347000	\N	2010-05-14	33629	\N	\N	f	Qual by exam of deed	0
33629_4410.0_2005-07-01	441000	\N	2005-07-01	33629	\N	\N	f	Sales which are qualified	0
33630_2800.0_2010-04-01	280000	\N	2010-04-01	33630	\N	\N	f	Qual by exam of deed	0
33630_3810.0_2005-08-01	381000	\N	2005-08-01	33630	\N	\N	f	Sales which are qualified	0
33630_6000.0_2021-04-15	600000	\N	2021-04-15	33630	\N	\N	f	Qual by exam of deed	0
33631_5020.0_2011-12-21	502000	\N	2011-12-21	33631	\N	\N	f	Qual by exam of deed	0
33708_12250.0_2013-02-20	1225000	\N	2013-02-20	33708	\N	\N	f	Qual by exam of deed	0
33708_307900.0_2010-05-27	30790000	\N	2010-05-27	33708	\N	\N	t	Qual on DOS, multi-parcel sale	0
33709_17800.0_2008-12-11	1780000	\N	2008-12-11	33709	\N	\N	f	Sales which are qualified	0
33709_26000.0_2022-02-28	2600000	\N	2022-02-28	33709	\N	\N	f	Qual by exam of deed	0
33710_14240.35_2012-01-02	1424035	\N	2012-01-02	33710	\N	\N	f	Qual by exam of deed	0
33710_20000.0_2022-03-15	2000000	\N	2022-03-15	33710	\N	\N	f	Qual by exam of deed	0
33710_307900.0_2010-05-27	30790000	\N	2010-05-27	33710	\N	\N	t	Qual on DOS, multi-parcel sale	0
33711_307900.0_2010-05-27	30790000	\N	2010-05-27	33711	\N	\N	t	Qual on DOS, multi-parcel sale	0
33711_4950.0_2013-03-15	495000	\N	2013-03-15	33711	\N	\N	f	Qual by exam of deed	0
33712_307900.0_2010-05-27	30790000	\N	2010-05-27	33712	\N	\N	t	Qual on DOS, multi-parcel sale	0
33712_8713.0_2010-11-08	871300	\N	2010-11-08	33712	\N	\N	f	Qual by exam of deed	0
33713_14100.0_2012-06-19	1410000	\N	2012-06-19	33713	\N	\N	f	Qual by exam of deed	0
33713_307900.0_2010-05-27	30790000	\N	2010-05-27	33713	\N	\N	t	Qual on DOS, multi-parcel sale	0
33714_12000.0_2019-08-22	1200000	\N	2019-08-22	33714	\N	\N	f	Qual by exam of deed	0
33714_12500.0_2012-07-11	1250000	\N	2012-07-11	33714	\N	\N	f	Qual by exam of deed	0
33714_307900.0_2010-05-27	30790000	\N	2010-05-27	33714	\N	\N	t	Qual on DOS, multi-parcel sale	0
33716_12750.0_2008-12-01	1275000	\N	2008-12-01	33716	\N	\N	f	Sales which are qualified	0
33716_13000.0_2012-02-02	1300000	\N	2012-02-02	33716	\N	\N	f	Qual by exam of deed	0
33716_18000.0_2022-07-05	1800000	\N	2022-07-05	33716	\N	\N	f	Qual by exam of deed	0
33717_20890.0_2008-12-01	2089000	\N	2008-12-01	33717	\N	\N	f	Sales which are qualified	0
33717_29000.0_2022-05-28	2900000	\N	2022-05-28	33717	\N	\N	f	Qual by exam of deed	0
33718_13800.0_2012-03-28	1380000	\N	2012-03-28	33718	\N	\N	f	Qual by exam of deed	0
33718_21000.0_2015-01-30	2100000	\N	2015-01-30	33718	\N	\N	f	Qual by exam of deed	0
33718_307900.0_2010-05-27	30790000	\N	2010-05-27	33718	\N	\N	t	Qual on DOS, multi-parcel sale	0
33719_307900.0_2010-05-27	30790000	\N	2010-05-27	33719	\N	\N	t	Qual on DOS, multi-parcel sale	0
33719_4180.0_2020-02-07	418000	\N	2020-02-07	33719	\N	\N	f	Qual by exam of deed	0
33719_4900.0_2012-11-26	490000	\N	2012-11-26	33719	\N	\N	f	Qual by exam of deed	0
33720_307900.0_2010-05-27	30790000	\N	2010-05-27	33720	\N	\N	t	Qual on DOS, multi-parcel sale	0
33720_8650.0_2020-06-03	865000	\N	2020-06-03	33720	\N	\N	f	Qual by exam of deed	0
33720_9600.0_2012-08-29	960000	\N	2012-08-29	33720	\N	\N	f	Qual by exam of deed	0
33721_11500.0_2017-04-25	1150000	\N	2017-04-25	33721	\N	\N	f	Qual by exam of deed	0
33763_3999.0_2007-01-01	399900	\N	2007-01-01	33763	\N	\N	f	Sales which are qualified	0
33763_4250.0_2023-05-19	425000	\N	2023-05-19	33763	\N	\N	f	Qual by exam of deed	0
33765_4519.0_2006-09-01	451900	\N	2006-09-01	33765	\N	\N	f	Sales which are qualified	0
33766_2500.0_2018-07-18	250000	\N	2018-07-18	33766	\N	\N	f	Qual by exam of deed	0
33766_3500.0_2008-07-01	350000	\N	2008-07-01	33766	\N	\N	f	Sales which are qualified	0
33769_12000.0_2015-05-22	1200000	\N	2015-05-22	33769	\N	\N	f	Qual by exam of deed	0
33769_48000.0_2008-09-25	4800000	\N	2008-09-25	33769	\N	\N	t	Deeds that include more than one parcel	0
33770_4000.0_2014-12-29	400000	\N	2014-12-29	33770	\N	\N	f	Qual by exam of deed	0
33770_5850.28_2006-09-01	585028	\N	2006-09-01	33770	\N	\N	f	Sales which are qualified	0
33771_2800.0_2014-06-09	280000	\N	2014-06-09	33771	\N	\N	f	Qual by exam of deed	0
33771_4209.0_2006-09-01	420900	\N	2006-09-01	33771	\N	\N	f	Sales which are qualified	0
33772_1670.0_2011-12-28	167000	\N	2011-12-28	33772	\N	\N	f	Qual by exam of deed	0
33772_4229.0_2006-10-01	422900	\N	2006-10-01	33772	\N	\N	f	Sales which are qualified	0
33773_5962.28_2006-09-01	596228	\N	2006-09-01	33773	\N	\N	f	Sales which are qualified	0
33774_4500.0_2009-02-12	450000	\N	2009-02-12	33774	\N	\N	f	Qual by exam of deed	0
33774_5609.0_2007-11-01	560900	\N	2007-11-01	33774	\N	\N	f	Sales which are qualified	0
33776_3010.0_2009-09-25	301000	\N	2009-09-25	33776	\N	\N	f	Qual by exam of deed	0
33776_6230.0_2006-10-01	623000	\N	2006-10-01	33776	\N	\N	f	Sales which are qualified	0
33776_7100.0_2023-03-01	710000	\N	2023-03-01	33776	\N	\N	f	Qual by exam of deed	0
33777_3200.0_2008-06-01	320000	\N	2008-06-01	33777	\N	\N	f	Sales which are qualified	0
33777_3350.0_2017-12-01	335000	\N	2017-12-01	33777	\N	\N	f	Qual by exam of deed	0
33777_4669.0_2006-10-01	466900	\N	2006-10-01	33777	\N	\N	f	Sales which are qualified	0
33778_2265.0_2009-09-08	226500	\N	2009-09-08	33778	\N	\N	f	Qual by exam of deed	0
33778_4159.0_2006-10-01	415900	\N	2006-10-01	33778	\N	\N	f	Sales which are qualified	0
33779_4625.0_2016-03-07	462500	\N	2016-03-07	33779	\N	\N	f	Qual by exam of deed	0
33779_4900.0_2013-05-17	490000	\N	2013-05-17	33779	\N	\N	f	Qual by exam of deed	0
33779_5709.0_2008-07-15	570900	\N	2008-07-15	33779	\N	\N	f	Sales which are qualified	0
33780_1350.0_2011-10-17	135000	\N	2011-10-17	33780	\N	\N	f	Qual by exam of deed	0
33780_2650.0_2013-04-05	265000	\N	2013-04-05	33780	\N	\N	f	Qual by exam of deed	0
33780_2800.0_2015-07-08	280000	\N	2015-07-08	33780	\N	\N	f	Qual by exam of deed	0
33780_3199.0_2006-11-01	319900	\N	2006-11-01	33780	\N	\N	f	Sales which are qualified	0
33764_3539.0_2006-09-01	353900	\N	2006-09-01	33764	\N	\N	f	Sales which are qualified	0
34324_4800.0_2002-05-01	480000	\N	2002-05-01	34324	\N	\N	f	Sales which are qualified	0
34324_5450.0_2004-04-01	545000	\N	2004-04-01	34324	\N	\N	f	Sales which are qualified	0
34448_27000.0_2006-07-01	2700000	\N	2006-07-01	34448	\N	\N	f	Sales which are qualified	0
34448_5282.0_1998-10-01	528200	\N	1998-10-01	34448	\N	\N	f	Sales which are qualified	0
34449_11750.0_2001-02-01	1175000	\N	2001-02-01	34449	\N	\N	f	Sales which are qualified	0
34569_10750.0_2007-04-01	1075000	\N	2007-04-01	34569	\N	\N	f	Sales which are qualified	0
34569_13000.0_2015-09-01	1300000	\N	2015-09-01	34569	\N	\N	f	Qual by exam of deed	0
34569_7100.0_2005-07-01	710000	\N	2005-07-01	34569	\N	\N	f	Sales which are qualified	0
34569_8500.0_2005-12-01	850000	\N	2005-12-01	34569	\N	\N	f	Sales which are qualified	0
34570_4850.0_2005-06-01	485000	\N	2005-06-01	34570	\N	\N	f	Sales which are qualified	0
34571_5000.0_2005-05-01	500000	\N	2005-05-01	34571	\N	\N	f	Sales which are qualified	0
34682_1659.0_2005-02-01	165900	\N	2005-02-01	34682	\N	\N	f	Sales which are qualified	0
34684_2541.4_2005-01-01	254140	\N	2005-01-01	34684	\N	\N	f	Sales which are qualified	0
34685_1100.0_2010-08-26	110000	\N	2010-08-26	34685	\N	\N	f	Qual by exam of deed	0
34685_1659.63_2005-01-01	165963	\N	2005-01-01	34685	\N	\N	f	Sales which are qualified	0
34685_2220.0_2014-05-16	222000	\N	2014-05-16	34685	\N	\N	f	Qual by exam of deed	0
34686_1200.0_2010-12-09	120000	\N	2010-12-09	34686	\N	\N	f	Qual by exam of deed	0
34687_1310.0_2010-12-20	131000	\N	2010-12-20	34687	\N	\N	f	Qual by exam of deed	0
34687_1602.0_2005-03-01	160200	\N	2005-03-01	34687	\N	\N	f	Sales which are qualified	0
34687_2400.0_2005-10-01	240000	\N	2005-10-01	34687	\N	\N	f	Sales which are qualified	0
34687_2730.0_2006-06-01	273000	\N	2006-06-01	34687	\N	\N	f	Sales which are qualified	0
34688_2027.27_2005-01-01	202727	\N	2005-01-01	34688	\N	\N	f	Sales which are qualified	0
34688_2200.0_2012-09-02	220000	\N	2012-09-02	34688	\N	\N	f	Qual by exam of deed	0
34688_2865.0_2005-09-01	286500	\N	2005-09-01	34688	\N	\N	f	Sales which are qualified	0
34689_1825.0_2012-05-10	182500	\N	2012-05-10	34689	\N	\N	f	Qual by exam of deed	0
34689_2017.6_2005-02-01	201760	\N	2005-02-01	34689	\N	\N	f	Sales which are qualified	0
34689_3093.0_2006-08-01	309300	\N	2006-08-01	34689	\N	\N	f	Sales which are qualified	0
34690_1800.0_2012-02-13	180000	\N	2012-02-13	34690	\N	\N	f	Qual by exam of deed	0
34690_2083.84_2005-01-01	208384	\N	2005-01-01	34690	\N	\N	f	Sales which are qualified	0
34690_2970.0_2007-06-01	297000	\N	2007-06-01	34690	\N	\N	f	Sales which are qualified	0
34692_4125.6_2005-01-01	412560	\N	2005-01-01	34692	\N	\N	f	Sales which are qualified	0
34692_5320.0_2019-02-14	532000	\N	2019-02-14	34692	\N	\N	f	Qual by exam of deed	0
34692_8000.0_2023-02-03	800000	\N	2023-02-03	34692	\N	\N	f	Qual by exam of deed	0
34693_1450.2_2009-08-20	145020	\N	2009-08-20	34693	\N	\N	f	Qual by exam of deed	0
34693_2209.0_2005-02-01	220900	\N	2005-02-01	34693	\N	\N	f	Sales which are qualified	0
34693_2850.0_2005-06-01	285000	\N	2005-06-01	34693	\N	\N	f	Sales which are qualified	0
34694_2885.24_2005-02-01	288524	\N	2005-02-01	34694	\N	\N	f	Sales which are qualified	0
34694_3750.0_2005-06-01	375000	\N	2005-06-01	34694	\N	\N	f	Sales which are qualified	0
34694_4000.0_2007-01-01	400000	\N	2007-01-01	34694	\N	\N	f	Sales which are qualified	0
34694_4400.0_2016-02-27	440000	\N	2016-02-27	34694	\N	\N	f	Qual by exam of deed	0
34694_5200.0_2023-02-15	520000	\N	2023-02-15	34694	\N	\N	f	Qual by exam of deed	0
35139_32500.0_2021-02-16	3250000	\N	2021-02-16	35139	\N	\N	f	Qual by exam of deed	0
35139_39000.0_2021-11-11	3900000	\N	2021-11-11	35139	\N	\N	f	Qual by exam of deed	0
35140_20000.0_2021-04-30	2000000	\N	2021-04-30	35140	\N	\N	f	Qual by exam of deed	0
35140_28500.0_2022-08-31	2850000	\N	2022-08-31	35140	\N	\N	f	Qual by exam of deed	0
35141_34700.0_2021-05-04	3470000	\N	2021-05-04	35141	\N	\N	f	Qual by exam of deed	0
35142_31750.0_2022-01-04	3175000	\N	2022-01-04	35142	\N	\N	f	Qual by exam of deed	0
35143_63500.0_2022-02-25	6350000	\N	2022-02-25	35143	\N	\N	f	Qual by exam of deed	0
35144_33250.0_2021-03-01	3325000	\N	2021-03-01	35144	\N	\N	f	Qual by exam of deed	0
35145_33500.0_2021-04-14	3350000	\N	2021-04-14	35145	\N	\N	f	Qual by exam of deed	0
35146_67000.0_2022-04-18	6700000	\N	2022-04-18	35146	\N	\N	f	Qual by exam of deed	0
35147_64000.0_2021-08-20	6400000	\N	2021-08-20	35147	\N	\N	f	Qual by exam of deed	0
35148_40000.0_2021-07-08	4000000	\N	2021-07-08	35148	\N	\N	f	Qual by exam of deed	0
35149_32000.0_2021-06-24	3200000	\N	2021-06-24	35149	\N	\N	f	Qual by exam of deed	0
35150_57000.0_2021-08-13	5700000	\N	2021-08-13	35150	\N	\N	f	Qual by exam of deed	0
35151_66000.0_2021-08-12	6600000	\N	2021-08-12	35151	\N	\N	f	Qual by exam of deed	0
35152_58000.0_2021-11-23	5800000	\N	2021-11-23	35152	\N	\N	f	Qual by exam of deed	0
35153_56000.0_2021-04-14	5600000	\N	2021-04-14	35153	\N	\N	f	Qual by exam of deed	0
35154_27000.0_2021-06-07	2700000	\N	2021-06-07	35154	\N	\N	f	Qual by exam of deed	0
35155_47500.0_2020-12-11	4750000	\N	2020-12-11	35155	\N	\N	f	Qual by exam of deed	0
35155_58500.0_2021-12-03	5850000	\N	2021-12-03	35155	\N	\N	f	Qual by exam of deed	0
35156_58500.0_2021-04-20	5850000	\N	2021-04-20	35156	\N	\N	f	Qual by exam of deed	0
35156_78500.0_2022-11-04	7850000	\N	2022-11-04	35156	\N	\N	f	Qual by exam of deed	0
35157_28500.0_2021-06-30	2850000	\N	2021-06-30	35157	\N	\N	f	Qual by exam of deed	0
35158_13490.0_2020-12-09	1349000	\N	2020-12-09	35158	\N	\N	f	Qual by exam of deed	0
35159_26000.0_2021-06-30	2600000	\N	2021-06-30	35159	\N	\N	f	Qual by exam of deed	0
35160_23200.0_2021-04-20	2320000	\N	2021-04-20	35160	\N	\N	f	Qual by exam of deed	0
35161_43500.0_2021-03-22	4350000	\N	2021-03-22	35161	\N	\N	f	Qual by exam of deed	0
35163_28400.0_2021-03-08	2840000	\N	2021-03-08	35163	\N	\N	f	Qual by exam of deed	0
35163_38000.0_2022-03-09	3800000	\N	2022-03-09	35163	\N	\N	f	Qual by exam of deed	0
35200_4410.0_2015-07-20	441000	\N	2015-07-20	35200	\N	\N	f	Qual by exam of deed	0
35203_2554.0_2013-01-15	255400	\N	2013-01-15	35203	\N	\N	f	Qual by exam of deed	0
35203_3511.2_2011-06-07	351120	\N	2011-06-07	35203	\N	\N	f	Qual by exam of deed	0
35205_3100.0_2021-12-21	310000	\N	2021-12-21	35205	\N	\N	f	Qual by exam of deed	0
35205_3760.0_2014-05-27	376000	\N	2014-05-27	35205	\N	\N	f	Qual by exam of deed	0
35206_2950.0_2019-10-07	295000	\N	2019-10-07	35206	\N	\N	f	Qual by exam of deed	0
35206_3100.0_2013-10-14	310000	\N	2013-10-14	35206	\N	\N	f	Qual by exam of deed	0
35210_2750.0_2020-10-08	275000	\N	2020-10-08	35210	\N	\N	f	Qual by exam of deed	0
35210_4850.0_2022-03-25	485000	\N	2022-03-25	35210	\N	\N	f	Qual by exam of deed	0
35210_6453.2_2008-11-26	645320	\N	2008-11-26	35210	\N	\N	f	Sales which are qualified	0
35211_4026.0_2012-08-16	402600	\N	2012-08-16	35211	\N	\N	f	Qual by exam of deed	0
35211_4350.0_2022-04-05	435000	\N	2022-04-05	35211	\N	\N	f	Qual by exam of deed	0
35212_4180.0_2020-12-14	418000	\N	2020-12-14	35212	\N	\N	f	Qual by exam of deed	0
35212_5026.4_2012-05-04	502640	\N	2012-05-04	35212	\N	\N	f	Qual by exam of deed	0
35213_2000.0_2020-05-18	200000	\N	2020-05-18	35213	\N	\N	f	Qual by exam of deed	0
35214_12122.3_2008-12-09	1212230	\N	2008-12-09	35214	\N	\N	f	Sales which are qualified	0
35214_7200.0_2022-12-07	720000	\N	2022-12-07	35214	\N	\N	f	Qual by exam of deed	0
35214_8200.0_2023-07-20	820000	\N	2023-07-20	35214	\N	\N	f	Qual by exam of deed	0
35215_2500.0_2019-12-11	250000	\N	2019-12-11	35215	\N	\N	f	Qual by exam of deed	0
35215_3650.0_2017-04-19	365000	\N	2017-04-19	35215	\N	\N	f	Qual by exam of deed	0
35215_4190.0_2014-03-26	419000	\N	2014-03-26	35215	\N	\N	f	Qual by exam of deed	0
35217_2065.0_2021-01-15	206500	\N	2021-01-15	35217	\N	\N	f	Qual by exam of deed	0
35217_3350.0_2014-05-16	335000	\N	2014-05-16	35217	\N	\N	f	Qual by exam of deed	0
35218_4800.0_2011-12-05	480000	\N	2011-12-05	35218	\N	\N	f	Qual by exam of deed	0
35218_6336.25_2008-12-17	633625	\N	2008-12-17	35218	\N	\N	f	Sales which are qualified	0
35222_5500.0_2014-10-14	550000	\N	2014-10-14	35222	\N	\N	f	Qual by exam of deed	0
35222_6200.0_2022-10-19	620000	\N	2022-10-19	35222	\N	\N	f	Qual by exam of deed	0
35222_7000.0_2008-12-17	700000	\N	2008-12-17	35222	\N	\N	f	Sales which are qualified	0
35223_4890.0_2008-02-01	489000	\N	2008-02-01	35223	\N	\N	f	Sales which are qualified	0
35224_6850.0_2012-07-13	685000	\N	2012-07-13	35224	\N	\N	f	Qual by exam of deed	0
35225_2920.0_2011-08-17	292000	\N	2011-08-17	35225	\N	\N	f	Qual by exam of deed	0
35225_3600.0_2018-12-05	360000	\N	2018-12-05	35225	\N	\N	f	Qual by exam of deed	0
35225_3850.0_2022-02-22	385000	\N	2022-02-22	35225	\N	\N	f	Qual by exam of deed	0
35226_4000.0_2011-07-20	400000	\N	2011-07-20	35226	\N	\N	f	Qual by exam of deed	0
35227_3270.0_2011-10-24	327000	\N	2011-10-24	35227	\N	\N	f	Qual by exam of deed	0
35552_15490.0_2016-09-19	1549000	\N	2016-09-19	35552	\N	\N	f	Qual by exam of deed	0
35552_24500.0_2018-06-20	2450000	\N	2018-06-20	35552	\N	\N	f	Qual by exam of deed	0
35553_12490.0_2016-08-01	1249000	\N	2016-08-01	35553	\N	\N	f	Qual by exam of deed	0
35553_17100.0_2020-11-24	1710000	\N	2020-11-24	35553	\N	\N	f	Qual by exam of deed	0
35554_12790.0_2016-08-29	1279000	\N	2016-08-29	35554	\N	\N	f	Qual by exam of deed	0
35555_12990.0_2016-09-21	1299000	\N	2016-09-21	35555	\N	\N	f	Qual by exam of deed	0
35556_16340.0_2016-08-04	1634000	\N	2016-08-04	35556	\N	\N	f	Qual by verifiable & documented evidence	0
35556_36500.0_2023-05-01	3650000	\N	2023-05-01	35556	\N	\N	f	Qual by exam of deed	0
35558_6890.0_2016-08-26	689000	\N	2016-08-26	35558	\N	\N	f	Qual by exam of deed	0
35558_8000.0_2019-07-19	800000	\N	2019-07-19	35558	\N	\N	f	Qual by exam of deed	0
35559_5290.0_2016-08-19	529000	\N	2016-08-19	35559	\N	\N	f	Qual by exam of deed	0
35611_21300.0_2004-03-01	2130000	\N	2004-03-01	35611	\N	\N	f	Sales which are qualified	0
35611_25000.0_2010-03-03	2500000	\N	2010-03-03	35611	\N	\N	f	Qual by exam of deed	0
35611_39500.0_2011-03-07	3950000	\N	2011-03-07	35611	\N	\N	f	Qual by exam of deed	0
35611_55000.0_2007-06-01	5500000	\N	2007-06-01	35611	\N	\N	f	Sales which are qualified	0
35611_67000.0_2016-05-17	6700000	\N	2016-05-17	35611	\N	\N	f	Qual by exam of deed	0
35612_3675.0_2004-02-01	367500	\N	2004-02-01	35612	\N	\N	f	Sales which are qualified	0
35613_16750.0_2020-11-19	1675000	\N	2020-11-19	35613	\N	\N	f	Qual by exam of deed	0
35613_19750.0_2014-06-27	1975000	\N	2014-06-27	35613	\N	\N	f	Qual by exam of deed	0
35613_5500.0_2004-03-01	550000	\N	2004-03-01	35613	\N	\N	f	Sales which are qualified	0
35614_10500.0_2004-02-01	1050000	\N	2004-02-01	35614	\N	\N	f	Sales which are qualified	0
35614_13500.0_2011-08-05	1350000	\N	2011-08-05	35614	\N	\N	f	Qual by exam of deed	0
35615_35600.0_2004-02-01	3560000	\N	2004-02-01	35615	\N	\N	f	Sales which are qualified	0
35615_69000.0_2004-05-01	6900000	\N	2004-05-01	35615	\N	\N	f	Sales which are qualified	0
35616_11000.0_2010-10-27	1100000	\N	2010-10-27	35616	\N	\N	f	Qual by exam of deed	0
35616_11500.0_2005-02-01	1150000	\N	2005-02-01	35616	\N	\N	f	Sales which are qualified	0
35616_16500.0_2006-09-01	1650000	\N	2006-09-01	35616	\N	\N	f	Sales which are qualified	0
35616_18000.0_2012-10-17	1800000	\N	2012-10-17	35616	\N	\N	f	Qual by exam of deed	0
35616_19500.0_2017-10-10	1950000	\N	2017-10-10	35616	\N	\N	f	Qual by exam of deed	0
35616_6200.0_2004-02-01	620000	\N	2004-02-01	35616	\N	\N	f	Sales which are qualified	0
35617_12900.0_2009-11-23	1290000	\N	2009-11-23	35617	\N	\N	f	Qual by exam of deed	0
35617_16300.0_2012-07-16	1630000	\N	2012-07-16	35617	\N	\N	f	Qual by exam of deed	0
35777_4220.0_1997-01-01	422000	\N	1997-01-01	35777	\N	\N	t	Deeds that include more than one parcel	0
35777_4300.0_1999-04-01	430000	\N	1999-04-01	35777	\N	\N	t	Deeds that include more than one parcel	0
35777_8400.0_2010-05-14	840000	\N	2010-05-14	35777	\N	\N	t	Qual on DOS, multi-parcel sale	0
35778_2170.0_1997-06-01	217000	\N	1997-06-01	35778	\N	\N	t	Deeds that include more than one parcel	0
35778_2250.0_2001-08-01	225000	\N	2001-08-01	35778	\N	\N	f	Sales which are qualified	0
35778_3155.0_1997-02-01	315500	\N	1997-02-01	35778	\N	\N	t	Deeds that include more than one parcel	0
35779_1143.0_1997-03-01	114300	\N	1997-03-01	35779	\N	\N	f	Sales which are qualified	0
35779_1210.0_1999-12-01	121000	\N	1999-12-01	35779	\N	\N	f	Sales which are qualified	0
35779_1950.0_2003-03-01	195000	\N	2003-03-01	35779	\N	\N	t	Deeds that include more than one parcel	0
35779_3900.0_2017-04-27	390000	\N	2017-04-27	35779	\N	\N	t	Qual on DOS, multi-parcel sale	0
35780_1650.0_1997-01-01	165000	\N	1997-01-01	35780	\N	\N	t	Deeds that include more than one parcel	0
35781_1750.0_1997-01-01	175000	\N	1997-01-01	35781	\N	\N	t	Deeds that include more than one parcel	0
35892_5000.0_2018-04-26	500000	\N	2018-04-26	35892	\N	\N	t	Qual on DOS, multi-parcel sale	0
36414_4900.0_2008-06-01	490000	\N	2008-06-01	36414	\N	\N	f	Sales which are qualified	0
36414_5727.75_2005-03-01	572775	\N	2005-03-01	36414	\N	\N	f	Sales which are qualified	0
36414_6750.0_2019-03-27	675000	\N	2019-03-27	36414	\N	\N	f	Qual by exam of deed	0
36415_4299.75_2004-11-01	429975	\N	2004-11-01	36415	\N	\N	f	Sales which are qualified	0
36415_6150.0_2005-11-01	615000	\N	2005-11-01	36415	\N	\N	f	Sales which are qualified	0
36415_7750.0_2022-01-18	775000	\N	2022-01-18	36415	\N	\N	f	Qual by exam of deed	0
36416_4795.0_2004-10-01	479500	\N	2004-10-01	36416	\N	\N	f	Sales which are qualified	0
36417_3095.0_2004-09-01	309500	\N	2004-09-01	36417	\N	\N	f	Sales which are qualified	0
36417_3900.0_2004-11-01	390000	\N	2004-11-01	36417	\N	\N	f	Sales which are qualified	0
36417_6800.0_2022-04-11	680000	\N	2022-04-11	36417	\N	\N	f	Qual by exam of deed	0
36418_2501.1_2004-08-01	250110	\N	2004-08-01	36418	\N	\N	f	Sales which are qualified	0
36419_2839.0_2004-09-01	283900	\N	2004-09-01	36419	\N	\N	f	Sales which are qualified	0
36419_3750.0_2014-09-06	375000	\N	2014-09-06	36419	\N	\N	f	Qual by exam of deed	0
36420_5495.0_2004-08-01	549500	\N	2004-08-01	36420	\N	\N	f	Sales which are qualified	0
36420_5785.0_2014-09-16	578500	\N	2014-09-16	36420	\N	\N	f	Qual by exam of deed	0
36421_3100.0_2009-04-24	310000	\N	2009-04-24	36421	\N	\N	f	Qual by exam of deed	0
36421_3950.0_2005-10-01	395000	\N	2005-10-01	36421	\N	\N	f	Sales which are qualified	0
36421_4299.75_2004-12-01	429975	\N	2004-12-01	36421	\N	\N	f	Sales which are qualified	0
36421_4600.0_2011-09-30	460000	\N	2011-09-30	36421	\N	\N	f	Qual by exam of deed	0
36422_4809.0_2004-10-01	480900	\N	2004-10-01	36422	\N	\N	f	Sales which are qualified	0
36422_5250.0_2004-12-01	525000	\N	2004-12-01	36422	\N	\N	f	Sales which are qualified	0
36422_6200.0_2007-05-01	620000	\N	2007-05-01	36422	\N	\N	f	Sales which are qualified	0
36423_3095.0_2004-08-01	309500	\N	2004-08-01	36423	\N	\N	f	Sales which are qualified	0
36423_3200.0_2010-03-26	320000	\N	2010-03-26	36423	\N	\N	f	Qual by exam of deed	0
36423_4750.0_2014-01-02	475000	\N	2014-01-02	36423	\N	\N	f	Qual by exam of deed	0
36424_2899.0_2004-12-01	289900	\N	2004-12-01	36424	\N	\N	f	Sales which are qualified	0
36424_6250.0_2013-10-30	625000	\N	2013-10-30	36424	\N	\N	f	Qual by exam of deed	0
36425_4095.0_2004-10-01	409500	\N	2004-10-01	36425	\N	\N	f	Sales which are qualified	0
36425_6315.0_2016-02-23	631500	\N	2016-02-23	36425	\N	\N	f	Qual by exam of deed	0
36425_7390.0_2022-02-18	739000	\N	2022-02-18	36425	\N	\N	f	Qual by exam of deed	0
36425_7550.0_2005-11-01	755000	\N	2005-11-01	36425	\N	\N	f	Sales which are qualified	0
36426_12000.0_2022-02-18	1200000	\N	2022-02-18	36426	\N	\N	f	Qual by exam of deed	0
36426_6700.0_2005-08-01	670000	\N	2005-08-01	36426	\N	\N	f	Sales which are qualified	0
36426_7678.0_2004-10-01	767800	\N	2004-10-01	36426	\N	\N	f	Sales which are qualified	0
36426_8100.0_2021-06-07	810000	\N	2021-06-07	36426	\N	\N	f	Qual by exam of deed	0
36427_2850.0_2009-11-12	285000	\N	2009-11-12	36427	\N	\N	f	Qual by exam of deed	0
36427_4299.75_2004-11-01	429975	\N	2004-11-01	36427	\N	\N	f	Sales which are qualified	0
36489_2675.0_2008-12-19	267500	\N	2008-12-19	36489	\N	\N	f	Other disqualified	0
36748_4300.0_2003-03-01	430000	\N	2003-03-01	36748	\N	\N	f	Sales which are qualified	0
36749_4190.0_2003-02-01	419000	\N	2003-02-01	36749	\N	\N	f	Sales which are qualified	0
36750_3350.0_2012-12-11	335000	\N	2012-12-11	36750	\N	\N	f	Qual by exam of deed	0
36750_4200.0_2005-08-01	420000	\N	2005-08-01	36750	\N	\N	f	Sales which are qualified	0
36751_3216.5_2003-06-01	321650	\N	2003-06-01	36751	\N	\N	f	Sales which are qualified	0
36751_5383.5_2005-09-01	538350	\N	2005-09-01	36751	\N	\N	f	Sales which are qualified	0
36751_5850.0_2015-08-27	585000	\N	2015-08-27	36751	\N	\N	f	Qual by exam of deed	0
36752_2100.0_2011-08-10	210000	\N	2011-08-10	36752	\N	\N	f	Qual by exam of deed	0
36752_2348.0_2003-04-01	234800	\N	2003-04-01	36752	\N	\N	f	Sales which are qualified	0
36752_5000.0_2023-03-21	500000	\N	2023-03-21	36752	\N	\N	f	Qual by exam of deed	0
36753_2700.0_2010-09-07	270000	\N	2010-09-07	36753	\N	\N	f	Qual by exam of deed	0
36753_3616.0_2003-05-01	361600	\N	2003-05-01	36753	\N	\N	f	Sales which are qualified	0
36753_3700.0_2004-05-01	370000	\N	2004-05-01	36753	\N	\N	f	Sales which are qualified	0
36754_3089.0_2003-03-01	308900	\N	2003-03-01	36754	\N	\N	f	Sales which are qualified	0
36754_4360.0_2004-11-01	436000	\N	2004-11-01	36754	\N	\N	f	Sales which are qualified	0
36754_4630.0_2008-12-15	463000	\N	2008-12-15	36754	\N	\N	f	Sales which are qualified	0
36754_6900.0_2014-05-23	690000	\N	2014-05-23	36754	\N	\N	f	Qual by exam of deed	0
36755_3789.0_2003-02-01	378900	\N	2003-02-01	36755	\N	\N	f	Sales which are qualified	0
36755_4700.0_2008-08-01	470000	\N	2008-08-01	36755	\N	\N	f	Sales which are qualified	0
36755_5375.49_2011-10-20	537549	\N	2011-10-20	36755	\N	\N	f	Qual by exam of deed	0
36755_5850.0_2007-03-01	585000	\N	2007-03-01	36755	\N	\N	f	Sales which are qualified	0
36755_8400.0_2007-03-01	840000	\N	2007-03-01	36755	\N	\N	f	Sales which are qualified	0
36756_2609.0_2003-03-01	260900	\N	2003-03-01	36756	\N	\N	f	Sales which are qualified	0
36756_5190.0_2021-09-14	519000	\N	2021-09-14	36756	\N	\N	f	Qual by exam of deed	0
36757_2324.0_2003-07-01	232400	\N	2003-07-01	36757	\N	\N	f	Sales which are qualified	0
36758_2085.0_2003-06-01	208500	\N	2003-06-01	36758	\N	\N	f	Sales which are qualified	0
36758_2529.0_2003-06-01	252900	\N	2003-06-01	36758	\N	\N	f	Sales which are qualified	0
36758_3850.0_2004-10-01	385000	\N	2004-10-01	36758	\N	\N	f	Sales which are qualified	0
36758_5160.0_2006-04-01	516000	\N	2006-04-01	36758	\N	\N	f	Sales which are qualified	0
36758_8200.0_2007-01-01	820000	\N	2007-01-01	36758	\N	\N	f	Sales which are qualified	0
36759_2309.0_2003-08-01	230900	\N	2003-08-01	36759	\N	\N	f	Sales which are qualified	0
37155_7400.0_2012-12-18	740000	\N	2012-12-18	37155	\N	\N	f	Qual by exam of deed	0
37156_107780.0_2021-01-27	10778000	\N	2021-01-27	37156	\N	\N	t	Qual on DOS, multi-parcel sale	0
37156_7600.0_2011-08-01	760000	\N	2011-08-01	37156	\N	\N	f	Qual by exam of deed	0
37156_8750.0_2014-04-11	875000	\N	2014-04-11	37156	\N	\N	f	Qual by exam of deed	0
37158_7900.0_2011-08-18	790000	\N	2011-08-18	37158	\N	\N	f	Qual by exam of deed	0
37159_10400.0_2011-05-05	1040000	\N	2011-05-05	37159	\N	\N	f	Qual by exam of deed	0
37159_107780.0_2021-01-27	10778000	\N	2021-01-27	37159	\N	\N	t	Qual on DOS, multi-parcel sale	0
37159_9000.0_2014-05-05	900000	\N	2014-05-05	37159	\N	\N	f	Qual by exam of deed	0
37510_107780.0_2021-01-27	10778000	\N	2021-01-27	37510	\N	\N	t	Qual on DOS, multi-parcel sale	0
37510_6400.0_2011-06-23	640000	\N	2011-06-23	37510	\N	\N	f	Qual by exam of deed	0
37510_9450.0_2015-03-09	945000	\N	2015-03-09	37510	\N	\N	f	Qual by exam of deed	0
37511_10000.0_2015-04-29	1000000	\N	2015-04-29	37511	\N	\N	f	Qual by exam of deed	0
37511_7100.0_2011-07-22	710000	\N	2011-07-22	37511	\N	\N	f	Qual by exam of deed	0
37511_8500.0_2013-07-29	850000	\N	2013-07-29	37511	\N	\N	f	Qual by exam of deed	0
37512_31000.0_2015-10-23	3100000	\N	2015-10-23	37512	\N	\N	f	Qual by exam of deed	0
37512_36500.0_2022-05-06	3650000	\N	2022-05-06	37512	\N	\N	f	Qual by exam of deed	0
37513_7450.0_2011-09-15	745000	\N	2011-09-15	37513	\N	\N	f	Qual by exam of deed	0
37514_7300.0_2011-12-20	730000	\N	2011-12-20	37514	\N	\N	f	Qual by exam of deed	0
37516_12000.0_2016-03-25	1200000	\N	2016-03-25	37516	\N	\N	f	Qual by exam of deed	0
37516_9969.0_2009-11-12	996900	\N	2009-11-12	37516	\N	\N	f	Qual by exam of deed	0
37517_18000.0_2022-11-16	1800000	\N	2022-11-16	37517	\N	\N	f	Qual by exam of deed	0
37517_18990.0_2013-05-10	1899000	\N	2013-05-10	37517	\N	\N	f	Qual by exam of deed	0
37518_107780.0_2021-01-27	10778000	\N	2021-01-27	37518	\N	\N	t	Qual on DOS, multi-parcel sale	0
37518_7400.0_2012-02-03	740000	\N	2012-02-03	37518	\N	\N	f	Qual by exam of deed	0
37518_9300.0_2014-09-22	930000	\N	2014-09-22	37518	\N	\N	f	Qual by exam of deed	0
37520_17500.0_2012-02-03	1750000	\N	2012-02-03	37520	\N	\N	f	Qual by exam of deed	0
37520_19500.0_2021-05-27	1950000	\N	2021-05-27	37520	\N	\N	f	Qual by exam of deed	0
37521_14600.0_2012-04-19	1460000	\N	2012-04-19	37521	\N	\N	f	Qual by exam of deed	0
153203_330.0_1992-05-01	33000	\N	1992-05-01	153203	\N	\N	f	Sales which are qualified	0
153203_350.0_1986-04-01	35000	\N	1986-04-01	153203	\N	\N	f	Sales which are qualified	0
153205_245.0_1976-09-01	24500	\N	1976-09-01	153205	\N	\N	f	Sales which are qualified	0
153205_2910.0_2018-05-25	291000	\N	2018-05-25	153205	\N	\N	f	Qual by exam of deed	0
153205_890.0_2000-03-01	89000	\N	2000-03-01	153205	\N	\N	f	Sales which are qualified	0
153206_1280.0_2001-12-01	128000	\N	2001-12-01	153206	\N	\N	f	Sales which are qualified	0
153206_188.0_1977-03-01	18800	\N	1977-03-01	153206	\N	\N	f	Sales which are qualified	0
153206_245.0_1989-05-01	24500	\N	1989-05-01	153206	\N	\N	f	Sales which are qualified	0
153206_910.0_1999-09-01	91000	\N	1999-09-01	153206	\N	\N	f	Sales which are qualified	0
153207_230.0_1976-11-01	23000	\N	1976-11-01	153207	\N	\N	f	Sales which are qualified	0
153207_256.0_1978-08-01	25600	\N	1978-08-01	153207	\N	\N	f	Sales which are qualified	0
153207_3400.0_2021-12-16	340000	\N	2021-12-16	153207	\N	\N	f	Qual by exam of deed	0
153207_350.0_1982-09-01	35000	\N	1982-09-01	153207	\N	\N	f	Sales which are qualified	0
153207_850.0_1996-08-01	85000	\N	1996-08-01	153207	\N	\N	f	Sales which are qualified	0
153208_1750.0_2003-06-01	175000	\N	2003-06-01	153208	\N	\N	f	Sales which are qualified	0
153208_3300.0_2006-09-01	330000	\N	2006-09-01	153208	\N	\N	f	Sales which are qualified	0
153208_3300.0_2015-06-23	330000	\N	2015-06-23	153208	\N	\N	f	Qual by exam of deed	0
153208_3600.0_2022-03-01	360000	\N	2022-03-01	153208	\N	\N	f	Qual by exam of deed	0
153208_850.0_1998-08-01	85000	\N	1998-08-01	153208	\N	\N	f	Sales which are qualified	0
153209_1600.0_2003-05-01	160000	\N	2003-05-01	153209	\N	\N	f	Sales which are qualified	0
153209_1751.0_2003-08-01	175100	\N	2003-08-01	153209	\N	\N	f	Sales which are qualified	0
153209_2050.0_2012-09-04	205000	\N	2012-09-04	153209	\N	\N	f	Qual by exam of deed	0
153209_3020.0_2019-01-31	302000	\N	2019-01-31	153209	\N	\N	f	Qual by exam of deed	0
153210_1200.0_2000-12-01	120000	\N	2000-12-01	153210	\N	\N	f	Sales which are qualified	0
153210_2800.0_2013-09-04	280000	\N	2013-09-04	153210	\N	\N	f	Qual by exam of deed	0
153210_3100.0_2018-10-25	310000	\N	2018-10-25	153210	\N	\N	f	Qual by exam of deed	0
153210_365.0_1988-07-01	36500	\N	1988-07-01	153210	\N	\N	f	Sales which are qualified	0
153211_435.0_1990-11-01	43500	\N	1990-11-01	153211	\N	\N	f	Sales which are qualified	0
153212_2650.0_2008-10-15	265000	\N	2008-10-15	153212	\N	\N	f	Sales which are qualified	0
153212_3150.0_2017-05-30	315000	\N	2017-05-30	153212	\N	\N	f	Qual by exam of deed	0
153213_1800.0_2004-07-01	180000	\N	2004-07-01	153213	\N	\N	f	Sales which are qualified	0
82107_17500.0_2024-05-16	1750000	\N	2024-05-16	82107	\N	\N	f	Qual by exam of deed	0
82112_16000.0_2024-04-04	1600000	\N	2024-04-04	82112	\N	\N	f	Qual by exam of deed	0
82261_12500.0_2024-03-28	1250000	\N	2024-03-28	82261	\N	\N	f	Qual by exam of deed	0
82326_15000.0_2024-03-12	1500000	\N	2024-03-12	82326	\N	\N	f	Qual by exam of deed	0
82538_8700.0_2024-03-01	870000	\N	2024-03-01	82538	\N	\N	f	Qual by exam of deed	0
82559_7250.0_2024-03-28	725000	\N	2024-03-28	82559	\N	\N	f	Qual by exam of deed	0
83242_20500.0_2024-04-03	2050000	\N	2024-04-03	83242	\N	\N	f	Qual by exam of deed	0
52681_11000.0_2024-05-16	1100000	\N	2024-05-16	52681	\N	\N	f	Qual by exam of deed	0
52717_7400.0_2024-03-27	740000	\N	2024-03-27	52717	\N	\N	f	Qual by exam of deed	0
52744_8200.0_2024-05-06	820000	\N	2024-05-06	52744	\N	\N	f	Qual by exam of deed	0
52751_7750.0_2024-03-26	775000	\N	2024-03-26	52751	\N	\N	f	Qual by exam of deed	0
52775_11500.0_2024-04-19	1150000	\N	2024-04-19	52775	\N	\N	f	Qual by exam of deed	0
53519_7650.0_2024-04-24	765000	\N	2024-04-24	53519	\N	\N	f	Qual by exam of deed	0
53534_6150.0_2024-03-22	615000	\N	2024-03-22	53534	\N	\N	f	Qual by exam of deed	0
82985_23500.0_2024-04-01	2350000	\N	2024-04-01	82985	\N	\N	f	Qual by exam of deed	0
83045_14000.0_2024-03-22	1400000	\N	2024-03-22	83045	\N	\N	f	Qual by exam of deed	0
83054_8500.0_2024-05-08	850000	\N	2024-05-08	83054	\N	\N	f	Qual by exam of deed	0
83056_8180.0_2024-06-04	818000	\N	2024-06-04	83056	\N	\N	f	Qual by exam of deed	0
83093_26000.0_2024-04-04	2600000	\N	2024-04-04	83093	\N	\N	f	Qual by exam of deed	0
83124_17363.0_2024-05-15	1736300	\N	2024-05-15	83124	\N	\N	f	Qual by exam of deed	0
82624_37500.0_2024-06-10	3750000	\N	2024-06-10	82624	\N	\N	t	Qual on DOS, multi-parcel sale	0
82634_18750.0_2024-04-17	1875000	\N	2024-04-17	82634	\N	\N	f	Qual by exam of deed	0
82644_37500.0_2024-06-10	3750000	\N	2024-06-10	82644	\N	\N	t	Qual on DOS, multi-parcel sale	0
82672_16950.0_2024-04-12	1695000	\N	2024-04-12	82672	\N	\N	f	Qual by exam of deed	0
82679_17500.0_2024-05-15	1750000	\N	2024-05-15	82679	\N	\N	f	Qual by exam of deed	0
82681_29507.0_2024-03-21	2950700	\N	2024-03-21	82681	\N	\N	f	Qual by exam of deed	0
82686_12500.0_2024-05-17	1250000	\N	2024-05-17	82686	\N	\N	f	Qual by exam of deed	0
82712_10000.0_2024-04-24	1000000	\N	2024-04-24	82712	\N	\N	f	Qual by exam of deed	0
82717_8500.0_2024-03-21	850000	\N	2024-03-21	82717	\N	\N	f	Qual by exam of deed	0
82722_7350.0_2024-04-29	735000	\N	2024-04-29	82722	\N	\N	f	Qual by exam of deed	0
132017_60000.0_2024-05-10	6000000	\N	2024-05-10	132017	\N	\N	f	Qual by exam of deed	0
132027_120000.0_2024-05-28	12000000	\N	2024-05-28	132027	\N	\N	f	Qual by exam of deed	0
132045_27500.0_2024-03-19	2750000	\N	2024-03-19	132045	\N	\N	f	Qual by exam of deed	0
132058_250000.0_2024-04-08	25000000	\N	2024-04-08	132058	\N	\N	f	Qual by exam of deed	0
80508_13250.0_2024-05-28	1325000	\N	2024-05-28	80508	\N	\N	f	Qual by exam of deed	0
80565_9000.0_2024-05-28	900000	\N	2024-05-28	80565	\N	\N	f	Qual by exam of deed	0
80603_8150.0_2024-03-13	815000	\N	2024-03-13	80603	\N	\N	f	Qual by exam of deed	0
80633_8500.0_2024-05-03	850000	\N	2024-05-03	80633	\N	\N	f	Qual by exam of deed	0
80640_8300.0_2024-04-16	830000	\N	2024-04-16	80640	\N	\N	f	Qual by exam of deed	0
52431_17000.0_2024-04-13	1700000	\N	2024-04-13	52431	\N	\N	f	Qual by exam of deed	0
52633_73250.0_2024-04-08	7325000	\N	2024-04-08	52633	\N	\N	f	Qual by exam of deed	0
53102_85000.0_2024-05-15	8500000	\N	2024-05-15	53102	\N	\N	f	Qual by exam of deed	0
53127_30000.0_2024-05-06	3000000	\N	2024-05-06	53127	\N	\N	f	Qual by exam of deed	0
53133_157500.0_2024-05-29	15750000	\N	2024-05-29	53133	\N	\N	f	Qual by exam of deed	0
53143_8500.0_2024-03-27	850000	\N	2024-03-27	53143	\N	\N	f	Qual by exam of deed	0
53162_8400.0_2024-03-28	840000	\N	2024-03-28	53162	\N	\N	f	Qual by exam of deed	0
53165_8100.0_2024-03-18	810000	\N	2024-03-18	53165	\N	\N	f	Qual by exam of deed	0
53197_8000.0_2024-05-08	800000	\N	2024-05-08	53197	\N	\N	f	Qual by exam of deed	0
53205_8050.0_2024-05-17	805000	\N	2024-05-17	53205	\N	\N	f	Qual by exam of deed	0
53273_48550.0_2024-06-07	4855000	\N	2024-06-07	53273	\N	\N	f	Qual by exam of deed	0
53314_43700.0_2024-04-18	4370000	\N	2024-04-18	53314	\N	\N	f	Qual by exam of deed	0
53476_4575.0_2024-05-01	457500	\N	2024-05-01	53476	\N	\N	f	Qual by exam of deed	0
53523_6000.0_2024-04-29	600000	\N	2024-04-29	53523	\N	\N	f	Qual by exam of deed	0
53524_6867.0_2024-04-10	686700	\N	2024-04-10	53524	\N	\N	f	Qual by exam of deed	0
53550_7790.0_2024-04-26	779000	\N	2024-04-26	53550	\N	\N	f	Qual by exam of deed	0
130071_14900.0_2024-05-21	1490000	\N	2024-05-21	130071	\N	\N	f	Qual by exam of deed	0
130099_13150.0_2024-05-30	1315000	\N	2024-05-30	130099	\N	\N	f	Qual by exam of deed	0
130133_21000.0_2024-03-14	2100000	\N	2024-03-14	130133	\N	\N	f	Qual by exam of deed	0
139405_11000.0_2024-03-26	1100000	\N	2024-03-26	139405	\N	\N	f	Qual by exam of deed	0
139407_6050.0_2024-04-12	605000	\N	2024-04-12	139407	\N	\N	f	Qual by exam of deed	0
139437_5351.0_2024-05-07	535100	\N	2024-05-07	139437	\N	\N	f	Qual by exam of deed	0
139438_4500.0_2024-05-01	450000	\N	2024-05-01	139438	\N	\N	f	Qual by exam of deed	0
139440_5075.0_2024-05-29	507500	\N	2024-05-29	139440	\N	\N	f	Qual by exam of deed	0
139474_4700.0_2024-04-29	470000	\N	2024-04-29	139474	\N	\N	f	Qual by exam of deed	0
139555_4500.0_2024-03-25	450000	\N	2024-03-25	139555	\N	\N	f	Qual by exam of deed	0
139557_5650.0_2024-04-18	565000	\N	2024-04-18	139557	\N	\N	f	Qual by exam of deed	0
139569_10000.0_2023-11-06	1000000	\N	2023-11-06	139569	\N	\N	t	Qual on DOS, multi-parcel sale	0
139572_5150.0_2024-05-14	515000	\N	2024-05-14	139572	\N	\N	f	Qual by exam of deed	0
139601_5550.0_2024-01-13	555000	\N	2024-01-13	139601	\N	\N	f	Qual by exam of deed	0
80690_13000.0_2024-05-03	1300000	\N	2024-05-03	80690	\N	\N	f	Qual by exam of deed	0
52935_39200.0_2024-05-15	3920000	\N	2024-05-15	52935	\N	\N	f	Qual by exam of deed	0
53015_17500.0_2024-05-29	1750000	\N	2024-05-29	53015	\N	\N	f	Qual by exam of deed	0
130203_4500.0_2024-03-28	450000	\N	2024-03-28	130203	\N	\N	f	Qual by exam of deed	0
133951_9000.0_2024-04-29	900000	\N	2024-04-29	133951	\N	\N	f	Qual by exam of deed	0
129284_9300.0_2024-03-20	930000	\N	2024-03-20	129284	\N	\N	f	Qual by exam of deed	0
129377_9550.0_2024-03-28	955000	\N	2024-03-28	129377	\N	\N	f	Qual by exam of deed	0
129404_4800.0_2024-04-26	480000	\N	2024-04-26	129404	\N	\N	f	Qual by exam of deed	0
129587_11500.0_2024-05-15	1150000	\N	2024-05-15	129587	\N	\N	f	Qual by exam of deed	0
129650_16000.0_2024-04-23	1600000	\N	2024-04-23	129650	\N	\N	f	Qual by exam of deed	0
129681_8000.0_2024-06-06	800000	\N	2024-06-06	129681	\N	\N	f	Qual by exam of deed	0
130425_3050.0_2024-03-18	305000	\N	2024-03-18	130425	\N	\N	f	Qual by exam of deed	0
130449_3700.0_2024-05-15	370000	\N	2024-05-15	130449	\N	\N	f	Qual by exam of deed	0
130453_3000.0_2024-04-30	300000	\N	2024-04-30	130453	\N	\N	f	Qual by exam of deed	0
130597_3450.0_2024-03-06	345000	\N	2024-03-06	130597	\N	\N	f	Qual by exam of deed	0
130653_4050.0_2024-04-01	405000	\N	2024-04-01	130653	\N	\N	f	Qual by exam of deed	0
130731_8600.0_2024-04-04	860000	\N	2024-04-04	130731	\N	\N	f	Qual by exam of deed	0
130452_3300.0_2024-05-31	330000	\N	2024-05-31	130452	\N	\N	f	Qual by exam of deed	0
130541_3880.0_2024-05-15	388000	\N	2024-05-15	130541	\N	\N	f	Qual by exam of deed	0
130587_5800.0_2024-05-30	580000	\N	2024-05-30	130587	\N	\N	f	Qual by exam of deed	0
130704_4320.0_2024-05-31	432000	\N	2024-05-31	130704	\N	\N	f	Qual by exam of deed	0
130785_3500.0_2024-05-22	350000	\N	2024-05-22	130785	\N	\N	f	Qual by exam of deed	0
32959_38000.0_2024-05-21	3800000	\N	2024-05-21	32959	\N	\N	f	Qual by exam of deed	0
33021_62250.0_2024-04-29	6225000	\N	2024-04-29	33021	\N	\N	f	Qual by exam of deed	0
33039_30000.0_2024-04-11	3000000	\N	2024-04-11	33039	\N	\N	f	Qual by exam of deed	0
33084_52500.0_2024-04-13	5250000	\N	2024-04-13	33084	\N	\N	f	Qual by exam of deed	0
33091_43700.0_2024-03-20	4370000	\N	2024-03-20	33091	\N	\N	f	Qual by exam of deed	0
33106_80000.0_2024-03-18	8000000	\N	2024-03-18	33106	\N	\N	f	Qual by exam of deed	0
35862_13000.0_2024-06-05	1300000	\N	2024-06-05	35862	\N	\N	f	Qual by exam of deed	0
35870_14800.0_2021-11-30	1480000	\N	2021-11-30	35870	\N	\N	f	Qual by exam of deed	0
34801_8420.0_2024-06-04	842000	\N	2024-06-04	34801	\N	\N	f	Qual by exam of deed	0
34812_3350.0_2024-03-22	335000	\N	2024-03-22	34812	\N	\N	f	Qual by exam of deed	0
34823_4290.0_2024-04-30	429000	\N	2024-04-30	34823	\N	\N	f	Qual by exam of deed	0
34930_3100.0_2024-05-16	310000	\N	2024-05-16	34930	\N	\N	f	Qual by exam of deed	0
34972_6600.0_2024-05-10	660000	\N	2024-05-10	34972	\N	\N	f	Qual by exam of deed	0
35022_2700.0_2024-06-12	270000	\N	2024-06-12	35022	\N	\N	f	Qual by exam of deed	0
35029_3650.0_2024-05-29	365000	\N	2024-05-29	35029	\N	\N	f	Qual by exam of deed	0
35128_6500.0_2024-05-14	650000	\N	2024-05-14	35128	\N	\N	f	Qual by exam of deed	0
34733_3467.0_2024-06-06	346700	\N	2024-06-06	34733	\N	\N	f	Qual by exam of deed	0
36755_9900.0_2024-05-16	990000	\N	2024-05-16	36755	\N	\N	f	Qual by exam of deed	0
36790_5135.0_2024-05-24	513500	\N	2024-05-24	36790	\N	\N	f	Qual by exam of deed	0
36796_6800.0_2024-05-02	680000	\N	2024-05-02	36796	\N	\N	f	Qual by exam of deed	0
37008_5200.0_2024-03-25	520000	\N	2024-03-25	37008	\N	\N	f	Qual by exam of deed	0
37014_9000.0_2024-05-22	900000	\N	2024-05-22	37014	\N	\N	f	Qual by exam of deed	0
127939_3415.0_2024-03-08	341500	\N	2024-03-08	127939	\N	\N	f	Qual by exam of deed	0
127967_4838.0_2024-04-03	483800	\N	2024-04-03	127967	\N	\N	f	Qual by exam of deed	0
128020_6900.0_2024-03-27	690000	\N	2024-03-27	128020	\N	\N	f	Qual by exam of deed	0
128028_3380.0_2024-03-12	338000	\N	2024-03-12	128028	\N	\N	f	Qual by exam of deed	0
128048_3900.0_2024-03-29	390000	\N	2024-03-29	128048	\N	\N	f	Qual by exam of deed	0
128105_2750.0_2024-06-13	275000	\N	2024-06-13	128105	\N	\N	f	Qual by exam of deed	0
128200_3110.0_2024-05-13	311000	\N	2024-05-13	128200	\N	\N	f	Qual by exam of deed	0
128211_3500.0_2024-05-21	350000	\N	2024-05-21	128211	\N	\N	f	Qual by exam of deed	0
128251_9750.0_2024-04-10	975000	\N	2024-04-10	128251	\N	\N	f	Qual by exam of deed	0
128285_3300.0_2024-04-30	330000	\N	2024-04-30	128285	\N	\N	f	Qual by exam of deed	0
128286_3230.0_2024-05-13	323000	\N	2024-05-13	128286	\N	\N	f	Qual by exam of deed	0
128293_4300.0_2024-04-15	430000	\N	2024-04-15	128293	\N	\N	f	Qual by exam of deed	0
128236_3690.0_2022-12-16	369000	\N	2022-12-16	128236	\N	\N	f	Qual by exam of deed	0
126606_32500.0_2024-05-22	3250000	\N	2024-05-22	126606	\N	\N	f	Qual by exam of deed	0
126631_8750.0_2024-04-25	875000	\N	2024-04-25	126631	\N	\N	f	Qual by exam of deed	0
126636_7650.0_2024-03-29	765000	\N	2024-03-29	126636	\N	\N	f	Qual by exam of deed	0
126664_15000.0_2024-04-01	1500000	\N	2024-04-01	126664	\N	\N	f	Qual by exam of deed	0
126694_11060.0_2024-05-13	1106000	\N	2024-05-13	126694	\N	\N	f	Qual by exam of deed	0
126696_12900.0_2024-05-07	1290000	\N	2024-05-07	126696	\N	\N	f	Qual by exam of deed	0
33627_23490.0_2024-05-09	2349000	\N	2024-05-09	33627	\N	\N	f	Qual by exam of deed	0
33760_25000.0_2024-04-30	2500000	\N	2024-04-30	33760	\N	\N	f	Qual by exam of deed	0
33938_2410.0_2022-04-18	241000	\N	2022-04-18	33938	\N	\N	f	Qual by exam of deed	0
33938_3400.0_2024-04-05	340000	\N	2024-04-05	33938	\N	\N	f	Qual by exam of deed	0
33970_3400.0_2024-05-05	340000	\N	2024-05-05	33970	\N	\N	f	Qual by exam of deed	0
34084_5000.0_2024-05-07	500000	\N	2024-05-07	34084	\N	\N	f	Qual by exam of deed	0
34091_5490.0_2024-04-15	549000	\N	2024-04-15	34091	\N	\N	f	Qual by exam of deed	0
34148_3090.0_2024-03-28	309000	\N	2024-03-28	34148	\N	\N	f	Qual by exam of deed	0
34226_4800.0_2024-04-08	480000	\N	2024-04-08	34226	\N	\N	f	Qual by exam of deed	0
34230_3500.0_2024-04-26	350000	\N	2024-04-26	34230	\N	\N	f	Qual by exam of deed	0
34259_3760.0_2024-04-24	376000	\N	2024-04-24	34259	\N	\N	f	Qual by exam of deed	0
34265_3850.0_2024-03-22	385000	\N	2024-03-22	34265	\N	\N	f	Qual by exam of deed	0
34274_3250.0_2024-04-23	325000	\N	2024-04-23	34274	\N	\N	f	Qual by exam of deed	0
33927_3450.0_2024-03-14	345000	\N	2024-03-14	33927	\N	\N	f	Qual by exam of deed	0
34514_28750.0_2024-04-15	2875000	\N	2024-04-15	34514	\N	\N	f	Qual by exam of deed	0
34586_14750.0_2024-05-28	1475000	\N	2024-05-28	34586	\N	\N	f	Qual by exam of deed	0
35139_43875.0_2024-04-02	4387500	\N	2024-04-02	35139	\N	\N	f	Qual by exam of deed	0
35167_64000.0_2024-03-27	6400000	\N	2024-03-27	35167	\N	\N	f	Qual by exam of deed	0
35227_5150.0_2024-03-20	515000	\N	2024-03-20	35227	\N	\N	f	Qual by exam of deed	0
35762_48000.0_2024-03-27	4800000	\N	2024-03-27	35762	\N	\N	f	Qual by exam of deed	0
36515_5200.0_2024-03-25	520000	\N	2024-03-25	36515	\N	\N	f	Qual by exam of deed	0
36522_14250.0_2024-04-03	1425000	\N	2024-04-03	36522	\N	\N	f	Qual by exam of deed	0
36594_16000.0_2024-04-29	1600000	\N	2024-04-29	36594	\N	\N	f	Qual by exam of deed	0
36626_10950.0_2024-03-28	1095000	\N	2024-03-28	36626	\N	\N	f	Qual by exam of deed	0
36660_4990.0_2024-04-18	499000	\N	2024-04-18	36660	\N	\N	f	Qual by exam of deed	0
36704_10000.0_2024-04-09	1000000	\N	2024-04-09	36704	\N	\N	f	Qual by exam of deed	0
36723_8250.0_2024-05-14	825000	\N	2024-05-14	36723	\N	\N	f	Qual by exam of deed	0
37358_13000.0_2024-03-28	1300000	\N	2024-03-28	37358	\N	\N	f	Qual by exam of deed	0
37436_22500.0_2024-05-20	2250000	\N	2024-05-20	37436	\N	\N	f	Qual by exam of deed	0
128295_4450.0_2024-05-02	445000	\N	2024-05-02	128295	\N	\N	f	Qual by exam of deed	0
126555_7000.0_2024-03-27	700000	\N	2024-03-27	126555	\N	\N	f	Qual by exam of deed	0
126562_6250.0_2024-04-11	625000	\N	2024-04-11	126562	\N	\N	f	Qual by exam of deed	0
88545_72500.0_2024-04-16	7250000	\N	2024-04-16	88545	\N	\N	f	Qual by exam of deed	0
89551_162000.0_2023-04-03	16200000	\N	2023-04-03	89551	\N	\N	f	Qual by exam of deed	0
89598_144000.0_2024-05-13	14400000	\N	2024-05-13	89598	\N	\N	f	Qual by exam of deed	0
89369_100000.0_2024-05-15	10000000	\N	2024-05-15	89369	\N	\N	f	Qual by exam of deed	0
89381_137650.0_2024-05-29	13765000	\N	2024-05-29	89381	\N	\N	f	Qual by exam of deed	0
89477_62500.0_2024-03-18	6250000	\N	2024-03-18	89477	\N	\N	f	Qual by exam of deed	0
89482_57500.0_2024-03-15	5750000	\N	2024-03-15	89482	\N	\N	f	Qual by exam of deed	0
89535_14000.0_2024-03-29	1400000	\N	2024-03-29	89535	\N	\N	f	Qual by exam of deed	0
87596_47000.0_2024-04-17	4700000	\N	2024-04-17	87596	\N	\N	f	Qual by exam of deed	0
87617_29550.0_2024-04-10	2955000	\N	2024-04-10	87617	\N	\N	f	Qual by exam of deed	0
87641_52500.0_2024-04-16	5250000	\N	2024-04-16	87641	\N	\N	f	Qual by exam of deed	0
87655_108500.0_2024-04-15	10850000	\N	2024-04-15	87655	\N	\N	f	Qual by exam of deed	0
87658_178000.0_2024-05-08	17800000	\N	2024-05-08	87658	\N	\N	f	Qual by exam of deed	0
87678_69000.0_2024-05-15	6900000	\N	2024-05-15	87678	\N	\N	f	Qual by exam of deed	0
87726_52000.0_2024-04-10	5200000	\N	2024-04-10	87726	\N	\N	f	Qual by exam of deed	0
87734_67500.0_2024-05-28	6750000	\N	2024-05-28	87734	\N	\N	f	Qual by exam of deed	0
88210_45000.0_2024-05-15	4500000	\N	2024-05-15	88210	\N	\N	f	Qual by exam of deed	0
87869_8650.0_2024-03-26	865000	\N	2024-03-26	87869	\N	\N	f	Qual by exam of deed	0
89619_22400.0_2024-04-18	2240000	\N	2024-04-18	89619	\N	\N	f	Qual by exam of deed	0
89640_34520.0_2024-03-18	3452000	\N	2024-03-18	89640	\N	\N	f	Qual by exam of deed	0
87387_53000.0_2024-05-28	5300000	\N	2024-05-28	87387	\N	\N	f	Qual by exam of deed	0
87461_59000.0_2024-06-06	5900000	\N	2024-06-06	87461	\N	\N	f	Qual by exam of deed	0
87463_36500.0_2024-03-08	3650000	\N	2024-03-08	87463	\N	\N	f	Qual by exam of deed	0
87509_57500.0_2024-06-04	5750000	\N	2024-06-04	87509	\N	\N	f	Qual by exam of deed	0
87549_25000.0_2024-06-06	2500000	\N	2024-06-06	87549	\N	\N	f	Qual by exam of deed	0
88573_13000.0_2024-04-01	1300000	\N	2024-04-01	88573	\N	\N	f	Qual by exam of deed	0
88694_16000.0_2024-04-22	1600000	\N	2024-04-22	88694	\N	\N	f	Qual by exam of deed	0
88774_12600.0_2024-05-07	1260000	\N	2024-05-07	88774	\N	\N	f	Qual by exam of deed	0
88192_7250.0_2024-05-17	725000	\N	2024-05-17	88192	\N	\N	f	Qual by exam of deed	0
89756_12250.0_2024-06-07	1225000	\N	2024-06-07	89756	\N	\N	f	Qual by exam of deed	0
89833_8650.0_2024-05-16	865000	\N	2024-05-16	89833	\N	\N	f	Qual by exam of deed	0
89858_8000.0_2024-03-22	800000	\N	2024-03-22	89858	\N	\N	f	Qual by exam of deed	0
89859_8500.0_2024-05-17	850000	\N	2024-05-17	89859	\N	\N	f	Qual by exam of deed	0
89892_12000.0_2024-03-27	1200000	\N	2024-03-27	89892	\N	\N	f	Qual by exam of deed	0
89934_14750.0_2024-03-15	1475000	\N	2024-03-15	89934	\N	\N	f	Qual by exam of deed	0
89966_16500.0_2024-05-31	1650000	\N	2024-05-31	89966	\N	\N	f	Qual by exam of deed	0
88344_35500.0_2024-03-28	3550000	\N	2024-03-28	88344	\N	\N	f	Qual by exam of deed	0
88394_19000.0_2024-04-19	1900000	\N	2024-04-19	88394	\N	\N	f	Qual by exam of deed	0
88432_9675.0_2024-05-30	967500	\N	2024-05-30	88432	\N	\N	f	Qual by exam of deed	0
88516_29000.0_2024-04-23	2900000	\N	2024-04-23	88516	\N	\N	f	Qual by exam of deed	0
88902_22500.0_2024-04-30	2250000	\N	2024-04-30	88902	\N	\N	f	Qual by exam of deed	0
88908_22400.0_2024-05-09	2240000	\N	2024-05-09	88908	\N	\N	f	Qual by exam of deed	0
88976_12000.0_2024-03-28	1200000	\N	2024-03-28	88976	\N	\N	f	Qual by exam of deed	0
133641_27000.0_2024-05-09	2700000	\N	2024-05-09	133641	\N	\N	f	Qual by exam of deed	0
82057_6730.0_2004-11-01	673000	\N	2004-11-01	82057	\N	\N	f	Sales which are qualified	0
82058_7320.0_2004-12-01	732000	\N	2004-12-01	82058	\N	\N	f	Sales which are qualified	0
82058_9000.0_2009-11-10	900000	\N	2009-11-10	82058	\N	\N	f	Qual by exam of deed	0
82059_7350.0_2005-01-01	735000	\N	2005-01-01	82059	\N	\N	f	Sales which are qualified	0
82060_6070.0_2004-12-01	607000	\N	2004-12-01	82060	\N	\N	f	Sales which are qualified	0
82061_11900.0_2020-09-17	1190000	\N	2020-09-17	82061	\N	\N	f	Qual by exam of deed	0
82061_14000.0_2015-02-10	1400000	\N	2015-02-10	82061	\N	\N	f	Qual by exam of deed	0
82061_25000.0_2022-09-16	2500000	\N	2022-09-16	82061	\N	\N	f	Qual by exam of deed	0
82061_6600.0_2004-11-01	660000	\N	2004-11-01	82061	\N	\N	f	Sales which are qualified	0
82061_8550.0_2011-04-25	855000	\N	2011-04-25	82061	\N	\N	f	Qual by exam of deed	0
82062_13100.0_2013-06-27	1310000	\N	2013-06-27	82062	\N	\N	f	Qual by exam of deed	0
82062_6880.0_2005-01-01	688000	\N	2005-01-01	82062	\N	\N	f	Sales which are qualified	0
82063_6560.0_2004-11-01	656000	\N	2004-11-01	82063	\N	\N	f	Sales which are qualified	0
82063_8500.0_2004-11-01	850000	\N	2004-11-01	82063	\N	\N	f	Sales which are qualified	0
82064_6390.0_2004-11-01	639000	\N	2004-11-01	82064	\N	\N	f	Sales which are qualified	0
82065_11250.0_2006-01-01	1125000	\N	2006-01-01	82065	\N	\N	f	Sales which are qualified	0
82065_6220.0_2004-11-01	622000	\N	2004-11-01	82065	\N	\N	f	Sales which are qualified	0
82065_8900.0_2009-06-08	890000	\N	2009-06-08	82065	\N	\N	f	Qual by exam of deed	0
82066_11000.0_2013-01-29	1100000	\N	2013-01-29	82066	\N	\N	f	Qual by exam of deed	0
82066_7400.0_2004-10-01	740000	\N	2004-10-01	82066	\N	\N	f	Sales which are qualified	0
82066_9386.13_2011-03-03	938613	\N	2011-03-03	82066	\N	\N	f	Qual by exam of deed	0
82067_6280.0_2004-12-01	628000	\N	2004-12-01	82067	\N	\N	f	Sales which are qualified	0
82068_13800.0_2013-12-04	1380000	\N	2013-12-04	82068	\N	\N	f	Qual by exam of deed	0
82068_6510.0_2004-12-01	651000	\N	2004-12-01	82068	\N	\N	f	Sales which are qualified	0
82069_13775.0_2019-10-21	1377500	\N	2019-10-21	82069	\N	\N	f	Qual by exam of deed	0
82069_6340.0_2004-12-01	634000	\N	2004-12-01	82069	\N	\N	f	Sales which are qualified	0
82070_14272.0_2014-05-06	1427200	\N	2014-05-06	82070	\N	\N	f	Qual by exam of deed	0
82070_6870.0_2004-12-01	687000	\N	2004-12-01	82070	\N	\N	f	Sales which are qualified	0
82070_9600.0_2005-04-01	960000	\N	2005-04-01	82070	\N	\N	f	Sales which are qualified	0
82071_11000.0_2005-11-01	1100000	\N	2005-11-01	82071	\N	\N	f	Sales which are qualified	0
82071_13000.0_2019-04-05	1300000	\N	2019-04-05	82071	\N	\N	f	Qual by exam of deed	0
82071_6900.0_2005-01-01	690000	\N	2005-01-01	82071	\N	\N	f	Sales which are qualified	0
82071_9500.0_2008-12-18	950000	\N	2008-12-18	82071	\N	\N	f	Sales which are qualified	0
82072_6630.0_2004-12-01	663000	\N	2004-12-01	82072	\N	\N	f	Sales which are qualified	0
82073_13750.0_2021-04-12	1375000	\N	2021-04-12	82073	\N	\N	f	Qual by exam of deed	0
82073_6960.0_2004-12-01	696000	\N	2004-12-01	82073	\N	\N	f	Sales which are qualified	0
82074_6490.0_2005-01-01	649000	\N	2005-01-01	82074	\N	\N	f	Sales which are qualified	0
82074_9600.0_2008-09-22	960000	\N	2008-09-22	82074	\N	\N	f	Sales which are qualified	0
82075_10000.0_2012-07-16	1000000	\N	2012-07-16	82075	\N	\N	f	Qual by exam of deed	0
82075_15000.0_2017-01-25	1500000	\N	2017-01-25	82075	\N	\N	f	Qual by exam of deed	0
82075_16500.0_2018-11-02	1650000	\N	2018-11-02	82075	\N	\N	f	Qual by exam of deed	0
82075_6520.0_2004-12-01	652000	\N	2004-12-01	82075	\N	\N	f	Sales which are qualified	0
82076_6750.0_2004-12-01	675000	\N	2004-12-01	82076	\N	\N	f	Sales which are qualified	0
82077_23980.0_2023-02-28	2398000	\N	2023-02-28	82077	\N	\N	f	Qual by exam of deed	0
82077_8850.0_2005-01-01	885000	\N	2005-01-01	82077	\N	\N	f	Sales which are qualified	0
82078_10000.0_2012-09-25	1000000	\N	2012-09-25	82078	\N	\N	f	Qual by exam of deed	0
82078_15850.0_2018-05-22	1585000	\N	2018-05-22	82078	\N	\N	f	Qual by exam of deed	0
82078_6610.0_2005-01-01	661000	\N	2005-01-01	82078	\N	\N	f	Sales which are qualified	0
82079_8800.0_2005-02-01	880000	\N	2005-02-01	82079	\N	\N	f	Sales which are qualified	0
82080_14500.0_2017-01-05	1450000	\N	2017-01-05	82080	\N	\N	f	Qual by exam of deed	0
82080_7170.0_2005-01-01	717000	\N	2005-01-01	82080	\N	\N	f	Sales which are qualified	0
82081_10600.0_2005-06-01	1060000	\N	2005-06-01	82081	\N	\N	f	Sales which are qualified	0
82081_12150.0_2013-06-25	1215000	\N	2013-06-25	82081	\N	\N	f	Qual by exam of deed	0
82081_18500.0_2021-05-25	1850000	\N	2021-05-25	82081	\N	\N	f	Qual by exam of deed	0
82082_6730.0_2005-01-01	673000	\N	2005-01-01	82082	\N	\N	f	Sales which are qualified	0
82083_21500.0_2022-10-06	2150000	\N	2022-10-06	82083	\N	\N	f	Qual by exam of deed	0
82083_28490.0_2023-08-09	2849000	\N	2023-08-09	82083	\N	\N	f	Qual by exam of deed	0
82083_7510.0_2005-01-01	751000	\N	2005-01-01	82083	\N	\N	f	Sales which are qualified	0
82084_10150.0_2007-07-01	1015000	\N	2007-07-01	82084	\N	\N	f	Sales which are qualified	0
82084_8470.0_2005-02-01	847000	\N	2005-02-01	82084	\N	\N	f	Sales which are qualified	0
82084_9200.0_2006-12-01	920000	\N	2006-12-01	82084	\N	\N	f	Sales which are qualified	0
82085_15600.0_2014-04-14	1560000	\N	2014-04-14	82085	\N	\N	f	Qual by exam of deed	0
82085_7720.0_2004-12-01	772000	\N	2004-12-01	82085	\N	\N	f	Sales which are qualified	0
82086_10250.0_2008-05-01	1025000	\N	2008-05-01	82086	\N	\N	f	Sales which are qualified	0
82086_7750.0_2005-01-01	775000	\N	2005-01-01	82086	\N	\N	f	Sales which are qualified	0
82086_9400.0_2005-03-01	940000	\N	2005-03-01	82086	\N	\N	f	Sales which are qualified	0
82087_14000.0_2020-12-16	1400000	\N	2020-12-16	82087	\N	\N	f	Qual by exam of deed	0
82087_7390.0_2008-08-15	739000	\N	2008-08-15	82087	\N	\N	f	Sales which are qualified	0
82087_7780.0_2005-03-01	778000	\N	2005-03-01	82087	\N	\N	f	Sales which are qualified	0
82087_9000.0_2012-05-14	900000	\N	2012-05-14	82087	\N	\N	f	Qual by exam of deed	0
82088_10500.0_2005-05-01	1050000	\N	2005-05-01	82088	\N	\N	f	Sales which are qualified	0
82088_7810.0_2005-03-01	781000	\N	2005-03-01	82088	\N	\N	f	Sales which are qualified	0
82089_11500.0_2005-07-01	1150000	\N	2005-07-01	82089	\N	\N	f	Sales which are qualified	0
82089_14925.0_2014-11-13	1492500	\N	2014-11-13	82089	\N	\N	f	Qual by exam of deed	0
82089_7840.0_2005-03-01	784000	\N	2005-03-01	82089	\N	\N	f	Sales which are qualified	0
82090_10300.0_2012-06-28	1030000	\N	2012-06-28	82090	\N	\N	f	Qual by exam of deed	0
82090_11070.0_2005-08-01	1107000	\N	2005-08-01	82090	\N	\N	f	Sales which are qualified	0
82090_11250.0_2008-09-24	1125000	\N	2008-09-24	82090	\N	\N	f	Sales which are qualified	0
82090_6470.0_2005-05-01	647000	\N	2005-05-01	82090	\N	\N	f	Sales which are qualified	0
82091_10500.0_2012-08-30	1050000	\N	2012-08-30	82091	\N	\N	f	Qual by exam of deed	0
82091_10800.0_2005-05-01	1080000	\N	2005-05-01	82091	\N	\N	f	Sales which are qualified	0
82091_16340.0_2021-02-23	1634000	\N	2021-02-23	82091	\N	\N	f	Qual by exam of deed	0
82091_6500.0_2005-04-01	650000	\N	2005-04-01	82091	\N	\N	f	Sales which are qualified	0
82092_7840.0_2005-03-01	784000	\N	2005-03-01	82092	\N	\N	f	Sales which are qualified	0
82093_11500.0_2005-07-01	1150000	\N	2005-07-01	82093	\N	\N	f	Sales which are qualified	0
82093_21700.0_2021-12-07	2170000	\N	2021-12-07	82093	\N	\N	f	Qual by exam of deed	0
82093_6800.0_2005-05-01	680000	\N	2005-05-01	82093	\N	\N	f	Sales which are qualified	0
82093_9600.0_2011-06-27	960000	\N	2011-06-27	82093	\N	\N	f	Qual by exam of deed	0
82094_22250.0_2008-10-02	2225000	\N	2008-10-02	82094	\N	\N	f	Sales which are qualified	0
82094_41000.0_2020-11-06	4100000	\N	2020-11-06	82094	\N	\N	f	Qual by exam of deed	0
82095_12000.0_2016-12-05	1200000	\N	2016-12-05	82095	\N	\N	f	Qual by exam of deed	0
82095_5980.0_2005-01-01	598000	\N	2005-01-01	82095	\N	\N	f	Sales which are qualified	0
82095_9700.0_2014-02-04	970000	\N	2014-02-04	82095	\N	\N	f	Qual by exam of deed	0
82096_4950.0_2004-11-01	495000	\N	2004-11-01	82096	\N	\N	f	Sales which are qualified	0
82096_8700.0_2006-04-01	870000	\N	2006-04-01	82096	\N	\N	f	Sales which are qualified	0
82097_4980.0_2004-11-01	498000	\N	2004-11-01	82097	\N	\N	f	Sales which are qualified	0
82099_11500.0_2016-05-04	1150000	\N	2016-05-04	82099	\N	\N	f	Qual by exam of deed	0
82099_5040.0_2004-11-01	504000	\N	2004-11-01	82099	\N	\N	f	Sales which are qualified	0
82100_5070.0_2004-11-01	507000	\N	2004-11-01	82100	\N	\N	f	Sales which are qualified	0
82100_7150.0_2005-03-01	715000	\N	2005-03-01	82100	\N	\N	f	Sales which are qualified	0
82100_9500.0_2014-02-26	950000	\N	2014-02-26	82100	\N	\N	f	Qual by exam of deed	0
82101_5100.0_2004-11-01	510000	\N	2004-11-01	82101	\N	\N	f	Sales which are qualified	0
82101_6575.0_2010-03-12	657500	\N	2010-03-12	82101	\N	\N	f	Qual by exam of deed	0
82102_10950.0_2015-06-15	1095000	\N	2015-06-15	82102	\N	\N	f	Qual by exam of deed	0
82102_6780.0_2005-01-01	678000	\N	2005-01-01	82102	\N	\N	f	Sales which are qualified	0
82103_5160.0_2004-12-01	516000	\N	2004-12-01	82103	\N	\N	f	Sales which are qualified	0
82103_7000.0_2005-01-01	700000	\N	2005-01-01	82103	\N	\N	f	Sales which are qualified	0
82104_7220.0_2005-02-01	722000	\N	2005-02-01	82104	\N	\N	f	Sales which are qualified	0
82104_8750.0_2013-08-21	875000	\N	2013-08-21	82104	\N	\N	f	Qual by exam of deed	0
82105_6280.0_2005-01-01	628000	\N	2005-01-01	82105	\N	\N	f	Sales which are qualified	0
82105_8625.0_2005-10-01	862500	\N	2005-10-01	82105	\N	\N	f	Sales which are qualified	0
82106_5550.0_2005-01-01	555000	\N	2005-01-01	82106	\N	\N	f	Sales which are qualified	0
82106_5900.0_2011-04-28	590000	\N	2011-04-28	82106	\N	\N	f	Qual by exam of deed	0
82106_7570.0_2005-03-01	757000	\N	2005-03-01	82106	\N	\N	f	Sales which are qualified	0
82106_9000.0_2005-11-01	900000	\N	2005-11-01	82106	\N	\N	f	Sales which are qualified	0
82107_10400.0_2019-09-10	1040000	\N	2019-09-10	82107	\N	\N	f	Qual by exam of deed	0
82107_5580.0_2004-12-01	558000	\N	2004-12-01	82107	\N	\N	f	Sales which are qualified	0
82107_6200.0_2011-09-30	620000	\N	2011-09-30	82107	\N	\N	f	Qual by exam of deed	0
82108_5610.0_2004-12-01	561000	\N	2004-12-01	82108	\N	\N	f	Sales which are qualified	0
82108_7550.0_2005-04-01	755000	\N	2005-04-01	82108	\N	\N	f	Sales which are qualified	0
82109_6220.0_2005-01-01	622000	\N	2005-01-01	82109	\N	\N	f	Sales which are qualified	0
82109_7850.0_2013-01-11	785000	\N	2013-01-11	82109	\N	\N	f	Qual by exam of deed	0
82110_6600.0_2010-03-31	660000	\N	2010-03-31	82110	\N	\N	f	Qual by exam of deed	0
82110_7290.0_2005-02-01	729000	\N	2005-02-01	82110	\N	\N	f	Sales which are qualified	0
82110_8400.0_2005-06-01	840000	\N	2005-06-01	82110	\N	\N	f	Sales which are qualified	0
82110_9400.0_2014-05-22	940000	\N	2014-05-22	82110	\N	\N	f	Qual by exam of deed	0
82111_5400.0_2004-12-01	540000	\N	2004-12-01	82111	\N	\N	f	Sales which are qualified	0
82111_7000.0_2005-01-01	700000	\N	2005-01-01	82111	\N	\N	f	Sales which are qualified	0
82111_8750.0_2013-09-19	875000	\N	2013-09-19	82111	\N	\N	f	Qual by exam of deed	0
82112_14500.0_2022-02-07	1450000	\N	2022-02-07	82112	\N	\N	f	Qual by exam of deed	0
82112_5700.0_2005-01-01	570000	\N	2005-01-01	82112	\N	\N	f	Sales which are qualified	0
82112_7590.0_2005-04-01	759000	\N	2005-04-01	82112	\N	\N	f	Sales which are qualified	0
82113_5760.0_2004-12-01	576000	\N	2004-12-01	82113	\N	\N	f	Sales which are qualified	0
82113_8300.0_2013-08-07	830000	\N	2013-08-07	82113	\N	\N	f	Qual by exam of deed	0
82114_5850.0_2012-07-26	585000	\N	2012-07-26	82114	\N	\N	f	Qual by exam of deed	0
82114_7380.0_2005-02-01	738000	\N	2005-02-01	82114	\N	\N	t	Deeds that include more than one parcel	0
82115_5820.0_2004-12-01	582000	\N	2004-12-01	82115	\N	\N	f	Sales which are qualified	0
82115_9250.0_2006-10-01	925000	\N	2006-10-01	82115	\N	\N	f	Sales which are qualified	0
82116_5505.0_2004-12-01	550500	\N	2004-12-01	82116	\N	\N	f	Sales which are qualified	0
82116_8850.0_2007-07-01	885000	\N	2007-07-01	82116	\N	\N	f	Sales which are qualified	0
82117_5880.0_2005-01-01	588000	\N	2005-01-01	82117	\N	\N	f	Sales which are qualified	0
82118_5910.0_2005-01-01	591000	\N	2005-01-01	82118	\N	\N	f	Sales which are qualified	0
82118_7000.0_2012-04-16	700000	\N	2012-04-16	82118	\N	\N	f	Qual by exam of deed	0
82118_8100.0_2008-01-01	810000	\N	2008-01-01	82118	\N	\N	f	Sales which are qualified	0
82119_5940.0_2005-01-01	594000	\N	2005-01-01	82119	\N	\N	f	Sales which are qualified	0
82119_6500.0_2011-08-30	650000	\N	2011-08-30	82119	\N	\N	f	Qual by exam of deed	0
82119_7850.0_2005-08-01	785000	\N	2005-08-01	82119	\N	\N	f	Sales which are qualified	0
82120_5671.5_2005-01-01	567150	\N	2005-01-01	82120	\N	\N	f	Sales which are qualified	0
82120_9000.0_2006-03-01	900000	\N	2006-03-01	82120	\N	\N	f	Sales which are qualified	0
82121_6000.0_2005-01-01	600000	\N	2005-01-01	82121	\N	\N	f	Sales which are qualified	0
82121_6300.0_2010-07-16	630000	\N	2010-07-16	82121	\N	\N	f	Qual by exam of deed	0
82122_6330.0_2005-01-01	633000	\N	2005-01-01	82122	\N	\N	f	Sales which are qualified	0
82123_7780.0_2005-02-01	778000	\N	2005-02-01	82123	\N	\N	f	Sales which are qualified	0
82123_9800.0_2014-07-18	980000	\N	2014-07-18	82123	\N	\N	f	Qual by exam of deed	0
82124_11500.0_2021-06-10	1150000	\N	2021-06-10	82124	\N	\N	f	Qual by exam of deed	0
82124_6120.0_2011-04-29	612000	\N	2011-04-29	82124	\N	\N	f	Qual by exam of deed	0
82124_7800.0_2005-05-01	780000	\N	2005-05-01	82124	\N	\N	f	Sales which are qualified	0
82125_6120.0_2005-03-01	612000	\N	2005-03-01	82125	\N	\N	f	Sales which are qualified	0
82125_8300.0_2005-08-01	830000	\N	2005-08-01	82125	\N	\N	f	Sales which are qualified	0
82125_9375.0_2006-01-01	937500	\N	2006-01-01	82125	\N	\N	f	Sales which are qualified	0
82126_6450.0_2005-03-01	645000	\N	2005-03-01	82126	\N	\N	f	Sales which are qualified	0
82126_6800.0_2008-10-22	680000	\N	2008-10-22	82126	\N	\N	f	Sales which are qualified	0
82126_8200.0_2013-07-25	820000	\N	2013-07-25	82126	\N	\N	f	Qual by exam of deed	0
82127_6480.0_2005-03-01	648000	\N	2005-03-01	82127	\N	\N	f	Sales which are qualified	0
82128_6600.0_2009-06-30	660000	\N	2009-06-30	82128	\N	\N	f	Qual by exam of deed	0
82128_6640.0_2005-03-01	664000	\N	2005-03-01	82128	\N	\N	f	Sales which are qualified	0
82128_9050.0_2005-11-01	905000	\N	2005-11-01	82128	\N	\N	f	Sales which are qualified	0
82129_7620.0_2005-03-01	762000	\N	2005-03-01	82129	\N	\N	t	Deeds that include more than one parcel	0
82129_9290.0_2005-10-01	929000	\N	2005-10-01	82129	\N	\N	f	Sales which are qualified	0
82130_6900.0_2005-04-01	690000	\N	2005-04-01	82130	\N	\N	f	Sales which are qualified	0
82131_10000.0_2005-11-01	1000000	\N	2005-11-01	82131	\N	\N	f	Sales which are qualified	0
82131_6730.0_2005-03-01	673000	\N	2005-03-01	82131	\N	\N	f	Sales which are qualified	0
82132_16160.0_2008-05-01	1616000	\N	2008-05-01	82132	\N	\N	f	Sales which are qualified	0
82132_24500.0_2018-09-27	2450000	\N	2018-09-27	82132	\N	\N	f	Qual by exam of deed	0
82133_7380.0_2004-11-01	738000	\N	2004-11-01	82133	\N	\N	f	Sales which are qualified	0
82134_10000.0_2013-07-26	1000000	\N	2013-07-26	82134	\N	\N	f	Qual by exam of deed	0
82134_16045.0_2016-08-10	1604500	\N	2016-08-10	82134	\N	\N	f	Qual by exam of deed	0
82134_7110.0_2004-11-01	711000	\N	2004-11-01	82134	\N	\N	f	Sales which are qualified	0
82135_6440.0_2005-02-01	644000	\N	2005-02-01	82135	\N	\N	f	Sales which are qualified	0
82135_9250.0_2004-03-01	925000	\N	2004-03-01	82135	\N	\N	f	Sales which are qualified	0
82136_6070.0_2005-03-01	607000	\N	2005-03-01	82136	\N	\N	f	Sales which are qualified	0
82136_9200.0_2011-07-15	920000	\N	2011-07-15	82136	\N	\N	f	Qual by exam of deed	0
82137_11000.0_2005-09-01	1100000	\N	2005-09-01	82137	\N	\N	f	Sales which are qualified	0
82137_22000.0_2022-08-30	2200000	\N	2022-08-30	82137	\N	\N	f	Qual by exam of deed	0
82137_7650.0_2005-01-01	765000	\N	2005-01-01	82137	\N	\N	f	Sales which are qualified	0
82137_8350.0_2008-12-04	835000	\N	2008-12-04	82137	\N	\N	f	Sales which are qualified	0
82137_9000.0_2012-06-22	900000	\N	2012-06-22	82137	\N	\N	f	Qual by exam of deed	0
82138_11750.0_2013-07-18	1175000	\N	2013-07-18	82138	\N	\N	f	Qual by exam of deed	0
82138_5773.5_2004-12-01	577350	\N	2004-12-01	82138	\N	\N	f	Sales which are qualified	0
82139_11000.0_2013-09-27	1100000	\N	2013-09-27	82139	\N	\N	f	Qual by exam of deed	0
82139_6160.0_2005-03-01	616000	\N	2005-03-01	82139	\N	\N	f	Sales which are qualified	0
82140_11400.0_2013-07-22	1140000	\N	2013-07-22	82140	\N	\N	f	Qual by exam of deed	0
82140_14000.0_2020-10-30	1400000	\N	2020-10-30	82140	\N	\N	f	Qual by exam of deed	0
82140_6290.0_2004-11-01	629000	\N	2004-11-01	82140	\N	\N	f	Sales which are qualified	0
82141_5909.0_2004-11-01	590900	\N	2004-11-01	82141	\N	\N	f	Sales which are qualified	0
82142_7800.0_2005-01-01	780000	\N	2005-01-01	82142	\N	\N	f	Sales which are qualified	0
82143_14250.0_2019-04-25	1425000	\N	2019-04-25	82143	\N	\N	f	Qual by exam of deed	0
82143_7830.0_2004-12-01	783000	\N	2004-12-01	82143	\N	\N	f	Sales which are qualified	0
82144_10750.0_2012-09-10	1075000	\N	2012-09-10	82144	\N	\N	f	Qual by exam of deed	0
82144_6910.0_2004-12-01	691000	\N	2004-12-01	82144	\N	\N	f	Sales which are qualified	0
82144_9000.0_2010-08-31	900000	\N	2010-08-31	82144	\N	\N	f	Qual by exam of deed	0
82145_14000.0_2020-12-15	1400000	\N	2020-12-15	82145	\N	\N	f	Qual by exam of deed	0
82145_6340.0_2004-12-01	634000	\N	2004-12-01	82145	\N	\N	f	Sales which are qualified	0
82145_9350.0_2011-03-30	935000	\N	2011-03-30	82145	\N	\N	f	Qual by exam of deed	0
82146_10000.0_2005-08-01	1000000	\N	2005-08-01	82146	\N	\N	f	Sales which are qualified	0
82146_10000.0_2010-10-15	1000000	\N	2010-10-15	82146	\N	\N	f	Qual by exam of deed	0
82147_17750.0_2016-07-28	1775000	\N	2016-07-28	82147	\N	\N	f	Qual by exam of deed	0
82147_7300.0_2005-02-01	730000	\N	2005-02-01	82147	\N	\N	f	Sales which are qualified	0
82147_9250.0_2012-01-31	925000	\N	2012-01-31	82147	\N	\N	f	Qual by exam of deed	0
82148_7980.0_2005-01-01	798000	\N	2005-01-01	82148	\N	\N	f	Sales which are qualified	0
82148_9750.0_2005-07-01	975000	\N	2005-07-01	82148	\N	\N	f	Sales which are qualified	0
82149_10000.0_2012-06-11	1000000	\N	2012-06-11	82149	\N	\N	f	Qual by exam of deed	0
82149_26500.0_2023-05-08	2650000	\N	2023-05-08	82149	\N	\N	f	Qual by exam of deed	0
82149_7810.0_2005-01-01	781000	\N	2005-01-01	82149	\N	\N	f	Sales which are qualified	0
82150_7840.0_2004-12-01	784000	\N	2004-12-01	82150	\N	\N	f	Sales which are qualified	0
82151_10000.0_2012-05-25	1000000	\N	2012-05-25	82151	\N	\N	f	Qual by exam of deed	0
82151_10750.0_2011-04-28	1075000	\N	2011-04-28	82151	\N	\N	f	Qual by exam of deed	0
82151_11180.0_2006-05-01	1118000	\N	2006-05-01	82151	\N	\N	f	Sales which are qualified	0
82151_13000.0_2013-07-23	1300000	\N	2013-07-23	82151	\N	\N	f	Qual by exam of deed	0
82151_7120.0_2005-01-01	712000	\N	2005-01-01	82151	\N	\N	f	Sales which are qualified	0
82152_13365.0_2014-03-04	1336500	\N	2014-03-04	82152	\N	\N	f	Qual by exam of deed	0
82152_14600.0_2020-09-29	1460000	\N	2020-09-29	82152	\N	\N	f	Qual by exam of deed	0
82152_18000.0_2016-12-08	1800000	\N	2016-12-08	82152	\N	\N	f	Qual by exam of deed	0
82152_6650.0_2005-01-01	665000	\N	2005-01-01	82152	\N	\N	f	Sales which are qualified	0
82152_9000.0_2011-01-19	900000	\N	2011-01-19	82152	\N	\N	f	Qual by exam of deed	0
82153_8950.0_2005-01-01	895000	\N	2005-01-01	82153	\N	\N	f	Sales which are qualified	0
82154_14500.0_2013-09-18	1450000	\N	2013-09-18	82154	\N	\N	f	Qual by exam of deed	0
82154_16000.0_2017-09-21	1600000	\N	2017-09-21	82154	\N	\N	f	Qual by exam of deed	0
82154_8960.0_2005-02-01	896000	\N	2005-02-01	82154	\N	\N	f	Sales which are qualified	0
82155_14500.0_2019-12-06	1450000	\N	2019-12-06	82155	\N	\N	f	Qual by exam of deed	0
82155_7740.0_2005-01-01	774000	\N	2005-01-01	82155	\N	\N	f	Sales which are qualified	0
82156_6770.0_2004-12-01	677000	\N	2004-12-01	82156	\N	\N	f	Sales which are qualified	0
82157_21500.0_2022-08-16	2150000	\N	2022-08-16	82157	\N	\N	f	Qual by exam of deed	0
82157_7800.0_2005-01-01	780000	\N	2005-01-01	82157	\N	\N	f	Sales which are qualified	0
82158_10250.0_2005-03-01	1025000	\N	2005-03-01	82158	\N	\N	f	Sales which are qualified	0
82158_7330.0_2005-01-01	733000	\N	2005-01-01	82158	\N	\N	f	Sales which are qualified	0
82159_8310.0_2005-01-01	831000	\N	2005-01-01	82159	\N	\N	f	Sales which are qualified	0
82159_9200.0_2009-04-09	920000	\N	2009-04-09	82159	\N	\N	f	Qual by exam of deed	0
82160_12750.0_2006-03-01	1275000	\N	2006-03-01	82160	\N	\N	f	Sales which are qualified	0
82160_14660.0_2019-11-01	1466000	\N	2019-11-01	82160	\N	\N	f	Qual by exam of deed	0
82160_6790.0_2005-01-01	679000	\N	2005-01-01	82160	\N	\N	f	Sales which are qualified	0
82160_8000.0_2005-01-01	800000	\N	2005-01-01	82160	\N	\N	f	Sales which are qualified	0
82161_8370.0_2005-01-01	837000	\N	2005-01-01	82161	\N	\N	f	Sales which are qualified	0
82162_13892.0_2017-11-09	1389200	\N	2017-11-09	82162	\N	\N	f	Qual by exam of deed	0
82162_7250.0_2005-04-01	725000	\N	2005-04-01	82162	\N	\N	f	Sales which are qualified	0
82163_10750.0_2005-04-01	1075000	\N	2005-04-01	82163	\N	\N	f	Sales which are qualified	0
82163_14000.0_2019-02-25	1400000	\N	2019-02-25	82163	\N	\N	f	Qual by exam of deed	0
82163_7100.0_2005-03-01	710000	\N	2005-03-01	82163	\N	\N	f	Sales which are qualified	0
82164_11420.0_2005-07-01	1142000	\N	2005-07-01	82164	\N	\N	f	Sales which are qualified	0
82164_15500.0_2018-12-07	1550000	\N	2018-12-07	82164	\N	\N	f	Qual by exam of deed	0
82164_7010.0_2005-03-01	701000	\N	2005-03-01	82164	\N	\N	f	Sales which are qualified	0
82165_7840.0_2005-03-01	784000	\N	2005-03-01	82165	\N	\N	f	Sales which are qualified	0
82166_14000.0_2013-05-10	1400000	\N	2013-05-10	82166	\N	\N	f	Qual by exam of deed	0
82166_14100.0_2019-02-25	1410000	\N	2019-02-25	82166	\N	\N	f	Qual by exam of deed	0
82166_6970.0_2005-03-01	697000	\N	2005-03-01	82166	\N	\N	f	Sales which are qualified	0
82167_7430.0_2005-04-01	743000	\N	2005-04-01	82167	\N	\N	f	Sales which are qualified	0
82167_9350.0_2011-04-11	935000	\N	2011-04-11	82167	\N	\N	f	Qual by exam of deed	0
82168_7100.0_2005-03-01	710000	\N	2005-03-01	82168	\N	\N	f	Sales which are qualified	0
82168_9500.0_2009-11-02	950000	\N	2009-11-02	82168	\N	\N	f	Qual by exam of deed	0
82168_9900.0_2005-04-01	990000	\N	2005-04-01	82168	\N	\N	f	Sales which are qualified	0
82169_18250.0_2015-05-22	1825000	\N	2015-05-22	82169	\N	\N	f	Qual by exam of deed	0
82169_7100.0_2005-03-01	710000	\N	2005-03-01	82169	\N	\N	f	Sales which are qualified	0
82170_20700.0_2008-12-30	2070000	\N	2008-12-30	82170	\N	\N	f	Sales which are qualified	0
82170_22500.0_2005-06-01	2250000	\N	2005-06-01	82170	\N	\N	f	Sales which are qualified	0
82171_2570.0_2004-11-01	257000	\N	2004-11-01	82171	\N	\N	f	Sales which are qualified	0
82171_5140.0_2007-04-01	514000	\N	2007-04-01	82171	\N	\N	f	Sales which are qualified	0
82172_2520.0_2004-11-01	252000	\N	2004-11-01	82172	\N	\N	f	Sales which are qualified	0
82172_3630.0_2012-08-15	363000	\N	2012-08-15	82172	\N	\N	f	Qual by exam of deed	0
82172_3750.0_2008-01-01	375000	\N	2008-01-01	82172	\N	\N	f	Sales which are qualified	0
82172_4095.0_2008-11-25	409500	\N	2008-11-25	82172	\N	\N	f	Sales which are qualified	0
82173_3090.0_2004-11-01	309000	\N	2004-11-01	82173	\N	\N	f	Sales which are qualified	0
82174_2480.0_2004-11-01	248000	\N	2004-11-01	82174	\N	\N	f	Sales which are qualified	0
82175_2610.0_2004-11-01	261000	\N	2004-11-01	82175	\N	\N	f	Sales which are qualified	0
82175_4200.0_2014-01-09	420000	\N	2014-01-09	82175	\N	\N	f	Qual by exam of deed	0
82175_5800.0_2014-09-04	580000	\N	2014-09-04	82175	\N	\N	f	Qual by exam of deed	0
82176_2940.0_2004-11-01	294000	\N	2004-11-01	82176	\N	\N	f	Sales which are qualified	0
82176_3500.0_2009-04-22	350000	\N	2009-04-22	82176	\N	\N	f	Qual by exam of deed	0
82177_3850.0_2005-01-01	385000	\N	2005-01-01	82177	\N	\N	f	Sales which are qualified	0
82177_3950.0_2018-09-12	395000	\N	2018-09-12	82177	\N	\N	f	Qual by exam of deed	0
82177_4425.0_2013-08-14	442500	\N	2013-08-14	82177	\N	\N	f	Qual by exam of deed	0
82178_2700.0_2004-11-01	270000	\N	2004-11-01	82178	\N	\N	f	Sales which are qualified	0
82178_4250.0_2005-04-01	425000	\N	2005-04-01	82178	\N	\N	f	Sales which are qualified	0
82178_5100.0_2014-06-04	510000	\N	2014-06-04	82178	\N	\N	f	Qual by exam of deed	0
82179_3180.0_2004-12-01	318000	\N	2004-12-01	82179	\N	\N	f	Sales which are qualified	0
82179_4150.0_2005-03-01	415000	\N	2005-03-01	82179	\N	\N	f	Sales which are qualified	0
82180_3210.0_2005-01-01	321000	\N	2005-01-01	82180	\N	\N	f	Sales which are qualified	0
82180_5350.0_2021-05-24	535000	\N	2021-05-24	82180	\N	\N	f	Qual by exam of deed	0
82180_5820.0_2005-09-01	582000	\N	2005-09-01	82180	\N	\N	f	Sales which are qualified	0
82181_2790.0_2004-12-01	279000	\N	2004-12-01	82181	\N	\N	f	Sales which are qualified	0
82181_3300.0_2011-03-11	330000	\N	2011-03-11	82181	\N	\N	f	Qual by exam of deed	0
82181_4250.0_2005-02-01	425000	\N	2005-02-01	82181	\N	\N	f	Sales which are qualified	0
82181_7190.0_2022-05-17	719000	\N	2022-05-17	82181	\N	\N	f	Qual by exam of deed	0
82182_3000.0_2011-10-17	300000	\N	2011-10-17	82182	\N	\N	f	Qual by exam of deed	0
82182_3120.0_2004-12-01	312000	\N	2004-12-01	82182	\N	\N	f	Sales which are qualified	0
82183_3950.0_2005-01-01	395000	\N	2005-01-01	82183	\N	\N	f	Sales which are qualified	0
82183_5100.0_2020-06-30	510000	\N	2020-06-30	82183	\N	\N	f	Qual by exam of deed	0
82184_3330.0_2004-12-01	333000	\N	2004-12-01	82184	\N	\N	f	Sales which are qualified	0
82184_5000.0_2020-02-11	500000	\N	2020-02-11	82184	\N	\N	f	Qual by exam of deed	0
82185_3500.0_2010-03-17	350000	\N	2010-03-17	82185	\N	\N	f	Qual by exam of deed	0
82185_3560.0_2005-03-01	356000	\N	2005-03-01	82185	\N	\N	f	Sales which are qualified	0
82185_5725.0_2016-12-01	572500	\N	2016-12-01	82185	\N	\N	f	Qual by exam of deed	0
82186_2940.0_2004-12-01	294000	\N	2004-12-01	82186	\N	\N	f	Sales which are qualified	0
82187_3950.0_2013-05-23	395000	\N	2013-05-23	82187	\N	\N	f	Qual by exam of deed	0
82187_4070.0_2004-12-01	407000	\N	2004-12-01	82187	\N	\N	f	Sales which are qualified	0
82187_5750.0_2015-04-23	575000	\N	2015-04-23	82187	\N	\N	f	Qual by exam of deed	0
82187_8950.0_2023-03-13	895000	\N	2023-03-13	82187	\N	\N	f	Qual by exam of deed	0
82188_3650.0_2004-12-01	365000	\N	2004-12-01	82188	\N	\N	f	Sales which are qualified	0
82188_4300.0_2013-03-04	430000	\N	2013-03-04	82188	\N	\N	f	Qual by exam of deed	0
82188_4800.0_2020-12-10	480000	\N	2020-12-10	82188	\N	\N	f	Qual by exam of deed	0
82189_3600.0_2005-03-01	360000	\N	2005-03-01	82189	\N	\N	f	Sales which are qualified	0
82189_4600.0_2005-05-01	460000	\N	2005-05-01	82189	\N	\N	f	Sales which are qualified	0
82189_5525.0_2018-12-13	552500	\N	2018-12-13	82189	\N	\N	f	Qual by exam of deed	0
82189_5650.0_2014-01-10	565000	\N	2014-01-10	82189	\N	\N	f	Qual by exam of deed	0
82190_2750.0_2011-04-20	275000	\N	2011-04-20	82190	\N	\N	f	Qual by exam of deed	0
82190_3250.0_2011-05-24	325000	\N	2011-05-24	82190	\N	\N	f	Qual by exam of deed	0
82190_4050.0_2012-09-07	405000	\N	2012-09-07	82190	\N	\N	f	Qual by exam of deed	0
82190_4160.0_2005-02-01	416000	\N	2005-02-01	82190	\N	\N	f	Sales which are qualified	0
82190_5400.0_2005-09-01	540000	\N	2005-09-01	82190	\N	\N	f	Sales which are qualified	0
82190_6500.0_2022-02-16	650000	\N	2022-02-16	82190	\N	\N	f	Qual by exam of deed	0
82191_2870.5_2005-02-01	287050	\N	2005-02-01	82191	\N	\N	f	Sales which are qualified	0
82191_7500.0_2022-08-16	750000	\N	2022-08-16	82191	\N	\N	f	Qual by exam of deed	0
82192_3750.0_2010-05-22	375000	\N	2010-05-22	82192	\N	\N	f	Qual by exam of deed	0
82192_4220.0_2004-12-01	422000	\N	2004-12-01	82192	\N	\N	f	Sales which are qualified	0
82193_3920.0_2004-12-01	392000	\N	2004-12-01	82193	\N	\N	f	Sales which are qualified	0
82194_4137.6_2005-01-01	413760	\N	2005-01-01	82194	\N	\N	f	Sales which are qualified	0
82194_5000.0_2010-05-28	500000	\N	2010-05-28	82194	\N	\N	f	Qual by exam of deed	0
82195_4130.0_2005-02-01	413000	\N	2005-02-01	82195	\N	\N	f	Sales which are qualified	0
82196_4450.0_2005-01-01	445000	\N	2005-01-01	82196	\N	\N	f	Sales which are qualified	0
82196_4500.0_2010-11-19	450000	\N	2010-11-19	82196	\N	\N	f	Qual by exam of deed	0
82197_4270.0_2005-01-01	427000	\N	2005-01-01	82197	\N	\N	f	Sales which are qualified	0
82197_6300.0_2005-07-01	630000	\N	2005-07-01	82197	\N	\N	f	Sales which are qualified	0
82197_7250.0_2021-03-12	725000	\N	2021-03-12	82197	\N	\N	f	Qual by exam of deed	0
82198_5750.0_2005-02-01	575000	\N	2005-02-01	82198	\N	\N	f	Sales which are qualified	0
82198_6380.0_2013-02-26	638000	\N	2013-02-26	82198	\N	\N	f	Qual by exam of deed	0
82199_4660.0_2005-03-01	466000	\N	2005-03-01	82199	\N	\N	f	Sales which are qualified	0
82199_6100.0_2013-05-01	610000	\N	2013-05-01	82199	\N	\N	f	Qual by exam of deed	0
82199_7350.0_2019-06-08	735000	\N	2019-06-08	82199	\N	\N	f	Qual by exam of deed	0
82200_5820.0_2005-02-01	582000	\N	2005-02-01	82200	\N	\N	f	Sales which are qualified	0
82201_4800.0_2005-03-01	480000	\N	2005-03-01	82201	\N	\N	f	Sales which are qualified	0
82201_5965.5_2005-05-01	596550	\N	2005-05-01	82201	\N	\N	f	Sales which are qualified	0
82201_6750.0_2013-04-24	675000	\N	2013-04-24	82201	\N	\N	f	Qual by exam of deed	0
82202_5520.0_2005-03-01	552000	\N	2005-03-01	82202	\N	\N	f	Sales which are qualified	0
82202_7250.0_2005-08-01	725000	\N	2005-08-01	82202	\N	\N	f	Sales which are qualified	0
82203_5290.0_2005-03-01	529000	\N	2005-03-01	82203	\N	\N	f	Sales which are qualified	0
82203_5990.0_2012-02-23	599000	\N	2012-02-23	82203	\N	\N	f	Qual by exam of deed	0
82203_6800.0_2005-06-01	680000	\N	2005-06-01	82203	\N	\N	f	Sales which are qualified	0
82204_5260.0_2005-03-01	526000	\N	2005-03-01	82204	\N	\N	f	Sales which are qualified	0
82205_5330.0_2005-03-01	533000	\N	2005-03-01	82205	\N	\N	f	Sales which are qualified	0
82205_9200.0_2015-11-16	920000	\N	2015-11-16	82205	\N	\N	f	Qual by exam of deed	0
82206_5600.0_2005-03-01	560000	\N	2005-03-01	82206	\N	\N	f	Sales which are qualified	0
82207_5470.0_2005-03-01	547000	\N	2005-03-01	82207	\N	\N	f	Sales which are qualified	0
82207_9300.0_2015-05-21	930000	\N	2015-05-21	82207	\N	\N	f	Qual by exam of deed	0
82208_11000.0_2005-08-01	1100000	\N	2005-08-01	82208	\N	\N	f	Sales which are qualified	0
82209_2350.0_2004-11-01	235000	\N	2004-11-01	82209	\N	\N	f	Sales which are qualified	0
82209_2600.0_2005-02-01	260000	\N	2005-02-01	82209	\N	\N	f	Sales which are qualified	0
82209_4970.0_2022-04-19	497000	\N	2022-04-19	82209	\N	\N	f	Qual by exam of deed	0
82210_2750.0_2009-12-29	275000	\N	2009-12-29	82210	\N	\N	f	Qual by exam of deed	0
82210_2950.0_2005-01-01	295000	\N	2005-01-01	82210	\N	\N	f	Sales which are qualified	0
82210_3600.0_2020-06-05	360000	\N	2020-06-05	82210	\N	\N	f	Qual by exam of deed	0
82210_3850.0_2018-07-25	385000	\N	2018-07-25	82210	\N	\N	f	Qual by exam of deed	0
82210_4000.0_2007-03-01	400000	\N	2007-03-01	82210	\N	\N	f	Sales which are qualified	0
82210_6000.0_2007-03-01	600000	\N	2007-03-01	82210	\N	\N	f	Sales which are qualified	0
82211_2180.0_2004-11-01	218000	\N	2004-11-01	82211	\N	\N	f	Sales which are qualified	0
82211_2450.0_2012-09-13	245000	\N	2012-09-13	82211	\N	\N	f	Qual by verifiable & documented evidence	0
82211_3350.0_2005-04-01	335000	\N	2005-04-01	82211	\N	\N	f	Sales which are qualified	0
82211_3900.0_2014-06-23	390000	\N	2014-06-23	82211	\N	\N	f	Qual by exam of deed	0
82211_4050.0_2005-08-01	405000	\N	2005-08-01	82211	\N	\N	f	Sales which are qualified	0
82211_4200.0_2017-07-28	420000	\N	2017-07-28	82211	\N	\N	f	Qual by exam of deed	0
82212_2380.0_2004-11-01	238000	\N	2004-11-01	82212	\N	\N	f	Sales which are qualified	0
82212_2400.0_2012-01-30	240000	\N	2012-01-30	82212	\N	\N	f	Qual by exam of deed	0
82212_4250.0_2006-07-01	425000	\N	2006-07-01	82212	\N	\N	f	Sales which are qualified	0
82212_5800.0_2007-02-01	580000	\N	2007-02-01	82212	\N	\N	f	Sales which are qualified	0
82213_2240.0_2004-11-01	224000	\N	2004-11-01	82213	\N	\N	f	Sales which are qualified	0
82213_2450.0_2009-10-12	245000	\N	2009-10-12	82213	\N	\N	f	Qual by exam of deed	0
82213_3417.0_2005-03-01	341700	\N	2005-03-01	82213	\N	\N	f	Sales which are qualified	0
82213_3925.0_2005-07-01	392500	\N	2005-07-01	82213	\N	\N	f	Sales which are qualified	0
82213_5850.0_2007-01-01	585000	\N	2007-01-01	82213	\N	\N	f	Sales which are qualified	0
82214_2440.0_2004-11-01	244000	\N	2004-11-01	82214	\N	\N	f	Sales which are qualified	0
82214_2600.0_2010-08-16	260000	\N	2010-08-16	82214	\N	\N	f	Qual by exam of deed	0
82214_3500.0_2005-05-01	350000	\N	2005-05-01	82214	\N	\N	f	Sales which are qualified	0
82214_3650.0_2020-08-31	365000	\N	2020-08-31	82214	\N	\N	f	Qual by exam of deed	0
82214_4000.0_2016-02-29	400000	\N	2016-02-29	82214	\N	\N	f	Qual by exam of deed	0
82214_4400.0_2006-10-01	440000	\N	2006-10-01	82214	\N	\N	f	Sales which are qualified	0
82215_3070.0_2005-01-01	307000	\N	2005-01-01	82215	\N	\N	f	Sales which are qualified	0
82216_2500.0_2004-11-01	250000	\N	2004-11-01	82216	\N	\N	f	Sales which are qualified	0
82216_6150.0_2006-12-01	615000	\N	2006-12-01	82216	\N	\N	f	Sales which are qualified	0
82217_2360.0_2004-11-01	236000	\N	2004-11-01	82217	\N	\N	f	Sales which are qualified	0
82217_2800.0_2010-08-26	280000	\N	2010-08-26	82217	\N	\N	f	Qual by exam of deed	0
82218_2500.0_2004-12-01	250000	\N	2004-12-01	82218	\N	\N	f	Sales which are qualified	0
82218_3400.0_2005-02-01	340000	\N	2005-02-01	82218	\N	\N	f	Sales which are qualified	0
82218_3610.0_2020-05-26	361000	\N	2020-05-26	82218	\N	\N	f	Qual by exam of deed	0
82218_4170.0_2013-09-03	417000	\N	2013-09-03	82218	\N	\N	f	Qual by exam of deed	0
82218_4300.0_2005-07-01	430000	\N	2005-07-01	82218	\N	\N	f	Sales which are qualified	0
82218_6400.0_2023-02-23	640000	\N	2023-02-23	82218	\N	\N	f	Qual by exam of deed	0
82219_2420.0_2004-12-01	242000	\N	2004-12-01	82219	\N	\N	f	Sales which are qualified	0
82219_2540.0_2009-09-22	254000	\N	2009-09-22	82219	\N	\N	f	Qual by exam of deed	0
82219_3400.0_2005-03-01	340000	\N	2005-03-01	82219	\N	\N	f	Sales which are qualified	0
82219_4490.0_2005-08-01	449000	\N	2005-08-01	82219	\N	\N	f	Sales which are qualified	0
82219_4800.0_2006-08-01	480000	\N	2006-08-01	82219	\N	\N	f	Sales which are qualified	0
82219_5250.0_2022-01-20	525000	\N	2022-01-20	82219	\N	\N	f	Qual by exam of deed	0
82220_2620.0_2004-12-01	262000	\N	2004-12-01	82220	\N	\N	f	Sales which are qualified	0
82220_4650.0_2016-10-21	465000	\N	2016-10-21	82220	\N	\N	f	Qual by exam of deed	0
82220_5335.0_2022-05-17	533500	\N	2022-05-17	82220	\N	\N	f	Qual by exam of deed	0
82221_2480.0_2004-12-01	248000	\N	2004-12-01	82221	\N	\N	f	Sales which are qualified	0
82221_2600.0_2011-07-29	260000	\N	2011-07-29	82221	\N	\N	f	Qual by exam of deed	0
82221_3685.0_2005-02-01	368500	\N	2005-02-01	82221	\N	\N	f	Sales which are qualified	0
82221_5750.0_2007-04-01	575000	\N	2007-04-01	82221	\N	\N	f	Sales which are qualified	0
82222_2510.0_2004-12-01	251000	\N	2004-12-01	82222	\N	\N	f	Sales which are qualified	0
82222_3400.0_2005-02-01	340000	\N	2005-02-01	82222	\N	\N	f	Sales which are qualified	0
82222_3650.0_2020-07-01	365000	\N	2020-07-01	82222	\N	\N	f	Qual by exam of deed	0
82223_3110.0_2004-12-01	311000	\N	2004-12-01	82223	\N	\N	f	Sales which are qualified	0
82223_3950.0_2019-11-21	395000	\N	2019-11-21	82223	\N	\N	f	Qual by exam of deed	0
82224_2740.0_2004-12-01	274000	\N	2004-12-01	82224	\N	\N	f	Sales which are qualified	0
82224_3100.0_2008-10-28	310000	\N	2008-10-28	82224	\N	\N	f	Sales which are qualified	0
82224_4750.0_2021-07-15	475000	\N	2021-07-15	82224	\N	\N	f	Qual by exam of deed	0
82225_2600.0_2004-12-01	260000	\N	2004-12-01	82225	\N	\N	f	Sales which are qualified	0
82225_3815.0_2005-02-01	381500	\N	2005-02-01	82225	\N	\N	f	Sales which are qualified	0
82225_4125.0_2013-11-19	412500	\N	2013-11-19	82225	\N	\N	f	Qual by exam of deed	0
82225_7500.0_2023-04-27	750000	\N	2023-04-27	82225	\N	\N	f	Qual by exam of deed	0
82226_2400.0_2009-12-17	240000	\N	2009-12-17	82226	\N	\N	f	Qual by exam of deed	0
82226_2630.0_2004-12-01	263000	\N	2004-12-01	82226	\N	\N	f	Sales which are qualified	0
82226_3845.0_2005-02-01	384500	\N	2005-02-01	82226	\N	\N	f	Sales which are qualified	0
82226_4350.0_2014-07-15	435000	\N	2014-07-15	82226	\N	\N	f	Qual by exam of deed	0
82226_4370.0_2005-05-01	437000	\N	2005-05-01	82226	\N	\N	f	Sales which are qualified	0
82227_2800.0_2012-01-03	280000	\N	2012-01-03	82227	\N	\N	f	Qual by exam of deed	0
82227_3430.0_2004-12-01	343000	\N	2004-12-01	82227	\N	\N	f	Sales which are qualified	0
82228_3060.0_2004-12-01	306000	\N	2004-12-01	82228	\N	\N	f	Sales which are qualified	0
82228_3300.0_2011-10-04	330000	\N	2011-10-04	82228	\N	\N	f	Qual by exam of deed	0
82229_3700.0_2005-02-01	370000	\N	2005-02-01	82229	\N	\N	f	Sales which are qualified	0
82229_6300.0_2007-03-01	630000	\N	2007-03-01	82229	\N	\N	f	Sales which are qualified	0
82230_2350.0_2005-01-01	235000	\N	2005-01-01	82230	\N	\N	f	Sales which are qualified	0
82231_3000.0_2004-11-01	300000	\N	2004-11-01	82231	\N	\N	f	Sales which are qualified	0
82231_3390.0_2012-09-26	339000	\N	2012-09-26	82231	\N	\N	f	Qual by exam of deed	0
82231_3900.0_2007-10-01	390000	\N	2007-10-01	82231	\N	\N	f	Sales which are qualified	0
82231_4000.0_2021-03-03	400000	\N	2021-03-03	82231	\N	\N	f	Qual by exam of deed	0
82231_6150.0_2007-11-01	615000	\N	2007-11-01	82231	\N	\N	f	Sales which are qualified	0
82231_6150.0_2008-03-01	615000	\N	2008-03-01	82231	\N	\N	f	Sales which are qualified	0
82232_2520.0_2004-11-01	252000	\N	2004-11-01	82232	\N	\N	f	Sales which are qualified	0
82232_2800.0_2009-09-11	280000	\N	2009-09-11	82232	\N	\N	f	Qual by exam of deed	0
82232_2800.0_2011-07-29	280000	\N	2011-07-29	82232	\N	\N	f	Qual by exam of deed	0
82232_3950.0_2013-07-29	395000	\N	2013-07-29	82232	\N	\N	f	Qual by exam of deed	0
82232_4600.0_2015-12-10	460000	\N	2015-12-10	82232	\N	\N	f	Qual by exam of deed	0
82232_4800.0_2021-07-16	480000	\N	2021-07-16	82232	\N	\N	f	Qual by exam of deed	0
82233_2550.0_2004-11-01	255000	\N	2004-11-01	82233	\N	\N	f	Sales which are qualified	0
82234_2580.0_2004-11-01	258000	\N	2004-11-01	82234	\N	\N	f	Sales which are qualified	0
82235_3490.0_2005-02-01	349000	\N	2005-02-01	82235	\N	\N	f	Sales which are qualified	0
82236_2640.0_2004-12-01	264000	\N	2004-12-01	82236	\N	\N	f	Sales which are qualified	0
82236_2950.0_2010-04-29	295000	\N	2010-04-29	82236	\N	\N	f	Qual by exam of deed	0
82236_4500.0_2014-01-13	450000	\N	2014-01-13	82236	\N	\N	f	Qual by exam of deed	0
82237_4460.0_2004-11-01	446000	\N	2004-11-01	82237	\N	\N	f	Sales which are qualified	0
82238_3000.0_2004-12-01	300000	\N	2004-12-01	82238	\N	\N	f	Sales which are qualified	0
82238_3200.0_2012-01-17	320000	\N	2012-01-17	82238	\N	\N	f	Qual by exam of deed	0
82238_4080.0_2005-03-01	408000	\N	2005-03-01	82238	\N	\N	f	Sales which are qualified	0
82238_5300.0_2006-01-01	530000	\N	2006-01-01	82238	\N	\N	f	Sales which are qualified	0
82238_6050.0_2006-11-01	605000	\N	2006-11-01	82238	\N	\N	f	Sales which are qualified	0
82238_6600.0_2022-03-15	660000	\N	2022-03-15	82238	\N	\N	f	Qual by exam of deed	0
82239_2730.0_2004-11-01	273000	\N	2004-11-01	82239	\N	\N	f	Sales which are qualified	0
82239_5500.0_2021-09-27	550000	\N	2021-09-27	82239	\N	\N	f	Qual by exam of deed	0
82239_5550.0_2015-07-09	555000	\N	2015-07-09	82239	\N	\N	f	Qual by exam of deed	0
82240_3000.0_2010-11-04	300000	\N	2010-11-04	82240	\N	\N	f	Qual by exam of deed	0
82240_3920.0_2005-02-01	392000	\N	2005-02-01	82240	\N	\N	f	Sales which are qualified	0
82241_2760.0_2004-12-01	276000	\N	2004-12-01	82241	\N	\N	f	Sales which are qualified	0
82241_4000.0_2012-04-06	400000	\N	2012-04-06	82241	\N	\N	f	Qual by exam of deed	0
82242_2790.0_2004-12-01	279000	\N	2004-12-01	82242	\N	\N	f	Sales which are qualified	0
82242_3000.0_2010-07-22	300000	\N	2010-07-22	82242	\N	\N	f	Qual by exam of deed	0
82242_4365.0_2005-04-01	436500	\N	2005-04-01	82242	\N	\N	f	Sales which are qualified	0
82243_3100.0_2004-12-01	310000	\N	2004-12-01	82243	\N	\N	f	Sales which are qualified	0
82244_3130.0_2004-12-01	313000	\N	2004-12-01	82244	\N	\N	f	Sales which are qualified	0
82244_4350.0_2005-04-01	435000	\N	2005-04-01	82244	\N	\N	f	Sales which are qualified	0
82244_7050.0_2022-06-23	705000	\N	2022-06-23	82244	\N	\N	f	Qual by exam of deed	0
82245_2910.0_2004-12-01	291000	\N	2004-12-01	82245	\N	\N	f	Sales which are qualified	0
82245_6090.0_2021-09-24	609000	\N	2021-09-24	82245	\N	\N	f	Qual by exam of deed	0
82246_4100.0_2005-02-01	410000	\N	2005-02-01	82246	\N	\N	f	Sales which are qualified	0
82246_4900.0_2005-06-01	490000	\N	2005-06-01	82246	\N	\N	f	Sales which are qualified	0
82246_5726.0_2014-09-17	572600	\N	2014-09-17	82246	\N	\N	f	Qual by exam of deed	0
82246_6350.0_2022-01-18	635000	\N	2022-01-18	82246	\N	\N	f	Qual by exam of deed	0
82247_3070.0_2004-12-01	307000	\N	2004-12-01	82247	\N	\N	f	Sales which are qualified	0
82247_5400.0_2006-02-01	540000	\N	2006-02-01	82247	\N	\N	f	Sales which are qualified	0
82247_6800.0_2022-02-25	680000	\N	2022-02-25	82247	\N	\N	f	Qual by exam of deed	0
82248_2900.0_2004-12-01	290000	\N	2004-12-01	82248	\N	\N	f	Sales which are qualified	0
82248_4230.0_2009-04-03	423000	\N	2009-04-03	82248	\N	\N	f	Qual by exam of deed	0
82248_5650.0_2014-09-02	565000	\N	2014-09-02	82248	\N	\N	f	Qual by exam of deed	0
82249_2880.0_2011-04-14	288000	\N	2011-04-14	82249	\N	\N	f	Qual by verifiable & documented evidence	0
82249_3030.0_2004-12-01	303000	\N	2004-12-01	82249	\N	\N	f	Sales which are qualified	0
82249_4500.0_2012-08-31	450000	\N	2012-08-31	82249	\N	\N	f	Qual by exam of deed	0
82249_5450.0_2005-07-01	545000	\N	2005-07-01	82249	\N	\N	f	Sales which are qualified	0
82249_6800.0_2022-05-11	680000	\N	2022-05-11	82249	\N	\N	f	Qual by exam of deed	0
82250_3260.0_2005-01-01	326000	\N	2005-01-01	82250	\N	\N	f	Sales which are qualified	0
82250_4770.0_2020-07-27	477000	\N	2020-07-27	82250	\N	\N	f	Qual by exam of deed	0
82250_5000.0_2005-06-01	500000	\N	2005-06-01	82250	\N	\N	f	Sales which are qualified	0
82251_3090.0_2004-12-01	309000	\N	2004-12-01	82251	\N	\N	f	Sales which are qualified	0
82252_3120.0_2004-12-01	312000	\N	2004-12-01	82252	\N	\N	f	Sales which are qualified	0
82252_4370.0_2005-04-01	437000	\N	2005-04-01	82252	\N	\N	f	Sales which are qualified	0
82252_4680.0_2013-01-16	468000	\N	2013-01-16	82252	\N	\N	f	Qual by exam of deed	0
82252_5500.0_2006-03-01	550000	\N	2006-03-01	82252	\N	\N	f	Sales which are qualified	0
82252_6600.0_2021-07-19	660000	\N	2021-07-19	82252	\N	\N	f	Qual by exam of deed	0
82253_3960.0_2004-12-01	396000	\N	2004-12-01	82253	\N	\N	f	Sales which are qualified	0
82253_5200.0_2012-05-02	520000	\N	2012-05-02	82253	\N	\N	f	Qual by exam of deed	0
82254_4060.0_2005-02-01	406000	\N	2005-02-01	82254	\N	\N	f	Sales which are qualified	0
82254_7200.0_2005-08-01	720000	\N	2005-08-01	82254	\N	\N	f	Sales which are qualified	0
82255_4230.0_2005-01-01	423000	\N	2005-01-01	82255	\N	\N	f	Sales which are qualified	0
82255_5800.0_2005-03-01	580000	\N	2005-03-01	82255	\N	\N	f	Sales which are qualified	0
82256_4300.0_2005-01-01	430000	\N	2005-01-01	82256	\N	\N	f	Sales which are qualified	0
82266_5250.0_2005-04-01	525000	\N	2005-04-01	82266	\N	\N	f	Sales which are qualified	0
82267_5000.0_2010-11-18	500000	\N	2010-11-18	82267	\N	\N	f	Qual by exam of deed	0
82267_5070.0_2005-03-01	507000	\N	2005-03-01	82267	\N	\N	f	Sales which are qualified	0
82267_5100.0_2008-03-01	510000	\N	2008-03-01	82267	\N	\N	f	Sales which are qualified	0
82268_17500.0_2018-03-13	1750000	\N	2018-03-13	82268	\N	\N	f	Qual by exam of deed	0
82268_18000.0_2006-05-01	1800000	\N	2006-05-01	82268	\N	\N	f	Sales which are qualified	0
82268_20000.0_2006-07-01	2000000	\N	2006-07-01	82268	\N	\N	f	Sales which are qualified	0
82269_4370.0_2004-11-01	437000	\N	2004-11-01	82269	\N	\N	f	Sales which are qualified	0
82269_6200.0_2020-06-15	620000	\N	2020-06-15	82269	\N	\N	f	Qual by exam of deed	0
82269_6425.0_2005-06-01	642500	\N	2005-06-01	82269	\N	\N	f	Sales which are qualified	0
82269_9500.0_2022-03-16	950000	\N	2022-03-16	82269	\N	\N	f	Qual by exam of deed	0
82270_5500.0_2005-02-01	550000	\N	2005-02-01	82270	\N	\N	f	Sales which are qualified	0
82270_7000.0_2014-02-07	700000	\N	2014-02-07	82270	\N	\N	f	Qual by exam of deed	0
82270_7300.0_2005-09-01	730000	\N	2005-09-01	82270	\N	\N	f	Sales which are qualified	0
82271_4700.0_2004-11-01	470000	\N	2004-11-01	82271	\N	\N	f	Sales which are qualified	0
82271_9250.0_2007-08-01	925000	\N	2007-08-01	82271	\N	\N	f	Sales which are qualified	0
82272_4800.0_2004-11-01	480000	\N	2004-11-01	82272	\N	\N	f	Sales which are qualified	0
82272_8050.0_2015-01-14	805000	\N	2015-01-14	82272	\N	\N	f	Qual by exam of deed	0
82273_4650.0_2011-02-14	465000	\N	2011-02-14	82273	\N	\N	f	Qual by exam of deed	0
82273_4770.0_2004-11-01	477000	\N	2004-11-01	82273	\N	\N	f	Sales which are qualified	0
82273_5850.0_2012-02-13	585000	\N	2012-02-13	82273	\N	\N	f	Qual by exam of deed	0
82273_7800.0_2007-05-01	780000	\N	2007-05-01	82273	\N	\N	f	Sales which are qualified	0
82274_5000.0_2004-12-01	500000	\N	2004-12-01	82274	\N	\N	f	Sales which are qualified	0
82275_4880.0_2004-12-01	488000	\N	2004-12-01	82275	\N	\N	f	Sales which are qualified	0
82275_8200.0_2014-05-07	820000	\N	2014-05-07	82275	\N	\N	f	Qual by exam of deed	0
82276_4664.5_2005-03-01	466450	\N	2005-03-01	82276	\N	\N	f	Sales which are qualified	0
82276_6700.0_2005-04-01	670000	\N	2005-04-01	82276	\N	\N	f	Sales which are qualified	0
82276_6900.0_2007-07-01	690000	\N	2007-07-01	82276	\N	\N	f	Sales which are qualified	0
82277_4693.0_2005-03-01	469300	\N	2005-03-01	82277	\N	\N	f	Sales which are qualified	0
82277_5633.3_2009-05-28	563330	\N	2009-05-28	82277	\N	\N	f	Qual by exam of deed	0
82277_6750.0_2005-04-01	675000	\N	2005-04-01	82277	\N	\N	f	Sales which are qualified	0
82277_8200.0_2005-08-01	820000	\N	2005-08-01	82277	\N	\N	f	Sales which are qualified	0
82278_12950.0_2022-04-29	1295000	\N	2022-04-29	82278	\N	\N	f	Qual by exam of deed	0
82278_5650.0_2005-01-01	565000	\N	2005-01-01	82278	\N	\N	f	Sales which are qualified	0
82279_4850.0_2005-01-01	485000	\N	2005-01-01	82279	\N	\N	f	Sales which are qualified	0
82279_6200.0_2005-07-01	620000	\N	2005-07-01	82279	\N	\N	f	Sales which are qualified	0
82279_7650.0_2005-10-01	765000	\N	2005-10-01	82279	\N	\N	f	Sales which are qualified	0
82279_8200.0_2007-10-01	820000	\N	2007-10-01	82279	\N	\N	f	Sales which are qualified	0
82280_4730.0_2004-12-01	473000	\N	2004-12-01	82280	\N	\N	f	Sales which are qualified	0
82280_8700.0_2006-05-01	870000	\N	2006-05-01	82280	\N	\N	f	Sales which are qualified	0
82281_12800.0_2022-02-18	1280000	\N	2022-02-18	82281	\N	\N	f	Qual by exam of deed	0
82281_6100.0_2005-02-01	610000	\N	2005-02-01	82281	\N	\N	f	Sales which are qualified	0
82281_8080.0_2005-06-01	808000	\N	2005-06-01	82281	\N	\N	f	Sales which are qualified	0
82281_8800.0_2020-08-04	880000	\N	2020-08-04	82281	\N	\N	f	Qual by exam of deed	0
82282_4940.0_2004-12-01	494000	\N	2004-12-01	82282	\N	\N	f	Sales which are qualified	0
82282_6000.0_2012-02-03	600000	\N	2012-02-03	82282	\N	\N	f	Qual by exam of deed	0
82282_8000.0_2019-08-14	800000	\N	2019-08-14	82282	\N	\N	f	Qual by exam of deed	0
82283_5850.0_2005-01-01	585000	\N	2005-01-01	82283	\N	\N	f	Sales which are qualified	0
82284_5300.0_2004-12-01	530000	\N	2004-12-01	82284	\N	\N	f	Sales which are qualified	0
82285_5330.0_2004-12-01	533000	\N	2004-12-01	82285	\N	\N	f	Sales which are qualified	0
82285_8800.0_2019-12-09	880000	\N	2019-12-09	82285	\N	\N	f	Qual by exam of deed	0
82286_5360.0_2004-12-01	536000	\N	2004-12-01	82286	\N	\N	f	Sales which are qualified	0
82287_4693.0_2005-02-01	469300	\N	2005-02-01	82287	\N	\N	f	Sales which are qualified	0
82287_9500.0_2006-07-01	950000	\N	2006-07-01	82287	\N	\N	f	Sales which are qualified	0
82288_10750.0_2016-12-27	1075000	\N	2016-12-27	82288	\N	\N	f	Qual by exam of deed	0
82288_4693.0_2004-12-01	469300	\N	2004-12-01	82288	\N	\N	f	Sales which are qualified	0
82288_7750.0_2005-04-01	775000	\N	2005-04-01	82288	\N	\N	f	Sales which are qualified	0
82289_10400.0_2018-06-27	1040000	\N	2018-06-27	82289	\N	\N	f	Qual by exam of deed	0
82289_6000.0_2011-04-29	600000	\N	2011-04-29	82289	\N	\N	f	Qual by exam of deed	0
82289_6600.0_2005-02-01	660000	\N	2005-02-01	82289	\N	\N	f	Sales which are qualified	0
82290_11500.0_2021-10-11	1150000	\N	2021-10-11	82290	\N	\N	f	Qual by exam of deed	0
82290_5030.0_2005-01-01	503000	\N	2005-01-01	82290	\N	\N	f	Sales which are qualified	0
82290_6700.0_2009-04-15	670000	\N	2009-04-15	82290	\N	\N	f	Qual by exam of deed	0
82291_4934.0_2005-01-01	493400	\N	2005-01-01	82291	\N	\N	f	Sales which are qualified	0
82292_5140.0_2005-01-01	514000	\N	2005-01-01	82292	\N	\N	f	Sales which are qualified	0
82293_5420.0_2005-01-01	542000	\N	2005-01-01	82293	\N	\N	f	Sales which are qualified	0
82294_5450.0_2004-12-01	545000	\N	2004-12-01	82294	\N	\N	f	Sales which are qualified	0
82294_6730.0_2009-08-31	673000	\N	2009-08-31	82294	\N	\N	f	Qual by exam of deed	0
82295_14000.0_2022-07-11	1400000	\N	2022-07-11	82295	\N	\N	f	Qual by exam of deed	0
82295_6820.0_2005-01-01	682000	\N	2005-01-01	82295	\N	\N	f	Sales which are qualified	0
82295_7300.0_2008-05-01	730000	\N	2008-05-01	82295	\N	\N	f	Sales which are qualified	0
82295_7400.0_2012-07-17	740000	\N	2012-07-17	82295	\N	\N	f	Qual by exam of deed	0
82295_9900.0_2019-12-10	990000	\N	2019-12-10	82295	\N	\N	f	Qual by exam of deed	0
82296_5660.0_2005-01-01	566000	\N	2005-01-01	82296	\N	\N	f	Sales which are qualified	0
82296_5900.0_2010-09-30	590000	\N	2010-09-30	82296	\N	\N	f	Qual by exam of deed	0
82296_8500.0_2005-05-01	850000	\N	2005-05-01	82296	\N	\N	f	Sales which are qualified	0
82297_12000.0_2022-06-15	1200000	\N	2022-06-15	82297	\N	\N	f	Qual by exam of deed	0
82297_5690.0_2004-11-01	569000	\N	2004-11-01	82297	\N	\N	f	Sales which are qualified	0
82297_6300.0_2011-05-20	630000	\N	2011-05-20	82297	\N	\N	f	Qual by exam of deed	0
82297_9700.0_2005-12-01	970000	\N	2005-12-01	82297	\N	\N	f	Sales which are qualified	0
82298_12250.0_2015-04-01	1225000	\N	2015-04-01	82298	\N	\N	f	Qual by exam of deed	0
82298_17250.0_2022-02-18	1725000	\N	2022-02-18	82298	\N	\N	f	Qual by exam of deed	0
82298_5720.0_2005-01-01	572000	\N	2005-01-01	82298	\N	\N	f	Sales which are qualified	0
82299_10200.0_2005-10-01	1020000	\N	2005-10-01	82299	\N	\N	f	Sales which are qualified	0
82299_5750.0_2005-03-01	575000	\N	2005-03-01	82299	\N	\N	f	Sales which are qualified	0
82299_8300.0_2008-09-19	830000	\N	2008-09-19	82299	\N	\N	f	Sales which are qualified	0
82300_5780.0_2005-04-01	578000	\N	2005-04-01	82300	\N	\N	f	Sales which are qualified	0
82300_9340.0_2006-05-01	934000	\N	2006-05-01	82300	\N	\N	f	Sales which are qualified	0
82301_11800.0_2021-06-11	1180000	\N	2021-06-11	82301	\N	\N	f	Qual by exam of deed	0
82301_5810.0_2005-03-01	581000	\N	2005-03-01	82301	\N	\N	f	Sales which are qualified	0
82302_12800.0_2021-07-14	1280000	\N	2021-07-14	82302	\N	\N	f	Qual by exam of deed	0
82302_5291.5_2005-03-01	529150	\N	2005-03-01	82302	\N	\N	f	Sales which are qualified	0
82302_9050.0_2007-06-01	905000	\N	2007-06-01	82302	\N	\N	f	Sales which are qualified	0
82303_5300.0_2005-03-01	530000	\N	2005-03-01	82303	\N	\N	f	Sales which are qualified	0
82304_15250.0_2022-05-13	1525000	\N	2022-05-13	82304	\N	\N	f	Qual by exam of deed	0
82304_5450.0_2005-03-01	545000	\N	2005-03-01	82304	\N	\N	f	Sales which are qualified	0
82305_13000.0_2014-10-29	1300000	\N	2014-10-29	82305	\N	\N	f	Qual by exam of deed	0
82305_5750.0_2005-07-01	575000	\N	2005-07-01	82305	\N	\N	f	Sales which are qualified	0
82305_7500.0_2007-08-01	750000	\N	2007-08-01	82305	\N	\N	f	Sales which are qualified	0
82306_17575.0_2005-06-01	1757500	\N	2005-06-01	82306	\N	\N	f	Sales which are qualified	0
82306_20620.0_2008-03-01	2062000	\N	2008-03-01	82306	\N	\N	t	Deeds that include more than one parcel	0
82307_4400.0_2004-12-01	440000	\N	2004-12-01	82307	\N	\N	f	Sales which are qualified	0
82307_8100.0_2021-06-18	810000	\N	2021-06-18	82307	\N	\N	f	Qual by exam of deed	0
82308_4670.0_2004-11-01	467000	\N	2004-11-01	82308	\N	\N	f	Sales which are qualified	0
82308_6330.0_2012-08-03	633000	\N	2012-08-03	82308	\N	\N	f	Qual by exam of deed	0
82308_7250.0_2018-12-28	725000	\N	2018-12-28	82308	\N	\N	f	Qual by exam of deed	0
82309_4460.0_2004-11-01	446000	\N	2004-11-01	82309	\N	\N	f	Sales which are qualified	0
82309_5450.0_2012-03-29	545000	\N	2012-03-29	82309	\N	\N	f	Qual by exam of deed	0
82310_4408.0_2004-12-01	440800	\N	2004-12-01	82310	\N	\N	f	Sales which are qualified	0
82310_5500.0_2012-04-30	550000	\N	2012-04-30	82310	\N	\N	f	Qual by exam of deed	0
82310_6650.0_2012-11-27	665000	\N	2012-11-27	82310	\N	\N	f	Qual by exam of deed	0
82310_8200.0_2014-04-22	820000	\N	2014-04-22	82310	\N	\N	f	Qual by exam of deed	0
82310_8750.0_2021-06-30	875000	\N	2021-06-30	82310	\N	\N	f	Qual by exam of deed	0
82311_4970.0_2004-11-01	497000	\N	2004-11-01	82311	\N	\N	f	Sales which are qualified	0
82311_6700.0_2005-05-01	670000	\N	2005-05-01	82311	\N	\N	f	Sales which are qualified	0
82312_4550.0_2004-11-01	455000	\N	2004-11-01	82312	\N	\N	f	Sales which are qualified	0
82313_4580.0_2004-11-01	458000	\N	2004-11-01	82313	\N	\N	f	Sales which are qualified	0
82313_7500.0_2007-07-01	750000	\N	2007-07-01	82313	\N	\N	f	Sales which are qualified	0
82314_4760.0_2004-12-01	476000	\N	2004-12-01	82314	\N	\N	f	Sales which are qualified	0
82315_5500.0_2011-03-08	550000	\N	2011-03-08	82315	\N	\N	f	Qual by exam of deed	0
82315_6280.0_2005-03-01	628000	\N	2005-03-01	82315	\N	\N	f	Sales which are qualified	0
82316_6310.0_2005-02-01	631000	\N	2005-02-01	82316	\N	\N	f	Sales which are qualified	0
82317_4560.0_2004-12-01	456000	\N	2004-12-01	82317	\N	\N	f	Sales which are qualified	0
82318_12500.0_2022-08-31	1250000	\N	2022-08-31	82318	\N	\N	f	Qual by exam of deed	0
82318_4730.0_2004-12-01	473000	\N	2004-12-01	82318	\N	\N	f	Sales which are qualified	0
82319_12000.0_2021-12-17	1200000	\N	2021-12-17	82319	\N	\N	f	Qual by exam of deed	0
82319_4760.0_2004-12-01	476000	\N	2004-12-01	82319	\N	\N	f	Sales which are qualified	0
82319_6000.0_2011-10-21	600000	\N	2011-10-21	82319	\N	\N	f	Qual by exam of deed	0
82319_7100.0_2005-04-01	710000	\N	2005-04-01	82319	\N	\N	f	Sales which are qualified	0
82320_4790.0_2004-12-01	479000	\N	2004-12-01	82320	\N	\N	f	Sales which are qualified	0
82321_4820.0_2004-12-01	482000	\N	2004-12-01	82321	\N	\N	f	Sales which are qualified	0
82321_6800.0_2004-02-01	680000	\N	2004-02-01	82321	\N	\N	f	Sales which are qualified	0
82321_6800.0_2005-02-25	680000	\N	2005-02-25	82321	\N	\N	f	Sales which are qualified	0
82322_4850.0_2004-12-01	485000	\N	2004-12-01	82322	\N	\N	f	Sales which are qualified	0
82322_8000.0_2019-02-14	800000	\N	2019-02-14	82322	\N	\N	f	Qual by exam of deed	0
82323_5030.0_2004-12-01	503000	\N	2004-12-01	82323	\N	\N	f	Sales which are qualified	0
82324_4910.0_2004-12-01	491000	\N	2004-12-01	82324	\N	\N	f	Sales which are qualified	0
82324_5950.0_2010-06-15	595000	\N	2010-06-15	82324	\N	\N	f	Qual by exam of deed	0
82325_4940.0_2004-12-01	494000	\N	2004-12-01	82325	\N	\N	f	Sales which are qualified	0
82325_5000.0_2010-12-01	500000	\N	2010-12-01	82325	\N	\N	f	Qual by exam of deed	0
82326_4970.0_2005-01-01	497000	\N	2005-01-01	82326	\N	\N	f	Sales which are qualified	0
82326_6740.0_2011-10-28	674000	\N	2011-10-28	82326	\N	\N	f	Qual by exam of deed	0
82326_9605.0_2021-08-03	960500	\N	2021-08-03	82326	\N	\N	f	Qual by exam of deed	0
82327_5000.0_2004-12-01	500000	\N	2004-12-01	82327	\N	\N	f	Sales which are qualified	0
82328_11100.0_2021-08-21	1110000	\N	2021-08-21	82328	\N	\N	f	Qual by exam of deed	0
82328_6670.0_2005-02-01	667000	\N	2005-02-01	82328	\N	\N	f	Sales which are qualified	0
82329_5060.0_2005-01-01	506000	\N	2005-01-01	82329	\N	\N	f	Sales which are qualified	0
82330_13500.0_2022-03-02	1350000	\N	2022-03-02	82330	\N	\N	f	Qual by exam of deed	0
82330_5090.0_2005-02-01	509000	\N	2005-02-01	82330	\N	\N	f	Sales which are qualified	0
82330_7050.0_2012-09-19	705000	\N	2012-09-19	82330	\N	\N	f	Qual by exam of deed	0
82331_5270.0_2005-01-01	527000	\N	2005-01-01	82331	\N	\N	f	Sales which are qualified	0
82331_5300.0_2011-09-30	530000	\N	2011-09-30	82331	\N	\N	f	Qual by exam of deed	0
82331_8650.0_2020-11-16	865000	\N	2020-11-16	82331	\N	\N	f	Qual by exam of deed	0
82332_5300.0_2005-01-01	530000	\N	2005-01-01	82332	\N	\N	f	Sales which are qualified	0
82333_5330.0_2005-01-01	533000	\N	2005-01-01	82333	\N	\N	f	Sales which are qualified	0
82333_7300.0_2008-09-29	730000	\N	2008-09-29	82333	\N	\N	f	Sales which are qualified	0
82333_8000.0_2013-05-27	800000	\N	2013-05-27	82333	\N	\N	f	Qual by exam of deed	0
82334_6850.0_2005-03-01	685000	\N	2005-03-01	82334	\N	\N	f	Sales which are qualified	0
82335_11000.0_2014-10-30	1100000	\N	2014-10-30	82335	\N	\N	f	Qual by exam of deed	0
82335_6880.0_2005-02-01	688000	\N	2005-02-01	82335	\N	\N	f	Sales which are qualified	0
82336_5720.0_2005-01-01	572000	\N	2005-01-01	82336	\N	\N	f	Sales which are qualified	0
82337_5630.0_2005-03-01	563000	\N	2005-03-01	82337	\N	\N	f	Sales which are qualified	0
82337_7350.0_2012-02-23	735000	\N	2012-02-23	82337	\N	\N	f	Qual by exam of deed	0
82337_7550.0_2005-03-01	755000	\N	2005-03-01	82337	\N	\N	f	Sales which are qualified	0
82337_7770.0_2008-05-01	777000	\N	2008-05-01	82337	\N	\N	f	Sales which are qualified	0
82338_5810.0_2005-03-01	581000	\N	2005-03-01	82338	\N	\N	f	Sales which are qualified	0
82338_8000.0_2005-05-01	800000	\N	2005-05-01	82338	\N	\N	f	Sales which are qualified	0
82339_11500.0_2013-12-13	1150000	\N	2013-12-13	82339	\N	\N	f	Qual by exam of deed	0
82339_5610.0_2005-03-01	561000	\N	2005-03-01	82339	\N	\N	f	Sales which are qualified	0
82339_8750.0_2007-05-01	875000	\N	2007-05-01	82339	\N	\N	f	Sales which are qualified	0
82340_5710.0_2005-03-01	571000	\N	2005-03-01	82340	\N	\N	f	Sales which are qualified	0
82341_5960.0_2005-03-01	596000	\N	2005-03-01	82341	\N	\N	f	Sales which are qualified	0
82341_9600.0_2006-04-01	960000	\N	2006-04-01	82341	\N	\N	f	Sales which are qualified	0
82342_6060.0_2005-03-01	606000	\N	2005-03-01	82342	\N	\N	f	Sales which are qualified	0
82343_19000.0_2005-05-01	1900000	\N	2005-05-01	82343	\N	\N	f	Sales which are qualified	0
82344_2670.0_2011-04-21	267000	\N	2011-04-21	82344	\N	\N	f	Qual by verifiable & documented evidence	0
82344_3600.0_2005-02-01	360000	\N	2005-02-01	82344	\N	\N	f	Sales which are qualified	0
82344_4560.0_2007-03-01	456000	\N	2007-03-01	82344	\N	\N	f	Sales which are qualified	0
82345_2520.0_2004-11-01	252000	\N	2004-11-01	82345	\N	\N	f	Sales which are qualified	0
82346_2550.0_2004-11-01	255000	\N	2004-11-01	82346	\N	\N	f	Sales which are qualified	0
82347_2580.0_2004-11-01	258000	\N	2004-11-01	82347	\N	\N	f	Sales which are qualified	0
82347_3250.0_2012-03-09	325000	\N	2012-03-09	82347	\N	\N	f	Qual by exam of deed	0
82348_2870.0_2004-11-01	287000	\N	2004-11-01	82348	\N	\N	f	Sales which are qualified	0
82348_6250.0_2007-01-01	625000	\N	2007-01-01	82348	\N	\N	f	Sales which are qualified	0
82349_3850.0_2005-02-01	385000	\N	2005-02-01	82349	\N	\N	f	Sales which are qualified	0
82349_4700.0_2013-12-11	470000	\N	2013-12-11	82349	\N	\N	f	Qual by exam of deed	0
82349_5200.0_2017-06-28	520000	\N	2017-06-28	82349	\N	\N	f	Qual by exam of deed	0
82350_2960.0_2004-11-01	296000	\N	2004-11-01	82350	\N	\N	f	Sales which are qualified	0
82350_4050.0_2004-11-01	405000	\N	2004-11-01	82350	\N	\N	f	Sales which are qualified	0
82350_4600.0_2014-02-14	460000	\N	2014-02-14	82350	\N	\N	f	Qual by exam of deed	0
82351_3750.0_2005-01-01	375000	\N	2005-01-01	82351	\N	\N	f	Sales which are qualified	0
82351_3750.0_2012-12-28	375000	\N	2012-12-28	82351	\N	\N	f	Qual by exam of deed	0
82352_2730.0_2004-11-01	273000	\N	2004-11-01	82352	\N	\N	f	Sales which are qualified	0
82353_3200.0_2011-09-07	320000	\N	2011-09-07	82353	\N	\N	f	Qual by exam of deed	0
82353_3515.0_2005-01-01	351500	\N	2005-01-01	82353	\N	\N	f	Sales which are qualified	0
82353_4970.0_2016-03-16	497000	\N	2016-03-16	82353	\N	\N	f	Qual by exam of deed	0
82354_2750.5_2004-12-01	275050	\N	2004-12-01	82354	\N	\N	f	Sales which are qualified	0
82354_3080.0_2011-06-10	308000	\N	2011-06-10	82354	\N	\N	f	Qual by verifiable & documented evidence	0
82354_4250.0_2005-04-01	425000	\N	2005-04-01	82354	\N	\N	f	Sales which are qualified	0
82354_6050.0_2006-06-01	605000	\N	2006-06-01	82354	\N	\N	f	Sales which are qualified	0
82354_6850.0_2022-10-12	685000	\N	2022-10-12	82354	\N	\N	f	Qual by exam of deed	0
82355_2820.0_2004-12-01	282000	\N	2004-12-01	82355	\N	\N	f	Sales which are qualified	0
82356_3140.0_2004-12-01	314000	\N	2004-12-01	82356	\N	\N	f	Sales which are qualified	0
82357_3170.0_2004-12-01	317000	\N	2004-12-01	82357	\N	\N	f	Sales which are qualified	0
82357_4350.0_2005-02-01	435000	\N	2005-02-01	82357	\N	\N	f	Sales which are qualified	0
82357_6150.0_2006-06-01	615000	\N	2006-06-01	82357	\N	\N	f	Sales which are qualified	0
82358_3200.0_2004-12-01	320000	\N	2004-12-01	82358	\N	\N	f	Sales which are qualified	0
82358_5800.0_2021-10-27	580000	\N	2021-10-27	82358	\N	\N	f	Qual by exam of deed	0
82359_2940.0_2004-12-01	294000	\N	2004-12-01	82359	\N	\N	f	Sales which are qualified	0
82359_4490.0_2005-04-01	449000	\N	2005-04-01	82359	\N	\N	f	Sales which are qualified	0
82359_5150.0_2013-11-08	515000	\N	2013-11-08	82359	\N	\N	f	Qual by exam of deed	0
82360_3194.8_2004-01-01	319480	\N	2004-01-01	82360	\N	\N	f	Sales which are qualified	0
82361_3290.0_2004-12-01	329000	\N	2004-12-01	82361	\N	\N	f	Sales which are qualified	0
82361_4400.0_2005-01-01	440000	\N	2005-01-01	82361	\N	\N	f	Sales which are qualified	0
82362_3420.0_2005-01-01	342000	\N	2005-01-01	82362	\N	\N	f	Sales which are qualified	0
82362_6250.0_2007-06-01	625000	\N	2007-06-01	82362	\N	\N	f	Sales which are qualified	0
82363_3060.0_2004-12-01	306000	\N	2004-12-01	82363	\N	\N	f	Sales which are qualified	0
82363_4000.0_2005-05-01	400000	\N	2005-05-01	82363	\N	\N	f	Sales which are qualified	0
82363_6150.0_2006-09-01	615000	\N	2006-09-01	82363	\N	\N	f	Sales which are qualified	0
82364_3380.0_2004-12-01	338000	\N	2004-12-01	82364	\N	\N	f	Sales which are qualified	0
82364_5100.0_2021-04-23	510000	\N	2021-04-23	82364	\N	\N	f	Qual by exam of deed	0
82365_4390.0_2005-01-01	439000	\N	2005-01-01	82365	\N	\N	f	Sales which are qualified	0
82365_5850.0_2015-06-13	585000	\N	2015-06-13	82365	\N	\N	f	Qual by exam of deed	0
82366_3990.0_2004-12-01	399000	\N	2004-12-01	82366	\N	\N	f	Sales which are qualified	0
82367_4060.0_2004-12-01	406000	\N	2004-12-01	82367	\N	\N	f	Sales which are qualified	0
82368_4130.0_2005-01-01	413000	\N	2005-01-01	82368	\N	\N	f	Sales which are qualified	0
82368_5750.0_2005-03-01	575000	\N	2005-03-01	82368	\N	\N	f	Sales which are qualified	0
82369_4200.0_2005-01-01	420000	\N	2005-01-01	82369	\N	\N	f	Sales which are qualified	0
82369_4750.0_2010-07-01	475000	\N	2010-07-01	82369	\N	\N	f	Qual by exam of deed	0
82369_7750.0_2006-09-01	775000	\N	2006-09-01	82369	\N	\N	f	Sales which are qualified	0
82370_4270.0_2005-01-01	427000	\N	2005-01-01	82370	\N	\N	f	Sales which are qualified	0
82370_4750.0_2010-02-10	475000	\N	2010-02-10	82370	\N	\N	f	Qual by exam of deed	0
82370_5800.0_2005-03-01	580000	\N	2005-03-01	82370	\N	\N	f	Sales which are qualified	0
82371_4340.0_2005-01-01	434000	\N	2005-01-01	82371	\N	\N	f	Sales which are qualified	0
82371_7500.0_2015-04-09	750000	\N	2015-04-09	82371	\N	\N	f	Qual by exam of deed	0
82372_4660.0_2005-01-01	466000	\N	2005-01-01	82372	\N	\N	f	Sales which are qualified	0
82372_6100.0_2005-04-01	610000	\N	2005-04-01	82372	\N	\N	f	Sales which are qualified	0
82373_4730.0_2005-01-01	473000	\N	2005-01-01	82373	\N	\N	f	Sales which are qualified	0
82374_4550.0_2005-03-01	455000	\N	2005-03-01	82374	\N	\N	f	Sales which are qualified	0
82375_4620.0_2005-03-01	462000	\N	2005-03-01	82375	\N	\N	f	Sales which are qualified	0
82375_4700.0_2009-10-19	470000	\N	2009-10-19	82375	\N	\N	f	Qual by exam of deed	0
82376_3179.0_2008-12-08	317900	\N	2008-12-08	82376	\N	\N	f	Sales which are qualified	0
82376_4690.0_2005-03-01	469000	\N	2005-03-01	82376	\N	\N	f	Sales which are qualified	0
82376_7000.0_2018-12-18	700000	\N	2018-12-18	82376	\N	\N	f	Qual by exam of deed	0
82377_4760.0_2005-03-01	476000	\N	2005-03-01	82377	\N	\N	f	Sales which are qualified	0
82378_4830.0_2005-03-01	483000	\N	2005-03-01	82378	\N	\N	f	Sales which are qualified	0
82378_5900.0_2008-07-18	590000	\N	2008-07-18	82378	\N	\N	f	Sales which are qualified	0
82378_7600.0_2016-09-12	760000	\N	2016-09-12	82378	\N	\N	f	Qual by exam of deed	0
82379_10000.0_2022-03-16	1000000	\N	2022-03-16	82379	\N	\N	f	Qual by exam of deed	0
82379_4450.0_2011-01-07	445000	\N	2011-01-07	82379	\N	\N	f	Qual by verifiable & documented evidence	0
82379_6340.0_2005-03-01	634000	\N	2005-03-01	82379	\N	\N	f	Sales which are qualified	0
82380_6610.0_2005-03-01	661000	\N	2005-03-01	82380	\N	\N	t	Deeds that include more than one parcel	0
82380_7000.0_2021-02-17	700000	\N	2021-02-17	82380	\N	\N	f	Qual by exam of deed	0
82380_7140.0_2014-01-15	714000	\N	2014-01-15	82380	\N	\N	f	Qual by exam of deed	0
82381_12500.0_2007-08-01	1250000	\N	2007-08-01	82381	\N	\N	f	Sales which are qualified	0
82381_7000.0_2005-06-01	700000	\N	2005-06-01	82381	\N	\N	f	Sales which are qualified	0
82381_9700.0_2012-04-27	970000	\N	2012-04-27	82381	\N	\N	f	Qual by exam of deed	0
82382_2970.0_2004-11-01	297000	\N	2004-11-01	82382	\N	\N	f	Sales which are qualified	0
82382_3800.0_2013-10-18	380000	\N	2013-10-18	82382	\N	\N	f	Qual by exam of deed	0
82383_2150.0_2004-11-01	215000	\N	2004-11-01	82383	\N	\N	f	Sales which are qualified	0
82383_2400.0_2012-05-18	240000	\N	2012-05-18	82383	\N	\N	f	Qual by exam of deed	0
82384_2180.0_2004-12-01	218000	\N	2004-12-01	82384	\N	\N	f	Sales which are qualified	0
82384_3510.0_2005-02-01	351000	\N	2005-02-01	82384	\N	\N	f	Sales which are qualified	0
82384_3845.0_2005-08-01	384500	\N	2005-08-01	82384	\N	\N	f	Sales which are qualified	0
82385_2210.0_2004-11-01	221000	\N	2004-11-01	82385	\N	\N	f	Sales which are qualified	0
82386_2240.0_2004-12-01	224000	\N	2004-12-01	82386	\N	\N	f	Sales which are qualified	0
82387_2550.0_2004-12-01	255000	\N	2004-12-01	82387	\N	\N	f	Sales which are qualified	0
82387_3850.0_2005-06-01	385000	\N	2005-06-01	82387	\N	\N	f	Sales which are qualified	0
82387_6050.0_2007-05-01	605000	\N	2007-05-01	82387	\N	\N	f	Sales which are qualified	0
82388_2300.0_2004-11-01	230000	\N	2004-11-01	82388	\N	\N	f	Sales which are qualified	0
82388_2400.0_2012-01-13	240000	\N	2012-01-13	82388	\N	\N	f	Qual by exam of deed	0
82388_3600.0_2005-04-01	360000	\N	2005-04-01	82388	\N	\N	f	Sales which are qualified	0
82389_3210.0_2005-02-01	321000	\N	2005-02-01	82389	\N	\N	f	Sales which are qualified	0
82389_3800.0_2017-12-29	380000	\N	2017-12-29	82389	\N	\N	f	Qual by exam of deed	0
82389_3850.0_2005-05-01	385000	\N	2005-05-01	82389	\N	\N	f	Sales which are qualified	0
82389_3900.0_2019-06-05	390000	\N	2019-06-05	82389	\N	\N	f	Qual by exam of deed	0
82390_2360.0_2004-11-01	236000	\N	2004-11-01	82390	\N	\N	f	Sales which are qualified	0
82390_2820.0_2012-03-19	282000	\N	2012-03-19	82390	\N	\N	f	Qual by exam of deed	0
82390_3950.0_2007-12-01	395000	\N	2007-12-01	82390	\N	\N	f	Sales which are qualified	0
82390_4100.0_2018-10-01	410000	\N	2018-10-01	82390	\N	\N	f	Qual by exam of deed	0
82391_2390.0_2004-12-01	239000	\N	2004-12-01	82391	\N	\N	f	Sales which are qualified	0
82392_2700.0_2004-12-01	270000	\N	2004-12-01	82392	\N	\N	f	Sales which are qualified	0
82392_6200.0_2007-06-01	620000	\N	2007-06-01	82392	\N	\N	f	Sales which are qualified	0
82393_2800.0_2011-08-25	280000	\N	2011-08-25	82393	\N	\N	f	Qual by exam of deed	0
82393_3400.0_2005-03-01	340000	\N	2005-03-01	82393	\N	\N	f	Sales which are qualified	0
82394_2760.0_2004-12-01	276000	\N	2004-12-01	82394	\N	\N	f	Sales which are qualified	0
82394_3600.0_2019-05-23	360000	\N	2019-05-23	82394	\N	\N	f	Qual by exam of deed	0
82395_2510.0_2004-12-01	251000	\N	2004-12-01	82395	\N	\N	f	Sales which are qualified	0
82395_3500.0_2005-04-01	350000	\N	2005-04-01	82395	\N	\N	f	Sales which are qualified	0
82395_4200.0_2005-07-01	420000	\N	2005-07-01	82395	\N	\N	f	Sales which are qualified	0
82396_2540.0_2004-12-01	254000	\N	2004-12-01	82396	\N	\N	f	Sales which are qualified	0
82396_2999.0_2012-04-19	299900	\N	2012-04-19	82396	\N	\N	f	Qual by exam of deed	0
82396_3750.0_2005-04-01	375000	\N	2005-04-01	82396	\N	\N	f	Sales which are qualified	0
82396_4060.0_2005-07-01	406000	\N	2005-07-01	82396	\N	\N	f	Sales which are qualified	0
82396_6100.0_2006-10-01	610000	\N	2006-10-01	82396	\N	\N	f	Sales which are qualified	0
82397_2850.0_2004-12-01	285000	\N	2004-12-01	82397	\N	\N	f	Sales which are qualified	0
82397_4790.0_2016-05-04	479000	\N	2016-05-04	82397	\N	\N	f	Qual by exam of deed	0
82398_2850.0_2004-12-01	285000	\N	2004-12-01	82398	\N	\N	f	Sales which are qualified	0
82399_3000.0_2010-06-24	300000	\N	2010-06-24	82399	\N	\N	f	Qual by exam of deed	0
82399_3310.0_2004-12-01	331000	\N	2004-12-01	82399	\N	\N	f	Sales which are qualified	0
82399_3750.0_2005-03-01	375000	\N	2005-03-01	82399	\N	\N	f	Sales which are qualified	0
82399_3950.0_2019-09-30	395000	\N	2019-09-30	82399	\N	\N	f	Qual by exam of deed	0
82400_2800.0_2010-02-12	280000	\N	2010-02-12	82400	\N	\N	f	Qual by exam of deed	0
82400_3540.0_2005-01-01	354000	\N	2005-01-01	82400	\N	\N	f	Sales which are qualified	0
82400_4370.0_2005-07-01	437000	\N	2005-07-01	82400	\N	\N	f	Sales which are qualified	0
82400_4400.0_2016-03-10	440000	\N	2016-03-10	82400	\N	\N	f	Qual by exam of deed	0
82400_4750.0_2021-08-20	475000	\N	2021-08-20	82400	\N	\N	f	Qual by exam of deed	0
82400_6150.0_2006-09-01	615000	\N	2006-09-01	82400	\N	\N	f	Sales which are qualified	0
82401_2900.0_2011-04-29	290000	\N	2011-04-29	82401	\N	\N	f	Qual by exam of deed	0
82401_3570.0_2004-12-01	357000	\N	2004-12-01	82401	\N	\N	f	Sales which are qualified	0
82401_3620.0_2020-08-07	362000	\N	2020-08-07	82401	\N	\N	f	Qual by exam of deed	0
82401_4590.0_2014-11-06	459000	\N	2014-11-06	82401	\N	\N	f	Qual by exam of deed	0
82401_6300.0_2007-08-01	630000	\N	2007-08-01	82401	\N	\N	f	Sales which are qualified	0
82402_3600.0_2005-01-01	360000	\N	2005-01-01	82402	\N	\N	f	Sales which are qualified	0
82402_3750.0_2013-03-21	375000	\N	2013-03-21	82402	\N	\N	f	Qual by exam of deed	0
82402_4300.0_2021-04-27	430000	\N	2021-04-27	82402	\N	\N	f	Qual by exam of deed	0
82403_3000.0_2009-09-04	300000	\N	2009-09-04	82403	\N	\N	f	Qual by exam of deed	0
82403_3230.0_2005-01-01	323000	\N	2005-01-01	82403	\N	\N	f	Sales which are qualified	0
82403_5500.0_2021-09-20	550000	\N	2021-09-20	82403	\N	\N	f	Qual by exam of deed	0
82404_2490.0_2004-11-01	249000	\N	2004-11-01	82404	\N	\N	f	Sales which are qualified	0
82404_3100.0_2010-12-28	310000	\N	2010-12-28	82404	\N	\N	f	Qual by exam of deed	0
82404_4400.0_2019-05-08	440000	\N	2019-05-08	82404	\N	\N	f	Qual by exam of deed	0
82404_5100.0_2007-03-01	510000	\N	2007-03-01	82404	\N	\N	f	Sales which are qualified	0
82405_2394.0_2004-11-01	239400	\N	2004-11-01	82405	\N	\N	f	Sales which are qualified	0
82405_5500.0_2006-05-01	550000	\N	2006-05-01	82405	\N	\N	f	Sales which are qualified	0
82405_7000.0_2023-03-31	700000	\N	2023-03-31	82405	\N	\N	f	Qual by exam of deed	0
82406_2550.0_2004-11-01	255000	\N	2004-11-01	82406	\N	\N	f	Sales which are qualified	0
82406_3200.0_2009-11-09	320000	\N	2009-11-09	82406	\N	\N	f	Qual by exam of deed	0
82407_2580.0_2004-11-01	258000	\N	2004-11-01	82407	\N	\N	f	Sales which are qualified	0
82407_3300.0_2004-11-01	330000	\N	2004-11-01	82407	\N	\N	f	Sales which are qualified	0
82407_4500.0_2020-06-22	450000	\N	2020-06-22	82407	\N	\N	f	Qual by exam of deed	0
82408_2610.0_2004-11-01	261000	\N	2004-11-01	82408	\N	\N	f	Sales which are qualified	0
82408_5490.0_2017-10-03	549000	\N	2017-10-03	82408	\N	\N	f	Qual by exam of deed	0
82408_5500.0_2006-04-01	550000	\N	2006-04-01	82408	\N	\N	f	Sales which are qualified	0
82408_6950.0_2022-09-23	695000	\N	2022-09-23	82408	\N	\N	f	Qual by exam of deed	0
82409_2640.0_2004-11-01	264000	\N	2004-11-01	82409	\N	\N	f	Sales which are qualified	0
82409_3750.0_2008-10-27	375000	\N	2008-10-27	82409	\N	\N	f	Sales which are qualified	0
82410_2670.0_2004-11-01	267000	\N	2004-11-01	82410	\N	\N	f	Sales which are qualified	0
82410_3400.0_2008-12-12	340000	\N	2008-12-12	82410	\N	\N	f	Sales which are qualified	0
82410_6010.0_2007-02-01	601000	\N	2007-02-01	82410	\N	\N	f	Sales which are qualified	0
82411_3750.0_2005-01-01	375000	\N	2005-01-01	82411	\N	\N	f	Sales which are qualified	0
82412_2730.0_2004-11-01	273000	\N	2004-11-01	82412	\N	\N	f	Sales which are qualified	0
82412_4200.0_2005-04-01	420000	\N	2005-04-01	82412	\N	\N	f	Sales which are qualified	0
82412_5950.0_2021-07-30	595000	\N	2021-07-30	82412	\N	\N	f	Qual by exam of deed	0
82413_3170.0_2005-01-01	317000	\N	2005-01-01	82413	\N	\N	f	Sales which are qualified	0
82413_3750.0_2005-01-01	375000	\N	2005-01-01	82413	\N	\N	f	Sales which are qualified	0
82413_4200.0_2013-08-21	420000	\N	2013-08-21	82413	\N	\N	f	Qual by exam of deed	0
82414_2790.0_2004-12-01	279000	\N	2004-12-01	82414	\N	\N	f	Sales which are qualified	0
82414_4000.0_2020-11-12	400000	\N	2020-11-12	82414	\N	\N	f	Qual by exam of deed	0
82414_4450.0_2005-02-01	445000	\N	2005-02-01	82414	\N	\N	f	Sales which are qualified	0
82415_2820.0_2004-12-01	282000	\N	2004-12-01	82415	\N	\N	f	Sales which are qualified	0
82415_5650.0_2015-10-02	565000	\N	2015-10-02	82415	\N	\N	f	Qual by exam of deed	0
82415_5800.0_2007-11-01	580000	\N	2007-11-01	82415	\N	\N	f	Sales which are qualified	0
82415_6070.0_2018-03-21	607000	\N	2018-03-21	82415	\N	\N	f	Qual by exam of deed	0
82416_2790.0_2004-12-01	279000	\N	2004-12-01	82416	\N	\N	f	Sales which are qualified	0
82416_2900.0_2011-03-16	290000	\N	2011-03-16	82416	\N	\N	f	Qual by verifiable & documented evidence	0
82417_2880.0_2004-12-01	288000	\N	2004-12-01	82417	\N	\N	f	Sales which are qualified	0
82418_2880.0_2004-12-01	288000	\N	2004-12-01	82418	\N	\N	f	Sales which are qualified	0
82418_3540.5_2004-12-01	354050	\N	2004-12-01	82418	\N	\N	f	Sales which are qualified	0
82418_5100.0_2021-03-05	510000	\N	2021-03-05	82418	\N	\N	f	Qual by exam of deed	0
82418_6350.0_2022-03-18	635000	\N	2022-03-18	82418	\N	\N	f	Qual by exam of deed	0
82418_7250.0_2023-12-04	725000	\N	2023-12-04	82418	\N	\N	f	Qual by exam of deed	0
82419_2100.0_2009-02-23	210000	\N	2009-02-23	82419	\N	\N	f	Qual by exam of deed	0
82419_3273.2_2005-01-01	327320	\N	2005-01-01	82419	\N	\N	f	Sales which are qualified	0
82419_3450.0_2011-05-18	345000	\N	2011-05-18	82419	\N	\N	f	Qual by exam of deed	0
82419_5500.0_2021-05-14	550000	\N	2021-05-14	82419	\N	\N	f	Qual by exam of deed	0
82419_6160.0_2006-10-01	616000	\N	2006-10-01	82419	\N	\N	f	Sales which are qualified	0
82420_3820.0_2005-02-01	382000	\N	2005-02-01	82420	\N	\N	f	Sales which are qualified	0
82420_4410.0_2005-03-01	441000	\N	2005-03-01	82420	\N	\N	f	Sales which are qualified	0
82420_4700.0_2005-05-01	470000	\N	2005-05-01	82420	\N	\N	f	Sales which are qualified	0
82420_4800.0_2013-08-28	480000	\N	2013-08-28	82420	\N	\N	f	Qual by exam of deed	0
82421_3300.0_2011-04-26	330000	\N	2011-04-26	82421	\N	\N	f	Qual by exam of deed	0
82421_4050.0_2004-12-01	405000	\N	2004-12-01	82421	\N	\N	f	Sales which are qualified	0
82421_5950.0_2015-07-29	595000	\N	2015-07-29	82421	\N	\N	f	Qual by exam of deed	0
82422_4080.0_2004-12-01	408000	\N	2004-12-01	82422	\N	\N	f	Sales which are qualified	0
82422_5700.0_2016-10-18	570000	\N	2016-10-18	82422	\N	\N	f	Qual by exam of deed	0
82422_7100.0_2022-06-02	710000	\N	2022-06-02	82422	\N	\N	f	Qual by exam of deed	0
82423_4110.0_2004-12-01	411000	\N	2004-12-01	82423	\N	\N	f	Sales which are qualified	0
82423_6800.0_2022-09-15	680000	\N	2022-09-15	82423	\N	\N	f	Qual by exam of deed	0
82424_3940.0_2005-01-01	394000	\N	2005-01-01	82424	\N	\N	f	Sales which are qualified	0
82424_4500.0_2005-03-01	450000	\N	2005-03-01	82424	\N	\N	f	Sales which are qualified	0
82424_4700.0_2013-08-08	470000	\N	2013-08-08	82424	\N	\N	f	Qual by exam of deed	0
82425_3520.0_2004-12-01	352000	\N	2004-12-01	82425	\N	\N	f	Sales which are qualified	0
82425_5000.0_2013-12-09	500000	\N	2013-12-09	82425	\N	\N	f	Qual by exam of deed	0
82426_3990.0_2005-01-01	399000	\N	2005-01-01	82426	\N	\N	f	Sales which are qualified	0
82426_5300.0_2012-04-13	530000	\N	2012-04-13	82426	\N	\N	f	Qual by exam of deed	0
82426_5700.0_2005-03-01	570000	\N	2005-03-01	82426	\N	\N	f	Sales which are qualified	0
82427_5400.0_2008-10-31	540000	\N	2008-10-31	82427	\N	\N	f	Sales which are qualified	0
82427_5577.5_2005-02-01	557750	\N	2005-02-01	82427	\N	\N	f	Sales which are qualified	0
82427_7500.0_2005-12-01	750000	\N	2005-12-01	82427	\N	\N	f	Sales which are qualified	0
82428_4130.0_2005-01-01	413000	\N	2005-01-01	82428	\N	\N	f	Sales which are qualified	0
82428_7201.0_2019-07-15	720100	\N	2019-07-15	82428	\N	\N	f	Qual by exam of deed	0
82429_4200.0_2005-01-01	420000	\N	2005-01-01	82429	\N	\N	f	Sales which are qualified	0
82429_7500.0_2020-04-23	750000	\N	2020-04-23	82429	\N	\N	f	Qual by exam of deed	0
82430_6850.0_2005-08-01	685000	\N	2005-08-01	82430	\N	\N	f	Sales which are qualified	0
82430_6990.0_2013-12-31	699000	\N	2013-12-31	82430	\N	\N	f	Qual by exam of deed	0
82431_4490.0_2005-01-01	449000	\N	2005-01-01	82431	\N	\N	f	Sales which are qualified	0
82431_6470.0_2006-03-01	647000	\N	2006-03-01	82431	\N	\N	f	Sales which are qualified	0
82431_7900.0_2006-10-30	790000	\N	2006-10-30	82431	\N	\N	f	Sales which are qualified	0
82432_4560.0_2005-01-01	456000	\N	2005-01-01	82432	\N	\N	f	Sales which are qualified	0
82433_5800.0_2005-01-01	580000	\N	2005-01-01	82433	\N	\N	f	Sales which are qualified	0
82434_12750.0_2023-02-22	1275000	\N	2023-02-22	82434	\N	\N	f	Qual by exam of deed	0
82434_4700.0_2005-03-01	470000	\N	2005-03-01	82434	\N	\N	f	Sales which are qualified	0
82435_4770.0_2005-03-01	477000	\N	2005-03-01	82435	\N	\N	f	Sales which are qualified	0
82436_5290.0_2005-03-01	529000	\N	2005-03-01	82436	\N	\N	f	Sales which are qualified	0
82437_5160.0_2005-03-01	516000	\N	2005-03-01	82437	\N	\N	f	Sales which are qualified	0
82437_5800.0_2008-09-04	580000	\N	2008-09-04	82437	\N	\N	f	Sales which are qualified	0
82437_7350.0_2005-10-01	735000	\N	2005-10-01	82437	\N	\N	f	Sales which are qualified	0
82437_8200.0_2015-05-05	820000	\N	2015-05-05	82437	\N	\N	f	Qual by exam of deed	0
82438_5000.0_2011-04-15	500000	\N	2011-04-15	82438	\N	\N	f	Qual by exam of deed	0
82438_5430.0_2005-04-01	543000	\N	2005-04-01	82438	\N	\N	f	Sales which are qualified	0
82438_6000.0_2011-12-23	600000	\N	2011-12-23	82438	\N	\N	f	Qual by exam of deed	0
82438_8000.0_2016-11-18	800000	\N	2016-11-18	82438	\N	\N	f	Qual by exam of deed	0
82439_5500.0_2005-04-01	550000	\N	2005-04-01	82439	\N	\N	f	Sales which are qualified	0
82439_6535.0_2013-04-10	653500	\N	2013-04-10	82439	\N	\N	f	Qual by exam of deed	0
82440_5570.0_2005-03-01	557000	\N	2005-03-01	82440	\N	\N	f	Sales which are qualified	0
82441_12000.0_2005-07-01	1200000	\N	2005-07-01	82441	\N	\N	f	Sales which are qualified	0
82441_12500.0_2013-08-20	1250000	\N	2013-08-20	82441	\N	\N	f	Qual by exam of deed	0
82441_18000.0_2017-05-01	1800000	\N	2017-05-01	82441	\N	\N	f	Qual by exam of deed	0
79849_56250.0_2016-07-06	5625000	\N	2016-07-06	79849	\N	\N	f	Qual by exam of deed	0
79849_72000.0_2018-05-07	7200000	\N	2018-05-07	79849	\N	\N	f	Qual by exam of deed	0
79850_75000.0_2016-05-23	7500000	\N	2016-05-23	79850	\N	\N	f	Qual by exam of deed	0
79851_131250.0_2016-06-09	13125000	\N	2016-06-09	79851	\N	\N	f	Qual by exam of deed	0
79852_60000.0_2021-05-10	6000000	\N	2021-05-10	79852	\N	\N	f	Qual by exam of deed	0
79852_65814.0_2017-08-28	6581400	\N	2017-08-28	79852	\N	\N	f	Qual by exam of deed	0
79852_75000.0_2016-06-24	7500000	\N	2016-06-24	79852	\N	\N	f	Qual by exam of deed	0
79853_64000.0_2016-06-15	6400000	\N	2016-06-15	79853	\N	\N	f	Qual by exam of deed	0
79854_57608.0_2016-06-06	5760800	\N	2016-06-06	79854	\N	\N	f	Qual by exam of deed	0
79855_140000.0_2016-05-27	14000000	\N	2016-05-27	79855	\N	\N	f	Qual by exam of deed	0
82476_3220.0_2005-01-01	322000	\N	2005-01-01	82476	\N	\N	f	Sales which are qualified	0
82476_4050.0_2019-09-27	405000	\N	2019-09-27	82476	\N	\N	f	Qual by exam of deed	0
82476_4650.0_2013-09-04	465000	\N	2013-09-04	82476	\N	\N	f	Qual by exam of deed	0
82479_6500.0_2022-05-24	650000	\N	2022-05-24	82479	\N	\N	f	Qual by exam of deed	0
82480_2520.0_2005-02-01	252000	\N	2005-02-01	82480	\N	\N	f	Sales which are qualified	0
82480_3100.0_2011-11-03	310000	\N	2011-11-03	82480	\N	\N	f	Qual by exam of deed	0
82481_3020.0_2005-02-01	302000	\N	2005-02-01	82481	\N	\N	f	Sales which are qualified	0
82482_2620.0_2005-02-01	262000	\N	2005-02-01	82482	\N	\N	f	Sales which are qualified	0
82482_2900.0_2011-08-02	290000	\N	2011-08-02	82482	\N	\N	f	Qual by verifiable & documented evidence	0
82482_3990.0_2013-08-09	399000	\N	2013-08-09	82482	\N	\N	f	Qual by exam of deed	0
82482_4690.0_2005-08-01	469000	\N	2005-08-01	82482	\N	\N	f	Sales which are qualified	0
82483_2600.0_2011-07-29	260000	\N	2011-07-29	82483	\N	\N	f	Qual by exam of deed	0
82483_3385.6_2005-02-01	338560	\N	2005-02-01	82483	\N	\N	f	Sales which are qualified	0
82483_4950.0_2005-09-01	495000	\N	2005-09-01	82483	\N	\N	f	Sales which are qualified	0
82484_2900.0_2009-05-27	290000	\N	2009-05-27	82484	\N	\N	f	Qual by exam of deed	0
82484_3458.95_2005-02-01	345895	\N	2005-02-01	82484	\N	\N	f	Sales which are qualified	0
82484_4600.0_2019-03-13	460000	\N	2019-03-13	82484	\N	\N	f	Qual by exam of deed	0
82484_5764.0_2022-02-25	576400	\N	2022-02-25	82484	\N	\N	f	Qual by exam of deed	0
82485_3210.0_2005-02-01	321000	\N	2005-02-01	82485	\N	\N	f	Sales which are qualified	0
82485_5000.0_2016-03-31	500000	\N	2016-03-31	82485	\N	\N	f	Qual by exam of deed	0
82485_5950.0_2021-10-28	595000	\N	2021-10-28	82485	\N	\N	f	Qual by exam of deed	0
82486_2885.0_2005-02-01	288500	\N	2005-02-01	82486	\N	\N	f	Sales which are qualified	0
82487_3608.0_2005-02-01	360800	\N	2005-02-01	82487	\N	\N	f	Sales which are qualified	0
82487_3800.0_2013-05-31	380000	\N	2013-05-31	82487	\N	\N	f	Qual by exam of deed	0
82487_4900.0_2005-07-01	490000	\N	2005-07-01	82487	\N	\N	f	Sales which are qualified	0
82487_5150.0_2015-03-05	515000	\N	2015-03-05	82487	\N	\N	f	Qual by exam of deed	0
82488_4050.0_2013-06-19	405000	\N	2013-06-19	82488	\N	\N	f	Qual by exam of deed	0
82488_4537.62_2005-01-01	453762	\N	2005-01-01	82488	\N	\N	f	Sales which are qualified	0
82488_5150.0_2015-09-01	515000	\N	2015-09-01	82488	\N	\N	f	Qual by exam of deed	0
82488_5650.0_2021-04-21	565000	\N	2021-04-21	82488	\N	\N	f	Qual by exam of deed	0
82489_4250.0_2005-01-01	425000	\N	2005-01-01	82489	\N	\N	f	Sales which are qualified	0
82489_5000.0_2012-05-22	500000	\N	2012-05-22	82489	\N	\N	f	Qual by exam of deed	0
82489_7500.0_2014-10-03	750000	\N	2014-10-03	82489	\N	\N	f	Qual by exam of deed	0
82489_7590.0_2005-05-01	759000	\N	2005-05-01	82489	\N	\N	f	Sales which are qualified	0
82490_4290.0_2005-02-01	429000	\N	2005-02-01	82490	\N	\N	f	Sales which are qualified	0
82490_7750.0_2006-09-01	775000	\N	2006-09-01	82490	\N	\N	f	Sales which are qualified	0
82490_9400.0_2022-03-17	940000	\N	2022-03-17	82490	\N	\N	f	Qual by exam of deed	0
82491_3825.0_2005-02-01	382500	\N	2005-02-01	82491	\N	\N	f	Sales which are qualified	0
82491_6850.0_2005-09-01	685000	\N	2005-09-01	82491	\N	\N	f	Sales which are qualified	0
82492_3905.0_2005-02-01	390500	\N	2005-02-01	82492	\N	\N	f	Sales which are qualified	0
82492_6500.0_2019-01-10	650000	\N	2019-01-10	82492	\N	\N	f	Qual by exam of deed	0
82492_6850.0_2013-08-27	685000	\N	2013-08-27	82492	\N	\N	f	Qual by exam of deed	0
82492_7150.0_2005-06-01	715000	\N	2005-06-01	82492	\N	\N	f	Sales which are qualified	0
82492_8350.0_2006-10-01	835000	\N	2006-10-01	82492	\N	\N	f	Sales which are qualified	0
82493_4165.0_2005-02-01	416500	\N	2005-02-01	82493	\N	\N	f	Sales which are qualified	0
82493_8350.0_2006-07-01	835000	\N	2006-07-01	82493	\N	\N	f	Sales which are qualified	0
82494_4220.0_2005-02-01	422000	\N	2005-02-01	82494	\N	\N	f	Sales which are qualified	0
82494_6700.0_2005-04-01	670000	\N	2005-04-01	82494	\N	\N	f	Sales which are qualified	0
82494_8250.0_2006-06-01	825000	\N	2006-06-01	82494	\N	\N	f	Sales which are qualified	0
82495_5750.0_2012-02-21	575000	\N	2012-02-21	82495	\N	\N	f	Qual by exam of deed	0
82495_6555.0_2005-02-01	655500	\N	2005-02-01	82495	\N	\N	f	Sales which are qualified	0
82495_7000.0_2005-06-01	700000	\N	2005-06-01	82495	\N	\N	f	Sales which are qualified	0
82495_8000.0_2014-10-10	800000	\N	2014-10-10	82495	\N	\N	f	Qual by exam of deed	0
82496_5000.0_2005-02-01	500000	\N	2005-02-01	82496	\N	\N	f	Sales which are qualified	0
82496_5791.5_2011-09-22	579150	\N	2011-09-22	82496	\N	\N	f	Qual by exam of deed	0
82497_4325.0_2005-02-01	432500	\N	2005-02-01	82497	\N	\N	f	Sales which are qualified	0
82498_5643.0_2005-02-01	564300	\N	2005-02-01	82498	\N	\N	f	Sales which are qualified	0
82498_7350.0_2005-04-01	735000	\N	2005-04-01	82498	\N	\N	f	Sales which are qualified	0
82498_9200.0_2021-01-07	920000	\N	2021-01-07	82498	\N	\N	f	Qual by exam of deed	0
82499_5709.0_2005-02-01	570900	\N	2005-02-01	82499	\N	\N	f	Sales which are qualified	0
82499_8150.0_2005-09-01	815000	\N	2005-09-01	82499	\N	\N	f	Sales which are qualified	0
82500_5250.0_2009-12-16	525000	\N	2009-12-16	82500	\N	\N	f	Qual by exam of deed	0
82500_5980.0_2005-02-01	598000	\N	2005-02-01	82500	\N	\N	f	Sales which are qualified	0
82500_7550.0_2005-09-01	755000	\N	2005-09-01	82500	\N	\N	f	Sales which are qualified	0
82501_10000.0_2009-12-14	1000000	\N	2009-12-14	82501	\N	\N	f	Qual by exam of deed	0
82501_15700.0_2007-06-01	1570000	\N	2007-06-01	82501	\N	\N	f	Sales which are qualified	0
82501_18900.0_2016-06-20	1890000	\N	2016-06-20	82501	\N	\N	f	Qual by exam of deed	0
82501_8600.0_2005-03-01	860000	\N	2005-03-01	82501	\N	\N	f	Sales which are qualified	0
82502_6305.0_2007-05-01	630500	\N	2007-05-01	82502	\N	\N	f	Sales which are qualified	0
82503_3745.0_2005-02-01	374500	\N	2005-02-01	82503	\N	\N	f	Sales which are qualified	0
82503_5500.0_2008-02-01	550000	\N	2008-02-01	82503	\N	\N	f	Sales which are qualified	0
82503_7650.0_2005-08-01	765000	\N	2005-08-01	82503	\N	\N	f	Sales which are qualified	0
82503_8000.0_2020-06-09	800000	\N	2020-06-09	82503	\N	\N	f	Qual by exam of deed	0
82504_4005.0_2005-02-01	400500	\N	2005-02-01	82504	\N	\N	f	Sales which are qualified	0
82504_5500.0_2014-01-09	550000	\N	2014-01-09	82504	\N	\N	f	Qual by exam of deed	0
82505_5500.0_2005-02-01	550000	\N	2005-02-01	82505	\N	\N	f	Sales which are qualified	0
82505_5500.0_2011-02-28	550000	\N	2011-02-28	82505	\N	\N	f	Qual by exam of deed	0
82506_13000.0_2022-12-12	1300000	\N	2022-12-12	82506	\N	\N	f	Qual by exam of deed	0
82506_6480.0_2005-02-01	648000	\N	2005-02-01	82506	\N	\N	f	Sales which are qualified	0
82506_8250.0_2006-08-01	825000	\N	2006-08-01	82506	\N	\N	f	Sales which are qualified	0
82506_9000.0_2015-01-09	900000	\N	2015-01-09	82506	\N	\N	f	Qual by exam of deed	0
82507_4400.0_2005-02-01	440000	\N	2005-02-01	82507	\N	\N	f	Sales which are qualified	0
82507_6400.0_2012-05-29	640000	\N	2012-05-29	82507	\N	\N	f	Qual by exam of deed	0
82507_7400.0_2005-05-01	740000	\N	2005-05-01	82507	\N	\N	f	Sales which are qualified	0
82507_9235.0_2020-06-08	923500	\N	2020-06-08	82507	\N	\N	f	Qual by exam of deed	0
82508_12950.0_2022-07-14	1295000	\N	2022-07-14	82508	\N	\N	f	Qual by exam of deed	0
82508_6056.92_2005-02-01	605692	\N	2005-02-01	82508	\N	\N	f	Sales which are qualified	0
82508_6200.0_2013-02-13	620000	\N	2013-02-13	82508	\N	\N	f	Qual by exam of deed	0
82508_8500.0_2006-02-01	850000	\N	2006-02-01	82508	\N	\N	f	Sales which are qualified	0
82509_4245.0_2005-02-01	424500	\N	2005-02-01	82509	\N	\N	f	Sales which are qualified	0
82509_7075.0_2005-05-01	707500	\N	2005-05-01	82509	\N	\N	f	Sales which are qualified	0
82510_6780.0_2005-02-01	678000	\N	2005-02-01	82510	\N	\N	f	Sales which are qualified	0
82510_7280.0_2014-05-29	728000	\N	2014-05-29	82510	\N	\N	f	Qual by exam of deed	0
82510_7500.0_2007-06-01	750000	\N	2007-06-01	82510	\N	\N	f	Sales which are qualified	0
82511_4745.0_2005-01-01	474500	\N	2005-01-01	82511	\N	\N	f	Sales which are qualified	0
82511_5250.0_2010-11-01	525000	\N	2010-11-01	82511	\N	\N	f	Qual by exam of deed	0
82511_5465.0_2005-03-01	546500	\N	2005-03-01	82511	\N	\N	f	Sales which are qualified	0
82511_7500.0_2005-07-01	750000	\N	2005-07-01	82511	\N	\N	f	Sales which are qualified	0
82511_9300.0_2019-07-26	930000	\N	2019-07-26	82511	\N	\N	f	Qual by exam of deed	0
82512_4825.0_2005-02-01	482500	\N	2005-02-01	82512	\N	\N	f	Sales which are qualified	0
82512_7690.0_2005-08-01	769000	\N	2005-08-01	82512	\N	\N	f	Sales which are qualified	0
82512_8800.0_2014-11-15	880000	\N	2014-11-15	82512	\N	\N	f	Qual by exam of deed	0
82513_6080.0_2005-02-01	608000	\N	2005-02-01	82513	\N	\N	f	Sales which are qualified	0
82514_2450.0_2005-02-01	245000	\N	2005-02-01	82514	\N	\N	f	Sales which are qualified	0
82514_3350.0_2009-06-02	335000	\N	2009-06-02	82514	\N	\N	f	Qual by exam of deed	0
82514_3607.52_2013-09-16	360752	\N	2013-09-16	82514	\N	\N	f	Qual by exam of deed	0
82515_2155.0_2005-02-01	215500	\N	2005-02-01	82515	\N	\N	f	Sales which are qualified	0
82515_3590.0_2005-04-01	359000	\N	2005-04-01	82515	\N	\N	f	Sales which are qualified	0
82515_4600.0_2005-11-01	460000	\N	2005-11-01	82515	\N	\N	f	Sales which are qualified	0
82516_1280.0_2012-12-31	128000	\N	2012-12-31	82516	\N	\N	f	Qual by exam of deed	0
82516_2205.0_2005-02-01	220500	\N	2005-02-01	82516	\N	\N	f	Sales which are qualified	0
82516_2600.0_2011-03-10	260000	\N	2011-03-10	82516	\N	\N	f	Qual by exam of deed	0
82516_3875.0_2005-07-01	387500	\N	2005-07-01	82516	\N	\N	f	Sales which are qualified	0
82517_2255.0_2005-02-01	225500	\N	2005-02-01	82517	\N	\N	f	Sales which are qualified	0
82517_3100.0_2013-03-22	310000	\N	2013-03-22	82517	\N	\N	f	Qual by exam of deed	0
82517_3750.0_2005-05-01	375000	\N	2005-05-01	82517	\N	\N	f	Sales which are qualified	0
82517_4880.0_2007-06-01	488000	\N	2007-06-01	82517	\N	\N	f	Sales which are qualified	0
82518_2295.0_2005-02-01	229500	\N	2005-02-01	82518	\N	\N	f	Sales which are qualified	0
82518_2800.0_2011-12-15	280000	\N	2011-12-15	82518	\N	\N	f	Qual by exam of deed	0
82519_3100.0_2009-06-30	310000	\N	2009-06-30	82519	\N	\N	f	Qual by exam of deed	0
82519_3750.0_2005-01-01	375000	\N	2005-01-01	82519	\N	\N	f	Sales which are qualified	0
82519_4000.0_2013-07-29	400000	\N	2013-07-29	82519	\N	\N	f	Qual by exam of deed	0
82520_2850.0_2005-02-01	285000	\N	2005-02-01	82520	\N	\N	f	Sales which are qualified	0
82520_5450.0_2022-04-11	545000	\N	2022-04-11	82520	\N	\N	f	Qual by exam of deed	0
82521_3130.0_2005-02-01	313000	\N	2005-02-01	82521	\N	\N	f	Sales which are qualified	0
82522_2485.0_2005-03-01	248500	\N	2005-03-01	82522	\N	\N	f	Sales which are qualified	0
82522_4200.0_2014-12-17	420000	\N	2014-12-17	82522	\N	\N	f	Qual by verifiable & documented evidence	0
82522_4250.0_2005-08-01	425000	\N	2005-08-01	82522	\N	\N	f	Sales which are qualified	0
82523_2600.0_2012-06-18	260000	\N	2012-06-18	82523	\N	\N	f	Qual by exam of deed	0
82523_3601.0_2005-02-01	360100	\N	2005-02-01	82523	\N	\N	f	Sales which are qualified	0
82523_4550.0_2006-06-01	455000	\N	2006-06-01	82523	\N	\N	f	Sales which are qualified	0
82524_3670.0_2005-02-01	367000	\N	2005-02-01	82524	\N	\N	f	Sales which are qualified	0
82525_3460.0_2005-02-01	346000	\N	2005-02-01	82525	\N	\N	f	Sales which are qualified	0
82526_2775.0_2005-02-01	277500	\N	2005-02-01	82526	\N	\N	f	Sales which are qualified	0
82526_4250.0_2005-07-01	425000	\N	2005-07-01	82526	\N	\N	f	Sales which are qualified	0
82526_4700.0_2014-02-13	470000	\N	2014-02-13	82526	\N	\N	f	Qual by exam of deed	0
82526_5300.0_2015-11-09	530000	\N	2015-11-09	82526	\N	\N	f	Qual by exam of deed	0
82526_7500.0_2022-04-20	750000	\N	2022-04-20	82526	\N	\N	f	Qual by exam of deed	0
82526_7750.0_2023-01-20	775000	\N	2023-01-20	82526	\N	\N	f	Qual by exam of deed	0
82527_2765.0_2005-01-01	276500	\N	2005-01-01	82527	\N	\N	f	Sales which are qualified	0
82527_4400.0_2005-04-01	440000	\N	2005-04-01	82527	\N	\N	f	Sales which are qualified	0
82527_5250.0_2007-04-01	525000	\N	2007-04-01	82527	\N	\N	f	Sales which are qualified	0
82527_5300.0_2013-05-23	530000	\N	2013-05-23	82527	\N	\N	f	Qual by exam of deed	0
82527_6290.0_2022-02-15	629000	\N	2022-02-15	82527	\N	\N	f	Qual by exam of deed	0
82527_7990.0_2022-09-01	799000	\N	2022-09-01	82527	\N	\N	f	Qual by exam of deed	0
82528_2425.0_2005-01-01	242500	\N	2005-01-01	82528	\N	\N	f	Sales which are qualified	0
82528_4200.0_2005-04-01	420000	\N	2005-04-01	82528	\N	\N	f	Sales which are qualified	0
82528_5390.0_2006-02-01	539000	\N	2006-02-01	82528	\N	\N	f	Sales which are qualified	0
82529_2475.0_2005-02-01	247500	\N	2005-02-01	82529	\N	\N	f	Sales which are qualified	0
82530_3510.0_2009-08-17	351000	\N	2009-08-17	82530	\N	\N	f	Qual by exam of deed	0
82531_2575.0_2006-01-01	257500	\N	2006-01-01	82531	\N	\N	f	Sales which are qualified	0
82531_5050.0_2017-06-08	505000	\N	2017-06-08	82531	\N	\N	f	Qual by exam of deed	0
82532_2625.0_2005-03-01	262500	\N	2005-03-01	82532	\N	\N	f	Sales which are qualified	0
82532_4500.0_2005-08-01	450000	\N	2005-08-01	82532	\N	\N	f	Sales which are qualified	0
82532_6950.0_2022-08-15	695000	\N	2022-08-15	82532	\N	\N	f	Qual by exam of deed	0
82533_2725.0_2005-02-01	272500	\N	2005-02-01	82533	\N	\N	f	Sales which are qualified	0
82533_4300.0_2005-04-01	430000	\N	2005-04-01	82533	\N	\N	f	Sales which are qualified	0
82533_4640.0_2007-09-01	464000	\N	2007-09-01	82533	\N	\N	f	Sales which are qualified	0
82534_2775.0_2005-02-01	277500	\N	2005-02-01	82534	\N	\N	f	Sales which are qualified	0
82534_4400.0_2005-05-01	440000	\N	2005-05-01	82534	\N	\N	f	Sales which are qualified	0
82534_5210.0_2015-01-13	521000	\N	2015-01-13	82534	\N	\N	f	Qual by exam of deed	0
82534_7000.0_2023-06-06	700000	\N	2023-06-06	82534	\N	\N	f	Qual by exam of deed	0
82535_2775.0_2005-02-01	277500	\N	2005-02-01	82535	\N	\N	f	Sales which are qualified	0
82535_4620.0_2005-09-01	462000	\N	2005-09-01	82535	\N	\N	f	Sales which are qualified	0
82535_5600.0_2015-04-20	560000	\N	2015-04-20	82535	\N	\N	f	Qual by exam of deed	0
82536_4250.0_2005-02-01	425000	\N	2005-02-01	82536	\N	\N	f	Sales which are qualified	0
82537_2875.0_2005-02-01	287500	\N	2005-02-01	82537	\N	\N	f	Sales which are qualified	0
82537_4820.0_2013-08-16	482000	\N	2013-08-16	82537	\N	\N	f	Qual by exam of deed	0
82537_5199.0_2006-02-01	519900	\N	2006-02-01	82537	\N	\N	f	Sales which are qualified	0
82537_5810.0_2016-03-30	581000	\N	2016-03-30	82537	\N	\N	f	Qual by exam of deed	0
82538_2925.0_2005-02-01	292500	\N	2005-02-01	82538	\N	\N	f	Sales which are qualified	0
82538_5150.0_2007-06-01	515000	\N	2007-06-01	82538	\N	\N	f	Sales which are qualified	0
82538_5550.0_2014-04-30	555000	\N	2014-04-30	82538	\N	\N	f	Qual by exam of deed	0
82539_4392.0_2005-02-01	439200	\N	2005-02-01	82539	\N	\N	f	Sales which are qualified	0
82539_6500.0_2015-02-10	650000	\N	2015-02-10	82539	\N	\N	f	Qual by exam of deed	0
82540_2500.0_2010-12-20	250000	\N	2010-12-20	82540	\N	\N	f	Qual by exam of deed	0
82540_2576.0_2005-01-01	257600	\N	2005-01-01	82540	\N	\N	f	Sales which are qualified	0
82540_4490.0_2005-03-01	449000	\N	2005-03-01	82540	\N	\N	f	Sales which are qualified	0
82540_4950.0_2019-08-21	495000	\N	2019-08-21	82540	\N	\N	f	Qual by exam of deed	0
82541_2355.0_2005-02-01	235500	\N	2005-02-01	82541	\N	\N	f	Sales which are qualified	0
82541_2800.0_2010-04-30	280000	\N	2010-04-30	82541	\N	\N	f	Qual by exam of deed	0
82541_4100.0_2005-06-01	410000	\N	2005-06-01	82541	\N	\N	f	Sales which are qualified	0
82541_4820.0_2021-08-26	482000	\N	2021-08-26	82541	\N	\N	f	Qual by exam of deed	0
82542_2375.0_2005-02-01	237500	\N	2005-02-01	82542	\N	\N	f	Sales which are qualified	0
82542_3000.0_2005-03-01	300000	\N	2005-03-01	82542	\N	\N	f	Sales which are qualified	0
82542_3550.0_2008-05-01	355000	\N	2008-05-01	82542	\N	\N	f	Sales which are qualified	0
82542_4890.0_2021-04-23	489000	\N	2021-04-23	82542	\N	\N	f	Qual by exam of deed	0
82543_2425.0_2005-02-01	242500	\N	2005-02-01	82543	\N	\N	f	Sales which are qualified	0
82543_4150.0_2005-04-01	415000	\N	2005-04-01	82543	\N	\N	f	Sales which are qualified	0
82544_2475.0_2005-01-01	247500	\N	2005-01-01	82544	\N	\N	f	Sales which are qualified	0
82544_3150.0_2011-04-20	315000	\N	2011-04-20	82544	\N	\N	f	Qual by exam of deed	0
82544_4500.0_2007-09-01	450000	\N	2007-09-01	82544	\N	\N	f	Sales which are qualified	0
82544_4600.0_2020-01-14	460000	\N	2020-01-14	82544	\N	\N	f	Qual by exam of deed	0
82545_2525.0_2005-02-01	252500	\N	2005-02-01	82545	\N	\N	f	Sales which are qualified	0
82545_4350.0_2005-04-01	435000	\N	2005-04-01	82545	\N	\N	f	Sales which are qualified	0
82546_2575.0_2005-02-01	257500	\N	2005-02-01	82546	\N	\N	f	Sales which are qualified	0
82546_3750.0_2008-03-01	375000	\N	2008-03-01	82546	\N	\N	f	Sales which are qualified	0
82547_2625.0_2005-02-01	262500	\N	2005-02-01	82547	\N	\N	f	Sales which are qualified	0
82547_5150.0_2005-12-01	515000	\N	2005-12-01	82547	\N	\N	f	Sales which are qualified	0
82547_5250.0_2016-05-19	525000	\N	2016-05-19	82547	\N	\N	f	Qual by exam of deed	0
82547_6700.0_2023-02-15	670000	\N	2023-02-15	82547	\N	\N	f	Qual by exam of deed	0
82548_2675.0_2005-02-01	267500	\N	2005-02-01	82548	\N	\N	f	Sales which are qualified	0
82548_3050.0_2011-07-25	305000	\N	2011-07-25	82548	\N	\N	f	Qual by exam of deed	0
82548_5150.0_2005-12-01	515000	\N	2005-12-01	82548	\N	\N	f	Sales which are qualified	0
82549_2725.0_2005-02-01	272500	\N	2005-02-01	82549	\N	\N	f	Sales which are qualified	0
82549_3850.0_2011-08-02	385000	\N	2011-08-02	82549	\N	\N	f	Qual by exam of deed	0
82549_5500.0_2006-07-01	550000	\N	2006-07-01	82549	\N	\N	f	Sales which are qualified	0
82550_2775.0_2005-02-01	277500	\N	2005-02-01	82550	\N	\N	f	Sales which are qualified	0
82550_5500.0_2006-04-01	550000	\N	2006-04-01	82550	\N	\N	f	Sales which are qualified	0
82550_5700.0_2015-11-16	570000	\N	2015-11-16	82550	\N	\N	f	Qual by exam of deed	0
82550_5700.0_2021-06-16	570000	\N	2021-06-16	82550	\N	\N	f	Qual by exam of deed	0
82551_3705.0_2006-02-01	370500	\N	2006-02-01	82551	\N	\N	f	Sales which are qualified	0
82552_3500.0_2010-01-29	350000	\N	2010-01-29	82552	\N	\N	f	Qual by exam of deed	0
82552_4260.0_2005-02-01	426000	\N	2005-02-01	82552	\N	\N	f	Sales which are qualified	0
82552_4400.0_2012-06-29	440000	\N	2012-06-29	82552	\N	\N	f	Qual by exam of deed	0
82552_5000.0_2018-10-22	500000	\N	2018-10-22	82552	\N	\N	f	Qual by exam of deed	0
82552_5600.0_2007-02-01	560000	\N	2007-02-01	82552	\N	\N	f	Sales which are qualified	0
82553_3519.36_2005-02-01	351936	\N	2005-02-01	82553	\N	\N	f	Sales which are qualified	0
82553_3520.0_2008-08-01	352000	\N	2008-08-01	82553	\N	\N	f	Sales which are qualified	0
82553_5500.0_2014-05-14	550000	\N	2014-05-14	82553	\N	\N	f	Qual by exam of deed	0
82554_2255.0_2005-02-01	225500	\N	2005-02-01	82554	\N	\N	f	Sales which are qualified	0
82554_4190.0_2005-07-01	419000	\N	2005-07-01	82554	\N	\N	f	Sales which are qualified	0
82554_5300.0_2007-06-01	530000	\N	2007-06-01	82554	\N	\N	f	Sales which are qualified	0
82555_2275.0_2005-02-01	227500	\N	2005-02-01	82555	\N	\N	f	Sales which are qualified	0
82555_3159.0_2011-11-14	315900	\N	2011-11-14	82555	\N	\N	f	Qual by exam of deed	0
82556_2315.0_2005-02-01	231500	\N	2005-02-01	82556	\N	\N	f	Sales which are qualified	0
82556_2800.0_2011-12-28	280000	\N	2011-12-28	82556	\N	\N	f	Qual by exam of deed	0
82556_3900.0_2005-04-01	390000	\N	2005-04-01	82556	\N	\N	f	Sales which are qualified	0
82556_4600.0_2007-02-01	460000	\N	2007-02-01	82556	\N	\N	f	Sales which are qualified	0
82556_4850.0_2005-07-01	485000	\N	2005-07-01	82556	\N	\N	f	Sales which are qualified	0
82557_2375.0_2005-02-01	237500	\N	2005-02-01	82557	\N	\N	f	Sales which are qualified	0
82557_4200.0_2005-07-01	420000	\N	2005-07-01	82557	\N	\N	f	Sales which are qualified	0
82557_4650.0_2017-06-16	465000	\N	2017-06-16	82557	\N	\N	f	Qual by exam of deed	0
82558_2425.0_2005-02-01	242500	\N	2005-02-01	82558	\N	\N	f	Sales which are qualified	0
82558_3920.0_2005-03-01	392000	\N	2005-03-01	82558	\N	\N	f	Sales which are qualified	0
82558_6450.0_2023-01-31	645000	\N	2023-01-31	82558	\N	\N	f	Qual by exam of deed	0
82559_2505.0_2005-02-01	250500	\N	2005-02-01	82559	\N	\N	f	Sales which are qualified	0
82559_4400.0_2019-11-27	440000	\N	2019-11-27	82559	\N	\N	f	Qual by exam of deed	0
82560_2555.0_2005-02-01	255500	\N	2005-02-01	82560	\N	\N	f	Sales which are qualified	0
82560_3160.0_2008-12-23	316000	\N	2008-12-23	82560	\N	\N	f	Other disqualified	0
82560_4950.0_2021-03-11	495000	\N	2021-03-11	82560	\N	\N	f	Qual by exam of deed	0
82560_5100.0_2005-12-01	510000	\N	2005-12-01	82560	\N	\N	f	Sales which are qualified	0
82561_3000.0_2012-03-09	300000	\N	2012-03-09	82561	\N	\N	f	Qual by exam of deed	0
82561_3100.0_2005-01-01	310000	\N	2005-01-01	82561	\N	\N	f	Sales which are qualified	0
82562_3300.0_2012-11-13	330000	\N	2012-11-13	82562	\N	\N	f	Qual by exam of deed	0
82562_3387.0_2005-02-01	338700	\N	2005-02-01	82562	\N	\N	f	Sales which are qualified	0
82562_5500.0_2021-04-01	550000	\N	2021-04-01	82562	\N	\N	f	Qual by exam of deed	0
82563_3900.0_2005-03-01	390000	\N	2005-03-01	82563	\N	\N	f	Sales which are qualified	0
82563_6400.0_2022-03-17	640000	\N	2022-03-17	82563	\N	\N	f	Qual by exam of deed	0
82564_4056.0_2005-02-01	405600	\N	2005-02-01	82564	\N	\N	f	Sales which are qualified	0
82564_4950.0_2005-05-01	495000	\N	2005-05-01	82564	\N	\N	f	Sales which are qualified	0
82564_5100.0_2014-01-08	510000	\N	2014-01-08	82564	\N	\N	f	Qual by exam of deed	0
82565_4100.0_2011-04-01	410000	\N	2011-04-01	82565	\N	\N	f	Qual by exam of deed	0
82565_4128.0_2005-02-01	412800	\N	2005-02-01	82565	\N	\N	f	Sales which are qualified	0
82565_5550.0_2020-11-12	555000	\N	2020-11-12	82565	\N	\N	f	Qual by exam of deed	0
82565_5600.0_2006-11-01	560000	\N	2006-11-01	82565	\N	\N	f	Sales which are qualified	0
82565_5900.0_2014-04-30	590000	\N	2014-04-30	82565	\N	\N	f	Qual by exam of deed	0
82566_5000.0_2009-07-23	500000	\N	2009-07-23	82566	\N	\N	f	Qual by exam of deed	0
82566_5146.82_2005-01-01	514682	\N	2005-01-01	82566	\N	\N	f	Sales which are qualified	0
82566_5280.0_2011-04-25	528000	\N	2011-04-25	82566	\N	\N	f	Qual by exam of deed	0
82567_3550.0_2005-02-01	355000	\N	2005-02-01	82567	\N	\N	f	Sales which are qualified	0
82567_6445.0_2021-10-05	644500	\N	2021-10-05	82567	\N	\N	f	Qual by exam of deed	0
82567_9700.0_2023-08-29	970000	\N	2023-08-29	82567	\N	\N	f	Qual by exam of deed	0
82568_4583.0_2005-02-01	458300	\N	2005-02-01	82568	\N	\N	f	Sales which are qualified	0
82568_4650.0_2012-08-24	465000	\N	2012-08-24	82568	\N	\N	f	Qual by exam of deed	0
82568_8800.0_2023-02-24	880000	\N	2023-02-24	82568	\N	\N	f	Qual by exam of deed	0
82569_3864.96_2005-02-01	386496	\N	2005-02-01	82569	\N	\N	f	Sales which are qualified	0
82570_4722.0_2005-02-01	472200	\N	2005-02-01	82570	\N	\N	f	Sales which are qualified	0
82571_4040.0_2005-02-01	404000	\N	2005-02-01	82571	\N	\N	f	Sales which are qualified	0
82571_5900.0_2007-08-01	590000	\N	2007-08-01	82571	\N	\N	f	Sales which are qualified	0
82571_7550.0_2021-08-10	755000	\N	2021-08-10	82571	\N	\N	f	Qual by exam of deed	0
82571_8950.0_2015-09-09	895000	\N	2015-09-09	82571	\N	\N	f	Qual by exam of deed	0
82572_3475.0_2005-02-01	347500	\N	2005-02-01	82572	\N	\N	f	Sales which are qualified	0
82572_3851.67_2008-12-03	385167	\N	2008-12-03	82572	\N	\N	f	Other disqualified	0
82572_7350.0_2021-04-13	735000	\N	2021-04-13	82572	\N	\N	f	Qual by exam of deed	0
82572_7400.0_2005-05-01	740000	\N	2005-05-01	82572	\N	\N	f	Sales which are qualified	0
82573_4829.89_2005-02-01	482989	\N	2005-02-01	82573	\N	\N	f	Sales which are qualified	0
82574_4947.15_2005-02-01	494715	\N	2005-02-01	82574	\N	\N	f	Sales which are qualified	0
82574_6600.0_2006-10-01	660000	\N	2006-10-01	82574	\N	\N	f	Sales which are qualified	0
82574_7850.0_2017-03-13	785000	\N	2017-03-13	82574	\N	\N	f	Qual by exam of deed	0
82575_5026.13_2005-02-01	502613	\N	2005-02-01	82575	\N	\N	f	Sales which are qualified	0
82575_6300.0_2005-04-01	630000	\N	2005-04-01	82575	\N	\N	f	Sales which are qualified	0
82575_6950.0_2006-08-01	695000	\N	2006-08-01	82575	\N	\N	f	Sales which are qualified	0
82575_7400.0_2017-10-31	740000	\N	2017-10-31	82575	\N	\N	f	Qual by exam of deed	0
82575_8800.0_2021-06-03	880000	\N	2021-06-03	82575	\N	\N	f	Qual by exam of deed	0
82576_5101.0_2005-02-01	510100	\N	2005-02-01	82576	\N	\N	f	Sales which are qualified	0
82576_5750.0_2012-03-07	575000	\N	2012-03-07	82576	\N	\N	f	Qual by exam of deed	0
82576_6250.0_2005-04-01	625000	\N	2005-04-01	82576	\N	\N	f	Sales which are qualified	0
82577_5265.3_2005-02-01	526530	\N	2005-02-01	82577	\N	\N	f	Sales which are qualified	0
82577_6100.0_2012-01-02	610000	\N	2012-01-02	82577	\N	\N	f	Qual by exam of deed	0
82577_7050.0_2005-06-01	705000	\N	2005-06-01	82577	\N	\N	f	Sales which are qualified	0
82577_8250.0_2016-10-05	825000	\N	2016-10-05	82577	\N	\N	f	Qual by exam of deed	0
82578_13950.0_2023-01-23	1395000	\N	2023-01-23	82578	\N	\N	f	Qual by exam of deed	0
82578_4250.0_2005-02-01	425000	\N	2005-02-01	82578	\N	\N	f	Sales which are qualified	0
82578_9050.0_2021-03-22	905000	\N	2021-03-22	82578	\N	\N	f	Qual by exam of deed	0
82579_4348.51_2005-01-01	434851	\N	2005-01-01	82579	\N	\N	f	Sales which are qualified	0
82579_6250.0_2005-09-01	625000	\N	2005-09-01	82579	\N	\N	f	Sales which are qualified	0
82580_4059.0_2005-02-01	405900	\N	2005-02-01	82580	\N	\N	f	Sales which are qualified	0
82580_5650.0_2005-08-01	565000	\N	2005-08-01	82580	\N	\N	f	Sales which are qualified	0
82581_4281.58_2005-02-01	428158	\N	2005-02-01	82581	\N	\N	f	Sales which are qualified	0
82582_4450.0_2008-11-05	445000	\N	2008-11-05	82582	\N	\N	f	Other disqualified	0
82582_4479.0_2005-01-01	447900	\N	2005-01-01	82582	\N	\N	f	Sales which are qualified	0
82582_4600.0_2009-06-25	460000	\N	2009-06-25	82582	\N	\N	f	Qual by exam of deed	0
82582_5450.0_2013-01-18	545000	\N	2013-01-18	82582	\N	\N	f	Qual by exam of deed	0
82582_7400.0_2005-08-01	740000	\N	2005-08-01	82582	\N	\N	f	Sales which are qualified	0
82583_4543.0_2005-01-01	454300	\N	2005-01-01	82583	\N	\N	f	Sales which are qualified	0
82583_5000.0_2007-10-01	500000	\N	2007-10-01	82583	\N	\N	f	Sales which are qualified	0
82583_7000.0_2005-07-01	700000	\N	2005-07-01	82583	\N	\N	f	Sales which are qualified	0
82584_4670.0_2005-02-01	467000	\N	2005-02-01	82584	\N	\N	f	Sales which are qualified	0
82584_5990.0_2019-04-10	599000	\N	2019-04-10	82584	\N	\N	f	Qual by exam of deed	0
82585_4673.0_2005-01-01	467300	\N	2005-01-01	82585	\N	\N	f	Sales which are qualified	0
82585_6125.0_2005-07-01	612500	\N	2005-07-01	82585	\N	\N	f	Sales which are qualified	0
82585_6250.0_2020-06-29	625000	\N	2020-06-29	82585	\N	\N	f	Qual by exam of deed	0
82586_4599.74_2005-02-01	459974	\N	2005-02-01	82586	\N	\N	f	Sales which are qualified	0
82586_5150.0_2012-09-18	515000	\N	2012-09-18	82586	\N	\N	f	Qual by exam of deed	0
82586_7050.0_2006-03-01	705000	\N	2006-03-01	82586	\N	\N	f	Sales which are qualified	0
82587_4658.91_2005-02-01	465891	\N	2005-02-01	82587	\N	\N	f	Sales which are qualified	0
82587_7200.0_2015-06-09	720000	\N	2015-06-09	82587	\N	\N	f	Qual by exam of deed	0
82588_4800.0_2005-02-01	480000	\N	2005-02-01	82588	\N	\N	f	Sales which are qualified	0
82588_5450.0_2016-11-04	545000	\N	2016-11-04	82588	\N	\N	f	Qual by exam of deed	0
82589_4800.0_2005-02-01	480000	\N	2005-02-01	82589	\N	\N	f	Sales which are qualified	0
82589_5525.0_2011-08-09	552500	\N	2011-08-09	82589	\N	\N	f	Qual by exam of deed	0
82589_6720.0_2018-09-03	672000	\N	2018-09-03	82589	\N	\N	f	Qual by exam of deed	0
82590_5100.0_2005-02-01	510000	\N	2005-02-01	82590	\N	\N	f	Sales which are qualified	0
82590_5790.0_2008-01-01	579000	\N	2008-01-01	82590	\N	\N	f	Sales which are qualified	0
82590_6850.0_2005-06-01	685000	\N	2005-06-01	82590	\N	\N	f	Sales which are qualified	0
82590_7250.0_2014-03-25	725000	\N	2014-03-25	82590	\N	\N	f	Qual by exam of deed	0
82591_5272.5_2005-02-01	527250	\N	2005-02-01	82591	\N	\N	f	Sales which are qualified	0
82591_6450.0_2012-08-21	645000	\N	2012-08-21	82591	\N	\N	f	Qual by exam of deed	0
82592_3270.0_2020-12-09	327000	\N	2020-12-09	82592	\N	\N	f	Qual by exam of deed	0
82592_3500.0_2013-02-27	350000	\N	2013-02-27	82592	\N	\N	f	Qual by exam of deed	0
82592_3615.0_2005-02-01	361500	\N	2005-02-01	82592	\N	\N	f	Sales which are qualified	0
82593_2764.5_2005-02-01	276450	\N	2005-02-01	82593	\N	\N	f	Sales which are qualified	0
82593_3800.0_2021-03-11	380000	\N	2021-03-11	82593	\N	\N	f	Qual by exam of deed	0
82594_3059.1_2005-02-01	305910	\N	2005-02-01	82594	\N	\N	f	Sales which are qualified	0
82594_3400.0_2019-12-24	340000	\N	2019-12-24	82594	\N	\N	f	Qual by exam of deed	0
82594_5750.0_2023-05-24	575000	\N	2023-05-24	82594	\N	\N	f	Qual by exam of deed	0
82595_3030.5_2005-02-01	303050	\N	2005-02-01	82595	\N	\N	f	Sales which are qualified	0
82595_3850.0_2007-07-01	385000	\N	2007-07-01	82595	\N	\N	f	Sales which are qualified	0
82596_3080.0_2005-01-01	308000	\N	2005-01-01	82596	\N	\N	f	Sales which are qualified	0
82597_3000.0_2005-02-01	300000	\N	2005-02-01	82597	\N	\N	f	Sales which are qualified	0
82597_3100.0_2008-09-15	310000	\N	2008-09-15	82597	\N	\N	f	Sales which are qualified	0
82597_4500.0_2013-12-26	450000	\N	2013-12-26	82597	\N	\N	f	Qual by exam of deed	0
82597_4850.0_2021-07-30	485000	\N	2021-07-30	82597	\N	\N	f	Qual by exam of deed	0
82598_2650.0_2011-09-22	265000	\N	2011-09-22	82598	\N	\N	f	Qual by exam of deed	0
82598_3212.0_2005-02-01	321200	\N	2005-02-01	82598	\N	\N	f	Sales which are qualified	0
82598_5250.0_2006-03-01	525000	\N	2006-03-01	82598	\N	\N	f	Sales which are qualified	0
82599_3000.0_2009-06-30	300000	\N	2009-06-30	82599	\N	\N	f	Qual by exam of deed	0
82599_3100.95_2005-01-01	310095	\N	2005-01-01	82599	\N	\N	f	Sales which are qualified	0
82600_3261.26_2005-02-01	326126	\N	2005-02-01	82600	\N	\N	f	Sales which are qualified	0
82601_3300.0_2005-02-01	330000	\N	2005-02-01	82601	\N	\N	f	Sales which are qualified	0
82601_4850.0_2005-07-01	485000	\N	2005-07-01	82601	\N	\N	f	Sales which are qualified	0
82602_3562.5_2005-02-01	356250	\N	2005-02-01	82602	\N	\N	f	Sales which are qualified	0
82602_6800.0_2022-04-21	680000	\N	2022-04-21	82602	\N	\N	f	Qual by exam of deed	0
82603_3591.95_2005-02-01	359195	\N	2005-02-01	82603	\N	\N	f	Sales which are qualified	0
81281_16500.0_2014-06-04	1650000	\N	2014-06-04	81281	\N	\N	f	Qual by exam of deed	0
81281_5100.0_2002-04-01	510000	\N	2002-04-01	81281	\N	\N	f	Sales which are qualified	0
81282_3413.0_2000-05-01	341300	\N	2000-05-01	81282	\N	\N	f	Sales which are qualified	0
81282_4750.0_2000-06-01	475000	\N	2000-06-01	81282	\N	\N	f	Sales which are qualified	0
81282_6000.0_2002-06-01	600000	\N	2002-06-01	81282	\N	\N	f	Sales which are qualified	0
81284_3690.0_2000-06-01	369000	\N	2000-06-01	81284	\N	\N	f	Sales which are qualified	0
81285_3850.0_2000-06-01	385000	\N	2000-06-01	81285	\N	\N	f	Sales which are qualified	0
81286_3750.0_2000-08-01	375000	\N	2000-08-01	81286	\N	\N	f	Sales which are qualified	0
81287_4150.0_2000-06-01	415000	\N	2000-06-01	81287	\N	\N	f	Sales which are qualified	0
81287_8166.67_2012-10-04	816667	\N	2012-10-04	81287	\N	\N	f	Qual by exam of deed	0
81288_11500.0_2004-11-01	1150000	\N	2004-11-01	81288	\N	\N	f	Sales which are qualified	0
81288_4430.0_2000-10-01	443000	\N	2000-10-01	81288	\N	\N	t	Deeds that include more than one parcel	0
81288_6650.0_2001-05-01	665000	\N	2001-05-01	81288	\N	\N	t	Deeds that include more than one parcel	0
81288_7450.0_2004-05-01	745000	\N	2004-05-01	81288	\N	\N	f	Sales which are qualified	0
81289_11750.0_2006-09-01	1175000	\N	2006-09-01	81289	\N	\N	f	Sales which are qualified	0
81289_12480.0_2005-10-01	1248000	\N	2005-10-01	81289	\N	\N	f	Sales which are qualified	0
81289_18150.0_2016-05-09	1815000	\N	2016-05-09	81289	\N	\N	f	Qual by exam of deed	0
81289_3840.0_2000-05-01	384000	\N	2000-05-01	81289	\N	\N	f	Sales which are qualified	0
81289_4800.0_2000-05-01	480000	\N	2000-05-01	81289	\N	\N	f	Sales which are qualified	0
81289_9940.0_2004-02-01	994000	\N	2004-02-01	81289	\N	\N	f	Sales which are qualified	0
81291_3840.0_2000-06-01	384000	\N	2000-06-01	81291	\N	\N	f	Sales which are qualified	0
81292_3930.0_2000-06-01	393000	\N	2000-06-01	81292	\N	\N	f	Sales which are qualified	0
81293_3960.0_2000-06-01	396000	\N	2000-06-01	81293	\N	\N	f	Sales which are qualified	0
81293_6500.0_2001-07-01	650000	\N	2001-07-01	81293	\N	\N	f	Sales which are qualified	0
81293_8800.0_2009-04-21	880000	\N	2009-04-21	81293	\N	\N	f	Qual by exam of deed	0
81294_11650.0_2011-08-22	1165000	\N	2011-08-22	81294	\N	\N	f	Qual by exam of deed	0
81294_20000.0_2020-10-30	2000000	\N	2020-10-30	81294	\N	\N	f	Qual by exam of deed	0
81294_4100.0_2000-09-01	410000	\N	2000-09-01	81294	\N	\N	f	Sales which are qualified	0
81294_6100.0_2001-06-01	610000	\N	2001-06-01	81294	\N	\N	f	Sales which are qualified	0
81295_6400.0_2001-09-01	640000	\N	2001-09-01	81295	\N	\N	f	Sales which are qualified	0
81295_7100.0_2003-09-01	710000	\N	2003-09-01	81295	\N	\N	f	Sales which are qualified	0
81296_4050.0_2000-07-01	405000	\N	2000-07-01	81296	\N	\N	f	Sales which are qualified	0
81296_5000.0_2000-07-01	500000	\N	2000-07-01	81296	\N	\N	f	Sales which are qualified	0
81296_9750.0_2008-03-01	975000	\N	2008-03-01	81296	\N	\N	f	Sales which are qualified	0
81297_18500.0_2017-01-10	1850000	\N	2017-01-10	81297	\N	\N	f	Qual by exam of deed	0
81297_20245.0_2014-11-05	2024500	\N	2014-11-05	81297	\N	\N	f	Qual by exam of deed	0
81297_6450.0_2002-06-01	645000	\N	2002-06-01	81297	\N	\N	f	Sales which are qualified	0
81298_10000.0_2005-01-01	1000000	\N	2005-01-01	81298	\N	\N	f	Sales which are qualified	0
81298_13000.0_2005-11-01	1300000	\N	2005-11-01	81298	\N	\N	f	Sales which are qualified	0
81298_18000.0_2017-11-13	1800000	\N	2017-11-13	81298	\N	\N	f	Qual by exam of deed	0
81298_23500.0_2022-05-11	2350000	\N	2022-05-11	81298	\N	\N	f	Qual by exam of deed	0
81298_5750.0_2000-07-01	575000	\N	2000-07-01	81298	\N	\N	f	Sales which are qualified	0
81298_6200.0_2003-05-01	620000	\N	2003-05-01	81298	\N	\N	f	Sales which are qualified	0
81299_12300.0_2011-12-01	1230000	\N	2011-12-01	81299	\N	\N	f	Qual by exam of deed	0
81299_6250.0_2000-06-01	625000	\N	2000-06-01	81299	\N	\N	f	Sales which are qualified	0
81300_11425.0_2007-07-01	1142500	\N	2007-07-01	81300	\N	\N	f	Sales which are qualified	0
81300_21000.0_2021-04-19	2100000	\N	2021-04-19	81300	\N	\N	f	Qual by exam of deed	0
81300_6985.0_2000-11-01	698500	\N	2000-11-01	81300	\N	\N	f	Sales which are qualified	0
81301_4450.0_2000-06-01	445000	\N	2000-06-01	81301	\N	\N	f	Sales which are qualified	0
81302_6550.0_2000-06-01	655000	\N	2000-06-01	81302	\N	\N	f	Sales which are qualified	0
81303_4510.0_2000-07-01	451000	\N	2000-07-01	81303	\N	\N	f	Sales which are qualified	0
81304_6734.0_2001-10-01	673400	\N	2001-10-01	81304	\N	\N	f	Sales which are qualified	0
81305_4700.0_2000-07-01	470000	\N	2000-07-01	81305	\N	\N	f	Sales which are qualified	0
81305_5500.0_2000-07-01	550000	\N	2000-07-01	81305	\N	\N	f	Sales which are qualified	0
81305_7500.0_2002-12-01	750000	\N	2002-12-01	81305	\N	\N	f	Sales which are qualified	0
81306_4950.0_2000-09-01	495000	\N	2000-09-01	81306	\N	\N	f	Sales which are qualified	0
81306_7250.0_2002-11-01	725000	\N	2002-11-01	81306	\N	\N	f	Sales which are qualified	0
81306_9550.0_2004-07-01	955000	\N	2004-07-01	81306	\N	\N	f	Sales which are qualified	0
81307_12500.0_2005-02-01	1250000	\N	2005-02-01	81307	\N	\N	f	Sales which are qualified	0
81307_4760.0_2000-09-01	476000	\N	2000-09-01	81307	\N	\N	f	Sales which are qualified	0
81308_13500.0_2011-10-24	1350000	\N	2011-10-24	81308	\N	\N	f	Qual by exam of deed	0
81308_23000.0_2023-02-17	2300000	\N	2023-02-17	81308	\N	\N	f	Qual by exam of deed	0
81308_43500.0_2021-03-15	4350000	\N	2021-03-15	81308	\N	\N	t	Qual on DOS, multi-parcel sale	0
81308_4790.0_2000-11-01	479000	\N	2000-11-01	81308	\N	\N	f	Sales which are qualified	0
81309_7750.0_2002-06-01	775000	\N	2002-06-01	81309	\N	\N	f	Sales which are qualified	0
81310_18500.0_2013-11-20	1850000	\N	2013-11-20	81310	\N	\N	f	Qual by exam of deed	0
81310_5220.0_2001-03-01	522000	\N	2001-03-01	81310	\N	\N	f	Sales which are qualified	0
81310_8000.0_2001-09-01	800000	\N	2001-09-01	81310	\N	\N	f	Sales which are qualified	0
81312_23800.0_2022-01-13	2380000	\N	2022-01-13	81312	\N	\N	f	Qual by exam of deed	0
81312_7550.0_2000-10-01	755000	\N	2000-10-01	81312	\N	\N	f	Sales which are qualified	0
81313_13500.0_2011-08-31	1350000	\N	2011-08-31	81313	\N	\N	f	Qual by exam of deed	0
81313_18000.0_2012-10-11	1800000	\N	2012-10-11	81313	\N	\N	f	Qual by exam of deed	0
81313_7950.0_2002-04-01	795000	\N	2002-04-01	81313	\N	\N	f	Sales which are qualified	0
81314_20675.0_2015-05-21	2067500	\N	2015-05-21	81314	\N	\N	f	Qual by exam of deed	0
81314_7350.0_2002-08-01	735000	\N	2002-08-01	81314	\N	\N	f	Sales which are qualified	0
81314_8330.0_2001-09-01	833000	\N	2001-09-01	81314	\N	\N	f	Sales which are qualified	0
81315_15250.0_2005-03-01	1525000	\N	2005-03-01	81315	\N	\N	t	Deeds that include more than one parcel	0
81315_7830.0_2002-05-01	783000	\N	2002-05-01	81315	\N	\N	f	Sales which are qualified	0
81316_13250.0_2005-03-01	1325000	\N	2005-03-01	81316	\N	\N	f	Sales which are qualified	0
81316_7000.0_2003-06-01	700000	\N	2003-06-01	81316	\N	\N	f	Sales which are qualified	0
81316_8789.0_2001-03-01	878900	\N	2001-03-01	81316	\N	\N	f	Sales which are qualified	0
81317_19890.0_2020-08-31	1989000	\N	2020-08-31	81317	\N	\N	f	Qual by exam of deed	0
81317_8100.0_2002-05-01	810000	\N	2002-05-01	81317	\N	\N	f	Sales which are qualified	0
81318_12500.0_2004-07-01	1250000	\N	2004-07-01	81318	\N	\N	f	Sales which are qualified	0
81318_14500.0_2010-05-17	1450000	\N	2010-05-17	81318	\N	\N	t	Qual on DOS, multi-parcel sale	0
81318_16350.0_2005-11-01	1635000	\N	2005-11-01	81318	\N	\N	f	Sales which are qualified	0
81318_25750.0_2014-06-10	2575000	\N	2014-06-10	81318	\N	\N	f	Qual by exam of deed	0
81318_27000.0_2018-02-28	2700000	\N	2018-02-28	81318	\N	\N	f	Qual by exam of deed	0
81318_6200.0_2000-11-01	620000	\N	2000-11-01	81318	\N	\N	t	Deeds that include more than one parcel	0
81318_8775.0_2000-11-01	877500	\N	2000-11-01	81318	\N	\N	t	Deeds that include more than one parcel	0
81319_16000.0_2005-01-01	1600000	\N	2005-01-01	81319	\N	\N	f	Sales which are qualified	0
81319_35000.0_2024-04-02	3500000	\N	2024-04-02	81319	\N	\N	f	Qual by exam of deed	0
81319_7400.0_2002-03-01	740000	\N	2002-03-01	81319	\N	\N	f	Sales which are qualified	0
81319_9460.0_2003-11-01	946000	\N	2003-11-01	81319	\N	\N	f	Sales which are qualified	0
81320_10640.0_2002-02-01	1064000	\N	2002-02-01	81320	\N	\N	f	Sales which are qualified	0
81321_3500.0_2000-04-01	350000	\N	2000-04-01	81321	\N	\N	f	Sales which are qualified	0
81321_7430.0_2010-03-08	743000	\N	2010-03-08	81321	\N	\N	f	Qual by exam of deed	0
81322_12550.0_2015-09-30	1255000	\N	2015-09-30	81322	\N	\N	f	Qual by exam of deed	0
81322_13120.0_2021-01-14	1312000	\N	2021-01-14	81322	\N	\N	f	Qual by exam of deed	0
81322_4640.0_2002-07-01	464000	\N	2002-07-01	81322	\N	\N	f	Sales which are qualified	0
81322_7630.0_2002-02-01	763000	\N	2002-02-01	81322	\N	\N	t	Deeds that include more than one parcel	0
81323_3025.0_2000-07-01	302500	\N	2000-07-01	81323	\N	\N	f	Sales which are qualified	0
81323_3100.0_2001-03-01	310000	\N	2001-03-01	81323	\N	\N	f	Sales which are qualified	0
81323_8300.0_2010-09-02	830000	\N	2010-09-02	81323	\N	\N	f	Qual by exam of deed	0
81324_2660.0_2000-06-01	266000	\N	2000-06-01	81324	\N	\N	f	Sales which are qualified	0
81325_16800.0_2022-02-22	1680000	\N	2022-02-22	81325	\N	\N	f	Qual by exam of deed	0
81325_2700.0_2000-06-01	270000	\N	2000-06-01	81325	\N	\N	f	Sales which are qualified	0
81325_3900.0_2000-07-01	390000	\N	2000-07-01	81325	\N	\N	f	Sales which are qualified	0
81325_4750.0_2000-12-01	475000	\N	2000-12-01	81325	\N	\N	f	Sales which are qualified	0
81326_15000.0_2021-10-15	1500000	\N	2021-10-15	81326	\N	\N	f	Qual by exam of deed	0
81326_2720.0_2000-10-01	272000	\N	2000-10-01	81326	\N	\N	f	Sales which are qualified	0
81327_4020.0_2000-06-01	402000	\N	2000-06-01	81327	\N	\N	f	Sales which are qualified	0
81328_3850.0_2000-11-01	385000	\N	2000-11-01	81328	\N	\N	f	Sales which are qualified	0
81328_8910.0_2008-05-01	891000	\N	2008-05-01	81328	\N	\N	f	Sales which are qualified	0
81329_3600.0_2000-06-01	360000	\N	2000-06-01	81329	\N	\N	f	Sales which are qualified	0
81329_4100.0_2000-05-01	410000	\N	2000-05-01	81329	\N	\N	f	Sales which are qualified	0
81329_6500.0_2002-07-01	650000	\N	2002-07-01	81329	\N	\N	f	Sales which are qualified	0
81329_7660.0_2009-01-16	766000	\N	2009-01-16	81329	\N	\N	f	Qual by exam of deed	0
81330_2800.0_2000-08-01	280000	\N	2000-08-01	81330	\N	\N	f	Sales which are qualified	0
81333_16480.0_2004-04-01	1648000	\N	2004-04-01	81333	\N	\N	t	Deeds that include more than one parcel	0
81333_21500.0_2023-05-04	2150000	\N	2023-05-04	81333	\N	\N	f	Qual by exam of deed	0
81333_3300.0_2000-06-01	330000	\N	2000-06-01	81333	\N	\N	f	Sales which are qualified	0
81333_4250.0_2000-06-01	425000	\N	2000-06-01	81333	\N	\N	f	Sales which are qualified	0
81333_8000.0_2010-01-19	800000	\N	2010-01-19	81333	\N	\N	f	Qual by exam of deed	0
81333_8900.0_2011-10-03	890000	\N	2011-10-03	81333	\N	\N	f	Qual by exam of deed	0
81334_16780.0_2022-01-20	1678000	\N	2022-01-20	81334	\N	\N	f	Qual by exam of deed	0
81334_3600.0_2000-06-01	360000	\N	2000-06-01	81334	\N	\N	f	Sales which are qualified	0
81334_4250.0_2000-06-01	425000	\N	2000-06-01	81334	\N	\N	f	Sales which are qualified	0
81334_8000.0_2004-10-01	800000	\N	2004-10-01	81334	\N	\N	f	Sales which are qualified	0
81335_13000.0_2019-04-08	1300000	\N	2019-04-08	81335	\N	\N	f	Qual by exam of deed	0
81335_3350.0_2000-06-01	335000	\N	2000-06-01	81335	\N	\N	f	Sales which are qualified	0
81336_4224.0_2000-06-01	422400	\N	2000-06-01	81336	\N	\N	f	Sales which are qualified	0
81336_4650.0_2000-11-01	465000	\N	2000-11-01	81336	\N	\N	f	Sales which are qualified	0
81336_7650.0_2004-05-01	765000	\N	2004-05-01	81336	\N	\N	f	Sales which are qualified	0
81337_4680.0_2000-07-01	468000	\N	2000-07-01	81337	\N	\N	f	Sales which are qualified	0
81338_5400.0_2002-04-01	540000	\N	2002-04-01	81338	\N	\N	f	Sales which are qualified	0
81339_15800.0_2014-03-26	1580000	\N	2014-03-26	81339	\N	\N	f	Qual by exam of deed	0
81339_3770.0_2000-06-01	377000	\N	2000-06-01	81339	\N	\N	f	Sales which are qualified	0
81339_84.0_2023-08-02	8400	\N	2023-08-02	81339	\N	\N	f	Qual by exam of deed	0
81340_10550.0_2008-03-01	1055000	\N	2008-03-01	81340	\N	\N	f	Sales which are qualified	0
81340_6109.0_2001-02-01	610900	\N	2001-02-01	81340	\N	\N	f	Sales which are qualified	0
81340_7540.0_2004-05-01	754000	\N	2004-05-01	81340	\N	\N	f	Sales which are qualified	0
81341_12700.0_2020-10-14	1270000	\N	2020-10-14	81341	\N	\N	f	Qual by exam of deed	0
81341_3890.0_2000-07-01	389000	\N	2000-07-01	81341	\N	\N	f	Sales which are qualified	0
81342_5366.0_2001-10-01	536600	\N	2001-10-01	81342	\N	\N	f	Sales which are qualified	0
81343_5800.0_2003-03-01	580000	\N	2003-03-01	81343	\N	\N	f	Sales which are qualified	0
81344_4050.0_2000-08-01	405000	\N	2000-08-01	81344	\N	\N	f	Sales which are qualified	0
81344_8675.0_2009-05-06	867500	\N	2009-05-06	81344	\N	\N	f	Qual by exam of deed	0
81345_12000.0_2013-04-18	1200000	\N	2013-04-18	81345	\N	\N	f	Qual by exam of deed	0
81345_23000.0_2023-02-17	2300000	\N	2023-02-17	81345	\N	\N	f	Qual by exam of deed	0
81345_43500.0_2021-03-15	4350000	\N	2021-03-15	81345	\N	\N	t	Qual on DOS, multi-parcel sale	0
81345_5900.0_2002-12-01	590000	\N	2002-12-01	81345	\N	\N	f	Sales which are qualified	0
81346_5950.0_2002-12-01	595000	\N	2002-12-01	81346	\N	\N	f	Sales which are qualified	0
81347_11500.0_2012-06-27	1150000	\N	2012-06-27	81347	\N	\N	f	Qual by exam of deed	0
81347_5900.0_2003-06-01	590000	\N	2003-06-01	81347	\N	\N	f	Sales which are qualified	0
81347_8700.0_2005-03-01	870000	\N	2005-03-01	81347	\N	\N	f	Sales which are qualified	0
81348_18250.0_2016-06-08	1825000	\N	2016-06-08	81348	\N	\N	f	Qual by exam of deed	0
81348_5750.0_2003-06-01	575000	\N	2003-06-01	81348	\N	\N	f	Sales which are qualified	0
81348_6727.0_2001-02-01	672700	\N	2001-02-01	81348	\N	\N	f	Sales which are qualified	0
81348_8200.0_2008-01-01	820000	\N	2008-01-01	81348	\N	\N	f	Sales which are qualified	0
81348_8390.0_2005-01-01	839000	\N	2005-01-01	81348	\N	\N	f	Sales which are qualified	0
81349_6150.0_2003-12-01	615000	\N	2003-12-01	81349	\N	\N	f	Sales which are qualified	0
81350_13350.0_2021-01-22	1335000	\N	2021-01-22	81350	\N	\N	f	Qual by exam of deed	0
81350_6664.0_2001-09-01	666400	\N	2001-09-01	81350	\N	\N	f	Sales which are qualified	0
81350_8986.0_2007-05-01	898600	\N	2007-05-01	81350	\N	\N	f	Sales which are qualified	0
81351_6150.0_2003-04-01	615000	\N	2003-04-01	81351	\N	\N	f	Sales which are qualified	0
81352_11150.0_2012-01-14	1115000	\N	2012-01-14	81352	\N	\N	f	Qual by exam of deed	0
81352_18100.0_2022-08-10	1810000	\N	2022-08-10	81352	\N	\N	f	Qual by exam of deed	0
81352_6250.0_2003-08-01	625000	\N	2003-08-01	81352	\N	\N	f	Sales which are qualified	0
81352_8950.0_2007-10-01	895000	\N	2007-10-01	81352	\N	\N	f	Sales which are qualified	0
81353_4680.0_2000-10-01	468000	\N	2000-10-01	81353	\N	\N	f	Sales which are qualified	0
81354_16650.0_2014-02-17	1665000	\N	2014-02-17	81354	\N	\N	f	Qual by exam of deed	0
81354_8770.0_2004-06-01	877000	\N	2004-06-01	81354	\N	\N	f	Sales which are qualified	0
81354_9900.0_2007-12-01	990000	\N	2007-12-01	81354	\N	\N	f	Sales which are qualified	0
81355_10640.0_2002-02-01	1064000	\N	2002-02-01	81355	\N	\N	f	Sales which are qualified	0
81356_12000.0_2007-03-01	1200000	\N	2007-03-01	81356	\N	\N	f	Sales which are qualified	0
81356_3700.0_2000-07-01	370000	\N	2000-07-01	81356	\N	\N	f	Sales which are qualified	0
81356_4050.0_2000-07-01	405000	\N	2000-07-01	81356	\N	\N	f	Sales which are qualified	0
81356_4850.0_2000-09-01	485000	\N	2000-09-01	81356	\N	\N	f	Sales which are qualified	0
81356_6200.0_2002-12-01	620000	\N	2002-12-01	81356	\N	\N	f	Sales which are qualified	0
81356_7600.0_2004-08-01	760000	\N	2004-08-01	81356	\N	\N	f	Sales which are qualified	0
81357_7630.0_2002-02-01	763000	\N	2002-02-01	81357	\N	\N	t	Deeds that include more than one parcel	0
81358_3730.0_2000-05-01	373000	\N	2000-05-01	81358	\N	\N	f	Sales which are qualified	0
81359_3850.0_2000-05-01	385000	\N	2000-05-01	81359	\N	\N	f	Sales which are qualified	0
81360_10000.0_2008-01-01	1000000	\N	2008-01-01	81360	\N	\N	f	Sales which are qualified	0
81360_41250.0_2019-12-17	4125000	\N	2019-12-17	81360	\N	\N	f	Qual by exam of deed	0
81360_4999.0_2000-06-01	499900	\N	2000-06-01	81360	\N	\N	f	Sales which are qualified	0
81360_65000.0_2022-04-04	6500000	\N	2022-04-04	81360	\N	\N	f	Qual by exam of deed	0
81361_20500.0_2016-04-28	2050000	\N	2016-04-28	81361	\N	\N	f	Qual by exam of deed	0
81361_22000.0_2020-06-25	2200000	\N	2020-06-25	81361	\N	\N	f	Qual by exam of deed	0
81361_4640.0_2000-10-01	464000	\N	2000-10-01	81361	\N	\N	t	Deeds that include more than one parcel	0
81361_6400.0_2001-05-01	640000	\N	2001-05-01	81361	\N	\N	f	Sales which are qualified	0
81361_7250.0_2003-02-28	725000	\N	2003-02-28	81361	\N	\N	f	Sales which are qualified	0
81362_12465.0_2005-07-01	1246500	\N	2005-07-01	81362	\N	\N	f	Sales which are qualified	0
81362_4660.0_2000-10-01	466000	\N	2000-10-01	81362	\N	\N	t	Deeds that include more than one parcel	0
81365_11000.0_2010-09-21	1100000	\N	2010-09-21	81365	\N	\N	f	Qual by exam of deed	0
81365_4070.0_2000-05-01	407000	\N	2000-05-01	81365	\N	\N	f	Sales which are qualified	0
81366_10950.0_2011-11-02	1095000	\N	2011-11-02	81366	\N	\N	f	Qual by exam of deed	0
81366_12000.0_2008-05-01	1200000	\N	2008-05-01	81366	\N	\N	f	Sales which are qualified	0
81366_5100.0_2000-06-01	510000	\N	2000-06-01	81366	\N	\N	f	Sales which are qualified	0
81367_13500.0_2012-04-30	1350000	\N	2012-04-30	81367	\N	\N	f	Qual by exam of deed	0
81367_14400.0_2005-04-01	1440000	\N	2005-04-01	81367	\N	\N	f	Sales which are qualified	0
81367_4120.0_2000-08-01	412000	\N	2000-08-01	81367	\N	\N	f	Sales which are qualified	0
81368_20000.0_2014-08-14	2000000	\N	2014-08-14	81368	\N	\N	f	Qual by exam of deed	0
81368_4160.0_2000-06-01	416000	\N	2000-06-01	81368	\N	\N	f	Sales which are qualified	0
81369_11000.0_2010-04-14	1100000	\N	2010-04-14	81369	\N	\N	f	Qual by exam of deed	0
81369_16480.0_2004-04-01	1648000	\N	2004-04-01	81369	\N	\N	t	Deeds that include more than one parcel	0
81369_28750.0_2022-04-26	2875000	\N	2022-04-26	81369	\N	\N	f	Qual by exam of deed	0
81369_5250.0_2000-06-01	525000	\N	2000-06-01	81369	\N	\N	f	Sales which are qualified	0
81370_4220.0_2000-08-01	422000	\N	2000-08-01	81370	\N	\N	f	Sales which are qualified	0
81370_7000.0_2001-04-01	700000	\N	2001-04-01	81370	\N	\N	f	Sales which are qualified	0
81371_20800.0_2017-10-18	2080000	\N	2017-10-18	81371	\N	\N	f	Qual by exam of deed	0
81371_4250.0_2000-06-01	425000	\N	2000-06-01	81371	\N	\N	f	Sales which are qualified	0
81372_4410.0_2000-06-01	441000	\N	2000-06-01	81372	\N	\N	f	Sales which are qualified	0
81374_4540.0_2000-06-01	454000	\N	2000-06-01	81374	\N	\N	f	Sales which are qualified	0
81374_6800.0_2000-10-01	680000	\N	2000-10-01	81374	\N	\N	f	Sales which are qualified	0
81375_11700.0_2005-02-01	1170000	\N	2005-02-01	81375	\N	\N	f	Sales which are qualified	0
81375_14800.0_2011-12-20	1480000	\N	2011-12-20	81375	\N	\N	f	Qual by exam of deed	0
81375_4570.0_2000-06-01	457000	\N	2000-06-01	81375	\N	\N	f	Sales which are qualified	0
81376_4600.0_2000-06-01	460000	\N	2000-06-01	81376	\N	\N	f	Sales which are qualified	0
81377_13200.0_2005-06-01	1320000	\N	2005-06-01	81377	\N	\N	f	Sales which are qualified	0
81377_4630.0_2000-08-01	463000	\N	2000-08-01	81377	\N	\N	f	Sales which are qualified	0
81377_6490.0_2000-11-01	649000	\N	2000-11-01	81377	\N	\N	f	Sales which are qualified	0
81377_7350.0_2002-04-01	735000	\N	2002-04-01	81377	\N	\N	f	Sales which are qualified	0
81377_9200.0_2003-11-01	920000	\N	2003-11-01	81377	\N	\N	f	Sales which are qualified	0
81378_13600.0_2006-02-01	1360000	\N	2006-02-01	81378	\N	\N	f	Sales which are qualified	0
81378_4660.0_2000-07-01	466000	\N	2000-07-01	81378	\N	\N	f	Sales which are qualified	0
81379_4580.0_2000-07-01	458000	\N	2000-07-01	81379	\N	\N	f	Sales which are qualified	0
81380_13000.0_2011-10-14	1300000	\N	2011-10-14	81380	\N	\N	f	Qual by exam of deed	0
81380_5700.0_2000-08-01	570000	\N	2000-08-01	81380	\N	\N	t	Deeds that include more than one parcel	0
81380_6500.0_2000-07-01	650000	\N	2000-07-01	81380	\N	\N	t	Deeds that include more than one parcel	0
81381_13750.0_2013-04-12	1375000	\N	2013-04-12	81381	\N	\N	f	Qual by exam of deed	0
81381_4950.0_2000-09-01	495000	\N	2000-09-01	81381	\N	\N	f	Sales which are qualified	0
81381_7250.0_2002-11-01	725000	\N	2002-11-01	81381	\N	\N	f	Sales which are qualified	0
81382_4670.0_2000-09-01	467000	\N	2000-09-01	81382	\N	\N	f	Sales which are qualified	0
81383_28600.0_2024-05-17	2860000	\N	2024-05-17	81383	\N	\N	f	Qual by exam of deed	0
81383_4700.0_2000-08-01	470000	\N	2000-08-01	81383	\N	\N	f	Sales which are qualified	0
81383_5600.0_2000-09-01	560000	\N	2000-09-01	81383	\N	\N	f	Sales which are qualified	0
81384_4730.0_2000-08-01	473000	\N	2000-08-01	81384	\N	\N	f	Sales which are qualified	0
81385_37900.0_2015-02-02	3790000	\N	2015-02-02	81385	\N	\N	t	Qual on DOS, multi-parcel sale	0
81385_5236.0_2000-09-01	523600	\N	2000-09-01	81385	\N	\N	f	Sales which are qualified	0
81386_6100.0_2000-09-01	610000	\N	2000-09-01	81386	\N	\N	f	Sales which are qualified	0
81386_8000.0_2011-04-01	800000	\N	2011-04-01	81386	\N	\N	f	Qual by exam of deed	0
81387_12500.0_2005-03-01	1250000	\N	2005-03-01	81387	\N	\N	f	Sales which are qualified	0
81387_14800.0_2012-07-27	1480000	\N	2012-07-27	81387	\N	\N	f	Qual by exam of deed	0
81387_19000.0_2019-12-23	1900000	\N	2019-12-23	81387	\N	\N	f	Qual by exam of deed	0
81387_8000.0_2003-12-01	800000	\N	2003-12-01	81387	\N	\N	f	Sales which are qualified	0
81387_8569.0_2000-11-01	856900	\N	2000-11-01	81387	\N	\N	f	Sales which are qualified	0
81388_20250.0_2018-04-30	2025000	\N	2018-04-30	81388	\N	\N	f	Qual by exam of deed	0
81388_23000.0_2021-06-01	2300000	\N	2021-06-01	81388	\N	\N	f	Qual by exam of deed	0
81388_8350.0_2003-04-01	835000	\N	2003-04-01	81388	\N	\N	f	Sales which are qualified	0
81389_13750.0_2005-08-01	1375000	\N	2005-08-01	81389	\N	\N	f	Sales which are qualified	0
81389_28550.0_2024-05-21	2855000	\N	2024-05-21	81389	\N	\N	f	Qual by exam of deed	0
81389_8400.0_2003-03-01	840000	\N	2003-03-01	81389	\N	\N	f	Sales which are qualified	0
81390_8450.0_2003-08-01	845000	\N	2003-08-01	81390	\N	\N	f	Sales which are qualified	0
81391_25000.0_2020-12-30	2500000	\N	2020-12-30	81391	\N	\N	f	Qual by exam of deed	0
81391_5720.0_2000-11-01	572000	\N	2000-11-01	81391	\N	\N	f	Sales which are qualified	0
81392_14250.0_2007-07-01	1425000	\N	2007-07-01	81392	\N	\N	f	Sales which are qualified	0
81392_21500.0_2021-06-25	2150000	\N	2021-06-25	81392	\N	\N	f	Qual by exam of deed	0
81392_5450.0_2000-11-01	545000	\N	2000-11-01	81392	\N	\N	f	Sales which are qualified	0
81393_13000.0_2008-01-01	1300000	\N	2008-01-01	81393	\N	\N	f	Sales which are qualified	0
81393_16500.0_2012-07-05	1650000	\N	2012-07-05	81393	\N	\N	f	Qual by exam of deed	0
81393_6650.0_2000-11-01	665000	\N	2000-11-01	81393	\N	\N	f	Sales which are qualified	0
81393_7900.0_2001-09-01	790000	\N	2001-09-01	81393	\N	\N	f	Sales which are qualified	0
81394_13000.0_2010-10-12	1300000	\N	2010-10-12	81394	\N	\N	f	Qual by exam of deed	0
81394_5650.0_2002-04-01	565000	\N	2002-04-01	81394	\N	\N	f	Sales which are qualified	0
81394_8500.0_2002-04-01	850000	\N	2002-04-01	81394	\N	\N	f	Sales which are qualified	0
81395_22480.0_2011-10-26	2248000	\N	2011-10-26	81395	\N	\N	f	Qual by exam of deed	0
81395_26400.0_2004-02-01	2640000	\N	2004-02-01	81395	\N	\N	f	Sales which are qualified	0
81395_26750.0_2006-02-01	2675000	\N	2006-02-01	81395	\N	\N	f	Sales which are qualified	0
81395_30700.0_2007-04-01	3070000	\N	2007-04-01	81395	\N	\N	f	Sales which are qualified	0
81396_2670.0_2000-05-01	267000	\N	2000-05-01	81396	\N	\N	f	Sales which are qualified	0
81396_3250.0_2001-04-01	325000	\N	2001-04-01	81396	\N	\N	f	Sales which are qualified	0
81396_7550.0_2014-01-09	755000	\N	2014-01-09	81396	\N	\N	f	Qual by exam of deed	0
81397_3460.0_2001-01-01	346000	\N	2001-01-01	81397	\N	\N	f	Sales which are qualified	0
81397_4100.0_2002-08-01	410000	\N	2002-08-01	81397	\N	\N	f	Sales which are qualified	0
81397_6800.0_2020-07-01	680000	\N	2020-07-01	81397	\N	\N	f	Qual by exam of deed	0
81397_7030.0_2005-05-01	703000	\N	2005-05-01	81397	\N	\N	f	Sales which are qualified	0
81397_7350.0_2012-12-11	735000	\N	2012-12-11	81397	\N	\N	f	Qual by exam of deed	0
81398_2470.0_2000-05-01	247000	\N	2000-05-01	81398	\N	\N	f	Sales which are qualified	0
81399_2490.0_2000-06-01	249000	\N	2000-06-01	81399	\N	\N	f	Sales which are qualified	0
81400_2510.0_2000-06-01	251000	\N	2000-06-01	81400	\N	\N	f	Sales which are qualified	0
81401_3200.0_2000-05-01	320000	\N	2000-05-01	81401	\N	\N	f	Sales which are qualified	0
81401_8450.0_2006-01-01	845000	\N	2006-01-01	81401	\N	\N	f	Sales which are qualified	0
81402_2550.0_2000-06-01	255000	\N	2000-06-01	81402	\N	\N	f	Sales which are qualified	0
81403_2827.0_2000-08-01	282700	\N	2000-08-01	81403	\N	\N	f	Sales which are qualified	0
81403_3100.0_2000-08-01	310000	\N	2000-08-01	81403	\N	\N	f	Sales which are qualified	0
81404_2590.0_2000-06-01	259000	\N	2000-06-01	81404	\N	\N	f	Sales which are qualified	0
81405_2570.0_2000-05-01	257000	\N	2000-05-01	81405	\N	\N	f	Sales which are qualified	0
81405_8090.0_2008-04-01	809000	\N	2008-04-01	81405	\N	\N	f	Sales which are qualified	0
81406_3450.0_2000-06-01	345000	\N	2000-06-01	81406	\N	\N	f	Sales which are qualified	0
81406_7400.0_2005-04-01	740000	\N	2005-04-01	81406	\N	\N	f	Sales which are qualified	0
81407_2650.0_2000-05-01	265000	\N	2000-05-01	81407	\N	\N	f	Sales which are qualified	0
81407_7100.0_2011-05-13	710000	\N	2011-05-13	81407	\N	\N	f	Qual by exam of deed	0
81407_8350.0_2013-11-08	835000	\N	2013-11-08	81407	\N	\N	f	Qual by exam of deed	0
81408_3069.0_2000-05-01	306900	\N	2000-05-01	81408	\N	\N	f	Sales which are qualified	0
81409_10400.0_2021-06-01	1040000	\N	2021-06-01	81409	\N	\N	f	Qual by exam of deed	0
81409_2690.0_2000-06-01	269000	\N	2000-06-01	81409	\N	\N	f	Sales which are qualified	0
81410_2710.0_2000-06-01	271000	\N	2000-06-01	81410	\N	\N	f	Sales which are qualified	0
81411_12500.0_2015-10-08	1250000	\N	2015-10-08	81411	\N	\N	f	Qual by exam of deed	0
81411_12500.0_2021-06-23	1250000	\N	2021-06-23	81411	\N	\N	f	Qual by exam of deed	0
81411_3030.0_2000-12-01	303000	\N	2000-12-01	81411	\N	\N	f	Sales which are qualified	0
81411_4100.0_2000-12-01	410000	\N	2000-12-01	81411	\N	\N	f	Sales which are qualified	0
81413_13920.0_2021-11-22	1392000	\N	2021-11-22	81413	\N	\N	f	Qual by exam of deed	0
81413_2890.0_2001-02-01	289000	\N	2001-02-01	81413	\N	\N	f	Sales which are qualified	0
81413_8000.0_2005-09-01	800000	\N	2005-09-01	81413	\N	\N	f	Sales which are qualified	0
81414_2920.0_2000-07-01	292000	\N	2000-07-01	81414	\N	\N	f	Sales which are qualified	0
81414_3650.0_2000-07-01	365000	\N	2000-07-01	81414	\N	\N	f	Sales which are qualified	0
81414_5100.0_2003-09-01	510000	\N	2003-09-01	81414	\N	\N	f	Sales which are qualified	0
81416_3950.0_2000-06-01	395000	\N	2000-06-01	81416	\N	\N	f	Sales which are qualified	0
81416_4697.0_2001-10-01	469700	\N	2001-10-01	81416	\N	\N	f	Sales which are qualified	0
81416_8750.0_2007-02-01	875000	\N	2007-02-01	81416	\N	\N	f	Sales which are qualified	0
81417_3410.0_2000-08-01	341000	\N	2000-08-01	81417	\N	\N	f	Sales which are qualified	0
81417_5000.0_2003-08-01	500000	\N	2003-08-01	81417	\N	\N	f	Sales which are qualified	0
81417_8500.0_2007-04-01	850000	\N	2007-04-01	81417	\N	\N	f	Sales which are qualified	0
81418_3100.0_2000-06-01	310000	\N	2000-06-01	81418	\N	\N	f	Sales which are qualified	0
81418_3650.0_2000-06-01	365000	\N	2000-06-01	81418	\N	\N	f	Sales which are qualified	0
81418_5250.0_2003-09-01	525000	\N	2003-09-01	81418	\N	\N	f	Sales which are qualified	0
81419_10375.0_2020-12-22	1037500	\N	2020-12-22	81419	\N	\N	f	Qual by exam of deed	0
81419_3020.0_2000-06-01	302000	\N	2000-06-01	81419	\N	\N	f	Sales which are qualified	0
81420_3160.0_2000-07-01	316000	\N	2000-07-01	81420	\N	\N	f	Sales which are qualified	0
81421_5490.0_2000-08-01	549000	\N	2000-08-01	81421	\N	\N	f	Sales which are qualified	0
81422_3200.0_2000-10-01	320000	\N	2000-10-01	81422	\N	\N	f	Sales which are qualified	0
81423_11000.0_2013-12-13	1100000	\N	2013-12-13	81423	\N	\N	f	Qual by exam of deed	0
81423_11500.0_2020-09-16	1150000	\N	2020-09-16	81423	\N	\N	f	Qual by exam of deed	0
81423_12700.0_2014-07-22	1270000	\N	2014-07-22	81423	\N	\N	f	Qual by exam of deed	0
81423_13180.0_2018-01-12	1318000	\N	2018-01-12	81423	\N	\N	f	Qual by exam of deed	0
81423_2700.0_2002-03-01	270000	\N	2002-03-01	81423	\N	\N	f	Sales which are qualified	0
81423_3220.0_2000-09-01	322000	\N	2000-09-01	81423	\N	\N	f	Sales which are qualified	0
81423_3700.0_2000-09-01	370000	\N	2000-09-01	81423	\N	\N	f	Sales which are qualified	0
81423_4820.0_2003-07-01	482000	\N	2003-07-01	81423	\N	\N	f	Sales which are qualified	0
81424_13500.0_2021-12-27	1350000	\N	2021-12-27	81424	\N	\N	f	Qual by exam of deed	0
81424_3280.0_2000-09-01	328000	\N	2000-09-01	81424	\N	\N	f	Sales which are qualified	0
81424_3900.0_2000-09-01	390000	\N	2000-09-01	81424	\N	\N	f	Sales which are qualified	0
81424_5600.0_2004-03-01	560000	\N	2004-03-01	81424	\N	\N	f	Sales which are qualified	0
81425_3300.0_2000-09-01	330000	\N	2000-09-01	81425	\N	\N	f	Sales which are qualified	0
81425_7250.0_2011-05-02	725000	\N	2011-05-02	81425	\N	\N	f	Qual by exam of deed	0
81425_8250.0_2005-03-01	825000	\N	2005-03-01	81425	\N	\N	f	Sales which are qualified	0
81426_3320.0_2000-10-01	332000	\N	2000-10-01	81426	\N	\N	f	Sales which are qualified	0
81426_4900.0_2004-04-01	490000	\N	2004-04-01	81426	\N	\N	f	Sales which are qualified	0
81426_5150.0_2005-04-01	515000	\N	2005-04-01	81426	\N	\N	f	Sales which are qualified	0
81426_9335.0_2005-10-01	933500	\N	2005-10-01	81426	\N	\N	f	Sales which are qualified	0
81427_11950.0_2017-08-19	1195000	\N	2017-08-19	81427	\N	\N	f	Qual by exam of deed	0
81427_8600.0_2005-03-01	860000	\N	2005-03-01	81427	\N	\N	f	Sales which are qualified	0
81428_10050.0_2020-10-14	1005000	\N	2020-10-14	81428	\N	\N	f	Qual by exam of deed	0
81428_8800.0_2007-04-01	880000	\N	2007-04-01	81428	\N	\N	f	Sales which are qualified	0
81428_9500.0_2013-08-06	950000	\N	2013-08-06	81428	\N	\N	f	Qual by exam of deed	0
81428_9900.99_2005-05-01	990099	\N	2005-05-01	81428	\N	\N	f	Sales which are qualified	0
81429_11400.0_2014-07-31	1140000	\N	2014-07-31	81429	\N	\N	f	Qual by exam of deed	0
81429_13050.0_2018-12-20	1305000	\N	2018-12-20	81429	\N	\N	f	Qual by exam of deed	0
81429_6938.0_2004-03-01	693800	\N	2004-03-01	81429	\N	\N	f	Sales which are qualified	0
81430_10701.75_2005-08-01	1070175	\N	2005-08-01	81430	\N	\N	f	Sales which are qualified	0
81431_9650.0_2007-04-01	965000	\N	2007-04-01	81431	\N	\N	f	Sales which are qualified	0
81432_9650.0_2007-02-01	965000	\N	2007-02-01	81432	\N	\N	f	Sales which are qualified	0
81433_14100.0_2008-09-06	1410000	\N	2008-09-06	81433	\N	\N	f	Sales which are qualified	0
81433_16650.0_2006-06-01	1665000	\N	2006-06-01	81433	\N	\N	f	Sales which are qualified	0
81433_21000.0_2013-07-10	2100000	\N	2013-07-10	81433	\N	\N	f	Qual by exam of deed	0
81434_10000.0_2023-04-11	1000000	\N	2023-04-11	81434	\N	\N	f	Qual by exam of deed	0
81434_5000.0_2008-08-29	500000	\N	2008-08-29	81434	\N	\N	f	Sales which are qualified	0
81434_7600.0_2020-08-07	760000	\N	2020-08-07	81434	\N	\N	f	Qual by exam of deed	0
81435_2790.0_2000-09-01	279000	\N	2000-09-01	81435	\N	\N	f	Sales which are qualified	0
81435_8600.0_2021-08-31	860000	\N	2021-08-31	81435	\N	\N	f	Qual by exam of deed	0
81436_2750.0_2000-05-01	275000	\N	2000-05-01	81436	\N	\N	f	Sales which are qualified	0
81436_6100.0_2011-09-20	610000	\N	2011-09-20	81436	\N	\N	f	Qual by exam of deed	0
81437_2430.0_2000-07-01	243000	\N	2000-07-01	81437	\N	\N	f	Sales which are qualified	0
81437_6200.0_2009-11-30	620000	\N	2009-11-30	81437	\N	\N	f	Qual by exam of deed	0
81438_2320.0_2000-07-01	232000	\N	2000-07-01	81438	\N	\N	f	Sales which are qualified	0
81438_3150.0_2000-07-01	315000	\N	2000-07-01	81438	\N	\N	f	Sales which are qualified	0
81438_3250.0_2001-02-01	325000	\N	2001-02-01	81438	\N	\N	f	Sales which are qualified	0
81438_7300.0_2007-07-01	730000	\N	2007-07-01	81438	\N	\N	f	Sales which are qualified	0
81438_8750.0_2006-02-01	875000	\N	2006-02-01	81438	\N	\N	f	Sales which are qualified	0
81439_2290.0_2000-05-01	229000	\N	2000-05-01	81439	\N	\N	f	Sales which are qualified	0
81439_3400.0_2000-07-01	340000	\N	2000-07-01	81439	\N	\N	f	Sales which are qualified	0
81439_6200.0_2009-09-01	620000	\N	2009-09-01	81439	\N	\N	f	Qual by exam of deed	0
81440_11500.0_2015-03-03	1150000	\N	2015-03-03	81440	\N	\N	f	Qual by exam of deed	0
81440_2360.0_2000-07-01	236000	\N	2000-07-01	81440	\N	\N	f	Sales which are qualified	0
81440_4650.0_2001-12-01	465000	\N	2001-12-01	81440	\N	\N	f	Sales which are qualified	0
81440_6750.0_2005-03-01	675000	\N	2005-03-01	81440	\N	\N	f	Sales which are qualified	0
81441_13325.0_2022-05-09	1332500	\N	2022-05-09	81441	\N	\N	f	Qual by exam of deed	0
81441_2900.0_2000-05-01	290000	\N	2000-05-01	81441	\N	\N	f	Sales which are qualified	0
81441_4100.0_2002-03-01	410000	\N	2002-03-01	81441	\N	\N	f	Sales which are qualified	0
81441_7300.0_2008-12-11	730000	\N	2008-12-11	81441	\N	\N	f	Sales which are qualified	0
81441_9100.0_2019-06-28	910000	\N	2019-06-28	81441	\N	\N	f	Qual by exam of deed	0
81442_3500.0_2000-05-01	350000	\N	2000-05-01	81442	\N	\N	f	Sales which are qualified	0
81443_2550.0_2000-07-01	255000	\N	2000-07-01	81443	\N	\N	f	Sales which are qualified	0
81443_5450.0_2004-02-01	545000	\N	2004-02-01	81443	\N	\N	f	Sales which are qualified	0
81444_2390.0_2000-06-01	239000	\N	2000-06-01	81444	\N	\N	f	Sales which are qualified	0
81445_2590.0_2000-07-01	259000	\N	2000-07-01	81445	\N	\N	f	Sales which are qualified	0
81446_2430.0_2000-06-01	243000	\N	2000-06-01	81446	\N	\N	f	Sales which are qualified	0
81446_3250.0_2000-06-01	325000	\N	2000-06-01	81446	\N	\N	f	Sales which are qualified	0
81446_4625.0_2002-09-01	462500	\N	2002-09-01	81446	\N	\N	f	Sales which are qualified	0
81447_2450.0_2000-06-01	245000	\N	2000-06-01	81447	\N	\N	f	Sales which are qualified	0
81447_3200.0_2000-06-01	320000	\N	2000-06-01	81447	\N	\N	f	Sales which are qualified	0
81447_4050.0_2001-02-01	405000	\N	2001-02-01	81447	\N	\N	f	Sales which are qualified	0
81447_4670.0_2003-07-01	467000	\N	2003-07-01	81447	\N	\N	f	Sales which are qualified	0
81447_7000.0_2004-12-01	700000	\N	2004-12-01	81447	\N	\N	f	Sales which are qualified	0
81448_11500.0_2015-08-26	1150000	\N	2015-08-26	81448	\N	\N	f	Qual by exam of deed	0
81448_2650.0_2000-07-01	265000	\N	2000-07-01	81448	\N	\N	f	Sales which are qualified	0
81449_2490.0_2000-09-01	249000	\N	2000-09-01	81449	\N	\N	t	Deeds that include more than one parcel	0
81449_4150.0_2001-03-01	415000	\N	2001-03-01	81449	\N	\N	f	Sales which are qualified	0
81450_2550.0_2000-09-01	255000	\N	2000-09-01	81450	\N	\N	f	Sales which are qualified	0
81450_5075.0_2003-10-01	507500	\N	2003-10-01	81450	\N	\N	f	Sales which are qualified	0
81451_4890.0_2000-08-01	489000	\N	2000-08-01	81451	\N	\N	f	Sales which are qualified	0
81451_6300.0_2004-06-01	630000	\N	2004-06-01	81451	\N	\N	f	Sales which are qualified	0
81451_7900.0_2012-01-17	790000	\N	2012-01-17	81451	\N	\N	f	Qual by exam of deed	0
81452_10500.0_2018-02-01	1050000	\N	2018-02-01	81452	\N	\N	f	Qual by exam of deed	0
81452_11739.0_2018-10-09	1173900	\N	2018-10-09	81452	\N	\N	f	Qual by exam of deed	0
81452_2021.0_2001-05-01	202100	\N	2001-05-01	81452	\N	\N	f	Sales which are qualified	0
81452_2730.0_2000-08-01	273000	\N	2000-08-01	81452	\N	\N	f	Sales which are qualified	0
81453_2750.0_2000-06-01	275000	\N	2000-06-01	81453	\N	\N	f	Sales which are qualified	0
81453_3350.0_2000-07-01	335000	\N	2000-07-01	81453	\N	\N	f	Sales which are qualified	0
81454_11500.0_2014-04-10	1150000	\N	2014-04-10	81454	\N	\N	f	Qual by exam of deed	0
81454_13000.0_2017-09-22	1300000	\N	2017-09-22	81454	\N	\N	f	Qual by exam of deed	0
81454_2770.0_2000-06-01	277000	\N	2000-06-01	81454	\N	\N	f	Sales which are qualified	0
81455_3310.0_2000-06-01	331000	\N	2000-06-01	81455	\N	\N	f	Sales which are qualified	0
81456_2850.0_2000-06-01	285000	\N	2000-06-01	81456	\N	\N	f	Sales which are qualified	0
81457_2870.0_2000-06-01	287000	\N	2000-06-01	81457	\N	\N	f	Sales which are qualified	0
81458_16000.0_2015-10-26	1600000	\N	2015-10-26	81458	\N	\N	f	Qual by exam of deed	0
81458_2890.0_2000-09-01	289000	\N	2000-09-01	81458	\N	\N	f	Sales which are qualified	0
81458_3750.0_2000-09-01	375000	\N	2000-09-01	81458	\N	\N	f	Sales which are qualified	0
81458_5260.0_2003-04-01	526000	\N	2003-04-01	81458	\N	\N	f	Sales which are qualified	0
81458_8150.0_2012-03-01	815000	\N	2012-03-01	81458	\N	\N	f	Qual by exam of deed	0
81459_2910.0_2000-08-01	291000	\N	2000-08-01	81459	\N	\N	f	Sales which are qualified	0
81459_3800.0_2000-08-01	380000	\N	2000-08-01	81459	\N	\N	f	Sales which are qualified	0
81459_7700.0_2010-04-12	770000	\N	2010-04-12	81459	\N	\N	f	Qual by exam of deed	0
81460_2930.0_2000-08-01	293000	\N	2000-08-01	81460	\N	\N	f	Sales which are qualified	0
81460_4250.0_2002-02-01	425000	\N	2002-02-01	81460	\N	\N	f	Sales which are qualified	0
81461_13000.0_2021-12-03	1300000	\N	2021-12-03	81461	\N	\N	f	Qual by exam of deed	0
81461_14600.0_2024-01-30	1460000	\N	2024-01-30	81461	\N	\N	f	Qual by exam of deed	0
81461_3795.0_2000-09-01	379500	\N	2000-09-01	81461	\N	\N	f	Sales which are qualified	0
81462_3215.0_2002-03-01	321500	\N	2002-03-01	81462	\N	\N	f	Sales which are qualified	0
81462_6125.0_2004-03-01	612500	\N	2004-03-01	81462	\N	\N	f	Sales which are qualified	0
81462_7000.0_2008-09-02	700000	\N	2008-09-02	81462	\N	\N	f	Sales which are qualified	0
81463_11600.0_2014-04-25	1160000	\N	2014-04-25	81463	\N	\N	f	Qual by exam of deed	0
81463_5550.0_2003-02-01	555000	\N	2003-02-01	81463	\N	\N	f	Sales which are qualified	0
81463_6500.0_2008-11-12	650000	\N	2008-11-12	81463	\N	\N	f	Sales which are qualified	0
81463_8650.0_2012-05-31	865000	\N	2012-05-31	81463	\N	\N	f	Qual by exam of deed	0
81464_5400.0_2003-03-01	540000	\N	2003-03-01	81464	\N	\N	f	Sales which are qualified	0
81465_12250.0_2019-11-25	1225000	\N	2019-11-25	81465	\N	\N	f	Qual by exam of deed	0
81465_4850.0_2002-02-01	485000	\N	2002-02-01	81465	\N	\N	f	Sales which are qualified	0
81465_8265.0_2005-04-01	826500	\N	2005-04-01	81465	\N	\N	f	Sales which are qualified	0
81465_8550.0_2007-10-01	855000	\N	2007-10-01	81465	\N	\N	f	Sales which are qualified	0
81466_5700.0_2003-12-01	570000	\N	2003-12-01	81466	\N	\N	f	Sales which are qualified	0
81466_9940.0_2013-12-23	994000	\N	2013-12-23	81466	\N	\N	f	Qual by exam of deed	0
81467_6900.0_2004-01-01	690000	\N	2004-01-01	81467	\N	\N	f	Sales which are qualified	0
81467_7500.0_2004-07-01	750000	\N	2004-07-01	81467	\N	\N	f	Sales which are qualified	0
81468_3150.0_2000-12-01	315000	\N	2000-12-01	81468	\N	\N	f	Sales which are qualified	0
81468_4900.0_2001-02-01	490000	\N	2001-02-01	81468	\N	\N	f	Sales which are qualified	0
81468_7220.0_2007-12-01	722000	\N	2007-12-01	81468	\N	\N	f	Sales which are qualified	0
81469_10300.0_2007-04-01	1030000	\N	2007-04-01	81469	\N	\N	f	Sales which are qualified	0
81469_6400.0_2002-09-01	640000	\N	2002-09-01	81469	\N	\N	f	Sales which are qualified	0
81469_7940.0_2004-10-01	794000	\N	2004-10-01	81469	\N	\N	f	Sales which are qualified	0
81470_7300.0_2000-12-01	730000	\N	2000-12-01	81470	\N	\N	f	Sales which are qualified	0
81471_4300.0_2000-10-01	430000	\N	2000-10-01	81471	\N	\N	f	Sales which are qualified	0
81472_17000.0_2006-01-01	1700000	\N	2006-01-01	81472	\N	\N	f	Sales which are qualified	0
81472_19750.0_2009-06-19	1975000	\N	2009-06-19	81472	\N	\N	f	Qual by exam of deed	0
81472_22250.0_2014-10-03	2225000	\N	2014-10-03	81472	\N	\N	f	Qual by exam of deed	0
81472_58000.0_2022-11-28	5800000	\N	2022-11-28	81472	\N	\N	f	Qual by exam of deed	0
81473_1950.0_2000-05-01	195000	\N	2000-05-01	81473	\N	\N	f	Sales which are qualified	0
81473_3570.0_2009-07-02	357000	\N	2009-07-02	81473	\N	\N	f	Qual by exam of deed	0
81473_4850.0_2005-05-01	485000	\N	2005-05-01	81473	\N	\N	f	Sales which are qualified	0
81474_1570.0_2000-05-01	157000	\N	2000-05-01	81474	\N	\N	f	Sales which are qualified	0
81474_1920.0_2000-05-01	192000	\N	2000-05-01	81474	\N	\N	f	Sales which are qualified	0
81475_1890.0_2000-07-01	189000	\N	2000-07-01	81475	\N	\N	f	Sales which are qualified	0
81475_7200.0_2015-05-01	720000	\N	2015-05-01	81475	\N	\N	f	Qual by exam of deed	0
81476_1630.0_2000-06-01	163000	\N	2000-06-01	81476	\N	\N	f	Sales which are qualified	0
81476_2725.0_2001-04-01	272500	\N	2001-04-01	81476	\N	\N	f	Sales which are qualified	0
81476_5900.0_2006-02-01	590000	\N	2006-02-01	81476	\N	\N	f	Sales which are qualified	0
81476_6600.0_2014-01-16	660000	\N	2014-01-16	81476	\N	\N	f	Qual by exam of deed	0
81476_7500.0_2015-12-09	750000	\N	2015-12-09	81476	\N	\N	f	Qual by exam of deed	0
81477_3131.0_2003-05-01	313100	\N	2003-05-01	81477	\N	\N	f	Sales which are qualified	0
81477_3132.0_2002-10-01	313200	\N	2002-10-01	81477	\N	\N	f	Sales which are qualified	0
81477_3500.0_2003-05-01	350000	\N	2003-05-01	81477	\N	\N	f	Sales which are qualified	0
81477_7350.0_2014-09-15	735000	\N	2014-09-15	81477	\N	\N	f	Qual by exam of deed	0
81477_7750.0_2017-12-06	775000	\N	2017-12-06	81477	\N	\N	f	Qual by exam of deed	0
81477_8500.0_2017-01-30	850000	\N	2017-01-30	81477	\N	\N	f	Qual by exam of deed	0
81478_1935.0_2000-06-01	193500	\N	2000-06-01	81478	\N	\N	f	Sales which are qualified	0
81479_1700.0_2000-06-01	170000	\N	2000-06-01	81479	\N	\N	f	Sales which are qualified	0
81479_2100.0_2000-06-01	210000	\N	2000-06-01	81479	\N	\N	f	Sales which are qualified	0
81479_4050.0_2004-04-01	405000	\N	2004-04-01	81479	\N	\N	f	Sales which are qualified	0
81480_1670.0_2000-05-01	167000	\N	2000-05-01	81480	\N	\N	f	Sales which are qualified	0
81480_7600.0_2015-03-31	760000	\N	2015-03-31	81480	\N	\N	f	Qual by exam of deed	0
81480_7600.0_2021-07-28	760000	\N	2021-07-28	81480	\N	\N	f	Qual by exam of deed	0
81481_1980.0_2000-05-01	198000	\N	2000-05-01	81481	\N	\N	f	Sales which are qualified	0
81482_10000.0_2023-07-17	1000000	\N	2023-07-17	81482	\N	\N	f	Qual by exam of deed	0
81482_1995.0_2000-07-01	199500	\N	2000-07-01	81482	\N	\N	f	Sales which are qualified	0
81482_5300.0_2012-02-03	530000	\N	2012-02-03	81482	\N	\N	f	Qual by exam of deed	0
81482_8000.0_2015-06-08	800000	\N	2015-06-08	81482	\N	\N	f	Qual by exam of deed	0
81482_8200.0_2018-09-27	820000	\N	2018-09-27	81482	\N	\N	f	Qual by exam of deed	0
81483_2160.0_2000-05-01	216000	\N	2000-05-01	81483	\N	\N	f	Sales which are qualified	0
81483_5330.0_2008-02-01	533000	\N	2008-02-01	81483	\N	\N	f	Sales which are qualified	0
81483_5375.0_2012-03-15	537500	\N	2012-03-15	81483	\N	\N	f	Qual by exam of deed	0
81484_2180.0_2000-06-01	218000	\N	2000-06-01	81484	\N	\N	f	Sales which are qualified	0
81484_3600.0_2002-08-01	360000	\N	2002-08-01	81484	\N	\N	f	Sales which are qualified	0
81484_8550.0_2016-11-18	855000	\N	2016-11-18	81484	\N	\N	f	Qual by exam of deed	0
81485_2040.0_2000-06-01	204000	\N	2000-06-01	81485	\N	\N	f	Sales which are qualified	0
81485_2675.0_2000-06-01	267500	\N	2000-06-01	81485	\N	\N	f	Sales which are qualified	0
81485_5400.0_2007-08-01	540000	\N	2007-08-01	81485	\N	\N	f	Sales which are qualified	0
81485_5500.0_2005-08-01	550000	\N	2005-08-01	81485	\N	\N	f	Sales which are qualified	0
81486_2055.0_2000-07-01	205500	\N	2000-07-01	81486	\N	\N	f	Sales which are qualified	0
81486_3800.0_2002-09-01	380000	\N	2002-09-01	81486	\N	\N	f	Sales which are qualified	0
81486_4486.0_2004-03-01	448600	\N	2004-03-01	81486	\N	\N	f	Sales which are qualified	0
81486_4750.0_2004-05-01	475000	\N	2004-05-01	81486	\N	\N	f	Sales which are qualified	0
81487_1860.0_2000-07-01	186000	\N	2000-07-01	81487	\N	\N	f	Sales which are qualified	0
81487_2550.0_2000-07-01	255000	\N	2000-07-01	81487	\N	\N	f	Sales which are qualified	0
81487_3325.0_2002-07-01	332500	\N	2002-07-01	81487	\N	\N	f	Sales which are qualified	0
81487_4100.0_2004-01-01	410000	\N	2004-01-01	81487	\N	\N	f	Sales which are qualified	0
81487_5250.0_2008-07-10	525000	\N	2008-07-10	81487	\N	\N	f	Sales which are qualified	0
81487_5250.0_2009-04-02	525000	\N	2009-04-02	81487	\N	\N	f	Qual by exam of deed	0
81488_2085.0_2000-06-01	208500	\N	2000-06-01	81488	\N	\N	f	Sales which are qualified	0
81488_5000.0_2010-07-14	500000	\N	2010-07-14	81488	\N	\N	f	Qual by exam of deed	0
81488_5500.0_2012-11-13	550000	\N	2012-11-13	81488	\N	\N	f	Qual by exam of deed	0
81488_7750.0_2017-12-15	775000	\N	2017-12-15	81488	\N	\N	f	Qual by exam of deed	0
81489_2100.0_2000-09-01	210000	\N	2000-09-01	81489	\N	\N	f	Sales which are qualified	0
81489_2850.0_2000-12-01	285000	\N	2000-12-01	81489	\N	\N	f	Sales which are qualified	0
81490_2115.0_2000-09-01	211500	\N	2000-09-01	81490	\N	\N	f	Sales which are qualified	0
81490_3600.0_2003-10-01	360000	\N	2003-10-01	81490	\N	\N	f	Sales which are qualified	0
81490_4800.0_2009-07-06	480000	\N	2009-07-06	81490	\N	\N	f	Qual by exam of deed	0
81491_2341.8_2000-06-01	234180	\N	2000-06-01	81491	\N	\N	f	Sales which are qualified	0
81491_3208.33_2000-06-01	320833	\N	2000-06-01	81491	\N	\N	f	Sales which are qualified	0
81491_4000.0_2003-02-01	400000	\N	2003-02-01	81491	\N	\N	f	Sales which are qualified	0
81491_7990.0_2021-04-22	799000	\N	2021-04-22	81491	\N	\N	f	Qual by exam of deed	0
81491_9700.0_2022-04-05	970000	\N	2022-04-05	81491	\N	\N	f	Qual by exam of deed	0
81492_2145.0_2000-06-01	214500	\N	2000-06-01	81492	\N	\N	f	Sales which are qualified	0
81492_9750.0_2022-06-30	975000	\N	2022-06-30	81492	\N	\N	f	Qual by exam of deed	0
81493_2160.0_2000-07-01	216000	\N	2000-07-01	81493	\N	\N	f	Sales which are qualified	0
81493_3150.0_2000-10-01	315000	\N	2000-10-01	81493	\N	\N	f	Sales which are qualified	0
81493_4210.0_2004-03-01	421000	\N	2004-03-01	81493	\N	\N	f	Sales which are qualified	0
81493_5250.0_2011-04-01	525000	\N	2011-04-01	81493	\N	\N	f	Qual by exam of deed	0
81493_7875.0_2018-10-01	787500	\N	2018-10-01	81493	\N	\N	f	Qual by exam of deed	0
81494_3140.0_2000-06-01	314000	\N	2000-06-01	81494	\N	\N	f	Sales which are qualified	0
81494_5300.0_2008-03-01	530000	\N	2008-03-01	81494	\N	\N	f	Sales which are qualified	0
81494_7200.0_2013-10-18	720000	\N	2013-10-18	81494	\N	\N	f	Qual by exam of deed	0
81494_8000.0_2019-04-01	800000	\N	2019-04-01	81494	\N	\N	f	Qual by exam of deed	0
81495_2190.0_2000-08-01	219000	\N	2000-08-01	81495	\N	\N	f	Sales which are qualified	0
81495_4900.0_2011-03-15	490000	\N	2011-03-15	81495	\N	\N	f	Qual by exam of deed	0
81495_6400.0_2013-03-07	640000	\N	2013-03-07	81495	\N	\N	f	Qual by exam of deed	0
81495_7900.0_2018-03-16	790000	\N	2018-03-16	81495	\N	\N	f	Qual by exam of deed	0
81496_3420.0_2000-06-01	342000	\N	2000-06-01	81496	\N	\N	f	Sales which are qualified	0
81497_2220.0_2000-11-01	222000	\N	2000-11-01	81497	\N	\N	f	Sales which are qualified	0
81497_8050.0_2022-03-07	805000	\N	2022-03-07	81497	\N	\N	f	Qual by exam of deed	0
81498_2235.0_2000-10-01	223500	\N	2000-10-01	81498	\N	\N	f	Sales which are qualified	0
81498_3400.0_2001-02-01	340000	\N	2001-02-01	81498	\N	\N	f	Sales which are qualified	0
81498_4800.0_2004-04-01	480000	\N	2004-04-01	81498	\N	\N	f	Sales which are qualified	0
81498_5050.0_2008-04-01	505000	\N	2008-04-01	81498	\N	\N	f	Sales which are qualified	0
81498_6699.0_2006-02-01	669900	\N	2006-02-01	81498	\N	\N	f	Sales which are qualified	0
81499_2250.0_2000-09-01	225000	\N	2000-09-01	81499	\N	\N	f	Sales which are qualified	0
81499_4140.0_2004-01-01	414000	\N	2004-01-01	81499	\N	\N	f	Sales which are qualified	0
81499_5330.0_2011-12-14	533000	\N	2011-12-14	81499	\N	\N	f	Qual by exam of deed	0
81499_6350.0_2005-11-01	635000	\N	2005-11-01	81499	\N	\N	f	Sales which are qualified	0
81500_4000.0_2003-07-01	400000	\N	2003-07-01	81500	\N	\N	f	Sales which are qualified	0
81500_6120.0_2007-08-01	612000	\N	2007-08-01	81500	\N	\N	f	Sales which are qualified	0
81500_7250.0_2019-12-30	725000	\N	2019-12-30	81500	\N	\N	f	Qual by exam of deed	0
81500_8000.0_2021-04-15	800000	\N	2021-04-15	81500	\N	\N	f	Qual by exam of deed	0
81501_4100.0_2003-09-01	410000	\N	2003-09-01	81501	\N	\N	f	Sales which are qualified	0
81502_2525.0_2000-11-01	252500	\N	2000-11-01	81502	\N	\N	f	Sales which are qualified	0
81502_2990.0_2003-08-01	299000	\N	2003-08-01	81502	\N	\N	f	Sales which are qualified	0
81502_4200.0_2010-03-18	420000	\N	2010-03-18	81502	\N	\N	f	Qual by exam of deed	0
81503_2310.0_2000-09-01	231000	\N	2000-09-01	81503	\N	\N	f	Sales which are qualified	0
81503_5100.0_2011-03-14	510000	\N	2011-03-14	81503	\N	\N	f	Qual by exam of deed	0
81503_5400.0_2005-01-01	540000	\N	2005-01-01	81503	\N	\N	f	Sales which are qualified	0
81504_4350.0_2003-12-01	435000	\N	2003-12-01	81504	\N	\N	f	Sales which are qualified	0
81505_2440.0_2000-10-01	244000	\N	2000-10-01	81505	\N	\N	f	Sales which are qualified	0
81506_2455.0_2000-10-01	245500	\N	2000-10-01	81506	\N	\N	f	Sales which are qualified	0
81506_7930.0_2019-11-13	793000	\N	2019-11-13	81506	\N	\N	f	Qual by exam of deed	0
81506_8600.0_2015-06-10	860000	\N	2015-06-10	81506	\N	\N	f	Qual by exam of deed	0
81507_11000.0_2016-08-25	1100000	\N	2016-08-25	81507	\N	\N	f	Qual by exam of deed	0
81507_2370.0_2001-02-01	237000	\N	2001-02-01	81507	\N	\N	f	Sales which are qualified	0
81507_3400.0_2002-05-01	340000	\N	2002-05-01	81507	\N	\N	f	Sales which are qualified	0
81508_5800.0_2009-11-18	580000	\N	2009-11-18	81508	\N	\N	f	Qual by exam of deed	0
81508_6120.0_2004-02-01	612000	\N	2004-02-01	81508	\N	\N	f	Sales which are qualified	0
81508_8913.33_2014-10-30	891333	\N	2014-10-30	81508	\N	\N	f	Qual by exam of deed	0
81509_2670.0_2000-11-01	267000	\N	2000-11-01	81509	\N	\N	f	Sales which are qualified	0
81510_10000.0_2018-09-28	1000000	\N	2018-09-28	81510	\N	\N	f	Qual by exam of deed	0
81510_11450.0_2021-10-28	1145000	\N	2021-10-28	81510	\N	\N	f	Qual by exam of deed	0
81510_2820.0_2002-03-01	282000	\N	2002-03-01	81510	\N	\N	f	Sales which are qualified	0
81510_7000.0_2006-03-01	700000	\N	2006-03-01	81510	\N	\N	f	Sales which are qualified	0
81510_7300.0_2014-04-15	730000	\N	2014-04-15	81510	\N	\N	f	Qual by exam of deed	0
81511_13200.0_2016-03-17	1320000	\N	2016-03-17	81511	\N	\N	f	Qual by exam of deed	0
81511_2820.0_2002-03-01	282000	\N	2002-03-01	81511	\N	\N	f	Sales which are qualified	0
81512_4300.0_2009-08-19	430000	\N	2009-08-19	81512	\N	\N	f	Qual by exam of deed	0
81512_5000.0_2011-02-15	500000	\N	2011-02-15	81512	\N	\N	f	Qual by exam of deed	0
81512_6200.0_2012-08-31	620000	\N	2012-08-31	81512	\N	\N	f	Qual by exam of deed	0
81512_6250.0_2007-06-01	625000	\N	2007-06-01	81512	\N	\N	f	Sales which are qualified	0
81513_2110.0_2001-10-01	211000	\N	2001-10-01	81513	\N	\N	f	Sales which are qualified	0
81514_3900.0_2003-05-01	390000	\N	2003-05-01	81514	\N	\N	f	Sales which are qualified	0
81515_3250.0_2000-05-01	325000	\N	2000-05-01	81515	\N	\N	f	Sales which are qualified	0
81515_3600.0_2001-10-01	360000	\N	2001-10-01	81515	\N	\N	f	Sales which are qualified	0
81515_7400.0_2014-08-01	740000	\N	2014-08-01	81515	\N	\N	f	Qual by exam of deed	0
81516_12600.0_2023-10-10	1260000	\N	2023-10-10	81516	\N	\N	f	Qual by exam of deed	0
81516_2170.0_2000-06-01	217000	\N	2000-06-01	81516	\N	\N	f	Sales which are qualified	0
81516_2900.0_2000-05-01	290000	\N	2000-05-01	81516	\N	\N	f	Sales which are qualified	0
81516_4775.2_2011-12-16	477520	\N	2011-12-16	81516	\N	\N	f	Qual by exam of deed	0
81517_12950.0_2022-06-30	1295000	\N	2022-06-30	81517	\N	\N	f	Qual by exam of deed	0
81517_3350.0_2000-07-01	335000	\N	2000-07-01	81517	\N	\N	f	Sales which are qualified	0
81518_2380.0_2000-05-01	238000	\N	2000-05-01	81518	\N	\N	f	Sales which are qualified	0
81518_3465.0_2000-10-01	346500	\N	2000-10-01	81518	\N	\N	f	Sales which are qualified	0
81518_4200.0_2002-05-01	420000	\N	2002-05-01	81518	\N	\N	f	Sales which are qualified	0
81518_5250.0_2004-05-01	525000	\N	2004-05-01	81518	\N	\N	f	Sales which are qualified	0
81518_8400.0_2014-12-22	840000	\N	2014-12-22	81518	\N	\N	f	Qual by exam of deed	0
81519_2660.0_2000-07-01	266000	\N	2000-07-01	81519	\N	\N	f	Sales which are qualified	0
81520_12000.0_2021-07-29	1200000	\N	2021-07-29	81520	\N	\N	f	Qual by exam of deed	0
81520_3590.0_2000-05-01	359000	\N	2000-05-01	81520	\N	\N	f	Sales which are qualified	0
81520_4400.0_2003-03-01	440000	\N	2003-03-01	81520	\N	\N	f	Sales which are qualified	0
81520_7180.0_2006-03-01	718000	\N	2006-03-01	81520	\N	\N	f	Sales which are qualified	0
81520_7300.0_2011-06-24	730000	\N	2011-06-24	81520	\N	\N	f	Qual by exam of deed	0
81520_8310.0_2013-06-05	831000	\N	2013-06-05	81520	\N	\N	f	Qual by exam of deed	0
81521_3050.0_2003-07-01	305000	\N	2003-07-01	81521	\N	\N	f	Sales which are qualified	0
81521_3550.0_2000-05-01	355000	\N	2000-05-01	81521	\N	\N	f	Sales which are qualified	0
81521_7050.0_2007-07-01	705000	\N	2007-07-01	81521	\N	\N	f	Sales which are qualified	0
81521_8750.0_2020-02-14	875000	\N	2020-02-14	81521	\N	\N	f	Qual by exam of deed	0
81522_4250.0_2003-01-01	425000	\N	2003-01-01	81522	\N	\N	f	Sales which are qualified	0
81523_2480.0_2000-05-01	248000	\N	2000-05-01	81523	\N	\N	f	Sales which are qualified	0
81523_3500.0_2000-11-01	350000	\N	2000-11-01	81523	\N	\N	f	Sales which are qualified	0
81523_4050.0_2001-05-01	405000	\N	2001-05-01	81523	\N	\N	f	Sales which are qualified	0
81523_7840.0_2013-04-10	784000	\N	2013-04-10	81523	\N	\N	f	Qual by exam of deed	0
81524_10500.0_2017-05-25	1050000	\N	2017-05-25	81524	\N	\N	f	Qual by exam of deed	0
81524_3700.0_2000-06-01	370000	\N	2000-06-01	81524	\N	\N	f	Sales which are qualified	0
81524_6750.0_2011-03-28	675000	\N	2011-03-28	81524	\N	\N	f	Qual by exam of deed	0
81524_8520.0_2006-01-01	852000	\N	2006-01-01	81524	\N	\N	f	Sales which are qualified	0
81524_9250.0_2020-07-17	925000	\N	2020-07-17	81524	\N	\N	f	Qual by exam of deed	0
81525_3080.0_2000-07-01	308000	\N	2000-07-01	81525	\N	\N	f	Sales which are qualified	0
81525_6950.0_2005-01-01	695000	\N	2005-01-01	81525	\N	\N	f	Sales which are qualified	0
81525_7700.0_2019-07-12	770000	\N	2019-07-12	81525	\N	\N	f	Qual by exam of deed	0
81525_9500.0_2021-04-30	950000	\N	2021-04-30	81525	\N	\N	f	Qual by exam of deed	0
81526_2540.0_2000-06-01	254000	\N	2000-06-01	81526	\N	\N	f	Sales which are qualified	0
81526_3700.0_2001-05-01	370000	\N	2001-05-01	81526	\N	\N	f	Sales which are qualified	0
81526_5300.0_2004-03-01	530000	\N	2004-03-01	81526	\N	\N	f	Sales which are qualified	0
81526_7800.0_2020-10-28	780000	\N	2020-10-28	81526	\N	\N	f	Qual by exam of deed	0
81526_8300.0_2005-07-01	830000	\N	2005-07-01	81526	\N	\N	f	Sales which are qualified	0
81527_2560.0_2000-08-01	256000	\N	2000-08-01	81527	\N	\N	f	Sales which are qualified	0
81527_5300.0_2004-06-01	530000	\N	2004-06-01	81527	\N	\N	f	Sales which are qualified	0
81528_2580.0_2000-06-01	258000	\N	2000-06-01	81528	\N	\N	f	Sales which are qualified	0
81528_4900.0_2003-07-01	490000	\N	2003-07-01	81528	\N	\N	f	Sales which are qualified	0
81529_2600.0_2000-06-01	260000	\N	2000-06-01	81529	\N	\N	f	Sales which are qualified	0
81529_4250.0_2001-06-01	425000	\N	2001-06-01	81529	\N	\N	f	Sales which are qualified	0
81530_2620.0_2000-08-01	262000	\N	2000-08-01	81530	\N	\N	f	Sales which are qualified	0
81531_3200.0_2000-07-01	320000	\N	2000-07-01	81531	\N	\N	f	Sales which are qualified	0
81532_11500.0_2021-04-01	1150000	\N	2021-04-01	81532	\N	\N	f	Qual by exam of deed	0
81532_11600.0_2014-11-14	1160000	\N	2014-11-14	81532	\N	\N	f	Qual by exam of deed	0
81532_2660.0_2000-06-01	266000	\N	2000-06-01	81532	\N	\N	f	Sales which are qualified	0
81533_2680.0_2000-07-01	268000	\N	2000-07-01	81533	\N	\N	f	Sales which are qualified	0
81533_3750.0_2000-07-01	375000	\N	2000-07-01	81533	\N	\N	f	Sales which are qualified	0
81533_8300.0_2005-07-01	830000	\N	2005-07-01	81533	\N	\N	f	Sales which are qualified	0
81534_3260.0_2000-07-01	326000	\N	2000-07-01	81534	\N	\N	f	Sales which are qualified	0
81534_4600.0_2003-01-01	460000	\N	2003-01-01	81534	\N	\N	f	Sales which are qualified	0
81535_2720.0_2000-06-01	272000	\N	2000-06-01	81535	\N	\N	f	Sales which are qualified	0
81535_3750.0_2000-06-01	375000	\N	2000-06-01	81535	\N	\N	f	Sales which are qualified	0
81535_4290.0_2000-08-01	429000	\N	2000-08-01	81535	\N	\N	f	Sales which are qualified	0
81535_5690.0_2003-04-01	569000	\N	2003-04-01	81535	\N	\N	f	Sales which are qualified	0
81536_2740.0_2000-08-01	274000	\N	2000-08-01	81536	\N	\N	f	Sales which are qualified	0
81536_4190.0_2000-08-01	419000	\N	2000-08-01	81536	\N	\N	f	Sales which are qualified	0
81536_4950.0_2002-04-01	495000	\N	2002-04-01	81536	\N	\N	f	Sales which are qualified	0
81537_14200.0_2015-12-14	1420000	\N	2015-12-14	81537	\N	\N	f	Qual by exam of deed	0
81537_2760.0_2000-09-01	276000	\N	2000-09-01	81537	\N	\N	f	Sales which are qualified	0
81537_7275.0_2005-03-01	727500	\N	2005-03-01	81537	\N	\N	f	Sales which are qualified	0
81538_2780.0_2000-08-01	278000	\N	2000-08-01	81538	\N	\N	f	Sales which are qualified	0
81538_3840.0_2000-08-01	384000	\N	2000-08-01	81538	\N	\N	f	Sales which are qualified	0
81538_4650.0_2001-06-01	465000	\N	2001-06-01	81538	\N	\N	f	Sales which are qualified	0
81538_5950.0_2004-01-01	595000	\N	2004-01-01	81538	\N	\N	f	Sales which are qualified	0
81539_2800.0_2000-10-01	280000	\N	2000-10-01	81539	\N	\N	f	Sales which are qualified	0
81539_4550.0_2001-02-01	455000	\N	2001-02-01	81539	\N	\N	f	Sales which are qualified	0
81539_5200.0_2002-01-01	520000	\N	2002-01-01	81539	\N	\N	f	Sales which are qualified	0
81539_6500.0_2008-06-01	650000	\N	2008-06-01	81539	\N	\N	f	Sales which are qualified	0
81540_5450.0_2002-10-01	545000	\N	2002-10-01	81540	\N	\N	f	Sales which are qualified	0
81541_2840.0_2000-10-01	284000	\N	2000-10-01	81541	\N	\N	f	Sales which are qualified	0
81542_12500.0_2018-02-26	1250000	\N	2018-02-26	81542	\N	\N	f	Qual by exam of deed	0
81542_2860.0_2000-09-01	286000	\N	2000-09-01	81542	\N	\N	f	Sales which are qualified	0
81542_4050.0_2000-09-01	405000	\N	2000-09-01	81542	\N	\N	f	Sales which are qualified	0
81542_7700.0_2011-02-09	770000	\N	2011-02-09	81542	\N	\N	f	Qual by exam of deed	0
81543_5400.0_2003-02-01	540000	\N	2003-02-01	81543	\N	\N	f	Sales which are qualified	0
81544_5650.0_2003-02-01	565000	\N	2003-02-01	81544	\N	\N	f	Sales which are qualified	0
81545_5650.0_2003-04-01	565000	\N	2003-04-01	81545	\N	\N	f	Sales which are qualified	0
81545_7900.0_2010-04-15	790000	\N	2010-04-15	81545	\N	\N	f	Qual by exam of deed	0
81546_15750.0_2017-12-11	1575000	\N	2017-12-11	81546	\N	\N	f	Qual by exam of deed	0
81546_5850.0_2003-02-01	585000	\N	2003-02-01	81546	\N	\N	f	Sales which are qualified	0
81546_7425.0_2011-02-24	742500	\N	2011-02-24	81546	\N	\N	f	Qual by exam of deed	0
81546_9400.0_2012-05-01	940000	\N	2012-05-01	81546	\N	\N	f	Qual by exam of deed	0
81547_7369.0_2001-11-01	736900	\N	2001-11-01	81547	\N	\N	f	Sales which are qualified	0
81548_13850.0_2021-05-04	1385000	\N	2021-05-04	81548	\N	\N	f	Qual by exam of deed	0
81548_4200.0_2000-11-01	420000	\N	2000-11-01	81548	\N	\N	f	Sales which are qualified	0
81549_10250.0_2007-05-01	1025000	\N	2007-05-01	81549	\N	\N	f	Sales which are qualified	0
81549_3500.0_2000-12-01	350000	\N	2000-12-01	81549	\N	\N	f	Sales which are qualified	0
81549_6400.0_2002-07-01	640000	\N	2002-07-01	81549	\N	\N	f	Sales which are qualified	0
81550_19500.0_2006-08-01	1950000	\N	2006-08-01	81550	\N	\N	f	Sales which are qualified	0
81551_2330.0_2000-06-01	233000	\N	2000-06-01	81551	\N	\N	f	Sales which are qualified	0
81552_3080.0_2000-06-01	308000	\N	2000-06-01	81552	\N	\N	f	Sales which are qualified	0
81552_3760.0_2002-04-01	376000	\N	2002-04-01	81552	\N	\N	f	Sales which are qualified	0
81552_4100.0_2004-01-01	410000	\N	2004-01-01	81552	\N	\N	f	Sales which are qualified	0
81552_5950.0_2009-10-18	595000	\N	2009-10-18	81552	\N	\N	f	Qual by exam of deed	0
81552_7800.0_2013-07-25	780000	\N	2013-07-25	81552	\N	\N	f	Qual by exam of deed	0
81552_8500.0_2014-11-24	850000	\N	2014-11-24	81552	\N	\N	f	Qual by exam of deed	0
81553_2405.0_2000-05-01	240500	\N	2000-05-01	81553	\N	\N	f	Sales which are qualified	0
81553_3000.0_2000-06-01	300000	\N	2000-06-01	81553	\N	\N	f	Sales which are qualified	0
81554_2460.0_2000-05-01	246000	\N	2000-05-01	81554	\N	\N	f	Sales which are qualified	0
81554_6250.0_2011-11-03	625000	\N	2011-11-03	81554	\N	\N	f	Qual by exam of deed	0
81555_2410.0_2000-05-01	241000	\N	2000-05-01	81555	\N	\N	f	Sales which are qualified	0
81555_5700.0_2010-02-05	570000	\N	2010-02-05	81555	\N	\N	f	Qual by exam of deed	0
81555_7850.0_2014-05-23	785000	\N	2014-05-23	81555	\N	\N	f	Qual by exam of deed	0
81555_8600.0_2015-03-31	860000	\N	2015-03-31	81555	\N	\N	f	Qual by exam of deed	0
81556_11000.0_2015-05-19	1100000	\N	2015-05-19	81556	\N	\N	f	Qual by exam of deed	0
81556_12900.0_2023-05-03	1290000	\N	2023-05-03	81556	\N	\N	f	Qual by exam of deed	0
81556_2430.0_2000-05-01	243000	\N	2000-05-01	81556	\N	\N	f	Sales which are qualified	0
81556_6650.0_2005-02-01	665000	\N	2005-02-01	81556	\N	\N	f	Sales which are qualified	0
81557_2520.0_2000-06-01	252000	\N	2000-06-01	81557	\N	\N	f	Sales which are qualified	0
81558_2540.0_2000-05-01	254000	\N	2000-05-01	81558	\N	\N	f	Sales which are qualified	0
81558_8300.0_2020-12-30	830000	\N	2020-12-30	81558	\N	\N	f	Qual by exam of deed	0
81559_2490.0_2000-08-01	249000	\N	2000-08-01	81559	\N	\N	f	Sales which are qualified	0
81559_9750.0_2021-11-01	975000	\N	2021-11-01	81559	\N	\N	f	Qual by exam of deed	0
81560_2510.0_2000-06-01	251000	\N	2000-06-01	81560	\N	\N	f	Sales which are qualified	0
81561_3750.0_2002-04-01	375000	\N	2002-04-01	81561	\N	\N	f	Sales which are qualified	0
81562_3570.0_2000-06-01	357000	\N	2000-06-01	81562	\N	\N	f	Sales which are qualified	0
81563_3600.0_2000-09-01	360000	\N	2000-09-01	81563	\N	\N	f	Sales which are qualified	0
81564_2500.0_2003-09-01	250000	\N	2003-09-01	81564	\N	\N	f	Sales which are qualified	0
81564_2590.0_2000-05-01	259000	\N	2000-05-01	81564	\N	\N	f	Sales which are qualified	0
81564_3700.0_2001-03-01	370000	\N	2001-03-01	81564	\N	\N	f	Sales which are qualified	0
81565_2750.0_2000-07-01	275000	\N	2000-07-01	81565	\N	\N	f	Sales which are qualified	0
81565_5575.0_2011-03-16	557500	\N	2011-03-16	81565	\N	\N	f	Qual by exam of deed	0
81565_7600.0_2020-06-26	760000	\N	2020-06-26	81565	\N	\N	f	Qual by exam of deed	0
81565_8450.0_2012-12-27	845000	\N	2012-12-27	81565	\N	\N	f	Qual by exam of deed	0
81566_4059.0_2000-12-01	405900	\N	2000-12-01	81566	\N	\N	f	Sales which are qualified	0
81566_7000.0_2007-08-24	700000	\N	2007-08-24	81566	\N	\N	f	Sales which are qualified	0
81567_3000.0_2000-08-01	300000	\N	2000-08-01	81567	\N	\N	f	Sales which are qualified	0
81567_6200.0_2004-05-01	620000	\N	2004-05-01	81567	\N	\N	f	Sales which are qualified	0
81567_6950.0_2011-12-13	695000	\N	2011-12-13	81567	\N	\N	f	Qual by exam of deed	0
81568_2800.0_2000-08-01	280000	\N	2000-08-01	81568	\N	\N	f	Sales which are qualified	0
81568_5900.0_2004-05-01	590000	\N	2004-05-01	81568	\N	\N	f	Sales which are qualified	0
81568_6800.0_2004-12-01	680000	\N	2004-12-01	81568	\N	\N	f	Sales which are qualified	0
81568_9600.0_2014-11-17	960000	\N	2014-11-17	81568	\N	\N	f	Qual by exam of deed	0
81569_15000.0_2022-11-17	1500000	\N	2022-11-17	81569	\N	\N	f	Qual by exam of deed	0
81569_3820.0_2000-07-01	382000	\N	2000-07-01	81569	\N	\N	f	Sales which are qualified	0
81569_4700.0_2003-06-01	470000	\N	2003-06-01	81569	\N	\N	f	Sales which are qualified	0
81569_6450.0_2011-12-20	645000	\N	2011-12-20	81569	\N	\N	f	Qual by exam of deed	0
81569_8450.0_2006-02-01	845000	\N	2006-02-01	81569	\N	\N	f	Sales which are qualified	0
81570_3060.0_2000-07-01	306000	\N	2000-07-01	81570	\N	\N	f	Sales which are qualified	0
81570_6000.0_2004-08-01	600000	\N	2004-08-01	81570	\N	\N	f	Sales which are qualified	0
81570_6200.0_2009-12-21	620000	\N	2009-12-21	81570	\N	\N	f	Qual by exam of deed	0
81571_3080.0_2000-08-01	308000	\N	2000-08-01	81571	\N	\N	f	Sales which are qualified	0
81571_8500.0_2013-09-26	850000	\N	2013-09-26	81571	\N	\N	f	Qual by exam of deed	0
81572_5300.0_2003-01-01	530000	\N	2003-01-01	81572	\N	\N	f	Sales which are qualified	0
81572_7700.0_2004-11-01	770000	\N	2004-11-01	81572	\N	\N	f	Sales which are qualified	0
81573_5299.0_2001-03-01	529900	\N	2001-03-01	81573	\N	\N	f	Sales which are qualified	0
81575_3160.0_2000-10-01	316000	\N	2000-10-01	81575	\N	\N	f	Sales which are qualified	0
81575_4850.0_2004-01-01	485000	\N	2004-01-01	81575	\N	\N	f	Sales which are qualified	0
81575_7980.0_2008-06-01	798000	\N	2008-06-01	81575	\N	\N	f	Sales which are qualified	0
81575_8000.0_2011-08-30	800000	\N	2011-08-30	81575	\N	\N	f	Qual by exam of deed	0
81576_5500.0_2002-05-01	550000	\N	2002-05-01	81576	\N	\N	f	Sales which are qualified	0
81576_8950.0_2013-07-10	895000	\N	2013-07-10	81576	\N	\N	f	Qual by exam of deed	0
81576_9200.0_2005-07-01	920000	\N	2005-07-01	81576	\N	\N	f	Sales which are qualified	0
81577_3200.0_2000-08-01	320000	\N	2000-08-01	81577	\N	\N	f	Sales which are qualified	0
81577_4850.0_2003-01-01	485000	\N	2003-01-01	81577	\N	\N	f	Sales which are qualified	0
81577_9350.0_2020-08-04	935000	\N	2020-08-04	81577	\N	\N	f	Qual by exam of deed	0
81578_11500.0_2013-11-26	1150000	\N	2013-11-26	81578	\N	\N	f	Qual by exam of deed	0
81578_3000.0_2000-09-01	300000	\N	2000-09-01	81578	\N	\N	f	Sales which are qualified	0
81578_5750.0_2004-10-01	575000	\N	2004-10-01	81578	\N	\N	f	Sales which are qualified	0
81578_5750.0_2007-09-01	575000	\N	2007-09-01	81578	\N	\N	f	Sales which are qualified	0
81578_7000.0_2009-10-14	700000	\N	2009-10-14	81578	\N	\N	f	Qual by exam of deed	0
81578_9300.0_2012-12-11	930000	\N	2012-12-11	81578	\N	\N	f	Qual by exam of deed	0
81579_11000.0_2021-05-26	1100000	\N	2021-05-26	81579	\N	\N	f	Qual by exam of deed	0
81579_6540.0_2004-03-01	654000	\N	2004-03-01	81579	\N	\N	f	Sales which are qualified	0
81579_9200.0_2019-10-24	920000	\N	2019-10-24	81579	\N	\N	f	Qual by exam of deed	0
81580_6990.0_2004-05-01	699000	\N	2004-05-01	81580	\N	\N	f	Sales which are qualified	0
81581_12100.0_2017-05-16	1210000	\N	2017-05-16	81581	\N	\N	f	Qual by exam of deed	0
81581_19750.0_2022-05-13	1975000	\N	2022-05-13	81581	\N	\N	f	Qual by exam of deed	0
81581_3340.0_2000-10-01	334000	\N	2000-10-01	81581	\N	\N	f	Sales which are qualified	0
81581_3850.0_2000-10-01	385000	\N	2000-10-01	81581	\N	\N	f	Sales which are qualified	0
81581_7750.0_2012-06-06	775000	\N	2012-06-06	81581	\N	\N	f	Qual by exam of deed	0
81582_11550.0_2014-07-30	1155000	\N	2014-07-30	81582	\N	\N	f	Qual by exam of deed	0
81582_3140.0_2000-09-01	314000	\N	2000-09-01	81582	\N	\N	f	Sales which are qualified	0
81582_3750.0_2000-09-01	375000	\N	2000-09-01	81582	\N	\N	f	Sales which are qualified	0
81583_7350.0_2004-08-01	735000	\N	2004-08-01	81583	\N	\N	f	Sales which are qualified	0
81584_16950.0_2022-03-22	1695000	\N	2022-03-22	81584	\N	\N	f	Qual by exam of deed	0
81584_7900.0_2004-11-01	790000	\N	2004-11-01	81584	\N	\N	f	Sales which are qualified	0
81585_11000.0_2019-10-31	1100000	\N	2019-10-31	81585	\N	\N	f	Qual by exam of deed	0
81585_9750.0_2006-10-01	975000	\N	2006-10-01	81585	\N	\N	f	Sales which are qualified	0
81586_7149.0_2004-01-01	714900	\N	2004-01-01	81586	\N	\N	f	Sales which are qualified	0
81587_6250.0_2003-07-01	625000	\N	2003-07-01	81587	\N	\N	f	Sales which are qualified	0
81587_8050.0_2009-11-02	805000	\N	2009-11-02	81587	\N	\N	f	Qual by exam of deed	0
81588_3950.0_2000-12-01	395000	\N	2000-12-01	81588	\N	\N	f	Sales which are qualified	0
81588_6000.0_2003-04-01	600000	\N	2003-04-01	81588	\N	\N	f	Sales which are qualified	0
81589_21000.0_2004-06-01	2100000	\N	2004-06-01	81589	\N	\N	f	Sales which are qualified	0
79865_33750.0_2023-01-17	3375000	\N	2023-01-17	79865	\N	\N	f	Qual by exam of deed	0
79866_11757.0_2009-12-29	1175700	\N	2009-12-29	79866	\N	\N	f	Qual by exam of deed	0
79868_11200.0_2009-11-30	1120000	\N	2009-11-30	79868	\N	\N	f	Qual by exam of deed	0
79869_12000.0_2009-11-30	1200000	\N	2009-11-30	79869	\N	\N	f	Qual by exam of deed	0
79869_13700.0_2010-05-24	1370000	\N	2010-05-24	79869	\N	\N	f	Qual by exam of deed	0
79869_30300.0_2021-03-22	3030000	\N	2021-03-22	79869	\N	\N	f	Qual by exam of deed	0
79870_13283.0_2009-12-15	1328300	\N	2009-12-15	79870	\N	\N	f	Qual by exam of deed	0
79871_12124.2_2010-01-07	1212420	\N	2010-01-07	79871	\N	\N	f	Qual by exam of deed	0
79871_19200.0_2012-04-30	1920000	\N	2012-04-30	79871	\N	\N	f	Qual by exam of deed	0
79871_24500.0_2013-04-30	2450000	\N	2013-04-30	79871	\N	\N	f	Qual by exam of deed	0
79872_12216.05_2009-12-14	1221605	\N	2009-12-14	79872	\N	\N	f	Qual by exam of deed	0
79873_17000.0_2009-05-01	1700000	\N	2009-05-01	79873	\N	\N	f	Qual by exam of deed	0
79874_14860.0_2010-05-21	1486000	\N	2010-05-21	79874	\N	\N	f	Qual by exam of deed	0
79875_14950.0_2010-04-30	1495000	\N	2010-04-30	79875	\N	\N	f	Qual by exam of deed	0
79876_14600.0_2010-02-26	1460000	\N	2010-02-26	79876	\N	\N	f	Qual by exam of deed	0
79876_14750.0_2011-02-23	1475000	\N	2011-02-23	79876	\N	\N	f	Qual by exam of deed	0
79877_15557.4_2010-04-01	1555740	\N	2010-04-01	79877	\N	\N	f	Qual by exam of deed	0
79877_35000.0_2021-06-15	3500000	\N	2021-06-15	79877	\N	\N	f	Qual by exam of deed	0
79878_15786.9_2010-04-01	1578690	\N	2010-04-01	79878	\N	\N	f	Qual by exam of deed	0
79878_31500.0_2020-12-29	3150000	\N	2020-12-29	79878	\N	\N	f	Qual by exam of deed	0
79879_15550.0_2010-01-29	1555000	\N	2010-01-29	79879	\N	\N	f	Qual by exam of deed	0
79880_15673.5_2010-02-19	1567350	\N	2010-02-19	79880	\N	\N	f	Qual by exam of deed	0
79881_14500.0_2009-10-30	1450000	\N	2009-10-30	79881	\N	\N	f	Qual by exam of deed	0
79881_42000.0_2014-12-12	4200000	\N	2014-12-12	79881	\N	\N	f	Qual by exam of deed	0
79881_42750.0_2024-03-15	4275000	\N	2024-03-15	79881	\N	\N	f	Qual by exam of deed	0
79882_16719.0_2009-12-15	1671900	\N	2009-12-15	79882	\N	\N	f	Qual by exam of deed	0
79882_42000.0_2021-07-01	4200000	\N	2021-07-01	79882	\N	\N	f	Qual by exam of deed	0
79883_27400.0_2012-04-19	2740000	\N	2012-04-19	79883	\N	\N	f	Qual by exam of deed	0
79884_17000.0_2009-07-21	1700000	\N	2009-07-21	79884	\N	\N	f	Qual by exam of deed	0
79885_27500.0_2008-10-20	2750000	\N	2008-10-20	79885	\N	\N	f	Sales which are qualified	0
79885_32200.0_2012-05-08	3220000	\N	2012-05-08	79885	\N	\N	f	Qual by exam of deed	0
79886_28500.0_2008-07-18	2850000	\N	2008-07-18	79886	\N	\N	f	Sales which are qualified	0
79886_39500.0_2014-03-31	3950000	\N	2014-03-31	79886	\N	\N	f	Qual by exam of deed	0
79887_17000.0_2009-03-09	1700000	\N	2009-03-09	79887	\N	\N	f	Qual by exam of deed	0
79887_36000.0_2013-04-25	3600000	\N	2013-04-25	79887	\N	\N	f	Qual by exam of deed	0
79888_35000.0_2014-05-27	3500000	\N	2014-05-27	79888	\N	\N	f	Qual by exam of deed	0
79888_46000.0_2020-12-04	4600000	\N	2020-12-04	79888	\N	\N	f	Qual by exam of deed	0
79889_6750.0_2011-04-29	675000	\N	2011-04-29	79889	\N	\N	f	Qual by exam of deed	0
79890_7050.0_2010-12-06	705000	\N	2010-12-06	79890	\N	\N	f	Qual by exam of deed	0
79891_7350.0_2011-02-11	735000	\N	2011-02-11	79891	\N	\N	f	Qual by exam of deed	0
79892_15500.0_2014-12-10	1550000	\N	2014-12-10	79892	\N	\N	f	Qual by exam of deed	0
79892_7300.0_2010-11-15	730000	\N	2010-11-15	79892	\N	\N	f	Qual by exam of deed	0
79893_14700.0_2013-11-11	1470000	\N	2013-11-11	79893	\N	\N	f	Qual by exam of deed	0
79893_15500.0_2018-07-31	1550000	\N	2018-07-31	79893	\N	\N	f	Qual by exam of deed	0
79893_8500.0_2010-12-09	850000	\N	2010-12-09	79893	\N	\N	f	Qual by exam of deed	0
79894_15250.0_2013-12-18	1525000	\N	2013-12-18	79894	\N	\N	f	Qual by exam of deed	0
79894_15500.0_2017-01-31	1550000	\N	2017-01-31	79894	\N	\N	f	Qual by exam of deed	0
79894_8904.5_2010-06-25	890450	\N	2010-06-25	79894	\N	\N	f	Qual by exam of deed	0
79895_14125.0_2013-08-30	1412500	\N	2013-08-30	79895	\N	\N	f	Qual by exam of deed	0
79895_9067.0_2010-02-10	906700	\N	2010-02-10	79895	\N	\N	f	Qual by exam of deed	0
79896_14000.0_2013-12-20	1400000	\N	2013-12-20	79896	\N	\N	f	Qual by exam of deed	0
79896_17000.0_2017-02-14	1700000	\N	2017-02-14	79896	\N	\N	f	Qual by exam of deed	0
79896_19500.0_2021-02-24	1950000	\N	2021-02-24	79896	\N	\N	f	Qual by exam of deed	0
79896_9000.0_2010-02-16	900000	\N	2010-02-16	79896	\N	\N	f	Qual by exam of deed	0
79897_17750.0_2021-03-08	1775000	\N	2021-03-08	79897	\N	\N	f	Qual by exam of deed	0
79897_9391.0_2009-12-29	939100	\N	2009-12-29	79897	\N	\N	f	Qual by exam of deed	0
79898_16750.0_2014-03-25	1675000	\N	2014-03-25	79898	\N	\N	f	Qual by exam of deed	0
79898_26250.0_2022-05-10	2625000	\N	2022-05-10	79898	\N	\N	f	Qual by exam of deed	0
79898_9553.0_2009-12-17	955300	\N	2009-12-17	79898	\N	\N	f	Qual by exam of deed	0
79899_8904.5_2009-11-24	890450	\N	2009-11-24	79899	\N	\N	f	Qual by exam of deed	0
79900_13000.0_2008-12-30	1300000	\N	2008-12-30	79900	\N	\N	f	Sales which are qualified	0
79900_23250.0_2019-01-29	2325000	\N	2019-01-29	79900	\N	\N	f	Qual by exam of deed	0
79900_9750.0_2011-04-28	975000	\N	2011-04-28	79900	\N	\N	f	Qual by exam of deed	0
79901_10500.0_2009-05-04	1050000	\N	2009-05-04	79901	\N	\N	f	Qual by exam of deed	0
79901_14490.0_2012-06-06	1449000	\N	2012-06-06	79901	\N	\N	f	Qual by exam of deed	0
79901_21500.0_2018-03-19	2150000	\N	2018-03-19	79901	\N	\N	f	Qual by exam of deed	0
79901_26500.0_2022-01-14	2650000	\N	2022-01-14	79901	\N	\N	f	Qual by exam of deed	0
79902_29000.0_2022-11-15	2900000	\N	2022-11-15	79902	\N	\N	f	Qual by exam of deed	0
79902_9875.0_2009-06-16	987500	\N	2009-06-16	79902	\N	\N	f	Qual by exam of deed	0
79903_10118.4_2010-01-15	1011840	\N	2010-01-15	79903	\N	\N	f	Qual by exam of deed	0
79903_26000.0_2019-04-18	2600000	\N	2019-04-18	79903	\N	\N	f	Qual by exam of deed	0
79904_10200.0_2009-04-30	1020000	\N	2009-04-30	79904	\N	\N	f	Qual by exam of deed	0
79904_26000.0_2019-12-12	2600000	\N	2019-12-12	79904	\N	\N	f	Qual by exam of deed	0
79905_10450.0_2013-10-18	1045000	\N	2013-10-18	79905	\N	\N	f	Qual by exam of deed	0
79905_12200.0_2014-09-12	1220000	\N	2014-09-12	79905	\N	\N	f	Qual by exam of deed	0
79905_5700.0_2011-05-25	570000	\N	2011-05-25	79905	\N	\N	f	Qual by exam of deed	0
79905_9300.0_2021-11-23	930000	\N	2021-11-23	79905	\N	\N	f	Qual by exam of deed	0
79906_11500.0_2014-05-27	1150000	\N	2014-05-27	79906	\N	\N	f	Qual by exam of deed	0
79906_5900.0_2011-01-10	590000	\N	2011-01-10	79906	\N	\N	f	Qual by exam of deed	0
79907_6171.0_2010-10-22	617100	\N	2010-10-22	79907	\N	\N	f	Qual by exam of deed	0
79907_8000.0_2012-03-07	800000	\N	2012-03-07	79907	\N	\N	f	Qual by exam of deed	0
79908_6700.0_2010-06-18	670000	\N	2010-06-18	79908	\N	\N	f	Qual by exam of deed	0
79909_13500.0_2020-02-27	1350000	\N	2020-02-27	79909	\N	\N	f	Qual by exam of deed	0
79909_15500.0_2015-11-23	1550000	\N	2015-11-23	79909	\N	\N	f	Qual by exam of deed	0
79909_6750.0_2010-06-11	675000	\N	2010-06-11	79909	\N	\N	f	Qual by exam of deed	0
79910_13500.0_2014-02-01	1350000	\N	2014-02-01	79910	\N	\N	f	Qual by exam of deed	0
79910_6770.0_2010-04-14	677000	\N	2010-04-14	79910	\N	\N	f	Qual by exam of deed	0
79911_20000.0_2022-04-04	2000000	\N	2022-04-04	79911	\N	\N	f	Qual by exam of deed	0
79911_7000.0_2010-05-26	700000	\N	2010-05-26	79911	\N	\N	f	Qual by exam of deed	0
79912_10000.0_2008-08-01	1000000	\N	2008-08-01	79912	\N	\N	f	Sales which are qualified	0
79913_11500.0_2012-02-27	1150000	\N	2012-02-27	79913	\N	\N	f	Qual by exam of deed	0
79913_17250.0_2014-05-16	1725000	\N	2014-05-16	79913	\N	\N	f	Qual by exam of deed	0
79913_21100.0_2022-04-08	2110000	\N	2022-04-08	79913	\N	\N	f	Qual by exam of deed	0
79913_7456.7_2010-01-21	745670	\N	2010-01-21	79913	\N	\N	f	Qual by exam of deed	0
79914_12250.0_2008-08-14	1225000	\N	2008-08-14	79914	\N	\N	f	Sales which are qualified	0
79914_12250.0_2013-06-04	1225000	\N	2013-06-04	79914	\N	\N	f	Qual by exam of deed	0
79915_14500.0_2008-07-22	1450000	\N	2008-07-22	79915	\N	\N	f	Sales which are qualified	0
79916_7815.3_2009-11-20	781530	\N	2009-11-20	79916	\N	\N	f	Qual by exam of deed	0
79917_13000.0_2019-12-16	1300000	\N	2019-12-16	79917	\N	\N	f	Qual by exam of deed	0
79917_16900.0_2014-02-14	1690000	\N	2014-02-14	79917	\N	\N	f	Qual by exam of deed	0
79917_21500.0_2021-03-15	2150000	\N	2021-03-15	79917	\N	\N	f	Qual by exam of deed	0
79918_17500.0_2017-04-19	1750000	\N	2017-04-19	79918	\N	\N	f	Qual by exam of deed	0
79918_7684.0_2009-12-22	768400	\N	2009-12-22	79918	\N	\N	f	Qual by exam of deed	0
79919_14000.0_2012-10-25	1400000	\N	2012-10-25	79919	\N	\N	f	Qual by exam of deed	0
79919_19000.0_2016-02-15	1900000	\N	2016-02-15	79919	\N	\N	f	Qual by exam of deed	0
79919_8030.0_2010-01-20	803000	\N	2010-01-20	79919	\N	\N	f	Qual by exam of deed	0
79920_8103.0_2010-02-25	810300	\N	2010-02-25	79920	\N	\N	f	Qual by exam of deed	0
79921_35000.0_2010-06-15	3500000	\N	2010-06-15	79921	\N	\N	f	Qual by exam of deed	0
79922_37000.0_2010-04-01	3700000	\N	2010-04-01	79922	\N	\N	f	Qual by exam of deed	0
79922_65000.0_2014-07-01	6500000	\N	2014-07-01	79922	\N	\N	f	Qual by exam of deed	0
79923_134330.0_2021-02-17	13433000	\N	2021-02-17	79923	\N	\N	t	Qual on DOS, multi-parcel sale	0
79923_42750.0_2010-04-08	4275000	\N	2010-04-08	79923	\N	\N	f	Qual by exam of deed	0
79924_100000.0_2021-02-19	10000000	\N	2021-02-19	79924	\N	\N	f	Qual by exam of deed	0
79924_47000.0_2010-07-14	4700000	\N	2010-07-14	79924	\N	\N	f	Qual by exam of deed	0
83210_60000.0_2019-11-22	6000000	\N	2019-11-22	83210	\N	\N	f	Qual by exam of deed	0
83210_62000.0_2022-03-04	6200000	\N	2022-03-04	83210	\N	\N	f	Qual by exam of deed	0
83216_50000.0_2020-06-29	5000000	\N	2020-06-29	83216	\N	\N	f	Qual by exam of deed	0
83218_106500.0_2020-07-30	10650000	\N	2020-07-30	83218	\N	\N	f	Qual by exam of deed	0
83218_92500.0_2022-02-14	9250000	\N	2022-02-14	83218	\N	\N	f	Qual by exam of deed	0
83219_114000.0_2021-10-28	11400000	\N	2021-10-28	83219	\N	\N	f	Qual by exam of deed	0
83219_75000.0_2020-08-27	7500000	\N	2020-08-27	83219	\N	\N	f	Qual by exam of deed	0
83220_61250.0_2020-01-10	6125000	\N	2020-01-10	83220	\N	\N	f	Qual by exam of deed	0
83221_65000.0_2019-12-05	6500000	\N	2019-12-05	83221	\N	\N	f	Qual by exam of deed	0
83222_69000.0_2019-12-02	6900000	\N	2019-12-02	83222	\N	\N	f	Qual by exam of deed	0
83223_75000.0_2019-12-30	7500000	\N	2019-12-30	83223	\N	\N	f	Qual by exam of deed	0
83223_90000.0_2021-09-14	9000000	\N	2021-09-14	83223	\N	\N	f	Qual by exam of deed	0
83224_74000.0_2020-02-18	7400000	\N	2020-02-18	83224	\N	\N	f	Qual by exam of deed	0
83224_94377.0_2022-06-08	9437700	\N	2022-06-08	83224	\N	\N	f	Qual by exam of deed	0
83225_59165.0_2021-01-15	5916500	\N	2021-01-15	83225	\N	\N	f	Qual by exam of deed	0
83226_65450.0_2020-01-22	6545000	\N	2020-01-22	83226	\N	\N	f	Qual by exam of deed	0
83227_98385.0_2020-01-15	9838500	\N	2020-01-15	83227	\N	\N	f	Qual by exam of deed	0
83229_114500.0_2020-02-28	11450000	\N	2020-02-28	83229	\N	\N	f	Qual by exam of deed	0
83230_124423.0_2020-02-14	12442300	\N	2020-02-14	83230	\N	\N	f	Qual by exam of deed	0
83231_125000.0_2020-02-06	12500000	\N	2020-02-06	83231	\N	\N	f	Qual by exam of deed	0
83232_116561.0_2020-02-27	11656100	\N	2020-02-27	83232	\N	\N	f	Qual by exam of deed	0
83234_13000.0_2019-11-20	1300000	\N	2019-11-20	83234	\N	\N	f	Qual by exam of deed	0
83235_15500.0_2019-12-27	1550000	\N	2019-12-27	83235	\N	\N	f	Qual by exam of deed	0
83236_14500.0_2019-11-25	1450000	\N	2019-11-25	83236	\N	\N	f	Qual by exam of deed	0
83236_17750.0_2021-12-02	1775000	\N	2021-12-02	83236	\N	\N	f	Qual by exam of deed	0
83237_12000.0_2010-02-10	1200000	\N	2010-02-10	83237	\N	\N	f	Qual by exam of deed	0
83237_17750.0_2023-09-02	1775000	\N	2023-09-02	83237	\N	\N	f	Qual by exam of deed	0
83238_16000.0_2019-12-02	1600000	\N	2019-12-02	83238	\N	\N	f	Qual by exam of deed	0
83239_13500.0_2019-11-22	1350000	\N	2019-11-22	83239	\N	\N	f	Qual by exam of deed	0
83240_18000.0_2019-12-13	1800000	\N	2019-12-13	83240	\N	\N	f	Qual by exam of deed	0
83241_17000.0_2020-02-28	1700000	\N	2020-02-28	83241	\N	\N	f	Qual by exam of deed	0
83241_19250.0_2022-09-21	1925000	\N	2022-09-21	83241	\N	\N	f	Qual by exam of deed	0
83242_16000.0_2021-04-09	1600000	\N	2021-04-09	83242	\N	\N	f	Qual by exam of deed	0
83243_28800.0_2020-09-03	2880000	\N	2020-09-03	83243	\N	\N	f	Qual by exam of deed	0
83243_30000.0_2022-06-22	3000000	\N	2022-06-22	83243	\N	\N	f	Qual by exam of deed	0
83244_29600.0_2020-03-10	2960000	\N	2020-03-10	83244	\N	\N	f	Qual by exam of deed	0
83245_68000.0_2020-01-10	6800000	\N	2020-01-10	83245	\N	\N	t	Qual on DOS, multi-parcel sale	0
83246_33000.0_2020-05-04	3300000	\N	2020-05-04	83246	\N	\N	f	Qual by exam of deed	0
83246_37500.0_2021-06-14	3750000	\N	2021-06-14	83246	\N	\N	f	Qual by exam of deed	0
83247_39000.0_2020-02-05	3900000	\N	2020-02-05	83247	\N	\N	f	Qual by exam of deed	0
83248_32080.0_2019-12-16	3208000	\N	2019-12-16	83248	\N	\N	f	Qual by exam of deed	0
83248_36000.0_2021-09-15	3600000	\N	2021-09-15	83248	\N	\N	f	Qual by exam of deed	0
83249_39000.0_2019-12-06	3900000	\N	2019-12-06	83249	\N	\N	f	Qual by exam of deed	0
83250_22500.0_2019-11-22	2250000	\N	2019-11-22	83250	\N	\N	f	Qual by exam of deed	0
83251_21900.0_2019-11-22	2190000	\N	2019-11-22	83251	\N	\N	f	Qual by exam of deed	0
83252_22000.0_2019-11-27	2200000	\N	2019-11-27	83252	\N	\N	f	Qual by exam of deed	0
83253_24000.0_2020-07-08	2400000	\N	2020-07-08	83253	\N	\N	f	Qual by exam of deed	0
83253_33000.0_2021-10-11	3300000	\N	2021-10-11	83253	\N	\N	f	Qual by exam of deed	0
83254_26000.0_2019-12-03	2600000	\N	2019-12-03	83254	\N	\N	f	Qual by exam of deed	0
83254_29200.0_2021-03-01	2920000	\N	2021-03-01	83254	\N	\N	f	Qual by exam of deed	0
83254_40000.0_2022-04-21	4000000	\N	2022-04-21	83254	\N	\N	f	Qual by exam of deed	0
83255_28800.0_2020-09-03	2880000	\N	2020-09-03	83255	\N	\N	f	Qual by exam of deed	0
83255_29500.0_2021-02-22	2950000	\N	2021-02-22	83255	\N	\N	f	Qual by exam of deed	0
83255_35000.0_2023-07-26	3500000	\N	2023-07-26	83255	\N	\N	f	Qual by exam of deed	0
83256_30000.0_2020-01-10	3000000	\N	2020-01-10	83256	\N	\N	f	Qual by exam of deed	0
83256_38500.0_2022-04-08	3850000	\N	2022-04-08	83256	\N	\N	f	Qual by exam of deed	0
83257_28500.0_2020-10-14	2850000	\N	2020-10-14	83257	\N	\N	f	Qual by exam of deed	0
83258_29500.0_2020-07-07	2950000	\N	2020-07-07	83258	\N	\N	f	Qual by exam of deed	0
83258_38500.0_2022-06-08	3850000	\N	2022-06-08	83258	\N	\N	f	Qual by exam of deed	0
83259_66000.0_2020-02-27	6600000	\N	2020-02-27	83259	\N	\N	f	Qual by exam of deed	0
83260_75000.0_2020-08-19	7500000	\N	2020-08-19	83260	\N	\N	f	Qual by exam of deed	0
83260_80000.0_2021-01-08	8000000	\N	2021-01-08	83260	\N	\N	f	Qual by exam of deed	0
83261_81000.0_2020-09-03	8100000	\N	2020-09-03	83261	\N	\N	f	Qual by exam of deed	0
83261_92990.0_2021-10-21	9299000	\N	2021-10-21	83261	\N	\N	f	Qual by exam of deed	0
83263_24500.0_2020-10-21	2450000	\N	2020-10-21	83263	\N	\N	f	Qual by exam of deed	0
83263_27250.0_2023-09-07	2725000	\N	2023-09-07	83263	\N	\N	f	Qual by exam of deed	0
83264_33000.0_2019-12-02	3300000	\N	2019-12-02	83264	\N	\N	f	Qual by exam of deed	0
83265_68000.0_2020-01-10	6800000	\N	2020-01-10	83265	\N	\N	t	Qual on DOS, multi-parcel sale	0
83266_33950.0_2020-01-31	3395000	\N	2020-01-31	83266	\N	\N	f	Qual by exam of deed	0
83266_48000.0_2022-05-27	4800000	\N	2022-05-27	83266	\N	\N	f	Qual by exam of deed	0
83267_36000.0_2019-12-30	3600000	\N	2019-12-30	83267	\N	\N	f	Qual by exam of deed	0
83267_48750.0_2022-05-16	4875000	\N	2022-05-16	83267	\N	\N	f	Qual by exam of deed	0
83268_33395.0_2020-12-30	3339500	\N	2020-12-30	83268	\N	\N	f	Qual by exam of deed	0
83269_38000.0_2020-01-13	3800000	\N	2020-01-13	83269	\N	\N	f	Qual by exam of deed	0
83269_52500.0_2022-09-16	5250000	\N	2022-09-16	83269	\N	\N	f	Qual by exam of deed	0
83270_50141.67_2020-01-15	5014167	\N	2020-01-15	83270	\N	\N	f	Qual by exam of deed	0
83271_41500.0_2019-12-30	4150000	\N	2019-12-30	83271	\N	\N	f	Qual by exam of deed	0
79810_125000.0_2017-01-10	12500000	\N	2017-01-10	79810	\N	\N	f	Qual by exam of deed	0
79810_165000.0_2015-09-02	16500000	\N	2015-09-02	79810	\N	\N	f	Qual by exam of deed	0
79811_185000.0_2015-11-16	18500000	\N	2015-11-16	79811	\N	\N	f	Qual by exam of deed	0
79812_153230.0_2015-11-30	15323000	\N	2015-11-30	79812	\N	\N	f	Qual by exam of deed	0
79814_187000.0_2022-06-30	18700000	\N	2022-06-30	79814	\N	\N	f	Qual by exam of deed	0
79814_200000.0_2015-12-04	20000000	\N	2015-12-04	79814	\N	\N	f	Qual by exam of deed	0
79815_73600.0_2015-12-11	7360000	\N	2015-12-11	79815	\N	\N	f	Qual by exam of deed	0
79816_79000.0_2018-06-07	7900000	\N	2018-06-07	79816	\N	\N	f	Qual by exam of deed	0
79816_81500.0_2015-09-09	8150000	\N	2015-09-09	79816	\N	\N	f	Qual by exam of deed	0
79817_92000.0_2015-09-28	9200000	\N	2015-09-28	79817	\N	\N	f	Qual by exam of deed	0
79818_88000.0_2015-10-06	8800000	\N	2015-10-06	79818	\N	\N	f	Qual by exam of deed	0
79819_90000.0_2015-11-10	9000000	\N	2015-11-10	79819	\N	\N	f	Qual by exam of deed	0
79819_93000.0_2021-05-12	9300000	\N	2021-05-12	79819	\N	\N	f	Qual by exam of deed	0
79820_98000.0_2015-09-24	9800000	\N	2015-09-24	79820	\N	\N	f	Qual by exam of deed	0
79821_100000.0_2015-10-23	10000000	\N	2015-10-23	79821	\N	\N	f	Qual by exam of deed	0
79822_135035.0_2015-09-18	13503500	\N	2015-09-18	79822	\N	\N	f	Qual by exam of deed	0
79824_120500.0_2021-03-01	12050000	\N	2021-03-01	79824	\N	\N	f	Qual by exam of deed	0
79824_121000.0_2015-10-19	12100000	\N	2015-10-19	79824	\N	\N	f	Qual by exam of deed	0
79825_50000.0_2015-10-16	5000000	\N	2015-10-16	79825	\N	\N	f	Qual by exam of deed	0
79826_45750.0_2019-09-25	4575000	\N	2019-09-25	79826	\N	\N	f	Qual by exam of deed	0
79826_57500.0_2015-10-02	5750000	\N	2015-10-02	79826	\N	\N	f	Qual by exam of deed	0
79827_40020.0_2015-09-17	4002000	\N	2015-09-17	79827	\N	\N	f	Qual by exam of deed	0
79828_50500.0_2015-09-09	5050000	\N	2015-09-09	79828	\N	\N	f	Qual by exam of deed	0
79828_55000.0_2021-06-18	5500000	\N	2021-06-18	79828	\N	\N	f	Qual by exam of deed	0
79828_56000.0_2022-04-08	5600000	\N	2022-04-08	79828	\N	\N	f	Qual by exam of deed	0
79829_51500.0_2015-09-04	5150000	\N	2015-09-04	79829	\N	\N	f	Qual by exam of deed	0
79829_51500.0_2020-09-18	5150000	\N	2020-09-18	79829	\N	\N	f	Qual by exam of deed	0
79829_58000.0_2022-03-23	5800000	\N	2022-03-23	79829	\N	\N	f	Qual by exam of deed	0
79830_50000.0_2015-09-17	5000000	\N	2015-09-17	79830	\N	\N	f	Qual by exam of deed	0
79830_72000.0_2021-06-28	7200000	\N	2021-06-28	79830	\N	\N	f	Qual by exam of deed	0
79831_55500.0_2015-09-16	5550000	\N	2015-09-16	79831	\N	\N	f	Qual by exam of deed	0
79832_64000.0_2015-10-14	6400000	\N	2015-10-14	79832	\N	\N	f	Qual by exam of deed	0
79834_86500.0_2015-11-02	8650000	\N	2015-11-02	79834	\N	\N	f	Qual by exam of deed	0
79835_25000.0_2015-09-28	2500000	\N	2015-09-28	79835	\N	\N	f	Qual by exam of deed	0
79836_26500.0_2015-09-03	2650000	\N	2015-09-03	79836	\N	\N	f	Qual by exam of deed	0
79836_26500.0_2019-12-10	2650000	\N	2019-12-10	79836	\N	\N	f	Qual by exam of deed	0
79837_25000.0_2015-09-11	2500000	\N	2015-09-11	79837	\N	\N	f	Qual by exam of deed	0
79838_25500.0_2015-09-16	2550000	\N	2015-09-16	79838	\N	\N	f	Qual by exam of deed	0
79839_24500.0_2021-06-28	2450000	\N	2021-06-28	79839	\N	\N	f	Qual by exam of deed	0
79839_25000.0_2015-09-10	2500000	\N	2015-09-10	79839	\N	\N	f	Qual by exam of deed	0
79839_34000.0_2015-10-19	3400000	\N	2015-10-19	79839	\N	\N	f	Qual by exam of deed	0
79840_26000.0_2015-09-18	2600000	\N	2015-09-18	79840	\N	\N	f	Qual by exam of deed	0
79841_25600.0_2015-09-14	2560000	\N	2015-09-14	79841	\N	\N	f	Qual by exam of deed	0
79843_35000.0_2015-09-14	3500000	\N	2015-09-14	79843	\N	\N	f	Qual by exam of deed	0
79844_120000.0_2017-04-06	12000000	\N	2017-04-06	79844	\N	\N	f	Qual by exam of deed	0
79844_92000.0_2019-12-23	9200000	\N	2019-12-23	79844	\N	\N	f	Qual by exam of deed	0
79846_291680.0_2015-10-20	29168000	\N	2015-10-20	79846	\N	\N	f	Qual by exam of deed	0
79847_111500.0_2021-06-17	11150000	\N	2021-06-17	79847	\N	\N	f	Qual by exam of deed	0
79847_600000.0_2015-09-21	60000000	\N	2015-09-21	79847	\N	\N	t	Qual on DOS, multi-parcel sale	0
79848_350000.0_2020-12-09	35000000	\N	2020-12-09	79848	\N	\N	f	Qual by exam of deed	0
79848_600000.0_2015-09-21	60000000	\N	2015-09-21	79848	\N	\N	t	Qual on DOS, multi-parcel sale	0
80369_6890.0_2017-03-28	689000	\N	2017-03-28	80369	\N	\N	f	Qual by exam of deed	0
80371_3790.0_2008-04-01	379000	\N	2008-04-01	80371	\N	\N	f	Sales which are qualified	0
80372_3000.0_2005-04-01	300000	\N	2005-04-01	80372	\N	\N	f	Sales which are qualified	0
80373_3450.0_2005-02-01	345000	\N	2005-02-01	80373	\N	\N	f	Sales which are qualified	0
80374_3000.0_2011-02-18	300000	\N	2011-02-18	80374	\N	\N	f	Qual by exam of deed	0
80374_3750.0_2005-03-01	375000	\N	2005-03-01	80374	\N	\N	f	Sales which are qualified	0
80380_3459.6_2005-03-01	345960	\N	2005-03-01	80380	\N	\N	f	Sales which are qualified	0
80381_12720.0_2005-04-01	1272000	\N	2005-04-01	80381	\N	\N	t	Deeds that include more than one parcel	0
80381_7000.0_2018-10-05	700000	\N	2018-10-05	80381	\N	\N	f	Qual by exam of deed	0
80381_7000.0_2021-07-22	700000	\N	2021-07-22	80381	\N	\N	f	Qual by exam of deed	0
80392_4650.0_2005-04-01	465000	\N	2005-04-01	80392	\N	\N	f	Sales which are qualified	0
80392_6200.0_2006-06-01	620000	\N	2006-06-01	80392	\N	\N	f	Sales which are qualified	0
80392_7500.0_2021-10-18	750000	\N	2021-10-18	80392	\N	\N	f	Qual by exam of deed	0
80393_3000.0_2005-04-01	300000	\N	2005-04-01	80393	\N	\N	f	Sales which are qualified	0
80393_5275.0_2005-04-01	527500	\N	2005-04-01	80393	\N	\N	f	Sales which are qualified	0
80394_4500.0_2005-05-01	450000	\N	2005-05-01	80394	\N	\N	f	Sales which are qualified	0
80394_4560.0_2012-05-18	456000	\N	2012-05-18	80394	\N	\N	f	Qual by exam of deed	0
80394_4850.0_2008-10-10	485000	\N	2008-10-10	80394	\N	\N	f	Sales which are qualified	0
80395_14400.0_2007-01-01	1440000	\N	2007-01-01	80395	\N	\N	t	Deeds that include more than one parcel	0
80395_4900.0_2005-06-01	490000	\N	2005-06-01	80395	\N	\N	f	Sales which are qualified	0
80396_5000.0_2005-06-01	500000	\N	2005-06-01	80396	\N	\N	f	Sales which are qualified	0
80396_6500.0_2005-06-01	650000	\N	2005-06-01	80396	\N	\N	f	Sales which are qualified	0
80397_2990.0_2005-02-01	299000	\N	2005-02-01	80397	\N	\N	f	Sales which are qualified	0
80397_3150.0_2008-08-29	315000	\N	2008-08-29	80397	\N	\N	f	Sales which are qualified	0
80397_3275.0_2009-05-30	327500	\N	2009-05-30	80397	\N	\N	f	Qual by exam of deed	0
80398_2990.0_2005-03-01	299000	\N	2005-03-01	80398	\N	\N	f	Sales which are qualified	0
80398_5000.0_2014-04-07	500000	\N	2014-04-07	80398	\N	\N	f	Qual by exam of deed	0
80399_3750.0_2005-06-01	375000	\N	2005-06-01	80399	\N	\N	f	Sales which are qualified	0
80400_3850.0_2005-03-01	385000	\N	2005-03-01	80400	\N	\N	f	Sales which are qualified	0
80400_6330.0_2015-09-01	633000	\N	2015-09-01	80400	\N	\N	f	Qual by exam of deed	0
80400_6720.0_2015-03-02	672000	\N	2015-03-02	80400	\N	\N	f	Qual by exam of deed	0
80401_3850.0_2005-02-01	385000	\N	2005-02-01	80401	\N	\N	f	Sales which are qualified	0
80401_5900.0_2014-11-12	590000	\N	2014-11-12	80401	\N	\N	f	Qual by exam of deed	0
80402_3100.0_2011-10-06	310000	\N	2011-10-06	80402	\N	\N	f	Qual by exam of deed	0
80402_3850.0_2005-02-01	385000	\N	2005-02-01	80402	\N	\N	f	Sales which are qualified	0
80402_7450.0_2016-02-11	745000	\N	2016-02-11	80402	\N	\N	f	Qual by exam of deed	0
80403_2800.0_2005-03-01	280000	\N	2005-03-01	80403	\N	\N	f	Sales which are qualified	0
80403_3500.0_2005-03-01	350000	\N	2005-03-01	80403	\N	\N	f	Sales which are qualified	0
80403_5070.0_2014-02-24	507000	\N	2014-02-24	80403	\N	\N	f	Qual by exam of deed	0
80404_4100.0_2005-02-01	410000	\N	2005-02-01	80404	\N	\N	f	Sales which are qualified	0
80405_3700.0_2005-03-01	370000	\N	2005-03-01	80405	\N	\N	f	Sales which are qualified	0
80405_4100.0_2007-02-01	410000	\N	2007-02-01	80405	\N	\N	f	Sales which are qualified	0
80405_5760.0_2014-06-12	576000	\N	2014-06-12	80405	\N	\N	f	Qual by exam of deed	0
80406_13250.0_2005-02-01	1325000	\N	2005-02-01	80406	\N	\N	t	Deeds that include more than one parcel	0
80407_3250.0_2005-05-01	325000	\N	2005-05-01	80407	\N	\N	f	Sales which are qualified	0
80407_4025.0_2005-05-01	402500	\N	2005-05-01	80407	\N	\N	f	Sales which are qualified	0
80407_7150.0_2015-05-08	715000	\N	2015-05-08	80407	\N	\N	f	Qual by exam of deed	0
80408_2930.0_2011-09-29	293000	\N	2011-09-29	80408	\N	\N	f	Qual by exam of deed	0
80408_3579.6_2005-07-01	357960	\N	2005-07-01	80408	\N	\N	f	Sales which are qualified	0
80409_3836.4_2005-03-01	383640	\N	2005-03-01	80409	\N	\N	f	Sales which are qualified	0
80409_7000.0_2019-07-09	700000	\N	2019-07-09	80409	\N	\N	f	Qual by exam of deed	0
80410_3150.0_2011-07-18	315000	\N	2011-07-18	80410	\N	\N	f	Qual by exam of deed	0
80410_3590.0_2008-12-31	359000	\N	2008-12-31	80410	\N	\N	f	Sales which are qualified	0
80410_3927.0_2005-02-01	392700	\N	2005-02-01	80410	\N	\N	f	Sales which are qualified	0
80411_3500.0_2006-07-01	350000	\N	2006-07-01	80411	\N	\N	f	Sales which are qualified	0
80411_4400.0_2005-04-01	440000	\N	2005-04-01	80411	\N	\N	f	Sales which are qualified	0
80411_7665.0_2015-09-28	766500	\N	2015-09-28	80411	\N	\N	f	Qual by exam of deed	0
80412_4000.0_2005-03-01	400000	\N	2005-03-01	80412	\N	\N	f	Sales which are qualified	0
80412_5270.0_2013-11-25	527000	\N	2013-11-25	80412	\N	\N	f	Qual by exam of deed	0
80413_4090.0_2005-05-01	409000	\N	2005-05-01	80413	\N	\N	f	Sales which are qualified	0
80414_4104.0_2005-05-01	410400	\N	2005-05-01	80414	\N	\N	f	Sales which are qualified	0
80414_4250.0_2007-05-01	425000	\N	2007-05-01	80414	\N	\N	f	Sales which are qualified	0
80415_12500.0_2005-05-01	1250000	\N	2005-05-01	80415	\N	\N	t	Deeds that include more than one parcel	0
80416_5000.0_2005-04-01	500000	\N	2005-04-01	80416	\N	\N	f	Sales which are qualified	0
80416_7955.0_2017-01-17	795500	\N	2017-01-17	80416	\N	\N	f	Qual by exam of deed	0
80416_8800.0_2022-07-27	880000	\N	2022-07-27	80416	\N	\N	f	Qual by exam of deed	0
80417_4100.0_2005-03-01	410000	\N	2005-03-01	80417	\N	\N	f	Sales which are qualified	0
80418_4005.0_2005-03-01	400500	\N	2005-03-01	80418	\N	\N	f	Sales which are qualified	0
80419_4400.0_2005-03-01	440000	\N	2005-03-01	80419	\N	\N	f	Sales which are qualified	0
80419_4900.0_2007-03-01	490000	\N	2007-03-01	80419	\N	\N	f	Sales which are qualified	0
80419_7500.0_2018-02-02	750000	\N	2018-02-02	80419	\N	\N	f	Qual by exam of deed	0
80422_3000.0_2005-04-01	300000	\N	2005-04-01	80422	\N	\N	f	Sales which are qualified	0
80433_7700.0_2005-03-01	770000	\N	2005-03-01	80433	\N	\N	f	Sales which are qualified	0
80434_6750.0_2007-05-01	675000	\N	2007-05-01	80434	\N	\N	f	Sales which are qualified	0
80434_9700.0_2005-02-01	970000	\N	2005-02-01	80434	\N	\N	t	Deeds that include more than one parcel	0
80435_11250.0_2019-02-14	1125000	\N	2019-02-14	80435	\N	\N	f	Qual by exam of deed	0
80435_13250.0_2005-02-01	1325000	\N	2005-02-01	80435	\N	\N	t	Deeds that include more than one parcel	0
80436_11000.0_2018-08-27	1100000	\N	2018-08-27	80436	\N	\N	f	Qual by exam of deed	0
80436_11500.0_2005-03-01	1150000	\N	2005-03-01	80436	\N	\N	t	Deeds that include more than one parcel	0
80436_7000.0_2005-03-01	700000	\N	2005-03-01	80436	\N	\N	t	Deeds that include more than one parcel	0
80437_6900.0_2005-04-01	690000	\N	2005-04-01	80437	\N	\N	f	Sales which are qualified	0
80437_7900.0_2005-04-01	790000	\N	2005-04-01	80437	\N	\N	f	Sales which are qualified	0
80437_9040.0_2013-02-12	904000	\N	2013-02-12	80437	\N	\N	f	Qual by exam of deed	0
80438_6033.4_2005-03-01	603340	\N	2005-03-01	80438	\N	\N	f	Sales which are qualified	0
80438_6280.0_2011-06-30	628000	\N	2011-06-30	80438	\N	\N	f	Qual by exam of deed	0
80438_7700.0_2005-05-01	770000	\N	2005-05-01	80438	\N	\N	f	Sales which are qualified	0
80439_12000.0_2018-10-05	1200000	\N	2018-10-05	80439	\N	\N	f	Qual by exam of deed	0
80439_12100.0_2021-07-22	1210000	\N	2021-07-22	80439	\N	\N	f	Qual by exam of deed	0
80439_12720.0_2005-04-01	1272000	\N	2005-04-01	80439	\N	\N	t	Deeds that include more than one parcel	0
80440_13500.0_2015-09-21	1350000	\N	2015-09-21	80440	\N	\N	f	Qual by exam of deed	0
80440_6500.0_2010-04-15	650000	\N	2010-04-15	80440	\N	\N	f	Qual by exam of deed	0
80440_9000.0_2005-03-01	900000	\N	2005-03-01	80440	\N	\N	f	Sales which are qualified	0
80441_8890.0_2005-03-01	889000	\N	2005-03-01	80441	\N	\N	f	Sales which are qualified	0
80442_6900.0_2005-04-01	690000	\N	2005-04-01	80442	\N	\N	f	Sales which are qualified	0
80442_7450.0_2008-05-01	745000	\N	2008-05-01	80442	\N	\N	f	Sales which are qualified	0
80443_5790.0_2005-03-01	579000	\N	2005-03-01	80443	\N	\N	f	Sales which are qualified	0
80444_7800.0_2005-04-01	780000	\N	2005-04-01	80444	\N	\N	f	Sales which are qualified	0
80445_8070.0_2005-05-01	807000	\N	2005-05-01	80445	\N	\N	f	Sales which are qualified	0
80446_6300.0_2010-09-27	630000	\N	2010-09-27	80446	\N	\N	f	Qual by exam of deed	0
80446_7800.0_2005-03-01	780000	\N	2005-03-01	80446	\N	\N	f	Sales which are qualified	0
80447_6750.0_2011-01-27	675000	\N	2011-01-27	80447	\N	\N	f	Qual by exam of deed	0
80447_7900.0_2005-04-01	790000	\N	2005-04-01	80447	\N	\N	f	Sales which are qualified	0
80448_12450.0_2019-06-03	1245000	\N	2019-06-03	80448	\N	\N	f	Qual by exam of deed	0
80448_8100.0_2005-04-01	810000	\N	2005-04-01	80448	\N	\N	f	Sales which are qualified	0
80449_11000.0_2014-07-03	1100000	\N	2014-07-03	80449	\N	\N	f	Qual by exam of deed	0
80449_7600.0_2005-04-01	760000	\N	2005-04-01	80449	\N	\N	f	Sales which are qualified	0
80449_9000.0_2006-06-01	900000	\N	2006-06-01	80449	\N	\N	f	Sales which are qualified	0
80450_7700.0_2005-05-01	770000	\N	2005-05-01	80450	\N	\N	f	Sales which are qualified	0
80451_6000.0_2005-04-01	600000	\N	2005-04-01	80451	\N	\N	f	Sales which are qualified	0
80451_7350.0_2010-03-03	735000	\N	2010-03-03	80451	\N	\N	f	Qual by exam of deed	0
80452_8300.0_2012-05-24	830000	\N	2012-05-24	80452	\N	\N	f	Qual by exam of deed	0
80452_9150.0_2005-05-01	915000	\N	2005-05-01	80452	\N	\N	f	Sales which are qualified	0
80453_14400.0_2007-01-01	1440000	\N	2007-01-01	80453	\N	\N	t	Deeds that include more than one parcel	0
80453_9100.0_2005-06-01	910000	\N	2005-06-01	80453	\N	\N	f	Sales which are qualified	0
80455_6200.0_2005-02-01	620000	\N	2005-02-01	80455	\N	\N	f	Sales which are qualified	0
80455_8000.0_2013-07-15	800000	\N	2013-07-15	80455	\N	\N	f	Qual by exam of deed	0
80456_6100.0_2005-03-01	610000	\N	2005-03-01	80456	\N	\N	f	Sales which are qualified	0
80456_8900.0_2021-09-09	890000	\N	2021-09-09	80456	\N	\N	f	Qual by exam of deed	0
80457_6100.0_2005-02-01	610000	\N	2005-02-01	80457	\N	\N	f	Sales which are qualified	0
80458_12000.0_2014-09-29	1200000	\N	2014-09-29	80458	\N	\N	f	Qual by exam of deed	0
80458_5276.0_2011-04-04	527600	\N	2011-04-04	80458	\N	\N	f	Qual by exam of deed	0
80458_6430.0_2005-03-01	643000	\N	2005-03-01	80458	\N	\N	f	Sales which are qualified	0
80458_8750.0_2020-08-04	875000	\N	2020-08-04	80458	\N	\N	f	Qual by exam of deed	0
80459_6500.0_2005-03-01	650000	\N	2005-03-01	80459	\N	\N	f	Sales which are qualified	0
80460_6640.0_2005-03-01	664000	\N	2005-03-01	80460	\N	\N	f	Sales which are qualified	0
80461_5450.0_2012-06-08	545000	\N	2012-06-08	80461	\N	\N	f	Qual by exam of deed	0
80461_6900.0_2005-04-01	690000	\N	2005-04-01	80461	\N	\N	f	Sales which are qualified	0
80462_10500.0_2017-12-27	1050000	\N	2017-12-27	80462	\N	\N	f	Qual by exam of deed	0
80462_4150.0_2012-02-02	415000	\N	2012-02-02	80462	\N	\N	f	Qual by exam of deed	0
80462_5577.5_2005-03-01	557750	\N	2005-03-01	80462	\N	\N	f	Sales which are qualified	0
80462_6700.0_2013-02-21	670000	\N	2013-02-21	80462	\N	\N	f	Qual by exam of deed	0
80462_6950.0_2005-06-01	695000	\N	2005-06-01	80462	\N	\N	f	Sales which are qualified	0
80463_10500.0_2016-09-30	1050000	\N	2016-09-30	80463	\N	\N	f	Qual by exam of deed	0
80463_11350.0_2021-07-19	1135000	\N	2021-07-19	80463	\N	\N	f	Qual by exam of deed	0
80463_7200.0_2005-03-01	720000	\N	2005-03-01	80463	\N	\N	f	Sales which are qualified	0
80464_13250.0_2005-02-01	1325000	\N	2005-02-01	80464	\N	\N	t	Deeds that include more than one parcel	0
80465_10150.0_2014-06-25	1015000	\N	2014-06-25	80465	\N	\N	f	Qual by exam of deed	0
80465_7850.0_2005-03-01	785000	\N	2005-03-01	80465	\N	\N	f	Sales which are qualified	0
80466_4850.0_2011-06-14	485000	\N	2011-06-14	80466	\N	\N	f	Qual by exam of deed	0
80466_6772.0_2005-07-01	677200	\N	2005-07-01	80466	\N	\N	f	Sales which are qualified	0
80467_10500.0_2017-12-04	1050000	\N	2017-12-04	80467	\N	\N	f	Qual by exam of deed	0
80467_12500.0_2015-04-17	1250000	\N	2015-04-17	80467	\N	\N	f	Qual by exam of deed	0
80467_7850.0_2005-03-01	785000	\N	2005-03-01	80467	\N	\N	f	Sales which are qualified	0
80468_10400.0_2019-08-12	1040000	\N	2019-08-12	80468	\N	\N	f	Qual by exam of deed	0
80468_6300.0_2011-04-01	630000	\N	2011-04-01	80468	\N	\N	f	Qual by exam of deed	0
80468_7300.0_2013-01-17	730000	\N	2013-01-17	80468	\N	\N	f	Qual by exam of deed	0
80468_7700.0_2005-03-01	770000	\N	2005-03-01	80468	\N	\N	f	Sales which are qualified	0
80469_7600.0_2005-04-01	760000	\N	2005-04-01	80469	\N	\N	f	Sales which are qualified	0
80469_9950.0_2018-09-14	995000	\N	2018-09-14	80469	\N	\N	f	Qual by exam of deed	0
80470_10300.0_2014-06-30	1030000	\N	2014-06-30	80470	\N	\N	f	Qual by exam of deed	0
80470_6000.0_2012-12-03	600000	\N	2012-12-03	80470	\N	\N	f	Qual by exam of deed	0
80470_8250.0_2005-04-01	825000	\N	2005-04-01	80470	\N	\N	f	Sales which are qualified	0
80471_6140.0_2005-03-01	614000	\N	2005-03-01	80471	\N	\N	f	Sales which are qualified	0
80472_6170.0_2005-03-01	617000	\N	2005-03-01	80472	\N	\N	f	Sales which are qualified	0
80473_12500.0_2005-05-01	1250000	\N	2005-05-01	80473	\N	\N	t	Deeds that include more than one parcel	0
80474_13545.0_2018-01-17	1354500	\N	2018-01-17	80474	\N	\N	f	Qual by exam of deed	0
80474_14800.0_2022-07-27	1480000	\N	2022-07-27	80474	\N	\N	f	Qual by exam of deed	0
80474_8500.0_2005-04-01	850000	\N	2005-04-01	80474	\N	\N	f	Sales which are qualified	0
80475_14500.0_2016-03-21	1450000	\N	2016-03-21	80475	\N	\N	f	Qual by exam of deed	0
80477_14520.0_2015-03-27	1452000	\N	2015-03-27	80477	\N	\N	f	Qual by exam of deed	0
80477_7661.0_2005-03-01	766100	\N	2005-03-01	80477	\N	\N	f	Sales which are qualified	0
80478_8950.0_2005-04-01	895000	\N	2005-04-01	80478	\N	\N	f	Sales which are qualified	0
80479_14000.0_2005-06-01	1400000	\N	2005-06-01	80479	\N	\N	t	Deeds that include more than one parcel	0
80480_11000.0_2006-05-01	1100000	\N	2006-05-01	80480	\N	\N	f	Sales which are qualified	0
80480_6000.0_2005-04-01	600000	\N	2005-04-01	80480	\N	\N	f	Sales which are qualified	0
80481_8000.0_2005-05-01	800000	\N	2005-05-01	80481	\N	\N	f	Sales which are qualified	0
80482_8300.0_2005-06-01	830000	\N	2005-06-01	80482	\N	\N	f	Sales which are qualified	0
80483_8500.0_2005-06-01	850000	\N	2005-06-01	80483	\N	\N	f	Sales which are qualified	0
80484_6950.0_2005-04-01	695000	\N	2005-04-01	80484	\N	\N	f	Sales which are qualified	0
80485_4092.0_2005-06-01	409200	\N	2005-06-01	80485	\N	\N	f	Sales which are qualified	0
80485_5400.0_2009-12-14	540000	\N	2009-12-14	80485	\N	\N	f	Qual by exam of deed	0
80485_5810.0_2011-12-09	581000	\N	2011-12-09	80485	\N	\N	f	Qual by exam of deed	0
80486_4138.5_2005-03-01	413850	\N	2005-03-01	80486	\N	\N	f	Sales which are qualified	0
80486_7000.0_2008-09-08	700000	\N	2008-09-08	80486	\N	\N	f	Sales which are qualified	0
80487_3937.5_2005-04-01	393750	\N	2005-04-01	80487	\N	\N	f	Sales which are qualified	0
80487_6600.0_2005-06-01	660000	\N	2005-06-01	80487	\N	\N	f	Sales which are qualified	0
80488_5600.0_2009-11-23	560000	\N	2009-11-23	80488	\N	\N	f	Qual by exam of deed	0
80488_5750.0_2005-11-01	575000	\N	2005-11-01	80488	\N	\N	f	Sales which are qualified	0
80488_6301.0_2005-02-01	630100	\N	2005-02-01	80488	\N	\N	t	Deeds that include more than one parcel	0
80489_6389.0_2005-02-01	638900	\N	2005-02-01	80489	\N	\N	t	Deeds that include more than one parcel	0
80490_4770.0_2005-02-01	477000	\N	2005-02-01	80490	\N	\N	f	Sales which are qualified	0
80491_4371.0_2005-03-01	437100	\N	2005-03-01	80491	\N	\N	f	Sales which are qualified	0
80493_4464.0_2005-04-01	446400	\N	2005-04-01	80493	\N	\N	f	Sales which are qualified	0
80493_9250.0_2020-11-30	925000	\N	2020-11-30	80493	\N	\N	f	Qual by exam of deed	0
80494_4510.5_2005-05-01	451050	\N	2005-05-01	80494	\N	\N	f	Sales which are qualified	0
80494_5575.0_2010-10-07	557500	\N	2010-10-07	80494	\N	\N	f	Qual by exam of deed	0
80495_13000.0_2013-02-12	1300000	\N	2013-02-12	80495	\N	\N	t	Qual on DOS, multi-parcel sale	0
80495_7800.0_2005-03-01	780000	\N	2005-03-01	80495	\N	\N	f	Sales which are qualified	0
80496_12000.0_2017-03-22	1200000	\N	2017-03-22	80496	\N	\N	f	Qual by exam of deed	0
80496_13400.0_2015-09-18	1340000	\N	2015-09-18	80496	\N	\N	f	Qual by exam of deed	0
80496_6290.0_2005-03-01	629000	\N	2005-03-01	80496	\N	\N	f	Sales which are qualified	0
80497_13240.0_2022-04-14	1324000	\N	2022-04-14	80497	\N	\N	f	Qual by exam of deed	0
80497_7840.0_2005-02-01	784000	\N	2005-02-01	80497	\N	\N	f	Sales which are qualified	0
80498_12000.0_2005-03-01	1200000	\N	2005-03-01	80498	\N	\N	t	Deeds that include more than one parcel	0
80499_11550.0_2018-06-29	1155000	\N	2018-06-29	80499	\N	\N	f	Qual by exam of deed	0
80499_7000.0_2005-03-01	700000	\N	2005-03-01	80499	\N	\N	f	Sales which are qualified	0
80500_4507.0_2005-04-01	450700	\N	2005-04-01	80500	\N	\N	f	Sales which are qualified	0
80500_7750.0_2005-03-01	775000	\N	2005-03-01	80500	\N	\N	f	Sales which are qualified	0
80500_9500.0_2014-05-01	950000	\N	2014-05-01	80500	\N	\N	f	Qual by exam of deed	0
80501_12050.0_2015-05-07	1205000	\N	2015-05-07	80501	\N	\N	f	Qual by exam of deed	0
80501_4551.0_2005-04-01	455100	\N	2005-04-01	80501	\N	\N	f	Sales which are qualified	0
80501_5500.0_2005-03-01	550000	\N	2005-03-01	80501	\N	\N	f	Sales which are qualified	0
80502_12250.0_2017-08-07	1225000	\N	2017-08-07	80502	\N	\N	f	Qual by exam of deed	0
80502_4595.0_2005-04-01	459500	\N	2005-04-01	80502	\N	\N	f	Sales which are qualified	0
80502_8500.0_2006-01-01	850000	\N	2006-01-01	80502	\N	\N	f	Sales which are qualified	0
80503_12000.0_2017-04-24	1200000	\N	2017-04-24	80503	\N	\N	f	Qual by exam of deed	0
80503_4638.0_2005-05-01	463800	\N	2005-05-01	80503	\N	\N	f	Sales which are qualified	0
80503_6390.0_2010-12-21	639000	\N	2010-12-21	80503	\N	\N	f	Qual by exam of deed	0
80503_7625.0_2013-02-20	762500	\N	2013-02-20	80503	\N	\N	f	Qual by exam of deed	0
80503_7885.0_2005-05-01	788500	\N	2005-05-01	80503	\N	\N	f	Sales which are qualified	0
80504_11340.0_2020-07-01	1134000	\N	2020-07-01	80504	\N	\N	f	Qual by exam of deed	0
80504_4682.0_2005-03-01	468200	\N	2005-03-01	80504	\N	\N	f	Sales which are qualified	0
80504_8050.0_2005-03-01	805000	\N	2005-03-01	80504	\N	\N	f	Sales which are qualified	0
80504_8190.0_2013-01-17	819000	\N	2013-01-17	80504	\N	\N	f	Qual by exam of deed	0
80505_4726.0_2005-04-01	472600	\N	2005-04-01	80505	\N	\N	f	Sales which are qualified	0
80506_11000.0_2012-01-28	1100000	\N	2012-01-28	80506	\N	\N	t	Qual on DOS, multi-parcel sale	0
80506_8390.0_2005-03-01	839000	\N	2005-03-01	80506	\N	\N	f	Sales which are qualified	0
80507_8290.0_2005-04-01	829000	\N	2005-04-01	80507	\N	\N	f	Sales which are qualified	0
80508_6270.0_2010-11-30	627000	\N	2010-11-30	80508	\N	\N	f	Qual by exam of deed	0
80508_7900.0_2005-04-01	790000	\N	2005-04-01	80508	\N	\N	f	Sales which are qualified	0
80509_4976.84_2008-09-25	497684	\N	2008-09-25	80509	\N	\N	f	Sales which are qualified	0
80509_6150.0_2009-08-13	615000	\N	2009-08-13	80509	\N	\N	f	Qual by exam of deed	0
80509_7550.0_2005-05-01	755000	\N	2005-05-01	80509	\N	\N	f	Sales which are qualified	0
80510_12500.0_2021-02-22	1250000	\N	2021-02-22	80510	\N	\N	f	Qual by exam of deed	0
80510_13500.0_2014-08-26	1350000	\N	2014-08-26	80510	\N	\N	f	Qual by exam of deed	0
80510_6250.0_2009-10-02	625000	\N	2009-10-02	80510	\N	\N	f	Qual by exam of deed	0
80510_8260.0_2005-05-01	826000	\N	2005-05-01	80510	\N	\N	f	Sales which are qualified	0
80510_9250.0_2005-05-01	925000	\N	2005-05-01	80510	\N	\N	f	Sales which are qualified	0
80511_10000.0_2013-12-23	1000000	\N	2013-12-23	80511	\N	\N	f	Qual by exam of deed	0
80511_7900.0_2005-06-01	790000	\N	2005-06-01	80511	\N	\N	f	Sales which are qualified	0
80512_14000.0_2014-10-08	1400000	\N	2014-10-08	80512	\N	\N	f	Qual by exam of deed	0
80512_5688.0_2005-07-01	568800	\N	2005-07-01	80512	\N	\N	f	Sales which are qualified	0
80513_5990.0_2005-03-01	599000	\N	2005-03-01	80513	\N	\N	f	Sales which are qualified	0
80513_9450.0_2016-01-04	945000	\N	2016-01-04	80513	\N	\N	f	Qual by exam of deed	0
80514_4900.0_2005-04-01	490000	\N	2005-04-01	80514	\N	\N	f	Sales which are qualified	0
80515_4650.0_2005-02-01	465000	\N	2005-02-01	80515	\N	\N	f	Sales which are qualified	0
80516_10490.0_2022-05-03	1049000	\N	2022-05-03	80516	\N	\N	f	Qual by exam of deed	0
80516_5870.0_2005-03-01	587000	\N	2005-03-01	80516	\N	\N	f	Sales which are qualified	0
80517_10700.0_2022-09-13	1070000	\N	2022-09-13	80517	\N	\N	f	Qual by exam of deed	0
80517_4350.0_2010-07-02	435000	\N	2010-07-02	80517	\N	\N	f	Qual by exam of deed	0
80517_5375.0_2011-09-09	537500	\N	2011-09-09	80517	\N	\N	f	Qual by exam of deed	0
80517_6900.0_2005-02-01	690000	\N	2005-02-01	80517	\N	\N	f	Sales which are qualified	0
80517_9100.0_2015-01-29	910000	\N	2015-01-29	80517	\N	\N	f	Qual by exam of deed	0
80517_9500.0_2021-04-20	950000	\N	2021-04-20	80517	\N	\N	f	Qual by exam of deed	0
80518_6200.0_2005-03-01	620000	\N	2005-03-01	80518	\N	\N	f	Sales which are qualified	0
80518_6250.0_2005-02-01	625000	\N	2005-02-01	80518	\N	\N	f	Sales which are qualified	0
80519_6250.0_2005-02-01	625000	\N	2005-02-01	80519	\N	\N	f	Sales which are qualified	0
80520_7000.0_2005-03-01	700000	\N	2005-03-01	80520	\N	\N	f	Sales which are qualified	0
80521_7000.0_2005-02-01	700000	\N	2005-02-01	80521	\N	\N	f	Sales which are qualified	0
80521_8630.0_2013-12-27	863000	\N	2013-12-27	80521	\N	\N	f	Qual by exam of deed	0
80522_6120.0_2005-03-01	612000	\N	2005-03-01	80522	\N	\N	f	Sales which are qualified	0
80522_6550.0_2012-03-02	655000	\N	2012-03-02	80522	\N	\N	f	Qual by exam of deed	0
80523_10300.0_2016-05-26	1030000	\N	2016-05-26	80523	\N	\N	f	Qual by exam of deed	0
80523_6500.0_2005-03-01	650000	\N	2005-03-01	80523	\N	\N	f	Sales which are qualified	0
80524_6550.0_2005-02-01	655000	\N	2005-02-01	80524	\N	\N	f	Sales which are qualified	0
80524_6550.0_2012-10-03	655000	\N	2012-10-03	80524	\N	\N	f	Qual by exam of deed	0
80524_8750.0_2013-08-14	875000	\N	2013-08-14	80524	\N	\N	f	Qual by exam of deed	0
80525_4770.0_2005-05-01	477000	\N	2005-05-01	80525	\N	\N	f	Sales which are qualified	0
80525_7130.0_2005-06-01	713000	\N	2005-06-01	80525	\N	\N	f	Sales which are qualified	0
80525_8000.0_2005-12-01	800000	\N	2005-12-01	80525	\N	\N	f	Sales which are qualified	0
80526_6400.0_2005-03-01	640000	\N	2005-03-01	80526	\N	\N	f	Sales which are qualified	0
80527_11000.0_2021-05-21	1100000	\N	2021-05-21	80527	\N	\N	f	Qual by exam of deed	0
80527_6700.0_2005-02-01	670000	\N	2005-02-01	80527	\N	\N	f	Sales which are qualified	0
80528_7000.0_2005-03-01	700000	\N	2005-03-01	80528	\N	\N	f	Sales which are qualified	0
80529_6540.0_2005-04-01	654000	\N	2005-04-01	80529	\N	\N	f	Sales which are qualified	0
80530_11000.0_2005-04-01	1100000	\N	2005-04-01	80530	\N	\N	t	Deeds that include more than one parcel	0
80530_13500.0_2013-01-03	1350000	\N	2013-01-03	80530	\N	\N	t	Qual on DOS, multi-parcel sale	0
80530_17000.0_2021-03-09	1700000	\N	2021-03-09	80530	\N	\N	t	Qual on DOS, multi-parcel sale	0
80530_8400.0_2005-09-01	840000	\N	2005-09-01	80530	\N	\N	f	Sales which are qualified	0
80531_7250.0_2005-04-01	725000	\N	2005-04-01	80531	\N	\N	f	Sales which are qualified	0
80532_6000.0_2009-09-04	600000	\N	2009-09-04	80532	\N	\N	f	Qual by exam of deed	0
80532_6450.0_2012-03-14	645000	\N	2012-03-14	80532	\N	\N	f	Qual by exam of deed	0
80532_6950.0_2005-04-01	695000	\N	2005-04-01	80532	\N	\N	f	Sales which are qualified	0
80533_10750.0_2005-04-01	1075000	\N	2005-04-01	80533	\N	\N	f	Sales which are qualified	0
80533_14750.0_2013-12-17	1475000	\N	2013-12-17	80533	\N	\N	t	Qual on DOS, multi-parcel sale	0
80533_7708.0_2007-06-01	770800	\N	2007-06-01	80533	\N	\N	f	Sales which are qualified	0
80534_6250.0_2008-05-01	625000	\N	2008-05-01	80534	\N	\N	f	Sales which are qualified	0
80534_6750.0_2012-01-04	675000	\N	2012-01-04	80534	\N	\N	f	Qual by exam of deed	0
80534_7536.0_2005-04-01	753600	\N	2005-04-01	80534	\N	\N	f	Sales which are qualified	0
80535_7330.0_2005-05-01	733000	\N	2005-05-01	80535	\N	\N	f	Sales which are qualified	0
80535_8000.0_2006-06-01	800000	\N	2006-06-01	80535	\N	\N	f	Sales which are qualified	0
80536_6360.0_2009-10-15	636000	\N	2009-10-15	80536	\N	\N	f	Qual by exam of deed	0
80536_8000.0_2005-05-01	800000	\N	2005-05-01	80536	\N	\N	f	Sales which are qualified	0
80537_7300.0_2005-04-01	730000	\N	2005-04-01	80537	\N	\N	f	Sales which are qualified	0
80537_9900.0_2014-01-24	990000	\N	2014-01-24	80537	\N	\N	f	Qual by exam of deed	0
80538_6210.0_2011-11-15	621000	\N	2011-11-15	80538	\N	\N	f	Qual by exam of deed	0
80538_7330.0_2005-05-01	733000	\N	2005-05-01	80538	\N	\N	f	Sales which are qualified	0
80539_12300.0_2015-03-24	1230000	\N	2015-03-24	80539	\N	\N	f	Qual by exam of deed	0
80539_7330.0_2005-05-01	733000	\N	2005-05-01	80539	\N	\N	f	Sales which are qualified	0
80540_10500.0_2014-07-15	1050000	\N	2014-07-15	80540	\N	\N	f	Qual by exam of deed	0
80540_7273.2_2005-07-01	727320	\N	2005-07-01	80540	\N	\N	f	Sales which are qualified	0
80540_8500.0_2006-12-01	850000	\N	2006-12-01	80540	\N	\N	t	Deeds that include more than one parcel	0
80541_3900.0_2005-04-01	390000	\N	2005-04-01	80541	\N	\N	f	Sales which are qualified	0
80542_2325.0_2005-04-01	232500	\N	2005-04-01	80542	\N	\N	f	Sales which are qualified	0
80542_3100.0_2014-04-09	310000	\N	2014-04-09	80542	\N	\N	f	Qual by exam of deed	0
80542_6000.0_2014-06-05	600000	\N	2014-06-05	80542	\N	\N	f	Qual by exam of deed	0
80543_2371.5_2005-04-01	237150	\N	2005-04-01	80543	\N	\N	f	Sales which are qualified	0
80544_2270.0_2005-04-01	227000	\N	2005-04-01	80544	\N	\N	f	Sales which are qualified	0
80544_3850.0_2007-10-01	385000	\N	2007-10-01	80544	\N	\N	f	Sales which are qualified	0
80544_5800.0_2014-10-15	580000	\N	2014-10-15	80544	\N	\N	f	Qual by exam of deed	0
80545_2950.0_2010-09-14	295000	\N	2010-09-14	80545	\N	\N	f	Qual by exam of deed	0
80545_5200.0_2005-11-01	520000	\N	2005-11-01	80545	\N	\N	f	Sales which are qualified	0
80545_6250.0_2006-05-01	625000	\N	2006-05-01	80545	\N	\N	f	Sales which are qualified	0
80545_6301.0_2005-02-01	630100	\N	2005-02-01	80545	\N	\N	t	Deeds that include more than one parcel	0
80546_6389.0_2005-02-01	638900	\N	2005-02-01	80546	\N	\N	t	Deeds that include more than one parcel	0
80547_2475.0_2005-02-01	247500	\N	2005-02-01	80547	\N	\N	f	Sales which are qualified	0
80547_7150.0_2021-12-16	715000	\N	2021-12-16	80547	\N	\N	f	Qual by exam of deed	0
80548_2604.0_2005-04-01	260400	\N	2005-04-01	80548	\N	\N	f	Sales which are qualified	0
80548_3350.0_2009-12-08	335000	\N	2009-12-08	80548	\N	\N	f	Qual by exam of deed	0
80548_4100.0_2005-04-01	410000	\N	2005-04-01	80548	\N	\N	f	Sales which are qualified	0
80548_5750.0_2006-05-01	575000	\N	2006-05-01	80548	\N	\N	f	Sales which are qualified	0
80549_2650.5_2005-03-01	265050	\N	2005-03-01	80549	\N	\N	f	Sales which are qualified	0
80549_7230.0_2021-10-07	723000	\N	2021-10-07	80549	\N	\N	f	Qual by exam of deed	0
80550_2980.0_2005-03-01	298000	\N	2005-03-01	80550	\N	\N	f	Sales which are qualified	0
80550_4450.0_2006-09-01	445000	\N	2006-09-01	80550	\N	\N	f	Sales which are qualified	0
80550_5200.0_2014-05-01	520000	\N	2014-05-01	80550	\N	\N	f	Qual by exam of deed	0
80551_3230.0_2005-02-01	323000	\N	2005-02-01	80551	\N	\N	f	Sales which are qualified	0
80551_3475.0_2011-04-30	347500	\N	2011-04-30	80551	\N	\N	f	Qual by exam of deed	0
80552_13000.0_2013-02-12	1300000	\N	2013-02-12	80552	\N	\N	t	Qual on DOS, multi-parcel sale	0
80552_3500.0_2005-03-01	350000	\N	2005-03-01	80552	\N	\N	f	Sales which are qualified	0
80552_5150.0_2007-08-01	515000	\N	2007-08-01	80552	\N	\N	f	Sales which are qualified	0
80553_3500.0_2005-02-25	350000	\N	2005-02-25	80553	\N	\N	f	Sales which are qualified	0
80554_3500.0_2005-03-01	350000	\N	2005-03-01	80554	\N	\N	f	Sales which are qualified	0
80554_3900.0_2008-12-31	390000	\N	2008-12-31	80554	\N	\N	f	Sales which are qualified	0
80554_4550.0_2006-07-01	455000	\N	2006-07-01	80554	\N	\N	f	Sales which are qualified	0
80555_12000.0_2005-03-01	1200000	\N	2005-03-01	80555	\N	\N	t	Deeds that include more than one parcel	0
80556_3950.0_2005-03-01	395000	\N	2005-03-01	80556	\N	\N	f	Sales which are qualified	0
80556_7400.0_2018-06-18	740000	\N	2018-06-18	80556	\N	\N	f	Qual by exam of deed	0
80557_4227.5_2005-05-01	422750	\N	2005-05-01	80557	\N	\N	f	Sales which are qualified	0
80557_6200.0_2014-06-04	620000	\N	2014-06-04	80557	\N	\N	f	Qual by exam of deed	0
80558_3700.0_2005-03-01	370000	\N	2005-03-01	80558	\N	\N	f	Sales which are qualified	0
80558_4660.0_2005-06-01	466000	\N	2005-06-01	80558	\N	\N	f	Sales which are qualified	0
80558_5700.0_2006-01-01	570000	\N	2006-01-01	80558	\N	\N	f	Sales which are qualified	0
80558_6750.0_2015-05-07	675000	\N	2015-05-07	80558	\N	\N	f	Qual by exam of deed	0
80559_3750.0_2005-04-01	375000	\N	2005-04-01	80559	\N	\N	f	Sales which are qualified	0
80559_4395.0_2005-04-01	439500	\N	2005-04-01	80559	\N	\N	f	Sales which are qualified	0
80560_4227.5_2005-05-01	422750	\N	2005-05-01	80560	\N	\N	f	Sales which are qualified	0
80560_7200.0_2022-05-23	720000	\N	2022-05-23	80560	\N	\N	f	Qual by exam of deed	0
80561_3220.0_2005-03-01	322000	\N	2005-03-01	80561	\N	\N	f	Sales which are qualified	0
80561_4430.0_2012-11-29	443000	\N	2012-11-29	80561	\N	\N	f	Qual by exam of deed	0
80561_5188.53_2005-07-01	518853	\N	2005-07-01	80561	\N	\N	f	Sales which are qualified	0
80561_5650.0_2005-08-01	565000	\N	2005-08-01	80561	\N	\N	f	Sales which are qualified	0
80562_3800.0_2010-02-19	380000	\N	2010-02-19	80562	\N	\N	f	Qual by exam of deed	0
80562_4400.0_2005-05-09	440000	\N	2005-05-09	80562	\N	\N	f	Sales which are disqualified as a result of examination of the deed	0
80563_11000.0_2012-01-28	1100000	\N	2012-01-28	80563	\N	\N	t	Qual on DOS, multi-parcel sale	0
80563_4790.0_2005-03-01	479000	\N	2005-03-01	80563	\N	\N	f	Sales which are qualified	0
80564_4650.0_2005-04-01	465000	\N	2005-04-01	80564	\N	\N	f	Sales which are qualified	0
80565_3230.0_2010-11-30	323000	\N	2010-11-30	80565	\N	\N	f	Qual by exam of deed	0
80565_4300.0_2005-04-01	430000	\N	2005-04-01	80565	\N	\N	f	Sales which are qualified	0
80566_10000.0_2018-01-08	1000000	\N	2018-01-08	80566	\N	\N	f	Qual by exam of deed	0
80566_4150.0_2005-04-01	415000	\N	2005-04-01	80566	\N	\N	f	Sales which are qualified	0
80567_3650.0_2010-11-29	365000	\N	2010-11-29	80567	\N	\N	f	Qual by exam of deed	0
80567_4350.0_2005-05-01	435000	\N	2005-05-01	80567	\N	\N	f	Sales which are qualified	0
80568_2950.0_2010-04-02	295000	\N	2010-04-02	80568	\N	\N	f	Qual by exam of deed	0
80568_3900.0_2005-06-01	390000	\N	2005-06-01	80568	\N	\N	f	Sales which are qualified	0
80568_4400.0_2012-04-18	440000	\N	2012-04-18	80568	\N	\N	f	Qual by exam of deed	0
80569_4650.0_2005-06-01	465000	\N	2005-06-01	80569	\N	\N	f	Sales which are qualified	0
80569_4800.0_2013-02-28	480000	\N	2013-02-28	80569	\N	\N	f	Qual by exam of deed	0
80570_2400.0_2005-02-01	240000	\N	2005-02-01	80570	\N	\N	f	Sales which are qualified	0
80570_6250.0_2019-11-26	625000	\N	2019-11-26	80570	\N	\N	f	Qual by exam of deed	0
80570_6800.0_2022-03-15	680000	\N	2022-03-15	80570	\N	\N	f	Qual by exam of deed	0
80571_3550.0_2012-04-16	355000	\N	2012-04-16	80571	\N	\N	f	Qual by exam of deed	0
80571_3990.0_2005-03-01	399000	\N	2005-03-01	80571	\N	\N	f	Sales which are qualified	0
80571_4400.0_2013-05-30	440000	\N	2013-05-30	80571	\N	\N	f	Qual by exam of deed	0
80572_2550.0_2005-02-01	255000	\N	2005-02-01	80572	\N	\N	f	Sales which are qualified	0
80573_2897.5_2005-03-01	289750	\N	2005-03-01	80573	\N	\N	f	Sales which are qualified	0
80573_3150.0_2011-07-19	315000	\N	2011-07-19	80573	\N	\N	f	Qual by exam of deed	0
80573_3750.0_2005-02-01	375000	\N	2005-02-01	80573	\N	\N	f	Sales which are qualified	0
80574_3000.0_2005-02-01	300000	\N	2005-02-01	80574	\N	\N	f	Sales which are qualified	0
80575_2700.0_2005-02-01	270000	\N	2005-02-01	80575	\N	\N	f	Sales which are qualified	0
80575_7300.0_2022-03-23	730000	\N	2022-03-23	80575	\N	\N	f	Qual by exam of deed	0
80576_2470.0_2005-03-01	247000	\N	2005-03-01	80576	\N	\N	f	Sales which are qualified	0
80576_4822.0_2013-07-05	482200	\N	2013-07-05	80576	\N	\N	f	Qual by exam of deed	0
80576_6300.0_2021-08-26	630000	\N	2021-08-26	80576	\N	\N	f	Qual by exam of deed	0
80577_7000.0_2005-03-01	700000	\N	2005-03-01	80577	\N	\N	f	Sales which are qualified	0
80578_2650.5_2005-06-01	265050	\N	2005-06-01	80578	\N	\N	f	Sales which are qualified	0
80578_3880.0_2012-05-09	388000	\N	2012-05-09	80578	\N	\N	f	Qual by exam of deed	0
80578_4750.0_2005-06-01	475000	\N	2005-06-01	80578	\N	\N	f	Sales which are qualified	0
80579_2557.5_2005-05-01	255750	\N	2005-05-01	80579	\N	\N	f	Sales which are qualified	0
80579_4900.0_2005-10-01	490000	\N	2005-10-01	80579	\N	\N	f	Sales which are qualified	0
80580_2604.0_2005-03-01	260400	\N	2005-03-01	80580	\N	\N	f	Sales which are qualified	0
80580_5200.0_2005-12-01	520000	\N	2005-12-01	80580	\N	\N	f	Sales which are qualified	0
80581_2650.0_2005-03-01	265000	\N	2005-03-01	80581	\N	\N	f	Sales which are qualified	0
80581_4300.0_2007-05-01	430000	\N	2007-05-01	80581	\N	\N	f	Sales which are qualified	0
80582_2668.0_2005-05-01	266800	\N	2005-05-01	80582	\N	\N	f	Sales which are qualified	0
80583_2883.0_2005-03-01	288300	\N	2005-03-01	80583	\N	\N	f	Sales which are qualified	0
80583_3100.0_2010-02-10	310000	\N	2010-02-10	80583	\N	\N	f	Qual by exam of deed	0
80583_5100.0_2005-11-01	510000	\N	2005-11-01	80583	\N	\N	f	Sales which are qualified	0
80584_2898.0_2005-05-01	289800	\N	2005-05-01	80584	\N	\N	f	Sales which are qualified	0
80585_3700.0_2005-05-01	370000	\N	2005-05-01	80585	\N	\N	f	Sales which are qualified	0
80585_3850.0_2008-08-29	385000	\N	2008-08-29	80585	\N	\N	f	Sales which are qualified	0
80586_3750.0_2005-04-01	375000	\N	2005-04-01	80586	\N	\N	f	Sales which are qualified	0
80586_6150.0_2014-06-17	615000	\N	2014-06-17	80586	\N	\N	f	Qual by exam of deed	0
80587_11000.0_2005-04-01	1100000	\N	2005-04-01	80587	\N	\N	t	Deeds that include more than one parcel	0
80587_13500.0_2013-01-03	1350000	\N	2013-01-03	80587	\N	\N	t	Qual on DOS, multi-parcel sale	0
80587_17000.0_2021-03-09	1700000	\N	2021-03-09	80587	\N	\N	t	Qual on DOS, multi-parcel sale	0
80587_7000.0_2005-09-01	700000	\N	2005-09-01	80587	\N	\N	f	Sales which are qualified	0
80588_4250.0_2005-04-01	425000	\N	2005-04-01	80588	\N	\N	f	Sales which are qualified	0
80588_7690.0_2015-04-30	769000	\N	2015-04-30	80588	\N	\N	f	Qual by exam of deed	0
80589_4150.0_2005-03-01	415000	\N	2005-03-01	80589	\N	\N	f	Sales which are qualified	0
80589_4500.0_2007-08-01	450000	\N	2007-08-01	80589	\N	\N	f	Sales which are qualified	0
80589_5140.0_2013-07-15	514000	\N	2013-07-15	80589	\N	\N	f	Qual by exam of deed	0
80590_10750.0_2005-04-01	1075000	\N	2005-04-01	80590	\N	\N	f	Sales which are qualified	0
80590_14750.0_2013-12-17	1475000	\N	2013-12-17	80590	\N	\N	t	Qual on DOS, multi-parcel sale	0
80590_4042.0_2007-06-01	404200	\N	2007-06-01	80590	\N	\N	f	Sales which are qualified	0
80591_1000.0_2005-06-01	100000	\N	2005-06-01	80591	\N	\N	f	Sales which are qualified	0
80592_3750.0_2005-04-01	375000	\N	2005-04-01	80592	\N	\N	f	Sales which are qualified	0
80593_3000.0_2009-10-15	300000	\N	2009-10-15	80593	\N	\N	f	Qual by exam of deed	0
80593_4500.0_2005-05-01	450000	\N	2005-05-01	80593	\N	\N	f	Sales which are qualified	0
80594_3700.0_2009-01-30	370000	\N	2009-01-30	80594	\N	\N	f	Qual by exam of deed	0
80594_4000.0_2005-04-01	400000	\N	2005-04-01	80594	\N	\N	f	Sales which are qualified	0
80594_4050.0_2012-04-17	405000	\N	2012-04-17	80594	\N	\N	f	Qual by exam of deed	0
80595_4350.0_2005-05-01	435000	\N	2005-05-01	80595	\N	\N	f	Sales which are qualified	0
80597_3579.6_2005-07-01	357960	\N	2005-07-01	80597	\N	\N	f	Sales which are qualified	0
80597_6500.0_2014-07-15	650000	\N	2014-07-15	80597	\N	\N	f	Qual by exam of deed	0
80597_8500.0_2006-12-01	850000	\N	2006-12-01	80597	\N	\N	t	Deeds that include more than one parcel	0
80598_14250.0_2013-10-31	1425000	\N	2013-10-31	80598	\N	\N	t	Qual on DOS, multi-parcel sale	0
80598_4000.0_2005-04-01	400000	\N	2005-04-01	80598	\N	\N	f	Sales which are qualified	0
80599_3900.0_2005-02-01	390000	\N	2005-02-01	80599	\N	\N	f	Sales which are qualified	0
80600_2800.0_2005-02-01	280000	\N	2005-02-01	80600	\N	\N	f	Sales which are qualified	0
80601_2650.0_2005-02-01	265000	\N	2005-02-01	80601	\N	\N	f	Sales which are qualified	0
80602_2660.0_2005-05-01	266000	\N	2005-05-01	80602	\N	\N	f	Sales which are qualified	0
80602_3250.0_2010-03-29	325000	\N	2010-03-29	80602	\N	\N	f	Qual by exam of deed	0
80605_2950.0_2005-02-01	295000	\N	2005-02-01	80605	\N	\N	f	Sales which are qualified	0
80608_2976.0_2005-03-01	297600	\N	2005-03-01	80608	\N	\N	f	Sales which are qualified	0
80610_2880.0_2005-03-01	288000	\N	2005-03-01	80610	\N	\N	f	Sales which are qualified	0
80610_3300.0_2009-12-01	330000	\N	2009-12-01	80610	\N	\N	f	Qual by exam of deed	0
80611_10750.0_2005-03-01	1075000	\N	2005-03-01	80611	\N	\N	t	Deeds that include more than one parcel	0
80611_5590.0_2005-08-01	559000	\N	2005-08-01	80611	\N	\N	f	Sales which are qualified	0
80612_3500.0_2005-04-01	350000	\N	2005-04-01	80612	\N	\N	f	Sales which are qualified	0
80613_3515.0_2005-05-01	351500	\N	2005-05-01	80613	\N	\N	f	Sales which are qualified	0
80613_3950.0_2011-10-03	395000	\N	2011-10-03	80613	\N	\N	f	Qual by exam of deed	0
80614_4270.0_2005-02-01	427000	\N	2005-02-01	80614	\N	\N	f	Sales which are qualified	0
80614_7000.0_2020-10-20	700000	\N	2020-10-20	80614	\N	\N	f	Qual by exam of deed	0
80615_3420.0_2005-03-01	342000	\N	2005-03-01	80615	\N	\N	f	Sales which are qualified	0
80615_5000.0_2005-05-01	500000	\N	2005-05-01	80615	\N	\N	f	Sales which are qualified	0
80615_7200.0_2017-06-20	720000	\N	2017-06-20	80615	\N	\N	f	Qual by exam of deed	0
80616_4310.0_2005-03-01	431000	\N	2005-03-01	80616	\N	\N	f	Sales which are qualified	0
80617_4220.0_2005-03-01	422000	\N	2005-03-01	80617	\N	\N	f	Sales which are qualified	0
80617_4600.0_2005-04-01	460000	\N	2005-04-01	80617	\N	\N	f	Sales which are qualified	0
80618_4350.0_2005-04-01	435000	\N	2005-04-01	80618	\N	\N	f	Sales which are qualified	0
80619_3650.0_2010-09-02	365000	\N	2010-09-02	80619	\N	\N	f	Qual by exam of deed	0
80619_3950.0_2005-04-01	395000	\N	2005-04-01	80619	\N	\N	f	Sales which are qualified	0
80620_21000.0_2015-04-01	2100000	\N	2015-04-01	80620	\N	\N	t	Qual on DOS, multi-parcel sale	0
80620_5000.0_2005-04-01	500000	\N	2005-04-01	80620	\N	\N	f	Sales which are qualified	0
80621_4300.0_2005-04-01	430000	\N	2005-04-01	80621	\N	\N	f	Sales which are qualified	0
80621_5947.5_2005-06-01	594750	\N	2005-06-01	80621	\N	\N	f	Sales which are qualified	0
80623_12250.0_2012-03-14	1225000	\N	2012-03-14	80623	\N	\N	t	Qual on DOS, multi-parcel sale	0
80623_12380.0_2005-05-01	1238000	\N	2005-05-01	80623	\N	\N	t	Deeds that include more than one parcel	0
80623_18050.0_2014-09-17	1805000	\N	2014-09-17	80623	\N	\N	t	Qual on DOS, multi-parcel sale	0
80624_3900.0_2005-05-01	390000	\N	2005-05-01	80624	\N	\N	f	Sales which are qualified	0
80624_7800.0_2016-01-11	780000	\N	2016-01-11	80624	\N	\N	f	Qual by exam of deed	0
80624_9300.0_2023-07-28	930000	\N	2023-07-28	80624	\N	\N	f	Qual by exam of deed	0
80625_2930.0_2010-06-17	293000	\N	2010-06-17	80625	\N	\N	f	Qual by exam of deed	0
80625_3579.6_2005-07-01	357960	\N	2005-07-01	80625	\N	\N	f	Sales which are qualified	0
80626_3500.0_2005-03-01	350000	\N	2005-03-01	80626	\N	\N	f	Sales which are qualified	0
80626_6250.0_2014-11-14	625000	\N	2014-11-14	80626	\N	\N	f	Qual by exam of deed	0
80627_8680.0_2005-03-01	868000	\N	2005-03-01	80627	\N	\N	t	Deeds that include more than one parcel	0
80628_3185.0_2005-02-01	318500	\N	2005-02-01	80628	\N	\N	f	Sales which are qualified	0
80628_7200.0_2022-04-05	720000	\N	2022-04-05	80628	\N	\N	f	Qual by exam of deed	0
80629_3100.0_2005-02-01	310000	\N	2005-02-01	80629	\N	\N	f	Sales which are qualified	0
80630_3140.0_2005-02-01	314000	\N	2005-02-01	80630	\N	\N	f	Sales which are qualified	0
80631_7300.0_2005-02-01	730000	\N	2005-02-01	80631	\N	\N	t	Deeds that include more than one parcel	0
80632_2750.0_2012-04-26	275000	\N	2012-04-26	80632	\N	\N	f	Qual by exam of deed	0
80632_3160.0_2005-02-01	316000	\N	2005-02-01	80632	\N	\N	f	Sales which are qualified	0
80632_3850.0_2007-05-01	385000	\N	2007-05-01	80632	\N	\N	f	Sales which are qualified	0
80632_3935.0_2005-02-01	393500	\N	2005-02-01	80632	\N	\N	f	Sales which are qualified	0
80633_3135.0_2005-03-01	313500	\N	2005-03-01	80633	\N	\N	f	Sales which are qualified	0
80633_4600.0_2005-06-01	460000	\N	2005-06-01	80633	\N	\N	f	Sales which are qualified	0
80634_2950.0_2005-03-01	295000	\N	2005-03-01	80634	\N	\N	f	Sales which are qualified	0
80634_3800.0_2007-12-01	380000	\N	2007-12-01	80634	\N	\N	f	Sales which are qualified	0
80635_2557.5_2005-05-01	255750	\N	2005-05-01	80635	\N	\N	f	Sales which are qualified	0
80635_4400.0_2005-05-01	440000	\N	2005-05-01	80635	\N	\N	f	Sales which are qualified	0
80635_4900.0_2013-07-28	490000	\N	2013-07-28	80635	\N	\N	f	Qual by exam of deed	0
80636_2604.0_2005-03-01	260400	\N	2005-03-01	80636	\N	\N	f	Sales which are qualified	0
80637_12000.0_2013-10-31	1200000	\N	2013-10-31	80637	\N	\N	t	Qual on DOS, multi-parcel sale	0
80637_21300.0_2015-05-07	2130000	\N	2015-05-07	80637	\N	\N	t	Qual on DOS, multi-parcel sale	0
80637_3465.0_2005-02-01	346500	\N	2005-02-01	80637	\N	\N	f	Sales which are qualified	0
80637_3920.0_2008-06-01	392000	\N	2008-06-01	80637	\N	\N	f	Sales which are qualified	0
80637_7150.0_2017-04-27	715000	\N	2017-04-27	80637	\N	\N	f	Qual by exam of deed	0
80638_9950.0_2005-03-01	995000	\N	2005-03-01	80638	\N	\N	t	Deeds that include more than one parcel	0
80639_3400.0_2011-10-17	340000	\N	2011-10-17	80639	\N	\N	f	Qual by exam of deed	0
80639_3420.0_2005-02-01	342000	\N	2005-02-01	80639	\N	\N	f	Sales which are qualified	0
80640_2898.0_2005-05-01	289800	\N	2005-05-01	80640	\N	\N	f	Sales which are qualified	0
80641_4000.0_2005-03-01	400000	\N	2005-03-01	80641	\N	\N	f	Sales which are qualified	0
80642_3500.0_2005-03-01	350000	\N	2005-03-01	80642	\N	\N	f	Sales which are qualified	0
80642_5000.0_2005-11-01	500000	\N	2005-11-01	80642	\N	\N	f	Sales which are qualified	0
80642_7900.0_2016-10-25	790000	\N	2016-10-25	80642	\N	\N	f	Qual by exam of deed	0
80643_10450.0_2005-04-01	1045000	\N	2005-04-01	80643	\N	\N	t	Deeds that include more than one parcel	0
80643_6500.0_2014-10-14	650000	\N	2014-10-14	80643	\N	\N	f	Qual by exam of deed	0
80644_3657.5_2005-03-01	365750	\N	2005-03-01	80644	\N	\N	f	Sales which are qualified	0
80645_4170.0_2005-03-01	417000	\N	2005-03-01	80645	\N	\N	f	Sales which are qualified	0
80645_6500.0_2013-11-08	650000	\N	2013-11-08	80645	\N	\N	f	Qual by exam of deed	0
80646_3710.0_2005-03-01	371000	\N	2005-03-01	80646	\N	\N	f	Sales which are qualified	0
80646_7870.0_2016-04-28	787000	\N	2016-04-28	80646	\N	\N	f	Qual by exam of deed	0
80647_4000.0_2005-04-01	400000	\N	2005-04-01	80647	\N	\N	f	Sales which are qualified	0
80647_4200.0_2007-05-01	420000	\N	2007-05-01	80647	\N	\N	f	Sales which are qualified	0
80647_4200.0_2012-04-18	420000	\N	2012-04-18	80647	\N	\N	f	Qual by exam of deed	0
80647_5050.0_2013-06-24	505000	\N	2013-06-24	80647	\N	\N	f	Qual by exam of deed	0
80648_4410.0_2005-05-01	441000	\N	2005-05-01	80648	\N	\N	f	Sales which are qualified	0
80649_3800.0_2005-04-01	380000	\N	2005-04-01	80649	\N	\N	f	Sales which are qualified	0
80649_7800.0_2016-03-30	780000	\N	2016-03-30	80649	\N	\N	f	Qual by exam of deed	0
80650_4270.0_2005-05-01	427000	\N	2005-05-01	80650	\N	\N	f	Sales which are qualified	0
80651_4280.0_2005-06-01	428000	\N	2005-06-01	80651	\N	\N	f	Sales which are qualified	0
80651_9450.0_2010-05-18	945000	\N	2010-05-18	80651	\N	\N	t	Qual on DOS, multi-parcel sale	0
80652_4050.0_2005-06-01	405000	\N	2005-06-01	80652	\N	\N	f	Sales which are qualified	0
80653_12000.0_2007-07-01	1200000	\N	2007-07-01	80653	\N	\N	t	Deeds that include more than one parcel	0
80653_3579.6_2005-07-01	357960	\N	2005-07-01	80653	\N	\N	f	Sales which are qualified	0
80653_6750.0_2014-06-06	675000	\N	2014-06-06	80653	\N	\N	f	Qual by exam of deed	0
80654_14250.0_2013-10-31	1425000	\N	2013-10-31	80654	\N	\N	t	Qual on DOS, multi-parcel sale	0
80654_6850.0_2005-04-01	685000	\N	2005-04-01	80654	\N	\N	f	Sales which are qualified	0
80655_6700.0_2005-02-01	670000	\N	2005-02-01	80655	\N	\N	f	Sales which are qualified	0
80656_4600.0_2005-02-01	460000	\N	2005-02-01	80656	\N	\N	f	Sales which are qualified	0
80657_4550.0_2005-02-01	455000	\N	2005-02-01	80657	\N	\N	f	Sales which are qualified	0
80657_6600.0_2008-11-21	660000	\N	2008-11-21	80657	\N	\N	f	Sales which are qualified	0
80658_4300.0_2005-03-01	430000	\N	2005-03-01	80658	\N	\N	f	Sales which are qualified	0
80658_6000.0_2005-03-01	600000	\N	2005-03-01	80658	\N	\N	f	Sales which are qualified	0
80658_6165.0_2009-04-13	616500	\N	2009-04-13	80658	\N	\N	f	Qual by exam of deed	0
80658_6400.0_2012-08-28	640000	\N	2012-08-28	80658	\N	\N	f	Qual by exam of deed	0
80659_6350.0_2005-02-01	635000	\N	2005-02-01	80659	\N	\N	f	Sales which are qualified	0
80660_12125.0_2015-12-18	1212500	\N	2015-12-18	80660	\N	\N	f	Qual by exam of deed	0
80660_6600.0_2005-04-01	660000	\N	2005-04-01	80660	\N	\N	f	Sales which are qualified	0
80660_8400.0_2013-05-20	840000	\N	2013-05-20	80660	\N	\N	f	Qual by exam of deed	0
80661_4607.5_2005-03-01	460750	\N	2005-03-01	80661	\N	\N	f	Sales which are qualified	0
80661_6500.0_2007-05-01	650000	\N	2007-05-01	80661	\N	\N	f	Sales which are qualified	0
80663_10100.0_2018-07-05	1010000	\N	2018-07-05	80663	\N	\N	f	Qual by exam of deed	0
80663_10100.0_2022-05-09	1010000	\N	2022-05-09	80663	\N	\N	f	Qual by exam of deed	0
80663_7000.0_2005-02-01	700000	\N	2005-02-01	80663	\N	\N	f	Sales which are qualified	0
80664_6540.0_2005-04-01	654000	\N	2005-04-01	80664	\N	\N	f	Sales which are qualified	0
80665_10000.0_2018-09-13	1000000	\N	2018-09-13	80665	\N	\N	f	Qual by exam of deed	0
80665_5450.0_2010-10-22	545000	\N	2010-10-22	80665	\N	\N	f	Qual by exam of deed	0
80665_6500.0_2007-10-01	650000	\N	2007-10-01	80665	\N	\N	f	Sales which are qualified	0
80665_6950.0_2005-02-01	695000	\N	2005-02-01	80665	\N	\N	f	Sales which are qualified	0
80665_7500.0_2005-12-01	750000	\N	2005-12-01	80665	\N	\N	f	Sales which are qualified	0
80666_10200.0_2018-08-30	1020000	\N	2018-08-30	80666	\N	\N	f	Qual by exam of deed	0
80666_6200.0_2005-04-01	620000	\N	2005-04-01	80666	\N	\N	f	Sales which are qualified	0
80667_4898.5_2005-04-01	489850	\N	2005-04-01	80667	\N	\N	f	Sales which are qualified	0
80667_6000.0_2010-12-03	600000	\N	2010-12-03	80667	\N	\N	f	Qual by exam of deed	0
80667_7700.0_2005-04-01	770000	\N	2005-04-01	80667	\N	\N	f	Sales which are qualified	0
80668_10750.0_2005-03-01	1075000	\N	2005-03-01	80668	\N	\N	t	Deeds that include more than one parcel	0
80668_7900.0_2006-03-01	790000	\N	2006-03-01	80668	\N	\N	f	Sales which are qualified	0
80669_11125.0_2017-01-05	1112500	\N	2017-01-05	80669	\N	\N	f	Qual by exam of deed	0
80669_7400.0_2005-06-01	740000	\N	2005-06-01	80669	\N	\N	f	Sales which are qualified	0
80670_11260.0_2019-11-14	1126000	\N	2019-11-14	80670	\N	\N	f	Qual by exam of deed	0
80670_6600.0_2008-10-28	660000	\N	2008-10-28	80670	\N	\N	f	Sales which are qualified	0
80670_6900.0_2005-03-01	690000	\N	2005-03-01	80670	\N	\N	f	Sales which are qualified	0
80671_7650.0_2005-03-01	765000	\N	2005-03-01	80671	\N	\N	f	Sales which are qualified	0
80671_8000.0_2005-11-01	800000	\N	2005-11-01	80671	\N	\N	f	Sales which are qualified	0
80672_6850.0_2005-04-01	685000	\N	2005-04-01	80672	\N	\N	f	Sales which are qualified	0
80673_6800.0_2005-03-01	680000	\N	2005-03-01	80673	\N	\N	f	Sales which are qualified	0
80673_7200.0_2006-04-01	720000	\N	2006-04-01	80673	\N	\N	f	Sales which are qualified	0
80674_6650.0_2011-08-01	665000	\N	2011-08-01	80674	\N	\N	f	Qual by exam of deed	0
80674_6850.0_2005-05-01	685000	\N	2005-05-01	80674	\N	\N	f	Sales which are qualified	0
80674_7150.0_2008-01-01	715000	\N	2008-01-01	80674	\N	\N	f	Sales which are qualified	0
80675_6950.0_2005-03-01	695000	\N	2005-03-01	80675	\N	\N	f	Sales which are qualified	0
80676_6500.0_2008-09-02	650000	\N	2008-09-02	80676	\N	\N	f	Sales which are qualified	0
80676_6900.0_2005-03-01	690000	\N	2005-03-01	80676	\N	\N	f	Sales which are qualified	0
80677_21000.0_2015-04-01	2100000	\N	2015-04-01	80677	\N	\N	t	Qual on DOS, multi-parcel sale	0
80677_8000.0_2005-04-01	800000	\N	2005-04-01	80677	\N	\N	f	Sales which are qualified	0
80678_13500.0_2014-04-08	1350000	\N	2014-04-08	80678	\N	\N	f	Qual by exam of deed	0
80678_7150.0_2005-05-01	715000	\N	2005-05-01	80678	\N	\N	f	Sales which are qualified	0
80679_4500.0_2009-12-17	450000	\N	2009-12-17	80679	\N	\N	f	Qual by exam of deed	0
80679_7690.0_2005-05-01	769000	\N	2005-05-01	80679	\N	\N	f	Sales which are qualified	0
80680_12250.0_2012-03-14	1225000	\N	2012-03-14	80680	\N	\N	t	Qual on DOS, multi-parcel sale	0
80680_12380.0_2005-05-01	1238000	\N	2005-05-01	80680	\N	\N	t	Deeds that include more than one parcel	0
80680_18050.0_2014-09-17	1805000	\N	2014-09-17	80680	\N	\N	t	Qual on DOS, multi-parcel sale	0
80681_6685.0_2005-06-01	668500	\N	2005-06-01	80681	\N	\N	f	Sales which are qualified	0
80682_7023.0_2005-07-01	702300	\N	2005-07-01	80682	\N	\N	f	Sales which are qualified	0
80683_3500.0_2010-03-08	350000	\N	2010-03-08	80683	\N	\N	f	Qual by exam of deed	0
80683_6700.0_2005-03-01	670000	\N	2005-03-01	80683	\N	\N	f	Sales which are qualified	0
80684_8680.0_2005-03-01	868000	\N	2005-03-01	80684	\N	\N	t	Deeds that include more than one parcel	0
80685_5100.0_2005-02-01	510000	\N	2005-02-01	80685	\N	\N	f	Sales which are qualified	0
80686_10900.0_2015-12-15	1090000	\N	2015-12-15	80686	\N	\N	f	Qual by exam of deed	0
80686_6485.0_2005-02-01	648500	\N	2005-02-01	80686	\N	\N	f	Sales which are qualified	0
80687_5035.0_2005-03-01	503500	\N	2005-03-01	80687	\N	\N	f	Sales which are qualified	0
80687_8750.0_2020-12-04	875000	\N	2020-12-04	80687	\N	\N	f	Qual by exam of deed	0
80688_7300.0_2005-02-01	730000	\N	2005-02-01	80688	\N	\N	t	Deeds that include more than one parcel	0
80689_4850.0_2011-02-03	485000	\N	2011-02-03	80689	\N	\N	f	Qual by exam of deed	0
80689_5990.0_2005-02-01	599000	\N	2005-02-01	80689	\N	\N	f	Sales which are qualified	0
80689_7600.0_2005-12-01	760000	\N	2005-12-01	80689	\N	\N	f	Sales which are qualified	0
80689_7630.0_2013-08-13	763000	\N	2013-08-13	80689	\N	\N	f	Qual by exam of deed	0
80690_10000.0_2021-10-29	1000000	\N	2021-10-29	80690	\N	\N	f	Qual by exam of deed	0
80690_6350.0_2005-03-01	635000	\N	2005-03-01	80690	\N	\N	f	Sales which are qualified	0
80691_6500.0_2005-03-01	650000	\N	2005-03-01	80691	\N	\N	f	Sales which are qualified	0
80692_6400.0_2005-03-01	640000	\N	2005-03-01	80692	\N	\N	f	Sales which are qualified	0
80693_6000.0_2005-03-01	600000	\N	2005-03-01	80693	\N	\N	f	Sales which are qualified	0
80693_6450.0_2007-10-01	645000	\N	2007-10-01	80693	\N	\N	f	Sales which are qualified	0
80694_10200.0_2019-04-23	1020000	\N	2019-04-23	80694	\N	\N	f	Qual by exam of deed	0
80694_12000.0_2013-10-31	1200000	\N	2013-10-31	80694	\N	\N	t	Qual on DOS, multi-parcel sale	0
80694_21300.0_2015-05-07	2130000	\N	2015-05-07	80694	\N	\N	t	Qual on DOS, multi-parcel sale	0
80694_4851.0_2005-02-01	485100	\N	2005-02-01	80694	\N	\N	f	Sales which are qualified	0
80694_6575.75_2007-02-01	657575	\N	2007-02-01	80694	\N	\N	f	Sales which are qualified	0
80695_9950.0_2005-03-01	995000	\N	2005-03-01	80695	\N	\N	t	Deeds that include more than one parcel	0
80696_6000.0_2011-06-13	600000	\N	2011-06-13	80696	\N	\N	f	Qual by exam of deed	0
80696_7350.0_2005-02-01	735000	\N	2005-02-01	80696	\N	\N	f	Sales which are qualified	0
80697_6550.0_2005-03-01	655000	\N	2005-03-01	80697	\N	\N	f	Sales which are qualified	0
80698_10875.0_2014-07-25	1087500	\N	2014-07-25	80698	\N	\N	f	Qual by exam of deed	0
80698_4200.0_2010-04-20	420000	\N	2010-04-20	80698	\N	\N	f	Qual by exam of deed	0
80698_5850.0_2010-07-19	585000	\N	2010-07-19	80698	\N	\N	f	Qual by exam of deed	0
80698_6250.0_2011-08-19	625000	\N	2011-08-19	80698	\N	\N	f	Qual by exam of deed	0
80698_6750.0_2005-03-01	675000	\N	2005-03-01	80698	\N	\N	f	Sales which are qualified	0
80698_7950.0_2006-03-01	795000	\N	2006-03-01	80698	\N	\N	f	Sales which are qualified	0
80699_12520.0_2018-01-17	1252000	\N	2018-01-17	80699	\N	\N	f	Qual by verifiable & documented evidence	0
80699_6150.0_2005-03-01	615000	\N	2005-03-01	80699	\N	\N	f	Sales which are qualified	0
80699_7500.0_2005-11-01	750000	\N	2005-11-01	80699	\N	\N	f	Sales which are qualified	0
80699_7690.0_2013-05-15	769000	\N	2013-05-15	80699	\N	\N	f	Qual by exam of deed	0
80700_10450.0_2005-04-01	1045000	\N	2005-04-01	80700	\N	\N	t	Deeds that include more than one parcel	0
80700_11490.0_2014-10-14	1149000	\N	2014-10-14	80700	\N	\N	f	Qual by exam of deed	0
80701_6200.0_2010-04-07	620000	\N	2010-04-07	80701	\N	\N	f	Qual by exam of deed	0
80701_7120.0_2005-04-01	712000	\N	2005-04-01	80701	\N	\N	f	Sales which are qualified	0
80701_7170.0_2012-09-21	717000	\N	2012-09-21	80701	\N	\N	f	Qual by exam of deed	0
80702_4500.0_2009-10-30	450000	\N	2009-10-30	80702	\N	\N	f	Qual by exam of deed	0
80702_6350.0_2011-12-12	635000	\N	2011-12-12	80702	\N	\N	f	Qual by exam of deed	0
80702_6800.0_2005-04-01	680000	\N	2005-04-01	80702	\N	\N	f	Sales which are qualified	0
80702_7350.0_2008-01-01	735000	\N	2008-01-01	80702	\N	\N	f	Sales which are qualified	0
80703_6880.0_2005-05-01	688000	\N	2005-05-01	80703	\N	\N	f	Sales which are qualified	0
80704_6750.0_2005-03-01	675000	\N	2005-03-01	80704	\N	\N	f	Sales which are qualified	0
80705_14000.0_2015-09-16	1400000	\N	2015-09-16	80705	\N	\N	f	Qual by exam of deed	0
80705_7320.0_2005-04-01	732000	\N	2005-04-01	80705	\N	\N	f	Sales which are qualified	0
80706_14500.0_2016-03-30	1450000	\N	2016-03-30	80706	\N	\N	f	Qual by exam of deed	0
80706_6950.0_2005-04-01	695000	\N	2005-04-01	80706	\N	\N	f	Sales which are qualified	0
80707_6950.0_2005-04-01	695000	\N	2005-04-01	80707	\N	\N	f	Sales which are qualified	0
80707_7350.0_2011-01-04	735000	\N	2011-01-04	80707	\N	\N	f	Qual by exam of deed	0
80708_9450.0_2010-05-18	945000	\N	2010-05-18	80708	\N	\N	t	Qual on DOS, multi-parcel sale	0
80709_7100.0_2005-06-01	710000	\N	2005-06-01	80709	\N	\N	f	Sales which are qualified	0
80710_11610.0_2014-06-06	1161000	\N	2014-06-06	80710	\N	\N	f	Qual by exam of deed	0
80710_12000.0_2007-07-01	1200000	\N	2007-07-01	80710	\N	\N	t	Deeds that include more than one parcel	0
80710_7022.4_2005-07-01	702240	\N	2005-07-01	80710	\N	\N	f	Sales which are qualified	0
80711_6800.0_2005-02-01	680000	\N	2005-02-01	80711	\N	\N	f	Sales which are qualified	0
80712_4340.0_2011-10-27	434000	\N	2011-10-27	80712	\N	\N	f	Qual by exam of deed	0
80712_6300.0_2005-03-01	630000	\N	2005-03-01	80712	\N	\N	f	Sales which are qualified	0
80713_6100.0_2005-03-01	610000	\N	2005-03-01	80713	\N	\N	f	Sales which are qualified	0
80713_6650.0_2008-08-01	665000	\N	2008-08-01	80713	\N	\N	f	Sales which are qualified	0
80714_6000.0_2005-02-01	600000	\N	2005-02-01	80714	\N	\N	f	Sales which are qualified	0
80714_6800.0_2012-06-05	680000	\N	2012-06-05	80714	\N	\N	f	Qual by exam of deed	0
80715_12050.0_2016-02-04	1205000	\N	2016-02-04	80715	\N	\N	f	Qual by exam of deed	0
80715_6480.0_2005-02-01	648000	\N	2005-02-01	80715	\N	\N	f	Sales which are qualified	0
80715_7550.0_2006-03-01	755000	\N	2006-03-01	80715	\N	\N	f	Sales which are qualified	0
80716_12100.0_2015-04-01	1210000	\N	2015-04-01	80716	\N	\N	f	Qual by exam of deed	0
80716_5023.5_2011-01-14	502350	\N	2011-01-14	80716	\N	\N	f	Qual by exam of deed	0
80716_7450.0_2005-02-01	745000	\N	2005-02-01	80716	\N	\N	f	Sales which are qualified	0
80717_12500.0_2016-05-10	1250000	\N	2016-05-10	80717	\N	\N	f	Qual by exam of deed	0
80717_6100.0_2005-02-01	610000	\N	2005-02-01	80717	\N	\N	f	Sales which are qualified	0
80717_8250.0_2005-09-01	825000	\N	2005-09-01	80717	\N	\N	f	Sales which are qualified	0
80718_5300.0_2005-03-01	530000	\N	2005-03-01	80718	\N	\N	f	Sales which are qualified	0
80718_6500.0_2007-05-01	650000	\N	2007-05-01	80718	\N	\N	f	Sales which are qualified	0
80719_11800.0_2018-02-02	1180000	\N	2018-02-02	80719	\N	\N	f	Qual by exam of deed	0
80719_5450.0_2010-01-12	545000	\N	2010-01-12	80719	\N	\N	f	Qual by exam of deed	0
80719_5795.0_2005-03-01	579500	\N	2005-03-01	80719	\N	\N	f	Sales which are qualified	0
80719_7650.0_2005-11-01	765000	\N	2005-11-01	80719	\N	\N	f	Sales which are qualified	0
80720_14000.0_2016-12-28	1400000	\N	2016-12-28	80720	\N	\N	f	Qual by exam of deed	0
80720_6700.0_2005-02-01	670000	\N	2005-02-01	80720	\N	\N	f	Sales which are qualified	0
80721_7065.0_2005-02-01	706500	\N	2005-02-01	80721	\N	\N	f	Sales which are qualified	0
80721_7350.0_2013-03-07	735000	\N	2013-03-07	80721	\N	\N	f	Qual by exam of deed	0
80722_11000.0_2019-12-18	1100000	\N	2019-12-18	80722	\N	\N	f	Qual by exam of deed	0
80722_5500.0_2005-03-01	550000	\N	2005-03-01	80722	\N	\N	f	Sales which are qualified	0
80722_7950.0_2006-07-01	795000	\N	2006-07-01	80722	\N	\N	f	Sales which are qualified	0
80722_9000.0_2013-11-18	900000	\N	2013-11-18	80722	\N	\N	f	Qual by exam of deed	0
80723_6300.0_2005-03-01	630000	\N	2005-03-01	80723	\N	\N	f	Sales which are qualified	0
80724_6200.0_2005-03-01	620000	\N	2005-03-01	80724	\N	\N	f	Sales which are qualified	0
80725_11113.5_2005-03-01	1111350	\N	2005-03-01	80725	\N	\N	f	Sales which are qualified	0
80725_11500.0_2014-10-14	1150000	\N	2014-10-14	80725	\N	\N	f	Qual by exam of deed	0
80725_8840.0_2014-07-18	884000	\N	2014-07-18	80725	\N	\N	f	Qual by exam of deed	0
80726_11392.5_2005-03-01	1139250	\N	2005-03-01	80726	\N	\N	t	Deeds that include more than one parcel	0
80727_14000.0_2015-07-06	1400000	\N	2015-07-06	80727	\N	\N	f	Qual by exam of deed	0
80727_6507.5_2005-03-01	650750	\N	2005-03-01	80727	\N	\N	f	Sales which are qualified	0
80728_5032.0_2005-03-01	503200	\N	2005-03-01	80728	\N	\N	f	Sales which are qualified	0
80729_21500.0_2021-06-03	2150000	\N	2021-06-03	80729	\N	\N	t	Qual on DOS, multi-parcel sale	0
80729_7929.19_2005-04-01	792919	\N	2005-04-01	80729	\N	\N	t	Deeds that include more than one parcel	0
80730_8250.0_2005-03-01	825000	\N	2005-03-01	80730	\N	\N	t	Deeds that include more than one parcel	0
80731_15000.0_2023-05-05	1500000	\N	2023-05-05	80731	\N	\N	f	Qual by exam of deed	0
80731_5700.0_2005-04-01	570000	\N	2005-04-01	80731	\N	\N	f	Sales which are qualified	0
80732_13500.0_2019-12-18	1350000	\N	2019-12-18	80732	\N	\N	f	Qual by exam of deed	0
80732_5207.0_2005-04-01	520700	\N	2005-04-01	80732	\N	\N	f	Sales which are qualified	0
80733_12500.0_2016-08-31	1250000	\N	2016-08-31	80733	\N	\N	f	Qual by exam of deed	0
80733_6000.0_2005-03-01	600000	\N	2005-03-01	80733	\N	\N	f	Sales which are qualified	0
80733_6400.0_2010-07-28	640000	\N	2010-07-28	80733	\N	\N	f	Qual by exam of deed	0
80734_4875.0_2007-06-01	487500	\N	2007-06-01	80734	\N	\N	f	Sales which are qualified	0
80734_5000.0_2008-04-01	500000	\N	2008-04-01	80734	\N	\N	f	Sales which are qualified	0
80734_5382.0_2005-04-01	538200	\N	2005-04-01	80734	\N	\N	f	Sales which are qualified	0
80735_5426.0_2005-04-01	542600	\N	2005-04-01	80735	\N	\N	f	Sales which are qualified	0
80735_8300.0_2005-04-01	830000	\N	2005-04-01	80735	\N	\N	f	Sales which are qualified	0
80736_5470.0_2005-04-01	547000	\N	2005-04-01	80736	\N	\N	f	Sales which are qualified	0
80737_5514.0_2005-06-01	551400	\N	2005-06-01	80737	\N	\N	f	Sales which are qualified	0
80737_8445.0_2005-09-01	844500	\N	2005-09-01	80737	\N	\N	f	Sales which are qualified	0
80738_5557.0_2005-06-01	555700	\N	2005-06-01	80738	\N	\N	f	Sales which are qualified	0
80739_12500.0_2008-04-04	1250000	\N	2008-04-04	80739	\N	\N	t	Deeds that include more than one parcel	0
80739_3844.95_2005-08-25	384495	\N	2005-08-25	80739	\N	\N	f	Sales which are qualified	0
80740_10750.0_2005-02-01	1075000	\N	2005-02-01	80740	\N	\N	t	Deeds that include more than one parcel	0
80741_6200.0_2005-02-01	620000	\N	2005-02-01	80741	\N	\N	f	Sales which are qualified	0
80741_6500.0_2008-01-01	650000	\N	2008-01-01	80741	\N	\N	f	Sales which are disqualified as a result of examination of the deed	0
80742_6000.0_2005-02-01	600000	\N	2005-02-01	80742	\N	\N	f	Sales which are qualified	0
80743_6600.0_2005-02-01	660000	\N	2005-02-01	80743	\N	\N	f	Sales which are qualified	0
80744_5650.0_2010-03-16	565000	\N	2010-03-16	80744	\N	\N	f	Qual by exam of deed	0
80744_6000.0_2005-02-01	600000	\N	2005-02-01	80744	\N	\N	f	Sales which are qualified	0
80745_11200.0_2009-04-03	1120000	\N	2009-04-03	80745	\N	\N	t	Qual on DOS, multi-parcel sale	0
80745_12000.0_2022-04-21	1200000	\N	2022-04-21	80745	\N	\N	f	Qual by exam of deed	0
80745_6300.0_2005-02-01	630000	\N	2005-02-01	80745	\N	\N	f	Sales which are qualified	0
80746_6550.0_2005-02-01	655000	\N	2005-02-01	80746	\N	\N	f	Sales which are qualified	0
80746_7600.0_2007-06-01	760000	\N	2007-06-01	80746	\N	\N	f	Sales which are qualified	0
80747_5680.0_2005-03-01	568000	\N	2005-03-01	80747	\N	\N	f	Sales which are qualified	0
80747_6500.0_2005-03-01	650000	\N	2005-03-01	80747	\N	\N	f	Sales which are qualified	0
80747_8000.0_2005-04-01	800000	\N	2005-04-01	80747	\N	\N	f	Sales which are qualified	0
80748_11000.0_2014-10-06	1100000	\N	2014-10-06	80748	\N	\N	f	Qual by exam of deed	0
80748_11650.0_2005-03-01	1165000	\N	2005-03-01	80748	\N	\N	f	Sales which are qualified	0
80749_5800.0_2005-04-01	580000	\N	2005-04-01	80749	\N	\N	f	Sales which are qualified	0
80750_11000.0_2014-09-19	1100000	\N	2014-09-19	80750	\N	\N	f	Qual by exam of deed	0
80750_7100.0_2005-03-01	710000	\N	2005-03-01	80750	\N	\N	f	Sales which are qualified	0
80751_11600.0_2005-03-01	1160000	\N	2005-03-01	80751	\N	\N	t	Deeds that include more than one parcel	0
80752_12200.0_2006-06-01	1220000	\N	2006-06-01	80752	\N	\N	t	Deeds that include more than one parcel	0
80752_14000.0_2020-12-30	1400000	\N	2020-12-30	80752	\N	\N	t	Qual on DOS, multi-parcel sale	0
80752_6600.0_2005-03-01	660000	\N	2005-03-01	80752	\N	\N	f	Sales which are qualified	0
80753_5500.0_2005-03-01	550000	\N	2005-03-01	80753	\N	\N	f	Sales which are qualified	0
80754_12700.0_2015-01-14	1270000	\N	2015-01-14	80754	\N	\N	f	Qual by exam of deed	0
80754_6550.0_2005-03-01	655000	\N	2005-03-01	80754	\N	\N	f	Sales which are qualified	0
80755_11800.0_2005-03-01	1180000	\N	2005-03-01	80755	\N	\N	t	Deeds that include more than one parcel	0
80756_12000.0_2019-12-17	1200000	\N	2019-12-17	80756	\N	\N	f	Qual by exam of deed	0
80756_7000.0_2005-03-01	700000	\N	2005-03-01	80756	\N	\N	f	Sales which are qualified	0
80756_8325.0_2006-06-01	832500	\N	2006-06-01	80756	\N	\N	f	Sales which are qualified	0
80757_5800.0_2010-02-26	580000	\N	2010-02-26	80757	\N	\N	f	Qual by exam of deed	0
80757_6965.0_2005-02-01	696500	\N	2005-02-01	80757	\N	\N	f	Sales which are qualified	0
80757_8400.0_2005-07-01	840000	\N	2005-07-01	80757	\N	\N	f	Sales which are qualified	0
80758_12700.0_2015-04-14	1270000	\N	2015-04-14	80758	\N	\N	f	Qual by exam of deed	0
80758_12750.0_2020-03-27	1275000	\N	2020-03-27	80758	\N	\N	f	Qual by exam of deed	0
80758_7702.0_2005-04-01	770200	\N	2005-04-01	80758	\N	\N	t	Deeds that include more than one parcel	0
80758_8900.0_2005-10-01	890000	\N	2005-10-01	80758	\N	\N	f	Sales which are qualified	0
80759_7500.0_2005-03-01	750000	\N	2005-03-01	80759	\N	\N	f	Sales which are qualified	0
80760_7500.0_2005-03-01	750000	\N	2005-03-01	80760	\N	\N	f	Sales which are qualified	0
80761_6100.0_2005-03-01	610000	\N	2005-03-01	80761	\N	\N	f	Sales which are qualified	0
80761_9850.0_2018-12-21	985000	\N	2018-12-21	80761	\N	\N	f	Qual by exam of deed	0
80762_13500.0_2016-05-26	1350000	\N	2016-05-26	80762	\N	\N	f	Qual by exam of deed	0
80762_7320.0_2005-04-01	732000	\N	2005-04-01	80762	\N	\N	f	Sales which are qualified	0
80763_10950.0_2005-06-01	1095000	\N	2005-06-01	80763	\N	\N	t	Deeds that include more than one parcel	0
80763_13650.0_2005-07-01	1365000	\N	2005-07-01	80763	\N	\N	t	Deeds that include more than one parcel	0
80763_18000.0_2014-08-21	1800000	\N	2014-08-21	80763	\N	\N	t	Qual on DOS, multi-parcel sale	0
80763_8000.0_2008-01-01	800000	\N	2008-01-01	80763	\N	\N	f	Sales which are qualified	0
80764_6800.0_2005-04-01	680000	\N	2005-04-01	80764	\N	\N	f	Sales which are qualified	0
80765_3200.0_2010-11-16	320000	\N	2010-11-16	80765	\N	\N	f	Qual by exam of deed	0
80765_7500.0_2005-05-01	750000	\N	2005-05-01	80765	\N	\N	f	Sales which are qualified	0
80765_8800.0_2006-03-01	880000	\N	2006-03-01	80765	\N	\N	f	Sales which are qualified	0
80766_12250.0_2006-11-01	1225000	\N	2006-11-01	80766	\N	\N	t	Deeds that include more than one parcel	0
80766_12500.0_2018-03-02	1250000	\N	2018-03-02	80766	\N	\N	f	Qual by exam of deed	0
80766_6589.2_2005-07-01	658920	\N	2005-07-01	80766	\N	\N	f	Sales which are qualified	0
80767_7700.0_2005-06-01	770000	\N	2005-06-01	80767	\N	\N	f	Sales which are qualified	0
80768_10250.0_2005-05-01	1025000	\N	2005-05-01	80768	\N	\N	t	Deeds that include more than one parcel	0
80768_12650.0_2007-03-01	1265000	\N	2007-03-01	80768	\N	\N	t	Deeds that include more than one parcel	0
80769_3200.0_2005-02-01	320000	\N	2005-02-01	80769	\N	\N	f	Sales which are qualified	0
80770_2950.0_2005-02-01	295000	\N	2005-02-01	80770	\N	\N	f	Sales which are qualified	0
80771_3600.0_2005-02-01	360000	\N	2005-02-01	80771	\N	\N	f	Sales which are qualified	0
80771_5500.0_2005-08-01	550000	\N	2005-08-01	80771	\N	\N	f	Sales which are qualified	0
80771_5800.0_2020-06-15	580000	\N	2020-06-15	80771	\N	\N	f	Qual by exam of deed	0
80772_3800.0_2005-02-01	380000	\N	2005-02-01	80772	\N	\N	f	Sales which are qualified	0
80772_3900.0_2007-09-01	390000	\N	2007-09-01	80772	\N	\N	f	Sales which are qualified	0
80773_3200.0_2005-02-01	320000	\N	2005-02-01	80773	\N	\N	f	Sales which are qualified	0
80774_3700.0_2005-03-01	370000	\N	2005-03-01	80774	\N	\N	f	Sales which are qualified	0
80775_2463.0_2005-02-01	246300	\N	2005-02-01	80775	\N	\N	f	Sales which are qualified	0
80775_4750.0_2005-09-01	475000	\N	2005-09-01	80775	\N	\N	f	Sales which are qualified	0
80775_7500.0_2016-05-10	750000	\N	2016-05-10	80775	\N	\N	f	Qual by exam of deed	0
80776_2890.0_2005-05-01	289000	\N	2005-05-01	80776	\N	\N	f	Sales which are qualified	0
80776_4150.0_2007-04-01	415000	\N	2007-04-01	80776	\N	\N	f	Sales which are qualified	0
80777_3350.0_2005-04-01	335000	\N	2005-04-01	80777	\N	\N	f	Sales which are qualified	0
80778_3200.0_2005-04-01	320000	\N	2005-04-01	80778	\N	\N	f	Sales which are qualified	0
80778_3860.0_2007-03-01	386000	\N	2007-03-01	80778	\N	\N	f	Sales which are qualified	0
80778_4000.0_2012-05-10	400000	\N	2012-05-10	80778	\N	\N	f	Qual by exam of deed	0
80779_3270.0_2005-04-01	327000	\N	2005-04-01	80779	\N	\N	f	Sales which are qualified	0
80780_3300.0_2005-03-01	330000	\N	2005-03-01	80780	\N	\N	f	Sales which are qualified	0
80780_4650.0_2013-11-04	465000	\N	2013-11-04	80780	\N	\N	f	Qual by exam of deed	0
80780_5400.0_2005-09-01	540000	\N	2005-09-01	80780	\N	\N	f	Sales which are qualified	0
80781_3373.0_2005-03-01	337300	\N	2005-03-01	80781	\N	\N	f	Sales which are qualified	0
80782_3250.0_2011-06-15	325000	\N	2011-06-15	80782	\N	\N	f	Qual by exam of deed	0
80782_3800.0_2005-03-01	380000	\N	2005-03-01	80782	\N	\N	f	Sales which are qualified	0
80782_6900.0_2018-08-29	690000	\N	2018-08-29	80782	\N	\N	f	Qual by exam of deed	0
80783_11113.5_2005-03-01	1111350	\N	2005-03-01	80783	\N	\N	f	Sales which are qualified	0
80783_4160.0_2014-07-18	416000	\N	2014-07-18	80783	\N	\N	f	Qual by exam of deed	0
80783_5500.0_2014-10-14	550000	\N	2014-10-14	80783	\N	\N	f	Qual by exam of deed	0
80784_11392.5_2005-03-01	1139250	\N	2005-03-01	80784	\N	\N	t	Deeds that include more than one parcel	0
80785_3940.0_2005-03-01	394000	\N	2005-03-01	80785	\N	\N	f	Sales which are qualified	0
80786_4350.0_2005-04-01	435000	\N	2005-04-01	80786	\N	\N	f	Sales which are qualified	0
80787_21500.0_2021-06-03	2150000	\N	2021-06-03	80787	\N	\N	t	Qual on DOS, multi-parcel sale	0
80787_7929.19_2005-04-01	792919	\N	2005-04-01	80787	\N	\N	t	Deeds that include more than one parcel	0
80788_8250.0_2005-03-01	825000	\N	2005-03-01	80788	\N	\N	t	Deeds that include more than one parcel	0
80789_11000.0_2023-05-05	1100000	\N	2023-05-05	80789	\N	\N	f	Qual by exam of deed	0
80789_2650.0_2005-03-01	265000	\N	2005-03-01	80789	\N	\N	f	Sales which are qualified	0
80790_3100.0_2005-04-01	310000	\N	2005-04-01	80790	\N	\N	f	Sales which are qualified	0
80790_7500.0_2019-12-18	750000	\N	2019-12-18	80790	\N	\N	f	Qual by exam of deed	0
80791_4268.0_2005-04-01	426800	\N	2005-04-01	80791	\N	\N	f	Sales which are qualified	0
80792_3250.0_2007-06-01	325000	\N	2007-06-01	80792	\N	\N	f	Sales which are qualified	0
80792_3579.6_2005-07-01	357960	\N	2005-07-01	80792	\N	\N	f	Sales which are qualified	0
80793_2680.0_2009-12-21	268000	\N	2009-12-21	80793	\N	\N	f	Qual by exam of deed	0
80793_3579.6_2005-07-01	357960	\N	2005-07-01	80793	\N	\N	f	Sales which are qualified	0
80794_3000.0_2006-07-01	300000	\N	2006-07-01	80794	\N	\N	f	Sales which are qualified	0
80794_3579.6_2005-07-01	357960	\N	2005-07-01	80794	\N	\N	f	Sales which are qualified	0
80795_2950.0_2010-09-14	295000	\N	2010-09-14	80795	\N	\N	f	Qual by exam of deed	0
80795_3350.0_2011-05-31	335000	\N	2011-05-31	80795	\N	\N	f	Qual by exam of deed	0
80795_3579.6_2005-07-01	357960	\N	2005-07-01	80795	\N	\N	f	Sales which are qualified	0
80795_4550.0_2006-07-01	455000	\N	2006-07-01	80795	\N	\N	f	Sales which are qualified	0
80796_4050.0_2005-07-01	405000	\N	2005-07-01	80796	\N	\N	f	Sales which are qualified	0
80796_4355.3_2012-06-06	435530	\N	2012-06-06	80796	\N	\N	f	Qual by exam of deed	0
80797_12500.0_2008-04-04	1250000	\N	2008-04-04	80797	\N	\N	t	Deeds that include more than one parcel	0
80797_1771.05_2005-08-25	177105	\N	2005-08-25	80797	\N	\N	f	Sales which are qualified	0
80798_10750.0_2005-02-01	1075000	\N	2005-02-01	80798	\N	\N	t	Deeds that include more than one parcel	0
80799_3050.0_2005-03-01	305000	\N	2005-03-01	80799	\N	\N	f	Sales which are qualified	0
80799_3500.0_2007-11-01	350000	\N	2007-11-01	80799	\N	\N	f	Sales which are qualified	0
80799_7450.0_2016-06-01	745000	\N	2016-06-01	80799	\N	\N	f	Qual by exam of deed	0
80800_3500.0_2005-02-01	350000	\N	2005-02-01	80800	\N	\N	f	Sales which are qualified	0
80800_3600.0_2008-01-01	360000	\N	2008-01-01	80800	\N	\N	f	Sales which are qualified	0
80801_3690.0_2005-02-01	369000	\N	2005-02-01	80801	\N	\N	f	Sales which are qualified	0
80802_2750.0_2005-05-01	275000	\N	2005-05-01	80802	\N	\N	f	Sales which are qualified	0
80802_6100.0_2021-03-29	610000	\N	2021-03-29	80802	\N	\N	f	Qual by exam of deed	0
80803_11200.0_2009-04-03	1120000	\N	2009-04-03	80803	\N	\N	t	Qual on DOS, multi-parcel sale	0
80803_3400.0_2005-02-01	340000	\N	2005-02-01	80803	\N	\N	f	Sales which are qualified	0
80803_7500.0_2022-04-21	750000	\N	2022-04-21	80803	\N	\N	f	Qual by exam of deed	0
80804_2511.0_2005-02-01	251100	\N	2005-02-01	80804	\N	\N	f	Sales which are qualified	0
80804_4750.0_2005-08-01	475000	\N	2005-08-01	80804	\N	\N	f	Sales which are qualified	0
80804_5750.0_2014-06-26	575000	\N	2014-06-26	80804	\N	\N	f	Qual by exam of deed	0
80805_3050.0_2005-03-01	305000	\N	2005-03-01	80805	\N	\N	f	Sales which are qualified	0
80805_4500.0_2005-04-01	450000	\N	2005-04-01	80805	\N	\N	f	Sales which are qualified	0
80806_11650.0_2005-03-01	1165000	\N	2005-03-01	80806	\N	\N	f	Sales which are qualified	0
80806_5500.0_2014-10-06	550000	\N	2014-10-06	80806	\N	\N	f	Qual by exam of deed	0
80807_11600.0_2011-10-25	1160000	\N	2011-10-25	80807	\N	\N	f	Qual by exam of deed	0
80807_3150.0_2005-04-01	315000	\N	2005-04-01	80807	\N	\N	f	Sales which are qualified	0
80808_2836.5_2005-05-01	283650	\N	2005-05-01	80808	\N	\N	f	Sales which are qualified	0
80808_4450.0_2005-05-01	445000	\N	2005-05-01	80808	\N	\N	f	Sales which are qualified	0
80808_8000.0_2023-01-23	800000	\N	2023-01-23	80808	\N	\N	f	Qual by exam of deed	0
80809_11600.0_2005-03-01	1160000	\N	2005-03-01	80809	\N	\N	t	Deeds that include more than one parcel	0
80810_12200.0_2006-06-01	1220000	\N	2006-06-01	80810	\N	\N	t	Deeds that include more than one parcel	0
80810_14000.0_2020-12-30	1400000	\N	2020-12-30	80810	\N	\N	t	Qual on DOS, multi-parcel sale	0
80810_3400.0_2005-03-01	340000	\N	2005-03-01	80810	\N	\N	f	Sales which are qualified	0
80811_3500.0_2005-05-01	350000	\N	2005-05-01	80811	\N	\N	f	Sales which are qualified	0
80812_3650.0_2005-03-01	365000	\N	2005-03-01	80812	\N	\N	f	Sales which are qualified	0
80812_5300.0_2005-11-01	530000	\N	2005-11-01	80812	\N	\N	f	Sales which are qualified	0
80813_11800.0_2005-03-01	1180000	\N	2005-03-01	80813	\N	\N	t	Deeds that include more than one parcel	0
80814_4000.0_2005-03-01	400000	\N	2005-03-01	80814	\N	\N	f	Sales which are qualified	0
80814_4650.0_2006-07-01	465000	\N	2006-07-01	80814	\N	\N	f	Sales which are qualified	0
80814_6500.0_2019-12-17	650000	\N	2019-12-17	80814	\N	\N	f	Qual by exam of deed	0
80815_3700.0_2005-03-01	370000	\N	2005-03-01	80815	\N	\N	f	Sales which are qualified	0
80816_4240.0_2012-12-20	424000	\N	2012-12-20	80816	\N	\N	f	Qual by exam of deed	0
80816_7702.0_2005-04-01	770200	\N	2005-04-01	80816	\N	\N	t	Deeds that include more than one parcel	0
80817_3850.0_2005-04-01	385000	\N	2005-04-01	80817	\N	\N	f	Sales which are qualified	0
80818_3970.0_2005-03-01	397000	\N	2005-03-01	80818	\N	\N	f	Sales which are qualified	0
80819_3990.0_2005-04-01	399000	\N	2005-04-01	80819	\N	\N	f	Sales which are qualified	0
80820_2880.0_2010-07-23	288000	\N	2010-07-23	80820	\N	\N	f	Qual by exam of deed	0
80820_3579.6_2005-07-01	357960	\N	2005-07-01	80820	\N	\N	f	Sales which are qualified	0
80820_7000.0_2016-05-26	700000	\N	2016-05-26	80820	\N	\N	f	Qual by exam of deed	0
80821_10950.0_2005-06-01	1095000	\N	2005-06-01	80821	\N	\N	t	Deeds that include more than one parcel	0
80821_13650.0_2005-07-01	1365000	\N	2005-07-01	80821	\N	\N	t	Deeds that include more than one parcel	0
80821_18000.0_2014-08-21	1800000	\N	2014-08-21	80821	\N	\N	t	Qual on DOS, multi-parcel sale	0
80821_6000.0_2007-12-01	600000	\N	2007-12-01	80821	\N	\N	f	Sales which are qualified	0
80822_3200.0_2005-04-01	320000	\N	2005-04-01	80822	\N	\N	f	Sales which are qualified	0
80823_4250.0_2005-05-01	425000	\N	2005-05-01	80823	\N	\N	f	Sales which are qualified	0
80823_4600.0_2006-07-01	460000	\N	2006-07-01	80823	\N	\N	f	Sales which are qualified	0
80823_7000.0_2021-05-12	700000	\N	2021-05-12	80823	\N	\N	f	Qual by exam of deed	0
80824_12250.0_2006-11-01	1225000	\N	2006-11-01	80824	\N	\N	t	Deeds that include more than one parcel	0
80824_3579.6_2005-07-01	357960	\N	2005-07-01	80824	\N	\N	f	Sales which are qualified	0
80824_8500.0_2018-02-16	850000	\N	2018-02-16	80824	\N	\N	f	Qual by exam of deed	0
80825_4500.0_2005-06-01	450000	\N	2005-06-01	80825	\N	\N	f	Sales which are qualified	0
80826_10250.0_2005-05-01	1025000	\N	2005-05-01	80826	\N	\N	t	Deeds that include more than one parcel	0
80826_12650.0_2007-03-01	1265000	\N	2007-03-01	80826	\N	\N	t	Deeds that include more than one parcel	0
80827_125000.0_2008-04-01	12500000	\N	2008-04-01	80827	\N	\N	f	Sales which are qualified	0
80827_140000.0_2023-03-02	14000000	\N	2023-03-02	80827	\N	\N	f	Qual by exam of deed	0
80827_39900.0_2005-07-01	3990000	\N	2005-07-01	80827	\N	\N	f	Sales which are qualified	0
80827_64000.0_2007-03-01	6400000	\N	2007-03-01	80827	\N	\N	f	Sales which are qualified	0
80828_130000.0_2023-03-02	13000000	\N	2023-03-02	80828	\N	\N	f	Qual by exam of deed	0
80828_36000.0_2005-07-01	3600000	\N	2005-07-01	80828	\N	\N	f	Sales which are qualified	0
52308_12180.0_2007-08-01	1218000	\N	2007-08-01	52308	\N	\N	f	Sales which are qualified	0
52310_7500.0_2004-03-01	750000	\N	2004-03-01	52310	\N	\N	f	Sales which are qualified	0
52310_7500.0_2010-02-05	750000	\N	2010-02-05	52310	\N	\N	f	Qual by exam of deed	0
52311_2520.0_2001-05-01	252000	\N	2001-05-01	52311	\N	\N	f	Sales which are qualified	0
52311_4000.0_2007-03-01	400000	\N	2007-03-01	52311	\N	\N	f	Sales which are qualified	0
52311_9800.0_2017-06-15	980000	\N	2017-06-15	52311	\N	\N	f	Qual by exam of deed	0
52312_2500.0_2001-03-01	250000	\N	2001-03-01	52312	\N	\N	f	Sales which are qualified	0
52312_6700.0_2012-09-28	670000	\N	2012-09-28	52312	\N	\N	f	Qual by exam of deed	0
52313_2000.0_2001-02-01	200000	\N	2001-02-01	52313	\N	\N	f	Sales which are qualified	0
52314_12000.0_2021-06-24	1200000	\N	2021-06-24	52314	\N	\N	f	Qual by exam of deed	0
52314_2600.0_2001-03-01	260000	\N	2001-03-01	52314	\N	\N	f	Sales which are qualified	0
52314_4450.0_2002-05-01	445000	\N	2002-05-01	52314	\N	\N	f	Sales which are qualified	0
52314_9500.0_2014-01-03	950000	\N	2014-01-03	52314	\N	\N	f	Qual by exam of deed	0
52315_2650.0_2001-03-01	265000	\N	2001-03-01	52315	\N	\N	f	Sales which are qualified	0
52316_18000.0_2011-12-02	1800000	\N	2011-12-02	52316	\N	\N	f	Qual by exam of deed	0
52316_5000.0_2001-02-01	500000	\N	2001-02-01	52316	\N	\N	f	Sales which are qualified	0
52317_15000.0_2016-09-27	1500000	\N	2016-09-27	52317	\N	\N	f	Qual by exam of deed	0
52317_21500.0_2023-03-17	2150000	\N	2023-03-17	52317	\N	\N	f	Qual by exam of deed	0
52317_4032.0_2001-03-01	403200	\N	2001-03-01	52317	\N	\N	f	Sales which are qualified	0
52317_4790.0_2001-04-01	479000	\N	2001-04-01	52317	\N	\N	f	Sales which are qualified	0
52317_6350.0_2003-09-01	635000	\N	2003-09-01	52317	\N	\N	f	Sales which are qualified	0
52317_8500.0_2010-08-12	850000	\N	2010-08-12	52317	\N	\N	f	Qual by exam of deed	0
52318_5950.0_2002-10-01	595000	\N	2002-10-01	52318	\N	\N	f	Sales which are qualified	0
52319_3849.0_2001-11-01	384900	\N	2001-11-01	52319	\N	\N	f	Sales which are qualified	0
52319_5100.0_2004-02-01	510000	\N	2004-02-01	52319	\N	\N	f	Sales which are qualified	0
52320_15500.0_2022-11-01	1550000	\N	2022-11-01	52320	\N	\N	f	Qual by exam of deed	0
52320_3400.0_2002-03-01	340000	\N	2002-03-01	52320	\N	\N	f	Sales which are qualified	0
52320_3510.0_2001-06-01	351000	\N	2001-06-01	52320	\N	\N	t	Deeds that include more than one parcel	0
52320_6640.0_2012-09-20	664000	\N	2012-09-20	52320	\N	\N	f	Qual by exam of deed	0
52321_2090.0_2001-03-01	209000	\N	2001-03-01	52321	\N	\N	f	Sales which are qualified	0
52321_8633.0_2022-06-29	863300	\N	2022-06-29	52321	\N	\N	f	Qual by exam of deed	0
52322_2620.0_2001-03-01	262000	\N	2001-03-01	52322	\N	\N	f	Sales which are qualified	0
52322_4925.0_2003-10-01	492500	\N	2003-10-01	52322	\N	\N	f	Sales which are qualified	0
52323_3300.0_2001-03-01	330000	\N	2001-03-01	52323	\N	\N	f	Sales which are qualified	0
52324_4070.0_2001-03-01	407000	\N	2001-03-01	52324	\N	\N	f	Sales which are qualified	0
52324_5550.0_2001-04-01	555000	\N	2001-04-01	52324	\N	\N	f	Sales which are qualified	0
52325_4140.0_2001-03-01	414000	\N	2001-03-01	52325	\N	\N	f	Sales which are qualified	0
52326_5350.0_2001-05-01	535000	\N	2001-05-01	52326	\N	\N	f	Sales which are qualified	0
52326_5500.0_2002-08-01	550000	\N	2002-08-01	52326	\N	\N	f	Sales which are qualified	0
52326_5500.0_2003-07-01	550000	\N	2003-07-01	52326	\N	\N	f	Sales which are qualified	0
52327_3650.0_2002-07-01	365000	\N	2002-07-01	52327	\N	\N	f	Sales which are qualified	0
52327_5600.0_2007-10-01	560000	\N	2007-10-01	52327	\N	\N	f	Sales which are qualified	0
52327_6440.0_2011-08-02	644000	\N	2011-08-02	52327	\N	\N	f	Qual by exam of deed	0
52327_6750.0_2008-08-06	675000	\N	2008-08-06	52327	\N	\N	f	Sales which are qualified	0
52328_2540.0_2001-03-01	254000	\N	2001-03-01	52328	\N	\N	f	Sales which are qualified	0
52328_5920.0_2004-12-01	592000	\N	2004-12-01	52328	\N	\N	f	Sales which are qualified	0
52328_7950.0_2014-04-09	795000	\N	2014-04-09	52328	\N	\N	f	Qual by exam of deed	0
52329_2130.0_2001-03-01	213000	\N	2001-03-01	52329	\N	\N	f	Sales which are qualified	0
52329_4200.0_2012-12-26	420000	\N	2012-12-26	52329	\N	\N	f	Qual by exam of deed	0
52330_2640.0_2001-03-01	264000	\N	2001-03-01	52330	\N	\N	f	Sales which are qualified	0
52331_2690.0_2001-05-01	269000	\N	2001-05-01	52331	\N	\N	f	Sales which are qualified	0
52331_4325.0_2001-08-01	432500	\N	2001-08-01	52331	\N	\N	f	Sales which are qualified	0
52332_12250.0_2008-05-01	1225000	\N	2008-05-01	52332	\N	\N	f	Sales which are qualified	0
52332_14000.0_2006-03-01	1400000	\N	2006-03-01	52332	\N	\N	f	Sales which are qualified	0
52332_5100.0_2001-04-01	510000	\N	2001-04-01	52332	\N	\N	f	Sales which are qualified	0
52333_3520.0_2001-05-01	352000	\N	2001-05-01	52333	\N	\N	f	Sales which are qualified	0
52334_16750.0_2016-02-05	1675000	\N	2016-02-05	52334	\N	\N	f	Qual by exam of deed	0
52334_21000.0_2021-07-12	2100000	\N	2021-07-12	52334	\N	\N	f	Qual by exam of deed	0
52334_5390.0_2001-05-01	539000	\N	2001-05-01	52334	\N	\N	f	Sales which are qualified	0
52334_8600.0_2004-08-01	860000	\N	2004-08-01	52334	\N	\N	f	Sales which are qualified	0
52335_3700.0_2002-09-01	370000	\N	2002-09-01	52335	\N	\N	f	Sales which are qualified	0
52335_6750.0_2013-06-27	675000	\N	2013-06-27	52335	\N	\N	f	Qual by exam of deed	0
52335_8300.0_2017-04-26	830000	\N	2017-04-26	52335	\N	\N	f	Qual by exam of deed	0
52336_2560.0_2001-03-01	256000	\N	2001-03-01	52336	\N	\N	f	Sales which are qualified	0
52336_3490.0_2001-03-01	349000	\N	2001-03-01	52336	\N	\N	f	Sales which are qualified	0
52336_5300.0_2004-04-01	530000	\N	2004-04-01	52336	\N	\N	f	Sales which are qualified	0
52336_7600.0_2006-08-01	760000	\N	2006-08-01	52336	\N	\N	f	Sales which are qualified	0
52337_2045.0_2001-05-01	204500	\N	2001-05-01	52337	\N	\N	f	Sales which are qualified	0
52337_2850.0_2001-08-01	285000	\N	2001-08-01	52337	\N	\N	f	Sales which are qualified	0
52338_10000.0_2018-09-05	1000000	\N	2018-09-05	52338	\N	\N	f	Qual by exam of deed	0
52338_2660.0_2001-04-01	266000	\N	2001-04-01	52338	\N	\N	f	Sales which are qualified	0
52338_4750.0_2003-10-01	475000	\N	2003-10-01	52338	\N	\N	f	Sales which are qualified	0
52339_11250.0_2014-06-02	1125000	\N	2014-06-02	52339	\N	\N	f	Qual by exam of deed	0
52339_2710.0_2001-03-01	271000	\N	2001-03-01	52339	\N	\N	f	Sales which are qualified	0
52339_3400.0_2001-04-01	340000	\N	2001-04-01	52339	\N	\N	f	Sales which are qualified	0
52340_15500.0_2012-06-14	1550000	\N	2012-06-14	52340	\N	\N	f	Qual by exam of deed	0
52340_4120.0_2001-02-01	412000	\N	2001-02-01	52340	\N	\N	f	Sales which are qualified	0
52341_15750.0_2016-09-01	1575000	\N	2016-09-01	52341	\N	\N	f	Qual by exam of deed	0
52341_3580.0_2001-03-01	358000	\N	2001-03-01	52341	\N	\N	f	Sales which are qualified	0
52341_4400.0_2001-04-01	440000	\N	2001-04-01	52341	\N	\N	f	Sales which are qualified	0
52341_9000.0_2012-01-27	900000	\N	2012-01-27	52341	\N	\N	f	Qual by exam of deed	0
52342_11000.0_2007-03-01	1100000	\N	2007-03-01	52342	\N	\N	f	Sales which are qualified	0
52342_17300.0_2018-03-15	1730000	\N	2018-03-15	52342	\N	\N	f	Qual by exam of deed	0
52342_6150.0_2002-06-01	615000	\N	2002-06-01	52342	\N	\N	f	Sales which are qualified	0
52343_10000.0_2017-12-20	1000000	\N	2017-12-20	52343	\N	\N	f	Qual by exam of deed	0
52343_3750.0_2002-09-01	375000	\N	2002-09-01	52343	\N	\N	f	Sales which are qualified	0
52343_9450.0_2015-12-15	945000	\N	2015-12-15	52343	\N	\N	f	Qual by exam of deed	0
52344_5280.0_2004-04-01	528000	\N	2004-04-01	52344	\N	\N	f	Sales which are qualified	0
52344_7850.0_2020-06-16	785000	\N	2020-06-16	52344	\N	\N	f	Qual by exam of deed	0
52345_2060.0_2001-03-01	206000	\N	2001-03-01	52345	\N	\N	f	Sales which are qualified	0
52345_4650.0_2004-11-01	465000	\N	2004-11-01	52345	\N	\N	f	Sales which are qualified	0
52346_2680.0_2001-04-01	268000	\N	2001-04-01	52346	\N	\N	f	Sales which are qualified	0
52346_3850.0_2001-05-01	385000	\N	2001-05-01	52346	\N	\N	f	Sales which are qualified	0
52347_2730.0_2001-03-01	273000	\N	2001-03-01	52347	\N	\N	f	Sales which are qualified	0
52347_8450.0_2005-09-01	845000	\N	2005-09-01	52347	\N	\N	f	Sales which are qualified	0
52348_13500.0_2006-02-01	1350000	\N	2006-02-01	52348	\N	\N	f	Sales which are qualified	0
52348_19500.0_2016-07-18	1950000	\N	2016-07-18	52348	\N	\N	f	Qual by exam of deed	0
52348_4160.0_2001-03-01	416000	\N	2001-03-01	52348	\N	\N	f	Sales which are qualified	0
52348_5250.0_2001-03-01	525000	\N	2001-03-01	52348	\N	\N	f	Sales which are qualified	0
52348_7850.0_2004-05-01	785000	\N	2004-05-01	52348	\N	\N	f	Sales which are qualified	0
52349_3600.0_2001-04-01	360000	\N	2001-04-01	52349	\N	\N	f	Sales which are qualified	0
52349_4430.0_2001-04-01	443000	\N	2001-04-01	52349	\N	\N	f	Sales which are qualified	0
52350_6200.0_2002-05-01	620000	\N	2002-05-01	52350	\N	\N	f	Sales which are qualified	0
52351_3800.0_2002-06-01	380000	\N	2002-06-01	52351	\N	\N	f	Sales which are qualified	0
52351_8700.0_2014-12-18	870000	\N	2014-12-18	52351	\N	\N	f	Qual by exam of deed	0
52351_9500.0_2021-03-08	950000	\N	2021-03-08	52351	\N	\N	f	Qual by exam of deed	0
52351_9900.0_2016-07-29	990000	\N	2016-07-29	52351	\N	\N	f	Qual by exam of deed	0
52352_7000.0_2007-05-01	700000	\N	2007-05-01	52352	\N	\N	f	Sales which are qualified	0
52352_7950.0_2013-11-21	795000	\N	2013-11-21	52352	\N	\N	f	Qual by exam of deed	0
52353_2075.0_2001-05-01	207500	\N	2001-05-01	52353	\N	\N	f	Sales which are qualified	0
52353_2400.0_2002-06-01	240000	\N	2002-06-01	52353	\N	\N	f	Sales which are qualified	0
52353_8500.0_2022-01-10	850000	\N	2022-01-10	52353	\N	\N	f	Qual by exam of deed	0
52354_3240.0_2001-03-01	324000	\N	2001-03-01	52354	\N	\N	f	Sales which are qualified	0
52354_7210.0_2011-06-28	721000	\N	2011-06-28	52354	\N	\N	f	Qual by exam of deed	0
52355_2750.0_2001-04-01	275000	\N	2001-04-01	52355	\N	\N	f	Sales which are qualified	0
52355_3500.0_2001-05-01	350000	\N	2001-05-01	52355	\N	\N	f	Sales which are qualified	0
52355_9000.0_2013-07-15	900000	\N	2013-07-15	52355	\N	\N	f	Qual by exam of deed	0
52356_5549.0_2001-03-01	554900	\N	2001-03-01	52356	\N	\N	f	Sales which are qualified	0
52356_7180.0_2003-06-01	718000	\N	2003-06-01	52356	\N	\N	f	Sales which are qualified	0
52357_10250.0_2007-05-01	1025000	\N	2007-05-01	52357	\N	\N	f	Sales which are qualified	0
52357_16500.0_2016-04-14	1650000	\N	2016-04-14	52357	\N	\N	f	Qual by exam of deed	0
52357_3610.0_2001-04-01	361000	\N	2001-04-01	52357	\N	\N	f	Sales which are qualified	0
52357_4576.0_2001-04-01	457600	\N	2001-04-01	52357	\N	\N	f	Sales which are qualified	0
52357_8900.0_2011-05-18	890000	\N	2011-05-18	52357	\N	\N	f	Qual by exam of deed	0
52358_10800.0_2005-04-01	1080000	\N	2005-04-01	52358	\N	\N	f	Sales which are qualified	0
52358_16250.0_2013-12-11	1625000	\N	2013-12-11	52358	\N	\N	f	Qual by exam of deed	0
52358_6250.0_2002-08-01	625000	\N	2002-08-01	52358	\N	\N	f	Sales which are qualified	0
52359_3752.0_2002-02-01	375200	\N	2002-02-01	52359	\N	\N	f	Sales which are qualified	0
52359_6100.0_2009-05-04	610000	\N	2009-05-04	52359	\N	\N	f	Qual by exam of deed	0
52359_7750.0_2005-11-01	775000	\N	2005-11-01	52359	\N	\N	f	Sales which are qualified	0
52359_9500.0_2006-12-01	950000	\N	2006-12-01	52359	\N	\N	f	Sales which are qualified	0
52360_10500.0_2015-12-14	1050000	\N	2015-12-14	52360	\N	\N	f	Qual by exam of deed	0
52360_11500.0_2022-01-10	1150000	\N	2022-01-10	52360	\N	\N	f	Qual by exam of deed	0
52360_6000.0_2013-04-19	600000	\N	2013-04-19	52360	\N	\N	f	Qual by exam of deed	0
52360_7150.0_2007-06-01	715000	\N	2007-06-01	52360	\N	\N	f	Sales which are qualified	0
52360_7800.0_2014-03-24	780000	\N	2014-03-24	52360	\N	\N	f	Qual by exam of deed	0
52361_2090.0_2001-04-01	209000	\N	2001-04-01	52361	\N	\N	f	Sales which are qualified	0
52361_5330.0_2012-04-26	533000	\N	2012-04-26	52361	\N	\N	f	Qual by exam of deed	0
52361_7200.0_2014-11-07	720000	\N	2014-11-07	52361	\N	\N	f	Qual by exam of deed	0
52362_11000.0_2015-05-05	1100000	\N	2015-05-05	52362	\N	\N	f	Qual by exam of deed	0
52362_2720.0_2001-04-01	272000	\N	2001-04-01	52362	\N	\N	f	Sales which are qualified	0
52363_2770.0_2001-05-01	277000	\N	2001-05-01	52363	\N	\N	f	Sales which are qualified	0
52364_13900.0_2005-07-01	1390000	\N	2005-07-01	52364	\N	\N	f	Sales which are qualified	0
52364_5300.0_2001-04-01	530000	\N	2001-04-01	52364	\N	\N	f	Sales which are qualified	0
52365_16000.0_2017-09-19	1600000	\N	2017-09-19	52365	\N	\N	f	Qual by exam of deed	0
52365_3620.0_2001-04-01	362000	\N	2001-04-01	52365	\N	\N	f	Sales which are qualified	0
52366_6150.0_2002-04-01	615000	\N	2002-04-01	52366	\N	\N	f	Sales which are qualified	0
52366_7030.0_2003-08-01	703000	\N	2003-08-01	52366	\N	\N	f	Sales which are qualified	0
52367_2880.0_2001-04-01	288000	\N	2001-04-01	52367	\N	\N	f	Sales which are qualified	0
52367_3550.0_2001-04-01	355000	\N	2001-04-01	52367	\N	\N	f	Sales which are qualified	0
52367_7500.0_2013-09-11	750000	\N	2013-09-11	52367	\N	\N	f	Qual by exam of deed	0
52367_9200.0_2021-06-16	920000	\N	2021-06-16	52367	\N	\N	f	Qual by exam of deed	0
52368_13100.0_2023-02-23	1310000	\N	2023-02-23	52368	\N	\N	f	Qual by exam of deed	0
52368_4550.0_2003-08-01	455000	\N	2003-08-01	52368	\N	\N	f	Sales which are qualified	0
52368_5843.0_2004-08-01	584300	\N	2004-08-01	52368	\N	\N	f	Sales which are qualified	0
52369_2155.0_2001-05-01	215500	\N	2001-05-01	52369	\N	\N	f	Sales which are qualified	0
52369_3250.0_2002-09-01	325000	\N	2002-09-01	52369	\N	\N	f	Sales which are qualified	0
52369_4200.0_2004-03-01	420000	\N	2004-03-01	52369	\N	\N	f	Sales which are qualified	0
52369_4800.0_2009-06-15	480000	\N	2009-06-15	52369	\N	\N	f	Qual by exam of deed	0
52369_5270.0_2005-02-01	527000	\N	2005-02-01	52369	\N	\N	f	Sales which are qualified	0
52369_6690.0_2007-04-01	669000	\N	2007-04-01	52369	\N	\N	f	Sales which are qualified	0
52369_9500.0_2022-10-25	950000	\N	2022-10-25	52369	\N	\N	f	Qual by exam of deed	0
52370_10500.0_2018-10-22	1050000	\N	2018-10-22	52370	\N	\N	f	Qual by exam of deed	0
52370_2740.0_2001-03-01	274000	\N	2001-03-01	52370	\N	\N	f	Sales which are qualified	0
52370_5150.0_2003-10-01	515000	\N	2003-10-01	52370	\N	\N	f	Sales which are qualified	0
52371_11690.0_2016-04-01	1169000	\N	2016-04-01	52371	\N	\N	f	Qual by exam of deed	0
52371_2790.0_2001-03-01	279000	\N	2001-03-01	52371	\N	\N	f	Sales which are qualified	0
52371_4700.0_2002-05-01	470000	\N	2002-05-01	52371	\N	\N	f	Sales which are qualified	0
52371_5200.0_2004-01-01	520000	\N	2004-01-01	52371	\N	\N	f	Sales which are qualified	0
52372_5350.0_2001-04-01	535000	\N	2001-04-01	52372	\N	\N	f	Sales which are qualified	0
52372_6100.0_2002-03-01	610000	\N	2002-03-01	52372	\N	\N	f	Sales which are qualified	0
52373_16750.0_2021-12-01	1675000	\N	2021-12-01	52373	\N	\N	f	Qual by exam of deed	0
52373_3640.0_2001-04-01	364000	\N	2001-04-01	52373	\N	\N	f	Sales which are qualified	0
52373_4650.0_2001-04-01	465000	\N	2001-04-01	52373	\N	\N	f	Sales which are qualified	0
52374_11000.0_2007-12-01	1100000	\N	2007-12-01	52374	\N	\N	f	Sales which are qualified	0
52374_11000.0_2010-12-01	1100000	\N	2010-12-01	52374	\N	\N	f	Qual by exam of deed	0
52374_19000.0_2013-08-05	1900000	\N	2013-08-05	52374	\N	\N	f	Qual by exam of deed	0
52374_4300.0_2001-10-01	430000	\N	2001-10-01	52374	\N	\N	f	Sales which are qualified	0
52374_6300.0_2002-05-01	630000	\N	2002-05-01	52374	\N	\N	f	Sales which are qualified	0
52374_9400.0_2004-07-01	940000	\N	2004-07-01	52374	\N	\N	f	Sales which are qualified	0
52375_10000.0_2017-03-03	1000000	\N	2017-03-03	52375	\N	\N	f	Qual by exam of deed	0
52375_4150.0_2002-07-01	415000	\N	2002-07-01	52375	\N	\N	f	Sales which are qualified	0
52376_4600.0_2003-02-01	460000	\N	2003-02-01	52376	\N	\N	f	Sales which are qualified	0
52377_3350.0_2002-04-01	335000	\N	2002-04-01	52377	\N	\N	f	Sales which are qualified	0
52377_5270.0_2005-01-01	527000	\N	2005-01-01	52377	\N	\N	f	Sales which are qualified	0
52377_7250.0_2021-03-15	725000	\N	2021-03-15	52377	\N	\N	f	Qual by exam of deed	0
52377_7800.0_2018-04-18	780000	\N	2018-04-18	52377	\N	\N	f	Qual by exam of deed	0
52378_2760.0_2001-04-01	276000	\N	2001-04-01	52378	\N	\N	f	Sales which are qualified	0
52378_4350.0_2001-07-01	435000	\N	2001-07-01	52378	\N	\N	f	Sales which are qualified	0
52378_5250.0_2011-02-28	525000	\N	2011-02-28	52378	\N	\N	f	Qual by exam of deed	0
52379_2800.0_2001-05-01	280000	\N	2001-05-01	52379	\N	\N	f	Sales which are qualified	0
52380_12400.0_2011-05-18	1240000	\N	2011-05-18	52380	\N	\N	f	Qual by exam of deed	0
52380_19800.0_2019-01-17	1980000	\N	2019-01-17	52380	\N	\N	f	Qual by exam of deed	0
52380_4270.0_2001-05-01	427000	\N	2001-05-01	52380	\N	\N	f	Sales which are qualified	0
52380_7850.0_2003-08-01	785000	\N	2003-08-01	52380	\N	\N	f	Sales which are qualified	0
52381_13000.0_2020-01-24	1300000	\N	2020-01-24	52381	\N	\N	f	Qual by exam of deed	0
52381_3650.0_2001-05-01	365000	\N	2001-05-01	52381	\N	\N	f	Sales which are qualified	0
52381_8700.0_2011-07-19	870000	\N	2011-07-19	52381	\N	\N	f	Qual by exam of deed	0
52382_4150.0_2001-11-01	415000	\N	2001-11-01	52382	\N	\N	f	Sales which are qualified	0
52383_10000.0_2020-11-19	1000000	\N	2020-11-19	52383	\N	\N	f	Qual by exam of deed	0
52383_4400.0_2002-06-01	440000	\N	2002-06-01	52383	\N	\N	f	Sales which are qualified	0
52384_3400.0_2001-06-01	340000	\N	2001-06-01	52384	\N	\N	f	Sales which are qualified	0
52384_3900.0_2001-10-01	390000	\N	2001-10-01	52384	\N	\N	f	Sales which are qualified	0
52384_4750.0_2002-05-01	475000	\N	2002-05-01	52384	\N	\N	f	Sales which are qualified	0
52384_6750.0_2008-04-01	675000	\N	2008-04-01	52384	\N	\N	f	Sales which are qualified	0
52385_2682.0_2001-04-01	268200	\N	2001-04-01	52385	\N	\N	f	Sales which are qualified	0
52386_2970.0_2001-03-01	297000	\N	2001-03-01	52386	\N	\N	f	Sales which are qualified	0
52387_12500.0_2016-10-05	1250000	\N	2016-10-05	52387	\N	\N	f	Qual by exam of deed	0
52387_2880.0_2001-04-01	288000	\N	2001-04-01	52387	\N	\N	f	Sales which are qualified	0
52387_4000.0_2001-04-01	400000	\N	2001-04-01	52387	\N	\N	f	Sales which are qualified	0
52387_4500.0_2003-06-01	450000	\N	2003-06-01	52387	\N	\N	f	Sales which are qualified	0
52388_14000.0_2014-12-10	1400000	\N	2014-12-10	52388	\N	\N	f	Qual by exam of deed	0
52388_3680.0_2001-05-01	368000	\N	2001-05-01	52388	\N	\N	f	Sales which are qualified	0
52388_8150.0_2009-04-29	815000	\N	2009-04-29	52388	\N	\N	f	Qual by exam of deed	0
52389_10500.0_2010-02-04	1050000	\N	2010-02-04	52389	\N	\N	f	Qual by exam of deed	0
52389_4800.0_2001-05-01	480000	\N	2001-05-01	52389	\N	\N	f	Sales which are qualified	0
52390_3720.0_2001-04-01	372000	\N	2001-04-01	52390	\N	\N	f	Sales which are qualified	0
52390_4675.0_2003-06-01	467500	\N	2003-06-01	52390	\N	\N	f	Sales which are qualified	0
52391_13000.0_2021-08-02	1300000	\N	2021-08-02	52391	\N	\N	f	Qual by exam of deed	0
52391_15050.0_2022-03-03	1505000	\N	2022-03-03	52391	\N	\N	f	Qual by exam of deed	0
52391_3190.0_2001-06-01	319000	\N	2001-06-01	52391	\N	\N	f	Sales which are qualified	0
52391_4180.0_2001-06-01	418000	\N	2001-06-01	52391	\N	\N	f	Sales which are qualified	0
52391_5400.0_2004-02-01	540000	\N	2004-02-01	52391	\N	\N	f	Sales which are qualified	0
52391_8000.0_2007-04-01	800000	\N	2007-04-01	52391	\N	\N	f	Sales which are qualified	0
52391_9200.0_2013-02-01	920000	\N	2013-02-01	52391	\N	\N	f	Qual by exam of deed	0
52392_2250.0_2001-05-01	225000	\N	2001-05-01	52392	\N	\N	f	Sales which are qualified	0
52392_3750.0_2003-07-01	375000	\N	2003-07-01	52392	\N	\N	f	Sales which are qualified	0
52393_4070.0_2001-04-01	407000	\N	2001-04-01	52393	\N	\N	f	Sales which are qualified	0
52394_2900.0_2001-05-01	290000	\N	2001-05-01	52394	\N	\N	f	Sales which are qualified	0
52395_4330.0_2001-05-01	433000	\N	2001-05-01	52395	\N	\N	f	Sales which are qualified	0
52396_15000.0_2017-10-16	1500000	\N	2017-10-16	52396	\N	\N	f	Qual by exam of deed	0
52396_3710.0_2001-03-01	371000	\N	2001-03-01	52396	\N	\N	f	Sales which are qualified	0
52396_4500.0_2001-04-01	450000	\N	2001-04-01	52396	\N	\N	f	Sales which are qualified	0
52396_7300.0_2004-05-01	730000	\N	2004-05-01	52396	\N	\N	f	Sales which are qualified	0
52397_4830.0_2001-03-01	483000	\N	2001-03-01	52397	\N	\N	f	Sales which are qualified	0
52398_11900.0_2021-06-03	1190000	\N	2021-06-03	52398	\N	\N	f	Qual by exam of deed	0
52398_2950.0_2001-05-01	295000	\N	2001-05-01	52398	\N	\N	f	Sales which are qualified	0
52398_4000.0_2001-05-01	400000	\N	2001-05-01	52398	\N	\N	f	Sales which are qualified	0
52399_13900.0_2014-05-05	1390000	\N	2014-05-05	52399	\N	\N	f	Qual by exam of deed	0
52399_4870.0_2001-06-01	487000	\N	2001-06-01	52399	\N	\N	f	Sales which are qualified	0
52399_6300.0_2004-09-01	630000	\N	2004-09-01	52399	\N	\N	f	Sales which are qualified	0
52399_7000.0_2011-05-03	700000	\N	2011-05-03	52399	\N	\N	f	Qual by exam of deed	0
52399_7600.0_2008-05-01	760000	\N	2008-05-01	52399	\N	\N	f	Sales which are qualified	0
52399_9000.0_2013-04-19	900000	\N	2013-04-19	52399	\N	\N	f	Qual by exam of deed	0
52400_2265.0_2001-04-01	226500	\N	2001-04-01	52400	\N	\N	f	Sales which are qualified	0
52400_3740.0_2006-06-01	374000	\N	2006-06-01	52400	\N	\N	f	Sales which are qualified	0
52401_3612.0_2001-03-01	361200	\N	2001-03-01	52401	\N	\N	f	Sales which are qualified	0
52401_5093.0_2002-06-01	509300	\N	2002-06-01	52401	\N	\N	f	Sales which are qualified	0
52401_8475.0_2007-01-01	847500	\N	2007-01-01	52401	\N	\N	f	Sales which are qualified	0
52402_3800.0_2001-04-01	380000	\N	2001-04-01	52402	\N	\N	f	Sales which are qualified	0
52403_11650.0_2007-02-01	1165000	\N	2007-02-01	52403	\N	\N	f	Sales which are qualified	0
52403_5828.0_2001-03-01	582800	\N	2001-03-01	52403	\N	\N	f	Sales which are qualified	0
52404_5730.0_2001-05-01	573000	\N	2001-05-01	52404	\N	\N	f	Sales which are qualified	0
52404_6050.0_2003-09-01	605000	\N	2003-09-01	52404	\N	\N	f	Sales which are qualified	0
52405_26200.0_2022-04-15	2620000	\N	2022-04-15	52405	\N	\N	f	Qual by exam of deed	0
52405_4910.0_2001-09-01	491000	\N	2001-09-01	52405	\N	\N	f	Sales which are qualified	0
52406_2970.0_2002-02-01	297000	\N	2002-02-01	52406	\N	\N	f	Sales which are qualified	0
52406_7500.0_2005-01-01	750000	\N	2005-01-01	52406	\N	\N	f	Sales which are qualified	0
52407_3230.0_2001-04-01	323000	\N	2001-04-01	52407	\N	\N	f	Sales which are qualified	0
52407_4050.0_2001-03-01	405000	\N	2001-03-01	52407	\N	\N	f	Sales which are qualified	0
52407_4850.0_2002-01-01	485000	\N	2002-01-01	52407	\N	\N	f	Sales which are qualified	0
52407_8400.0_2010-01-04	840000	\N	2010-01-04	52407	\N	\N	f	Qual by exam of deed	0
52408_2280.0_2001-04-01	228000	\N	2001-04-01	52408	\N	\N	f	Sales which are qualified	0
52408_6100.0_2006-03-01	610000	\N	2006-03-01	52408	\N	\N	f	Sales which are qualified	0
52409_10700.0_2019-06-14	1070000	\N	2019-06-14	52409	\N	\N	f	Qual by exam of deed	0
52409_13750.0_2022-04-25	1375000	\N	2022-04-25	52409	\N	\N	f	Qual by exam of deed	0
52409_3636.0_2002-03-01	363600	\N	2002-03-01	52409	\N	\N	f	Sales which are qualified	0
52410_11250.0_2016-12-13	1125000	\N	2016-12-13	52410	\N	\N	f	Qual by exam of deed	0
52410_3600.0_2002-02-01	360000	\N	2002-02-01	52410	\N	\N	f	Sales which are qualified	0
52411_11000.0_2010-02-15	1100000	\N	2010-02-15	52411	\N	\N	f	Qual by exam of deed	0
52411_6468.0_2001-04-01	646800	\N	2001-04-01	52411	\N	\N	f	Sales which are qualified	0
52412_13800.0_2013-10-15	1380000	\N	2013-10-15	52412	\N	\N	f	Qual by exam of deed	0
52412_5500.0_2002-04-01	550000	\N	2002-04-01	52412	\N	\N	f	Sales which are qualified	0
52413_12500.0_2005-02-01	1250000	\N	2005-02-01	52413	\N	\N	f	Sales which are qualified	0
52413_12950.0_2011-03-17	1295000	\N	2011-03-17	52413	\N	\N	f	Qual by exam of deed	0
52413_22750.0_2020-11-16	2275000	\N	2020-11-16	52413	\N	\N	f	Qual by exam of deed	0
52413_4940.0_2001-03-01	494000	\N	2001-03-01	52413	\N	\N	f	Sales which are qualified	0
52413_6900.0_2001-04-01	690000	\N	2001-04-01	52413	\N	\N	f	Sales which are qualified	0
52414_3980.0_2002-02-01	398000	\N	2002-02-01	52414	\N	\N	f	Sales which are qualified	0
52414_4775.0_2002-09-01	477500	\N	2002-09-01	52414	\N	\N	f	Sales which are qualified	0
52414_8150.0_2011-05-17	815000	\N	2011-05-17	52414	\N	\N	f	Qual by exam of deed	0
52414_9950.0_2020-06-15	995000	\N	2020-06-15	52414	\N	\N	f	Qual by exam of deed	0
52415_3250.0_2001-04-01	325000	\N	2001-04-01	52415	\N	\N	f	Sales which are qualified	0
52416_3530.0_2002-02-01	353000	\N	2002-02-01	52416	\N	\N	f	Sales which are qualified	0
52416_4650.0_2004-04-01	465000	\N	2004-04-01	52416	\N	\N	f	Sales which are qualified	0
52416_4950.0_2004-10-01	495000	\N	2004-10-01	52416	\N	\N	f	Sales which are qualified	0
52417_3050.0_2001-04-01	305000	\N	2001-04-01	52417	\N	\N	f	Sales which are qualified	0
52418_11500.0_2016-03-31	1150000	\N	2016-03-31	52418	\N	\N	f	Qual by exam of deed	0
52418_2960.0_2001-03-01	296000	\N	2001-03-01	52418	\N	\N	f	Sales which are qualified	0
52419_18000.0_2014-01-13	1800000	\N	2014-01-13	52419	\N	\N	f	Qual by exam of deed	0
52419_21070.0_2014-09-19	2107000	\N	2014-09-19	52419	\N	\N	f	Qual by exam of deed	0
52419_5630.0_2002-02-01	563000	\N	2002-02-01	52419	\N	\N	f	Sales which are qualified	0
52420_5600.0_2002-04-01	560000	\N	2002-04-01	52420	\N	\N	f	Sales which are qualified	0
52421_15000.0_2011-12-16	1500000	\N	2011-12-16	52421	\N	\N	f	Qual by exam of deed	0
52421_6878.0_2001-05-01	687800	\N	2001-05-01	52421	\N	\N	f	Sales which are qualified	0
52421_6990.0_2002-07-01	699000	\N	2002-07-01	52421	\N	\N	f	Sales which are qualified	0
52422_12630.0_2015-01-15	1263000	\N	2015-01-15	52422	\N	\N	f	Qual by exam of deed	0
52422_14500.0_2015-04-10	1450000	\N	2015-04-10	52422	\N	\N	f	Qual by exam of deed	0
52422_3240.0_2001-05-01	324000	\N	2001-05-01	52422	\N	\N	f	Sales which are qualified	0
52423_3270.0_2001-05-01	327000	\N	2001-05-01	52423	\N	\N	f	Sales which are qualified	0
52423_4450.0_2001-12-01	445000	\N	2001-12-01	52423	\N	\N	f	Sales which are qualified	0
52423_6650.0_2004-03-01	665000	\N	2004-03-01	52423	\N	\N	f	Sales which are qualified	0
52423_9500.0_2006-02-01	950000	\N	2006-02-01	52423	\N	\N	f	Sales which are qualified	0
52424_3250.0_2002-03-01	325000	\N	2002-03-01	52424	\N	\N	f	Sales which are qualified	0
52424_4420.0_2004-02-01	442000	\N	2004-02-01	52424	\N	\N	f	Sales which are qualified	0
52424_5330.0_2001-04-01	533000	\N	2001-04-01	52424	\N	\N	t	Deeds that include more than one parcel	0
52424_5400.0_2013-02-14	540000	\N	2013-02-14	52424	\N	\N	f	Qual by exam of deed	0
52424_6430.0_2006-11-01	643000	\N	2006-11-01	52424	\N	\N	f	Sales which are qualified	0
52425_13150.0_2022-12-09	1315000	\N	2022-12-09	52425	\N	\N	f	Qual by exam of deed	0
52425_4380.0_2002-03-01	438000	\N	2002-03-01	52425	\N	\N	f	Sales which are qualified	0
52425_5330.0_2001-04-01	533000	\N	2001-04-01	52425	\N	\N	t	Deeds that include more than one parcel	0
52425_7150.0_2005-04-01	715000	\N	2005-04-01	52425	\N	\N	f	Sales which are qualified	0
52425_7300.0_2011-05-02	730000	\N	2011-05-02	52425	\N	\N	f	Qual by exam of deed	0
52426_3625.0_2002-02-01	362500	\N	2002-02-01	52426	\N	\N	f	Sales which are qualified	0
52426_4900.0_2002-10-01	490000	\N	2002-10-01	52426	\N	\N	f	Sales which are qualified	0
52427_20000.0_2019-08-19	2000000	\N	2019-08-19	52427	\N	\N	f	Qual by exam of deed	0
52427_5985.0_2001-03-01	598500	\N	2001-03-01	52427	\N	\N	f	Sales which are qualified	0
52427_7450.0_2003-07-01	745000	\N	2003-07-01	52427	\N	\N	f	Sales which are qualified	0
52428_3830.0_2001-05-01	383000	\N	2001-05-01	52428	\N	\N	f	Sales which are qualified	0
52429_22500.0_2018-02-12	2250000	\N	2018-02-12	52429	\N	\N	f	Qual by exam of deed	0
52429_4950.0_2001-09-01	495000	\N	2001-09-01	52429	\N	\N	f	Sales which are qualified	0
52429_6659.0_2002-04-01	665900	\N	2002-04-01	52429	\N	\N	f	Sales which are qualified	0
52430_3912.0_2001-04-01	391200	\N	2001-04-01	52430	\N	\N	f	Sales which are qualified	0
52430_9400.0_2012-03-26	940000	\N	2012-03-26	52430	\N	\N	f	Qual by exam of deed	0
52431_4600.0_2001-03-01	460000	\N	2001-03-01	52431	\N	\N	f	Sales which are qualified	0
52431_9100.0_2012-10-22	910000	\N	2012-10-22	52431	\N	\N	f	Qual by exam of deed	0
52432_3800.0_2002-04-01	380000	\N	2002-04-01	52432	\N	\N	f	Sales which are qualified	0
52432_4290.0_2004-03-01	429000	\N	2004-03-01	52432	\N	\N	f	Sales which are qualified	0
52432_5250.0_2011-01-07	525000	\N	2011-01-07	52432	\N	\N	f	Qual by exam of deed	0
52432_7500.0_2021-04-05	750000	\N	2021-04-05	52432	\N	\N	f	Qual by exam of deed	0
52433_10000.0_2014-03-31	1000000	\N	2014-03-31	52433	\N	\N	f	Qual by exam of deed	0
52433_15250.0_2022-07-08	1525000	\N	2022-07-08	52433	\N	\N	f	Qual by exam of deed	0
52433_3090.0_2001-03-01	309000	\N	2001-03-01	52433	\N	\N	f	Sales which are qualified	0
52433_4500.0_2002-09-01	450000	\N	2002-09-01	52433	\N	\N	f	Sales which are qualified	0
52433_8300.0_2007-09-01	830000	\N	2007-09-01	52433	\N	\N	f	Sales which are qualified	0
52434_5264.0_2002-03-01	526400	\N	2002-03-01	52434	\N	\N	f	Sales which are qualified	0
52434_8900.0_2013-08-02	890000	\N	2013-08-02	52434	\N	\N	f	Qual by exam of deed	0
52435_13000.0_2012-11-29	1300000	\N	2012-11-29	52435	\N	\N	f	Qual by exam of deed	0
52435_16564.0_2001-06-01	1656400	\N	2001-06-01	52435	\N	\N	t	Deeds that include more than one parcel	0
52435_35250.0_2005-05-01	3525000	\N	2005-05-01	52435	\N	\N	f	Sales which are qualified	0
52436_16564.0_2001-06-01	1656400	\N	2001-06-01	52436	\N	\N	t	Deeds that include more than one parcel	0
52436_8750.0_2008-08-01	875000	\N	2008-08-01	52436	\N	\N	f	Sales which are qualified	0
52437_15000.0_2007-09-01	1500000	\N	2007-09-01	52437	\N	\N	f	Sales which are qualified	0
52437_16564.0_2001-06-01	1656400	\N	2001-06-01	52437	\N	\N	t	Deeds that include more than one parcel	0
52438_12800.0_2021-07-07	1280000	\N	2021-07-07	52438	\N	\N	f	Qual by exam of deed	0
52438_3450.0_2001-04-01	345000	\N	2001-04-01	52438	\N	\N	f	Sales which are qualified	0
52438_4725.0_2003-05-01	472500	\N	2003-05-01	52438	\N	\N	f	Sales which are qualified	0
52438_7500.0_2011-05-19	750000	\N	2011-05-19	52438	\N	\N	f	Qual by exam of deed	0
52438_7650.0_2007-12-01	765000	\N	2007-12-01	52438	\N	\N	f	Sales which are qualified	0
52439_3310.0_2001-03-01	331000	\N	2001-03-01	52439	\N	\N	f	Sales which are qualified	0
52440_2270.0_2001-03-01	227000	\N	2001-03-01	52440	\N	\N	f	Sales which are qualified	0
52441_4801.0_2001-06-01	480100	\N	2001-06-01	52441	\N	\N	f	Sales which are qualified	0
52441_6500.0_2005-02-01	650000	\N	2005-02-01	52441	\N	\N	f	Sales which are qualified	0
52441_8550.0_2005-09-01	855000	\N	2005-09-01	52441	\N	\N	f	Sales which are qualified	0
52442_3220.0_2001-04-01	322000	\N	2001-04-01	52442	\N	\N	f	Sales which are qualified	0
52443_10500.0_2004-08-01	1050000	\N	2004-08-01	52443	\N	\N	f	Sales which are qualified	0
52443_7228.0_2001-06-01	722800	\N	2001-06-01	52443	\N	\N	f	Sales which are qualified	0
52444_16000.0_2015-04-13	1600000	\N	2015-04-13	52444	\N	\N	f	Qual by exam of deed	0
52444_21950.0_2021-01-05	2195000	\N	2021-01-05	52444	\N	\N	f	Qual by exam of deed	0
52444_5750.0_2002-08-01	575000	\N	2002-08-01	52444	\N	\N	f	Sales which are qualified	0
52444_8900.0_2009-05-27	890000	\N	2009-05-27	52444	\N	\N	f	Qual by exam of deed	0
52445_4500.0_2021-05-07	450000	\N	2021-05-07	52445	\N	\N	f	Qual by exam of deed	0
52445_7290.0_2001-03-01	729000	\N	2001-03-01	52445	\N	\N	f	Sales which are qualified	0
52446_3170.0_2001-04-01	317000	\N	2001-04-01	52446	\N	\N	f	Sales which are qualified	0
52446_4750.0_2001-09-01	475000	\N	2001-09-01	52446	\N	\N	f	Sales which are qualified	0
52446_6450.0_2004-05-01	645000	\N	2004-05-01	52446	\N	\N	f	Sales which are qualified	0
52447_5450.0_2002-05-01	545000	\N	2002-05-01	52447	\N	\N	f	Sales which are qualified	0
52447_6150.0_2003-07-01	615000	\N	2003-07-01	52447	\N	\N	f	Sales which are qualified	0
52448_2275.0_2001-04-01	227500	\N	2001-04-01	52448	\N	\N	f	Sales which are qualified	0
52448_3850.0_2003-04-01	385000	\N	2003-04-01	52448	\N	\N	f	Sales which are qualified	0
52448_4000.0_2003-07-01	400000	\N	2003-07-01	52448	\N	\N	f	Sales which are qualified	0
52448_5250.0_2011-12-20	525000	\N	2011-12-20	52448	\N	\N	f	Qual by exam of deed	0
52449_3280.0_2001-04-01	328000	\N	2001-04-01	52449	\N	\N	f	Sales which are qualified	0
52449_8100.0_2012-07-12	810000	\N	2012-07-12	52449	\N	\N	f	Qual by exam of deed	0
52450_12950.0_2014-10-20	1295000	\N	2014-10-20	52450	\N	\N	f	Qual by exam of deed	0
52450_13750.0_2021-10-21	1375000	\N	2021-10-21	52450	\N	\N	f	Qual by exam of deed	0
52450_5050.0_2002-06-01	505000	\N	2002-06-01	52450	\N	\N	f	Sales which are qualified	0
52451_10500.0_2011-01-14	1050000	\N	2011-01-14	52451	\N	\N	f	Qual by exam of deed	0
52451_4120.0_2002-03-01	412000	\N	2002-03-01	52451	\N	\N	f	Sales which are qualified	0
52451_8580.22_2009-06-18	858022	\N	2009-06-18	52451	\N	\N	f	Qual by exam of deed	0
52452_14000.0_2013-12-09	1400000	\N	2013-12-09	52452	\N	\N	f	Qual by exam of deed	0
52452_14250.0_2019-09-20	1425000	\N	2019-09-20	52452	\N	\N	f	Qual by exam of deed	0
52452_16500.0_2021-05-19	1650000	\N	2021-05-19	52452	\N	\N	f	Qual by exam of deed	0
52452_5800.0_2002-07-01	580000	\N	2002-07-01	52452	\N	\N	f	Sales which are qualified	0
52452_9100.0_2008-07-01	910000	\N	2008-07-01	52452	\N	\N	f	Sales which are qualified	0
52453_19000.0_2013-09-09	1900000	\N	2013-09-09	52453	\N	\N	f	Qual by exam of deed	0
52453_5290.0_2001-05-01	529000	\N	2001-05-01	52453	\N	\N	f	Sales which are qualified	0
52453_7250.0_2002-06-01	725000	\N	2002-06-01	52453	\N	\N	f	Sales which are qualified	0
52454_17500.0_2023-09-15	1750000	\N	2023-09-15	52454	\N	\N	f	Qual by exam of deed	0
52454_3480.0_2002-02-01	348000	\N	2002-02-01	52454	\N	\N	f	Sales which are qualified	0
52455_3350.0_2001-05-01	335000	\N	2001-05-01	52455	\N	\N	f	Sales which are qualified	0
52455_5050.0_2001-06-01	505000	\N	2001-06-01	52455	\N	\N	f	Sales which are qualified	0
52455_6250.0_2004-02-01	625000	\N	2004-02-01	52455	\N	\N	f	Sales which are qualified	0
52456_2280.0_2001-05-01	228000	\N	2001-05-01	52456	\N	\N	f	Sales which are qualified	0
52456_3900.0_2003-04-01	390000	\N	2003-04-01	52456	\N	\N	f	Sales which are qualified	0
52457_11200.0_2019-05-16	1120000	\N	2019-05-16	52457	\N	\N	f	Qual by exam of deed	0
52457_4800.0_2001-06-01	480000	\N	2001-06-01	52457	\N	\N	f	Sales which are qualified	0
52458_5100.0_2002-10-01	510000	\N	2002-10-01	52458	\N	\N	f	Sales which are qualified	0
52459_6815.0_2001-05-01	681500	\N	2001-05-01	52459	\N	\N	f	Sales which are qualified	0
52459_8000.0_2005-05-01	800000	\N	2005-05-01	52459	\N	\N	f	Sales which are qualified	0
52460_5850.0_2002-06-01	585000	\N	2002-06-01	52460	\N	\N	f	Sales which are qualified	0
52461_7393.0_2001-05-01	739300	\N	2001-05-01	52461	\N	\N	f	Sales which are qualified	0
52462_3600.0_2003-04-01	360000	\N	2003-04-01	52462	\N	\N	f	Sales which are qualified	0
52462_7250.0_2004-08-01	725000	\N	2004-08-01	52462	\N	\N	f	Sales which are qualified	0
52462_7800.0_2011-05-15	780000	\N	2011-05-15	52462	\N	\N	f	Qual by exam of deed	0
52462_9250.0_2008-07-01	925000	\N	2008-07-01	52462	\N	\N	f	Sales which are qualified	0
52463_4089.0_2001-05-01	408900	\N	2001-05-01	52463	\N	\N	f	Sales which are qualified	0
52463_8800.0_2014-05-22	880000	\N	2014-05-22	52463	\N	\N	f	Qual by exam of deed	0
52464_3929.0_2003-05-01	392900	\N	2003-05-01	52464	\N	\N	f	Sales which are qualified	0
52465_14000.0_2017-06-21	1400000	\N	2017-06-21	52465	\N	\N	f	Qual by exam of deed	0
52465_3320.0_2001-06-01	332000	\N	2001-06-01	52465	\N	\N	f	Sales which are qualified	0
52465_4880.0_2003-03-01	488000	\N	2003-03-01	52465	\N	\N	f	Sales which are qualified	0
52465_5200.0_2003-10-01	520000	\N	2003-10-01	52465	\N	\N	f	Sales which are qualified	0
52466_4500.0_2002-02-01	450000	\N	2002-02-01	52466	\N	\N	f	Sales which are qualified	0
52466_6900.0_2004-08-01	690000	\N	2004-08-01	52466	\N	\N	f	Sales which are qualified	0
52466_7500.0_2008-03-01	750000	\N	2008-03-01	52466	\N	\N	f	Sales which are qualified	0
52467_11550.0_2005-02-01	1155000	\N	2005-02-01	52467	\N	\N	f	Sales which are qualified	0
52467_15100.0_2013-03-25	1510000	\N	2013-03-25	52467	\N	\N	f	Qual by exam of deed	0
52467_7138.5_2001-09-01	713850	\N	2001-09-01	52467	\N	\N	f	Sales which are qualified	0
52467_9400.0_2009-02-17	940000	\N	2009-02-17	52467	\N	\N	f	Qual by exam of deed	0
52468_12750.0_2020-04-06	1275000	\N	2020-04-06	52468	\N	\N	f	Qual by exam of deed	0
52468_5850.0_2002-05-01	585000	\N	2002-05-01	52468	\N	\N	f	Sales which are qualified	0
52469_13250.0_2011-06-17	1325000	\N	2011-06-17	52469	\N	\N	f	Qual by exam of deed	0
52469_14250.0_2005-03-01	1425000	\N	2005-03-01	52469	\N	\N	f	Sales which are qualified	0
52469_7100.0_2002-02-01	710000	\N	2002-02-01	52469	\N	\N	f	Sales which are qualified	0
52469_8950.0_2010-04-30	895000	\N	2010-04-30	52469	\N	\N	f	Qual by exam of deed	0
52469_9625.0_2004-08-01	962500	\N	2004-08-01	52469	\N	\N	f	Sales which are qualified	0
52470_3520.0_2001-06-01	352000	\N	2001-06-01	52470	\N	\N	f	Sales which are qualified	0
52470_4700.0_2001-10-01	470000	\N	2001-10-01	52470	\N	\N	f	Sales which are qualified	0
52471_3390.0_2001-06-01	339000	\N	2001-06-01	52471	\N	\N	f	Sales which are qualified	0
52471_5210.0_2001-07-01	521000	\N	2001-07-01	52471	\N	\N	f	Sales which are qualified	0
52471_8600.0_2012-03-30	860000	\N	2012-03-30	52471	\N	\N	f	Qual by exam of deed	0
52472_2290.0_2001-06-01	229000	\N	2001-06-01	52472	\N	\N	f	Sales which are qualified	0
52472_3750.0_2001-06-01	375000	\N	2001-06-01	52472	\N	\N	f	Sales which are qualified	0
52472_3900.0_2002-12-01	390000	\N	2002-12-01	52472	\N	\N	f	Sales which are qualified	0
52473_4950.0_2002-04-01	495000	\N	2002-04-01	52473	\N	\N	f	Sales which are qualified	0
52473_7500.0_2012-01-30	750000	\N	2012-01-30	52473	\N	\N	f	Qual by exam of deed	0
52474_4950.0_2003-07-01	495000	\N	2003-07-01	52474	\N	\N	f	Sales which are qualified	0
52475_8100.0_2011-07-21	810000	\N	2011-07-21	52475	\N	\N	f	Qual by exam of deed	0
52476_4956.0_2001-05-01	495600	\N	2001-05-01	52476	\N	\N	f	Sales which are qualified	0
52476_5890.0_2004-07-01	589000	\N	2004-07-01	52476	\N	\N	f	Sales which are qualified	0
52477_3410.0_2001-05-01	341000	\N	2001-05-01	52477	\N	\N	f	Sales which are qualified	0
52478_2325.0_2001-05-01	232500	\N	2001-05-01	52478	\N	\N	f	Sales which are qualified	0
52479_11075.0_2018-06-06	1107500	\N	2018-06-06	52479	\N	\N	f	Qual by exam of deed	0
52479_5100.0_2002-12-01	510000	\N	2002-12-01	52479	\N	\N	f	Sales which are qualified	0
52479_6850.0_2011-01-20	685000	\N	2011-01-20	52479	\N	\N	f	Qual by exam of deed	0
52480_10000.0_2020-08-19	1000000	\N	2020-08-19	52480	\N	\N	f	Qual by exam of deed	0
52480_5050.0_2003-08-01	505000	\N	2003-08-01	52480	\N	\N	f	Sales which are qualified	0
52480_7160.0_2010-09-03	716000	\N	2010-09-03	52480	\N	\N	f	Qual by exam of deed	0
52480_8250.0_2005-05-01	825000	\N	2005-05-01	52480	\N	\N	f	Sales which are qualified	0
52481_10500.0_2006-02-01	1050000	\N	2006-02-01	52481	\N	\N	f	Sales which are qualified	0
52481_14000.0_2008-08-01	1400000	\N	2008-08-01	52481	\N	\N	f	Sales which are qualified	0
52481_14700.0_2012-12-09	1470000	\N	2012-12-09	52481	\N	\N	f	Qual by exam of deed	0
52481_22300.0_2014-12-09	2230000	\N	2014-12-09	52481	\N	\N	f	Qual by exam of deed	0
52481_41100.0_2021-10-11	4110000	\N	2021-10-11	52481	\N	\N	f	Qual by exam of deed	0
52481_6552.0_2002-12-01	655200	\N	2002-12-01	52481	\N	\N	f	Sales which are qualified	0
52481_9700.0_2003-06-01	970000	\N	2003-06-01	52481	\N	\N	f	Sales which are qualified	0
52482_21000.0_2020-11-10	2100000	\N	2020-11-10	52482	\N	\N	f	Qual by exam of deed	0
52482_21500.0_2021-02-11	2150000	\N	2021-02-11	52482	\N	\N	f	Qual by exam of deed	0
52482_4148.0_2001-05-01	414800	\N	2001-05-01	52482	\N	\N	f	Sales which are qualified	0
52483_3420.0_2001-05-01	342000	\N	2001-05-01	52483	\N	\N	f	Sales which are qualified	0
52483_3420.0_2001-06-01	342000	\N	2001-06-01	52483	\N	\N	f	Sales which are qualified	0
52483_7400.0_2004-09-01	740000	\N	2004-09-01	52483	\N	\N	f	Sales which are qualified	0
52483_7800.0_2009-09-15	780000	\N	2009-09-15	52483	\N	\N	f	Qual by exam of deed	0
52483_9070.0_2005-08-01	907000	\N	2005-08-01	52483	\N	\N	f	Sales which are qualified	0
52483_9600.0_2020-09-22	960000	\N	2020-09-22	52483	\N	\N	f	Qual by exam of deed	0
52484_3430.0_2001-05-01	343000	\N	2001-05-01	52484	\N	\N	f	Sales which are qualified	0
52485_2330.0_2001-05-01	233000	\N	2001-05-01	52485	\N	\N	f	Sales which are qualified	0
52485_3400.0_2002-04-01	340000	\N	2002-04-01	52485	\N	\N	f	Sales which are qualified	0
52486_5050.0_2003-01-01	505000	\N	2003-01-01	52486	\N	\N	f	Sales which are qualified	0
52487_17330.0_2022-03-09	1733000	\N	2022-03-09	52487	\N	\N	f	Qual by exam of deed	0
52487_6300.0_2004-03-01	630000	\N	2004-03-01	52487	\N	\N	f	Sales which are qualified	0
52487_7150.0_2011-03-28	715000	\N	2011-03-28	52487	\N	\N	f	Qual by exam of deed	0
52487_8000.0_2005-03-01	800000	\N	2005-03-01	52487	\N	\N	f	Sales which are qualified	0
52488_11250.0_2010-01-09	1125000	\N	2010-01-09	52488	\N	\N	f	Qual by exam of deed	0
52488_6430.0_2002-02-01	643000	\N	2002-02-01	52488	\N	\N	f	Sales which are qualified	0
52488_7000.0_2003-09-01	700000	\N	2003-09-01	52488	\N	\N	f	Sales which are qualified	0
52489_6050.0_2004-01-01	605000	\N	2004-01-01	52489	\N	\N	f	Sales which are qualified	0
52489_7550.0_2004-05-01	755000	\N	2004-05-01	52489	\N	\N	f	Sales which are qualified	0
52489_8000.0_2010-11-11	800000	\N	2010-11-11	52489	\N	\N	f	Qual by exam of deed	0
52489_8800.0_2004-12-01	880000	\N	2004-12-01	52489	\N	\N	f	Sales which are qualified	0
52490_10000.0_2004-01-01	1000000	\N	2004-01-01	52490	\N	\N	f	Sales which are qualified	0
52490_17000.0_2005-10-01	1700000	\N	2005-10-01	52490	\N	\N	f	Sales which are qualified	0
52490_22390.0_2019-07-07	2239000	\N	2019-07-07	52490	\N	\N	f	Qual by exam of deed	0
52490_30000.0_2022-12-22	3000000	\N	2022-12-22	52490	\N	\N	f	Qual by exam of deed	0
52490_32655.0_2022-05-20	3265500	\N	2022-05-20	52490	\N	\N	f	Qual by exam of deed	0
52490_4600.0_2001-05-01	460000	\N	2001-05-01	52490	\N	\N	f	Sales which are qualified	0
52490_7305.0_2002-08-01	730500	\N	2002-08-01	52490	\N	\N	f	Sales which are qualified	0
52491_3460.0_2001-08-01	346000	\N	2001-08-01	52491	\N	\N	f	Sales which are qualified	0
52491_4750.0_2002-12-01	475000	\N	2002-12-01	52491	\N	\N	f	Sales which are qualified	0
52491_5380.0_2002-05-01	538000	\N	2002-05-01	52491	\N	\N	f	Sales which are qualified	0
52492_14000.0_2016-07-21	1400000	\N	2016-07-21	52492	\N	\N	f	Qual by exam of deed	0
52492_3450.0_2001-06-01	345000	\N	2001-06-01	52492	\N	\N	f	Sales which are qualified	0
52492_9600.0_2006-08-01	960000	\N	2006-08-01	52492	\N	\N	f	Sales which are qualified	0
52493_2305.0_2001-05-01	230500	\N	2001-05-01	52493	\N	\N	f	Sales which are qualified	0
52493_5000.0_2009-05-28	500000	\N	2009-05-28	52493	\N	\N	f	Qual by exam of deed	0
52494_10250.0_2018-03-07	1025000	\N	2018-03-07	52494	\N	\N	f	Qual by exam of deed	0
52494_14125.0_2019-10-04	1412500	\N	2019-10-04	52494	\N	\N	f	Qual by exam of deed	0
52494_5100.0_2003-01-01	510000	\N	2003-01-01	52494	\N	\N	f	Sales which are qualified	0
52495_6646.2_2004-04-01	664620	\N	2004-04-01	52495	\N	\N	f	Sales which are qualified	0
52495_7500.0_2007-07-01	750000	\N	2007-07-01	52495	\N	\N	f	Sales which are qualified	0
52496_10000.0_2009-03-27	1000000	\N	2009-03-27	52496	\N	\N	f	Qual by exam of deed	0
52496_19000.0_2018-04-23	1900000	\N	2018-04-23	52496	\N	\N	f	Qual by exam of deed	0
52496_6950.0_2002-07-01	695000	\N	2002-07-01	52496	\N	\N	f	Sales which are qualified	0
52497_12850.0_2020-02-24	1285000	\N	2020-02-24	52497	\N	\N	f	Qual by exam of deed	0
52497_7320.0_2004-05-01	732000	\N	2004-05-01	52497	\N	\N	f	Sales which are qualified	0
52498_10750.0_2004-10-01	1075000	\N	2004-10-01	52498	\N	\N	f	Sales which are qualified	0
52498_13750.0_2004-12-01	1375000	\N	2004-12-01	52498	\N	\N	f	Sales which are qualified	0
52498_5590.0_2001-06-01	559000	\N	2001-06-01	52498	\N	\N	f	Sales which are qualified	0
52498_7500.0_2001-10-01	750000	\N	2001-10-01	52498	\N	\N	f	Sales which are qualified	0
52499_11000.0_2007-01-01	1100000	\N	2007-01-01	52499	\N	\N	f	Sales which are qualified	0
52499_14250.0_2021-07-27	1425000	\N	2021-07-27	52499	\N	\N	f	Qual by exam of deed	0
52499_3700.0_2001-05-01	370000	\N	2001-05-01	52499	\N	\N	f	Sales which are qualified	0
52499_7500.0_2005-02-01	750000	\N	2005-02-01	52499	\N	\N	f	Sales which are qualified	0
52499_9000.0_2014-02-28	900000	\N	2014-02-28	52499	\N	\N	f	Qual by exam of deed	0
52500_3470.0_2001-05-01	347000	\N	2001-05-01	52500	\N	\N	f	Sales which are qualified	0
52500_4550.0_2001-05-01	455000	\N	2001-05-01	52500	\N	\N	f	Sales which are qualified	0
52500_8250.0_2011-05-04	825000	\N	2011-05-04	52500	\N	\N	f	Qual by exam of deed	0
52500_9250.0_2008-01-01	925000	\N	2008-01-01	52500	\N	\N	f	Sales which are qualified	0
52501_4350.0_2003-08-01	435000	\N	2003-08-01	52501	\N	\N	f	Sales which are qualified	0
52501_6040.0_2005-12-01	604000	\N	2005-12-01	52501	\N	\N	f	Sales which are qualified	0
52501_7700.0_2014-12-08	770000	\N	2014-12-08	52501	\N	\N	f	Qual by exam of deed	0
52502_14000.0_2018-03-07	1400000	\N	2018-03-07	52502	\N	\N	f	Qual by exam of deed	0
52502_5200.0_2003-03-01	520000	\N	2003-03-01	52502	\N	\N	f	Sales which are qualified	0
52503_6900.0_2004-10-01	690000	\N	2004-10-01	52503	\N	\N	f	Sales which are qualified	0
52504_10800.0_2009-07-24	1080000	\N	2009-07-24	52504	\N	\N	f	Qual by exam of deed	0
52504_7000.0_2002-04-01	700000	\N	2002-04-01	52504	\N	\N	f	Sales which are qualified	0
52505_6150.0_2003-12-01	615000	\N	2003-12-01	52505	\N	\N	f	Sales which are qualified	0
52505_9300.0_2007-05-01	930000	\N	2007-05-01	52505	\N	\N	f	Sales which are qualified	0
52506_7368.0_2001-05-01	736800	\N	2001-05-01	52506	\N	\N	f	Sales which are qualified	0
52507_11500.0_2021-08-31	1150000	\N	2021-08-31	52507	\N	\N	f	Qual by exam of deed	0
52507_14750.0_2021-10-27	1475000	\N	2021-10-27	52507	\N	\N	f	Qual by exam of deed	0
52507_5350.0_2002-05-01	535000	\N	2002-05-01	52507	\N	\N	f	Sales which are qualified	0
52508_3490.0_2001-05-01	349000	\N	2001-05-01	52508	\N	\N	f	Sales which are qualified	0
52509_2325.0_2001-05-01	232500	\N	2001-05-01	52509	\N	\N	f	Sales which are qualified	0
52509_3750.0_2001-07-01	375000	\N	2001-07-01	52509	\N	\N	f	Sales which are qualified	0
52509_7650.0_2014-12-05	765000	\N	2014-12-05	52509	\N	\N	f	Qual by exam of deed	0
52509_8200.0_2020-03-26	820000	\N	2020-03-26	52509	\N	\N	f	Qual by exam of deed	0
52510_13400.0_2021-05-04	1340000	\N	2021-05-04	52510	\N	\N	f	Qual by exam of deed	0
52510_5000.0_2003-07-01	500000	\N	2003-07-01	52510	\N	\N	f	Sales which are qualified	0
52511_7356.0_2004-11-01	735600	\N	2004-11-01	52511	\N	\N	f	Sales which are qualified	0
52511_9264.0_2014-02-27	926400	\N	2014-02-27	52511	\N	\N	f	Qual by exam of deed	0
52512_11550.0_2010-08-06	1155000	\N	2010-08-06	52512	\N	\N	f	Qual by exam of deed	0
52512_7050.0_2002-08-01	705000	\N	2002-08-01	52512	\N	\N	f	Sales which are qualified	0
52513_7000.0_2001-05-01	700000	\N	2001-05-01	52513	\N	\N	f	Sales which are qualified	0
52514_11260.0_2021-02-04	1126000	\N	2021-02-04	52514	\N	\N	f	Qual by exam of deed	0
52514_3560.0_2001-05-01	356000	\N	2001-05-01	52514	\N	\N	f	Sales which are qualified	0
52515_3510.0_2001-05-01	351000	\N	2001-05-01	52515	\N	\N	f	Sales which are qualified	0
52516_2340.0_2001-05-01	234000	\N	2001-05-01	52516	\N	\N	f	Sales which are qualified	0
52516_3420.0_2002-04-01	342000	\N	2002-04-01	52516	\N	\N	f	Sales which are qualified	0
52516_3850.0_2002-06-01	385000	\N	2002-06-01	52516	\N	\N	f	Sales which are qualified	0
52517_11450.0_2018-09-26	1145000	\N	2018-09-26	52517	\N	\N	f	Qual by exam of deed	0
52517_5200.0_2003-05-01	520000	\N	2003-05-01	52517	\N	\N	f	Sales which are qualified	0
52518_9100.0_2013-07-23	910000	\N	2013-07-23	52518	\N	\N	f	Qual by exam of deed	0
52518_9157.0_2005-08-01	915700	\N	2005-08-01	52518	\N	\N	f	Sales which are qualified	0
52519_7100.0_2002-09-01	710000	\N	2002-09-01	52519	\N	\N	f	Sales which are qualified	0
52520_10000.0_2008-05-01	1000000	\N	2008-05-01	52520	\N	\N	f	Sales which are qualified	0
52520_17000.0_2022-01-18	1700000	\N	2022-01-18	52520	\N	\N	f	Qual by exam of deed	0
52520_6250.0_2003-02-01	625000	\N	2003-02-01	52520	\N	\N	f	Sales which are qualified	0
52520_9750.0_2012-03-23	975000	\N	2012-03-23	52520	\N	\N	f	Qual by exam of deed	0
52521_17500.0_2006-03-01	1750000	\N	2006-03-01	52521	\N	\N	f	Sales which are qualified	0
52521_19000.0_2012-09-13	1900000	\N	2012-09-13	52521	\N	\N	f	Qual by exam of deed	0
52521_5960.0_2001-08-01	596000	\N	2001-08-01	52521	\N	\N	f	Sales which are qualified	0
52521_7000.0_2002-03-01	700000	\N	2002-03-01	52521	\N	\N	f	Sales which are qualified	0
52522_5450.0_2002-07-01	545000	\N	2002-07-01	52522	\N	\N	f	Sales which are qualified	0
52522_8225.0_2009-05-20	822500	\N	2009-05-20	52522	\N	\N	f	Qual by exam of deed	0
52523_3530.0_2001-08-01	353000	\N	2001-08-01	52523	\N	\N	f	Sales which are qualified	0
52524_2350.0_2001-09-01	235000	\N	2001-09-01	52524	\N	\N	f	Sales which are qualified	0
52524_2355.0_2001-09-01	235500	\N	2001-09-01	52524	\N	\N	f	Sales which are qualified	0
52524_9500.0_2022-04-25	950000	\N	2022-04-25	52524	\N	\N	f	Qual by exam of deed	0
52525_5300.0_2003-06-01	530000	\N	2003-06-01	52525	\N	\N	f	Sales which are qualified	0
52525_9000.0_2013-04-26	900000	\N	2013-04-26	52525	\N	\N	f	Qual by exam of deed	0
52526_7620.0_2004-12-01	762000	\N	2004-12-01	52526	\N	\N	f	Sales which are qualified	0
52527_7200.0_2002-06-01	720000	\N	2002-06-01	52527	\N	\N	f	Sales which are qualified	0
52528_10900.0_2012-05-03	1090000	\N	2012-05-03	52528	\N	\N	f	Qual by exam of deed	0
52528_11000.0_2006-01-01	1100000	\N	2006-01-01	52528	\N	\N	f	Sales which are qualified	0
52528_15200.0_2017-10-09	1520000	\N	2017-10-09	52528	\N	\N	f	Qual by exam of deed	0
52528_7680.0_2003-10-01	768000	\N	2003-10-01	52528	\N	\N	f	Sales which are qualified	0
52529_16000.0_2008-04-01	1600000	\N	2008-04-01	52529	\N	\N	f	Sales which are qualified	0
52529_25850.0_2017-12-21	2585000	\N	2017-12-21	52529	\N	\N	f	Qual by exam of deed	0
52529_35500.0_2022-09-28	3550000	\N	2022-09-28	52529	\N	\N	f	Qual by exam of deed	0
52529_5770.0_2001-11-01	577000	\N	2001-11-01	52529	\N	\N	f	Sales which are qualified	0
52530_5600.0_2002-06-01	560000	\N	2002-06-01	52530	\N	\N	f	Sales which are qualified	0
52530_8250.0_2010-04-30	825000	\N	2010-04-30	52530	\N	\N	f	Qual by exam of deed	0
52531_3550.0_2001-08-01	355000	\N	2001-08-01	52531	\N	\N	f	Sales which are qualified	0
52532_2370.0_2001-08-01	237000	\N	2001-08-01	52532	\N	\N	f	Sales which are qualified	0
52532_3625.0_2002-04-01	362500	\N	2002-04-01	52532	\N	\N	f	Sales which are qualified	0
52532_5750.0_2008-05-01	575000	\N	2008-05-01	52532	\N	\N	f	Sales which are qualified	0
52532_9800.0_2015-06-29	980000	\N	2015-06-29	52532	\N	\N	f	Qual by exam of deed	0
52533_5550.0_2003-03-01	555000	\N	2003-03-01	52533	\N	\N	f	Sales which are qualified	0
52533_8150.0_2009-12-14	815000	\N	2009-12-14	52533	\N	\N	f	Qual by exam of deed	0
52534_6950.0_2009-09-30	695000	\N	2009-09-30	52534	\N	\N	f	Qual by exam of deed	0
52534_8599.5_2005-03-01	859950	\N	2005-03-01	52534	\N	\N	f	Sales which are qualified	0
52534_9300.0_2006-06-01	930000	\N	2006-06-01	52534	\N	\N	f	Sales which are qualified	0
52535_28000.0_2022-10-21	2800000	\N	2022-10-21	52535	\N	\N	f	Qual by exam of deed	0
52535_4900.0_2001-11-01	490000	\N	2001-11-01	52535	\N	\N	f	Sales which are qualified	0
52536_3590.0_2001-03-01	359000	\N	2001-03-01	52536	\N	\N	f	Sales which are qualified	0
52536_4250.0_2001-04-01	425000	\N	2001-04-01	52536	\N	\N	f	Sales which are qualified	0
52536_6750.0_2004-05-01	675000	\N	2004-05-01	52536	\N	\N	f	Sales which are qualified	0
52537_10000.0_2008-12-29	1000000	\N	2008-12-29	52537	\N	\N	f	Sales which are qualified	0
52537_3700.0_2001-03-01	370000	\N	2001-03-01	52537	\N	\N	f	Sales which are qualified	0
52538_15000.0_2013-04-04	1500000	\N	2013-04-04	52538	\N	\N	f	Qual by exam of deed	0
52538_3830.0_2001-03-01	383000	\N	2001-03-01	52538	\N	\N	f	Sales which are qualified	0
52538_7250.0_2008-05-01	725000	\N	2008-05-01	52538	\N	\N	f	Sales which are qualified	0
52539_12400.0_2013-10-29	1240000	\N	2013-10-29	52539	\N	\N	f	Qual by exam of deed	0
52539_3660.0_2001-03-01	366000	\N	2001-03-01	52539	\N	\N	f	Sales which are qualified	0
52539_4450.0_2001-03-01	445000	\N	2001-03-01	52539	\N	\N	f	Sales which are qualified	0
52539_9000.0_2006-09-01	900000	\N	2006-09-01	52539	\N	\N	f	Sales which are qualified	0
52540_3550.0_2001-03-01	355000	\N	2001-03-01	52540	\N	\N	f	Sales which are qualified	0
52540_5150.0_2001-03-01	515000	\N	2001-03-01	52540	\N	\N	f	Sales which are qualified	0
52541_12550.0_2022-03-08	1255000	\N	2022-03-08	52541	\N	\N	f	Qual by exam of deed	0
52541_2330.0_2001-04-01	233000	\N	2001-04-01	52541	\N	\N	f	Sales which are qualified	0
52541_7000.0_2020-11-04	700000	\N	2020-11-04	52541	\N	\N	f	Qual by exam of deed	0
52542_4880.0_2008-03-01	488000	\N	2008-03-01	52542	\N	\N	f	Sales which are qualified	0
52542_6165.0_2007-06-01	616500	\N	2007-06-01	52542	\N	\N	f	Sales which are qualified	0
52542_6725.0_2013-12-16	672500	\N	2013-12-16	52542	\N	\N	f	Qual by exam of deed	0
52542_8750.0_2015-02-17	875000	\N	2015-02-17	52542	\N	\N	f	Qual by exam of deed	0
52543_1950.0_2001-02-01	195000	\N	2001-02-01	52543	\N	\N	f	Sales which are qualified	0
52543_6450.0_2015-02-05	645000	\N	2015-02-05	52543	\N	\N	f	Qual by exam of deed	0
52544_7000.0_2013-03-25	700000	\N	2013-03-25	52544	\N	\N	f	Qual by exam of deed	0
52545_2530.0_2001-04-01	253000	\N	2001-04-01	52545	\N	\N	f	Sales which are qualified	0
52545_4500.0_2004-02-01	450000	\N	2004-02-01	52545	\N	\N	f	Sales which are qualified	0
52545_5800.0_2012-07-27	580000	\N	2012-07-27	52545	\N	\N	f	Qual by exam of deed	0
52545_6500.0_2007-08-01	650000	\N	2007-08-01	52545	\N	\N	f	Sales which are qualified	0
52546_3860.0_2001-05-01	386000	\N	2001-05-01	52546	\N	\N	f	Sales which are qualified	0
52547_3600.0_2001-05-01	360000	\N	2001-05-01	52547	\N	\N	f	Sales which are qualified	0
52548_3660.0_2001-03-01	366000	\N	2001-03-01	52548	\N	\N	f	Sales which are qualified	0
52549_2350.0_2001-03-01	235000	\N	2001-03-01	52549	\N	\N	f	Sales which are qualified	0
52550_3800.0_2003-06-01	380000	\N	2003-06-01	52550	\N	\N	f	Sales which are qualified	0
52550_7000.0_2005-07-01	700000	\N	2005-07-01	52550	\N	\N	f	Sales which are qualified	0
52550_7850.0_2006-02-01	785000	\N	2006-02-01	52550	\N	\N	f	Sales which are qualified	0
52551_3050.0_2002-04-01	305000	\N	2002-04-01	52551	\N	\N	f	Sales which are qualified	0
52552_3900.0_2002-06-01	390000	\N	2002-06-01	52552	\N	\N	f	Sales which are qualified	0
52552_4250.0_2003-07-01	425000	\N	2003-07-01	52552	\N	\N	f	Sales which are qualified	0
52552_6000.0_2011-10-07	600000	\N	2011-10-07	52552	\N	\N	f	Qual by exam of deed	0
52553_2550.0_2001-03-01	255000	\N	2001-03-01	52553	\N	\N	f	Sales which are qualified	0
52554_4750.0_2001-03-01	475000	\N	2001-03-01	52554	\N	\N	f	Sales which are qualified	0
52554_9900.0_2004-12-01	990000	\N	2004-12-01	52554	\N	\N	f	Sales which are qualified	0
52555_3550.0_2001-08-01	355000	\N	2001-08-01	52555	\N	\N	f	Sales which are qualified	0
52555_6500.0_2004-03-01	650000	\N	2004-03-01	52555	\N	\N	f	Sales which are qualified	0
52555_8900.0_2008-03-01	890000	\N	2008-03-01	52555	\N	\N	f	Sales which are qualified	0
52556_13750.0_2021-05-07	1375000	\N	2021-05-07	52556	\N	\N	f	Qual by exam of deed	0
52556_3690.0_2001-08-01	369000	\N	2001-08-01	52556	\N	\N	f	Sales which are qualified	0
52557_2409.0_2001-03-01	240900	\N	2001-03-01	52557	\N	\N	f	Sales which are qualified	0
52557_3500.0_2001-07-01	350000	\N	2001-07-01	52557	\N	\N	f	Sales which are qualified	0
52557_6540.0_2008-08-01	654000	\N	2008-08-01	52557	\N	\N	f	Sales which are qualified	0
52557_8350.0_2020-01-28	835000	\N	2020-01-28	52557	\N	\N	f	Qual by exam of deed	0
52558_3900.0_2002-12-01	390000	\N	2002-12-01	52558	\N	\N	f	Sales which are qualified	0
52558_8000.0_2017-12-15	800000	\N	2017-12-15	52558	\N	\N	f	Qual by exam of deed	0
52559_1940.0_2001-02-01	194000	\N	2001-02-01	52559	\N	\N	f	Sales which are qualified	0
52559_4900.0_2009-02-20	490000	\N	2009-02-20	52559	\N	\N	f	Qual by exam of deed	0
52560_2520.0_2001-03-01	252000	\N	2001-03-01	52560	\N	\N	f	Sales which are qualified	0
52560_3800.0_2001-12-01	380000	\N	2001-12-01	52560	\N	\N	f	Sales which are qualified	0
52560_4900.0_2003-10-01	490000	\N	2003-10-01	52560	\N	\N	f	Sales which are qualified	0
52560_6500.0_2007-05-24	650000	\N	2007-05-24	52560	\N	\N	f	Sales which are qualified	0
52560_6525.0_2008-08-27	652500	\N	2008-08-27	52560	\N	\N	f	Sales which are qualified	0
52561_3050.0_2001-03-01	305000	\N	2001-03-01	52561	\N	\N	f	Sales which are qualified	0
52561_6400.0_2005-03-01	640000	\N	2005-03-01	52561	\N	\N	f	Sales which are qualified	0
52562_11750.0_2008-06-01	1175000	\N	2008-06-01	52562	\N	\N	f	Sales which are qualified	0
52562_3920.0_2001-02-01	392000	\N	2001-02-01	52562	\N	\N	f	Sales which are qualified	0
52562_5600.0_2001-03-01	560000	\N	2001-03-01	52562	\N	\N	f	Sales which are qualified	0
52563_8280.0_2004-05-01	828000	\N	2004-05-01	52563	\N	\N	t	Deeds that include more than one parcel	0
52564_8280.0_2004-05-01	828000	\N	2004-05-01	52564	\N	\N	t	Deeds that include more than one parcel	0
52565_2500.0_2001-05-01	250000	\N	2001-05-01	52565	\N	\N	f	Sales which are qualified	0
52565_3250.0_2001-05-01	325000	\N	2001-05-01	52565	\N	\N	f	Sales which are qualified	0
52565_3250.0_2001-10-01	325000	\N	2001-10-01	52565	\N	\N	f	Sales which are qualified	0
52565_4600.0_2002-10-01	460000	\N	2002-10-01	52565	\N	\N	f	Sales which are qualified	0
52565_6850.0_2005-03-01	685000	\N	2005-03-01	52565	\N	\N	f	Sales which are qualified	0
52565_7370.0_2006-06-01	737000	\N	2006-06-01	52565	\N	\N	f	Sales which are qualified	0
52565_8400.0_2013-12-23	840000	\N	2013-12-23	52565	\N	\N	f	Qual by exam of deed	0
52566_2440.0_2001-02-01	244000	\N	2001-02-01	52566	\N	\N	f	Sales which are qualified	0
52566_3080.0_2001-11-01	308000	\N	2001-11-01	52566	\N	\N	f	Sales which are qualified	0
52566_4670.0_2003-08-01	467000	\N	2003-08-01	52566	\N	\N	f	Sales which are qualified	0
52567_1955.0_2001-05-01	195500	\N	2001-05-01	52567	\N	\N	f	Sales which are qualified	0
52568_2600.0_2001-04-01	260000	\N	2001-04-01	52568	\N	\N	f	Sales which are qualified	0
52569_3120.0_2001-03-01	312000	\N	2001-03-01	52569	\N	\N	f	Sales which are qualified	0
52570_12000.0_2007-06-01	1200000	\N	2007-06-01	52570	\N	\N	f	Sales which are qualified	0
52570_1640.0_2001-05-01	164000	\N	2001-05-01	52570	\N	\N	f	Sales which are qualified	0
52571_10100.0_2006-02-01	1010000	\N	2006-02-01	52571	\N	\N	f	Sales which are qualified	0
52571_4920.0_2001-05-01	492000	\N	2001-05-01	52571	\N	\N	f	Sales which are qualified	0
52571_5350.0_2001-05-01	535000	\N	2001-05-01	52571	\N	\N	f	Sales which are qualified	0
52572_3750.0_2001-03-01	375000	\N	2001-03-01	52572	\N	\N	f	Sales which are qualified	0
52573_2410.0_2001-04-01	241000	\N	2001-04-01	52573	\N	\N	f	Sales which are qualified	0
52573_3500.0_2002-03-01	350000	\N	2002-03-01	52573	\N	\N	f	Sales which are qualified	0
52573_9000.0_2021-08-05	900000	\N	2021-08-05	52573	\N	\N	f	Qual by exam of deed	0
52574_3900.0_2002-04-01	390000	\N	2002-04-01	52574	\N	\N	f	Sales which are qualified	0
52574_7750.0_2013-10-04	775000	\N	2013-10-04	52574	\N	\N	f	Qual by exam of deed	0
52574_7850.0_2005-10-01	785000	\N	2005-10-01	52574	\N	\N	f	Sales which are qualified	0
52575_1970.0_2001-03-01	197000	\N	2001-03-01	52575	\N	\N	f	Sales which are qualified	0
52576_2560.0_2001-03-01	256000	\N	2001-03-01	52576	\N	\N	f	Sales which are qualified	0
52576_3550.0_2001-04-01	355000	\N	2001-04-01	52576	\N	\N	f	Sales which are qualified	0
52577_2610.0_2001-02-01	261000	\N	2001-02-01	52577	\N	\N	f	Sales which are qualified	0
52577_3320.0_2001-04-01	332000	\N	2001-04-01	52577	\N	\N	f	Sales which are qualified	0
52606_5450.0_2002-02-01	545000	\N	2002-02-01	52606	\N	\N	f	Sales which are qualified	0
52606_7100.0_2002-08-01	710000	\N	2002-08-01	52606	\N	\N	f	Sales which are qualified	0
52607_10418.65_2005-04-01	1041865	\N	2005-04-01	52607	\N	\N	f	Sales which are qualified	0
52608_13000.0_2004-10-01	1300000	\N	2004-10-01	52608	\N	\N	f	Sales which are qualified	0
52608_5950.0_2002-02-01	595000	\N	2002-02-01	52608	\N	\N	f	Sales which are qualified	0
52608_8788.0_2002-04-01	878800	\N	2002-04-01	52608	\N	\N	f	Sales which are qualified	0
52609_11400.0_2006-02-01	1140000	\N	2006-02-01	52609	\N	\N	f	Sales which are qualified	0
52609_13340.0_2013-09-30	1334000	\N	2013-09-30	52609	\N	\N	f	Qual by exam of deed	0
52609_20000.0_2018-09-14	2000000	\N	2018-09-14	52609	\N	\N	f	Qual by exam of deed	0
52609_4150.0_2002-04-01	415000	\N	2002-04-01	52609	\N	\N	f	Sales which are qualified	0
52610_10800.0_2005-04-01	1080000	\N	2005-04-01	52610	\N	\N	f	Sales which are qualified	0
52610_12850.0_2018-06-11	1285000	\N	2018-06-11	52610	\N	\N	f	Qual by exam of deed	0
52610_3750.0_2002-02-01	375000	\N	2002-02-01	52610	\N	\N	f	Sales which are qualified	0
52610_6700.0_2002-11-01	670000	\N	2002-11-01	52610	\N	\N	f	Sales which are qualified	0
52611_2670.0_2003-09-01	267000	\N	2003-09-01	52611	\N	\N	f	Sales which are qualified	0
52612_10750.0_2005-08-01	1075000	\N	2005-08-01	52612	\N	\N	f	Sales which are qualified	0
52612_11500.0_2021-01-13	1150000	\N	2021-01-13	52612	\N	\N	f	Qual by exam of deed	0
52612_5500.0_2003-01-01	550000	\N	2003-01-01	52612	\N	\N	f	Sales which are qualified	0
52613_8700.0_2007-04-01	870000	\N	2007-04-01	52613	\N	\N	f	Sales which are qualified	0
52614_5550.0_2002-02-01	555000	\N	2002-02-01	52614	\N	\N	f	Sales which are qualified	0
52614_8250.0_2002-12-01	825000	\N	2002-12-01	52614	\N	\N	f	Sales which are qualified	0
52615_13750.0_2013-10-25	1375000	\N	2013-10-25	52615	\N	\N	f	Qual by exam of deed	0
52615_17000.0_2018-07-23	1700000	\N	2018-07-23	52615	\N	\N	f	Qual by exam of deed	0
52615_4780.0_2002-02-01	478000	\N	2002-02-01	52615	\N	\N	f	Sales which are qualified	0
52615_5820.0_2003-09-01	582000	\N	2003-09-01	52615	\N	\N	f	Sales which are qualified	0
52616_13100.0_2004-07-01	1310000	\N	2004-07-01	52616	\N	\N	f	Sales which are qualified	0
52616_15500.0_2010-12-15	1550000	\N	2010-12-15	52616	\N	\N	f	Qual by exam of deed	0
52616_6150.0_2002-02-01	615000	\N	2002-02-01	52616	\N	\N	f	Sales which are qualified	0
52616_9700.0_2002-08-01	970000	\N	2002-08-01	52616	\N	\N	f	Sales which are qualified	0
52617_14280.0_2019-12-06	1428000	\N	2019-12-06	52617	\N	\N	f	Qual by exam of deed	0
52617_5160.0_2002-03-01	516000	\N	2002-03-01	52617	\N	\N	f	Sales which are qualified	0
52617_8800.0_2004-04-01	880000	\N	2004-04-01	52617	\N	\N	f	Sales which are qualified	0
52618_14900.0_2013-10-15	1490000	\N	2013-10-15	52618	\N	\N	f	Qual by exam of deed	0
52618_4395.0_2002-02-01	439500	\N	2002-02-01	52618	\N	\N	f	Sales which are qualified	0
52619_11200.0_2014-07-14	1120000	\N	2014-07-14	52619	\N	\N	f	Qual by exam of deed	0
52619_3840.0_2002-02-01	384000	\N	2002-02-01	52619	\N	\N	f	Sales which are qualified	0
52619_8600.0_2020-03-09	860000	\N	2020-03-09	52619	\N	\N	f	Qual by exam of deed	0
52620_10500.0_2013-07-03	1050000	\N	2013-07-03	52620	\N	\N	f	Qual by exam of deed	0
52620_4729.0_2002-02-01	472900	\N	2002-02-01	52620	\N	\N	f	Sales which are qualified	0
52621_9300.0_2006-08-01	930000	\N	2006-08-01	52621	\N	\N	f	Sales which are qualified	0
52622_8500.0_2001-08-01	850000	\N	2001-08-01	52622	\N	\N	f	Sales which are qualified	0
52623_10850.0_2006-05-01	1085000	\N	2006-05-01	52623	\N	\N	f	Sales which are qualified	0
52623_7799.0_2001-08-01	779900	\N	2001-08-01	52623	\N	\N	f	Sales which are qualified	0
52624_31950.0_2021-04-21	3195000	\N	2021-04-21	52624	\N	\N	f	Qual by exam of deed	0
52624_6063.0_2002-04-01	606300	\N	2002-04-01	52624	\N	\N	f	Sales which are qualified	0
52624_9750.0_2002-07-01	975000	\N	2002-07-01	52624	\N	\N	f	Sales which are qualified	0
52625_19250.0_2016-03-10	1925000	\N	2016-03-10	52625	\N	\N	f	Qual by exam of deed	0
52625_5600.0_2002-05-01	560000	\N	2002-05-01	52625	\N	\N	f	Sales which are qualified	0
52626_3950.0_2002-02-01	395000	\N	2002-02-01	52626	\N	\N	f	Sales which are qualified	0
52626_7615.0_2009-09-30	761500	\N	2009-09-30	52626	\N	\N	f	Qual by exam of deed	0
52627_2800.0_2002-02-01	280000	\N	2002-02-01	52627	\N	\N	f	Sales which are qualified	0
52628_1590.0_2003-08-01	159000	\N	2003-08-01	52628	\N	\N	f	Sales which are qualified	0
52629_10500.0_2005-09-01	1050000	\N	2005-09-01	52629	\N	\N	f	Sales which are qualified	0
52630_25700.0_2006-11-01	2570000	\N	2006-11-01	52630	\N	\N	f	Sales which are qualified	0
52631_12500.0_2005-08-01	1250000	\N	2005-08-01	52631	\N	\N	f	Sales which are qualified	0
52632_28000.0_2004-04-01	2800000	\N	2004-04-01	52632	\N	\N	f	Sales which are qualified	0
52633_20000.0_2006-08-01	2000000	\N	2006-08-01	52633	\N	\N	f	Sales which are qualified	0
52633_22000.0_2012-05-04	2200000	\N	2012-05-04	52633	\N	\N	f	Qual by exam of deed	0
52635_2870.0_2002-02-01	287000	\N	2002-02-01	52635	\N	\N	f	Sales which are qualified	0
52635_4100.0_2004-05-01	410000	\N	2004-05-01	52635	\N	\N	f	Sales which are qualified	0
52636_20000.0_2004-10-01	2000000	\N	2004-10-01	52636	\N	\N	f	Sales which are qualified	0
52637_18375.0_2007-05-01	1837500	\N	2007-05-01	52637	\N	\N	f	Sales which are qualified	0
52637_26500.0_2016-03-31	2650000	\N	2016-03-31	52637	\N	\N	f	Qual by exam of deed	0
52638_46000.0_2019-02-15	4600000	\N	2019-02-15	52638	\N	\N	f	Qual by exam of deed	0
52638_46500.0_2022-03-11	4650000	\N	2022-03-11	52638	\N	\N	f	Qual by exam of deed	0
52639_34673.0_2020-08-18	3467300	\N	2020-08-18	52639	\N	\N	f	Qual by exam of deed	0
52639_40000.0_2019-02-14	4000000	\N	2019-02-14	52639	\N	\N	f	Qual by exam of deed	0
52640_40000.0_2019-01-25	4000000	\N	2019-01-25	52640	\N	\N	f	Qual by exam of deed	0
52641_42750.0_2019-02-01	4275000	\N	2019-02-01	52641	\N	\N	f	Qual by exam of deed	0
52642_40000.0_2019-02-28	4000000	\N	2019-02-28	52642	\N	\N	f	Qual by exam of deed	0
52643_40000.0_2019-02-11	4000000	\N	2019-02-11	52643	\N	\N	f	Qual by exam of deed	0
52644_42000.0_2019-01-25	4200000	\N	2019-01-25	52644	\N	\N	f	Qual by exam of deed	0
52645_42000.0_2019-03-04	4200000	\N	2019-03-04	52645	\N	\N	f	Qual by exam of deed	0
52646_30000.0_2019-01-25	3000000	\N	2019-01-25	52646	\N	\N	f	Qual by exam of deed	0
52647_48000.0_2019-02-05	4800000	\N	2019-02-05	52647	\N	\N	f	Qual by exam of deed	0
52647_55000.0_2022-02-25	5500000	\N	2022-02-25	52647	\N	\N	f	Qual by exam of deed	0
52648_31000.0_2019-02-25	3100000	\N	2019-02-25	52648	\N	\N	f	Qual by exam of deed	0
52648_36000.0_2023-09-25	3600000	\N	2023-09-25	52648	\N	\N	f	Qual by exam of deed	0
52649_48500.0_2019-02-15	4850000	\N	2019-02-15	52649	\N	\N	f	Qual by exam of deed	0
52650_31000.0_2019-03-04	3100000	\N	2019-03-04	52650	\N	\N	f	Qual by exam of deed	0
52651_34000.0_2019-02-12	3400000	\N	2019-02-12	52651	\N	\N	f	Qual by exam of deed	0
52653_30500.0_2019-02-25	3050000	\N	2019-02-25	52653	\N	\N	f	Qual by exam of deed	0
52653_41000.0_2022-03-21	4100000	\N	2022-03-21	52653	\N	\N	f	Qual by exam of deed	0
52654_45000.0_2022-12-29	4500000	\N	2022-12-29	52654	\N	\N	f	Qual by exam of deed	0
52655_35000.0_2019-02-04	3500000	\N	2019-02-04	52655	\N	\N	f	Qual by exam of deed	0
52656_37000.0_2019-03-20	3700000	\N	2019-03-20	52656	\N	\N	f	Qual by exam of deed	0
52657_42000.0_2019-01-24	4200000	\N	2019-01-24	52657	\N	\N	f	Qual by exam of deed	0
52658_41500.0_2019-02-15	4150000	\N	2019-02-15	52658	\N	\N	f	Qual by exam of deed	0
52660_38500.0_2019-02-05	3850000	\N	2019-02-05	52660	\N	\N	f	Qual by exam of deed	0
52661_41500.0_2019-02-01	4150000	\N	2019-02-01	52661	\N	\N	f	Qual by exam of deed	0
52664_210000.0_2019-02-06	21000000	\N	2019-02-06	52664	\N	\N	f	Qual by exam of deed	0
52664_360000.0_2021-12-17	36000000	\N	2021-12-17	52664	\N	\N	f	Qual by exam of deed	0
52674_3480.0_1996-02-01	348000	\N	1996-02-01	52674	\N	\N	f	Sales which are qualified	0
52674_5250.0_2003-07-01	525000	\N	2003-07-01	52674	\N	\N	f	Sales which are qualified	0
52674_7800.0_2010-06-11	780000	\N	2010-06-11	52674	\N	\N	f	Qual by exam of deed	0
52674_8590.0_2006-07-01	859000	\N	2006-07-01	52674	\N	\N	f	Sales which are qualified	0
52674_9800.0_2013-12-02	980000	\N	2013-12-02	52674	\N	\N	f	Qual by exam of deed	0
52675_12665.0_2022-04-22	1266500	\N	2022-04-22	52675	\N	\N	f	Qual by exam of deed	0
52675_2700.0_1995-12-01	270000	\N	1995-12-01	52675	\N	\N	f	Sales which are qualified	0
52675_4450.0_2002-08-01	445000	\N	2002-08-01	52675	\N	\N	f	Sales which are qualified	0
52675_8850.0_2018-07-25	885000	\N	2018-07-25	52675	\N	\N	f	Qual by exam of deed	0
52676_3000.0_1999-01-01	300000	\N	1999-01-01	52676	\N	\N	f	Sales which are qualified	0
52676_3900.0_2001-06-01	390000	\N	2001-06-01	52676	\N	\N	f	Sales which are qualified	0
52676_7000.0_2007-06-01	700000	\N	2007-06-01	52676	\N	\N	f	Sales which are qualified	0
52676_9350.0_2021-11-08	935000	\N	2021-11-08	52676	\N	\N	f	Qual by exam of deed	0
52677_1630.0_1995-11-01	163000	\N	1995-11-01	52677	\N	\N	f	Sales which are qualified	0
52677_5900.0_2023-05-11	590000	\N	2023-05-11	52677	\N	\N	f	Qual by exam of deed	0
52678_2470.0_1996-03-01	247000	\N	1996-03-01	52678	\N	\N	f	Sales which are qualified	0
52678_2550.0_1999-06-01	255000	\N	1999-06-01	52678	\N	\N	f	Sales which are qualified	0
52678_2990.0_2002-10-01	299000	\N	2002-10-01	52678	\N	\N	f	Sales which are qualified	0
52678_4180.0_2003-10-01	418000	\N	2003-10-01	52678	\N	\N	f	Sales which are qualified	0
52678_6500.0_2015-03-04	650000	\N	2015-03-04	52678	\N	\N	f	Qual by exam of deed	0
52679_1840.0_1996-04-01	184000	\N	1996-04-01	52679	\N	\N	f	Sales which are qualified	0
52679_2050.0_1999-05-01	205000	\N	1999-05-01	52679	\N	\N	f	Sales which are qualified	0
52679_5090.0_2013-07-25	509000	\N	2013-07-25	52679	\N	\N	f	Qual by exam of deed	0
52679_5550.0_2005-01-01	555000	\N	2005-01-01	52679	\N	\N	f	Sales which are qualified	0
52679_6300.0_2016-01-22	630000	\N	2016-01-22	52679	\N	\N	f	Qual by exam of deed	0
52679_7400.0_2023-04-19	740000	\N	2023-04-19	52679	\N	\N	f	Qual by exam of deed	0
52680_2450.0_1996-01-01	245000	\N	1996-01-01	52680	\N	\N	f	Sales which are qualified	0
52680_2600.0_2000-12-01	260000	\N	2000-12-01	52680	\N	\N	f	Sales which are qualified	0
52680_4500.0_2009-01-08	450000	\N	2009-01-08	52680	\N	\N	f	Qual by exam of deed	0
52680_6450.0_2015-12-23	645000	\N	2015-12-23	52680	\N	\N	f	Qual by exam of deed	0
52681_2060.0_1995-12-01	206000	\N	1995-12-01	52681	\N	\N	f	Sales which are qualified	0
52681_5500.0_2021-03-08	550000	\N	2021-03-08	52681	\N	\N	f	Qual by exam of deed	0
52682_12397.0_2022-06-22	1239700	\N	2022-06-22	52682	\N	\N	f	Qual by exam of deed	0
52682_3670.0_1996-01-01	367000	\N	1996-01-01	52682	\N	\N	f	Sales which are qualified	0
52683_13500.0_2022-10-01	1350000	\N	2022-10-01	52683	\N	\N	f	Qual by exam of deed	0
52683_2950.0_1998-07-01	295000	\N	1998-07-01	52683	\N	\N	f	Sales which are qualified	0
52683_5900.0_2004-07-01	590000	\N	2004-07-01	52683	\N	\N	f	Sales which are qualified	0
52684_3000.0_1996-01-01	300000	\N	1996-01-01	52684	\N	\N	f	Sales which are qualified	0
52685_1760.0_1996-02-01	176000	\N	1996-02-01	52685	\N	\N	f	Sales which are qualified	0
52685_5650.0_2023-05-05	565000	\N	2023-05-05	52685	\N	\N	f	Qual by exam of deed	0
52686_2350.0_1998-09-01	235000	\N	1998-09-01	52686	\N	\N	f	Sales which are qualified	0
52686_2500.0_1995-12-01	250000	\N	1995-12-01	52686	\N	\N	f	Sales which are qualified	0
52686_4350.0_2004-04-01	435000	\N	2004-04-01	52686	\N	\N	f	Sales which are qualified	0
52687_1870.0_1995-12-01	187000	\N	1995-12-01	52687	\N	\N	f	Sales which are qualified	0
52688_2310.0_1996-03-01	231000	\N	1996-03-01	52688	\N	\N	f	Sales which are qualified	0
52688_9200.0_2023-02-27	920000	\N	2023-02-27	52688	\N	\N	f	Qual by exam of deed	0
52689_2090.0_1995-12-01	209000	\N	1995-12-01	52689	\N	\N	f	Sales which are qualified	0
52689_4390.0_2004-05-01	439000	\N	2004-05-01	52689	\N	\N	f	Sales which are qualified	0
52689_7050.0_2018-02-14	705000	\N	2018-02-14	52689	\N	\N	f	Qual by exam of deed	0
52690_13200.0_2021-02-25	1320000	\N	2021-02-25	52690	\N	\N	f	Qual by exam of deed	0
52690_3510.0_1995-12-01	351000	\N	1995-12-01	52690	\N	\N	f	Sales which are qualified	0
52690_7580.0_2012-09-05	758000	\N	2012-09-05	52690	\N	\N	f	Qual by exam of deed	0
52691_3230.0_1996-01-01	323000	\N	1996-01-01	52691	\N	\N	f	Sales which are qualified	0
52691_3450.0_1999-02-01	345000	\N	1999-02-01	52691	\N	\N	f	Sales which are qualified	0
52691_3700.0_2000-06-01	370000	\N	2000-06-01	52691	\N	\N	f	Sales which are qualified	0
52691_7850.0_2014-05-05	785000	\N	2014-05-05	52691	\N	\N	f	Qual by exam of deed	0
52692_12000.0_2023-01-27	1200000	\N	2023-01-27	52692	\N	\N	f	Qual by exam of deed	0
52692_3640.0_1995-12-01	364000	\N	1995-12-01	52692	\N	\N	f	Sales which are qualified	0
52692_3700.0_2000-06-01	370000	\N	2000-06-01	52692	\N	\N	f	Sales which are qualified	0
52692_5750.0_2009-08-06	575000	\N	2009-08-06	52692	\N	\N	f	Qual by exam of deed	0
52692_5870.0_2004-05-01	587000	\N	2004-05-01	52692	\N	\N	f	Sales which are qualified	0
52692_7300.0_2005-04-01	730000	\N	2005-04-01	52692	\N	\N	f	Sales which are qualified	0
52693_1660.0_1996-04-01	166000	\N	1996-04-01	52693	\N	\N	f	Sales which are qualified	0
52693_4500.0_2018-05-16	450000	\N	2018-05-16	52693	\N	\N	f	Qual by exam of deed	0
52694_2500.0_1995-12-01	250000	\N	1995-12-01	52694	\N	\N	f	Sales which are qualified	0
52694_6700.0_2021-04-20	670000	\N	2021-04-20	52694	\N	\N	f	Qual by exam of deed	0
52695_1870.0_1995-12-01	187000	\N	1995-12-01	52695	\N	\N	f	Sales which are qualified	0
52695_2450.0_2000-02-01	245000	\N	2000-02-01	52695	\N	\N	f	Sales which are qualified	0
52695_4500.0_2007-01-01	450000	\N	2007-01-01	52695	\N	\N	f	Sales which are qualified	0
52696_2310.0_1996-01-01	231000	\N	1996-01-01	52696	\N	\N	f	Sales which are qualified	0
52696_2400.0_1998-11-01	240000	\N	1998-11-01	52696	\N	\N	f	Sales which are qualified	0
52696_5700.0_2005-04-01	570000	\N	2005-04-01	52696	\N	\N	f	Sales which are qualified	0
52696_6250.0_2021-09-08	625000	\N	2021-09-08	52696	\N	\N	f	Qual by exam of deed	0
52696_8000.0_2007-05-01	800000	\N	2007-05-01	52696	\N	\N	f	Sales which are qualified	0
52697_1970.0_1996-01-01	197000	\N	1996-01-01	52697	\N	\N	f	Sales which are qualified	0
52697_2304.0_1997-03-01	230400	\N	1997-03-01	52697	\N	\N	f	Sales which are qualified	0
52697_3000.0_2001-01-01	300000	\N	2001-01-01	52697	\N	\N	f	Sales which are qualified	0
52697_3870.0_2003-08-01	387000	\N	2003-08-01	52697	\N	\N	f	Sales which are qualified	0
52697_4400.0_2004-06-01	440000	\N	2004-06-01	52697	\N	\N	f	Sales which are qualified	0
52697_7260.0_2022-04-08	726000	\N	2022-04-08	52697	\N	\N	f	Qual by exam of deed	0
52698_11000.0_2015-09-24	1100000	\N	2015-09-24	52698	\N	\N	f	Qual by exam of deed	0
52698_13000.0_2018-06-05	1300000	\N	2018-06-05	52698	\N	\N	f	Qual by exam of deed	0
52698_15000.0_2022-08-02	1500000	\N	2022-08-02	52698	\N	\N	f	Qual by exam of deed	0
52698_3510.0_1995-12-01	351000	\N	1995-12-01	52698	\N	\N	f	Sales which are qualified	0
52698_3700.0_1999-08-01	370000	\N	1999-08-01	52698	\N	\N	f	Sales which are qualified	0
52698_4550.0_2001-06-01	455000	\N	2001-06-01	52698	\N	\N	f	Sales which are qualified	0
52698_4900.0_2002-06-01	490000	\N	2002-06-01	52698	\N	\N	f	Sales which are qualified	0
52699_2730.0_1996-01-01	273000	\N	1996-01-01	52699	\N	\N	f	Sales which are qualified	0
52699_4450.0_2002-07-01	445000	\N	2002-07-01	52699	\N	\N	f	Sales which are qualified	0
52699_5200.0_2009-03-06	520000	\N	2009-03-06	52699	\N	\N	f	Qual by exam of deed	0
52699_5850.0_2013-03-14	585000	\N	2013-03-14	52699	\N	\N	f	Qual by exam of deed	0
52700_3300.0_1998-04-01	330000	\N	1998-04-01	52700	\N	\N	f	Sales which are qualified	0
52701_1660.0_1995-12-01	166000	\N	1995-12-01	52701	\N	\N	f	Sales which are qualified	0
52701_2350.0_2001-12-01	235000	\N	2001-12-01	52701	\N	\N	f	Sales which are qualified	0
52701_3500.0_2013-03-18	350000	\N	2013-03-18	52701	\N	\N	f	Qual by exam of deed	0
52702_2400.0_1995-12-01	240000	\N	1995-12-01	52702	\N	\N	f	Sales which are qualified	0
52702_2700.0_1996-10-01	270000	\N	1996-10-01	52702	\N	\N	f	Sales which are qualified	0
52702_3600.0_2001-06-01	360000	\N	2001-06-01	52702	\N	\N	f	Sales which are qualified	0
52702_3950.0_2003-07-01	395000	\N	2003-07-01	52702	\N	\N	f	Sales which are qualified	0
52702_5350.0_2013-10-18	535000	\N	2013-10-18	52702	\N	\N	f	Qual by exam of deed	0
52702_6050.0_2005-03-01	605000	\N	2005-03-01	52702	\N	\N	f	Sales which are qualified	0
52702_7550.0_2006-04-01	755000	\N	2006-04-01	52702	\N	\N	f	Sales which are qualified	0
52702_9250.0_2022-02-28	925000	\N	2022-02-28	52702	\N	\N	f	Qual by exam of deed	0
52703_1870.0_1996-03-01	187000	\N	1996-03-01	52703	\N	\N	f	Sales which are qualified	0
52703_2380.0_1998-12-01	238000	\N	1998-12-01	52703	\N	\N	f	Sales which are qualified	0
52703_8184.0_2022-03-30	818400	\N	2022-03-30	52703	\N	\N	f	Qual by exam of deed	0
52704_2450.0_1996-01-01	245000	\N	1996-01-01	52704	\N	\N	f	Sales which are qualified	0
52704_2500.0_1999-08-01	250000	\N	1999-08-01	52704	\N	\N	f	Sales which are qualified	0
52704_3990.0_2003-08-01	399000	\N	2003-08-01	52704	\N	\N	f	Sales which are qualified	0
52704_6200.0_2005-07-01	620000	\N	2005-07-01	52704	\N	\N	f	Sales which are qualified	0
52704_6200.0_2018-01-19	620000	\N	2018-01-19	52704	\N	\N	f	Qual by exam of deed	0
52705_2090.0_1996-01-01	209000	\N	1996-01-01	52705	\N	\N	f	Sales which are qualified	0
52705_3630.0_2002-05-01	363000	\N	2002-05-01	52705	\N	\N	f	Sales which are qualified	0
52706_10450.0_2017-05-31	1045000	\N	2017-05-31	52706	\N	\N	f	Qual by exam of deed	0
52706_3560.0_1996-02-01	356000	\N	1996-02-01	52706	\N	\N	f	Sales which are qualified	0
52706_5450.0_2002-08-01	545000	\N	2002-08-01	52706	\N	\N	f	Sales which are qualified	0
52706_7000.0_2011-06-16	700000	\N	2011-06-16	52706	\N	\N	f	Qual by exam of deed	0
52706_7500.0_2008-03-01	750000	\N	2008-03-01	52706	\N	\N	f	Sales which are qualified	0
52707_13500.0_2023-02-03	1350000	\N	2023-02-03	52707	\N	\N	f	Qual by exam of deed	0
52707_2700.0_1996-01-01	270000	\N	1996-01-01	52707	\N	\N	f	Sales which are qualified	0
52707_6200.0_2004-10-01	620000	\N	2004-10-01	52707	\N	\N	f	Sales which are qualified	0
52708_3050.0_1997-12-01	305000	\N	1997-12-01	52708	\N	\N	f	Sales which are qualified	0
52708_3550.0_1999-10-01	355000	\N	1999-10-01	52708	\N	\N	f	Sales which are qualified	0
52709_1710.0_1996-01-01	171000	\N	1996-01-01	52709	\N	\N	f	Sales which are qualified	0
52710_2650.0_1995-12-01	265000	\N	1995-12-01	52710	\N	\N	f	Sales which are qualified	0
52710_4250.0_2004-03-01	425000	\N	2004-03-01	52710	\N	\N	f	Sales which are qualified	0
52710_6700.0_2018-04-24	670000	\N	2018-04-24	52710	\N	\N	f	Qual by exam of deed	0
52711_1920.0_1995-12-01	192000	\N	1995-12-01	52711	\N	\N	f	Sales which are qualified	0
52711_7060.0_2021-03-30	706000	\N	2021-03-30	52711	\N	\N	f	Qual by exam of deed	0
52711_7150.0_2016-09-20	715000	\N	2016-09-20	52711	\N	\N	f	Qual by exam of deed	0
52712_2360.0_1995-11-01	236000	\N	1995-11-01	52712	\N	\N	f	Sales which are qualified	0
52712_7350.0_2022-12-20	735000	\N	2022-12-20	52712	\N	\N	f	Qual by exam of deed	0
52713_2240.0_1995-12-01	224000	\N	1995-12-01	52713	\N	\N	f	Sales which are qualified	0
52713_8390.0_2022-03-09	839000	\N	2022-03-09	52713	\N	\N	f	Qual by exam of deed	0
52714_13900.0_2021-11-17	1390000	\N	2021-11-17	52714	\N	\N	f	Qual by exam of deed	0
52714_3560.0_1996-04-01	356000	\N	1996-04-01	52714	\N	\N	f	Sales which are qualified	0
52714_3775.0_1998-03-01	377500	\N	1998-03-01	52714	\N	\N	f	Sales which are qualified	0
52715_10400.0_2013-12-20	1040000	\N	2013-12-20	52715	\N	\N	f	Qual by exam of deed	0
52715_11500.0_2016-04-18	1150000	\N	2016-04-18	52715	\N	\N	f	Qual by exam of deed	0
52715_11500.0_2019-09-17	1150000	\N	2019-09-17	52715	\N	\N	f	Qual by exam of deed	0
52715_2825.0_1996-04-01	282500	\N	1996-04-01	52715	\N	\N	f	Sales which are qualified	0
52715_5400.0_2010-11-30	540000	\N	2010-11-30	52715	\N	\N	f	Qual by exam of deed	0
52716_11900.0_2021-09-14	1190000	\N	2021-09-14	52716	\N	\N	f	Qual by exam of deed	0
52716_2850.0_1998-09-01	285000	\N	1998-09-01	52716	\N	\N	f	Sales which are qualified	0
52716_3390.0_1995-11-01	339000	\N	1995-11-01	52716	\N	\N	f	Sales which are qualified	0
52716_3600.0_1999-08-01	360000	\N	1999-08-01	52716	\N	\N	f	Sales which are qualified	0
52716_4900.0_2002-09-01	490000	\N	2002-09-01	52716	\N	\N	f	Sales which are qualified	0
52716_6500.0_2010-07-01	650000	\N	2010-07-01	52716	\N	\N	f	Qual by exam of deed	0
52716_6920.0_2005-03-01	692000	\N	2005-03-01	52716	\N	\N	f	Sales which are qualified	0
52717_1710.0_1995-12-01	171000	\N	1995-12-01	52717	\N	\N	f	Sales which are qualified	0
52717_1720.0_1997-12-01	172000	\N	1997-12-01	52717	\N	\N	f	Sales which are qualified	0
52717_1800.0_1996-06-01	180000	\N	1996-06-01	52717	\N	\N	f	Sales which are qualified	0
52717_5360.0_2020-11-06	536000	\N	2020-11-06	52717	\N	\N	f	Qual by exam of deed	0
52718_2700.0_1998-01-01	270000	\N	1998-01-01	52718	\N	\N	f	Sales which are qualified	0
52718_2850.0_1999-05-01	285000	\N	1999-05-01	52718	\N	\N	f	Sales which are qualified	0
52718_2950.0_1995-11-01	295000	\N	1995-11-01	52718	\N	\N	f	Sales which are qualified	0
52718_4300.0_2003-09-01	430000	\N	2003-09-01	52718	\N	\N	f	Sales which are qualified	0
52718_4559.0_2004-05-01	455900	\N	2004-05-01	52718	\N	\N	f	Sales which are qualified	0
52718_6850.0_2017-02-24	685000	\N	2017-02-24	52718	\N	\N	f	Qual by exam of deed	0
52718_7500.0_2015-01-21	750000	\N	2015-01-21	52718	\N	\N	f	Qual by exam of deed	0
52718_9750.0_2023-03-09	975000	\N	2023-03-09	52718	\N	\N	f	Qual by exam of deed	0
52719_1920.0_1996-01-01	192000	\N	1996-01-01	52719	\N	\N	f	Sales which are qualified	0
52719_3150.0_2001-08-01	315000	\N	2001-08-01	52719	\N	\N	f	Sales which are qualified	0
52719_3860.0_2004-04-01	386000	\N	2004-04-01	52719	\N	\N	f	Sales which are qualified	0
52720_2360.0_1996-01-01	236000	\N	1996-01-01	52720	\N	\N	f	Sales which are qualified	0
52720_2770.0_2000-05-01	277000	\N	2000-05-01	52720	\N	\N	f	Sales which are qualified	0
52721_2240.0_1996-01-01	224000	\N	1996-01-01	52721	\N	\N	f	Sales which are qualified	0
52721_2600.0_1999-01-01	260000	\N	1999-01-01	52721	\N	\N	f	Sales which are qualified	0
52721_3750.0_2002-07-01	375000	\N	2002-07-01	52721	\N	\N	f	Sales which are qualified	0
52721_4025.0_2010-06-04	402500	\N	2010-06-04	52721	\N	\N	f	Qual by exam of deed	0
52721_4780.0_2004-06-01	478000	\N	2004-06-01	52721	\N	\N	f	Sales which are qualified	0
52722_11000.0_2017-04-07	1100000	\N	2017-04-07	52722	\N	\N	f	Qual by exam of deed	0
52722_3560.0_1995-12-01	356000	\N	1995-12-01	52722	\N	\N	f	Sales which are qualified	0
52722_4150.0_1999-10-01	415000	\N	1999-10-01	52722	\N	\N	f	Sales which are qualified	0
52723_2780.0_1996-01-01	278000	\N	1996-01-01	52723	\N	\N	f	Sales which are qualified	0
52723_2863.0_1998-01-01	286300	\N	1998-01-01	52723	\N	\N	f	Sales which are qualified	0
52723_7900.0_2005-11-01	790000	\N	2005-11-01	52723	\N	\N	f	Sales which are qualified	0
52724_11000.0_2015-10-20	1100000	\N	2015-10-20	52724	\N	\N	f	Qual by exam of deed	0
52724_3690.0_1995-12-01	369000	\N	1995-12-01	52724	\N	\N	f	Sales which are qualified	0
52725_1710.0_1996-01-01	171000	\N	1996-01-01	52725	\N	\N	f	Sales which are qualified	0
52725_1880.0_1998-08-01	188000	\N	1998-08-01	52725	\N	\N	f	Sales which are qualified	0
52725_2350.0_2000-10-01	235000	\N	2000-10-01	52725	\N	\N	f	Sales which are qualified	0
52726_13500.0_2022-07-06	1350000	\N	2022-07-06	52726	\N	\N	f	Qual by exam of deed	0
52726_2550.0_1996-03-01	255000	\N	1996-03-01	52726	\N	\N	f	Sales which are qualified	0
52726_2550.0_1999-05-01	255000	\N	1999-05-01	52726	\N	\N	f	Sales which are qualified	0
52726_4350.0_2003-09-01	435000	\N	2003-09-01	52726	\N	\N	f	Sales which are qualified	0
52726_5424.0_2005-03-01	542400	\N	2005-03-01	52726	\N	\N	f	Sales which are qualified	0
52726_7150.0_2005-06-01	715000	\N	2005-06-01	52726	\N	\N	f	Sales which are qualified	0
52726_7500.0_2015-06-18	750000	\N	2015-06-18	52726	\N	\N	f	Qual by exam of deed	0
52727_1920.0_1996-06-01	192000	\N	1996-06-01	52727	\N	\N	f	Sales which are qualified	0
52728_2360.0_1996-03-01	236000	\N	1996-03-01	52728	\N	\N	f	Sales which are qualified	0
52728_2500.0_1999-07-01	250000	\N	1999-07-01	52728	\N	\N	f	Sales which are qualified	0
52728_3523.0_2010-11-12	352300	\N	2010-11-12	52728	\N	\N	f	Qual by exam of deed	0
52728_6250.0_2005-06-01	625000	\N	2005-06-01	52728	\N	\N	f	Sales which are qualified	0
52728_7700.0_2006-03-01	770000	\N	2006-03-01	52728	\N	\N	f	Sales which are qualified	0
52729_2240.0_1995-12-01	224000	\N	1995-12-01	52729	\N	\N	f	Sales which are qualified	0
52729_2600.0_1999-05-01	260000	\N	1999-05-01	52729	\N	\N	f	Sales which are qualified	0
52729_4843.0_2009-01-30	484300	\N	2009-01-30	52729	\N	\N	f	Qual by exam of deed	0
52729_5990.0_2005-04-01	599000	\N	2005-04-01	52729	\N	\N	f	Sales which are qualified	0
52729_6680.0_2014-08-22	668000	\N	2014-08-22	52729	\N	\N	f	Qual by exam of deed	0
52729_7300.0_2018-07-05	730000	\N	2018-07-05	52729	\N	\N	f	Qual by exam of deed	0
52729_9600.0_2022-08-24	960000	\N	2022-08-24	52729	\N	\N	f	Qual by exam of deed	0
52730_10000.0_2017-01-25	1000000	\N	2017-01-25	52730	\N	\N	f	Qual by exam of deed	0
52730_3200.0_1997-12-01	320000	\N	1997-12-01	52730	\N	\N	f	Sales which are qualified	0
52730_4900.0_2002-03-01	490000	\N	2002-03-01	52730	\N	\N	f	Sales which are qualified	0
52731_14500.0_2022-08-01	1450000	\N	2022-08-01	52731	\N	\N	f	Qual by exam of deed	0
52731_2825.0_1997-05-01	282500	\N	1997-05-01	52731	\N	\N	f	Sales which are qualified	0
52731_3500.0_1995-12-01	350000	\N	1995-12-01	52731	\N	\N	f	Sales which are qualified	0
52731_8310.0_2020-12-04	831000	\N	2020-12-04	52731	\N	\N	f	Qual by exam of deed	0
52732_10300.0_2014-05-10	1030000	\N	2014-05-10	52732	\N	\N	f	Qual by exam of deed	0
52732_3600.0_2000-03-01	360000	\N	2000-03-01	52732	\N	\N	f	Sales which are qualified	0
52732_3740.0_1997-08-01	374000	\N	1997-08-01	52732	\N	\N	f	Sales which are qualified	0
52732_8160.0_2013-05-22	816000	\N	2013-05-22	52732	\N	\N	f	Qual by exam of deed	0
52733_1720.0_1997-09-01	172000	\N	1997-09-01	52733	\N	\N	f	Sales which are qualified	0
52733_5100.0_2021-04-26	510000	\N	2021-04-26	52733	\N	\N	f	Qual by exam of deed	0
52734_11500.0_2015-06-11	1150000	\N	2015-06-11	52734	\N	\N	f	Qual by exam of deed	0
52734_2600.0_1995-12-01	260000	\N	1995-12-01	52734	\N	\N	f	Sales which are qualified	0
52734_2650.0_1996-09-01	265000	\N	1996-09-01	52734	\N	\N	f	Sales which are qualified	0
52734_3699.0_2000-10-01	369900	\N	2000-10-01	52734	\N	\N	f	Sales which are qualified	0
52734_5100.0_2012-02-08	510000	\N	2012-02-08	52734	\N	\N	f	Qual by exam of deed	0
52734_6400.0_2014-10-02	640000	\N	2014-10-02	52734	\N	\N	f	Qual by exam of deed	0
52734_8500.0_2020-12-15	850000	\N	2020-12-15	52734	\N	\N	f	Qual by exam of deed	0
52735_2050.0_1996-01-01	205000	\N	1996-01-01	52735	\N	\N	f	Sales which are qualified	0
52736_2410.0_1995-12-01	241000	\N	1995-12-01	52736	\N	\N	f	Sales which are qualified	0
52736_2700.0_2000-04-01	270000	\N	2000-04-01	52736	\N	\N	f	Sales which are qualified	0
52736_2750.0_1998-06-01	275000	\N	1998-06-01	52736	\N	\N	f	Sales which are qualified	0
52736_4150.0_2004-01-01	415000	\N	2004-01-01	52736	\N	\N	f	Sales which are qualified	0
52736_4350.0_2010-11-24	435000	\N	2010-11-24	52736	\N	\N	f	Qual by exam of deed	0
52737_2850.0_1995-12-01	285000	\N	1995-12-01	52737	\N	\N	f	Sales which are qualified	0
52738_3700.0_1997-06-01	370000	\N	1997-06-01	52738	\N	\N	f	Sales which are qualified	0
52739_3330.0_1996-01-01	333000	\N	1996-01-01	52739	\N	\N	f	Sales which are qualified	0
52739_5200.0_2003-10-01	520000	\N	2003-10-01	52739	\N	\N	f	Sales which are qualified	0
52740_12850.0_2023-05-22	1285000	\N	2023-05-22	52740	\N	\N	f	Qual by exam of deed	0
52740_3740.0_1996-01-01	374000	\N	1996-01-01	52740	\N	\N	f	Sales which are qualified	0
52740_3920.0_2001-03-01	392000	\N	2001-03-01	52740	\N	\N	f	Sales which are qualified	0
52741_1795.0_1996-08-01	179500	\N	1996-08-01	52741	\N	\N	f	Sales which are qualified	0
52741_2050.0_1999-03-01	205000	\N	1999-03-01	52741	\N	\N	f	Sales which are qualified	0
52742_2600.0_1995-12-01	260000	\N	1995-12-01	52742	\N	\N	f	Sales which are qualified	0
52742_4000.0_2001-03-01	400000	\N	2001-03-01	52742	\N	\N	f	Sales which are qualified	0
52742_6250.0_2005-01-01	625000	\N	2005-01-01	52742	\N	\N	f	Sales which are qualified	0
52742_8750.0_2021-03-05	875000	\N	2021-03-05	52742	\N	\N	f	Qual by exam of deed	0
52743_2230.0_1996-01-01	223000	\N	1996-01-01	52743	\N	\N	f	Sales which are qualified	0
52743_5180.0_2012-07-06	518000	\N	2012-07-06	52743	\N	\N	f	Qual by exam of deed	0
52744_2410.0_1996-01-01	241000	\N	1996-01-01	52744	\N	\N	f	Sales which are qualified	0
52744_6500.0_2014-04-15	650000	\N	2014-04-15	52744	\N	\N	f	Qual by exam of deed	0
52745_2290.0_1996-02-01	229000	\N	1996-02-01	52745	\N	\N	f	Sales which are qualified	0
52745_3450.0_1996-07-01	345000	\N	1996-07-01	52745	\N	\N	f	Sales which are qualified	0
52745_3640.0_2002-05-01	364000	\N	2002-05-01	52745	\N	\N	f	Sales which are qualified	0
52746_3610.0_1996-01-01	361000	\N	1996-01-01	52746	\N	\N	f	Sales which are qualified	0
52746_3650.0_1999-07-01	365000	\N	1999-07-01	52746	\N	\N	f	Sales which are qualified	0
52746_4025.0_2000-08-01	402500	\N	2000-08-01	52746	\N	\N	f	Sales which are qualified	0
52746_5250.0_2003-10-01	525000	\N	2003-10-01	52746	\N	\N	f	Sales which are qualified	0
52747_13300.0_2017-03-14	1330000	\N	2017-03-14	52747	\N	\N	f	Qual by exam of deed	0
52747_2800.0_1996-12-01	280000	\N	1996-12-01	52747	\N	\N	f	Sales which are qualified	0
52747_9500.0_2015-07-31	950000	\N	2015-07-31	52747	\N	\N	f	Qual by exam of deed	0
52748_3440.0_1996-01-01	344000	\N	1996-01-01	52748	\N	\N	f	Sales which are qualified	0
52748_9750.0_2014-12-05	975000	\N	2014-12-05	52748	\N	\N	f	Qual by exam of deed	0
52749_1800.0_1996-04-01	180000	\N	1996-04-01	52749	\N	\N	f	Sales which are qualified	0
52750_2830.0_1996-01-01	283000	\N	1996-01-01	52750	\N	\N	f	Sales which are qualified	0
52750_3150.0_1999-05-01	315000	\N	1999-05-01	52750	\N	\N	f	Sales which are qualified	0
52750_4100.0_2003-03-01	410000	\N	2003-03-01	52750	\N	\N	f	Sales which are qualified	0
52750_5750.0_2008-05-19	575000	\N	2008-05-19	52750	\N	\N	f	Sales which are qualified	0
52751_2050.0_1997-08-01	205000	\N	1997-08-01	52751	\N	\N	f	Sales which are qualified	0
52751_2230.0_1996-02-01	223000	\N	1996-02-01	52751	\N	\N	f	Sales which are qualified	0
52751_2450.0_1999-07-01	245000	\N	1999-07-01	52751	\N	\N	f	Sales which are qualified	0
52752_2410.0_1996-01-01	241000	\N	1996-01-01	52752	\N	\N	f	Sales which are qualified	0
52752_6900.0_2015-05-29	690000	\N	2015-05-29	52752	\N	\N	f	Qual by exam of deed	0
52752_9300.0_2017-09-20	930000	\N	2017-09-20	52752	\N	\N	f	Qual by exam of deed	0
52753_2290.0_1996-04-01	229000	\N	1996-04-01	52753	\N	\N	f	Sales which are qualified	0
52753_2550.0_1997-04-01	255000	\N	1997-04-01	52753	\N	\N	f	Sales which are qualified	0
52753_6990.0_2017-09-22	699000	\N	2017-09-22	52753	\N	\N	f	Qual by exam of deed	0
52754_12150.0_2014-10-10	1215000	\N	2014-10-10	52754	\N	\N	f	Qual by exam of deed	0
52754_13935.0_2019-06-07	1393500	\N	2019-06-07	52754	\N	\N	f	Qual by exam of deed	0
52754_15000.0_2022-09-02	1500000	\N	2022-09-02	52754	\N	\N	f	Qual by exam of deed	0
52754_3520.0_1999-10-01	352000	\N	1999-10-01	52754	\N	\N	f	Sales which are qualified	0
52754_3660.0_1996-02-01	366000	\N	1996-02-01	52754	\N	\N	f	Sales which are qualified	0
52754_5190.0_2003-05-01	519000	\N	2003-05-01	52754	\N	\N	f	Sales which are qualified	0
52755_14000.0_2023-06-16	1400000	\N	2023-06-16	52755	\N	\N	f	Qual by exam of deed	0
52755_2880.0_1996-01-01	288000	\N	1996-01-01	52755	\N	\N	f	Sales which are qualified	0
52755_4000.0_2001-01-01	400000	\N	2001-01-01	52755	\N	\N	f	Sales which are qualified	0
52755_4800.0_2009-11-06	480000	\N	2009-11-06	52755	\N	\N	f	Qual by exam of deed	0
52755_5500.0_2011-05-24	550000	\N	2011-05-24	52755	\N	\N	f	Qual by exam of deed	0
52755_6620.0_2005-06-01	662000	\N	2005-06-01	52755	\N	\N	f	Sales which are qualified	0
52755_8800.0_2020-09-15	880000	\N	2020-09-15	52755	\N	\N	f	Qual by exam of deed	0
52755_9000.0_2014-05-14	900000	\N	2014-05-14	52755	\N	\N	f	Qual by exam of deed	0
52756_13165.0_2017-07-19	1316500	\N	2017-07-19	52756	\N	\N	f	Qual by exam of deed	0
52756_3790.0_1996-01-01	379000	\N	1996-01-01	52756	\N	\N	f	Sales which are qualified	0
52756_4150.0_2000-11-01	415000	\N	2000-11-01	52756	\N	\N	f	Sales which are qualified	0
52756_6250.0_2004-07-01	625000	\N	2004-07-01	52756	\N	\N	f	Sales which are qualified	0
52756_9000.0_2006-09-01	900000	\N	2006-09-01	52756	\N	\N	f	Sales which are qualified	0
52757_1810.0_1996-02-01	181000	\N	1996-02-01	52757	\N	\N	f	Sales which are qualified	0
52757_1880.0_1997-10-01	188000	\N	1997-10-01	52757	\N	\N	f	Sales which are qualified	0
52758_2600.0_1998-11-01	260000	\N	1998-11-01	52758	\N	\N	f	Sales which are qualified	0
52758_2650.0_1996-02-01	265000	\N	1996-02-01	52758	\N	\N	f	Sales which are qualified	0
52758_7850.0_2006-07-01	785000	\N	2006-07-01	52758	\N	\N	f	Sales which are qualified	0
52758_9500.0_2017-04-04	950000	\N	2017-04-04	52758	\N	\N	f	Qual by exam of deed	0
52759_2220.0_1996-02-01	222000	\N	1996-02-01	52759	\N	\N	f	Sales which are qualified	0
52759_2230.0_1998-11-01	223000	\N	1998-11-01	52759	\N	\N	f	Sales which are qualified	0
52759_4100.0_2003-08-01	410000	\N	2003-08-01	52759	\N	\N	f	Sales which are qualified	0
52759_5600.0_2021-03-05	560000	\N	2021-03-05	52759	\N	\N	f	Qual by exam of deed	0
52760_2460.0_1996-01-01	246000	\N	1996-01-01	52760	\N	\N	f	Sales which are qualified	0
52760_7000.0_2014-05-23	700000	\N	2014-05-23	52760	\N	\N	f	Qual by exam of deed	0
52761_2340.0_1996-01-01	234000	\N	1996-01-01	52761	\N	\N	f	Sales which are qualified	0
52761_2750.0_1999-09-01	275000	\N	1999-09-01	52761	\N	\N	f	Sales which are qualified	0
52761_2820.0_1996-10-01	282000	\N	1996-10-01	52761	\N	\N	f	Sales which are qualified	0
52761_3000.0_2000-11-01	300000	\N	2000-11-01	52761	\N	\N	f	Sales which are qualified	0
52761_5850.0_2008-07-01	585000	\N	2008-07-01	52761	\N	\N	f	Sales which are qualified	0
52761_6000.0_2005-02-01	600000	\N	2005-02-01	52761	\N	\N	f	Sales which are qualified	0
52762_10500.0_2006-03-01	1050000	\N	2006-03-01	52762	\N	\N	f	Sales which are qualified	0
52762_4000.0_1996-11-01	400000	\N	1996-11-01	52762	\N	\N	f	Sales which are qualified	0
52762_5300.0_2003-02-01	530000	\N	2003-02-01	52762	\N	\N	f	Sales which are qualified	0
52762_9450.0_2011-05-20	945000	\N	2011-05-20	52762	\N	\N	f	Qual by exam of deed	0
52763_10950.0_2015-04-23	1095000	\N	2015-04-23	52763	\N	\N	f	Qual by exam of deed	0
52763_2880.0_1996-01-01	288000	\N	1996-01-01	52763	\N	\N	f	Sales which are qualified	0
52763_3400.0_1998-11-01	340000	\N	1998-11-01	52763	\N	\N	f	Sales which are qualified	0
52763_4300.0_2001-08-01	430000	\N	2001-08-01	52763	\N	\N	f	Sales which are qualified	0
52763_5350.0_2011-05-05	535000	\N	2011-05-05	52763	\N	\N	f	Qual by exam of deed	0
52763_6150.0_2004-08-01	615000	\N	2004-08-01	52763	\N	\N	f	Sales which are qualified	0
52764_2850.0_1998-03-01	285000	\N	1998-03-01	52764	\N	\N	f	Sales which are qualified	0
52764_3450.0_1999-08-01	345000	\N	1999-08-01	52764	\N	\N	f	Sales which are qualified	0
52764_3490.0_1996-01-01	349000	\N	1996-01-01	52764	\N	\N	f	Sales which are qualified	0
52764_7350.0_2005-03-01	735000	\N	2005-03-01	52764	\N	\N	f	Sales which are qualified	0
52765_1750.0_1998-04-01	175000	\N	1998-04-01	52765	\N	\N	f	Sales which are qualified	0
52765_1810.0_1996-02-01	181000	\N	1996-02-01	52765	\N	\N	f	Sales which are qualified	0
52765_3400.0_2003-09-01	340000	\N	2003-09-01	52765	\N	\N	f	Sales which are qualified	0
52766_10800.0_2019-02-14	1080000	\N	2019-02-14	52766	\N	\N	f	Qual by exam of deed	0
52766_2650.0_1996-01-01	265000	\N	1996-01-01	52766	\N	\N	f	Sales which are qualified	0
52766_5450.0_2009-03-23	545000	\N	2009-03-23	52766	\N	\N	f	Qual by exam of deed	0
52769_2800.0_2000-09-01	280000	\N	2000-09-01	52769	\N	\N	f	Sales which are qualified	0
52770_4150.0_1996-01-01	415000	\N	1996-01-01	52770	\N	\N	f	Sales which are qualified	0
52771_2880.0_1996-03-01	288000	\N	1996-03-01	52771	\N	\N	f	Sales which are qualified	0
52771_6432.0_2013-08-02	643200	\N	2013-08-02	52771	\N	\N	f	Qual by exam of deed	0
52772_13500.0_2023-04-17	1350000	\N	2023-04-17	52772	\N	\N	f	Qual by exam of deed	0
52772_3350.0_1999-03-01	335000	\N	1999-03-01	52772	\N	\N	f	Sales which are qualified	0
52772_3490.0_1996-03-01	349000	\N	1996-03-01	52772	\N	\N	f	Sales which are qualified	0
52772_3690.0_2000-04-01	369000	\N	2000-04-01	52772	\N	\N	f	Sales which are qualified	0
52773_1810.0_1996-03-01	181000	\N	1996-03-01	52773	\N	\N	f	Sales which are qualified	0
52773_2500.0_2001-02-01	250000	\N	2001-02-01	52773	\N	\N	f	Sales which are qualified	0
52774_2650.0_1996-01-01	265000	\N	1996-01-01	52774	\N	\N	f	Sales which are qualified	0
52774_5500.0_2005-06-01	550000	\N	2005-06-01	52774	\N	\N	f	Sales which are qualified	0
52774_6020.0_2008-06-01	602000	\N	2008-06-01	52774	\N	\N	f	Sales which are qualified	0
52775_2280.0_1996-04-01	228000	\N	1996-04-01	52775	\N	\N	f	Sales which are qualified	0
52775_2640.0_2000-05-01	264000	\N	2000-05-01	52775	\N	\N	f	Sales which are qualified	0
52775_5550.0_2013-05-13	555000	\N	2013-05-13	52775	\N	\N	f	Qual by exam of deed	0
52775_6100.0_2020-12-28	610000	\N	2020-12-28	52775	\N	\N	f	Qual by exam of deed	0
52775_9500.0_2023-01-04	950000	\N	2023-01-04	52775	\N	\N	f	Qual by exam of deed	0
52776_2460.0_1995-12-01	246000	\N	1995-12-01	52776	\N	\N	f	Sales which are qualified	0
52776_2600.0_1997-03-01	260000	\N	1997-03-01	52776	\N	\N	f	Sales which are qualified	0
52776_2620.0_2000-10-01	262000	\N	2000-10-01	52776	\N	\N	f	Sales which are qualified	0
52776_3600.0_2002-04-01	360000	\N	2002-04-01	52776	\N	\N	f	Sales which are qualified	0
52776_4800.0_2012-08-28	480000	\N	2012-08-28	52776	\N	\N	f	Qual by exam of deed	0
52776_4830.0_2006-09-01	483000	\N	2006-09-01	52776	\N	\N	f	Other disqualified	0
52776_6435.0_2005-06-01	643500	\N	2005-06-01	52776	\N	\N	f	Sales which are qualified	0
52777_2390.0_1996-01-01	239000	\N	1996-01-01	52777	\N	\N	f	Sales which are qualified	0
52777_2450.0_1997-06-01	245000	\N	1997-06-01	52777	\N	\N	f	Sales which are qualified	0
52778_3710.0_1996-02-01	371000	\N	1996-02-01	52778	\N	\N	f	Sales which are qualified	0
52778_3750.0_1999-02-01	375000	\N	1999-02-01	52778	\N	\N	f	Sales which are qualified	0
52778_5550.0_2002-11-01	555000	\N	2002-11-01	52778	\N	\N	f	Sales which are qualified	0
52778_8000.0_2009-03-10	800000	\N	2009-03-10	52778	\N	\N	f	Qual by exam of deed	0
52779_10000.0_2019-02-21	1000000	\N	2019-02-21	52779	\N	\N	f	Qual by exam of deed	0
52779_13250.0_2021-06-21	1325000	\N	2021-06-21	52779	\N	\N	f	Qual by exam of deed	0
52779_3300.0_1996-07-01	330000	\N	1996-07-01	52779	\N	\N	f	Sales which are qualified	0
52780_2990.0_1998-04-01	299000	\N	1998-04-01	52780	\N	\N	f	Sales which are qualified	0
52780_3400.0_1999-10-01	340000	\N	1999-10-01	52780	\N	\N	f	Sales which are qualified	0
52780_3540.0_1996-01-01	354000	\N	1996-01-01	52780	\N	\N	f	Sales which are qualified	0
52780_5250.0_2010-10-15	525000	\N	2010-10-15	52780	\N	\N	f	Qual by exam of deed	0
52781_1860.0_1996-04-01	186000	\N	1996-04-01	52781	\N	\N	f	Sales which are qualified	0
52781_2525.0_2000-10-01	252500	\N	2000-10-01	52781	\N	\N	f	Sales which are qualified	0
52781_3925.0_2013-04-02	392500	\N	2013-04-02	52781	\N	\N	f	Qual by exam of deed	0
52781_4400.0_2005-06-01	440000	\N	2005-06-01	52781	\N	\N	f	Sales which are qualified	0
52782_12500.0_2018-04-03	1250000	\N	2018-04-03	52782	\N	\N	f	Qual by exam of deed	0
52782_14500.0_2023-05-19	1450000	\N	2023-05-19	52782	\N	\N	f	Qual by exam of deed	0
52782_2700.0_1996-03-01	270000	\N	1996-03-01	52782	\N	\N	f	Sales which are qualified	0
52782_6500.0_2014-04-30	650000	\N	2014-04-30	52782	\N	\N	f	Qual by exam of deed	0
52783_2450.0_1999-09-01	245000	\N	1999-09-01	52783	\N	\N	f	Sales which are qualified	0
52783_4050.0_2004-01-01	405000	\N	2004-01-01	52783	\N	\N	f	Sales which are qualified	0
52784_2510.0_1996-04-01	251000	\N	1996-04-01	52784	\N	\N	f	Sales which are qualified	0
52784_4100.0_2003-10-01	410000	\N	2003-10-01	52784	\N	\N	f	Sales which are qualified	0
52784_6550.0_2014-02-07	655000	\N	2014-02-07	52784	\N	\N	f	Qual by exam of deed	0
52784_8600.0_2019-03-29	860000	\N	2019-03-29	52784	\N	\N	f	Qual by exam of deed	0
52785_2390.0_1996-01-01	239000	\N	1996-01-01	52785	\N	\N	f	Sales which are qualified	0
52785_2441.0_2001-11-01	244100	\N	2001-11-01	52785	\N	\N	f	Sales which are qualified	0
52786_16770.0_2022-03-08	1677000	\N	2022-03-08	52786	\N	\N	f	Qual by exam of deed	0
52786_3710.0_1996-01-01	371000	\N	1996-01-01	52786	\N	\N	f	Sales which are qualified	0
52786_4200.0_2000-10-01	420000	\N	2000-10-01	52786	\N	\N	f	Sales which are qualified	0
52786_9100.0_2013-03-18	910000	\N	2013-03-18	52786	\N	\N	f	Qual by exam of deed	0
52786_9600.0_2020-02-27	960000	\N	2020-02-27	52786	\N	\N	f	Qual by exam of deed	0
52787_2930.0_1996-02-01	293000	\N	1996-02-01	52787	\N	\N	f	Sales which are qualified	0
52788_3540.0_1996-01-01	354000	\N	1996-01-01	52788	\N	\N	f	Sales which are qualified	0
52788_3750.0_2000-09-01	375000	\N	2000-09-01	52788	\N	\N	f	Sales which are qualified	0
52789_1860.0_1996-01-01	186000	\N	1996-01-01	52789	\N	\N	f	Sales which are qualified	0
52789_2050.0_1997-04-01	205000	\N	1997-04-01	52789	\N	\N	f	Sales which are qualified	0
52789_2210.0_1999-01-01	221000	\N	1999-01-01	52789	\N	\N	f	Sales which are qualified	0
52789_4419.0_2013-06-10	441900	\N	2013-06-10	52789	\N	\N	f	Qual by exam of deed	0
52789_5700.0_2016-07-15	570000	\N	2016-07-15	52789	\N	\N	f	Qual by exam of deed	0
52790_2700.0_1996-01-01	270000	\N	1996-01-01	52790	\N	\N	f	Sales which are qualified	0
52790_3100.0_1997-06-01	310000	\N	1997-06-01	52790	\N	\N	f	Sales which are qualified	0
52791_2230.0_1996-02-01	223000	\N	1996-02-01	52791	\N	\N	f	Sales which are qualified	0
52791_4550.0_2004-08-01	455000	\N	2004-08-01	52791	\N	\N	f	Sales which are qualified	0
52791_7350.0_2014-12-22	735000	\N	2014-12-22	52791	\N	\N	f	Qual by exam of deed	0
52791_9000.0_2015-05-01	900000	\N	2015-05-01	52791	\N	\N	f	Qual by exam of deed	0
52792_2510.0_1996-02-01	251000	\N	1996-02-01	52792	\N	\N	f	Sales which are qualified	0
52792_3900.0_2002-12-01	390000	\N	2002-12-01	52792	\N	\N	f	Sales which are qualified	0
52792_7800.0_2019-09-03	780000	\N	2019-09-03	52792	\N	\N	f	Qual by exam of deed	0
52792_8450.0_2021-06-17	845000	\N	2021-06-17	52792	\N	\N	f	Qual by exam of deed	0
52793_2390.0_1996-01-01	239000	\N	1996-01-01	52793	\N	\N	f	Sales which are qualified	0
52793_2600.0_1996-04-01	260000	\N	1996-04-01	52793	\N	\N	f	Sales which are qualified	0
52794_3710.0_1996-02-01	371000	\N	1996-02-01	52794	\N	\N	f	Sales which are qualified	0
52794_7300.0_2008-07-01	730000	\N	2008-07-01	52794	\N	\N	f	Sales which are qualified	0
52794_9000.0_2010-08-17	900000	\N	2010-08-17	52794	\N	\N	f	Qual by exam of deed	0
52795_10800.0_2014-10-22	1080000	\N	2014-10-22	52795	\N	\N	f	Qual by exam of deed	0
52795_13250.0_2021-03-25	1325000	\N	2021-03-25	52795	\N	\N	f	Qual by exam of deed	0
52795_2930.0_1996-03-01	293000	\N	1996-03-01	52795	\N	\N	f	Sales which are qualified	0
52795_5400.0_2010-08-11	540000	\N	2010-08-11	52795	\N	\N	f	Qual by exam of deed	0
52796_3520.0_1999-10-01	352000	\N	1999-10-01	52796	\N	\N	f	Sales which are qualified	0
52796_3540.0_1996-01-01	354000	\N	1996-01-01	52796	\N	\N	f	Sales which are qualified	0
52796_4600.0_2001-06-01	460000	\N	2001-06-01	52796	\N	\N	f	Sales which are qualified	0
52796_5850.0_2002-08-01	585000	\N	2002-08-01	52796	\N	\N	f	Sales which are qualified	0
52796_6700.0_2004-08-01	670000	\N	2004-08-01	52796	\N	\N	f	Sales which are qualified	0
52797_1860.0_1996-04-01	186000	\N	1996-04-01	52797	\N	\N	f	Sales which are qualified	0
52798_11250.0_2015-10-05	1125000	\N	2015-10-05	52798	\N	\N	f	Qual by exam of deed	0
52798_2700.0_1996-01-01	270000	\N	1996-01-01	52798	\N	\N	f	Sales which are qualified	0
52798_5750.0_2012-03-05	575000	\N	2012-03-05	52798	\N	\N	f	Qual by exam of deed	0
52799_2330.0_1996-04-01	233000	\N	1996-04-01	52799	\N	\N	f	Sales which are qualified	0
52799_2550.0_2000-05-01	255000	\N	2000-05-01	52799	\N	\N	f	Sales which are qualified	0
52799_3400.0_2001-06-01	340000	\N	2001-06-01	52799	\N	\N	f	Sales which are qualified	0
52799_5400.0_2012-06-22	540000	\N	2012-06-22	52799	\N	\N	f	Qual by exam of deed	0
52799_7100.0_2021-02-10	710000	\N	2021-02-10	52799	\N	\N	f	Qual by exam of deed	0
52800_2510.0_1996-04-01	251000	\N	1996-04-01	52800	\N	\N	f	Sales which are qualified	0
52800_2700.0_1999-05-01	270000	\N	1999-05-01	52800	\N	\N	f	Sales which are qualified	0
52800_3530.0_2002-11-01	353000	\N	2002-11-01	52800	\N	\N	f	Sales which are qualified	0
52800_7750.0_2016-02-05	775000	\N	2016-02-05	52800	\N	\N	f	Qual by exam of deed	0
52800_8000.0_2022-11-22	800000	\N	2022-11-22	52800	\N	\N	f	Qual by exam of deed	0
52800_9000.0_2018-07-19	900000	\N	2018-07-19	52800	\N	\N	f	Qual by exam of deed	0
52801_2390.0_1996-04-01	239000	\N	1996-04-01	52801	\N	\N	f	Sales which are qualified	0
52801_2850.0_1999-08-01	285000	\N	1999-08-01	52801	\N	\N	f	Sales which are qualified	0
52801_2930.0_1998-08-01	293000	\N	1998-08-01	52801	\N	\N	f	Sales which are qualified	0
52801_3050.0_2000-10-01	305000	\N	2000-10-01	52801	\N	\N	f	Sales which are qualified	0
52801_3575.0_2002-05-01	357500	\N	2002-05-01	52801	\N	\N	f	Sales which are qualified	0
52801_6500.0_2005-04-01	650000	\N	2005-04-01	52801	\N	\N	f	Sales which are qualified	0
52801_9500.0_2022-06-06	950000	\N	2022-06-06	52801	\N	\N	f	Qual by exam of deed	0
52802_12200.0_2015-10-15	1220000	\N	2015-10-15	52802	\N	\N	f	Qual by exam of deed	0
52802_3680.0_1996-02-01	368000	\N	1996-02-01	52802	\N	\N	f	Sales which are qualified	0
52803_12500.0_2022-03-24	1250000	\N	2022-03-24	52803	\N	\N	f	Qual by exam of deed	0
52803_3480.0_1996-01-01	348000	\N	1996-01-01	52803	\N	\N	f	Sales which are qualified	0
52803_3700.0_1999-09-01	370000	\N	1999-09-01	52803	\N	\N	f	Sales which are qualified	0
52804_3050.0_1998-01-01	305000	\N	1998-01-01	52804	\N	\N	f	Sales which are qualified	0
52804_3600.0_2005-09-15	360000	\N	2005-09-15	52804	\N	\N	f	Sales which are qualified	0
52804_3900.0_2000-02-01	390000	\N	2000-02-01	52804	\N	\N	f	Sales which are qualified	0
52804_5950.0_2002-09-01	595000	\N	2002-09-01	52804	\N	\N	f	Sales which are qualified	0
52805_1910.0_1996-01-01	191000	\N	1996-01-01	52805	\N	\N	f	Sales which are qualified	0
52805_2100.0_1999-03-01	210000	\N	1999-03-01	52805	\N	\N	f	Sales which are qualified	0
52806_2750.0_1996-01-01	275000	\N	1996-01-01	52806	\N	\N	f	Sales which are qualified	0
52806_5520.0_2011-09-15	552000	\N	2011-09-15	52806	\N	\N	f	Qual by exam of deed	0
52806_8800.0_2014-11-07	880000	\N	2014-11-07	52806	\N	\N	f	Qual by exam of deed	0
52807_2150.0_1996-02-01	215000	\N	1996-02-01	52807	\N	\N	f	Sales which are qualified	0
52808_2560.0_1996-03-01	256000	\N	1996-03-01	52808	\N	\N	f	Sales which are qualified	0
52808_8420.0_2022-04-27	842000	\N	2022-04-27	52808	\N	\N	f	Qual by exam of deed	0
52809_2540.0_1996-01-01	254000	\N	1996-01-01	52809	\N	\N	f	Sales which are qualified	0
52809_2600.0_1998-06-01	260000	\N	1998-06-01	52809	\N	\N	f	Sales which are qualified	0
52810_3760.0_1996-02-01	376000	\N	1996-02-01	52810	\N	\N	f	Sales which are qualified	0
52810_3950.0_1999-03-01	395000	\N	1999-03-01	52810	\N	\N	f	Sales which are qualified	0
52810_5750.0_2002-08-01	575000	\N	2002-08-01	52810	\N	\N	f	Sales which are qualified	0
52810_7150.0_2008-08-01	715000	\N	2008-08-01	52810	\N	\N	f	Sales which are qualified	0
52811_2780.0_1996-01-01	278000	\N	1996-01-01	52811	\N	\N	f	Sales which are qualified	0
52812_3890.0_1996-03-01	389000	\N	1996-03-01	52812	\N	\N	f	Sales which are qualified	0
52812_5350.0_2012-11-08	535000	\N	2012-11-08	52812	\N	\N	f	Qual by exam of deed	0
52812_7610.0_2004-09-01	761000	\N	2004-09-01	52812	\N	\N	f	Sales which are qualified	0
52813_1910.0_1996-02-01	191000	\N	1996-02-01	52813	\N	\N	f	Sales which are qualified	0
52813_4790.0_2019-03-08	479000	\N	2019-03-08	52813	\N	\N	f	Qual by exam of deed	0
52814_2750.0_1996-02-01	275000	\N	1996-02-01	52814	\N	\N	f	Sales which are qualified	0
52814_3450.0_2000-04-01	345000	\N	2000-04-01	52814	\N	\N	f	Sales which are qualified	0
52814_9400.0_2015-10-26	940000	\N	2015-10-26	52814	\N	\N	f	Qual by exam of deed	0
52815_2100.0_1996-02-01	210000	\N	1996-02-01	52815	\N	\N	f	Sales which are qualified	0
52815_2995.0_2001-07-01	299500	\N	2001-07-01	52815	\N	\N	f	Sales which are qualified	0
52815_4300.0_2011-06-20	430000	\N	2011-06-20	52815	\N	\N	f	Qual by exam of deed	0
52816_2560.0_1996-02-01	256000	\N	1996-02-01	52816	\N	\N	f	Sales which are qualified	0
52816_7350.0_2013-06-21	735000	\N	2013-06-21	52816	\N	\N	f	Qual by exam of deed	0
52817_2440.0_1996-02-01	244000	\N	1996-02-01	52817	\N	\N	f	Sales which are qualified	0
52817_3300.0_2000-10-01	330000	\N	2000-10-01	52817	\N	\N	f	Sales which are qualified	0
52817_4450.0_2003-06-01	445000	\N	2003-06-01	52817	\N	\N	f	Sales which are qualified	0
52817_6000.0_2004-09-01	600000	\N	2004-09-01	52817	\N	\N	f	Sales which are qualified	0
52818_12000.0_2014-12-12	1200000	\N	2014-12-12	52818	\N	\N	f	Qual by exam of deed	0
52818_16800.0_2023-01-16	1680000	\N	2023-01-16	52818	\N	\N	f	Qual by exam of deed	0
52818_3850.0_1998-06-01	385000	\N	1998-06-01	52818	\N	\N	f	Sales which are qualified	0
52818_6740.0_1996-02-01	674000	\N	1996-02-01	52818	\N	\N	t	Deeds that include more than one parcel	0
52819_3200.0_1998-07-01	320000	\N	1998-07-01	52819	\N	\N	f	Sales which are qualified	0
52819_6740.0_1996-02-01	674000	\N	1996-02-01	52819	\N	\N	t	Deeds that include more than one parcel	0
52820_12750.0_2022-02-02	1275000	\N	2022-02-02	52820	\N	\N	f	Qual by exam of deed	0
52820_3700.0_1997-03-01	370000	\N	1997-03-01	52820	\N	\N	f	Sales which are qualified	0
52821_1910.0_1996-02-01	191000	\N	1996-02-01	52821	\N	\N	f	Sales which are qualified	0
52821_2250.0_1999-10-01	225000	\N	1999-10-01	52821	\N	\N	f	Sales which are qualified	0
52821_3775.0_2011-09-06	377500	\N	2011-09-06	52821	\N	\N	f	Qual by exam of deed	0
52821_4600.0_2005-04-01	460000	\N	2005-04-01	52821	\N	\N	f	Sales which are qualified	0
52821_7260.0_2022-08-15	726000	\N	2022-08-15	52821	\N	\N	f	Qual by exam of deed	0
52822_10500.0_2016-05-12	1050000	\N	2016-05-12	52822	\N	\N	f	Qual by exam of deed	0
52822_2850.0_1996-03-01	285000	\N	1996-03-01	52822	\N	\N	f	Sales which are qualified	0
52822_3470.0_1999-01-01	347000	\N	1999-01-01	52822	\N	\N	f	Sales which are qualified	0
52822_3860.0_1999-07-01	386000	\N	1999-07-01	52822	\N	\N	f	Sales which are qualified	0
52822_8050.0_2006-04-01	805000	\N	2006-04-01	52822	\N	\N	f	Sales which are qualified	0
52823_2330.0_1996-02-01	233000	\N	1996-02-01	52823	\N	\N	f	Sales which are qualified	0
52823_2375.0_2000-01-01	237500	\N	2000-01-01	52823	\N	\N	f	Sales which are qualified	0
52823_9250.0_2015-09-17	925000	\N	2015-09-17	52823	\N	\N	f	Qual by exam of deed	0
52824_2560.0_1996-02-01	256000	\N	1996-02-01	52824	\N	\N	f	Sales which are qualified	0
52824_5500.0_2004-05-01	550000	\N	2004-05-01	52824	\N	\N	f	Sales which are qualified	0
52824_6900.0_2013-09-18	690000	\N	2013-09-18	52824	\N	\N	f	Qual by exam of deed	0
52825_2440.0_1996-02-01	244000	\N	1996-02-01	52825	\N	\N	f	Sales which are qualified	0
52825_2700.0_1997-12-01	270000	\N	1997-12-01	52825	\N	\N	f	Sales which are qualified	0
52826_10350.0_2020-09-15	1035000	\N	2020-09-15	52826	\N	\N	f	Qual by exam of deed	0
52826_3810.0_1996-03-01	381000	\N	1996-03-01	52826	\N	\N	f	Sales which are qualified	0
52826_4450.0_2000-06-01	445000	\N	2000-06-01	52826	\N	\N	f	Sales which are qualified	0
52827_11000.0_2021-01-06	1100000	\N	2021-01-06	52827	\N	\N	f	Qual by exam of deed	0
52827_11100.0_2015-04-08	1110000	\N	2015-04-08	52827	\N	\N	f	Qual by exam of deed	0
52827_3000.0_1997-12-01	300000	\N	1997-12-01	52827	\N	\N	f	Sales which are qualified	0
52827_3030.0_1996-06-01	303000	\N	1996-06-01	52827	\N	\N	f	Sales which are qualified	0
52827_5750.0_2010-11-11	575000	\N	2010-11-11	52827	\N	\N	f	Qual by exam of deed	0
52827_9650.0_2005-11-01	965000	\N	2005-11-01	52827	\N	\N	f	Sales which are qualified	0
52828_12500.0_2020-10-15	1250000	\N	2020-10-15	52828	\N	\N	f	Qual by exam of deed	0
52828_13140.0_2015-09-15	1314000	\N	2015-09-15	52828	\N	\N	f	Qual by exam of deed	0
52828_14500.0_2021-08-20	1450000	\N	2021-08-20	52828	\N	\N	f	Qual by exam of deed	0
52828_3100.0_1998-06-01	310000	\N	1998-06-01	52828	\N	\N	f	Sales which are qualified	0
52828_3640.0_1996-04-01	364000	\N	1996-04-01	52828	\N	\N	f	Sales which are qualified	0
52828_3750.0_1999-06-01	375000	\N	1999-06-01	52828	\N	\N	f	Sales which are qualified	0
52829_1860.0_1996-08-01	186000	\N	1996-08-01	52829	\N	\N	f	Sales which are qualified	0
52829_6250.0_1999-12-01	625000	\N	1999-12-01	52829	\N	\N	t	Deeds that include more than one parcel	0
52829_9500.0_2011-03-29	950000	\N	2011-03-29	52829	\N	\N	t	Qual on DOS, multi-parcel sale	0
52830_3140.0_1996-08-01	314000	\N	1996-08-01	52830	\N	\N	f	Sales which are qualified	0
52830_6250.0_1999-12-01	625000	\N	1999-12-01	52830	\N	\N	t	Deeds that include more than one parcel	0
52830_9500.0_2011-03-29	950000	\N	2011-03-29	52830	\N	\N	t	Qual on DOS, multi-parcel sale	0
52831_2250.0_1996-04-01	225000	\N	1996-04-01	52831	\N	\N	f	Sales which are qualified	0
52831_2595.0_1998-06-01	259500	\N	1998-06-01	52831	\N	\N	f	Sales which are qualified	0
52831_3500.0_2002-03-01	350000	\N	2002-03-01	52831	\N	\N	f	Sales which are qualified	0
52831_4500.0_2004-05-01	450000	\N	2004-05-01	52831	\N	\N	f	Sales which are qualified	0
52831_5200.0_2011-12-30	520000	\N	2011-12-30	52831	\N	\N	f	Qual by exam of deed	0
52831_6150.0_2005-05-01	615000	\N	2005-05-01	52831	\N	\N	f	Sales which are qualified	0
52831_7150.0_2018-06-29	715000	\N	2018-06-29	52831	\N	\N	f	Qual by exam of deed	0
52832_3050.0_1996-03-01	305000	\N	1996-03-01	52832	\N	\N	f	Sales which are qualified	0
52832_6050.0_2004-12-01	605000	\N	2004-12-01	52832	\N	\N	f	Sales which are qualified	0
52832_8250.0_2015-03-31	825000	\N	2015-03-31	52832	\N	\N	f	Qual by exam of deed	0
52833_2490.0_1996-03-01	249000	\N	1996-03-01	52833	\N	\N	f	Sales which are qualified	0
52833_3832.0_2002-08-01	383200	\N	2002-08-01	52833	\N	\N	f	Sales which are qualified	0
52833_4680.0_2004-05-01	468000	\N	2004-05-01	52833	\N	\N	f	Sales which are qualified	0
52834_3500.0_1995-12-01	350000	\N	1995-12-01	52834	\N	\N	f	Sales which are qualified	0
52834_4350.0_2000-10-01	435000	\N	2000-10-01	52834	\N	\N	f	Sales which are qualified	0
52834_8500.0_2019-04-11	850000	\N	2019-04-11	52834	\N	\N	f	Qual by exam of deed	0
52835_2610.0_1996-01-01	261000	\N	1996-01-01	52835	\N	\N	f	Sales which are qualified	0
52835_2650.0_1997-11-01	265000	\N	1997-11-01	52835	\N	\N	f	Sales which are qualified	0
52835_2690.0_1998-05-01	269000	\N	1998-05-01	52835	\N	\N	f	Sales which are qualified	0
52836_3000.0_1999-03-01	300000	\N	1999-03-01	52836	\N	\N	f	Sales which are qualified	0
52836_4000.0_2002-01-01	400000	\N	2002-01-01	52836	\N	\N	f	Sales which are qualified	0
52836_7950.0_2020-01-06	795000	\N	2020-01-06	52836	\N	\N	f	Qual by exam of deed	0
52837_1540.0_1995-12-01	154000	\N	1995-12-01	52837	\N	\N	f	Sales which are qualified	0
52837_1790.0_1996-08-01	179000	\N	1996-08-01	52837	\N	\N	f	Sales which are qualified	0
52837_3170.0_2004-08-01	317000	\N	2004-08-01	52837	\N	\N	f	Sales which are qualified	0
52838_2280.0_1996-01-01	228000	\N	1996-01-01	52838	\N	\N	f	Sales which are qualified	0
52838_3600.0_2002-12-01	360000	\N	2002-12-01	52838	\N	\N	f	Sales which are qualified	0
52838_4600.0_2004-09-01	460000	\N	2004-09-01	52838	\N	\N	f	Sales which are qualified	0
52838_6150.0_2014-09-03	615000	\N	2014-09-03	52838	\N	\N	f	Qual by exam of deed	0
52838_6600.0_2005-06-01	660000	\N	2005-06-01	52838	\N	\N	f	Sales which are qualified	0
52839_1750.0_1995-12-01	175000	\N	1995-12-01	52839	\N	\N	f	Sales which are qualified	0
52839_1930.0_1998-05-01	193000	\N	1998-05-01	52839	\N	\N	f	Sales which are qualified	0
52839_3500.0_2009-03-27	350000	\N	2009-03-27	52839	\N	\N	f	Qual by exam of deed	0
52840_2300.0_1995-11-01	230000	\N	1995-11-01	52840	\N	\N	f	Sales which are qualified	0
52840_3790.0_2003-12-01	379000	\N	2003-12-01	52840	\N	\N	f	Sales which are qualified	0
52840_4625.0_2013-02-05	462500	\N	2013-02-05	52840	\N	\N	f	Qual by exam of deed	0
52840_6200.0_2017-10-10	620000	\N	2017-10-10	52840	\N	\N	f	Qual by exam of deed	0
52841_2150.0_1995-12-01	215000	\N	1995-12-01	52841	\N	\N	f	Sales which are qualified	0
52842_3000.0_1997-10-01	300000	\N	1997-10-01	52842	\N	\N	f	Sales which are qualified	0
52842_4650.0_2001-08-01	465000	\N	2001-08-01	52842	\N	\N	f	Sales which are qualified	0
52842_8000.0_2007-03-01	800000	\N	2007-03-01	52842	\N	\N	f	Sales which are qualified	0
52843_2640.0_1995-12-01	264000	\N	1995-12-01	52843	\N	\N	f	Sales which are qualified	0
52843_3200.0_1998-11-01	320000	\N	1998-11-01	52843	\N	\N	f	Sales which are qualified	0
52843_9000.0_2018-05-29	900000	\N	2018-05-29	52843	\N	\N	f	Qual by exam of deed	0
52844_12000.0_2022-07-20	1200000	\N	2022-07-20	52844	\N	\N	f	Qual by exam of deed	0
52844_3200.0_1996-01-01	320000	\N	1996-01-01	52844	\N	\N	f	Sales which are qualified	0
52844_5750.0_2003-04-01	575000	\N	2003-04-01	52844	\N	\N	f	Sales which are qualified	0
52845_1570.0_1996-04-01	157000	\N	1996-04-01	52845	\N	\N	f	Sales which are qualified	0
52845_1810.0_1998-06-01	181000	\N	1998-06-01	52845	\N	\N	f	Sales which are qualified	0
52845_2950.0_2004-08-01	295000	\N	2004-08-01	52845	\N	\N	f	Sales which are qualified	0
52845_4500.0_2020-01-10	450000	\N	2020-01-10	52845	\N	\N	f	Qual by exam of deed	0
52846_2410.0_1995-11-01	241000	\N	1995-11-01	52846	\N	\N	f	Sales which are qualified	0
52846_2570.0_1999-03-01	257000	\N	1999-03-01	52846	\N	\N	f	Sales which are qualified	0
52847_1780.0_1995-12-01	178000	\N	1995-12-01	52847	\N	\N	f	Sales which are qualified	0
52848_2220.0_1996-01-01	222000	\N	1996-01-01	52848	\N	\N	f	Sales which are qualified	0
52848_2340.0_1999-12-01	234000	\N	1999-12-01	52848	\N	\N	f	Sales which are qualified	0
52848_5500.0_2021-04-11	550000	\N	2021-04-11	52848	\N	\N	f	Qual by exam of deed	0
52849_2100.0_1996-01-01	210000	\N	1996-01-01	52849	\N	\N	f	Sales which are qualified	0
52849_2100.0_1998-02-01	210000	\N	1998-02-01	52849	\N	\N	f	Sales which are qualified	0
52849_2950.0_2002-04-01	295000	\N	2002-04-01	52849	\N	\N	f	Sales which are qualified	0
52849_4750.0_2011-10-11	475000	\N	2011-10-11	52849	\N	\N	f	Qual by exam of deed	0
52850_5000.0_1996-03-01	500000	\N	1996-03-01	52850	\N	\N	f	Sales which are qualified	0
52850_7450.0_2004-06-01	745000	\N	2004-06-01	52850	\N	\N	f	Sales which are qualified	0
52851_11000.0_2018-06-21	1100000	\N	2018-06-21	52851	\N	\N	f	Qual by exam of deed	0
52851_16701.0_2022-04-20	1670100	\N	2022-04-20	52851	\N	\N	f	Qual by exam of deed	0
52851_3848.0_1996-03-01	384800	\N	1996-03-01	52851	\N	\N	f	Sales which are qualified	0
52851_8650.0_2005-09-01	865000	\N	2005-09-01	52851	\N	\N	f	Sales which are qualified	0
52851_9950.0_2006-04-01	995000	\N	2006-04-01	52851	\N	\N	f	Sales which are qualified	0
52852_13000.0_2021-02-04	1300000	\N	2021-02-04	52852	\N	\N	f	Qual by exam of deed	0
52852_13500.0_2016-06-17	1350000	\N	2016-06-17	52852	\N	\N	f	Qual by exam of deed	0
52852_3650.0_1997-10-01	365000	\N	1997-10-01	52852	\N	\N	f	Sales which are qualified	0
52852_4850.0_2000-09-01	485000	\N	2000-09-01	52852	\N	\N	f	Sales which are qualified	0
52852_5300.0_2002-04-01	530000	\N	2002-04-01	52852	\N	\N	f	Sales which are qualified	0
52853_2565.0_1996-03-01	256500	\N	1996-03-01	52853	\N	\N	f	Sales which are qualified	0
52853_4850.0_2010-06-15	485000	\N	2010-06-15	52853	\N	\N	f	Qual by exam of deed	0
52853_5141.0_2005-09-01	514100	\N	2005-09-01	52853	\N	\N	f	Sales which are qualified	0
52853_6150.0_2007-02-01	615000	\N	2007-02-01	52853	\N	\N	f	Sales which are qualified	0
52854_3000.0_1999-01-01	300000	\N	1999-01-01	52854	\N	\N	f	Sales which are qualified	0
52854_3850.0_1996-04-01	385000	\N	1996-04-01	52854	\N	\N	f	Sales which are qualified	0
52854_9970.0_2021-05-27	997000	\N	2021-05-27	52854	\N	\N	f	Qual by exam of deed	0
52855_2350.0_1998-05-01	235000	\N	1998-05-01	52855	\N	\N	f	Sales which are qualified	0
52856_12450.0_2022-08-04	1245000	\N	2022-08-04	52856	\N	\N	f	Qual by exam of deed	0
52856_2700.0_1997-10-01	270000	\N	1997-10-01	52856	\N	\N	f	Sales which are qualified	0
52856_2750.0_1999-06-01	275000	\N	1999-06-01	52856	\N	\N	f	Sales which are qualified	0
52856_6600.0_2013-07-01	660000	\N	2013-07-01	52856	\N	\N	f	Qual by exam of deed	0
52856_8490.0_2021-12-17	849000	\N	2021-12-17	52856	\N	\N	f	Qual by exam of deed	0
52857_3200.0_1996-04-01	320000	\N	1996-04-01	52857	\N	\N	f	Sales which are qualified	0
52857_3200.0_1998-12-01	320000	\N	1998-12-01	52857	\N	\N	f	Sales which are qualified	0
52857_4800.0_2004-06-01	480000	\N	2004-06-01	52857	\N	\N	f	Sales which are qualified	0
52857_7250.0_2013-12-20	725000	\N	2013-12-20	52857	\N	\N	f	Qual by exam of deed	0
52858_13000.0_2010-12-17	1300000	\N	2010-12-17	52858	\N	\N	t	Qual on DOS, multi-parcel sale	0
52858_28000.0_2018-05-30	2800000	\N	2018-05-30	52858	\N	\N	t	Qual on DOS, multi-parcel sale	0
52858_6620.0_1996-04-01	662000	\N	1996-04-01	52858	\N	\N	f	Sales which are qualified	0
52858_7000.0_2002-12-01	700000	\N	2002-12-01	52858	\N	\N	f	Sales which are qualified	0
52859_13000.0_2010-12-17	1300000	\N	2010-12-17	52859	\N	\N	t	Qual on DOS, multi-parcel sale	0
52859_28000.0_2018-05-30	2800000	\N	2018-05-30	52859	\N	\N	t	Qual on DOS, multi-parcel sale	0
52859_5500.0_1996-04-01	550000	\N	1996-04-01	52859	\N	\N	f	Sales which are qualified	0
52859_5500.0_2002-12-01	550000	\N	2002-12-01	52859	\N	\N	f	Sales which are qualified	0
52860_11000.0_2015-02-23	1100000	\N	2015-02-23	52860	\N	\N	f	Qual by exam of deed	0
52860_15730.0_2018-03-19	1573000	\N	2018-03-19	52860	\N	\N	f	Qual by exam of deed	0
52860_6620.0_1996-04-01	662000	\N	1996-04-01	52860	\N	\N	f	Sales which are qualified	0
52860_6620.0_1997-01-01	662000	\N	1997-01-01	52860	\N	\N	f	Sales which are qualified	0
52860_7950.0_2002-08-01	795000	\N	2002-08-01	52860	\N	\N	f	Sales which are qualified	0
52861_3450.0_2003-02-01	345000	\N	2003-02-01	52861	\N	\N	f	Sales which are qualified	0
52861_3480.0_1996-04-01	348000	\N	1996-04-01	52861	\N	\N	f	Sales which are qualified	0
52861_3480.0_1997-03-01	348000	\N	1997-03-01	52861	\N	\N	f	Sales which are qualified	0
52861_4500.0_2004-06-01	450000	\N	2004-06-01	52861	\N	\N	f	Sales which are qualified	0
52862_3633.0_2001-01-01	363300	\N	2001-01-01	52862	\N	\N	f	Sales which are qualified	0
52862_5360.0_1996-04-01	536000	\N	1996-04-01	52862	\N	\N	f	Sales which are qualified	0
52862_5360.0_1997-01-01	536000	\N	1997-01-01	52862	\N	\N	f	Sales which are qualified	0
52862_6975.0_2003-01-01	697500	\N	2003-01-01	52862	\N	\N	f	Sales which are qualified	0
52863_4430.0_2003-02-01	443000	\N	2003-02-01	52863	\N	\N	f	Sales which are qualified	0
52863_4600.0_1996-04-01	460000	\N	1996-04-01	52863	\N	\N	f	Sales which are qualified	0
52863_4600.0_1997-03-01	460000	\N	1997-03-01	52863	\N	\N	f	Sales which are qualified	0
52864_11500.0_2014-05-12	1150000	\N	2014-05-12	52864	\N	\N	f	Qual by exam of deed	0
52864_19000.0_2022-04-29	1900000	\N	2022-04-29	52864	\N	\N	f	Qual by exam of deed	0
52864_5000.0_1996-04-01	500000	\N	1996-04-01	52864	\N	\N	f	Sales which are qualified	0
52864_5000.0_1997-02-01	500000	\N	1997-02-01	52864	\N	\N	f	Sales which are qualified	0
52864_5175.0_2003-06-01	517500	\N	2003-06-01	52864	\N	\N	f	Sales which are qualified	0
52865_4150.0_2003-02-01	415000	\N	2003-02-01	52865	\N	\N	f	Sales which are qualified	0
52865_4750.0_1996-04-01	475000	\N	1996-04-01	52865	\N	\N	f	Sales which are qualified	0
52865_4750.0_1997-03-01	475000	\N	1997-03-01	52865	\N	\N	f	Sales which are qualified	0
52866_14000.0_2019-11-22	1400000	\N	2019-11-22	52866	\N	\N	f	Qual by exam of deed	0
52866_4000.0_1998-01-01	400000	\N	1998-01-01	52866	\N	\N	f	Sales which are qualified	0
52866_4400.0_2000-06-01	440000	\N	2000-06-01	52866	\N	\N	f	Sales which are qualified	0
52866_4410.0_1996-06-01	441000	\N	1996-06-01	52866	\N	\N	f	Sales which are qualified	0
52866_6830.0_2003-05-01	683000	\N	2003-05-01	52866	\N	\N	f	Sales which are qualified	0
52866_9700.0_2013-06-13	970000	\N	2013-06-13	52866	\N	\N	f	Qual by exam of deed	0
52867_3450.0_1996-08-01	345000	\N	1996-08-01	52867	\N	\N	f	Sales which are qualified	0
52867_7450.0_2013-04-30	745000	\N	2013-04-30	52867	\N	\N	f	Qual by exam of deed	0
52868_11600.0_2005-09-01	1160000	\N	2005-09-01	52868	\N	\N	f	Sales which are qualified	0
52868_3300.0_1998-02-01	330000	\N	1998-02-01	52868	\N	\N	f	Sales which are qualified	0
52868_6200.0_2003-02-01	620000	\N	2003-02-01	52868	\N	\N	f	Sales which are qualified	0
52868_9150.0_2005-05-01	915000	\N	2005-05-01	52868	\N	\N	f	Sales which are qualified	0
52869_2200.0_1998-12-01	220000	\N	1998-12-01	52869	\N	\N	f	Sales which are qualified	0
52869_2340.0_1996-12-01	234000	\N	1996-12-01	52869	\N	\N	f	Sales which are qualified	0
52869_3550.0_2003-08-01	355000	\N	2003-08-01	52869	\N	\N	f	Sales which are qualified	0
52869_5550.0_2013-08-30	555000	\N	2013-08-30	52869	\N	\N	f	Qual by exam of deed	0
52870_3500.0_1996-03-01	350000	\N	1996-03-01	52870	\N	\N	f	Sales which are qualified	0
52870_5000.0_2010-07-08	500000	\N	2010-07-08	52870	\N	\N	f	Qual by exam of deed	0
52870_7350.0_2011-07-26	735000	\N	2011-07-26	52870	\N	\N	f	Qual by exam of deed	0
52871_3120.0_1996-03-01	312000	\N	1996-03-01	52871	\N	\N	f	Sales which are qualified	0
52871_5323.0_2021-02-19	532300	\N	2021-02-19	52871	\N	\N	f	Qual by exam of deed	0
52872_2750.0_1998-12-01	275000	\N	1998-12-01	52872	\N	\N	f	Sales which are qualified	0
52872_3360.0_1996-03-01	336000	\N	1996-03-01	52872	\N	\N	f	Sales which are qualified	0
52882_8800.0_2015-04-24	880000	\N	2015-04-24	52882	\N	\N	f	Qual by exam of deed	0
52883_4750.0_1995-09-01	475000	\N	1995-09-01	52883	\N	\N	f	Sales which are qualified	0
52884_13250.0_2022-04-21	1325000	\N	2022-04-21	52884	\N	\N	f	Qual by exam of deed	0
52884_2358.0_1995-10-01	235800	\N	1995-10-01	52884	\N	\N	f	Sales which are qualified	0
52884_3900.0_2002-06-01	390000	\N	2002-06-01	52884	\N	\N	f	Sales which are qualified	0
52886_1967.0_1997-10-01	196700	\N	1997-10-01	52886	\N	\N	f	Sales which are qualified	0
52886_2980.0_2001-08-01	298000	\N	2001-08-01	52886	\N	\N	f	Sales which are qualified	0
52887_3500.0_2004-05-01	350000	\N	2004-05-01	52887	\N	\N	f	Sales which are qualified	0
52887_7050.0_2006-11-01	705000	\N	2006-11-01	52887	\N	\N	f	Sales which are qualified	0
52889_6000.0_2008-10-17	600000	\N	2008-10-17	52889	\N	\N	f	Sales which are qualified	0
52889_9500.0_2018-10-25	950000	\N	2018-10-25	52889	\N	\N	f	Qual by exam of deed	0
52890_2480.0_1995-09-01	248000	\N	1995-09-01	52890	\N	\N	f	Sales which are qualified	0
52890_3650.0_2001-03-01	365000	\N	2001-03-01	52890	\N	\N	f	Sales which are qualified	0
52890_6000.0_2011-04-27	600000	\N	2011-04-27	52890	\N	\N	f	Qual by exam of deed	0
52890_9065.0_2017-06-23	906500	\N	2017-06-23	52890	\N	\N	f	Qual by exam of deed	0
52891_5402.0_1995-08-01	540200	\N	1995-08-01	52891	\N	\N	f	Sales which are qualified	0
52892_2211.0_1997-10-01	221100	\N	1997-10-01	52892	\N	\N	f	Sales which are qualified	0
52892_6000.0_2008-04-01	600000	\N	2008-04-01	52892	\N	\N	f	Sales which are qualified	0
52893_2102.0_1995-12-01	210200	\N	1995-12-01	52893	\N	\N	f	Sales which are qualified	0
52893_5400.0_2010-06-24	540000	\N	2010-06-24	52893	\N	\N	f	Qual by exam of deed	0
52893_7500.0_2006-10-01	750000	\N	2006-10-01	52893	\N	\N	f	Sales which are qualified	0
52893_9300.0_2015-02-27	930000	\N	2015-02-27	52893	\N	\N	f	Qual by exam of deed	0
52894_13000.0_2005-08-01	1300000	\N	2005-08-01	52894	\N	\N	f	Sales which are qualified	0
52894_26000.0_2021-03-31	2600000	\N	2021-03-31	52894	\N	\N	f	Qual by exam of deed	0
52894_4095.0_1995-08-01	409500	\N	1995-08-01	52894	\N	\N	f	Sales which are qualified	0
52895_2080.0_1995-09-01	208000	\N	1995-09-01	52895	\N	\N	f	Sales which are qualified	0
52895_2780.0_1998-04-01	278000	\N	1998-04-01	52895	\N	\N	f	Sales which are qualified	0
52895_2900.0_1999-07-01	290000	\N	1999-07-01	52895	\N	\N	f	Sales which are qualified	0
52896_2070.0_1995-09-01	207000	\N	1995-09-01	52896	\N	\N	f	Sales which are qualified	0
52896_4150.0_2002-06-01	415000	\N	2002-06-01	52896	\N	\N	f	Sales which are qualified	0
52897_14000.0_2012-03-13	1400000	\N	2012-03-13	52897	\N	\N	f	Qual by exam of deed	0
52897_4290.0_1995-09-01	429000	\N	1995-09-01	52897	\N	\N	f	Sales which are qualified	0
52898_2286.0_1995-08-01	228600	\N	1995-08-01	52898	\N	\N	f	Sales which are qualified	0
52898_5480.0_2004-08-01	548000	\N	2004-08-01	52898	\N	\N	f	Sales which are qualified	0
52899_2057.0_1995-10-01	205700	\N	1995-10-01	52899	\N	\N	f	Sales which are qualified	0
52899_2500.0_1997-09-01	250000	\N	1997-09-01	52899	\N	\N	f	Sales which are qualified	0
52900_12000.0_2012-01-03	1200000	\N	2012-01-03	52900	\N	\N	f	Qual by exam of deed	0
52900_25500.0_2019-04-30	2550000	\N	2019-04-30	52900	\N	\N	f	Qual by exam of deed	0
52900_4900.0_1995-10-01	490000	\N	1995-10-01	52900	\N	\N	f	Sales which are qualified	0
52900_6150.0_2002-06-01	615000	\N	2002-06-01	52900	\N	\N	f	Sales which are qualified	0
52900_8250.0_2002-06-01	825000	\N	2002-06-01	52900	\N	\N	f	Sales which are qualified	0
52900_8700.0_2000-06-01	870000	\N	2000-06-01	52900	\N	\N	f	Sales which are qualified	0
52901_11500.0_2019-01-29	1150000	\N	2019-01-29	52901	\N	\N	f	Qual by exam of deed	0
52901_11500.0_2021-04-05	1150000	\N	2021-04-05	52901	\N	\N	f	Qual by exam of deed	0
52901_2500.0_1996-08-01	250000	\N	1996-08-01	52901	\N	\N	f	Sales which are qualified	0
52901_3300.0_2001-07-01	330000	\N	2001-07-01	52901	\N	\N	f	Sales which are qualified	0
52901_5200.0_2009-11-30	520000	\N	2009-11-30	52901	\N	\N	f	Qual by exam of deed	0
52902_4770.0_2004-03-01	477000	\N	2004-03-01	52902	\N	\N	f	Sales which are qualified	0
52902_5600.0_2009-03-25	560000	\N	2009-03-25	52902	\N	\N	f	Qual by exam of deed	0
52903_10000.0_2004-12-01	1000000	\N	2004-12-01	52903	\N	\N	f	Sales which are qualified	0
52903_17500.0_2012-12-20	1750000	\N	2012-12-20	52903	\N	\N	f	Qual by exam of deed	0
52903_4630.0_1996-08-01	463000	\N	1996-08-01	52903	\N	\N	f	Sales which are qualified	0
52903_6170.0_1999-01-01	617000	\N	1999-01-01	52903	\N	\N	f	Sales which are qualified	0
52904_10238.0_2021-07-19	1023800	\N	2021-07-19	52904	\N	\N	f	Qual by exam of deed	0
52904_2938.0_1995-10-01	293800	\N	1995-10-01	52904	\N	\N	f	Sales which are qualified	0
52905_2512.0_1995-11-01	251200	\N	1995-11-01	52905	\N	\N	f	Sales which are qualified	0
52905_2950.0_1998-11-01	295000	\N	1998-11-01	52905	\N	\N	f	Sales which are qualified	0
52905_3300.0_1999-07-01	330000	\N	1999-07-01	52905	\N	\N	f	Sales which are qualified	0
52905_3850.0_2001-06-01	385000	\N	2001-06-01	52905	\N	\N	f	Sales which are qualified	0
52906_5600.0_1996-02-01	560000	\N	1996-02-01	52906	\N	\N	f	Sales which are qualified	0
52906_6000.0_1999-08-01	600000	\N	1999-08-01	52906	\N	\N	f	Sales which are qualified	0
52907_3147.0_1995-12-01	314700	\N	1995-12-01	52907	\N	\N	f	Sales which are qualified	0
52907_6486.0_2005-09-01	648600	\N	2005-09-01	52907	\N	\N	f	Sales which are qualified	0
52908_2468.0_1995-10-01	246800	\N	1995-10-01	52908	\N	\N	f	Sales which are qualified	0
52908_2650.0_1996-01-01	265000	\N	1996-01-01	52908	\N	\N	f	Sales which are qualified	0
52908_3400.0_1999-10-01	340000	\N	1999-10-01	52908	\N	\N	f	Sales which are qualified	0
52909_28000.0_2016-10-05	2800000	\N	2016-10-05	52909	\N	\N	f	Qual by exam of deed	0
52909_5450.0_1995-12-01	545000	\N	1995-12-01	52909	\N	\N	f	Sales which are qualified	0
52910_11500.0_2021-10-19	1150000	\N	2021-10-19	52910	\N	\N	f	Qual by exam of deed	0
52910_2750.0_1996-03-01	275000	\N	1996-03-01	52910	\N	\N	f	Sales which are qualified	0
52910_2980.0_1998-02-01	298000	\N	1998-02-01	52910	\N	\N	f	Sales which are qualified	0
52910_5700.0_2009-07-15	570000	\N	2009-07-15	52910	\N	\N	f	Qual by exam of deed	0
52910_7450.0_2006-01-01	745000	\N	2006-01-01	52910	\N	\N	f	Sales which are qualified	0
52911_2194.0_1997-10-01	219400	\N	1997-10-01	52911	\N	\N	f	Sales which are qualified	0
52911_7300.0_2006-07-01	730000	\N	2006-07-01	52911	\N	\N	f	Sales which are qualified	0
52912_14000.0_2010-10-19	1400000	\N	2010-10-19	52912	\N	\N	f	Qual by exam of deed	0
52912_19490.0_2013-05-28	1949000	\N	2013-05-28	52912	\N	\N	f	Qual by exam of deed	0
52912_25000.0_2015-03-14	2500000	\N	2015-03-14	52912	\N	\N	f	Qual by exam of deed	0
52912_5400.0_1995-10-01	540000	\N	1995-10-01	52912	\N	\N	f	Sales which are qualified	0
52913_12150.0_2021-04-06	1215000	\N	2021-04-06	52913	\N	\N	f	Qual by exam of deed	0
52913_2600.0_1997-07-01	260000	\N	1997-07-01	52913	\N	\N	f	Sales which are qualified	0
52913_2800.0_1996-03-01	280000	\N	1996-03-01	52913	\N	\N	f	Sales which are qualified	0
52913_3600.0_1999-07-01	360000	\N	1999-07-01	52913	\N	\N	f	Sales which are qualified	0
52913_3750.0_2000-12-01	375000	\N	2000-12-01	52913	\N	\N	f	Sales which are qualified	0
52913_5700.0_2009-11-06	570000	\N	2009-11-06	52913	\N	\N	f	Qual by exam of deed	0
52913_8615.0_2013-07-30	861500	\N	2013-07-30	52913	\N	\N	f	Qual by exam of deed	0
52914_2497.0_1995-09-01	249700	\N	1995-09-01	52914	\N	\N	f	Sales which are qualified	0
52914_3500.0_2000-03-01	350000	\N	2000-03-01	52914	\N	\N	f	Sales which are qualified	0
52914_4750.0_2002-08-01	475000	\N	2002-08-01	52914	\N	\N	f	Sales which are qualified	0
52914_5400.0_2005-01-01	540000	\N	2005-01-01	52914	\N	\N	f	Sales which are qualified	0
52914_5800.0_2008-10-27	580000	\N	2008-10-27	52914	\N	\N	f	Sales which are qualified	0
52915_12000.0_2010-01-14	1200000	\N	2010-01-14	52915	\N	\N	f	Qual by exam of deed	0
52915_15500.0_2012-06-05	1550000	\N	2012-06-05	52915	\N	\N	f	Qual by exam of deed	0
52915_4990.0_1997-04-01	499000	\N	1997-04-01	52915	\N	\N	f	Sales which are qualified	0
52915_8070.0_2000-05-01	807000	\N	2000-05-01	52915	\N	\N	f	Sales which are qualified	0
52916_2500.0_1998-07-01	250000	\N	1998-07-01	52916	\N	\N	f	Sales which are qualified	0
52916_2750.0_1999-06-01	275000	\N	1999-06-01	52916	\N	\N	f	Sales which are qualified	0
52916_9800.0_2021-06-04	980000	\N	2021-06-04	52916	\N	\N	f	Qual by exam of deed	0
52917_10000.0_2017-12-11	1000000	\N	2017-12-11	52917	\N	\N	f	Qual by exam of deed	0
52917_11000.0_2021-05-04	1100000	\N	2021-05-04	52917	\N	\N	f	Qual by exam of deed	0
52917_2750.0_1997-12-01	275000	\N	1997-12-01	52917	\N	\N	f	Sales which are qualified	0
52918_17500.0_2013-08-09	1750000	\N	2013-08-09	52918	\N	\N	f	Qual by exam of deed	0
52918_4900.0_1997-01-01	490000	\N	1997-01-01	52918	\N	\N	f	Sales which are qualified	0
52919_14500.0_2015-07-07	1450000	\N	2015-07-07	52919	\N	\N	f	Qual by exam of deed	0
52919_2598.0_1996-06-01	259800	\N	1996-06-01	52919	\N	\N	f	Sales which are qualified	0
52920_11340.0_2014-05-28	1134000	\N	2014-05-28	52920	\N	\N	f	Qual by exam of deed	0
52920_15000.0_2022-10-14	1500000	\N	2022-10-14	52920	\N	\N	f	Qual by exam of deed	0
52920_2647.0_1996-06-01	264700	\N	1996-06-01	52920	\N	\N	f	Sales which are qualified	0
52920_3190.0_1997-07-01	319000	\N	1997-07-01	52920	\N	\N	f	Sales which are qualified	0
52920_6100.0_2011-12-07	610000	\N	2011-12-07	52920	\N	\N	f	Qual by exam of deed	0
52921_10500.0_2004-04-01	1050000	\N	2004-04-01	52921	\N	\N	f	Sales which are qualified	0
52921_6000.0_1996-06-01	600000	\N	1996-06-01	52921	\N	\N	f	Sales which are qualified	0
52922_2160.0_1995-07-01	216000	\N	1995-07-01	52922	\N	\N	f	Sales which are qualified	0
52923_2115.0_1995-10-01	211500	\N	1995-10-01	52923	\N	\N	f	Sales which are qualified	0
52924_10300.0_2021-05-28	1030000	\N	2021-05-28	52924	\N	\N	f	Qual by exam of deed	0
52924_2095.0_1996-01-01	209500	\N	1996-01-01	52924	\N	\N	f	Sales which are qualified	0
52925_2850.0_1996-12-01	285000	\N	1996-12-01	52925	\N	\N	f	Sales which are qualified	0
52925_3800.0_1999-12-01	380000	\N	1999-12-01	52925	\N	\N	f	Sales which are qualified	0
52926_2095.0_1996-01-01	209500	\N	1996-01-01	52926	\N	\N	f	Sales which are qualified	0
52926_2850.0_1997-11-01	285000	\N	1997-11-01	52926	\N	\N	f	Sales which are qualified	0
52926_4650.0_2002-04-01	465000	\N	2002-04-01	52926	\N	\N	f	Sales which are qualified	0
52926_6000.0_2004-04-01	600000	\N	2004-04-01	52926	\N	\N	f	Sales which are qualified	0
52926_7303.8_2005-04-01	730380	\N	2005-04-01	52926	\N	\N	f	Sales which are qualified	0
52927_1990.0_1995-10-01	199000	\N	1995-10-01	52927	\N	\N	f	Sales which are qualified	0
52927_2700.0_1999-04-01	270000	\N	1999-04-01	52927	\N	\N	f	Sales which are qualified	0
52927_9780.0_2022-02-14	978000	\N	2022-02-14	52927	\N	\N	f	Qual by exam of deed	0
52928_1950.0_1995-07-01	195000	\N	1995-07-01	52928	\N	\N	f	Sales which are qualified	0
52928_6900.0_2013-08-06	690000	\N	2013-08-06	52928	\N	\N	f	Qual by exam of deed	0
52928_8100.0_2017-01-04	810000	\N	2017-01-04	52928	\N	\N	f	Qual by exam of deed	0
52929_2331.0_1995-10-01	233100	\N	1995-10-01	52929	\N	\N	f	Sales which are qualified	0
52929_9000.0_2006-06-01	900000	\N	2006-06-01	52929	\N	\N	f	Sales which are qualified	0
52930_1908.0_1995-08-01	190800	\N	1995-08-01	52930	\N	\N	f	Sales which are qualified	0
52930_2100.0_1997-08-01	210000	\N	1997-08-01	52930	\N	\N	f	Sales which are qualified	0
52930_2400.0_1998-01-01	240000	\N	1998-01-01	52930	\N	\N	f	Sales which are qualified	0
52931_11550.0_2022-10-28	1155000	\N	2022-10-28	52931	\N	\N	f	Qual by exam of deed	0
52931_2058.0_1995-07-01	205800	\N	1995-07-01	52931	\N	\N	f	Sales which are qualified	0
52932_25000.0_2015-06-29	2500000	\N	2015-06-29	52932	\N	\N	f	Qual by exam of deed	0
52932_3506.0_1996-07-01	350600	\N	1996-07-01	52932	\N	\N	f	Sales which are qualified	0
52932_4800.0_1997-08-01	480000	\N	1997-08-01	52932	\N	\N	f	Sales which are qualified	0
52932_5500.0_2000-08-01	550000	\N	2000-08-01	52932	\N	\N	f	Sales which are qualified	0
52933_1953.0_1995-12-01	195300	\N	1995-12-01	52933	\N	\N	f	Sales which are qualified	0
52934_2250.0_1995-09-01	225000	\N	1995-09-01	52934	\N	\N	f	Sales which are qualified	0
52935_30500.0_2021-04-16	3050000	\N	2021-04-16	52935	\N	\N	f	Qual by exam of deed	0
52935_3735.0_1995-07-01	373500	\N	1995-07-01	52935	\N	\N	f	Sales which are qualified	0
52935_7750.0_1999-12-01	775000	\N	1999-12-01	52935	\N	\N	f	Sales which are qualified	0
52936_1998.0_1995-07-01	199800	\N	1995-07-01	52936	\N	\N	f	Sales which are qualified	0
52936_9000.0_2019-04-15	900000	\N	2019-04-15	52936	\N	\N	f	Qual by exam of deed	0
52937_1863.0_1995-11-01	186300	\N	1995-11-01	52937	\N	\N	f	Sales which are qualified	0
52937_3050.0_1999-07-01	305000	\N	1999-07-01	52937	\N	\N	f	Sales which are qualified	0
52937_4500.0_2003-09-01	450000	\N	2003-09-01	52937	\N	\N	f	Sales which are qualified	0
52937_5300.0_2008-05-01	530000	\N	2008-05-01	52937	\N	\N	f	Sales which are qualified	0
52938_4753.0_1995-11-01	475300	\N	1995-11-01	52938	\N	\N	f	Sales which are qualified	0
52950_17250.0_2006-12-01	1725000	\N	2006-12-01	52950	\N	\N	f	Sales which are qualified	0
52950_34000.0_2023-03-15	3400000	\N	2023-03-15	52950	\N	\N	f	Qual by exam of deed	0
52951_12250.0_2006-12-01	1225000	\N	2006-12-01	52951	\N	\N	f	Sales which are qualified	0
52951_13250.0_2008-07-01	1325000	\N	2008-07-01	52951	\N	\N	f	Sales which are qualified	0
52951_15300.0_2013-07-31	1530000	\N	2013-07-31	52951	\N	\N	f	Qual by exam of deed	0
52952_10300.0_2006-12-01	1030000	\N	2006-12-01	52952	\N	\N	f	Sales which are qualified	0
52952_10500.0_2013-03-18	1050000	\N	2013-03-18	52952	\N	\N	f	Qual by exam of deed	0
52952_17000.0_2015-05-08	1700000	\N	2015-05-08	52952	\N	\N	f	Qual by exam of deed	0
52953_12405.0_2006-12-01	1240500	\N	2006-12-01	52953	\N	\N	f	Sales which are qualified	0
52954_11875.0_2015-03-25	1187500	\N	2015-03-25	52954	\N	\N	f	Qual by exam of deed	0
52954_12425.0_2007-01-01	1242500	\N	2007-01-01	52954	\N	\N	f	Sales which are qualified	0
52954_6500.0_2011-12-14	650000	\N	2011-12-14	52954	\N	\N	f	Qual by exam of deed	0
52955_10650.0_2007-01-01	1065000	\N	2007-01-01	52955	\N	\N	f	Sales which are qualified	0
52955_9000.0_2008-09-28	900000	\N	2008-09-28	52955	\N	\N	f	Sales which are qualified	0
52956_14250.0_2006-12-01	1425000	\N	2006-12-01	52956	\N	\N	f	Sales which are qualified	0
52956_17050.0_2007-03-01	1705000	\N	2007-03-01	52956	\N	\N	f	Sales which are qualified	0
52957_12250.0_2006-12-01	1225000	\N	2006-12-01	52957	\N	\N	f	Sales which are qualified	0
52957_19500.0_2018-05-25	1950000	\N	2018-05-25	52957	\N	\N	f	Qual by exam of deed	0
52957_21500.0_2021-05-19	2150000	\N	2021-05-19	52957	\N	\N	f	Qual by exam of deed	0
52958_10750.0_2006-12-01	1075000	\N	2006-12-01	52958	\N	\N	f	Sales which are qualified	0
52958_10750.0_2012-01-31	1075000	\N	2012-01-31	52958	\N	\N	f	Qual by exam of deed	0
52959_11000.0_2018-06-04	1100000	\N	2018-06-04	52959	\N	\N	f	Qual by exam of deed	0
52959_12925.0_2006-12-01	1292500	\N	2006-12-01	52959	\N	\N	f	Sales which are qualified	0
52960_11750.0_2017-09-27	1175000	\N	2017-09-27	52960	\N	\N	f	Qual by exam of deed	0
52960_16441.5_2006-12-01	1644150	\N	2006-12-01	52960	\N	\N	f	Sales which are qualified	0
52960_18200.0_2022-06-14	1820000	\N	2022-06-14	52960	\N	\N	f	Qual by exam of deed	0
52961_11250.0_2006-12-01	1125000	\N	2006-12-01	52961	\N	\N	f	Sales which are qualified	0
52961_12000.0_2013-06-14	1200000	\N	2013-06-14	52961	\N	\N	f	Qual by exam of deed	0
52961_16500.0_2013-10-29	1650000	\N	2013-10-29	52961	\N	\N	f	Qual by exam of deed	0
52962_14500.0_2006-01-01	1450000	\N	2006-01-01	52962	\N	\N	f	Sales which are qualified	0
52962_16800.0_2007-04-01	1680000	\N	2007-04-01	52962	\N	\N	f	Sales which are qualified	0
52962_27000.0_2020-09-16	2700000	\N	2020-09-16	52962	\N	\N	f	Qual by exam of deed	0
52963_10010.0_2010-04-29	1001000	\N	2010-04-29	52963	\N	\N	f	Qual by exam of deed	0
52963_12500.0_2006-12-01	1250000	\N	2006-12-01	52963	\N	\N	f	Sales which are qualified	0
52963_13822.5_2007-02-01	1382250	\N	2007-02-01	52963	\N	\N	f	Sales which are qualified	0
52964_10300.0_2012-05-22	1030000	\N	2012-05-22	52964	\N	\N	f	Qual by exam of deed	0
52964_11000.0_2006-12-01	1100000	\N	2006-12-01	52964	\N	\N	f	Sales which are qualified	0
52964_13650.0_2019-11-06	1365000	\N	2019-11-06	52964	\N	\N	f	Qual by exam of deed	0
52965_22140.62_2014-05-06	2214062	\N	2014-05-06	52965	\N	\N	f	Qual by exam of deed	0
52965_23750.0_2007-01-01	2375000	\N	2007-01-01	52965	\N	\N	f	Sales which are qualified	0
52965_29750.0_2021-08-06	2975000	\N	2021-08-06	52965	\N	\N	f	Qual by exam of deed	0
52966_10950.0_2006-12-01	1095000	\N	2006-12-01	52966	\N	\N	f	Sales which are qualified	0
52966_8300.0_2011-08-17	830000	\N	2011-08-17	52966	\N	\N	f	Qual by exam of deed	0
52967_14750.0_2006-12-01	1475000	\N	2006-12-01	52967	\N	\N	f	Sales which are qualified	0
52967_17000.0_2006-12-01	1700000	\N	2006-12-01	52967	\N	\N	f	Sales which are qualified	0
52968_12500.0_2006-12-01	1250000	\N	2006-12-01	52968	\N	\N	f	Sales which are qualified	0
52968_14500.0_2007-04-01	1450000	\N	2007-04-01	52968	\N	\N	f	Sales which are qualified	0
52968_19100.0_2021-02-12	1910000	\N	2021-02-12	52968	\N	\N	f	Qual by exam of deed	0
52969_10115.0_2006-12-01	1011500	\N	2006-12-01	52969	\N	\N	f	Sales which are qualified	0
52969_13400.0_2021-02-05	1340000	\N	2021-02-05	52969	\N	\N	f	Qual by exam of deed	0
52970_19000.0_2011-04-27	1900000	\N	2011-04-27	52970	\N	\N	f	Qual by exam of deed	0
52970_20850.0_2006-12-01	2085000	\N	2006-12-01	52970	\N	\N	f	Sales which are qualified	0
52970_24000.0_2020-07-10	2400000	\N	2020-07-10	52970	\N	\N	f	Qual by exam of deed	0
52971_11250.0_2007-01-01	1125000	\N	2007-01-01	52971	\N	\N	f	Sales which are qualified	0
52971_20400.0_2021-12-02	2040000	\N	2021-12-02	52971	\N	\N	f	Qual by exam of deed	0
52971_9790.0_2008-01-01	979000	\N	2008-01-01	52971	\N	\N	f	Sales which are qualified	0
52972_14950.0_2006-12-01	1495000	\N	2006-12-01	52972	\N	\N	f	Sales which are qualified	0
52972_17500.0_2007-08-01	1750000	\N	2007-08-01	52972	\N	\N	f	Sales which are qualified	0
52972_17500.0_2011-11-08	1750000	\N	2011-11-08	52972	\N	\N	f	Qual by exam of deed	0
52972_40000.0_2022-04-14	4000000	\N	2022-04-14	52972	\N	\N	f	Qual by exam of deed	0
52973_13500.0_2006-12-01	1350000	\N	2006-12-01	52973	\N	\N	f	Sales which are qualified	0
52974_10750.0_2006-12-01	1075000	\N	2006-12-01	52974	\N	\N	f	Sales which are qualified	0
52974_8200.0_2009-03-24	820000	\N	2009-03-24	52974	\N	\N	f	Qual by exam of deed	0
52975_17750.0_2013-03-12	1775000	\N	2013-03-12	52975	\N	\N	f	Qual by exam of deed	0
52975_24250.0_2007-01-01	2425000	\N	2007-01-01	52975	\N	\N	f	Sales which are qualified	0
52976_11500.0_2007-01-01	1150000	\N	2007-01-01	52976	\N	\N	f	Sales which are qualified	0
52976_8800.0_2012-02-01	880000	\N	2012-02-01	52976	\N	\N	f	Qual by exam of deed	0
52977_15250.0_2006-12-01	1525000	\N	2006-12-01	52977	\N	\N	f	Sales which are qualified	0
52977_18000.0_2007-02-01	1800000	\N	2007-02-01	52977	\N	\N	f	Sales which are qualified	0
52977_18700.0_2010-06-15	1870000	\N	2010-06-15	52977	\N	\N	f	Qual by exam of deed	0
52978_13950.0_2007-01-01	1395000	\N	2007-01-01	52978	\N	\N	f	Sales which are qualified	0
52978_16500.0_2007-09-01	1650000	\N	2007-09-01	52978	\N	\N	f	Sales which are qualified	0
52979_10950.0_2006-12-01	1095000	\N	2006-12-01	52979	\N	\N	f	Sales which are qualified	0
52979_9825.0_2008-06-01	982500	\N	2008-06-01	52979	\N	\N	f	Sales which are qualified	0
52980_14500.0_2008-11-12	1450000	\N	2008-11-12	52980	\N	\N	f	Sales which are qualified	0
52980_17750.0_2012-04-04	1775000	\N	2012-04-04	52980	\N	\N	f	Qual by exam of deed	0
52980_48550.0_2022-11-16	4855000	\N	2022-11-16	52980	\N	\N	f	Qual by exam of deed	0
52981_12850.0_2006-12-01	1285000	\N	2006-12-01	52981	\N	\N	f	Sales which are qualified	0
52981_9500.0_2008-03-01	950000	\N	2008-03-01	52981	\N	\N	f	Sales which are qualified	0
52982_15500.0_2006-12-01	1550000	\N	2006-12-01	52982	\N	\N	f	Sales which are qualified	0
52982_20000.0_2012-11-21	2000000	\N	2012-11-21	52982	\N	\N	f	Qual by exam of deed	0
52983_16130.0_2012-05-30	1613000	\N	2012-05-30	52983	\N	\N	f	Qual by exam of deed	0
52983_23000.0_2007-07-01	2300000	\N	2007-07-01	52983	\N	\N	f	Sales which are qualified	0
52984_11950.0_2007-01-01	1195000	\N	2007-01-01	52984	\N	\N	f	Sales which are qualified	0
52984_7750.0_2011-01-18	775000	\N	2011-01-18	52984	\N	\N	f	Qual by exam of deed	0
52985_15750.0_2006-12-01	1575000	\N	2006-12-01	52985	\N	\N	f	Sales which are qualified	0
52985_18800.0_2006-12-01	1880000	\N	2006-12-01	52985	\N	\N	f	Sales which are qualified	0
52986_16750.0_2007-01-01	1675000	\N	2007-01-01	52986	\N	\N	f	Sales which are qualified	0
52986_18250.0_2007-12-01	1825000	\N	2007-12-01	52986	\N	\N	f	Sales which are qualified	0
52986_28000.0_2018-07-13	2800000	\N	2018-07-13	52986	\N	\N	f	Qual by exam of deed	0
52986_34000.0_2023-04-28	3400000	\N	2023-04-28	52986	\N	\N	f	Qual by exam of deed	0
52987_13500.0_2007-04-01	1350000	\N	2007-04-01	52987	\N	\N	f	Sales which are qualified	0
52987_18000.0_2022-12-07	1800000	\N	2022-12-07	52987	\N	\N	f	Qual by exam of deed	0
52987_9950.0_2006-12-01	995000	\N	2006-12-01	52987	\N	\N	f	Sales which are qualified	0
52988_10400.0_2021-08-20	1040000	\N	2021-08-20	52988	\N	\N	f	Qual by exam of deed	0
52988_11800.0_2007-05-01	1180000	\N	2007-05-01	52988	\N	\N	f	Sales which are qualified	0
52988_7250.0_2006-12-01	725000	\N	2006-12-01	52988	\N	\N	f	Sales which are qualified	0
52989_12150.0_2015-11-24	1215000	\N	2015-11-24	52989	\N	\N	f	Qual by exam of deed	0
52989_14000.0_2022-02-11	1400000	\N	2022-02-11	52989	\N	\N	f	Qual by exam of deed	0
52989_5000.0_2011-05-13	500000	\N	2011-05-13	52989	\N	\N	f	Qual by exam of deed	0
52989_8750.0_2006-12-01	875000	\N	2006-12-01	52989	\N	\N	f	Sales which are qualified	0
52990_8250.0_2013-07-09	825000	\N	2013-07-09	52990	\N	\N	f	Qual by exam of deed	0
52990_8750.0_2021-01-08	875000	\N	2021-01-08	52990	\N	\N	f	Qual by exam of deed	0
52990_8793.0_2006-12-01	879300	\N	2006-12-01	52990	\N	\N	f	Sales which are qualified	0
52991_10000.0_2006-12-01	1000000	\N	2006-12-01	52991	\N	\N	f	Sales which are qualified	0
52992_12500.0_2006-12-01	1250000	\N	2006-12-01	52992	\N	\N	f	Sales which are qualified	0
52992_12900.0_2006-12-01	1290000	\N	2006-12-01	52992	\N	\N	f	Sales which are qualified	0
52992_25500.0_2023-04-10	2550000	\N	2023-04-10	52992	\N	\N	f	Qual by exam of deed	0
52993_10000.0_2006-12-01	1000000	\N	2006-12-01	52993	\N	\N	f	Sales which are qualified	0
52993_10000.0_2007-11-01	1000000	\N	2007-11-01	52993	\N	\N	f	Sales which are qualified	0
52993_15250.0_2014-02-10	1525000	\N	2014-02-10	52993	\N	\N	f	Qual by exam of deed	0
52993_18500.0_2022-04-06	1850000	\N	2022-04-06	52993	\N	\N	f	Qual by exam of deed	0
52994_14500.0_2022-03-01	1450000	\N	2022-03-01	52994	\N	\N	f	Qual by exam of deed	0
52994_8500.0_2011-09-01	850000	\N	2011-09-01	52994	\N	\N	f	Qual by exam of deed	0
52994_9950.0_2006-12-01	995000	\N	2006-12-01	52994	\N	\N	f	Sales which are qualified	0
52995_10500.0_2007-01-01	1050000	\N	2007-01-01	52995	\N	\N	f	Sales which are qualified	0
52995_11000.0_2022-06-25	1100000	\N	2022-06-25	52995	\N	\N	f	Qual by exam of deed	0
52995_5850.0_2011-11-12	585000	\N	2011-11-12	52995	\N	\N	f	Qual by exam of deed	0
52996_9450.0_2017-09-29	945000	\N	2017-09-29	52996	\N	\N	f	Qual by exam of deed	0
52996_9750.0_2007-02-01	975000	\N	2007-02-01	52996	\N	\N	f	Sales which are qualified	0
52997_10400.0_2006-12-01	1040000	\N	2006-12-01	52997	\N	\N	f	Sales which are qualified	0
52997_14500.0_2014-05-14	1450000	\N	2014-05-14	52997	\N	\N	f	Qual by exam of deed	0
52997_16150.0_2016-03-09	1615000	\N	2016-03-09	52997	\N	\N	f	Qual by exam of deed	0
52998_13250.0_2006-12-01	1325000	\N	2006-12-01	52998	\N	\N	f	Sales which are qualified	0
52998_16400.0_2007-02-01	1640000	\N	2007-02-01	52998	\N	\N	f	Sales which are qualified	0
52998_33000.0_2023-01-09	3300000	\N	2023-01-09	52998	\N	\N	f	Qual by exam of deed	0
52999_10000.0_2006-12-01	1000000	\N	2006-12-01	52999	\N	\N	f	Sales which are qualified	0
52999_9600.0_2011-05-01	960000	\N	2011-05-01	52999	\N	\N	f	Qual by exam of deed	0
53000_10100.0_2020-07-28	1010000	\N	2020-07-28	53000	\N	\N	f	Qual by exam of deed	0
53000_12000.0_2013-06-28	1200000	\N	2013-06-28	53000	\N	\N	f	Qual by exam of deed	0
53000_8600.0_2006-12-01	860000	\N	2006-12-01	53000	\N	\N	f	Sales which are qualified	0
53001_12700.0_2019-04-24	1270000	\N	2019-04-24	53001	\N	\N	f	Qual by exam of deed	0
53001_8600.0_2017-04-17	860000	\N	2017-04-17	53001	\N	\N	f	Qual by exam of deed	0
53001_9950.0_2007-01-01	995000	\N	2007-01-01	53001	\N	\N	f	Sales which are qualified	0
53002_14500.0_2022-09-26	1450000	\N	2022-09-26	53002	\N	\N	f	Qual by exam of deed	0
53002_9650.0_2007-01-01	965000	\N	2007-01-01	53002	\N	\N	f	Sales which are qualified	0
53003_12750.0_2013-09-16	1275000	\N	2013-09-16	53003	\N	\N	f	Qual by exam of deed	0
53003_13250.0_2020-11-02	1325000	\N	2020-11-02	53003	\N	\N	f	Qual by exam of deed	0
53003_9750.0_2006-12-01	975000	\N	2006-12-01	53003	\N	\N	f	Sales which are qualified	0
53004_12800.0_2006-12-01	1280000	\N	2006-12-01	53004	\N	\N	f	Sales which are qualified	0
53004_14800.0_2007-02-01	1480000	\N	2007-02-01	53004	\N	\N	f	Sales which are qualified	0
53004_7500.0_2010-05-18	750000	\N	2010-05-18	53004	\N	\N	f	Qual by exam of deed	0
53005_11000.0_2006-12-01	1100000	\N	2006-12-01	53005	\N	\N	f	Sales which are qualified	0
53006_10250.0_2007-10-09	1025000	\N	2007-10-09	53006	\N	\N	f	Sales which are qualified	0
53006_12000.0_2017-03-28	1200000	\N	2017-03-28	53006	\N	\N	f	Qual by exam of deed	0
53006_12750.0_2021-03-24	1275000	\N	2021-03-24	53006	\N	\N	f	Qual by exam of deed	0
53006_9950.0_2006-12-01	995000	\N	2006-12-01	53006	\N	\N	f	Sales which are qualified	0
53007_11000.0_2013-09-30	1100000	\N	2013-09-30	53007	\N	\N	f	Qual by exam of deed	0
53007_14950.0_2022-02-18	1495000	\N	2022-02-18	53007	\N	\N	f	Qual by exam of deed	0
53007_9950.0_2006-12-01	995000	\N	2006-12-01	53007	\N	\N	f	Sales which are qualified	0
53008_9935.0_2017-08-04	993500	\N	2017-08-04	53008	\N	\N	f	Qual by exam of deed	0
53008_9950.0_2006-12-01	995000	\N	2006-12-01	53008	\N	\N	f	Sales which are qualified	0
53009_9850.0_2006-12-01	985000	\N	2006-12-01	53009	\N	\N	f	Sales which are qualified	0
53010_13250.0_2007-02-01	1325000	\N	2007-02-01	53010	\N	\N	f	Sales which are qualified	0
53010_14000.0_2008-10-23	1400000	\N	2008-10-23	53010	\N	\N	f	Sales which are qualified	0
53010_17000.0_2007-02-01	1700000	\N	2007-02-01	53010	\N	\N	f	Sales which are qualified	0
53010_28750.0_2021-06-23	2875000	\N	2021-06-23	53010	\N	\N	f	Qual by exam of deed	0
53011_11950.0_2006-12-01	1195000	\N	2006-12-01	53011	\N	\N	f	Sales which are qualified	0
53011_15250.0_2021-07-28	1525000	\N	2021-07-28	53011	\N	\N	f	Qual by exam of deed	0
53012_11500.0_2012-10-25	1150000	\N	2012-10-25	53012	\N	\N	f	Qual by exam of deed	0
53012_14600.0_2014-02-26	1460000	\N	2014-02-26	53012	\N	\N	f	Qual by exam of deed	0
53012_9750.0_2006-12-01	975000	\N	2006-12-01	53012	\N	\N	f	Sales which are qualified	0
53013_10350.0_2019-12-04	1035000	\N	2019-12-04	53013	\N	\N	f	Qual by exam of deed	0
53013_9500.0_2007-02-01	950000	\N	2007-02-01	53013	\N	\N	f	Sales which are qualified	0
53014_13600.0_2021-11-29	1360000	\N	2021-11-29	53014	\N	\N	f	Qual by exam of deed	0
53014_8895.0_2012-07-24	889500	\N	2012-07-24	53014	\N	\N	f	Qual by exam of deed	0
53014_9750.0_2006-12-01	975000	\N	2006-12-01	53014	\N	\N	f	Sales which are qualified	0
53015_10800.0_2006-12-01	1080000	\N	2006-12-01	53015	\N	\N	f	Sales which are qualified	0
53015_16600.0_2015-04-09	1660000	\N	2015-04-09	53015	\N	\N	f	Qual by exam of deed	0
53016_13500.0_2006-12-01	1350000	\N	2006-12-01	53016	\N	\N	f	Sales which are qualified	0
53016_15750.0_2007-01-01	1575000	\N	2007-01-01	53016	\N	\N	f	Sales which are qualified	0
53016_26000.0_2014-04-17	2600000	\N	2014-04-17	53016	\N	\N	f	Qual by exam of deed	0
53016_29000.0_2019-02-28	2900000	\N	2019-02-28	53016	\N	\N	f	Qual by exam of deed	0
53021_32000.0_2012-04-20	3200000	\N	2012-04-20	53021	\N	\N	f	Qual by exam of deed	0
53021_34750.0_2006-12-22	3475000	\N	2006-12-22	53021	\N	\N	f	Sales which are qualified	0
53021_50700.0_2015-03-09	5070000	\N	2015-03-09	53021	\N	\N	f	Qual by exam of deed	0
53022_15000.0_2009-01-30	1500000	\N	2009-01-30	53022	\N	\N	f	Qual by exam of deed	0
53023_17500.0_2008-12-30	1750000	\N	2008-12-30	53023	\N	\N	f	Sales which are qualified	0
53025_28190.0_2007-07-01	2819000	\N	2007-07-01	53025	\N	\N	f	Sales which are qualified	0
53026_24000.0_2013-05-21	2400000	\N	2013-05-21	53026	\N	\N	f	Qual by exam of deed	0
53026_31750.0_2007-03-01	3175000	\N	2007-03-01	53026	\N	\N	f	Sales which are qualified	0
53027_17000.0_2009-08-14	1700000	\N	2009-08-14	53027	\N	\N	f	Qual by exam of deed	0
53027_18500.0_2012-03-25	1850000	\N	2012-03-25	53027	\N	\N	f	Qual by exam of deed	0
53027_32000.0_2007-02-01	3200000	\N	2007-02-01	53027	\N	\N	f	Sales which are qualified	0
53028_15000.0_2010-09-27	1500000	\N	2010-09-27	53028	\N	\N	f	Qual by exam of deed	0
53028_31000.0_2007-02-01	3100000	\N	2007-02-01	53028	\N	\N	f	Sales which are qualified	0
53042_13750.0_2020-08-26	1375000	\N	2020-08-26	53042	\N	\N	f	Qual by exam of deed	0
53045_24500.0_2020-09-21	2450000	\N	2020-09-21	53045	\N	\N	f	Qual by exam of deed	0
53046_17500.0_2019-10-03	1750000	\N	2019-10-03	53046	\N	\N	f	Qual by exam of deed	0
53047_22000.0_2019-09-19	2200000	\N	2019-09-19	53047	\N	\N	f	Qual by exam of deed	0
53047_39500.0_2022-07-14	3950000	\N	2022-07-14	53047	\N	\N	f	Qual by exam of deed	0
53050_12250.0_2021-02-26	1225000	\N	2021-02-26	53050	\N	\N	f	Qual by exam of deed	0
53051_28000.0_2021-03-15	2800000	\N	2021-03-15	53051	\N	\N	f	Qual by exam of deed	0
53053_27000.0_2021-04-16	2700000	\N	2021-04-16	53053	\N	\N	f	Qual by exam of deed	0
53053_32000.0_2022-02-23	3200000	\N	2022-02-23	53053	\N	\N	f	Qual by exam of deed	0
53054_25000.0_2020-02-26	2500000	\N	2020-02-26	53054	\N	\N	f	Qual by exam of deed	0
53055_36000.0_2020-03-02	3600000	\N	2020-03-02	53055	\N	\N	f	Qual by exam of deed	0
53055_50000.0_2022-11-02	5000000	\N	2022-11-02	53055	\N	\N	f	Qual by exam of deed	0
53058_34500.0_2020-02-28	3450000	\N	2020-02-28	53058	\N	\N	f	Qual by exam of deed	0
53063_33125.0_2021-05-09	3312500	\N	2021-05-09	53063	\N	\N	f	Qual by exam of deed	0
53063_38850.0_2020-03-16	3885000	\N	2020-03-16	53063	\N	\N	f	Qual by exam of deed	0
53066_13950.0_2019-10-22	1395000	\N	2019-10-22	53066	\N	\N	f	Qual by exam of deed	0
53066_30900.0_2023-09-17	3090000	\N	2023-09-17	53066	\N	\N	f	Qual by exam of deed	0
53067_23000.0_2020-10-23	2300000	\N	2020-10-23	53067	\N	\N	f	Qual by exam of deed	0
53067_34750.0_2022-05-11	3475000	\N	2022-05-11	53067	\N	\N	f	Qual by exam of deed	0
53067_37000.0_2019-10-01	3700000	\N	2019-10-01	53067	\N	\N	f	Qual by exam of deed	0
53069_22000.0_2019-10-01	2200000	\N	2019-10-01	53069	\N	\N	f	Qual by exam of deed	0
53070_23528.0_2019-09-24	2352800	\N	2019-09-24	53070	\N	\N	f	Qual by exam of deed	0
53071_22000.0_2019-09-23	2200000	\N	2019-09-23	53071	\N	\N	f	Qual by exam of deed	0
53072_21900.0_2019-10-17	2190000	\N	2019-10-17	53072	\N	\N	f	Qual by exam of deed	0
53072_23000.0_2021-02-26	2300000	\N	2021-02-26	53072	\N	\N	f	Qual by exam of deed	0
53073_14750.0_2019-10-25	1475000	\N	2019-10-25	53073	\N	\N	f	Qual by exam of deed	0
53073_15000.0_2020-01-29	1500000	\N	2020-01-29	53073	\N	\N	f	Qual by exam of deed	0
53074_12500.0_2021-01-14	1250000	\N	2021-01-14	53074	\N	\N	f	Qual by exam of deed	0
53075_27585.0_2020-02-13	2758500	\N	2020-02-13	53075	\N	\N	f	Qual by exam of deed	0
53075_30300.0_2022-02-18	3030000	\N	2022-02-18	53075	\N	\N	f	Qual by exam of deed	0
53076_23850.0_2020-02-14	2385000	\N	2020-02-14	53076	\N	\N	f	Qual by exam of deed	0
53076_30000.0_2022-01-13	3000000	\N	2022-01-13	53076	\N	\N	f	Qual by exam of deed	0
53080_42750.0_2021-05-13	4275000	\N	2021-05-13	53080	\N	\N	f	Qual by exam of deed	0
53083_13500.0_2020-03-11	1350000	\N	2020-03-11	53083	\N	\N	f	Qual by exam of deed	0
53083_13950.0_2019-09-25	1395000	\N	2019-09-25	53083	\N	\N	f	Qual by exam of deed	0
53083_15750.0_2021-05-17	1575000	\N	2021-05-17	53083	\N	\N	f	Qual by exam of deed	0
53085_27250.0_2021-02-16	2725000	\N	2021-02-16	53085	\N	\N	f	Qual by exam of deed	0
53087_23714.0_2019-09-10	2371400	\N	2019-09-10	53087	\N	\N	f	Qual by exam of deed	0
53088_21750.0_2021-04-01	2175000	\N	2021-04-01	53088	\N	\N	f	Qual by exam of deed	0
53089_20750.0_2021-05-10	2075000	\N	2021-05-10	53089	\N	\N	f	Qual by exam of deed	0
53089_22500.0_2021-07-14	2250000	\N	2021-07-14	53089	\N	\N	f	Qual by exam of deed	0
53090_22000.0_2021-06-10	2200000	\N	2021-06-10	53090	\N	\N	f	Qual by exam of deed	0
53093_28000.0_2020-02-14	2800000	\N	2020-02-14	53093	\N	\N	f	Qual by exam of deed	0
53094_32500.0_2021-02-18	3250000	\N	2021-02-18	53094	\N	\N	f	Qual by exam of deed	0
53094_44000.0_2022-01-06	4400000	\N	2022-01-06	53094	\N	\N	f	Qual by exam of deed	0
53097_44000.0_2019-09-20	4400000	\N	2019-09-20	53097	\N	\N	f	Qual by exam of deed	0
53097_59000.0_2022-05-03	5900000	\N	2022-05-03	53097	\N	\N	f	Qual by exam of deed	0
53098_51500.0_2021-09-20	5150000	\N	2021-09-20	53098	\N	\N	f	Qual by exam of deed	0
53099_63748.0_2019-09-27	6374800	\N	2019-09-27	53099	\N	\N	f	Qual by exam of deed	0
53102_55000.0_2021-06-28	5500000	\N	2021-06-28	53102	\N	\N	f	Qual by exam of deed	0
53104_42375.0_2021-03-01	4237500	\N	2021-03-01	53104	\N	\N	f	Qual by exam of deed	0
53106_56000.0_2019-09-26	5600000	\N	2019-09-26	53106	\N	\N	f	Qual by exam of deed	0
53107_54600.0_2021-08-27	5460000	\N	2021-08-27	53107	\N	\N	f	Qual by exam of deed	0
53107_74000.0_2023-05-29	7400000	\N	2023-05-29	53107	\N	\N	f	Qual by exam of deed	0
53108_51000.0_2021-06-07	5100000	\N	2021-06-07	53108	\N	\N	f	Qual by exam of deed	0
53114_47500.0_2020-01-31	4750000	\N	2020-01-31	53114	\N	\N	f	Qual by exam of deed	0
53120_28250.0_2020-11-13	2825000	\N	2020-11-13	53120	\N	\N	f	Qual by exam of deed	0
53127_21250.0_2021-04-21	2125000	\N	2021-04-21	53127	\N	\N	f	Qual by exam of deed	0
53132_48750.0_2021-03-29	4875000	\N	2021-03-29	53132	\N	\N	f	Qual by exam of deed	0
53133_150000.0_2021-01-31	15000000	\N	2021-01-31	53133	\N	\N	f	Qual by exam of deed	0
53134_150000.0_2021-01-11	15000000	\N	2021-01-11	53134	\N	\N	f	Qual by exam of deed	0
53135_63000.0_2021-12-08	6300000	\N	2021-12-08	53135	\N	\N	f	Qual by exam of deed	0
53140_4000.0_2010-10-18	400000	\N	2010-10-18	53140	\N	\N	f	Qual by exam of deed	0
53142_4000.0_2010-10-18	400000	\N	2010-10-18	53142	\N	\N	f	Qual by exam of deed	0
53145_4650.0_2012-03-19	465000	\N	2012-03-19	53145	\N	\N	f	Qual by exam of deed	0
53145_7250.0_2022-05-31	725000	\N	2022-05-31	53145	\N	\N	f	Qual by exam of deed	0
53148_4000.0_2010-10-18	400000	\N	2010-10-18	53148	\N	\N	f	Qual by exam of deed	0
53149_4111.36_2011-12-09	411136	\N	2011-12-09	53149	\N	\N	f	Qual by exam of deed	0
53157_4330.0_2011-01-18	433000	\N	2011-01-18	53157	\N	\N	f	Qual by exam of deed	0
53157_5360.0_2018-08-07	536000	\N	2018-08-07	53157	\N	\N	f	Qual by exam of deed	0
53163_4070.0_2011-02-09	407000	\N	2011-02-09	53163	\N	\N	f	Qual by exam of deed	0
53163_5600.0_2021-03-05	560000	\N	2021-03-05	53163	\N	\N	f	Qual by exam of deed	0
53163_5725.0_2017-07-13	572500	\N	2017-07-13	53163	\N	\N	f	Qual by exam of deed	0
53164_4700.0_2011-07-22	470000	\N	2011-07-22	53164	\N	\N	f	Qual by exam of deed	0
53164_6200.0_2016-07-29	620000	\N	2016-07-29	53164	\N	\N	f	Qual by exam of deed	0
53165_4080.0_2011-03-03	408000	\N	2011-03-03	53165	\N	\N	f	Qual by exam of deed	0
53165_5560.0_2021-05-27	556000	\N	2021-05-27	53165	\N	\N	f	Qual by exam of deed	0
53166_4300.0_2010-10-22	430000	\N	2010-10-22	53166	\N	\N	f	Qual by exam of deed	0
53166_5600.0_2013-08-14	560000	\N	2013-08-14	53166	\N	\N	f	Qual by exam of deed	0
53167_4750.0_2011-09-01	475000	\N	2011-09-01	53167	\N	\N	f	Qual by exam of deed	0
53167_6100.0_2013-06-21	610000	\N	2013-06-21	53167	\N	\N	f	Qual by exam of deed	0
53168_4850.0_2011-10-12	485000	\N	2011-10-12	53168	\N	\N	f	Qual by exam of deed	0
53169_4150.0_2011-11-03	415000	\N	2011-11-03	53169	\N	\N	f	Qual by exam of deed	0
53169_8650.0_2023-07-24	865000	\N	2023-07-24	53169	\N	\N	f	Qual by exam of deed	0
53170_4072.32_2010-11-19	407232	\N	2010-11-19	53170	\N	\N	f	Qual by exam of deed	0
53170_5544.0_2016-10-26	554400	\N	2016-10-26	53170	\N	\N	f	Qual by exam of deed	0
53171_4090.0_2010-11-22	409000	\N	2010-11-22	53171	\N	\N	f	Qual by exam of deed	0
53171_5400.0_2020-09-01	540000	\N	2020-09-01	53171	\N	\N	f	Qual by exam of deed	0
53171_6290.0_2015-04-09	629000	\N	2015-04-09	53171	\N	\N	f	Qual by exam of deed	0
53172_3670.0_2010-12-30	367000	\N	2010-12-30	53172	\N	\N	f	Qual by exam of deed	0
53172_4900.0_2019-03-27	490000	\N	2019-03-27	53172	\N	\N	f	Qual by exam of deed	0
53173_3700.0_2010-12-30	370000	\N	2010-12-30	53173	\N	\N	f	Qual by exam of deed	0
53173_5500.0_2020-12-14	550000	\N	2020-12-14	53173	\N	\N	f	Qual by exam of deed	0
53174_3794.02_2010-11-19	379402	\N	2010-11-19	53174	\N	\N	f	Qual by exam of deed	0
53174_6000.0_2015-11-02	600000	\N	2015-11-02	53174	\N	\N	f	Qual by exam of deed	0
53175_4150.0_2011-06-07	415000	\N	2011-06-07	53175	\N	\N	f	Qual by exam of deed	0
53176_5000.0_2010-11-22	500000	\N	2010-11-22	53176	\N	\N	f	Qual by exam of deed	0
53176_5200.0_2019-07-29	520000	\N	2019-07-29	53176	\N	\N	f	Qual by exam of deed	0
53177_3980.0_2011-02-04	398000	\N	2011-02-04	53177	\N	\N	f	Qual by exam of deed	0
53178_4300.0_2011-02-16	430000	\N	2011-02-16	53178	\N	\N	f	Qual by exam of deed	0
53178_6350.0_2014-05-30	635000	\N	2014-05-30	53178	\N	\N	f	Qual by exam of deed	0
53179_4500.0_2010-10-13	450000	\N	2010-10-13	53179	\N	\N	f	Qual by exam of deed	0
53179_5200.0_2012-07-01	520000	\N	2012-07-01	53179	\N	\N	f	Qual by exam of deed	0
53179_5250.0_2013-05-07	525000	\N	2013-05-07	53179	\N	\N	f	Qual by exam of deed	0
53179_5250.0_2019-11-06	525000	\N	2019-11-06	53179	\N	\N	f	Qual by exam of deed	0
53179_6305.0_2015-10-08	630500	\N	2015-10-08	53179	\N	\N	f	Qual by exam of deed	0
53180_4700.0_2011-02-28	470000	\N	2011-02-28	53180	\N	\N	f	Qual by exam of deed	0
53180_5040.0_2019-01-31	504000	\N	2019-01-31	53180	\N	\N	f	Qual by exam of deed	0
53181_4000.0_2010-10-18	400000	\N	2010-10-18	53181	\N	\N	f	Qual by exam of deed	0
53181_7550.0_2023-02-28	755000	\N	2023-02-28	53181	\N	\N	f	Qual by exam of deed	0
53182_4500.0_2010-10-25	450000	\N	2010-10-25	53182	\N	\N	f	Qual by exam of deed	0
53182_6500.0_2021-12-28	650000	\N	2021-12-28	53182	\N	\N	f	Qual by exam of deed	0
53183_4000.0_2010-10-18	400000	\N	2010-10-18	53183	\N	\N	f	Qual by exam of deed	0
53184_4250.0_2011-07-27	425000	\N	2011-07-27	53184	\N	\N	f	Qual by exam of deed	0
53184_6150.0_2014-08-06	615000	\N	2014-08-06	53184	\N	\N	f	Qual by exam of deed	0
53184_7250.0_2022-06-04	725000	\N	2022-06-04	53184	\N	\N	f	Qual by exam of deed	0
53185_4000.0_2010-10-18	400000	\N	2010-10-18	53185	\N	\N	f	Qual by exam of deed	0
53186_4390.0_2011-03-30	439000	\N	2011-03-30	53186	\N	\N	f	Qual by exam of deed	0
53186_6350.0_2014-12-22	635000	\N	2014-12-22	53186	\N	\N	f	Qual by exam of deed	0
53187_4000.0_2010-10-18	400000	\N	2010-10-18	53187	\N	\N	f	Qual by exam of deed	0
53187_5600.0_2021-07-22	560000	\N	2021-07-22	53187	\N	\N	f	Qual by exam of deed	0
53188_4230.0_2011-02-10	423000	\N	2011-02-10	53188	\N	\N	f	Qual by exam of deed	0
53189_4000.0_2010-10-18	400000	\N	2010-10-18	53189	\N	\N	f	Qual by exam of deed	0
53189_5530.0_2021-06-28	553000	\N	2021-06-28	53189	\N	\N	f	Qual by exam of deed	0
53190_4500.0_2011-01-28	450000	\N	2011-01-28	53190	\N	\N	f	Qual by exam of deed	0
53190_5250.0_2019-03-28	525000	\N	2019-03-28	53190	\N	\N	f	Qual by exam of deed	0
53190_5300.0_2012-05-01	530000	\N	2012-05-01	53190	\N	\N	f	Qual by exam of deed	0
53192_4500.0_2010-10-13	450000	\N	2010-10-13	53192	\N	\N	f	Qual by exam of deed	0
53192_5400.0_2012-07-01	540000	\N	2012-07-01	53192	\N	\N	f	Qual by exam of deed	0
53192_5550.0_2013-06-27	555000	\N	2013-06-27	53192	\N	\N	f	Qual by exam of deed	0
53194_4072.32_2010-11-19	407232	\N	2010-11-19	53194	\N	\N	f	Qual by exam of deed	0
53194_6075.0_2015-09-24	607500	\N	2015-09-24	53194	\N	\N	f	Qual by exam of deed	0
53194_7250.0_2022-07-15	725000	\N	2022-07-15	53194	\N	\N	f	Qual by exam of deed	0
53195_4500.0_2010-10-13	450000	\N	2010-10-13	53195	\N	\N	f	Qual by exam of deed	0
53195_4900.0_2012-07-01	490000	\N	2012-07-01	53195	\N	\N	f	Qual by exam of deed	0
53195_5200.0_2013-02-15	520000	\N	2013-02-15	53195	\N	\N	f	Qual by exam of deed	0
53195_5600.0_2017-03-16	560000	\N	2017-03-16	53195	\N	\N	f	Qual by exam of deed	0
53196_4072.32_2010-11-19	407232	\N	2010-11-19	53196	\N	\N	f	Qual by exam of deed	0
53196_5050.0_2020-03-16	505000	\N	2020-03-16	53196	\N	\N	f	Qual by exam of deed	0
53196_5500.0_2017-06-29	550000	\N	2017-06-29	53196	\N	\N	f	Qual by exam of deed	0
53198_4580.0_2010-11-15	458000	\N	2010-11-15	53198	\N	\N	f	Qual by exam of deed	0
53198_5200.0_2019-10-25	520000	\N	2019-10-25	53198	\N	\N	f	Qual by exam of deed	0
53199_4600.0_2019-07-02	460000	\N	2019-07-02	53199	\N	\N	f	Qual by exam of deed	0
53199_4980.0_2018-06-22	498000	\N	2018-06-22	53199	\N	\N	f	Qual by exam of deed	0
53200_4390.0_2010-11-15	439000	\N	2010-11-15	53200	\N	\N	f	Qual by exam of deed	0
53200_6150.0_2016-02-16	615000	\N	2016-02-16	53200	\N	\N	f	Qual by exam of deed	0
53200_6500.0_2021-07-29	650000	\N	2021-07-29	53200	\N	\N	f	Qual by exam of deed	0
53202_4190.0_2010-12-02	419000	\N	2010-12-02	53202	\N	\N	f	Qual by exam of deed	0
53202_7200.0_2022-02-28	720000	\N	2022-02-28	53202	\N	\N	f	Qual by exam of deed	0
53203_4500.0_2010-10-13	450000	\N	2010-10-13	53203	\N	\N	f	Qual by exam of deed	0
53203_5650.0_2013-08-14	565000	\N	2013-08-14	53203	\N	\N	f	Qual by exam of deed	0
53203_6980.0_2021-04-28	698000	\N	2021-04-28	53203	\N	\N	f	Qual by exam of deed	0
53204_3750.0_2010-12-28	375000	\N	2010-12-28	53204	\N	\N	f	Qual by exam of deed	0
53204_5750.0_2015-11-30	575000	\N	2015-11-30	53204	\N	\N	f	Qual by exam of deed	0
53205_4494.4_2011-01-18	449440	\N	2011-01-18	53205	\N	\N	f	Qual by exam of deed	0
53205_7700.0_2023-04-25	770000	\N	2023-04-25	53205	\N	\N	f	Qual by exam of deed	0
53206_4355.0_2010-12-06	435500	\N	2010-12-06	53206	\N	\N	f	Qual by exam of deed	0
53207_5250.0_2011-03-25	525000	\N	2011-03-25	53207	\N	\N	f	Qual by exam of deed	0
53208_4500.0_2010-10-13	450000	\N	2010-10-13	53208	\N	\N	f	Qual by exam of deed	0
53208_5820.0_2013-08-01	582000	\N	2013-08-01	53208	\N	\N	f	Qual by exam of deed	0
53209_5040.0_2010-10-13	504000	\N	2010-10-13	53209	\N	\N	f	Qual by exam of deed	0
53209_5600.0_2017-08-04	560000	\N	2017-08-04	53209	\N	\N	f	Qual by exam of deed	0
53210_4390.0_2010-11-15	439000	\N	2010-11-15	53210	\N	\N	f	Qual by exam of deed	0
53210_6350.0_2015-08-31	635000	\N	2015-08-31	53210	\N	\N	f	Qual by exam of deed	0
53211_3794.02_2010-11-19	379402	\N	2010-11-19	53211	\N	\N	f	Qual by exam of deed	0
53211_4650.0_2012-06-20	465000	\N	2012-06-20	53211	\N	\N	f	Qual by exam of deed	0
53212_4225.0_2011-05-31	422500	\N	2011-05-31	53212	\N	\N	f	Qual by exam of deed	0
53212_7600.0_2022-05-16	760000	\N	2022-05-16	53212	\N	\N	f	Qual by exam of deed	0
53213_4550.0_2010-11-30	455000	\N	2010-11-30	53213	\N	\N	f	Qual by exam of deed	0
53214_4500.0_2010-10-13	450000	\N	2010-10-13	53214	\N	\N	f	Qual by exam of deed	0
53214_5600.0_2017-07-11	560000	\N	2017-07-11	53214	\N	\N	f	Qual by exam of deed	0
53214_6165.0_2013-10-01	616500	\N	2013-10-01	53214	\N	\N	f	Qual by exam of deed	0
53215_5140.0_2010-10-22	514000	\N	2010-10-22	53215	\N	\N	f	Qual by exam of deed	0
53215_5200.0_2019-10-07	520000	\N	2019-10-07	53215	\N	\N	f	Qual by exam of deed	0
53215_5400.0_2012-05-30	540000	\N	2012-05-30	53215	\N	\N	f	Qual by exam of deed	0
53215_5900.0_2013-11-19	590000	\N	2013-11-19	53215	\N	\N	f	Qual by exam of deed	0
53216_4467.26_2010-11-18	446726	\N	2010-11-18	53216	\N	\N	f	Qual by exam of deed	0
53216_4990.0_2019-03-05	499000	\N	2019-03-05	53216	\N	\N	f	Qual by exam of deed	0
53217_5500.0_2011-03-09	550000	\N	2011-03-09	53217	\N	\N	f	Qual by exam of deed	0
53217_6000.0_2012-06-14	600000	\N	2012-06-14	53217	\N	\N	f	Qual by exam of deed	0
53218_6350.0_2011-08-18	635000	\N	2011-08-18	53218	\N	\N	f	Qual by exam of deed	0
53219_8290.0_2010-10-25	829000	\N	2010-10-25	53219	\N	\N	f	Qual by exam of deed	0
53219_9500.0_2017-08-24	950000	\N	2017-08-24	53219	\N	\N	f	Qual by exam of deed	0
53220_2840.0_2011-02-22	284000	\N	2011-02-22	53220	\N	\N	f	Qual by exam of deed	0
53221_2950.0_2010-11-15	295000	\N	2010-11-15	53221	\N	\N	f	Qual by exam of deed	0
53221_4000.0_2015-01-20	400000	\N	2015-01-20	53221	\N	\N	f	Qual by exam of deed	0
53222_5700.0_2011-08-01	570000	\N	2011-08-01	53222	\N	\N	f	Qual by exam of deed	0
53222_8150.0_2016-02-26	815000	\N	2016-02-26	53222	\N	\N	f	Qual by exam of deed	0
53223_6500.0_2010-10-29	650000	\N	2010-10-29	53223	\N	\N	f	Qual by exam of deed	0
53224_5700.0_2011-12-14	570000	\N	2011-12-14	53224	\N	\N	f	Qual by exam of deed	0
53225_6650.0_2011-01-06	665000	\N	2011-01-06	53225	\N	\N	f	Qual by exam of deed	0
53225_8500.0_2015-06-10	850000	\N	2015-06-10	53225	\N	\N	f	Qual by exam of deed	0
53226_2750.0_2011-02-25	275000	\N	2011-02-25	53226	\N	\N	f	Qual by exam of deed	0
53226_3140.0_2020-09-29	314000	\N	2020-09-29	53226	\N	\N	f	Qual by exam of deed	0
53227_2900.0_2011-01-28	290000	\N	2011-01-28	53227	\N	\N	f	Qual by exam of deed	0
53227_3500.0_2020-06-19	350000	\N	2020-06-19	53227	\N	\N	f	Qual by exam of deed	0
53227_3630.0_2017-03-28	363000	\N	2017-03-28	53227	\N	\N	f	Qual by exam of deed	0
53227_4254.0_2022-05-05	425400	\N	2022-05-05	53227	\N	\N	f	Qual by exam of deed	0
53227_4815.0_2022-07-11	481500	\N	2022-07-11	53227	\N	\N	f	Qual by exam of deed	0
53228_5700.0_2011-10-11	570000	\N	2011-10-11	53228	\N	\N	f	Qual by exam of deed	0
53228_8300.0_2017-03-13	830000	\N	2017-03-13	53228	\N	\N	f	Qual by exam of deed	0
53228_8950.0_2021-06-03	895000	\N	2021-06-03	53228	\N	\N	f	Qual by exam of deed	0
53229_10000.0_2021-06-30	1000000	\N	2021-06-30	53229	\N	\N	f	Qual by exam of deed	0
53229_6650.0_2011-02-24	665000	\N	2011-02-24	53229	\N	\N	f	Qual by exam of deed	0
53229_8100.0_2018-06-20	810000	\N	2018-06-20	53229	\N	\N	f	Qual by exam of deed	0
53230_5600.0_2011-11-18	560000	\N	2011-11-18	53230	\N	\N	f	Qual by exam of deed	0
53230_8580.0_2014-10-15	858000	\N	2014-10-15	53230	\N	\N	f	Qual by exam of deed	0
53231_12500.0_2020-09-10	1250000	\N	2020-09-10	53231	\N	\N	f	Qual by exam of deed	0
53231_13000.0_2015-03-02	1300000	\N	2015-03-02	53231	\N	\N	f	Qual by exam of deed	0
53231_7500.0_2012-05-04	750000	\N	2012-05-04	53231	\N	\N	f	Qual by exam of deed	0
53232_2500.0_2010-11-30	250000	\N	2010-11-30	53232	\N	\N	f	Qual by exam of deed	0
53232_3450.0_2013-07-01	345000	\N	2013-07-01	53232	\N	\N	f	Qual by exam of deed	0
53232_3500.0_2020-11-12	350000	\N	2020-11-12	53232	\N	\N	f	Qual by exam of deed	0
53232_3520.0_2018-06-06	352000	\N	2018-06-06	53232	\N	\N	f	Qual by exam of deed	0
53233_5850.0_2012-03-21	585000	\N	2012-03-21	53233	\N	\N	f	Qual by exam of deed	0
53234_6285.0_2012-03-16	628500	\N	2012-03-16	53234	\N	\N	f	Qual by exam of deed	0
53234_8400.0_2015-09-04	840000	\N	2015-09-04	53234	\N	\N	f	Qual by exam of deed	0
53235_5750.0_2012-04-27	575000	\N	2012-04-27	53235	\N	\N	f	Qual by exam of deed	0
53236_12900.0_2023-06-13	1290000	\N	2023-06-13	53236	\N	\N	f	Qual by exam of deed	0
53236_6375.0_2011-12-15	637500	\N	2011-12-15	53236	\N	\N	f	Qual by exam of deed	0
53236_8000.0_2020-10-20	800000	\N	2020-10-20	53236	\N	\N	f	Qual by exam of deed	0
53237_2500.0_2010-11-19	250000	\N	2010-11-19	53237	\N	\N	f	Qual by exam of deed	0
53237_3400.0_2017-03-17	340000	\N	2017-03-17	53237	\N	\N	f	Qual by exam of deed	0
53238_2500.0_2010-12-30	250000	\N	2010-12-30	53238	\N	\N	f	Qual by exam of deed	0
53238_3925.0_2015-07-02	392500	\N	2015-07-02	53238	\N	\N	f	Qual by exam of deed	0
53238_5250.0_2022-05-17	525000	\N	2022-05-17	53238	\N	\N	f	Qual by exam of deed	0
53239_6650.0_2012-03-16	665000	\N	2012-03-16	53239	\N	\N	f	Qual by exam of deed	0
53240_7200.0_2011-03-04	720000	\N	2011-03-04	53240	\N	\N	f	Qual by exam of deed	0
53241_5850.0_2012-04-25	585000	\N	2012-04-25	53241	\N	\N	f	Qual by exam of deed	0
53241_7675.0_2019-05-30	767500	\N	2019-05-30	53241	\N	\N	f	Qual by exam of deed	0
53241_8300.0_2017-05-31	830000	\N	2017-05-31	53241	\N	\N	f	Qual by exam of deed	0
53241_8625.0_2015-01-30	862500	\N	2015-01-30	53241	\N	\N	f	Qual by exam of deed	0
53242_6500.0_2012-03-02	650000	\N	2012-03-02	53242	\N	\N	f	Qual by exam of deed	0
53243_2650.0_2010-11-15	265000	\N	2010-11-15	53243	\N	\N	f	Qual by exam of deed	0
53243_3850.0_2017-05-30	385000	\N	2017-05-30	53243	\N	\N	f	Qual by exam of deed	0
53243_4900.0_2022-09-23	490000	\N	2022-09-23	53243	\N	\N	f	Qual by exam of deed	0
53244_2500.0_2010-11-19	250000	\N	2010-11-19	53244	\N	\N	f	Qual by exam of deed	0
53244_3800.0_2015-11-09	380000	\N	2015-11-09	53244	\N	\N	f	Qual by exam of deed	0
53245_12000.0_2022-12-16	1200000	\N	2022-12-16	53245	\N	\N	f	Qual by exam of deed	0
53245_7050.0_2011-07-12	705000	\N	2011-07-12	53245	\N	\N	f	Qual by exam of deed	0
53246_10500.0_2021-12-30	1050000	\N	2021-12-30	53246	\N	\N	f	Qual by exam of deed	0
53246_6300.0_2012-03-30	630000	\N	2012-03-30	53246	\N	\N	f	Qual by exam of deed	0
53246_8350.0_2017-02-17	835000	\N	2017-02-17	53246	\N	\N	f	Qual by exam of deed	0
53247_7600.0_2011-11-19	760000	\N	2011-11-19	53247	\N	\N	f	Qual by exam of deed	0
53248_2500.0_2010-11-19	250000	\N	2010-11-19	53248	\N	\N	f	Qual by exam of deed	0
53248_3500.0_2016-09-15	350000	\N	2016-09-15	53248	\N	\N	f	Qual by exam of deed	0
53249_4020.3_2012-12-21	402030	\N	2012-12-21	53249	\N	\N	f	Qual by exam of deed	0
53249_6350.0_2012-03-09	635000	\N	2012-03-09	53249	\N	\N	f	Qual by exam of deed	0
53250_6250.0_2011-11-30	625000	\N	2011-11-30	53250	\N	\N	f	Qual by exam of deed	0
53251_2800.0_2010-10-25	280000	\N	2010-10-25	53251	\N	\N	f	Qual by exam of deed	0
53251_3200.0_2016-12-09	320000	\N	2016-12-09	53251	\N	\N	f	Qual by exam of deed	0
53252_10500.0_2014-01-21	1050000	\N	2014-01-21	53252	\N	\N	f	Qual by exam of deed	0
53252_6870.0_2010-10-25	687000	\N	2010-10-25	53252	\N	\N	f	Qual by exam of deed	0
53253_11750.0_2022-08-01	1175000	\N	2022-08-01	53253	\N	\N	f	Qual by exam of deed	0
53253_7000.0_2011-07-07	700000	\N	2011-07-07	53253	\N	\N	f	Qual by exam of deed	0
53253_8600.0_2015-01-20	860000	\N	2015-01-20	53253	\N	\N	f	Qual by exam of deed	0
53253_9000.0_2013-09-11	900000	\N	2013-09-11	53253	\N	\N	f	Qual by exam of deed	0
53254_2990.0_2010-12-30	299000	\N	2010-12-30	53254	\N	\N	f	Qual by exam of deed	0
53254_3287.0_2012-09-04	328700	\N	2012-09-04	53254	\N	\N	f	Qual by exam of deed	0
53254_3499.0_2021-05-17	349900	\N	2021-05-17	53254	\N	\N	f	Qual by exam of deed	0
53255_8500.0_2010-10-25	850000	\N	2010-10-25	53255	\N	\N	f	Qual by exam of deed	0
53262_19350.0_2005-12-01	1935000	\N	2005-12-01	53262	\N	\N	f	Sales which are qualified	0
53262_35000.0_2007-01-01	3500000	\N	2007-01-01	53262	\N	\N	f	Sales which are qualified	0
53263_18350.0_2005-11-01	1835000	\N	2005-11-01	53263	\N	\N	f	Sales which are qualified	0
53263_23000.0_2008-04-01	2300000	\N	2008-04-01	53263	\N	\N	f	Sales which are qualified	0
53264_22750.0_2005-11-01	2275000	\N	2005-11-01	53264	\N	\N	f	Sales which are qualified	0
53265_26000.0_2012-12-03	2600000	\N	2012-12-03	53265	\N	\N	f	Qual by exam of deed	0
53265_43000.0_2015-06-17	4300000	\N	2015-06-17	53265	\N	\N	f	Qual by exam of deed	0
53265_8700.0_2005-12-01	870000	\N	2005-12-01	53265	\N	\N	f	Sales which are qualified	0
53266_18200.0_2022-05-25	1820000	\N	2022-05-25	53266	\N	\N	f	Qual by exam of deed	0
53266_5500.0_2009-11-09	550000	\N	2009-11-09	53266	\N	\N	f	Qual by exam of deed	0
53266_6000.0_2005-12-01	600000	\N	2005-12-01	53266	\N	\N	f	Sales which are qualified	0
53267_10000.0_2005-11-01	1000000	\N	2005-11-01	53267	\N	\N	f	Sales which are qualified	0
53267_15700.0_2021-04-12	1570000	\N	2021-04-12	53267	\N	\N	f	Qual by exam of deed	0
53267_17250.0_2015-03-27	1725000	\N	2015-03-27	53267	\N	\N	f	Qual by exam of deed	0
53267_19000.0_2022-05-04	1900000	\N	2022-05-04	53267	\N	\N	f	Qual by exam of deed	0
53268_14550.0_2005-11-01	1455000	\N	2005-11-01	53268	\N	\N	f	Sales which are qualified	0
53268_20400.0_2006-07-01	2040000	\N	2006-07-01	53268	\N	\N	f	Sales which are qualified	0
53269_16500.0_2005-11-01	1650000	\N	2005-11-01	53269	\N	\N	f	Sales which are qualified	0
53269_22750.0_2005-11-01	2275000	\N	2005-11-01	53269	\N	\N	f	Sales which are qualified	0
53269_22850.0_2008-10-08	2285000	\N	2008-10-08	53269	\N	\N	f	Sales which are qualified	0
53269_32000.0_2018-06-21	3200000	\N	2018-06-21	53269	\N	\N	f	Qual by exam of deed	0
53270_18750.0_2005-11-01	1875000	\N	2005-11-01	53270	\N	\N	f	Sales which are qualified	0
53270_53000.0_2022-05-05	5300000	\N	2022-05-05	53270	\N	\N	f	Qual by exam of deed	0
53271_19500.0_2005-11-01	1950000	\N	2005-11-01	53271	\N	\N	f	Sales which are qualified	0
53271_24000.0_2008-03-01	2400000	\N	2008-03-01	53271	\N	\N	f	Sales which are qualified	0
53272_22600.0_2005-11-01	2260000	\N	2005-11-01	53272	\N	\N	f	Sales which are qualified	0
53273_18500.0_2005-11-01	1850000	\N	2005-11-01	53273	\N	\N	f	Sales which are qualified	0
53273_21000.0_2010-04-01	2100000	\N	2010-04-01	53273	\N	\N	f	Qual by exam of deed	0
53273_26800.0_2012-01-12	2680000	\N	2012-01-12	53273	\N	\N	f	Qual by exam of deed	0
53274_12500.0_2021-07-28	1250000	\N	2021-07-28	53274	\N	\N	f	Qual by exam of deed	0
53274_6150.0_2005-11-01	615000	\N	2005-11-01	53274	\N	\N	f	Sales which are qualified	0
53274_7300.0_2008-10-27	730000	\N	2008-10-27	53274	\N	\N	f	Sales which are qualified	0
53275_10990.0_2012-03-27	1099000	\N	2012-03-27	53275	\N	\N	f	Qual by exam of deed	0
53275_15000.0_2021-03-16	1500000	\N	2021-03-16	53275	\N	\N	f	Qual by exam of deed	0
53275_15500.0_2014-02-28	1550000	\N	2014-02-28	53275	\N	\N	f	Qual by exam of deed	0
53275_8500.0_2005-11-01	850000	\N	2005-11-01	53275	\N	\N	f	Sales which are qualified	0
53275_8500.0_2008-06-01	850000	\N	2008-06-01	53275	\N	\N	f	Sales which are qualified	0
53276_10500.0_2005-11-01	1050000	\N	2005-11-01	53276	\N	\N	f	Sales which are qualified	0
53276_26000.0_2021-04-23	2600000	\N	2021-04-23	53276	\N	\N	f	Qual by exam of deed	0
53277_16050.0_2005-12-01	1605000	\N	2005-12-01	53277	\N	\N	f	Sales which are qualified	0
53277_23000.0_2007-02-01	2300000	\N	2007-02-01	53277	\N	\N	f	Sales which are qualified	0
53277_34000.0_2013-01-24	3400000	\N	2013-01-24	53277	\N	\N	f	Qual by exam of deed	0
53277_35000.0_2020-08-28	3500000	\N	2020-08-28	53277	\N	\N	f	Qual by exam of deed	0
53278_20640.0_2005-12-01	2064000	\N	2005-12-01	53278	\N	\N	f	Sales which are qualified	0
53278_22500.0_2008-08-07	2250000	\N	2008-08-07	53278	\N	\N	f	Sales which are qualified	0
53278_27250.0_2005-12-01	2725000	\N	2005-12-01	53278	\N	\N	f	Sales which are qualified	0
53278_37750.0_2013-02-26	3775000	\N	2013-02-26	53278	\N	\N	f	Qual by exam of deed	0
53278_40000.0_2018-08-15	4000000	\N	2018-08-15	53278	\N	\N	f	Qual by exam of deed	0
53279_19600.0_2005-10-01	1960000	\N	2005-10-01	53279	\N	\N	f	Sales which are qualified	0
53279_22500.0_2010-04-05	2250000	\N	2010-04-05	53279	\N	\N	f	Qual by exam of deed	0
53280_22654.0_2005-10-01	2265400	\N	2005-10-01	53280	\N	\N	f	Sales which are qualified	0
53280_25000.0_2009-08-18	2500000	\N	2009-08-18	53280	\N	\N	f	Qual by exam of deed	0
53281_10000.0_2005-12-01	1000000	\N	2005-12-01	53281	\N	\N	f	Sales which are qualified	0
53281_20000.0_2009-06-12	2000000	\N	2009-06-12	53281	\N	\N	f	Qual by exam of deed	0
53281_30800.0_2021-03-11	3080000	\N	2021-03-11	53281	\N	\N	f	Qual by exam of deed	0
53281_9000.0_2005-12-01	900000	\N	2005-12-01	53281	\N	\N	f	Sales which are qualified	0
53282_12750.0_2021-02-18	1275000	\N	2021-02-18	53282	\N	\N	f	Qual by exam of deed	0
53282_5950.0_2010-09-23	595000	\N	2010-09-23	53282	\N	\N	f	Qual by exam of deed	0
53282_9900.0_2005-11-01	990000	\N	2005-11-01	53282	\N	\N	f	Sales which are qualified	0
53283_12750.0_2005-11-01	1275000	\N	2005-11-01	53283	\N	\N	f	Sales which are qualified	0
53283_16250.0_2016-01-05	1625000	\N	2016-01-05	53283	\N	\N	f	Qual by exam of deed	0
53283_8400.0_2009-12-22	840000	\N	2009-12-22	53283	\N	\N	f	Qual by exam of deed	0
53283_8830.0_2005-11-01	883000	\N	2005-11-01	53283	\N	\N	f	Sales which are qualified	0
53284_17000.0_2008-05-01	1700000	\N	2008-05-01	53284	\N	\N	f	Sales which are qualified	0
53284_18950.0_2005-11-01	1895000	\N	2005-11-01	53284	\N	\N	f	Sales which are qualified	0
53284_20750.0_2011-07-14	2075000	\N	2011-07-14	53284	\N	\N	f	Qual by exam of deed	0
53284_30000.0_2015-05-11	3000000	\N	2015-05-11	53284	\N	\N	f	Qual by exam of deed	0
53284_32000.0_2021-05-14	3200000	\N	2021-05-14	53284	\N	\N	f	Qual by exam of deed	0
53284_9250.0_2005-12-01	925000	\N	2005-12-01	53284	\N	\N	f	Sales which are qualified	0
53285_16950.0_2005-12-01	1695000	\N	2005-12-01	53285	\N	\N	f	Sales which are qualified	0
53285_22750.0_2008-07-01	2275000	\N	2008-07-01	53285	\N	\N	f	Sales which are qualified	0
53285_38000.0_2013-05-03	3800000	\N	2013-05-03	53285	\N	\N	f	Qual by exam of deed	0
53286_20400.0_2005-11-01	2040000	\N	2005-11-01	53286	\N	\N	f	Sales which are qualified	0
53286_28250.0_2012-02-06	2825000	\N	2012-02-06	53286	\N	\N	f	Qual by exam of deed	0
53286_43500.0_2014-05-13	4350000	\N	2014-05-13	53286	\N	\N	f	Qual by exam of deed	0
53287_20200.0_2005-10-01	2020000	\N	2005-10-01	53287	\N	\N	f	Sales which are qualified	0
53287_24500.0_2010-10-29	2450000	\N	2010-10-29	53287	\N	\N	f	Qual by exam of deed	0
53287_51500.0_2022-03-15	5150000	\N	2022-03-15	53287	\N	\N	f	Qual by exam of deed	0
53288_23077.0_2005-10-01	2307700	\N	2005-10-01	53288	\N	\N	f	Sales which are qualified	0
53288_25500.0_2010-06-23	2550000	\N	2010-06-23	53288	\N	\N	f	Qual by exam of deed	0
53289_13090.0_2005-11-01	1309000	\N	2005-11-01	53289	\N	\N	f	Sales which are qualified	0
53289_45000.0_2012-12-27	4500000	\N	2012-12-27	53289	\N	\N	t	Qual on DOS, multi-parcel sale	0
53289_58943.0_2022-02-15	5894300	\N	2022-02-15	53289	\N	\N	f	Qual by exam of deed	0
53290_12150.0_2011-08-01	1215000	\N	2011-08-01	53290	\N	\N	f	Qual by exam of deed	0
53291_12500.0_2005-12-01	1250000	\N	2005-12-01	53291	\N	\N	f	Sales which are qualified	0
53291_21000.0_2005-11-01	2100000	\N	2005-11-01	53291	\N	\N	f	Sales which are qualified	0
53291_23000.0_2007-04-01	2300000	\N	2007-04-01	53291	\N	\N	f	Sales which are qualified	0
53291_23000.0_2012-07-03	2300000	\N	2012-07-03	53291	\N	\N	f	Qual by exam of deed	0
53291_30000.0_2021-04-12	3000000	\N	2021-04-12	53291	\N	\N	f	Qual by exam of deed	0
53291_38000.0_2022-01-31	3800000	\N	2022-01-31	53291	\N	\N	f	Qual by exam of deed	0
53292_17050.0_2005-11-01	1705000	\N	2005-11-01	53292	\N	\N	f	Sales which are qualified	0
53292_24000.0_2008-06-01	2400000	\N	2008-06-01	53292	\N	\N	f	Sales which are qualified	0
53293_22200.0_2005-11-01	2220000	\N	2005-11-01	53293	\N	\N	f	Sales which are qualified	0
53294_21250.0_2005-11-01	2125000	\N	2005-11-01	53294	\N	\N	f	Sales which are qualified	0
53295_23500.0_2005-10-01	2350000	\N	2005-10-01	53295	\N	\N	f	Sales which are qualified	0
53295_26500.0_2010-06-30	2650000	\N	2010-06-30	53295	\N	\N	f	Qual by exam of deed	0
53296_13700.0_2005-12-01	1370000	\N	2005-12-01	53296	\N	\N	f	Sales which are qualified	0
53296_22500.0_2007-05-01	2250000	\N	2007-05-01	53296	\N	\N	f	Sales which are qualified	0
53297_12150.0_2013-06-28	1215000	\N	2013-06-28	53297	\N	\N	f	Qual by exam of deed	0
53297_8800.0_2005-12-01	880000	\N	2005-12-01	53297	\N	\N	f	Sales which are qualified	0
53298_17750.0_2012-08-31	1775000	\N	2012-08-31	53298	\N	\N	f	Qual by exam of deed	0
53298_34000.0_2006-01-01	3400000	\N	2006-01-01	53298	\N	\N	t	Deeds that include more than one parcel	0
53298_50000.0_2014-09-08	5000000	\N	2014-09-08	53298	\N	\N	f	Qual by exam of deed	0
53299_18750.0_2005-12-01	1875000	\N	2005-12-01	53299	\N	\N	f	Sales which are qualified	0
53299_20000.0_2008-04-01	2000000	\N	2008-04-01	53299	\N	\N	f	Sales which are qualified	0
53299_25000.0_2010-12-20	2500000	\N	2010-12-20	53299	\N	\N	f	Qual by exam of deed	0
53300_21000.0_2010-03-30	2100000	\N	2010-03-30	53300	\N	\N	f	Qual by exam of deed	0
53300_27500.0_2005-12-01	2750000	\N	2005-12-01	53300	\N	\N	f	Sales which are qualified	0
53300_28855.0_2006-02-01	2885500	\N	2006-02-01	53300	\N	\N	f	Sales which are qualified	0
53301_22000.0_2005-12-01	2200000	\N	2005-12-01	53301	\N	\N	f	Sales which are qualified	0
53301_23500.0_2010-06-01	2350000	\N	2010-06-01	53301	\N	\N	f	Qual by exam of deed	0
53301_55500.0_2022-01-21	5550000	\N	2022-01-21	53301	\N	\N	f	Qual by exam of deed	0
53302_25500.0_2006-01-01	2550000	\N	2006-01-01	53302	\N	\N	f	Sales which are qualified	0
53302_28000.0_2011-12-27	2800000	\N	2011-12-27	53302	\N	\N	f	Qual by exam of deed	0
53303_13760.0_2005-12-01	1376000	\N	2005-12-01	53303	\N	\N	f	Sales which are qualified	0
53303_33500.0_2013-09-09	3350000	\N	2013-09-09	53303	\N	\N	f	Qual by exam of deed	0
53303_37000.0_2021-03-26	3700000	\N	2021-03-26	53303	\N	\N	f	Qual by exam of deed	0
53304_7950.0_2005-12-01	795000	\N	2005-12-01	53304	\N	\N	f	Sales which are qualified	0
53304_8700.0_2012-06-16	870000	\N	2012-06-16	53304	\N	\N	f	Qual by exam of deed	0
53305_15000.0_2005-12-01	1500000	\N	2005-12-01	53305	\N	\N	f	Sales which are qualified	0
53305_18000.0_2016-04-15	1800000	\N	2016-04-15	53305	\N	\N	f	Qual by exam of deed	0
53305_24400.0_2023-01-10	2440000	\N	2023-01-10	53305	\N	\N	f	Qual by exam of deed	0
53305_9960.0_2005-12-01	996000	\N	2005-12-01	53305	\N	\N	f	Sales which are qualified	0
53306_21500.0_2005-12-01	2150000	\N	2005-12-01	53306	\N	\N	f	Sales which are qualified	0
53306_26000.0_2018-01-05	2600000	\N	2018-01-05	53306	\N	\N	f	Qual by exam of deed	0
53307_18950.0_2005-12-01	1895000	\N	2005-12-01	53307	\N	\N	f	Sales which are qualified	0
53307_23525.0_2005-12-01	2352500	\N	2005-12-01	53307	\N	\N	f	Sales which are qualified	0
53308_24000.0_2009-12-15	2400000	\N	2009-12-15	53308	\N	\N	f	Qual by exam of deed	0
53308_26000.0_2005-12-01	2600000	\N	2005-12-01	53308	\N	\N	f	Sales which are qualified	0
53308_38000.0_2012-06-15	3800000	\N	2012-06-15	53308	\N	\N	f	Qual by exam of deed	0
53309_22500.0_2010-03-26	2250000	\N	2010-03-26	53309	\N	\N	f	Qual by exam of deed	0
53309_22790.0_2005-12-01	2279000	\N	2005-12-01	53309	\N	\N	f	Sales which are qualified	0
53309_45500.0_2014-01-24	4550000	\N	2014-01-24	53309	\N	\N	f	Qual by exam of deed	0
53310_26790.0_2005-12-01	2679000	\N	2005-12-01	53310	\N	\N	f	Sales which are qualified	0
53310_32250.0_2012-08-27	3225000	\N	2012-08-27	53310	\N	\N	f	Qual by exam of deed	0
53310_52000.0_2019-01-16	5200000	\N	2019-01-16	53310	\N	\N	f	Qual by exam of deed	0
53311_1.0_2023-06-08	100	\N	2023-06-08	53311	\N	\N	t	Qual by exam of deed	0
53311_20000.0_2010-11-26	2000000	\N	2010-11-26	53311	\N	\N	f	Qual by exam of deed	0
53311_24000.0_2005-12-01	2400000	\N	2005-12-01	53311	\N	\N	f	Sales which are qualified	0
53311_9900.0_2005-12-01	990000	\N	2005-12-01	53311	\N	\N	f	Sales which are qualified	0
53312_11750.0_2005-12-01	1175000	\N	2005-12-01	53312	\N	\N	f	Sales which are qualified	0
53312_12900.0_2013-06-11	1290000	\N	2013-06-11	53312	\N	\N	f	Qual by exam of deed	0
53313_12500.0_2005-12-01	1250000	\N	2005-12-01	53313	\N	\N	f	Sales which are qualified	0
53314_16500.0_2006-05-01	1650000	\N	2006-05-01	53314	\N	\N	f	Sales which are qualified	0
53314_21750.0_2007-06-01	2175000	\N	2007-06-01	53314	\N	\N	f	Sales which are qualified	0
53314_32000.0_2015-08-17	3200000	\N	2015-08-17	53314	\N	\N	f	Qual by exam of deed	0
53314_46500.0_2023-03-22	4650000	\N	2023-03-22	53314	\N	\N	f	Qual by exam of deed	0
53315_20500.0_2005-12-01	2050000	\N	2005-12-01	53315	\N	\N	f	Sales which are qualified	0
53315_40000.0_2021-08-10	4000000	\N	2021-08-10	53315	\N	\N	f	Qual by exam of deed	0
53316_32250.0_2005-12-01	3225000	\N	2005-12-01	53316	\N	\N	f	Sales which are qualified	0
53317_24500.0_2005-12-01	2450000	\N	2005-12-01	53317	\N	\N	f	Sales which are qualified	0
53318_35000.0_2005-12-01	3500000	\N	2005-12-01	53318	\N	\N	f	Sales which are qualified	0
53319_26500.0_2007-01-01	2650000	\N	2007-01-01	53319	\N	\N	f	Sales which are qualified	0
53319_34500.0_2013-07-26	3450000	\N	2013-07-26	53319	\N	\N	f	Qual by exam of deed	0
53319_46000.0_2023-06-29	4600000	\N	2023-06-29	53319	\N	\N	f	Qual by exam of deed	0
53319_9900.0_2005-12-01	990000	\N	2005-12-01	53319	\N	\N	f	Sales which are qualified	0
53320_13000.0_2005-12-01	1300000	\N	2005-12-01	53320	\N	\N	f	Sales which are qualified	0
53320_8065.0_2011-06-06	806500	\N	2011-06-06	53320	\N	\N	f	Qual by exam of deed	0
53321_35500.0_2005-12-01	3550000	\N	2005-12-01	53321	\N	\N	t	Deeds that include more than one parcel	0
53321_47500.0_2021-02-18	4750000	\N	2021-02-18	53321	\N	\N	t	Qual on DOS, multi-parcel sale	0
53321_64875.0_2014-11-14	6487500	\N	2014-11-14	53321	\N	\N	t	Qual on DOS, multi-parcel sale	0
53322_35500.0_2005-12-01	3550000	\N	2005-12-01	53322	\N	\N	t	Deeds that include more than one parcel	0
53322_47500.0_2021-02-18	4750000	\N	2021-02-18	53322	\N	\N	t	Qual on DOS, multi-parcel sale	0
53322_64875.0_2014-11-14	6487500	\N	2014-11-14	53322	\N	\N	t	Qual on DOS, multi-parcel sale	0
53323_25500.0_2006-08-01	2550000	\N	2006-08-01	53323	\N	\N	f	Sales which are qualified	0
53323_64000.0_2023-06-20	6400000	\N	2023-06-20	53323	\N	\N	f	Qual by exam of deed	0
53324_22000.0_2006-08-01	2200000	\N	2006-08-01	53324	\N	\N	f	Sales which are qualified	0
53324_31000.0_2010-12-07	3100000	\N	2010-12-07	53324	\N	\N	f	Qual by exam of deed	0
53325_31430.0_2011-07-20	3143000	\N	2011-07-20	53325	\N	\N	f	Qual by exam of deed	0
53325_34500.0_2005-12-01	3450000	\N	2005-12-01	53325	\N	\N	f	Sales which are qualified	0
53325_37500.0_2018-05-29	3750000	\N	2018-05-29	53325	\N	\N	f	Qual by exam of deed	0
53325_42500.0_2006-05-01	4250000	\N	2006-05-01	53325	\N	\N	f	Sales which are qualified	0
53326_25500.0_2006-08-01	2550000	\N	2006-08-01	53326	\N	\N	f	Sales which are qualified	0
53326_35000.0_2008-05-01	3500000	\N	2008-05-01	53326	\N	\N	f	Sales which are qualified	0
53327_36000.0_2005-01-01	3600000	\N	2005-01-01	53327	\N	\N	t	Deeds that include more than one parcel	0
53328_25080.0_2021-02-12	2508000	\N	2021-02-12	53328	\N	\N	f	Qual on DOS, but significant phy change since time of transfer	0
53328_68000.0_2005-01-01	6800000	\N	2005-01-01	53328	\N	\N	t	Deeds that include more than one parcel	0
53329_35957.5_2005-10-01	3595750	\N	2005-10-01	53329	\N	\N	f	Sales which are qualified	0
53329_60000.0_2021-08-10	6000000	\N	2021-08-10	53329	\N	\N	f	Qual by exam of deed	0
53330_24500.0_2006-08-01	2450000	\N	2006-08-01	53330	\N	\N	f	Sales which are qualified	0
53330_34000.0_2008-05-01	3400000	\N	2008-05-01	53330	\N	\N	f	Sales which are qualified	0
53330_79500.0_2023-08-18	7950000	\N	2023-08-18	53330	\N	\N	f	Qual by exam of deed	0
53331_100000.0_2022-04-19	10000000	\N	2022-04-19	53331	\N	\N	f	Qual by exam of deed	0
53331_35850.0_2005-12-01	3585000	\N	2005-12-01	53331	\N	\N	f	Sales which are qualified	0
53331_42600.0_2010-12-28	4260000	\N	2010-12-28	53331	\N	\N	f	Qual by exam of deed	0
53331_60000.0_2014-06-05	6000000	\N	2014-06-05	53331	\N	\N	f	Qual by exam of deed	0
53332_10000.0_2005-12-01	1000000	\N	2005-12-01	53332	\N	\N	f	Sales which are qualified	0
53333_7500.0_2005-01-01	750000	\N	2005-01-01	53333	\N	\N	f	Sales which are qualified	0
53334_49143.88_2006-05-01	4914388	\N	2006-05-01	53334	\N	\N	f	Sales which are qualified	0
53335_49000.0_2006-03-01	4900000	\N	2006-03-01	53335	\N	\N	f	Sales which are qualified	0
53335_57000.0_2011-07-20	5700000	\N	2011-07-20	53335	\N	\N	f	Qual by exam of deed	0
53336_47000.0_2006-08-01	4700000	\N	2006-08-01	53336	\N	\N	f	Sales which are qualified	0
53337_56000.0_2006-03-01	5600000	\N	2006-03-01	53337	\N	\N	f	Sales which are qualified	0
53337_67000.0_2008-03-01	6700000	\N	2008-03-01	53337	\N	\N	f	Sales which are qualified	0
53339_55000.0_2008-06-01	5500000	\N	2008-06-01	53339	\N	\N	f	Sales which are qualified	0
53339_62000.0_2006-03-01	6200000	\N	2006-03-01	53339	\N	\N	f	Sales which are qualified	0
53339_75000.0_2015-11-06	7500000	\N	2015-11-06	53339	\N	\N	f	Qual by exam of deed	0
53340_17000.0_2023-03-28	1700000	\N	2023-03-28	53340	\N	\N	f	Qual by exam of deed	0
53340_6150.0_2005-11-01	615000	\N	2005-11-01	53340	\N	\N	f	Sales which are qualified	0
53341_10000.0_2009-05-15	1000000	\N	2009-05-15	53341	\N	\N	f	Qual by exam of deed	0
53341_10750.0_2005-11-01	1075000	\N	2005-11-01	53341	\N	\N	f	Sales which are qualified	0
53341_12700.0_2011-11-30	1270000	\N	2011-11-30	53341	\N	\N	f	Qual by exam of deed	0
53341_16750.0_2005-11-01	1675000	\N	2005-11-01	53341	\N	\N	f	Sales which are qualified	0
53342_13800.0_2009-05-15	1380000	\N	2009-05-15	53342	\N	\N	f	Qual by exam of deed	0
53342_16500.0_2005-11-01	1650000	\N	2005-11-01	53342	\N	\N	f	Sales which are qualified	0
53343_18900.0_2005-10-17	1890000	\N	2005-10-17	53343	\N	\N	f	Sales which are qualified	0
53343_26000.0_2014-10-10	2600000	\N	2014-10-10	53343	\N	\N	f	Qual by exam of deed	0
53344_15500.0_2008-10-06	1550000	\N	2008-10-06	53344	\N	\N	f	Sales which are qualified	0
53344_17600.0_2005-11-01	1760000	\N	2005-11-01	53344	\N	\N	f	Sales which are qualified	0
53344_25000.0_2015-12-21	2500000	\N	2015-12-21	53344	\N	\N	f	Qual by exam of deed	0
53345_12000.0_2012-04-24	1200000	\N	2012-04-24	53345	\N	\N	f	Qual by exam of deed	0
53345_19500.0_2005-12-01	1950000	\N	2005-12-01	53345	\N	\N	f	Sales which are qualified	0
53345_19900.0_2007-03-01	1990000	\N	2007-03-01	53345	\N	\N	f	Sales which are qualified	0
53345_29500.0_2019-02-13	2950000	\N	2019-02-13	53345	\N	\N	f	Qual by exam of deed	0
53346_13000.0_2005-11-01	1300000	\N	2005-11-01	53346	\N	\N	f	Sales which are qualified	0
53346_16700.0_2012-01-25	1670000	\N	2012-01-25	53346	\N	\N	f	Qual by exam of deed	0
53346_25000.0_2006-12-01	2500000	\N	2006-12-01	53346	\N	\N	f	Sales which are qualified	0
53347_5900.0_2005-12-01	590000	\N	2005-12-01	53347	\N	\N	f	Sales which are qualified	0
53347_6350.0_2005-11-01	635000	\N	2005-11-01	53347	\N	\N	f	Sales which are qualified	0
53347_7450.0_2012-09-21	745000	\N	2012-09-21	53347	\N	\N	f	Qual by exam of deed	0
53348_17000.0_2021-12-02	1700000	\N	2021-12-02	53348	\N	\N	f	Qual by exam of deed	0
53348_6370.0_2005-11-01	637000	\N	2005-11-01	53348	\N	\N	f	Sales which are qualified	0
53348_6500.0_2008-05-01	650000	\N	2008-05-01	53348	\N	\N	f	Sales which are qualified	0
53348_8400.0_2011-10-17	840000	\N	2011-10-17	53348	\N	\N	f	Qual by exam of deed	0
53349_10500.0_2005-11-01	1050000	\N	2005-11-01	53349	\N	\N	f	Sales which are qualified	0
53349_13500.0_2005-11-01	1350000	\N	2005-11-01	53349	\N	\N	f	Sales which are qualified	0
53349_18000.0_2005-11-01	1800000	\N	2005-11-01	53349	\N	\N	f	Sales which are qualified	0
53349_31000.0_2023-06-16	3100000	\N	2023-06-16	53349	\N	\N	f	Qual by exam of deed	0
53350_13127.39_2006-03-01	1312739	\N	2006-03-01	53350	\N	\N	f	Sales which are qualified	0
53351_19400.0_2005-11-01	1940000	\N	2005-11-01	53351	\N	\N	f	Sales which are qualified	0
53351_22000.0_2007-04-01	2200000	\N	2007-04-01	53351	\N	\N	f	Sales which are qualified	0
53351_23750.0_2011-06-01	2375000	\N	2011-06-01	53351	\N	\N	f	Qual by exam of deed	0
53351_31750.0_2014-04-28	3175000	\N	2014-04-28	53351	\N	\N	f	Qual by exam of deed	0
53351_50500.0_2022-04-28	5050000	\N	2022-04-28	53351	\N	\N	f	Qual by exam of deed	0
53352_17300.0_2005-11-01	1730000	\N	2005-11-01	53352	\N	\N	f	Sales which are qualified	0
53352_18000.0_2011-02-07	1800000	\N	2011-02-07	53352	\N	\N	f	Qual by exam of deed	0
53353_20000.0_2005-11-01	2000000	\N	2005-11-01	53353	\N	\N	f	Sales which are qualified	0
53353_26500.0_2012-07-02	2650000	\N	2012-07-02	53353	\N	\N	f	Qual by exam of deed	0
53354_13250.0_2005-11-01	1325000	\N	2005-11-01	53354	\N	\N	f	Sales which are qualified	0
53354_16000.0_2012-11-01	1600000	\N	2012-11-01	53354	\N	\N	f	Qual by exam of deed	0
53354_17000.0_2005-11-01	1700000	\N	2005-11-01	53354	\N	\N	f	Sales which are qualified	0
53355_13000.0_2006-07-01	1300000	\N	2006-07-01	53355	\N	\N	f	Sales which are qualified	0
53355_7400.0_2005-11-01	740000	\N	2005-11-01	53355	\N	\N	f	Sales which are qualified	0
53355_9750.0_2005-11-01	975000	\N	2005-11-01	53355	\N	\N	f	Sales which are qualified	0
53356_11150.0_2013-06-27	1115000	\N	2013-06-27	53356	\N	\N	f	Qual by exam of deed	0
53356_6450.0_2005-11-01	645000	\N	2005-11-01	53356	\N	\N	f	Sales which are qualified	0
53356_9750.0_2012-10-25	975000	\N	2012-10-25	53356	\N	\N	f	Qual by exam of deed	0
53357_10250.0_2005-11-01	1025000	\N	2005-11-01	53357	\N	\N	f	Sales which are qualified	0
53357_12000.0_2009-02-24	1200000	\N	2009-02-24	53357	\N	\N	f	Qual by exam of deed	0
53357_14000.0_2011-02-11	1400000	\N	2011-02-11	53357	\N	\N	f	Qual by exam of deed	0
53357_22000.0_2013-02-28	2200000	\N	2013-02-28	53357	\N	\N	f	Qual by exam of deed	0
53358_17500.0_2005-11-01	1750000	\N	2005-11-01	53358	\N	\N	f	Sales which are qualified	0
53358_19500.0_2008-01-01	1950000	\N	2008-01-01	53358	\N	\N	f	Sales which are qualified	0
53358_35000.0_2017-10-19	3500000	\N	2017-10-19	53358	\N	\N	f	Qual by exam of deed	0
53359_19950.0_2005-10-01	1995000	\N	2005-10-01	53359	\N	\N	f	Sales which are qualified	0
53360_17950.0_2005-11-01	1795000	\N	2005-11-01	53360	\N	\N	f	Sales which are qualified	0
53361_19960.0_2006-01-01	1996000	\N	2006-01-01	53361	\N	\N	f	Sales which are qualified	0
53361_23500.0_2011-03-29	2350000	\N	2011-03-29	53361	\N	\N	f	Qual by exam of deed	0
53361_27000.0_2012-01-26	2700000	\N	2012-01-26	53361	\N	\N	f	Qual by exam of deed	0
53362_13500.0_2005-11-01	1350000	\N	2005-11-01	53362	\N	\N	f	Sales which are qualified	0
53362_20000.0_2006-11-01	2000000	\N	2006-11-01	53362	\N	\N	f	Sales which are qualified	0
53362_20290.0_2010-05-06	2029000	\N	2010-05-06	53362	\N	\N	f	Qual by exam of deed	0
53362_30090.0_2021-04-15	3009000	\N	2021-04-15	53362	\N	\N	f	Qual by exam of deed	0
53362_45500.0_2022-02-22	4550000	\N	2022-02-22	53362	\N	\N	f	Qual by exam of deed	0
53363_7000.0_2008-05-01	700000	\N	2008-05-01	53363	\N	\N	f	Sales which are qualified	0
53363_7600.0_2005-11-01	760000	\N	2005-11-01	53363	\N	\N	f	Sales which are qualified	0
53364_14500.0_2005-11-01	1450000	\N	2005-11-01	53364	\N	\N	f	Sales which are qualified	0
53364_15500.0_2016-03-03	1550000	\N	2016-03-03	53364	\N	\N	f	Qual by exam of deed	0
53365_16500.0_2008-09-24	1650000	\N	2008-09-24	53365	\N	\N	f	Sales which are qualified	0
53365_20000.0_2006-03-01	2000000	\N	2006-03-01	53365	\N	\N	f	Sales which are qualified	0
53365_8900.0_2005-11-01	890000	\N	2005-11-01	53365	\N	\N	f	Sales which are qualified	0
53366_17000.0_2005-11-01	1700000	\N	2005-11-01	53366	\N	\N	f	Sales which are qualified	0
53366_31000.0_2014-10-01	3100000	\N	2014-10-01	53366	\N	\N	f	Qual by exam of deed	0
53366_43000.0_2015-03-04	4300000	\N	2015-03-04	53366	\N	\N	f	Qual by exam of deed	0
53367_18000.0_2005-10-01	1800000	\N	2005-10-01	53367	\N	\N	f	Sales which are qualified	0
53368_18950.0_2005-12-01	1895000	\N	2005-12-01	53368	\N	\N	f	Sales which are qualified	0
53369_22000.0_2005-11-01	2200000	\N	2005-11-01	53369	\N	\N	f	Sales which are qualified	0
53369_31000.0_2011-10-13	3100000	\N	2011-10-13	53369	\N	\N	f	Qual by exam of deed	0
53370_22000.0_2005-10-01	2200000	\N	2005-10-01	53370	\N	\N	f	Sales which are qualified	0
53370_24750.0_2006-02-01	2475000	\N	2006-02-01	53370	\N	\N	f	Sales which are qualified	0
53370_40000.0_2014-05-06	4000000	\N	2014-05-06	53370	\N	\N	f	Qual by exam of deed	0
53371_11500.0_2015-04-19	1150000	\N	2015-04-19	53371	\N	\N	f	Qual by exam of deed	0
53371_5900.0_2005-11-01	590000	\N	2005-11-01	53371	\N	\N	f	Sales which are qualified	0
53371_7000.0_2008-06-01	700000	\N	2008-06-01	53371	\N	\N	f	Sales which are qualified	0
53399_5750.0_2010-07-29	575000	\N	2010-07-29	53399	\N	\N	f	Qual by exam of deed	0
53399_6250.0_2011-06-09	625000	\N	2011-06-09	53399	\N	\N	f	Qual by exam of deed	0
53400_5100.0_2009-06-19	510000	\N	2009-06-19	53400	\N	\N	f	Qual by exam of deed	0
53404_3200.0_2011-01-10	320000	\N	2011-01-10	53404	\N	\N	f	Qual by exam of deed	0
53404_4575.0_2015-07-09	457500	\N	2015-07-09	53404	\N	\N	f	Qual by exam of deed	0
53404_5250.0_2022-05-02	525000	\N	2022-05-02	53404	\N	\N	f	Qual by exam of deed	0
53405_3950.0_2012-09-11	395000	\N	2012-09-11	53405	\N	\N	f	Qual by exam of deed	0
53405_4300.0_2015-01-09	430000	\N	2015-01-09	53405	\N	\N	f	Qual by exam of deed	0
53405_5300.0_2022-07-05	530000	\N	2022-07-05	53405	\N	\N	f	Qual by exam of deed	0
53406_4200.0_2009-12-04	420000	\N	2009-12-04	53406	\N	\N	f	Qual by exam of deed	0
53406_4250.0_2011-05-19	425000	\N	2011-05-19	53406	\N	\N	f	Qual by exam of deed	0
53406_6550.0_2012-11-20	655000	\N	2012-11-20	53406	\N	\N	f	Qual by exam of deed	0
53406_8350.0_2014-06-25	835000	\N	2014-06-25	53406	\N	\N	f	Qual by exam of deed	0
53406_8700.0_2022-03-11	870000	\N	2022-03-11	53406	\N	\N	f	Qual by exam of deed	0
53407_3380.0_2011-05-31	338000	\N	2011-05-31	53407	\N	\N	f	Qual by exam of deed	0
53407_5800.0_2013-06-13	580000	\N	2013-06-13	53407	\N	\N	f	Qual by exam of deed	0
53408_3850.0_2009-08-28	385000	\N	2009-08-28	53408	\N	\N	f	Qual by exam of deed	0
53408_6500.0_2012-08-30	650000	\N	2012-08-30	53408	\N	\N	f	Qual by exam of deed	0
53408_6950.0_2022-03-03	695000	\N	2022-03-03	53408	\N	\N	f	Qual by exam of deed	0
53409_4000.0_2010-06-24	400000	\N	2010-06-24	53409	\N	\N	f	Qual by exam of deed	0
53410_3500.0_2010-05-07	350000	\N	2010-05-07	53410	\N	\N	f	Qual by exam of deed	0
53410_3850.0_2019-10-30	385000	\N	2019-10-30	53410	\N	\N	f	Qual by exam of deed	0
53410_6500.0_2022-06-30	650000	\N	2022-06-30	53410	\N	\N	f	Qual by exam of deed	0
53413_6350.0_2009-11-27	635000	\N	2009-11-27	53413	\N	\N	f	Qual by exam of deed	0
53414_6220.0_2011-05-19	622000	\N	2011-05-19	53414	\N	\N	f	Qual by exam of deed	0
53415_5250.0_2010-10-13	525000	\N	2010-10-13	53415	\N	\N	f	Qual by exam of deed	0
53416_3550.0_2011-01-05	355000	\N	2011-01-05	53416	\N	\N	f	Qual by exam of deed	0
53416_4700.0_2021-05-27	470000	\N	2021-05-27	53416	\N	\N	f	Qual by exam of deed	0
53416_7300.0_2022-03-14	730000	\N	2022-03-14	53416	\N	\N	f	Qual by exam of deed	0
53417_11500.0_2016-06-14	1150000	\N	2016-06-14	53417	\N	\N	f	Qual by exam of deed	0
53417_12000.0_2022-02-15	1200000	\N	2022-02-15	53417	\N	\N	f	Qual by exam of deed	0
53417_15500.0_2022-09-09	1550000	\N	2022-09-09	53417	\N	\N	f	Qual by exam of deed	0
53417_6500.0_2008-11-11	650000	\N	2008-11-11	53417	\N	\N	f	Sales which are qualified	0
53417_8500.0_2014-09-19	850000	\N	2014-09-19	53417	\N	\N	f	Qual by exam of deed	0
53418_5175.0_2011-08-22	517500	\N	2011-08-22	53418	\N	\N	f	Qual by exam of deed	0
53420_3050.0_2011-06-20	305000	\N	2011-06-20	53420	\N	\N	f	Qual by exam of deed	0
53420_3700.0_2018-01-11	370000	\N	2018-01-11	53420	\N	\N	f	Qual by exam of deed	0
53421_4500.0_2008-11-21	450000	\N	2008-11-21	53421	\N	\N	f	Sales which are qualified	0
53422_4750.0_2008-11-19	475000	\N	2008-11-19	53422	\N	\N	f	Sales which are qualified	0
53423_3650.0_2008-12-24	365000	\N	2008-12-24	53423	\N	\N	f	Sales which are qualified	0
53424_4950.0_2008-11-05	495000	\N	2008-11-05	53424	\N	\N	f	Sales which are qualified	0
53425_3750.0_2021-02-22	375000	\N	2021-02-22	53425	\N	\N	f	Qual by exam of deed	0
53425_6000.0_2022-04-05	600000	\N	2022-04-05	53425	\N	\N	f	Qual by exam of deed	0
53426_3500.0_2010-12-30	350000	\N	2010-12-30	53426	\N	\N	f	Qual by exam of deed	0
53427_12100.0_2014-01-03	1210000	\N	2014-01-03	53427	\N	\N	f	Qual by exam of deed	0
53427_13000.0_2021-06-21	1300000	\N	2021-06-21	53427	\N	\N	f	Qual by exam of deed	0
53427_7200.0_2009-07-13	720000	\N	2009-07-13	53427	\N	\N	f	Qual by exam of deed	0
53428_12750.0_2012-12-03	1275000	\N	2012-12-03	53428	\N	\N	f	Qual by exam of deed	0
53428_16500.0_2023-07-06	1650000	\N	2023-07-06	53428	\N	\N	f	Qual by exam of deed	0
53428_7950.0_2009-07-08	795000	\N	2009-07-08	53428	\N	\N	f	Qual by exam of deed	0
53429_6400.0_2009-03-16	640000	\N	2009-03-16	53429	\N	\N	f	Qual by exam of deed	0
53430_11250.0_2013-06-24	1125000	\N	2013-06-24	53430	\N	\N	f	Qual by exam of deed	0
53430_6600.0_2011-02-24	660000	\N	2011-02-24	53430	\N	\N	f	Qual by exam of deed	0
53430_7950.0_2012-08-07	795000	\N	2012-08-07	53430	\N	\N	f	Qual by exam of deed	0
53431_10140.0_2016-10-03	1014000	\N	2016-10-03	53431	\N	\N	f	Qual by exam of deed	0
53431_5350.0_2009-09-15	535000	\N	2009-09-15	53431	\N	\N	f	Qual by exam of deed	0
53432_3375.0_2010-08-31	337500	\N	2010-08-31	53432	\N	\N	f	Qual by exam of deed	0
53432_6050.0_2016-10-19	605000	\N	2016-10-19	53432	\N	\N	f	Qual by exam of deed	0
53433_11000.0_2014-11-17	1100000	\N	2014-11-17	53433	\N	\N	f	Qual by exam of deed	0
53433_12950.0_2022-04-18	1295000	\N	2022-04-18	53433	\N	\N	f	Qual by exam of deed	0
53433_5350.0_2011-03-18	535000	\N	2011-03-18	53433	\N	\N	f	Qual by exam of deed	0
53434_5100.0_2010-12-01	510000	\N	2010-12-01	53434	\N	\N	f	Qual by exam of deed	0
53434_6500.0_2021-04-08	650000	\N	2021-04-08	53434	\N	\N	f	Qual by exam of deed	0
53435_5600.0_2010-12-23	560000	\N	2010-12-23	53435	\N	\N	f	Qual by exam of deed	0
53435_7650.0_2022-02-07	765000	\N	2022-02-07	53435	\N	\N	f	Qual by exam of deed	0
53436_3600.0_2011-05-06	360000	\N	2011-05-06	53436	\N	\N	f	Qual by exam of deed	0
53436_5873.0_2015-02-18	587300	\N	2015-02-18	53436	\N	\N	f	Qual by exam of deed	0
53437_3195.0_2011-05-16	319500	\N	2011-05-16	53437	\N	\N	f	Qual by exam of deed	0
53437_3300.0_2019-06-13	330000	\N	2019-06-13	53437	\N	\N	f	Qual by exam of deed	0
53437_5400.0_2022-09-29	540000	\N	2022-09-29	53437	\N	\N	f	Qual by exam of deed	0
53439_3100.0_2010-07-09	310000	\N	2010-07-09	53439	\N	\N	f	Qual by exam of deed	0
53439_4000.0_2012-06-07	400000	\N	2012-06-07	53439	\N	\N	f	Qual by exam of deed	0
53439_4300.0_2021-07-07	430000	\N	2021-07-07	53439	\N	\N	f	Qual by exam of deed	0
53440_4990.0_2021-10-01	499000	\N	2021-10-01	53440	\N	\N	f	Qual by exam of deed	0
53440_6650.0_2014-09-26	665000	\N	2014-09-26	53440	\N	\N	f	Qual by exam of deed	0
53440_6950.0_2022-05-24	695000	\N	2022-05-24	53440	\N	\N	f	Qual by exam of deed	0
53441_2500.0_2009-09-25	250000	\N	2009-09-25	53441	\N	\N	f	Qual by exam of deed	0
53441_3000.0_2012-04-07	300000	\N	2012-04-07	53441	\N	\N	f	Qual by exam of deed	0
53442_3000.0_2009-11-16	300000	\N	2009-11-16	53442	\N	\N	f	Qual by exam of deed	0
53443_6250.0_2012-05-02	625000	\N	2012-05-02	53443	\N	\N	f	Qual by exam of deed	0
53444_12500.0_2021-06-17	1250000	\N	2021-06-17	53444	\N	\N	f	Qual by exam of deed	0
53445_3750.0_2010-12-20	375000	\N	2010-12-20	53445	\N	\N	f	Qual by exam of deed	0
53445_3753.2_2010-02-19	375320	\N	2010-02-19	53445	\N	\N	f	Qual by exam of deed	0
53445_4750.0_2012-05-01	475000	\N	2012-05-01	53445	\N	\N	f	Qual by exam of deed	0
53447_3500.0_2011-02-25	350000	\N	2011-02-25	53447	\N	\N	f	Qual by exam of deed	0
53447_4000.0_2022-01-07	400000	\N	2022-01-07	53447	\N	\N	f	Qual by exam of deed	0
53448_2770.0_2020-07-09	277000	\N	2020-07-09	53448	\N	\N	f	Qual by exam of deed	0
53448_3240.0_2012-07-25	324000	\N	2012-07-25	53448	\N	\N	f	Qual by exam of deed	0
53448_4500.0_2013-12-12	450000	\N	2013-12-12	53448	\N	\N	f	Qual by exam of deed	0
53449_3150.0_2012-06-14	315000	\N	2012-06-14	53449	\N	\N	f	Qual by exam of deed	0
53450_3051.0_2012-07-09	305100	\N	2012-07-09	53450	\N	\N	f	Qual by exam of deed	0
53451_3000.0_2009-10-30	300000	\N	2009-10-30	53451	\N	\N	f	Qual by exam of deed	0
53451_3500.0_2011-02-28	350000	\N	2011-02-28	53451	\N	\N	f	Qual by exam of deed	0
53451_5200.0_2012-10-18	520000	\N	2012-10-18	53451	\N	\N	f	Qual by exam of deed	0
53451_6750.0_2014-02-28	675000	\N	2014-02-28	53451	\N	\N	f	Qual by exam of deed	0
53452_2950.0_2012-04-30	295000	\N	2012-04-30	53452	\N	\N	f	Qual by exam of deed	0
53453_5200.0_2008-11-04	520000	\N	2008-11-04	53453	\N	\N	f	Sales which are qualified	0
53454_6900.0_2012-01-27	690000	\N	2012-01-27	53454	\N	\N	f	Qual by exam of deed	0
53455_9500.0_2011-08-16	950000	\N	2011-08-16	53455	\N	\N	f	Qual by exam of deed	0
53456_3660.0_2010-01-05	366000	\N	2010-01-05	53456	\N	\N	f	Qual by exam of deed	0
53458_3400.0_2011-05-10	340000	\N	2011-05-10	53458	\N	\N	f	Qual by exam of deed	0
53458_5697.0_2022-02-18	569700	\N	2022-02-18	53458	\N	\N	f	Qual by exam of deed	0
53459_3200.0_2010-07-23	320000	\N	2010-07-23	53459	\N	\N	f	Qual by exam of deed	0
53459_5560.0_2014-01-29	556000	\N	2014-01-29	53459	\N	\N	f	Qual by exam of deed	0
53459_6250.0_2015-06-15	625000	\N	2015-06-15	53459	\N	\N	f	Qual by exam of deed	0
53459_6250.0_2022-03-21	625000	\N	2022-03-21	53459	\N	\N	f	Qual by exam of deed	0
53460_1620.0_2012-10-01	162000	\N	2012-10-01	53460	\N	\N	f	Qual by exam of deed	0
53460_3240.0_2012-03-30	324000	\N	2012-03-30	53460	\N	\N	f	Qual by exam of deed	0
53461_3150.0_2012-05-15	315000	\N	2012-05-15	53461	\N	\N	f	Qual by exam of deed	0
53462_2960.0_2011-10-06	296000	\N	2011-10-06	53462	\N	\N	f	Qual by exam of deed	0
53462_3370.0_2012-08-08	337000	\N	2012-08-08	53462	\N	\N	f	Qual by exam of deed	0
53462_3600.0_2021-06-20	360000	\N	2021-06-20	53462	\N	\N	f	Qual by exam of deed	0
53463_3250.0_2011-09-26	325000	\N	2011-09-26	53463	\N	\N	f	Qual by verifiable & documented evidence	0
53463_3750.0_2018-04-10	375000	\N	2018-04-10	53463	\N	\N	f	Qual by exam of deed	0
53465_3050.0_2010-07-30	305000	\N	2010-07-30	53465	\N	\N	f	Qual by exam of deed	0
53465_3650.0_2010-10-29	365000	\N	2010-10-29	53465	\N	\N	f	Qual by exam of deed	0
53465_5750.0_2008-12-24	575000	\N	2008-12-24	53465	\N	\N	f	Sales which are qualified	0
53465_6250.0_2022-06-07	625000	\N	2022-06-07	53465	\N	\N	f	Qual by exam of deed	0
53466_4958.0_2008-12-22	495800	\N	2008-12-22	53466	\N	\N	f	Sales which are qualified	0
53467_3250.0_2010-01-19	325000	\N	2010-01-19	53467	\N	\N	f	Qual by exam of deed	0
53468_6150.0_2008-11-14	615000	\N	2008-11-14	53468	\N	\N	f	Sales which are qualified	0
53468_7750.0_2008-11-14	775000	\N	2008-11-14	53468	\N	\N	f	Sales which are qualified	0
53468_9000.0_2015-05-29	900000	\N	2015-05-29	53468	\N	\N	f	Qual by exam of deed	0
53469_12000.0_2008-12-12	1200000	\N	2008-12-12	53469	\N	\N	f	Sales which are qualified	0
53470_6300.0_2008-01-21	630000	\N	2008-01-21	53470	\N	\N	f	Sales which are qualified	0
53470_6300.0_2014-05-15	630000	\N	2014-05-15	53470	\N	\N	f	Qual by exam of deed	0
53471_3700.0_2018-07-16	370000	\N	2018-07-16	53471	\N	\N	f	Qual by exam of deed	0
53472_3680.0_2012-02-17	368000	\N	2012-02-17	53472	\N	\N	f	Qual by exam of deed	0
53472_3900.0_2018-01-30	390000	\N	2018-01-30	53472	\N	\N	f	Qual by exam of deed	0
53473_3500.0_2010-06-18	350000	\N	2010-06-18	53473	\N	\N	f	Qual by exam of deed	0
53474_5500.0_2008-12-19	550000	\N	2008-12-19	53474	\N	\N	f	Sales which are qualified	0
53475_3750.0_2012-07-31	375000	\N	2012-07-31	53475	\N	\N	f	Qual by exam of deed	0
53476_3000.0_2011-12-12	300000	\N	2011-12-12	53476	\N	\N	f	Qual by exam of deed	0
53476_3000.0_2021-03-29	300000	\N	2021-03-29	53476	\N	\N	f	Qual by exam of deed	0
53477_2500.0_2010-06-15	250000	\N	2010-06-15	53477	\N	\N	f	Qual by exam of deed	0
53479_3100.0_2010-04-23	310000	\N	2010-04-23	53479	\N	\N	f	Qual by exam of deed	0
53480_3140.0_2012-04-09	314000	\N	2012-04-09	53480	\N	\N	f	Qual by exam of deed	0
53480_3250.0_2009-09-08	325000	\N	2009-09-08	53480	\N	\N	f	Qual by exam of deed	0
53480_3908.96_2014-04-17	390896	\N	2014-04-17	53480	\N	\N	f	Qual by exam of deed	0
53481_5870.0_2008-12-10	587000	\N	2008-12-10	53481	\N	\N	f	Sales which are qualified	0
53482_6500.0_2009-12-18	650000	\N	2009-12-18	53482	\N	\N	f	Qual by exam of deed	0
53483_17850.0_2021-09-08	1785000	\N	2021-09-08	53483	\N	\N	f	Qual by exam of deed	0
53484_3250.0_2011-06-20	325000	\N	2011-06-20	53484	\N	\N	f	Qual by exam of deed	0
53484_4300.0_2011-05-23	430000	\N	2011-05-23	53484	\N	\N	f	Qual by exam of deed	0
53484_5330.0_2018-01-19	533000	\N	2018-01-19	53484	\N	\N	f	Qual by exam of deed	0
53484_6600.0_2008-05-14	660000	\N	2008-05-14	53484	\N	\N	f	Sales which are qualified	0
53485_3750.0_2010-09-07	375000	\N	2010-09-07	53485	\N	\N	f	Qual by exam of deed	0
53485_4350.0_2021-06-01	435000	\N	2021-06-01	53485	\N	\N	f	Qual by exam of deed	0
53485_6300.0_2023-01-31	630000	\N	2023-01-31	53485	\N	\N	f	Qual by exam of deed	0
53486_3870.0_2012-02-21	387000	\N	2012-02-21	53486	\N	\N	f	Qual by exam of deed	0
53486_4000.0_2018-06-29	400000	\N	2018-06-29	53486	\N	\N	f	Qual by exam of deed	0
53487_6200.0_2008-11-20	620000	\N	2008-11-20	53487	\N	\N	f	Sales which are qualified	0
53488_3450.0_2011-11-18	345000	\N	2011-11-18	53488	\N	\N	f	Qual by exam of deed	0
53488_5750.0_2013-07-30	575000	\N	2013-07-30	53488	\N	\N	f	Qual by exam of deed	0
53488_6100.0_2008-12-04	610000	\N	2008-12-04	53488	\N	\N	f	Sales which are qualified	0
53488_6500.0_2014-04-23	650000	\N	2014-04-23	53488	\N	\N	f	Qual by exam of deed	0
53489_3735.0_2012-05-22	373500	\N	2012-05-22	53489	\N	\N	f	Qual by exam of deed	0
53490_3060.0_2011-11-29	306000	\N	2011-11-29	53490	\N	\N	f	Qual by exam of deed	0
53491_4892.7_2008-12-22	489270	\N	2008-12-22	53491	\N	\N	f	Sales which are qualified	0
53492_2200.0_2009-09-24	220000	\N	2009-09-24	53492	\N	\N	f	Qual by exam of deed	0
53493_3000.0_2009-12-30	300000	\N	2009-12-30	53493	\N	\N	f	Qual by exam of deed	0
53495_4000.0_2009-06-30	400000	\N	2009-06-30	53495	\N	\N	f	Qual by exam of deed	0
53496_4350.0_2021-06-03	435000	\N	2021-06-03	53496	\N	\N	f	Qual by exam of deed	0
53496_5500.0_2023-05-31	550000	\N	2023-05-31	53496	\N	\N	f	Qual by exam of deed	0
53497_5950.0_2008-12-22	595000	\N	2008-12-22	53497	\N	\N	f	Sales which are qualified	0
53498_6543.0_2012-07-19	654300	\N	2012-07-19	53498	\N	\N	f	Qual by exam of deed	0
53498_7500.0_2014-11-14	750000	\N	2014-11-14	53498	\N	\N	f	Qual by exam of deed	0
53499_10500.0_2020-12-14	1050000	\N	2020-12-14	53499	\N	\N	f	Qual by exam of deed	0
53499_14000.0_2008-10-30	1400000	\N	2008-10-30	53499	\N	\N	f	Sales which are qualified	0
53500_7450.0_2021-09-28	745000	\N	2021-09-28	53500	\N	\N	f	Qual by exam of deed	0
53500_7500.0_2008-12-30	750000	\N	2008-12-30	53500	\N	\N	f	Sales which are qualified	0
53501_4250.0_2009-09-16	425000	\N	2009-09-16	53501	\N	\N	f	Qual by exam of deed	0
53502_6000.0_2023-04-28	600000	\N	2023-04-28	53502	\N	\N	f	Qual by exam of deed	0
53503_4100.0_2009-06-17	410000	\N	2009-06-17	53503	\N	\N	f	Qual by exam of deed	0
53504_4400.0_2012-08-18	440000	\N	2012-08-18	53504	\N	\N	f	Qual by exam of deed	0
53504_4650.0_2009-12-14	465000	\N	2009-12-14	53504	\N	\N	f	Qual by exam of deed	0
53505_4400.0_2009-09-17	440000	\N	2009-09-17	53505	\N	\N	f	Qual by exam of deed	0
53506_4650.0_2008-10-23	465000	\N	2008-10-23	53506	\N	\N	f	Sales which are qualified	0
53506_6400.0_2013-05-09	640000	\N	2013-05-09	53506	\N	\N	f	Qual by exam of deed	0
53507_3890.0_2011-09-19	389000	\N	2011-09-19	53507	\N	\N	f	Qual by exam of deed	0
53507_5300.0_2013-01-21	530000	\N	2013-01-21	53507	\N	\N	f	Qual by exam of deed	0
53509_3550.0_2012-08-07	355000	\N	2012-08-07	53509	\N	\N	f	Qual by exam of deed	0
53509_4850.0_2022-06-03	485000	\N	2022-06-03	53509	\N	\N	f	Qual by exam of deed	0
53509_5350.0_2008-11-04	535000	\N	2008-11-04	53509	\N	\N	f	Sales which are qualified	0
53510_2650.0_2010-04-19	265000	\N	2010-04-19	53510	\N	\N	f	Qual by exam of deed	0
53510_5150.0_2013-07-01	515000	\N	2013-07-01	53510	\N	\N	f	Qual by exam of deed	0
53511_4287.13_2008-10-31	428713	\N	2008-10-31	53511	\N	\N	f	Sales which are qualified	0
53512_6400.0_2013-08-14	640000	\N	2013-08-14	53512	\N	\N	f	Qual by exam of deed	0
53512_7200.0_2022-03-09	720000	\N	2022-03-09	53512	\N	\N	f	Qual by exam of deed	0
53514_4450.0_2010-05-19	445000	\N	2010-05-19	53514	\N	\N	f	Qual by exam of deed	0
53514_7500.0_2022-06-10	750000	\N	2022-06-10	53514	\N	\N	f	Qual by exam of deed	0
53514_8200.0_2013-10-23	820000	\N	2013-10-23	53514	\N	\N	f	Qual by exam of deed	0
53516_5900.0_2008-11-07	590000	\N	2008-11-07	53516	\N	\N	f	Sales which are qualified	0
53518_12500.0_2013-02-21	1250000	\N	2013-02-21	53518	\N	\N	f	Qual by exam of deed	0
53518_12600.0_2021-06-16	1260000	\N	2021-06-16	53518	\N	\N	f	Qual by exam of deed	0
53519_4500.0_2009-12-15	450000	\N	2009-12-15	53519	\N	\N	f	Qual by exam of deed	0
53520_4600.0_2021-11-04	460000	\N	2021-11-04	53520	\N	\N	f	Qual by exam of deed	0
53520_6750.0_2023-07-28	675000	\N	2023-07-28	53520	\N	\N	f	Qual by exam of deed	0
53521_4050.0_2011-04-29	405000	\N	2011-04-29	53521	\N	\N	f	Qual by exam of deed	0
53522_3200.0_2011-03-11	320000	\N	2011-03-11	53522	\N	\N	f	Qual by exam of deed	0
53522_4000.0_2021-02-03	400000	\N	2021-02-03	53522	\N	\N	f	Qual by exam of deed	0
53522_4400.0_2011-09-19	440000	\N	2011-09-19	53522	\N	\N	f	Qual by exam of deed	0
53522_6300.0_2008-10-29	630000	\N	2008-10-29	53522	\N	\N	f	Sales which are qualified	0
53523_4090.5_2012-02-02	409050	\N	2012-02-02	53523	\N	\N	f	Qual by exam of deed	0
53523_5280.0_2012-12-21	528000	\N	2012-12-21	53523	\N	\N	f	Qual by exam of deed	0
53524_4095.0_2012-05-11	409500	\N	2012-05-11	53524	\N	\N	f	Qual by exam of deed	0
53524_6000.0_2013-10-14	600000	\N	2013-10-14	53524	\N	\N	f	Qual by exam of deed	0
53525_3800.0_2018-06-19	380000	\N	2018-06-19	53525	\N	\N	f	Qual by exam of deed	0
53525_5000.0_2008-12-12	500000	\N	2008-12-12	53525	\N	\N	f	Sales which are qualified	0
53525_5800.0_2013-02-08	580000	\N	2013-02-08	53525	\N	\N	f	Qual by exam of deed	0
53526_3942.0_2012-06-14	394200	\N	2012-06-14	53526	\N	\N	f	Qual by exam of deed	0
53527_5450.0_2009-08-27	545000	\N	2009-08-27	53527	\N	\N	f	Qual by exam of deed	0
53528_3290.0_2011-11-18	329000	\N	2011-11-18	53528	\N	\N	f	Qual by exam of deed	0
53529_3320.0_2012-04-10	332000	\N	2012-04-10	53529	\N	\N	f	Qual by exam of deed	0
53530_3936.0_2008-11-21	393600	\N	2008-11-21	53530	\N	\N	f	Sales which are qualified	0
53530_5200.0_2014-04-22	520000	\N	2014-04-22	53530	\N	\N	f	Qual by exam of deed	0
53531_4850.0_2012-05-09	485000	\N	2012-05-09	53531	\N	\N	f	Qual by exam of deed	0
53531_4900.0_2008-12-31	490000	\N	2008-12-31	53531	\N	\N	f	Sales which are qualified	0
53531_6350.0_2013-06-18	635000	\N	2013-06-18	53531	\N	\N	f	Qual by exam of deed	0
53531_8187.0_2015-10-08	818700	\N	2015-10-08	53531	\N	\N	f	Qual by exam of deed	0
53533_4350.0_2010-07-01	435000	\N	2010-07-01	53533	\N	\N	f	Qual by exam of deed	0
53534_2950.0_2009-08-12	295000	\N	2009-08-12	53534	\N	\N	f	Qual by exam of deed	0
53535_3250.0_2009-12-30	325000	\N	2009-12-30	53535	\N	\N	f	Qual by exam of deed	0
53535_4500.0_2021-06-04	450000	\N	2021-06-04	53535	\N	\N	f	Qual by exam of deed	0
53535_5350.0_2022-01-14	535000	\N	2022-01-14	53535	\N	\N	f	Qual by exam of deed	0
53536_8075.0_2009-05-15	807500	\N	2009-05-15	53536	\N	\N	f	Qual by exam of deed	0
53537_13000.0_2012-10-23	1300000	\N	2012-10-23	53537	\N	\N	f	Qual by exam of deed	0
53537_9750.0_2008-11-06	975000	\N	2008-11-06	53537	\N	\N	f	Sales which are qualified	0
53537_9990.0_2009-10-26	999000	\N	2009-10-26	53537	\N	\N	f	Qual by exam of deed	0
53538_5450.0_2010-03-31	545000	\N	2010-03-31	53538	\N	\N	f	Qual by exam of deed	0
53539_4050.0_2011-05-06	405000	\N	2011-05-06	53539	\N	\N	f	Qual by exam of deed	0
53539_5990.0_2023-05-23	599000	\N	2023-05-23	53539	\N	\N	f	Qual by exam of deed	0
53540_3950.0_2012-07-02	395000	\N	2012-07-02	53540	\N	\N	f	Qual by exam of deed	0
53540_7409.3_2009-10-08	740930	\N	2009-10-08	53540	\N	\N	f	Qual by exam of deed	0
53541_6900.0_2008-11-19	690000	\N	2008-11-19	53541	\N	\N	f	Sales which are qualified	0
53542_4750.0_2009-06-17	475000	\N	2009-06-17	53542	\N	\N	f	Qual by exam of deed	0
53543_3600.0_2010-07-20	360000	\N	2010-07-20	53543	\N	\N	f	Qual by exam of deed	0
53543_7490.0_2022-03-09	749000	\N	2022-03-09	53543	\N	\N	f	Qual by exam of deed	0
53544_5100.0_2012-12-19	510000	\N	2012-12-19	53544	\N	\N	f	Qual by exam of deed	0
53544_5390.0_2008-12-22	539000	\N	2008-12-22	53544	\N	\N	f	Sales which are qualified	0
53545_3600.0_2018-09-21	360000	\N	2018-09-21	53545	\N	\N	f	Qual by exam of deed	0
53545_4025.0_2019-02-07	402500	\N	2019-02-07	53545	\N	\N	f	Qual by exam of deed	0
53545_5450.0_2008-12-04	545000	\N	2008-12-04	53545	\N	\N	f	Sales which are qualified	0
53546_7300.0_2008-12-15	730000	\N	2008-12-15	53546	\N	\N	f	Sales which are qualified	0
53546_7690.0_2021-05-18	769000	\N	2021-05-18	53546	\N	\N	f	Qual by exam of deed	0
53547_5000.0_2022-03-21	500000	\N	2022-03-21	53547	\N	\N	f	Qual by exam of deed	0
53547_5750.0_2008-10-31	575000	\N	2008-10-31	53547	\N	\N	f	Sales which are qualified	0
53548_2750.0_2010-06-03	275000	\N	2010-06-03	53548	\N	\N	f	Qual by exam of deed	0
53549_4150.0_2008-10-31	415000	\N	2008-10-31	53549	\N	\N	f	Sales which are qualified	0
53550_5000.0_2021-07-19	500000	\N	2021-07-19	53550	\N	\N	f	Qual by exam of deed	0
53550_5750.0_2008-11-26	575000	\N	2008-11-26	53550	\N	\N	f	Sales which are qualified	0
53552_6500.0_2020-03-04	650000	\N	2020-03-04	53552	\N	\N	f	Qual by exam of deed	0
53552_6610.0_2017-04-18	661000	\N	2017-04-18	53552	\N	\N	f	Qual by exam of deed	0
53553_3050.0_2009-08-19	305000	\N	2009-08-19	53553	\N	\N	f	Qual by exam of deed	0
53553_3150.0_2010-05-07	315000	\N	2010-05-07	53553	\N	\N	f	Qual by exam of deed	0
53554_4020.0_2019-04-30	402000	\N	2019-04-30	53554	\N	\N	f	Qual by exam of deed	0
53555_5950.0_2010-09-10	595000	\N	2010-09-10	53555	\N	\N	f	Qual by exam of deed	0
53557_6500.0_2008-12-04	650000	\N	2008-12-04	53557	\N	\N	f	Sales which are qualified	0
53558_4167.5_2011-06-07	416750	\N	2011-06-07	53558	\N	\N	f	Qual by exam of deed	0
53559_4086.0_2012-06-28	408600	\N	2012-06-28	53559	\N	\N	f	Qual by exam of deed	0
53560_6300.0_2008-11-26	630000	\N	2008-11-26	53560	\N	\N	f	Sales which are qualified	0
53560_6600.0_2015-08-31	660000	\N	2015-08-31	53560	\N	\N	f	Qual by exam of deed	0
53561_5250.0_2009-06-26	525000	\N	2009-06-26	53561	\N	\N	f	Qual by exam of deed	0
53561_6600.0_2015-05-06	660000	\N	2015-05-06	53561	\N	\N	f	Qual by exam of deed	0
53562_4230.0_2012-03-16	423000	\N	2012-03-16	53562	\N	\N	f	Qual by exam of deed	0
53563_3250.0_2010-05-07	325000	\N	2010-05-07	53563	\N	\N	f	Qual by exam of deed	0
53564_3300.0_2010-04-09	330000	\N	2010-04-09	53564	\N	\N	f	Qual by exam of deed	0
53564_5600.0_2013-03-18	560000	\N	2013-03-18	53564	\N	\N	f	Qual by exam of deed	0
53565_9000.0_2021-05-17	900000	\N	2021-05-17	53565	\N	\N	f	Qual by exam of deed	0
53565_9200.0_2014-10-07	920000	\N	2014-10-07	53565	\N	\N	f	Qual by exam of deed	0
53566_3470.0_2012-04-10	347000	\N	2012-04-10	53566	\N	\N	f	Qual by exam of deed	0
53567_3500.0_2012-05-24	350000	\N	2012-05-24	53567	\N	\N	f	Qual by exam of deed	0
53567_5450.0_2008-11-04	545000	\N	2008-11-04	53567	\N	\N	f	Sales which are qualified	0
53568_4250.0_2008-11-06	425000	\N	2008-11-06	53568	\N	\N	f	Sales which are qualified	0
53569_5600.0_2008-11-04	560000	\N	2008-11-04	53569	\N	\N	f	Sales which are qualified	0
53571_4200.0_2010-03-22	420000	\N	2010-03-22	53571	\N	\N	f	Qual by exam of deed	0
53571_5150.0_2011-09-01	515000	\N	2011-09-01	53571	\N	\N	f	Qual by exam of deed	0
53571_6750.0_2021-06-28	675000	\N	2021-06-28	53571	\N	\N	f	Qual by exam of deed	0
53572_3526.0_2009-12-31	352600	\N	2009-12-31	53572	\N	\N	f	Qual by exam of deed	0
53572_4900.0_2020-01-06	490000	\N	2020-01-06	53572	\N	\N	f	Qual by exam of deed	0
53572_5000.0_2015-04-22	500000	\N	2015-04-22	53572	\N	\N	f	Qual by exam of deed	0
53573_3150.0_2010-11-11	315000	\N	2010-11-11	53573	\N	\N	f	Qual by exam of deed	0
53573_3300.0_2020-04-02	330000	\N	2020-04-02	53573	\N	\N	f	Qual by exam of deed	0
53573_3350.0_2018-09-21	335000	\N	2018-09-21	53573	\N	\N	f	Qual by exam of deed	0
53573_4100.0_2021-08-09	410000	\N	2021-08-09	53573	\N	\N	f	Qual by exam of deed	0
53573_4420.0_2012-08-13	442000	\N	2012-08-13	53573	\N	\N	f	Qual by exam of deed	0
53573_5250.0_2008-11-11	525000	\N	2008-11-11	53573	\N	\N	f	Sales which are qualified	0
53574_5085.0_2012-09-18	508500	\N	2012-09-18	53574	\N	\N	f	Qual by exam of deed	0
53574_6700.0_2013-01-28	670000	\N	2013-01-28	53574	\N	\N	f	Qual by exam of deed	0
53574_8675.0_2021-09-23	867500	\N	2021-09-23	53574	\N	\N	f	Qual by exam of deed	0
53575_7000.0_2008-11-21	700000	\N	2008-11-21	53575	\N	\N	f	Sales which are qualified	0
53576_15615.0_2012-09-07	1561500	\N	2012-09-07	53576	\N	\N	f	Qual by exam of deed	0
53577_7700.0_2012-09-06	770000	\N	2012-09-06	53577	\N	\N	f	Qual by exam of deed	0
53577_9000.0_2019-04-23	900000	\N	2019-04-23	53577	\N	\N	f	Qual by exam of deed	0
53578_11250.0_2013-01-14	1125000	\N	2013-01-14	53578	\N	\N	f	Qual by exam of deed	0
53578_7740.0_2012-11-08	774000	\N	2012-11-08	53578	\N	\N	f	Qual by exam of deed	0
53578_9850.0_2021-06-20	985000	\N	2021-06-20	53578	\N	\N	f	Qual by exam of deed	0
53579_7000.0_2008-12-22	700000	\N	2008-12-22	53579	\N	\N	f	Sales which are qualified	0
53580_3800.0_2011-03-15	380000	\N	2011-03-15	53580	\N	\N	f	Qual by exam of deed	0
53580_5000.0_2013-04-01	500000	\N	2013-04-01	53580	\N	\N	f	Qual by exam of deed	0
53581_6900.0_2008-11-18	690000	\N	2008-11-18	53581	\N	\N	f	Sales which are qualified	0
53582_14000.0_2017-07-13	1400000	\N	2017-07-13	53582	\N	\N	f	Qual by exam of deed	0
53582_5550.0_2011-06-30	555000	\N	2011-06-30	53582	\N	\N	f	Qual by exam of deed	0
53583_3020.0_2011-12-19	302000	\N	2011-12-19	53583	\N	\N	f	Qual by exam of deed	0
53583_4350.0_2021-12-06	435000	\N	2021-12-06	53583	\N	\N	f	Qual by exam of deed	0
53583_4500.0_2015-10-01	450000	\N	2015-10-01	53583	\N	\N	f	Qual by exam of deed	0
53585_3500.0_2011-11-04	350000	\N	2011-11-04	53585	\N	\N	f	Qual by exam of deed	0
53585_4990.0_2018-03-07	499000	\N	2018-03-07	53585	\N	\N	f	Qual by exam of deed	0
53586_3500.0_2009-07-30	350000	\N	2009-07-30	53586	\N	\N	f	Qual by exam of deed	0
53586_5250.0_2011-05-17	525000	\N	2011-05-17	53586	\N	\N	f	Qual by exam of deed	0
53586_6150.0_2011-12-02	615000	\N	2011-12-02	53586	\N	\N	f	Qual by exam of deed	0
53586_7000.0_2008-11-11	700000	\N	2008-11-11	53586	\N	\N	f	Sales which are qualified	0
53587_3850.0_2011-10-21	385000	\N	2011-10-21	53587	\N	\N	f	Qual by exam of deed	0
53588_4150.0_2012-09-07	415000	\N	2012-09-07	53588	\N	\N	f	Qual by exam of deed	0
53588_5800.0_2016-03-15	580000	\N	2016-03-15	53588	\N	\N	f	Qual by exam of deed	0
53589_5490.0_2012-11-08	549000	\N	2012-11-08	53589	\N	\N	f	Qual by exam of deed	0
53590_16500.0_2012-09-06	1650000	\N	2012-09-06	53590	\N	\N	f	Qual by exam of deed	0
53591_11500.0_2012-12-12	1150000	\N	2012-12-12	53591	\N	\N	f	Qual by exam of deed	0
53591_13125.0_2022-10-11	1312500	\N	2022-10-11	53591	\N	\N	f	Qual by exam of deed	0
53591_8150.0_2012-09-04	815000	\N	2012-09-04	53591	\N	\N	f	Qual by exam of deed	0
53592_12750.0_2015-02-04	1275000	\N	2015-02-04	53592	\N	\N	f	Qual by exam of deed	0
53592_6300.0_2011-03-16	630000	\N	2011-03-16	53592	\N	\N	f	Qual by exam of deed	0
53592_9500.0_2013-04-23	950000	\N	2013-04-23	53592	\N	\N	f	Qual by exam of deed	0
53593_5450.0_2010-11-29	545000	\N	2010-11-29	53593	\N	\N	f	Qual by exam of deed	0
53594_3800.0_2011-05-31	380000	\N	2011-05-31	53594	\N	\N	f	Qual by exam of deed	0
53594_9750.0_2022-02-25	975000	\N	2022-02-25	53594	\N	\N	f	Qual by exam of deed	0
53595_5625.0_2011-05-23	562500	\N	2011-05-23	53595	\N	\N	f	Qual by exam of deed	0
53596_7350.0_2008-11-14	735000	\N	2008-11-14	53596	\N	\N	f	Sales which are qualified	0
53597_5500.0_2010-07-30	550000	\N	2010-07-30	53597	\N	\N	f	Qual by exam of deed	0
53598_3100.0_2011-07-25	310000	\N	2011-07-25	53598	\N	\N	f	Qual by exam of deed	0
53599_4009.0_2012-07-02	400900	\N	2012-07-02	53599	\N	\N	f	Qual by exam of deed	0
53599_5750.0_2022-08-25	575000	\N	2022-08-25	53599	\N	\N	f	Qual by exam of deed	0
53600_5380.0_2011-08-30	538000	\N	2011-08-30	53600	\N	\N	f	Qual by exam of deed	0
53601_3650.0_2011-08-22	365000	\N	2011-08-22	53601	\N	\N	f	Qual by exam of deed	0
53601_4000.0_2017-09-29	400000	\N	2017-09-29	53601	\N	\N	f	Qual by exam of deed	0
82980_23250.0_2013-02-04	2325000	\N	2013-02-04	82980	\N	\N	f	Qual by exam of deed	0
82982_10000.0_2012-05-29	1000000	\N	2012-05-29	82982	\N	\N	f	Qual by exam of deed	0
82984_9500.0_2011-06-02	950000	\N	2011-06-02	82984	\N	\N	f	Qual by exam of deed	0
82985_10850.0_2011-11-07	1085000	\N	2011-11-07	82985	\N	\N	f	Qual by exam of deed	0
82985_13000.0_2021-04-13	1300000	\N	2021-04-13	82985	\N	\N	f	Qual by exam of deed	0
82986_10125.0_2010-09-29	1012500	\N	2010-09-29	82986	\N	\N	f	Qual by exam of deed	0
82986_12000.0_2012-06-22	1200000	\N	2012-06-22	82986	\N	\N	f	Qual by exam of deed	0
82986_16450.0_2016-12-06	1645000	\N	2016-12-06	82986	\N	\N	f	Qual by exam of deed	0
82987_11100.0_2012-04-16	1110000	\N	2012-04-16	82987	\N	\N	f	Qual by exam of deed	0
82987_18000.0_2015-09-21	1800000	\N	2015-09-21	82987	\N	\N	f	Qual by exam of deed	0
82988_10900.0_2011-09-30	1090000	\N	2011-09-30	82988	\N	\N	f	Qual by exam of deed	0
82988_12500.0_2019-06-03	1250000	\N	2019-06-03	82988	\N	\N	f	Qual by exam of deed	0
82988_14100.0_2012-07-24	1410000	\N	2012-07-24	82988	\N	\N	f	Qual by exam of deed	0
82989_11050.0_2012-03-20	1105000	\N	2012-03-20	82989	\N	\N	f	Qual by exam of deed	0
82989_12500.0_2012-05-11	1250000	\N	2012-05-11	82989	\N	\N	f	Qual by exam of deed	0
82989_15500.0_2021-09-15	1550000	\N	2021-09-15	82989	\N	\N	f	Qual by exam of deed	0
82990_13310.0_2012-05-21	1331000	\N	2012-05-21	82990	\N	\N	f	Qual by exam of deed	0
82990_13500.0_2020-06-19	1350000	\N	2020-06-19	82990	\N	\N	f	Qual by exam of deed	0
82991_12800.0_2011-12-19	1280000	\N	2011-12-19	82991	\N	\N	f	Qual by exam of deed	0
82991_13400.0_2020-03-26	1340000	\N	2020-03-26	82991	\N	\N	f	Qual by exam of deed	0
82991_16750.0_2012-12-31	1675000	\N	2012-12-31	82991	\N	\N	f	Qual by exam of deed	0
82991_18500.0_2014-05-02	1850000	\N	2014-05-02	82991	\N	\N	f	Qual by exam of deed	0
82992_13990.0_2012-05-11	1399000	\N	2012-05-11	82992	\N	\N	f	Qual by exam of deed	0
82992_18000.0_2014-11-25	1800000	\N	2014-11-25	82992	\N	\N	f	Qual by exam of deed	0
82993_13119.5_2012-03-27	1311950	\N	2012-03-27	82993	\N	\N	f	Qual by exam of deed	0
82994_17600.0_2008-10-24	1760000	\N	2008-10-24	82994	\N	\N	f	Sales which are qualified	0
82994_19000.0_2015-02-13	1900000	\N	2015-02-13	82994	\N	\N	f	Qual by exam of deed	0
82995_13750.0_2012-08-28	1375000	\N	2012-08-28	82995	\N	\N	f	Qual by exam of deed	0
82995_18200.0_2013-09-10	1820000	\N	2013-09-10	82995	\N	\N	f	Qual by exam of deed	0
82996_22560.0_2008-12-17	2256000	\N	2008-12-17	82996	\N	\N	f	Sales which are qualified	0
82997_13500.0_2012-05-21	1350000	\N	2012-05-21	82997	\N	\N	f	Qual by exam of deed	0
82997_15100.0_2021-04-30	1510000	\N	2021-04-30	82997	\N	\N	f	Qual by exam of deed	0
82998_21750.0_2012-08-02	2175000	\N	2012-08-02	82998	\N	\N	f	Qual by exam of deed	0
82999_15320.0_2013-01-22	1532000	\N	2013-01-22	82999	\N	\N	f	Qual by exam of deed	0
82999_22000.0_2022-05-31	2200000	\N	2022-05-31	82999	\N	\N	f	Qual by exam of deed	0
83000_54497.0_2008-10-11	5449700	\N	2008-10-11	83000	\N	\N	t	Deeds that include more than one parcel	0
83000_9383.0_2015-08-25	938300	\N	2015-08-25	83000	\N	\N	f	Qual by exam of deed	0
83001_15707.9_2013-02-12	1570790	\N	2013-02-12	83001	\N	\N	f	Qual by exam of deed	0
83002_23100.0_2012-06-15	2310000	\N	2012-06-15	83002	\N	\N	f	Qual by exam of deed	0
83002_28000.0_2021-03-18	2800000	\N	2021-03-18	83002	\N	\N	f	Qual by exam of deed	0
83003_22000.0_2016-09-14	2200000	\N	2016-09-14	83003	\N	\N	f	Qual by exam of deed	0
83003_24750.0_2013-02-19	2475000	\N	2013-02-19	83003	\N	\N	f	Qual by exam of deed	0
83003_32500.0_2023-03-27	3250000	\N	2023-03-27	83003	\N	\N	f	Qual by exam of deed	0
83004_24000.0_2012-01-25	2400000	\N	2012-01-25	83004	\N	\N	f	Qual by exam of deed	0
83004_32000.0_2022-01-10	3200000	\N	2022-01-10	83004	\N	\N	f	Qual by exam of deed	0
83005_23150.0_2013-01-18	2315000	\N	2013-01-18	83005	\N	\N	f	Qual by exam of deed	0
83005_30000.0_2014-05-02	3000000	\N	2014-05-02	83005	\N	\N	f	Qual by exam of deed	0
83006_22600.0_2012-01-24	2260000	\N	2012-01-24	83006	\N	\N	f	Qual by exam of deed	0
83007_25000.0_2021-03-05	2500000	\N	2021-03-05	83007	\N	\N	f	Qual by exam of deed	0
83007_27000.0_2013-07-09	2700000	\N	2013-07-09	83007	\N	\N	f	Qual by exam of deed	0
83008_23000.0_2012-07-19	2300000	\N	2012-07-19	83008	\N	\N	f	Qual by exam of deed	0
83009_20000.0_2012-08-22	2000000	\N	2012-08-22	83009	\N	\N	f	Qual by exam of deed	0
83010_12343.9_2011-12-21	1234390	\N	2011-12-21	83010	\N	\N	f	Qual by exam of deed	0
83010_25900.0_2013-11-01	2590000	\N	2013-11-01	83010	\N	\N	f	Qual by exam of deed	0
83011_11800.0_2011-06-13	1180000	\N	2011-06-13	83011	\N	\N	f	Qual by exam of deed	0
83012_11702.0_2011-05-03	1170200	\N	2011-05-03	83012	\N	\N	f	Qual by exam of deed	0
83012_19450.0_2021-12-29	1945000	\N	2021-12-29	83012	\N	\N	f	Qual by exam of deed	0
83013_13972.0_2011-07-12	1397200	\N	2011-07-12	83013	\N	\N	f	Qual by exam of deed	0
83014_13630.0_2011-04-14	1363000	\N	2011-04-14	83014	\N	\N	f	Qual by exam of deed	0
83014_14000.0_2020-01-16	1400000	\N	2020-01-16	83014	\N	\N	f	Qual by exam of deed	0
83015_14000.0_2011-12-09	1400000	\N	2011-12-09	83015	\N	\N	f	Qual by exam of deed	0
83016_15750.0_2011-06-02	1575000	\N	2011-06-02	83016	\N	\N	f	Qual by exam of deed	0
83017_17100.0_2010-04-16	1710000	\N	2010-04-16	83017	\N	\N	f	Qual by exam of deed	0
83018_15400.0_2012-06-15	1540000	\N	2012-06-15	83018	\N	\N	f	Qual by exam of deed	0
83018_19000.0_2021-04-30	1900000	\N	2021-04-30	83018	\N	\N	f	Qual by exam of deed	0
83019_19300.0_2008-11-25	1930000	\N	2008-11-25	83019	\N	\N	f	Sales which are qualified	0
83020_15700.0_2011-04-27	1570000	\N	2011-04-27	83020	\N	\N	f	Qual by exam of deed	0
83020_22750.0_2016-09-06	2275000	\N	2016-09-06	83020	\N	\N	f	Qual by exam of deed	0
83021_16745.5_2012-06-28	1674550	\N	2012-06-28	83021	\N	\N	f	Qual by exam of deed	0
83021_17500.0_2021-03-08	1750000	\N	2021-03-08	83021	\N	\N	f	Qual by exam of deed	0
83022_16600.0_2012-05-03	1660000	\N	2012-05-03	83022	\N	\N	f	Qual by exam of deed	0
83023_29850.0_2011-12-01	2985000	\N	2011-12-01	83023	\N	\N	t	Qual on DOS, multi-parcel sale	0
83024_17000.0_2012-03-29	1700000	\N	2012-03-29	83024	\N	\N	f	Qual by exam of deed	0
83024_20000.0_2019-03-25	2000000	\N	2019-03-25	83024	\N	\N	f	Qual by exam of deed	0
83025_22850.0_2011-11-07	2285000	\N	2011-11-07	83025	\N	\N	f	Qual by exam of deed	0
83026_9000.0_2011-11-18	900000	\N	2011-11-18	83026	\N	\N	f	Qual by exam of deed	0
83027_6300.0_2012-06-19	630000	\N	2012-06-19	83027	\N	\N	f	Qual by exam of deed	0
83028_11690.0_2023-08-24	1169000	\N	2023-08-24	83028	\N	\N	f	Qual by exam of deed	0
83028_5400.0_2021-01-18	540000	\N	2021-01-18	83028	\N	\N	f	Qual by exam of deed	0
83028_5500.0_2011-12-19	550000	\N	2011-12-19	83028	\N	\N	f	Qual by exam of deed	0
83028_9490.0_2022-03-16	949000	\N	2022-03-16	83028	\N	\N	f	Qual by exam of deed	0
83029_6005.8_2012-03-16	600580	\N	2012-03-16	83029	\N	\N	f	Qual by exam of deed	0
83029_8500.0_2013-03-08	850000	\N	2013-03-08	83029	\N	\N	f	Qual by exam of deed	0
83029_9300.0_2021-12-29	930000	\N	2021-12-29	83029	\N	\N	f	Qual by exam of deed	0
83030_7200.0_2012-06-15	720000	\N	2012-06-15	83030	\N	\N	f	Qual by exam of deed	0
83031_6800.0_2011-08-22	680000	\N	2011-08-22	83031	\N	\N	f	Qual by exam of deed	0
83032_7450.0_2019-12-09	745000	\N	2019-12-09	83032	\N	\N	f	Qual by exam of deed	0
83032_7500.0_2012-01-12	750000	\N	2012-01-12	83032	\N	\N	f	Qual by exam of deed	0
83032_9100.0_2021-12-14	910000	\N	2021-12-14	83032	\N	\N	f	Qual by exam of deed	0
83033_7250.0_2011-05-06	725000	\N	2011-05-06	83033	\N	\N	f	Qual by exam of deed	0
83033_8490.0_2021-08-30	849000	\N	2021-08-30	83033	\N	\N	f	Qual by exam of deed	0
83034_6800.0_2012-02-15	680000	\N	2012-02-15	83034	\N	\N	f	Qual by exam of deed	0
83035_6300.0_2010-03-17	630000	\N	2010-03-17	83035	\N	\N	f	Qual by exam of deed	0
83035_7400.0_2021-04-19	740000	\N	2021-04-19	83035	\N	\N	f	Qual by exam of deed	0
83036_11700.0_2014-09-15	1170000	\N	2014-09-15	83036	\N	\N	f	Qual by exam of deed	0
83036_6550.0_2011-07-14	655000	\N	2011-07-14	83036	\N	\N	f	Qual by exam of deed	0
83036_9050.0_2021-04-06	905000	\N	2021-04-06	83036	\N	\N	f	Qual by exam of deed	0
83037_7070.0_2011-07-14	707000	\N	2011-07-14	83037	\N	\N	f	Qual by exam of deed	0
83038_7350.0_2011-07-27	735000	\N	2011-07-27	83038	\N	\N	f	Qual by exam of deed	0
83038_7800.0_2012-04-12	780000	\N	2012-04-12	83038	\N	\N	f	Qual by exam of deed	0
83039_13500.0_2008-11-12	1350000	\N	2008-11-12	83039	\N	\N	f	Sales which are qualified	0
83040_7900.0_2011-08-31	790000	\N	2011-08-31	83040	\N	\N	f	Qual by exam of deed	0
83040_8250.0_2021-05-04	825000	\N	2021-05-04	83040	\N	\N	f	Qual by exam of deed	0
83041_10260.0_2013-11-19	1026000	\N	2013-11-19	83041	\N	\N	f	Qual by exam of deed	0
83041_16500.0_2014-01-15	1650000	\N	2014-01-15	83041	\N	\N	f	Qual by exam of deed	0
83042_11950.0_2013-02-20	1195000	\N	2013-02-20	83042	\N	\N	f	Qual by exam of deed	0
83042_14500.0_2015-06-08	1450000	\N	2015-06-08	83042	\N	\N	f	Qual by exam of deed	0
83042_8570.0_2012-01-19	857000	\N	2012-01-19	83042	\N	\N	f	Qual by exam of deed	0
83043_13750.0_2022-09-08	1375000	\N	2022-09-08	83043	\N	\N	f	Qual by exam of deed	0
83043_9591.2_2012-11-07	959120	\N	2012-11-07	83043	\N	\N	f	Qual by exam of deed	0
83044_14902.0_2015-08-25	1490200	\N	2015-08-25	83044	\N	\N	f	Qual by exam of deed	0
83044_54497.0_2008-10-11	5449700	\N	2008-10-11	83044	\N	\N	t	Deeds that include more than one parcel	0
83045_10000.0_2019-12-18	1000000	\N	2019-12-18	83045	\N	\N	f	Qual by exam of deed	0
83045_9000.0_2012-05-21	900000	\N	2012-05-21	83045	\N	\N	f	Qual by exam of deed	0
83046_13230.0_2017-06-07	1323000	\N	2017-06-07	83046	\N	\N	f	Qual by exam of deed	0
83046_35000.0_2021-12-10	3500000	\N	2021-12-10	83046	\N	\N	f	Qual by exam of deed	0
83047_28000.0_2013-03-01	2800000	\N	2013-03-01	83047	\N	\N	f	Qual by exam of deed	0
83048_4020.75_2012-04-05	402075	\N	2012-04-05	83048	\N	\N	f	Qual by exam of deed	0
83049_4200.0_2012-01-27	420000	\N	2012-01-27	83049	\N	\N	f	Qual by exam of deed	0
83049_6300.0_2013-02-12	630000	\N	2013-02-12	83049	\N	\N	f	Qual by exam of deed	0
83050_4400.0_2012-04-16	440000	\N	2012-04-16	83050	\N	\N	f	Qual by exam of deed	0
83050_5750.0_2018-07-06	575000	\N	2018-07-06	83050	\N	\N	f	Qual by exam of deed	0
83050_6250.0_2014-04-10	625000	\N	2014-04-10	83050	\N	\N	f	Qual by exam of deed	0
83051_4550.0_2011-10-25	455000	\N	2011-10-25	83051	\N	\N	f	Qual by exam of deed	0
83051_5550.0_2016-05-16	555000	\N	2016-05-16	83051	\N	\N	f	Qual by exam of deed	0
83052_5000.0_2012-05-08	500000	\N	2012-05-08	83052	\N	\N	f	Qual by exam of deed	0
83052_5000.0_2021-05-14	500000	\N	2021-05-14	83052	\N	\N	f	Qual by exam of deed	0
83053_4825.12_2011-11-28	482512	\N	2011-11-28	83053	\N	\N	f	Qual by exam of deed	0
83054_4250.0_2011-12-14	425000	\N	2011-12-14	83054	\N	\N	f	Qual by exam of deed	0
83054_5320.0_2020-03-09	532000	\N	2020-03-09	83054	\N	\N	f	Qual by exam of deed	0
83054_6325.0_2014-03-14	632500	\N	2014-03-14	83054	\N	\N	f	Qual by exam of deed	0
83055_4300.0_2011-08-12	430000	\N	2011-08-12	83055	\N	\N	f	Qual by exam of deed	0
83056_5450.0_2017-07-12	545000	\N	2017-07-12	83056	\N	\N	f	Qual by exam of deed	0
83056_8000.0_2022-06-29	800000	\N	2022-06-29	83056	\N	\N	f	Qual by exam of deed	0
83056_8600.0_2008-11-24	860000	\N	2008-11-24	83056	\N	\N	f	Sales which are qualified	0
83057_4500.0_2011-06-26	450000	\N	2011-06-26	83057	\N	\N	f	Qual by exam of deed	0
83058_4954.0_2011-07-29	495400	\N	2011-07-29	83058	\N	\N	f	Qual by exam of deed	0
83058_6090.0_2016-01-29	609000	\N	2016-01-29	83058	\N	\N	f	Qual by exam of deed	0
83059_18990.0_2011-08-25	1899000	\N	2011-08-25	83059	\N	\N	f	Qual by exam of deed	0
83059_20229.0_2018-10-17	2022900	\N	2018-10-17	83059	\N	\N	f	Qual by exam of deed	0
83060_18552.5_2011-09-06	1855250	\N	2011-09-06	83060	\N	\N	f	Qual by exam of deed	0
83060_29375.0_2015-01-24	2937500	\N	2015-01-24	83060	\N	\N	f	Qual by exam of deed	0
83061_18800.0_2012-07-18	1880000	\N	2012-07-18	83061	\N	\N	f	Qual by exam of deed	0
83061_22500.0_2019-10-11	2250000	\N	2019-10-11	83061	\N	\N	f	Qual by exam of deed	0
83062_21000.0_2009-04-15	2100000	\N	2009-04-15	83062	\N	\N	f	Qual by exam of deed	0
83062_24000.0_2021-10-20	2400000	\N	2021-10-20	83062	\N	\N	f	Qual by exam of deed	0
83063_19500.0_2009-11-30	1950000	\N	2009-11-30	83063	\N	\N	f	Qual by exam of deed	0
83064_20532.5_2011-08-25	2053250	\N	2011-08-25	83064	\N	\N	f	Qual by exam of deed	0
83065_30907.0_2015-08-25	3090700	\N	2015-08-25	83065	\N	\N	f	Qual by exam of deed	0
83065_54497.0_2008-10-11	5449700	\N	2008-10-11	83065	\N	\N	t	Deeds that include more than one parcel	0
83066_19750.0_2012-08-24	1975000	\N	2012-08-24	83066	\N	\N	f	Qual by exam of deed	0
83067_20500.0_2012-05-23	2050000	\N	2012-05-23	83067	\N	\N	f	Qual by exam of deed	0
83067_24500.0_2012-09-13	2450000	\N	2012-09-13	83067	\N	\N	f	Qual by exam of deed	0
83067_30000.0_2019-12-17	3000000	\N	2019-12-17	83067	\N	\N	f	Qual by exam of deed	0
83068_23250.0_2011-06-01	2325000	\N	2011-06-01	83068	\N	\N	f	Qual by exam of deed	0
83069_25000.0_2011-09-06	2500000	\N	2011-09-06	83069	\N	\N	f	Qual by exam of deed	0
83069_36500.0_2021-10-13	3650000	\N	2021-10-13	83069	\N	\N	f	Qual by exam of deed	0
83069_39950.0_2023-02-13	3995000	\N	2023-02-13	83069	\N	\N	f	Qual by exam of deed	0
83070_26050.0_2012-07-25	2605000	\N	2012-07-25	83070	\N	\N	f	Qual by exam of deed	0
83071_25000.0_2012-01-12	2500000	\N	2012-01-12	83071	\N	\N	f	Qual on DOS, but significant phy change since	0
83071_60000.0_2022-08-26	6000000	\N	2022-08-26	83071	\N	\N	f	Qual by exam of deed	0
83071_69000.0_2023-09-27	6900000	\N	2023-09-27	83071	\N	\N	f	Qual by exam of deed	0
83072_26000.0_2011-05-25	2600000	\N	2011-05-25	83072	\N	\N	f	Qual by exam of deed	0
83073_29000.0_2012-10-02	2900000	\N	2012-10-02	83073	\N	\N	f	Qual by exam of deed	0
83073_30000.0_2019-06-18	3000000	\N	2019-06-18	83073	\N	\N	f	Qual by exam of deed	0
83073_30000.0_2021-02-24	3000000	\N	2021-02-24	83073	\N	\N	f	Qual by exam of deed	0
83074_22000.0_2016-12-14	2200000	\N	2016-12-14	83074	\N	\N	f	Qual by exam of deed	0
83075_27000.0_2013-02-28	2700000	\N	2013-02-28	83075	\N	\N	f	Qual by exam of deed	0
83075_45750.0_2023-01-09	4575000	\N	2023-01-09	83075	\N	\N	f	Qual by exam of deed	0
83076_18750.0_2023-03-31	1875000	\N	2023-03-31	83076	\N	\N	f	Qual by exam of deed	0
83076_8837.75_2011-04-25	883775	\N	2011-04-25	83076	\N	\N	f	Qual by exam of deed	0
83077_11500.0_2021-01-26	1150000	\N	2021-01-26	83077	\N	\N	f	Qual by exam of deed	0
83077_13160.0_2013-08-01	1316000	\N	2013-08-01	83077	\N	\N	f	Qual by exam of deed	0
83078_10500.0_2019-05-08	1050000	\N	2019-05-08	83078	\N	\N	f	Qual by exam of deed	0
83078_8500.0_2011-01-25	850000	\N	2011-01-25	83078	\N	\N	f	Qual by exam of deed	0
83079_16000.0_2015-01-23	1600000	\N	2015-01-23	83079	\N	\N	f	Qual by exam of deed	0
83079_16950.0_2022-02-11	1695000	\N	2022-02-11	83079	\N	\N	f	Qual by exam of deed	0
83079_9500.0_2012-04-02	950000	\N	2012-04-02	83079	\N	\N	f	Qual by exam of deed	0
83080_14000.0_2021-07-19	1400000	\N	2021-07-19	83080	\N	\N	f	Qual by exam of deed	0
83080_9500.0_2011-04-22	950000	\N	2011-04-22	83080	\N	\N	f	Qual by exam of deed	0
83081_11000.0_2008-11-26	1100000	\N	2008-11-26	83081	\N	\N	f	Sales which are qualified	0
83081_15500.0_2021-07-19	1550000	\N	2021-07-19	83081	\N	\N	f	Qual by exam of deed	0
83081_9500.0_2011-06-03	950000	\N	2011-06-03	83081	\N	\N	f	Qual by exam of deed	0
83082_12500.0_2013-01-21	1250000	\N	2013-01-21	83082	\N	\N	f	Qual by exam of deed	0
83082_16500.0_2022-06-08	1650000	\N	2022-06-08	83082	\N	\N	f	Qual by exam of deed	0
83082_9950.0_2012-05-29	995000	\N	2012-05-29	83082	\N	\N	f	Qual by exam of deed	0
83083_9950.0_2012-02-09	995000	\N	2012-02-09	83083	\N	\N	f	Qual by exam of deed	0
83084_12900.0_2009-01-28	1290000	\N	2009-01-28	83084	\N	\N	f	Qual by exam of deed	0
83084_14000.0_2014-01-24	1400000	\N	2014-01-24	83084	\N	\N	f	Qual by exam of deed	0
83084_17500.0_2022-04-29	1750000	\N	2022-04-29	83084	\N	\N	f	Qual by exam of deed	0
83085_10500.0_2011-12-21	1050000	\N	2011-12-21	83085	\N	\N	f	Qual by exam of deed	0
83086_14000.0_2016-07-06	1400000	\N	2016-07-06	83086	\N	\N	f	Qual by exam of deed	0
83086_9750.0_2011-02-24	975000	\N	2011-02-24	83086	\N	\N	f	Qual by exam of deed	0
83087_18500.0_2011-01-07	1850000	\N	2011-01-07	83087	\N	\N	f	Qual by exam of deed	0
83087_22200.0_2019-02-08	2220000	\N	2019-02-08	83087	\N	\N	f	Qual by exam of deed	0
83088_12812.4_2012-01-09	1281240	\N	2012-01-09	83088	\N	\N	f	Qual by exam of deed	0
83089_12617.0_2011-06-27	1261700	\N	2011-06-27	83089	\N	\N	f	Qual by exam of deed	0
83089_18000.0_2014-08-26	1800000	\N	2014-08-26	83089	\N	\N	f	Qual by exam of deed	0
83089_25000.0_2022-04-01	2500000	\N	2022-04-01	83089	\N	\N	f	Qual by exam of deed	0
83090_11750.0_2011-03-16	1175000	\N	2011-03-16	83090	\N	\N	f	Qual by exam of deed	0
83090_14500.0_2012-05-24	1450000	\N	2012-05-24	83090	\N	\N	f	Qual by exam of deed	0
83090_20000.0_2014-11-19	2000000	\N	2014-11-19	83090	\N	\N	f	Qual by exam of deed	0
83091_14600.0_2011-09-26	1460000	\N	2011-09-26	83091	\N	\N	f	Qual by exam of deed	0
83092_14000.0_2011-12-09	1400000	\N	2011-12-09	83092	\N	\N	f	Qual by exam of deed	0
83093_15500.0_2009-05-27	1550000	\N	2009-05-27	83093	\N	\N	f	Qual by exam of deed	0
83094_15300.0_2021-01-29	1530000	\N	2021-01-29	83094	\N	\N	f	Qual by exam of deed	0
83094_21000.0_2012-05-01	2100000	\N	2012-05-01	83094	\N	\N	t	Qual on DOS, multi-parcel sale	0
83095_15700.0_2012-06-28	1570000	\N	2012-06-28	83095	\N	\N	f	Qual by exam of deed	0
83096_22000.0_2008-09-12	2200000	\N	2008-09-12	83096	\N	\N	f	Sales which are qualified	0
83097_20000.0_2008-08-26	2000000	\N	2008-08-26	83097	\N	\N	f	Sales which are qualified	0
83097_23550.0_2015-04-21	2355000	\N	2015-04-21	83097	\N	\N	f	Qual by exam of deed	0
83098_16500.0_2011-04-15	1650000	\N	2011-04-15	83098	\N	\N	f	Qual by exam of deed	0
83098_17500.0_2021-04-09	1750000	\N	2021-04-09	83098	\N	\N	f	Qual by exam of deed	0
83099_15950.0_2012-05-01	1595000	\N	2012-05-01	83099	\N	\N	f	Qual by exam of deed	0
83099_18000.0_2019-04-01	1800000	\N	2019-04-01	83099	\N	\N	f	Qual by exam of deed	0
83100_29050.0_2012-06-14	2905000	\N	2012-06-14	83100	\N	\N	t	Qual on DOS, multi-parcel sale	0
83100_34500.0_2020-12-02	3450000	\N	2020-12-02	83100	\N	\N	f	Qual by exam of deed	0
83100_36000.0_2022-02-10	3600000	\N	2022-02-10	83100	\N	\N	f	Qual by exam of deed	0
83101_17436.75_2012-03-19	1743675	\N	2012-03-19	83101	\N	\N	f	Qual by exam of deed	0
83102_17745.5_2012-07-02	1774550	\N	2012-07-02	83102	\N	\N	f	Qual by exam of deed	0
83103_8400.0_2012-10-26	840000	\N	2012-10-26	83103	\N	\N	f	Qual by exam of deed	0
83104_13100.0_2021-05-17	1310000	\N	2021-05-17	83104	\N	\N	f	Qual by exam of deed	0
83104_17000.0_2014-10-29	1700000	\N	2014-10-29	83104	\N	\N	f	Qual by exam of deed	0
83104_9500.0_2011-04-29	950000	\N	2011-04-29	83104	\N	\N	f	Qual by exam of deed	0
83105_18500.0_2022-07-01	1850000	\N	2022-07-01	83105	\N	\N	f	Qual by exam of deed	0
83105_9180.0_2011-05-09	918000	\N	2011-05-09	83105	\N	\N	f	Qual by exam of deed	0
83106_15000.0_2008-11-18	1500000	\N	2008-11-18	83106	\N	\N	f	Sales which are qualified	0
83106_20000.0_2015-07-16	2000000	\N	2015-07-16	83106	\N	\N	f	Qual by exam of deed	0
83107_10000.0_2010-12-30	1000000	\N	2010-12-30	83107	\N	\N	f	Qual by exam of deed	0
83107_12250.0_2019-06-05	1225000	\N	2019-06-05	83107	\N	\N	f	Qual by exam of deed	0
83107_17000.0_2014-02-13	1700000	\N	2014-02-13	83107	\N	\N	f	Qual by exam of deed	0
83107_21000.0_2024-02-15	2100000	\N	2024-02-15	83107	\N	\N	f	Qual by exam of deed	0
83108_11226.6_2012-02-03	1122660	\N	2012-02-03	83108	\N	\N	f	Qual by exam of deed	0
83108_15660.0_2017-04-24	1566000	\N	2017-04-24	83108	\N	\N	f	Qual by exam of deed	0
83108_17800.0_2014-12-12	1780000	\N	2014-12-12	83108	\N	\N	f	Qual by exam of deed	0
83108_21150.0_2023-08-08	2115000	\N	2023-08-08	83108	\N	\N	f	Qual by exam of deed	0
83109_11500.0_2012-02-03	1150000	\N	2012-02-03	83109	\N	\N	f	Qual by exam of deed	0
83109_18000.0_2022-04-21	1800000	\N	2022-04-21	83109	\N	\N	f	Qual by exam of deed	0
83110_12500.0_2012-01-11	1250000	\N	2012-01-11	83110	\N	\N	f	Qual by exam of deed	0
83110_16250.0_2021-09-13	1625000	\N	2021-09-13	83110	\N	\N	f	Qual by exam of deed	0
83111_13000.0_2012-02-03	1300000	\N	2012-02-03	83111	\N	\N	f	Qual by exam of deed	0
83111_15800.0_2021-09-05	1580000	\N	2021-09-05	83111	\N	\N	f	Qual by exam of deed	0
83112_12050.0_2012-03-15	1205000	\N	2012-03-15	83112	\N	\N	f	Qual by exam of deed	0
83113_12450.0_2019-04-02	1245000	\N	2019-04-02	83113	\N	\N	f	Qual by exam of deed	0
83113_14050.0_2011-08-22	1405000	\N	2011-08-22	83113	\N	\N	f	Qual by exam of deed	0
83114_10850.0_2019-05-01	1085000	\N	2019-05-01	83114	\N	\N	f	Qual by exam of deed	0
83114_12862.9_2012-06-28	1286290	\N	2012-06-28	83114	\N	\N	f	Qual by exam of deed	0
83115_13100.0_2012-02-15	1310000	\N	2012-02-15	83115	\N	\N	f	Qual by exam of deed	0
83116_14040.0_2012-08-27	1404000	\N	2012-08-27	83116	\N	\N	f	Qual by exam of deed	0
83117_23200.0_2012-02-01	2320000	\N	2012-02-01	83117	\N	\N	f	Qual by exam of deed	0
83118_12000.0_2009-06-15	1200000	\N	2009-06-15	83118	\N	\N	f	Qual by exam of deed	0
83120_18500.0_2018-07-23	1850000	\N	2018-07-23	83120	\N	\N	f	Qual by exam of deed	0
83120_18900.0_2012-01-20	1890000	\N	2012-01-20	83120	\N	\N	f	Qual by exam of deed	0
83121_19783.25_2012-03-08	1978325	\N	2012-03-08	83121	\N	\N	f	Qual by exam of deed	0
83121_23500.0_2018-04-30	2350000	\N	2018-04-30	83121	\N	\N	f	Qual by exam of deed	0
83121_33500.0_2022-03-25	3350000	\N	2022-03-25	83121	\N	\N	f	Qual by exam of deed	0
83122_20850.0_2012-12-18	2085000	\N	2012-12-18	83122	\N	\N	f	Qual by exam of deed	0
83123_20500.0_2013-02-04	2050000	\N	2013-02-04	83123	\N	\N	f	Qual by exam of deed	0
83123_20548.0_2021-05-04	2054800	\N	2021-05-04	83123	\N	\N	f	Qual by exam of deed	0
83123_27000.0_2013-06-14	2700000	\N	2013-06-14	83123	\N	\N	f	Qual by exam of deed	0
83124_11500.0_2013-09-25	1150000	\N	2013-09-25	83124	\N	\N	f	Qual by exam of deed	0
83124_14750.0_2023-05-31	1475000	\N	2023-05-31	83124	\N	\N	f	Qual by exam of deed	0
83124_8500.0_2013-08-30	850000	\N	2013-08-30	83124	\N	\N	f	Qual by exam of deed	0
83125_12500.0_2021-09-27	1250000	\N	2021-09-27	83125	\N	\N	f	Qual by exam of deed	0
83125_7900.0_2011-04-28	790000	\N	2011-04-28	83125	\N	\N	f	Qual by exam of deed	0
83126_12250.0_2014-05-30	1225000	\N	2014-05-30	83126	\N	\N	f	Qual by exam of deed	0
83126_8000.0_2020-10-28	800000	\N	2020-10-28	83126	\N	\N	f	Qual by exam of deed	0
83126_8100.0_2011-07-07	810000	\N	2011-07-07	83126	\N	\N	f	Qual by exam of deed	0
83127_14750.0_2022-07-08	1475000	\N	2022-07-08	83127	\N	\N	f	Qual by exam of deed	0
83127_19000.0_2024-03-04	1900000	\N	2024-03-04	83127	\N	\N	f	Qual by exam of deed	0
83127_7000.0_2010-06-18	700000	\N	2010-06-18	83127	\N	\N	f	Qual by exam of deed	0
83128_14250.0_2008-08-29	1425000	\N	2008-08-29	83128	\N	\N	f	Sales which are qualified	0
83128_14500.0_2023-06-01	1450000	\N	2023-06-01	83128	\N	\N	f	Qual by exam of deed	0
83129_9600.0_2012-09-17	960000	\N	2012-09-17	83129	\N	\N	f	Qual by exam of deed	0
83130_11750.0_2021-06-15	1175000	\N	2021-06-15	83130	\N	\N	f	Qual by exam of deed	0
83130_9450.0_2011-06-13	945000	\N	2011-06-13	83130	\N	\N	f	Qual by exam of deed	0
83131_10600.0_2012-04-27	1060000	\N	2012-04-27	83131	\N	\N	f	Qual by exam of deed	0
83131_14550.0_2013-09-13	1455000	\N	2013-09-13	83131	\N	\N	f	Qual by exam of deed	0
83131_14700.0_2015-12-01	1470000	\N	2015-12-01	83131	\N	\N	f	Qual by exam of deed	0
83132_9700.0_2012-02-06	970000	\N	2012-02-06	83132	\N	\N	f	Qual by exam of deed	0
83133_11025.0_2012-09-17	1102500	\N	2012-09-17	83133	\N	\N	f	Qual by exam of deed	0
83133_12000.0_2019-06-17	1200000	\N	2019-06-17	83133	\N	\N	f	Qual by exam of deed	0
83133_14990.0_2014-03-14	1499000	\N	2014-03-14	83133	\N	\N	f	Qual by exam of deed	0
83134_10750.0_2020-03-05	1075000	\N	2020-03-05	83134	\N	\N	f	Qual by exam of deed	0
83134_8890.0_2010-12-20	889000	\N	2010-12-20	83134	\N	\N	f	Qual by exam of deed	0
83135_12000.0_2008-10-10	1200000	\N	2008-10-10	83135	\N	\N	f	Sales which are qualified	0
83135_13200.0_2021-07-26	1320000	\N	2021-07-26	83135	\N	\N	f	Qual by exam of deed	0
83136_10650.0_2013-11-13	1065000	\N	2013-11-13	83136	\N	\N	f	Qual by exam of deed	0
83136_14750.0_2013-12-23	1475000	\N	2013-12-23	83136	\N	\N	f	Qual by exam of deed	0
83137_10400.0_2011-02-24	1040000	\N	2011-02-24	83137	\N	\N	f	Qual by exam of deed	0
83137_10850.0_2011-11-21	1085000	\N	2011-11-21	83137	\N	\N	f	Qual by exam of deed	0
83138_10300.0_2011-06-10	1030000	\N	2011-06-10	83138	\N	\N	f	Qual by exam of deed	0
83138_11000.0_2020-11-13	1100000	\N	2020-11-13	83138	\N	\N	f	Qual by exam of deed	0
83139_17395.0_2011-07-20	1739500	\N	2011-07-20	83139	\N	\N	f	Qual by exam of deed	0
83139_23000.0_2021-02-18	2300000	\N	2021-02-18	83139	\N	\N	f	Qual by exam of deed	0
83140_18500.0_2011-04-07	1850000	\N	2011-04-07	83140	\N	\N	f	Qual by exam of deed	0
83142_21750.0_2019-05-06	2175000	\N	2019-05-06	83142	\N	\N	f	Qual by exam of deed	0
83142_21850.0_2011-02-01	2185000	\N	2011-02-01	83142	\N	\N	f	Qual by exam of deed	0
83142_34500.0_2013-09-16	3450000	\N	2013-09-16	83142	\N	\N	f	Qual by exam of deed	0
83143_25000.0_2011-09-28	2500000	\N	2011-09-28	83143	\N	\N	f	Qual by exam of deed	0
83144_32000.0_2008-09-08	3200000	\N	2008-09-08	83144	\N	\N	f	Sales which are qualified	0
83144_35900.0_2013-04-05	3590000	\N	2013-04-05	83144	\N	\N	f	Qual by exam of deed	0
83144_39000.0_2015-06-09	3900000	\N	2015-06-09	83144	\N	\N	f	Qual by exam of deed	0
83145_28500.0_2013-06-11	2850000	\N	2013-06-11	83145	\N	\N	f	Qual by exam of deed	0
83145_30000.0_2021-05-04	3000000	\N	2021-05-04	83145	\N	\N	f	Qual by exam of deed	0
83146_3500.0_2018-04-19	350000	\N	2018-04-19	83146	\N	\N	f	Qual by exam of deed	0
83146_3900.0_2012-09-05	390000	\N	2012-09-05	83146	\N	\N	f	Qual by exam of deed	0
83146_5150.0_2023-01-19	515000	\N	2023-01-19	83146	\N	\N	f	Qual by exam of deed	0
83147_4005.0_2011-09-19	400500	\N	2011-09-19	83147	\N	\N	f	Qual by exam of deed	0
83148_3720.0_2012-04-24	372000	\N	2012-04-24	83148	\N	\N	f	Qual by exam of deed	0
83149_4000.0_2012-06-28	400000	\N	2012-06-28	83149	\N	\N	f	Qual by exam of deed	0
83149_4300.0_2018-05-08	430000	\N	2018-05-08	83149	\N	\N	f	Qual by exam of deed	0
83150_4140.0_2021-05-10	414000	\N	2021-05-10	83150	\N	\N	f	Qual by exam of deed	0
83150_4190.0_2012-04-09	419000	\N	2012-04-09	83150	\N	\N	f	Qual by exam of deed	0
83151_7250.0_2008-10-09	725000	\N	2008-10-09	83151	\N	\N	f	Sales which are qualified	0
83152_21000.0_2012-05-01	2100000	\N	2012-05-01	83152	\N	\N	t	Qual on DOS, multi-parcel sale	0
83152_4350.0_2018-10-29	435000	\N	2018-10-29	83152	\N	\N	f	Qual by exam of deed	0
83153_4800.0_2012-02-01	480000	\N	2012-02-01	83153	\N	\N	f	Qual by exam of deed	0
83154_4150.0_2012-05-29	415000	\N	2012-05-29	83154	\N	\N	f	Qual by exam of deed	0
83155_4880.0_2011-03-11	488000	\N	2011-03-11	83155	\N	\N	f	Qual by exam of deed	0
83156_4920.78_2012-02-10	492078	\N	2012-02-10	83156	\N	\N	f	Qual by exam of deed	0
83157_4883.15_2012-07-25	488315	\N	2012-07-25	83157	\N	\N	f	Qual by exam of deed	0
83157_5900.0_2012-12-27	590000	\N	2012-12-27	83157	\N	\N	f	Qual by exam of deed	0
83157_6100.0_2014-05-07	610000	\N	2014-05-07	83157	\N	\N	f	Qual by exam of deed	0
83158_8500.0_2008-09-19	850000	\N	2008-09-19	83158	\N	\N	f	Sales which are qualified	0
83159_10150.0_2008-09-23	1015000	\N	2008-09-23	83159	\N	\N	f	Sales which are qualified	0
83160_4880.0_2010-06-01	488000	\N	2010-06-01	83160	\N	\N	f	Qual by exam of deed	0
83160_6750.0_2020-01-03	675000	\N	2020-01-03	83160	\N	\N	f	Qual by exam of deed	0
83160_6800.0_2017-01-04	680000	\N	2017-01-04	83160	\N	\N	f	Qual by exam of deed	0
83161_12250.0_2023-03-08	1225000	\N	2023-03-08	83161	\N	\N	f	Qual by exam of deed	0
83161_8100.0_2015-09-22	810000	\N	2015-09-22	83161	\N	\N	f	Qual by exam of deed	0
83162_5850.0_2012-07-25	585000	\N	2012-07-25	83162	\N	\N	f	Qual by exam of deed	0
83163_5150.0_2011-06-30	515000	\N	2011-06-30	83163	\N	\N	f	Qual by exam of deed	0
83164_11750.0_2022-04-28	1175000	\N	2022-04-28	83164	\N	\N	f	Qual by exam of deed	0
83164_5300.0_2011-06-21	530000	\N	2011-06-21	83164	\N	\N	f	Qual by exam of deed	0
83164_8550.0_2016-10-31	855000	\N	2016-10-31	83164	\N	\N	f	Qual by exam of deed	0
83165_5948.8_2012-03-13	594880	\N	2012-03-13	83165	\N	\N	f	Qual by exam of deed	0
83165_9500.0_2015-01-12	950000	\N	2015-01-12	83165	\N	\N	f	Qual by exam of deed	0
83166_2750.0_2011-12-29	275000	\N	2011-12-29	83166	\N	\N	f	Qual by exam of deed	0
83166_6700.0_2021-03-30	670000	\N	2021-03-30	83166	\N	\N	f	Qual by exam of deed	0
83166_9500.0_2014-10-27	950000	\N	2014-10-27	83166	\N	\N	f	Qual by exam of deed	0
83167_11750.0_2023-03-20	1175000	\N	2023-03-20	83167	\N	\N	f	Qual by exam of deed	0
83167_6025.8_2012-02-14	602580	\N	2012-02-14	83167	\N	\N	f	Qual by exam of deed	0
83167_6750.0_2020-01-06	675000	\N	2020-01-06	83167	\N	\N	f	Qual by exam of deed	0
83167_6960.0_2021-06-29	696000	\N	2021-06-29	83167	\N	\N	f	Qual by exam of deed	0
83168_6414.75_2011-09-20	641475	\N	2011-09-20	83168	\N	\N	f	Qual by exam of deed	0
83168_9600.0_2014-10-03	960000	\N	2014-10-03	83168	\N	\N	f	Qual by exam of deed	0
83168_9790.0_2022-01-25	979000	\N	2022-01-25	83168	\N	\N	f	Qual by exam of deed	0
83169_7000.0_2012-01-25	700000	\N	2012-01-25	83169	\N	\N	f	Qual by exam of deed	0
83169_9375.0_2021-09-01	937500	\N	2021-09-01	83169	\N	\N	f	Qual by exam of deed	0
83170_10250.0_2022-02-08	1025000	\N	2022-02-08	83170	\N	\N	f	Qual by exam of deed	0
83170_6750.0_2012-01-11	675000	\N	2012-01-11	83170	\N	\N	f	Qual by exam of deed	0
83171_11000.0_2014-09-24	1100000	\N	2014-09-24	83171	\N	\N	f	Qual by exam of deed	0
83171_6965.0_2011-06-15	696500	\N	2011-06-15	83171	\N	\N	f	Qual by exam of deed	0
83171_7163.0_2021-01-22	716300	\N	2021-01-22	83171	\N	\N	f	Qual by exam of deed	0
83172_11000.0_2014-12-19	1100000	\N	2014-12-19	83172	\N	\N	f	Qual by exam of deed	0
83172_12784.0_2023-04-28	1278400	\N	2023-04-28	83172	\N	\N	f	Qual by exam of deed	0
83172_7000.0_2011-06-30	700000	\N	2011-06-30	83172	\N	\N	f	Qual by exam of deed	0
83173_7300.0_2012-03-19	730000	\N	2012-03-19	83173	\N	\N	f	Qual by exam of deed	0
83174_11250.0_2022-06-02	1125000	\N	2022-06-02	83174	\N	\N	f	Qual by exam of deed	0
83174_11750.0_2015-12-07	1175000	\N	2015-12-07	83174	\N	\N	f	Qual by exam of deed	0
83174_12500.0_2023-09-05	1250000	\N	2023-09-05	83174	\N	\N	f	Qual by exam of deed	0
83174_7200.0_2012-02-02	720000	\N	2012-02-02	83174	\N	\N	f	Qual by exam of deed	0
83175_10000.0_2014-09-04	1000000	\N	2014-09-04	83175	\N	\N	f	Qual by exam of deed	0
83175_11750.0_2022-04-13	1175000	\N	2022-04-13	83175	\N	\N	f	Qual by exam of deed	0
83175_8000.0_2011-10-18	800000	\N	2011-10-18	83175	\N	\N	f	Qual by exam of deed	0
83176_13000.0_2008-11-07	1300000	\N	2008-11-07	83176	\N	\N	f	Sales which are qualified	0
83177_8650.0_2012-03-07	865000	\N	2012-03-07	83177	\N	\N	f	Qual by exam of deed	0
83178_13750.0_2008-09-22	1375000	\N	2008-09-22	83178	\N	\N	f	Sales which are qualified	0
82608_6500.0_2008-03-01	650000	\N	2008-03-01	82608	\N	\N	f	Sales which are qualified	0
82609_5287.0_2008-11-25	528700	\N	2008-11-25	82609	\N	\N	f	Sales which are qualified	0
82609_7150.0_2012-11-05	715000	\N	2012-11-05	82609	\N	\N	f	Qual by exam of deed	0
82610_5950.0_2020-03-30	595000	\N	2020-03-30	82610	\N	\N	f	Qual by exam of deed	0
82610_6500.0_2008-02-01	650000	\N	2008-02-01	82610	\N	\N	f	Sales which are qualified	0
82611_3300.0_2008-01-01	330000	\N	2008-01-01	82611	\N	\N	f	Sales which are qualified	0
82611_4525.0_2014-03-27	452500	\N	2014-03-27	82611	\N	\N	f	Qual by exam of deed	0
82611_4600.0_2022-06-29	460000	\N	2022-06-29	82611	\N	\N	f	Qual by exam of deed	0
82612_2254.31_2011-05-18	225431	\N	2011-05-18	82612	\N	\N	f	Qual by exam of deed	0
82612_3500.0_2007-12-01	350000	\N	2007-12-01	82612	\N	\N	f	Sales which are qualified	0
82612_4250.0_2015-10-02	425000	\N	2015-10-02	82612	\N	\N	f	Qual by exam of deed	0
82613_3800.0_2008-01-01	380000	\N	2008-01-01	82613	\N	\N	f	Sales which are qualified	0
82613_4100.0_2021-09-21	410000	\N	2021-09-21	82613	\N	\N	f	Qual by exam of deed	0
82613_5300.0_2023-06-05	530000	\N	2023-06-05	82613	\N	\N	f	Qual by exam of deed	0
82613_5500.0_2013-07-26	550000	\N	2013-07-26	82613	\N	\N	f	Qual by exam of deed	0
82614_3250.0_2011-07-05	325000	\N	2011-07-05	82614	\N	\N	f	Qual by exam of deed	0
82615_3800.0_2007-12-01	380000	\N	2007-12-01	82615	\N	\N	f	Sales which are qualified	0
82616_3040.0_2008-09-04	304000	\N	2008-09-04	82616	\N	\N	f	Sales which are qualified	0
82617_3600.0_2011-03-11	360000	\N	2011-03-11	82617	\N	\N	f	Qual by exam of deed	0
82617_4800.0_2013-04-12	480000	\N	2013-04-12	82617	\N	\N	f	Qual by exam of deed	0
82618_4050.0_2021-07-19	405000	\N	2021-07-19	82618	\N	\N	f	Qual by exam of deed	0
82618_4100.0_2007-12-01	410000	\N	2007-12-01	82618	\N	\N	f	Sales which are qualified	0
82619_4400.0_2021-09-02	440000	\N	2021-09-02	82619	\N	\N	f	Qual by exam of deed	0
82619_4750.0_2008-01-01	475000	\N	2008-01-01	82619	\N	\N	f	Sales which are qualified	0
82619_6425.0_2014-03-05	642500	\N	2014-03-05	82619	\N	\N	f	Qual by exam of deed	0
82620_4300.0_2007-12-01	430000	\N	2007-12-01	82620	\N	\N	f	Sales which are qualified	0
82620_5500.0_2022-03-31	550000	\N	2022-03-31	82620	\N	\N	f	Qual by exam of deed	0
82621_3690.0_2011-03-18	369000	\N	2011-03-18	82621	\N	\N	f	Qual by exam of deed	0
82621_4650.0_2018-07-27	465000	\N	2018-07-27	82621	\N	\N	f	Qual by exam of deed	0
82621_6150.0_2013-07-05	615000	\N	2013-07-05	82621	\N	\N	f	Qual by exam of deed	0
82622_4750.0_2019-08-22	475000	\N	2019-08-22	82622	\N	\N	f	Qual by exam of deed	0
82622_6500.0_2007-12-01	650000	\N	2007-12-01	82622	\N	\N	f	Sales which are qualified	0
82623_6150.0_2023-01-23	615000	\N	2023-01-23	82623	\N	\N	f	Qual by exam of deed	0
82623_7500.0_2007-12-10	750000	\N	2007-12-10	82623	\N	\N	f	Sales which are qualified	0
82624_25000.0_2010-05-25	2500000	\N	2010-05-25	82624	\N	\N	t	Qual on DOS, multi-parcel sale	0
82624_31500.0_2021-04-12	3150000	\N	2021-04-12	82624	\N	\N	t	Qual on DOS, multi-parcel sale	0
82625_19900.0_2010-11-02	1990000	\N	2010-11-02	82625	\N	\N	t	Qual on DOS, multi-parcel sale	0
82625_29500.0_2013-01-25	2950000	\N	2013-01-25	82625	\N	\N	f	Qual by exam of deed	0
82626_3500.0_2020-12-09	350000	\N	2020-12-09	82626	\N	\N	f	Qual by exam of deed	0
82626_6000.0_2008-03-19	600000	\N	2008-03-19	82626	\N	\N	f	Sales which are qualified	0
82627_5300.0_2008-04-01	530000	\N	2008-04-01	82627	\N	\N	f	Sales which are qualified	0
82627_5950.0_2021-04-16	595000	\N	2021-04-16	82627	\N	\N	f	Qual by exam of deed	0
82628_5000.0_2009-04-06	500000	\N	2009-04-06	82628	\N	\N	f	Qual by exam of deed	0
82628_5960.0_2009-01-16	596000	\N	2009-01-16	82628	\N	\N	f	Qual by exam of deed	0
82629_5500.0_2008-05-01	550000	\N	2008-05-01	82629	\N	\N	f	Sales which are qualified	0
82630_6500.0_2008-02-01	650000	\N	2008-02-01	82630	\N	\N	f	Sales which are qualified	0
82630_7650.0_2012-10-23	765000	\N	2012-10-23	82630	\N	\N	f	Qual by exam of deed	0
82631_5850.0_2010-03-01	585000	\N	2010-03-01	82631	\N	\N	f	Qual by exam of deed	0
82632_14000.0_2013-08-29	1400000	\N	2013-08-29	82632	\N	\N	f	Qual by exam of deed	0
82632_8325.0_2011-10-24	832500	\N	2011-10-24	82632	\N	\N	f	Qual by exam of deed	0
82632_9600.0_2007-12-01	960000	\N	2007-12-01	82632	\N	\N	f	Sales which are qualified	0
82633_10000.0_2008-11-21	1000000	\N	2008-11-21	82633	\N	\N	f	Sales which are qualified	0
82633_13000.0_2016-03-25	1300000	\N	2016-03-25	82633	\N	\N	f	Qual by exam of deed	0
82634_10750.0_2012-10-24	1075000	\N	2012-10-24	82634	\N	\N	f	Qual by exam of deed	0
82634_9000.0_2008-06-18	900000	\N	2008-06-18	82634	\N	\N	f	Sales which are qualified	0
82635_13850.0_2016-08-03	1385000	\N	2016-08-03	82635	\N	\N	f	Qual by exam of deed	0
82635_8850.0_2010-07-08	885000	\N	2010-07-08	82635	\N	\N	f	Qual by exam of deed	0
82636_7400.0_2008-09-04	740000	\N	2008-09-04	82636	\N	\N	f	Sales which are qualified	0
82637_13425.0_2017-07-20	1342500	\N	2017-07-20	82637	\N	\N	f	Qual by exam of deed	0
82637_9750.0_2008-07-01	975000	\N	2008-07-01	82637	\N	\N	f	Sales which are qualified	0
82638_14700.0_2015-07-17	1470000	\N	2015-07-17	82638	\N	\N	f	Qual by exam of deed	0
82638_9000.0_2008-07-18	900000	\N	2008-07-18	82638	\N	\N	f	Sales which are qualified	0
82639_13000.0_2020-04-07	1300000	\N	2020-04-07	82639	\N	\N	f	Qual by exam of deed	0
82639_13800.0_2021-04-15	1380000	\N	2021-04-15	82639	\N	\N	f	Qual by exam of deed	0
82639_14000.0_2008-04-01	1400000	\N	2008-04-01	82639	\N	\N	f	Sales which are qualified	0
82639_15000.0_2013-05-07	1500000	\N	2013-05-07	82639	\N	\N	f	Qual by exam of deed	0
82640_12500.0_2008-06-01	1250000	\N	2008-06-01	82640	\N	\N	f	Sales which are qualified	0
82640_8990.0_2011-03-03	899000	\N	2011-03-03	82640	\N	\N	f	Qual by exam of deed	0
82641_9400.0_2008-07-01	940000	\N	2008-07-01	82641	\N	\N	f	Sales which are qualified	0
82642_20000.0_2007-12-01	2000000	\N	2007-12-01	82642	\N	\N	f	Sales which are qualified	0
82642_20000.0_2019-09-20	2000000	\N	2019-09-20	82642	\N	\N	f	Qual by exam of deed	0
82643_19000.0_2008-07-01	1900000	\N	2008-07-01	82643	\N	\N	f	Sales which are qualified	0
82644_25000.0_2010-05-25	2500000	\N	2010-05-25	82644	\N	\N	t	Qual on DOS, multi-parcel sale	0
82644_29212.47_2009-10-08	2921247	\N	2009-10-08	82644	\N	\N	f	Qual by exam of deed	0
82644_31500.0_2021-04-12	3150000	\N	2021-04-12	82644	\N	\N	t	Qual on DOS, multi-parcel sale	0
82645_5853.5_2008-04-01	585350	\N	2008-04-01	82645	\N	\N	f	Sales which are qualified	0
82645_7000.0_2012-12-27	700000	\N	2012-12-27	82645	\N	\N	f	Qual by exam of deed	0
82645_7000.0_2021-04-20	700000	\N	2021-04-20	82645	\N	\N	f	Qual by exam of deed	0
82646_5950.0_2008-04-01	595000	\N	2008-04-01	82646	\N	\N	f	Sales which are qualified	0
82646_8500.0_2022-02-28	850000	\N	2022-02-28	82646	\N	\N	f	Qual by exam of deed	0
82647_6250.0_2008-09-12	625000	\N	2008-09-12	82647	\N	\N	f	Sales which are qualified	0
82647_6400.0_2012-08-06	640000	\N	2012-08-06	82647	\N	\N	f	Qual by exam of deed	0
82647_6900.0_2019-05-10	690000	\N	2019-05-10	82647	\N	\N	f	Qual by exam of deed	0
82648_5500.0_2009-07-01	550000	\N	2009-07-01	82648	\N	\N	f	Qual by exam of deed	0
82648_5600.0_2008-02-25	560000	\N	2008-02-25	82648	\N	\N	f	Sales which are qualified	0
82649_6284.25_2008-10-10	628425	\N	2008-10-10	82649	\N	\N	f	Sales which are qualified	0
82650_3092.5_2010-11-05	309250	\N	2010-11-05	82650	\N	\N	f	Qual by exam of deed	0
82650_3950.0_2018-04-20	395000	\N	2018-04-20	82650	\N	\N	f	Qual by exam of deed	0
82651_3400.0_2010-10-08	340000	\N	2010-10-08	82651	\N	\N	f	Qual by exam of deed	0
82651_5500.0_2007-12-01	550000	\N	2007-12-01	82651	\N	\N	f	Sales which are qualified	0
82652_4760.0_2011-05-23	476000	\N	2011-05-23	82652	\N	\N	f	Qual by exam of deed	0
82653_5000.0_2019-05-02	500000	\N	2019-05-02	82653	\N	\N	f	Qual by exam of deed	0
82653_5250.0_2007-12-01	525000	\N	2007-12-01	82653	\N	\N	f	Sales which are qualified	0
82653_5650.0_2012-01-18	565000	\N	2012-01-18	82653	\N	\N	f	Qual by exam of deed	0
82653_5650.0_2020-09-10	565000	\N	2020-09-10	82653	\N	\N	f	Qual by exam of deed	0
82653_6000.0_2007-12-01	600000	\N	2007-12-01	82653	\N	\N	f	Sales which are qualified	0
82653_6290.0_2012-07-16	629000	\N	2012-07-16	82653	\N	\N	f	Qual by exam of deed	0
82654_5750.0_2008-01-01	575000	\N	2008-01-01	82654	\N	\N	f	Sales which are qualified	0
82654_6250.0_2018-02-28	625000	\N	2018-02-28	82654	\N	\N	f	Qual by exam of deed	0
82655_10000.0_2022-02-28	1000000	\N	2022-02-28	82655	\N	\N	f	Qual by exam of deed	0
82655_5000.0_2007-12-01	500000	\N	2007-12-01	82655	\N	\N	f	Sales which are qualified	0
82655_6100.0_2018-01-30	610000	\N	2018-01-30	82655	\N	\N	f	Qual by exam of deed	0
82656_4650.0_2007-12-01	465000	\N	2007-12-01	82656	\N	\N	f	Sales which are qualified	0
82656_4800.0_2011-04-05	480000	\N	2011-04-05	82656	\N	\N	f	Qual by exam of deed	0
82656_8764.26_2014-10-21	876426	\N	2014-10-21	82656	\N	\N	f	Qual by exam of deed	0
82657_7300.0_2008-05-01	730000	\N	2008-05-01	82657	\N	\N	f	Sales which are qualified	0
82657_8600.0_2015-08-26	860000	\N	2015-08-26	82657	\N	\N	f	Qual by exam of deed	0
82658_8000.0_2008-03-01	800000	\N	2008-03-01	82658	\N	\N	f	Sales which are qualified	0
82659_5250.0_2010-01-04	525000	\N	2010-01-04	82659	\N	\N	f	Qual by exam of deed	0
82659_6400.0_2009-01-07	640000	\N	2009-01-07	82659	\N	\N	f	Qual by exam of deed	0
82660_15000.0_2012-06-01	1500000	\N	2012-06-01	82660	\N	\N	f	Qual by exam of deed	0
82660_22500.0_2008-04-01	2250000	\N	2008-04-01	82660	\N	\N	f	Sales which are qualified	0
82661_17000.0_2008-06-01	1700000	\N	2008-06-01	82661	\N	\N	f	Sales which are qualified	0
82661_24800.0_2013-03-13	2480000	\N	2013-03-13	82661	\N	\N	f	Qual by exam of deed	0
82662_13750.0_2011-05-26	1375000	\N	2011-05-26	82662	\N	\N	f	Qual by exam of deed	0
82662_21000.0_2008-04-01	2100000	\N	2008-04-01	82662	\N	\N	f	Sales which are qualified	0
82662_25500.0_2014-11-26	2550000	\N	2014-11-26	82662	\N	\N	f	Qual by exam of deed	0
82663_21500.0_2015-05-07	2150000	\N	2015-05-07	82663	\N	\N	f	Qual by exam of deed	0
82663_41225.0_2012-05-21	4122500	\N	2012-05-21	82663	\N	\N	t	Qual on DOS, multi-parcel sale	0
82664_20000.0_2008-02-01	2000000	\N	2008-02-01	82664	\N	\N	f	Sales which are qualified	0
82664_34500.0_2023-01-13	3450000	\N	2023-01-13	82664	\N	\N	f	Qual by exam of deed	0
82664_36000.0_2016-05-12	3600000	\N	2016-05-12	82664	\N	\N	f	Qual by exam of deed	0
82665_3550.0_2010-08-31	355000	\N	2010-08-31	82665	\N	\N	f	Qual by exam of deed	0
82666_11450.0_2014-01-27	1145000	\N	2014-01-27	82666	\N	\N	f	Qual by exam of deed	0
82666_6000.0_2010-02-18	600000	\N	2010-02-18	82666	\N	\N	f	Qual by exam of deed	0
82667_15750.0_2022-06-10	1575000	\N	2022-06-10	82667	\N	\N	f	Qual by exam of deed	0
82667_7250.0_2010-05-07	725000	\N	2010-05-07	82667	\N	\N	f	Qual by exam of deed	0
82667_7250.0_2011-04-08	725000	\N	2011-04-08	82667	\N	\N	f	Qual by exam of deed	0
82667_8500.0_2021-05-07	850000	\N	2021-05-07	82667	\N	\N	f	Qual by exam of deed	0
82668_12500.0_2013-09-09	1250000	\N	2013-09-09	82668	\N	\N	f	Qual by exam of deed	0
82668_8500.0_2008-01-01	850000	\N	2008-01-01	82668	\N	\N	f	Sales which are qualified	0
82669_11500.0_2015-02-11	1150000	\N	2015-02-11	82669	\N	\N	f	Qual by exam of deed	0
82669_7100.0_2008-01-01	710000	\N	2008-01-01	82669	\N	\N	f	Sales which are qualified	0
82669_7993.0_2012-02-09	799300	\N	2012-02-09	82669	\N	\N	f	Qual by exam of deed	0
82670_6600.0_2009-05-04	660000	\N	2009-05-04	82670	\N	\N	f	Qual by exam of deed	0
82670_7150.0_2008-04-01	715000	\N	2008-04-01	82670	\N	\N	f	Sales which are qualified	0
82671_6526.5_2009-10-06	652650	\N	2009-10-06	82671	\N	\N	f	Qual by exam of deed	0
82671_8750.0_2010-06-24	875000	\N	2010-06-24	82671	\N	\N	f	Qual by exam of deed	0
82671_9000.0_2009-05-07	900000	\N	2009-05-07	82671	\N	\N	f	Qual by exam of deed	0
82672_10650.0_2020-03-30	1065000	\N	2020-03-30	82672	\N	\N	f	Qual by exam of deed	0
82672_11500.0_2015-02-26	1150000	\N	2015-02-26	82672	\N	\N	f	Qual by exam of deed	0
82672_14000.0_2021-06-17	1400000	\N	2021-06-17	82672	\N	\N	f	Qual by exam of deed	0
82672_8000.0_2008-07-01	800000	\N	2008-07-01	82672	\N	\N	f	Sales which are qualified	0
82673_11500.0_2013-02-25	1150000	\N	2013-02-25	82673	\N	\N	f	Qual by exam of deed	0
82673_11700.0_2018-10-25	1170000	\N	2018-10-25	82673	\N	\N	f	Qual by exam of deed	0
82673_13950.0_2021-12-27	1395000	\N	2021-12-27	82673	\N	\N	f	Qual by exam of deed	0
82673_7000.0_2007-12-01	700000	\N	2007-12-01	82673	\N	\N	f	Sales which are qualified	0
82673_8000.0_2008-06-01	800000	\N	2008-06-01	82673	\N	\N	f	Sales which are qualified	0
82674_6690.0_2009-09-16	669000	\N	2009-09-16	82674	\N	\N	f	Qual by exam of deed	0
82674_9500.0_2008-04-01	950000	\N	2008-04-01	82674	\N	\N	f	Sales which are qualified	0
82675_11000.0_2021-07-01	1100000	\N	2021-07-01	82675	\N	\N	f	Qual by exam of deed	0
82675_9750.0_2008-01-01	975000	\N	2008-01-01	82675	\N	\N	f	Sales which are qualified	0
82675_9890.0_2012-10-15	989000	\N	2012-10-15	82675	\N	\N	f	Qual by exam of deed	0
82676_11000.0_2008-01-01	1100000	\N	2008-01-01	82676	\N	\N	f	Sales which are qualified	0
82677_10000.0_2008-12-18	1000000	\N	2008-12-18	82677	\N	\N	f	Sales which are qualified	0
82678_8250.0_2008-12-30	825000	\N	2008-12-30	82678	\N	\N	f	Sales which are qualified	0
82679_9500.0_2008-06-01	950000	\N	2008-06-01	82679	\N	\N	f	Sales which are qualified	0
82680_10000.0_2011-01-07	1000000	\N	2011-01-07	82680	\N	\N	f	Qual by exam of deed	0
82681_17000.0_2008-07-01	1700000	\N	2008-07-01	82681	\N	\N	f	Sales which are qualified	0
82681_24000.0_2013-04-10	2400000	\N	2013-04-10	82681	\N	\N	f	Qual by exam of deed	0
82682_18864.0_2008-03-01	1886400	\N	2008-03-01	82682	\N	\N	f	Sales which are qualified	0
82683_20650.0_2013-07-30	2065000	\N	2013-07-30	82683	\N	\N	f	Qual by exam of deed	0
82683_21225.0_2018-11-02	2122500	\N	2018-11-02	82683	\N	\N	f	Qual by exam of deed	0
82683_41225.0_2012-05-21	4122500	\N	2012-05-21	82683	\N	\N	t	Qual on DOS, multi-parcel sale	0
82684_15500.0_2010-02-22	1550000	\N	2010-02-22	82684	\N	\N	f	Qual by exam of deed	0
82684_19650.0_2008-04-01	1965000	\N	2008-04-01	82684	\N	\N	f	Sales which are qualified	0
82684_23750.0_2021-03-24	2375000	\N	2021-03-24	82684	\N	\N	f	Qual by exam of deed	0
82685_11000.0_2023-04-04	1100000	\N	2023-04-04	82685	\N	\N	f	Qual by exam of deed	0
82685_9750.0_2008-03-01	975000	\N	2008-03-01	82685	\N	\N	f	Sales which are qualified	0
82686_11000.0_2007-12-01	1100000	\N	2007-12-01	82686	\N	\N	f	Sales which are qualified	0
82687_11000.0_2019-11-07	1100000	\N	2019-11-07	82687	\N	\N	f	Qual by exam of deed	0
82687_9350.0_2010-03-05	935000	\N	2010-03-05	82687	\N	\N	f	Qual by exam of deed	0
82688_11750.0_2013-03-15	1175000	\N	2013-03-15	82688	\N	\N	f	Qual by exam of deed	0
82688_12000.0_2018-05-31	1200000	\N	2018-05-31	82688	\N	\N	f	Qual by exam of deed	0
82688_16750.0_2022-05-16	1675000	\N	2022-05-16	82688	\N	\N	f	Qual by exam of deed	0
82688_9166.75_2008-05-07	916675	\N	2008-05-07	82688	\N	\N	f	Sales which are qualified	0
82689_12000.0_2018-05-17	1200000	\N	2018-05-17	82689	\N	\N	f	Qual by exam of deed	0
82689_14000.0_2013-04-22	1400000	\N	2013-04-22	82689	\N	\N	f	Qual by exam of deed	0
82689_9450.0_2008-06-01	945000	\N	2008-06-01	82689	\N	\N	f	Sales which are qualified	0
82690_7500.0_2007-12-01	750000	\N	2007-12-01	82690	\N	\N	f	Sales which are qualified	0
82690_8400.0_2010-11-08	840000	\N	2010-11-08	82690	\N	\N	f	Qual by exam of deed	0
82691_11250.0_2019-11-01	1125000	\N	2019-11-01	82691	\N	\N	f	Qual by exam of deed	0
82691_13625.0_2017-01-10	1362500	\N	2017-01-10	82691	\N	\N	f	Qual by exam of deed	0
82691_8700.0_2010-04-09	870000	\N	2010-04-09	82691	\N	\N	f	Qual by exam of deed	0
82692_9000.0_2007-12-01	900000	\N	2007-12-01	82692	\N	\N	f	Sales which are qualified	0
82692_9800.0_2008-10-31	980000	\N	2008-10-31	82692	\N	\N	f	Sales which are qualified	0
82693_12250.0_2016-10-02	1225000	\N	2016-10-02	82693	\N	\N	f	Qual by exam of deed	0
82693_7700.0_2007-12-01	770000	\N	2007-12-01	82693	\N	\N	f	Sales which are qualified	0
82693_8625.0_2009-05-07	862500	\N	2009-05-07	82693	\N	\N	f	Qual by exam of deed	0
82694_9600.0_2008-06-01	960000	\N	2008-06-01	82694	\N	\N	f	Sales which are qualified	0
82695_10000.0_2008-08-22	1000000	\N	2008-08-22	82695	\N	\N	f	Sales which are qualified	0
82695_13000.0_2021-01-25	1300000	\N	2021-01-25	82695	\N	\N	f	Qual by exam of deed	0
82696_13000.0_2012-07-28	1300000	\N	2012-07-28	82696	\N	\N	f	Qual by exam of deed	0
82696_9250.0_2008-05-01	925000	\N	2008-05-01	82696	\N	\N	f	Sales which are qualified	0
82697_13010.0_2012-05-07	1301000	\N	2012-05-07	82697	\N	\N	f	Qual by exam of deed	0
82697_13600.0_2017-11-30	1360000	\N	2017-11-30	82697	\N	\N	f	Qual by exam of deed	0
82697_16000.0_2021-04-13	1600000	\N	2021-04-13	82697	\N	\N	f	Qual by exam of deed	0
82697_16000.0_2023-05-10	1600000	\N	2023-05-10	82697	\N	\N	f	Qual by exam of deed	0
82697_9500.0_2008-07-16	950000	\N	2008-07-16	82697	\N	\N	f	Sales which are qualified	0
82698_10000.0_2010-05-27	1000000	\N	2010-05-27	82698	\N	\N	f	Qual by exam of deed	0
82698_11500.0_2008-04-02	1150000	\N	2008-04-02	82698	\N	\N	f	Sales which are qualified	0
82698_13000.0_2012-02-27	1300000	\N	2012-02-27	82698	\N	\N	f	Qual by exam of deed	0
82698_16150.0_2013-06-14	1615000	\N	2013-06-14	82698	\N	\N	f	Qual by exam of deed	0
82698_8110.0_2008-04-01	811000	\N	2008-04-01	82698	\N	\N	f	Sales which are qualified	0
82699_13000.0_2008-06-01	1300000	\N	2008-06-01	82699	\N	\N	f	Sales which are qualified	0
82699_16000.0_2013-12-19	1600000	\N	2013-12-19	82699	\N	\N	f	Qual by exam of deed	0
82700_11750.0_2010-07-29	1175000	\N	2010-07-29	82700	\N	\N	f	Qual by exam of deed	0
82701_22000.0_2008-04-01	2200000	\N	2008-04-01	82701	\N	\N	f	Sales which are qualified	0
82702_15000.0_2010-06-24	1500000	\N	2010-06-24	82702	\N	\N	f	Qual by exam of deed	0
82703_19150.0_2019-12-16	1915000	\N	2019-12-16	82703	\N	\N	f	Qual by exam of deed	0
82703_20650.0_2015-05-19	2065000	\N	2015-05-19	82703	\N	\N	f	Qual by exam of deed	0
82703_41225.0_2012-05-21	4122500	\N	2012-05-21	82703	\N	\N	t	Qual on DOS, multi-parcel sale	0
82704_16000.0_2011-12-27	1600000	\N	2011-12-27	82704	\N	\N	f	Qual by exam of deed	0
82704_21400.0_2008-04-28	2140000	\N	2008-04-28	82704	\N	\N	f	Sales which are qualified	0
82705_3500.0_2010-06-29	350000	\N	2010-06-29	82705	\N	\N	f	Qual by exam of deed	0
82705_4150.0_2011-06-24	415000	\N	2011-06-24	82705	\N	\N	f	Qual by exam of deed	0
82705_5180.0_2021-05-04	518000	\N	2021-05-04	82705	\N	\N	f	Qual by exam of deed	0
82705_5500.0_2007-12-01	550000	\N	2007-12-01	82705	\N	\N	f	Sales which are qualified	0
82706_5250.0_2007-12-01	525000	\N	2007-12-01	82706	\N	\N	f	Sales which are qualified	0
82706_8250.0_2014-04-24	825000	\N	2014-04-24	82706	\N	\N	f	Qual by exam of deed	0
82707_5300.0_2021-03-18	530000	\N	2021-03-18	82707	\N	\N	f	Qual by exam of deed	0
82707_6500.0_2008-11-18	650000	\N	2008-11-18	82707	\N	\N	f	Sales which are qualified	0
82707_7500.0_2013-04-08	750000	\N	2013-04-08	82707	\N	\N	f	Qual by exam of deed	0
82708_5150.0_2012-08-30	515000	\N	2012-08-30	82708	\N	\N	f	Qual by exam of deed	0
82708_5850.0_2008-03-01	585000	\N	2008-03-01	82708	\N	\N	f	Sales which are qualified	0
82708_6150.0_2013-03-04	615000	\N	2013-03-04	82708	\N	\N	f	Qual by exam of deed	0
82708_7300.0_2015-09-24	730000	\N	2015-09-24	82708	\N	\N	f	Qual by exam of deed	0
82709_5200.0_2020-12-01	520000	\N	2020-12-01	82709	\N	\N	f	Qual by exam of deed	0
82709_5450.0_2008-06-01	545000	\N	2008-06-01	82709	\N	\N	f	Sales which are qualified	0
82710_6250.0_2007-12-01	625000	\N	2007-12-01	82710	\N	\N	f	Sales which are qualified	0
82710_7525.0_2015-04-20	752500	\N	2015-04-20	82710	\N	\N	f	Qual by exam of deed	0
82711_4550.0_2010-10-29	455000	\N	2010-10-29	82711	\N	\N	f	Qual by exam of deed	0
82712_5750.0_2008-05-01	575000	\N	2008-05-01	82712	\N	\N	f	Sales which are qualified	0
82712_6550.0_2013-02-08	655000	\N	2013-02-08	82712	\N	\N	f	Qual by exam of deed	0
82712_7325.0_2021-12-10	732500	\N	2021-12-10	82712	\N	\N	f	Qual by exam of deed	0
82712_9250.0_2013-08-26	925000	\N	2013-08-26	82712	\N	\N	f	Qual by exam of deed	0
82713_5850.0_2008-05-01	585000	\N	2008-05-01	82713	\N	\N	f	Sales which are qualified	0
82713_6650.0_2021-09-24	665000	\N	2021-09-24	82713	\N	\N	f	Qual by exam of deed	0
82713_8800.0_2022-06-10	880000	\N	2022-06-10	82713	\N	\N	f	Qual by exam of deed	0
82714_5050.0_2011-04-18	505000	\N	2011-04-18	82714	\N	\N	f	Qual by exam of deed	0
82714_5950.0_2008-01-01	595000	\N	2008-01-01	82714	\N	\N	f	Sales which are qualified	0
82714_6980.0_2017-06-28	698000	\N	2017-06-28	82714	\N	\N	f	Qual by exam of deed	0
82714_8850.0_2022-07-18	885000	\N	2022-07-18	82714	\N	\N	f	Qual by exam of deed	0
82715_5760.0_2019-09-11	576000	\N	2019-09-11	82715	\N	\N	f	Qual by exam of deed	0
82715_6550.0_2008-10-17	655000	\N	2008-10-17	82715	\N	\N	f	Sales which are qualified	0
82715_6950.0_2007-12-01	695000	\N	2007-12-01	82715	\N	\N	f	Sales which are qualified	0
82716_6150.0_2010-01-21	615000	\N	2010-01-21	82716	\N	\N	f	Qual by exam of deed	0
82716_8050.0_2015-04-02	805000	\N	2015-04-02	82716	\N	\N	f	Qual by exam of deed	0
82717_5400.0_2011-02-15	540000	\N	2011-02-15	82717	\N	\N	f	Qual by exam of deed	0
82717_9250.0_2013-09-30	925000	\N	2013-09-30	82717	\N	\N	f	Qual by exam of deed	0
82718_6490.0_2007-12-01	649000	\N	2007-12-01	82718	\N	\N	f	Sales which are qualified	0
82718_6750.0_2021-07-06	675000	\N	2021-07-06	82718	\N	\N	f	Qual by exam of deed	0
82720_3900.0_2007-12-01	390000	\N	2007-12-01	82720	\N	\N	f	Sales which are qualified	0
82720_4400.0_2016-09-08	440000	\N	2016-09-08	82720	\N	\N	f	Qual by exam of deed	0
82720_5200.0_2008-03-01	520000	\N	2008-03-01	82720	\N	\N	f	Sales which are qualified	0
82721_2900.0_2011-06-21	290000	\N	2011-06-21	82721	\N	\N	f	Qual by exam of deed	0
82721_5250.0_2008-06-01	525000	\N	2008-06-01	82721	\N	\N	f	Sales which are qualified	0
82721_6500.0_2023-10-12	650000	\N	2023-10-12	82721	\N	\N	f	Qual by exam of deed	0
82722_4300.0_2008-04-01	430000	\N	2008-04-01	82722	\N	\N	f	Sales which are qualified	0
82722_5200.0_2012-08-06	520000	\N	2012-08-06	82722	\N	\N	f	Qual by exam of deed	0
82722_6400.0_2015-05-13	640000	\N	2015-05-13	82722	\N	\N	f	Qual by exam of deed	0
82723_3750.0_2009-10-29	375000	\N	2009-10-29	82723	\N	\N	f	Qual by exam of deed	0
82724_4700.0_2008-05-01	470000	\N	2008-05-01	82724	\N	\N	f	Sales which are qualified	0
82724_6500.0_2013-09-06	650000	\N	2013-09-06	82724	\N	\N	f	Qual by exam of deed	0
82725_3800.0_2008-03-01	380000	\N	2008-03-01	82725	\N	\N	f	Sales which are qualified	0
82725_4075.0_2021-06-28	407500	\N	2021-06-28	82725	\N	\N	f	Qual by exam of deed	0
82725_4500.0_2015-09-02	450000	\N	2015-09-02	82725	\N	\N	f	Qual by exam of deed	0
82725_5000.0_2008-03-01	500000	\N	2008-03-01	82725	\N	\N	f	Sales which are qualified	0
82726_4500.0_2010-05-17	450000	\N	2010-05-17	82726	\N	\N	f	Qual by exam of deed	0
82727_4500.0_2008-05-01	450000	\N	2008-05-01	82727	\N	\N	f	Sales which are qualified	0
82727_4820.0_2012-11-06	482000	\N	2012-11-06	82727	\N	\N	f	Qual by exam of deed	0
82727_5075.0_2019-09-19	507500	\N	2019-09-19	82727	\N	\N	f	Qual by exam of deed	0
82727_6250.0_2015-04-08	625000	\N	2015-04-08	82727	\N	\N	f	Qual by exam of deed	0
82727_6600.0_2022-09-22	660000	\N	2022-09-22	82727	\N	\N	f	Qual by exam of deed	0
82728_4600.0_2008-04-01	460000	\N	2008-04-01	82728	\N	\N	f	Sales which are qualified	0
82728_5750.0_2015-06-29	575000	\N	2015-06-29	82728	\N	\N	f	Qual by exam of deed	0
82728_5990.0_2013-09-05	599000	\N	2013-09-05	82728	\N	\N	f	Qual by exam of deed	0
82729_4200.0_2010-08-20	420000	\N	2010-08-20	82729	\N	\N	f	Qual by exam of deed	0
82730_3100.0_2017-06-20	310000	\N	2017-06-20	82730	\N	\N	f	Qual by exam of deed	0
82730_4050.0_2021-08-04	405000	\N	2021-08-04	82730	\N	\N	f	Qual by exam of deed	0
82731_4000.0_2008-07-01	400000	\N	2008-07-01	82731	\N	\N	f	Sales which are qualified	0
82731_4400.0_2020-03-26	440000	\N	2020-03-26	82731	\N	\N	f	Qual by exam of deed	0
82731_4790.0_2013-08-06	479000	\N	2013-08-06	82731	\N	\N	f	Qual by exam of deed	0
82732_3900.0_2008-05-01	390000	\N	2008-05-01	82732	\N	\N	f	Sales which are qualified	0
82733_4000.0_2008-03-01	400000	\N	2008-03-01	82733	\N	\N	f	Sales which are qualified	0
82733_6000.0_2022-06-30	600000	\N	2022-06-30	82733	\N	\N	f	Qual by exam of deed	0
82734_3750.0_2011-02-04	375000	\N	2011-02-04	82734	\N	\N	f	Qual by exam of deed	0
82734_5050.0_2019-06-26	505000	\N	2019-06-26	82734	\N	\N	f	Qual by exam of deed	0
82734_5500.0_2014-05-14	550000	\N	2014-05-14	82734	\N	\N	f	Qual by exam of deed	0
82735_3625.0_2010-08-26	362500	\N	2010-08-26	82735	\N	\N	f	Qual by exam of deed	0
82735_4450.0_2008-04-01	445000	\N	2008-04-01	82735	\N	\N	f	Sales which are qualified	0
82735_6000.0_2014-09-05	600000	\N	2014-09-05	82735	\N	\N	f	Qual by exam of deed	0
82735_6200.0_2022-03-16	620000	\N	2022-03-16	82735	\N	\N	f	Qual by exam of deed	0
82736_4550.0_2008-04-01	455000	\N	2008-04-01	82736	\N	\N	f	Sales which are qualified	0
82736_5500.0_2021-08-10	550000	\N	2021-08-10	82736	\N	\N	f	Qual by exam of deed	0
82737_4650.0_2008-02-01	465000	\N	2008-02-01	82737	\N	\N	f	Sales which are qualified	0
82737_5100.0_2018-09-27	510000	\N	2018-09-27	82737	\N	\N	f	Qual by exam of deed	0
82737_5500.0_2012-06-19	550000	\N	2012-06-19	82737	\N	\N	f	Qual by exam of deed	0
82738_7150.0_2014-03-27	715000	\N	2014-03-27	82738	\N	\N	f	Qual by exam of deed	0
82738_7750.0_2023-04-12	775000	\N	2023-04-12	82738	\N	\N	f	Qual by exam of deed	0
82739_3450.0_2008-03-01	345000	\N	2008-03-01	82739	\N	\N	f	Sales which are qualified	0
82739_4550.0_2013-02-25	455000	\N	2013-02-25	82739	\N	\N	f	Qual by exam of deed	0
82740_3600.0_2008-04-01	360000	\N	2008-04-01	82740	\N	\N	f	Sales which are qualified	0
82741_3000.0_2012-02-21	300000	\N	2012-02-21	82741	\N	\N	f	Qual by exam of deed	0
82741_4350.0_2012-10-09	435000	\N	2012-10-09	82741	\N	\N	f	Qual by exam of deed	0
82742_3750.0_2008-03-01	375000	\N	2008-03-01	82742	\N	\N	f	Sales which are qualified	0
82742_5000.0_2021-04-20	500000	\N	2021-04-20	82742	\N	\N	f	Qual by exam of deed	0
82742_5250.0_2015-03-18	525000	\N	2015-03-18	82742	\N	\N	f	Qual by exam of deed	0
82743_3900.0_2012-02-04	390000	\N	2012-02-04	82743	\N	\N	f	Qual by exam of deed	0
82743_4150.0_2010-01-25	415000	\N	2010-01-25	82743	\N	\N	f	Qual by exam of deed	0
82743_6400.0_2014-04-08	640000	\N	2014-04-08	82743	\N	\N	f	Qual by exam of deed	0
82744_4100.0_2008-03-01	410000	\N	2008-03-01	82744	\N	\N	f	Sales which are qualified	0
82744_5090.0_2012-09-24	509000	\N	2012-09-24	82744	\N	\N	f	Qual by exam of deed	0
82744_5500.0_2021-04-15	550000	\N	2021-04-15	82744	\N	\N	f	Qual by exam of deed	0
82744_6500.0_2022-06-09	650000	\N	2022-06-09	82744	\N	\N	f	Qual by exam of deed	0
82745_4200.0_2008-02-29	420000	\N	2008-02-29	82745	\N	\N	f	Sales which are qualified	0
82745_6300.0_2013-04-30	630000	\N	2013-04-30	82745	\N	\N	f	Qual by exam of deed	0
82745_6650.0_2022-08-03	665000	\N	2022-08-03	82745	\N	\N	f	Qual by exam of deed	0
82746_4150.0_2011-05-02	415000	\N	2011-05-02	82746	\N	\N	f	Qual by exam of deed	0
82746_4300.0_2008-04-23	430000	\N	2008-04-23	82746	\N	\N	f	Sales which are qualified	0
82746_5250.0_2021-04-23	525000	\N	2021-04-23	82746	\N	\N	f	Qual by exam of deed	0
82746_5990.0_2022-02-25	599000	\N	2022-02-25	82746	\N	\N	f	Qual by exam of deed	0
131990_53300.0_2021-11-11	5330000	\N	2021-11-11	131990	\N	\N	f	Qual by exam of deed	0
131990_89000.0_2023-06-13	8900000	\N	2023-06-13	131990	\N	\N	f	Qual by exam of deed	0
131991_57000.0_2021-12-17	5700000	\N	2021-12-17	131991	\N	\N	f	Qual by exam of deed	0
131992_39500.0_2021-11-02	3950000	\N	2021-11-02	131992	\N	\N	f	Qual by exam of deed	0
131993_49500.0_2021-10-20	4950000	\N	2021-10-20	131993	\N	\N	f	Qual by exam of deed	0
131994_71000.0_2023-08-18	7100000	\N	2023-08-18	131994	\N	\N	f	Qual by exam of deed	0
131995_64500.0_2021-11-08	6450000	\N	2021-11-08	131995	\N	\N	f	Qual by exam of deed	0
131996_85000.0_2021-10-26	8500000	\N	2021-10-26	131996	\N	\N	f	Qual by exam of deed	0
131997_78900.0_2021-10-19	7890000	\N	2021-10-19	131997	\N	\N	f	Qual by exam of deed	0
131998_49696.0_2021-10-19	4969600	\N	2021-10-19	131998	\N	\N	f	Qual by exam of deed	0
131999_45000.0_2021-10-19	4500000	\N	2021-10-19	131999	\N	\N	f	Qual by exam of deed	0
132000_50233.0_2021-11-08	5023300	\N	2021-11-08	132000	\N	\N	f	Qual by exam of deed	0
132001_85750.0_2021-10-20	8575000	\N	2021-10-20	132001	\N	\N	f	Qual by exam of deed	0
132002_75411.0_2021-10-19	7541100	\N	2021-10-19	132002	\N	\N	f	Qual by exam of deed	0
132003_73000.0_2021-10-22	7300000	\N	2021-10-22	132003	\N	\N	f	Qual by exam of deed	0
132004_30455.0_2021-10-29	3045500	\N	2021-10-29	132004	\N	\N	f	Qual by exam of deed	0
132004_55500.0_2023-05-24	5550000	\N	2023-05-24	132004	\N	\N	f	Qual by exam of deed	0
132005_38000.0_2021-10-21	3800000	\N	2021-10-21	132005	\N	\N	f	Qual by exam of deed	0
132006_33000.0_2021-12-14	3300000	\N	2021-12-14	132006	\N	\N	f	Qual by exam of deed	0
132007_48000.0_2022-02-25	4800000	\N	2022-02-25	132007	\N	\N	f	Qual by exam of deed	0
132008_32000.0_2021-11-02	3200000	\N	2021-11-02	132008	\N	\N	f	Qual by exam of deed	0
132009_35000.0_2021-11-02	3500000	\N	2021-11-02	132009	\N	\N	f	Qual by exam of deed	0
132010_40000.0_2021-10-20	4000000	\N	2021-10-20	132010	\N	\N	f	Qual by exam of deed	0
132011_38000.0_2021-10-20	3800000	\N	2021-10-20	132011	\N	\N	f	Qual by exam of deed	0
132034_22500.0_2023-08-01	2250000	\N	2023-08-01	132034	\N	\N	f	Qual by exam of deed	0
132035_19380.0_2021-10-29	1938000	\N	2021-10-29	132035	\N	\N	f	Qual by exam of deed	0
132036_18650.0_2021-11-05	1865000	\N	2021-11-05	132036	\N	\N	f	Qual by exam of deed	0
132037_13850.0_2021-11-05	1385000	\N	2021-11-05	132037	\N	\N	f	Qual by exam of deed	0
132038_15250.0_2021-10-25	1525000	\N	2021-10-25	132038	\N	\N	f	Qual by exam of deed	0
132039_15478.0_2021-10-26	1547800	\N	2021-10-26	132039	\N	\N	f	Qual by exam of deed	0
132039_22250.0_2022-12-29	2225000	\N	2022-12-29	132039	\N	\N	f	Qual by exam of deed	0
132040_17000.0_2021-11-05	1700000	\N	2021-11-05	132040	\N	\N	f	Qual by exam of deed	0
132041_15300.0_2021-12-01	1530000	\N	2021-12-01	132041	\N	\N	f	Qual by exam of deed	0
132042_17000.0_2021-10-26	1700000	\N	2021-10-26	132042	\N	\N	f	Qual by exam of deed	0
132043_22000.0_2021-10-19	2200000	\N	2021-10-19	132043	\N	\N	f	Qual by exam of deed	0
132043_26000.0_2022-03-28	2600000	\N	2022-03-28	132043	\N	\N	f	Qual by exam of deed	0
132044_24750.0_2021-10-28	2475000	\N	2021-10-28	132044	\N	\N	f	Qual by exam of deed	0
132045_23250.0_2021-11-10	2325000	\N	2021-11-10	132045	\N	\N	f	Qual by exam of deed	0
132046_25500.0_2021-12-13	2550000	\N	2021-12-13	132046	\N	\N	f	Qual by exam of deed	0
132047_18500.0_2021-10-19	1850000	\N	2021-10-19	132047	\N	\N	f	Qual by exam of deed	0
132047_33000.0_2022-04-15	3300000	\N	2022-04-15	132047	\N	\N	f	Qual by exam of deed	0
132048_16250.0_2021-10-19	1625000	\N	2021-10-19	132048	\N	\N	f	Qual by exam of deed	0
132049_20250.0_2021-11-01	2025000	\N	2021-11-01	132049	\N	\N	f	Qual by exam of deed	0
132049_28300.0_2022-01-12	2830000	\N	2022-01-12	132049	\N	\N	f	Qual by exam of deed	0
132050_20000.0_2021-10-22	2000000	\N	2021-10-22	132050	\N	\N	f	Qual by exam of deed	0
132051_21750.0_2021-10-29	2175000	\N	2021-10-29	132051	\N	\N	f	Qual by exam of deed	0
132051_27000.0_2022-03-09	2700000	\N	2022-03-09	132051	\N	\N	f	Qual by exam of deed	0
132052_20500.0_2021-10-26	2050000	\N	2021-10-26	132052	\N	\N	f	Qual by exam of deed	0
132053_22419.0_2021-10-27	2241900	\N	2021-10-27	132053	\N	\N	f	Qual by exam of deed	0
132054_22754.0_2021-10-27	2275400	\N	2021-10-27	132054	\N	\N	f	Qual by exam of deed	0
132054_28000.0_2021-11-24	2800000	\N	2021-11-24	132054	\N	\N	f	Qual by exam of deed	0
132055_25650.0_2021-10-29	2565000	\N	2021-10-29	132055	\N	\N	f	Qual by exam of deed	0
132056_25436.0_2021-10-22	2543600	\N	2021-10-22	132056	\N	\N	f	Qual by exam of deed	0
132056_35500.0_2023-05-12	3550000	\N	2023-05-12	132056	\N	\N	f	Qual by exam of deed	0
132057_370000.0_2022-06-17	37000000	\N	2022-06-17	132057	\N	\N	f	Qual by verifiable & documented evidence	0
132058_138000.0_2021-10-21	13800000	\N	2021-10-21	132058	\N	\N	f	Qual by exam of deed	0
132851_3540.0_2004-05-01	354000	\N	2004-05-01	132851	\N	\N	f	Sales which are qualified	0
132851_8000.0_2022-01-20	800000	\N	2022-01-20	132851	\N	\N	f	Qual by exam of deed	0
132852_4050.0_2004-05-01	405000	\N	2004-05-01	132852	\N	\N	f	Sales which are qualified	0
132852_5700.0_2015-09-04	570000	\N	2015-09-04	132852	\N	\N	f	Qual by exam of deed	0
132853_4300.0_2004-05-01	430000	\N	2004-05-01	132853	\N	\N	f	Sales which are qualified	0
132853_5900.0_2007-06-01	590000	\N	2007-06-01	132853	\N	\N	f	Sales which are qualified	0
132853_7650.0_2021-05-14	765000	\N	2021-05-14	132853	\N	\N	f	Qual by exam of deed	0
132854_4400.0_2004-05-01	440000	\N	2004-05-01	132854	\N	\N	f	Sales which are qualified	0
132854_4430.0_2010-12-14	443000	\N	2010-12-14	132854	\N	\N	f	Qual by exam of deed	0
132854_5520.0_2020-09-04	552000	\N	2020-09-04	132854	\N	\N	f	Qual by exam of deed	0
132855_4800.0_2004-05-01	480000	\N	2004-05-01	132855	\N	\N	f	Sales which are qualified	0
132855_7030.0_2014-04-25	703000	\N	2014-04-25	132855	\N	\N	f	Qual by exam of deed	0
132855_7300.0_2018-04-05	730000	\N	2018-04-05	132855	\N	\N	f	Qual by exam of deed	0
130195_10950.0_2006-08-01	1095000	\N	2006-08-01	130195	\N	\N	f	Sales which are qualified	0
130195_13625.0_2008-03-01	1362500	\N	2008-03-01	130195	\N	\N	f	Sales which are qualified	0
130196_10100.0_2023-01-03	1010000	\N	2023-01-03	130196	\N	\N	f	Qual by exam of deed	0
130196_4250.0_2006-08-01	425000	\N	2006-08-01	130196	\N	\N	f	Sales which are qualified	0
130196_8250.0_2016-05-31	825000	\N	2016-05-31	130196	\N	\N	f	Qual by exam of deed	0
130197_11135.0_2008-07-01	1113500	\N	2008-07-01	130197	\N	\N	f	Sales which are qualified	0
130198_4050.0_2010-02-17	405000	\N	2010-02-17	130198	\N	\N	f	Qual by exam of deed	0
130198_5000.0_2020-04-06	500000	\N	2020-04-06	130198	\N	\N	f	Qual by exam of deed	0
130199_3175.0_2008-12-09	317500	\N	2008-12-09	130199	\N	\N	f	Sales which are qualified	0
130199_3620.0_2014-10-24	362000	\N	2014-10-24	130199	\N	\N	f	Qual by exam of deed	0
130199_4000.0_2020-11-23	400000	\N	2020-11-23	130199	\N	\N	f	Qual by exam of deed	0
130200_5450.0_2013-01-16	545000	\N	2013-01-16	130200	\N	\N	f	Qual by exam of deed	0
130200_6500.0_2006-08-01	650000	\N	2006-08-01	130200	\N	\N	f	Sales which are qualified	0
130200_7923.0_2017-03-13	792300	\N	2017-03-13	130200	\N	\N	f	Qual by exam of deed	0
130201_3800.0_2012-11-27	380000	\N	2012-11-27	130201	\N	\N	f	Qual by exam of deed	0
130201_4150.0_2014-04-10	415000	\N	2014-04-10	130201	\N	\N	f	Qual by exam of deed	0
130201_4250.0_2008-09-24	425000	\N	2008-09-24	130201	\N	\N	f	Sales which are qualified	0
130201_5977.0_2017-03-13	597700	\N	2017-03-13	130201	\N	\N	f	Qual by exam of deed	0
130202_4050.0_2006-08-01	405000	\N	2006-08-01	130202	\N	\N	f	Sales which are qualified	0
130202_4150.0_2012-04-09	415000	\N	2012-04-09	130202	\N	\N	f	Qual by exam of deed	0
130202_4600.0_2015-07-22	460000	\N	2015-07-22	130202	\N	\N	f	Qual by exam of deed	0
130203_3350.0_2006-08-01	335000	\N	2006-08-01	130203	\N	\N	f	Sales which are qualified	0
130203_4450.0_2014-08-13	445000	\N	2014-08-13	130203	\N	\N	f	Qual by exam of deed	0
130203_4650.0_2007-05-01	465000	\N	2007-05-01	130203	\N	\N	f	Sales which are qualified	0
130204_3450.0_2006-08-01	345000	\N	2006-08-01	130204	\N	\N	f	Sales which are qualified	0
130204_4000.0_2007-05-01	400000	\N	2007-05-01	130204	\N	\N	f	Sales which are qualified	0
130204_4300.0_2015-08-05	430000	\N	2015-08-05	130204	\N	\N	f	Qual by exam of deed	0
130205_7000.0_2012-01-27	700000	\N	2012-01-27	130205	\N	\N	t	Qual on DOS, multi-parcel sale	0
130206_4650.0_2015-10-19	465000	\N	2015-10-19	130206	\N	\N	f	Qual by exam of deed	0
130206_7000.0_2012-01-27	700000	\N	2012-01-27	130206	\N	\N	t	Qual on DOS, multi-parcel sale	0
130207_8400.0_2006-12-01	840000	\N	2006-12-01	130207	\N	\N	f	Sales which are qualified	0
130208_3948.75_2016-03-22	394875	\N	2016-03-22	130208	\N	\N	f	Qual by exam of deed	0
130209_4760.0_2015-09-03	476000	\N	2015-09-03	130209	\N	\N	f	Qual by exam of deed	0
130209_5000.0_2019-04-24	500000	\N	2019-04-24	130209	\N	\N	f	Qual by exam of deed	0
130209_5320.0_2007-04-01	532000	\N	2007-04-01	130209	\N	\N	f	Sales which are qualified	0
130209_5500.0_2023-06-27	550000	\N	2023-06-27	130209	\N	\N	f	Qual by exam of deed	0
130210_4750.0_2021-04-19	475000	\N	2021-04-19	130210	\N	\N	f	Qual by exam of deed	0
130027_10500.0_2021-12-10	1050000	\N	2021-12-10	130027	\N	\N	f	Qual by exam of deed	0
130027_7000.0_2011-06-03	700000	\N	2011-06-03	130027	\N	\N	f	Qual by exam of deed	0
130027_8400.0_2018-10-25	840000	\N	2018-10-25	130027	\N	\N	f	Qual by exam of deed	0
130028_18750.0_2012-08-03	1875000	\N	2012-08-03	130028	\N	\N	t	Qual on DOS, multi-parcel sale	0
130028_27000.0_2020-11-20	2700000	\N	2020-11-20	130028	\N	\N	f	Qual by exam of deed	0
130028_8375.0_2017-05-26	837500	\N	2017-05-26	130028	\N	\N	f	Qual by exam of deed	0
130028_9571.0_2009-07-22	957100	\N	2009-07-22	130028	\N	\N	t	Qual on DOS, multi-parcel sale	0
130029_10000.0_2019-10-17	1000000	\N	2019-10-17	130029	\N	\N	f	Qual by exam of deed	0
130029_21500.0_2021-12-14	2150000	\N	2021-12-14	130029	\N	\N	f	Qual by exam of deed	0
130029_8400.0_2009-12-03	840000	\N	2009-12-03	130029	\N	\N	f	Qual by exam of deed	0
130030_13000.0_2021-11-23	1300000	\N	2021-11-23	130030	\N	\N	f	Qual by exam of deed	0
130030_7910.0_2009-12-03	791000	\N	2009-12-03	130030	\N	\N	f	Qual by exam of deed	0
130031_12000.0_2018-02-01	1200000	\N	2018-02-01	130031	\N	\N	f	Qual by exam of deed	0
130031_12750.0_2013-06-03	1275000	\N	2013-06-03	130031	\N	\N	f	Qual by exam of deed	0
130031_7500.0_2009-05-27	750000	\N	2009-05-27	130031	\N	\N	f	Qual by exam of deed	0
130032_12800.0_2013-06-03	1280000	\N	2013-06-03	130032	\N	\N	f	Qual by exam of deed	0
130032_18500.0_2015-08-04	1850000	\N	2015-08-04	130032	\N	\N	f	Qual by exam of deed	0
130032_21000.0_2022-05-11	2100000	\N	2022-05-11	130032	\N	\N	f	Qual by exam of deed	0
130045_10640.0_2011-02-17	1064000	\N	2011-02-17	130045	\N	\N	f	Qual by exam of deed	0
130045_15000.0_2008-09-30	1500000	\N	2008-09-30	130045	\N	\N	f	Sales which are qualified	0
130046_10840.0_2015-09-24	1084000	\N	2015-09-24	130046	\N	\N	f	Qual by exam of deed	0
130047_11400.0_2010-01-29	1140000	\N	2010-01-29	130047	\N	\N	f	Qual by exam of deed	0
130047_25000.0_2015-02-12	2500000	\N	2015-02-12	130047	\N	\N	f	Qual by exam of deed	0
130048_10100.0_2011-04-19	1010000	\N	2011-04-19	130048	\N	\N	f	Qual by exam of deed	0
130049_10600.0_2010-01-15	1060000	\N	2010-01-15	130049	\N	\N	f	Qual by exam of deed	0
130049_25000.0_2015-01-15	2500000	\N	2015-01-15	130049	\N	\N	f	Qual by exam of deed	0
130050_10500.0_2009-09-18	1050000	\N	2009-09-18	130050	\N	\N	f	Qual by exam of deed	0
130050_25000.0_2017-04-10	2500000	\N	2017-04-10	130050	\N	\N	f	Qual by exam of deed	0
130051_10600.0_2009-07-24	1060000	\N	2009-07-24	130051	\N	\N	f	Qual by exam of deed	0
130051_17000.0_2021-01-22	1700000	\N	2021-01-22	130051	\N	\N	f	Qual by exam of deed	0
130051_21000.0_2017-03-30	2100000	\N	2017-03-30	130051	\N	\N	f	Qual by exam of deed	0
130052_12000.0_2010-10-07	1200000	\N	2010-10-07	130052	\N	\N	f	Qual by exam of deed	0
130052_9500.0_2009-04-29	950000	\N	2009-04-29	130052	\N	\N	f	Qual by exam of deed	0
130053_11700.0_2009-05-04	1170000	\N	2009-05-04	130053	\N	\N	f	Qual by exam of deed	0
130053_21000.0_2013-06-10	2100000	\N	2013-06-10	130053	\N	\N	f	Qual by exam of deed	0
130053_25750.0_2014-04-09	2575000	\N	2014-04-09	130053	\N	\N	f	Qual by exam of deed	0
130054_18400.0_2008-06-11	1840000	\N	2008-06-11	130054	\N	\N	f	Sales which are qualified	0
130054_20000.0_2013-07-25	2000000	\N	2013-07-25	130054	\N	\N	f	Qual by exam of deed	0
130055_14000.0_2009-11-30	1400000	\N	2009-11-30	130055	\N	\N	f	Qual by exam of deed	0
130056_10500.0_2009-05-22	1050000	\N	2009-05-22	130056	\N	\N	f	Qual by exam of deed	0
130056_23000.0_2013-10-01	2300000	\N	2013-10-01	130056	\N	\N	f	Qual by exam of deed	0
130057_11285.25_2009-07-23	1128525	\N	2009-07-23	130057	\N	\N	f	Qual by exam of deed	0
130057_27000.0_2016-09-12	2700000	\N	2016-09-12	130057	\N	\N	f	Qual by exam of deed	0
130057_30000.0_2022-01-03	3000000	\N	2022-01-03	130057	\N	\N	f	Qual by exam of deed	0
130057_34000.0_2022-08-19	3400000	\N	2022-08-19	130057	\N	\N	f	Qual by exam of deed	0
130058_18000.0_2020-11-09	1800000	\N	2020-11-09	130058	\N	\N	f	Qual by exam of deed	0
130058_20904.0_2013-06-12	2090400	\N	2013-06-12	130058	\N	\N	f	Qual by exam of deed	0
130058_21500.0_2008-05-28	2150000	\N	2008-05-28	130058	\N	\N	f	Sales which are qualified	0
130058_23500.0_2021-08-16	2350000	\N	2021-08-16	130058	\N	\N	f	Qual by exam of deed	0
130059_12700.0_2010-04-27	1270000	\N	2010-04-27	130059	\N	\N	f	Qual by exam of deed	0
130060_13500.0_2009-05-27	1350000	\N	2009-05-27	130060	\N	\N	f	Qual by exam of deed	0
130061_11300.0_2009-04-24	1130000	\N	2009-04-24	130061	\N	\N	f	Qual by exam of deed	0
130061_26000.0_2021-05-20	2600000	\N	2021-05-20	130061	\N	\N	f	Qual by exam of deed	0
130061_28720.0_2015-06-04	2872000	\N	2015-06-04	130061	\N	\N	f	Qual by exam of deed	0
130061_38500.0_2023-04-10	3850000	\N	2023-04-10	130061	\N	\N	f	Qual by exam of deed	0
130062_15590.0_2009-01-16	1559000	\N	2009-01-16	130062	\N	\N	f	Qual by exam of deed	0
130063_12000.0_2022-10-31	1200000	\N	2022-10-31	130063	\N	\N	f	Qual by exam of deed	0
130063_12900.0_2023-03-15	1290000	\N	2023-03-15	130063	\N	\N	f	Qual by exam of deed	0
130063_6000.0_2009-10-09	600000	\N	2009-10-09	130063	\N	\N	f	Qual by exam of deed	0
130063_8500.0_2021-08-09	850000	\N	2021-08-09	130063	\N	\N	f	Qual by exam of deed	0
130064_7450.0_2018-12-28	745000	\N	2018-12-28	130064	\N	\N	f	Qual by exam of deed	0
130064_9700.0_2008-06-25	970000	\N	2008-06-25	130064	\N	\N	f	Sales which are qualified	0
130065_5350.0_2009-07-13	535000	\N	2009-07-13	130065	\N	\N	f	Qual by exam of deed	0
130066_10400.0_2015-10-05	1040000	\N	2015-10-05	130066	\N	\N	f	Qual by exam of deed	0
130066_5500.0_2009-07-20	550000	\N	2009-07-20	130066	\N	\N	f	Qual by exam of deed	0
130067_14250.0_2023-03-15	1425000	\N	2023-03-15	130067	\N	\N	f	Qual by exam of deed	0
130067_5990.0_2009-05-07	599000	\N	2009-05-07	130067	\N	\N	f	Qual by exam of deed	0
130067_7900.0_2021-04-29	790000	\N	2021-04-29	130067	\N	\N	f	Qual by exam of deed	0
130068_7100.0_2010-01-27	710000	\N	2010-01-27	130068	\N	\N	f	Qual by exam of deed	0
130068_9400.0_2016-12-30	940000	\N	2016-12-30	130068	\N	\N	f	Qual by exam of deed	0
130069_6000.0_2009-07-15	600000	\N	2009-07-15	130069	\N	\N	f	Qual by exam of deed	0
130069_7900.0_2021-03-01	790000	\N	2021-03-01	130069	\N	\N	f	Qual by exam of deed	0
130070_10500.0_2015-02-17	1050000	\N	2015-02-17	130070	\N	\N	f	Qual by exam of deed	0
130070_10900.0_2008-10-17	1090000	\N	2008-10-17	130070	\N	\N	f	Sales which are qualified	0
130071_10500.0_2021-11-23	1050000	\N	2021-11-23	130071	\N	\N	f	Qual by exam of deed	0
130071_10750.0_2015-07-07	1075000	\N	2015-07-07	130071	\N	\N	f	Qual by exam of deed	0
130071_7700.0_2011-07-07	770000	\N	2011-07-07	130071	\N	\N	f	Qual by exam of deed	0
130072_11000.0_2013-05-30	1100000	\N	2013-05-30	130072	\N	\N	f	Qual by exam of deed	0
130072_11000.0_2016-02-11	1100000	\N	2016-02-11	130072	\N	\N	f	Qual by exam of deed	0
130072_6500.0_2009-02-20	650000	\N	2009-02-20	130072	\N	\N	f	Qual by exam of deed	0
130073_6800.0_2009-08-03	680000	\N	2009-08-03	130073	\N	\N	f	Qual by exam of deed	0
130074_6350.0_2009-07-09	635000	\N	2009-07-09	130074	\N	\N	f	Qual by exam of deed	0
130075_10450.0_2013-10-16	1045000	\N	2013-10-16	130075	\N	\N	f	Qual by exam of deed	0
130075_11000.0_2009-07-08	1100000	\N	2009-07-08	130075	\N	\N	f	Qual by exam of deed	0
130075_11000.0_2021-12-15	1100000	\N	2021-12-15	130075	\N	\N	f	Qual by exam of deed	0
130076_9877.57_2008-09-08	987757	\N	2008-09-08	130076	\N	\N	f	Sales which are qualified	0
130077_13610.0_2008-07-31	1361000	\N	2008-07-31	130077	\N	\N	f	Sales which are qualified	0
130078_15000.0_2022-09-15	1500000	\N	2022-09-15	130078	\N	\N	f	Qual by exam of deed	0
130078_7350.0_2010-03-08	735000	\N	2010-03-08	130078	\N	\N	f	Qual by exam of deed	0
130078_9750.0_2019-03-29	975000	\N	2019-03-29	130078	\N	\N	f	Qual by exam of deed	0
130079_12250.0_2015-12-18	1225000	\N	2015-12-18	130079	\N	\N	f	Qual by exam of deed	0
130079_7400.0_2010-06-22	740000	\N	2010-06-22	130079	\N	\N	f	Qual by exam of deed	0
130079_7500.0_2009-06-23	750000	\N	2009-06-23	130079	\N	\N	f	Qual by exam of deed	0
130079_8230.0_2011-02-16	823000	\N	2011-02-16	130079	\N	\N	f	Qual by exam of deed	0
130080_3750.0_2009-08-21	375000	\N	2009-08-21	130080	\N	\N	f	Qual by exam of deed	0
130080_4050.0_2021-01-27	405000	\N	2021-01-27	130080	\N	\N	f	Qual by exam of deed	0
130081_3970.0_2011-02-21	397000	\N	2011-02-21	130081	\N	\N	f	Qual by exam of deed	0
130082_3770.0_2010-05-28	377000	\N	2010-05-28	130082	\N	\N	f	Qual by exam of deed	0
130082_5650.0_2013-04-23	565000	\N	2013-04-23	130082	\N	\N	f	Qual by exam of deed	0
130082_6200.0_2017-11-30	620000	\N	2017-11-30	130082	\N	\N	f	Qual by exam of deed	0
130082_6900.0_2022-03-22	690000	\N	2022-03-22	130082	\N	\N	f	Qual by exam of deed	0
130083_4700.0_2021-01-04	470000	\N	2021-01-04	130083	\N	\N	f	Qual by exam of deed	0
130083_7600.0_2008-05-28	760000	\N	2008-05-28	130083	\N	\N	f	Sales which are qualified	0
130084_4100.0_2010-02-26	410000	\N	2010-02-26	130084	\N	\N	f	Qual by verifiable & documented evidence	0
130084_5200.0_2019-05-03	520000	\N	2019-05-03	130084	\N	\N	f	Qual by exam of deed	0
130085_4150.0_2010-02-19	415000	\N	2010-02-19	130085	\N	\N	f	Qual by exam of deed	0
130085_8100.0_2023-02-27	810000	\N	2023-02-27	130085	\N	\N	f	Qual by exam of deed	0
130086_4650.0_2009-12-31	465000	\N	2009-12-31	130086	\N	\N	f	Qual by exam of deed	0
130086_5600.0_2014-08-07	560000	\N	2014-08-07	130086	\N	\N	f	Qual by exam of deed	0
130087_7750.0_2022-03-21	775000	\N	2022-03-21	130087	\N	\N	f	Qual by exam of deed	0
130087_8550.0_2008-09-04	855000	\N	2008-09-04	130087	\N	\N	f	Sales which are qualified	0
130088_6900.0_2022-02-10	690000	\N	2022-02-10	130088	\N	\N	f	Qual by exam of deed	0
130088_7600.0_2008-06-04	760000	\N	2008-06-04	130088	\N	\N	f	Sales which are qualified	0
130089_5950.0_2014-01-24	595000	\N	2014-01-24	130089	\N	\N	f	Qual by exam of deed	0
130089_7500.0_2016-06-30	750000	\N	2016-06-30	130089	\N	\N	f	Qual by exam of deed	0
130089_8599.0_2008-07-21	859900	\N	2008-07-21	130089	\N	\N	f	Sales which are qualified	0
130090_6400.0_2015-01-23	640000	\N	2015-01-23	130090	\N	\N	f	Qual by exam of deed	0
130090_7700.0_2022-02-01	770000	\N	2022-02-01	130090	\N	\N	f	Qual by exam of deed	0
130090_8600.0_2022-05-20	860000	\N	2022-05-20	130090	\N	\N	f	Qual by exam of deed	0
130090_9750.0_2008-05-16	975000	\N	2008-05-16	130090	\N	\N	f	Sales which are qualified	0
130091_12500.0_2018-06-04	1250000	\N	2018-06-04	130091	\N	\N	f	Qual by exam of deed	0
130091_8500.0_2012-06-05	850000	\N	2012-06-05	130091	\N	\N	f	Qual by exam of deed	0
130092_12374.0_2021-06-30	1237400	\N	2021-06-30	130092	\N	\N	f	Qual by exam of deed	0
130092_14024.0_2019-12-20	1402400	\N	2019-12-20	130092	\N	\N	f	Qual by exam of deed	0
130092_15300.0_2015-09-02	1530000	\N	2015-09-02	130092	\N	\N	f	Qual by exam of deed	0
130092_8500.0_2012-04-19	850000	\N	2012-04-19	130092	\N	\N	f	Qual by exam of deed	0
130093_14000.0_2013-12-09	1400000	\N	2013-12-09	130093	\N	\N	f	Qual by exam of deed	0
130093_15500.0_2021-10-22	1550000	\N	2021-10-22	130093	\N	\N	f	Qual by exam of deed	0
130093_9700.0_2010-02-23	970000	\N	2010-02-23	130093	\N	\N	f	Qual by exam of deed	0
130094_5850.0_2009-05-26	585000	\N	2009-05-26	130094	\N	\N	f	Qual by exam of deed	0
130095_6500.0_2009-08-05	650000	\N	2009-08-05	130095	\N	\N	f	Qual by exam of deed	0
130096_5600.0_2009-09-29	560000	\N	2009-09-29	130096	\N	\N	f	Qual by exam of deed	0
130096_9300.0_2017-11-13	930000	\N	2017-11-13	130096	\N	\N	f	Qual by exam of deed	0
130097_11000.0_2015-04-01	1100000	\N	2015-04-01	130097	\N	\N	f	Qual by exam of deed	0
130097_5500.0_2009-10-26	550000	\N	2009-10-26	130097	\N	\N	f	Qual by exam of deed	0
130097_8500.0_2019-08-09	850000	\N	2019-08-09	130097	\N	\N	f	Qual by exam of deed	0
130098_5980.0_2009-11-24	598000	\N	2009-11-24	130098	\N	\N	f	Qual by exam of deed	0
130098_8200.0_2021-06-09	820000	\N	2021-06-09	130098	\N	\N	f	Qual by exam of deed	0
130099_5850.0_2009-08-13	585000	\N	2009-08-13	130099	\N	\N	f	Qual by exam of deed	0
130099_8000.0_2012-09-14	800000	\N	2012-09-14	130099	\N	\N	f	Qual by exam of deed	0
130100_5950.0_2009-05-01	595000	\N	2009-05-01	130100	\N	\N	f	Qual by exam of deed	0
130100_7680.0_2012-09-11	768000	\N	2012-09-11	130100	\N	\N	f	Qual by exam of deed	0
130101_6300.0_2009-01-07	630000	\N	2009-01-07	130101	\N	\N	f	Qual by exam of deed	0
130101_7500.0_2021-04-14	750000	\N	2021-04-14	130101	\N	\N	f	Qual by exam of deed	0
130102_10950.0_2008-06-25	1095000	\N	2008-06-25	130102	\N	\N	f	Sales which are qualified	0
130103_10900.0_2014-05-08	1090000	\N	2014-05-08	130103	\N	\N	f	Qual by exam of deed	0
130103_5750.0_2009-05-11	575000	\N	2009-05-11	130103	\N	\N	f	Qual by exam of deed	0
130104_6575.0_2009-11-06	657500	\N	2009-11-06	130104	\N	\N	f	Qual by exam of deed	0
130104_7100.0_2020-07-15	710000	\N	2020-07-15	130104	\N	\N	f	Qual by exam of deed	0
130105_11000.0_2008-06-09	1100000	\N	2008-06-09	130105	\N	\N	f	Sales which are qualified	0
130105_11000.0_2015-09-10	1100000	\N	2015-09-10	130105	\N	\N	f	Qual by exam of deed	0
130105_14500.0_2022-05-02	1450000	\N	2022-05-02	130105	\N	\N	f	Qual by exam of deed	0
130105_8856.0_2021-04-30	885600	\N	2021-04-30	130105	\N	\N	f	Qual by exam of deed	0
130106_7000.0_2010-03-24	700000	\N	2010-03-24	130106	\N	\N	f	Qual by exam of deed	0
130106_8150.0_2019-03-07	815000	\N	2019-03-07	130106	\N	\N	f	Qual by exam of deed	0
130106_8500.0_2021-05-04	850000	\N	2021-05-04	130106	\N	\N	f	Qual by exam of deed	0
130107_12500.0_2022-04-12	1250000	\N	2022-04-12	130107	\N	\N	f	Qual by exam of deed	0
130107_6850.0_2010-02-05	685000	\N	2010-02-05	130107	\N	\N	f	Qual by exam of deed	0
130108_14750.0_2022-04-14	1475000	\N	2022-04-14	130108	\N	\N	f	Qual by exam of deed	0
130108_7000.0_2010-05-10	700000	\N	2010-05-10	130108	\N	\N	f	Qual by exam of deed	0
130108_9430.0_2017-06-05	943000	\N	2017-06-05	130108	\N	\N	f	Qual by exam of deed	0
130109_11000.0_2012-11-29	1100000	\N	2012-11-29	130109	\N	\N	f	Qual by exam of deed	0
130109_7050.0_2010-03-12	705000	\N	2010-03-12	130109	\N	\N	f	Qual by exam of deed	0
130110_7500.0_2009-06-18	750000	\N	2009-06-18	130110	\N	\N	f	Qual by exam of deed	0
130110_9650.0_2021-11-01	965000	\N	2021-11-01	130110	\N	\N	f	Qual by exam of deed	0
130111_5900.0_2014-06-26	590000	\N	2014-06-26	130111	\N	\N	f	Qual by exam of deed	0
130111_6450.0_2008-09-02	645000	\N	2008-09-02	130111	\N	\N	f	Sales which are qualified	0
130111_7450.0_2015-07-15	745000	\N	2015-07-15	130111	\N	\N	f	Qual by exam of deed	0
130112_3850.0_2011-07-18	385000	\N	2011-07-18	130112	\N	\N	f	Qual by exam of deed	0
130112_5000.0_2012-12-20	500000	\N	2012-12-20	130112	\N	\N	f	Qual by exam of deed	0
130112_6700.0_2008-08-06	670000	\N	2008-08-06	130112	\N	\N	f	Sales which are qualified	0
130113_3850.0_2009-10-30	385000	\N	2009-10-30	130113	\N	\N	f	Qual by exam of deed	0
130114_5950.0_2008-12-19	595000	\N	2008-12-19	130114	\N	\N	f	Sales which are qualified	0
130114_6250.0_2017-02-24	625000	\N	2017-02-24	130114	\N	\N	f	Qual by exam of deed	0
130114_6300.0_2015-06-03	630000	\N	2015-06-03	130114	\N	\N	f	Qual by exam of deed	0
130114_8250.0_2023-05-15	825000	\N	2023-05-15	130114	\N	\N	f	Qual by exam of deed	0
130115_4100.0_2009-08-24	410000	\N	2009-08-24	130115	\N	\N	f	Qual by exam of deed	0
130115_7400.0_2022-11-01	740000	\N	2022-11-01	130115	\N	\N	f	Qual by exam of deed	0
130116_4526.7_2009-05-08	452670	\N	2009-05-08	130116	\N	\N	f	Qual by exam of deed	0
130117_3080.0_2012-02-25	308000	\N	2012-02-25	130117	\N	\N	f	Qual by exam of deed	0
130117_4850.0_2012-07-17	485000	\N	2012-07-17	130117	\N	\N	f	Qual by exam of deed	0
130117_5600.0_2021-07-19	560000	\N	2021-07-19	130117	\N	\N	f	Qual by exam of deed	0
130117_7150.0_2008-07-02	715000	\N	2008-07-02	130117	\N	\N	f	Sales which are qualified	0
130118_4300.0_2009-10-01	430000	\N	2009-10-01	130118	\N	\N	f	Qual by exam of deed	0
130118_7100.0_2022-04-15	710000	\N	2022-04-15	130118	\N	\N	f	Qual by exam of deed	0
130119_4700.0_2010-02-10	470000	\N	2010-02-10	130119	\N	\N	f	Qual by exam of deed	0
130119_4850.0_2020-04-22	485000	\N	2020-04-22	130119	\N	\N	f	Qual by exam of deed	0
130120_4660.0_2009-12-18	466000	\N	2009-12-18	130120	\N	\N	f	Qual by exam of deed	0
130120_6100.0_2013-09-16	610000	\N	2013-09-16	130120	\N	\N	f	Qual by exam of deed	0
130120_7930.0_2022-04-19	793000	\N	2022-04-19	130120	\N	\N	f	Qual by exam of deed	0
130121_4879.16_2009-07-09	487916	\N	2009-07-09	130121	\N	\N	f	Qual by exam of deed	0
130121_7400.0_2022-08-30	740000	\N	2022-08-30	130121	\N	\N	f	Qual by exam of deed	0
130122_11270.0_2012-09-11	1127000	\N	2012-09-11	130122	\N	\N	f	Qual by exam of deed	0
130123_11000.0_2012-03-14	1100000	\N	2012-03-14	130123	\N	\N	f	Qual by exam of deed	0
130123_14250.0_2015-03-25	1425000	\N	2015-03-25	130123	\N	\N	f	Qual by exam of deed	0
130123_14820.0_2021-04-16	1482000	\N	2021-04-16	130123	\N	\N	f	Qual by exam of deed	0
130124_10000.0_2011-09-28	1000000	\N	2011-09-28	130124	\N	\N	f	Qual by exam of deed	0
130124_21500.0_2022-03-01	2150000	\N	2022-03-01	130124	\N	\N	f	Qual by exam of deed	0
130125_6750.0_2009-09-04	675000	\N	2009-09-04	130125	\N	\N	f	Qual by exam of deed	0
130125_8300.0_2012-11-30	830000	\N	2012-11-30	130125	\N	\N	f	Qual by exam of deed	0
130125_8400.0_2021-04-22	840000	\N	2021-04-22	130125	\N	\N	f	Qual by exam of deed	0
130126_10850.0_2008-07-17	1085000	\N	2008-07-17	130126	\N	\N	f	Sales which are qualified	0
130126_14500.0_2023-08-11	1450000	\N	2023-08-11	130126	\N	\N	f	Qual by exam of deed	0
130127_6930.0_2010-02-19	693000	\N	2010-02-19	130127	\N	\N	f	Qual by exam of deed	0
130128_10000.0_2017-06-05	1000000	\N	2017-06-05	130128	\N	\N	f	Qual by exam of deed	0
130128_7150.0_2010-08-11	715000	\N	2010-08-11	130128	\N	\N	f	Qual by exam of deed	0
130129_11100.0_2021-08-19	1110000	\N	2021-08-19	130129	\N	\N	f	Qual by exam of deed	0
130129_7500.0_2010-01-21	750000	\N	2010-01-21	130129	\N	\N	f	Qual by exam of deed	0
130130_8650.0_2009-10-21	865000	\N	2009-10-21	130130	\N	\N	f	Qual by exam of deed	0
130130_9800.0_2018-03-01	980000	\N	2018-03-01	130130	\N	\N	f	Qual by exam of deed	0
130131_10100.0_2008-12-10	1010000	\N	2008-12-10	130131	\N	\N	f	Sales which are qualified	0
130131_8575.0_2021-01-15	857500	\N	2021-01-15	130131	\N	\N	f	Qual by exam of deed	0
130131_9800.0_2016-10-18	980000	\N	2016-10-18	130131	\N	\N	f	Qual by exam of deed	0
130132_11150.0_2008-06-11	1115000	\N	2008-06-11	130132	\N	\N	f	Sales which are qualified	0
130132_8600.0_2012-11-15	860000	\N	2012-11-15	130132	\N	\N	f	Qual by exam of deed	0
130133_10300.0_2016-10-25	1030000	\N	2016-10-25	130133	\N	\N	f	Qual by exam of deed	0
130133_11000.0_2014-11-05	1100000	\N	2014-11-05	130133	\N	\N	f	Qual by exam of deed	0
130133_17750.0_2022-09-01	1775000	\N	2022-09-01	130133	\N	\N	f	Qual by exam of deed	0
130133_9190.0_2010-05-24	919000	\N	2010-05-24	130133	\N	\N	f	Qual by exam of deed	0
130134_7240.0_2009-09-08	724000	\N	2009-09-08	130134	\N	\N	f	Qual by exam of deed	0
130135_11450.0_2021-07-19	1145000	\N	2021-07-19	130135	\N	\N	f	Qual by exam of deed	0
130135_7500.0_2009-08-14	750000	\N	2009-08-14	130135	\N	\N	f	Qual by exam of deed	0
130136_10000.0_2019-06-12	1000000	\N	2019-06-12	130136	\N	\N	f	Qual by exam of deed	0
130136_7000.0_2009-07-22	700000	\N	2009-07-22	130136	\N	\N	f	Qual by exam of deed	0
130137_9500.0_2020-10-07	950000	\N	2020-10-07	130137	\N	\N	f	Qual by exam of deed	0
130137_9600.0_2008-09-16	960000	\N	2008-09-16	130137	\N	\N	f	Sales which are qualified	0
130138_11650.0_2015-03-26	1165000	\N	2015-03-26	130138	\N	\N	f	Qual by exam of deed	0
130138_5650.0_2011-08-25	565000	\N	2011-08-25	130138	\N	\N	f	Qual by exam of deed	0
130138_9750.0_2009-01-22	975000	\N	2009-01-22	130138	\N	\N	f	Qual by exam of deed	0
130139_10800.0_2013-08-05	1080000	\N	2013-08-05	130139	\N	\N	f	Qual by exam of deed	0
130139_11500.0_2021-03-17	1150000	\N	2021-03-17	130139	\N	\N	f	Qual by exam of deed	0
130139_8000.0_2009-02-05	800000	\N	2009-02-05	130139	\N	\N	f	Qual by exam of deed	0
130140_11900.0_2021-03-10	1190000	\N	2021-03-10	130140	\N	\N	f	Qual by exam of deed	0
130140_12150.0_2014-03-19	1215000	\N	2014-03-19	130140	\N	\N	f	Qual by exam of deed	0
130140_7950.0_2009-07-14	795000	\N	2009-07-14	130140	\N	\N	f	Qual by exam of deed	0
130141_11000.0_2012-05-15	1100000	\N	2012-05-15	130141	\N	\N	f	Qual by exam of deed	0
130141_13000.0_2018-01-25	1300000	\N	2018-01-25	130141	\N	\N	f	Qual by exam of deed	0
130141_8000.0_2009-05-21	800000	\N	2009-05-21	130141	\N	\N	f	Qual by exam of deed	0
130142_13000.0_2008-06-03	1300000	\N	2008-06-03	130142	\N	\N	f	Sales which are qualified	0
130142_8650.0_2011-12-23	865000	\N	2011-12-23	130142	\N	\N	f	Qual by exam of deed	0
130143_8650.0_2011-10-12	865000	\N	2011-10-12	130143	\N	\N	f	Qual by exam of deed	0
130144_9000.0_2011-12-05	900000	\N	2011-12-05	130144	\N	\N	f	Qual by exam of deed	0
130145_13150.0_2008-06-30	1315000	\N	2008-06-30	130145	\N	\N	f	Sales which are qualified	0
130145_16750.0_2022-02-18	1675000	\N	2022-02-18	130145	\N	\N	f	Qual by exam of deed	0
130146_8900.0_2011-01-18	890000	\N	2011-01-18	130146	\N	\N	f	Qual by exam of deed	0
130147_9300.0_2010-02-25	930000	\N	2010-02-25	130147	\N	\N	f	Qual by exam of deed	0
130148_9500.0_2010-08-16	950000	\N	2010-08-16	130148	\N	\N	f	Qual by exam of deed	0
130149_9250.0_2009-10-12	925000	\N	2009-10-12	130149	\N	\N	f	Qual by exam of deed	0
130150_10500.0_2009-10-30	1050000	\N	2009-10-30	130150	\N	\N	f	Qual by exam of deed	0
130151_13450.0_2008-05-16	1345000	\N	2008-05-16	130151	\N	\N	f	Sales which are qualified	0
130151_16000.0_2013-09-05	1600000	\N	2013-09-05	130151	\N	\N	f	Qual by exam of deed	0
130152_10240.0_2009-05-01	1024000	\N	2009-05-01	130152	\N	\N	f	Qual by exam of deed	0
130152_12300.0_2012-04-09	1230000	\N	2012-04-09	130152	\N	\N	f	Qual by exam of deed	0
130153_14500.0_2008-06-03	1450000	\N	2008-06-03	130153	\N	\N	f	Sales which are qualified	0
130154_12000.0_2009-07-31	1200000	\N	2009-07-31	130154	\N	\N	f	Qual by exam of deed	0
130154_15500.0_2016-06-09	1550000	\N	2016-06-09	130154	\N	\N	f	Qual by exam of deed	0
130154_21500.0_2021-04-28	2150000	\N	2021-04-28	130154	\N	\N	f	Qual by exam of deed	0
130155_10690.0_2009-04-17	1069000	\N	2009-04-17	130155	\N	\N	f	Qual by exam of deed	0
130155_14500.0_2013-02-20	1450000	\N	2013-02-20	130155	\N	\N	f	Qual by exam of deed	0
130156_15850.0_2008-09-18	1585000	\N	2008-09-18	130156	\N	\N	f	Sales which are qualified	0
130157_16750.0_2008-09-18	1675000	\N	2008-09-18	130157	\N	\N	f	Sales which are qualified	0
130158_16000.0_2008-09-18	1600000	\N	2008-09-18	130158	\N	\N	f	Sales which are qualified	0
130158_20750.0_2021-04-09	2075000	\N	2021-04-09	130158	\N	\N	f	Qual by exam of deed	0
133924_10300.0_2015-06-26	1030000	\N	2015-06-26	133924	\N	\N	f	Qual by exam of deed	0
133924_11400.0_2021-10-06	1140000	\N	2021-10-06	133924	\N	\N	f	Qual by exam of deed	0
133925_5000.0_2013-05-20	500000	\N	2013-05-20	133925	\N	\N	f	Qual by exam of deed	0
133925_5250.0_2005-08-01	525000	\N	2005-08-01	133925	\N	\N	f	Sales which are qualified	0
133926_3696.0_2005-08-01	369600	\N	2005-08-01	133926	\N	\N	f	Sales which are qualified	0
133926_5150.0_2005-08-01	515000	\N	2005-08-01	133926	\N	\N	f	Sales which are qualified	0
133926_5150.0_2015-12-28	515000	\N	2015-12-28	133926	\N	\N	f	Qual by exam of deed	0
133926_5250.0_2013-07-31	525000	\N	2013-07-31	133926	\N	\N	f	Qual by exam of deed	0
133927_3436.5_2005-08-01	343650	\N	2005-08-01	133927	\N	\N	f	Sales which are qualified	0
133927_4100.0_2008-09-15	410000	\N	2008-09-15	133927	\N	\N	f	Sales which are qualified	0
133928_10500.0_2022-09-30	1050000	\N	2022-09-30	133928	\N	\N	f	Qual by exam of deed	0
133928_6500.0_2005-09-01	650000	\N	2005-09-01	133928	\N	\N	f	Sales which are qualified	0
133928_6850.0_2015-07-31	685000	\N	2015-07-31	133928	\N	\N	f	Qual by exam of deed	0
133928_6900.0_2018-06-29	690000	\N	2018-06-29	133928	\N	\N	f	Qual by exam of deed	0
133929_10500.0_2014-04-24	1050000	\N	2014-04-24	133929	\N	\N	f	Qual by exam of deed	0
133929_9160.0_2006-05-01	916000	\N	2006-05-01	133929	\N	\N	f	Sales which are qualified	0
133930_3315.0_2005-08-01	331500	\N	2005-08-01	133930	\N	\N	f	Sales which are qualified	0
133930_3500.0_2009-02-10	350000	\N	2009-02-10	133930	\N	\N	f	Qual by exam of deed	0
133930_5400.0_2014-04-04	540000	\N	2014-04-04	133930	\N	\N	f	Qual by exam of deed	0
133930_6100.0_2017-03-03	610000	\N	2017-03-03	133930	\N	\N	f	Qual by exam of deed	0
133931_3593.5_2005-08-01	359350	\N	2005-08-01	133931	\N	\N	f	Sales which are qualified	0
133931_4800.0_2013-04-11	480000	\N	2013-04-11	133931	\N	\N	f	Qual by exam of deed	0
133932_4111.25_2005-08-01	411125	\N	2005-08-01	133932	\N	\N	f	Sales which are qualified	0
133940_4108.87_2005-08-01	410887	\N	2005-08-01	133940	\N	\N	f	Sales which are qualified	0
133940_5050.0_2015-07-08	505000	\N	2015-07-08	133940	\N	\N	f	Qual by exam of deed	0
133940_5500.0_2021-05-15	550000	\N	2021-05-15	133940	\N	\N	f	Qual by exam of deed	0
133941_3300.0_2010-07-23	330000	\N	2010-07-23	133941	\N	\N	f	Qual by exam of deed	0
133941_4500.0_2005-09-01	450000	\N	2005-09-01	133941	\N	\N	f	Sales which are qualified	0
133941_5300.0_2018-06-27	530000	\N	2018-06-27	133941	\N	\N	f	Qual by exam of deed	0
133941_6250.0_2007-05-01	625000	\N	2007-05-01	133941	\N	\N	f	Sales which are qualified	0
133941_7900.0_2022-09-08	790000	\N	2022-09-08	133941	\N	\N	f	Qual by exam of deed	0
133942_4330.0_2005-09-01	433000	\N	2005-09-01	133942	\N	\N	f	Sales which are qualified	0
133942_4450.0_2008-10-31	445000	\N	2008-10-31	133942	\N	\N	f	Sales which are qualified	0
133942_5900.0_2022-03-04	590000	\N	2022-03-04	133942	\N	\N	f	Qual by exam of deed	0
133943_4800.0_2005-08-01	480000	\N	2005-08-01	133943	\N	\N	f	Sales which are qualified	0
133943_5600.0_2017-08-30	560000	\N	2017-08-30	133943	\N	\N	f	Qual by exam of deed	0
133944_4520.0_2005-09-01	452000	\N	2005-09-01	133944	\N	\N	f	Sales which are qualified	0
133944_6300.0_2006-07-01	630000	\N	2006-07-01	133944	\N	\N	f	Sales which are qualified	0
133945_3387.0_2005-08-01	338700	\N	2005-08-01	133945	\N	\N	f	Sales which are qualified	0
133945_4850.0_2019-06-28	485000	\N	2019-06-28	133945	\N	\N	f	Qual by exam of deed	0
133946_7290.0_2012-04-16	729000	\N	2012-04-16	133946	\N	\N	f	Qual by exam of deed	0
133946_7591.91_2005-08-01	759191	\N	2005-08-01	133946	\N	\N	f	Sales which are qualified	0
133946_7990.0_2018-10-25	799000	\N	2018-10-25	133946	\N	\N	f	Qual by exam of deed	0
133947_4332.74_2005-09-01	433274	\N	2005-09-01	133947	\N	\N	f	Sales which are qualified	0
133947_4750.0_2018-12-18	475000	\N	2018-12-18	133947	\N	\N	f	Qual by exam of deed	0
133947_8400.0_2022-09-21	840000	\N	2022-09-21	133947	\N	\N	f	Qual by exam of deed	0
133948_4520.0_2005-08-01	452000	\N	2005-08-01	133948	\N	\N	f	Sales which are qualified	0
133948_5300.0_2005-08-01	530000	\N	2005-08-01	133948	\N	\N	f	Sales which are qualified	0
133949_3390.0_2005-08-01	339000	\N	2005-08-01	133949	\N	\N	f	Sales which are qualified	0
133949_4300.0_2013-03-28	430000	\N	2013-03-28	133949	\N	\N	f	Qual by exam of deed	0
133950_3100.0_2005-08-01	310000	\N	2005-08-01	133950	\N	\N	f	Sales which are qualified	0
133950_5130.0_2013-11-21	513000	\N	2013-11-21	133950	\N	\N	f	Qual by exam of deed	0
133951_3390.0_2005-08-01	339000	\N	2005-08-01	133951	\N	\N	f	Sales which are qualified	0
133951_3675.0_2010-05-18	367500	\N	2010-05-18	133951	\N	\N	f	Qual by exam of deed	0
133951_5000.0_2020-05-01	500000	\N	2020-05-01	133951	\N	\N	f	Qual by exam of deed	0
133952_4400.0_2012-11-09	440000	\N	2012-11-09	133952	\N	\N	f	Qual by exam of deed	0
133952_4480.0_2005-08-01	448000	\N	2005-08-01	133952	\N	\N	f	Sales which are qualified	0
133952_5850.0_2016-07-11	585000	\N	2016-07-11	133952	\N	\N	f	Qual by exam of deed	0
133952_9900.0_2022-12-01	990000	\N	2022-12-01	133952	\N	\N	f	Qual by exam of deed	0
133953_4920.0_2005-08-01	492000	\N	2005-08-01	133953	\N	\N	f	Sales which are qualified	0
133953_5000.0_2013-07-23	500000	\N	2013-07-23	133953	\N	\N	f	Qual by exam of deed	0
133954_5200.0_2013-12-09	520000	\N	2013-12-09	133954	\N	\N	f	Qual by exam of deed	0
133954_5250.0_2005-08-01	525000	\N	2005-08-01	133954	\N	\N	f	Sales which are qualified	0
133954_6300.0_2022-03-23	630000	\N	2022-03-23	133954	\N	\N	f	Qual by exam of deed	0
133955_4520.0_2005-08-01	452000	\N	2005-08-01	133955	\N	\N	f	Sales which are qualified	0
133955_5650.0_2014-01-24	565000	\N	2014-01-24	133955	\N	\N	f	Qual by exam of deed	0
133956_3610.12_2005-08-01	361012	\N	2005-08-01	133956	\N	\N	f	Sales which are qualified	0
133956_4200.0_2008-07-01	420000	\N	2008-07-01	133956	\N	\N	f	Sales which are qualified	0
133956_4893.0_2015-03-05	489300	\N	2015-03-05	133956	\N	\N	f	Qual by exam of deed	0
133957_3792.99_2005-08-01	379299	\N	2005-08-01	133957	\N	\N	f	Sales which are qualified	0
133957_4900.0_2015-04-27	490000	\N	2015-04-27	133957	\N	\N	f	Qual by exam of deed	0
133957_4905.0_2007-02-01	490500	\N	2007-02-01	133957	\N	\N	f	Sales which are qualified	0
133958_3793.6_2005-08-01	379360	\N	2005-08-01	133958	\N	\N	f	Sales which are qualified	0
133958_4630.0_2008-05-01	463000	\N	2008-05-01	133958	\N	\N	f	Sales which are qualified	0
133958_4700.0_2021-04-13	470000	\N	2021-04-13	133958	\N	\N	f	Qual by exam of deed	0
133959_150.0_2013-02-05	15000	\N	2013-02-05	133959	\N	\N	f	Qual by exam of deed	0
133959_4220.0_2013-05-17	422000	\N	2013-05-17	133959	\N	\N	f	Qual by exam of deed	0
133959_5700.0_2005-09-01	570000	\N	2005-09-01	133959	\N	\N	f	Sales which are qualified	0
133960_3797.71_2005-08-01	379771	\N	2005-08-01	133960	\N	\N	f	Sales which are qualified	0
133960_4850.0_2005-10-01	485000	\N	2005-10-01	133960	\N	\N	f	Sales which are qualified	0
133960_5900.0_2018-08-15	590000	\N	2018-08-15	133960	\N	\N	f	Qual by exam of deed	0
133960_8670.0_2022-11-02	867000	\N	2022-11-02	133960	\N	\N	f	Qual by exam of deed	0
133961_4650.0_2005-09-01	465000	\N	2005-09-01	133961	\N	\N	f	Sales which are qualified	0
133962_3219.0_2005-08-01	321900	\N	2005-08-01	133962	\N	\N	f	Sales which are qualified	0
133962_5050.0_2007-07-01	505000	\N	2007-07-01	133962	\N	\N	f	Sales which are qualified	0
133962_5490.0_2019-04-29	549000	\N	2019-04-29	133962	\N	\N	f	Qual by exam of deed	0
133962_6800.0_2022-02-28	680000	\N	2022-02-28	133962	\N	\N	f	Qual by exam of deed	0
133963_4541.04_2005-08-01	454104	\N	2005-08-01	133963	\N	\N	f	Sales which are qualified	0
133963_5175.0_2017-11-30	517500	\N	2017-11-30	133963	\N	\N	f	Qual by exam of deed	0
129145_1969.0_2001-02-01	196900	\N	2001-02-01	129145	\N	\N	f	Sales which are qualified	0
129145_2900.0_2004-07-01	290000	\N	2004-07-01	129145	\N	\N	f	Sales which are qualified	0
129145_6350.0_2021-07-22	635000	\N	2021-07-22	129145	\N	\N	f	Qual by exam of deed	0
129146_3000.0_2011-11-21	300000	\N	2011-11-21	129146	\N	\N	f	Qual by exam of deed	0
129146_3625.0_2013-02-28	362500	\N	2013-02-28	129146	\N	\N	f	Qual by exam of deed	0
129146_9750.0_2022-05-31	975000	\N	2022-05-31	129146	\N	\N	f	Qual by exam of deed	0
129147_5490.0_2006-12-01	549000	\N	2006-12-01	129147	\N	\N	f	Sales which are qualified	0
129148_2199.0_2000-10-01	219900	\N	2000-10-01	129148	\N	\N	f	Sales which are qualified	0
129148_2900.0_2012-03-30	290000	\N	2012-03-30	129148	\N	\N	f	Qual by exam of deed	0
129148_3250.0_2004-12-01	325000	\N	2004-12-01	129148	\N	\N	f	Sales which are qualified	0
129148_4900.0_2005-06-01	490000	\N	2005-06-01	129148	\N	\N	f	Sales which are qualified	0
129148_6250.0_2020-08-07	625000	\N	2020-08-07	129148	\N	\N	f	Qual by exam of deed	0
129153_3107.0_2003-05-01	310700	\N	2003-05-01	129153	\N	\N	f	Sales which are qualified	0
129153_3230.0_2004-04-01	323000	\N	2004-04-01	129153	\N	\N	f	Sales which are qualified	0
129158_3550.0_2004-06-01	355000	\N	2004-06-01	129158	\N	\N	f	Sales which are qualified	0
129158_3575.0_2003-02-01	357500	\N	2003-02-01	129158	\N	\N	f	Sales which are qualified	0
129158_7050.0_2015-02-23	705000	\N	2015-02-23	129158	\N	\N	f	Qual by exam of deed	0
129158_7800.0_2021-05-28	780000	\N	2021-05-28	129158	\N	\N	f	Qual by exam of deed	0
129163_3200.0_2011-03-23	320000	\N	2011-03-23	129163	\N	\N	f	Qual by exam of deed	0
129164_1679.0_1998-05-01	167900	\N	1998-05-01	129164	\N	\N	f	Sales which are qualified	0
129165_2580.0_2000-11-01	258000	\N	2000-11-01	129165	\N	\N	f	Sales which are qualified	0
129166_2800.0_2001-02-01	280000	\N	2001-02-01	129166	\N	\N	f	Sales which are qualified	0
129166_3500.0_2012-10-05	350000	\N	2012-10-05	129166	\N	\N	f	Qual by exam of deed	0
129166_7250.0_2021-05-03	725000	\N	2021-05-03	129166	\N	\N	f	Qual by exam of deed	0
129168_2684.0_2002-11-01	268400	\N	2002-11-01	129168	\N	\N	f	Sales which are qualified	0
129168_3500.0_2004-08-01	350000	\N	2004-08-01	129168	\N	\N	f	Sales which are qualified	0
129168_4500.0_2013-02-22	450000	\N	2013-02-22	129168	\N	\N	f	Qual by exam of deed	0
129168_6500.0_2016-11-15	650000	\N	2016-11-15	129168	\N	\N	f	Qual by exam of deed	0
129173_2359.0_2001-01-01	235900	\N	2001-01-01	129173	\N	\N	f	Sales which are qualified	0
129173_3950.0_2005-09-01	395000	\N	2005-09-01	129173	\N	\N	f	Sales which are qualified	0
129173_4000.0_2004-01-01	400000	\N	2004-01-01	129173	\N	\N	f	Sales which are qualified	0
129173_5500.0_2019-01-31	550000	\N	2019-01-31	129173	\N	\N	f	Qual by exam of deed	0
129174_2430.0_2000-12-01	243000	\N	2000-12-01	129174	\N	\N	f	Sales which are qualified	0
129174_3150.0_2004-06-01	315000	\N	2004-06-01	129174	\N	\N	f	Sales which are qualified	0
129174_5200.0_2014-08-18	520000	\N	2014-08-18	129174	\N	\N	f	Qual by exam of deed	0
129176_4200.0_2013-03-08	420000	\N	2013-03-08	129176	\N	\N	f	Qual by exam of deed	0
129176_6850.0_2015-04-23	685000	\N	2015-04-23	129176	\N	\N	f	Qual by exam of deed	0
129177_1735.0_1998-03-01	173500	\N	1998-03-01	129177	\N	\N	f	Sales which are qualified	0
129177_5200.0_2005-11-01	520000	\N	2005-11-01	129177	\N	\N	f	Sales which are qualified	0
129177_5200.0_2013-02-26	520000	\N	2013-02-26	129177	\N	\N	f	Qual by exam of deed	0
129180_2825.0_2003-05-01	282500	\N	2003-05-01	129180	\N	\N	f	Sales which are qualified	0
129180_4200.0_2005-03-01	420000	\N	2005-03-01	129180	\N	\N	f	Sales which are qualified	0
129180_5400.0_2013-02-26	540000	\N	2013-02-26	129180	\N	\N	f	Qual by exam of deed	0
129180_7566.0_2019-11-21	756600	\N	2019-11-21	129180	\N	\N	f	Qual by exam of deed	0
129183_2400.0_1999-12-01	240000	\N	1999-12-01	129183	\N	\N	f	Sales which are qualified	0
129183_8150.0_2020-02-27	815000	\N	2020-02-27	129183	\N	\N	f	Qual by exam of deed	0
129187_2289.0_2000-10-01	228900	\N	2000-10-01	129187	\N	\N	f	Sales which are qualified	0
129187_5500.0_2016-06-09	550000	\N	2016-06-09	129187	\N	\N	f	Qual by exam of deed	0
129187_7250.0_2021-08-16	725000	\N	2021-08-16	129187	\N	\N	f	Qual by exam of deed	0
129189_1699.0_1998-09-01	169900	\N	1998-09-01	129189	\N	\N	f	Sales which are qualified	0
129189_2489.0_2000-12-01	248900	\N	2000-12-01	129189	\N	\N	f	Sales which are qualified	0
129189_3900.0_2003-11-01	390000	\N	2003-11-01	129189	\N	\N	f	Sales which are qualified	0
129190_5900.0_2019-03-15	590000	\N	2019-03-15	129190	\N	\N	f	Qual by exam of deed	0
129192_3100.0_2002-03-01	310000	\N	2002-03-01	129192	\N	\N	f	Sales which are qualified	0
129193_1985.0_1998-06-01	198500	\N	1998-06-01	129193	\N	\N	f	Sales which are qualified	0
129193_3700.0_2008-06-01	370000	\N	2008-06-01	129193	\N	\N	f	Sales which are qualified	0
129193_4150.0_2010-06-17	415000	\N	2010-06-17	129193	\N	\N	f	Qual by exam of deed	0
129193_5050.0_2005-08-01	505000	\N	2005-08-01	129193	\N	\N	f	Sales which are qualified	0
129194_3550.0_2001-06-01	355000	\N	2001-06-01	129194	\N	\N	f	Sales which are qualified	0
129194_4150.0_2013-02-06	415000	\N	2013-02-06	129194	\N	\N	f	Qual by exam of deed	0
129194_6935.0_2019-11-21	693500	\N	2019-11-21	129194	\N	\N	f	Qual by exam of deed	0
129195_1750.0_1998-07-01	175000	\N	1998-07-01	129195	\N	\N	f	Sales which are qualified	0
129195_7650.0_2019-02-22	765000	\N	2019-02-22	129195	\N	\N	f	Qual by exam of deed	0
129196_3580.0_2001-12-01	358000	\N	2001-12-01	129196	\N	\N	f	Sales which are qualified	0
129196_3950.0_2005-03-01	395000	\N	2005-03-01	129196	\N	\N	f	Sales which are qualified	0
129197_3850.0_2001-07-01	385000	\N	2001-07-01	129197	\N	\N	f	Sales which are qualified	0
129197_8200.0_2020-03-03	820000	\N	2020-03-03	129197	\N	\N	f	Qual by exam of deed	0
129198_3700.0_2003-11-01	370000	\N	2003-11-01	129198	\N	\N	f	Sales which are qualified	0
129199_3950.0_2010-11-15	395000	\N	2010-11-15	129199	\N	\N	f	Qual by exam of deed	0
129199_4199.0_2003-10-01	419900	\N	2003-10-01	129199	\N	\N	f	Sales which are qualified	0
129200_14200.0_2022-03-31	1420000	\N	2022-03-31	129200	\N	\N	f	Qual by exam of deed	0
129200_2509.0_2000-09-01	250900	\N	2000-09-01	129200	\N	\N	f	Sales which are qualified	0
129200_4500.0_2005-07-01	450000	\N	2005-07-01	129200	\N	\N	f	Sales which are qualified	0
129200_5700.0_2017-03-21	570000	\N	2017-03-21	129200	\N	\N	f	Qual by exam of deed	0
129200_6800.0_2021-03-12	680000	\N	2021-03-12	129200	\N	\N	f	Qual by exam of deed	0
129201_2564.0_2000-07-01	256400	\N	2000-07-01	129201	\N	\N	f	Sales which are qualified	0
129201_3087.5_2003-10-01	308750	\N	2003-10-01	129201	\N	\N	f	Sales which are qualified	0
129201_3250.0_2002-05-01	325000	\N	2002-05-01	129201	\N	\N	f	Sales which are qualified	0
129201_3661.7_2009-05-07	366170	\N	2009-05-07	129201	\N	\N	f	Qual by exam of deed	0
129201_3900.0_2011-06-30	390000	\N	2011-06-30	129201	\N	\N	f	Qual by exam of deed	0
129203_1720.0_1997-12-01	172000	\N	1997-12-01	129203	\N	\N	f	Sales which are qualified	0
129203_2300.0_2000-09-01	230000	\N	2000-09-01	129203	\N	\N	f	Sales which are qualified	0
129203_3200.0_2004-06-01	320000	\N	2004-06-01	129203	\N	\N	f	Sales which are qualified	0
129203_5000.0_2007-12-01	500000	\N	2007-12-01	129203	\N	\N	f	Sales which are qualified	0
129204_1539.0_1998-09-01	153900	\N	1998-09-01	129204	\N	\N	f	Sales which are qualified	0
129204_5600.0_2007-03-01	560000	\N	2007-03-01	129204	\N	\N	f	Sales which are qualified	0
129206_2315.0_1999-06-01	231500	\N	1999-06-01	129206	\N	\N	f	Sales which are qualified	0
129206_3999.0_2003-11-01	399900	\N	2003-11-01	129206	\N	\N	f	Sales which are qualified	0
129207_2265.0_1999-05-01	226500	\N	1999-05-01	129207	\N	\N	f	Sales which are qualified	0
129207_3800.0_2004-12-01	380000	\N	2004-12-01	129207	\N	\N	f	Sales which are qualified	0
129207_3900.0_2002-06-01	390000	\N	2002-06-01	129207	\N	\N	f	Sales which are qualified	0
129207_7650.0_2018-07-31	765000	\N	2018-07-31	129207	\N	\N	f	Qual by exam of deed	0
129208_6250.0_2007-06-01	625000	\N	2007-06-01	129208	\N	\N	f	Sales which are qualified	0
129208_7500.0_2014-10-28	750000	\N	2014-10-28	129208	\N	\N	f	Qual by exam of deed	0
129208_7557.0_2019-02-22	755700	\N	2019-02-22	129208	\N	\N	f	Qual by exam of deed	0
129209_3130.0_2000-06-01	313000	\N	2000-06-01	129209	\N	\N	f	Sales which are qualified	0
129209_3150.0_2001-05-01	315000	\N	2001-05-01	129209	\N	\N	f	Sales which are qualified	0
129209_6750.0_2014-08-01	675000	\N	2014-08-01	129209	\N	\N	f	Qual by exam of deed	0
129211_3990.0_2004-02-01	399000	\N	2004-02-01	129211	\N	\N	f	Sales which are qualified	0
129211_8400.0_2021-02-27	840000	\N	2021-02-27	129211	\N	\N	f	Qual by exam of deed	0
129212_1879.0_1998-04-01	187900	\N	1998-04-01	129212	\N	\N	f	Sales which are qualified	0
129212_3069.0_2005-03-01	306900	\N	2005-03-01	129212	\N	\N	f	Sales which are qualified	0
129212_3850.0_2002-03-01	385000	\N	2002-03-01	129212	\N	\N	f	Sales which are qualified	0
129212_5100.0_2005-06-01	510000	\N	2005-06-01	129212	\N	\N	f	Sales which are qualified	0
129217_2239.0_1998-04-01	223900	\N	1998-04-01	129217	\N	\N	f	Sales which are qualified	0
129217_4900.0_2011-03-14	490000	\N	2011-03-14	129217	\N	\N	f	Qual by exam of deed	0
129218_11650.0_2015-04-10	1165000	\N	2015-04-10	129218	\N	\N	f	Qual by exam of deed	0
129218_2279.0_1998-05-01	227900	\N	1998-05-01	129218	\N	\N	f	Sales which are qualified	0
129218_5150.0_2005-02-01	515000	\N	2005-02-01	129218	\N	\N	f	Sales which are qualified	0
129218_5500.0_2008-09-26	550000	\N	2008-09-26	129218	\N	\N	f	Sales which are qualified	0
129219_2149.0_1997-10-01	214900	\N	1997-10-01	129219	\N	\N	f	Sales which are qualified	0
129219_8200.0_2013-09-09	820000	\N	2013-09-09	129219	\N	\N	f	Qual by exam of deed	0
129220_15000.0_2020-11-10	1500000	\N	2020-11-10	129220	\N	\N	f	Qual by exam of deed	0
129220_2350.0_1998-08-01	235000	\N	1998-08-01	129220	\N	\N	f	Sales which are qualified	0
129220_9000.0_2017-04-03	900000	\N	2017-04-03	129220	\N	\N	f	Qual by exam of deed	0
129221_2004.0_1998-01-01	200400	\N	1998-01-01	129221	\N	\N	f	Sales which are qualified	0
129221_5150.0_2008-05-01	515000	\N	2008-05-01	129221	\N	\N	f	Sales which are qualified	0
129224_1890.0_1998-03-01	189000	\N	1998-03-01	129224	\N	\N	f	Sales which are qualified	0
129224_5300.0_2004-03-01	530000	\N	2004-03-01	129224	\N	\N	f	Sales which are qualified	0
129224_5500.0_2008-05-01	550000	\N	2008-05-01	129224	\N	\N	f	Sales which are qualified	0
129225_4999.0_2003-09-01	499900	\N	2003-09-01	129225	\N	\N	f	Sales which are qualified	0
129225_8350.0_2013-03-14	835000	\N	2013-03-14	129225	\N	\N	f	Qual by exam of deed	0
129226_12250.0_2017-08-31	1225000	\N	2017-08-31	129226	\N	\N	f	Qual by exam of deed	0
129226_3480.0_2011-09-15	348000	\N	2011-09-15	129226	\N	\N	f	Qual by exam of deed	0
129226_8950.0_2005-08-01	895000	\N	2005-08-01	129226	\N	\N	f	Sales which are qualified	0
129227_12300.0_2017-08-29	1230000	\N	2017-08-29	129227	\N	\N	f	Qual by exam of deed	0
129227_3450.0_2011-08-31	345000	\N	2011-08-31	129227	\N	\N	f	Qual by exam of deed	0
129227_6000.0_2003-09-01	600000	\N	2003-09-01	129227	\N	\N	f	Sales which are qualified	0
129228_3770.0_2000-08-01	377000	\N	2000-08-01	129228	\N	\N	f	Sales which are qualified	0
129228_7550.0_2006-11-01	755000	\N	2006-11-01	129228	\N	\N	f	Sales which are qualified	0
129228_9300.0_2014-05-30	930000	\N	2014-05-30	129228	\N	\N	f	Qual by exam of deed	0
129230_3095.0_1999-07-01	309500	\N	1999-07-01	129230	\N	\N	f	Sales which are qualified	0
129230_5100.0_2009-12-30	510000	\N	2009-12-30	129230	\N	\N	f	Qual by exam of deed	0
129236_16000.0_2017-12-18	1600000	\N	2017-12-18	129236	\N	\N	f	Qual by exam of deed	0
129236_2330.0_1998-01-01	233000	\N	1998-01-01	129236	\N	\N	f	Sales which are qualified	0
129236_4170.0_2002-08-01	417000	\N	2002-08-01	129236	\N	\N	f	Sales which are qualified	0
129236_5500.0_2011-04-13	550000	\N	2011-04-13	129236	\N	\N	f	Qual by exam of deed	0
129237_3100.0_1999-10-01	310000	\N	1999-10-01	129237	\N	\N	f	Sales which are qualified	0
129238_3539.0_1999-11-01	353900	\N	1999-11-01	129238	\N	\N	f	Sales which are qualified	0
129238_5100.0_2003-12-01	510000	\N	2003-12-01	129238	\N	\N	f	Sales which are qualified	0
129238_9400.0_2013-12-09	940000	\N	2013-12-09	129238	\N	\N	f	Qual by exam of deed	0
129239_3450.0_1999-10-01	345000	\N	1999-10-01	129239	\N	\N	f	Sales which are qualified	0
129239_5600.0_2010-03-25	560000	\N	2010-03-25	129239	\N	\N	f	Qual by exam of deed	0
129240_47500.0_2022-03-18	4750000	\N	2022-03-18	129240	\N	\N	f	Qual by exam of deed	0
129241_20000.0_2023-06-02	2000000	\N	2023-06-02	129241	\N	\N	f	Qual by exam of deed	0
129241_6430.0_2003-02-01	643000	\N	2003-02-01	129241	\N	\N	f	Sales which are qualified	0
129242_3500.0_2001-03-01	350000	\N	2001-03-01	129242	\N	\N	f	Sales which are qualified	0
129243_10400.0_2016-07-22	1040000	\N	2016-07-22	129243	\N	\N	f	Qual by exam of deed	0
129243_3680.0_2003-04-01	368000	\N	2003-04-01	129243	\N	\N	f	Sales which are qualified	0
129243_5300.0_2005-04-01	530000	\N	2005-04-01	129243	\N	\N	f	Sales which are qualified	0
129243_7400.0_2013-01-16	740000	\N	2013-01-16	129243	\N	\N	f	Qual by exam of deed	0
129244_5700.0_2003-07-01	570000	\N	2003-07-01	129244	\N	\N	f	Sales which are qualified	0
129244_6050.0_2008-09-23	605000	\N	2008-09-23	129244	\N	\N	f	Sales which are qualified	0
129244_7200.0_2005-07-01	720000	\N	2005-07-01	129244	\N	\N	f	Sales which are qualified	0
129244_7300.0_2007-06-01	730000	\N	2007-06-01	129244	\N	\N	f	Sales which are qualified	0
129245_2118.0_1998-01-01	211800	\N	1998-01-01	129245	\N	\N	f	Sales which are qualified	0
129245_4600.0_2004-09-01	460000	\N	2004-09-01	129245	\N	\N	f	Sales which are qualified	0
129245_5700.0_2012-02-02	570000	\N	2012-02-02	129245	\N	\N	f	Qual by exam of deed	0
129245_7100.0_2005-06-01	710000	\N	2005-06-01	129245	\N	\N	f	Sales which are qualified	0
129246_3760.0_2000-02-01	376000	\N	2000-02-01	129246	\N	\N	f	Sales which are qualified	0
129246_5200.0_2012-03-02	520000	\N	2012-03-02	129246	\N	\N	f	Qual by exam of deed	0
129246_7100.0_2005-11-01	710000	\N	2005-11-01	129246	\N	\N	f	Sales which are qualified	0
129247_5100.0_2011-08-09	510000	\N	2011-08-09	129247	\N	\N	f	Qual by exam of deed	0
129247_5650.0_2002-10-01	565000	\N	2002-10-01	129247	\N	\N	f	Sales which are qualified	0
129247_7790.0_2005-09-01	779000	\N	2005-09-01	129247	\N	\N	f	Sales which are qualified	0
129248_13250.0_2017-12-07	1325000	\N	2017-12-07	129248	\N	\N	f	Qual by exam of deed	0
129248_2000.0_1997-12-01	200000	\N	1997-12-01	129248	\N	\N	f	Sales which are qualified	0
129248_5700.0_2003-03-01	570000	\N	2003-03-01	129248	\N	\N	f	Sales which are qualified	0
129248_6150.0_2005-02-01	615000	\N	2005-02-01	129248	\N	\N	f	Sales which are qualified	0
129248_7370.0_2005-07-01	737000	\N	2005-07-01	129248	\N	\N	f	Sales which are qualified	0
129250_13600.0_2015-04-24	1360000	\N	2015-04-24	129250	\N	\N	f	Qual by exam of deed	0
129250_2139.0_1997-10-01	213900	\N	1997-10-01	129250	\N	\N	f	Sales which are qualified	0
129250_3750.0_2002-11-01	375000	\N	2002-11-01	129250	\N	\N	f	Sales which are qualified	0
129250_5200.0_2005-03-01	520000	\N	2005-03-01	129250	\N	\N	f	Sales which are qualified	0
129251_2190.0_1998-04-01	219000	\N	1998-04-01	129251	\N	\N	f	Sales which are qualified	0
129251_4100.0_2002-06-01	410000	\N	2002-06-01	129251	\N	\N	f	Sales which are qualified	0
129252_3325.0_1999-12-01	332500	\N	1999-12-01	129252	\N	\N	f	Sales which are qualified	0
129253_5700.0_2004-01-01	570000	\N	2004-01-01	129253	\N	\N	f	Sales which are qualified	0
129253_8500.0_2013-05-15	850000	\N	2013-05-15	129253	\N	\N	f	Qual by exam of deed	0
129254_23000.0_2022-03-12	2300000	\N	2022-03-12	129254	\N	\N	f	Qual by exam of deed	0
129254_7850.0_2005-04-01	785000	\N	2005-04-01	129254	\N	\N	f	Sales which are qualified	0
129256_15500.0_2015-06-12	1550000	\N	2015-06-12	129256	\N	\N	f	Qual by exam of deed	0
129256_3450.0_1998-07-01	345000	\N	1998-07-01	129256	\N	\N	f	Sales which are qualified	0
129256_4700.0_2002-12-01	470000	\N	2002-12-01	129256	\N	\N	f	Sales which are qualified	0
129256_7250.0_2005-02-01	725000	\N	2005-02-01	129256	\N	\N	f	Sales which are qualified	0
129257_2180.0_1997-09-01	218000	\N	1997-09-01	129257	\N	\N	f	Sales which are qualified	0
129259_12000.0_2017-08-01	1200000	\N	2017-08-01	129259	\N	\N	f	Qual by exam of deed	0
129259_19500.0_2019-10-18	1950000	\N	2019-10-18	129259	\N	\N	f	Qual by exam of deed	0
129259_2789.0_1998-04-01	278900	\N	1998-04-01	129259	\N	\N	f	Sales which are qualified	0
129261_2619.0_1998-07-01	261900	\N	1998-07-01	129261	\N	\N	f	Sales which are qualified	0
129262_2620.0_1997-11-01	262000	\N	1997-11-01	129262	\N	\N	f	Sales which are qualified	0
129262_4900.0_2002-04-01	490000	\N	2002-04-01	129262	\N	\N	f	Sales which are qualified	0
129262_5150.0_2003-04-01	515000	\N	2003-04-01	129262	\N	\N	f	Sales which are qualified	0
129262_6750.0_2011-05-04	675000	\N	2011-05-04	129262	\N	\N	f	Qual by exam of deed	0
129262_9200.0_2012-05-08	920000	\N	2012-05-08	129262	\N	\N	f	Qual by exam of deed	0
129263_16500.0_2021-03-26	1650000	\N	2021-03-26	129263	\N	\N	f	Qual by exam of deed	0
129263_2540.0_1998-01-01	254000	\N	1998-01-01	129263	\N	\N	f	Sales which are qualified	0
129263_6750.0_2009-12-31	675000	\N	2009-12-31	129263	\N	\N	f	Qual by exam of deed	0
129267_12950.0_2013-08-30	1295000	\N	2013-08-30	129267	\N	\N	f	Qual by exam of deed	0
129267_23000.0_2021-11-12	2300000	\N	2021-11-12	129267	\N	\N	f	Qual by exam of deed	0
129267_5520.0_2002-10-01	552000	\N	2002-10-01	129267	\N	\N	f	Sales which are qualified	0
129267_6000.0_2000-01-01	600000	\N	2000-01-01	129267	\N	\N	f	Sales which are qualified	0
129270_17500.0_2021-06-22	1750000	\N	2021-06-22	129270	\N	\N	f	Qual by exam of deed	0
129270_3869.0_2000-10-01	386900	\N	2000-10-01	129270	\N	\N	f	Sales which are qualified	0
129270_6100.0_2004-12-01	610000	\N	2004-12-01	129270	\N	\N	f	Sales which are qualified	0
129273_4800.0_2002-12-01	480000	\N	2002-12-01	129273	\N	\N	f	Sales which are qualified	0
129274_24750.0_2022-08-10	2475000	\N	2022-08-10	129274	\N	\N	f	Qual by exam of deed	0
129274_3750.0_1999-04-01	375000	\N	1999-04-01	129274	\N	\N	f	Sales which are qualified	0
129274_5600.0_2004-09-01	560000	\N	2004-09-01	129274	\N	\N	f	Sales which are qualified	0
129276_2529.0_1998-01-01	252900	\N	1998-01-01	129276	\N	\N	f	Sales which are qualified	0
129276_4900.0_2003-11-01	490000	\N	2003-11-01	129276	\N	\N	f	Sales which are qualified	0
129277_11000.0_2014-01-27	1100000	\N	2014-01-27	129277	\N	\N	f	Qual by exam of deed	0
129277_4550.0_2001-01-01	455000	\N	2001-01-01	129277	\N	\N	f	Sales which are qualified	0
129278_3599.0_1999-08-01	359900	\N	1999-08-01	129278	\N	\N	f	Sales which are qualified	0
129278_4800.0_2003-04-01	480000	\N	2003-04-01	129278	\N	\N	f	Sales which are qualified	0
129278_6320.0_2011-05-05	632000	\N	2011-05-05	129278	\N	\N	f	Qual by exam of deed	0
129279_3623.0_1999-06-01	362300	\N	1999-06-01	129279	\N	\N	f	Sales which are qualified	0
129279_5090.0_2003-05-01	509000	\N	2003-05-01	129279	\N	\N	f	Sales which are qualified	0
129280_4990.0_2003-05-01	499000	\N	2003-05-01	129280	\N	\N	f	Sales which are qualified	0
129280_5600.0_2000-06-01	560000	\N	2000-06-01	129280	\N	\N	f	Sales which are qualified	0
129281_11000.0_2006-07-01	1100000	\N	2006-07-01	129281	\N	\N	f	Sales which are qualified	0
129281_6750.0_2004-05-01	675000	\N	2004-05-01	129281	\N	\N	f	Sales which are qualified	0
129281_9250.0_2012-09-14	925000	\N	2012-09-14	129281	\N	\N	f	Qual by exam of deed	0
129282_10400.0_2005-08-01	1040000	\N	2005-08-01	129282	\N	\N	f	Sales which are qualified	0
129282_5290.0_2003-06-01	529000	\N	2003-06-01	129282	\N	\N	f	Sales which are qualified	0
129282_6800.0_2004-12-01	680000	\N	2004-12-01	129282	\N	\N	f	Sales which are qualified	0
129282_9500.0_2014-03-13	950000	\N	2014-03-13	129282	\N	\N	f	Qual by exam of deed	0
129283_1060.0_1998-02-01	106000	\N	1998-02-01	129283	\N	\N	f	Sales which are qualified	0
129283_2060.0_2004-10-01	206000	\N	2004-10-01	129283	\N	\N	f	Sales which are qualified	0
129284_1070.0_1998-05-01	107000	\N	1998-05-01	129284	\N	\N	f	Sales which are qualified	0
129284_1450.0_1999-10-01	145000	\N	1999-10-01	129284	\N	\N	f	Sales which are qualified	0
129284_2000.0_2001-11-01	200000	\N	2001-11-01	129284	\N	\N	f	Sales which are qualified	0
129284_4180.0_2013-11-08	418000	\N	2013-11-08	129284	\N	\N	f	Qual by exam of deed	0
129284_4500.0_2017-06-19	450000	\N	2017-06-19	129284	\N	\N	f	Qual by exam of deed	0
129284_4950.0_2015-01-06	495000	\N	2015-01-06	129284	\N	\N	f	Qual by exam of deed	0
129285_1130.0_1997-10-01	113000	\N	1997-10-01	129285	\N	\N	f	Sales which are qualified	0
129285_2550.0_2004-07-01	255000	\N	2004-07-01	129285	\N	\N	f	Sales which are qualified	0
129285_2650.0_2012-06-07	265000	\N	2012-06-07	129285	\N	\N	f	Qual by exam of deed	0
129285_6500.0_2021-10-29	650000	\N	2021-10-29	129285	\N	\N	f	Qual by exam of deed	0
129286_1209.0_1998-06-01	120900	\N	1998-06-01	129286	\N	\N	f	Sales which are qualified	0
129286_5000.0_2015-02-09	500000	\N	2015-02-09	129286	\N	\N	f	Qual by exam of deed	0
129286_6490.0_2015-06-05	649000	\N	2015-06-05	129286	\N	\N	f	Qual by exam of deed	0
129287_1500.0_1999-10-01	150000	\N	1999-10-01	129287	\N	\N	f	Sales which are qualified	0
129287_1925.0_2001-06-01	192500	\N	2001-06-01	129287	\N	\N	f	Sales which are qualified	0
129291_1786.0_1999-10-01	178600	\N	1999-10-01	129291	\N	\N	f	Sales which are qualified	0
129291_1880.0_2002-06-01	188000	\N	2002-06-01	129291	\N	\N	f	Sales which are qualified	0
129291_2140.0_2010-09-12	214000	\N	2010-09-12	129291	\N	\N	f	Qual by exam of deed	0
129291_2140.0_2012-06-08	214000	\N	2012-06-08	129291	\N	\N	f	Qual by exam of deed	0
129291_2250.0_2003-12-01	225000	\N	2003-12-01	129291	\N	\N	f	Sales which are qualified	0
129291_6600.0_2015-12-17	660000	\N	2015-12-17	129291	\N	\N	f	Qual by exam of deed	0
129293_1890.0_1999-12-01	189000	\N	1999-12-01	129293	\N	\N	f	Sales which are qualified	0
129293_6800.0_2021-07-20	680000	\N	2021-07-20	129293	\N	\N	f	Qual by exam of deed	0
129294_2650.0_2003-01-01	265000	\N	2003-01-01	129294	\N	\N	f	Sales which are qualified	0
129294_3300.0_2005-04-01	330000	\N	2005-04-01	129294	\N	\N	f	Sales which are qualified	0
129294_6090.0_2021-04-05	609000	\N	2021-04-05	129294	\N	\N	f	Qual by exam of deed	0
129296_1420.0_2001-01-01	142000	\N	2001-01-01	129296	\N	\N	f	Sales which are qualified	0
129296_1900.0_2004-12-01	190000	\N	2004-12-01	129296	\N	\N	f	Sales which are qualified	0
129296_3050.0_2018-06-15	305000	\N	2018-06-15	129296	\N	\N	f	Qual by exam of deed	0
129296_3400.0_2013-11-18	340000	\N	2013-11-18	129296	\N	\N	f	Qual by exam of deed	0
129297_1439.0_1999-11-01	143900	\N	1999-11-01	129297	\N	\N	f	Sales which are qualified	0
129297_1900.0_2008-11-24	190000	\N	2008-11-24	129297	\N	\N	f	Other disqualified	0
129297_1920.0_2010-10-27	192000	\N	2010-10-27	129297	\N	\N	f	Qual by exam of deed	0
129297_2156.0_2005-03-01	215600	\N	2005-03-01	129297	\N	\N	f	Sales which are qualified	0
129297_3036.0_2005-06-01	303600	\N	2005-06-01	129297	\N	\N	f	Sales which are qualified	0
129299_1499.0_1999-05-01	149900	\N	1999-05-01	129299	\N	\N	f	Sales which are qualified	0
129299_1680.0_2002-04-01	168000	\N	2002-04-01	129299	\N	\N	f	Sales which are qualified	0
129299_1990.0_2011-04-01	199000	\N	2011-04-01	129299	\N	\N	f	Qual by exam of deed	0
129299_4700.0_2019-12-31	470000	\N	2019-12-31	129299	\N	\N	f	Qual by exam of deed	0
129300_1529.0_1999-10-01	152900	\N	1999-10-01	129300	\N	\N	f	Sales which are qualified	0
129300_2000.0_2003-10-01	200000	\N	2003-10-01	129300	\N	\N	f	Sales which are qualified	0
129300_2100.0_2009-03-20	210000	\N	2009-03-20	129300	\N	\N	f	Qual by exam of deed	0
129301_2169.0_2001-08-01	216900	\N	2001-08-01	129301	\N	\N	f	Sales which are qualified	0
129301_2550.0_2005-01-01	255000	\N	2005-01-01	129301	\N	\N	f	Sales which are qualified	0
129301_3250.0_2005-07-01	325000	\N	2005-07-01	129301	\N	\N	f	Sales which are qualified	0
129302_1520.0_1999-11-01	152000	\N	1999-11-01	129302	\N	\N	f	Sales which are qualified	0
129302_1800.0_2011-03-25	180000	\N	2011-03-25	129302	\N	\N	f	Qual by exam of deed	0
129305_1978.0_2002-08-01	197800	\N	2002-08-01	129305	\N	\N	f	Sales which are qualified	0
129305_2525.0_2005-02-01	252500	\N	2005-02-01	129305	\N	\N	f	Sales which are qualified	0
129305_3180.0_2005-05-01	318000	\N	2005-05-01	129305	\N	\N	f	Sales which are qualified	0
129305_5250.0_2021-05-27	525000	\N	2021-05-27	129305	\N	\N	f	Qual by exam of deed	0
129306_2650.0_2003-05-01	265000	\N	2003-05-01	129306	\N	\N	f	Sales which are qualified	0
129307_2600.0_2003-10-01	260000	\N	2003-10-01	129307	\N	\N	f	Sales which are qualified	0
129307_3050.0_2005-05-01	305000	\N	2005-05-01	129307	\N	\N	f	Sales which are qualified	0
129307_3900.0_2018-09-06	390000	\N	2018-09-06	129307	\N	\N	f	Qual by exam of deed	0
129308_2150.0_2010-06-14	215000	\N	2010-06-14	129308	\N	\N	f	Qual by exam of deed	0
129308_2880.0_2003-12-01	288000	\N	2003-12-01	129308	\N	\N	f	Sales which are qualified	0
129309_1100.0_2009-04-30	110000	\N	2009-04-30	129309	\N	\N	f	Qual by exam of deed	0
129309_1576.0_2001-04-01	157600	\N	2001-04-01	129309	\N	\N	f	Sales which are qualified	0
129311_1870.0_2003-07-01	187000	\N	2003-07-01	129311	\N	\N	f	Sales which are qualified	0
129312_1530.0_2000-01-01	153000	\N	2000-01-01	129312	\N	\N	f	Sales which are qualified	0
129312_2100.0_2011-07-05	210000	\N	2011-07-05	129312	\N	\N	f	Qual by exam of deed	0
129312_2270.0_2004-10-01	227000	\N	2004-10-01	129312	\N	\N	f	Sales which are qualified	0
129312_5300.0_2021-04-29	530000	\N	2021-04-29	129312	\N	\N	f	Qual by exam of deed	0
129313_1040.0_1997-10-01	104000	\N	1997-10-01	129313	\N	\N	f	Sales which are qualified	0
129313_2770.0_2008-06-01	277000	\N	2008-06-01	129313	\N	\N	f	Sales which are qualified	0
129313_4175.0_2017-10-18	417500	\N	2017-10-18	129313	\N	\N	f	Qual by exam of deed	0
129315_1930.0_2003-05-01	193000	\N	2003-05-01	129315	\N	\N	f	Sales which are qualified	0
129315_3800.0_2013-06-17	380000	\N	2013-06-17	129315	\N	\N	f	Qual by exam of deed	0
129316_1879.0_2000-10-01	187900	\N	2000-10-01	129316	\N	\N	f	Sales which are qualified	0
129316_3505.0_2017-05-16	350500	\N	2017-05-16	129316	\N	\N	f	Qual by exam of deed	0
129316_4600.0_2021-05-05	460000	\N	2021-05-05	129316	\N	\N	f	Qual by exam of deed	0
129317_1850.0_2009-08-24	185000	\N	2009-08-24	129317	\N	\N	f	Qual by exam of deed	0
129317_1939.0_2001-01-01	193900	\N	2001-01-01	129317	\N	\N	f	Sales which are qualified	0
129317_2250.0_2004-09-01	225000	\N	2004-09-01	129317	\N	\N	f	Sales which are qualified	0
129317_4580.0_2019-08-07	458000	\N	2019-08-07	129317	\N	\N	f	Qual by exam of deed	0
129318_2280.0_2003-01-01	228000	\N	2003-01-01	129318	\N	\N	f	Sales which are qualified	0
129318_3600.0_2007-05-01	360000	\N	2007-05-01	129318	\N	\N	f	Sales which are qualified	0
129318_5850.0_2021-12-16	585000	\N	2021-12-16	129318	\N	\N	f	Qual by exam of deed	0
129319_18750.0_2019-05-06	1875000	\N	2019-05-06	129319	\N	\N	t	Qual on DOS, multi-parcel sale	0
129319_2150.0_2011-12-12	215000	\N	2011-12-12	129319	\N	\N	f	Qual by exam of deed	0
129319_2350.0_2008-12-30	235000	\N	2008-12-30	129319	\N	\N	f	Sales which are qualified	0
129319_2500.0_2002-06-01	250000	\N	2002-06-01	129319	\N	\N	f	Sales which are qualified	0
129319_2850.0_2005-04-01	285000	\N	2005-04-01	129319	\N	\N	f	Sales which are qualified	0
129319_5000.0_2015-05-27	500000	\N	2015-05-27	129319	\N	\N	f	Qual by exam of deed	0
129319_5250.0_2016-10-20	525000	\N	2016-10-20	129319	\N	\N	f	Qual by exam of deed	0
129320_2500.0_2003-11-01	250000	\N	2003-11-01	129320	\N	\N	f	Sales which are qualified	0
129320_3350.0_2005-07-01	335000	\N	2005-07-01	129320	\N	\N	f	Sales which are qualified	0
129320_3900.0_2018-02-22	390000	\N	2018-02-22	129320	\N	\N	f	Qual by exam of deed	0
129320_4600.0_2006-04-01	460000	\N	2006-04-01	129320	\N	\N	f	Sales which are qualified	0
129321_2696.0_2003-12-01	269600	\N	2003-12-01	129321	\N	\N	f	Sales which are qualified	0
129321_3783.0_2005-06-01	378300	\N	2005-06-01	129321	\N	\N	f	Sales which are qualified	0
129326_1734.0_1999-08-01	173400	\N	1999-08-01	129326	\N	\N	f	Sales which are qualified	0
129326_2400.0_2001-02-01	240000	\N	2001-02-01	129326	\N	\N	f	Sales which are qualified	0
129326_3200.0_2002-06-01	320000	\N	2002-06-01	129326	\N	\N	f	Sales which are qualified	0
129326_6430.0_2006-09-01	643000	\N	2006-09-01	129326	\N	\N	f	Sales which are qualified	0
129327_2700.0_2009-03-03	270000	\N	2009-03-03	129327	\N	\N	f	Qual by exam of deed	0
129327_3164.5_2004-04-01	316450	\N	2004-04-01	129327	\N	\N	f	Sales which are qualified	0
129328_1820.0_1999-02-01	182000	\N	1999-02-01	129328	\N	\N	f	Sales which are qualified	0
129328_3475.0_2004-11-01	347500	\N	2004-11-01	129328	\N	\N	f	Sales which are qualified	0
129331_2189.0_2000-01-01	218900	\N	2000-01-01	129331	\N	\N	f	Sales which are qualified	0
129331_3450.0_2004-07-01	345000	\N	2004-07-01	129331	\N	\N	f	Sales which are qualified	0
129331_3990.0_2005-02-01	399000	\N	2005-02-01	129331	\N	\N	f	Sales which are qualified	0
129333_3990.0_2004-07-01	399000	\N	2004-07-01	129333	\N	\N	f	Sales which are qualified	0
129336_2325.0_2009-09-28	232500	\N	2009-09-28	129336	\N	\N	f	Qual by exam of deed	0
129336_2725.0_2002-05-01	272500	\N	2002-05-01	129336	\N	\N	f	Sales which are qualified	0
129337_3000.0_2004-05-01	300000	\N	2004-05-01	129337	\N	\N	f	Sales which are qualified	0
129337_4150.0_2013-06-12	415000	\N	2013-06-12	129337	\N	\N	f	Qual by exam of deed	0
129337_5700.0_2018-07-23	570000	\N	2018-07-23	129337	\N	\N	f	Qual by exam of deed	0
129338_4400.0_2012-06-08	440000	\N	2012-06-08	129338	\N	\N	f	Qual by exam of deed	0
129339_14500.0_2022-04-29	1450000	\N	2022-04-29	129339	\N	\N	f	Qual by exam of deed	0
129339_1799.0_1998-08-01	179900	\N	1998-08-01	129339	\N	\N	f	Sales which are qualified	0
129339_1999.0_2003-01-01	199900	\N	2003-01-01	129339	\N	\N	f	Sales which are qualified	0
129339_2675.0_2001-03-01	267500	\N	2001-03-01	129339	\N	\N	f	Sales which are qualified	0
129339_6750.0_2014-05-21	675000	\N	2014-05-21	129339	\N	\N	f	Qual by exam of deed	0
129340_13250.0_2023-05-01	1325000	\N	2023-05-01	129340	\N	\N	f	Qual by exam of deed	0
129340_1910.0_1999-05-01	191000	\N	1999-05-01	129340	\N	\N	f	Sales which are qualified	0
129340_9000.0_2022-03-09	900000	\N	2022-03-09	129340	\N	\N	f	Qual by exam of deed	0
129342_11500.0_2021-07-20	1150000	\N	2021-07-20	129342	\N	\N	f	Qual by exam of deed	0
129342_2500.0_2001-04-01	250000	\N	2001-04-01	129342	\N	\N	f	Sales which are qualified	0
129342_3200.0_2003-09-01	320000	\N	2003-09-01	129342	\N	\N	f	Sales which are qualified	0
129342_3400.0_2005-07-01	340000	\N	2005-07-01	129342	\N	\N	f	Sales which are qualified	0
129342_6899.0_2006-06-01	689900	\N	2006-06-01	129342	\N	\N	f	Sales which are qualified	0
129346_3350.0_2002-06-01	335000	\N	2002-06-01	129346	\N	\N	f	Sales which are qualified	0
129346_8600.0_2021-06-25	860000	\N	2021-06-25	129346	\N	\N	f	Qual by exam of deed	0
129347_3690.0_2003-02-01	369000	\N	2003-02-01	129347	\N	\N	f	Sales which are qualified	0
129348_10595.0_2015-09-03	1059500	\N	2015-09-03	129348	\N	\N	f	Qual by exam of deed	0
129348_4270.0_2003-12-01	427000	\N	2003-12-01	129348	\N	\N	f	Sales which are qualified	0
129348_7050.0_2012-03-22	705000	\N	2012-03-22	129348	\N	\N	f	Qual by exam of deed	0
129349_1586.0_1999-09-01	158600	\N	1999-09-01	129349	\N	\N	f	Sales which are qualified	0
129349_2399.0_2003-10-01	239900	\N	2003-10-01	129349	\N	\N	f	Sales which are qualified	0
129349_2400.0_2002-10-01	240000	\N	2002-10-01	129349	\N	\N	f	Sales which are qualified	0
129349_2920.0_2005-02-01	292000	\N	2005-02-01	129349	\N	\N	f	Sales which are qualified	0
129349_3100.0_2012-12-14	310000	\N	2012-12-14	129349	\N	\N	f	Qual by exam of deed	0
129350_1680.0_1999-09-01	168000	\N	1999-09-01	129350	\N	\N	f	Sales which are qualified	0
129350_2470.0_2003-06-01	247000	\N	2003-06-01	129350	\N	\N	f	Sales which are qualified	0
129353_1660.0_1999-09-01	166000	\N	1999-09-01	129353	\N	\N	f	Sales which are qualified	0
129353_4000.0_2003-12-01	400000	\N	2003-12-01	129353	\N	\N	f	Sales which are qualified	0
129353_4350.0_2005-07-01	435000	\N	2005-07-01	129353	\N	\N	f	Sales which are qualified	0
129354_2900.0_2001-08-01	290000	\N	2001-08-01	129354	\N	\N	f	Sales which are qualified	0
129355_1720.0_1999-09-01	172000	\N	1999-09-01	129355	\N	\N	f	Sales which are qualified	0
129356_1850.0_1999-12-01	185000	\N	1999-12-01	129356	\N	\N	f	Sales which are qualified	0
129356_3500.0_2011-05-09	350000	\N	2011-05-09	129356	\N	\N	f	Qual by exam of deed	0
129356_6300.0_2016-07-01	630000	\N	2016-07-01	129356	\N	\N	f	Qual by exam of deed	0
129357_3099.0_2001-11-01	309900	\N	2001-11-01	129357	\N	\N	f	Sales which are qualified	0
129357_4550.0_2005-06-01	455000	\N	2005-06-01	129357	\N	\N	f	Sales which are qualified	0
129359_11500.0_2023-05-31	1150000	\N	2023-05-31	129359	\N	\N	f	Qual by exam of deed	0
129360_3299.0_2003-08-01	329900	\N	2003-08-01	129360	\N	\N	f	Sales which are qualified	0
129360_3566.7_2010-03-31	356670	\N	2010-03-31	129360	\N	\N	f	Qual by exam of deed	0
129360_5850.0_2018-01-10	585000	\N	2018-01-10	129360	\N	\N	f	Qual by exam of deed	0
129361_3891.0_2003-12-01	389100	\N	2003-12-01	129361	\N	\N	f	Sales which are qualified	0
129361_3949.0_2007-09-01	394900	\N	2007-09-01	129361	\N	\N	f	Sales which are qualified	0
129365_1529.0_1998-08-01	152900	\N	1998-08-01	129365	\N	\N	f	Sales which are qualified	0
129365_2620.0_2001-06-01	262000	\N	2001-06-01	129365	\N	\N	f	Sales which are qualified	0
129365_3250.0_2013-09-25	325000	\N	2013-09-25	129365	\N	\N	f	Qual by exam of deed	0
129366_1459.0_1997-12-01	145900	\N	1997-12-01	129366	\N	\N	f	Sales which are qualified	0
129366_3500.0_2012-03-23	350000	\N	2012-03-23	129366	\N	\N	f	Qual by exam of deed	0
129366_4300.0_2005-05-01	430000	\N	2005-05-01	129366	\N	\N	f	Sales which are qualified	0
129367_2870.0_2001-10-01	287000	\N	2001-10-01	129367	\N	\N	f	Sales which are qualified	0
129367_3347.5_2004-05-01	334750	\N	2004-05-01	129367	\N	\N	f	Sales which are qualified	0
129367_3900.0_2005-03-01	390000	\N	2005-03-01	129367	\N	\N	f	Sales which are qualified	0
129368_1750.0_1999-08-01	175000	\N	1999-08-01	129368	\N	\N	f	Sales which are qualified	0
129368_2750.0_2003-09-01	275000	\N	2003-09-01	129368	\N	\N	f	Sales which are qualified	0
129368_5850.0_2016-11-30	585000	\N	2016-11-30	129368	\N	\N	f	Qual by exam of deed	0
129368_6550.0_2020-03-31	655000	\N	2020-03-31	129368	\N	\N	f	Qual by exam of deed	0
129369_1739.0_1999-09-01	173900	\N	1999-09-01	129369	\N	\N	f	Sales which are qualified	0
129369_4350.0_2012-05-23	435000	\N	2012-05-23	129369	\N	\N	f	Qual by exam of deed	0
129369_6300.0_2019-06-27	630000	\N	2019-06-27	129369	\N	\N	f	Qual by exam of deed	0
129371_3350.0_2004-11-01	335000	\N	2004-11-01	129371	\N	\N	f	Sales which are qualified	0
129372_1970.0_1999-11-01	197000	\N	1999-11-01	129372	\N	\N	f	Sales which are qualified	0
129372_2700.0_2003-06-01	270000	\N	2003-06-01	129372	\N	\N	f	Sales which are qualified	0
129372_8000.0_2014-07-27	800000	\N	2014-07-27	129372	\N	\N	f	Qual by exam of deed	0
129373_10650.0_2022-04-07	1065000	\N	2022-04-07	129373	\N	\N	f	Qual by exam of deed	0
129373_3200.0_2009-10-29	320000	\N	2009-10-29	129373	\N	\N	f	Qual by exam of deed	0
129373_3299.0_2003-09-01	329900	\N	2003-09-01	129373	\N	\N	f	Sales which are qualified	0
129374_3720.0_2003-06-01	372000	\N	2003-06-01	129374	\N	\N	f	Sales which are qualified	0
129374_4350.0_2012-05-31	435000	\N	2012-05-31	129374	\N	\N	f	Qual by exam of deed	0
129374_5600.0_2005-08-01	560000	\N	2005-08-01	129374	\N	\N	f	Sales which are qualified	0
129374_6400.0_2017-05-17	640000	\N	2017-05-17	129374	\N	\N	f	Qual by exam of deed	0
129375_8050.0_2018-05-30	805000	\N	2018-05-30	129375	\N	\N	f	Qual by exam of deed	0
129376_1800.0_2009-06-18	180000	\N	2009-06-18	129376	\N	\N	f	Qual by exam of deed	0
129376_2186.0_2002-09-01	218600	\N	2002-09-01	129376	\N	\N	f	Sales which are qualified	0
129376_3950.0_2004-08-01	395000	\N	2004-08-01	129376	\N	\N	f	Sales which are qualified	0
129376_5300.0_2006-04-01	530000	\N	2006-04-01	129376	\N	\N	f	Sales which are qualified	0
129376_6300.0_2007-04-01	630000	\N	2007-04-01	129376	\N	\N	f	Sales which are qualified	0
129377_2250.0_2001-07-01	225000	\N	2001-07-01	129377	\N	\N	f	Sales which are qualified	0
129377_2980.0_2012-12-15	298000	\N	2012-12-15	129377	\N	\N	f	Qual by exam of deed	0
129377_4200.0_2013-05-23	420000	\N	2013-05-23	129377	\N	\N	f	Qual by exam of deed	0
129377_5500.0_2020-07-31	550000	\N	2020-07-31	129377	\N	\N	f	Qual by exam of deed	0
129377_6890.0_2022-03-07	689000	\N	2022-03-07	129377	\N	\N	f	Qual by exam of deed	0
129381_2750.0_2002-11-01	275000	\N	2002-11-01	129381	\N	\N	f	Sales which are qualified	0
129383_1670.0_1999-05-01	167000	\N	1999-05-01	129383	\N	\N	f	Sales which are qualified	0
129383_1800.0_2013-12-18	180000	\N	2013-12-18	129383	\N	\N	f	Qual by exam of deed	0
129383_2850.0_2003-09-01	285000	\N	2003-09-01	129383	\N	\N	f	Sales which are qualified	0
129383_5200.0_2014-05-29	520000	\N	2014-05-29	129383	\N	\N	f	Qual by exam of deed	0
129383_7600.0_2021-05-13	760000	\N	2021-05-13	129383	\N	\N	f	Qual by exam of deed	0
129384_3000.0_2002-07-01	300000	\N	2002-07-01	129384	\N	\N	f	Sales which are qualified	0
129384_3100.0_2004-04-01	310000	\N	2004-04-01	129384	\N	\N	f	Sales which are qualified	0
129385_11820.0_2018-02-26	1182000	\N	2018-02-26	129385	\N	\N	f	Qual by exam of deed	0
129385_5950.0_2016-08-23	595000	\N	2016-08-23	129385	\N	\N	f	Qual by exam of deed	0
129386_1900.0_1999-04-01	190000	\N	1999-04-01	129386	\N	\N	f	Sales which are qualified	0
129386_2800.0_2003-11-01	280000	\N	2003-11-01	129386	\N	\N	f	Sales which are qualified	0
129386_8000.0_2014-08-26	800000	\N	2014-08-26	129386	\N	\N	f	Qual by exam of deed	0
129387_2850.0_2003-09-01	285000	\N	2003-09-01	129387	\N	\N	f	Sales which are qualified	0
129387_6330.0_2018-09-28	633000	\N	2018-09-28	129387	\N	\N	f	Qual by exam of deed	0
129388_3299.0_2003-11-01	329900	\N	2003-11-01	129388	\N	\N	f	Sales which are qualified	0
129388_4800.0_2005-05-01	480000	\N	2005-05-01	129388	\N	\N	f	Sales which are qualified	0
129388_5400.0_2013-07-15	540000	\N	2013-07-15	129388	\N	\N	f	Qual by exam of deed	0
129389_2100.0_2009-07-31	210000	\N	2009-07-31	129389	\N	\N	f	Qual by exam of deed	0
129389_2970.0_2003-06-01	297000	\N	2003-06-01	129389	\N	\N	f	Sales which are qualified	0
129389_2990.0_2011-04-14	299000	\N	2011-04-14	129389	\N	\N	f	Qual by exam of deed	0
129389_4800.0_2005-11-01	480000	\N	2005-11-01	129389	\N	\N	f	Sales which are qualified	0
129389_5500.0_2019-12-13	550000	\N	2019-12-13	129389	\N	\N	f	Qual by exam of deed	0
129390_1039.0_1997-10-01	103900	\N	1997-10-01	129390	\N	\N	f	Sales which are qualified	0
129390_2725.0_2017-10-31	272500	\N	2017-10-31	129390	\N	\N	f	Qual by exam of deed	0
129391_1065.0_1997-12-01	106500	\N	1997-12-01	129391	\N	\N	f	Sales which are qualified	0
129391_3150.0_2005-12-01	315000	\N	2005-12-01	129391	\N	\N	f	Sales which are qualified	0
129392_1081.0_1998-02-01	108100	\N	1998-02-01	129392	\N	\N	f	Sales which are qualified	0
129392_1500.0_2002-06-01	150000	\N	2002-06-01	129392	\N	\N	f	Sales which are qualified	0
129392_2200.0_2004-07-01	220000	\N	2004-07-01	129392	\N	\N	f	Sales which are qualified	0
129392_6550.0_2022-01-27	655000	\N	2022-01-27	129392	\N	\N	f	Qual by exam of deed	0
129396_1510.0_1999-11-01	151000	\N	1999-11-01	129396	\N	\N	f	Sales which are qualified	0
129396_2300.0_2008-12-15	230000	\N	2008-12-15	129396	\N	\N	f	Sales which are qualified	0
129396_2400.0_2012-03-09	240000	\N	2012-03-09	129396	\N	\N	f	Qual by exam of deed	0
129397_1279.0_1997-11-01	127900	\N	1997-11-01	129397	\N	\N	f	Sales which are qualified	0
129397_1350.0_2011-03-10	135000	\N	2011-03-10	129397	\N	\N	f	Qual by exam of deed	0
129397_1700.0_2002-01-01	170000	\N	2002-01-01	129397	\N	\N	f	Sales which are qualified	0
129399_1432.0_1999-08-01	143200	\N	1999-08-01	129399	\N	\N	f	Sales which are qualified	0
129399_1880.0_2012-04-23	188000	\N	2012-04-23	129399	\N	\N	f	Qual by exam of deed	0
129399_2000.0_2003-03-01	200000	\N	2003-03-01	129399	\N	\N	f	Sales which are qualified	0
129399_2490.0_2004-10-01	249000	\N	2004-10-01	129399	\N	\N	f	Sales which are qualified	0
129399_5650.0_2016-08-29	565000	\N	2016-08-29	129399	\N	\N	f	Qual by exam of deed	0
129399_7880.0_2018-02-26	788000	\N	2018-02-26	129399	\N	\N	f	Qual by exam of deed	0
129401_2499.0_2002-11-01	249900	\N	2002-11-01	129401	\N	\N	f	Sales which are qualified	0
129401_8285.0_2023-01-04	828500	\N	2023-01-04	129401	\N	\N	f	Qual by exam of deed	0
129403_3890.0_2003-08-01	389000	\N	2003-08-01	129403	\N	\N	f	Sales which are qualified	0
129403_5000.0_2007-11-01	500000	\N	2007-11-01	129403	\N	\N	f	Sales which are qualified	0
129403_5000.0_2013-05-01	500000	\N	2013-05-01	129403	\N	\N	f	Qual by exam of deed	0
129404_1019.0_1997-12-01	101900	\N	1997-12-01	129404	\N	\N	f	Sales which are qualified	0
129404_1200.0_2002-03-01	120000	\N	2002-03-01	129404	\N	\N	f	Sales which are qualified	0
129404_2600.0_2018-04-19	260000	\N	2018-04-19	129404	\N	\N	f	Qual by exam of deed	0
129406_1700.0_2000-06-01	170000	\N	2000-06-01	129406	\N	\N	f	Sales which are qualified	0
129406_1750.0_2003-06-01	175000	\N	2003-06-01	129406	\N	\N	f	Sales which are qualified	0
129407_1144.0_1998-12-01	114400	\N	1998-12-01	129407	\N	\N	f	Sales which are qualified	0
129407_1700.0_2000-06-01	170000	\N	2000-06-01	129407	\N	\N	f	Sales which are qualified	0
129407_1750.0_2002-09-01	175000	\N	2002-09-01	129407	\N	\N	f	Sales which are qualified	0
129407_3350.0_2005-06-01	335000	\N	2005-06-01	129407	\N	\N	f	Sales which are qualified	0
129408_1180.0_1998-12-01	118000	\N	1998-12-01	129408	\N	\N	f	Sales which are qualified	0
129408_1400.0_2000-11-01	140000	\N	2000-11-01	129408	\N	\N	f	Sales which are qualified	0
129408_1900.0_2003-04-01	190000	\N	2003-04-01	129408	\N	\N	f	Sales which are qualified	0
129408_2430.0_2004-08-01	243000	\N	2004-08-01	129408	\N	\N	f	Sales which are qualified	0
129408_3500.0_2007-04-01	350000	\N	2007-04-01	129408	\N	\N	f	Sales which are qualified	0
129409_1750.0_2002-06-01	175000	\N	2002-06-01	129409	\N	\N	f	Sales which are qualified	0
129409_2650.0_2005-03-01	265000	\N	2005-03-01	129409	\N	\N	f	Sales which are qualified	0
129409_3350.0_2005-06-01	335000	\N	2005-06-01	129409	\N	\N	f	Sales which are qualified	0
129409_4150.0_2014-07-27	415000	\N	2014-07-27	129409	\N	\N	f	Qual by exam of deed	0
129409_4800.0_2019-10-15	480000	\N	2019-10-15	129409	\N	\N	f	Qual by exam of deed	0
129410_1790.0_2002-08-01	179000	\N	2002-08-01	129410	\N	\N	f	Sales which are qualified	0
129410_2250.0_2004-10-01	225000	\N	2004-10-01	129410	\N	\N	f	Sales which are qualified	0
129410_2250.0_2011-11-22	225000	\N	2011-11-22	129410	\N	\N	f	Qual by exam of deed	0
129410_4000.0_2017-08-04	400000	\N	2017-08-04	129410	\N	\N	f	Qual by exam of deed	0
129412_1300.0_1998-10-01	130000	\N	1998-10-01	129412	\N	\N	f	Sales which are qualified	0
129412_1970.0_2010-06-18	197000	\N	2010-06-18	129412	\N	\N	f	Qual by exam of deed	0
129412_6950.0_2022-06-16	695000	\N	2022-06-16	129412	\N	\N	f	Qual by exam of deed	0
129416_1299.0_2000-11-01	129900	\N	2000-11-01	129416	\N	\N	f	Sales which are qualified	0
129416_1950.0_2005-03-01	195000	\N	2005-03-01	129416	\N	\N	f	Sales which are qualified	0
129416_2850.0_2021-02-20	285000	\N	2021-02-20	129416	\N	\N	f	Qual by exam of deed	0
129417_1350.0_2002-07-01	135000	\N	2002-07-01	129417	\N	\N	f	Sales which are qualified	0
129417_920.0_1998-02-01	92000	\N	1998-02-01	129417	\N	\N	f	Sales which are qualified	0
129418_1450.0_2000-10-01	145000	\N	2000-10-01	129418	\N	\N	f	Sales which are qualified	0
129418_2100.0_2005-02-01	210000	\N	2005-02-01	129418	\N	\N	f	Sales which are qualified	0
129418_3550.0_2014-01-17	355000	\N	2014-01-17	129418	\N	\N	f	Qual by exam of deed	0
129419_1120.0_1999-07-01	112000	\N	1999-07-01	129419	\N	\N	f	Sales which are qualified	0
129419_1800.0_2004-10-01	180000	\N	2004-10-01	129419	\N	\N	f	Sales which are qualified	0
129420_1400.0_2002-04-01	140000	\N	2002-04-01	129420	\N	\N	f	Sales which are qualified	0
129420_1950.0_2011-06-30	195000	\N	2011-06-30	129420	\N	\N	f	Qual by exam of deed	0
129420_4750.0_2022-02-18	475000	\N	2022-02-18	129420	\N	\N	f	Qual by exam of deed	0
129421_1700.0_2002-10-01	170000	\N	2002-10-01	129421	\N	\N	f	Sales which are qualified	0
129421_2400.0_2003-12-01	240000	\N	2003-12-01	129421	\N	\N	f	Sales which are qualified	0
129421_2950.0_2005-07-01	295000	\N	2005-07-01	129421	\N	\N	f	Sales which are qualified	0
129421_4070.0_2015-05-11	407000	\N	2015-05-11	129421	\N	\N	f	Qual by exam of deed	0
129421_4424.0_2018-02-08	442400	\N	2018-02-08	129421	\N	\N	f	Qual by exam of deed	0
129421_4650.0_2021-11-30	465000	\N	2021-11-30	129421	\N	\N	f	Qual by exam of deed	0
129423_1430.0_2002-08-01	143000	\N	2002-08-01	129423	\N	\N	f	Sales which are qualified	0
129423_2369.0_2003-12-01	236900	\N	2003-12-01	129423	\N	\N	f	Sales which are qualified	0
129423_3990.0_2014-03-10	399000	\N	2014-03-10	129423	\N	\N	f	Qual by exam of deed	0
129423_4550.0_2006-10-01	455000	\N	2006-10-01	129423	\N	\N	f	Sales which are qualified	0
129423_899.0_1998-01-01	89900	\N	1998-01-01	129423	\N	\N	f	Sales which are qualified	0
129425_1690.0_2003-06-01	169000	\N	2003-06-01	129425	\N	\N	f	Sales which are qualified	0
129425_3790.0_2006-11-01	379000	\N	2006-11-01	129425	\N	\N	f	Sales which are qualified	0
129425_3850.0_2013-11-25	385000	\N	2013-11-25	129425	\N	\N	f	Qual by exam of deed	0
129425_899.0_1998-02-01	89900	\N	1998-02-01	129425	\N	\N	f	Sales which are qualified	0
129426_6170.0_2023-06-26	617000	\N	2023-06-26	129426	\N	\N	f	Qual by exam of deed	0
129428_1950.0_2003-12-01	195000	\N	2003-12-01	129428	\N	\N	f	Sales which are qualified	0
129428_4150.0_2014-02-25	415000	\N	2014-02-25	129428	\N	\N	f	Qual by exam of deed	0
129429_10400.0_2019-01-10	1040000	\N	2019-01-10	129429	\N	\N	f	Qual by exam of deed	0
129429_17000.0_2021-07-13	1700000	\N	2021-07-13	129429	\N	\N	f	Qual by exam of deed	0
129429_4599.0_2002-10-01	459900	\N	2002-10-01	129429	\N	\N	f	Sales which are qualified	0
129429_5250.0_2010-02-15	525000	\N	2010-02-15	129429	\N	\N	f	Qual by exam of deed	0
129430_1270.0_2003-03-01	127000	\N	2003-03-01	129430	\N	\N	f	Sales which are qualified	0
129430_2150.0_2005-04-01	215000	\N	2005-04-01	129430	\N	\N	f	Sales which are qualified	0
129430_2730.0_2013-06-12	273000	\N	2013-06-12	129430	\N	\N	f	Qual by exam of deed	0
129431_1650.0_2000-06-01	165000	\N	2000-06-01	129431	\N	\N	f	Sales which are qualified	0
129431_2100.0_2004-08-01	210000	\N	2004-08-01	129431	\N	\N	f	Sales which are qualified	0
129431_3350.0_2006-03-01	335000	\N	2006-03-01	129431	\N	\N	f	Sales which are qualified	0
129431_5500.0_2022-04-29	550000	\N	2022-04-29	129431	\N	\N	f	Qual by exam of deed	0
129433_18500.0_2021-05-19	1850000	\N	2021-05-19	129433	\N	\N	t	Qual on DOS, multi-parcel sale	0
129433_2070.0_2004-05-01	207000	\N	2004-05-01	129433	\N	\N	f	Sales which are qualified	0
129433_3775.0_2015-06-19	377500	\N	2015-06-19	129433	\N	\N	f	Qual by exam of deed	0
129434_1500.0_2010-11-12	150000	\N	2010-11-12	129434	\N	\N	f	Qual by exam of deed	0
129434_959.0_1998-02-01	95900	\N	1998-02-01	129434	\N	\N	f	Sales which are qualified	0
129435_1203.0_1998-08-01	120300	\N	1998-08-01	129435	\N	\N	f	Sales which are qualified	0
129435_1750.0_2003-04-01	175000	\N	2003-04-01	129435	\N	\N	f	Sales which are qualified	0
129435_2675.0_2012-12-13	267500	\N	2012-12-13	129435	\N	\N	f	Qual by exam of deed	0
129435_4550.0_2006-09-01	455000	\N	2006-09-01	129435	\N	\N	f	Sales which are qualified	0
129436_799.0_1997-11-01	79900	\N	1997-11-01	129436	\N	\N	f	Sales which are qualified	0
129437_3250.0_2005-10-01	325000	\N	2005-10-01	129437	\N	\N	f	Sales which are qualified	0
129437_4190.0_2006-08-01	419000	\N	2006-08-01	129437	\N	\N	f	Sales which are qualified	0
129437_5990.0_2022-05-05	599000	\N	2022-05-05	129437	\N	\N	f	Qual by exam of deed	0
129437_899.0_1998-02-01	89900	\N	1998-02-01	129437	\N	\N	f	Sales which are qualified	0
129438_1800.0_2003-08-01	180000	\N	2003-08-01	129438	\N	\N	f	Sales which are qualified	0
129438_2180.0_2004-12-01	218000	\N	2004-12-01	129438	\N	\N	f	Sales which are qualified	0
129438_3950.0_2014-06-24	395000	\N	2014-06-24	129438	\N	\N	f	Qual by exam of deed	0
129438_899.0_1997-10-01	89900	\N	1997-10-01	129438	\N	\N	f	Sales which are qualified	0
129439_899.0_1998-01-01	89900	\N	1998-01-01	129439	\N	\N	f	Sales which are qualified	0
129440_1875.0_2002-10-01	187500	\N	2002-10-01	129440	\N	\N	f	Sales which are qualified	0
129440_3200.0_2006-04-01	320000	\N	2006-04-01	129440	\N	\N	f	Sales which are qualified	0
129440_4300.0_2021-06-15	430000	\N	2021-06-15	129440	\N	\N	f	Qual by exam of deed	0
129441_4100.0_2018-04-26	410000	\N	2018-04-26	129441	\N	\N	f	Qual by exam of deed	0
129441_799.0_1997-10-01	79900	\N	1997-10-01	129441	\N	\N	f	Sales which are qualified	0
129443_1919.0_2004-01-01	191900	\N	2004-01-01	129443	\N	\N	f	Sales which are qualified	0
129444_2336.0_2001-04-01	233600	\N	2001-04-01	129444	\N	\N	f	Sales which are qualified	0
129444_4400.0_2004-11-01	440000	\N	2004-11-01	129444	\N	\N	f	Sales which are qualified	0
129444_5100.0_2005-11-01	510000	\N	2005-11-01	129444	\N	\N	f	Sales which are qualified	0
129444_6300.0_2007-01-01	630000	\N	2007-01-01	129444	\N	\N	f	Sales which are qualified	0
129445_2140.0_2001-04-01	214000	\N	2001-04-01	129445	\N	\N	f	Sales which are qualified	0
129446_1539.0_1997-09-01	153900	\N	1997-09-01	129446	\N	\N	f	Sales which are qualified	0
129446_18500.0_2021-05-19	1850000	\N	2021-05-19	129446	\N	\N	t	Qual on DOS, multi-parcel sale	0
129446_1900.0_2001-02-01	190000	\N	2001-02-01	129446	\N	\N	f	Sales which are qualified	0
129448_2890.0_2001-08-01	289000	\N	2001-08-01	129448	\N	\N	f	Sales which are qualified	0
129449_2410.0_2000-06-01	241000	\N	2000-06-01	129449	\N	\N	f	Sales which are qualified	0
129449_3100.0_2009-03-27	310000	\N	2009-03-27	129449	\N	\N	f	Qual by exam of deed	0
129449_3450.0_2004-12-01	345000	\N	2004-12-01	129449	\N	\N	f	Sales which are qualified	0
129450_2100.0_1999-08-01	210000	\N	1999-08-01	129450	\N	\N	f	Sales which are qualified	0
129450_3350.0_2004-08-01	335000	\N	2004-08-01	129450	\N	\N	f	Sales which are qualified	0
129450_3900.0_2012-05-09	390000	\N	2012-05-09	129450	\N	\N	f	Qual by exam of deed	0
129450_6350.0_2013-05-21	635000	\N	2013-05-21	129450	\N	\N	f	Qual by exam of deed	0
129450_7000.0_2016-08-26	700000	\N	2016-08-26	129450	\N	\N	f	Qual by exam of deed	0
129451_1985.0_1999-12-01	198500	\N	1999-12-01	129451	\N	\N	f	Sales which are qualified	0
129451_3180.0_2003-07-01	318000	\N	2003-07-01	129451	\N	\N	f	Sales which are qualified	0
129454_2755.0_2011-10-13	275500	\N	2011-10-13	129454	\N	\N	f	Qual by exam of deed	0
129454_3450.0_2002-12-01	345000	\N	2002-12-01	129454	\N	\N	f	Sales which are qualified	0
129455_3920.0_2003-06-01	392000	\N	2003-06-01	129455	\N	\N	f	Sales which are qualified	0
129455_6200.0_2005-10-01	620000	\N	2005-10-01	129455	\N	\N	f	Sales which are qualified	0
129455_9400.0_2015-04-16	940000	\N	2015-04-16	129455	\N	\N	f	Qual by exam of deed	0
129456_19500.0_2021-07-14	1950000	\N	2021-07-14	129456	\N	\N	f	Qual by exam of deed	0
129456_6250.0_2004-10-01	625000	\N	2004-10-01	129456	\N	\N	f	Sales which are qualified	0
129456_9500.0_2006-08-01	950000	\N	2006-08-01	129456	\N	\N	f	Sales which are qualified	0
129458_1600.0_1998-02-01	160000	\N	1998-02-01	129458	\N	\N	f	Sales which are qualified	0
129458_1920.0_2002-08-01	192000	\N	2002-08-01	129458	\N	\N	f	Sales which are qualified	0
129459_1415.0_1997-10-01	141500	\N	1997-10-01	129459	\N	\N	f	Sales which are qualified	0
129459_9170.0_2023-03-07	917000	\N	2023-03-07	129459	\N	\N	f	Qual by exam of deed	0
129460_1830.0_1999-11-01	183000	\N	1999-11-01	129460	\N	\N	f	Sales which are qualified	0
129460_3150.0_2011-10-25	315000	\N	2011-10-25	129460	\N	\N	f	Qual by exam of deed	0
129461_1743.0_1999-08-01	174300	\N	1999-08-01	129461	\N	\N	f	Sales which are qualified	0
129463_1915.0_1999-03-01	191500	\N	1999-03-01	129463	\N	\N	f	Sales which are qualified	0
129463_8750.0_2022-04-18	875000	\N	2022-04-18	129463	\N	\N	f	Qual by exam of deed	0
129464_1950.0_1999-10-01	195000	\N	1999-10-01	129464	\N	\N	f	Sales which are qualified	0
129465_3255.0_2003-04-01	325500	\N	2003-04-01	129465	\N	\N	f	Sales which are qualified	0
129465_3740.0_2011-06-08	374000	\N	2011-06-08	129465	\N	\N	f	Qual by exam of deed	0
129465_3850.0_2010-01-15	385000	\N	2010-01-15	129465	\N	\N	f	Qual by exam of deed	0
129465_4100.0_2005-03-01	410000	\N	2005-03-01	129465	\N	\N	f	Sales which are qualified	0
129466_2070.0_1999-10-01	207000	\N	1999-10-01	129466	\N	\N	f	Sales which are qualified	0
129468_3780.0_2003-06-01	378000	\N	2003-06-01	129468	\N	\N	f	Sales which are qualified	0
129468_3850.0_2011-05-02	385000	\N	2011-05-02	129468	\N	\N	f	Qual by exam of deed	0
129468_5600.0_2005-09-01	560000	\N	2005-09-01	129468	\N	\N	f	Sales which are qualified	0
129469_10000.0_2021-06-28	1000000	\N	2021-06-28	129469	\N	\N	f	Qual by exam of deed	0
129469_3100.0_2009-12-24	310000	\N	2009-12-24	129469	\N	\N	f	Qual by exam of deed	0
129469_7000.0_2005-11-01	700000	\N	2005-11-01	129469	\N	\N	f	Sales which are qualified	0
129469_7600.0_2006-11-01	760000	\N	2006-11-01	129469	\N	\N	f	Sales which are qualified	0
129469_8900.0_2014-09-12	890000	\N	2014-09-12	129469	\N	\N	f	Qual by exam of deed	0
129470_11500.0_2021-04-22	1150000	\N	2021-04-22	129470	\N	\N	f	Qual by exam of deed	0
129470_3650.0_2010-06-30	365000	\N	2010-06-30	129470	\N	\N	f	Qual by exam of deed	0
129470_3800.0_2003-12-01	380000	\N	2003-12-01	129470	\N	\N	f	Sales which are qualified	0
129470_4350.0_2005-01-01	435000	\N	2005-01-01	129470	\N	\N	f	Sales which are qualified	0
129471_5470.0_2019-09-17	547000	\N	2019-09-17	129471	\N	\N	f	Qual by exam of deed	0
129472_1989.0_1999-05-01	198900	\N	1999-05-01	129472	\N	\N	f	Sales which are qualified	0
129472_4990.0_2005-08-01	499000	\N	2005-08-01	129472	\N	\N	f	Sales which are qualified	0
129472_7000.0_2014-07-28	700000	\N	2014-07-28	129472	\N	\N	f	Qual by exam of deed	0
129474_1997.0_1999-10-01	199700	\N	1999-10-01	129474	\N	\N	f	Sales which are qualified	0
129476_3890.0_2003-02-01	389000	\N	2003-02-01	129476	\N	\N	f	Sales which are qualified	0
129476_4550.0_2004-03-01	455000	\N	2004-03-01	129476	\N	\N	f	Sales which are qualified	0
129476_6150.0_2013-07-15	615000	\N	2013-07-15	129476	\N	\N	f	Qual by exam of deed	0
129477_14990.0_2022-04-12	1499000	\N	2022-04-12	129477	\N	\N	f	Qual by exam of deed	0
129477_17750.0_2023-04-03	1775000	\N	2023-04-03	129477	\N	\N	f	Qual by exam of deed	0
129477_1930.0_1999-08-01	193000	\N	1999-08-01	129477	\N	\N	f	Sales which are qualified	0
129477_2350.0_2003-02-01	235000	\N	2003-02-01	129477	\N	\N	f	Sales which are qualified	0
129477_3910.0_2004-06-01	391000	\N	2004-06-01	129477	\N	\N	f	Sales which are qualified	0
129477_4100.0_2012-06-11	410000	\N	2012-06-11	129477	\N	\N	f	Qual by exam of deed	0
129479_13500.0_2022-02-28	1350000	\N	2022-02-28	129479	\N	\N	f	Qual by exam of deed	0
129479_1899.0_1999-03-01	189900	\N	1999-03-01	129479	\N	\N	f	Sales which are qualified	0
129479_4250.0_2010-07-19	425000	\N	2010-07-19	129479	\N	\N	f	Qual by exam of deed	0
129479_5250.0_2003-06-01	525000	\N	2003-06-01	129479	\N	\N	f	Sales which are qualified	0
129479_6150.0_2004-11-01	615000	\N	2004-11-01	129479	\N	\N	f	Sales which are qualified	0
129479_7100.0_2005-11-01	710000	\N	2005-11-01	129479	\N	\N	f	Sales which are qualified	0
129480_5400.0_2013-03-19	540000	\N	2013-03-19	129480	\N	\N	f	Qual by exam of deed	0
129480_9550.0_2021-06-15	955000	\N	2021-06-15	129480	\N	\N	f	Qual by exam of deed	0
129482_3950.0_2003-01-01	395000	\N	2003-01-01	129482	\N	\N	f	Sales which are qualified	0
129482_6770.0_2013-06-05	677000	\N	2013-06-05	129482	\N	\N	f	Qual by exam of deed	0
129482_9450.0_2016-06-13	945000	\N	2016-06-13	129482	\N	\N	f	Qual by exam of deed	0
129484_3477.0_2002-10-01	347700	\N	2002-10-01	129484	\N	\N	f	Sales which are qualified	0
129484_3600.0_2011-01-31	360000	\N	2011-01-31	129484	\N	\N	f	Qual by exam of deed	0
129484_6120.0_2004-01-01	612000	\N	2004-01-01	129484	\N	\N	f	Sales which are qualified	0
129484_6120.0_2004-07-01	612000	\N	2004-07-01	129484	\N	\N	f	Sales which are qualified	0
129484_6350.0_2005-09-01	635000	\N	2005-09-01	129484	\N	\N	f	Sales which are qualified	0
129484_8500.0_2018-05-17	850000	\N	2018-05-17	129484	\N	\N	f	Qual by exam of deed	0
129484_8990.0_2006-07-01	899000	\N	2006-07-01	129484	\N	\N	f	Sales which are qualified	0
129485_1700.0_2002-12-01	170000	\N	2002-12-01	129485	\N	\N	f	Sales which are qualified	0
129485_3200.0_2015-02-24	320000	\N	2015-02-24	129485	\N	\N	f	Qual by exam of deed	0
129485_3500.0_2021-07-26	350000	\N	2021-07-26	129485	\N	\N	f	Qual by exam of deed	0
129485_999.0_1999-05-01	99900	\N	1999-05-01	129485	\N	\N	f	Sales which are qualified	0
129486_1400.0_2000-12-01	140000	\N	2000-12-01	129486	\N	\N	f	Sales which are qualified	0
129486_1400.0_2010-07-21	140000	\N	2010-07-21	129486	\N	\N	f	Qual by exam of deed	0
129486_1750.0_2003-09-01	175000	\N	2003-09-01	129486	\N	\N	f	Sales which are qualified	0
129486_2150.0_2012-12-20	215000	\N	2012-12-20	129486	\N	\N	f	Qual by exam of deed	0
129486_3400.0_2006-03-01	340000	\N	2006-03-01	129486	\N	\N	f	Sales which are qualified	0
129486_4100.0_2015-04-20	410000	\N	2015-04-20	129486	\N	\N	f	Qual by exam of deed	0
129487_5200.0_2023-06-01	520000	\N	2023-06-01	129487	\N	\N	f	Qual by exam of deed	0
129487_799.0_1997-12-01	79900	\N	1997-12-01	129487	\N	\N	f	Sales which are qualified	0
129488_1290.0_2001-04-01	129000	\N	2001-04-01	129488	\N	\N	f	Sales which are qualified	0
129488_1585.0_2003-08-01	158500	\N	2003-08-01	129488	\N	\N	f	Sales which are qualified	0
129488_1650.0_2001-10-01	165000	\N	2001-10-01	129488	\N	\N	f	Sales which are qualified	0
129488_2500.0_2013-07-31	250000	\N	2013-07-31	129488	\N	\N	f	Qual by exam of deed	0
129488_899.0_1998-01-01	89900	\N	1998-01-01	129488	\N	\N	f	Sales which are qualified	0
129489_1529.0_2000-02-01	152900	\N	2000-02-01	129489	\N	\N	f	Sales which are qualified	0
129489_4270.0_2014-04-30	427000	\N	2014-04-30	129489	\N	\N	f	Qual by exam of deed	0
129490_1700.0_2003-09-01	170000	\N	2003-09-01	129490	\N	\N	f	Sales which are qualified	0
129490_2130.0_2002-01-01	213000	\N	2002-01-01	129490	\N	\N	f	Sales which are qualified	0
129490_2500.0_2004-04-01	250000	\N	2004-04-01	129490	\N	\N	f	Sales which are qualified	0
129490_2800.0_2005-07-01	280000	\N	2005-07-01	129490	\N	\N	f	Sales which are qualified	0
129491_1270.0_1999-12-01	127000	\N	1999-12-01	129491	\N	\N	f	Sales which are qualified	0
129491_1420.0_2003-02-01	142000	\N	2003-02-01	129491	\N	\N	f	Sales which are qualified	0
129491_2330.0_2005-04-01	233000	\N	2005-04-01	129491	\N	\N	f	Sales which are qualified	0
129492_2950.0_2005-08-01	295000	\N	2005-08-01	129492	\N	\N	f	Sales which are qualified	0
129492_3400.0_2013-08-01	340000	\N	2013-08-01	129492	\N	\N	f	Qual by exam of deed	0
129492_3550.0_2004-11-01	355000	\N	2004-11-01	129492	\N	\N	f	Sales which are qualified	0
129492_3600.0_2016-12-05	360000	\N	2016-12-05	129492	\N	\N	f	Qual by exam of deed	0
129492_5500.0_2022-01-12	550000	\N	2022-01-12	129492	\N	\N	f	Qual by exam of deed	0
129495_2980.0_2013-03-07	298000	\N	2013-03-07	129495	\N	\N	f	Qual by exam of deed	0
129496_1820.0_2010-07-20	182000	\N	2010-07-20	129496	\N	\N	f	Qual by exam of deed	0
129496_2199.0_2003-09-01	219900	\N	2003-09-01	129496	\N	\N	f	Sales which are qualified	0
129496_2890.0_2005-01-01	289000	\N	2005-01-01	129496	\N	\N	f	Sales which are qualified	0
129496_5900.0_2022-05-09	590000	\N	2022-05-09	129496	\N	\N	f	Qual by exam of deed	0
129498_3400.0_2002-10-01	340000	\N	2002-10-01	129498	\N	\N	f	Sales which are qualified	0
129498_5770.0_2003-05-01	577000	\N	2003-05-01	129498	\N	\N	f	Sales which are qualified	0
129498_6200.0_2004-07-01	620000	\N	2004-07-01	129498	\N	\N	f	Sales which are qualified	0
129498_7400.0_2005-12-01	740000	\N	2005-12-01	129498	\N	\N	f	Sales which are qualified	0
129499_1250.0_2000-03-01	125000	\N	2000-03-01	129499	\N	\N	f	Sales which are qualified	0
129499_1790.0_2003-11-01	179000	\N	2003-11-01	129499	\N	\N	f	Sales which are qualified	0
129499_3630.0_2019-10-24	363000	\N	2019-10-24	129499	\N	\N	f	Qual by exam of deed	0
129499_4800.0_2007-05-01	480000	\N	2007-05-01	129499	\N	\N	f	Sales which are qualified	0
129500_1600.0_2001-05-01	160000	\N	2001-05-01	129500	\N	\N	f	Sales which are qualified	0
129500_2600.0_2005-06-01	260000	\N	2005-06-01	129500	\N	\N	f	Sales which are qualified	0
129501_1670.0_2003-06-01	167000	\N	2003-06-01	129501	\N	\N	f	Sales which are qualified	0
129501_999.0_1999-04-01	99900	\N	1999-04-01	129501	\N	\N	f	Sales which are qualified	0
129503_1140.0_1999-06-01	114000	\N	1999-06-01	129503	\N	\N	f	Sales which are qualified	0
129503_1550.0_2008-11-12	155000	\N	2008-11-12	129503	\N	\N	f	Other disqualified	0
129503_2360.0_2004-03-01	236000	\N	2004-03-01	129503	\N	\N	f	Sales which are qualified	0
129503_3890.0_2013-07-18	389000	\N	2013-07-18	129503	\N	\N	f	Qual by exam of deed	0
129503_4550.0_2006-08-01	455000	\N	2006-08-01	129503	\N	\N	f	Sales which are qualified	0
129504_1900.0_2001-06-01	190000	\N	2001-06-01	129504	\N	\N	f	Sales which are qualified	0
129504_2200.0_2005-12-01	220000	\N	2005-12-01	129504	\N	\N	f	Sales which are qualified	0
129505_1500.0_2002-10-01	150000	\N	2002-10-01	129505	\N	\N	f	Sales which are qualified	0
129505_1500.0_2008-11-19	150000	\N	2008-11-19	129505	\N	\N	f	Other disqualified	0
129505_2950.0_2005-05-01	295000	\N	2005-05-01	129505	\N	\N	f	Sales which are qualified	0
129506_1540.0_2002-07-01	154000	\N	2002-07-01	129506	\N	\N	f	Sales which are qualified	0
129506_2150.0_2012-07-12	215000	\N	2012-07-12	129506	\N	\N	f	Qual by exam of deed	0
129506_2900.0_2005-09-01	290000	\N	2005-09-01	129506	\N	\N	f	Sales which are qualified	0
129506_5000.0_2022-03-02	500000	\N	2022-03-02	129506	\N	\N	f	Qual by exam of deed	0
129507_1999.0_2003-04-01	199900	\N	2003-04-01	129507	\N	\N	f	Sales which are qualified	0
129508_1990.0_2012-03-19	199000	\N	2012-03-19	129508	\N	\N	f	Qual by exam of deed	0
129508_2099.0_2003-01-01	209900	\N	2003-01-01	129508	\N	\N	f	Sales which are qualified	0
129508_2650.0_2005-04-01	265000	\N	2005-04-01	129508	\N	\N	f	Sales which are qualified	0
129508_3300.0_2005-09-01	330000	\N	2005-09-01	129508	\N	\N	f	Sales which are qualified	0
129508_3440.0_2016-11-17	344000	\N	2016-11-17	129508	\N	\N	f	Qual by exam of deed	0
129508_5600.0_2006-06-01	560000	\N	2006-06-01	129508	\N	\N	f	Sales which are qualified	0
129509_1290.0_1999-04-01	129000	\N	1999-04-01	129509	\N	\N	f	Sales which are qualified	0
129509_1920.0_2003-11-01	192000	\N	2003-11-01	129509	\N	\N	f	Sales which are qualified	0
129509_3750.0_2013-12-06	375000	\N	2013-12-06	129509	\N	\N	f	Qual by exam of deed	0
129510_2000.0_2002-09-01	200000	\N	2002-09-01	129510	\N	\N	f	Sales which are qualified	0
129510_2240.0_2004-07-01	224000	\N	2004-07-01	129510	\N	\N	f	Sales which are qualified	0
129510_4250.0_2021-08-16	425000	\N	2021-08-16	129510	\N	\N	f	Qual by exam of deed	0
129511_2630.0_2003-07-01	263000	\N	2003-07-01	129511	\N	\N	f	Sales which are qualified	0
129512_1690.0_2012-02-14	169000	\N	2012-02-14	129512	\N	\N	f	Qual by verifiable & documented evidence	0
129512_3400.0_2020-01-16	340000	\N	2020-01-16	129512	\N	\N	f	Qual by exam of deed	0
129512_5600.0_2022-01-26	560000	\N	2022-01-26	129512	\N	\N	f	Qual by exam of deed	0
129512_960.0_1998-04-01	96000	\N	1998-04-01	129512	\N	\N	f	Sales which are qualified	0
129515_3000.0_2017-05-25	300000	\N	2017-05-25	129515	\N	\N	f	Qual by exam of deed	0
129515_4850.0_2006-08-01	485000	\N	2006-08-01	129515	\N	\N	f	Sales which are qualified	0
129517_2183.0_2014-05-15	218300	\N	2014-05-15	129517	\N	\N	f	Qual by exam of deed	0
129517_2650.0_2005-04-01	265000	\N	2005-04-01	129517	\N	\N	f	Sales which are qualified	0
129517_3970.0_2019-05-23	397000	\N	2019-05-23	129517	\N	\N	f	Qual by exam of deed	0
129517_5500.0_2022-10-31	550000	\N	2022-10-31	129517	\N	\N	f	Qual by exam of deed	0
129517_987.0_1997-09-01	98700	\N	1997-09-01	129517	\N	\N	f	Sales which are qualified	0
129520_2230.0_2002-06-01	223000	\N	2002-06-01	129520	\N	\N	f	Sales which are qualified	0
129520_2530.0_2004-11-01	253000	\N	2004-11-01	129520	\N	\N	f	Sales which are qualified	0
129520_3600.0_2017-11-09	360000	\N	2017-11-09	129520	\N	\N	f	Qual by exam of deed	0
129521_2185.0_2003-12-01	218500	\N	2003-12-01	129521	\N	\N	f	Sales which are qualified	0
129521_2850.0_2008-04-01	285000	\N	2008-04-01	129521	\N	\N	f	Sales which are qualified	0
129526_2570.0_2013-06-28	257000	\N	2013-06-28	129526	\N	\N	f	Qual by exam of deed	0
129526_5600.0_2022-03-10	560000	\N	2022-03-10	129526	\N	\N	f	Qual by exam of deed	0
129526_950.0_1998-07-01	95000	\N	1998-07-01	129526	\N	\N	f	Sales which are qualified	0
129527_1116.0_1999-08-01	111600	\N	1999-08-01	129527	\N	\N	f	Sales which are qualified	0
129528_1090.0_1999-07-01	109000	\N	1999-07-01	129528	\N	\N	f	Sales which are qualified	0
129529_1609.0_2000-03-01	160900	\N	2000-03-01	129529	\N	\N	f	Sales which are qualified	0
129529_1990.0_2004-11-01	199000	\N	2004-11-01	129529	\N	\N	f	Sales which are qualified	0
129529_5650.0_2023-08-04	565000	\N	2023-08-04	129529	\N	\N	f	Qual by exam of deed	0
129530_1068.0_1999-05-01	106800	\N	1999-05-01	129530	\N	\N	f	Sales which are qualified	0
129530_1390.0_2001-10-01	139000	\N	2001-10-01	129530	\N	\N	f	Sales which are qualified	0
129531_1710.0_2002-05-01	171000	\N	2002-05-01	129531	\N	\N	f	Sales which are qualified	0
129531_2050.0_2004-05-01	205000	\N	2004-05-01	129531	\N	\N	f	Sales which are qualified	0
129531_5000.0_2022-03-25	500000	\N	2022-03-25	129531	\N	\N	f	Qual by exam of deed	0
129533_2164.0_2001-10-01	216400	\N	2001-10-01	129533	\N	\N	f	Sales which are qualified	0
129537_2499.0_2002-11-01	249900	\N	2002-11-01	129537	\N	\N	f	Sales which are qualified	0
129537_3650.0_2013-11-03	365000	\N	2013-11-03	129537	\N	\N	f	Qual by exam of deed	0
129537_4300.0_2019-12-20	430000	\N	2019-12-20	129537	\N	\N	f	Qual by exam of deed	0
129540_2850.0_2013-03-07	285000	\N	2013-03-07	129540	\N	\N	f	Qual by exam of deed	0
129540_799.0_1998-05-01	79900	\N	1998-05-01	129540	\N	\N	f	Sales which are qualified	0
129541_1099.0_1999-05-01	109900	\N	1999-05-01	129541	\N	\N	f	Sales which are qualified	0
129541_1100.0_1999-12-01	110000	\N	1999-12-01	129541	\N	\N	f	Sales which are qualified	0
129541_1350.0_2002-12-01	135000	\N	2002-12-01	129541	\N	\N	f	Sales which are qualified	0
129541_1550.0_2011-06-30	155000	\N	2011-06-30	129541	\N	\N	f	Qual by exam of deed	0
129541_2000.0_2001-06-01	200000	\N	2001-06-01	129541	\N	\N	f	Sales which are qualified	0
129541_3000.0_2017-07-12	300000	\N	2017-07-12	129541	\N	\N	f	Qual by exam of deed	0
129543_1155.0_1999-09-01	115500	\N	1999-09-01	129543	\N	\N	f	Sales which are qualified	0
129543_1750.0_2009-05-07	175000	\N	2009-05-07	129543	\N	\N	f	Qual by exam of deed	0
129543_1750.0_2012-12-12	175000	\N	2012-12-12	129543	\N	\N	f	Qual by exam of deed	0
129543_1792.77_2005-08-01	179277	\N	2005-08-01	129543	\N	\N	f	Sales which are qualified	0
129543_1950.0_2004-06-01	195000	\N	2004-06-01	129543	\N	\N	f	Sales which are qualified	0
129543_3700.0_2019-06-28	370000	\N	2019-06-28	129543	\N	\N	f	Qual by exam of deed	0
129543_4850.0_2021-12-23	485000	\N	2021-12-23	129543	\N	\N	f	Qual by exam of deed	0
129545_3900.0_2015-05-28	390000	\N	2015-05-28	129545	\N	\N	f	Qual by exam of deed	0
129547_1530.0_2002-09-01	153000	\N	2002-09-01	129547	\N	\N	f	Sales which are qualified	0
129547_1850.0_2003-02-01	185000	\N	2003-02-01	129547	\N	\N	f	Sales which are qualified	0
129547_3700.0_2016-09-01	370000	\N	2016-09-01	129547	\N	\N	f	Qual by exam of deed	0
129550_2800.0_2005-04-01	280000	\N	2005-04-01	129550	\N	\N	f	Sales which are qualified	0
129550_5500.0_2016-02-02	550000	\N	2016-02-02	129550	\N	\N	f	Qual by exam of deed	0
129550_5550.0_2021-08-10	555000	\N	2021-08-10	129550	\N	\N	f	Qual by exam of deed	0
129554_3520.0_2007-02-01	352000	\N	2007-02-01	129554	\N	\N	f	Sales which are qualified	0
129555_1155.0_1999-09-01	115500	\N	1999-09-01	129555	\N	\N	f	Sales which are qualified	0
129555_1780.0_2003-09-01	178000	\N	2003-09-01	129555	\N	\N	f	Sales which are qualified	0
129555_3690.0_2013-07-12	369000	\N	2013-07-12	129555	\N	\N	f	Qual by exam of deed	0
129556_1770.0_2002-07-01	177000	\N	2002-07-01	129556	\N	\N	f	Sales which are qualified	0
129556_2250.0_2004-04-01	225000	\N	2004-04-01	129556	\N	\N	f	Sales which are qualified	0
129556_4240.0_2006-08-01	424000	\N	2006-08-01	129556	\N	\N	f	Sales which are qualified	0
129557_1160.0_1999-07-01	116000	\N	1999-07-01	129557	\N	\N	f	Sales which are qualified	0
129557_1833.0_2010-09-23	183300	\N	2010-09-23	129557	\N	\N	f	Qual by exam of deed	0
129557_2200.0_2005-05-01	220000	\N	2005-05-01	129557	\N	\N	f	Sales which are qualified	0
129558_1311.0_1999-12-01	131100	\N	1999-12-01	129558	\N	\N	f	Sales which are qualified	0
129558_1875.0_2012-05-02	187500	\N	2012-05-02	129558	\N	\N	f	Qual by exam of deed	0
129558_2000.0_2003-07-01	200000	\N	2003-07-01	129558	\N	\N	f	Sales which are qualified	0
129558_7300.0_2023-03-27	730000	\N	2023-03-27	129558	\N	\N	f	Qual by exam of deed	0
129559_1950.0_2002-11-01	195000	\N	2002-11-01	129559	\N	\N	f	Sales which are qualified	0
129559_3600.0_2018-01-02	360000	\N	2018-01-02	129559	\N	\N	f	Qual by exam of deed	0
129561_1800.0_2010-02-01	180000	\N	2010-02-01	129561	\N	\N	f	Qual by exam of deed	0
129561_1999.0_2003-11-01	199900	\N	2003-11-01	129561	\N	\N	f	Sales which are qualified	0
129561_3650.0_2017-06-02	365000	\N	2017-06-02	129561	\N	\N	f	Qual by exam of deed	0
129563_2250.0_2003-03-01	225000	\N	2003-03-01	129563	\N	\N	f	Sales which are qualified	0
129563_2750.0_2005-02-01	275000	\N	2005-02-01	129563	\N	\N	f	Sales which are qualified	0
129563_4950.0_2021-08-02	495000	\N	2021-08-02	129563	\N	\N	f	Qual by exam of deed	0
129563_7850.0_2022-10-10	785000	\N	2022-10-10	129563	\N	\N	f	Qual by exam of deed	0
129567_1360.0_1998-08-01	136000	\N	1998-08-01	129567	\N	\N	f	Sales which are qualified	0
129568_3950.0_2004-03-01	395000	\N	2004-03-01	129568	\N	\N	f	Sales which are qualified	0
129568_4430.0_2006-03-01	443000	\N	2006-03-01	129568	\N	\N	f	Sales which are qualified	0
129570_1500.0_1998-05-01	150000	\N	1998-05-01	129570	\N	\N	f	Sales which are qualified	0
129570_2750.0_2011-09-15	275000	\N	2011-09-15	129570	\N	\N	f	Qual by exam of deed	0
129570_3300.0_2005-07-01	330000	\N	2005-07-01	129570	\N	\N	f	Sales which are qualified	0
129570_3900.0_2002-07-01	390000	\N	2002-07-01	129570	\N	\N	f	Sales which are qualified	0
129570_4550.0_2017-05-30	455000	\N	2017-05-30	129570	\N	\N	f	Qual by exam of deed	0
129570_4990.0_2006-11-01	499000	\N	2006-11-01	129570	\N	\N	f	Sales which are qualified	0
129570_6400.0_2007-06-01	640000	\N	2007-06-01	129570	\N	\N	f	Sales which are qualified	0
129571_1749.0_1999-03-01	174900	\N	1999-03-01	129571	\N	\N	f	Sales which are qualified	0
129571_7200.0_2015-08-20	720000	\N	2015-08-20	129571	\N	\N	f	Qual by exam of deed	0
129575_2600.0_2009-08-03	260000	\N	2009-08-03	129575	\N	\N	f	Qual by exam of deed	0
129575_3390.0_2003-04-01	339000	\N	2003-04-01	129575	\N	\N	f	Sales which are qualified	0
129575_5150.0_2005-07-01	515000	\N	2005-07-01	129575	\N	\N	f	Sales which are qualified	0
129575_5500.0_2013-05-21	550000	\N	2013-05-21	129575	\N	\N	f	Qual by exam of deed	0
129579_1489.0_1999-04-01	148900	\N	1999-04-01	129579	\N	\N	f	Sales which are qualified	0
129579_3750.0_2018-01-24	375000	\N	2018-01-24	129579	\N	\N	f	Qual by exam of deed	0
129579_6000.0_2020-08-07	600000	\N	2020-08-07	129579	\N	\N	f	Qual by exam of deed	0
129580_1410.0_1999-03-01	141000	\N	1999-03-01	129580	\N	\N	f	Sales which are qualified	0
129580_2030.0_2005-05-01	203000	\N	2005-05-01	129580	\N	\N	f	Sales which are qualified	0
129581_2450.0_2003-09-01	245000	\N	2003-09-01	129581	\N	\N	f	Sales which are qualified	0
129581_4050.0_2005-06-01	405000	\N	2005-06-01	129581	\N	\N	f	Sales which are qualified	0
129581_4680.0_2017-02-10	468000	\N	2017-02-10	129581	\N	\N	f	Qual by exam of deed	0
129595_1165.0_1999-08-01	116500	\N	1999-08-01	129595	\N	\N	f	Sales which are qualified	0
129595_2050.0_2004-08-01	205000	\N	2004-08-01	129595	\N	\N	f	Sales which are qualified	0
129598_4100.0_2015-07-09	410000	\N	2015-07-09	129598	\N	\N	f	Qual by exam of deed	0
129600_2200.0_2003-12-01	220000	\N	2003-12-01	129600	\N	\N	f	Sales which are qualified	0
129601_11000.0_2019-11-21	1100000	\N	2019-11-21	129601	\N	\N	t	Qual on DOS, multi-parcel sale	0
129603_1070.0_1999-06-01	107000	\N	1999-06-01	129603	\N	\N	f	Sales which are qualified	0
129603_3800.0_2013-06-11	380000	\N	2013-06-11	129603	\N	\N	f	Qual by exam of deed	0
129604_1300.0_1999-12-01	130000	\N	1999-12-01	129604	\N	\N	f	Sales which are qualified	0
129604_1480.0_2002-09-01	148000	\N	2002-09-01	129604	\N	\N	f	Sales which are qualified	0
129604_3430.0_2019-01-02	343000	\N	2019-01-02	129604	\N	\N	f	Qual by exam of deed	0
129604_3780.0_2013-09-20	378000	\N	2013-09-20	129604	\N	\N	f	Qual by exam of deed	0
129614_1499.0_1999-06-01	149900	\N	1999-06-01	129614	\N	\N	f	Sales which are qualified	0
129614_1800.0_2008-12-12	180000	\N	2008-12-12	129614	\N	\N	f	Other disqualified	0
129614_3900.0_2005-07-01	390000	\N	2005-07-01	129614	\N	\N	f	Sales which are qualified	0
129614_4100.0_2017-08-31	410000	\N	2017-08-31	129614	\N	\N	f	Qual by exam of deed	0
129614_6300.0_2006-05-01	630000	\N	2006-05-01	129614	\N	\N	f	Sales which are qualified	0
129615_1359.0_1999-04-01	135900	\N	1999-04-01	129615	\N	\N	f	Sales which are qualified	0
129615_2950.0_2004-09-01	295000	\N	2004-09-01	129615	\N	\N	f	Sales which are qualified	0
129615_4800.0_2006-12-01	480000	\N	2006-12-01	129615	\N	\N	f	Sales which are qualified	0
129615_6468.0_2021-07-27	646800	\N	2021-07-27	129615	\N	\N	f	Qual by exam of deed	0
129616_1442.0_1998-12-01	144200	\N	1998-12-01	129616	\N	\N	f	Sales which are qualified	0
129616_2325.0_2012-01-10	232500	\N	2012-01-10	129616	\N	\N	f	Qual by verifiable & documented evidence	0
129616_4950.0_2006-09-01	495000	\N	2006-09-01	129616	\N	\N	f	Sales which are qualified	0
129616_7850.0_2022-04-22	785000	\N	2022-04-22	129616	\N	\N	f	Qual by exam of deed	0
129620_2200.0_2002-03-01	220000	\N	2002-03-01	129620	\N	\N	f	Sales which are qualified	0
129620_3900.0_2004-04-01	390000	\N	2004-04-01	129620	\N	\N	f	Sales which are qualified	0
129620_4470.0_2005-11-01	447000	\N	2005-11-01	129620	\N	\N	f	Sales which are qualified	0
129620_6000.0_2019-09-23	600000	\N	2019-09-23	129620	\N	\N	f	Qual by exam of deed	0
129620_9000.0_2023-03-23	900000	\N	2023-03-23	129620	\N	\N	f	Qual by exam of deed	0
129622_1805.0_1999-08-01	180500	\N	1999-08-01	129622	\N	\N	f	Sales which are qualified	0
129622_3900.0_2003-09-01	390000	\N	2003-09-01	129622	\N	\N	f	Sales which are qualified	0
129622_5500.0_2013-12-02	550000	\N	2013-12-02	129622	\N	\N	f	Qual by exam of deed	0
129625_3099.0_2002-11-01	309900	\N	2002-11-01	129625	\N	\N	f	Sales which are qualified	0
129627_2180.0_2000-09-01	218000	\N	2000-09-01	129627	\N	\N	f	Sales which are qualified	0
129627_3840.0_2003-10-01	384000	\N	2003-10-01	129627	\N	\N	f	Sales which are qualified	0
129627_5550.0_2018-10-24	555000	\N	2018-10-24	129627	\N	\N	f	Qual by exam of deed	0
129628_1900.0_1999-07-01	190000	\N	1999-07-01	129628	\N	\N	f	Sales which are qualified	0
129629_6300.0_2018-02-26	630000	\N	2018-02-26	129629	\N	\N	f	Qual by exam of deed	0
129631_8600.0_2014-11-11	860000	\N	2014-11-11	129631	\N	\N	f	Qual by exam of deed	0
129633_15000.0_2022-01-31	1500000	\N	2022-01-31	129633	\N	\N	f	Qual by exam of deed	0
129633_2530.0_2000-07-01	253000	\N	2000-07-01	129633	\N	\N	f	Sales which are qualified	0
129633_4420.0_2004-12-01	442000	\N	2004-12-01	129633	\N	\N	f	Sales which are qualified	0
129635_2725.0_2000-12-01	272500	\N	2000-12-01	129635	\N	\N	f	Sales which are qualified	0
129635_3700.0_2010-01-15	370000	\N	2010-01-15	129635	\N	\N	f	Qual by exam of deed	0
129635_4365.0_2012-07-17	436500	\N	2012-07-17	129635	\N	\N	f	Qual by exam of deed	0
129635_9750.0_2021-06-01	975000	\N	2021-06-01	129635	\N	\N	f	Qual by exam of deed	0
129636_1859.0_1998-04-01	185900	\N	1998-04-01	129636	\N	\N	f	Sales which are qualified	0
129636_9300.0_2021-11-10	930000	\N	2021-11-10	129636	\N	\N	f	Qual by exam of deed	0
129641_13500.0_2022-04-08	1350000	\N	2022-04-08	129641	\N	\N	f	Qual by exam of deed	0
129641_2460.0_2000-08-01	246000	\N	2000-08-01	129641	\N	\N	f	Sales which are qualified	0
129643_2599.0_2000-12-01	259900	\N	2000-12-01	129643	\N	\N	f	Sales which are qualified	0
129644_19000.0_2023-06-08	1900000	\N	2023-06-08	129644	\N	\N	f	Qual by exam of deed	0
129644_7500.0_2019-12-17	750000	\N	2019-12-17	129644	\N	\N	f	Qual by exam of deed	0
129646_2510.0_1999-04-01	251000	\N	1999-04-01	129646	\N	\N	f	Sales which are qualified	0
129651_3900.0_2004-01-01	390000	\N	2004-01-01	129651	\N	\N	f	Sales which are qualified	0
129651_3950.0_2010-03-04	395000	\N	2010-03-04	129651	\N	\N	f	Qual by exam of deed	0
129653_2340.0_2000-09-01	234000	\N	2000-09-01	129653	\N	\N	f	Sales which are qualified	0
129653_2850.0_2009-11-09	285000	\N	2009-11-09	129653	\N	\N	f	Qual by exam of deed	0
129653_7000.0_2018-06-25	700000	\N	2018-06-25	129653	\N	\N	f	Qual by exam of deed	0
129654_2460.0_2000-12-01	246000	\N	2000-12-01	129654	\N	\N	f	Sales which are qualified	0
129654_6530.0_2018-03-29	653000	\N	2018-03-29	129654	\N	\N	f	Qual by exam of deed	0
129655_1650.0_1997-12-01	165000	\N	1997-12-01	129655	\N	\N	f	Sales which are qualified	0
129655_3900.0_2003-05-01	390000	\N	2003-05-01	129655	\N	\N	f	Sales which are qualified	0
129655_4350.0_2005-01-01	435000	\N	2005-01-01	129655	\N	\N	f	Sales which are qualified	0
129655_4800.0_2013-04-05	480000	\N	2013-04-05	129655	\N	\N	f	Qual by exam of deed	0
129655_5000.0_2005-07-01	500000	\N	2005-07-01	129655	\N	\N	f	Sales which are qualified	0
129657_3750.0_2003-12-01	375000	\N	2003-12-01	129657	\N	\N	f	Sales which are qualified	0
129658_2650.0_2001-04-01	265000	\N	2001-04-01	129658	\N	\N	f	Sales which are qualified	0
129658_3250.0_2003-03-01	325000	\N	2003-03-01	129658	\N	\N	f	Sales which are qualified	0
129658_4550.0_2005-02-01	455000	\N	2005-02-01	129658	\N	\N	f	Sales which are qualified	0
129658_9800.0_2021-09-22	980000	\N	2021-09-22	129658	\N	\N	f	Qual by exam of deed	0
129660_2510.0_1999-04-01	251000	\N	1999-04-01	129660	\N	\N	f	Sales which are qualified	0
129660_3600.0_2004-03-01	360000	\N	2004-03-01	129660	\N	\N	f	Sales which are qualified	0
129661_3550.0_2003-11-01	355000	\N	2003-11-01	129661	\N	\N	f	Sales which are qualified	0
129661_4650.0_2012-05-07	465000	\N	2012-05-07	129661	\N	\N	f	Qual by exam of deed	0
129662_1680.0_1998-06-01	168000	\N	1998-06-01	129662	\N	\N	f	Sales which are qualified	0
129662_3100.0_2002-06-01	310000	\N	2002-06-01	129662	\N	\N	f	Sales which are qualified	0
129662_3400.0_2003-12-01	340000	\N	2003-12-01	129662	\N	\N	f	Sales which are qualified	0
129662_7300.0_2006-01-01	730000	\N	2006-01-01	129662	\N	\N	f	Sales which are qualified	0
129662_9250.0_2021-03-12	925000	\N	2021-03-12	129662	\N	\N	f	Qual by exam of deed	0
129663_7475.0_2006-01-01	747500	\N	2006-01-01	129663	\N	\N	f	Sales which are qualified	0
129663_8115.0_2018-05-25	811500	\N	2018-05-25	129663	\N	\N	f	Qual by exam of deed	0
129665_2400.0_2004-05-01	240000	\N	2004-05-01	129665	\N	\N	f	Sales which are qualified	0
129666_1100.0_1997-12-01	110000	\N	1997-12-01	129666	\N	\N	f	Sales which are qualified	0
129666_4350.0_2018-02-26	435000	\N	2018-02-26	129666	\N	\N	f	Qual by exam of deed	0
129667_1157.0_1998-02-01	115700	\N	1998-02-01	129667	\N	\N	f	Sales which are qualified	0
129667_3000.0_2010-07-22	300000	\N	2010-07-22	129667	\N	\N	f	Qual by exam of deed	0
129667_4000.0_2017-12-26	400000	\N	2017-12-26	129667	\N	\N	f	Qual by exam of deed	0
129667_6520.0_2021-09-15	652000	\N	2021-09-15	129667	\N	\N	f	Qual by exam of deed	0
129668_1089.0_1999-01-01	108900	\N	1999-01-01	129668	\N	\N	f	Sales which are qualified	0
129668_2090.0_2003-08-01	209000	\N	2003-08-01	129668	\N	\N	f	Sales which are qualified	0
129668_4950.0_2018-04-10	495000	\N	2018-04-10	129668	\N	\N	f	Qual by exam of deed	0
129670_2600.0_2003-12-01	260000	\N	2003-12-01	129670	\N	\N	f	Sales which are qualified	0
129670_2630.0_2011-10-13	263000	\N	2011-10-13	129670	\N	\N	f	Qual by exam of deed	0
129670_3250.0_2008-08-15	325000	\N	2008-08-15	129670	\N	\N	f	Sales which are qualified	0
129670_7050.0_2015-04-08	705000	\N	2015-04-08	129670	\N	\N	f	Qual by exam of deed	0
129672_2070.0_2002-11-01	207000	\N	2002-11-01	129672	\N	\N	f	Sales which are qualified	0
129672_2990.0_2005-02-01	299000	\N	2005-02-01	129672	\N	\N	f	Sales which are qualified	0
129673_1730.0_1999-04-01	173000	\N	1999-04-01	129673	\N	\N	f	Sales which are qualified	0
129673_2600.0_2004-04-01	260000	\N	2004-04-01	129673	\N	\N	f	Sales which are qualified	0
129673_4700.0_2006-05-01	470000	\N	2006-05-01	129673	\N	\N	f	Sales which are qualified	0
129675_2800.0_2004-11-01	280000	\N	2004-11-01	129675	\N	\N	f	Sales which are qualified	0
129675_947.0_1997-12-01	94700	\N	1997-12-01	129675	\N	\N	f	Sales which are qualified	0
129677_3300.0_2021-05-14	330000	\N	2021-05-14	129677	\N	\N	f	Qual by exam of deed	0
129677_7500.0_2023-04-13	750000	\N	2023-04-13	129677	\N	\N	f	Qual by exam of deed	0
129677_799.0_1998-02-01	79900	\N	1998-02-01	129677	\N	\N	f	Sales which are qualified	0
129679_1700.0_2002-06-01	170000	\N	2002-06-01	129679	\N	\N	f	Sales which are qualified	0
129679_1900.0_2004-02-01	190000	\N	2004-02-01	129679	\N	\N	f	Sales which are qualified	0
129679_4050.0_2015-04-02	405000	\N	2015-04-02	129679	\N	\N	f	Qual by exam of deed	0
129679_4500.0_2021-06-17	450000	\N	2021-06-17	129679	\N	\N	f	Qual by exam of deed	0
129679_955.0_1998-12-01	95500	\N	1998-12-01	129679	\N	\N	f	Sales which are qualified	0
129683_2299.0_2002-11-01	229900	\N	2002-11-01	129683	\N	\N	f	Sales which are qualified	0
129683_2500.0_2012-05-30	250000	\N	2012-05-30	129683	\N	\N	f	Qual by exam of deed	0
129683_2690.0_2004-11-01	269000	\N	2004-11-01	129683	\N	\N	f	Sales which are qualified	0
129683_4000.0_2013-11-27	400000	\N	2013-11-27	129683	\N	\N	f	Qual by exam of deed	0
129684_1250.0_1998-06-01	125000	\N	1998-06-01	129684	\N	\N	f	Sales which are qualified	0
129684_2345.0_2004-05-01	234500	\N	2004-05-01	129684	\N	\N	f	Sales which are qualified	0
129684_2630.0_2005-07-01	263000	\N	2005-07-01	129684	\N	\N	f	Sales which are qualified	0
129684_3000.0_2008-03-01	300000	\N	2008-03-01	129684	\N	\N	f	Sales which are qualified	0
129684_4500.0_2006-07-01	450000	\N	2006-07-01	129684	\N	\N	f	Sales which are qualified	0
129686_2225.0_2003-08-01	222500	\N	2003-08-01	129686	\N	\N	f	Sales which are qualified	0
129686_2450.0_2011-04-13	245000	\N	2011-04-13	129686	\N	\N	f	Qual by exam of deed	0
129686_4400.0_2019-03-26	440000	\N	2019-03-26	129686	\N	\N	f	Qual by exam of deed	0
129686_6200.0_2021-10-08	620000	\N	2021-10-08	129686	\N	\N	f	Qual by exam of deed	0
129690_1380.0_2011-01-06	138000	\N	2011-01-06	129690	\N	\N	f	Qual by exam of deed	0
129690_1900.0_2003-12-01	190000	\N	2003-12-01	129690	\N	\N	f	Sales which are qualified	0
129690_799.0_1997-10-01	79900	\N	1997-10-01	129690	\N	\N	f	Sales which are qualified	0
129690_990.0_1999-07-01	99000	\N	1999-07-01	129690	\N	\N	f	Sales which are qualified	0
129694_3380.0_2007-05-01	338000	\N	2007-05-01	129694	\N	\N	f	Sales which are qualified	0
129694_899.0_1998-01-01	89900	\N	1998-01-01	129694	\N	\N	f	Sales which are qualified	0
129695_1920.0_2002-10-01	192000	\N	2002-10-01	129695	\N	\N	f	Sales which are qualified	0
129695_4100.0_2014-04-14	410000	\N	2014-04-14	129695	\N	\N	f	Qual by exam of deed	0
129695_4100.0_2018-09-21	410000	\N	2018-09-21	129695	\N	\N	f	Qual by exam of deed	0
129697_1650.0_2001-12-01	165000	\N	2001-12-01	129697	\N	\N	f	Sales which are qualified	0
129697_1750.0_2011-01-31	175000	\N	2011-01-31	129697	\N	\N	f	Qual by exam of deed	0
129697_2220.0_2004-02-01	222000	\N	2004-02-01	129697	\N	\N	f	Sales which are qualified	0
129697_3250.0_2005-06-01	325000	\N	2005-06-01	129697	\N	\N	f	Sales which are qualified	0
129697_4000.0_2018-04-05	400000	\N	2018-04-05	129697	\N	\N	f	Qual by exam of deed	0
129697_4250.0_2021-02-16	425000	\N	2021-02-16	129697	\N	\N	f	Qual by exam of deed	0
129697_4500.0_2006-05-01	450000	\N	2006-05-01	129697	\N	\N	f	Sales which are qualified	0
129697_799.0_1998-08-01	79900	\N	1998-08-01	129697	\N	\N	f	Sales which are qualified	0
129698_750.0_1997-10-01	75000	\N	1997-10-01	129698	\N	\N	f	Sales which are qualified	0
129700_799.0_1998-03-01	79900	\N	1998-03-01	129700	\N	\N	f	Sales which are qualified	0
129149_2180.0_2001-02-01	218000	\N	2001-02-01	129149	\N	\N	f	Sales which are qualified	0
129149_9700.0_2023-05-13	970000	\N	2023-05-13	129149	\N	\N	f	Qual by exam of deed	0
129150_2800.0_2003-12-01	280000	\N	2003-12-01	129150	\N	\N	f	Sales which are qualified	0
129151_1898.0_1999-11-01	189800	\N	1999-11-01	129151	\N	\N	f	Sales which are qualified	0
129151_2620.0_2010-01-15	262000	\N	2010-01-15	129151	\N	\N	f	Qual by exam of deed	0
129151_3000.0_2004-09-01	300000	\N	2004-09-01	129151	\N	\N	f	Sales which are qualified	0
129151_6250.0_2006-09-01	625000	\N	2006-09-01	129151	\N	\N	f	Sales which are qualified	0
129152_2625.0_2001-03-01	262500	\N	2001-03-01	129152	\N	\N	f	Sales which are qualified	0
129152_3780.0_2013-02-20	378000	\N	2013-02-20	129152	\N	\N	f	Qual by exam of deed	0
129154_3199.0_2002-10-01	319900	\N	2002-10-01	129154	\N	\N	f	Sales which are qualified	0
129154_3480.0_2010-07-21	348000	\N	2010-07-21	129154	\N	\N	f	Qual by exam of deed	0
129154_5750.0_2019-06-26	575000	\N	2019-06-26	129154	\N	\N	f	Qual by exam of deed	0
129155_2500.0_2011-04-18	250000	\N	2011-04-18	129155	\N	\N	f	Qual by exam of deed	0
129155_2850.0_2003-09-01	285000	\N	2003-09-01	129155	\N	\N	f	Sales which are qualified	0
129155_5200.0_2013-11-12	520000	\N	2013-11-12	129155	\N	\N	f	Qual by exam of deed	0
129157_2500.0_2011-02-25	250000	\N	2011-02-25	129157	\N	\N	f	Qual by exam of deed	0
129157_3459.0_2003-04-01	345900	\N	2003-04-01	129157	\N	\N	f	Sales which are qualified	0
129159_2159.0_2001-02-01	215900	\N	2001-02-01	129159	\N	\N	f	Sales which are qualified	0
129159_3900.0_2003-10-01	390000	\N	2003-10-01	129159	\N	\N	f	Sales which are qualified	0
129159_4299.0_2005-08-01	429900	\N	2005-08-01	129159	\N	\N	f	Sales which are qualified	0
129159_5450.0_2016-03-24	545000	\N	2016-03-24	129159	\N	\N	f	Qual by exam of deed	0
129159_5890.0_2005-12-01	589000	\N	2005-12-01	129159	\N	\N	f	Sales which are qualified	0
129159_6800.0_2007-06-01	680000	\N	2007-06-01	129159	\N	\N	f	Sales which are qualified	0
129160_2560.0_2002-05-01	256000	\N	2002-05-01	129160	\N	\N	f	Sales which are qualified	0
129160_5650.0_2015-04-23	565000	\N	2015-04-23	129160	\N	\N	f	Qual by exam of deed	0
129161_2000.0_1999-11-01	200000	\N	1999-11-01	129161	\N	\N	f	Sales which are qualified	0
129161_700.0_2007-06-22	70000	\N	2007-06-22	129161	\N	\N	f	Sales which are disqualified as a result of examination of the deed	0
129162_1589.0_1997-11-01	158900	\N	1997-11-01	129162	\N	\N	f	Sales which are qualified	0
129162_3920.0_2004-03-01	392000	\N	2004-03-01	129162	\N	\N	f	Sales which are qualified	0
129162_3950.0_2005-01-01	395000	\N	2005-01-01	129162	\N	\N	f	Sales which are qualified	0
129167_2700.0_2002-01-01	270000	\N	2002-01-01	129167	\N	\N	f	Sales which are qualified	0
129167_4020.0_2005-04-01	402000	\N	2005-04-01	129167	\N	\N	f	Sales which are qualified	0
129167_6999.0_2007-01-01	699900	\N	2007-01-01	129167	\N	\N	f	Sales which are qualified	0
129167_9000.0_2016-01-04	900000	\N	2016-01-04	129167	\N	\N	f	Qual by exam of deed	0
129169_3910.0_2002-10-01	391000	\N	2002-10-01	129169	\N	\N	f	Sales which are qualified	0
129169_4200.0_2012-10-10	420000	\N	2012-10-10	129169	\N	\N	f	Qual by exam of deed	0
129169_7227.0_2020-03-03	722700	\N	2020-03-03	129169	\N	\N	f	Qual by exam of deed	0
129170_3420.0_2003-03-01	342000	\N	2003-03-01	129170	\N	\N	f	Sales which are qualified	0
129170_3900.0_2004-11-01	390000	\N	2004-11-01	129170	\N	\N	f	Sales which are qualified	0
129170_4800.0_2005-06-01	480000	\N	2005-06-01	129170	\N	\N	f	Sales which are qualified	0
129170_7250.0_2021-04-04	725000	\N	2021-04-04	129170	\N	\N	f	Qual by exam of deed	0
129171_4250.0_2012-12-20	425000	\N	2012-12-20	129171	\N	\N	f	Qual by exam of deed	0
129171_4400.0_2003-04-01	440000	\N	2003-04-01	129171	\N	\N	f	Sales which are qualified	0
129171_8050.0_2016-04-04	805000	\N	2016-04-04	129171	\N	\N	f	Qual by exam of deed	0
129172_11500.0_2020-09-16	1150000	\N	2020-09-16	129172	\N	\N	f	Qual by exam of deed	0
129172_4650.0_2004-01-01	465000	\N	2004-01-01	129172	\N	\N	f	Sales which are qualified	0
129172_5850.0_2004-06-01	585000	\N	2004-06-01	129172	\N	\N	f	Sales which are qualified	0
129172_7490.0_2012-07-24	749000	\N	2012-07-24	129172	\N	\N	f	Qual by exam of deed	0
129175_2180.0_1999-11-01	218000	\N	1999-11-01	129175	\N	\N	f	Sales which are qualified	0
129175_2600.0_2011-01-14	260000	\N	2011-01-14	129175	\N	\N	f	Qual by exam of deed	0
129175_3200.0_2003-09-01	320000	\N	2003-09-01	129175	\N	\N	f	Sales which are qualified	0
129175_3500.0_2012-12-19	350000	\N	2012-12-19	129175	\N	\N	f	Qual by exam of deed	0
129175_4200.0_2005-03-01	420000	\N	2005-03-01	129175	\N	\N	f	Sales which are qualified	0
129178_3800.0_2002-01-01	380000	\N	2002-01-01	129178	\N	\N	f	Sales which are qualified	0
129179_2270.0_1999-07-01	227000	\N	1999-07-01	129179	\N	\N	f	Sales which are qualified	0
129179_2700.0_2001-04-01	270000	\N	2001-04-01	129179	\N	\N	f	Sales which are qualified	0
129179_3150.0_2003-02-01	315000	\N	2003-02-01	129179	\N	\N	f	Sales which are qualified	0
129179_3400.0_2010-12-16	340000	\N	2010-12-16	129179	\N	\N	f	Qual by exam of deed	0
129181_2340.0_1999-12-01	234000	\N	1999-12-01	129181	\N	\N	f	Sales which are qualified	0
129181_3100.0_2004-03-01	310000	\N	2004-03-01	129181	\N	\N	f	Sales which are qualified	0
129181_4200.0_2012-05-18	420000	\N	2012-05-18	129181	\N	\N	f	Qual by exam of deed	0
129181_7550.0_2020-01-22	755000	\N	2020-01-22	129181	\N	\N	f	Qual by exam of deed	0
129182_2370.0_1999-12-01	237000	\N	1999-12-01	129182	\N	\N	f	Sales which are qualified	0
129182_3200.0_2004-04-01	320000	\N	2004-04-01	129182	\N	\N	f	Sales which are qualified	0
129182_3700.0_2004-07-01	370000	\N	2004-07-01	129182	\N	\N	f	Sales which are qualified	0
129182_5300.0_2005-07-01	530000	\N	2005-07-01	129182	\N	\N	f	Sales which are qualified	0
129185_3570.0_2002-10-01	357000	\N	2002-10-01	129185	\N	\N	f	Sales which are qualified	0
129185_4300.0_2004-10-01	430000	\N	2004-10-01	129185	\N	\N	f	Sales which are qualified	0
129185_6700.0_2007-06-01	670000	\N	2007-06-01	129185	\N	\N	f	Sales which are qualified	0
129185_6775.0_2020-07-27	677500	\N	2020-07-27	129185	\N	\N	f	Qual by exam of deed	0
129186_6070.0_2003-07-01	607000	\N	2003-07-01	129186	\N	\N	f	Sales which are qualified	0
129186_6500.0_2008-04-01	650000	\N	2008-04-01	129186	\N	\N	f	Sales which are qualified	0
129188_2341.0_2000-07-01	234100	\N	2000-07-01	129188	\N	\N	f	Sales which are qualified	0
129188_3200.0_2009-10-15	320000	\N	2009-10-15	129188	\N	\N	f	Qual by exam of deed	0
129188_6400.0_2020-02-06	640000	\N	2020-02-06	129188	\N	\N	f	Qual by exam of deed	0
129191_3490.0_2004-10-01	349000	\N	2004-10-01	129191	\N	\N	f	Sales which are qualified	0
129191_3900.0_2002-07-01	390000	\N	2002-07-01	129191	\N	\N	f	Sales which are qualified	0
129202_1910.0_1999-04-01	191000	\N	1999-04-01	129202	\N	\N	f	Sales which are qualified	0
129202_3990.0_2003-12-01	399000	\N	2003-12-01	129202	\N	\N	f	Sales which are qualified	0
129202_6350.0_2018-06-25	635000	\N	2018-06-25	129202	\N	\N	f	Qual by exam of deed	0
129205_1450.0_1997-09-01	145000	\N	1997-09-01	129205	\N	\N	f	Sales which are qualified	0
129205_2570.0_2008-10-15	257000	\N	2008-10-15	129205	\N	\N	f	Sales which are qualified	0
129205_7000.0_2018-04-04	700000	\N	2018-04-04	129205	\N	\N	f	Qual by exam of deed	0
129210_2280.0_1999-03-01	228000	\N	1999-03-01	129210	\N	\N	f	Sales which are qualified	0
129210_4100.0_2005-05-01	410000	\N	2005-05-01	129210	\N	\N	f	Sales which are qualified	0
129213_5250.0_2004-03-01	525000	\N	2004-03-01	129213	\N	\N	f	Sales which are qualified	0
129214_11470.0_2018-07-12	1147000	\N	2018-07-12	129214	\N	\N	f	Qual by exam of deed	0
129214_1890.0_1998-01-01	189000	\N	1998-01-01	129214	\N	\N	f	Sales which are qualified	0
129214_7800.0_2006-05-01	780000	\N	2006-05-01	129214	\N	\N	f	Sales which are qualified	0
129216_4200.0_2003-11-01	420000	\N	2003-11-01	129216	\N	\N	f	Sales which are qualified	0
129216_8000.0_2013-07-15	800000	\N	2013-07-15	129216	\N	\N	f	Qual by exam of deed	0
129216_9750.0_2016-05-26	975000	\N	2016-05-26	129216	\N	\N	f	Qual by exam of deed	0
129222_15710.0_2021-05-12	1571000	\N	2021-05-12	129222	\N	\N	f	Qual by exam of deed	0
129222_4599.0_2002-06-01	459900	\N	2002-06-01	129222	\N	\N	f	Sales which are qualified	0
129222_5300.0_2003-12-01	530000	\N	2003-12-01	129222	\N	\N	f	Sales which are qualified	0
129222_8650.0_2012-12-05	865000	\N	2012-12-05	129222	\N	\N	f	Qual by exam of deed	0
129223_12000.0_2021-01-13	1200000	\N	2021-01-13	129223	\N	\N	f	Qual by exam of deed	0
129223_3036.0_1999-06-01	303600	\N	1999-06-01	129223	\N	\N	f	Sales which are qualified	0
129229_11850.0_2019-02-05	1185000	\N	2019-02-05	129229	\N	\N	f	Qual by exam of deed	0
129229_21000.0_2023-02-14	2100000	\N	2023-02-14	129229	\N	\N	f	Qual by exam of deed	0
129229_21500.0_2022-02-28	2150000	\N	2022-02-28	129229	\N	\N	f	Qual by exam of deed	0
129229_2410.0_1998-07-01	241000	\N	1998-07-01	129229	\N	\N	f	Sales which are qualified	0
129229_3750.0_2002-12-01	375000	\N	2002-12-01	129229	\N	\N	f	Sales which are qualified	0
129229_5500.0_2012-04-18	550000	\N	2012-04-18	129229	\N	\N	f	Qual by exam of deed	0
129231_14500.0_2014-12-22	1450000	\N	2014-12-22	129231	\N	\N	f	Qual by exam of deed	0
129231_2609.0_1998-04-01	260900	\N	1998-04-01	129231	\N	\N	f	Sales which are qualified	0
129231_5540.0_2005-08-01	554000	\N	2005-08-01	129231	\N	\N	f	Sales which are qualified	0
129232_2600.0_1998-09-01	260000	\N	1998-09-01	129232	\N	\N	f	Sales which are qualified	0
129232_4260.0_2003-01-01	426000	\N	2003-01-01	129232	\N	\N	f	Sales which are qualified	0
129232_8500.0_2013-12-06	850000	\N	2013-12-06	129232	\N	\N	f	Qual by exam of deed	0
129233_2249.0_1998-01-01	224900	\N	1998-01-01	129233	\N	\N	f	Sales which are qualified	0
129233_6350.0_2012-12-28	635000	\N	2012-12-28	129233	\N	\N	f	Qual by exam of deed	0
129233_8150.0_2013-05-22	815000	\N	2013-05-22	129233	\N	\N	f	Qual by exam of deed	0
129234_5500.0_2011-08-23	550000	\N	2011-08-23	129234	\N	\N	f	Qual by exam of deed	0
129234_5950.0_2005-02-01	595000	\N	2005-02-01	129234	\N	\N	f	Sales which are qualified	0
129234_9750.0_2007-05-01	975000	\N	2007-05-01	129234	\N	\N	f	Sales which are qualified	0
129235_13000.0_2016-09-26	1300000	\N	2016-09-26	129235	\N	\N	f	Qual by exam of deed	0
129235_17750.0_2021-05-01	1775000	\N	2021-05-01	129235	\N	\N	f	Qual by exam of deed	0
129235_3080.0_1998-10-01	308000	\N	1998-10-01	129235	\N	\N	f	Sales which are qualified	0
129235_7400.0_2005-06-01	740000	\N	2005-06-01	129235	\N	\N	f	Sales which are qualified	0
129249_3172.0_1999-11-01	317200	\N	1999-11-01	129249	\N	\N	f	Sales which are qualified	0
129249_4150.0_2003-01-01	415000	\N	2003-01-01	129249	\N	\N	f	Sales which are qualified	0
129249_9500.0_2013-12-10	950000	\N	2013-12-10	129249	\N	\N	f	Qual by exam of deed	0
129255_4640.0_2001-11-01	464000	\N	2001-11-01	129255	\N	\N	f	Sales which are qualified	0
129255_4900.0_2003-09-01	490000	\N	2003-09-01	129255	\N	\N	f	Sales which are qualified	0
129258_15950.0_2020-07-13	1595000	\N	2020-07-13	129258	\N	\N	f	Qual by exam of deed	0
129258_2300.0_1998-03-01	230000	\N	1998-03-01	129258	\N	\N	f	Sales which are qualified	0
129258_26900.0_2023-03-21	2690000	\N	2023-03-21	129258	\N	\N	f	Qual by exam of deed	0
129260_14000.0_2015-09-22	1400000	\N	2015-09-22	129260	\N	\N	f	Qual by exam of deed	0
129260_6820.0_2012-02-15	682000	\N	2012-02-15	129260	\N	\N	f	Qual by exam of deed	0
129264_11500.0_2017-04-10	1150000	\N	2017-04-10	129264	\N	\N	f	Qual by exam of deed	0
129264_2600.0_1997-10-01	260000	\N	1997-10-01	129264	\N	\N	f	Sales which are qualified	0
129264_4831.0_2002-11-01	483100	\N	2002-11-01	129264	\N	\N	f	Sales which are qualified	0
129264_5750.0_2004-06-01	575000	\N	2004-06-01	129264	\N	\N	f	Sales which are qualified	0
129264_7150.0_2010-03-26	715000	\N	2010-03-26	129264	\N	\N	f	Qual by exam of deed	0
129265_10000.0_2013-04-18	1000000	\N	2013-04-18	129265	\N	\N	f	Qual by exam of deed	0
129265_11000.0_2006-11-01	1100000	\N	2006-11-01	129265	\N	\N	f	Sales which are qualified	0
129265_3106.0_1998-08-01	310600	\N	1998-08-01	129265	\N	\N	f	Sales which are qualified	0
129265_5125.0_2003-08-01	512500	\N	2003-08-01	129265	\N	\N	f	Sales which are qualified	0
129265_6270.0_2012-09-28	627000	\N	2012-09-28	129265	\N	\N	f	Qual by exam of deed	0
129265_8900.0_2005-04-01	890000	\N	2005-04-01	129265	\N	\N	f	Sales which are qualified	0
129266_12000.0_2017-02-23	1200000	\N	2017-02-23	129266	\N	\N	f	Qual by exam of deed	0
129266_30000.0_2021-05-25	3000000	\N	2021-05-25	129266	\N	\N	f	Qual by exam of deed	0
129266_3309.0_1998-05-01	330900	\N	1998-05-01	129266	\N	\N	f	Sales which are qualified	0
129268_5290.0_2004-02-01	529000	\N	2004-02-01	129268	\N	\N	f	Sales which are qualified	0
129269_8050.0_2006-04-01	805000	\N	2006-04-01	129269	\N	\N	f	Sales which are qualified	0
129269_9150.0_2006-09-01	915000	\N	2006-09-01	129269	\N	\N	f	Sales which are qualified	0
129271_3310.0_1999-10-01	331000	\N	1999-10-01	129271	\N	\N	f	Sales which are qualified	0
129272_4330.0_2001-07-01	433000	\N	2001-07-01	129272	\N	\N	f	Sales which are qualified	0
129272_5750.0_2005-02-01	575000	\N	2005-02-01	129272	\N	\N	f	Sales which are qualified	0
129272_5750.0_2009-06-24	575000	\N	2009-06-24	129272	\N	\N	f	Qual by exam of deed	0
129275_14000.0_2018-08-20	1400000	\N	2018-08-20	129275	\N	\N	f	Qual by exam of deed	0
129275_3070.0_1998-10-01	307000	\N	1998-10-01	129275	\N	\N	f	Sales which are qualified	0
129288_2100.0_2010-03-12	210000	\N	2010-03-12	129288	\N	\N	f	Qual by exam of deed	0
129288_2275.0_2004-06-01	227500	\N	2004-06-01	129288	\N	\N	f	Sales which are qualified	0
129288_5550.0_2019-07-24	555000	\N	2019-07-24	129288	\N	\N	f	Qual by exam of deed	0
129289_1554.0_1999-09-01	155400	\N	1999-09-01	129289	\N	\N	f	Sales which are qualified	0
129289_2650.0_2004-10-01	265000	\N	2004-10-01	129289	\N	\N	f	Sales which are qualified	0
129289_2800.0_2008-04-01	280000	\N	2008-04-01	129289	\N	\N	f	Sales which are qualified	0
129289_5750.0_2018-11-06	575000	\N	2018-11-06	129289	\N	\N	f	Qual by exam of deed	0
129289_8400.0_2023-02-15	840000	\N	2023-02-15	129289	\N	\N	f	Qual by exam of deed	0
129290_1510.0_1999-06-01	151000	\N	1999-06-01	129290	\N	\N	f	Sales which are qualified	0
129290_3150.0_2018-08-03	315000	\N	2018-08-03	129290	\N	\N	f	Qual by exam of deed	0
129290_4000.0_2022-09-13	400000	\N	2022-09-13	129290	\N	\N	f	Qual by exam of deed	0
129292_1320.0_1998-06-01	132000	\N	1998-06-01	129292	\N	\N	f	Sales which are qualified	0
129292_5240.0_2014-10-24	524000	\N	2014-10-24	129292	\N	\N	f	Qual by exam of deed	0
129295_3050.0_2002-11-01	305000	\N	2002-11-01	129295	\N	\N	f	Sales which are qualified	0
129295_5000.0_2014-02-25	500000	\N	2014-02-25	129295	\N	\N	f	Qual by exam of deed	0
129298_1085.0_1997-10-01	108500	\N	1997-10-01	129298	\N	\N	f	Sales which are qualified	0
129298_1980.0_2008-12-16	198000	\N	2008-12-16	129298	\N	\N	f	Sales which are qualified	0
129298_2200.0_2004-10-01	220000	\N	2004-10-01	129298	\N	\N	f	Sales which are qualified	0
129298_2700.0_2012-12-28	270000	\N	2012-12-28	129298	\N	\N	f	Qual by exam of deed	0
129303_2152.0_2000-09-01	215200	\N	2000-09-01	129303	\N	\N	f	Sales which are qualified	0
129303_2350.0_2012-01-31	235000	\N	2012-01-31	129303	\N	\N	f	Qual by exam of deed	0
129303_4140.0_2018-07-24	414000	\N	2018-07-24	129303	\N	\N	f	Qual by exam of deed	0
129303_8240.0_2023-03-07	824000	\N	2023-03-07	129303	\N	\N	f	Qual by exam of deed	0
129304_1500.0_2009-11-11	150000	\N	2009-11-11	129304	\N	\N	f	Qual by exam of deed	0
129304_1939.0_2001-01-01	193900	\N	2001-01-01	129304	\N	\N	f	Sales which are qualified	0
129304_2500.0_2005-01-01	250000	\N	2005-01-01	129304	\N	\N	f	Sales which are qualified	0
129304_4250.0_2014-02-28	425000	\N	2014-02-28	129304	\N	\N	f	Qual by exam of deed	0
129304_5250.0_2021-04-06	525000	\N	2021-04-06	129304	\N	\N	f	Qual by exam of deed	0
129304_7750.0_2023-04-20	775000	\N	2023-04-20	129304	\N	\N	f	Qual by exam of deed	0
129310_1340.0_1999-12-01	134000	\N	1999-12-01	129310	\N	\N	f	Sales which are qualified	0
129310_1630.0_2003-03-01	163000	\N	2003-03-01	129310	\N	\N	f	Sales which are qualified	0
129310_2380.0_2009-08-03	238000	\N	2009-08-03	129310	\N	\N	f	Qual by exam of deed	0
129314_1990.0_2002-11-01	199000	\N	2002-11-01	129314	\N	\N	f	Sales which are qualified	0
129314_4650.0_2014-01-15	465000	\N	2014-01-15	129314	\N	\N	f	Qual by exam of deed	0
129323_2295.0_2001-05-01	229500	\N	2001-05-01	129323	\N	\N	f	Sales which are qualified	0
129323_3700.0_2008-04-01	370000	\N	2008-04-01	129323	\N	\N	f	Sales which are qualified	0
129323_3750.0_2017-07-26	375000	\N	2017-07-26	129323	\N	\N	f	Qual by exam of deed	0
129324_1720.0_1999-09-01	172000	\N	1999-09-01	129324	\N	\N	f	Sales which are qualified	0
129324_3930.0_2003-12-01	393000	\N	2003-12-01	129324	\N	\N	f	Sales which are qualified	0
129324_4500.0_2005-09-01	450000	\N	2005-09-01	129324	\N	\N	f	Sales which are qualified	0
129324_6250.0_2014-06-19	625000	\N	2014-06-19	129324	\N	\N	f	Qual by exam of deed	0
129325_2650.0_2008-11-24	265000	\N	2008-11-24	129325	\N	\N	f	Other disqualified	0
129325_2999.5_2004-04-01	299950	\N	2004-04-01	129325	\N	\N	f	Sales which are qualified	0
129325_3275.0_2010-09-07	327500	\N	2010-09-07	129325	\N	\N	f	Qual by exam of deed	0
129325_5850.0_2006-06-01	585000	\N	2006-06-01	129325	\N	\N	f	Sales which are qualified	0
129325_7000.0_2021-01-04	700000	\N	2021-01-04	129325	\N	\N	f	Qual by exam of deed	0
129329_2000.0_2000-01-01	200000	\N	2000-01-01	129329	\N	\N	f	Sales which are qualified	0
129329_2630.0_2002-08-01	263000	\N	2002-08-01	129329	\N	\N	f	Sales which are qualified	0
129330_1800.0_1999-06-01	180000	\N	1999-06-01	129330	\N	\N	f	Sales which are qualified	0
129330_2500.0_2002-11-01	250000	\N	2002-11-01	129330	\N	\N	f	Sales which are qualified	0
129330_6350.0_2020-02-11	635000	\N	2020-02-11	129330	\N	\N	f	Qual by exam of deed	0
129332_18750.0_2019-05-06	1875000	\N	2019-05-06	129332	\N	\N	t	Qual on DOS, multi-parcel sale	0
129332_3299.0_2003-11-01	329900	\N	2003-11-01	129332	\N	\N	f	Sales which are qualified	0
129332_7000.0_2013-11-04	700000	\N	2013-11-04	129332	\N	\N	f	Qual by exam of deed	0
129332_7100.0_2016-09-01	710000	\N	2016-09-01	129332	\N	\N	f	Qual by exam of deed	0
129334_3718.0_2003-01-01	371800	\N	2003-01-01	129334	\N	\N	f	Sales which are qualified	0
129334_3875.0_2003-12-01	387500	\N	2003-12-01	129334	\N	\N	f	Sales which are qualified	0
129334_4290.0_2004-12-01	429000	\N	2004-12-01	129334	\N	\N	f	Sales which are qualified	0
129334_4550.0_2012-04-25	455000	\N	2012-04-25	129334	\N	\N	f	Qual by exam of deed	0
129334_5650.0_2006-05-01	565000	\N	2006-05-01	129334	\N	\N	f	Sales which are qualified	0
129334_7300.0_2018-02-01	730000	\N	2018-02-01	129334	\N	\N	f	Qual by exam of deed	0
129335_2000.0_2010-04-12	200000	\N	2010-04-12	129335	\N	\N	f	Qual by exam of deed	0
129335_2260.0_2001-03-01	226000	\N	2001-03-01	129335	\N	\N	f	Sales which are qualified	0
129335_2700.0_2011-07-07	270000	\N	2011-07-07	129335	\N	\N	f	Qual by exam of deed	0
129341_2620.0_2001-03-01	262000	\N	2001-03-01	129341	\N	\N	f	Sales which are qualified	0
129343_5240.0_2007-07-18	524000	\N	2007-07-18	129343	\N	\N	f	Other disqualified	0
129343_6000.0_2013-10-21	600000	\N	2013-10-21	129343	\N	\N	f	Qual by exam of deed	0
129343_7300.0_2018-01-24	730000	\N	2018-01-24	129343	\N	\N	f	Qual by exam of deed	0
129344_1870.0_1999-02-01	187000	\N	1999-02-01	129344	\N	\N	f	Sales which are qualified	0
129344_3000.0_2009-04-17	300000	\N	2009-04-17	129344	\N	\N	f	Qual by exam of deed	0
129344_5000.0_2012-05-08	500000	\N	2012-05-08	129344	\N	\N	f	Qual by exam of deed	0
129344_6650.0_2017-03-29	665000	\N	2017-03-29	129344	\N	\N	f	Qual by exam of deed	0
129345_1955.0_1999-04-01	195500	\N	1999-04-01	129345	\N	\N	f	Sales which are qualified	0
129351_1310.0_1997-12-01	131000	\N	1997-12-01	129351	\N	\N	f	Sales which are qualified	0
129351_1650.0_1999-10-01	165000	\N	1999-10-01	129351	\N	\N	f	Sales which are qualified	0
129352_1499.0_1997-12-01	149900	\N	1997-12-01	129352	\N	\N	f	Sales which are qualified	0
129352_1499.0_2000-11-01	149900	\N	2000-11-01	129352	\N	\N	f	Sales which are qualified	0
129352_2900.0_2004-08-01	290000	\N	2004-08-01	129352	\N	\N	f	Sales which are qualified	0
129352_2999.0_2002-09-01	299900	\N	2002-09-01	129352	\N	\N	f	Sales which are qualified	0
129352_3500.0_2011-10-07	350000	\N	2011-10-07	129352	\N	\N	f	Qual by exam of deed	0
129352_3750.0_2005-04-01	375000	\N	2005-04-01	129352	\N	\N	f	Sales which are qualified	0
129352_6450.0_2016-06-09	645000	\N	2016-06-09	129352	\N	\N	f	Qual by exam of deed	0
129362_3210.0_2004-02-01	321000	\N	2004-02-01	129362	\N	\N	f	Sales which are qualified	0
129362_3700.0_2012-03-22	370000	\N	2012-03-22	129362	\N	\N	f	Qual by exam of deed	0
129362_8555.0_2015-09-03	855500	\N	2015-09-03	129362	\N	\N	f	Qual by exam of deed	0
129363_1608.0_1999-09-01	160800	\N	1999-09-01	129363	\N	\N	f	Sales which are qualified	0
129363_3900.0_2002-11-01	390000	\N	2002-11-01	129363	\N	\N	f	Sales which are qualified	0
129363_4050.0_2005-10-01	405000	\N	2005-10-01	129363	\N	\N	f	Sales which are qualified	0
129370_2489.0_2001-02-01	248900	\N	2001-02-01	129370	\N	\N	f	Sales which are qualified	0
129370_2800.0_2003-10-01	280000	\N	2003-10-01	129370	\N	\N	f	Sales which are qualified	0
129370_4600.0_2013-07-19	460000	\N	2013-07-19	129370	\N	\N	f	Qual by exam of deed	0
129370_5000.0_2017-11-27	500000	\N	2017-11-27	129370	\N	\N	f	Qual by exam of deed	0
129379_1590.0_1999-08-01	159000	\N	1999-08-01	129379	\N	\N	f	Sales which are qualified	0
129379_1899.0_2000-12-01	189900	\N	2000-12-01	129379	\N	\N	f	Sales which are qualified	0
129379_4850.0_2017-12-27	485000	\N	2017-12-27	129379	\N	\N	f	Qual by exam of deed	0
129380_1600.0_1999-04-01	160000	\N	1999-04-01	129380	\N	\N	f	Sales which are qualified	0
129380_4950.0_2018-02-15	495000	\N	2018-02-15	129380	\N	\N	f	Qual by exam of deed	0
129380_6250.0_2019-09-10	625000	\N	2019-09-10	129380	\N	\N	f	Qual by exam of deed	0
129382_10250.0_2023-05-31	1025000	\N	2023-05-31	129382	\N	\N	f	Qual by exam of deed	0
129382_1630.0_1999-07-01	163000	\N	1999-07-01	129382	\N	\N	f	Sales which are qualified	0
129393_1237.0_1998-08-01	123700	\N	1998-08-01	129393	\N	\N	f	Sales which are qualified	0
129393_2235.0_2004-03-01	223500	\N	2004-03-01	129393	\N	\N	f	Sales which are qualified	0
129394_1415.0_1999-06-01	141500	\N	1999-06-01	129394	\N	\N	f	Sales which are qualified	0
129394_2680.0_2005-04-01	268000	\N	2005-04-01	129394	\N	\N	f	Sales which are qualified	0
129394_3000.0_2012-05-04	300000	\N	2012-05-04	129394	\N	\N	f	Qual by exam of deed	0
129394_4450.0_2014-10-29	445000	\N	2014-10-29	129394	\N	\N	f	Qual by exam of deed	0
129394_4750.0_2016-05-31	475000	\N	2016-05-31	129394	\N	\N	f	Qual by exam of deed	0
129395_1999.0_2002-02-01	199900	\N	2002-02-01	129395	\N	\N	f	Sales which are qualified	0
129395_2200.0_2004-05-01	220000	\N	2004-05-01	129395	\N	\N	f	Sales which are qualified	0
129395_2700.0_2012-08-27	270000	\N	2012-08-27	129395	\N	\N	f	Qual by exam of deed	0
129398_1449.0_1999-06-01	144900	\N	1999-06-01	129398	\N	\N	f	Sales which are qualified	0
129400_1540.0_1999-09-01	154000	\N	1999-09-01	129400	\N	\N	f	Sales which are qualified	0
129400_2150.0_2003-03-01	215000	\N	2003-03-01	129400	\N	\N	f	Sales which are qualified	0
129400_3125.0_2005-10-01	312500	\N	2005-10-01	129400	\N	\N	f	Sales which are qualified	0
129402_2650.0_2003-01-01	265000	\N	2003-01-01	129402	\N	\N	f	Sales which are qualified	0
129405_1700.0_2003-12-01	170000	\N	2003-12-01	129405	\N	\N	f	Sales which are qualified	0
129405_2000.0_2001-09-01	200000	\N	2001-09-01	129405	\N	\N	f	Sales which are qualified	0
129405_3200.0_2020-12-26	320000	\N	2020-12-26	129405	\N	\N	f	Qual by exam of deed	0
129411_1000.0_1997-10-01	100000	\N	1997-10-01	129411	\N	\N	f	Sales which are qualified	0
129411_1300.0_2003-02-01	130000	\N	2003-02-01	129411	\N	\N	f	Sales which are qualified	0
129411_2300.0_2004-08-01	230000	\N	2004-08-01	129411	\N	\N	f	Sales which are qualified	0
129411_3850.0_2013-04-19	385000	\N	2013-04-19	129411	\N	\N	f	Qual by exam of deed	0
129411_4750.0_2016-05-19	475000	\N	2016-05-19	129411	\N	\N	f	Qual by exam of deed	0
129413_2099.0_2002-08-01	209900	\N	2002-08-01	129413	\N	\N	f	Sales which are qualified	0
129413_3200.0_2005-09-01	320000	\N	2005-09-01	129413	\N	\N	f	Sales which are qualified	0
129414_2050.0_2002-08-01	205000	\N	2002-08-01	129414	\N	\N	f	Sales which are qualified	0
129414_3150.0_2005-06-01	315000	\N	2005-06-01	129414	\N	\N	f	Sales which are qualified	0
129414_3800.0_2018-03-16	380000	\N	2018-03-16	129414	\N	\N	f	Qual by exam of deed	0
129415_2100.0_2002-08-01	210000	\N	2002-08-01	129415	\N	\N	f	Sales which are qualified	0
129422_1476.0_2002-07-01	147600	\N	2002-07-01	129422	\N	\N	f	Sales which are qualified	0
129422_2750.0_2021-09-30	275000	\N	2021-09-30	129422	\N	\N	f	Qual by exam of deed	0
129422_844.0_1998-05-01	84400	\N	1998-05-01	129422	\N	\N	f	Sales which are qualified	0
129424_1990.0_2004-11-01	199000	\N	2004-11-01	129424	\N	\N	f	Sales which are qualified	0
129424_3400.0_2018-09-28	340000	\N	2018-09-28	129424	\N	\N	f	Qual by exam of deed	0
129424_899.0_1997-10-01	89900	\N	1997-10-01	129424	\N	\N	f	Sales which are qualified	0
129427_1800.0_2003-07-01	180000	\N	2003-07-01	129427	\N	\N	f	Sales which are qualified	0
129427_2150.0_2012-04-05	215000	\N	2012-04-05	129427	\N	\N	f	Qual by exam of deed	0
129427_3650.0_2021-06-08	365000	\N	2021-06-08	129427	\N	\N	f	Qual by exam of deed	0
129427_799.0_1997-11-01	79900	\N	1997-11-01	129427	\N	\N	f	Sales which are qualified	0
129432_1650.0_2009-06-18	165000	\N	2009-06-18	129432	\N	\N	f	Qual by exam of deed	0
129432_1750.0_2004-01-01	175000	\N	2004-01-01	129432	\N	\N	f	Sales which are qualified	0
129432_2590.0_2012-02-23	259000	\N	2012-02-23	129432	\N	\N	f	Qual by exam of deed	0
129432_5850.0_2023-01-10	585000	\N	2023-01-10	129432	\N	\N	f	Qual by exam of deed	0
129432_799.0_1998-04-01	79900	\N	1998-04-01	129432	\N	\N	f	Sales which are qualified	0
129442_2240.0_2003-01-01	224000	\N	2003-01-01	129442	\N	\N	f	Sales which are qualified	0
129442_4050.0_2005-11-01	405000	\N	2005-11-01	129442	\N	\N	f	Sales which are qualified	0
129442_4400.0_2013-10-22	440000	\N	2013-10-22	129442	\N	\N	f	Qual by exam of deed	0
129447_1680.0_1998-03-01	168000	\N	1998-03-01	129447	\N	\N	f	Sales which are qualified	0
129447_4440.0_2005-04-01	444000	\N	2005-04-01	129447	\N	\N	f	Sales which are qualified	0
129452_2973.0_2001-04-01	297300	\N	2001-04-01	129452	\N	\N	f	Sales which are qualified	0
129453_3410.0_2001-10-01	341000	\N	2001-10-01	129453	\N	\N	f	Sales which are qualified	0
129457_2700.0_2012-06-29	270000	\N	2012-06-29	129457	\N	\N	f	Qual by exam of deed	0
129457_3663.0_2006-05-01	366300	\N	2006-05-01	129457	\N	\N	f	Sales which are qualified	0
129457_4150.0_2005-02-01	415000	\N	2005-02-01	129457	\N	\N	f	Sales which are qualified	0
129457_5100.0_2006-08-01	510000	\N	2006-08-01	129457	\N	\N	f	Sales which are qualified	0
129457_6950.0_2022-03-10	695000	\N	2022-03-10	129457	\N	\N	f	Qual by exam of deed	0
129462_3270.0_2003-01-01	327000	\N	2003-01-01	129462	\N	\N	f	Sales which are qualified	0
129462_4200.0_2005-03-01	420000	\N	2005-03-01	129462	\N	\N	f	Sales which are qualified	0
129473_1942.0_1999-02-01	194200	\N	1999-02-01	129473	\N	\N	f	Sales which are qualified	0
129473_2650.0_2002-10-01	265000	\N	2002-10-01	129473	\N	\N	f	Sales which are qualified	0
129473_3700.0_2011-12-30	370000	\N	2011-12-30	129473	\N	\N	f	Qual by exam of deed	0
129473_9150.0_2021-07-30	915000	\N	2021-07-30	129473	\N	\N	f	Qual by exam of deed	0
129475_2050.0_1999-06-01	205000	\N	1999-06-01	129475	\N	\N	f	Sales which are qualified	0
129475_3450.0_2011-08-04	345000	\N	2011-08-04	129475	\N	\N	f	Qual by exam of deed	0
129475_8100.0_2018-12-10	810000	\N	2018-12-10	129475	\N	\N	f	Qual by exam of deed	0
129481_2198.0_1998-10-01	219800	\N	1998-10-01	129481	\N	\N	f	Sales which are qualified	0
129481_5300.0_2013-04-10	530000	\N	2013-04-10	129481	\N	\N	f	Qual by exam of deed	0
129483_14000.0_2022-01-10	1400000	\N	2022-01-10	129483	\N	\N	f	Qual by exam of deed	0
129483_4071.0_2003-01-01	407100	\N	2003-01-01	129483	\N	\N	f	Sales which are qualified	0
129483_6150.0_2004-10-01	615000	\N	2004-10-01	129483	\N	\N	f	Sales which are qualified	0
129483_7500.0_2016-11-04	750000	\N	2016-11-04	129483	\N	\N	f	Qual by exam of deed	0
129483_7800.0_2005-11-01	780000	\N	2005-11-01	129483	\N	\N	f	Sales which are qualified	0
129483_9000.0_2017-02-01	900000	\N	2017-02-01	129483	\N	\N	f	Qual by exam of deed	0
129483_9770.0_2014-12-05	977000	\N	2014-12-05	129483	\N	\N	f	Qual by exam of deed	0
129493_2036.0_2002-12-01	203600	\N	2002-12-01	129493	\N	\N	f	Sales which are qualified	0
129493_2200.0_2004-09-01	220000	\N	2004-09-01	129493	\N	\N	f	Sales which are qualified	0
129493_3700.0_2019-02-07	370000	\N	2019-02-07	129493	\N	\N	f	Qual by exam of deed	0
129493_6500.0_2023-03-15	650000	\N	2023-03-15	129493	\N	\N	f	Qual by exam of deed	0
129494_1300.0_1999-06-01	130000	\N	1999-06-01	129494	\N	\N	f	Sales which are qualified	0
129494_2990.0_2005-07-01	299000	\N	2005-07-01	129494	\N	\N	f	Sales which are qualified	0
129497_2450.0_2004-02-01	245000	\N	2004-02-01	129497	\N	\N	f	Sales which are qualified	0
129497_2750.0_2005-01-01	275000	\N	2005-01-01	129497	\N	\N	f	Sales which are qualified	0
129502_1830.0_2004-04-01	183000	\N	2004-04-01	129502	\N	\N	f	Sales which are qualified	0
129502_2670.0_2005-04-01	267000	\N	2005-04-01	129502	\N	\N	f	Sales which are qualified	0
129502_3100.0_2007-11-01	310000	\N	2007-11-01	129502	\N	\N	f	Sales which are qualified	0
129502_4050.0_2021-12-22	405000	\N	2021-12-22	129502	\N	\N	f	Qual by exam of deed	0
129513_1059.0_1999-07-01	105900	\N	1999-07-01	129513	\N	\N	f	Sales which are qualified	0
129514_2300.0_2005-02-01	230000	\N	2005-02-01	129514	\N	\N	f	Sales which are qualified	0
129514_2840.0_2005-05-01	284000	\N	2005-05-01	129514	\N	\N	f	Sales which are qualified	0
129514_3500.0_2021-06-22	350000	\N	2021-06-22	129514	\N	\N	f	Qual by exam of deed	0
129514_950.0_1998-02-01	95000	\N	1998-02-01	129514	\N	\N	f	Sales which are qualified	0
129515_1330.0_1999-08-01	133000	\N	1999-08-01	129515	\N	\N	f	Sales which are qualified	0
129515_2250.0_2005-01-01	225000	\N	2005-01-01	129515	\N	\N	f	Sales which are qualified	0
129515_3190.0_2005-09-01	319000	\N	2005-09-01	129515	\N	\N	f	Sales which are qualified	0
129516_1220.0_2000-01-01	122000	\N	2000-01-01	129516	\N	\N	f	Sales which are qualified	0
129516_1550.0_2011-01-28	155000	\N	2011-01-28	129516	\N	\N	f	Qual by exam of deed	0
129516_3250.0_2014-11-14	325000	\N	2014-11-14	129516	\N	\N	f	Qual by exam of deed	0
129516_4400.0_2018-09-05	440000	\N	2018-09-05	129516	\N	\N	f	Qual by exam of deed	0
129518_1358.0_1999-07-01	135800	\N	1999-07-01	129518	\N	\N	f	Sales which are qualified	0
129518_2000.0_2004-10-01	200000	\N	2004-10-01	129518	\N	\N	f	Sales which are qualified	0
129518_4700.0_2007-04-01	470000	\N	2007-04-01	129518	\N	\N	f	Sales which are qualified	0
129519_1700.0_2002-10-01	170000	\N	2002-10-01	129519	\N	\N	f	Sales which are qualified	0
129519_2100.0_2003-03-01	210000	\N	2003-03-01	129519	\N	\N	f	Sales which are qualified	0
129519_3550.0_2006-05-01	355000	\N	2006-05-01	129519	\N	\N	f	Sales which are qualified	0
129519_4850.0_2021-12-11	485000	\N	2021-12-11	129519	\N	\N	f	Qual by exam of deed	0
129522_2264.0_2004-02-01	226400	\N	2004-02-01	129522	\N	\N	f	Sales which are qualified	0
129522_3380.0_2005-09-01	338000	\N	2005-09-01	129522	\N	\N	f	Sales which are qualified	0
129522_4400.0_2020-12-21	440000	\N	2020-12-21	129522	\N	\N	f	Qual by exam of deed	0
129522_4600.0_2006-10-01	460000	\N	2006-10-01	129522	\N	\N	f	Sales which are qualified	0
129523_2200.0_2002-09-01	220000	\N	2002-09-01	129523	\N	\N	f	Sales which are qualified	0
129523_2380.0_2004-11-01	238000	\N	2004-11-01	129523	\N	\N	f	Sales which are qualified	0
129523_3700.0_2014-03-07	370000	\N	2014-03-07	129523	\N	\N	f	Qual by exam of deed	0
129532_1169.0_1998-04-01	116900	\N	1998-04-01	129532	\N	\N	f	Sales which are qualified	0
129534_2070.0_2003-07-01	207000	\N	2003-07-01	129534	\N	\N	f	Sales which are qualified	0
129534_5700.0_2022-11-18	570000	\N	2022-11-18	129534	\N	\N	f	Qual by exam of deed	0
129535_2000.0_2004-04-01	200000	\N	2004-04-01	129535	\N	\N	f	Sales which are qualified	0
129535_5090.0_2021-10-05	509000	\N	2021-10-05	129535	\N	\N	f	Qual by exam of deed	0
129536_2490.0_2003-07-01	249000	\N	2003-07-01	129536	\N	\N	f	Sales which are qualified	0
129536_4320.0_2014-12-12	432000	\N	2014-12-12	129536	\N	\N	f	Qual by exam of deed	0
129538_2630.0_2003-06-01	263000	\N	2003-06-01	129538	\N	\N	f	Sales which are qualified	0
129538_3066.0_2013-02-26	306600	\N	2013-02-26	129538	\N	\N	f	Qual by exam of deed	0
129538_3600.0_2005-08-01	360000	\N	2005-08-01	129538	\N	\N	f	Sales which are qualified	0
129538_4450.0_2014-03-05	445000	\N	2014-03-05	129538	\N	\N	f	Qual by exam of deed	0
129539_1098.33_1999-05-01	109833	\N	1999-05-01	129539	\N	\N	f	Sales which are qualified	0
129539_1650.0_2003-04-01	165000	\N	2003-04-01	129539	\N	\N	f	Sales which are qualified	0
129539_4700.0_2007-07-01	470000	\N	2007-07-01	129539	\N	\N	f	Sales which are qualified	0
129542_1149.0_1999-09-01	114900	\N	1999-09-01	129542	\N	\N	f	Sales which are qualified	0
129542_1300.0_2012-01-20	130000	\N	2012-01-20	129542	\N	\N	f	Qual by exam of deed	0
129542_1500.0_2002-10-01	150000	\N	2002-10-01	129542	\N	\N	f	Sales which are qualified	0
129542_1700.0_2009-06-04	170000	\N	2009-06-04	129542	\N	\N	f	Qual by exam of deed	0
129542_2300.0_2008-03-01	230000	\N	2008-03-01	129542	\N	\N	f	Sales which are qualified	0
129542_3450.0_2020-11-20	345000	\N	2020-11-20	129542	\N	\N	f	Qual by exam of deed	0
129542_4050.0_2014-05-15	405000	\N	2014-05-15	129542	\N	\N	f	Qual by exam of deed	0
129542_6100.0_2023-08-08	610000	\N	2023-08-08	129542	\N	\N	f	Qual by exam of deed	0
129544_1599.0_2002-03-01	159900	\N	2002-03-01	129544	\N	\N	f	Sales which are qualified	0
129544_1900.0_2003-09-01	190000	\N	2003-09-01	129544	\N	\N	f	Sales which are qualified	0
129544_4200.0_2006-06-01	420000	\N	2006-06-01	129544	\N	\N	f	Sales which are qualified	0
129544_5490.0_2006-10-01	549000	\N	2006-10-01	129544	\N	\N	f	Sales which are qualified	0
129546_1679.0_2002-06-01	167900	\N	2002-06-01	129546	\N	\N	f	Sales which are qualified	0
129546_2890.0_2005-04-01	289000	\N	2005-04-01	129546	\N	\N	f	Sales which are qualified	0
129548_1280.0_1999-07-01	128000	\N	1999-07-01	129548	\N	\N	f	Sales which are qualified	0
129548_3750.0_2013-06-28	375000	\N	2013-06-28	129548	\N	\N	f	Qual by exam of deed	0
129549_2190.0_2003-10-01	219000	\N	2003-10-01	129549	\N	\N	f	Sales which are qualified	0
129549_4100.0_2014-06-17	410000	\N	2014-06-17	129549	\N	\N	f	Qual by exam of deed	0
129551_1324.0_2002-01-01	132400	\N	2002-01-01	129551	\N	\N	f	Sales which are qualified	0
129552_1099.0_1998-10-01	109900	\N	1998-10-01	129552	\N	\N	f	Sales which are qualified	0
129552_1500.0_2002-03-01	150000	\N	2002-03-01	129552	\N	\N	f	Sales which are qualified	0
129552_1750.0_2012-02-09	175000	\N	2012-02-09	129552	\N	\N	f	Qual by exam of deed	0
129552_1970.0_2004-06-01	197000	\N	2004-06-01	129552	\N	\N	f	Sales which are qualified	0
129552_2400.0_2013-03-08	240000	\N	2013-03-08	129552	\N	\N	f	Qual by exam of deed	0
129552_2840.0_2005-05-01	284000	\N	2005-05-01	129552	\N	\N	f	Sales which are qualified	0
129552_3200.0_2013-08-22	320000	\N	2013-08-22	129552	\N	\N	f	Qual by exam of deed	0
129552_4040.0_2021-10-13	404000	\N	2021-10-13	129552	\N	\N	f	Qual by exam of deed	0
129553_1525.0_2002-10-01	152500	\N	2002-10-01	129553	\N	\N	f	Sales which are qualified	0
129553_2090.0_2012-09-05	209000	\N	2012-09-05	129553	\N	\N	f	Qual by exam of deed	0
129553_2100.0_2005-06-01	210000	\N	2005-06-01	129553	\N	\N	f	Sales which are qualified	0
129553_4800.0_2007-04-01	480000	\N	2007-04-01	129553	\N	\N	f	Sales which are qualified	0
129553_990.0_1998-09-01	99000	\N	1998-09-01	129553	\N	\N	f	Sales which are qualified	0
129560_2090.0_2003-06-01	209000	\N	2003-06-01	129560	\N	\N	f	Sales which are qualified	0
129560_4200.0_2014-12-16	420000	\N	2014-12-16	129560	\N	\N	f	Qual by exam of deed	0
129562_2000.0_2004-01-01	200000	\N	2004-01-01	129562	\N	\N	f	Sales which are qualified	0
129562_3750.0_2017-04-25	375000	\N	2017-04-25	129562	\N	\N	f	Qual by exam of deed	0
129564_1330.0_1999-06-01	133000	\N	1999-06-01	129564	\N	\N	f	Sales which are qualified	0
129564_4550.0_2013-11-14	455000	\N	2013-11-14	129564	\N	\N	f	Qual by exam of deed	0
129564_4970.0_2016-04-28	497000	\N	2016-04-28	129564	\N	\N	f	Qual by exam of deed	0
129564_8200.0_2023-02-16	820000	\N	2023-02-16	129564	\N	\N	f	Qual by exam of deed	0
129565_1219.0_1998-10-01	121900	\N	1998-10-01	129565	\N	\N	f	Sales which are qualified	0
129565_4100.0_2017-09-29	410000	\N	2017-09-29	129565	\N	\N	f	Qual by exam of deed	0
129566_1410.0_1998-11-01	141000	\N	1998-11-01	129566	\N	\N	f	Sales which are qualified	0
129569_2849.0_2001-11-01	284900	\N	2001-11-01	129569	\N	\N	f	Sales which are qualified	0
129569_2970.0_2004-09-01	297000	\N	2004-09-01	129569	\N	\N	f	Sales which are qualified	0
129569_5597.0_2007-01-01	559700	\N	2007-01-01	129569	\N	\N	f	Sales which are qualified	0
129572_2010.0_1999-11-01	201000	\N	1999-11-01	129572	\N	\N	f	Sales which are qualified	0
129573_2500.0_2002-09-01	250000	\N	2002-09-01	129573	\N	\N	f	Sales which are qualified	0
129574_3090.0_2003-01-01	309000	\N	2003-01-01	129574	\N	\N	f	Sales which are qualified	0
129574_3750.0_2012-10-05	375000	\N	2012-10-05	129574	\N	\N	f	Qual by exam of deed	0
129574_3950.0_2004-05-01	395000	\N	2004-05-01	129574	\N	\N	f	Sales which are qualified	0
129574_4750.0_2005-06-01	475000	\N	2005-06-01	129574	\N	\N	f	Sales which are qualified	0
129574_5800.0_2016-09-09	580000	\N	2016-09-09	129574	\N	\N	f	Qual by exam of deed	0
129576_2750.0_2005-02-01	275000	\N	2005-02-01	129576	\N	\N	f	Sales which are qualified	0
129576_4000.0_2016-04-06	400000	\N	2016-04-06	129576	\N	\N	f	Qual by exam of deed	0
129577_1294.0_1999-04-01	129400	\N	1999-04-01	129577	\N	\N	f	Sales which are qualified	0
129577_2550.0_2003-10-01	255000	\N	2003-10-01	129577	\N	\N	f	Sales which are qualified	0
129577_3940.0_2007-02-01	394000	\N	2007-02-01	129577	\N	\N	f	Sales which are qualified	0
129577_7375.0_2022-03-10	737500	\N	2022-03-10	129577	\N	\N	f	Qual by exam of deed	0
129578_1380.0_1999-06-01	138000	\N	1999-06-01	129578	\N	\N	f	Sales which are qualified	0
129578_2300.0_2002-11-01	230000	\N	2002-11-01	129578	\N	\N	f	Sales which are qualified	0
129578_4310.0_2018-03-20	431000	\N	2018-03-20	129578	\N	\N	f	Qual by exam of deed	0
129582_5050.0_2018-10-29	505000	\N	2018-10-29	129582	\N	\N	f	Qual by exam of deed	0
129591_799.0_1997-09-01	79900	\N	1997-09-01	129591	\N	\N	f	Sales which are qualified	0
129593_2140.0_2004-03-01	214000	\N	2004-03-01	129593	\N	\N	f	Sales which are qualified	0
129593_4100.0_2006-09-01	410000	\N	2006-09-01	129593	\N	\N	f	Sales which are qualified	0
129594_1650.0_2003-10-01	165000	\N	2003-10-01	129594	\N	\N	f	Sales which are qualified	0
129594_4000.0_2015-03-17	400000	\N	2015-03-17	129594	\N	\N	f	Qual by exam of deed	0
129596_1729.0_2001-01-01	172900	\N	2001-01-01	129596	\N	\N	f	Sales which are qualified	0
129597_1840.0_2011-10-31	184000	\N	2011-10-31	129597	\N	\N	f	Qual by exam of deed	0
129597_2100.0_2003-03-01	210000	\N	2003-03-01	129597	\N	\N	f	Sales which are qualified	0
129597_5990.0_2022-07-29	599000	\N	2022-07-29	129597	\N	\N	f	Qual by exam of deed	0
129599_1700.0_2011-02-25	170000	\N	2011-02-25	129599	\N	\N	f	Qual by exam of deed	0
129599_1999.0_2003-11-01	199900	\N	2003-11-01	129599	\N	\N	f	Sales which are qualified	0
129605_1149.0_1999-06-01	114900	\N	1999-06-01	129605	\N	\N	f	Sales which are qualified	0
129605_1750.0_2003-12-01	175000	\N	2003-12-01	129605	\N	\N	f	Sales which are qualified	0
129605_2600.0_2013-04-09	260000	\N	2013-04-09	129605	\N	\N	f	Qual by exam of deed	0
129605_3850.0_2015-06-12	385000	\N	2015-06-12	129605	\N	\N	f	Qual by exam of deed	0
129606_1209.0_1999-11-01	120900	\N	1999-11-01	129606	\N	\N	f	Sales which are qualified	0
129607_1880.0_2004-01-01	188000	\N	2004-01-01	129607	\N	\N	f	Sales which are qualified	0
129607_4050.0_2006-10-01	405000	\N	2006-10-01	129607	\N	\N	f	Sales which are qualified	0
129607_4100.0_2015-08-24	410000	\N	2015-08-24	129607	\N	\N	f	Qual by exam of deed	0
129608_1239.0_1999-01-01	123900	\N	1999-01-01	129608	\N	\N	f	Sales which are qualified	0
129608_1950.0_2004-08-01	195000	\N	2004-08-01	129608	\N	\N	f	Sales which are qualified	0
129608_2050.0_2012-04-13	205000	\N	2012-04-13	129608	\N	\N	f	Qual by exam of deed	0
129608_3570.0_2006-11-01	357000	\N	2006-11-01	129608	\N	\N	f	Sales which are qualified	0
129609_1781.0_2001-05-01	178100	\N	2001-05-01	129609	\N	\N	f	Sales which are qualified	0
129609_2350.0_2005-03-01	235000	\N	2005-03-01	129609	\N	\N	f	Sales which are qualified	0
129609_4550.0_2014-12-23	455000	\N	2014-12-23	129609	\N	\N	f	Qual by exam of deed	0
129610_1620.0_2002-09-01	162000	\N	2002-09-01	129610	\N	\N	f	Sales which are qualified	0
129610_2300.0_2004-05-01	230000	\N	2004-05-01	129610	\N	\N	f	Sales which are qualified	0
129612_5560.0_2005-11-01	556000	\N	2005-11-01	129612	\N	\N	f	Sales which are qualified	0
129613_2690.0_2004-10-01	269000	\N	2004-10-01	129613	\N	\N	f	Sales which are qualified	0
129613_4650.0_2013-12-13	465000	\N	2013-12-13	129613	\N	\N	f	Qual by exam of deed	0
129617_1430.0_1999-08-01	143000	\N	1999-08-01	129617	\N	\N	f	Sales which are qualified	0
129617_2311.0_2005-04-01	231100	\N	2005-04-01	129617	\N	\N	f	Sales which are qualified	0
129617_3750.0_2005-09-01	375000	\N	2005-09-01	129617	\N	\N	f	Sales which are qualified	0
129617_3890.0_2013-02-15	389000	\N	2013-02-15	129617	\N	\N	f	Qual by exam of deed	0
129617_3900.0_2003-09-01	390000	\N	2003-09-01	129617	\N	\N	f	Sales which are qualified	0
129618_1440.0_1999-04-01	144000	\N	1999-04-01	129618	\N	\N	f	Sales which are qualified	0
129618_2050.0_2002-07-01	205000	\N	2002-07-01	129618	\N	\N	f	Sales which are qualified	0
129618_2525.0_2011-05-09	252500	\N	2011-05-09	129618	\N	\N	f	Qual by exam of deed	0
129618_3130.0_2003-12-01	313000	\N	2003-12-01	129618	\N	\N	f	Sales which are qualified	0
129618_4400.0_2005-04-01	440000	\N	2005-04-01	129618	\N	\N	f	Sales which are qualified	0
129618_4880.0_2005-08-01	488000	\N	2005-08-01	129618	\N	\N	f	Sales which are qualified	0
129619_2509.0_2003-10-01	250900	\N	2003-10-01	129619	\N	\N	f	Sales which are qualified	0
129619_5650.0_2006-10-01	565000	\N	2006-10-01	129619	\N	\N	f	Sales which are qualified	0
129619_8990.0_2022-03-30	899000	\N	2022-03-30	129619	\N	\N	f	Qual by exam of deed	0
129621_2500.0_2003-10-01	250000	\N	2003-10-01	129621	\N	\N	f	Sales which are qualified	0
129621_3250.0_2004-10-01	325000	\N	2004-10-01	129621	\N	\N	f	Sales which are qualified	0
129621_5000.0_2007-01-01	500000	\N	2007-01-01	129621	\N	\N	f	Sales which are qualified	0
129621_9500.0_2016-05-27	950000	\N	2016-05-27	129621	\N	\N	f	Qual by exam of deed	0
129623_1815.0_1999-08-01	181500	\N	1999-08-01	129623	\N	\N	f	Sales which are qualified	0
129623_3500.0_2005-04-01	350000	\N	2005-04-01	129623	\N	\N	f	Sales which are qualified	0
129624_1679.0_1998-04-01	167900	\N	1998-04-01	129624	\N	\N	f	Sales which are qualified	0
129624_2600.0_2003-06-01	260000	\N	2003-06-01	129624	\N	\N	f	Sales which are qualified	0
129624_2850.0_2009-06-05	285000	\N	2009-06-05	129624	\N	\N	f	Qual by exam of deed	0
129624_3445.0_2005-02-01	344500	\N	2005-02-01	129624	\N	\N	f	Sales which are qualified	0
129630_15500.0_2022-05-19	1550000	\N	2022-05-19	129630	\N	\N	f	Qual by exam of deed	0
129630_4050.0_2012-07-27	405000	\N	2012-07-27	129630	\N	\N	f	Qual by exam of deed	0
129630_7500.0_2014-06-18	750000	\N	2014-06-18	129630	\N	\N	f	Qual by exam of deed	0
129637_3025.8_2010-03-30	302580	\N	2010-03-30	129637	\N	\N	f	Qual by exam of deed	0
129637_3106.0_2000-12-01	310600	\N	2000-12-01	129637	\N	\N	f	Sales which are qualified	0
129638_14000.0_2022-01-11	1400000	\N	2022-01-11	129638	\N	\N	f	Qual by exam of deed	0
129638_3500.0_2012-03-05	350000	\N	2012-03-05	129638	\N	\N	f	Qual by exam of deed	0
129638_4369.0_2001-08-01	436900	\N	2001-08-01	129638	\N	\N	f	Sales which are qualified	0
129638_4369.0_2001-11-01	436900	\N	2001-11-01	129638	\N	\N	f	Sales which are qualified	0
129638_6700.0_2005-11-01	670000	\N	2005-11-01	129638	\N	\N	f	Sales which are qualified	0
129639_5250.0_2002-04-01	525000	\N	2002-04-01	129639	\N	\N	f	Sales which are qualified	0
129640_2346.0_2000-09-01	234600	\N	2000-09-01	129640	\N	\N	f	Sales which are qualified	0
129640_3610.0_2011-07-29	361000	\N	2011-07-29	129640	\N	\N	f	Qual by exam of deed	0
129640_4600.0_2013-02-11	460000	\N	2013-02-11	129640	\N	\N	f	Qual by exam of deed	0
129642_3150.0_2003-08-01	315000	\N	2003-08-01	129642	\N	\N	f	Sales which are qualified	0
129642_3800.0_2004-12-01	380000	\N	2004-12-01	129642	\N	\N	f	Sales which are qualified	0
129642_9500.0_2017-09-20	950000	\N	2017-09-20	129642	\N	\N	f	Qual by exam of deed	0
129648_3060.0_2000-09-01	306000	\N	2000-09-01	129648	\N	\N	f	Sales which are qualified	0
129649_3800.0_2010-05-10	380000	\N	2010-05-10	129649	\N	\N	f	Qual by exam of deed	0
129649_7200.0_2017-06-08	720000	\N	2017-06-08	129649	\N	\N	f	Qual by exam of deed	0
129650_4200.0_2004-07-01	420000	\N	2004-07-01	129650	\N	\N	f	Sales which are qualified	0
129650_6674.0_2006-02-01	667400	\N	2006-02-01	129650	\N	\N	f	Sales which are qualified	0
129652_2429.0_2000-12-01	242900	\N	2000-12-01	129652	\N	\N	f	Sales which are qualified	0
129652_5500.0_2013-09-13	550000	\N	2013-09-13	129652	\N	\N	f	Qual by exam of deed	0
129656_1650.0_1998-04-01	165000	\N	1998-04-01	129656	\N	\N	f	Sales which are qualified	0
129656_3150.0_2001-07-01	315000	\N	2001-07-01	129656	\N	\N	f	Sales which are qualified	0
129659_10800.0_2022-01-05	1080000	\N	2022-01-05	129659	\N	\N	f	Qual by exam of deed	0
129659_3330.0_2002-08-01	333000	\N	2002-08-01	129659	\N	\N	f	Sales which are qualified	0
129659_4500.0_2005-06-01	450000	\N	2005-06-01	129659	\N	\N	f	Sales which are qualified	0
129664_5000.0_2002-08-01	500000	\N	2002-08-01	129664	\N	\N	f	Sales which are qualified	0
129669_1139.0_1998-02-01	113900	\N	1998-02-01	129669	\N	\N	f	Sales which are qualified	0
129669_2220.0_2003-03-01	222000	\N	2003-03-01	129669	\N	\N	f	Sales which are qualified	0
129669_7600.0_2022-03-09	760000	\N	2022-03-09	129669	\N	\N	f	Qual by exam of deed	0
129671_1019.0_1998-07-01	101900	\N	1998-07-01	129671	\N	\N	f	Sales which are qualified	0
129671_2600.0_2004-07-01	260000	\N	2004-07-01	129671	\N	\N	f	Sales which are qualified	0
129671_5500.0_2016-12-20	550000	\N	2016-12-20	129671	\N	\N	f	Qual by exam of deed	0
129674_2160.0_2002-09-01	216000	\N	2002-09-01	129674	\N	\N	f	Sales which are qualified	0
129674_2690.0_2004-08-01	269000	\N	2004-08-01	129674	\N	\N	f	Sales which are qualified	0
129676_1379.0_1997-12-01	137900	\N	1997-12-01	129676	\N	\N	f	Sales which are qualified	0
129678_1185.0_1999-09-01	118500	\N	1999-09-01	129678	\N	\N	f	Sales which are qualified	0
129678_1870.0_2011-03-04	187000	\N	2011-03-04	129678	\N	\N	f	Qual by exam of deed	0
129678_1925.0_2004-04-01	192500	\N	2004-04-01	129678	\N	\N	f	Sales which are qualified	0
129678_2200.0_2009-03-17	220000	\N	2009-03-17	129678	\N	\N	f	Qual by exam of deed	0
129678_2350.0_2008-04-01	235000	\N	2008-04-01	129678	\N	\N	f	Sales which are qualified	0
129678_4450.0_2018-11-28	445000	\N	2018-11-28	129678	\N	\N	f	Qual by exam of deed	0
129678_899.0_1998-01-01	89900	\N	1998-01-01	129678	\N	\N	f	Sales which are qualified	0
129680_1690.0_2009-12-10	169000	\N	2009-12-10	129680	\N	\N	f	Qual by exam of deed	0
129680_2650.0_2003-09-01	265000	\N	2003-09-01	129680	\N	\N	f	Sales which are qualified	0
129680_2990.0_2005-02-01	299000	\N	2005-02-01	129680	\N	\N	f	Sales which are qualified	0
129680_3950.0_2018-04-10	395000	\N	2018-04-10	129680	\N	\N	f	Qual by exam of deed	0
129681_1731.0_2002-08-01	173100	\N	2002-08-01	129681	\N	\N	f	Sales which are qualified	0
129681_3500.0_2007-05-01	350000	\N	2007-05-01	129681	\N	\N	f	Sales which are qualified	0
129681_4300.0_2018-04-24	430000	\N	2018-04-24	129681	\N	\N	f	Qual by exam of deed	0
129681_5600.0_2022-10-09	560000	\N	2022-10-09	129681	\N	\N	f	Qual by exam of deed	0
129682_1259.0_1997-09-01	125900	\N	1997-09-01	129682	\N	\N	f	Sales which are qualified	0
129682_2235.0_2004-10-01	223500	\N	2004-10-01	129682	\N	\N	f	Sales which are qualified	0
129682_4950.0_2021-10-18	495000	\N	2021-10-18	129682	\N	\N	f	Qual by exam of deed	0
129685_1950.0_2002-08-01	195000	\N	2002-08-01	129685	\N	\N	f	Sales which are qualified	0
129687_2360.0_2003-09-01	236000	\N	2003-09-01	129687	\N	\N	f	Sales which are qualified	0
129687_3500.0_2013-06-17	350000	\N	2013-06-17	129687	\N	\N	f	Qual by exam of deed	0
129688_2650.0_2002-11-01	265000	\N	2002-11-01	129688	\N	\N	f	Sales which are qualified	0
129691_1650.0_2002-02-01	165000	\N	2002-02-01	129691	\N	\N	f	Sales which are qualified	0
129691_2035.0_2004-02-01	203500	\N	2004-02-01	129691	\N	\N	f	Sales which are qualified	0
129691_4250.0_2018-11-26	425000	\N	2018-11-26	129691	\N	\N	f	Qual by exam of deed	0
129692_1450.0_2002-10-01	145000	\N	2002-10-01	129692	\N	\N	f	Sales which are qualified	0
129692_2800.0_2005-01-01	280000	\N	2005-01-01	129692	\N	\N	f	Sales which are qualified	0
129692_3750.0_2006-05-01	375000	\N	2006-05-01	129692	\N	\N	f	Sales which are qualified	0
129692_750.0_1998-02-01	75000	\N	1998-02-01	129692	\N	\N	f	Sales which are qualified	0
129693_3200.0_2013-08-09	320000	\N	2013-08-09	129693	\N	\N	f	Qual by exam of deed	0
129693_3710.0_2006-06-01	371000	\N	2006-06-01	129693	\N	\N	f	Sales which are qualified	0
129693_4650.0_2007-01-01	465000	\N	2007-01-01	129693	\N	\N	f	Sales which are qualified	0
129693_5000.0_2020-07-15	500000	\N	2020-07-15	129693	\N	\N	f	Qual by exam of deed	0
129696_2225.0_2011-12-02	222500	\N	2011-12-02	129696	\N	\N	f	Qual by exam of deed	0
129696_3720.0_2016-11-23	372000	\N	2016-11-23	129696	\N	\N	f	Qual by exam of deed	0
129696_4100.0_2006-08-01	410000	\N	2006-08-01	129696	\N	\N	f	Sales which are qualified	0
129696_749.0_1997-09-01	74900	\N	1997-09-01	129696	\N	\N	f	Sales which are qualified	0
129699_1810.0_2003-09-01	181000	\N	2003-09-01	129699	\N	\N	f	Sales which are qualified	0
129699_2290.0_2004-12-01	229000	\N	2004-12-01	129699	\N	\N	f	Sales which are qualified	0
129701_1700.0_2002-04-01	170000	\N	2002-04-01	129701	\N	\N	f	Sales which are qualified	0
129701_2300.0_2004-07-01	230000	\N	2004-07-01	129701	\N	\N	f	Sales which are qualified	0
129701_799.0_1998-06-01	79900	\N	1998-06-01	129701	\N	\N	f	Sales which are qualified	0
130213_1840.0_2012-11-13	184000	\N	2012-11-13	130213	\N	\N	f	Qual by exam of deed	0
130213_2085.0_2021-07-09	208500	\N	2021-07-09	130213	\N	\N	f	Qual by exam of deed	0
130213_518.0_1998-01-01	51800	\N	1998-01-01	130213	\N	\N	f	Sales which are qualified	0
130213_599.0_1993-04-01	59900	\N	1993-04-01	130213	\N	\N	f	Sales which are qualified	0
130214_1180.0_2003-05-01	118000	\N	2003-05-01	130214	\N	\N	f	Sales which are qualified	0
130214_599.0_1993-04-01	59900	\N	1993-04-01	130214	\N	\N	f	Sales which are qualified	0
130215_1350.0_2003-07-01	135000	\N	2003-07-01	130215	\N	\N	f	Sales which are qualified	0
130215_2550.0_2018-05-09	255000	\N	2018-05-09	130215	\N	\N	f	Qual by exam of deed	0
130215_3060.0_2007-10-01	306000	\N	2007-10-01	130215	\N	\N	f	Sales which are qualified	0
130215_585.0_1993-08-01	58500	\N	1993-08-01	130215	\N	\N	f	Sales which are qualified	0
130220_1550.0_2004-02-01	155000	\N	2004-02-01	130220	\N	\N	f	Sales which are qualified	0
130220_2200.0_2018-12-05	220000	\N	2018-12-05	130220	\N	\N	f	Qual by exam of deed	0
130220_2980.0_2023-05-17	298000	\N	2023-05-17	130220	\N	\N	f	Qual by exam of deed	0
130220_650.0_1993-08-01	65000	\N	1993-08-01	130220	\N	\N	f	Sales which are qualified	0
130220_730.0_1998-09-01	73000	\N	1998-09-01	130220	\N	\N	f	Sales which are qualified	0
130222_1425.0_2009-05-01	142500	\N	2009-05-01	130222	\N	\N	f	Qual by exam of deed	0
130222_2750.0_2014-06-11	275000	\N	2014-06-11	130222	\N	\N	f	Qual by exam of deed	0
130222_2775.0_2005-08-01	277500	\N	2005-08-01	130222	\N	\N	f	Sales which are qualified	0
130222_650.0_1993-08-01	65000	\N	1993-08-01	130222	\N	\N	f	Sales which are qualified	0
130223_1100.0_2002-12-01	110000	\N	2002-12-01	130223	\N	\N	f	Sales which are qualified	0
130223_2000.0_2012-05-22	200000	\N	2012-05-22	130223	\N	\N	f	Qual by exam of deed	0
130223_2750.0_2023-03-07	275000	\N	2023-03-07	130223	\N	\N	f	Qual by exam of deed	0
130223_2940.0_2006-05-01	294000	\N	2006-05-01	130223	\N	\N	f	Sales which are qualified	0
130223_3000.0_2014-06-22	300000	\N	2014-06-22	130223	\N	\N	f	Qual by exam of deed	0
130223_650.0_1998-09-01	65000	\N	1998-09-01	130223	\N	\N	f	Sales which are qualified	0
130223_720.0_1993-09-01	72000	\N	1993-09-01	130223	\N	\N	f	Sales which are qualified	0
130224_1500.0_2004-01-01	150000	\N	2004-01-01	130224	\N	\N	f	Sales which are qualified	0
130224_670.0_1993-07-01	67000	\N	1993-07-01	130224	\N	\N	f	Sales which are qualified	0
130228_1000.0_1993-09-01	100000	\N	1993-09-01	130228	\N	\N	f	Sales which are qualified	0
130229_1010.0_1993-08-01	101000	\N	1993-08-01	130229	\N	\N	f	Sales which are qualified	0
130229_3400.0_2011-09-12	340000	\N	2011-09-12	130229	\N	\N	f	Qual by exam of deed	0
130230_1030.0_1993-07-01	103000	\N	1993-07-01	130230	\N	\N	f	Sales which are qualified	0
130230_1130.0_1996-11-01	113000	\N	1996-11-01	130230	\N	\N	f	Sales which are qualified	0
130230_2650.0_2004-01-01	265000	\N	2004-01-01	130230	\N	\N	f	Sales which are qualified	0
130230_4150.0_2005-06-01	415000	\N	2005-06-01	130230	\N	\N	f	Sales which are qualified	0
130230_5200.0_2014-08-19	520000	\N	2014-08-19	130230	\N	\N	f	Qual by exam of deed	0
130232_1200.0_1993-07-01	120000	\N	1993-07-01	130232	\N	\N	f	Sales which are qualified	0
130237_1210.0_1993-08-01	121000	\N	1993-08-01	130237	\N	\N	f	Sales which are qualified	0
130237_1350.0_1995-05-01	135000	\N	1995-05-01	130237	\N	\N	f	Sales which are qualified	0
130237_2800.0_2003-03-01	280000	\N	2003-03-01	130237	\N	\N	f	Sales which are qualified	0
130243_1500.0_2003-12-01	150000	\N	2003-12-01	130243	\N	\N	f	Sales which are qualified	0
130243_2500.0_2005-12-01	250000	\N	2005-12-01	130243	\N	\N	f	Sales which are qualified	0
130243_650.0_1993-06-01	65000	\N	1993-06-01	130243	\N	\N	f	Sales which are qualified	0
130245_720.0_1993-06-01	72000	\N	1993-06-01	130245	\N	\N	f	Sales which are qualified	0
130245_780.0_1995-06-01	78000	\N	1995-06-01	130245	\N	\N	f	Sales which are qualified	0
130245_900.0_1999-11-01	90000	\N	1999-11-01	130245	\N	\N	f	Sales which are qualified	0
130247_1770.0_2004-02-01	177000	\N	2004-02-01	130247	\N	\N	f	Sales which are qualified	0
130247_2700.0_2013-10-23	270000	\N	2013-10-23	130247	\N	\N	f	Qual by exam of deed	0
130247_715.0_1993-06-01	71500	\N	1993-06-01	130247	\N	\N	f	Sales which are qualified	0
130251_2500.0_2022-02-22	250000	\N	2022-02-22	130251	\N	\N	f	Qual by exam of deed	0
130251_770.0_1997-11-01	77000	\N	1997-11-01	130251	\N	\N	f	Sales which are qualified	0
130251_849.0_1993-07-01	84900	\N	1993-07-01	130251	\N	\N	f	Sales which are qualified	0
130252_2500.0_2019-09-12	250000	\N	2019-09-12	130252	\N	\N	f	Qual by exam of deed	0
130252_750.0_1994-08-01	75000	\N	1994-08-01	130252	\N	\N	f	Sales which are qualified	0
130254_2050.0_2004-04-01	205000	\N	2004-04-01	130254	\N	\N	f	Sales which are qualified	0
130254_3300.0_2018-04-20	330000	\N	2018-04-20	130254	\N	\N	f	Qual by exam of deed	0
130254_3525.0_2023-06-06	352500	\N	2023-06-06	130254	\N	\N	f	Qual by exam of deed	0
130254_650.0_1993-04-01	65000	\N	1993-04-01	130254	\N	\N	f	Sales which are qualified	0
130254_875.0_1999-12-01	87500	\N	1999-12-01	130254	\N	\N	f	Sales which are qualified	0
130255_2010.0_2011-03-07	201000	\N	2011-03-07	130255	\N	\N	f	Qual by exam of deed	0
130255_3250.0_2022-08-14	325000	\N	2022-08-14	130255	\N	\N	f	Qual by exam of deed	0
130255_639.0_1993-01-01	63900	\N	1993-01-01	130255	\N	\N	f	Sales which are qualified	0
130255_730.0_1998-07-01	73000	\N	1998-07-01	130255	\N	\N	f	Sales which are qualified	0
130258_1750.0_2002-12-01	175000	\N	2002-12-01	130258	\N	\N	f	Sales which are qualified	0
130258_2550.0_2020-06-18	255000	\N	2020-06-18	130258	\N	\N	f	Qual by exam of deed	0
130258_2750.0_2004-12-01	275000	\N	2004-12-01	130258	\N	\N	f	Sales which are qualified	0
130258_715.0_1993-03-01	71500	\N	1993-03-01	130258	\N	\N	f	Sales which are qualified	0
130258_800.0_1996-03-01	80000	\N	1996-03-01	130258	\N	\N	f	Sales which are qualified	0
130259_1240.0_1999-12-01	124000	\N	1999-12-01	130259	\N	\N	f	Sales which are qualified	0
130259_1419.6_2004-04-01	141960	\N	2004-04-01	130259	\N	\N	f	Sales which are qualified	0
130259_1450.0_2000-11-01	145000	\N	2000-11-01	130259	\N	\N	f	Sales which are qualified	0
130259_3600.0_2022-12-07	360000	\N	2022-12-07	130259	\N	\N	f	Qual by exam of deed	0
130259_840.0_1993-07-01	84000	\N	1993-07-01	130259	\N	\N	f	Sales which are qualified	0
130264_1050.0_1998-10-01	105000	\N	1998-10-01	130264	\N	\N	f	Sales which are qualified	0
130264_921.82_1991-05-01	92182	\N	1991-05-01	130264	\N	\N	f	Sales which are qualified	0
130265_1030.0_2001-09-01	103000	\N	2001-09-01	130265	\N	\N	f	Sales which are qualified	0
130265_1030.0_2002-06-01	103000	\N	2002-06-01	130265	\N	\N	f	Sales which are qualified	0
130265_2300.0_2008-03-01	230000	\N	2008-03-01	130265	\N	\N	f	Sales which are qualified	0
130265_2500.0_2014-07-28	250000	\N	2014-07-28	130265	\N	\N	f	Qual by exam of deed	0
130265_2650.0_2017-06-29	265000	\N	2017-06-29	130265	\N	\N	f	Qual by exam of deed	0
130265_599.0_1993-08-01	59900	\N	1993-08-01	130265	\N	\N	f	Sales which are qualified	0
130266_1750.0_2012-09-13	175000	\N	2012-09-13	130266	\N	\N	f	Qual by exam of deed	0
130266_2250.0_2014-08-27	225000	\N	2014-08-27	130266	\N	\N	f	Qual by exam of deed	0
130266_599.0_1993-02-01	59900	\N	1993-02-01	130266	\N	\N	f	Sales which are qualified	0
130268_1650.0_2012-08-10	165000	\N	2012-08-10	130268	\N	\N	f	Qual by exam of deed	0
130268_2200.0_2014-04-03	220000	\N	2014-04-03	130268	\N	\N	f	Qual by exam of deed	0
130268_599.0_1993-02-01	59900	\N	1993-02-01	130268	\N	\N	f	Sales which are qualified	0
130269_599.0_1993-07-01	59900	\N	1993-07-01	130269	\N	\N	f	Sales which are qualified	0
130271_599.0_1993-06-01	59900	\N	1993-06-01	130271	\N	\N	f	Sales which are qualified	0
130271_660.0_1997-05-01	66000	\N	1997-05-01	130271	\N	\N	f	Sales which are qualified	0
130274_1750.0_2004-03-01	175000	\N	2004-03-01	130274	\N	\N	f	Sales which are qualified	0
130274_1875.0_2013-01-18	187500	\N	2013-01-18	130274	\N	\N	f	Qual by exam of deed	0
130274_3100.0_2022-08-29	310000	\N	2022-08-29	130274	\N	\N	f	Qual by exam of deed	0
130274_665.0_1993-07-01	66500	\N	1993-07-01	130274	\N	\N	f	Sales which are qualified	0
130274_825.0_1999-09-01	82500	\N	1999-09-01	130274	\N	\N	f	Sales which are qualified	0
130275_1100.0_2001-12-01	110000	\N	2001-12-01	130275	\N	\N	f	Sales which are qualified	0
130275_1250.0_2003-05-01	125000	\N	2003-05-01	130275	\N	\N	f	Sales which are qualified	0
130275_1800.0_2009-04-17	180000	\N	2009-04-17	130275	\N	\N	f	Qual by exam of deed	0
130275_2365.0_2005-04-01	236500	\N	2005-04-01	130275	\N	\N	f	Sales which are qualified	0
130275_2820.0_2014-03-17	282000	\N	2014-03-17	130275	\N	\N	f	Qual by exam of deed	0
130275_699.0_1993-07-01	69900	\N	1993-07-01	130275	\N	\N	f	Sales which are qualified	0
130278_1800.0_2012-09-13	180000	\N	2012-09-13	130278	\N	\N	f	Qual by exam of deed	0
130278_2225.0_2021-01-21	222500	\N	2021-01-21	130278	\N	\N	f	Qual by exam of deed	0
130278_599.0_1993-02-01	59900	\N	1993-02-01	130278	\N	\N	f	Sales which are qualified	0
130279_2080.0_2013-06-12	208000	\N	2013-06-12	130279	\N	\N	f	Qual by exam of deed	0
130279_2350.0_2004-12-01	235000	\N	2004-12-01	130279	\N	\N	f	Sales which are qualified	0
130279_3130.0_2005-08-01	313000	\N	2005-08-01	130279	\N	\N	f	Sales which are qualified	0
130279_567.0_1993-01-01	56700	\N	1993-01-01	130279	\N	\N	f	Sales which are qualified	0
130279_820.0_1994-12-01	82000	\N	1994-12-01	130279	\N	\N	f	Sales which are qualified	0
130279_950.0_2001-03-01	95000	\N	2001-03-01	130279	\N	\N	f	Sales which are qualified	0
130280_1750.0_2004-07-01	175000	\N	2004-07-01	130280	\N	\N	f	Sales which are qualified	0
130280_3270.0_2016-05-31	327000	\N	2016-05-31	130280	\N	\N	f	Qual by exam of deed	0
130280_594.0_1993-04-01	59400	\N	1993-04-01	130280	\N	\N	f	Sales which are qualified	0
130281_2900.0_2005-09-01	290000	\N	2005-09-01	130281	\N	\N	f	Sales which are qualified	0
130281_599.0_1993-03-01	59900	\N	1993-03-01	130281	\N	\N	f	Sales which are qualified	0
130281_850.0_1995-04-01	85000	\N	1995-04-01	130281	\N	\N	f	Sales which are qualified	0
130284_1550.0_2012-09-07	155000	\N	2012-09-07	130284	\N	\N	f	Qual by exam of deed	0
130284_2080.0_2012-12-04	208000	\N	2012-12-04	130284	\N	\N	f	Qual by exam of deed	0
130284_2180.0_2004-10-01	218000	\N	2004-10-01	130284	\N	\N	f	Sales which are qualified	0
130284_2600.0_2005-04-01	260000	\N	2005-04-01	130284	\N	\N	f	Sales which are qualified	0
130284_3050.0_2007-07-01	305000	\N	2007-07-01	130284	\N	\N	f	Sales which are qualified	0
130284_599.0_1993-04-01	59900	\N	1993-04-01	130284	\N	\N	f	Sales which are qualified	0
130285_702.0_1993-06-01	70200	\N	1993-06-01	130285	\N	\N	f	Sales which are qualified	0
130287_1820.0_2010-05-14	182000	\N	2010-05-14	130287	\N	\N	f	Qual by exam of deed	0
130287_2700.0_2005-04-01	270000	\N	2005-04-01	130287	\N	\N	f	Sales which are qualified	0
130287_670.0_1993-04-01	67000	\N	1993-04-01	130287	\N	\N	f	Sales which are qualified	0
130289_2060.0_2004-09-01	206000	\N	2004-09-01	130289	\N	\N	f	Sales which are qualified	0
130289_700.0_1996-12-01	70000	\N	1996-12-01	130289	\N	\N	f	Sales which are qualified	0
130289_750.0_1993-06-01	75000	\N	1993-06-01	130289	\N	\N	f	Sales which are qualified	0
130292_1350.0_2003-11-01	135000	\N	2003-11-01	130292	\N	\N	f	Sales which are qualified	0
130292_1850.0_2012-12-10	185000	\N	2012-12-10	130292	\N	\N	f	Qual by exam of deed	0
130292_2102.0_2023-04-11	210200	\N	2023-04-11	130292	\N	\N	f	Qual by exam of deed	0
130292_609.0_1993-04-01	60900	\N	1993-04-01	130292	\N	\N	f	Sales which are qualified	0
130294_649.0_1993-07-01	64900	\N	1993-07-01	130294	\N	\N	f	Sales which are qualified	0
130295_1000.0_1994-09-01	100000	\N	1994-09-01	130295	\N	\N	f	Sales which are qualified	0
130295_650.0_1993-07-01	65000	\N	1993-07-01	130295	\N	\N	f	Sales which are qualified	0
130297_1900.0_2004-09-01	190000	\N	2004-09-01	130297	\N	\N	f	Sales which are qualified	0
130297_699.0_1993-07-01	69900	\N	1993-07-01	130297	\N	\N	f	Sales which are qualified	0
130300_2300.0_2004-10-01	230000	\N	2004-10-01	130300	\N	\N	f	Sales which are qualified	0
130300_805.0_1993-05-01	80500	\N	1993-05-01	130300	\N	\N	f	Sales which are qualified	0
130301_1215.0_2000-11-01	121500	\N	2000-11-01	130301	\N	\N	f	Sales which are qualified	0
130301_1625.0_2009-07-06	162500	\N	2009-07-06	130301	\N	\N	f	Qual by exam of deed	0
130301_780.0_1998-01-01	78000	\N	1998-01-01	130301	\N	\N	f	Sales which are qualified	0
130301_870.0_1993-07-01	87000	\N	1993-07-01	130301	\N	\N	f	Sales which are qualified	0
130304_977.0_1993-08-01	97700	\N	1993-08-01	130304	\N	\N	f	Sales which are qualified	0
130305_1005.0_1993-08-01	100500	\N	1993-08-01	130305	\N	\N	f	Sales which are qualified	0
130305_1010.0_1997-06-01	101000	\N	1997-06-01	130305	\N	\N	f	Sales which are qualified	0
130305_1450.0_2000-08-01	145000	\N	2000-08-01	130305	\N	\N	f	Sales which are qualified	0
130305_2400.0_2009-12-14	240000	\N	2009-12-14	130305	\N	\N	f	Qual by exam of deed	0
130305_3750.0_2021-04-20	375000	\N	2021-04-20	130305	\N	\N	f	Qual by exam of deed	0
130306_1030.0_1993-07-01	103000	\N	1993-07-01	130306	\N	\N	f	Sales which are qualified	0
130306_1250.0_1995-10-01	125000	\N	1995-10-01	130306	\N	\N	f	Sales which are qualified	0
130306_1295.0_1999-07-01	129500	\N	1999-07-01	130306	\N	\N	f	Sales which are qualified	0
130306_3000.0_2003-11-01	300000	\N	2003-11-01	130306	\N	\N	f	Sales which are qualified	0
130306_4400.0_2022-06-10	440000	\N	2022-06-10	130306	\N	\N	f	Qual by exam of deed	0
130308_1029.0_1992-12-01	102900	\N	1992-12-01	130308	\N	\N	f	Sales which are qualified	0
130308_1290.0_1997-03-01	129000	\N	1997-03-01	130308	\N	\N	f	Sales which are qualified	0
130308_5450.0_2018-06-15	545000	\N	2018-06-15	130308	\N	\N	f	Qual by exam of deed	0
130309_1050.0_1996-05-01	105000	\N	1996-05-01	130309	\N	\N	f	Sales which are qualified	0
130309_1130.0_1993-05-01	113000	\N	1993-05-01	130309	\N	\N	f	Sales which are qualified	0
130309_3500.0_2004-10-01	350000	\N	2004-10-01	130309	\N	\N	f	Sales which are qualified	0
130309_4800.0_2022-09-15	480000	\N	2022-09-15	130309	\N	\N	f	Qual by exam of deed	0
130310_1242.0_1993-07-01	124200	\N	1993-07-01	130310	\N	\N	f	Sales which are qualified	0
130310_3660.0_2005-01-01	366000	\N	2005-01-01	130310	\N	\N	f	Sales which are qualified	0
130310_5150.0_2013-10-21	515000	\N	2013-10-21	130310	\N	\N	f	Qual by exam of deed	0
130310_7000.0_2016-09-20	700000	\N	2016-09-20	130310	\N	\N	f	Qual by exam of deed	0
130315_1290.0_1993-07-01	129000	\N	1993-07-01	130315	\N	\N	f	Sales which are qualified	0
130315_1300.0_2000-02-01	130000	\N	2000-02-01	130315	\N	\N	f	Sales which are qualified	0
130315_1550.0_1998-07-01	155000	\N	1998-07-01	130315	\N	\N	f	Sales which are qualified	0
130315_1560.0_2000-12-01	156000	\N	2000-12-01	130315	\N	\N	f	Sales which are qualified	0
130315_2650.0_2001-09-01	265000	\N	2001-09-01	130315	\N	\N	f	Sales which are qualified	0
130315_3500.0_2011-12-21	350000	\N	2011-12-21	130315	\N	\N	f	Qual by exam of deed	0
130315_4500.0_2020-06-23	450000	\N	2020-06-23	130315	\N	\N	f	Qual by exam of deed	0
130315_7750.0_2022-04-26	775000	\N	2022-04-26	130315	\N	\N	f	Qual by exam of deed	0
130316_2650.0_2016-05-20	265000	\N	2016-05-20	130316	\N	\N	f	Qual by exam of deed	0
130316_3499.0_2022-05-30	349900	\N	2022-05-30	130316	\N	\N	f	Qual by exam of deed	0
130316_615.0_1993-06-01	61500	\N	1993-06-01	130316	\N	\N	f	Sales which are qualified	0
130317_1500.0_2003-05-01	150000	\N	2003-05-01	130317	\N	\N	f	Sales which are qualified	0
130317_1530.0_2010-08-09	153000	\N	2010-08-09	130317	\N	\N	f	Qual by exam of deed	0
130317_629.0_1993-06-01	62900	\N	1993-06-01	130317	\N	\N	f	Sales which are qualified	0
130317_930.0_2000-06-01	93000	\N	2000-06-01	130317	\N	\N	f	Sales which are qualified	0
130323_675.0_1993-07-01	67500	\N	1993-07-01	130323	\N	\N	f	Sales which are qualified	0
130325_1950.0_2012-08-20	195000	\N	2012-08-20	130325	\N	\N	f	Qual by exam of deed	0
130325_820.0_1993-03-01	82000	\N	1993-03-01	130325	\N	\N	f	Sales which are qualified	0
130325_900.0_1999-07-01	90000	\N	1999-07-01	130325	\N	\N	f	Sales which are qualified	0
130326_1230.0_2002-02-01	123000	\N	2002-02-01	130326	\N	\N	f	Sales which are qualified	0
130326_2950.0_2005-10-01	295000	\N	2005-10-01	130326	\N	\N	f	Sales which are qualified	0
130326_860.0_1993-06-01	86000	\N	1993-06-01	130326	\N	\N	f	Sales which are qualified	0
130326_860.0_1998-09-01	86000	\N	1998-09-01	130326	\N	\N	f	Sales which are qualified	0
130327_1455.0_2002-04-01	145500	\N	2002-04-01	130327	\N	\N	f	Sales which are qualified	0
130327_900.0_1993-07-01	90000	\N	1993-07-01	130327	\N	\N	f	Sales which are qualified	0
130328_2475.0_2021-10-07	247500	\N	2021-10-07	130328	\N	\N	f	Qual by exam of deed	0
130328_965.0_1993-08-01	96500	\N	1993-08-01	130328	\N	\N	f	Sales which are qualified	0
130329_899.0_1993-12-01	89900	\N	1993-12-01	130329	\N	\N	f	Sales which are qualified	0
130333_1000.0_1993-09-01	100000	\N	1993-09-01	130333	\N	\N	f	Sales which are qualified	0
130335_1030.0_1993-08-01	103000	\N	1993-08-01	130335	\N	\N	f	Sales which are qualified	0
130335_5375.0_2014-07-01	537500	\N	2014-07-01	130335	\N	\N	f	Qual by exam of deed	0
130339_1089.0_1993-07-01	108900	\N	1993-07-01	130339	\N	\N	f	Sales which are qualified	0
130339_1230.0_1994-05-01	123000	\N	1994-05-01	130339	\N	\N	f	Sales which are qualified	0
130339_1490.0_1997-12-01	149000	\N	1997-12-01	130339	\N	\N	f	Sales which are qualified	0
130339_4850.0_2022-06-27	485000	\N	2022-06-27	130339	\N	\N	f	Qual by exam of deed	0
130341_1262.0_1993-08-01	126200	\N	1993-08-01	130341	\N	\N	f	Sales which are qualified	0
130341_2080.0_2000-09-01	208000	\N	2000-09-01	130341	\N	\N	f	Sales which are qualified	0
130341_2400.0_2001-02-01	240000	\N	2001-02-01	130341	\N	\N	f	Sales which are qualified	0
130344_1490.0_1993-11-01	149000	\N	1993-11-01	130344	\N	\N	f	Sales which are qualified	0
130344_3050.0_2011-07-07	305000	\N	2011-07-07	130344	\N	\N	f	Qual by exam of deed	0
130344_4100.0_2014-06-04	410000	\N	2014-06-04	130344	\N	\N	f	Qual by exam of deed	0
130344_5900.0_2017-09-27	590000	\N	2017-09-27	130344	\N	\N	f	Qual by exam of deed	0
130344_7200.0_2023-05-18	720000	\N	2023-05-18	130344	\N	\N	f	Qual by exam of deed	0
130345_1470.0_1993-09-01	147000	\N	1993-09-01	130345	\N	\N	f	Sales which are qualified	0
130345_4980.0_2013-04-26	498000	\N	2013-04-26	130345	\N	\N	f	Qual by exam of deed	0
130350_1584.0_1993-09-01	158400	\N	1993-09-01	130350	\N	\N	f	Sales which are qualified	0
130350_2100.0_2000-06-01	210000	\N	2000-06-01	130350	\N	\N	f	Sales which are qualified	0
130350_2550.0_2002-02-01	255000	\N	2002-02-01	130350	\N	\N	f	Sales which are qualified	0
130350_3500.0_2010-03-23	350000	\N	2010-03-23	130350	\N	\N	f	Qual by exam of deed	0
130351_1630.0_1993-10-01	163000	\N	1993-10-01	130351	\N	\N	f	Sales which are qualified	0
130351_4400.0_2008-09-10	440000	\N	2008-09-10	130351	\N	\N	f	Sales which are qualified	0
130351_4850.0_2012-04-25	485000	\N	2012-04-25	130351	\N	\N	f	Qual by exam of deed	0
130351_5950.0_2021-04-29	595000	\N	2021-04-29	130351	\N	\N	f	Qual by exam of deed	0
130356_1000.0_2000-08-01	100000	\N	2000-08-01	130356	\N	\N	f	Sales which are qualified	0
130356_615.0_1993-02-01	61500	\N	1993-02-01	130356	\N	\N	f	Sales which are qualified	0
130359_1650.0_2001-09-01	165000	\N	2001-09-01	130359	\N	\N	f	Sales which are qualified	0
130359_2100.0_2012-06-22	210000	\N	2012-06-22	130359	\N	\N	f	Qual by exam of deed	0
130359_2700.0_2007-10-01	270000	\N	2007-10-01	130359	\N	\N	f	Sales which are qualified	0
130359_3100.0_2020-12-30	310000	\N	2020-12-30	130359	\N	\N	f	Qual by exam of deed	0
130359_660.0_1993-02-01	66000	\N	1993-02-01	130359	\N	\N	f	Sales which are qualified	0
130359_750.0_1997-08-01	75000	\N	1997-08-01	130359	\N	\N	f	Sales which are qualified	0
130360_2350.0_2005-01-01	235000	\N	2005-01-01	130360	\N	\N	f	Sales which are qualified	0
130360_3250.0_2006-06-01	325000	\N	2006-06-01	130360	\N	\N	f	Sales which are qualified	0
130360_700.0_1993-03-01	70000	\N	1993-03-01	130360	\N	\N	f	Sales which are qualified	0
130365_1220.0_2000-01-01	122000	\N	2000-01-01	130365	\N	\N	f	Sales which are qualified	0
130365_1635.0_2002-05-01	163500	\N	2002-05-01	130365	\N	\N	f	Sales which are qualified	0
130365_790.0_1993-06-01	79000	\N	1993-06-01	130365	\N	\N	f	Sales which are qualified	0
130365_950.0_1995-12-01	95000	\N	1995-12-01	130365	\N	\N	f	Sales which are qualified	0
130366_3900.0_2022-09-06	390000	\N	2022-09-06	130366	\N	\N	f	Qual by exam of deed	0
130366_810.0_1993-05-01	81000	\N	1993-05-01	130366	\N	\N	f	Sales which are qualified	0
130367_1740.0_2002-10-01	174000	\N	2002-10-01	130367	\N	\N	f	Sales which are qualified	0
130367_4223.0_2022-03-11	422300	\N	2022-03-11	130367	\N	\N	f	Qual by exam of deed	0
130367_839.0_1993-07-01	83900	\N	1993-07-01	130367	\N	\N	f	Sales which are qualified	0
130368_1190.0_1993-08-01	119000	\N	1993-08-01	130368	\N	\N	f	Sales which are qualified	0
130370_1240.0_1994-03-01	124000	\N	1994-03-01	130370	\N	\N	f	Sales which are qualified	0
130370_1710.0_2000-10-01	171000	\N	2000-10-01	130370	\N	\N	f	Sales which are qualified	0
130370_2450.0_2001-12-01	245000	\N	2001-12-01	130370	\N	\N	f	Sales which are qualified	0
130370_5600.0_2007-04-01	560000	\N	2007-04-01	130370	\N	\N	f	Sales which are qualified	0
130375_1600.0_1993-10-01	160000	\N	1993-10-01	130375	\N	\N	f	Sales which are qualified	0
130375_1950.0_1998-11-01	195000	\N	1998-11-01	130375	\N	\N	f	Sales which are qualified	0
130375_4150.0_2005-01-01	415000	\N	2005-01-01	130