/* eslint import/no-extraneous-dependencies: [error, {devDependencies: true}] */

// Storybook's webpack loads this file too. Use require instead of import.
const postcss = require('postcss');

/**
 * md-only postcss plugin will convert CSS file for markdown into CSS which is not applied to wiki applicatins.
 * An example of the original CSS's selector is '.markdown ul li'.
 * This plugin will convert the selector into '.markdown ul.md li.md'.
 * If markdown converter adds 'md' class to all elements generated by markdown,
 * and if markdown converter does no add 'md' class to application elements,
 * CSS rules will not be applied to applications.
 */
const plugin = postcss.plugin('md-only', (/* opts */) => (css) => {
  const splitter = /[ \n]/;
  css.walkRules((rule) => {
    const tokens = rule.selectors.map((selector) => selector.split(splitter));
    const modified = tokens.map((arr) => arr.map((t) => {
      if (t === '.markdown-body') return t;
      // cannot place '.class' after '::pseudo-elements'
      const pseudoElementIndex = t.indexOf('::');
      if (pseudoElementIndex >= 0) {
        return `${t.substring(0, pseudoElementIndex)}.md${t.substring(pseudoElementIndex)}`;
      }
      return `${t}.md`;
    }));
    // eslint-disable-next-line no-param-reassign
    rule.selector = modified.map((ts) => ts.join(' ')).join(', ');
  });
});

module.exports = plugin;
