/* (c) Copyright Frontify Ltd., all rights reserved. */

import { type ReactElement, memo } from 'react';

function PatternTypography(): ReactElement {
    return (
        <svg
            viewBox="0 0 193 135"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            data-test-id="pattern-typography"
            className="tw-h-full"
        >
            <g clipPath="url(#clip0_11493_270491)">
                <rect width="193" height="135" fill="#FAFAFA" />
                <path
                    d="M27.8276 17.9274L27.2784 20.8734L26.6728 24.5074L25.5665 28.538L25.5261 31.7835L24.7993 35.4013L27.5368 34.3572L30.4117 33.6369L33.125 32.4714L35.8786 31.4112L38.6242 30.3347L41.3779 29.3878L39.8032 27.9714L38.0832 25.9642L33.3834 22.2655L29.8464 19.4651L28.0456 17.9112L27.8276 17.9274Z"
                    fill="currentColor"
                />
                <path
                    d="M60.0804 46.0522L59.9269 43.0657L59.6605 39.3912L59.7977 35.2149L59.071 32.0423L58.9418 28.3597L56.5272 30.0189L53.8947 31.3948L51.5286 33.1673L49.106 34.8426L46.6834 36.5342L44.2285 38.1043L46.0939 39.1079L48.2339 40.6619L53.6686 43.1466L57.7628 45.0405L59.8704 46.125L60.0804 46.0522Z"
                    fill="currentColor"
                />
                <path
                    d="M13.6877 -4.79132L13.1467 -1.85337L12.533 1.78063L11.4347 5.8112L11.3943 9.0648L10.6595 12.6745L13.397 11.6304L16.2718 10.9101L18.9851 9.74466L21.7388 8.6844L24.4844 7.60796L27.2381 6.66102L25.6634 5.24465L23.9515 3.23746L19.2436 -0.461281L15.7066 -3.26164L13.9138 -4.8156L13.6877 -4.79132Z"
                    fill="currentColor"
                />
                <path
                    d="M54.7749 23.3903L56.6807 21.0837L58.9741 18.2105L61.9054 15.232L63.5205 12.4155L65.9188 9.62323L63.0198 9.19427L60.1611 8.4092L57.2217 8.10974L54.3065 7.68888L51.3833 7.2842L48.5165 6.76622L49.2029 8.77341L49.7198 11.3633L52.0293 16.8912L53.7493 21.0675L54.565 23.3013L54.7749 23.3903Z"
                    fill="currentColor"
                />
                <path
                    d="M59.1194 8.36873L61.0333 6.07017L63.3267 3.18887L66.2499 0.210456L67.8731 -2.598L70.2714 -5.39836L67.3724 -5.82731L64.5057 -6.60429L61.5743 -6.91185L58.6591 -7.33271L55.7278 -7.73739L52.8691 -8.25537L53.5555 -6.24818L54.0723 -3.65825L56.3738 1.86963L58.1019 6.04589L58.9175 8.2797L59.1194 8.36873Z"
                    fill="currentColor"
                />
                <path
                    d="M9.96506 44.2392L10.5626 47.1771L11.3621 50.7707L11.8466 54.9226L13.0337 57.9496L13.7039 61.5674L15.852 59.5764L18.2503 57.8282L20.3257 55.7158L22.4737 53.7005L24.6217 51.6691L26.8182 49.759L24.8236 49.0306L22.4818 47.8165L16.7402 46.1655L12.4119 44.9029L10.1669 44.134L9.96506 44.2392Z"
                    fill="currentColor"
                />
                <path
                    d="M27.1574 21.877L24.1857 22.1117L20.5276 22.4759L16.3527 22.4597L13.2114 23.2691L9.54517 23.4957L11.2652 25.8752L12.7026 28.4732L14.5357 30.7961L16.2719 33.1756L18.0323 35.5551L19.6555 37.975L20.6164 36.0811L22.1023 33.8959L24.436 28.3842L26.2126 24.2322L27.2382 22.0874L27.1574 21.877Z"
                    fill="currentColor"
                />
                <path
                    d="M26.9475 50.1717L29.5558 48.4478L32.0834 44.2715L30.7752 38.4684L27.4643 35.6681L25.1951 35.3443L22.5626 35.6033L19.0013 37.7157L16.9987 41.1879L19.0498 42.9199L20.3984 44.2068L20.9879 44.9271L22.0457 45.6717L24.7025 48.1321L25.7927 49.419L26.8021 50.1555L26.9475 50.1717Z"
                    fill="currentColor"
                />
                <path
                    d="M33.8114 52.8022L34.9581 55.7159L38.5112 59.0504L44.4466 58.9614L47.8705 56.2906L48.6458 54.1296L48.9445 51.4992L47.604 47.5738L44.6323 44.8868L42.5166 46.546L40.9823 47.6062L40.1586 48.0352L39.2138 48.9174L36.2663 51.0217L34.7885 51.8229L33.8599 52.6647L33.8114 52.8022Z"
                    fill="currentColor"
                />
                <path
                    d="M55.631 25.8182L53.7252 23.3416L49.3888 21.1159L43.7118 22.856L41.16 26.3686L41.0147 28.6672L41.4588 31.2733L43.8249 34.6807L47.4265 36.4289L49.0012 34.2517L50.1802 32.803L50.8504 32.1636L51.5207 31.0548L53.7737 28.2139L54.9688 27.0323L55.6229 25.9639L55.631 25.8182Z"
                    fill="currentColor"
                />
                <path
                    d="M41.5718 -0.437106L39.666 -2.92182L35.3295 -5.13944L29.6526 -3.39934L27.1008 0.113255L26.9554 2.40372L27.3996 5.01793L29.7657 8.4253L33.3672 10.1735L34.9419 7.98825L36.1209 6.54761L36.7912 5.90822L37.4614 4.79131L39.7144 1.95858L40.9096 0.776923L41.5637 -0.291422L41.5718 -0.437106Z"
                    fill="currentColor"
                />
                <path
                    d="M54.8152 23.0421L56.2122 25.8344L60.0561 28.8371L65.9592 28.2139L69.1247 25.2436L69.7061 23.026L69.7626 20.3794L68.083 16.5835L64.8771 14.1797L62.9228 16.0251L61.4935 17.2148L60.7102 17.7166L59.8461 18.6797L57.0924 21.043L55.6954 21.9738L54.8475 22.8965L54.8152 23.0421Z"
                    fill="currentColor"
                />
                <path
                    d="M46.1989 57.8768L43.1949 58.7186L39.5207 61.9236L39.0038 67.8481L41.2972 71.5387L43.3645 72.5342L45.9486 73.0927L49.9782 72.17L52.9499 69.4749L51.5206 67.2006L50.6242 65.5657L50.285 64.6997L49.5017 63.6637L47.7171 60.5072L47.0711 58.9452L46.3362 57.9416L46.1989 57.8768Z"
                    fill="currentColor"
                />
                <path
                    d="M55.8247 2.24201L54.8557 -0.728312L51.5045 -4.27328L45.5772 -4.54036L41.9998 -2.07993L41.0954 0.0324802L40.6432 2.6386L41.7414 6.64489L44.5516 9.49381L46.7643 7.97223L48.3551 7.00101L49.203 6.6287L50.2043 5.80316L53.273 3.8769L54.7911 3.16467L55.7682 2.3796L55.8247 2.24201Z"
                    fill="currentColor"
                />
                <path
                    d="M11.9032 54.3076L9.9974 51.831L5.66096 49.6053L-0.0159888 51.3454L-2.56779 54.858L-2.71314 57.1565L-2.269 59.7627L0.0970659 63.17L3.69866 64.9182L5.27334 62.7411L6.45234 61.2923L7.12259 60.653L7.79284 59.5441L10.0459 56.7033L11.241 55.5217L11.8951 54.4533L11.9032 54.3076Z"
                    fill="currentColor"
                />
                <path
                    d="M30.5087 16.4702L29.7577 13.4271L26.6729 9.64738L20.7779 8.95133L17.031 11.1366L15.9812 13.1762L15.3352 15.7499L16.1427 19.8209L18.7349 22.8722L21.0525 21.5125L22.7079 20.6627L23.5801 20.3551L24.6379 19.6024L27.8438 17.9109L29.4104 17.3119L30.436 16.5997L30.5087 16.4702Z"
                    fill="currentColor"
                />
                <path
                    d="M11.4913 8.06943L10.7403 5.03436L7.66358 1.25468L1.7686 0.550548L-1.97835 2.74389L-3.03621 4.78346L-3.67416 7.34911L-2.87471 11.4202L-0.282531 14.4795L2.03508 13.1117L3.6986 12.27L4.57073 11.9543L5.6286 11.2016L8.82642 9.51008L10.4011 8.91116L11.4267 8.19893L11.4913 8.06943Z"
                    fill="currentColor"
                />
                <path
                    d="M43.0414 41.1962L44.0589 40.055L45.1168 37.9507L44.8664 36.591L44.503 35.0127L43.3806 34.2519L39.569 32.6575L36.6458 32.2609L34.1989 31.8077L33.5933 34.7699L32.8746 37.7564L32.487 40.8077L31.7683 43.7942L31.5018 46.7321L33.8032 47.3553L36.3147 47.8329L41.927 47.1935L43.8086 44.7249L43.7036 42.8877L43.3483 41.9893L43.0414 41.1962Z"
                    fill="currentColor"
                />
                <path
                    d="M29.685 54.1781L28.5867 53.1097L26.5275 51.9685L25.1628 52.1628L23.5719 52.4784L22.7725 53.563L21.0363 57.3183L20.5275 60.232L19.9784 62.6682L22.9017 63.3885L25.8573 64.2221L28.8855 64.732L31.833 65.5737L34.7482 65.9541L35.4669 63.6718L36.0402 61.1709L35.6203 55.5297L33.2381 53.5468L31.3969 53.5791L30.4844 53.9029L29.685 54.1781Z"
                    fill="currentColor"
                />
                <path
                    d="M3.42405 14.9651L1.92204 15.2322L-0.201765 16.2439L-0.839715 17.466L-1.51804 18.939L-1.1062 20.2259L0.920705 23.8356L2.97991 25.948L4.63535 27.8176L6.92066 25.859L9.32711 23.9408L11.5074 21.7798L13.9139 19.8697L15.9246 17.725L14.4872 15.8068L12.8076 13.8805L7.99468 10.9264L4.99066 11.7115L3.94895 13.225L3.67439 14.1476L3.42405 14.9651Z"
                    fill="currentColor"
                />
                <path
                    d="M4.86133 34.1142L3.432 34.6484L1.51008 36.0243L1.10632 37.3355L0.694474 38.9056L1.33242 40.1035L3.96498 43.2923L6.36334 45.0081L8.32565 46.554L10.2314 44.215L12.2583 41.9002L14.0187 39.3831L16.0456 37.0765L17.6446 34.6079L15.9003 32.973L13.8976 31.3786L8.64058 29.331L5.8223 30.634L5.06322 32.3094L4.96631 33.2725L4.86133 34.1142Z"
                    fill="currentColor"
                />
                <path
                    d="M40.0051 11.2906L38.7776 10.3761L36.5812 9.51816L35.2568 9.89046L33.7225 10.4084L33.0765 11.5982L31.849 15.5478L31.7198 18.502L31.5018 20.9867L34.4977 21.3185L37.534 21.7556L40.6027 21.8608L43.6309 22.3059L46.5703 22.2978L46.9821 19.9345L47.2244 17.3851L46.0696 11.8491L43.4452 10.198L41.6201 10.4732L40.7642 10.9183L40.0051 11.2906Z"
                    fill="currentColor"
                />
                <path
                    d="M59.7089 51.313L60.1531 49.8481L60.2096 47.4929L59.4102 46.3679L58.4088 45.0972L57.0764 44.8868L52.9499 45.0648L50.1316 45.947L47.7252 46.5864L48.4358 49.5163L49.0495 52.5352L49.9943 55.4569L50.6081 58.4758L51.6094 61.2438L53.9593 60.8229L56.4384 60.1917L61.2433 57.2213L61.8974 54.1862L61.0252 52.5675L60.3227 51.9039L59.7089 51.313Z"
                    fill="currentColor"
                />
                <path
                    d="M71.1516 34.1951L71.5877 32.7382L71.6523 30.3749L70.8528 29.2499L69.8515 27.9793L68.511 27.7688L64.3926 27.9469L61.5743 28.8291L59.1598 29.4685L59.8704 32.3983L60.4922 35.4172L61.4289 38.339L62.0426 41.3578L63.044 44.1258L65.402 43.705L67.873 43.0737L72.6859 40.1033L73.34 37.0683L72.4679 35.4496L71.7653 34.7859L71.1516 34.1951Z"
                    fill="currentColor"
                />
                <path
                    d="M102.056 40.9775L102.605 38.0396L103.211 34.4056L104.317 30.375L104.357 27.1295L105.092 23.5117L102.347 24.5558L99.4718 25.2761L96.7585 26.4416L94.0129 27.5018L91.2592 28.5783L88.5055 29.5252L90.0883 30.9416L91.8003 32.9488L96.5001 36.6475L100.037 39.4479L101.838 41.0018L102.056 40.9775Z"
                    fill="currentColor"
                />
                <path
                    d="M69.8031 12.8605L69.9565 15.847L70.223 19.5215L70.0938 23.6978L70.8125 26.8704L70.9417 30.553L73.3643 28.8938L75.9888 27.5179L78.3549 25.7454L80.7775 24.0701L83.2001 22.3785L85.6549 20.8084L83.7895 19.8048L81.6577 18.2508L76.223 15.7661L72.1288 13.8722L70.0131 12.7877L69.8031 12.8605Z"
                    fill="currentColor"
                />
                <path
                    d="M116.196 63.7041L116.745 60.7661L117.351 57.1321L118.457 53.1015L118.489 49.8479L119.224 46.2382L116.486 47.2823L113.612 47.9945L110.898 49.1681L108.145 50.2283L105.399 51.3048L102.645 52.2517L104.22 53.6681L105.94 55.6753L110.64 59.374L114.177 62.1744L115.978 63.7283L116.196 63.7041Z"
                    fill="currentColor"
                />
                <path
                    d="M78.3791 40.3219L77.2243 43.0818L75.8677 46.5053L73.9377 50.2122L73.2109 53.3767L71.7331 56.7517L74.6241 56.3147L77.5877 56.2256L80.4867 55.6591L83.4019 55.2059L86.3171 54.7364L89.2081 54.3965L87.9645 52.6726L86.7128 50.3497L82.9013 45.7364L80.0345 42.2481L78.6052 40.3461L78.3791 40.3219Z"
                    fill="currentColor"
                />
                <path
                    d="M119.918 14.6734L119.321 11.7355L118.521 8.14195L118.037 3.98998L116.858 0.962997L116.18 -2.65481L114.032 -0.663801L111.633 1.0844L109.558 3.19681L107.41 5.2121L105.262 7.24357L103.065 9.15364L105.06 9.87397L107.402 11.0961L113.143 12.7472L117.472 14.0098L119.725 14.7786L119.918 14.6734Z"
                    fill="currentColor"
                />
                <path
                    d="M102.726 37.036L105.698 36.8013L109.364 36.4371L113.531 36.4533L116.672 35.6439L120.338 35.4173L118.626 33.0378L117.181 30.4398L115.348 28.1169L113.612 25.7374L111.859 23.3579L110.228 20.938L109.275 22.8318L107.781 25.0171L105.448 30.5288L103.671 34.6808L102.645 36.8256L102.726 37.036Z"
                    fill="currentColor"
                />
                <path
                    d="M102.936 8.74097L100.328 10.4649L97.8001 14.6331L99.1164 20.4442L102.419 23.2446L104.688 23.5683L107.321 23.3093L110.882 21.1969L112.893 17.7248L110.834 15.9928L109.485 14.7059L108.904 13.9856L107.838 13.241L105.181 10.7805L104.091 9.49367L103.081 8.75716L102.936 8.74097Z"
                    fill="currentColor"
                />
                <path
                    d="M96.0722 6.1106L94.9255 3.19693L91.3723 -0.137597L85.437 -0.0485687L82.013 2.62229L81.2378 4.78327L80.9471 7.41366L82.2795 11.339L85.2512 14.0261L87.367 12.3669L88.9013 11.3066L89.725 10.8777L90.6698 9.9955L93.6253 7.89118L95.1031 7.08992L96.0237 6.24819L96.0722 6.1106Z"
                    fill="currentColor"
                />
                <path
                    d="M74.2525 33.0943L76.1583 35.5709L80.4947 37.7966L86.1717 36.0565L88.7235 32.5439L88.8688 30.2454L88.4247 27.6393L86.0586 24.2319L82.457 22.4837L80.8823 24.6609L79.7034 26.1096L79.0331 26.749L78.3629 27.8578L76.1098 30.6986L74.9147 31.8803L74.2606 32.9486L74.2525 33.0943Z"
                    fill="currentColor"
                />
                <path
                    d="M93.5769 48.966L91.5177 51.3131L90.1772 56.0073L92.9712 61.26L96.8958 63.0972L99.1731 62.7978L101.644 61.8589L104.519 58.8724L105.544 55.0037L103.106 53.8706L101.466 52.9884L100.707 52.4462L99.488 52.0091L96.2821 50.3338L94.8932 49.3868L93.7222 48.9417L93.5769 48.966Z"
                    fill="currentColor"
                />
                <path
                    d="M75.7143 48.6258L74.3172 45.8335L70.4734 42.8308L64.5703 43.4621L61.4048 46.4244L60.8234 48.642L60.7668 51.2967L62.4465 55.0844L65.6524 57.4882L67.6066 55.651L69.036 54.4531L69.8193 53.9513L70.6833 52.9882L73.437 50.6249L74.834 49.6941L75.682 48.7715L75.7143 48.6258Z"
                    fill="currentColor"
                />
                <path
                    d="M117.98 4.60546L119.886 7.08208L124.223 9.3078L129.9 7.56769L132.451 4.05511L132.605 1.75654L132.153 -0.849571L129.786 -4.25695L126.185 -6.00515L124.61 -3.82799L123.431 -2.37925L122.761 -1.73986L122.091 -0.631047L119.846 2.20978L118.643 3.39144L117.988 4.45978L117.98 4.60546Z"
                    fill="currentColor"
                />
                <path
                    d="M99.3748 42.4426L100.126 45.4857L103.211 49.2654L109.106 49.9614L112.853 47.7762L113.91 45.7366L114.548 43.1629L113.741 39.0918L111.157 36.0406L108.839 37.4003L107.176 38.2501L106.303 38.5577L105.246 39.3104L102.048 41.0019L100.473 41.6008L99.4475 42.313L99.3748 42.4426Z"
                    fill="currentColor"
                />
                <path
                    d="M86.8421 17.7167L85.8246 18.8579L84.7667 20.9622L85.0171 22.3219L85.3885 23.9001L86.5029 24.6609L90.3145 26.2554L93.2377 26.6519L95.6845 27.1052L96.2902 24.1429L97.0089 21.1564L97.3965 18.1052L98.1233 15.1187L98.3898 12.1807L96.0802 11.5575L93.5688 11.08L87.9565 11.7194L86.0749 14.1879L86.1799 16.0251L86.5433 16.9235L86.8421 17.7167Z"
                    fill="currentColor"
                />
                <path
                    d="M100.199 4.7346L101.297 5.80295L103.364 6.94413L104.721 6.74989L106.312 6.43424L107.111 5.34971L108.847 1.59431L109.364 -1.31935L109.905 -3.75551L106.982 -4.47583L104.026 -5.30946L101.006 -5.81935L98.0505 -6.66108L95.1353 -7.04148L94.4247 -4.7591L93.8513 -2.2582L94.2632 3.38298L96.6535 5.3659L98.4866 5.33352L99.3991 5.00978L100.199 4.7346Z"
                    fill="currentColor"
                />
                <path
                    d="M126.459 43.9479L127.961 43.6809L130.093 42.6692L130.731 41.447L131.402 39.974L130.99 38.6871L128.971 35.0774L126.904 32.965L125.256 31.0954L122.963 33.0541L120.564 34.9722L118.376 37.1332L115.97 39.0433L113.959 41.188L115.396 43.1062L117.084 45.0325L121.897 47.9866L124.893 47.2015L125.943 45.6881L126.209 44.7654L126.459 43.9479Z"
                    fill="currentColor"
                />
                <path
                    d="M128.066 59.9326L129.568 59.6655L131.7 58.6538L132.338 57.4317L133.017 55.9587L132.597 54.6718L130.578 51.0702L128.519 48.9497L126.863 47.0801L124.57 49.0387L122.171 50.9569L119.991 53.1179L117.585 55.0279L115.574 57.1727L117.003 59.0909L118.691 61.0171L123.504 63.9794L126.5 63.1943L127.55 61.6808L127.824 60.75L128.066 59.9326Z"
                    fill="currentColor"
                />
                <path
                    d="M199.816 82.9668L201.067 82.0927L202.577 80.2716L202.642 78.8957V77.277L201.721 76.2815L198.37 73.8615L195.616 72.8094L193.331 71.8139L192.071 74.5576L190.699 77.3094L189.625 80.1907L188.244 82.9344L187.323 85.7348L189.431 86.8679L191.765 87.9039L197.377 88.5513L199.767 86.5765L200.082 84.7636L199.937 83.8085L199.816 82.9668Z"
                    fill="currentColor"
                />
                <path
                    d="M125.022 24.7987L126.451 24.2645L128.373 22.8886L128.785 21.5774L129.189 20.0073L128.551 18.8094L125.919 15.6206L123.52 13.9048L121.558 12.3589L119.652 14.6979L117.625 17.0127L115.865 19.5298L113.838 21.8364L112.239 24.305L113.991 25.9398L115.986 27.5343L121.251 29.5819L124.061 28.2789L124.82 26.6035L124.925 25.6404L125.022 24.7987Z"
                    fill="currentColor"
                />
                <path
                    d="M89.8783 47.6224L91.1057 48.5369L93.3022 49.3948L94.6266 49.0144L96.1609 48.5045L96.8069 47.3148L98.0424 43.3652L98.1636 40.411L98.3897 37.9263L95.3937 37.5945L92.3574 37.1574L89.2888 37.0522L86.2525 36.6071L83.313 36.6152L82.9012 38.9785L82.659 41.5279L83.8137 47.0639L86.4463 48.715L88.2632 48.4398L89.1192 47.9947L89.8783 47.6224Z"
                    fill="currentColor"
                />
                <path
                    d="M71.3536 12.1241L72.4276 13.2167L74.4626 14.3984L75.8354 14.2365L77.4262 13.9613L78.2499 12.8849L80.0669 9.16996L80.6483 6.27248L81.2458 3.84442L78.3307 3.06744L75.3993 2.16906L72.3872 1.58632L69.4559 0.687943L66.5488 0.242799L65.7816 2.50899L65.1517 4.9937L65.4505 10.643L67.7924 12.6745L69.6335 12.6826L70.5461 12.3831L71.3536 12.1241Z"
                    fill="currentColor"
                />
                <path
                    d="M30.2018 115.43L30.7428 112.484L31.3484 108.85L32.4548 104.819L32.4951 101.574L33.23 97.9561L30.4925 99.0002L27.6096 99.7205L24.9043 100.886L22.1507 101.946L19.397 103.023L16.6514 103.97L18.2261 105.386L19.938 107.393L24.6379 111.092L28.1748 113.892L29.9756 115.446L30.2018 115.43Z"
                    fill="currentColor"
                />
                <path
                    d="M-2.05917 87.3049L-1.89767 90.2914L-1.63926 93.9659L-1.76846 98.1421L-1.04976 101.315L-0.920553 104.997L1.50204 103.338L4.12652 101.962L6.49259 100.19L8.91518 98.5144L11.3378 96.8229L13.7927 95.2608L11.9273 94.2491L9.79539 92.7033L4.3607 90.2105L0.266518 88.3166L-1.84921 87.2321L-2.05917 87.3049Z"
                    fill="currentColor"
                />
                <path
                    d="M44.3335 138.149L44.8827 135.211L45.4883 131.577L46.5946 127.546L46.635 124.292L47.3698 120.683L44.6242 121.727L41.7494 122.447L39.0361 123.613L36.2905 124.673L33.5368 125.749L30.7832 126.696L32.3659 128.113L34.0779 130.12L38.7777 133.819L42.3147 136.619L44.1155 138.173L44.3335 138.149Z"
                    fill="currentColor"
                />
                <path
                    d="M3.77932 111.051L2.62455 113.811L1.26789 117.235L-0.662107 120.942L-1.38888 124.106L-2.86667 127.481L0.0323706 127.044L2.98794 126.955L5.88697 126.388L8.80216 125.935L11.7174 125.466L14.6083 125.126L13.3647 123.402L12.113 121.079L8.30149 116.466L5.43476 112.978L4.00542 111.084L3.77932 111.051Z"
                    fill="currentColor"
                />
                <path
                    d="M48.0562 89.1178L47.4586 86.1879L46.6592 82.5863L46.1746 78.4343L44.9956 75.4073L44.3173 71.7895L42.1693 73.7886L39.7709 75.5368L37.6956 77.6411L35.5475 79.6564L33.3995 81.6879L31.2111 83.598L33.1976 84.3264L35.5395 85.5404L41.281 87.1915L45.6094 88.4622L47.8624 89.223L48.0562 89.1178Z"
                    fill="currentColor"
                />
                <path
                    d="M30.8639 111.48L33.8437 111.246L37.5018 110.881L41.6687 110.898L44.81 110.088L48.4843 109.862L46.7642 107.482L45.3187 104.884L43.4856 102.561L41.7495 100.182L39.9971 97.8022L38.3659 95.3823L37.413 97.2762L35.9271 99.4614L33.5853 104.973L31.8087 109.125L30.7832 111.27L30.8639 111.48Z"
                    fill="currentColor"
                />
                <path
                    d="M31.0739 83.1853L28.4656 84.9092L25.938 89.0855L27.2543 94.8886L30.5571 97.697L32.8262 98.0127L35.4588 97.7537L39.02 95.6413L41.0308 92.1772L38.9796 90.4371L37.623 89.1503L37.0416 88.4299L35.9756 87.6853L33.3188 85.2249L32.2287 83.938L31.2193 83.2015L31.0739 83.1853Z"
                    fill="currentColor"
                />
                <path
                    d="M24.2099 80.5548L23.0632 77.6412L19.5101 74.3066L13.5747 74.3957L10.1508 77.0665L9.37553 79.2275L9.08482 81.8579L10.4172 85.7914L13.389 88.4703L15.5047 86.8111L17.039 85.7509L17.8627 85.3219L18.8156 84.4397L21.7631 82.3354L23.2408 81.5341L24.1614 80.6924L24.2099 80.5548Z"
                    fill="currentColor"
                />
                <path
                    d="M2.39024 107.539L4.29602 110.015L8.63246 112.241L14.3094 110.501L16.8612 106.988L17.0146 104.69L16.5624 102.084L14.1964 98.6764L10.6028 96.9282L9.02007 99.1054L7.84915 100.554L7.17083 101.193L6.50865 102.302L4.25564 105.143L3.05242 106.325L2.39832 107.393L2.39024 107.539Z"
                    fill="currentColor"
                />
                <path
                    d="M14.673 133.478L16.5868 135.955L20.9232 138.173L26.6002 136.433L29.152 132.92L29.2973 130.629L28.8532 128.015L26.4871 124.616L22.8855 122.86L21.3109 125.045L20.1319 126.486L19.4616 127.125L18.7914 128.242L16.5384 131.075L15.3432 132.264L14.681 133.325L14.673 133.478Z"
                    fill="currentColor"
                />
                <path
                    d="M11.8223 75.4803L14.8344 74.6385L18.5087 71.4335L19.0255 65.5091L16.7241 61.8184L14.6649 60.8229L12.0808 60.2645L8.0431 61.1871L5.07946 63.8823L6.50072 66.1646L7.39708 67.7995L7.73624 68.6574L8.51954 69.7015L10.3042 72.8499L10.9502 74.4119L11.6931 75.4155L11.8223 75.4803Z"
                    fill="currentColor"
                />
                <path
                    d="M46.1181 79.0494L48.0239 81.5341L52.3603 83.7518L58.0453 82.0117L60.589 78.4991L60.7425 76.2005L60.2903 73.5944L57.9242 70.187L54.3307 68.4388L52.7479 70.616L51.577 72.0647L50.8987 72.7041L50.2365 73.821L47.9835 76.6537L46.7803 77.8354L46.1262 78.9037L46.1181 79.0494Z"
                    fill="currentColor"
                />
                <path
                    d="M27.5207 116.895L28.2717 119.93L31.3484 123.71L37.2434 124.406L40.9904 122.22L42.0482 120.181L42.6862 117.607L41.8867 113.536L39.2945 110.485L36.9769 111.844L35.3134 112.694L34.4413 113.002L33.3834 113.755L30.1856 115.446L28.6109 116.045L27.5853 116.757L27.5207 116.895Z"
                    fill="currentColor"
                />
                <path
                    d="M14.9798 92.1609L13.9623 93.3021L12.9044 95.4145L13.1548 96.7661L13.5262 98.3443L14.6406 99.1051L18.4522 100.7L21.3754 101.096L23.8303 101.549L24.4279 98.5871L25.1466 95.6006L25.5423 92.5494L26.261 89.5629L26.5275 86.6249L24.218 86.0017L21.7065 85.5242L16.1023 86.1636L14.2207 88.6321L14.3257 90.4693L14.681 91.3677L14.9798 92.1609Z"
                    fill="currentColor"
                />
                <path
                    d="M28.3443 79.179L29.4345 80.2473L31.5018 81.3885L32.8665 81.1943L34.4493 80.8786L35.2487 79.7941L36.993 76.0387L37.5018 73.125L38.0509 70.6889L35.1195 69.9686L32.164 69.1349L29.1438 68.625L26.1882 67.7833L23.273 67.4029L22.5624 69.6934L21.9891 72.1862L22.4009 77.8274L24.7912 79.8103L26.6324 79.7779L27.5368 79.4542L28.3443 79.179Z"
                    fill="currentColor"
                />
                <path
                    d="M54.5974 118.392L56.0994 118.125L58.2312 117.113L58.8692 115.891L59.5475 114.418L59.1276 113.131L57.1088 109.522L55.0496 107.409L53.3941 105.54L51.1007 107.498L48.7024 109.416L46.514 111.577L44.1156 113.487L42.1048 115.632L43.5342 117.55L45.2219 119.477L50.0348 122.431L53.0307 121.654L54.0805 120.132L54.347 119.209L54.5974 118.392Z"
                    fill="currentColor"
                />
                <path
                    d="M53.1599 99.2427L54.5973 98.7085L56.5111 97.3326L56.9229 96.0215L57.3267 94.4513L56.6888 93.2535L54.0562 90.0646L51.6578 88.3488L49.6955 86.8029L47.7898 89.142L45.7709 91.4567L44.0024 93.9738L41.9755 96.2804L40.3766 98.749L42.129 100.384L44.1317 101.978L49.3887 104.026L52.1989 102.723L52.966 101.048L53.0629 100.084L53.1599 99.2427Z"
                    fill="currentColor"
                />
                <path
                    d="M18.016 122.067L19.2435 122.981L21.44 123.839L22.7643 123.467L24.2986 122.949L24.9446 121.759L26.1802 117.809L26.3013 114.855L26.5274 112.371L23.5315 112.047L20.4951 111.602L17.4265 111.496L14.3902 111.051L11.4508 111.059L11.0389 113.423L10.8048 115.972L11.9595 121.508L14.584 123.159L16.401 122.884L17.2569 122.447L18.016 122.067Z"
                    fill="currentColor"
                />
                <path
                    d="M-1.84919 80.7491L-2.28525 82.2141L-2.34986 84.5774L-1.5504 85.6943L-0.540987 86.965L0.79144 87.1754L4.91793 86.9973L7.72813 86.1152L10.1427 85.4838L9.43203 82.5459L8.81023 79.5351L7.87349 76.6053L7.25977 73.5945L6.25843 70.8265L3.90044 71.2393L1.42939 71.8786L-3.3835 74.8409L-4.0376 77.8759L-3.16546 79.5027L-2.45484 80.1583L-1.84919 80.7491Z"
                    fill="currentColor"
                />
                <path
                    d="M106.594 79.9561L103.622 79.6809L99.9562 79.4139L95.854 78.6854L92.6158 78.9525L88.9657 78.5559L90.2497 81.1944L91.2349 83.9948L92.6481 86.5928L93.9563 89.2394L95.2806 91.886L96.4758 94.5406L97.7355 92.8329L99.5767 90.939L102.815 85.9049L105.262 82.1171L106.643 80.1747L106.594 79.9561Z"
                    fill="currentColor"
                />
                <path
                    d="M81.6576 114.758L84.6132 114.321L88.239 113.722L92.3978 113.463L95.4826 112.451L99.1245 111.974L97.2591 109.716L95.6441 107.223L93.6656 105.03L91.776 102.764L89.8702 100.505L88.0856 98.1988L87.2538 100.157L85.9133 102.432L83.9429 108.081L82.449 112.346L81.5607 114.556L81.6576 114.758Z"
                    fill="currentColor"
                />
                <path
                    d="M127.857 63.7366L124.885 63.4614L121.219 63.1944L117.108 62.4659L113.878 62.733L110.22 62.3364L111.512 64.9749L112.497 67.7753L113.91 70.3733L115.219 73.0199L116.543 75.6665L117.738 78.3212L118.998 76.6134L120.831 74.7195L124.069 69.6854L126.524 65.8976L127.897 63.9552L127.857 63.7366Z"
                    fill="currentColor"
                />
                <path
                    d="M104.244 103.686L106.756 105.313L109.881 107.256L113.176 109.813L116.163 111.084L119.216 113.14L119.297 110.202L119.725 107.264L119.676 104.301L119.741 101.347L119.797 98.3932L119.967 95.4795L118.061 96.4022L115.558 97.2277L110.357 100.182L106.425 102.399L104.309 103.476L104.244 103.686Z"
                    fill="currentColor"
                />
                <path
                    d="M78.799 64.5783L75.9404 65.4443L72.4438 66.5773L68.3657 67.4515L65.4667 68.9083L61.9297 69.92L64.1181 71.8786L66.0724 74.1043L68.3577 75.982L70.5622 77.9407L72.7829 79.8912L74.8906 81.9065L75.4155 79.8507L76.4088 77.3984L77.5231 71.5144L78.3711 67.0791L78.9202 64.7644L78.799 64.5783Z"
                    fill="currentColor"
                />
                <path
                    d="M102.621 79.6564L102.104 76.7104L101.402 73.0926L101.03 68.9244L99.94 65.8731L99.3667 62.2311L97.1621 64.1654L94.7153 65.8408L92.5834 67.8884L90.3789 69.8471L88.1743 71.8138L85.9294 73.6672L87.8997 74.4442L90.2012 75.723L95.9024 77.544L100.19 78.928L102.419 79.7535L102.621 79.6564Z"
                    fill="currentColor"
                />
                <path
                    d="M74.4868 82.0764L76.441 84.5206L80.8179 86.6492L86.4625 84.8039L88.9497 81.2427L89.0547 78.9442L88.554 76.3462L86.1233 72.9873L82.4894 71.3039L80.9551 73.5215L79.8084 74.9864L79.1463 75.6339L78.5002 76.767L76.3038 79.6483L75.1248 80.8542L74.4949 81.9307L74.4868 82.0764Z"
                    fill="currentColor"
                />
                <path
                    d="M72.5083 89.1665L69.7224 90.5828L66.7426 94.4435L67.3805 100.36L70.3522 103.524L72.5729 104.099L75.2136 104.148L78.9928 102.448L81.3831 99.2348L79.5339 97.2762L78.3387 95.8436L77.838 95.0586L76.869 94.2006L74.511 91.4488L73.5743 90.0487L72.6537 89.2069L72.5083 89.1665Z"
                    fill="currentColor"
                />
                <path
                    d="M101.345 108.437L103.631 106.308L105.431 101.768L103.178 96.2644L99.4475 94.0468L97.1622 94.1115L94.6104 94.7995L91.4449 97.4784L90.0398 101.234L92.3574 102.602L93.8998 103.646L94.5942 104.261L95.7652 104.819L98.7934 106.802L100.077 107.887L101.2 108.445L101.345 108.437Z"
                    fill="currentColor"
                />
                <path
                    d="M125.967 93.7635L128.252 91.6349L130.053 87.1025L127.8 81.5909L124.077 79.3732L121.784 79.438L119.232 80.1259L116.067 82.8049L114.661 86.5603L116.979 87.9281L118.521 88.9722L119.216 89.5873L120.387 90.1457L123.415 92.1286L124.699 93.2132L125.822 93.7716L125.967 93.7635Z"
                    fill="currentColor"
                />
                <path
                    d="M105.561 105.467L102.912 107.126L100.287 111.237L101.458 117.073L104.697 119.962L106.958 120.335L109.598 120.14L113.208 118.109L115.299 114.693L113.289 112.905L111.964 111.594L111.399 110.857L110.357 110.08L107.757 107.563L106.699 106.252L105.706 105.491L105.561 105.467Z"
                    fill="currentColor"
                />
                <path
                    d="M68.624 102.003L67.5015 99.0808L63.9807 95.7058L58.0453 95.7463L54.5972 98.3767L53.7977 100.538L53.4828 103.16L54.7748 107.102L57.7223 109.813L59.8542 108.178L61.3966 107.134L62.2283 106.713L63.1812 105.839L66.1529 103.767L67.6388 102.974L68.5675 102.14L68.624 102.003Z"
                    fill="currentColor"
                />
                <path
                    d="M72.0804 66.3347L72.0238 63.2106L69.8596 58.832L64.2715 56.841L60.1289 58.1359L58.6511 59.8841L57.4559 62.2474L57.3348 66.3994L59.176 69.9525L61.7439 69.1431L63.5447 68.6899L64.4653 68.5766L65.6685 68.0829L69.1652 67.1521L70.8287 66.9174L71.9835 66.4561L72.0804 66.3347Z"
                    fill="currentColor"
                />
                <path
                    d="M108.298 82.4972L111.254 81.4612L114.718 78.0376L114.863 72.0889L112.344 68.552L110.22 67.686L107.604 67.2895L103.639 68.4711L100.845 71.3362L102.411 73.5215L103.404 75.0997L103.8 75.9414L104.64 76.9288L106.618 79.9639L107.361 81.4774L108.161 82.4405L108.298 82.4972Z"
                    fill="currentColor"
                />
                <path
                    d="M84.8958 97.3003L86.1232 98.2149L88.3197 99.0728L89.6441 98.7005L91.1784 98.1825L91.8244 96.9928L93.0599 93.0431L93.1811 90.089L93.4072 87.6043L90.4112 87.2724L87.3749 86.8354L84.3063 86.7302L81.27 86.285L78.3306 86.2931L77.9187 88.6564L77.6845 91.2059L78.8393 96.7419L81.4638 98.3929L83.2807 98.1178L84.1367 97.6807L84.8958 97.3003Z"
                    fill="currentColor"
                />
                <path
                    d="M70.7641 85.1762L71.7169 83.9864L72.6618 81.8174L72.3387 80.4739L71.8865 78.9199L70.7237 78.2239L66.8395 76.8399L63.9 76.5971L61.4209 76.2814L60.9849 79.2679L60.4277 82.2949L60.2016 85.3623L59.6444 88.3812L59.5313 91.3273L61.8731 91.8291L64.4007 92.169L69.9727 91.2301L71.7169 88.6645L71.5151 86.8273L71.1113 85.9532L70.7641 85.1762Z"
                    fill="currentColor"
                />
                <path
                    d="M88.3844 58.5405L87.7222 57.1646L86.1799 55.3759L84.8313 55.0926L83.2404 54.8336L82.1099 55.5782L79.1866 58.5L77.7008 61.0576L76.3522 63.1538L78.8556 64.8453L81.3347 66.6502L83.9995 68.1718L86.4786 69.9847L89.087 71.3444L90.5405 69.4505L91.9376 67.3058L93.4961 61.8669L91.9376 59.1799L90.2014 58.5728L89.2323 58.5647L88.3844 58.5405Z"
                    fill="currentColor"
                />
                <path
                    d="M114.322 91.4893L115.114 90.1862L115.768 87.912L115.275 86.6251L114.621 85.144L113.377 84.6098L109.34 83.7438L106.392 83.8976L103.905 83.9057L103.857 86.9246L103.703 89.992L103.881 93.0675L103.719 96.135L104.002 99.0648L106.384 99.2591H108.944L114.338 97.5918L115.727 94.8238L115.291 93.0271L114.774 92.2177L114.322 91.4893Z"
                    fill="currentColor"
                />
                <path
                    d="M57.9324 129.926L58.7238 128.614L59.3779 126.348L58.8772 125.061L58.2231 123.58L56.9876 123.038L52.95 122.18L50.0025 122.326L47.5072 122.334L47.4668 125.361L47.3134 128.428L47.4911 131.496L47.3296 134.571L47.6122 137.501L49.9944 137.695H52.5462L57.9405 136.028L59.3375 133.252L58.8934 131.463L58.3766 130.646L57.9324 129.926Z"
                    fill="currentColor"
                />
                <path
                    d="M76.3925 114.871L77.8864 115.179L80.2444 115.025L81.2861 114.119L82.449 113.002L82.5378 111.65L81.9725 107.547L80.8339 104.819L79.986 102.472L77.1354 103.452L74.196 104.35L71.3777 105.564L68.4383 106.454L65.7815 107.709L66.4114 110.023L67.2755 112.435L70.6671 116.952L73.7438 117.332L75.2781 116.304L75.8676 115.543L76.3925 114.871Z"
                    fill="currentColor"
                />
                <path
                    d="M147.689 13.5163L149.603 15.8148L152.002 18.6071L154.392 22.0307L156.863 24.135L159.173 27.0082L160.117 24.224L161.401 21.5531L162.233 18.7123L163.178 15.912L164.107 13.1035L165.14 10.376L163.041 10.6916L160.408 10.7321L154.562 11.9947L150.152 12.9335L147.811 13.3301L147.689 13.5163Z"
                    fill="currentColor"
                />
                <path
                    d="M189.875 6.58001L187.485 4.79944L184.497 2.65465L181.372 -0.113334L178.473 -1.57826L175.566 -3.82826L175.291 -0.906499L174.669 1.99908L174.524 4.95321L174.257 7.89926L174.015 10.8453L173.652 13.7347L175.614 12.9415L178.166 12.2859L183.552 9.67983L187.614 7.72929L189.802 6.79044L189.875 6.58001Z"
                    fill="currentColor"
                />
                <path
                    d="M121.21 9.92268L123.124 12.2212L125.523 15.0054L127.913 18.429L130.384 20.5333L132.694 23.4065L133.638 20.6304L134.922 17.9515L135.762 15.1106L136.699 12.3103L137.628 9.50181L138.661 6.78239L136.562 7.08994L133.929 7.13041L128.083 8.393L123.673 9.33994L121.34 9.73652L121.21 9.92268Z"
                    fill="currentColor"
                />
                <path
                    d="M156.492 44.0935L159.124 45.5018L162.403 47.1852L165.899 49.4514L168.976 50.4793L172.19 52.268L172.029 49.3381L172.214 46.3678L171.924 43.4298L171.746 40.4757L171.552 37.5297L171.488 34.6079L169.662 35.6843L167.232 36.7203L162.298 40.0953L158.559 42.6205L156.54 43.875L156.492 44.0935Z"
                    fill="currentColor"
                />
                <path
                    d="M177.277 47.4847L179.91 48.893L183.189 50.5764L186.685 52.8426L189.762 53.8705L192.976 55.6591L192.814 52.7293L193 49.759L192.709 46.821L192.532 43.8669L192.338 40.9208L192.273 37.9991L190.448 39.0755L188.018 40.1115L183.075 43.4865L179.345 46.0117L177.326 47.2662L177.277 47.4847Z"
                    fill="currentColor"
                />
                <path
                    d="M150.29 16.5513L148.578 18.9955L146.519 22.0549L143.846 25.2599L142.457 28.1979L140.292 31.1763L143.216 31.3705L146.131 31.9128L149.086 31.9776L152.026 32.1637L154.973 32.3256L157.864 32.6169L157.025 30.6664L156.298 28.125L153.552 22.8076L151.493 18.7851L150.5 16.6241L150.29 16.5513Z"
                    fill="currentColor"
                />
                <path
                    d="M171.891 34.7698L172.23 31.6619L170.639 27.0486L165.342 24.3535L161.078 25.1142L159.383 26.6682L157.897 28.8535L157.251 32.9569L158.632 36.7204L161.28 36.2428L163.129 36.0162L164.05 36.0243L165.302 35.6844L168.887 35.2069L170.575 35.1826L171.778 34.875L171.891 34.7698Z"
                    fill="currentColor"
                />
                <path
                    d="M178.295 31.16L181.259 32.1312L186.096 31.5242L189.81 26.8866L189.948 22.5404L188.785 20.5655L186.944 18.6555L183.076 17.1744L179.119 17.7571L179.046 20.4522L178.876 22.3056L178.683 23.2121L178.755 24.5152L178.489 28.133L178.158 29.7841L178.214 31.0305L178.295 31.16Z"
                    fill="currentColor"
                />
                <path
                    d="M171.495 -2.90533L168.378 -3.01055L163.905 -1.08429L161.611 4.41121L162.685 8.61984L164.349 10.1981L166.642 11.5173L170.769 11.8653L174.411 10.2062L173.74 7.60006L173.377 5.77092L173.321 4.84017L172.893 3.61805L172.15 0.0649891L172.004 -1.61846L171.609 -2.80012L171.495 -2.90533Z"
                    fill="currentColor"
                />
                <path
                    d="M142.287 -7.55931L139.162 -7.66452L134.688 -5.73826L132.403 -0.242761L133.469 3.96587L135.14 5.54411L137.426 6.86335L141.552 7.21138L145.194 5.5522L144.524 2.94609L144.169 1.11695L144.112 0.186197L143.676 -1.03593L142.933 -4.58898L142.796 -6.27244L142.392 -7.45409L142.287 -7.55931Z"
                    fill="currentColor"
                />
                <path
                    d="M190.093 24.839L188.825 27.696L188.938 32.5764L193.162 36.7607L197.458 37.3435L199.541 36.3803L201.625 34.7535L203.482 31.0467L203.312 27.0404L200.647 26.6843L198.822 26.3363L197.942 26.0449L196.65 25.9801L193.089 25.3489L191.474 24.8471L190.23 24.7742L190.093 24.839Z"
                    fill="currentColor"
                />
                <path
                    d="M148.271 10.5134L145.461 9.15372L140.591 9.12134L136.295 13.2248L135.585 17.5062L136.473 19.6267L138.039 21.7553L141.681 23.7383L145.679 23.6897L146.115 21.035L146.519 19.214L146.842 18.3399L146.938 17.0449L147.681 13.4918L148.222 11.8974L148.335 10.651L148.271 10.5134Z"
                    fill="currentColor"
                />
                <path
                    d="M175.267 16.6323L175.049 15.1188L174.096 12.9498L172.901 12.278L171.447 11.5577L170.155 11.9381L166.497 13.8562L164.325 15.8553L162.411 17.4579L164.3 19.8131L166.142 22.2735L168.233 24.5235L170.066 26.992L172.15 29.064L174.104 27.6881L176.074 26.0532L179.167 21.3185L178.473 18.2915L176.987 17.1989L176.074 16.8994L175.267 16.6323Z"
                    fill="currentColor"
                />
                <path
                    d="M176.712 35.2232L175.194 35.385L172.998 36.251L172.279 37.4246L171.504 38.8491L171.835 40.1602L173.603 43.8994L175.517 46.1494L177.035 48.1323L179.458 46.3275L181.985 44.5874L184.311 42.5802L186.839 40.8401L188.987 38.8329L187.695 36.8176L186.136 34.7861L181.541 31.5082L178.497 32.0829L177.35 33.5235L177.019 34.43L176.712 35.2232Z"
                    fill="currentColor"
                />
                <path
                    d="M129.835 30.4478L129.084 31.7752L128.495 34.0657L129.027 35.3363L129.73 36.8013L130.982 37.3031L135.044 38.0477L137.983 37.8049L140.478 37.7239L140.43 34.705L140.494 31.6295L140.228 28.562L140.301 25.4946L139.929 22.5728L137.547 22.4514L134.987 22.5243L129.649 24.3453L128.333 27.1619L128.826 28.9343L129.367 29.7356L129.835 30.4478Z"
                    fill="currentColor"
                />
                <path
                    d="M145.461 41.5684L144.952 43.0091L144.79 45.3643L145.533 46.5217L146.478 47.8409L147.803 48.108L151.937 48.1161L154.788 47.3553L157.226 46.8292L156.645 43.867L156.16 40.8319L155.353 37.8616L154.876 34.8265L153.996 32.0181L151.63 32.3256L149.127 32.8517L144.193 35.5954L143.401 38.5981L144.201 40.2573L144.871 40.9452L145.461 41.5684Z"
                    fill="currentColor"
                />
                <path
                    d="M150.362 -0.113266L148.885 0.242849L146.817 1.39213L146.26 2.65472L145.679 4.16821L146.171 5.42271L148.424 8.89483L150.613 10.8777L152.381 12.634L154.545 10.5297L156.815 8.46587L158.858 6.1754L161.135 4.11156L163.008 1.84537L161.458 0.0162306L159.649 -1.79672L154.658 -4.43521L151.719 -3.46399L150.766 -1.88575L150.556 -0.946898L150.362 -0.113266Z"
                    fill="currentColor"
                />
                <path
                    d="M193.678 10.2302L192.839 8.95956L191.062 7.39751L189.689 7.30038L188.074 7.26801L187.065 8.1583L184.561 11.4524L183.447 14.1961L182.397 16.4542L185.102 17.7815L187.816 19.2302L190.658 20.3714L193.363 21.8202L196.133 22.8157L197.32 20.7356L198.402 18.4209L199.194 12.8202L197.288 10.3759L195.479 10.0117L194.526 10.1331L193.678 10.2302Z"
                    fill="currentColor"
                />
                <path
                    d="M146.777 96.5556L149.603 95.5763L153.051 94.3137L157.097 93.2859L159.932 91.7157L163.428 90.5664L161.175 88.6968L159.132 86.544L156.774 84.7553L154.497 82.8857L152.212 81.0161L150.031 79.0898L149.579 81.1618L148.683 83.6465L147.794 89.5709L147.108 94.0386L146.648 96.3695L146.777 96.5556Z"
                    fill="currentColor"
                />
                <path
                    d="M155.256 54.5505L152.737 56.1692L149.676 58.2088L145.994 60.1593L143.595 62.3527L140.462 64.287L143.095 65.5739L145.59 67.1845L148.295 68.3662L150.944 69.653L153.609 70.9318L156.177 72.2996L156.136 70.171L156.427 67.5487L155.902 61.5838L155.523 57.0757L155.426 54.7043L155.256 54.5505Z"
                    fill="currentColor"
                />
                <path
                    d="M132.274 118.481L135.092 117.502L138.548 116.239L142.586 115.211L145.428 113.641L148.925 112.5L146.664 110.622L144.621 108.469L142.271 106.681L139.994 104.811L137.7 102.942L135.52 101.015L135.068 103.087L134.171 105.572L133.283 111.496L132.597 115.964L132.145 118.295L132.274 118.481Z"
                    fill="currentColor"
                />
                <path
                    d="M106.013 125.288L108.831 126.275L112.32 127.424L116.131 129.124L119.329 129.65L122.785 130.929L122.163 128.056L121.889 125.093L121.146 122.236L120.516 119.347L119.87 116.458L119.353 113.592L117.714 114.936L115.477 116.336L111.116 120.432L107.822 123.515L106.021 125.061L106.013 125.288Z"
                    fill="currentColor"
                />
                <path
                    d="M85.1946 130.298L87.3992 132.313L90.1609 134.749L92.9954 137.817L95.7248 139.565L98.4058 142.09L98.963 139.209L99.8755 136.384L100.312 133.454L100.869 130.557L101.402 127.643L102.056 124.802L100.021 125.401L97.4126 125.798L91.8002 127.845L87.5607 129.383L85.2915 130.095L85.1946 130.298Z"
                    fill="currentColor"
                />
                <path
                    d="M58.651 124.017L59.4585 126.898L60.5083 130.427L61.2916 134.531L62.6806 137.469L63.6093 141.038L65.6119 138.893L67.8811 136.975L69.803 134.725L71.8057 132.564L73.8003 130.379L75.8514 128.315L73.8165 127.74L71.3939 126.696L65.5473 125.45L61.1382 124.495L58.8448 123.896L58.651 124.017Z"
                    fill="currentColor"
                />
                <path
                    d="M138.984 70.8831L136.013 71.2392L132.371 71.7491L128.204 71.8948L125.103 72.8256L121.445 73.1979L123.254 75.5126L124.796 78.0459L126.718 80.2959L128.543 82.6107L130.392 84.9173L132.112 87.2644L132.992 85.3382L134.398 83.0963L136.513 77.4955L138.128 73.2788L139.065 71.0936L138.984 70.8831Z"
                    fill="currentColor"
                />
                <path
                    d="M178.424 99.1296L180.677 97.1629L183.398 94.6863L186.758 92.2177L188.801 89.6925L191.619 87.3131L188.825 86.4309L186.12 85.2006L183.269 84.4318L180.459 83.5577L177.633 82.6916L174.887 81.7204L175.251 83.8086L175.347 86.4551L176.744 92.2744L177.786 96.6692L178.238 99.0082L178.424 99.1296Z"
                    fill="currentColor"
                />
                <path
                    d="M150.693 95.8354L152.365 98.312L154.489 101.323L156.532 104.965L158.785 107.296L160.796 110.388L162.015 107.709L163.557 105.175L164.664 102.432L165.875 99.7365L167.07 97.0333L168.362 94.419L166.247 94.5243L163.622 94.3057L157.687 94.9937L153.205 95.4955L150.839 95.6574L150.693 95.8354Z"
                    fill="currentColor"
                />
                <path
                    d="M175.186 81.3967L172.4 79.9804L167.539 79.8347L163.146 83.841L162.346 88.1144L163.186 90.251L164.712 92.412L168.306 94.4759L172.303 94.5163L172.796 91.8616L173.24 90.0568L173.579 89.1908L173.7 87.8958L174.524 84.3671L175.105 82.7807L175.242 81.5343L175.186 81.3967Z"
                    fill="currentColor"
                />
                <path
                    d="M174.08 74.1207L176.042 71.6845L177.181 66.9336L174.168 61.8104L170.163 60.1432L167.91 60.5317L165.479 61.5757L162.726 64.6755L161.87 68.5928L164.357 69.6207L166.029 70.43L166.804 70.9399L168.047 71.3284L171.326 72.8662L172.747 73.7565L173.934 74.145L174.08 74.1207Z"
                    fill="currentColor"
                />
                <path
                    d="M139.889 68.4226L138.686 71.312L138.896 76.1843L143.216 80.2716L147.52 80.7653L149.579 79.7617L151.63 78.0863L153.407 74.339L153.157 70.3408L150.484 70.0414L148.65 69.7257L147.762 69.4505L146.462 69.4262L142.893 68.8597L141.27 68.3984L140.026 68.3579L139.889 68.4226Z"
                    fill="currentColor"
                />
                <path
                    d="M126.419 45.6717L127.703 48.5206L131.41 51.6852L137.337 51.3048L140.624 48.472L141.302 46.2787L141.463 43.6321L139.937 39.7715L136.844 37.2382L134.809 38.9945L133.332 40.1276L132.524 40.597L131.62 41.5278L128.777 43.7697L127.34 44.6438L126.46 45.526L126.419 45.6717Z"
                    fill="currentColor"
                />
                <path
                    d="M123.455 91.9345L122.244 94.8239L122.462 99.6962L126.774 103.792L131.087 104.277L133.146 103.274L135.189 101.598L136.974 97.8509L136.715 93.8527L134.05 93.5533L132.209 93.2376L131.329 92.9705L130.029 92.9381L126.451 92.3797L124.836 91.9184L123.593 91.8698L123.455 91.9345Z"
                    fill="currentColor"
                />
                <path
                    d="M142.376 64.57L141.213 61.6644L137.644 58.3461L131.708 58.4675L128.301 61.1545L127.533 63.3155L127.251 65.9459L128.607 69.8713L131.587 72.5421L133.703 70.8749L135.229 69.8065L136.053 69.3776L136.99 68.4873L139.929 66.3668L141.407 65.5574L142.327 64.7157L142.376 64.57Z"
                    fill="currentColor"
                />
                <path
                    d="M172.368 60.8148L174.58 63.0163L179.175 64.6431L184.577 62.1665L186.637 58.3463L186.483 56.0558L185.692 53.5226L182.898 50.4632L179.102 49.2087L177.827 51.5801L176.849 53.1665L176.268 53.8868L175.751 55.0846L173.894 58.1925L172.86 59.528L172.351 60.6692L172.368 60.8148Z"
                    fill="currentColor"
                />
                <path
                    d="M186.201 92.4685L184.989 95.3579L185.207 100.23L189.52 104.317L193.832 104.811L195.891 103.808L197.934 102.132L199.719 98.3848L199.46 94.3866L196.795 94.0872L194.954 93.7715L194.074 93.5045L192.774 93.4721L189.197 92.9055L187.581 92.4523L186.338 92.4037L186.201 92.4685Z"
                    fill="currentColor"
                />
                <path
                    d="M192.475 56.2419L189.439 56.9946L185.66 60.0782L184.957 65.9865L187.137 69.7419L189.172 70.8021L191.732 71.4415L195.794 70.6484L198.846 68.0584L197.49 65.7275L196.65 64.0683L196.335 63.1942L195.592 62.1259L193.904 58.9208L193.315 57.3426L192.604 56.3147L192.475 56.2419Z"
                    fill="currentColor"
                />
                <path
                    d="M144.185 94.937L141.924 97.098L140.163 101.647L142.465 107.126L146.212 109.311L148.505 109.23L151.049 108.518L154.19 105.807L155.555 102.043L153.229 100.692L151.679 99.6637L150.976 99.0566L149.797 98.5063L146.753 96.5557L145.461 95.4793L144.33 94.9289L144.185 94.937Z"
                    fill="currentColor"
                />
                <path
                    d="M159.455 71.8059L157.961 71.4821L155.611 71.5954L154.554 72.4857L153.366 73.5864L153.261 74.9381L153.762 79.0415L154.852 81.7933L155.676 84.1485L158.535 83.2096L161.49 82.3598L164.325 81.1943L167.28 80.3526L169.953 79.1305L169.356 76.8158L168.532 74.3877L165.213 69.8149L162.136 69.394L160.594 70.3976L159.996 71.1503L159.455 71.8059Z"
                    fill="currentColor"
                />
                <path
                    d="M177.31 77.0422L176.93 78.5152L176.954 80.8785L177.802 81.9712L178.852 83.2014L180.193 83.3633L184.311 83.0233L187.089 82.0359L189.471 81.3075L188.647 78.4019L187.913 75.4154L186.863 72.526L186.136 69.5395L185.03 66.812L182.696 67.3138L180.241 68.0503L175.557 71.1987L175.016 74.25L175.953 75.8444L176.68 76.4757L177.31 77.0422Z"
                    fill="currentColor"
                />
                <path
                    d="M152.583 119.857V121.387L153.205 123.669L154.295 124.511L155.619 125.433L156.96 125.247L160.852 123.888L163.299 122.228L165.423 120.917L163.897 118.311L162.435 115.608L160.691 113.075L159.237 110.371L157.477 108.008L155.345 109.093L153.157 110.42L149.41 114.653L149.66 117.745L150.96 119.048L151.824 119.468L152.583 119.857Z"
                    fill="currentColor"
                />
                <path
                    d="M175.711 109.837L177.237 109.862L179.522 109.271L180.378 108.186L181.315 106.867L181.154 105.524L179.845 101.598L178.214 99.1378L176.946 96.9849L174.322 98.4822L171.609 99.9066L169.057 101.622L166.335 103.047L163.961 104.771L165.003 106.924L166.303 109.133L170.47 112.945L173.563 112.743L174.879 111.456L175.315 110.59L175.711 109.837Z"
                    fill="currentColor"
                />
                <path
                    d="M135.003 89.215L134.817 90.7366L135.157 93.0756L136.134 94.0468L137.337 95.1233L138.694 95.1071L142.723 94.2249L145.348 92.8814L147.617 91.8454L146.422 89.0693L145.299 86.2042L143.886 83.4767L142.772 80.6197L141.31 78.0621L139.065 78.8634L136.731 79.9155L132.492 83.6547L132.363 86.7627L133.493 88.2114L134.301 88.7375L135.003 89.215Z"
                    fill="currentColor"
                />
                <path
                    d="M160.004 52.2843L158.518 52.6161L156.435 53.7331L155.854 54.9875L155.248 56.4849L155.724 57.7474L157.921 61.26L160.077 63.2753L161.813 65.064L164.01 63.0001L166.319 60.9687L168.395 58.7025L170.712 56.6872L172.618 54.4453L171.092 52.5919L169.315 50.7546L164.373 48.0271L161.409 48.9498L160.44 50.5199L160.214 51.4588L160.004 52.2843Z"
                    fill="currentColor"
                />
                <path
                    d="M178.618 109.619L176.106 111.229L173.038 113.277L169.355 115.22L166.957 117.413L163.832 119.347L166.465 120.642L168.952 122.253L171.657 123.434L174.306 124.721L176.971 126L179.547 127.36L179.498 125.239L179.789 122.617L179.264 116.644L178.884 112.144L178.787 109.773L178.618 109.619Z"
                    fill="currentColor"
                />
                <path
                    d="M143.361 41.8596L141.932 44.49L140.244 47.7679L137.951 51.2562L136.917 54.3317L135.108 57.5449L138.031 57.3992L140.995 57.6015L143.934 57.3263L146.874 57.1726L149.821 56.9945L152.728 56.9459L151.663 55.1087L150.653 52.6726L147.318 47.7031L144.815 43.9396L143.579 41.9082L143.361 41.8596Z"
                    fill="currentColor"
                />
                <path
                    d="M160.893 126.437L157.929 126.793L154.287 127.295L150.12 127.441L147.011 128.38L143.353 128.752L145.162 131.059L146.704 133.6L148.626 135.842L150.459 138.157L152.309 140.471L154.029 142.818L154.909 140.884L156.306 138.65L158.43 133.05L160.037 128.825L160.981 126.648L160.893 126.437Z"
                    fill="currentColor"
                />
                <path
                    d="M130.449 139.783L128.212 137.817L125.402 135.437L122.511 132.426L119.741 130.727L117.019 128.25L116.511 131.147L115.655 133.988L115.275 136.926L114.783 139.84L114.298 142.754L113.7 145.611L115.727 144.979L118.32 144.526L123.9 142.365L128.107 140.746L130.36 139.994L130.449 139.783Z"
                    fill="currentColor"
                />
                <path
                    d="M197.441 129.181L199.404 126.745L200.542 122.002L197.53 116.879L193.533 115.211L191.272 115.6L188.841 116.644L186.096 119.744L185.232 123.661L187.719 124.689L189.39 125.498L190.166 126.008L191.409 126.397L194.688 127.926L196.117 128.825L197.296 129.213L197.441 129.181Z"
                    fill="currentColor"
                />
                <path
                    d="M163.259 123.491L162.047 126.372L162.265 131.253L166.578 135.34L170.882 135.825L172.941 134.83L174.992 133.147L176.777 129.407L176.518 125.401L173.845 125.11L172.012 124.794L171.124 124.519L169.832 124.495L166.255 123.928L164.632 123.467L163.388 123.426L163.259 123.491Z"
                    fill="currentColor"
                />
                <path
                    d="M73.9699 130.16L72.7586 133.041L72.9767 137.922L77.2889 142.009L81.6011 142.503L83.6603 141.499L85.7033 139.816L87.488 136.076L87.2296 132.07L84.5647 131.779L82.7236 131.463L81.8433 131.188L80.5432 131.164L76.9659 130.597L75.3508 130.136L74.1072 130.095L73.9699 130.16Z"
                    fill="currentColor"
                />
                <path
                    d="M138.346 116.207L137.135 119.096L137.353 123.969L141.665 128.056L145.978 128.55L148.037 127.546L150.08 125.871L151.864 122.123L151.606 118.125L148.941 117.826L147.108 117.51L146.22 117.243L144.92 117.211L141.35 116.644L139.727 116.191L138.484 116.142L138.346 116.207Z"
                    fill="currentColor"
                />
                <path
                    d="M123.044 118.465L121.832 121.354L122.05 126.227L126.363 130.322L130.667 130.807L132.734 129.804L134.777 128.128L136.562 124.381L136.303 120.383L133.63 120.084L131.797 119.776L130.909 119.501L129.617 119.468L126.04 118.91L124.425 118.449L123.173 118.4L123.044 118.465Z"
                    fill="currentColor"
                />
                <path
                    d="M63.9404 110.347L61.2513 111.942L58.5299 115.98L59.5555 121.848L62.721 124.81L64.974 125.239L67.6147 125.118L71.2728 123.175L73.445 119.817L71.4827 117.979L70.1907 116.628L69.6416 115.883L68.6241 115.082L66.0884 112.492L65.0629 111.156L64.0857 110.371L63.9404 110.347Z"
                    fill="currentColor"
                />
                <path
                    d="M104.866 124.616L102.597 126.769L100.836 131.317L103.146 136.805L106.893 138.99L109.186 138.901L111.73 138.189L114.863 135.485L116.236 131.714L113.91 130.37L112.36 129.343L111.657 128.736L110.478 128.185L107.434 126.227L106.134 125.15L105.011 124.608L104.866 124.616Z"
                    fill="currentColor"
                />
                <path
                    d="M182.817 126.874L181.323 126.542L178.973 126.664L177.915 127.554L176.728 128.655L176.623 130.006L177.124 134.11L178.222 136.853L179.038 139.217L181.905 138.278L184.852 137.428L187.686 136.263L190.642 135.413L193.315 134.199L192.726 131.876L191.894 129.456L188.575 124.883L185.498 124.462L183.956 125.458L183.358 126.219L182.817 126.874Z"
                    fill="currentColor"
                />
                <path
                    d="M96.2093 124.3L97.7275 124.446L100.053 124.058L100.998 123.054L102.048 121.824L101.999 120.472L101.03 116.45L99.6252 113.844L98.5431 111.602L95.8055 112.856L92.9711 114.046L90.282 115.535L87.4557 116.717L84.9362 118.23L85.7922 120.472L86.8904 122.779L90.7181 126.939L93.819 127.004L95.2403 125.83L95.749 125.013L96.2093 124.3Z"
                    fill="currentColor"
                />
                <path
                    d="M137.119 139.597L138.597 139.969L140.955 139.921L142.037 139.063L143.248 138.003L143.393 136.659L143.022 132.532L142.013 129.755L141.262 127.376L138.371 128.226L135.399 128.987L132.524 130.063L129.552 130.824L126.839 131.957L127.364 134.296L128.115 136.74L131.305 141.41L134.357 141.928L135.932 140.973L136.554 140.237L137.119 139.597Z"
                    fill="currentColor"
                />
                <path
                    d="M8.69716 137.339L10.183 137.711L12.541 137.663L13.615 136.805L14.8344 135.736L14.9797 134.393L14.6083 130.273L13.5989 127.497L12.8479 125.118L9.95691 125.96L6.98519 126.728L4.11038 127.805L1.13866 128.558L-1.57464 129.699L-1.04975 132.038L-0.298743 134.482L2.89101 139.152L5.94347 139.67L7.51816 138.715L8.13996 137.978L8.69716 137.339Z"
                    fill="currentColor"
                />
                <path
                    d="M75.5607 124.397L75.1166 125.854L75.052 128.218L75.8514 129.343L76.8528 130.613L78.1852 130.824L82.3117 130.654L85.1219 129.78L87.5364 129.148L86.8339 126.21L86.2201 123.2L85.2834 120.27L84.6778 117.251L83.6764 114.483L81.3265 114.896L78.8474 115.527L74.0345 118.481L73.3723 121.516L74.2445 123.143L74.947 123.798L75.5607 124.397Z"
                    fill="currentColor"
                />
                <path
                    d="M158.365 144.283L158.179 145.805L158.518 148.136L159.496 149.107L160.707 150.192L162.055 150.167L166.085 149.293L168.71 147.942L170.979 146.906L169.784 144.138L168.669 141.272L167.248 138.545L166.133 135.68L164.672 133.122L162.427 133.932L160.093 134.984L155.854 138.723L155.724 141.823L156.863 143.28L157.662 143.806L158.365 144.283Z"
                    fill="currentColor"
                />
                <path
                    d="M183.366 107.344L181.88 107.684L179.797 108.801L179.224 110.048L178.61 111.553L179.086 112.816L181.283 116.328L183.439 118.344L185.175 120.132L187.372 118.06L189.681 116.037L191.765 113.771L194.074 111.747L195.98 109.505L194.454 107.66L192.677 105.823L187.735 103.095L184.779 104.018L183.802 105.58L183.576 106.519L183.366 107.344Z"
                    fill="currentColor"
                />
                <path
                    d="M121.978 108.785L120.669 109.57L119.038 111.27L118.877 112.646L118.764 114.256L119.612 115.316L122.777 117.963L125.458 119.209L127.663 120.367L129.108 117.72L130.675 115.074L131.951 112.273L133.517 109.635L134.64 106.907L132.621 105.628L130.36 104.431L124.812 103.378L122.285 105.183L121.84 106.972L121.921 107.935L121.978 108.785Z"
                    fill="currentColor"
                />
            </g>
            <defs>
                <clipPath id="clip0_11493_270491">
                    <rect width="193" height="135" fill="white" />
                </clipPath>
            </defs>
        </svg>
    );
}

PatternTypography.displayName = 'FonduePatternTypography';

const Memo = memo(PatternTypography);

export default Memo;
