/* (c) Copyright Frontify Ltd., all rights reserved. */

import { type ReactElement, memo } from 'react';

function PatternSound(): ReactElement {
    return (
        <svg
            viewBox="0 0 193 135"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            data-test-id="pattern-sound"
            className="tw-h-full"
        >
            <g clipPath="url(#clip0_11493_271080)">
                <rect width="193" height="135" fill="#FAFAFA" />
                <path
                    d="M36.5729 6.62862L37.5985 8.652L38.5352 10.813L39.5366 12.7473L39.5769 12.9416L37.4208 12.0189L35.2244 11.2177L33.9646 11.0639L32.2446 10.8373L28.8933 12.804L26.8341 13.5729L26.8664 13.5567L27.5286 11.5414L28.1504 9.26712L29.1194 7.13042L28.1908 4.96136L26.9149 2.98654L25.857 0.930785L26.0185 0.825569L28.1019 1.6592L30.3065 2.44427L32.503 3.22935L34.5218 2.04769L36.6618 1.09266L38.4464 -0.056625L38.721 0.0243103L37.8165 2.17719L37.2755 4.47575L36.5729 6.62862Z"
                    fill="currentColor"
                />
                <path
                    d="M33.4316 31.2896L34.5703 33.2482L35.6281 35.3444L36.7425 37.2221L36.799 37.4164L34.5864 36.6232L32.3496 35.9434L31.0898 35.8624L29.3536 35.7329L26.1235 37.8939L24.1047 38.7761L24.137 38.7518L24.6861 36.7042L25.1706 34.4056L26.0266 32.2122L24.9687 30.0998L23.5878 28.206L22.4088 26.2069L22.5623 26.1016L24.6942 26.8139L29.184 28.125L31.1221 26.8301L33.2136 25.7536L34.9256 24.4991L35.2001 24.572L34.4168 26.7734L34.0131 29.0881L33.4316 31.2896Z"
                    fill="currentColor"
                />
                <path
                    d="M57.5607 22.2491L57.3669 24.5072L57.0196 26.8381L56.8581 29.0153L56.7935 29.2015L55.445 27.2752L53.9995 25.4299L53.0143 24.6367L51.6657 23.5279L47.7896 23.4308L45.6334 22.9937H45.6738L47.297 21.634L49.017 20.0315L50.9712 18.7284L51.3185 16.3975L51.2781 14.0423L51.4638 11.7356H51.6496L52.982 13.5486L54.4436 15.3777L55.8972 17.2069L58.2309 17.2716L60.5566 17.5873L62.6804 17.5549L62.8581 17.7734L60.9604 19.125L59.2969 20.7842L57.5607 22.2491Z"
                    fill="currentColor"
                />
                <path
                    d="M21.2056 14.2851L21.9809 11.8975L22.966 7.33276L23.2083 7.45416L23.499 10.0846L23.2648 12.5693L23.4102 13.7914L23.3779 15.0783L24.2581 14.1637L26.067 12.6988L27.3267 11.4281L28.9014 9.85793V9.92268L26.5999 12.9901L24.6619 16.2923L28.5945 15.9119L32.4061 15.0216L32.5272 15.5234L28.9418 16.8588L25.4613 18.3723L28.7722 19.7158L31.8489 21.5774L31.8973 21.6097L28.3523 20.8247L24.9445 20.4443L26.931 23.5036L29.2486 26.5792L28.8126 26.8462L25.8328 24.4506L23.1922 21.5855L23.4183 22.4596L23.3133 23.8355L23.281 27.8498L23.3294 29.6466L22.9176 29.7518L22.2635 27.5747L21.6417 24.75L21.464 23.2527L21.0926 22.0063L19.857 23.8031L18.6538 25.6565L17.5152 27.5423L16.958 28.4407L16.8127 28.4488L17.2326 27.3238L17.5879 25.6565L18.1935 24.6772L19.0253 21.0513L15.7548 22.67L12.347 24.2806L12.024 23.8355L15.2783 21.8687L16.9257 20.3067L17.7332 19.5621L16.8207 18.9712L14.3335 18.8256L10.6027 18.3076V17.9515L14.3255 17.4416L18.3631 17.1907L15.3268 14.6007L12.3389 12.2779L12.5408 11.9784L15.8759 13.8399L19.2191 15.3939L18.2662 11.7275L17.0065 7.98833L16.9903 8.00452L17.1114 7.96405L17.9351 8.67628L18.8799 10.554L19.962 12.4883L20.6727 13.3543L21.2056 14.2446V14.2851Z"
                    fill="currentColor"
                />
                <path
                    d="M62.422 2.72754L63.924 0.728444L66.3547 -3.25357L66.5485 -3.06742L65.9671 -0.485584L64.9254 1.7887L64.6589 2.99463L64.2067 4.19247L65.3372 3.62593L67.5337 2.83276L69.1326 2.04769L71.1353 1.08456L71.1111 1.14121L67.9294 3.286L65.0223 5.76262L68.8661 6.70146L72.7503 7.10614L72.7019 7.62413L68.8823 7.70506L65.103 7.99643L67.784 10.3516L70.0855 13.1277L70.1178 13.1682L67.025 11.2581L63.9321 9.7851L64.8123 13.322L65.9913 16.9883L65.4906 17.0935L63.4557 13.8561L61.9052 10.2788L61.8244 11.1853L61.2834 12.4479L59.9348 16.2356L59.3938 17.9434L58.9739 17.9029L59.0627 15.6367L59.4019 12.7554L59.7249 11.2905L59.7814 9.99553L58.029 11.2743L56.2848 12.634L54.589 14.0342L53.7734 14.706L53.628 14.6655L54.3952 13.7428L55.2754 12.286L56.1717 11.5576L58.1421 8.4092L54.5244 8.85434L50.7693 9.26711L50.6159 8.73294L54.3306 7.94787L56.3978 7.00902L57.4073 6.58006L56.7451 5.72215L54.4355 4.76711L51.0843 3.04319L51.1973 2.71136L54.8878 3.44787L58.7801 4.54049L56.7612 1.09265L54.702 -2.08001L54.9847 -2.29853L57.5284 0.55848L60.1771 3.13222L60.4759 -0.655549L60.5082 -4.59709L60.492 -4.589H60.6212L61.1623 -3.64206L61.4449 -1.55393L61.8325 0.631322L62.2121 1.67539L62.4301 2.69517L62.422 2.72754Z"
                    fill="currentColor"
                />
                <path
                    d="M2.99579 -7.78595L4.50587 -9.78505L6.92846 -13.7752L7.12227 -13.5809L6.54085 -10.9991L5.49913 -8.73289L5.23265 -7.52696L4.78851 -6.32102L5.91905 -6.89566L8.10746 -7.68883L9.70637 -8.4739L11.7171 -9.43703L11.6929 -9.38037L8.51123 -7.23559L5.60411 -4.75897L9.43989 -3.82012L13.3322 -3.41544L13.2837 -2.88937L9.46411 -2.81652L5.67679 -2.52516L8.36587 -0.169942L10.6673 2.60614L10.6996 2.6466L7.60679 0.736533L4.51394 -0.736489L5.38608 2.80038L6.57315 6.46675L6.07248 6.58005L4.0375 3.33455L2.48704 -0.242784L2.40629 0.663691L1.86524 1.92628L0.516666 5.71405L-0.0243808 7.42178L-0.444297 7.38941L-0.363544 5.11513L-0.016305 2.24193L0.306708 0.768907L0.363234 -0.526057L-1.39718 0.760813L-3.13338 2.11243L-4.82919 3.5207L-5.6448 4.19247L-5.79015 4.152L-5.023 3.22124L-4.14279 1.76441L-3.24643 1.04409L-1.27605 -2.11239L-4.89379 -1.65915L-8.64882 -1.25447L-8.80225 -1.78865L-5.0876 -2.57372L-3.02032 -3.51257L-2.01091 -3.94152L-2.68116 -4.79944L-4.98262 -5.75447L-8.34195 -7.47839L-8.22082 -7.81023L-4.53041 -7.07372L-0.638105 -5.973L-2.65693 -9.42893L-4.72421 -12.5935L-4.4335 -12.8201L-1.88978 -9.96311L0.758925 -7.38937L1.05771 -11.169L1.09001 -15.1187L1.07386 -15.1106H1.19499L1.74411 -14.1636L2.02675 -12.0755L2.40629 -9.89026L2.7939 -8.83811L3.01194 -7.82642L2.99579 -7.78595Z"
                    fill="currentColor"
                />
                <path
                    d="M42.7182 18.5261L43.9376 20.4038L42.9363 22.4191L42.6133 24.5882L41.7411 25.0333L40.764 25.786L39.1005 27.2266L36.9525 26.6034L34.7964 26.5953L33.3751 24.9847L31.8166 23.5117L31.647 21.3831L31.3886 19.2221L32.2042 18.4047L32.939 17.3202L33.9485 15.6448L36.0723 15.3939L38.0992 14.5603L39.9484 15.75L41.9753 16.5027L42.7182 18.5261Z"
                    fill="currentColor"
                />
                <path
                    d="M19.7924 -1.19781L21.9163 -1.99098L24.1531 -2.68702L26.1881 -3.47209L26.3819 -3.48828L25.2352 -1.44871L24.1935 0.655603L23.9028 1.88582L23.4829 3.58546L25.0656 7.13851L25.5905 9.27521L25.5824 9.24283L23.6605 8.35254L21.4721 7.48654L19.4614 6.2806L17.2083 6.96855L15.1088 8.02071L12.9446 8.84625L12.8638 8.67628L13.9217 6.68528L14.9473 4.58096L15.9647 2.47665L15.0199 0.339955L14.3093 -1.90195L13.3645 -3.80393L13.4856 -4.07102L15.5125 -2.92983L17.7332 -2.13666L19.7924 -1.19781Z"
                    fill="currentColor"
                />
                <path
                    d="M9.48026 26.7006L9.22993 28.9586L8.83424 31.2734L8.6162 33.4506L8.54353 33.6367L7.2434 31.6781L5.84637 29.8004L4.87733 28.9829L3.56106 27.8417L-0.315094 27.6475L-2.45505 27.1538H-2.42275L-0.767311 25.8346L0.993107 24.2806L2.97963 23.0261L3.39147 20.7033L3.39955 18.348L3.64181 16.0414L3.82754 16.0495L5.11959 17.8948L7.94595 21.6178L10.2797 21.7392L12.5973 22.1196L14.7131 22.1358L14.8907 22.3624L12.9607 23.6655L11.2488 25.2842L9.48026 26.7006Z"
                    fill="currentColor"
                />
                <path
                    d="M11.3941 9.70416L12.6216 11.5819L11.6121 13.5971L11.2972 15.7662L10.4251 16.2114L9.44796 16.9641L7.78445 18.4047L5.63642 17.7815L3.48031 17.7734L2.05098 16.1628L0.500516 14.6898L0.32286 12.5612L0.0725252 10.4002L0.880056 9.58276L1.61491 8.49823L2.6324 6.82287L4.74813 6.57197L6.78311 5.73834L8.63236 6.92809L10.6512 7.68078L11.3941 9.70416Z"
                    fill="currentColor"
                />
                <path
                    d="M65.5229 34.1142L63.6414 35.3202L61.6387 34.2923L59.4826 33.9524L59.0465 33.0702L58.3036 32.0828L56.8823 30.3993L57.5284 28.2545L57.5607 26.0935L59.1838 24.6772L60.6697 23.1394L62.7935 22.9856L64.9496 22.759L65.7571 23.5765L66.8311 24.3292L68.4946 25.357L68.7208 27.4856L69.5283 29.5333L68.3251 31.3705L67.5579 33.3939L65.5229 34.1142Z"
                    fill="currentColor"
                />
                <path
                    d="M50.9308 9.82557L51.7868 11.8975L50.4221 13.6943L49.7115 15.7662L48.7667 16.0333L47.6684 16.5918L45.7707 17.7087L43.7761 16.6889L41.6604 16.2842L40.5541 14.4308L39.3024 12.6988L39.5204 10.5702L39.6739 8.40111L40.6187 7.74553L41.5473 6.82287L42.8475 5.36603L44.9793 5.51172L47.1274 5.06657L48.7263 6.58006L50.5755 7.69697L50.9308 9.82557Z"
                    fill="currentColor"
                />
                <path
                    d="M15.0926 39.6421L12.8719 39.9254L11.4991 38.1448L9.69022 36.9146L9.67407 35.9353L9.41566 34.7212L8.84231 32.6007L10.3443 30.9335L11.2891 28.991L13.3564 28.4002L15.351 27.6394L17.3456 28.4083L19.3887 29.1205L19.7763 30.2051L20.4304 31.3462L21.4963 32.9892L20.7938 35.0045L20.6646 37.206L18.7911 38.3552L17.2326 39.8525L15.0926 39.6421Z"
                    fill="currentColor"
                />
                <path
                    d="M51.5284 35.5711L53.2646 37.3678L56.8258 40.3786L56.6078 40.5405L54.1529 39.5693L52.0775 38.1934L50.9228 37.7482L49.8084 37.1169L50.2041 38.3229L50.6482 40.6133L51.1731 42.3211L51.8191 44.4577L51.7626 44.4254L50.1395 40.9452L48.1368 37.6835L46.6267 41.3498L45.6334 45.1376L45.1247 45.0081L45.6334 41.2122L45.9241 37.4245L43.1947 39.7149L40.1018 41.5684L40.0615 41.6007L42.4114 38.8327L44.3414 35.9919L40.7236 36.3157L36.9202 36.9308L36.8959 36.4128L40.4006 34.8993L44.1637 33.9038L43.2835 33.6934L42.1207 32.9569L38.5918 31.0468L36.9848 30.2455L37.0897 29.8327L39.3185 30.2698L42.0964 31.0468L43.5015 31.5971L44.7694 31.848L43.7761 29.9137L42.7021 27.9793L41.0386 25.1709L41.1032 25.0414L41.8946 25.9398L43.1947 27.0324L43.7761 28.0279L46.5863 30.464L46.6913 26.8139L46.869 23.0342L47.41 22.9613L47.62 26.7653L48.2256 28.9506L48.5002 30.0189L49.445 29.4928L50.7451 27.3561L52.9577 24.2887L53.2646 24.4587L51.9725 28.0036L50.2929 31.6862L54.0075 30.2131L57.4476 28.6592L57.6253 28.9748L54.4113 31.0549L51.48 33.2887L55.1623 34.1628L59.0465 34.8022L59.0384 34.7779L59.0223 34.9074L58.0048 35.304L55.9052 35.2554L53.6845 35.3121L52.5943 35.5306L51.5607 35.5872L51.5284 35.5711Z"
                    fill="currentColor"
                />
                <path
                    d="M102.904 19.5783L103.824 17.4982L104.906 15.4101L105.762 13.4029L105.891 13.2491L106.537 15.5072L107.305 17.7248L107.983 18.7932L108.895 20.2824L112.537 21.6421L114.427 22.759L114.395 22.7428L112.416 23.5036L110.268 24.4587L107.999 25.0495L106.909 27.1376L106.19 29.3795L105.262 31.5081L105.084 31.4434L104.414 29.2905L103.622 27.089L102.839 24.8876L100.659 24.0621L98.559 23.0018L96.5483 22.3462L96.4433 22.0792L98.6802 21.4236L100.796 20.3957L102.904 19.5783Z"
                    fill="currentColor"
                />
                <path
                    d="M132.104 17.6925L133.897 16.3004L135.827 14.9731L137.539 13.6133L137.716 13.5405L137.224 15.8391L136.852 18.1538L136.941 19.4164L137.038 21.1565L139.606 24.0783L140.744 25.9641L140.712 25.9398L138.621 25.6646L136.279 25.4865L133.994 24.9281L132.047 26.2554L130.352 27.8822L128.535 29.3148L128.405 29.1772L128.833 26.9596L129.181 24.6448L129.536 22.3301L128.002 20.5738L126.653 18.6394L125.191 17.1016L125.224 16.8184L127.509 17.304L129.859 17.4011L132.104 17.6925Z"
                    fill="currentColor"
                />
                <path
                    d="M117.568 -2.75177L119.829 -2.85699L122.179 -2.82461L124.352 -2.95411L124.545 -2.90555L122.817 -1.31922L121.186 0.364236L120.532 1.44877L119.619 2.92988L120.031 6.79859L119.878 9.00003V8.95956L118.319 7.527L116.51 6.0297L114.96 4.25722L112.61 4.21675L110.284 4.57287L107.975 4.69427L107.951 4.50812L109.566 2.94607L111.189 1.24643L112.804 -0.437023L112.554 -2.75987L112.57 -5.11508L112.255 -7.2194L112.441 -7.42983L114.031 -5.714L115.897 -4.28145L117.568 -2.75177Z"
                    fill="currentColor"
                />
                <path
                    d="M97.6223 -5.00177L95.442 -6.23199L91.1863 -8.11778L91.3478 -8.3363L93.9723 -8.0935L96.3626 -7.36508L97.59 -7.25987L98.8336 -6.97659L98.123 -8.02066L97.049 -10.0926L96.0557 -11.5818L94.8363 -13.4433L94.9009 -13.4271L97.4446 -10.5539L100.279 -7.98828L100.699 -11.9298L100.586 -15.8471L101.111 -15.8633L101.692 -12.0836L102.476 -8.36058L104.454 -11.339L106.893 -13.9937L106.925 -14.0261L105.447 -10.7077L104.397 -7.43792L107.781 -8.77335L111.253 -10.4325L111.423 -9.94692L108.484 -7.50267L105.157 -5.48738L106.061 -5.52785L107.385 -5.15555L111.302 -4.31382L113.07 -4.00627L113.087 -3.58541L110.825 -3.36688L107.943 -3.32641L106.441 -3.45591L105.157 -3.3426L106.659 -1.76436L108.225 -0.218499L109.84 1.2869L110.615 2.00722L110.591 2.1529L109.574 1.51351L108.015 0.833659L107.183 0.0404934L103.8 -1.49728L104.729 2.0315L105.625 5.70596L105.116 5.93258L103.848 2.33905L102.653 0.412796L102.088 -0.534147L101.329 0.242831L100.691 2.66279L99.4312 6.22395L99.0839 6.1511L99.3262 2.38762L99.8995 -1.62677L96.7502 0.833659L93.8915 3.30218L93.6331 3.04319L96.1203 0.145709L98.3168 -2.82461L94.5295 -2.63037L90.621 -2.13666L90.6372 -2.12048L90.621 -2.24188L91.4851 -2.91364L93.512 -3.464L95.6196 -4.13577L96.6129 -4.65375L97.5819 -5.00987L97.6223 -5.00177Z"
                    fill="currentColor"
                />
                <path
                    d="M115.703 12.5693L117.399 11.1124L119.531 11.8409L121.711 11.8651L122.268 12.6826L123.14 13.5486L124.788 15.0054L124.457 17.2311L124.731 19.3678L123.326 21.0027L122.082 22.7347L119.991 23.188L117.891 23.7302L116.979 23.0342L115.808 22.4434L114.015 21.6664L113.49 19.5864L112.392 17.6844L113.321 15.6853L113.797 13.581L115.703 12.5693Z"
                    fill="currentColor"
                />
                <path
                    d="M108.225 5.18798L110.163 4.06298L112.118 5.17988L114.257 5.60884L114.653 6.51531L115.348 7.5351L116.696 9.27521L115.953 11.3876L115.832 13.5405L114.152 14.884L112.602 16.357L110.47 16.4218L108.306 16.5594L107.531 15.7015L106.489 14.9083L104.874 13.7995L104.745 11.6628L104.018 9.59085L105.302 7.80218L106.166 5.81927L108.225 5.18798Z"
                    fill="currentColor"
                />
                <path
                    d="M140.389 37.1412L140.963 39.3022L139.38 40.9047L138.403 42.8633L137.434 43.009L136.271 43.4218L134.244 44.2797L132.395 43.009L130.352 42.3292L129.496 40.3462L128.478 38.4685L128.979 36.3885L129.407 34.2599L130.432 33.7338L131.474 32.9326L132.952 31.6538L135.051 32.0828L137.24 31.929L138.621 33.6367L140.308 34.9802L140.389 37.1412Z"
                    fill="currentColor"
                />
                <path
                    d="M131.539 1.48114L133.089 -0.485584L135.601 -4.42713L135.786 -4.22479L135.148 -1.65915L134.066 0.590854L133.775 1.7887L133.299 2.97844L134.438 2.42808L136.65 1.68348L138.265 0.938876L140.292 0.0162138L140.268 0.0728682L137.038 2.14481L134.082 4.56477L137.902 5.58456L141.778 6.07017L141.722 6.58816H137.902L134.115 6.79859L136.747 9.21046L138.984 12.0351L139.016 12.0756L135.972 10.1007L132.911 8.56297L133.711 12.116L134.817 15.8067L134.308 15.9038L132.346 12.6259L130.868 9.01621L130.771 9.91459L130.206 11.1691L128.777 14.9245L128.195 16.6241L127.776 16.5756L127.913 14.3094L128.317 11.4443L128.672 9.97934L128.753 8.68438L126.968 9.93078L125.2 11.25L123.471 12.6178L122.648 13.2734L122.502 13.2329L123.286 12.3184L124.198 10.8777L125.111 10.1736L127.146 7.06567L123.52 7.43798L119.757 7.76981L119.619 7.23564L123.35 6.52341L125.434 5.63312L126.451 5.22035L125.805 4.34625L123.52 3.34265L120.201 1.55398L120.322 1.22215L123.996 2.03959L127.864 3.21316L125.918 -0.275152L123.924 -3.48828L124.214 -3.70681L126.693 -0.793139L129.294 1.82916L129.673 -1.94242L129.786 -5.89206L129.77 -5.87587H129.891L130.416 -4.92084L130.658 -2.82461L130.998 -0.631268L131.353 0.42089L131.555 1.44067L131.539 1.48114Z"
                    fill="currentColor"
                />
                <path
                    d="M86.5026 108.162L85.8404 105.993L85.2752 103.71L84.613 101.63L84.6049 101.428L86.5753 102.707L88.6022 103.872L89.8216 104.228L91.477 104.746L95.1109 103.379L97.2751 102.966L97.2347 102.982L96.2495 104.852L95.2562 106.988L93.9319 108.931L94.481 111.221L95.4097 113.39L96.1041 115.6L95.9265 115.673L94.0126 114.491L91.9696 113.35L89.9346 112.201L87.7543 113.026L85.477 113.609L83.5228 114.434L83.2725 114.305L84.5322 112.338L85.4447 110.169L86.5026 108.162Z"
                    fill="currentColor"
                />
                <path
                    d="M104.519 111.496L106.473 110.347L108.556 109.279L110.43 108.146L110.615 108.097L109.832 110.315L109.17 112.565L109.097 113.827L108.976 115.567L111.148 118.797L112.037 120.812L112.013 120.78L109.969 120.237L107.668 119.76L105.48 118.918L103.38 119.987L101.49 121.387L99.5039 122.576L99.3989 122.423L100.093 120.278L101.385 115.778L100.085 113.835L98.9951 111.755L97.7354 110.04L97.808 109.764L100.013 110.533L102.322 110.93L104.519 111.496Z"
                    fill="currentColor"
                />
                <path
                    d="M116.704 105.774L118.489 104.39L120.427 103.063L122.139 101.703L122.317 101.63L121.824 103.921L121.444 106.236L121.541 107.506L121.638 109.246L124.198 112.168L125.337 114.054L125.313 114.03L123.221 113.755L120.871 113.576L118.594 113.018L116.648 114.337L114.952 115.972L113.135 117.405L113.006 117.267L113.426 115.049L114.136 110.42L112.594 108.664L111.253 106.729L109.792 105.192L109.824 104.908L112.109 105.394L114.451 105.491L116.704 105.774Z"
                    fill="currentColor"
                />
                <path
                    d="M103.856 81.5747L106.118 81.4694L108.459 81.5018L110.64 81.3723L110.834 81.4209L109.105 83.0072L107.474 84.6907L106.82 85.7752L105.908 87.2563L106.319 91.125L106.166 93.3264V93.286L104.607 91.8534L102.791 90.3561L101.248 88.5836L98.8982 88.5432L96.5725 88.8993L94.263 89.0207L94.2388 88.8345L95.8538 87.2725L97.4769 85.5729L99.092 83.8894L98.8417 81.5666L98.8498 79.2113L98.5429 77.107L98.7286 76.8966L100.319 78.6124L102.185 80.045L103.856 81.5747Z"
                    fill="currentColor"
                />
                <path
                    d="M82.5538 80.3444L80.3815 79.1061L76.1178 77.2284L76.2793 77.0099L78.9118 77.2446L81.294 77.9811L82.5215 78.0863L83.7651 78.3696L83.0545 77.3256L81.9804 75.2536L80.9952 73.7644L79.7759 71.9029L79.8405 71.9191L82.3761 74.7923L85.2106 77.3579L85.6305 73.4164L85.5174 69.4991L86.0423 69.4829L86.6237 73.2626L87.407 76.9856L89.3855 74.0072L91.8242 71.3525L91.8565 71.3121L90.3788 74.6385L89.329 77.9083L92.7125 76.5729L96.1849 74.9137L96.3545 75.3912L93.4232 77.8435L90.088 79.8588L90.9925 79.8184L92.3168 80.1907L96.2414 81.0243L98.0019 81.3399L98.018 81.7608L95.765 81.9712L92.874 82.0117L91.372 81.8903L90.088 82.0036L91.5901 83.5738L93.1647 85.1277L94.7717 86.6331L95.547 87.3534L95.5227 87.4991L94.5053 86.8597L92.9467 86.1799L92.1149 85.3867L88.7314 83.8408L89.6601 87.3777L90.5564 91.0522L90.0557 91.2707L88.7799 87.6853L87.5847 85.759L87.0275 84.8121L86.2603 85.589L85.6224 88.0009L84.3626 91.5702L84.0154 91.4892L84.2657 87.7338L84.831 83.7194L81.6816 86.1799L78.823 88.6484L78.5646 88.3894L81.0518 85.4919L83.2483 82.5135L79.469 82.7158L75.5606 83.2095L75.5767 83.2257L75.5525 83.0962L76.4165 82.4326L78.4435 81.8822L80.5592 81.2024L81.5444 80.6844L82.5215 80.3363L82.5538 80.3444Z"
                    fill="currentColor"
                />
                <path
                    d="M108.023 99.8741L109.832 101.201L109.598 103.443L110.058 105.58L109.396 106.3L108.75 107.353L107.7 109.295L105.472 109.465L103.453 110.218L101.547 109.214L99.5765 108.38L98.664 106.446L97.6708 104.52L98.1391 103.468L98.446 102.189L98.8094 100.271L100.707 99.2833L102.314 97.786L104.462 98.2473L106.618 98.2392L108.023 99.8741Z"
                    fill="currentColor"
                />
                <path
                    d="M104.995 68.366L106.432 70.0819L105.681 72.2024L105.633 74.3957L104.817 74.938L103.937 75.804L102.459 77.447L100.255 77.0828L98.1149 77.3336L96.4998 75.9173L94.7798 74.6385L94.3518 72.5504L93.835 70.438L94.5375 69.5234L95.1351 68.3579L95.9426 66.5693L98.018 66.0675L99.9318 64.991L101.91 65.9461L104.01 66.4479L104.995 68.366Z"
                    fill="currentColor"
                />
                <path
                    d="M87.7624 96.8795L87.1082 94.7347L88.6345 93.0756L89.5389 91.0845L90.4999 90.8984L91.6466 90.4452L93.6412 89.5225L95.5389 90.7284L97.6062 91.3274L98.5267 93.2698L99.6169 95.1151L99.1889 97.2113L98.8417 99.3561L97.8323 99.9227L96.8309 100.756L95.3935 102.084L93.2859 101.736L91.1055 101.97L89.652 100.319L87.9158 99.0324L87.7624 96.8795Z"
                    fill="currentColor"
                />
                <path
                    d="M159.705 114.815L159.326 117.057L158.801 119.347L158.47 121.508L158.389 121.686L157.194 119.663L155.902 117.704L154.981 116.838L153.73 115.624L149.87 115.219L147.754 114.612H147.794L149.514 113.39L151.364 111.925L153.415 110.784L153.948 108.494L154.093 106.139L154.456 103.848L154.642 103.864L155.829 105.782L157.145 107.725L158.446 109.659L160.763 109.91L163.057 110.412L165.172 110.549L165.342 110.776L163.339 111.974L161.546 113.496L159.705 114.815Z"
                    fill="currentColor"
                />
                <path
                    d="M168.023 133.843L168.943 135.915L169.759 138.116L170.664 140.107L170.696 140.301L168.588 139.265L166.44 138.351L165.188 138.132L163.485 137.808L160.036 139.597L157.937 140.253L157.969 140.237L158.736 138.262L159.471 136.028L160.561 133.94L159.746 131.73L158.575 129.691L157.63 127.578L157.791 127.481L159.835 128.428L164.147 130.225L166.222 129.156L168.411 128.315L170.252 127.255L170.518 127.36L169.501 129.464L168.838 131.722L168.023 133.843Z"
                    fill="currentColor"
                />
                <path
                    d="M136.553 91.5459L137.797 93.4479L138.968 95.4793L140.187 97.3004L140.244 97.4865L137.999 96.8067L135.73 96.2563L134.462 96.2482L132.718 96.2158L129.609 98.5468L127.646 99.5423L127.679 99.518L128.115 97.4461L128.478 95.1151L129.205 92.8813L128.042 90.8336L126.548 89.0126L125.264 87.0863L125.409 86.9649L127.582 87.5639L129.859 88.0899L132.128 88.6241L134.002 87.2239L136.028 86.0342L137.668 84.6907L137.95 84.7473L137.288 86.9892L137.006 89.3282L136.553 91.5459Z"
                    fill="currentColor"
                />
                <path
                    d="M139.84 131.981L139.21 134.158L138.427 136.376L137.845 138.48L137.74 138.65L136.796 136.505L135.738 134.409L134.914 133.446L133.816 132.094L130.02 131.245L127.994 130.395L128.034 130.403L129.883 129.383L131.886 128.145L134.058 127.246L134.85 125.029L135.261 122.714L135.891 120.48L136.077 120.521L137.03 122.552L138.112 124.632L139.186 126.712L141.463 127.222L143.684 127.991L145.767 128.371L145.905 128.622L143.781 129.577L141.827 130.88L139.84 131.981Z"
                    fill="currentColor"
                />
                <path
                    d="M186.136 124.487L188.599 124.915L193.25 125.247L193.169 125.506L190.61 126.17L188.122 126.283L186.927 126.599L185.659 126.753L186.685 127.497L188.389 129.084L189.818 130.152L191.595 131.496L191.53 131.504L188.171 129.65L184.642 128.193L185.571 132.046L186.992 135.704L186.507 135.89L184.69 132.531L182.704 129.294L181.84 132.758L180.435 136.085L180.41 136.133L180.685 132.507L180.58 129.076L177.842 131.471L175.129 134.207L174.806 133.81L176.752 130.516L179.207 127.489L178.367 127.837L177.003 127.934L173.03 128.469L171.261 128.768L171.1 128.379L173.159 127.416L175.864 126.397L177.318 126.016L178.488 125.466L176.542 124.495L174.548 123.564L172.521 122.698L171.552 122.277L171.519 122.131L172.699 122.39L174.386 122.504L175.444 122.973L179.143 123.281L177.083 120.27L175.008 117.105L175.404 116.725L177.81 119.679L179.587 121.087L180.427 121.791L180.887 120.804L180.677 118.311L180.669 114.531L181.016 114.483L182.05 118.109L182.865 122.083L184.997 118.7L186.863 115.406L187.194 115.567L185.821 119.137L184.755 122.674L188.252 121.209L191.764 119.428L191.74 119.42L191.805 119.533L191.215 120.448L189.495 121.654L187.727 123.005L186.976 123.823L186.176 124.487H186.136Z"
                    fill="currentColor"
                />
                <path
                    d="M149.07 131.746L146.922 131.107L146.389 128.914L145.234 127.06L145.614 126.154L145.872 124.94L146.211 122.763L148.255 121.848L149.902 120.456L152.026 120.763L154.166 120.877L155.668 122.39L157.258 123.871L157.17 125.021L157.307 126.324L157.614 128.258L156.16 129.828L155.151 131.779L152.971 132.07L150.944 132.807L149.07 131.746Z"
                    fill="currentColor"
                />
                <path
                    d="M184.618 107.862L185.28 105.726L187.476 105.208L189.334 104.075L190.238 104.463L191.441 104.738L193.614 105.094L194.502 107.158L195.867 108.826L195.544 110.954L195.406 113.091L193.88 114.58L192.386 116.158L191.239 116.053L189.939 116.183L188.001 116.466L186.459 114.993L184.521 113.957L184.254 111.772L183.536 109.732L184.618 107.862Z"
                    fill="currentColor"
                />
                <path
                    d="M169.945 119.914L171.285 121.71L170.405 123.782L170.227 125.968L169.38 126.461L168.451 127.279L166.884 128.825L164.696 128.331L162.548 128.46L161.022 126.939L159.382 125.571L159.075 123.451L158.688 121.314L159.447 120.448L160.109 119.315L161.014 117.583L163.121 117.202L165.092 116.239L167.013 117.308L169.081 117.939L169.945 119.914Z"
                    fill="currentColor"
                />
                <path
                    d="M130.4 111.059L128.325 111.885L126.548 110.493L124.497 109.756L124.239 108.801L123.697 107.692L122.615 105.774L123.657 103.791L124.093 101.679L125.95 100.594L127.703 99.3642L129.819 99.6151L131.983 99.7932L132.621 100.756L133.533 101.695L134.971 103.022L134.793 105.159L135.197 107.32L133.671 108.898L132.532 110.736L130.4 111.059Z"
                    fill="currentColor"
                />
                <path
                    d="M117.673 122.496L116.405 120.658L117.35 118.611L117.617 116.442L118.481 115.972L119.434 115.195L121.057 113.706L123.221 114.281L125.377 114.232L126.847 115.802L128.438 117.235L128.664 119.355L128.979 121.508L128.187 122.35L127.485 123.451L126.516 125.15L124.4 125.458L122.389 126.348L120.508 125.207L118.473 124.503L117.673 122.496Z"
                    fill="currentColor"
                />
                <path
                    d="M140.866 119.153L140.066 121.532L139.033 126.081L138.79 125.96L138.524 123.329L138.79 120.844L138.661 119.614L138.701 118.335L137.813 119.234L135.988 120.683L134.72 121.937L133.121 123.491V123.426L135.463 120.383L137.442 117.105L133.501 117.437L129.681 118.287L129.568 117.777L133.162 116.49L136.658 115.017L133.364 113.633L130.311 111.731L130.263 111.707L133.8 112.532L137.199 112.945L135.245 109.87L132.968 106.77L133.412 106.503L136.36 108.931L138.968 111.836L138.758 110.946L138.871 109.578L138.952 105.564L138.919 103.767L139.331 103.67L139.969 105.847L140.551 108.688L140.712 110.185L141.067 111.432L142.327 109.651L143.547 107.814L144.718 105.944L145.275 105.046L145.428 105.038L144.992 106.163L144.621 107.822L143.999 108.793L143.127 112.411L146.413 110.833L149.845 109.254L150.16 109.708L146.882 111.642L145.218 113.18L144.403 113.916L145.307 114.515L147.794 114.685L151.525 115.26L151.509 115.608L147.786 116.077L143.74 116.28L146.753 118.91L149.708 121.257L149.506 121.565L146.187 119.663L142.868 118.06L143.773 121.743L145 125.498L145.008 125.482L144.887 125.522L144.072 124.802L143.151 122.908L142.093 120.958L141.391 120.084L140.866 119.193V119.153Z"
                    fill="currentColor"
                />
                <path
                    d="M121.396 140.706L120.605 143.077L119.563 147.626L119.321 147.513L119.054 144.874L119.321 142.389L119.191 141.167L119.24 139.88L118.344 140.787L116.519 142.236L115.251 143.482L113.652 145.036V144.971L115.994 141.928L117.972 138.658L114.031 138.99L110.212 139.84L110.099 139.33L113.692 138.043L117.189 136.562L113.902 135.178L110.842 133.284L110.793 133.252L114.33 134.077L117.73 134.49L115.784 131.423L113.498 128.315L113.943 128.056L116.89 130.484L119.498 133.381L119.288 132.499L119.401 131.123L119.482 127.109L119.45 125.312L119.862 125.215L120.5 127.4L121.089 130.233L121.243 131.73L121.598 132.977L122.858 131.204L124.077 129.359L125.248 127.489L125.805 126.591H125.959L125.523 127.708L125.151 129.367L124.529 130.346L123.657 133.956L126.944 132.386L130.376 130.808L130.691 131.261L127.42 133.187L125.757 134.733L124.933 135.461L125.837 136.06L128.325 136.238L132.055 136.805L132.047 137.153L128.317 137.63L124.271 137.825L127.283 140.455L130.238 142.81L130.037 143.11L126.726 141.208L123.399 139.613L124.311 143.296L125.531 147.051L125.539 147.027L125.418 147.067L124.602 146.347L123.681 144.461L122.623 142.511L121.929 141.637L121.396 140.738V140.706Z"
                    fill="currentColor"
                />
                <path
                    d="M195.019 54.5908L195.891 56.6871L196.658 58.9047L197.522 60.9119L197.546 61.1142L195.463 60.0297L193.331 59.0666L192.095 58.8238L190.392 58.4676L186.903 60.1754L184.787 60.7905L184.828 60.7743L185.635 58.8157L186.418 56.598L187.549 54.5342L186.782 52.3085L185.659 50.2365L184.755 48.1079L184.925 48.0189L186.943 49.0063L189.083 49.9533L191.215 50.8921L193.315 49.8723L195.519 49.0711L197.385 48.0594L197.651 48.1646L196.585 50.2446L195.883 52.4946L195.019 54.5908Z"
                    fill="currentColor"
                />
                <path
                    d="M170.187 70.9398L168.968 72.8498L167.587 74.7518L166.44 76.6133L166.295 76.7428L165.988 74.4119L165.56 72.1052L165.051 70.9479L164.373 69.3372L160.973 67.4515L159.269 66.0594L159.302 66.0836L161.369 65.6304L163.638 65.0072L165.972 64.7563L167.361 62.8543L168.402 60.75L169.638 58.7914L169.808 58.8804L170.147 61.1061L170.599 63.4047L171.043 65.6952L173.078 66.8363L174.992 68.2041L176.89 69.1592L176.954 69.4344L174.645 69.75L172.4 70.4461L170.187 70.9398Z"
                    fill="currentColor"
                />
                <path
                    d="M191.256 85.9209L189.64 87.5153L187.88 89.0612L186.346 90.6151L186.168 90.7122L186.386 88.3732L186.483 86.0261L186.241 84.7797L185.942 83.0639L183.051 80.4658L181.694 78.7338L181.719 78.7581L183.834 78.7743L186.184 78.6772L188.518 78.9524L190.287 77.4065L191.78 75.5854L193.412 73.9506L193.557 74.072L193.404 76.322L193.331 78.661L193.25 81L194.986 82.5621L196.553 84.3184L198.184 85.67V85.9613L195.867 85.7509L193.517 85.929L191.256 85.9209Z"
                    fill="currentColor"
                />
                <path
                    d="M192.879 99.8984L190.924 101.04L188.841 102.108L186.968 103.233L186.782 103.29L187.565 101.072L188.235 98.83L188.308 97.5594L188.429 95.8193L186.265 92.5899L185.377 90.5747L185.401 90.607L187.444 91.1493L189.745 91.6268L191.934 92.4766L194.033 91.4083L195.923 90.0162L197.91 88.8265L198.023 88.9802L197.32 91.125L196.028 95.625L197.32 97.5675L198.402 99.6556L199.662 101.371L199.589 101.647L197.393 100.87L195.075 100.465L192.879 99.8984Z"
                    fill="currentColor"
                />
                <path
                    d="M174.475 116.377L172.23 116.684L169.896 116.862L167.74 117.178L167.546 117.154L169.121 115.414L170.599 113.593L171.148 112.451L171.931 110.897L171.18 107.077L171.132 104.876L171.14 104.916L172.82 106.203L174.758 107.539L176.454 109.157L178.803 108.987L181.081 108.429L183.374 108.105L183.414 108.291L181.945 109.991L179.021 113.649L179.474 115.94L179.667 118.287L180.168 120.351L179.999 120.577L178.262 119.015L176.284 117.753L174.475 116.377Z"
                    fill="currentColor"
                />
                <path
                    d="M183.729 66.5126L182.623 68.4631L180.378 68.4955L178.311 69.2077L177.519 68.6331L176.397 68.107L174.354 67.2896L173.926 65.0881L172.949 63.1619L173.716 61.1547L174.314 59.0989L176.122 57.9658L177.923 56.7437L179.021 57.0917L180.314 57.2536L182.268 57.3831L183.463 59.1556L185.134 60.5881L184.925 62.7815L185.183 64.9263L183.729 66.5126Z"
                    fill="currentColor"
                />
                <path
                    d="M176.316 97.5189L176.978 95.3741L179.167 94.8642L181.032 93.723L181.937 94.1196L183.132 94.3867L185.304 94.7509L186.192 96.8067L187.565 98.4739L187.242 100.603L187.105 102.739L185.579 104.237L184.085 105.807L182.938 105.71L181.63 105.831L179.7 106.122L178.149 104.641L176.219 103.605L175.945 101.42L175.234 99.3804L176.316 97.5189Z"
                    fill="currentColor"
                />
                <path
                    d="M192.879 74.9218L191.433 76.6295L189.213 76.241L187.056 76.5567L186.378 75.8444L185.377 75.116L183.527 73.9344L183.511 71.6925L182.906 69.6205L184.036 67.7914L184.997 65.8813L186.984 65.1043L188.978 64.2383L189.996 64.7887L191.239 65.1853L193.129 65.679L193.977 67.6457L195.35 69.3615L194.744 71.4739L194.599 73.6349L192.879 74.9218Z"
                    fill="currentColor"
                />
                <path
                    d="M196.262 26.9029L194.817 28.6187L192.596 28.2302L190.44 28.5378L189.762 27.8256L188.768 27.1052L186.911 25.9236L186.895 23.6736L186.289 21.6016L187.42 19.7725L188.389 17.8624L190.375 17.0855L192.362 16.2275L193.379 16.7698L194.623 17.1664L196.521 17.6601L197.361 19.6268L198.741 21.3426L198.128 23.4551L197.99 25.616L196.262 26.9029Z"
                    fill="currentColor"
                />
                <path
                    d="M155.934 61.5837L154.666 59.7464L155.611 57.6988L155.878 55.5297L156.742 55.0603L157.695 54.2833L159.318 52.7941L161.482 53.3687L163.638 53.3121L165.108 54.8903L166.699 56.3148L166.925 58.4434L167.24 60.5962L166.448 61.438L165.738 62.5387L164.769 64.2383L162.661 64.5459L160.65 65.4281L158.769 64.295L156.726 63.5908L155.934 61.5837Z"
                    fill="currentColor"
                />
                <path
                    d="M175.234 86.9164L174.435 89.2959L173.401 93.8444L173.151 93.723L172.892 91.0926L173.159 88.6079L173.03 87.3777L173.07 86.0989L172.182 86.9973L170.357 88.4461L169.081 89.7006L167.49 91.2545V91.1898L169.832 88.1466L171.802 84.8687L167.861 85.2005L164.05 86.0504L163.929 85.5405L167.522 84.2536L171.027 82.7806L167.732 81.3966L164.672 79.4946L164.631 79.4622L168.16 80.2959L171.56 80.7086L169.614 77.6331L167.336 74.5333L167.773 74.2662L170.728 76.6943L173.328 79.5917L173.118 78.7095L173.231 77.3417L173.32 73.3193L173.288 71.5225L173.7 71.4335L174.338 73.6106L174.919 76.4434L175.081 77.9488L175.436 79.1871L176.696 77.4146L177.915 75.5774L179.078 73.7077L179.643 72.8094L179.789 72.8013L179.361 73.9263L178.989 75.5854L178.367 76.5567L177.495 80.1745L180.782 78.5962L184.214 77.018L184.529 77.4712L181.25 79.4056L179.587 80.9434L178.763 81.6718L179.667 82.2788L182.163 82.4488L185.885 83.0153L185.877 83.3714L182.147 83.8408L178.109 84.0432L181.113 86.6736L184.077 89.0207L183.875 89.3282L180.556 87.4182L177.229 85.8238L178.141 89.5063L179.361 93.2617L179.377 93.2455L179.256 93.286L178.44 92.5657L177.511 90.6718L176.454 88.7212L175.759 87.8471L175.234 86.9568V86.9164Z"
                    fill="currentColor"
                />
                <path
                    d="M157.945 74.679L158.51 76.8804L158.962 79.1871L159.528 81.2995V81.4937L157.614 80.1259L155.643 78.8714L154.448 78.4506L152.817 77.8597L149.119 79.0576L146.946 79.3651L146.979 79.3489L148.061 77.5279L149.151 75.4398L150.556 73.5621L150.112 71.2473L149.288 69.0459L148.699 66.804L148.876 66.7392L150.742 68.0018L152.72 69.2482L154.699 70.4784L156.919 69.7662L159.221 69.2887L161.207 68.5522L161.458 68.6898L160.109 70.5998L159.092 72.7203L157.945 74.679Z"
                    fill="currentColor"
                />
                <path
                    d="M129.318 82.5378L127.299 83.5576L125.143 84.4964L123.213 85.5L123.019 85.5405L123.94 83.3795L124.747 81.1781L124.893 79.9236L125.127 78.1916L123.165 74.8327L122.405 72.7689L122.422 72.8013L124.432 73.4649L126.693 74.0881L128.833 75.0675L130.989 74.1367L132.968 72.8579L135.019 71.7977L135.124 71.9595L134.284 74.0558L133.501 76.2653L132.718 78.4667L133.897 80.482L134.85 82.6349L135.996 84.4236L135.907 84.6907L133.759 83.7842L131.474 83.2419L129.318 82.5378Z"
                    fill="currentColor"
                />
                <path
                    d="M152.042 90.1133L149.789 89.9029L147.471 89.5387L145.299 89.3606L145.113 89.2878L147.043 87.9523L148.901 86.5279L149.692 85.5405L150.814 84.2051L150.944 80.3121L151.396 78.1592V78.1916L152.736 79.8345L154.319 81.5666L155.611 83.5414L157.929 83.9056L160.279 83.8813L162.58 84.0836V84.2779L160.763 85.5971L158.922 87.0459L157.089 88.4946L157.008 90.8255L156.669 93.1565L156.685 95.2851L156.467 95.4631L155.135 93.545L153.487 91.8696L152.042 90.1133Z"
                    fill="currentColor"
                />
                <path
                    d="M167.837 99.0809L170.219 99.8498L174.774 100.837L174.653 101.088L172.028 101.38L169.549 101.137L168.322 101.282L167.046 101.25L167.958 102.132L169.42 103.945L170.688 105.208L172.254 106.786H172.19L169.129 104.479L165.834 102.537L166.214 106.478L167.102 110.299L166.594 110.42L165.269 106.835L163.759 103.346L162.419 106.656L160.553 109.748L160.529 109.789L161.312 106.244L161.684 102.828L158.639 104.811L155.571 107.134L155.304 106.697L157.695 103.71L160.553 101.072L159.673 101.29L158.308 101.193L154.295 101.153L152.51 101.201L152.405 100.797L154.577 100.133L157.396 99.5099L158.89 99.3318L160.125 98.9676L158.341 97.7212L156.491 96.5234L154.61 95.3741L153.713 94.8238L153.705 94.67L154.828 95.0908L156.491 95.447L157.468 96.0621L161.086 96.8876L159.479 93.6178L157.864 90.1943L158.308 89.8705L160.271 93.1322L161.829 94.7833L162.572 95.6007L163.162 94.6862L163.307 92.1853L163.824 88.4461H164.179L164.688 92.1853L164.938 96.232L167.522 93.1889L169.84 90.1943L170.139 90.3885L168.281 93.7392L166.731 97.0899L170.389 96.1349L174.12 94.8642L174.104 94.8561L174.144 94.9694L173.433 95.8031L171.56 96.75L169.63 97.8345L168.766 98.5387L167.878 99.0809H167.837Z"
                    fill="currentColor"
                />
                <path
                    d="M145.42 84.9577L144.055 86.7302L141.818 86.4389L139.679 86.8516L138.968 86.1718L137.942 85.4919L136.028 84.3912L135.924 82.1493L135.221 80.1097L136.271 78.232L137.143 76.2815L139.097 75.4155L141.043 74.4604L142.085 74.9622L143.345 75.3022L145.259 75.7149L146.195 77.6412L147.641 79.2842L147.132 81.429L147.084 83.5899L145.42 84.9577Z"
                    fill="currentColor"
                />
                <path
                    d="M141.576 96.1106L142.529 94.0872L144.774 93.8849L146.777 93.027L147.617 93.545L148.771 93.982L150.863 94.6457L151.452 96.8147L152.575 98.652L151.953 100.716L151.517 102.812L149.797 104.075L148.093 105.426L146.971 105.159L145.662 105.094L143.708 105.111L142.384 103.427L140.615 102.132L140.656 99.9308L140.244 97.8103L141.576 96.1106Z"
                    fill="currentColor"
                />
                <path
                    d="M111.262 76.8966L110.26 74.8894L111.488 73.0036L112.053 70.8912L112.973 70.5513L114.031 69.9119L115.848 68.6736L117.916 69.5477L120.047 69.7986L121.283 71.563L122.656 73.206L122.583 75.3426L122.591 77.5198L121.687 78.2401L120.831 79.2275L119.636 80.7734L117.496 80.7815L115.388 81.3723L113.684 79.9802L111.762 78.9928L111.262 76.8966Z"
                    fill="currentColor"
                />
                <path
                    d="M123.447 68.2446L122.446 66.2374L123.681 64.3516L124.247 62.2392L125.167 61.8993L126.225 61.2599L128.042 60.0135L130.101 60.8876L132.241 61.1466L133.477 62.911L134.85 64.554L134.769 66.6907L134.777 68.8597L133.88 69.58L133.024 70.5756L131.821 72.1214H129.689L127.574 72.7203L125.87 71.3202L123.948 70.3408L123.447 68.2446Z"
                    fill="currentColor"
                />
                <path
                    d="M116.389 96.6529L115.259 98.8948L113.587 103.249L113.361 103.095L113.474 100.457L114.088 98.0369L114.136 96.7986L114.362 95.536L113.353 96.3049L111.342 97.4784L109.905 98.5387L108.104 99.8498L108.112 99.7851L110.866 97.1061L113.28 94.1439L109.332 93.9092L105.431 94.2086L105.391 93.6907L109.13 92.9218L112.804 91.9586L109.743 90.1214L106.982 87.8067L106.941 87.7743L110.325 89.0935L113.628 89.9838L112.134 86.6655L110.317 83.2743L110.785 83.072L113.369 85.8966L115.533 89.134L115.453 88.2275L115.759 86.8921L116.405 82.9263L116.632 81.1457L117.052 81.1052L117.375 83.3552L117.552 86.2446L117.496 87.75L117.673 89.0369L119.175 87.4586L120.645 85.8076L122.058 84.1241L122.745 83.3148L122.89 83.3309L122.3 84.375L121.703 85.9694L120.952 86.8435L119.579 90.2995L123.051 89.2068L126.669 88.1304L126.92 88.6241L123.407 90.0648L121.541 91.3597L120.621 91.9667L121.436 92.6871L123.875 93.2131L127.485 94.3058L127.428 94.6538L123.665 94.589L119.636 94.2167L122.244 97.2437L124.844 99.9955L124.594 100.263L121.582 97.9074L118.521 95.8597L118.901 99.6313L119.579 103.524L119.595 103.508L119.466 103.532L118.763 102.699L118.117 100.692L117.342 98.6115L116.777 97.6484L116.381 96.6934L116.389 96.6529Z"
                    fill="currentColor"
                />
                <path
                    d="M164.203 10.9506L162.346 12.2617L160.359 13.5L158.591 14.7788L158.405 14.8435L159.003 12.5693L159.479 10.2788L159.439 9.00812L159.423 7.26801L156.992 4.23294L155.934 2.29858L155.958 2.32287L158.042 2.69517L160.376 2.97844L162.629 3.63402L164.631 2.39571L166.4 0.841751L168.281 -0.501774L168.402 -0.364184L167.878 1.82916L166.973 6.42628L168.427 8.24732L169.686 10.2383L171.075 11.8409L171.027 12.1241L168.774 11.5333L166.432 11.331L164.203 10.9506Z"
                    fill="currentColor"
                />
                <path
                    d="M186.838 32.2284L186.774 34.5027L186.572 36.8418L186.54 39.027L186.483 39.2131L185.021 37.3759L183.479 35.6196L182.437 34.8912L181.032 33.8633L177.156 34.0009L174.976 33.6853H175.016L176.55 32.2365L178.182 30.5288L180.055 29.1124L180.265 26.7653L180.079 24.4182L180.128 22.1034L180.314 22.0873L181.751 23.8193L184.884 27.2995L187.21 27.2186L189.552 27.4047L191.667 27.2428L191.861 27.4452L190.044 28.9101L188.486 30.6664L186.838 32.2284Z"
                    fill="currentColor"
                />
                <path
                    d="M188.72 1.58636L188.252 3.81208L187.63 6.07826L187.202 8.21495L187.113 8.39301L186.007 6.32107L184.803 4.30578L183.915 3.39931L182.72 2.13672L178.876 1.56208L176.793 0.85794L176.833 0.866033L178.61 -0.283248L180.515 -1.65915L182.615 -2.7113L183.245 -4.98559L183.487 -7.32461L183.955 -9.5908L184.141 -9.57461L185.248 -7.60789L186.475 -5.60879L187.694 -3.61778L189.996 -3.26976L192.265 -2.66274L194.373 -2.43613L194.534 -2.20141L192.483 -1.0926L190.626 0.348048L188.72 1.58636Z"
                    fill="currentColor"
                />
                <path
                    d="M146.906 17.1583L144.814 18.0324L142.602 18.8175L140.599 19.6916L140.405 19.7158L141.479 17.6196L142.432 15.4829L142.674 14.2365L143.022 12.5288L141.302 9.04049L140.688 6.92808L140.704 6.96045L142.658 7.76171L144.871 8.54679L146.938 9.67178L149.159 8.89481L151.21 7.76171L153.342 6.84715L153.423 7.00902L152.446 9.04049L150.58 13.3301L151.606 15.4263L152.413 17.6439L153.431 19.5054L153.326 19.7725L151.242 18.7123L148.997 18.0081L146.906 17.1583Z"
                    fill="currentColor"
                />
                <path
                    d="M160.384 40.3948L158.123 40.322L155.789 40.1115L153.608 40.0711L153.423 40.0144L155.264 38.5576L157.016 37.0117L157.751 35.9757L158.777 34.5675L158.664 30.6745L158.979 28.4973L158.987 28.5378L160.424 30.0837L162.12 31.7185L163.525 33.6043L165.867 33.8229L168.209 33.6448L170.518 33.7015L170.534 33.8876L168.798 35.3283L167.054 36.8903L165.318 38.4524L165.382 40.7833L165.197 43.1304L165.342 45.2509L165.14 45.4452L163.686 43.6241L161.942 42.0459L160.384 40.3948Z"
                    fill="currentColor"
                />
                <path
                    d="M133.905 50.9569L132.209 49.4515L130.545 47.7923L128.89 46.3678L128.785 46.206L131.127 46.2626L133.469 46.1979L134.688 45.866L136.376 45.4452L138.766 42.3696L140.397 40.8966L140.373 40.929L140.494 43.0414L140.761 45.3804L140.648 47.7356L142.303 49.4029L144.217 50.7626L145.961 52.2842L145.856 52.438H143.603L141.269 52.527L138.936 52.6079L137.498 54.4533L135.859 56.1367L134.623 57.8687L134.341 57.8849L134.389 55.554L134.05 53.223L133.905 50.9569Z"
                    fill="currentColor"
                />
                <path
                    d="M177.673 48.8768L179.458 50.6331L183.091 53.5549L182.881 53.7248L180.402 52.8103L178.287 51.491L177.124 51.0702L175.993 50.4712L176.413 51.6691L176.922 53.9434L177.495 55.6349L178.19 57.7554L178.133 57.723L176.421 54.2914L174.338 51.0783L172.925 54.777L172.02 58.589L171.511 58.4757L171.923 54.6718L172.125 50.8759L169.444 53.2392L166.408 55.1736L166.359 55.1979L168.645 52.3732L170.502 49.4838L166.884 49.9047L163.105 50.6088L163.065 50.0989L166.529 48.4883L170.268 47.4038L169.38 47.2096L168.201 46.5054L164.631 44.6844L163 43.9236L163.097 43.5108L165.334 43.8912L168.136 44.5953L169.549 45.1052L170.825 45.3319L169.775 43.4218L168.653 41.5198L167.482 39.6502L166.925 38.7518L166.981 38.6142L167.805 39.4964L169.129 40.5567L169.735 41.536L172.602 43.8993L172.618 40.2491L172.699 36.4694L173.24 36.3804L173.546 40.1763L174.209 42.3453L174.507 43.4056L175.436 42.8552L176.68 40.6862L178.812 37.5702L179.126 37.732L177.923 41.3013L176.34 45.0324L180.015 43.4622L183.414 41.8193L183.6 42.1349L180.443 44.2959L177.568 46.6025L181.266 47.3795L185.175 47.9218L185.159 47.8975L185.143 48.027L184.141 48.4479L182.042 48.456L179.829 48.5612L178.739 48.8121L177.705 48.893L177.673 48.8768Z"
                    fill="currentColor"
                />
                <path
                    d="M149.482 61.875L151.832 62.7491L156.338 63.9227L156.217 64.1655L153.576 64.3516L151.113 64.0117L149.886 64.1007L148.602 64.0198L149.474 64.9425L150.871 66.8121L152.082 68.1232L153.576 69.7662H153.512L150.548 67.33L147.342 65.25L147.56 69.2077L148.295 73.0603L147.778 73.1574L146.599 69.5234L145.234 65.9703L143.757 69.232L141.77 72.2347L141.738 72.2833L142.674 68.7626L143.183 65.3714L140.058 67.2329L136.901 69.4263L136.65 68.973L139.162 66.0917L142.125 63.5666L141.237 63.7527L139.88 63.5989L135.875 63.3966L134.082 63.3723L133.994 62.9595L136.19 62.3849L139.033 61.8831L140.535 61.7698L141.786 61.4461L140.058 60.1349L138.257 58.8561L136.424 57.634L135.544 57.0432V56.8975L136.65 57.3588L138.298 57.7878L139.251 58.4353L142.828 59.4146L141.35 56.072L139.88 52.5917L140.341 52.2923L142.174 55.6268L143.66 57.3426L144.362 58.1844L144.992 57.2941L145.234 54.8094L145.913 51.0863L146.268 51.1106L146.623 54.8579L146.704 58.9128L149.417 55.9829L151.848 53.0854L152.147 53.2959L150.144 56.5576L148.456 59.8435L152.155 59.0423L155.934 57.9335L155.918 57.9173L155.958 58.0387L155.215 58.8318L153.302 59.7059L151.323 60.7095L150.435 61.3813L149.522 61.8831L149.482 61.875Z"
                    fill="currentColor"
                />
                <path
                    d="M164.599 24.7905L162.588 25.7698L160.723 24.5153L158.615 23.9164L158.292 22.9937L157.67 21.9254L156.451 20.0882L157.347 18.0324L157.63 15.8957L159.407 14.6817L161.062 13.322L163.186 13.4272L165.358 13.4434L166.069 14.3579L167.046 15.2239L168.572 16.4461L168.548 18.5828L169.113 20.7114L167.708 22.3948L166.699 24.313L164.599 24.7905Z"
                    fill="currentColor"
                />
                <path
                    d="M151.573 42.0621L153.326 40.67L155.425 41.4955L157.598 41.625L158.123 42.4587L158.954 43.3651L160.537 44.9029L160.101 47.0962L160.287 49.2491L158.809 50.8193L157.485 52.5027L155.385 52.8588L153.261 53.304L152.373 52.5675L151.226 51.9281L149.474 51.0621L149.038 48.9658L148.036 47.0153L149.054 45.0648L149.619 42.9766L151.573 42.0621Z"
                    fill="currentColor"
                />
                <path
                    d="M172.287 34.179L170.131 34.7617L168.524 33.1754L166.569 32.2042L166.416 31.2329L166.004 30.0675L165.148 28.036L166.416 26.1826L167.086 24.1349L169.057 23.2689L170.93 22.2491L173.005 22.7428L175.137 23.1637L175.662 24.1916L176.462 25.2275L177.737 26.7167L177.318 28.813L177.479 31.0063L175.783 32.3984L174.443 34.098L172.287 34.179Z"
                    fill="currentColor"
                />
                <path
                    d="M195.6 43.7212L195.681 45.9551L193.783 47.1691L192.402 48.8606L191.417 48.7878L190.198 48.9254L188.025 49.3058L186.507 47.6547L184.666 46.5378L184.27 44.4173L183.697 42.3534L184.65 40.4434L185.538 38.4605L186.653 38.1772L187.848 37.6268L189.576 36.7122L191.522 37.5944L193.686 37.9344L194.663 39.9092L196.004 41.6007L195.6 43.7212Z"
                    fill="currentColor"
                />
                <path
                    d="M145.703 -0.0242575V-2.26616L147.641 -3.40735L149.086 -5.04224L150.063 -4.93703L151.291 -5.03415L153.471 -5.33361L154.933 -3.62588L156.734 -2.44422L157.049 -0.307531L157.549 1.7725L156.532 3.6502L155.571 5.60074L154.44 5.84355L153.237 6.34535L151.477 7.19517L149.563 6.24013L147.407 5.82736L146.502 3.82017L145.218 2.08006L145.703 -0.0242575Z"
                    fill="currentColor"
                />
                <path
                    d="M146.736 33.0054L144.734 34.5108L141.302 37.6592L141.164 37.4245L142.44 35.1097L144.072 33.2159L144.661 32.1313L145.42 31.1034L144.176 31.3382L141.859 31.4919L140.098 31.7995L137.91 32.1637L137.942 32.107L141.592 30.9416L145.081 29.3714L141.649 27.3966L138.023 25.9236L138.217 25.438L141.907 26.4254L145.622 27.2024L143.692 24.1916L142.255 20.8894L142.238 20.8409L144.677 23.5279L147.237 25.8103L147.374 22.1682L147.261 18.3157L147.77 18.3561L148.82 22.0306L149.32 25.8993L149.652 25.0495L150.524 23.9892L152.866 20.7275L153.859 19.2383L154.254 19.3921L153.544 21.545L152.413 24.2159L151.695 25.5351L151.283 26.7653L153.326 26.0207L155.377 25.2033L157.396 24.3292L158.365 23.9083L158.486 23.9892L157.501 24.6691L156.249 25.8184L155.191 26.2635L152.421 28.7482L156.015 29.3229L159.738 29.9784V30.5288L155.95 30.2536L153.705 30.5774L152.615 30.7069L153.019 31.7186L154.965 33.2806L157.711 35.8705L157.509 36.1538L154.174 34.4137L150.734 32.277L151.719 36.1538L152.817 39.7797L152.478 39.9092L150.831 36.4533L148.997 33.2482L147.665 36.8013L146.534 40.581L146.559 40.5729L146.438 40.5405L146.171 39.4802L146.486 37.4002L146.72 35.1907L146.639 34.0738L146.712 33.0378L146.736 33.0054Z"
                    fill="currentColor"
                />
                <path
                    d="M176.195 16.5513L174.192 18.0486L170.752 21.2051L170.623 20.9703L171.899 18.6475L173.53 16.7617L174.12 15.6772L174.879 14.6412L173.635 14.8759L171.31 15.0297L169.557 15.3373L167.361 15.7096L167.401 15.6529L171.051 14.4793L174.532 12.9092L171.1 10.9425L167.482 9.46945L167.676 8.98384L171.358 9.97125L175.073 10.7482L173.151 7.73744L171.713 4.42719L171.689 4.37863L174.128 7.07377L176.696 9.34805L176.833 5.71406L176.712 1.85344L177.229 1.89391L178.279 5.57647L178.779 9.44517L179.11 8.59535L179.974 7.5351L182.324 4.27341L183.318 2.77611L183.713 2.92988L182.995 5.09085L181.872 7.75362L181.153 9.08096L180.742 10.3031L182.785 9.56657L184.828 8.74103L186.855 7.86693L187.824 7.45416L187.945 7.52701L186.951 8.20686L185.708 9.36424L184.642 9.80938L181.88 12.286L185.474 12.8606L189.196 13.5162V14.0747L185.409 13.7914L183.164 14.1151L182.074 14.2446L182.478 15.2563L184.424 16.8184L187.169 19.4083L186.968 19.6916L183.624 17.9596L180.192 15.8229L181.178 19.6997L182.276 23.3175L181.937 23.447L180.289 19.9991L178.456 16.7941L177.116 20.3391L175.993 24.1268L176.017 24.1187L175.896 24.0783L175.63 23.018L175.945 20.938L176.179 18.7284L176.098 17.6196L176.171 16.5837L176.195 16.5513Z"
                    fill="currentColor"
                />
                <path
                    d="M97.7273 29.6709L99.9803 29.857L102.306 30.1808L104.478 30.3345L104.664 30.4074L102.75 31.7671L100.917 33.2239L100.134 34.2194L99.0355 35.5711L98.9547 39.456L98.5268 41.6169V41.5845L97.162 39.9658L95.555 38.2419L94.2468 36.2914L91.9212 35.9515L89.5712 36.0081L87.2698 35.8381L87.2617 35.652L89.0706 34.3004L90.8875 32.8274L92.7045 31.3624L92.7529 29.0234L93.0598 26.6925L93.0194 24.5639L93.2293 24.3777L94.586 26.2797L96.2576 27.9389L97.7273 29.6709Z"
                    fill="currentColor"
                />
                <path
                    d="M98.1876 58.8723L99.3262 60.831L100.384 62.9272L101.498 64.8049L101.555 64.9991L99.3423 64.206L97.1055 63.5261L95.8457 63.4452L94.1095 63.3157L90.8794 65.4766L88.8606 66.3588L88.8929 66.3345L89.442 64.2869L89.9265 61.9883L90.7825 59.795L89.7246 57.6826L88.3438 55.7887L87.1648 53.7896L87.3182 53.6844L89.4501 54.3966L93.94 55.7078L95.878 54.4128L97.9695 53.3283L99.6815 52.0819L99.9561 52.1547L99.1808 54.3561L98.769 56.6709L98.1876 58.8723Z"
                    fill="currentColor"
                />
                <path
                    d="M120.702 48.375L120.508 50.6412L120.169 52.9641L120.007 55.1412L119.934 55.3274L118.586 53.4092L117.148 51.5639L116.155 50.7707L114.815 49.6619L110.93 49.5648L108.774 49.1196H108.815L110.438 47.768L112.158 46.1655L114.112 44.8543L114.467 42.5315L114.419 40.1763L114.605 37.8615H114.79L116.131 39.6745L117.593 41.5117L119.046 43.3328L121.38 43.3975L123.706 43.7212L125.821 43.6889L126.007 43.9074L124.101 45.2509L122.438 46.9182L120.702 48.375Z"
                    fill="currentColor"
                />
                <path
                    d="M84.3546 40.411L85.1217 38.0234L86.1069 33.4667L86.3572 33.5801L86.648 36.2105L86.4057 38.6952L86.5511 39.9254L86.5268 41.2042L87.399 40.2977L89.2159 38.8247L90.4676 37.5621L92.0503 35.9838V36.0567L89.7408 39.1241L87.8027 42.4182L91.7435 42.0459L95.5469 41.1475L95.6681 41.6574L92.0907 42.9847L88.6103 44.4982L91.9131 45.8498L94.9978 47.7113L95.0463 47.7356L91.5012 46.9506L88.0934 46.5783L90.08 49.6295L92.3976 52.7051L91.9534 52.9721L88.9737 50.5765L86.3411 47.7113L86.5591 48.5935L86.4622 49.9613L86.4299 53.9838L86.4784 55.7806L86.0665 55.8777L85.4043 53.7086L84.7826 50.8759L84.613 49.3786L84.2415 48.1403L83.006 49.929L81.8028 51.7824L80.6561 53.6682L80.107 54.5666L79.9616 54.5828L80.3815 53.4497L80.7287 51.7905L81.3425 50.8112L82.1662 47.1772L78.9037 48.7959L75.4879 50.4146L75.1729 49.9613L78.4192 47.9946L80.0666 46.4326L80.8822 45.6961L79.9697 45.1052L77.4825 44.9596L73.7436 44.4335L73.7517 44.0855L77.4744 43.5675L81.512 43.3247L78.4757 40.7266L75.4879 38.4119L75.6898 38.1043L79.0248 39.9658L82.368 41.5279L81.4151 37.8534L80.1473 34.1142L80.1392 34.1304L80.2604 34.0899L81.0841 34.8022L82.0289 36.6799L83.111 38.6223L83.8135 39.4883L84.3546 40.3705V40.411Z"
                    fill="currentColor"
                />
                <path
                    d="M125.563 28.8615L127.073 26.8624L129.496 22.8723L129.689 23.0666L129.108 25.6484L128.066 27.9146L127.8 29.1205L127.356 30.3265L128.486 29.7518L130.675 28.9587L132.273 28.1736L134.284 27.2105L134.26 27.2752L131.078 29.4119L128.163 31.8885L132.007 32.8274L135.899 33.2401L135.843 33.7581L132.031 33.839L128.244 34.1223L130.933 36.4775L133.226 39.2536L133.267 39.2941L130.174 37.3921L127.081 35.911L127.953 39.4479L129.14 43.1223L128.632 43.2275L126.605 39.982L125.054 36.4047L124.973 37.3112L124.432 38.5738L123.084 42.3615L122.535 44.0774L122.115 44.0369L122.204 41.7626L122.551 38.8894L122.874 37.4164L122.93 36.1214L121.17 37.4083L119.434 38.7599L117.73 40.1682L116.914 40.8399L116.777 40.7995L117.544 39.8687L118.416 38.4119L119.313 37.6916L121.283 34.5351L117.673 34.9883L113.918 35.393L113.765 34.8588L117.48 34.0738L119.547 33.143L120.556 32.706L119.886 31.848L117.584 30.893L114.225 29.1691L114.346 28.8373L118.029 29.5819L121.929 30.6745L119.91 27.2266L117.843 24.054L118.134 23.8274L120.677 26.6925L123.326 29.2581L123.625 25.4784L123.657 21.5288L123.641 21.545H123.762L124.311 22.4838L124.586 24.572L124.973 26.7572L125.361 27.8094L125.579 28.8211L125.563 28.8615Z"
                    fill="currentColor"
                />
                <path
                    d="M103.986 51.5801L102.435 53.1988L100.247 52.6727L98.0665 52.8426L97.4446 52.0899L96.4918 51.3049L94.7071 50.0099L94.8363 47.768L94.3599 45.6637L95.6035 43.9074L96.6856 42.0621L98.7125 41.4146L100.756 40.6781L101.741 41.2851L102.96 41.7545L104.809 42.3696L105.536 44.3849L106.804 46.1817L106.061 48.2536L105.786 50.3984L103.986 51.5801Z"
                    fill="currentColor"
                />
                <path
                    d="M128.672 60.2401L126.782 61.4461L124.78 60.4182L122.623 60.0783L122.195 59.1961L121.453 58.2087L120.023 56.5333L120.677 54.3804L120.71 52.2275L122.325 50.8112L123.811 49.2653L125.942 49.1196L128.099 48.8849L128.906 49.7105L129.98 50.4551L131.636 51.491L131.87 53.6196L132.677 55.6592L131.474 57.5045L130.699 59.5198L128.672 60.2401Z"
                    fill="currentColor"
                />
                <path
                    d="M114.072 35.9596L114.928 38.0315L113.571 39.8283L112.852 41.8921L111.916 42.1673L110.809 42.7257L108.912 43.8345L106.917 42.8148L104.801 42.4101L103.695 40.5648L102.443 38.8247L102.669 36.7042L102.815 34.5351L103.768 33.8795L104.688 32.9488L105.996 31.4919L108.128 31.6376L110.276 31.2006L111.875 32.7141L113.716 33.831L114.072 35.9596Z"
                    fill="currentColor"
                />
                <path
                    d="M80.438 65.2662L78.2173 65.5495L76.8445 63.7689L75.0357 62.5387L75.0195 61.5513L74.7692 60.3453L74.1877 58.2167L75.6898 56.5495L76.6346 54.607L78.7018 54.0243L80.6965 53.2635L82.6911 54.0324L84.7422 54.7365L85.1217 55.8292L85.7758 56.9622L86.8418 58.6052L86.1392 60.6286L86.01 62.822L84.1365 63.9793L82.578 65.4766L80.438 65.2662Z"
                    fill="currentColor"
                />
                <path
                    d="M63.1649 46.6025L60.9523 46.8858L59.5714 45.1052L57.7706 43.875L57.7464 42.8876L57.4961 41.6817L56.9227 39.5531L58.4247 37.8858L59.3615 35.9434L61.4287 35.3606L63.4314 34.5998L65.4179 35.3687L67.4691 36.0729L67.8567 37.1655L68.5108 38.2986L69.5687 39.9416L68.8742 41.9649L68.7369 44.1583L66.8715 45.3157L65.313 46.813L63.1649 46.6025Z"
                    fill="currentColor"
                />
                <path
                    d="M114.669 61.697L116.414 63.5018L119.975 66.5126L119.757 66.6745L117.302 65.7033L115.218 64.3193L114.072 63.8741L112.957 63.2509L113.345 64.4569L113.797 66.7473L114.322 68.4551L114.968 70.5836L114.912 70.5513L113.28 67.0792L111.286 63.8175L109.776 67.4757L108.774 71.2635L108.274 71.134L108.774 67.3462L109.073 63.5504L106.336 65.8489L103.251 67.7024L103.202 67.7266L105.56 64.9586L107.482 62.1178L103.865 62.4497L100.069 63.0567L100.037 62.5468L103.542 61.0252L107.305 60.0378L106.424 59.8193L105.27 59.0908L101.741 57.1727L100.134 56.3795L100.239 55.9667L102.459 56.4038L105.245 57.1808L106.642 57.723L107.91 57.9739L106.917 56.0396L105.843 54.1133L104.721 52.2113L104.188 51.3049L104.244 51.1673L105.044 52.0657L106.344 53.1583L106.925 54.1619L109.727 56.5899L109.84 52.9479L110.01 49.1601L110.559 49.0953L110.769 52.8912L111.375 55.0845L111.641 56.1529L112.594 55.6187L113.886 53.482L116.099 50.4227L116.405 50.5926L115.113 54.1295L113.442 57.8202L117.148 56.3471L120.597 54.7851L120.766 55.1088L117.56 57.1889L114.621 59.4227L118.303 60.2968L122.195 60.9281L122.179 60.9119L122.163 61.0333L121.146 61.4299L119.046 61.3894L116.833 61.438L115.743 61.6565L114.71 61.7212L114.669 61.697Z"
                    fill="currentColor"
                />
                <path
                    d="M72.8069 36.0567L70.7396 35.1421L68.6481 34.0657L66.6454 33.2078L66.492 33.0864L68.745 32.4308L70.9576 31.6538L72.0236 30.9739L73.5013 30.0594L74.8499 26.4092L75.9562 24.5072L75.9482 24.5396L76.7072 26.5144L77.6601 28.6673L78.2658 30.9416L80.3492 32.0261L82.5861 32.7464L84.7099 33.6691L84.6453 33.8471L82.5053 34.527L80.3008 35.3202L78.1043 36.1133L77.2967 38.3067L76.2389 40.4029L75.5848 42.4263L75.3264 42.5315L74.6642 40.2896L73.6305 38.1772L72.8069 36.0567Z"
                    fill="currentColor"
                />
                <path
                    d="M45.1247 2.84086L42.8717 3.04319L40.5299 3.11604L38.3576 3.34266L38.1638 3.30219L39.8192 1.63492L41.3778 -0.113279L41.9753 -1.23019L42.8313 -2.74367L42.2499 -6.59619L42.2983 -8.79763L42.3064 -8.75716L43.9215 -7.39745L45.803 -5.98108L47.4262 -4.28144L49.7761 -4.34619L52.0776 -4.79943L54.379 -5.02605L54.4113 -4.8399L52.8689 -3.20501L51.3265 -1.44062L49.7842 0.315676L50.1314 2.63042L50.2283 4.97755L50.6321 7.06568L50.4544 7.2842L48.7909 5.64931L46.869 4.29769L45.1247 2.84086Z"
                    fill="currentColor"
                />
                <path
                    d="M73.8405 7.2842L72.71 5.31747L71.6521 3.22125L70.5296 1.34355L70.4812 1.14931L72.6857 1.95057L74.9307 2.63042L76.1904 2.70326L77.9266 2.83276L81.1567 0.679881L83.1756 -0.202312L83.1433 -0.186126L82.5942 1.86154L82.1016 4.16819L81.2536 6.36154L82.3034 8.46585L83.6924 10.3678L84.8714 12.3588L84.718 12.4721L82.578 11.7599L78.0962 10.4488L76.15 11.7437L74.0666 12.8202L72.3547 14.0666L72.0801 14.0018L72.8553 11.8004L73.2672 9.47754L73.8405 7.2842Z"
                    fill="currentColor"
                />
                <path
                    d="M87.6816 25.7374L86.9144 28.125L85.9293 32.6898L85.6789 32.5684L85.3882 29.938L85.6224 27.4533L85.4851 26.2311L85.5093 24.9443L84.6291 25.8588L82.8203 27.3238L81.5686 28.5944L79.9858 30.1646V30.0998L82.2954 27.0324L84.2334 23.7302L80.2927 24.1106L76.4892 25.0009L76.3681 24.4991L79.9454 23.1637L83.4259 21.6502L80.115 20.3067L77.0383 18.4452L76.9899 18.4128L80.5349 19.1979L83.9427 19.5783L81.9562 16.5189L79.6386 13.4434L80.0746 13.1763L83.0544 15.572L85.6951 18.4371L85.477 17.563L85.5739 16.1871L85.6062 12.1727L85.5578 10.3759L85.9696 10.2707L86.6318 12.4479L87.2455 15.2725L87.4232 16.7698L87.7946 18.0162L89.0302 16.2194L90.2334 14.366L91.3801 12.4802L91.9292 11.5819L92.0746 11.5738L91.6547 12.6988L91.2993 14.366L90.6937 15.3454L89.8619 18.9712L93.1324 17.3525L96.5483 15.7419L96.8632 16.1871L93.6089 18.1538L91.9696 19.7159L91.154 20.4605L92.0665 21.0513L94.5537 21.197L98.2926 21.715L98.2845 22.0711L94.5618 22.581L90.5241 22.8319L93.5604 25.4218L96.5483 27.7446L96.3464 28.0441L93.0113 26.1826L89.6681 24.6286L90.621 28.295L91.8808 32.0342L91.8969 32.018L91.7758 32.0585L90.9521 31.3462L90.0073 29.4685L88.9252 27.5342L88.2226 26.6682L87.6816 25.7779V25.7374Z"
                    fill="currentColor"
                />
                <path
                    d="M68.0505 14.5765L69.601 12.9578L71.7894 13.4838L73.9617 13.3058L74.5915 14.0585L75.5444 14.8435L77.321 16.1385L77.1998 18.3804L77.6763 20.4847L76.4327 22.241L75.3506 24.0944L73.3156 24.7419L71.2806 25.4784L70.2955 24.8714L69.0761 24.3939L67.2188 23.7788L66.5001 21.7716L65.2322 19.9748L65.9671 17.8948L66.2497 15.7581L68.0505 14.5765Z"
                    fill="currentColor"
                />
                <path
                    d="M88.045 4.83995L88.263 2.61423L90.3061 1.66729L91.905 0.186176L92.8659 0.388514L94.1015 0.412795L96.298 0.331859L97.5819 2.16909L99.2535 3.5288L99.3585 5.67358L99.6492 7.80218L98.4541 9.56657L97.3074 11.4119L96.1607 11.5414L94.909 11.9218L93.0759 12.5935L91.267 11.4605L89.1594 10.8292L88.4649 8.74912L87.3586 6.88761L88.045 4.83995Z"
                    fill="currentColor"
                />
                <path
                    d="M77.9912 70.697L77.8055 72.9631L77.4744 75.2941L77.321 77.4712L77.2564 77.6574L75.8997 75.7392L74.4462 73.902L73.4529 73.1169L72.1043 72.0162L68.2201 71.9353L66.064 71.5063H66.1044L67.7194 70.1385L69.4314 68.5279L71.3776 67.2167L71.7167 64.8858L71.6602 62.5306L71.8378 60.2158H72.0236L73.3641 62.0207L74.8338 63.8498L76.3035 65.6709L78.6373 65.7194L80.9629 66.027L83.0787 65.9865L83.2644 66.197L81.3748 67.5567L79.7113 69.232L77.9912 70.697Z"
                    fill="currentColor"
                />
                <path
                    d="M50.091 69.9766L49.1058 72.0162L47.9591 74.072L47.0305 76.0468L46.9013 76.2006L46.3279 73.9182L45.6334 71.6763L44.9955 70.5837L44.1314 69.0702L40.5379 67.5971L38.6806 66.4155L38.7129 66.4317L40.7156 65.7437L42.8959 64.8534L45.1812 64.3355L46.336 62.2797L47.1274 60.0702L48.1206 57.9739L48.2983 58.0387L48.9039 60.2158L50.3252 64.6673L52.4894 65.5657L54.5486 66.6907L56.5351 67.4191L56.632 67.6862L54.379 68.2689L52.231 69.2239L50.091 69.9766Z"
                    fill="currentColor"
                />
                <path
                    d="M66.4274 56.9623L68.8015 57.7311L73.356 58.7186L73.2429 58.9614L70.6185 59.2608L68.1313 59.018L66.9119 59.1637L65.6279 59.1394L66.5404 60.0135L68.0101 61.8346L69.2699 63.0891L70.8365 64.6754H70.7719L67.7113 62.3606L64.4247 60.4182L64.7962 64.3678L65.6925 68.1799L65.1838 68.3013L63.8594 64.7159L62.3413 61.2275L61.0008 64.5378L59.1434 67.6295L59.1111 67.67L59.9025 64.125L60.274 60.7096L57.2296 62.7006L54.161 65.0234L53.8945 64.5783L56.2767 61.5918L59.1434 58.9533L58.2632 59.1718L56.8904 59.0747L52.8851 59.0342L51.0923 59.0909L50.9874 58.6781L53.1596 58.0144L55.986 57.3912L57.4718 57.2213L58.7154 56.849L56.9308 55.6025L55.0815 54.4047L53.2 53.2554L52.2956 52.7051L52.2875 52.5594L53.418 52.9722L55.0735 53.3283L56.0506 53.9434L59.6683 54.7689L58.0613 51.4991L56.4463 48.0756L56.8985 47.7599L58.8608 51.0135L60.4113 52.6646L61.1542 53.482L61.7437 52.5675L61.889 50.0666L62.4139 46.3274L62.7612 46.3355L63.278 50.0666L63.5202 54.1133L66.1124 51.0702L68.422 48.0756L68.7288 48.2698L66.8634 51.6205L65.313 54.9713L68.9792 54.0162L72.71 52.7455L72.6857 52.7374L72.7342 52.8507L72.0155 53.6844L70.142 54.6313L68.212 55.7159L67.3479 56.42L66.4597 56.9623H66.4274Z"
                    fill="currentColor"
                />
                <path
                    d="M62.1878 78.5153L60.3144 79.7374L58.3036 78.7338L56.1394 78.4182L55.7034 77.5441L54.9443 76.5648L53.5069 74.8975L54.1368 72.7446V70.5836L55.7437 69.1511L57.2134 67.5971L59.3373 67.4191L61.4934 67.1601L62.309 67.9775L63.3911 68.714L65.0627 69.7257L65.313 71.8543L66.1447 73.8858L64.9658 75.7473L64.2147 77.7707L62.1878 78.5153Z"
                    fill="currentColor"
                />
                <path
                    d="M40.3683 50.7221L40.0857 48.4964L41.8623 47.1205L43.0897 45.3076L44.0668 45.2914L45.2781 45.0405L47.4019 44.4578L49.0574 45.9632L50.9954 46.9101L51.5849 48.982L52.344 50.9811L51.5769 52.9802L50.8662 55.036L49.7841 55.4164L48.6536 56.072L47.0143 57.1403L44.9955 56.4443L42.799 56.3067L41.6523 54.429L40.1584 52.8669L40.3683 50.7221Z"
                    fill="currentColor"
                />
                <path
                    d="M2.54357 72.0729L2.7293 69.8148L3.05231 67.4838L3.20574 65.3067L3.27842 65.1205L4.63507 67.0387L6.08863 68.8759L7.08189 69.661L8.43047 70.7617L12.3066 70.8427L14.4627 71.2716H14.4304L12.8154 72.6394L11.0953 74.25L9.14917 75.5612L8.81001 77.8921L8.86654 80.2473L8.69696 82.554L8.51122 82.5621L7.16265 80.7572L4.23131 77.107L1.89754 77.0585L-0.428148 76.7509L-2.55196 76.7914L-2.73769 76.581L-0.839989 75.2212L0.81545 73.5459L2.54357 72.0729Z"
                    fill="currentColor"
                />
                <path
                    d="M31.6793 71.6115L33.6335 70.4703L35.725 69.4101L37.5985 68.2932L37.7923 68.2365L37.0009 70.4542L36.3226 72.6961L36.2419 73.9587L36.1127 75.6988L38.2688 78.9443L39.149 80.9596L39.1247 80.9272L37.0817 80.3768L34.7883 79.8912L32.5999 79.0333L30.4922 80.0935L28.6026 81.4775L26.608 82.6592L26.495 82.5054L27.2056 80.3687L27.8678 78.1187L28.5219 75.8687L27.2298 73.9263L26.1477 71.8301L24.9041 70.1142L24.9768 69.8391L27.1733 70.6241L29.4828 71.0288L31.6793 71.6115Z"
                    fill="currentColor"
                />
                <path
                    d="M18.3147 48.1727L19.7359 46.4083L21.3187 44.6682L22.6673 42.9443L22.8207 42.831L22.8691 45.1862L23.0387 47.5171L23.4263 48.7311L23.9189 50.3984L27.0844 52.6565L28.6349 54.2266L28.6026 54.2024L26.4949 54.4209L24.1773 54.7851L21.8274 54.777L20.2447 56.5171L18.9688 58.4919L17.5314 60.3049L17.3698 60.1997L17.2729 57.9497L17.0791 55.6187L16.8934 53.2878L14.9876 51.9281L13.2353 50.366L11.4587 49.2087L11.4264 48.9254L13.7602 48.8687L16.0616 48.4155L18.3147 48.1727Z"
                    fill="currentColor"
                />
                <path
                    d="M13.2595 85.4757L10.8773 84.7068L6.33089 83.7194L6.44395 83.4766L9.06842 83.1772L11.5475 83.42L12.775 83.2743L14.0509 83.2986L13.1465 82.4245L11.6768 80.6034L10.417 79.3489L8.84232 77.7626H8.90692L11.9755 80.0774L15.2622 82.0198L14.8826 78.0702L13.9944 74.2581L14.5031 74.1367L15.8275 77.7221L17.3375 81.2104L18.6861 77.9002L20.5434 74.8085L20.5677 74.768L19.7844 78.313L19.4129 81.7284L22.4573 79.7374L25.5259 77.4146L25.7924 77.8597L23.4021 80.8462L20.5434 83.4847L21.4237 83.2662L22.7884 83.3633L26.8018 83.4038L28.5945 83.3471L28.6914 83.7599L26.5273 84.4236L23.7009 85.0468L22.207 85.2167L20.9714 85.589L22.7561 86.8354L24.6053 88.0333L26.4869 89.1826L27.3832 89.7329L27.3994 89.8786L26.2688 89.4658L24.6134 89.1097L23.6363 88.4946L20.0105 87.6691L21.6255 90.9389L23.2406 94.3624L22.7884 94.6781L20.8261 91.4245L19.2675 89.7734L18.5327 88.9559L17.9432 89.8705L17.7978 92.3714L17.2729 96.1106L16.9257 96.1025L16.4089 92.3714L16.1666 88.3247L13.5744 91.3678L11.2649 94.3624L10.958 94.1682L12.8154 90.8175L14.3739 87.4667L10.7077 88.4218L6.97692 89.6925L6.99307 89.7006L6.95269 89.5872L7.66332 88.7536L9.53679 87.8067L11.4749 86.7221L12.3389 86.018L13.2191 85.4757H13.2595Z"
                    fill="currentColor"
                />
                <path
                    d="M1.73604 44.1745L-0.258563 42.661L-4.23969 40.2329L-4.04588 40.0387L-1.46986 40.6214L0.791228 41.6655L1.99445 41.9326L3.19767 42.3777L2.62432 41.2446L1.83294 39.0513L1.04964 37.4488L0.0886755 35.4335L0.153278 35.4578L2.28516 38.6466L4.75621 41.5684L5.69294 37.7159L6.10479 33.8148L6.6216 33.8714L6.70236 37.6916L6.98499 41.4874L9.33491 38.7923L12.1047 36.4937L12.1451 36.4533L10.2393 39.5531L8.76964 42.6529L12.2985 41.7788L15.9647 40.5971L16.0697 41.0989L12.8315 43.1304L9.26223 44.6844L10.1667 44.7653L11.4264 45.3157L15.2057 46.6673L16.9176 47.2096L16.8773 47.6304L14.6081 47.5414L11.7414 47.1934L10.2716 46.8696L8.97959 46.813L10.2636 48.5774L11.6121 50.3175L13.0173 52.0252L13.6875 52.8427L13.6471 52.9802L12.7185 52.2194L11.2649 51.3373L10.5462 50.4389L7.39684 48.4641L7.84905 52.0819L8.25282 55.8453L7.71985 55.9991L6.93654 52.2761L6.00788 50.2042L5.57181 49.1925L4.71583 49.8642L3.76294 52.1709L2.0429 55.5378L1.71181 55.4164L2.45474 51.7257L3.54491 47.8166L0.104827 49.84L-3.0607 51.9119L-3.28681 51.6205L-0.428145 49.0711L2.13173 46.4164L-1.63944 46.1169L-5.58019 46.0846L-5.56404 46.1007V45.9793L-4.62731 45.429L-2.54388 45.1538L-0.363542 44.7653L0.686249 44.3768L1.69566 44.1583L1.73604 44.1745Z"
                    fill="currentColor"
                />
                <path
                    d="M17.499 63.9227L19.3644 62.7006L21.3833 63.7042L23.5394 64.0198L23.9835 64.8939L24.7345 65.8732L26.18 67.5405L25.5501 69.6934L25.5421 71.8543L23.9351 73.2869L22.4734 74.8408L20.3416 75.0189L18.1935 75.2779L17.3698 74.4604L16.2878 73.7239L14.6242 72.7123L14.3658 70.5837L13.5341 68.5522L14.7211 66.6907L15.4721 64.6673L17.499 63.9227Z"
                    fill="currentColor"
                />
                <path
                    d="M5.10344 83.4523L6.71851 84.9982L6.19361 87.1916L6.37127 89.3768L5.61219 90.0081L4.82888 90.9631L3.53683 92.7437L1.29997 92.6142L-0.799611 93.0917L-2.55195 91.8453L-4.39313 90.7689L-5.03915 88.7293L-5.774 86.6817L-5.16836 85.7024L-4.69999 84.4802L-4.08626 82.6187L-2.07551 81.8984L-0.282791 80.6277L1.78449 81.3642L3.92445 81.6394L5.10344 83.4523Z"
                    fill="currentColor"
                />
                <path
                    d="M35.8381 40.9533L37.0413 42.8472L36.0157 44.8543L35.6766 47.0153L34.7964 47.4443L33.8112 48.1889L32.1315 49.6133L29.9916 48.9659L27.8355 48.9335L26.4303 47.3067L24.888 45.8256L24.7426 43.6889L24.5084 41.5279L25.324 40.7186L26.075 39.6421L27.1006 37.9749L29.2244 37.7482L31.2675 36.9389L33.1006 38.1448L35.1194 38.9218L35.8381 40.9533Z"
                    fill="currentColor"
                />
                <path
                    d="M8.81809 55.6916L10.8854 54.8337L12.67 56.2015L14.7373 56.9137L15.0119 57.8525L15.5691 58.9613L16.6754 60.8633L15.6579 62.8624L15.2541 64.9829L13.4129 66.0917L11.6768 67.3462L9.56102 67.1196L7.39684 66.9739L6.74273 66.0189L5.81407 65.0962L4.36052 63.7851L4.50587 61.6484L4.06981 59.4955L5.57989 57.893L6.69428 56.0477L8.81809 55.6916Z"
                    fill="currentColor"
                />
                <path
                    d="M34.11 85.8399L36.3388 86.0585L37.2755 88.1061L38.7613 89.7167L38.5595 90.6718L38.5272 91.9101L38.616 94.1115L36.7829 95.3984L35.4262 97.0819L33.2782 97.1871L31.1625 97.4784L29.394 96.2806L27.5528 95.1232L27.4236 93.9739L27.0441 92.7275L26.3738 90.8822L27.5124 89.0693L28.1342 86.965L30.2177 86.2608L32.0669 85.152L34.11 85.8399Z"
                    fill="currentColor"
                />
                <path
                    d="M34.4976 55.0926L36.2984 53.3444L39.3024 49.7752L39.4639 49.9937L38.4949 52.4542L37.114 54.5423L36.6698 55.6916L36.048 56.8085L37.2513 56.42L39.5366 55.9748L41.2324 55.4407L43.3643 54.7932L43.332 54.8579L39.8677 56.4847L36.6052 58.4838L40.2634 59.9973L44.0426 61.0009L43.9134 61.5027L40.1342 61.0009L36.3468 60.7015L38.6402 63.4452L40.4895 66.5369L40.5137 66.5854L37.7519 64.2221L34.9175 62.2959L35.2486 65.9218L35.8542 69.7257L35.3455 69.7581L33.8273 66.2455L32.8421 62.4739L32.6241 63.3561L31.8973 64.5216L29.9835 68.0504L29.184 69.661L28.7803 69.5558L29.2163 67.3301L29.9916 64.5378L30.5326 63.1376L30.7829 61.8669L28.8529 62.8624L26.931 63.9389L25.0333 65.0639L24.1289 65.6061L23.9916 65.5414L24.888 64.7401L25.9781 63.4371L26.9795 62.8624L29.4021 60.0459L25.7682 59.9326L21.9889 59.7626L21.9243 59.2122L25.7116 59.0018L27.9001 58.3948L28.966 58.1277L28.433 57.1727L26.3011 55.8777L23.2487 53.6601L23.4183 53.3525L26.9472 54.6475L30.6295 56.3229L29.1598 52.6079L27.6013 49.152L27.9243 48.982L29.9996 52.1952L32.2203 55.1412L33.1006 51.4506L33.7304 47.5495L33.7143 47.5657L33.8354 47.5819L34.2311 48.6016L34.1907 50.706L34.2392 52.9236L34.4572 54.0162L34.5218 55.0522L34.4976 55.0926Z"
                    fill="currentColor"
                />
                <path
                    d="M45.2943 113.374L45.052 111.116L44.9309 108.769L44.6725 106.6L44.7048 106.406L46.4006 108.024L48.1691 109.562L49.2916 110.145L50.8259 110.97L54.6536 110.315L56.85 110.331H56.8177L55.4853 111.982L54.1044 113.884L52.4409 115.543L52.5459 117.898L53.0466 120.197L53.305 122.504L53.1273 122.536L51.4638 121.022L47.8945 117.996L45.5931 118.384L43.2512 118.522L41.1759 118.967L40.9578 118.789L42.5648 117.097L43.873 115.147L45.2943 113.374Z"
                    fill="currentColor"
                />
                <path
                    d="M79.7759 113.253L81.9804 113.771L84.2254 114.434L86.3573 114.904L86.5268 115.001L84.4434 116.069L82.4165 117.235L81.4878 118.109L80.2039 119.282L79.5578 123.119L78.823 125.199V125.158L77.7167 123.353L76.3762 121.419L75.3668 119.299L73.1137 118.619L70.78 118.327L68.527 117.817L68.5512 117.631L70.5296 116.563L72.5485 115.373L74.5592 114.192L74.9468 111.885L75.5929 109.619L75.8594 107.514L76.1016 107.361L77.1675 109.441L78.5727 111.326L79.7759 113.253Z"
                    fill="currentColor"
                />
                <path
                    d="M63.3587 88.9155L65.6198 89.1097L67.9374 89.4578L70.1097 89.6196L70.2954 89.6844L68.3816 91.036L66.5404 92.4847L65.749 93.4721L64.6427 94.8238L64.5458 98.7086L64.1017 100.87V100.829L62.7531 99.2104L61.1542 97.4784L59.846 95.5198L57.5284 95.1718L55.1785 95.2122L52.8689 95.0261V94.8399L54.6778 93.5045L56.5109 92.0396L58.3278 90.5827L58.3924 88.2437L58.7154 85.9128L58.6831 83.7923L58.9012 83.6061L60.2417 85.5081L61.9052 87.1754L63.3587 88.9155Z"
                    fill="currentColor"
                />
                <path
                    d="M55.4126 125.353L53.0304 124.576L48.484 123.588L48.5971 123.345L51.2215 123.054L53.7007 123.289L54.9281 123.143L56.204 123.175L55.2996 122.293L53.8299 120.48L50.9954 117.639H51.06L54.1287 119.946L57.4153 121.889L57.0358 117.947L56.1475 114.127L56.6562 114.005L57.9806 117.599L59.4907 121.087L60.8392 117.769L62.6966 114.685L62.7208 114.637L61.9375 118.19L61.566 121.605L64.6104 119.614L67.679 117.291L67.9455 117.728L65.5552 120.715L62.6966 123.362L63.5768 123.135L64.9415 123.24L68.9549 123.272L70.7477 123.224L70.8446 123.637L68.6804 124.3L65.854 124.915L64.3601 125.094L63.1246 125.466L64.9092 126.704L66.7585 127.91L68.64 129.051L69.5364 129.61L69.5525 129.755L68.422 129.335L66.7665 128.978L65.7894 128.371L62.1636 127.538L63.7787 130.816L65.3937 134.231L64.9415 134.555L62.9792 131.293L61.4207 129.65L60.6858 128.833L60.0963 129.747L59.951 132.24L59.4261 135.987L59.0788 135.979L58.562 132.248L58.3197 128.201L55.7276 131.245L53.418 134.239L53.1112 134.037L54.9685 130.694L56.527 127.344L52.8608 128.299L49.13 129.561L49.1462 129.577L49.1058 129.456L49.8164 128.63L51.6899 127.683L53.628 126.599L54.492 125.895L55.3723 125.353H55.4126Z"
                    fill="currentColor"
                />
                <path
                    d="M43.8892 84.0513L41.8946 82.5378L37.9134 80.1016L38.1072 79.9074L40.6833 80.4982L42.9444 81.5342L44.1476 81.8013L45.3508 82.2545L44.7774 81.1214L43.9861 78.9281L43.2028 77.3175L42.2418 75.3103L42.3064 75.3346L44.4383 78.5234L46.9093 81.4371L47.8461 77.5845L48.2579 73.6916L48.7747 73.7401L48.8555 77.5684L49.1381 81.3561L51.488 78.6691L54.2579 76.3624L54.2982 76.33L52.4005 79.4299L50.9228 82.5297L54.4517 81.6475L58.1179 80.4658L58.2228 80.9676L54.9846 83.0072L51.4154 84.5612L52.3198 84.6421L53.5795 85.1844L57.3588 86.536L59.0708 87.0783L59.0304 87.4991L56.7612 87.4101L53.8945 87.0702L52.4248 86.7464L51.1327 86.6898L52.4167 88.4461L53.7653 90.1943L55.1704 91.8939L55.8406 92.7113L55.8003 92.857L54.8716 92.0881L53.418 91.2059L52.6993 90.3076L49.55 88.3327L50.0022 91.9586L50.4059 95.7221L49.873 95.8759L49.0897 92.1529L48.161 90.0809L47.7249 89.0693L46.869 89.7329L45.9161 92.0477L44.196 95.4065L43.8649 95.2932L44.6079 91.5944L45.698 87.6934L42.2579 89.7167L39.0924 91.7806L38.8663 91.4973L41.725 88.9479L44.2849 86.2932L40.5137 85.9937L36.5729 85.9613L36.5891 85.9775V85.848L37.5258 85.3058L39.6092 85.0225L41.7896 84.634L42.8394 84.2536L43.8488 84.0351L43.8892 84.0513Z"
                    fill="currentColor"
                />
                <path
                    d="M67.8405 106.211L69.4556 107.765L68.9307 109.959L69.1084 112.144L68.3574 112.767L67.5741 113.722L66.282 115.511L64.0451 115.381L61.9456 115.859L60.1932 114.612L58.344 113.528L57.6979 111.496L56.9631 109.449L57.5687 108.469L58.0452 107.247L58.6589 105.386L60.6616 104.657L62.4543 103.395L64.5297 104.131L66.6615 104.406L67.8405 106.211Z"
                    fill="currentColor"
                />
                <path
                    d="M73.251 87.8148L71.6844 89.4173L69.5041 88.8669L67.3237 89.0207L66.7019 88.2599L65.7571 87.4667L63.9967 86.1475L64.1501 83.9056L63.6898 81.8013L64.9496 80.0531L66.0559 78.2158L68.0909 77.5926L70.142 76.8804L71.1191 77.4955L72.3304 77.9811L74.1797 78.6205L74.8822 80.6358L76.1258 82.4488L75.3667 84.5126L75.0679 86.6574L73.251 87.8148Z"
                    fill="currentColor"
                />
                <path
                    d="M50.9712 95.5603L53.0385 94.7104L54.8231 96.0702L56.8904 96.7824L57.165 97.7293L57.7222 98.83L58.8285 100.732L57.811 102.739L57.4072 104.86L55.5661 105.96L53.8299 107.223L51.7141 106.996L49.55 106.843L48.8959 105.896L47.9672 104.965L46.5136 103.662L46.659 101.525L46.2229 99.3723L47.733 97.7698L48.8474 95.9164L50.9712 95.5603Z"
                    fill="currentColor"
                />
                <path
                    d="M37.76 99.1214L39.8273 98.2716L41.62 99.6313L43.6873 100.352L43.9618 101.29L44.519 102.391L45.6254 104.301L44.6079 106.3L44.2041 108.421L42.3549 109.53L40.6267 110.784L38.5029 110.558L36.3387 110.412L35.6927 109.457L34.7641 108.534L33.3105 107.223L33.4559 105.086L33.0198 102.933L34.5218 101.331L35.6362 99.4775L37.76 99.1214Z"
                    fill="currentColor"
                />
                <path
                    d="M76.7718 124.357L78.9925 124.576L79.9374 126.623L81.4232 128.226L81.2213 129.189L81.189 130.427L81.2779 132.629L79.4367 133.915L78.0881 135.591L75.9401 135.704L73.8244 135.996L72.0559 134.79L70.2147 133.64L70.0855 132.491L69.7059 131.237L69.0357 129.399L70.1743 127.586L70.7961 125.474L72.8795 124.778L74.7288 123.669L76.7718 124.357Z"
                    fill="currentColor"
                />
                <path
                    d="M76.6507 94.9613L78.4515 93.2212L81.4555 89.652L81.617 89.8705L80.648 92.331L79.2671 94.411L78.823 95.5684L78.2012 96.6853L79.4044 96.2887L81.6897 95.8435L83.3855 95.3175L85.5174 94.67L85.4851 94.7266L82.0208 96.3534L78.7584 98.3606L82.4165 99.8741L86.1957 100.87L86.0665 101.38L82.2873 100.87L78.5 100.578L80.7934 103.314L82.6426 106.414L82.6668 106.454L79.9051 104.099L77.0706 102.165L77.4017 105.79L78.0074 109.603L77.4986 109.627L75.9805 106.114L74.9953 102.343L74.7772 103.225L74.0505 104.39L72.1366 107.927L71.3372 109.538L70.9334 109.433L71.3695 107.199L72.1447 104.415L72.6857 103.006L72.9361 101.736L71.0061 102.739L69.0842 103.808L67.1865 104.941L66.282 105.475L66.1447 105.41L67.0411 104.617L68.1313 103.314L69.1326 102.731L71.5552 99.9146L67.9213 99.8094L64.1421 99.6313L64.0775 99.089L67.8648 98.8786L70.0532 98.2716L71.1191 97.9964L70.5862 97.0495L68.4543 95.7464L65.4018 93.5288L65.5714 93.2212L69.1003 94.5162L72.7826 96.1996L71.3129 92.4766L69.7544 89.0288L70.0774 88.8507L72.1528 92.072L74.3816 95.018L75.2537 91.3193L75.8836 87.4263L75.8674 87.4344L75.9885 87.4586L76.3842 88.4703L76.3439 90.5747L76.3923 92.8004L76.6103 93.893L76.6749 94.929L76.6507 94.9613Z"
                    fill="currentColor"
                />
                <path
                    d="M36.3791 119.112L35.62 121.249L34.7075 123.418L33.9969 125.482L33.8919 125.644L33.0682 123.442L32.1315 121.298L31.3724 120.278L30.3469 118.87L26.6161 117.793L24.6457 116.822L24.678 116.838L26.5918 115.932L28.6591 114.815L30.8798 114.046L31.8004 111.877L32.3495 109.586L33.1086 107.401L33.2944 107.442L34.1261 109.538L36.0319 113.811L38.2768 114.459L40.441 115.357L42.5083 115.859L42.6294 116.118L40.4491 116.943L38.4222 118.133L36.3791 119.112Z"
                    fill="currentColor"
                />
                <path
                    d="M7.8006 118.781L5.84637 119.922L3.75486 120.982L1.88139 122.099L1.68758 122.156L2.47897 119.938L3.15729 117.696L3.23804 116.433L3.36725 114.693L1.21114 111.448L0.330931 109.433L0.355157 109.465L2.39821 110.015L4.6916 110.501L6.88001 111.359L8.98767 110.299L10.8773 108.915L12.8719 107.733L12.9849 107.887L12.2743 110.023L11.6121 112.273L10.958 114.523L12.2501 116.466L13.3322 118.562L14.5758 120.278L14.5031 120.553L12.3066 119.768L9.99708 119.363L7.8006 118.781Z"
                    fill="currentColor"
                />
                <path
                    d="M106.303 130.832L104.042 130.63L101.725 130.29L99.5523 130.128L99.3666 130.055L101.289 128.711L103.13 127.263L103.913 126.267L105.019 124.924L105.124 121.031L105.56 118.878V118.91L106.917 120.537L108.516 122.261L109.816 124.228L112.142 124.576L114.484 124.527L116.793 124.713V124.907L114.984 126.243L113.159 127.708L111.334 129.165L111.27 131.504L110.947 133.835L110.979 135.955L110.769 136.141L109.42 134.239L107.765 132.564L106.303 130.832Z"
                    fill="currentColor"
                />
                <path
                    d="M26.2204 104.916L28.6026 105.685L33.149 106.673L33.0359 106.915L30.4115 107.215L27.9324 106.972L26.7049 107.118L25.429 107.094L26.3334 107.968L27.8031 109.789L29.071 111.043L30.6376 112.629H30.573L27.5044 110.315L24.2177 108.372L24.5972 112.322L25.4855 116.134L24.9768 116.255L23.6524 112.67L22.1424 109.182L20.8019 112.492L18.9365 115.584L18.9122 115.624L19.6955 112.079L20.067 108.664L17.0226 110.655L13.954 112.978L13.6875 112.532L16.0778 109.546L18.9365 106.907L18.0562 107.126L16.6915 107.029L12.6781 106.988L10.8854 107.045L10.7885 106.632L12.9607 105.969L15.779 105.345L17.2729 105.175L18.5085 104.803L16.7238 103.557L14.8746 102.359L12.993 101.21L12.0967 100.659L12.0886 100.513L13.2111 100.926L14.8665 101.282L15.8436 101.897L19.4694 102.723L17.8544 99.4532L16.2393 96.0297L16.6915 95.714L18.6538 98.9676L20.2124 100.619L20.9472 101.436L21.5367 100.522L21.6821 98.0207L22.207 94.2815L22.5542 94.2896L23.071 98.0207L23.3213 102.067L25.9054 99.0243L28.215 96.0297L28.5219 96.2239L26.6645 99.5746L25.106 102.925L28.7722 101.97L32.503 100.7L32.4868 100.692L32.5272 100.805L31.8166 101.638L29.9431 102.585L28.005 103.67L27.141 104.374L26.2608 104.916H26.2204Z"
                    fill="currentColor"
                />
                <path
                    d="M95.8134 127.894L97.808 129.407L101.781 131.835L101.595 132.03L99.0193 131.447L96.7502 130.403L95.5469 130.136L94.3518 129.691L94.9252 130.824L95.7165 133.017L97.4608 136.627L97.3962 136.611L95.2562 133.422L92.7852 130.5L91.8485 134.353L91.4447 138.254L90.9279 138.197L90.8471 134.377L90.5645 130.581L88.2065 133.268L85.4367 135.575L85.3963 135.607L87.3021 132.515L88.7718 129.415L85.2429 130.29L81.5847 131.471L81.4798 130.969L84.7099 128.938L88.2792 127.376L87.3747 127.303L86.115 126.753L82.3438 125.401L80.6318 124.859L80.6722 124.438L82.9414 124.527L85.8081 124.867L87.2778 125.199L88.5618 125.255L87.2859 123.491L85.9293 121.751L84.5322 120.043L83.862 119.226L83.9024 119.088L84.831 119.849L86.2765 120.731L87.0033 121.63L90.1526 123.604L89.7004 119.987L89.2967 116.223L89.8216 116.069L90.6129 119.792L91.5416 121.864L91.9696 122.876L92.8256 122.204L93.7865 119.898L95.5066 116.531L95.8296 116.652L95.0947 120.343L94.0046 124.252L97.4446 122.22L100.61 120.156L100.828 120.448L97.9776 122.997L95.4177 125.652L99.1889 125.951L103.13 125.984L103.114 125.96V126.089L102.169 126.639L100.085 126.915L97.9049 127.303L96.8632 127.692L95.8457 127.91L95.8134 127.894Z"
                    fill="currentColor"
                />
                <path
                    d="M16.425 125.903L14.3981 124.956L14.1882 122.714L13.316 120.707L13.8248 119.865L14.2609 118.708L14.9069 116.603L17.0711 116.005L18.9042 114.863L20.9634 115.478L23.0549 115.907L24.3227 117.623L25.6793 119.323L25.4209 120.448L25.3644 121.759L25.3886 123.718L23.7251 125.053L22.4331 126.834L20.2366 126.801L18.1289 127.23L16.425 125.903Z"
                    fill="currentColor"
                />
                <path
                    d="M36.8475 127.182L37.4451 125.021L39.6173 124.438L41.4504 123.248L42.3629 123.612L43.5662 123.855L45.7465 124.147L46.6994 126.178L48.1206 127.805L47.8542 129.942L47.7815 132.078L46.3037 133.616L44.8501 135.235L43.7035 135.17L42.4033 135.332L40.4814 135.68L38.8906 134.247L36.9283 133.276L36.5891 131.099L35.8219 129.076L36.8475 127.182Z"
                    fill="currentColor"
                />
                <path
                    d="M30.6618 134.701L28.5945 135.558L26.8099 134.191L24.7426 133.478L24.468 132.54L23.9109 131.431L22.8045 129.529L23.822 127.53L24.2258 125.409L26.067 124.3L27.8032 123.046L29.9189 123.272L32.0831 123.418L32.7372 124.373L33.6658 125.296L35.1194 126.607L34.974 128.744L35.4101 130.897L33.9081 132.499L32.7937 134.344L30.6618 134.701Z"
                    fill="currentColor"
                />
                <path
                    d="M0.920435 98.7815L0.629724 96.5639L2.41437 95.1799L3.63374 93.3669L4.61893 93.3507L5.82215 93.0998L7.94596 92.5252L9.60947 94.0225L11.5475 94.9694L12.137 97.0414L12.8961 99.0486L12.1209 101.04L11.4183 103.095L10.3282 103.476L9.19763 104.131L7.55834 105.2L5.53951 104.504L3.3511 104.366L2.19633 102.488L0.710477 100.934L0.920435 98.7815Z"
                    fill="currentColor"
                />
                <path
                    d="M4.98231 135.299L3.18152 137.048L0.177502 140.617L0.0159958 140.398L0.985033 137.938L2.36591 135.85L2.81005 134.701L3.43185 133.584L2.22863 133.972L-0.0566816 134.417L-1.7525 134.951L-3.88438 135.599L-3.85208 135.534L-0.379694 133.907L2.87466 131.908L-0.78346 130.395L-4.56271 129.391L-4.4335 128.889L-0.654255 129.391L3.13307 129.691L0.839678 126.947L-1.00957 123.855L-1.03379 123.807L1.72796 126.17L4.5624 128.096L4.23131 124.47L3.62566 120.666L4.13441 120.634L5.65256 124.147L6.63775 127.918L6.85579 127.036L7.58256 125.871L9.49641 122.342L10.2959 120.731L10.6996 120.836L10.2716 123.062L9.48834 125.854L8.94729 127.255L8.69696 128.525L10.627 127.53L12.5489 126.453L14.4466 125.328L15.351 124.786L15.4883 124.851L14.5919 125.652L13.5018 126.955L12.5004 127.53L10.0778 130.346L13.7198 130.46L17.491 130.63L17.5556 131.18L13.7683 131.39L11.5798 131.997L10.5139 132.264L11.0469 133.219L13.1788 134.514L16.2312 136.732L16.0616 137.04L12.5327 135.745L8.85039 134.069L10.3201 137.784L11.8786 141.24L11.5556 141.41L9.48026 138.197L7.25955 135.251L6.37934 138.942L5.74947 142.843L5.76562 142.826L5.64449 142.81L5.2488 141.79L5.28918 139.686L5.24072 137.469L5.02269 136.376L4.95809 135.34L4.98231 135.299Z"
                    fill="currentColor"
                />
            </g>
            <defs>
                <clipPath id="clip0_11493_271080">
                    <rect width="193" height="135" fill="white" />
                </clipPath>
            </defs>
        </svg>
    );
}

PatternSound.displayName = 'FonduePatternSound';

const Memo = memo(PatternSound);

export default Memo;
