/* (c) Copyright Frontify Ltd., all rights reserved. */

import { type ReactElement, memo } from 'react';

function PatternImagery(): ReactElement {
    return (
        <svg
            viewBox="0 0 193 135"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            data-test-id="pattern-imagery"
            className="tw-h-full"
        >
            <g clipPath="url(#clip0_11493_270641)">
                <rect width="193" height="135" fill="#FAFAFA" />
                <path
                    d="M13.0979 20.8087L15.8597 22.5002L18.5972 24.3213L19.5097 22.0389L19.429 20.2664L19.2836 18.324L17.7816 15.7583L16.6592 14.9085L15.9082 14.172L12.6296 13.3303L7.41292 15.0299L5.88669 16.7781L8.67267 18.413L11.3375 20.0236L8.89878 19.368L7.75209 19.708L6.47619 19.7808L4.20702 21.0515L2.18819 23.1477L4.40083 24.3051L6.54079 25.4705L8.6646 26.6846L10.7965 27.8662L12.8638 29.1531L15.0199 30.2781L15.8274 27.8824L14.9553 22.8159L13.0979 20.8087Z"
                    fill="currentColor"
                />
                <path
                    d="M33.367 43.7134L30.1369 43.9481L26.8502 44.0452L27.4236 46.4409L28.5137 47.8411L29.7573 49.3384L32.4626 50.5605L33.8758 50.5929L34.9094 50.7628L38.0668 49.5407L41.3373 45.1297L41.5715 42.815L38.3576 43.0983L35.2566 43.3411L37.6227 42.4589L38.3576 41.5119L39.3589 40.7107L40.4733 38.3555L40.9013 35.4823L38.4383 35.8222L36.0157 36.1135L33.585 36.3564L31.1624 36.6315L28.7318 36.7853L26.3253 37.1252L27.0521 39.5452L30.6941 43.163L33.367 43.7134Z"
                    fill="currentColor"
                />
                <path
                    d="M-1.11458 46.4651L-4.3447 46.6917L-7.63135 46.7889L-7.05801 49.1845L-5.96784 50.5847L-4.72424 52.082L-2.01901 53.3041L-0.605832 53.3365L0.427808 53.5065L3.59333 52.2844L6.85576 47.8734L7.09802 45.5586L3.87597 45.85L0.775046 46.0847L3.14111 45.2025L3.87597 44.2556L4.87731 43.4543L5.9917 41.1072L6.41969 38.2259L3.95672 38.5658L1.53413 38.8572L-0.896543 39.1L-3.31914 39.3752L-5.74981 39.529L-8.15625 39.8689L-7.42947 42.2889L-3.78751 45.9067L-1.11458 46.4651Z"
                    fill="currentColor"
                />
                <path
                    d="M19.5502 8.7817L16.32 9.01642L13.0414 9.11354L13.6148 11.5092L14.705 12.9094L15.9486 14.4067L18.6538 15.6288L20.0589 15.6612L21.1006 15.8312L24.2581 14.609L27.5286 10.1981L27.7627 7.88332L24.5407 8.1666L21.4398 8.4094L23.8058 7.52721L24.5488 6.58027L25.542 5.77901L26.6564 3.42379L27.0925 0.542497L24.6214 0.890519L22.1989 1.18189L19.7763 1.42469L17.3537 1.69987L14.9149 1.85365L12.5166 2.18548L13.2353 4.61354L16.8853 8.23134L19.5502 8.7817Z"
                    fill="currentColor"
                />
                <path
                    d="M45.6254 33.1432L43.8569 35.8626L41.9592 38.5415L44.2041 39.529L45.9807 39.5047L47.9188 39.4156L50.5271 37.9912L51.3992 36.8905L52.1583 36.162L53.1031 32.9004L51.5688 27.6234L49.873 26.037L48.1529 28.7888L46.4652 31.4031L47.2001 28.9831L46.8932 27.8176L46.8528 26.5388L45.6577 24.2322L43.6308 22.1441L42.4114 24.3212L41.1759 26.4336L39.908 28.5218L38.6564 30.618L37.3159 32.6576L36.1288 34.7781L38.4949 35.6602L43.5742 34.9399L45.6254 33.1432Z"
                    fill="currentColor"
                />
                <path
                    d="M-0.113238 2.37974L0.557013 3.74755L1.02538 5.78712L0.435883 7.49485L-0.654284 8.31229L-1.80905 8.82219L-2.35817 8.70078L-4.52236 8.27992L-6.62194 11.2826L-4.64349 12.7233L-2.68926 14.1882L-0.654284 15.5317L1.25957 17.0614L3.18957 18.5506L5.12764 19.7889L7.28375 16.9643L6.88806 15.9121L5.97555 14.5686L6.82346 12.1405L7.75212 10.9832L8.95534 10.4975L10.3201 10.7646L11.604 11.0398L13.954 8.10186L11.7252 6.8069L9.9163 5.14773L7.88132 3.78802L4.98228 1.50564L1.98634 -0.574393L-0.226293 2.39593L-0.113238 2.37974Z"
                    fill="currentColor"
                />
                <path
                    d="M35.3212 29.1369L35.0144 27.6396L35.0628 25.5515L36.0641 24.0461L37.3239 23.52L38.5675 23.3177L39.0682 23.5686L41.0547 24.5236L42.807 23.0182L43.8407 22.136L42.2821 20.2502L40.7559 18.3401L39.1166 16.5353L37.6469 14.5767L36.1449 12.6504L34.5783 10.9669L31.7842 13.1603L31.9054 14.2772L32.4545 15.8069L31.0252 17.9516L29.8462 18.8338L28.5541 19.0038L27.2944 18.413L26.1315 17.8222L23.1194 20.0802L24.9606 21.8851L26.293 23.949L27.9242 25.77L30.1692 28.7079L32.5514 31.4678L35.4343 29.145L35.3212 29.1369Z"
                    fill="currentColor"
                />
                <path
                    d="M52.8447 26.4256L54.3386 26.1342L56.4221 26.2071L57.916 27.2187L58.4167 28.4894L58.6105 29.7439L58.3521 30.2376L57.383 32.2205L59.7329 35.0371L61.6306 33.4912L63.5526 31.9858L65.3776 30.3671L67.3399 28.9103L69.286 27.4292L70.9818 25.8752L68.8177 23.0506L67.7033 23.1639L66.169 23.69L64.0452 22.2412L63.173 21.0515L63.0196 19.7565L63.6252 18.502L64.2309 17.3366L62.0102 14.3015L60.1852 16.1225L58.1098 17.4337L56.2767 19.0443L53.3211 21.2619L50.5432 23.6252L52.8285 26.5389L52.8447 26.4256Z"
                    fill="currentColor"
                />
                <path
                    d="M60.9684 -0.323494L60.9038 1.20618L60.3547 3.22147L59.0223 4.44359L57.6737 4.63784L56.414 4.53262L55.9941 4.16841L54.2902 2.76014L51.0116 4.40312L52.0695 6.61265L53.0869 8.83837L54.2417 10.9913L55.1946 13.2413L56.1879 15.4751L57.3023 17.4904L60.5485 16.0335L60.6939 14.9247L60.5324 13.306L62.4301 11.574L63.7948 10.9993L65.0869 11.145L66.1609 12.0272L67.1541 12.8851L70.6184 11.4202L69.2699 9.21877L68.4704 6.89593L67.3318 4.73496L65.8621 1.34377L64.2147 -1.90982L60.8554 -0.363962L60.9684 -0.323494Z"
                    fill="currentColor"
                />
                <path
                    d="M41.5877 11.1531L40.659 9.94714L39.7869 8.05325L40.013 6.25649L40.9174 5.22862L41.951 4.4921L42.5082 4.5002L44.7128 4.47592L45.6253 2.35541L46.1583 1.10901L43.9295 0.105415L41.7169 -0.938649L39.4558 -1.83703L37.2754 -2.94584L35.0789 -4.01419L32.9309 -4.83163L31.3885 -1.61851L31.9942 -0.671563L33.157 0.46153L32.8179 3.01099L32.1476 4.33023L31.0655 5.05056L29.6766 5.07484L28.3684 5.05865L26.6564 8.40937L29.1032 9.22682L31.2109 10.4894L33.472 11.404L36.7828 13.047L40.1341 14.4714L41.7007 11.1126L41.5877 11.1531Z"
                    fill="currentColor"
                />
                <path
                    d="M18.4681 49.7106L17.7332 48.3752L17.168 46.3599L17.6848 44.6279L18.7346 43.7538L19.8651 43.1953L20.4142 43.2925L22.5946 43.6162L23.8301 41.6576L24.565 40.5164L22.5138 39.1729L20.495 37.7889L18.4035 36.5425L16.425 35.1099L14.4224 33.7097L12.4278 32.5604L10.4009 35.4822L10.8531 36.5182L11.8221 37.8212L11.0873 40.2817L10.2151 41.4795L9.03612 42.0218L7.65525 41.8194L6.3632 41.6009L4.15056 44.6441L6.44395 45.8338L8.3255 47.4121L10.4089 48.6747L13.4129 50.8194L16.5058 52.7538L18.5811 49.6863L18.4681 49.7106Z"
                    fill="currentColor"
                />
                <path
                    d="M6.51656 38.0802L5.95129 36.0811L5.00648 34.1954L6.77497 35.3204L8.59999 36.5263L9.52058 34.7457L7.87321 33.556L5.99974 32.4552L8.16392 32.1558L10.2797 32.172L10.1262 30.181L8.03472 30.3105L5.98359 30.44L7.62288 29.2016L9.08451 27.7853L9.13296 27.6882L7.85706 26.3284L6.28238 27.6153L4.63501 28.9103L5.08723 26.8626L5.73325 24.7745L3.64175 24.2403L3.07648 26.3608L2.68078 28.4651L1.7925 26.5146L1.18685 24.3213L-0.67047 25.3087L0.0886096 27.2106L0.629656 29.0317L-2.6247 27.0811L-3.9329 28.6918L-2.08365 29.8734L-0.718922 30.707L-0.428211 30.8527L-0.460511 30.8365L-0.896578 30.8527C-1.39725 30.8689 -1.84947 31.0793 -2.35013 31.0793C-2.61662 31.0793 -2.89118 31.0632 -3.15767 31.0713C-3.43223 31.0793 -3.69064 31.1522 -3.95712 31.1927C-4.0298 31.2007 -4.32859 31.0955 -4.39319 31.1036C-4.53047 31.1279 -4.45779 31.2898 -4.45779 31.3788C-4.44972 31.6378 -4.44164 31.8968 -4.44164 32.1639C-4.43357 32.5605 -4.42549 32.957 -4.40934 33.3455L-2.1967 33.0461L-0.694696 33.0056L-0.29093 32.9975L-0.403984 33.2646L-0.799675 33.6369L-2.22093 34.6162L-2.7539 35.288L-3.3757 35.6765L-2.01097 37.0362L-0.420135 35.7979L1.31606 34.2925L0.839614 36.5506L0.0320827 38.663L2.26895 39.1243L2.4466 36.8096L2.83422 35.9516L3.0361 35.1828L3.86786 36.9471L4.78844 38.7844L6.51656 38.0802Z"
                    fill="currentColor"
                />
                <path
                    d="M21.4237 37.6917L22.1262 35.7412L22.4654 33.6612L23.2487 35.6117L24.0239 37.6593L25.8086 36.7529L25.1625 34.8266L24.2662 32.8356L26.1962 33.8554L27.9081 35.1018L28.9418 33.3941L27.1733 32.2772L25.429 31.1845L27.4882 31.136L29.499 30.8365L29.5959 30.7799L29.3455 28.9264L27.3186 29.0559L25.2271 29.1531L26.7857 27.7529L28.5219 26.4336L27.141 24.7664L25.4532 26.1585L23.9028 27.6396L24.3146 25.5352L25.0979 23.3986L23.0145 23.1153L22.5219 25.1063L21.9001 26.895L20.39 23.4067L18.3873 23.957L19.2029 25.9966L19.8247 27.4696L19.9782 27.761L19.962 27.7286L19.5986 27.4858C19.1868 27.2106 18.6942 27.1135 18.2824 26.8221C18.0643 26.6683 17.8544 26.4903 17.6283 26.3365C17.4021 26.1827 17.1518 26.0937 16.9096 25.9642C16.845 25.9318 16.6673 25.6728 16.6027 25.6405C16.4816 25.5757 16.4412 25.7538 16.3927 25.8266C16.2474 26.0451 16.102 26.2556 15.9567 26.4741C15.7386 26.7978 15.5125 27.1297 15.2945 27.4534L17.2649 28.4975L18.5085 29.3392L18.8396 29.5658L18.5892 29.7115L18.0482 29.7843L16.3201 29.752L15.5044 29.9867L14.7696 29.9381L15.0845 31.8401L17.0953 31.7592L19.3806 31.5487L17.6848 33.1108L15.8032 34.3572L17.3537 36.0406L18.8476 34.2601L19.6632 33.7906L20.2689 33.2807L19.9136 35.1989L19.5986 37.2304L21.4237 37.6917Z"
                    fill="currentColor"
                />
                <path
                    d="M46.2875 2.46065L47.9995 1.29518L49.4934 -0.194029L48.9846 1.84554L48.4113 3.95795L50.3897 4.2736L50.9954 2.33115L51.4395 0.194459L52.4005 2.15309L53.0546 4.16838L54.8877 3.3914L54.1125 1.44896L53.3453 -0.461115L55.0411 0.712446L56.8419 1.65939L56.955 1.67557L57.8433 0.0325889L56.1313 -1.05194L54.387 -2.20932L56.4705 -2.42784L58.6508 -2.4764L58.4974 -4.63737L56.317 -4.50788L54.1851 -4.20842L55.7518 -5.66525L57.6333 -6.93593L56.1151 -8.39277L54.5485 -7.07352L52.9981 -5.98899L53.8217 -9.70392L51.8837 -10.4404L51.3426 -8.31183L50.9792 -6.75788L50.9308 -6.43414L50.9389 -6.4746L50.7935 -6.88737C50.6239 -7.3568 50.2848 -7.72101 50.1152 -8.19852C50.0264 -8.45752 49.9617 -8.71651 49.8729 -8.9755C49.776 -9.23449 49.6307 -9.45302 49.5095 -9.70392C49.4772 -9.76867 49.4853 -10.0843 49.453 -10.1491C49.3884 -10.2705 49.2592 -10.1572 49.1704 -10.1248C48.9281 -10.0358 48.6778 -9.94672 48.4355 -9.8577C48.0641 -9.7282 47.6926 -9.59061 47.3211 -9.46111L48.3063 -7.45392L48.8231 -6.03755L48.9523 -5.65716L48.6616 -5.68144L48.1852 -5.94043L46.8124 -6.96021L46.0129 -7.25158L45.4476 -7.72101L44.5836 -5.99709L46.2552 -4.87209L48.2336 -3.69852L45.9483 -3.44763L43.6953 -3.55284L43.9618 -1.27856L46.2148 -1.83701L47.1435 -1.7318L47.9268 -1.78036L46.5136 -0.436835L45.06 1.02L46.2875 2.46065Z"
                    fill="currentColor"
                />
                <path
                    d="M46.4894 22.6216L47.1919 20.6711L47.5311 18.5911L48.3144 20.5416L49.0896 22.5893L50.8743 21.6828L50.2283 19.7565L49.3319 17.7655L51.2619 18.7853L52.9739 20.0317L54.0075 18.324L50.4947 16.1064L52.5539 16.0578L54.5647 15.7583L54.6616 15.7017L54.4113 13.8483L52.3844 13.9778L50.2929 14.0749L51.8514 12.6747L53.5876 11.3555L52.1986 9.70438L50.5109 11.0884L48.9685 12.5695L49.3803 10.4652L50.1636 8.32848L48.0802 8.04521L47.5876 10.0362L46.9658 11.8249L45.4557 8.33658L43.4531 8.88694L44.2687 10.9265L44.8905 12.3995L45.0439 12.6909L45.0277 12.6585L44.6644 12.4157C44.2525 12.1405 43.7599 12.0434 43.3481 11.752C43.13 11.5983 42.9201 11.4202 42.694 11.2664C42.4679 11.1127 42.2175 11.0236 41.9753 10.8941C41.9107 10.8618 41.733 10.6028 41.6684 10.5704C41.5473 10.5056 41.5069 10.6837 41.4585 10.7565C41.3131 10.9751 41.1677 11.1855 41.0224 11.404C40.8044 11.7278 40.5782 12.0596 40.3602 12.3833L42.3306 13.4274L43.5742 14.2691L43.9053 14.4957L43.6549 14.6414L43.1139 14.7143L41.3858 14.6819L40.5702 14.9166L39.8353 14.8681L40.1503 16.77L42.161 16.6891L44.4463 16.4787L42.7424 18.0326L40.8609 19.279L42.4113 20.9625L43.9053 19.1819L44.7209 18.7125L45.3265 18.2026L44.9712 20.1207L44.6563 22.1522L46.4894 22.6216Z"
                    fill="currentColor"
                />
                <path
                    d="M87.6816 11.7925L89.555 14.439L91.3477 17.1989L93.092 15.4669L93.7138 13.7997L94.3437 11.9624L93.9803 9.00829L93.2777 7.78617L92.882 6.81495L90.201 4.73491L84.7421 4.23311L82.6506 5.22862L84.5645 7.84282L86.3733 10.3761L84.403 8.80595L83.2078 8.66027L82.0046 8.22322L79.4205 8.4984L76.7395 9.6234L78.3142 11.5578L79.8243 13.4759L81.294 15.4265L82.7798 17.3608L84.1769 19.368L85.7192 21.2538L87.407 19.368L88.5941 14.3662L87.6816 11.7925Z"
                    fill="currentColor"
                />
                <path
                    d="M89.9588 44.6441L86.9063 43.5757L83.8458 42.3698L83.4258 44.7898L83.8781 46.5137L84.4272 48.3833L86.4299 50.5766L87.7138 51.1675L88.6021 51.7259L91.9857 51.8635L96.7259 49.1036L97.8564 47.0721L94.7878 46.0604L91.8484 45.0487L94.3598 45.1782L95.4177 44.6036L96.6532 44.2637L98.5994 42.5398L100.134 40.0631L97.7272 39.4076L95.3935 38.7115L93.0678 37.975L90.734 37.2628L88.4406 36.4372L86.0988 35.7979L85.8081 38.3068L87.7219 43.082L89.9588 44.6441Z"
                    fill="currentColor"
                />
                <path
                    d="M74.1877 2.33921L71.1352 1.27087L68.0747 0.0568388L67.6548 2.4849L68.107 4.20882L68.6561 6.07033L70.6588 8.26367L71.9428 8.8545L72.8311 9.42104L76.2146 9.55054L80.9548 6.79874L82.0854 4.76727L79.0167 3.74749L76.0692 2.74389L78.5887 2.87338L79.6466 2.29065L80.8741 1.95072L82.8283 0.234895L84.3626 -2.24172L81.9562 -2.90539L79.6224 -3.60143L77.2967 -4.32985L74.9629 -5.04208L72.6695 -5.86762L70.3196 -6.50701L70.037 -3.99802L71.9508 0.769068L74.1877 2.33921Z"
                    fill="currentColor"
                />
                <path
                    d="M103.751 35.8788L101.054 37.6756L98.2521 39.3833L99.9237 41.1801L101.563 41.8599L103.38 42.5479L106.336 42.2727L107.579 41.609L108.564 41.2448L110.712 38.6144L111.391 33.1675L110.454 31.0389L107.789 32.8761L105.213 34.6162L106.836 32.6819L107.014 31.4921L107.49 30.3024L107.296 27.7044L106.255 24.9849L104.276 26.5065L102.314 27.9553L100.327 29.3635L98.349 30.7961L96.3141 32.1396L94.3841 33.6207L96.2091 35.3689L101.159 36.7205L103.751 35.8788Z"
                    fill="currentColor"
                />
                <path
                    d="M97.2992 -7.462L97.3477 -5.94042L96.952 -3.89275L95.7084 -2.57351L94.3841 -2.27405L93.1162 -2.28214L92.6721 -2.61398L90.8713 -3.89275L88.8848 -2.70301L87.7219 -2.01506L88.9413 0.11354L90.1203 2.25832L91.4285 4.31408L92.551 6.49124L93.7057 8.64411L94.9736 10.5704L98.0906 8.87883L98.1552 7.75383L97.8807 6.15131L99.6411 4.2898L100.957 3.60994L102.257 3.6585L103.396 4.46786L104.446 5.24483L107.797 3.52901L106.287 1.43278L105.318 -0.825308L104.018 -2.89725L102.306 -6.17513L100.424 -9.29113L97.1862 -7.49437L97.2992 -7.462Z"
                    fill="currentColor"
                />
                <path
                    d="M101.426 26.9517L101.733 25.4625L102.605 23.5605L104.115 22.5731L105.48 22.5973L106.707 22.9049L107.062 23.3258L108.516 24.993L110.72 24.3051L112.012 23.9085L111.326 21.5533L110.68 19.1981L109.889 16.8833L109.307 14.5038L108.694 12.1405L107.91 9.97145L104.478 10.886L104.155 11.9544L104.05 13.5812L101.894 14.9813L100.457 15.3294L99.205 14.9732L98.2925 13.9292L97.4527 12.9175L93.7946 13.7997L94.7717 16.1954L95.1835 18.6153L95.9588 20.9382L96.8632 24.5236L97.9614 28.0038L101.531 27.0164L101.426 26.9517Z"
                    fill="currentColor"
                />
                <path
                    d="M114.992 32.439L115.622 33.8311L116.042 35.8707L115.404 37.5703L114.29 38.3554L113.111 38.8329L112.578 38.6953L110.422 38.2097L109.049 40.0712L108.233 41.1558L110.179 42.6531L112.085 44.1746L114.088 45.5748L115.953 47.1531L117.843 48.6989L119.749 49.9858L121.985 47.2259L121.614 46.1656L120.742 44.7897L121.654 42.386L122.615 41.261L123.835 40.8077L125.191 41.1072L126.459 41.4228L128.89 38.5496L126.701 37.198L124.941 35.4822L122.946 34.0739L120.112 31.7025L117.173 29.5496L114.879 32.4471L114.992 32.439Z"
                    fill="currentColor"
                />
                <path
                    d="M137.442 14.0506L136.779 15.4265L135.479 17.0614L133.775 17.6522L132.459 17.3042L131.345 16.7052L131.103 16.2115L130.093 14.2367L127.784 14.3743L126.435 14.4472L126.54 16.8995L126.597 19.3437L126.806 21.7718L126.79 24.2241L126.823 26.6684L127.049 28.9588L130.602 28.9103L131.175 27.9472L131.676 26.3932L134.098 25.5596L135.576 25.5677L136.707 26.2151L137.345 27.4534L137.918 28.6351L141.673 28.6675L141.302 26.1099L141.487 23.6576L141.294 21.2214L141.286 17.5227L141.051 13.8806L137.361 13.9696L137.442 14.0506Z"
                    fill="currentColor"
                />
                <path
                    d="M117.181 14.6981L116.801 13.2251L116.745 11.1369L117.665 9.57488L118.901 8.99215L120.136 8.72506L120.645 8.95168L122.68 9.8096L124.36 8.21517L125.345 7.28442L123.689 5.47956L122.066 3.64233L120.346 1.91841L118.78 0.040715L117.181 -1.80461L115.533 -3.40713L112.852 -1.07619L113.03 0.032621L113.652 1.53802L112.336 3.73945L111.197 4.69449L109.921 4.9292L108.637 4.39503L107.442 3.86086L104.551 6.26463L106.473 7.98046L107.91 9.97145L109.63 11.7116L112.013 14.5362L114.532 17.1666L117.302 14.7062L117.181 14.6981Z"
                    fill="currentColor"
                />
                <path
                    d="M80.3249 42.4103L79.6062 41.0668L79.0652 39.0515L79.5901 37.3195L80.656 36.4616L81.7946 35.9112L82.3357 36.0083L84.516 36.3564L85.7758 34.4139L86.5106 33.2727L84.4756 31.913L82.473 30.5128L80.3976 29.2502L78.4272 27.7934L76.4488 26.3689L74.4622 25.2035L72.403 28.101L72.8391 29.1369L73.8001 30.4562L73.041 32.9085L72.1608 34.0983L70.9656 34.6243L69.5928 34.4139L68.3089 34.1792L66.0639 37.1981L68.3412 38.4121L70.2066 40.0065L72.2819 41.2934L75.2617 43.4706L78.3303 45.4373L80.438 42.3941L80.3249 42.4103Z"
                    fill="currentColor"
                />
                <path
                    d="M74.8256 25.0416L75.0921 22.9858L74.9791 20.8815L76.1581 22.6216L77.3532 24.4507L78.9037 23.1801L77.862 21.4318L76.5618 19.6756L78.6614 20.2583L80.5995 21.1081L81.2374 19.2223L79.2671 18.5101L77.329 17.814L79.3236 17.3284L81.2294 16.6081L81.3182 16.5353L80.6802 14.779L78.7341 15.3374L76.7153 15.8797L77.9346 14.1801L79.3478 12.5209L77.6359 11.2016L76.2792 12.9256L75.0841 14.7061L75.0356 12.5613L75.3425 10.3033L73.2429 10.4732L73.1864 12.5209L72.9683 14.4067L70.7476 11.323L68.9145 12.2862L70.142 14.1072L71.0625 15.4103L71.2725 15.6612L71.2483 15.6288L70.8445 15.4669C70.3842 15.2808 69.8835 15.297 69.4152 15.1027C69.1648 14.9975 68.9307 14.8761 68.6803 14.7709C68.4219 14.6657 68.1635 14.6333 67.897 14.5604C67.8243 14.5443 67.5982 14.3257 67.5336 14.3095C67.4044 14.2772 67.3964 14.4552 67.3641 14.5362C67.2671 14.779 67.1702 15.0218 67.0733 15.2646C66.928 15.6288 66.7826 16.0011 66.6292 16.3653L68.7853 16.9642L70.1823 17.5227L70.5538 17.6765L70.3438 17.8707L69.8351 18.0569L68.1393 18.3968L67.3883 18.8015L66.6615 18.9148L67.3802 20.7115L69.3264 20.2016L71.5148 19.5056L70.1823 21.3914L68.6076 23.0101L70.4811 24.3212L71.5632 22.2655L72.2577 21.6342L72.7422 21.011L72.8068 22.9615L72.9279 25.0173L74.8256 25.0416Z"
                    fill="currentColor"
                />
                <path
                    d="M87.2212 34.3167L88.6344 32.8032L89.765 31.0227L89.7165 33.127L89.6277 35.3122L91.6304 35.1827L91.8 33.1513L91.7676 30.966L93.1405 32.6656L94.2145 34.4948L95.8376 33.3374L94.6505 31.6135L93.4796 29.9219L95.3854 30.6908L97.3558 31.2169L97.4688 31.2088L97.9695 29.412L96.0637 28.7241L94.1095 27.9795L96.0879 27.3077L98.2037 26.7817L97.5819 24.7097L95.4823 25.3167L93.4796 26.0613L94.6828 24.2888L96.2414 22.6378L94.4406 21.5451L93.205 23.18L91.9292 24.5802L91.9211 20.7763L89.87 20.4849L89.8134 22.6863L89.8053 24.2888L89.8296 24.6207L89.8215 24.5802L89.5873 24.216C89.3208 23.7951 88.9009 23.5119 88.6425 23.0829C88.4971 22.8563 88.376 22.6135 88.2387 22.3788C88.0934 22.1441 87.8996 21.966 87.7219 21.7475C87.6735 21.6908 87.6169 21.3833 87.5685 21.3266C87.4797 21.2214 87.3747 21.3671 87.302 21.4156C87.084 21.5532 86.8659 21.6989 86.6398 21.8365C86.3087 22.0469 85.9776 22.2574 85.6466 22.4759L87.0436 24.2241L87.8592 25.4948L88.0692 25.8347L87.7784 25.8752L87.2535 25.7295L85.6789 25.0092L84.831 24.8959L84.1769 24.564L83.7166 26.4417L85.59 27.1701L87.7784 27.8824L85.6062 28.6351L83.3855 29.0317L84.1446 31.1926L86.2199 30.1486L87.1486 30.0433L87.9076 29.8167L86.8256 31.4354L85.7273 33.1755L87.2212 34.3167Z"
                    fill="currentColor"
                />
                <path
                    d="M125.401 11.1612L127.436 10.7646L129.391 9.98765L128.115 11.663L126.758 13.3788L128.454 14.4553L129.778 12.9094L131.03 11.1207L131.143 13.306L130.941 15.4184L132.936 15.4346L132.992 13.3384L133.041 11.2826L134.131 13.0308L135.415 14.6172L135.512 14.6738L136.973 13.5164L135.835 11.833L134.688 10.0767L136.683 10.6999L138.701 11.5254L139.412 9.48586L137.353 8.74125L135.294 8.16661L137.304 7.44629L139.533 7.02543L138.718 5.08298L136.763 5.67381L134.914 6.0542L137.135 2.97057L135.641 1.52992L134.308 3.27003L133.364 4.5569L133.194 4.84017L133.21 4.8078L133.234 4.37075C133.259 3.86895 133.097 3.39953 133.129 2.89773C133.146 2.63064 133.194 2.36356 133.21 2.08838C133.226 1.8132 133.178 1.5542 133.162 1.27902C133.154 1.20618 133.291 0.914816 133.283 0.850067C133.275 0.712477 133.105 0.769132 133.016 0.761038C132.758 0.744851 132.5 0.728665 132.241 0.712478C131.845 0.688197 131.458 0.663916 131.062 0.639635L131.175 2.87345L131.086 4.37884L131.054 4.78352L130.804 4.64593L130.465 4.21697L129.609 2.71158L128.987 2.12075L128.656 1.46518L127.186 2.71158L128.276 4.40312L129.625 6.26463L127.42 5.59287L125.393 4.60546L124.739 6.79881L127.025 7.1792L127.84 7.64053L128.583 7.90762L126.758 8.57938L124.852 9.34017L125.401 11.1612Z"
                    fill="currentColor"
                />
                <path
                    d="M116.171 29.2583L117.584 27.7448L118.715 25.9642L118.667 28.0685L118.578 30.2538L120.58 30.1243L120.75 28.0928L120.718 25.9076L122.09 27.6072L123.164 29.4363L124.788 28.279L123.601 26.555L122.43 24.8635L124.335 25.6324L126.306 26.1585L126.419 26.1504L126.919 24.3536L125.014 23.6656L123.059 22.921L125.038 22.2493L127.154 21.7232L126.532 19.6513L124.432 20.2583L122.43 21.0029L123.633 19.2304L125.191 17.5793L123.391 16.4867L122.155 18.1216L120.879 19.5218L120.871 15.7178L118.82 15.4264L118.763 17.6279L118.755 19.2304L118.78 19.5622L118.771 19.5218L118.537 19.1576C118.271 18.7367 117.851 18.4534 117.592 18.0245C117.447 17.7978 117.326 17.555 117.189 17.3203C117.043 17.0856 116.85 16.9076 116.672 16.689C116.623 16.6324 116.567 16.3248 116.518 16.2682C116.43 16.1629 116.325 16.3086 116.252 16.3572C116.034 16.4948 115.816 16.6405 115.59 16.7781C115.259 16.9885 114.928 17.1989 114.597 17.4174L115.994 19.1656L116.809 20.4363L117.019 20.7763L116.728 20.8167L116.204 20.671L114.629 19.9507L113.781 19.8374L113.127 19.5056L112.667 21.3833L114.54 22.1117L116.728 22.8239L114.556 23.5766L112.335 23.9732L113.095 26.1342L115.17 25.0901L116.099 24.9849L116.858 24.7583L115.776 26.377L114.677 28.1171L116.171 29.2583Z"
                    fill="currentColor"
                />
                <path
                    d="M161.45 47.3473L163.856 45.1782L166.384 43.0658L164.462 41.5362L162.742 41.1072L160.844 40.6944L157.961 41.3986L156.822 42.2403L155.91 42.7502L154.166 45.6558L154.295 51.1513L155.53 53.118L157.896 50.9085L160.19 48.8122L158.865 50.9651V52.163L158.575 53.4094L159.14 55.9507L160.569 58.4921L162.305 56.6953L164.034 54.9714L165.794 53.288L167.538 51.5721L169.363 49.9534L171.051 48.1971L168.992 46.7403L163.896 46.1333L161.45 47.3473Z"
                    fill="currentColor"
                />
                <path
                    d="M150.612 66.5532L148.65 63.9714L146.761 61.2762L145.081 63.073L144.516 64.7565L143.95 66.618L144.419 69.5559L145.162 70.7538L145.59 71.7169L148.343 73.6917L153.818 74.0074L155.878 72.9309L153.867 70.3896L151.969 67.9291L154.004 69.4264L155.199 69.5236L156.411 69.912L158.987 69.5559L161.627 68.3338L159.98 66.4561L158.413 64.5865L156.871 62.6926L155.312 60.8068L153.843 58.8563L152.244 57.0271L150.621 58.9696L149.611 64.0119L150.612 66.5532Z"
                    fill="currentColor"
                />
                <path
                    d="M188.332 34.5919L191.369 35.725L194.397 36.9957L194.865 34.5757L194.453 32.8518L193.937 30.9741L191.982 28.7403L190.714 28.1252L189.834 27.5425L186.459 27.3401L181.662 29.9948L180.483 32.002L183.536 33.0784L186.459 34.1549L183.939 33.9687L182.873 34.5272L181.638 34.8428L179.651 36.5182L178.069 38.9624L180.459 39.6747L182.776 40.4193L185.086 41.1962L187.404 41.957L189.689 42.823L192.015 43.5191L192.354 41.0101L190.537 36.2025L188.332 34.5919Z"
                    fill="currentColor"
                />
                <path
                    d="M151.8 37.708L151.089 40.8725L150.249 44.0533L152.704 44.1909L154.351 43.5434L156.144 42.7745L158.082 40.5326L158.518 39.181L158.97 38.2341L158.712 34.851L155.425 30.4562L153.285 29.5659L152.631 32.7385L151.977 35.7817L151.816 33.2646L151.113 32.2772L150.637 31.0956L148.707 29.3555L146.074 28.1171L145.703 30.5857L145.283 32.9894L144.822 35.3932L144.394 37.797L143.845 40.1765L143.482 42.5884L146.001 42.5803L150.507 40.1198L151.8 37.708Z"
                    fill="currentColor"
                />
                <path
                    d="M180.822 18.6073L182.914 21.0839L184.941 23.6819L186.532 21.8042L187.008 20.0884L187.476 18.2026L186.863 15.2889L186.055 14.1315L185.579 13.1927L182.728 11.3636L177.245 11.3231L175.242 12.5047L177.382 14.9409L179.401 17.3042L177.301 15.9121L176.098 15.8716L174.863 15.5398L172.311 16.0335L169.735 17.3851L171.471 19.1738L173.135 20.9625L174.766 22.7754L176.421 24.5803L177.98 26.458L179.676 28.1981L181.194 26.1828L181.961 21.092L180.822 18.6073Z"
                    fill="currentColor"
                />
                <path
                    d="M137.886 48.7961L139.032 49.7997L140.26 51.4912L140.373 53.2961L139.687 54.4777L138.822 55.4004L138.273 55.4975L136.117 55.9508L135.35 59.5443L137.732 60.0946L140.098 60.6855L142.497 61.1225L144.847 61.7862L147.205 62.4094L149.474 62.7898L150.362 59.3419L149.587 58.5326L148.23 57.6423L148.069 55.0767L148.472 53.6522L149.393 52.7295L150.75 52.4463L152.034 52.2035L153.059 48.5776L150.499 48.2538L148.19 47.4283L145.8 46.975L142.238 46.0038L138.669 45.2592L137.781 48.8608L137.886 48.7961Z"
                    fill="currentColor"
                />
                <path
                    d="M175.759 28.3842L174.241 28.2466L172.262 27.6072L171.108 26.2151L170.97 24.8554L171.132 23.6009L171.511 23.1962L172.989 21.5533L172.052 19.4408L171.503 18.1944L169.258 19.1576L166.989 20.0721L164.801 21.1324L162.507 21.9822L160.23 22.8725L158.179 23.9004L159.479 27.2106L160.577 27.413L162.201 27.3239L163.84 29.3068L164.349 30.6989L164.147 31.9858L163.21 33.0218L162.314 33.9687L163.614 37.5056L165.875 36.2592L168.225 35.5631L170.429 34.5191L173.877 33.2079L177.196 31.7025L175.807 28.2709L175.759 28.3842Z"
                    fill="currentColor"
                />
                <path
                    d="M173.385 8.77363L174.475 7.71337L176.26 6.62884L178.061 6.66122L179.183 7.44629L180.023 8.39323L180.079 8.94359L180.346 11.1369L182.558 11.8087L183.859 12.2053L184.602 9.87435L185.385 7.5596L186.023 5.20438L186.879 2.90582L187.694 0.599168L188.26 -1.63464L184.908 -2.80821L184.044 -2.10407L183.043 -0.817199L180.483 -0.873854L179.094 -1.39184L178.262 -2.38734L178.085 -3.77133L177.956 -5.07439L174.435 -6.40173L173.902 -3.87655L172.884 -1.63464L172.23 0.72057L170.97 4.19269L169.937 7.69719L173.433 8.87884L173.385 8.77363Z"
                    fill="currentColor"
                />
                <path
                    d="M152.51 -3.05912L153.948 -2.55732L155.716 -1.4566L156.507 0.178289L156.314 1.52991L155.853 2.71156L155.385 3.01102L153.552 4.24124L153.956 6.51552L154.182 7.85904L156.596 7.47055L159.019 7.13063L161.401 6.63692L163.832 6.36174L166.246 6.05419L168.491 5.55239L168.031 2.02361L167.005 1.56228L165.415 1.25473L164.3 -1.06002L164.139 -2.53304L164.655 -3.73898L165.802 -4.51595L166.908 -5.22009L166.497 -8.96739L164.009 -8.30372L161.555 -8.19851L159.164 -7.72099L155.498 -7.28394L151.921 -6.62836L152.437 -2.962L152.51 -3.05912Z"
                    fill="currentColor"
                />
                <path
                    d="M160.359 17.2151L158.938 17.7655L156.879 18.065L155.232 17.3284L154.505 16.1711L154.101 14.9732L154.263 14.4391L154.868 12.3186L153.1 10.8293L152.058 9.95525L150.459 11.8168L148.836 13.6378L147.326 15.556L145.654 17.3365L143.999 19.1333L142.602 20.9705L145.234 23.3662L146.308 23.0587L147.73 22.2655L150.063 23.3177L151.137 24.3374L151.517 25.5838L151.137 26.9274L150.75 28.1738L153.471 30.7718L154.949 28.6594L156.758 26.9921L158.276 25.082L160.795 22.3788L163.113 19.5623L160.351 17.1018L160.359 17.2151Z"
                    fill="currentColor"
                />
                <path
                    d="M190.278 47.4849L189.027 48.3509L187.089 49.1279L185.312 48.8042L184.343 47.8491L183.665 46.7808L183.697 46.2223L183.794 44.0128L181.719 42.993L180.507 42.386L179.385 44.5713L178.238 46.7241L177.221 48.9418L176.009 51.0704L174.83 53.2071L173.902 55.3195L177.019 57.0272L177.996 56.4768L179.183 55.368L181.711 55.8374L182.986 56.582L183.649 57.699L183.6 59.091L183.519 60.4022L186.774 62.288L187.71 59.8761L189.075 57.8365L190.101 55.6189L191.918 52.3977L193.509 49.1117L190.246 47.3716L190.278 47.4849Z"
                    fill="currentColor"
                />
                <path
                    d="M176.074 58.6054L174.007 58.5812L171.931 58.9454L173.514 57.5695L175.194 56.1612L173.756 54.761L172.149 55.9993L170.558 57.4966L170.89 55.3357L171.511 53.3042L169.565 52.8833L169.089 54.9229L168.628 56.9301L167.91 54.9957L166.973 53.1828L166.892 53.1018L165.229 53.9436L166.004 55.8213L166.779 57.7718L164.946 56.752L163.137 55.538L162.031 57.3995L163.896 58.5488L165.794 59.5281L163.678 59.8276L161.409 59.7871L161.821 61.859L163.856 61.6729H165.746L162.952 64.2385L164.122 65.9544L165.786 64.5137L166.973 63.4454L167.199 63.2026L167.175 63.2349L167.062 63.6558C166.933 64.1414 167.005 64.6351 166.868 65.1207C166.795 65.3797 166.698 65.6306 166.626 65.8977C166.553 66.1648 166.553 66.4319 166.513 66.699C166.505 66.7718 166.319 67.0227 166.303 67.0956C166.287 67.2331 166.464 67.2089 166.545 67.2331C166.795 67.2979 167.046 67.3707 167.296 67.4355C167.676 67.5407 168.055 67.6459 168.435 67.743L168.782 65.5335L169.17 64.0767L169.275 63.6882L169.493 63.8743L169.735 64.3599L170.268 66.011L170.752 66.7152L170.946 67.4274L172.642 66.5047L171.915 64.627L170.97 62.5308L172.989 63.6396L174.774 65.0155L175.856 63.0002L173.692 62.1666L172.989 61.5434L172.311 61.1306L174.233 60.8393L176.252 60.4751L176.074 58.6054Z"
                    fill="currentColor"
                />
                <path
                    d="M179.974 44.1746L178.311 42.9444L176.413 42.0299L178.505 41.8356L180.685 41.6738L180.33 39.6989L178.303 39.7718L176.139 40.0631L177.665 38.5011L179.344 37.2142L178.004 35.7331L176.429 37.1171L174.887 38.4768L175.428 36.4858L175.719 34.4624L175.694 34.3491L173.853 34.0577L173.393 36.0407L172.884 38.0721L171.988 36.1782L171.221 34.1306L169.242 34.9966L170.09 37.02L171.067 38.93L169.178 37.9345L167.361 36.5748L166.489 38.493L168.249 39.5371L169.783 40.6459L166.02 41.0991L165.972 43.1791L168.16 42.9849L169.743 42.8068L170.066 42.7421L170.026 42.7502L169.686 43.0254C169.299 43.341 169.073 43.7862 168.677 44.1018C168.467 44.2718 168.241 44.4175 168.031 44.5874C167.813 44.7655 167.659 44.9759 167.466 45.1702C167.409 45.2268 167.118 45.3239 167.07 45.3725C166.973 45.4696 167.126 45.5586 167.183 45.6315C167.345 45.8338 167.514 46.0362 167.676 46.2385C167.926 46.5461 168.176 46.8536 168.419 47.1531L169.985 45.5586L171.148 44.6036L171.463 44.3527L171.536 44.636L171.455 45.1702L170.93 46.8212L170.922 47.6711L170.663 48.359L172.577 48.6018L173.078 46.6513L173.53 44.3932L174.532 46.4732L175.186 48.6423L177.237 47.6387L175.961 45.6962L175.751 44.7817L175.444 44.0532L177.18 44.9435L179.029 45.8338L179.974 44.1746Z"
                    fill="currentColor"
                />
                <path
                    d="M200.478 24.9445L198.814 23.7143L196.916 22.7997L199.008 22.6054L201.188 22.4436L200.833 20.4687L198.806 20.5416L196.642 20.833L198.168 19.2709L199.848 17.984L198.507 16.5029L196.932 17.8869L195.39 19.2466L195.931 17.2556L196.222 15.2322L196.198 15.1189L194.356 14.8276L193.896 16.8105L193.387 18.842L192.491 16.9481L191.724 14.9004L189.745 15.7664L190.593 17.7898L191.57 19.6999L189.689 18.6963L187.872 17.3366L187 19.2547L188.76 20.2988L190.295 21.4076L186.531 21.8608L186.483 23.9409L188.671 23.7466L190.254 23.5686L190.577 23.5038L190.537 23.5119L190.198 23.7871C189.81 24.1027 189.584 24.5479 189.188 24.8635C188.978 25.0335 188.752 25.1792 188.542 25.3491C188.324 25.5272 188.171 25.7376 187.977 25.9319C187.92 25.9885 187.63 26.0857 187.581 26.1342C187.484 26.2313 187.638 26.3204 187.694 26.3932C187.856 26.5955 188.025 26.7979 188.187 27.0002C188.437 27.3078 188.688 27.6153 188.93 27.9148L190.496 26.3204L191.659 25.3653L191.974 25.1144L192.047 25.3977L191.966 25.9319L191.441 27.583L191.433 28.4328L191.175 29.1207L193.089 29.3635L193.589 27.413L194.041 25.1549L195.043 27.2349L195.697 29.404L197.748 28.4004L196.472 26.458L196.262 25.5434L195.955 24.815L197.692 25.7053L199.541 26.5955L200.478 24.9445Z"
                    fill="currentColor"
                />
                <path
                    d="M150.201 11.7277L149.571 9.75291L148.578 7.8914L150.386 8.96784L152.244 10.1171L153.116 8.30417L151.436 7.16298L149.522 6.12701L151.67 5.7628L153.786 5.71424L153.568 3.73133L151.485 3.91748L149.442 4.11173L151.049 2.82485L152.47 1.35993L152.518 1.25471L151.202 -0.0645331L149.668 1.2709L148.061 2.61442L148.448 0.550575L149.03 -1.55374L146.922 -2.02317L146.421 0.113524L146.09 2.23403L145.146 0.315862L144.467 -1.8613L142.634 -0.81723L143.45 1.06047L144.047 2.85723L140.736 1.00381L139.477 2.65489L141.358 3.77989L142.747 4.57306L143.046 4.71065L143.014 4.69446L142.578 4.71874C142.077 4.75111 141.633 4.96964 141.132 4.99392C140.866 5.00201 140.591 4.99392 140.325 5.01011C140.05 5.02629 139.792 5.10723 139.525 5.15579C139.452 5.17198 139.154 5.06676 139.089 5.08295C138.952 5.10723 139.024 5.2691 139.032 5.35813C139.049 5.61712 139.065 5.87611 139.073 6.13511C139.097 6.53169 139.113 6.92018 139.137 7.31676L141.342 6.94446L142.844 6.85543L143.248 6.83924L143.143 7.10633L142.763 7.49482L141.366 8.5146L140.858 9.19446L140.244 9.60723L141.649 10.9265L143.199 9.6396L144.871 8.09374L144.459 10.3599L143.716 12.4966L145.969 12.8932L146.074 10.5704L146.438 9.70435L146.615 8.93546L147.495 10.6756L148.473 12.4885L150.201 11.7277Z"
                    fill="currentColor"
                />
                <path
                    d="M172.723 15.7906L171.059 14.5604L169.161 13.6459L171.253 13.4516L173.433 13.2897L173.078 11.3149L171.051 11.3878L168.887 11.6791L170.413 10.1171L172.093 8.83022L170.752 7.3491L169.178 8.73309L167.635 10.0928L168.176 8.1018L168.467 6.07842L168.443 5.96511L166.602 5.67374L166.141 7.65666L165.633 9.68813L164.736 7.79425L163.969 5.74658L161.991 6.61259L162.839 8.63597L163.816 10.546L161.926 9.55054L160.109 8.19083L159.237 10.109L160.997 11.1531L162.532 12.2619L158.769 12.7151L158.72 14.7951L160.909 14.6009L162.491 14.4228L162.814 14.3581L162.774 14.3662L162.435 14.6414C162.047 14.957 161.821 15.4022 161.425 15.7178C161.215 15.8878 160.989 16.0335 160.779 16.2034C160.561 16.3815 160.408 16.5919 160.214 16.7861C160.158 16.8428 159.867 16.9399 159.818 16.9885C159.721 17.0856 159.875 17.1746 159.931 17.2475C160.093 17.4498 160.262 17.6522 160.424 17.8545C160.674 18.162 160.925 18.4696 161.167 18.7691L162.734 17.1746L163.896 16.2196L164.211 15.9687L164.284 16.252L164.203 16.7861L163.678 18.4372L163.67 19.287L163.412 19.975L165.326 20.2178L165.826 18.2673L166.279 16.0092L167.28 18.0892L167.934 20.2583L169.985 19.2547L168.709 17.3122L168.499 16.3977L168.192 15.6692L169.929 16.5595L171.778 17.4498L172.723 15.7906Z"
                    fill="currentColor"
                />
                <path
                    d="M142.271 36.7853L140.607 35.5551L138.709 34.6405L140.801 34.4463L142.981 34.2844L142.626 32.3096L140.591 32.3743L138.427 32.6657L139.953 31.1037L141.633 29.8168L140.292 28.3357L138.718 29.7197L137.175 31.0794L137.716 29.0884L138.007 27.065L137.983 26.9517L136.142 26.6603L135.681 28.6432L135.172 30.6747L134.276 28.7808L133.509 26.7332L131.547 27.5992L132.395 29.6225L133.372 31.5326L131.482 30.5371L129.665 29.1774L128.793 31.0956L130.553 32.1396L132.088 33.2484L128.325 33.7017L128.276 35.7817L130.465 35.5875L132.047 35.4094L132.37 35.3447L132.33 35.3528L131.991 35.6279C131.603 35.9436 131.377 36.3887 130.981 36.7044C130.771 36.8743 130.545 37.02 130.335 37.19C130.117 37.368 129.964 37.5785 129.77 37.7727C129.714 37.8294 129.423 37.9265 129.374 37.9751C129.278 38.0722 129.431 38.1612 129.487 38.2341C129.649 38.4364 129.819 38.6387 129.98 38.8411C130.23 39.1486 130.481 39.4562 130.723 39.7556L132.29 38.1612L133.452 37.2062L133.767 36.9553L133.84 37.2385L133.759 37.7727L133.234 39.4238L133.226 40.2736L132.968 40.9616L134.882 41.2044L135.382 39.2538L135.835 36.9957L136.836 39.0758L137.49 41.2448L139.541 40.2412L138.265 38.2988L138.055 37.3842L137.749 36.6558L139.485 37.5461L141.334 38.4364L142.271 36.7853Z"
                    fill="currentColor"
                />
                <path
                    d="M116.252 57.9013L115.477 61.0497L114.572 64.2143L117.019 64.4004L118.683 63.7853L120.492 63.0569L122.478 60.8554L122.938 59.52L123.415 58.5812L123.221 55.19L120.031 50.7224L117.907 49.7916L117.189 52.9481L116.47 55.9831L116.357 53.458L115.687 52.4625L115.226 51.2646L113.337 49.484L110.728 48.1891L110.301 50.6495L109.832 53.0452L109.331 55.4328L108.847 57.8366L108.249 60.1999L107.829 62.6036L110.357 62.6522L114.912 60.2808L116.252 57.9013Z"
                    fill="currentColor"
                />
                <path
                    d="M103.041 83.9138L101.846 80.903L100.764 77.7951L98.6559 79.0658L97.6546 80.5307L96.6048 82.1737L96.2656 85.1279L96.6532 86.4795L96.8066 87.5235L98.9224 90.1701L104.107 91.9669L106.376 91.4894L105.132 88.4948L103.969 85.6054L105.52 87.6045L106.65 88.0253L107.708 88.7295L110.284 89.0856L113.159 88.6243L112.085 86.3743L111.076 84.1485L110.107 81.9066L109.121 79.6728L108.233 77.3905L107.183 75.1971L105.1 76.6216L102.758 81.1944L103.041 83.9138Z"
                    fill="currentColor"
                />
                <path
                    d="M129.156 62.3689L127.961 59.3581L126.879 56.2502L124.771 57.5209L123.77 58.9858L122.72 60.6288L122.381 63.5749L122.769 64.9346L122.922 65.9786L125.038 68.6252L130.222 70.4139L132.5 69.9445L131.248 66.9499L130.085 64.0605L131.635 66.0596L132.766 66.4804L133.824 67.1846L136.4 67.5407L139.275 67.0794L138.201 64.8294L137.191 62.6036L136.222 60.3617L135.237 58.1279L134.349 55.8456L133.299 53.6522L131.216 55.0767L128.874 59.6495L129.156 62.3689Z"
                    fill="currentColor"
                />
                <path
                    d="M111.189 98.0694L108.072 97.2034L104.947 96.1998L104.68 98.6441L105.245 100.328L105.916 102.157L108.056 104.22L109.372 104.722L110.292 105.232L113.676 105.143L118.23 102.084L119.224 99.9795L116.099 99.1701L113.095 98.3527L115.622 98.3203L116.632 97.6728L117.843 97.252L119.676 95.4067L121.041 92.841L118.602 92.3392L116.228 91.7969L113.862 91.2142L111.479 90.6557L109.138 89.984L106.755 89.4984L106.634 92.0236L108.855 96.653L111.189 98.0694Z"
                    fill="currentColor"
                />
                <path
                    d="M133.598 40.9211L133.137 42.3698L132.08 44.1747L130.473 45.0002L129.116 44.8383L127.929 44.4013L127.622 43.94L126.346 42.1351L122.753 42.8554L123.197 45.2673L123.601 47.6792L124.15 50.0587L124.481 52.4867L124.844 54.8986L125.401 57.1405L128.906 56.5901L129.342 55.5542L129.617 53.9517L131.894 52.7781L133.364 52.5839L134.567 53.0695L135.374 54.2026L136.109 55.2871L139.832 54.7934L139.113 52.3087L138.952 49.8563L138.419 47.4687L137.886 43.8105L137.151 40.2412L133.509 40.8482L133.598 40.9211Z"
                    fill="currentColor"
                />
                <path
                    d="M115.049 81.6477L116.381 80.9031L118.384 80.3203L120.12 80.814L120.992 81.8662L121.566 82.9912L121.477 83.5416L121.17 85.7349L123.132 86.957L124.279 87.6774L125.603 85.6135L126.96 83.5739L128.187 81.4696L129.601 79.4705L130.981 77.4552L132.112 75.448L129.173 73.4408L128.147 73.8941L126.855 74.8815L124.392 74.1693L123.189 73.3033L122.64 72.1216L122.825 70.7457L123.035 69.4507L119.983 67.2574L118.812 69.564L117.253 71.4579L116.018 73.5622L113.902 76.5973L111.996 79.7052L115.073 81.761L115.049 81.6477Z"
                    fill="currentColor"
                />
                <path
                    d="M123.415 95.8923L124.142 97.2277L124.699 99.243L124.182 100.975L123.132 101.841L121.994 102.399L121.452 102.31L119.272 101.979L118.029 103.929L117.302 105.078L119.345 106.422L121.356 107.806L123.447 109.052L125.426 110.493L127.42 111.901L129.415 113.051L131.45 110.129L131.006 109.101L130.037 107.798L130.771 105.329L131.644 104.14L132.831 103.597L134.203 103.8L135.495 104.026L137.716 100.983L135.431 99.7853L133.549 98.207L131.466 96.9445L128.462 94.7916L125.377 92.8491L123.294 95.9085L123.415 95.8923Z"
                    fill="currentColor"
                />
                <path
                    d="M150.814 97.2439L149.353 97.6485L147.269 97.7295L145.703 96.823L145.105 95.6009L144.823 94.3626L145.041 93.8527L145.864 91.7969L144.257 90.1377L143.312 89.1584L141.536 90.8419L139.727 92.4849L138.031 94.2412L136.174 95.8356L134.349 97.4543L132.774 99.1297L135.132 101.792L136.238 101.59L137.732 100.951L139.945 102.246L140.906 103.371L141.156 104.649L140.639 105.944L140.131 107.15L142.561 110.015L144.257 108.065L146.22 106.6L147.932 104.852L150.717 102.432L153.318 99.8662L150.822 97.1306L150.814 97.2439Z"
                    fill="currentColor"
                />
                <path
                    d="M134.05 82.2061L134.914 80.9517L136.456 79.5434L138.233 79.2196L139.477 79.77L140.486 80.5308L140.648 81.065L141.342 83.1693L143.635 83.3959L144.984 83.5335L145.267 81.0973L145.59 78.6693L145.759 76.2412L146.147 73.8212L146.502 71.4013L146.631 69.1027L143.119 68.5928L142.4 69.4588L141.665 70.9157L139.146 71.3608L137.684 71.118L136.666 70.3006L136.23 68.9813L135.851 67.7268L132.144 67.1117L132.112 69.6936L131.547 72.0892L131.361 74.5254L130.796 78.1756L130.457 81.8177L134.123 82.2952L134.05 82.2061Z"
                    fill="currentColor"
                />
                <path
                    d="M92.333 74.0235L92.8821 72.5991L94.0449 70.8671L95.6923 70.1387L97.0409 70.3815L98.1956 70.8833L98.4783 71.3608L99.6411 73.2385L101.934 72.9228L103.275 72.7367L102.976 70.3005L102.718 67.8725L102.314 65.4606L102.12 63.0245L101.894 60.5883L101.482 58.3221L97.9453 58.662L97.4527 59.6656L97.0812 61.252L94.7313 62.2879L93.2616 62.3932L92.0826 61.8428L91.3478 60.6611L90.6775 59.5361L86.9306 59.8113L87.5039 62.3284L87.5201 64.7888L87.9157 67.2007L88.2226 70.8833L88.7475 74.5011L92.4218 74.1045L92.333 74.0235Z"
                    fill="currentColor"
                />
                <path
                    d="M97.8403 56.833L99.5685 55.6837L101.079 54.2188L100.546 56.2502L99.948 58.3545L101.926 58.7026L102.556 56.7682L103.033 54.6396L103.97 56.6144L104.591 58.6378L106.432 57.8851L105.681 55.9265L104.939 54.0083L106.618 55.1981L108.411 56.1693L108.524 56.1855L109.428 54.5506L107.733 53.4418L106.004 52.2601L108.088 52.0659L110.268 52.0497L110.139 49.8887L107.951 49.9858L105.827 50.2448L107.41 48.8042L109.315 47.5578L107.813 46.0767L106.231 47.3716L104.664 48.44L105.536 44.7412L103.606 43.9805L103.041 46.101L102.661 47.6549L102.613 47.9786L102.621 47.9382L102.476 47.5254C102.314 47.056 101.975 46.6837 101.813 46.2062C101.733 45.9472 101.668 45.6882 101.579 45.4292C101.49 45.1702 101.345 44.9436 101.224 44.7008C101.192 44.636 101.208 44.3204 101.175 44.2556C101.111 44.1342 100.982 44.2475 100.893 44.2799C100.651 44.3608 100.4 44.4499 100.158 44.5308C99.7865 44.6603 99.415 44.7898 99.0436 44.9193L99.9965 46.9427L100.489 48.3671L100.618 48.7475L100.328 48.7152L99.8511 48.4481L98.4864 47.3878L97.6869 47.0803L97.1297 46.6028L96.2495 48.3186L97.9049 49.4598L99.8672 50.6576L97.5739 50.8842L95.3208 50.7466L95.555 53.0209L97.8161 52.4867L98.7448 52.6001L99.5362 52.5596L98.1068 53.8869L96.6371 55.3276L97.8403 56.833Z"
                    fill="currentColor"
                />
                <path
                    d="M102.71 70.9562L104.777 71.0371L106.86 70.7295L105.245 72.065L103.533 73.4247L104.939 74.8572L106.578 73.6594L108.201 72.2026L107.813 74.3554L107.143 76.3707L109.081 76.8402L109.606 74.8087L110.123 72.8177L110.793 74.7682L111.69 76.6054L111.77 76.6864L113.458 75.8932L112.723 73.9993L112.004 72.0326L113.805 73.0929L115.59 74.3554L116.745 72.5263L114.912 71.3285L113.038 70.3006L115.162 70.0578L117.431 70.1549L117.076 68.0749L115.033 68.2044L113.143 68.1558L116.002 65.6549L114.879 63.9067L113.183 65.2988L111.972 66.3348L111.738 66.5695L111.762 66.5371L111.883 66.1162C112.021 65.6387 111.964 65.1369 112.117 64.6594C112.198 64.4004 112.303 64.1495 112.376 63.8905C112.457 63.6234 112.465 63.3563 112.513 63.0893C112.529 63.0164 112.723 62.7655 112.731 62.7008C112.755 62.5632 112.578 62.5794 112.489 62.5551C112.239 62.4822 111.988 62.4094 111.738 62.3285C111.358 62.2152 110.987 62.1019 110.607 61.9885L110.212 64.19L109.792 65.6387L109.671 66.0191L109.453 65.8249L109.218 65.3312L108.726 63.672L108.257 62.9598L108.08 62.2475L106.36 63.1297L107.038 65.0236L107.934 67.1441L105.94 65.9867L104.188 64.5623L103.057 66.5533L105.197 67.4436L105.883 68.083L106.546 68.5119L104.616 68.7547L102.589 69.0623L102.71 70.9562Z"
                    fill="currentColor"
                />
                <path
                    d="M124.626 90.3482L126.693 90.4291L128.777 90.1216L127.162 91.457L125.45 92.8167L126.855 94.2493L128.494 93.0514L130.117 91.5946L129.73 93.7475L129.059 95.7628L130.998 96.2322L131.522 94.2007L132.039 92.2097L132.709 94.1602L133.606 95.9975L133.687 96.0784L135.374 95.2852L134.639 93.3914L133.921 91.4246L135.722 92.4849L137.506 93.7475L138.661 91.9183L136.828 90.7205L134.938 89.6764L137.062 89.4336L139.331 89.5307L138.976 87.4507L136.933 87.5802L135.043 87.5316L137.902 85.0307L136.779 83.2825L135.084 84.6746L133.872 85.7106L133.638 85.9453L133.662 85.9129L133.783 85.4921C133.921 85.0146 133.864 84.5128 134.018 84.0353C134.098 83.7763 134.203 83.5254 134.276 83.2664C134.357 82.9993 134.365 82.7322 134.413 82.4651C134.43 82.3923 134.623 82.1414 134.631 82.0766C134.656 81.939 134.478 81.9552 134.389 81.9309C134.139 81.8581 133.888 81.7852 133.638 81.7043C133.259 81.591 132.887 81.4777 132.508 81.3644L132.112 83.5658L131.692 85.0146L131.571 85.395L131.353 85.2007L131.119 84.707L130.626 83.0478L130.158 82.3356L129.98 81.6234L128.26 82.5056L128.938 84.3995L129.835 86.52L127.84 85.3626L126.088 83.9381L124.957 85.9291L127.097 86.8194L127.784 87.4588L128.446 87.8878L126.516 88.1306L124.489 88.4381L124.626 90.3482Z"
                    fill="currentColor"
                />
                <path
                    d="M167.054 130.023L168.798 127.287L170.672 124.584L168.41 123.621L166.642 123.669L164.696 123.774L162.112 125.223L161.24 126.34L160.489 127.069L159.584 130.346L161.167 135.599L162.887 137.169L164.575 134.409L166.23 131.771L165.528 134.199L165.843 135.364L165.891 136.643L167.118 138.942L169.17 140.998L170.357 138.812L171.576 136.692L172.82 134.587L174.047 132.475L175.371 130.427L176.534 128.291L174.16 127.433L169.089 128.202L167.054 130.023Z"
                    fill="currentColor"
                />
                <path
                    d="M188.001 112.8L185.167 114.37L182.235 115.843L183.754 117.777L185.336 118.586L187.089 119.42L190.06 119.388L191.352 118.821L192.362 118.538L194.72 116.102L195.834 110.72L195.075 108.518L192.273 110.137L189.56 111.658L191.336 109.87L191.611 108.696L192.176 107.547L192.2 104.941L191.377 102.149L189.285 103.5L187.21 104.779L185.118 106.025L183.027 107.296L180.887 108.461L178.844 109.789L180.523 111.675L185.344 113.423L188.001 112.8Z"
                    fill="currentColor"
                />
                <path
                    d="M189.35 67.3222L188.171 64.2952L187.105 61.1873L184.989 62.4418L183.98 63.9067L182.922 65.5335L182.558 68.4876L182.946 69.8474L183.091 70.8914L185.191 73.5542L190.367 75.3752L192.636 74.9139L191.409 71.9112L190.27 69.0218L191.805 71.0209L192.927 71.4499L193.985 72.1702L196.561 72.5344L199.428 72.0893L198.37 69.8312L197.377 67.5974L196.424 65.3554L195.447 63.1135L194.583 60.8312L193.541 58.6297L191.449 60.038L189.083 64.6027L189.35 67.3222Z"
                    fill="currentColor"
                />
                <path
                    d="M162.12 117.494L162.281 120.739L162.314 124.033L164.712 123.507L166.133 122.439L167.651 121.225L168.927 118.538L168.992 117.13L169.178 116.094L168.023 112.897L163.695 109.538L161.385 109.255L161.603 112.484L161.781 115.592L160.949 113.204L160.02 112.444L159.245 111.432L156.919 110.266L154.053 109.781L154.343 112.257L154.586 114.685L154.779 117.122L155.005 119.558L155.11 122.002L155.393 124.414L157.824 123.742L161.514 120.165L162.12 117.494Z"
                    fill="currentColor"
                />
                <path
                    d="M183.988 90.9714L186.935 89.6279L189.972 88.3734L188.599 86.3339L187.089 85.4112L185.401 84.44L182.437 84.2457L181.105 84.7151L180.079 84.9175L177.544 87.1756L176.025 92.4526L176.615 94.7026L179.53 93.3024L182.348 91.9912L180.443 93.6423L180.079 94.7916L179.433 95.8923L179.207 98.4903L179.813 101.339L182.001 100.15L184.173 99.0245L186.354 97.9481L188.534 96.8393L190.755 95.8357L192.895 94.6783L191.36 92.663L186.685 90.5506L183.988 90.9714Z"
                    fill="currentColor"
                />
                <path
                    d="M146.244 140.326L147.148 139.096L148.723 137.736L150.507 137.469L151.743 138.06L152.728 138.853L152.874 139.387L153.495 141.515L155.789 141.807L157.129 141.993L157.485 139.565L157.88 137.145L158.122 134.717L158.591 132.313L159.019 129.909L159.213 127.611L155.716 127.004L154.973 127.846L154.198 129.27L151.662 129.642L150.209 129.359L149.224 128.509L148.82 127.174L148.481 125.911L144.79 125.183L144.677 127.765L144.047 130.136L143.789 132.572L143.11 136.206L142.658 139.824L146.308 140.423L146.244 140.326Z"
                    fill="currentColor"
                />
                <path
                    d="M182.736 102.116L181.242 102.391L179.159 102.294L177.673 101.266L177.18 99.9957L177.003 98.7412L177.269 98.2475L178.254 96.2727L176.793 94.484L175.937 93.4319L174.023 94.9616L172.085 96.4508L170.244 98.0533L168.265 99.4858L166.311 100.951L164.599 102.489L166.731 105.329L167.853 105.232L169.388 104.714L171.495 106.187L172.359 107.385L172.497 108.688L171.875 109.935L171.261 111.092L173.458 114.151L175.299 112.346L177.382 111.051L179.231 109.457L182.211 107.272L185.013 104.933L182.752 101.995L182.736 102.116Z"
                    fill="currentColor"
                />
                <path
                    d="M178.593 82.8617L178.327 81.3644L178.448 79.2763L179.49 77.8033L180.766 77.3177L182.017 77.1558L182.51 77.4229L184.464 78.4346L187.323 76.136L185.821 74.2017L184.359 72.243L182.776 70.3896L181.371 68.3905L179.934 66.4157L178.416 64.6837L175.549 66.788L175.646 67.913L176.139 69.4588L174.653 71.547L173.441 72.4049L172.141 72.5344L170.906 71.895L169.759 71.2718L166.682 73.4328L168.459 75.3024L169.735 77.3986L171.301 79.2682L173.449 82.279L175.751 85.1117L178.706 82.886L178.593 82.8617Z"
                    fill="currentColor"
                />
                <path
                    d="M154.206 76.2979L155.724 76.395L157.719 76.9858L158.914 78.3455L159.084 79.7053L158.954 80.9598L158.583 81.3725L157.145 83.0479L158.131 85.1441L158.712 86.3743L160.941 85.3545L163.178 84.3752L165.35 83.2664L167.611 82.3518L169.864 81.413L171.899 80.3285L170.51 77.0506L169.404 76.8806L167.781 77.0101L166.101 75.0677L165.552 73.6918L165.721 72.4049L166.626 71.3446L167.506 70.3653L166.117 66.8689L163.888 68.172L161.555 68.9247L159.374 70.0254L155.958 71.4256L152.68 73.0119L154.158 76.4031L154.206 76.2979Z"
                    fill="currentColor"
                />
                <path
                    d="M164.93 95.4634L163.711 96.3698L161.797 97.2116L160.012 96.9364L159.011 96.0137L158.3 94.9696L158.316 94.4112L158.341 92.2017L156.233 91.2466L154.997 90.6801L153.956 92.8977L152.874 95.083L151.929 97.333L150.782 99.502L149.668 101.679L148.812 103.816L151.977 105.426L152.938 104.836L154.093 103.694L156.629 104.083L157.929 104.787L158.631 105.888L158.623 107.28L158.583 108.591L161.894 110.372L162.758 107.935L164.05 105.847L165.011 103.597L166.723 100.319L168.209 96.993L164.89 95.35L164.93 95.4634Z"
                    fill="currentColor"
                />
                <path
                    d="M193.428 126.664L192.451 127.837L190.795 129.1L188.994 129.262L187.799 128.598L186.863 127.748L186.749 127.206L186.249 125.053L183.98 124.616L182.655 124.357L182.155 126.761L181.622 129.149L181.234 131.56L180.628 133.932L180.055 136.311L179.724 138.586L183.18 139.403L183.98 138.61L184.828 137.226L187.387 137.007L188.817 137.38L189.753 138.286L190.077 139.638L190.343 140.925L193.977 141.872L194.243 139.298L195.019 136.967L195.422 134.555L196.311 130.962L196.973 127.376L193.363 126.567L193.428 126.664Z"
                    fill="currentColor"
                />
                <path
                    d="M199.613 77.5443L197.611 78.0703L195.705 78.9687L196.868 77.2124L198.111 75.4076L196.351 74.4444L195.132 76.0712L194.001 77.9408L193.751 75.7718L193.807 73.6513L191.821 73.7646L191.902 75.8608L191.99 77.9166L190.787 76.2493L189.398 74.752L189.301 74.7034L187.92 75.9579L189.172 77.5605L190.432 79.2358L188.397 78.7421L186.33 78.0542L185.756 80.1423L187.856 80.7493L189.947 81.1863L187.985 82.0362L185.789 82.6027L186.733 84.4885L188.647 83.7682L190.472 83.2664L188.461 86.4876L190.044 87.8311L191.264 86.002L192.12 84.6585L192.273 84.3671L192.257 84.3995L192.265 84.8365C192.273 85.3383 192.467 85.7997 192.467 86.3015C192.467 86.5685 192.435 86.8437 192.443 87.1108C192.443 87.386 192.507 87.645 192.539 87.9202C192.548 87.993 192.435 88.2844 192.443 88.3572C192.459 88.4948 192.628 88.43 192.717 88.43C192.976 88.43 193.234 88.43 193.5 88.43C193.896 88.43 194.292 88.4301 194.679 88.422L194.421 86.1962L194.405 84.6908V84.2862L194.663 84.4076L195.027 84.8122L195.98 86.261L196.634 86.8033L197.013 87.4346L198.402 86.091L197.199 84.4723L195.729 82.6998L197.974 83.2259L200.066 84.0757L200.574 81.8419L198.265 81.6153L197.417 81.2025L196.658 80.9921L198.434 80.1989L200.284 79.3087L199.613 77.5443Z"
                    fill="currentColor"
                />
                <path
                    d="M184.06 121.541L182.13 120.796L180.063 120.416L182.025 119.671L184.085 118.935L183.213 117.122L181.274 117.729L179.272 118.587L180.33 116.676L181.614 114.985L179.934 113.917L178.787 115.665L177.665 117.389L177.657 115.325L177.398 113.301L177.35 113.204L175.501 113.415L175.581 115.446L175.63 117.542L174.265 115.956L172.981 114.192L171.301 115.551L172.65 117.275L174.096 118.854L172.004 118.4L169.888 117.575L169.557 119.655L171.528 120.189L173.304 120.845L169.791 122.285L170.3 124.301L172.351 123.524L173.829 122.933L174.12 122.787L174.087 122.803L173.837 123.159C173.546 123.572 173.441 124.058 173.151 124.462C172.989 124.681 172.812 124.883 172.658 125.102C172.497 125.328 172.4 125.579 172.27 125.814C172.238 125.879 171.972 126.049 171.939 126.114C171.875 126.235 172.044 126.275 172.117 126.332C172.327 126.486 172.537 126.631 172.755 126.785C173.078 127.012 173.401 127.247 173.716 127.473L174.798 125.515L175.662 124.284L175.896 123.961L176.042 124.212L176.106 124.754L176.034 126.486L176.252 127.311L176.187 128.048L178.093 127.773L178.052 125.757L177.891 123.459L179.409 125.199L180.612 127.109L182.324 125.587L180.58 124.058L180.128 123.232L179.635 122.617L181.541 123.014L183.56 123.378L184.06 121.541Z"
                    fill="currentColor"
                />
                <path
                    d="M156.354 90.5829L155.224 88.8428L153.77 87.3131L155.797 87.8635L157.896 88.4786L158.252 86.5038L156.33 85.8563L154.206 85.3626L156.184 84.4399L158.211 83.8329L157.477 81.9795L155.522 82.716L153.6 83.4444L154.804 81.7691L155.781 79.9804L155.797 79.8671L154.174 78.9444L153.051 80.636L151.864 82.3599L151.687 80.2718V78.0865L149.53 78.1998L149.611 80.3932L149.853 82.5218L148.432 80.9273L147.205 79.0092L145.719 80.4984L147.003 82.0928L148.053 83.671L144.37 82.7727L143.595 84.6989L145.711 85.2816L147.253 85.6782L147.576 85.7349L147.536 85.7268L147.124 85.8644C146.656 86.0263 146.276 86.3581 145.8 86.5119C145.541 86.5928 145.283 86.6575 145.024 86.7385C144.758 86.8275 144.54 86.9732 144.29 87.0865C144.225 87.1189 143.91 87.1027 143.845 87.1351C143.724 87.1917 143.837 87.3293 143.862 87.4183C143.942 87.6692 144.031 87.912 144.112 88.1629C144.241 88.5353 144.362 88.9075 144.491 89.2879L146.518 88.341L147.94 87.8554L148.319 87.734L148.287 88.0254L148.02 88.5029L146.946 89.8626L146.639 90.6557L146.155 91.2142L147.859 92.1126L149.014 90.4615L150.225 88.5029L150.435 90.8014L150.281 93.0595L152.559 92.841L152.05 90.5748L152.171 89.6441L152.139 88.8509L153.447 90.2915L154.868 91.7727L156.354 90.5829Z"
                    fill="currentColor"
                />
                <path
                    d="M176.47 90.7853L174.54 90.0407L172.472 89.6603L174.435 88.9157L176.494 88.1792L175.622 86.3662L173.684 86.9732L171.681 87.8311L172.739 85.9211L174.023 84.2295L172.343 83.1612L171.196 84.9094L170.074 86.6333L170.066 84.5695L169.808 82.5461L169.759 82.449L167.91 82.6594L167.991 84.6909L168.039 86.7871L166.674 85.2008L165.39 83.4364L163.711 84.7961L165.059 86.52L166.505 88.0982L164.413 87.645L162.297 86.8195L161.966 88.8995L163.937 89.4337L165.713 90.0892L162.201 91.5299L162.709 93.5452L164.76 92.7682L166.238 92.1774L166.529 92.0317L166.497 92.0479L166.246 92.404C165.956 92.8168 165.851 93.3024 165.56 93.7071C165.398 93.9256 165.221 94.1279 165.067 94.3464C164.906 94.5731 164.809 94.824 164.68 95.0587C164.647 95.1234 164.381 95.2934 164.349 95.3581C164.284 95.4795 164.454 95.52 164.526 95.5767C164.736 95.7304 164.946 95.8761 165.164 96.0299C165.487 96.2565 165.81 96.4912 166.125 96.7178L167.207 94.7592L168.071 93.529L168.306 93.2052L168.451 93.4561L168.515 93.9984L168.443 95.7304L168.661 96.556L168.596 97.2925L170.502 97.0173L170.462 95.002L170.3 92.7035L171.818 94.4436L173.022 96.3536L174.733 94.832L172.989 93.3024L172.537 92.4768L172.044 91.8617L173.95 92.2583L175.969 92.6225L176.47 90.7853Z"
                    fill="currentColor"
                />
                <path
                    d="M132.79 133.568L129.786 134.774L126.79 136.125L126.257 133.73L126.629 131.989L127.089 130.096L128.987 127.813L130.238 127.158L131.094 126.551L134.47 126.259L139.339 128.792L140.559 130.767L137.539 131.925L134.656 133.074L137.159 132.823L138.241 133.349L139.493 133.632L141.52 135.259L143.167 137.655L140.801 138.432L138.491 139.241L136.206 140.083L133.913 140.9L131.652 141.831L129.342 142.584L128.938 140.091L130.626 135.235L132.79 133.568Z"
                    fill="currentColor"
                />
                <path
                    d="M7.17877 127.975L6.22588 124.867L5.13572 121.767L7.57446 121.435L9.27028 121.953L11.1114 122.577L13.2272 124.665L13.7601 125.968L14.2931 126.874L14.3012 130.274L11.3699 134.919L9.30258 135.971L8.40622 132.855L7.50986 129.877L7.54216 132.402L6.92844 133.438L6.54082 134.66L4.75618 136.546L2.2286 137.987L1.66333 135.559L1.05768 133.187L0.411657 130.832L-0.210142 128.469L-0.944995 126.138L-1.49412 123.766L1.01731 123.572L5.70099 125.676L7.17877 127.975Z"
                    fill="currentColor"
                />
                <path
                    d="M55.9698 116.62L59.1192 117.372L62.3331 118.012L61.3803 120.286L60.0801 121.484L58.6104 122.755L55.7356 123.524L54.3386 123.321H53.2969L50.3736 121.597L47.8703 116.709L48.0156 114.386L51.1408 115.195L54.1609 115.94L51.9725 114.685L51.3992 113.625L50.5432 112.678L49.8326 110.169L49.8729 107.264L52.2552 108L54.597 108.688L56.9469 109.328L59.2968 109.991L61.671 110.542L63.9886 111.27L62.8742 113.536L58.6912 116.515L55.9698 116.62Z"
                    fill="currentColor"
                />
                <path
                    d="M130.796 120.319L133.945 121.071L137.167 121.711L136.214 123.977L134.906 125.183L133.436 126.453L130.57 127.214L129.173 127.02L128.123 127.012L125.208 125.296L122.696 120.408L122.842 118.085L125.975 118.894L128.995 119.639L126.806 118.384L126.225 117.324L125.377 116.369L124.658 113.868L124.707 110.954L127.081 111.699L129.423 112.379L131.781 113.018L134.123 113.69L136.497 114.24L138.814 114.969L137.708 117.235L133.525 120.213L130.796 120.319Z"
                    fill="currentColor"
                />
                <path
                    d="M95.6196 138.893L96.9278 141.863L98.3652 144.826L95.983 145.433L94.2387 145.117L92.341 144.712L89.9992 142.875L89.3128 141.645L88.6829 140.803L88.2872 137.428L90.6613 132.475L92.5913 131.188L93.843 134.183L95.0785 137.04L94.7475 134.539L95.2481 133.438L95.4904 132.176L97.0489 130.095L99.3908 128.372L100.231 130.719L101.103 133.001L102.015 135.267L102.912 137.55L103.905 139.775L104.729 142.066L102.249 142.551L97.3558 141.006L95.6196 138.893Z"
                    fill="currentColor"
                />
                <path
                    d="M73.2268 118.222L74.5269 121.193L75.9643 124.155L73.5901 124.762L71.8459 124.446L69.9401 124.042L67.6063 122.212L66.9199 120.974L66.2901 120.132L65.8944 116.757L68.2685 111.812L70.1985 110.525L71.4502 113.512L72.6776 116.369L72.3546 113.868L72.8472 112.767L73.0895 111.505L74.648 109.425L76.9899 107.701L77.8378 110.048L78.7099 112.33L79.6224 114.596L80.5107 116.879L81.504 119.105L82.3276 121.395L79.8566 121.881L74.963 120.335L73.2268 118.222Z"
                    fill="currentColor"
                />
                <path
                    d="M153.73 114.208L152.357 114.872L150.734 116.183L150.144 117.89L150.491 119.21L151.089 120.327L151.59 120.569L153.56 121.573L153.431 123.888L153.358 125.239L150.911 125.142L148.473 125.094L146.05 124.891L143.603 124.908L141.164 124.883L138.871 124.657L138.919 121.095L139.88 120.521L141.423 120.019L142.255 117.591L142.238 116.102L141.592 114.977L140.357 114.337L139.178 113.771L139.137 109.999L141.689 110.363L144.136 110.177L146.567 110.363H150.257L153.891 110.59L153.81 114.289L153.73 114.208Z"
                    fill="currentColor"
                />
                <path
                    d="M112.57 138.294L113.111 136.87L113.41 134.806L112.667 133.155L111.512 132.435L110.309 132.03L109.784 132.192L107.66 132.807L106.174 131.034L105.302 129.998L107.151 128.396L108.968 126.753L110.874 125.239L112.65 123.556L114.443 121.897L116.26 120.497L118.658 123.119L118.36 124.195L117.568 125.62L118.626 127.967L119.652 129.035L120.895 129.416L122.228 129.027L123.479 128.639L126.08 131.358L123.972 132.847L122.317 134.66L120.411 136.19L117.722 138.723L114.92 141.054L112.449 138.294H112.57Z"
                    fill="currentColor"
                />
                <path
                    d="M44.5836 136.805L45.7788 135.858L47.0708 134.223L47.2727 132.418L46.6348 131.212L45.8111 130.249L45.27 130.128L43.1301 129.586L42.7424 127.303L42.5163 125.96L44.9228 125.515L47.3131 125.029L49.7276 124.689L52.1017 124.131L54.484 123.613L56.7693 123.329L57.5122 126.81L56.7047 127.586L55.3076 128.42L55.0331 130.97L55.3722 132.41L56.2524 133.373L57.601 133.721L58.8689 134.021L59.741 137.679L57.173 137.89L54.8231 138.618L52.4167 138.974L48.8151 139.783L45.2216 140.374L44.4867 136.74L44.5836 136.805Z"
                    fill="currentColor"
                />
                <path
                    d="M90.8632 131.544L89.442 131.018L87.3747 130.743L85.7354 131.504L85.0248 132.677L84.6372 133.875L84.8067 134.409L85.4447 136.522L83.6924 138.035L82.6668 138.917L81.0436 137.08L79.3963 135.283L77.862 133.381L76.1581 131.625L74.4865 129.853L73.0652 128.04L75.6574 125.604L76.7395 125.895L78.1688 126.672L80.4945 125.587L81.5524 124.551L81.9158 123.305L81.5201 121.962L81.1163 120.715L83.7973 118.085L85.3074 120.181L87.1324 121.816L88.6829 123.71L91.2347 126.381L93.5927 129.165L90.8632 131.666V131.544Z"
                    fill="currentColor"
                />
                <path
                    d="M91.4204 104.552L91.2347 106.066L91.4527 108.146L92.5671 109.57L93.8673 109.983L95.127 110.088L95.6035 109.797L97.5092 108.688L99.3746 110.048L100.481 110.841L99.0678 112.848L97.703 114.88L96.2172 116.814L94.9009 118.878L93.5685 120.917L92.1311 122.722L89.1755 120.756L89.2078 119.639L89.6277 118.06L88.0369 116.045L86.7852 115.252L85.4932 115.187L84.2819 115.883L83.1675 116.571L79.9858 114.556L81.6735 112.605L82.8445 110.444L84.3222 108.494L86.3249 105.386L88.481 102.448L91.5416 104.528L91.4204 104.552Z"
                    fill="currentColor"
                />
                <path
                    d="M108.669 119.048L109.784 118.004L110.955 116.28L111.019 114.467L110.3 113.31L109.404 112.419L108.855 112.33L106.683 111.95L106.126 109.7L105.794 108.381L108.169 107.757L110.51 107.094L112.893 106.576L115.226 105.847L117.56 105.151L119.821 104.698L120.815 108.113L120.064 108.947L118.731 109.878L118.65 112.444L119.095 113.86L120.047 114.75L121.42 114.993L122.712 115.195L123.843 118.789L121.299 119.193L119.014 120.084L116.632 120.618L113.111 121.702L109.566 122.552L108.564 118.991L108.669 119.048Z"
                    fill="currentColor"
                />
                <path
                    d="M28.4249 121.638L29.7573 120.893L31.2997 119.493L31.7923 117.753L31.3563 116.45L30.6941 115.373L30.1853 115.163L28.1665 114.273L28.1504 111.958L28.1423 110.598L30.5891 110.55L33.0278 110.461L35.4666 110.517L37.9053 110.363L40.336 110.234L42.6375 110.331L42.8071 113.884L41.8784 114.515L40.3683 115.106L39.6819 117.583L39.7788 119.064L40.4975 120.157L41.7653 120.715L42.9766 121.217L43.235 124.972L40.6671 124.762L38.2364 125.094L35.7977 125.053L32.1153 125.272L28.4734 125.264L28.3442 121.557L28.4249 121.638Z"
                    fill="currentColor"
                />
                <path
                    d="M12.1693 135.211L13.6875 135.089L15.674 134.458L16.8368 133.074L16.9903 131.714L16.8368 130.46L16.4573 130.055L14.9876 128.404L16.4977 125.053L18.7426 126.033L20.9956 126.971L23.184 128.04L25.4694 128.914L27.7304 129.812L29.7816 130.856L28.4572 134.158L27.3509 134.353L25.7358 134.256L24.0804 136.222L23.5555 137.606L23.7574 138.893L24.678 139.937L25.5663 140.9L24.2419 144.421L21.997 143.158L19.6471 142.446L17.4506 141.386L14.0105 140.051L10.6996 138.521L12.1209 135.097L12.1693 135.211Z"
                    fill="currentColor"
                />
                <path
                    d="M31.5743 137.946L32.4626 136.069L33.6981 134.361L31.7681 135.186L29.7735 136.077L29.1517 134.167L30.9686 133.26L33.0036 132.483L30.9202 131.836L28.8287 131.504L29.3051 129.569L33.3428 130.5L31.9215 129.003L30.7102 127.36L30.6779 127.255L32.1638 126.122L33.5043 127.643L34.9175 129.189L34.8125 127.093L34.5218 124.924L36.6698 124.738L36.8798 126.923L36.9282 129.068L38.1234 127.295L39.0843 125.231L40.7559 126.51L39.6981 128.266L38.8663 129.974L42.3952 128.582L43.4208 130.387L41.4019 131.253L39.9242 131.852L39.6092 131.949L39.6496 131.941L40.0776 132.022C40.5702 132.119 40.982 132.402 41.4746 132.483C41.7411 132.532 42.0076 132.556 42.2741 132.605C42.5486 132.653 42.7828 132.766 43.0493 132.855C43.122 132.88 43.4288 132.823 43.4935 132.839C43.6227 132.88 43.5258 133.033 43.5096 133.123C43.4612 133.382 43.4127 133.632 43.3642 133.891C43.2916 134.28 43.2189 134.668 43.1462 135.057L41.0143 134.393L39.5365 134.102L39.1409 134.029L39.2135 134.312L39.5446 134.749L40.7882 135.947L41.2001 136.692L41.7492 137.177L40.1826 138.294L38.8178 136.813L37.3481 135.041L37.4531 137.347L37.9053 139.565L35.62 139.654L35.8219 137.339L35.5796 136.433L35.507 135.648L34.4007 137.258L33.1894 138.917L31.5743 137.946Z"
                    fill="currentColor"
                />
                <path
                    d="M101.725 107.863L100.223 106.43L98.9951 104.722L99.1647 106.819L99.3827 108.996L97.38 108.988L97.0974 106.972L97.0086 104.787L95.7407 106.568L94.7717 108.453L93.084 107.385L94.1661 105.596L95.232 103.84L93.3747 104.722L91.4366 105.362H91.3236L90.7179 103.597L92.5833 102.804L94.4971 101.954L92.4783 101.396L90.3384 100.991L90.839 98.8869L92.9709 99.3725L95.014 100.004L93.7058 98.3041L92.0503 96.7421L93.7865 95.5523L95.1109 97.1063L96.4675 98.4336L96.2576 94.6378L98.2925 94.2331L98.4783 96.4264L98.5833 98.0209L98.5752 98.3527V98.3122L98.7932 97.9318C99.0355 97.4948 99.4312 97.1872 99.6734 96.7502C99.8026 96.5155 99.9076 96.2646 100.037 96.0298C100.174 95.787 100.352 95.5928 100.513 95.3743C100.554 95.3095 100.602 95.002 100.642 94.9453C100.723 94.8401 100.836 94.9696 100.917 95.0182C101.143 95.1477 101.369 95.2691 101.595 95.3985C101.943 95.5928 102.282 95.787 102.629 95.9732L101.329 97.7942L100.594 99.1054L100.4 99.4615L100.691 99.4777L101.208 99.2996L102.734 98.4903L103.574 98.3284L104.212 97.9561L104.777 99.8014L102.944 100.635L100.804 101.469L103.017 102.092L105.253 102.359L104.616 104.56L102.484 103.638L101.547 103.589L100.78 103.411L101.951 104.965L103.146 106.64L101.725 107.863Z"
                    fill="currentColor"
                />
                <path
                    d="M100.521 130.524L100.15 128.485L100.158 126.372L99.0677 128.169L97.9695 130.063L96.3544 128.873L97.3073 127.077L98.5105 125.256L96.4433 125.943L94.5536 126.899L93.8188 125.045L95.7488 124.236L97.6465 123.443L95.6276 123.054L93.6896 122.431L93.6007 122.366L94.1499 120.577L96.1283 121.031L98.1714 121.468L96.8632 119.833L95.3612 118.247L97.0004 116.838L98.4379 118.489L99.7218 120.205L99.6572 118.06L99.2373 115.827L101.337 115.883L101.498 117.923L101.813 119.792L103.873 116.595L105.754 117.461L104.615 119.339L103.759 120.691L103.558 120.958L103.582 120.926L103.978 120.747C104.43 120.537 104.93 120.529 105.383 120.31C105.625 120.197 105.859 120.051 106.101 119.938C106.352 119.825 106.61 119.776 106.877 119.687C106.949 119.663 107.167 119.436 107.232 119.42C107.361 119.38 107.377 119.558 107.41 119.639C107.523 119.873 107.628 120.108 107.741 120.351C107.902 120.707 108.072 121.071 108.233 121.427L106.117 122.14L104.753 122.763L104.389 122.933L104.607 123.119L105.124 123.281L106.836 123.532L107.603 123.896L108.338 123.969L107.716 125.798L105.746 125.393L103.525 124.81L104.955 126.623L106.61 128.161L104.809 129.569L103.63 127.57L102.904 126.979L102.387 126.381L102.427 128.331L102.411 130.387L100.521 130.524Z"
                    fill="currentColor"
                />
                <path
                    d="M65.6925 136.643L65.321 134.604L65.3291 132.491L64.2389 134.288L63.1407 136.182L61.5256 134.992L62.4785 133.195L63.6817 131.374L61.6144 132.062L59.7248 133.017L58.99 131.164L60.92 130.355L62.8177 129.561L60.7988 129.173L58.8608 128.55L58.7719 128.485L59.3211 126.696L61.2995 127.149L63.3426 127.587L62.0344 125.952L60.5323 124.365L62.1716 122.957L63.609 124.608L64.893 126.324L64.8284 124.179L64.4085 121.945L66.5081 122.002L66.6696 124.042L66.9845 125.911L69.0437 122.714L70.9253 123.58L69.7867 125.458L68.9307 126.81L68.7288 127.077L68.753 127.044L69.1487 126.866C69.6009 126.656 70.1016 126.648 70.5538 126.429C70.7961 126.316 71.0303 126.17 71.2725 126.057C71.5228 125.944 71.7813 125.895 72.0477 125.806C72.1204 125.782 72.3385 125.555 72.4031 125.539C72.5323 125.498 72.5484 125.676 72.5807 125.757C72.6938 125.992 72.7988 126.227 72.9118 126.47C73.0733 126.826 73.2429 127.19 73.4044 127.546L71.2887 128.258L69.9239 128.882L69.5606 129.051L69.7786 129.238L70.2954 129.399L72.0074 129.65L72.7745 130.015L73.5094 130.087L72.8876 131.917L70.9172 131.512L68.6965 130.929L70.1258 132.742L71.7813 134.28L69.9805 135.688L68.8015 133.689L68.0747 133.098L67.5579 132.499L67.5982 134.45L67.5821 136.506L65.6925 136.643Z"
                    fill="currentColor"
                />
                <path
                    d="M24.9768 105.402L22.5219 103.29L19.9539 101.242L21.8355 99.6639L23.5474 99.1945L25.429 98.7331L28.328 99.3725L29.4828 100.19L30.4115 100.676L32.2203 103.541V109.036L31.0333 111.035L28.6187 108.882L26.2688 106.835L27.6416 108.955L27.6739 110.161L27.9969 111.4L27.4882 113.949L26.1235 116.523L24.3469 114.766L22.5784 113.091L20.7776 111.44L18.993 109.773L17.1276 108.194L15.3995 106.487L17.4264 104.973L22.5057 104.245L24.9768 105.402Z"
                    fill="currentColor"
                />
                <path
                    d="M-0.864273 91.9346L-0.0809682 95.0829L0.831542 98.2475L-1.61528 98.4337L-3.27879 97.8266L-5.08766 97.1063L-7.07419 94.9049L-7.54256 93.5695L-8.02708 92.6306L-7.84134 89.2394L-4.65967 84.7637L-2.53586 83.8249L-1.81716 86.9894L-1.08231 90.0164L-0.977328 87.4912L-0.307077 86.4876L0.145141 85.2898L2.03476 83.5092L4.63501 82.2061L5.07108 84.6666L5.53945 87.0623L6.05627 89.4498L6.54886 91.8455L7.14644 94.2169L7.56635 96.6126L5.04686 96.6693L0.484304 94.306L-0.864273 91.9346Z"
                    fill="currentColor"
                />
                <path
                    d="M34.4006 95.5361L35.1839 98.6845L36.0965 101.849L33.6496 102.043L31.9861 101.436L30.1772 100.708L28.1826 98.5065L27.7224 97.171L27.2378 96.2403L27.4236 92.8491L30.6052 88.3734L32.729 87.4345L33.4478 90.591L34.1826 93.618L34.2795 91.0928L34.9578 90.0973L35.4101 88.8995L37.2997 87.1108L39.8999 85.8158L40.336 88.2682L40.8044 90.6719L41.3212 93.0595L41.8138 95.4552L42.4113 97.8185L42.8313 100.214L40.3118 100.271L35.7492 97.9156L34.4006 95.5361Z"
                    fill="currentColor"
                />
                <path
                    d="M4.9338 77.1315L2.89882 79.6567L0.944596 82.2952L-0.694692 80.4579L-1.21151 78.7583L-1.72833 76.8806L-1.17921 73.9588L-0.403981 72.7772L0.0563119 71.8302L2.85844 69.9283L8.34158 69.7664L10.3685 70.8914L8.29313 73.3842L6.32276 75.7961L8.39811 74.3473L9.59326 74.2826L10.8207 73.9265L13.3806 74.3554L15.9889 75.6504L14.2931 77.4795L12.678 79.3006L11.0872 81.154L9.4802 82.9912L7.96204 84.9094L6.3066 86.6899L4.73999 84.707L3.85979 79.6405L4.9338 77.1315Z"
                    fill="currentColor"
                />
                <path
                    d="M23.5474 53.3446L20.9714 51.386L18.2742 49.5002L20.0589 47.8087L21.7385 47.234L23.5959 46.6594L26.5272 47.1207L27.7304 47.8653L28.6833 48.2943L30.6698 51.0461L31.0009 56.5254L29.935 58.5973L27.3912 56.5901L24.9283 54.6962L26.4303 56.7277L26.5272 57.9256L26.931 59.1477L26.5756 61.7214L25.3643 64.368L23.4909 62.7331L21.6174 61.163L19.7197 59.6333L17.8382 58.0712L15.8839 56.6144L14.0589 55.0119L15.9889 53.377L21.0118 52.341L23.5474 53.3446Z"
                    fill="currentColor"
                />
                <path
                    d="M54.5809 109.449L53.3615 108.534L51.4557 107.693L49.6711 107.952L48.6617 108.874L47.951 109.918L47.9672 110.469L47.9753 112.686L45.8676 113.633L44.6321 114.192L43.5984 111.974L42.5244 109.773L41.5877 107.523L40.4491 105.354L39.3508 103.176L38.4949 101.032L41.6765 99.4372L42.6294 100.02L43.7761 101.169L46.3118 100.789L47.62 100.101L48.3225 99.0002V97.6081L48.2821 96.297L51.6011 94.5326L52.4571 96.9687L53.7491 99.0568L54.6939 101.307L56.3897 104.593L57.8675 107.935L54.5486 109.562L54.5809 109.449Z"
                    fill="currentColor"
                />
                <path
                    d="M10.2231 86.779L11.7413 86.609L13.7036 85.9211L14.8342 84.5047L14.9391 83.145L14.7453 81.8905L14.3577 81.4939L12.8315 79.8914L13.7198 77.7547L14.2366 76.5002L16.5138 77.4067L18.7991 78.2727L21.0198 79.2763L23.3294 80.0776L25.6228 80.9112L27.6981 81.8905L26.4788 85.225L25.3805 85.4517L23.7574 85.4031L22.1665 87.4265L21.6901 88.8267L21.9243 90.1054L22.8772 91.1252L23.7978 92.056L22.5865 95.6171L20.3011 94.4193L17.927 93.788L15.6982 92.7925L12.2177 91.5623L8.86649 90.1378L10.1747 86.6738L10.2231 86.779Z"
                    fill="currentColor"
                />
                <path
                    d="M8.76961 70.3248L8.58387 68.8113L7.87325 66.8446L6.44392 65.7358L5.08726 65.6387L3.83559 65.8491L3.44797 66.2457L1.86521 67.7834L-1.53449 66.4075L-0.654284 64.1252L0.185549 61.8266L1.15459 59.5928L1.92982 57.2619L2.73735 54.9552L3.69023 52.859L7.04149 54.0487L7.27567 55.1495L7.25145 56.7763L9.27835 58.3464L10.6835 58.8158L11.9594 58.5649L12.9607 57.5937L13.8813 56.6629L17.4506 57.8446L16.2796 60.1432L15.6659 62.5227L14.705 64.7727L13.5179 68.2691L12.1289 71.6521L8.65655 70.3734L8.76961 70.3248Z"
                    fill="currentColor"
                />
                <path
                    d="M25.3643 75.2538L26.7937 75.7718L28.861 76.0227L30.4922 75.2457L31.1866 74.0722L31.5662 72.8662L31.3885 72.332L30.7344 70.2277L32.4706 68.6981L33.4881 67.7997L35.1274 69.6207L36.799 71.4094L38.3495 73.2871L40.0695 75.0272L41.7572 76.7916L43.1946 78.5883L40.6267 81.0488L39.5446 80.7655L38.1072 80.0047L35.7976 81.1135L34.7479 82.1576L34.3925 83.4121L34.8044 84.7475L35.2243 85.9858L32.5675 88.6486L31.0413 86.5685L29.192 84.9498L27.6254 83.0721L25.0494 80.4256L22.6591 77.6657L25.3643 75.1405V75.2538Z"
                    fill="currentColor"
                />
                <path
                    d="M-3.83596 106.22L-2.56813 107.061L-0.613907 107.79L1.15459 107.426L2.10747 106.446L2.76157 105.362L2.71312 104.803L2.56777 102.602L4.6189 101.525L5.81404 100.894L6.98496 103.047L8.18011 105.176L9.24605 107.369L10.5139 109.473L11.7413 111.577L12.7184 113.666L9.64174 115.454L8.65655 114.92L7.43718 113.844L4.92576 114.37L3.66601 115.139L3.02806 116.28L3.11689 117.672L3.22994 118.975L0.0159668 120.934L-0.977296 118.554L-2.39048 116.539L-3.47257 114.345L-5.35412 111.173L-7.02571 107.927L-3.80366 106.106L-3.83596 106.22Z"
                    fill="currentColor"
                />
                <path
                    d="M10.6189 117L12.6861 116.927L14.7696 117.243L13.1545 115.899L11.4425 114.532L12.8476 113.099L14.4869 114.305L16.1101 115.762L15.7225 113.609L15.0522 111.594L16.9903 111.132L17.5152 113.164L18.0239 115.155L18.6942 113.204L19.5905 111.375L19.6713 111.294L21.3509 112.095L20.6161 113.989L19.8893 115.956L21.6982 114.896L23.4828 113.641L24.6295 115.47L22.7964 116.66L20.9149 117.688L23.0387 117.939L25.3078 117.842L24.9445 119.922L22.9014 119.784L21.0118 119.833L23.8704 122.334L22.7399 124.074L21.0441 122.674L19.8328 121.63L19.5986 121.395L19.6228 121.427L19.744 121.848C19.8812 122.326 19.8247 122.827 19.9701 123.305C20.0508 123.564 20.1558 123.815 20.2285 124.074C20.3092 124.341 20.3173 124.608 20.3658 124.875C20.3819 124.948 20.5676 125.199 20.5838 125.264C20.608 125.401 20.4304 125.385 20.3415 125.409C20.0912 125.482 19.8409 125.555 19.5905 125.636C19.211 125.749 18.8314 125.863 18.46 125.976L18.0643 123.774L17.6444 122.326L17.5232 121.945L17.3052 122.14L17.071 122.633L16.5784 124.292L16.1101 125.005L15.9324 125.717L14.2204 124.835L14.9068 122.941L15.8032 120.82L13.8086 121.97L12.0563 123.394L10.9257 121.403L13.0737 120.521L13.7682 119.881L14.4304 119.461L12.5004 119.218L10.4977 118.894L10.6189 117Z"
                    fill="currentColor"
                />
                <path
                    d="M6.38741 102.667L8.02669 101.396L9.90017 100.433L7.80866 100.287L5.62833 100.174L5.94326 98.1909L7.97017 98.2151L10.1344 98.4499L8.56774 96.9283L6.85577 95.6819L8.1559 94.1765L9.76289 95.52L11.3376 96.8392L10.7481 94.8644L10.4089 92.8491L10.4251 92.7358L12.2582 92.404L12.7588 94.3707L13.316 96.3941L14.1639 94.4759L14.8826 92.4121L16.8853 93.2295L16.0859 95.2691L15.1572 97.1954L17.0226 96.1594L18.8072 94.7592L19.7197 96.6612L17.9836 97.7457L16.4735 98.8869L20.2527 99.2511L20.3496 101.331L18.1612 101.185L16.5704 101.048L16.2474 100.991L16.2877 100.999L16.6269 101.266C17.0226 101.574 17.2649 102.011 17.6605 102.319C17.8786 102.48 18.1047 102.626 18.3227 102.788C18.5408 102.958 18.7023 103.168 18.8961 103.363C18.9526 103.419 19.2514 103.508 19.2998 103.549C19.3967 103.646 19.2433 103.735 19.1868 103.808C19.0253 104.01 18.8718 104.221 18.7103 104.423C18.4681 104.739 18.2258 105.046 17.9836 105.362L16.3766 103.8L15.1976 102.869L14.8746 102.626L14.81 102.909L14.9069 103.444L15.4721 105.078L15.5044 105.928L15.779 106.616L13.8732 106.899L13.3241 104.957L12.8234 102.707L11.8705 104.811L11.273 106.989L9.19761 106.033L10.4251 104.059L10.6189 103.136L10.9096 102.399L9.19761 103.33L7.36452 104.261L6.38741 102.667Z"
                    fill="currentColor"
                />
                <path
                    d="M32.1638 68.0991L32.7452 66.1081L33.6981 64.2304L31.9215 65.3473L30.0884 66.5452L29.1679 64.7484L30.8233 63.5667L32.7129 62.4822L30.5568 62.1666H28.4411L28.6107 60.1756L30.6941 60.3132L32.7452 60.4588L31.114 59.2043L29.6605 57.7718L29.612 57.6666L30.896 56.3149L32.4626 57.6099L34.0938 58.9211L33.6577 56.8734L33.0279 54.7853L35.1274 54.2673L35.6766 56.3878L36.0561 58.5002L36.9605 56.5578L37.5823 54.3725L39.4397 55.368L38.6725 57.27L38.1234 59.0829L41.3939 57.1567L42.6859 58.7835L40.8286 59.957L39.4558 60.7826L39.157 60.9283L39.1893 60.9121L39.6254 60.9283C40.1261 60.9444 40.5783 61.1549 41.079 61.1711C41.3454 61.1792 41.62 61.1549 41.8865 61.163C42.161 61.1711 42.4194 61.2439 42.6859 61.2844C42.7586 61.2925 43.0574 61.1873 43.122 61.2034C43.2593 61.2277 43.1866 61.3896 43.1866 61.4786C43.1785 61.7376 43.1705 61.9966 43.1624 62.2637C43.1462 62.6603 43.1382 63.0488 43.122 63.4453L40.9094 63.1297L39.4074 63.073L39.0036 63.0649L39.1167 63.332L39.5123 63.7124L40.9336 64.6998L41.4585 65.3716L42.0803 65.7682L40.7075 67.1198L39.1247 65.8734L37.4128 64.3437L37.8731 66.6018L38.6644 68.7223L36.4276 69.1675L36.2661 66.8446L35.8784 65.9867L35.6846 65.2178L34.8448 66.9822L33.9161 68.8114L32.1638 68.0991Z"
                    fill="currentColor"
                />
                <path
                    d="M12.9688 74.1207L14.6081 72.85L16.4815 71.8869L14.39 71.7412L12.2097 71.6279L12.5246 69.645L14.5515 69.6693L16.7157 69.904L15.1491 68.3824L13.4372 67.136L14.7373 65.6306L16.3443 66.9741L17.919 68.2934L17.3295 66.3185L16.9903 64.3033L17.0064 64.1899L18.8395 63.8581L19.3402 65.8248L19.8974 67.8482L20.7453 65.9301L21.464 63.8662L23.4667 64.6837L22.6672 66.7232L21.7386 68.6495L23.604 67.6135L25.3886 66.2133L26.3011 68.1153L24.5811 69.1998L23.071 70.341L26.8502 70.7052L26.9472 72.7853L24.7587 72.6396L23.1679 72.502L22.8449 72.4453L22.8853 72.4534L23.2244 72.7205C23.6201 73.0281 23.8624 73.4651 24.2581 73.7727C24.4761 73.9346 24.7022 74.0802 24.9203 74.2421C25.1383 74.4121 25.2998 74.6225 25.4936 74.8167C25.5501 74.8734 25.8489 74.9624 25.8974 75.0029C25.9943 75.1 25.8408 75.189 25.7843 75.2619C25.6228 75.4642 25.4694 75.6747 25.3079 75.877C25.0656 76.1926 24.8233 76.5002 24.5811 76.8158L22.9741 75.2538L21.7951 74.323L21.4721 74.0802L21.4075 74.3635L21.5044 74.8977L22.0697 76.5326L22.102 77.3824L22.3765 78.0703L20.4708 78.3536L19.9216 76.4112L19.421 74.1612L18.4681 76.2655L17.8705 78.4426L15.7951 77.4876L17.0226 75.5128L17.2164 74.5901L17.5071 73.8536L15.7951 74.7844L13.962 75.7151L12.9688 74.1207Z"
                    fill="currentColor"
                />
                <path
                    d="M59.1353 92.404L61.5417 90.2268L64.0693 88.1225L62.1474 86.5929L60.4274 86.1558L58.5297 85.743L55.6468 86.4553L54.5162 87.297L53.5956 87.7988L51.8514 90.7125L51.9887 96.208L53.2161 98.1747L55.5822 95.9651L57.8836 93.8689L56.5593 96.0137V97.2196L56.2605 98.466L56.8258 101.007L58.2551 103.541L59.9913 101.752L61.7194 100.028L63.4798 98.3366L65.2241 96.6288L67.0491 95.0101L68.7369 93.2538L66.6776 91.797L61.5821 91.19L59.1353 92.404Z"
                    fill="currentColor"
                />
                <path
                    d="M88.8444 84.3024L88.1419 87.4669L87.294 90.6477L89.7489 90.7853L91.4043 90.1378L93.189 89.3689L95.127 87.1189L95.5631 85.7754L96.0234 84.8284L95.7569 81.4453L92.4783 77.0425L90.3303 76.1522L89.6843 79.3329L89.0221 82.3761L88.8606 79.8509L88.1661 78.8716L87.6816 77.6819L85.7516 75.9417L83.119 74.7034L82.7476 77.172L82.3277 79.5838L81.8674 81.9795L81.4394 84.3914L80.8902 86.7709L80.5269 89.1747H83.0464L87.5524 86.7061L88.8444 84.3024Z"
                    fill="currentColor"
                />
                <path
                    d="M49.4853 82.7646L48.7828 85.9291L47.9429 89.1099L50.3898 89.2475L52.0452 88.6L53.8298 87.8311L55.7679 85.5811L56.204 84.2376L56.6643 83.2906L56.3978 79.9075L53.1192 75.5047L50.9712 74.6225L50.3252 77.7951L49.663 80.8383L49.5015 78.3131L48.807 77.3338L48.3225 76.1441L46.3925 74.4039L43.7599 73.1737L43.3885 75.6342L42.9685 78.046L42.5083 80.4417L42.0803 82.8536L41.5311 85.2331L41.1677 87.6369H43.6872L48.1933 85.1683L49.4853 82.7646Z"
                    fill="currentColor"
                />
                <path
                    d="M80.5511 67.8725L82.6426 70.3491L84.6614 72.939L86.2522 71.0694L86.7368 69.3536L87.2051 67.4678L86.5914 64.5541L85.7839 63.3968L85.3074 62.4579L82.4568 60.6288L76.9737 60.5883L74.971 61.77L77.1029 64.2061L79.1298 66.5694L77.0222 65.1773L75.8189 65.1369L74.5915 64.805L72.0397 65.2987L69.4637 66.6503L71.1999 68.439L72.8634 70.2277L74.4946 72.0406L76.15 73.8455L77.7086 75.7151L79.4044 77.4633L80.9225 75.448L81.6816 70.3572L80.5511 67.8725Z"
                    fill="currentColor"
                />
                <path
                    d="M73.4448 73.4328L71.9347 73.3033L69.9482 72.6558L68.7934 71.2718L68.6561 69.9121L68.8176 68.6495L69.1972 68.2448L70.683 66.6099L69.7382 64.4975L69.1972 63.2511L66.9441 64.2142L64.6831 65.1288L62.4866 66.189L60.1932 67.0389L57.924 67.9292L55.8648 68.957L57.1649 72.2673L58.2713 72.4696L59.8863 72.3806L61.5256 74.3635L62.0344 75.7475L61.8325 77.0344L60.9038 78.0784L59.9994 79.0254L61.2995 82.5622L63.5606 81.3158L65.9105 80.6198L68.1151 79.5757L71.5713 78.2646L74.8903 76.7592L73.4932 73.3275L73.4448 73.4328Z"
                    fill="currentColor"
                />
                <path
                    d="M77.1029 60.4993L77.2483 58.9777L77.9105 57.0029L79.3156 55.8536L80.6722 55.7322L81.9239 55.9103L82.3196 56.2987L83.9427 57.796L86.0584 56.8815L87.3101 56.3473L86.3734 54.0811L85.4851 51.7987L84.4515 49.5892L83.6278 47.2826L82.7637 45.0002L81.7624 42.9202L78.4434 44.1908L78.2335 45.2997L78.2981 46.9184L76.3035 48.5452L74.9145 49.0389L73.6305 48.8203L72.605 47.8734L71.6682 46.9669L68.1313 48.2295L69.3506 50.5038L70.0128 52.8671L71.0303 55.0928L72.3062 58.5649L73.7678 61.9076L77.2079 60.5478L77.1029 60.4993Z"
                    fill="currentColor"
                />
                <path
                    d="M52.6186 40.3869L54.056 40.8806L55.8245 41.9894L56.6078 43.6162L56.414 44.9679L55.9537 46.1495L55.4853 46.449L53.6522 47.6792L54.056 49.9616L54.2902 51.297L56.7047 50.9085L59.1192 50.5686L61.5095 50.0749L63.9321 49.7997L66.3547 49.4921L68.5996 48.9903L68.1313 45.4616L67.1138 45.0002L65.5148 44.6927L64.4085 42.3779L64.247 40.9049L64.7558 39.7071L65.9105 38.922L67.0088 38.2179L66.605 34.4706L64.1097 35.1342L61.6629 35.2394L59.2726 35.717L55.6064 36.154L52.021 36.8096L52.5459 40.476L52.6186 40.3869Z"
                    fill="currentColor"
                />
                <path
                    d="M58.0452 62.2718L56.6239 62.8222L54.5647 63.1216L52.9173 62.3851L52.1906 61.2277L51.7868 60.0299L51.9483 59.4957L52.562 57.3671L50.7855 55.886L49.7437 55.0119L48.1529 56.8734L46.5217 58.6945L45.0197 60.6126L43.34 62.3932L41.6846 64.19L40.2956 66.0272L42.9201 68.4229L43.9941 68.1153L45.4154 67.3222L47.7572 68.3743L48.8232 69.3941L49.2027 70.6405L48.8232 71.984L48.4436 73.2304L51.1569 75.8284L52.6347 73.716L54.4436 72.0488L55.9617 70.1387L58.4812 67.4355L60.7989 64.6189L58.0452 62.1585V62.2718Z"
                    fill="currentColor"
                />
                <path
                    d="M87.9642 92.5335L86.7125 93.4076L84.7825 94.1846L83.0059 93.8608L82.0288 92.8977L81.3505 91.8294L81.3828 91.279L81.4797 89.0695L78.193 87.4427L77.0787 89.6198L75.9239 91.7808L74.9064 93.9984L73.6951 96.127L72.5161 98.2637L71.5955 100.376L74.7045 102.084L75.6816 101.533L76.8768 100.425L79.3963 100.894L80.6722 101.631L81.3424 102.756L81.2859 104.148L81.2051 105.459L84.4595 107.337L85.3962 104.933L86.761 102.893L87.7865 100.676L89.6035 97.4544L91.1943 94.1684L87.9319 92.4202L87.9642 92.5335Z"
                    fill="currentColor"
                />
                <path
                    d="M73.7678 103.654L71.7006 103.63L69.6252 103.994L71.208 102.618L72.8876 101.21L71.4502 99.8095L69.8432 101.048L68.2524 102.545L68.5835 100.384L69.2053 98.3527L67.2591 97.9318L66.7827 99.9714L66.3224 101.979L65.6037 100.044L64.667 98.2313L64.5862 98.1504L62.9227 98.9921L63.6979 100.87L64.4731 102.82L62.6401 101.801L60.8312 100.587L59.7249 102.448L61.5903 103.597L63.488 104.577L61.3722 104.876L59.1031 104.836L59.5149 106.908L61.5499 106.721H63.4395L60.6454 109.287L61.8164 111.003L63.4799 109.562L64.667 108.494L64.8931 108.251L64.8688 108.283L64.7558 108.704C64.6266 109.19 64.6993 109.684 64.562 110.169C64.4893 110.428 64.3924 110.679 64.3197 110.946C64.247 111.213 64.247 111.48 64.2067 111.747C64.1986 111.82 64.0129 112.071 63.9967 112.144C63.9806 112.282 64.1582 112.257 64.239 112.282C64.4893 112.346 64.7396 112.419 64.99 112.484C65.3695 112.589 65.749 112.694 66.1286 112.792L66.4758 110.582L66.8634 109.125L66.9684 108.737L67.1865 108.923L67.4287 109.408L67.9617 111.06L68.4462 111.764L68.64 112.476L70.3358 111.553L69.609 109.676L68.6642 107.579L70.6831 108.688L72.4677 110.064L73.5498 108.049L71.3856 107.215L70.6831 106.592L70.0047 106.179L71.9267 105.888L73.9455 105.524L73.7678 103.654Z"
                    fill="currentColor"
                />
                <path
                    d="M77.6601 89.2232L75.9966 87.993L74.0989 87.0785L76.1904 86.8842L78.3708 86.7223L78.0154 84.7475L75.9885 84.8204L73.8244 85.1117L75.3506 83.5497L77.0303 82.2628L75.6898 80.7817L74.1151 82.1657L72.5727 83.5254L73.1137 81.5344L73.4044 79.511L73.3802 79.3977L71.539 79.1063L71.0788 81.0893L70.5781 83.1207L69.6817 81.2268L68.9146 79.1792L66.9361 80.0452L67.784 82.0686L68.7611 83.9786L66.8715 82.9831L65.0546 81.6234L64.1824 83.5416L65.9429 84.5857L67.4772 85.6945L63.7141 86.1477L63.6656 88.2277L65.854 88.0335L67.4368 87.8554L67.7598 87.7907L67.7194 87.7988L67.3803 88.074C66.9926 88.3896 66.7665 88.8348 66.3708 89.1504C66.1609 89.3204 65.9348 89.4661 65.7248 89.636C65.5068 89.8141 65.3534 90.0245 65.1596 90.2187C65.103 90.2754 64.8123 90.3725 64.7639 90.4211C64.667 90.5182 64.8204 90.6072 64.8769 90.6801C65.0384 90.8824 65.208 91.0848 65.3695 91.2871C65.6198 91.5946 65.8702 91.9022 66.1124 92.2017L67.679 90.6072L68.8419 89.6522L69.1568 89.4013L69.2295 89.6846L69.1488 90.2187L68.6239 91.8698L68.6158 92.7196L68.3574 93.4076L70.2712 93.6504L70.7719 91.6999L71.2241 89.4418L72.2254 91.5218L72.8795 93.6909L74.9307 92.6873L73.6548 90.7448L73.4448 89.8303L73.138 89.1018L74.8741 89.9921L76.7234 90.8824L77.6601 89.2232Z"
                    fill="currentColor"
                />
                <path
                    d="M51.0762 55.2789L50.4463 53.3041L49.4531 51.4426L51.2619 52.5191L53.1193 53.6683L53.9914 51.8554L52.3117 50.7142L50.3898 49.6782L52.5378 49.314L54.6536 49.2655L54.4355 47.2825L52.3521 47.4687L50.3091 47.6629L51.916 46.3761L53.3373 44.9111L53.3857 44.8059L52.0695 43.4867L50.5352 44.8221L48.9282 46.1656L49.3158 44.1018L49.8972 41.9975L47.7896 41.5281L47.2889 43.6647L46.9578 45.7852L46.013 43.8671L45.3347 41.6899L43.5096 42.734L44.3253 44.6117L44.9228 46.4084L41.6119 44.555L40.3441 46.2142L42.2257 47.3392L43.6146 48.1324L43.9134 48.27L43.8811 48.2538L43.445 48.2781C42.9444 48.3104 42.5002 48.529 41.9996 48.5532C41.7331 48.5613 41.4585 48.5532 41.192 48.5694C40.9175 48.5856 40.6591 48.6665 40.3926 48.7151C40.3199 48.7313 40.0211 48.6261 39.9565 48.6423C39.8192 48.6665 39.8919 48.8284 39.9 48.9174C39.9161 49.1764 39.9323 49.4354 39.9404 49.6944C39.9646 50.091 39.9807 50.4795 40.005 50.8761L42.2095 50.5038L43.7115 50.4147L44.1153 50.3986L44.0103 50.6656L43.6308 51.0541L42.2337 52.0739L41.725 52.7538L41.1113 53.1665L42.5164 54.4858L44.0668 53.1989L45.7546 51.6369L45.3427 53.9031L44.5998 56.0397L46.8528 56.4363L46.9578 54.1135L47.3212 53.2475L47.4988 52.4786L48.3791 54.2187L49.3562 56.0316L51.0762 55.2789Z"
                    fill="currentColor"
                />
                <path
                    d="M70.4084 60.8473L68.7449 59.6171L66.8472 58.7026L68.9387 58.5083L71.1191 58.3464L70.7638 56.3716L68.7369 56.4445L66.5727 56.7358L68.0989 55.1738L69.7786 53.8869L68.4381 52.4058L66.8634 53.7898L65.3291 55.1414L65.8701 53.1504L66.1608 51.127L66.1366 51.0137L64.2954 50.7223L63.8351 52.7053L63.3264 54.7367L62.43 52.8509L61.6629 50.8033L59.6844 51.6693L60.5323 53.6927L61.5094 55.6027L59.6198 54.6072L57.8029 53.2475L56.9307 55.1657L58.6912 56.2097L60.2255 57.3186L56.4624 57.7718L56.4139 59.8518L58.6023 59.6576L60.1851 59.4795L60.5081 59.4148L60.4677 59.4229L60.1286 59.6981C59.741 60.0137 59.5148 60.4589 59.1192 60.7745C58.9092 60.9445 58.6831 61.0901 58.4731 61.2601C58.2551 61.4382 58.1017 61.6486 57.9079 61.8428C57.8513 61.8995 57.5606 61.9966 57.5122 62.0452C57.4153 62.1423 57.5687 62.2313 57.6252 62.3042C57.7867 62.5065 57.9563 62.7088 58.1178 62.9112C58.3682 63.2187 58.6185 63.5263 58.8607 63.8258L60.4274 62.2313L61.5902 61.2763L61.9051 61.0254L61.9778 61.3087L61.8971 61.8428L61.3722 63.4939L61.3641 64.3437L61.1057 65.0317L63.0195 65.2745L63.5202 63.324L63.9724 61.0659L64.9738 63.1459L65.6279 65.315L67.679 64.3114L66.4031 62.3689L66.1931 61.4544L65.8863 60.7259L67.6225 61.6162L69.4717 62.5065L70.4084 60.8473Z"
                    fill="currentColor"
                />
            </g>
            <defs>
                <clipPath id="clip0_11493_270641">
                    <rect width="193" height="135" fill="white" />
                </clipPath>
            </defs>
        </svg>
    );
}

PatternImagery.displayName = 'FonduePatternImagery';

const Memo = memo(PatternImagery);

export default Memo;
