/* (c) Copyright Frontify Ltd., all rights reserved. */

import { type ReactElement, memo } from 'react';

function PatternDigitalAssets(): ReactElement {
    return (
        <svg
            viewBox="0 0 193 135"
            fill="none"
            xmlns="http://www.w3.org/2000/svg"
            data-test-id="pattern-digital-assets"
            className="tw-h-full"
        >
            <g clipPath="url(#clip0_11493_270764)">
                <rect width="193" height="135" fill="#FAFAFA" />
                <path
                    d="M86.9064 18.9147L86.3088 20.6305L85.8082 22.4192L85.4609 24.2564L84.8876 26.0289L83.862 28.3032L83.3856 30.7636L82.5377 33.1836L80.753 32.4713L78.9522 32.0586L77.0707 31.4677L77.6117 29.5577L78.5162 27.9066L78.9684 26.1017L79.5821 24.3454L80.4139 21.6908L81.1326 18.9956L81.5363 17.3284L81.8916 17.126L83.4421 17.7735L85.1702 18.4291L86.9064 18.9147Z"
                    fill="currentColor"
                />
                <path
                    d="M80.5027 8.83016L79.0249 7.79418L77.4422 6.82296L75.7706 5.99742L74.2201 4.96145L72.3063 3.35084L70.0775 2.23393L67.9779 0.76091L69.1407 -0.768766L70.029 -2.39557L71.103 -4.05474L72.7908 -3.01877L74.1313 -1.69952L75.7464 -0.768766L77.2645 0.299579L79.5902 1.81307L81.9886 3.23753L83.4825 4.07116L83.5794 4.47584L82.5458 5.79508L81.4475 7.28429L80.5027 8.83016Z"
                    fill="currentColor"
                />
                <path
                    d="M66.6858 8.69256L65.9832 7.0172L65.1595 5.34993L64.1824 3.7636L63.4153 2.05587L62.6562 -0.323627L61.3641 -2.46032L60.3709 -4.82363L62.1717 -5.49539L63.7867 -6.40996L65.5714 -7.2355L66.4516 -5.45492L66.8876 -3.62578L67.7598 -1.97471L68.4785 -0.258877L69.6413 2.2663L70.9091 4.74292L71.7328 6.25641L71.6036 6.6449L70.0209 7.21145L68.3008 7.88321L66.6858 8.69256Z"
                    fill="currentColor"
                />
                <path
                    d="M41.8058 14.0262L42.6941 15.6125L43.6954 17.1746L44.8421 18.6476L45.795 20.2501L46.8205 22.5325L48.3387 24.5154L49.5985 26.7492L47.8865 27.6152L46.3845 28.6998L44.6967 29.7276L43.6227 28.0604L42.9848 26.2879L41.935 24.7501L41.0305 23.1314L39.5851 20.7438L38.0427 18.4291L37.0575 17.0208L37.1463 16.6161L38.6483 15.8796L40.2876 15.0136L41.8058 14.0262Z"
                    fill="currentColor"
                />
                <path
                    d="M38.5998 16.1062L36.7909 16.0577L34.9336 16.1224L33.0844 16.3571L31.219 16.349L28.7479 16.0577L26.2688 16.3571L23.7089 16.2924L23.8381 14.3742L23.6847 12.5208L23.6686 10.546L25.647 10.4812L27.4963 10.8373L29.3455 10.724L31.2028 10.7726L33.9807 10.7564L36.7586 10.6188L38.4706 10.4893L38.7694 10.7726L38.6321 12.448L38.5271 14.2933L38.5998 16.1062Z"
                    fill="currentColor"
                />
                <path
                    d="M17.9594 0.372419L19.7602 0.259109L21.6013 0.0243973L23.4264 -0.380279L25.2756 -0.54215L27.7709 -0.485495L30.2177 -1.00348L32.7695 -1.17344L32.8099 0.744721L33.141 2.57386L33.3348 4.54058L31.3644 4.79148L29.499 4.60533L27.6578 4.88051L25.8086 5.00192L23.0468 5.27709L20.2931 5.66558L18.5973 5.95695L18.2743 5.69796L18.2582 4.0226L18.1936 2.16918L17.9594 0.372419Z"
                    fill="currentColor"
                />
                <path
                    d="M8.6727 8.85443L7.04956 8.06127L5.32952 7.35713L3.55295 6.79868L1.85714 6.0217L-0.274747 4.73483L-2.65696 3.98213L-4.95843 2.85713L-4.04592 1.16558L-3.43219 -0.582617L-2.63274 -2.38747L-0.799643 -1.62668L0.734667 -0.54215L2.47086 0.129613L4.13437 0.938966L6.6781 2.07206L9.2622 3.09994L10.8773 3.69076L11.0307 4.07116L10.2151 5.53609L9.3591 7.17907L8.6727 8.85443Z"
                    fill="currentColor"
                />
                <path
                    d="M16.1182 26.4336L16.1667 28.2546L16.3282 30.0999L16.6592 31.9372L16.7481 33.8068L16.5946 36.2996L17.0226 38.7681L17.0953 41.3257L15.1734 41.3014L13.3403 41.5604L11.378 41.6818L11.2003 39.6989L11.4587 37.8293L11.2488 35.9839L11.2003 34.1224L11.0308 31.3463L10.7481 28.5703L10.5301 26.8625L10.7966 26.5469L12.4682 26.6035H14.3174L16.1182 26.4336Z"
                    fill="currentColor"
                />
                <path
                    d="M26.0831 24.2321L26.4142 26.0208L26.8664 27.8176L27.4801 29.582L27.8678 31.4111L28.11 33.8958L28.9175 36.2672L29.394 38.7843L27.4882 39.0595L25.7197 39.6017L23.7978 40.0307L23.3133 38.1044L23.2729 36.2267L22.7803 34.43L22.4331 32.6008L21.8355 29.8814L21.1168 27.1863L20.6323 25.5433L20.8422 25.1872L22.5057 24.9767L24.3308 24.6854L26.0831 24.2321Z"
                    fill="currentColor"
                />
                <path
                    d="M7.29192 36.4048L6.03217 35.0936L4.66744 33.8391L3.18966 32.7061L1.86531 31.3868L0.30677 29.4444L-1.67168 27.9066L-3.44825 26.0613L-2.01085 24.7825L-0.823774 23.358L0.549029 21.9417L2.00259 23.2852L3.06853 24.8391L4.46556 26.0613L5.75761 27.4048L7.74413 29.3472L9.81949 31.2007L11.1277 32.3176L11.1438 32.7303L9.87602 33.8149L8.51129 35.0694L7.29192 36.4048Z"
                    fill="currentColor"
                />
                <path
                    d="M66.5404 19.9183L64.8284 19.3194L63.0438 18.8095L61.2107 18.4695L59.4422 17.8949L57.1649 16.867L54.7181 16.3895L52.3036 15.5397L53.0061 13.751L53.4261 11.9462L54.0075 10.0604L55.9133 10.5945L57.5687 11.501L59.3695 11.9624L61.1138 12.5775L63.7705 13.4111L66.4515 14.1314L68.1231 14.528L68.325 14.8922L67.679 16.4381L67.0249 18.1701L66.5404 19.9183Z"
                    fill="currentColor"
                />
                <path
                    d="M56.8178 0.663783L55.2512 1.57835L53.7088 2.61432L52.2633 3.78788L50.6806 4.7672L48.4195 5.83555L46.4733 7.3976L44.2607 8.69256L43.3643 6.99292L42.258 5.50371L41.2082 3.82835L42.8475 2.72763L44.6079 2.05587L46.1261 0.979431L47.725 0.0405816L50.0749 -1.44053L52.3683 -3.02686L53.7492 -4.03855L54.161 -3.95762L54.9201 -2.46032L55.8084 -0.841612L56.8178 0.663783Z"
                    fill="currentColor"
                />
                <path
                    d="M87.4313 51.046L86.5349 49.4758L85.5174 47.9138L84.3626 46.457L83.3936 44.8544L82.3519 42.5882L80.8176 40.6134L79.5417 38.3877L81.2537 37.5055L82.7476 36.4129L84.4192 35.3688L85.5093 37.0361L86.1634 38.8005L87.2213 40.3302L88.1419 41.9489L89.5955 44.3122L91.154 46.6269L92.1553 48.0271L92.0665 48.4318L90.5726 49.1764L88.9414 50.0505L87.4313 51.046Z"
                    fill="currentColor"
                />
                <path
                    d="M90.7421 45.7447L91.2024 43.9884L91.5577 42.1593L91.7596 40.3059L92.1876 38.4929L93.0355 36.1377L93.31 33.653L93.9641 31.1683L95.7972 31.7348L97.6303 32.0019L99.5523 32.439L99.1646 34.3895L98.3975 36.1053L98.0825 37.9426L97.6061 39.7393L96.9924 42.4587L96.4917 45.2025L96.2252 46.9021L95.878 47.1287L94.2872 46.6107L92.5106 46.0847L90.7421 45.7447Z"
                    fill="currentColor"
                />
                <path
                    d="M26.0024 8.47404L24.8718 9.8904L23.8059 11.4039L22.8691 13.0226L21.7386 14.5037L20.0105 16.3086L18.7507 18.4695L17.1518 20.4686L15.7063 19.206L14.1397 18.2186L12.557 17.0289L13.7037 15.4102L15.1007 14.1557L16.1343 12.6017L17.2972 11.153L18.9607 8.92727L20.5354 6.62062L21.464 5.17997L21.8678 5.10713L23.1114 6.23213L24.5246 7.42997L26.0024 8.47404Z"
                    fill="currentColor"
                />
                <path
                    d="M39.3186 29.5172L38.4303 31.0954L37.6228 32.7708L36.9687 34.519L36.0965 36.1701L34.6834 38.2339L33.7951 40.5649L32.5434 42.8068L30.9041 41.7951L29.2002 41.0748L27.4479 40.1683L28.3119 38.3796L29.4909 36.9066L30.2581 35.207L31.1625 33.5882L32.4384 31.1197L33.6174 28.5864L34.2957 27.0163L34.6914 26.8787L36.0965 27.7852L37.6874 28.7321L39.3186 29.5172Z"
                    fill="currentColor"
                />
                <path
                    d="M28.9175 76.84L30.694 77.2123L32.5271 77.4794L34.3845 77.5846L36.2176 77.9246L38.6079 78.653L41.0951 78.8068L43.5984 79.3328L43.13 81.1944L42.9524 83.0478L42.6132 84.9902L40.6509 84.6989L38.8986 84.019L37.0574 83.7924L35.2405 83.412L32.5029 82.9345L29.7492 82.5622L28.0373 82.3841L27.795 82.0523L28.2311 80.4336L28.6671 78.6287L28.9175 76.84Z"
                    fill="currentColor"
                />
                <path
                    d="M15.0523 81.1134L13.308 80.6278L11.491 80.2393L9.6418 80.0127L7.83293 79.5595L5.49917 78.6773L3.02812 78.3616L0.557073 77.6818L1.14657 75.8526L1.44536 74.0154L1.90565 72.0972L3.84373 72.51L5.54762 73.3032L7.37264 73.6431L9.15728 74.1449L11.8625 74.8005L14.592 75.3427L16.2797 75.6341L16.5058 75.9821L15.9648 77.5685L15.4237 79.341L15.0523 81.1134Z"
                    fill="currentColor"
                />
                <path
                    d="M50.1315 84.5855L49.5339 82.8697L48.8152 81.1539L47.943 79.5109L47.2889 77.7627L46.6833 75.3347L45.5285 73.117L44.6806 70.6971L46.5218 70.1386L48.1934 69.3373L50.0265 68.6251L50.7936 70.4543L51.1166 72.3077L51.8757 74.0073L52.4814 75.7636L53.4908 78.3616L54.5971 80.9192L55.3239 82.4731L55.1705 82.8616L53.5554 83.3149L51.795 83.8814L50.1315 84.5855Z"
                    fill="currentColor"
                />
                <path
                    d="M34.3037 98.1584L33.3428 96.6206L32.2607 95.1071L31.0413 93.6989L30.0157 92.1368L28.8852 89.9111L27.262 88.0091L25.8973 85.84L27.5689 84.885L29.0144 83.7276L30.6456 82.6188L31.8004 84.2294L32.5271 85.9695L33.6496 87.4588L34.6348 89.0289L36.1933 91.3356L37.8407 93.5775L38.8986 94.9372L38.834 95.3418L37.3643 96.1512L35.7734 97.0981L34.3037 98.1584Z"
                    fill="currentColor"
                />
                <path
                    d="M15.8355 87.0784L17.4182 87.9606L19.0817 88.7618L20.8179 89.4012L22.4653 90.2753L24.5245 91.6836L26.8421 92.5577L29.079 93.8041L28.0857 95.5199L27.3832 97.3005L26.4949 99.1296L24.7183 98.2798L23.2486 97.09L21.5609 96.3374L19.9458 95.4309L17.4828 94.1602L14.9633 92.9947L13.3967 92.323L13.2594 91.9264L14.1477 90.4453L15.0764 88.778L15.8355 87.0784Z"
                    fill="currentColor"
                />
                <path
                    d="M58.9173 84.4641L60.5647 83.7115L62.204 82.8454L63.7625 81.8257L65.4422 81.0082L67.8001 80.1827L69.8997 78.8311L72.2254 77.7627L72.9441 79.5514L73.897 81.1458L74.7691 82.9102L73.0249 83.8409L71.2079 84.3266L69.5848 85.2411L67.8971 86.01L65.4099 87.2483L62.9711 88.5918L61.4853 89.4579L61.0896 89.3365L60.492 87.7663L59.7733 86.0586L58.9173 84.4641Z"
                    fill="currentColor"
                />
                <path
                    d="M14.3982 63.5748L16.0698 62.8868L17.7333 62.0694L19.3322 61.1062L21.0361 60.3535L23.4183 59.6089L25.5664 58.3302L27.9243 57.3508L28.5865 59.1557L29.4748 60.7825L30.2904 62.5793L28.5138 63.4534L26.6807 63.8742L25.0253 64.7321L23.3133 65.4363L20.7777 66.5856L18.2986 67.84L16.7885 68.6575L16.3928 68.5199L15.8517 66.9336L15.1896 65.2016L14.3982 63.5748Z"
                    fill="currentColor"
                />
                <path
                    d="M10.0779 73.983L10.0213 72.162L9.85176 70.3167L9.5126 68.4794L9.41569 66.6098L9.55297 64.117L9.11691 61.6566L9.03615 59.0909L10.9581 59.1152L12.7912 58.8481L14.7535 58.7186L14.9392 60.6935L14.6889 62.5631L14.9069 64.4165L14.9634 66.2699L15.1411 69.0541L15.4399 71.8221L15.666 73.5298L15.3995 73.8454L13.7279 73.7969L11.8787 73.805L10.0779 73.983Z"
                    fill="currentColor"
                />
                <path
                    d="M72.2255 22.1278L70.667 23.0505L69.1327 24.0945L67.6953 25.2762L66.1125 26.2636L63.8595 27.34L61.9214 28.9183L59.7169 30.2213L58.8124 28.5298L57.698 27.0487L56.6321 25.3814L58.2714 24.2645L60.0318 23.5846L61.5419 22.5001L63.1327 21.5532L65.4746 20.0559L67.7599 18.4614L69.1407 17.4417L69.5445 17.5226L70.3117 19.0118L71.208 20.6305L72.2255 22.1278Z"
                    fill="currentColor"
                />
                <path
                    d="M52.5944 53.4902L50.9632 54.2753L49.34 55.1737L47.7977 56.2258L46.1341 57.0676L43.7923 57.9336L41.7169 59.3257L39.4074 60.4264L38.6564 58.662L37.6793 57.0838L36.7749 55.3275L38.503 54.3724L40.3118 53.8463L41.9188 52.9075L43.5904 52.1062L46.0615 50.8275L48.4679 49.4435L49.9376 48.5451L50.3333 48.6665L50.9632 50.2204L51.7142 51.912L52.5944 53.4902Z"
                    fill="currentColor"
                />
                <path
                    d="M39.8353 52.43L39.7788 50.617L39.6092 48.7636L39.262 46.9264L39.1651 45.0649L39.3023 42.564L38.8663 40.1035L38.7774 37.5379L40.6994 37.5622L42.5325 37.2951L44.5028 37.1656L44.6805 39.1404L44.4302 41.01L44.6563 42.8553L44.7128 44.7168L44.8985 47.4929L45.1892 50.269L45.4234 51.9686L45.1569 52.2924L43.4853 52.2438L41.6361 52.2519L39.8353 52.43Z"
                    fill="currentColor"
                />
                <path
                    d="M58.4247 57.3508L57.2134 55.9992L55.8971 54.6881L54.4597 53.5064L53.1838 52.1386L51.6899 50.1395L49.776 48.537L48.0641 46.6269L49.5499 45.4048L50.7774 44.0208L52.2067 42.653L53.6118 44.0451L54.6212 45.6395L55.9779 46.9183L57.2134 48.3023L59.1353 50.3095L61.1461 52.2438L62.4139 53.4012V53.814L61.1057 54.858L59.6925 56.0559L58.4247 57.3508Z"
                    fill="currentColor"
                />
                <path
                    d="M84.7906 16.5918L86.3007 15.5882L87.7866 14.4713L89.1594 13.2168L90.6937 12.1485L92.8821 10.9507L94.7394 9.28339L96.8713 7.86702L97.8646 9.51L99.0597 10.9345L100.198 12.5451L98.6156 13.7348L96.9036 14.5118L95.4501 15.6692L93.8996 16.6971L91.6385 18.3077L89.442 20.0235L88.1177 21.1161L87.7058 21.0514L86.866 19.6026L85.8889 18.0325L84.7906 16.5918Z"
                    fill="currentColor"
                />
                <path
                    d="M63.5526 59.9246L65.1757 60.7258L66.8877 61.4462L68.6562 62.0046L70.352 62.7897L72.4839 64.0847L74.858 64.8616L77.1514 65.9866L76.2389 67.6782L75.609 69.4264L74.8015 71.2231L72.9684 70.4623L71.4421 69.3616L69.714 68.6818L68.0505 67.8643L65.5149 66.715L62.9308 65.6791L61.3238 65.0802L61.1703 64.6917L61.994 63.2348L62.8581 61.5999L63.5526 59.9246Z"
                    fill="currentColor"
                />
                <path
                    d="M86.107 57.0109L85.4287 58.6944L84.8392 60.4507L84.4112 62.2717L83.7571 64.0199L82.6184 66.2456L82.0289 68.6737L81.0761 71.0532L79.3237 70.26L77.5391 69.7582L75.6898 69.0864L76.3197 67.2007L77.2968 65.59L77.8459 63.8095L78.5404 62.0855L79.4933 59.4713L80.3331 56.8167L80.8096 55.1656L81.181 54.9794L82.6992 55.6998L84.395 56.4363L86.107 57.0109Z"
                    fill="currentColor"
                />
                <path
                    d="M98.4703 94.1278L96.726 93.626L94.9171 93.2213L93.0679 92.9866L91.2671 92.5091L88.9414 91.6107L86.4704 91.2789L84.0074 90.5667L84.613 88.7456L84.9199 86.9165L85.4044 84.9983L87.3344 85.4273L89.0383 86.2447L90.8553 86.6008L92.6399 87.1107L95.3371 87.7906L98.0584 88.3571L99.7462 88.6566L99.9723 89.0127L99.4151 90.591L98.8579 92.3553L98.4703 94.1278Z"
                    fill="currentColor"
                />
                <path
                    d="M101.256 100.87L99.4473 100.999L97.6061 101.25L95.7892 101.663L93.9399 101.841L91.4447 101.8L89.0059 102.335L86.4541 102.521L86.3976 100.603L86.0584 98.7735L85.8485 96.8149L87.8108 96.5478L89.6843 96.7258L91.5174 96.4264L93.3666 96.2969L96.1284 95.9974L98.882 95.5927L100.57 95.2933L100.901 95.5442L100.925 97.2276L101.006 99.073L101.256 100.87Z"
                    fill="currentColor"
                />
                <path
                    d="M102.984 70.3814L101.176 70.5595L99.3505 70.8508L97.5416 71.3122L95.6924 71.5388L93.1971 71.5631L90.7745 72.1701L88.2308 72.421L88.1258 70.4947L87.7382 68.6818L87.4798 66.7231L89.434 66.4075L91.3075 66.537L93.1325 66.1971L94.9817 66.0109L97.7354 65.6467L100.473 65.1611L102.161 64.8212L102.492 65.064L102.556 66.7474L102.686 68.5927L102.984 70.3814Z"
                    fill="currentColor"
                />
                <path
                    d="M81.1003 75.9255L81.3668 77.7141L81.7544 79.5352L82.3116 81.3158L82.6346 83.153L82.788 85.6539L83.5067 88.0496L83.8944 90.5828L81.9886 90.7933L80.1959 91.2708L78.2578 91.6269L77.8459 89.6926L77.8702 87.8068L77.4341 85.9938L77.1595 84.1566L76.6508 81.421L76.029 78.7016L75.6091 77.0343L75.8352 76.6863L77.4987 76.5325L79.3318 76.3059L81.1003 75.9255Z"
                    fill="currentColor"
                />
                <path
                    d="M70.6023 53.5064L70.6185 51.6935L70.5216 49.832L70.2551 47.9866L70.2228 46.117L70.4651 43.6323L70.1259 41.1557L70.1501 38.59L72.064 38.6872L73.9051 38.4929L75.8755 38.4444L75.9805 40.4273L75.6575 42.2807L75.8028 44.1422L75.7867 46.0037L75.8513 48.7798L76.037 51.564L76.1985 53.2798L75.924 53.5873L74.2524 53.474L72.4031 53.4093L70.6023 53.5064Z"
                    fill="currentColor"
                />
                <path
                    d="M58.2955 44.2474L57.7787 42.5073L57.1488 40.7672L56.3494 39.0757L55.776 37.3032L55.2754 34.8508L54.2256 32.5846L53.4988 30.1242L55.3561 29.6548L57.06 28.9264L58.9335 28.2951L59.6118 30.1647L59.846 32.0343L60.5243 33.7663L61.0573 35.5469L61.9375 38.1854L62.9308 40.7915L63.5849 42.3859L63.4072 42.7582L61.7841 43.1386L59.9914 43.6242L58.2955 44.2474Z"
                    fill="currentColor"
                />
                <path
                    d="M74.9711 22.4839L77.2806 22.5972L78.8472 24.2402V26.474L77.9347 28.1251L75.4475 28.7564L73.0572 27.2267L72.71 25.7294L73.3157 23.617L74.4946 22.6134L74.9711 22.4839Z"
                    fill="currentColor"
                />
                <path
                    d="M82.0532 42.1674L82.4004 44.4579L81.1084 46.3194L78.92 46.7645L77.1272 46.198L76.0128 43.8832L77.0303 41.2285L78.4273 40.5972L80.6158 40.7591L81.8351 41.7222L82.0532 42.1674Z"
                    fill="currentColor"
                />
                <path
                    d="M92.1473 36.9309L92.4946 39.2213L91.2025 41.0828L89.0141 41.528L87.2214 40.9695L86.107 38.6548L87.1245 36.0001L88.5215 35.3607L90.7099 35.5226L91.9293 36.4857L92.1473 36.9309Z"
                    fill="currentColor"
                />
                <path
                    d="M97.0813 49.2007L97.4285 51.4911L96.1365 53.3526L93.9481 53.7978L92.1554 53.2393L91.041 50.9165L92.0585 48.2699L93.4555 47.6305L95.6439 47.7924L96.8552 48.7555L97.0813 49.2007Z"
                    fill="currentColor"
                />
                <path
                    d="M56.2767 60.1107L54.0398 60.6935L52.0614 59.5847L51.3992 57.448L51.7788 55.6026L53.9672 54.2591L56.7047 55.0118L57.4799 56.3391L57.5284 58.5406L56.6966 59.8517L56.2767 60.1107Z"
                    fill="currentColor"
                />
                <path
                    d="M58.449 87.8472L56.2121 88.43L54.2337 87.3212L53.5715 85.1926L53.943 83.3391L56.1314 81.9956L58.8689 82.7483L59.6441 84.0757L59.7007 86.2771L58.8689 87.5882L58.449 87.8472Z"
                    fill="currentColor"
                />
                <path
                    d="M58.1178 43.7618L60.4193 43.8751L61.9859 45.5181V47.7519L61.0734 49.403L58.5862 50.0343L56.1959 48.5046L55.8567 47.0073L56.4543 44.8949L57.6333 43.8913L58.1178 43.7618Z"
                    fill="currentColor"
                />
                <path
                    d="M54.7746 37.6512L56.527 39.1485L56.7612 41.4066L55.3964 43.1791L53.6764 43.9318L51.3184 42.9039L50.3655 40.233L51.0035 38.8329L52.772 37.5217L54.3143 37.457L54.7746 37.6512Z"
                    fill="currentColor"
                />
                <path
                    d="M40.1099 60.5478L41.8622 62.0451L42.1045 64.3032L40.7398 66.0757L39.0117 66.8284L36.6537 65.8005L35.7008 63.1296L36.3387 61.7294L38.1072 60.4183L39.6496 60.3535L40.1099 60.5478Z"
                    fill="currentColor"
                />
                <path
                    d="M39.4639 21.5694L41.2162 23.0748L41.4504 25.3328L40.0857 27.1053L38.3657 27.8499L36.0077 26.8302L35.0467 24.1512L35.6927 22.751L37.4532 21.448L39.0036 21.3751L39.4639 21.5694Z"
                    fill="currentColor"
                />
                <path
                    d="M35.8784 16.2034L37.6388 17.7088L37.873 19.9668L36.5083 21.7312L34.7802 22.4839L32.4302 21.4561L31.4693 18.7852L32.1072 17.385L33.8757 16.082L35.4262 16.0091L35.8784 16.2034Z"
                    fill="currentColor"
                />
                <path
                    d="M57.6011 72.9794L56.4947 75.0109L54.3467 75.715L52.336 74.7438L51.2377 73.2141L51.7545 70.689L54.161 69.1917L55.663 69.5316L57.3023 70.9884L57.6899 72.4938L57.6011 72.9794Z"
                    fill="currentColor"
                />
                <path
                    d="M69.4637 71.0208L68.3574 73.0604L66.2013 73.7564L64.1905 72.7933L63.1004 71.2555L63.6091 68.7384L66.0236 67.2411L67.5176 67.573L69.1649 69.0379L69.5526 70.5352L69.4637 71.0208Z"
                    fill="currentColor"
                />
                <path
                    d="M73.6952 89.4498L71.6925 88.3005L71.0465 86.1233L72.0559 84.1323L73.6145 83.0721L76.1178 83.6467L77.5552 86.099L77.1838 87.5882L75.6898 89.1989L74.1797 89.555L73.6952 89.4498Z"
                    fill="currentColor"
                />
                <path
                    d="M66.064 28.1818L67.2915 30.1485L66.8473 32.3742L65.0223 33.653L63.1488 33.8553L61.2027 32.1719L61.0816 29.3391L62.1152 28.1899L64.1825 27.4695L65.6845 27.8661L66.064 28.1818Z"
                    fill="currentColor"
                />
                <path
                    d="M62.955 6.95245L64.1905 8.91109L63.7464 11.1449L61.9133 12.4237L60.0479 12.626L58.1017 10.9426L57.9806 8.10983L59.0062 6.96055L61.0815 6.24022L62.5835 6.6368L62.955 6.95245Z"
                    fill="currentColor"
                />
                <path
                    d="M27.7709 40.1683L29.0064 42.1269L28.5623 44.3526L26.7292 45.6395L24.8638 45.8418L22.9176 44.1584L22.7965 41.3176L23.8221 40.1764L25.8974 39.4561L27.3914 39.8526L27.7709 40.1683Z"
                    fill="currentColor"
                />
                <path
                    d="M27.7709 52.5514L29.0064 54.51L28.5623 56.7357L26.7292 58.0145L24.8638 58.2168L22.9176 56.5415L22.7965 53.7007L23.8221 52.5514L25.8974 51.8311L27.3914 52.2276L27.7709 52.5514Z"
                    fill="currentColor"
                />
                <path
                    d="M21.3671 29.8895L22.6026 31.8562L22.1504 34.082L20.3254 35.3607L18.46 35.5631L16.5139 33.8796L16.3927 31.0469L17.4183 29.8976L19.4937 29.1773L20.9876 29.5739L21.3671 29.8895Z"
                    fill="currentColor"
                />
                <path
                    d="M7.29999 46.0685L8.53551 48.0271L8.0833 50.2528L6.25828 51.5397L4.3848 51.742L2.44673 50.0586L2.3256 47.2177L3.35116 46.0766L5.42652 45.3562L6.92045 45.7528L7.29999 46.0685Z"
                    fill="currentColor"
                />
                <path
                    d="M79.7517 53.1098L80.9791 55.0685L80.535 57.2942L78.71 58.573L76.8365 58.7753L74.8903 57.0999L74.7692 54.2591L75.8028 53.1179L77.8701 52.3895L79.3721 52.7942L79.7517 53.1098Z"
                    fill="currentColor"
                />
                <path
                    d="M85.7678 73.4408L86.9952 75.4075L86.5511 77.6332L84.726 78.912L82.8526 79.1143L80.9145 77.4309L80.7934 74.5981L81.8189 73.4489L83.8943 72.7285L85.3882 73.1251L85.7678 73.4408Z"
                    fill="currentColor"
                />
                <path
                    d="M86.963 67.3059L88.1985 69.2645L87.7543 71.4902L85.9212 72.769L84.0558 72.9713L82.1097 71.296L81.9886 68.4552L83.0141 67.3059L85.0895 66.5856L86.5915 66.9821L86.963 67.3059Z"
                    fill="currentColor"
                />
                <path
                    d="M90.7017 21.1404L91.9292 23.099L91.485 25.3248L89.66 26.6035L87.7866 26.8059L85.8485 25.1305L85.7273 22.2897L86.7529 21.1404L88.8283 20.4201L90.3222 20.8167L90.7017 21.1404Z"
                    fill="currentColor"
                />
                <path
                    d="M76.8285 6.29688L78.0559 8.25551L77.6118 10.4812L75.7867 11.7681L73.9133 11.9704L71.9752 10.287L71.8541 7.44616L72.8796 6.30497L74.955 5.58465L76.4489 5.98123L76.8285 6.29688Z"
                    fill="currentColor"
                />
                <path
                    d="M12.4036 14.9812L13.631 16.9399L13.1869 19.1656L11.3538 20.4444L9.48837 20.6467L7.54222 18.9713L7.42109 16.1305L8.44666 14.9893L10.522 14.2609L12.024 14.6575L12.4036 14.9812Z"
                    fill="currentColor"
                />
                <path
                    d="M15.6821 1.03609L16.9176 3.00281L16.4735 5.22853L14.6404 6.50731L12.775 6.70965L10.8288 5.0262L10.7077 2.19346L11.7332 1.04418L13.8086 0.323857L15.3025 0.72044L15.6821 1.03609Z"
                    fill="currentColor"
                />
                <path
                    d="M30.6214 5.3904L31.8489 7.34903L31.4047 9.57475L29.5797 10.8535L27.7062 11.0559L25.7681 9.38051L25.647 6.53968L26.6726 5.3904L28.7479 4.67008L30.2419 5.06666L30.6214 5.3904Z"
                    fill="currentColor"
                />
                <path
                    d="M95.2563 81.421L96.4837 83.3796L96.0396 85.6053L94.2146 86.8841L92.3411 87.0865L90.3949 85.4111L90.2738 82.5703L91.3074 81.421L93.3747 80.7007L94.8767 81.0972L95.2563 81.421Z"
                    fill="currentColor"
                />
                <path
                    d="M29.9915 72.0811L31.2189 74.0397L30.7748 76.2654L28.9417 77.5442L27.0763 77.7465L25.1302 76.0712L25.009 73.2303L26.0346 72.0811L28.1099 71.3607L29.612 71.7573L29.9915 72.0811Z"
                    fill="currentColor"
                />
                <path
                    d="M12.4036 88.7537L13.631 90.7204L13.1869 92.9462L11.3538 94.2249L9.48837 94.4273L7.54222 92.7438L7.42109 89.9111L8.44666 88.7618L10.522 88.0415L12.024 88.4381L12.4036 88.7537Z"
                    fill="currentColor"
                />
                <path
                    d="M6.19358 88.7537L7.42103 90.7204L6.97688 92.9462L5.15186 94.2249L3.27839 94.4273L1.34032 92.7438L1.21919 89.9111L2.24475 88.7618L4.31203 88.0415L5.81404 88.4381L6.19358 88.7537Z"
                    fill="currentColor"
                />
                <path
                    d="M25.5017 84.9093L26.7291 86.8679L26.285 89.0936L24.4599 90.3724L22.5865 90.5748L20.6403 88.8994L20.5192 86.0586L21.5528 84.9093L23.6201 84.189L25.1221 84.5855L25.5017 84.9093Z"
                    fill="currentColor"
                />
                <path
                    d="M8.8343 67.6539L10.0617 69.6125L9.61761 71.8382L7.79259 73.117L5.91911 73.3194L3.98104 71.644L3.85991 68.8032L4.88547 67.662L6.96083 66.9336L8.45476 67.3302L8.8343 67.6539Z"
                    fill="currentColor"
                />
                <path
                    d="M38.6483 84.3104L39.8758 86.269L39.4316 88.4947L37.5985 89.7816L35.7331 89.9839L33.787 88.3005L33.6659 85.4597L34.6914 84.3185L36.7668 83.5981L38.2688 83.9947L38.6483 84.3104Z"
                    fill="currentColor"
                />
                <path
                    d="M80.1635 34.3733L81.076 36.2753L81.0276 37.4084L80.3008 38.3634L80.1231 38.76L79.8244 38.8571L79.251 39.4075L78.8553 39.6503L77.2645 39.5127L75.7705 38.8571L74.5269 37.5217L73.3318 36.1701L71.9348 35.0127L70.7719 33.6125L69.496 32.3338L68.0505 31.2249L66.8715 29.8328L66.0479 28.465L66.1044 26.8463L66.4113 26.3203L66.9119 25.5837L68.5028 24.6125L69.7867 24.7906L71.103 25.5837L72.5808 26.6278L73.8486 27.9228L75.1245 29.2016L76.3035 30.5774L77.7813 31.6458L78.9684 33.0217L79.9778 34.0658L80.1635 34.3733Z"
                    fill="currentColor"
                />
                <path
                    d="M67.7113 101.695L66.387 103.33L65.3453 103.775L64.1663 103.524L63.7302 103.541L63.5202 103.314L62.7773 103.031L62.3897 102.772L61.8325 101.266L61.784 99.6395L62.4543 97.9399L63.1649 96.2726L63.6091 94.5163L64.3762 92.8652L64.9819 91.1575L65.3614 89.3769L66.1124 87.7177L66.9926 86.3823L68.4785 85.7429L69.0761 85.7915L69.9643 85.9291L71.5148 86.957L71.9105 88.1872L71.7571 89.7249L71.4502 91.5136L70.8284 93.2132L70.2147 94.921L69.4798 96.5721L69.1487 98.3688L68.4219 100.036L67.9051 101.396L67.7113 101.695Z"
                    fill="currentColor"
                />
                <path
                    d="M66.3628 13.5001L65.2403 11.7195L65.1596 10.5865L65.7814 9.55048L65.9106 9.13771L66.1932 9.00821L66.702 8.39311L67.0734 8.10983L68.6723 8.07746L70.2309 8.55498L71.6118 9.74473L72.9523 10.9588L74.4704 11.9543L75.7786 13.2088L77.1837 14.3418L78.7503 15.2807L80.0666 16.5352L81.0357 17.7978L81.1649 19.4165L80.9226 19.9749L80.5027 20.7681L79.033 21.9012L77.7409 21.8769L76.3439 21.2294L74.7531 20.3634L73.348 19.2142L71.9348 18.0811L70.6185 16.8427L69.0277 15.9525L67.6952 14.7141L66.5728 13.7834L66.3628 13.5001Z"
                    fill="currentColor"
                />
                <path
                    d="M90.6049 5.44706L92.7045 5.47134L93.6977 6.01361L94.2307 7.09814L94.5134 7.42998L94.4649 7.73753L94.6991 8.49832L94.7475 8.95966L93.9077 10.3356L92.6641 11.3877L90.9198 11.9057L89.1756 12.3832L87.5201 13.1278L85.7597 13.5487L84.0477 14.1314L82.4165 14.9327L80.648 15.3697L79.0572 15.5073L77.6359 14.7384L77.3049 14.2285L76.8607 13.4516L76.7073 11.5901L77.426 10.5217L78.718 9.68807L80.3089 8.82206L82.0289 8.25552L83.7409 7.68087L85.4932 7.23573L87.1083 6.37782L88.8606 5.92458L90.2496 5.47944L90.6049 5.44706Z"
                    fill="currentColor"
                />
                <path
                    d="M52.134 12.1485L50.1233 12.7879L49.0169 12.5936L48.169 11.7357L47.7976 11.501L47.741 11.2016L47.2807 10.5541L47.095 10.1251L47.4584 8.56306L48.3063 7.17098L49.7922 6.11882L51.3022 5.11522L52.6347 3.8931L54.1771 2.93806L55.6145 1.84544L56.9146 0.558567L58.4489 -0.412656L59.9186 -1.04395L61.5094 -0.760677L61.9859 -0.388375L62.6481 0.210546L63.3829 1.92637L63.0357 3.17278L62.0666 4.37062L60.8311 5.69796L59.3776 6.7744L57.9402 7.86702L56.4139 8.84634L55.1542 10.1656L53.636 11.153L52.457 12.0109L52.134 12.1485Z"
                    fill="currentColor"
                />
                <path
                    d="M55.2188 68.9408L53.2888 69.7825L52.1663 69.6935L51.2376 68.9246L50.842 68.7384L50.7612 68.439L50.2282 67.84L50.0021 67.4354L50.204 65.8409L50.9066 64.376L52.2874 63.1782L53.6845 62.0289L54.8877 60.6773L56.3251 59.5604L57.6414 58.3302L58.8042 56.9219L60.2336 55.7969L61.6306 55.028L63.2456 55.1413L63.7544 55.465L64.4731 55.9992L65.3775 57.626L65.1595 58.8967L64.3197 60.1917L63.2295 61.6323L61.889 62.8544L60.5646 64.0847L59.1434 65.2097L58.029 66.6584L56.6158 67.7915L55.5337 68.7708L55.2188 68.9408Z"
                    fill="currentColor"
                />
                <path
                    d="M31.2836 73.8454L29.8058 72.3562L29.4747 71.2717L29.8462 70.1224L29.8866 69.6935L30.1288 69.4992L30.4922 68.787L30.7829 68.4309L32.3415 68.0424L33.9646 68.1638L35.5716 69.0136L37.1544 69.8958L38.8502 70.5352L40.4006 71.4659L42.0319 72.251L43.76 72.8257L45.3266 73.7564L46.546 74.7762L47.0305 76.3221L46.9174 76.921L46.6832 77.787L45.4962 79.2195L44.2364 79.4785L42.7263 79.1629L40.9821 78.6692L39.367 77.8598L37.7358 77.0748L36.1773 76.1602L34.4249 75.6422L32.8583 74.7357L31.5582 74.0721L31.2836 73.8454Z"
                    fill="currentColor"
                />
                <path
                    d="M43.5661 80.4902L45.1166 79.0739L46.2148 78.7906L47.3373 79.2195L47.7734 79.2762L47.951 79.5352L48.6374 79.9318L48.9847 80.2393L49.2996 81.8095L49.1058 83.4282L48.1852 85.0064L47.2323 86.5442L46.5217 88.2115L45.5123 89.7249L44.6563 91.3194L44.0103 93.0271L43.0089 94.5487L41.9349 95.7303L40.3683 96.1431L39.7869 95.9974L38.9309 95.7222L37.5581 94.4758L37.3562 93.1971L37.7358 91.6998L38.3091 89.9839L39.1893 88.3976L40.0534 86.8032L41.0305 85.2816L41.6361 83.5577L42.6052 82.028L43.3239 80.7573L43.5661 80.4902Z"
                    fill="currentColor"
                />
                <path
                    d="M3.57724 56.9138L5.13578 55.4974L6.22594 55.2222L7.35649 55.6512L7.78448 55.6998L7.96214 55.9588L8.65661 56.3553L8.99578 56.6629L9.31879 58.2411L9.11691 59.8598L8.19632 61.43L7.24343 62.9677L6.53281 64.6431L5.53147 66.1566L4.67548 67.7429L4.02138 69.4507L3.02812 70.9803L1.9541 72.1539L0.387492 72.5667L-0.202007 72.4291L-1.04991 72.1539L-2.43079 70.8994L-2.63268 69.6206L-2.24506 68.1314L-1.67171 66.4075L-0.791505 64.8212L0.0644791 63.2267L1.04967 61.7052L1.64724 59.9812L2.62435 58.4516L3.33498 57.1809L3.57724 56.9138Z"
                    fill="currentColor"
                />
                <path
                    d="M25.2433 64.4974L27.1895 63.6962L28.3119 63.8014L29.2244 64.5864L29.6121 64.7888L29.6928 65.0882L30.2096 65.6953L30.4196 66.0999L30.1935 67.6944L29.4586 69.1512L28.0535 70.3167L26.6323 71.4336L25.4048 72.769L23.9432 73.8454L22.5946 75.0514L21.4075 76.4354L19.954 77.528L18.5408 78.2726L16.9338 78.1269L16.4251 77.7951L15.7225 77.2447L14.8504 75.6017L15.0926 74.3311L15.9648 73.0523L17.0872 71.6278L18.4439 70.4381L19.8005 69.2321L21.238 68.1395L22.3846 66.715L23.8221 65.6143L24.9284 64.6593L25.2433 64.4974Z"
                    fill="currentColor"
                />
                <path
                    d="M23.9916 77.1557L26.0912 77.0424L27.1167 77.5118L27.7224 78.5559L28.0212 78.8715L28.005 79.1791L28.2877 79.9237L28.3603 80.385L27.6174 81.8095L26.4465 82.9426L24.7426 83.582L23.0306 84.1728L21.4317 85.0226L19.7036 85.5568L18.032 86.2528L16.4573 87.1674L14.7211 87.7258L13.1465 87.9606L11.6767 87.2888L11.3053 86.8113L10.8208 86.0586L10.5381 84.2132L11.1842 83.0963L12.4197 82.1818L13.954 81.2106L15.6256 80.5307L17.2972 79.8347L19.0172 79.2762L20.5677 78.3131L22.2877 77.7465L23.6444 77.2043L23.9916 77.1557Z"
                    fill="currentColor"
                />
                <path
                    d="M9.39144 83.2663L10.7319 84.8931L10.958 86.0019L10.4735 87.1026L10.4008 87.5316L10.1344 87.7016L9.71445 88.3733L9.38336 88.7052L7.8006 88.948L6.19361 88.6728L4.67545 87.6773L3.18152 86.6494L1.5503 85.8562L0.0967484 84.7798L-1.45371 83.849L-3.1253 83.1206L-4.59501 82.0442L-5.71748 80.9192L-6.05664 79.3248L-5.88706 78.7501L-5.57212 77.9084L-4.26392 76.5892L-2.97995 76.4435L-1.51024 76.9048L0.177502 77.5604L1.71989 78.5154L3.26227 79.4462L4.73198 80.5064L6.4278 81.1863L7.90558 82.2384L9.1411 83.0073L9.39144 83.2663Z"
                    fill="currentColor"
                />
                <path
                    d="M35.9107 65.0802L35.1517 67.0469L34.2957 67.7915L33.1005 67.9129L32.6887 68.0586L32.4141 67.9048L31.6227 67.8643L31.1786 67.7348L30.1853 66.4722L29.6443 64.9345L29.7654 63.1134L29.9269 61.3167L29.8219 59.5037L30.04 57.6989L30.0965 55.8859L29.9189 54.073L30.1288 52.26L30.5649 50.7222L31.7842 49.6539L32.3657 49.5163L33.254 49.3787L35.0386 49.8805L35.7896 50.9408L36.1126 52.4462L36.371 54.2429L36.2903 56.0559L36.2337 57.8607L36.0319 59.6656L36.266 61.4785L36.0803 63.2834L36.0076 64.7402L35.9107 65.0802Z"
                    fill="currentColor"
                />
                <path
                    d="M7.88936 55.894L6.36313 54.4453L5.99166 53.3688L6.3389 52.2114L6.35505 51.7744L6.59731 51.5802L6.93648 50.8598L7.21911 50.4956L8.7615 50.0505L10.3846 50.1233L12.0239 50.9246L13.6309 51.7582L15.3429 52.3409L16.9256 53.2312L18.573 53.9677L20.3253 54.4776L21.9162 55.3598L23.1759 56.3472L23.7008 57.8769L23.6039 58.4758L23.402 59.3499L22.2634 60.8149L21.0037 61.1143L19.4855 60.8472L17.7332 60.4102L16.0858 59.6494L14.4384 58.9129L12.8476 58.0469L11.0872 57.5856L9.48828 56.7276L8.16393 56.1125L7.88936 55.894Z"
                    fill="currentColor"
                />
                <path
                    d="M52.2068 32.5604L50.5514 33.8553L49.437 34.0577L48.3468 33.5478L47.9188 33.4588L47.7654 33.1917L47.1032 32.7465L46.7802 32.4147L46.5783 30.8203L46.8933 29.2177L47.935 27.7204L48.9928 26.2555L49.8246 24.6368L50.939 23.2043L51.9161 21.6827L52.6833 20.0316L53.7896 18.5829L54.9524 17.4821L56.5433 17.1908L57.1166 17.3769L57.9484 17.7088L59.2243 19.0604L59.3373 20.3472L58.8366 21.8122L58.1422 23.4875L57.1489 25.001L56.1718 26.5226L55.0816 27.9713L54.3548 29.6467L53.2728 31.1035L52.4652 32.3176L52.2068 32.5604Z"
                    fill="currentColor"
                />
                <path
                    d="M0.93655 38.5981L0.169395 36.6395L0.290525 35.5145L1.08998 34.608L1.29186 34.2276L1.59065 34.1467L2.20437 33.6368L2.61622 33.4264L4.19898 33.6854L5.63638 34.4381L6.78308 35.8625L7.88132 37.2951L9.18952 38.5577L10.2474 40.0307L11.4345 41.3985L12.7992 42.6044L13.8732 44.0775L14.5919 45.5019L14.4223 47.1206L14.0832 47.6143L13.526 48.3185L11.8705 49.1683L10.6108 48.9093L9.35103 48.019L7.94592 46.8697L6.775 45.4938L5.58793 44.1179L4.51391 42.6611L3.11688 41.4875L2.03479 40.0388L1.09806 38.9138L0.93655 38.5981Z"
                    fill="currentColor"
                />
                <path
                    d="M20.3496 21.1404L19.0576 19.4812L18.8557 18.3724L19.3644 17.2717L19.4452 16.8508L19.7117 16.689L20.1558 16.0253L20.4869 15.7016L22.0778 15.4992L23.6767 15.8149L25.1787 16.8508L26.6403 17.9111L28.2473 18.7447L29.6847 19.8535L31.2109 20.8248L32.8583 21.5936L34.3038 22.7025L35.402 23.8598L35.7008 25.4543L35.5151 26.0289L35.184 26.8625L33.8354 28.1494L32.5514 28.2627L31.0898 27.769L29.4182 27.073L27.9081 26.0775L26.3819 25.1062L24.9364 24.0136L23.2648 23.2933L21.8113 22.2087L20.6 21.3994L20.3496 21.1404Z"
                    fill="currentColor"
                />
                <path
                    d="M13.0899 6.5154L15.1975 6.41018L16.215 6.8877L16.8207 7.93177L17.1194 8.24741L17.0952 8.55497L17.3779 9.29957L17.4505 9.7609L16.7076 11.1773L15.5286 12.3104L13.8166 12.9417L12.1128 13.5325L10.5058 14.3742L8.76957 14.9084L7.10606 15.5963L5.5233 16.5028L3.7871 17.0532L2.21242 17.2879L0.742711 16.608L0.379322 16.1305L-0.113272 15.3778L-0.387833 13.5325L0.266268 12.4156L1.50987 11.501L3.0361 10.5379L4.71576 9.86612L6.38736 9.17817L8.1074 8.61972L9.66593 7.66468L11.386 7.09813L12.7426 6.56396L13.0899 6.5154Z"
                    fill="currentColor"
                />
                <path
                    d="M18.5004 20.3311L20.503 20.9623L21.2944 21.7717L21.4963 22.9614L21.6659 23.358L21.5367 23.6413L21.5447 24.4426L21.4478 24.8958L20.2527 25.9641L18.7588 26.6116L16.9337 26.6035L15.1249 26.555L13.3322 26.7816L11.5233 26.6683L9.71442 26.733L7.9217 27.0244L6.10475 26.9354L4.54622 26.5954L3.39952 25.4462L3.22994 24.8715L3.03613 23.9893L3.42375 22.1683L4.42509 21.3508L5.90287 20.9381L7.67136 20.5658L9.48023 20.5253L11.2891 20.4686L13.098 20.5496L14.8826 20.2016L16.6996 20.2744L18.1531 20.2501L18.5004 20.3311Z"
                    fill="currentColor"
                />
                <path
                    d="M17.6929 37.3194L19.0092 35.6764L20.0428 35.2231L21.2218 35.474L21.6579 35.4578L21.8759 35.6845L22.6189 35.9677L23.0065 36.2186L23.5717 37.724L23.6283 39.3508L22.958 41.0505L22.2636 42.7177L21.8194 44.4821L21.0684 46.1332L20.4628 47.8409L20.0913 49.6296L19.3484 51.2888L18.4682 52.6242L16.9904 53.2798L16.3847 53.2312L15.5045 53.0936L13.946 52.0739L13.5503 50.8436L13.6956 49.3059L13.9944 47.5172L14.6082 45.8095L15.2138 44.1017L15.9406 42.4426L16.2636 40.6458L16.9904 38.9785L17.4991 37.6107L17.6929 37.3194Z"
                    fill="currentColor"
                />
                <path
                    d="M27.3187 52.2195L25.2514 52.5918L24.1774 52.2438L23.4506 51.2807L23.1114 51.0055L23.1034 50.6899L22.7238 49.9857L22.6027 49.5406L23.168 48.0352L24.1935 46.7726L25.8086 45.939L27.4398 45.1458L28.9257 44.1098L30.5811 43.3652L32.1558 42.4749L33.6093 41.3823L35.2648 40.6215L36.7991 40.1926L38.3415 40.6863L38.7614 41.1233L39.3428 41.8032L39.8354 43.5999L39.3267 44.7897L38.2123 45.8499L36.8072 46.9992L35.2244 47.8733L33.6497 48.7555L32.0104 49.5244L30.5811 50.6656L28.9418 51.4345L27.6659 52.1305L27.3187 52.2195Z"
                    fill="currentColor"
                />
                <path
                    d="M66.9685 79.1953L64.877 79.001L63.9322 78.3778L63.488 77.2609L63.2377 76.9048L63.3104 76.5972L63.1327 75.8203V75.3589L64.0775 74.0559L65.4019 73.117L67.1865 72.7366L68.9631 72.4048L70.667 71.8059L72.4597 71.5307L74.212 71.0936L75.9079 70.4219L77.7006 70.1305H79.2995L80.6561 71.0127L80.9469 71.5388L81.3183 72.3562L81.3264 74.2177L80.5189 75.2294L79.1622 75.9498L77.5068 76.6863L75.7464 77.1071L73.994 77.5442L72.2094 77.8436L70.5297 78.564L68.7451 78.8715L67.3238 79.2034L66.9685 79.1953Z"
                    fill="currentColor"
                />
                <path
                    d="M93.6493 71.992L95.652 71.3526L96.7583 71.5469L97.6062 72.4048L97.9777 72.6395L98.0342 72.939L98.5026 73.5864L98.6883 74.0154L98.3249 75.5775L97.477 76.9695L95.9911 78.0217L94.481 79.0253L93.1486 80.2555L91.6062 81.2106L90.1688 82.3032L88.8768 83.5901L87.3425 84.5694L85.8728 85.1926L84.2738 84.9174L83.8055 84.5451L83.1433 83.9462L82.4004 82.2303L82.7476 80.9839L83.7167 79.7861L84.9522 78.4588L86.3977 77.3742L87.8431 76.2816L89.3613 75.3104L90.621 73.983L92.1473 72.9956L93.3182 72.1377L93.6493 71.992Z"
                    fill="currentColor"
                />
                <path
                    d="M73.6144 97.3086L71.6683 96.4992L70.9496 95.6251L70.8608 94.4192L70.7316 94.0064L70.885 93.7393L70.9496 92.9381L71.0788 92.501L72.3708 91.5379L73.9132 91.028L75.7302 91.198L77.5229 91.4084L79.3318 91.3436L81.1245 91.6107L82.9253 91.7159L84.7422 91.5784L86.543 91.8293L88.0692 92.3068L89.1029 93.5532L89.224 94.144L89.3371 95.0343L88.796 96.8149L87.722 97.5433L86.2119 97.8266L84.4111 98.037L82.6103 97.9156L80.8095 97.8104L79.0168 97.5676L77.1999 97.7537L75.4072 97.519L73.9536 97.4138L73.6144 97.3086Z"
                    fill="currentColor"
                />
                <path
                    d="M44.939 70.9561L43.2836 72.251L42.1772 72.4534L41.079 71.9435L40.6591 71.8544L40.4976 71.5873L39.8354 71.1422L39.5205 70.8104L39.3186 69.2159L39.6335 67.6134L40.6672 66.1161L41.7331 64.6512L42.5649 63.0406L43.6792 61.5999L44.6483 60.0784L45.4235 58.4273L46.5298 56.9785L47.6846 55.8778L49.2754 55.5864L49.8488 55.7726L50.6805 56.1044L51.9645 57.4561L52.0695 58.7429L51.5769 60.2079L50.8744 61.8832L49.8892 63.3967L48.9121 64.9264L47.8219 66.367L47.0951 68.0424L46.0049 69.4992L45.1974 70.7132L44.939 70.9561Z"
                    fill="currentColor"
                />
                <path
                    d="M57.3104 67.9615L58.0291 65.9785L58.8608 65.2177L60.056 65.064L60.4678 64.9102L60.7424 65.0559L61.5338 65.0802L61.986 65.1935L63.0035 66.4318L63.5849 67.9534L63.5041 69.7825L63.383 71.5873L63.5364 73.4003L63.3588 75.2052L63.3426 77.0181L63.5687 78.823L63.3992 80.644L63.0035 82.1899L61.8083 83.2906L61.2269 83.4363L60.3467 83.5981L58.5459 83.1368L57.7707 82.1008L57.4073 80.6035L57.1085 78.8068L57.1489 77.0019L57.165 75.189L57.3185 73.3841L57.0439 71.5712L57.1892 69.7663L57.2215 68.3095L57.3104 67.9615Z"
                    fill="currentColor"
                />
                <path
                    d="M51.2053 37.8131L51.7948 39.8364L51.5687 40.9453L50.6885 41.7708L50.4463 42.135L50.1394 42.1836L49.4853 42.6287L49.0573 42.8068L47.5069 42.4021L46.1421 41.5199L45.1327 39.9983L44.1717 38.4605L42.9847 37.0927L42.0641 35.5226L41.0143 34.0496L39.7707 32.7222L38.842 31.1521L38.2525 29.671L38.5675 28.0766L38.9551 27.6152L39.5769 26.9596L41.2969 26.2717L42.5325 26.6521L43.7034 27.6557L44.9954 28.9264L46.0371 30.4075L47.0869 31.8805L48.0156 33.4345L49.3076 34.7294L50.2525 36.2834L51.0761 37.4812L51.2053 37.8131Z"
                    fill="currentColor"
                />
                <path
                    d="M76.3358 58.2088L77.4179 60.0136L77.4744 61.1467L76.8365 62.1665L76.6992 62.5793L76.4165 62.7088L75.8916 63.3077L75.5202 63.5829L73.9213 63.5909L72.3708 63.0811L71.0142 61.8589L69.6979 60.6206L68.2039 59.6008L66.92 58.314L65.531 57.1566L63.9886 56.1854L62.6885 54.9066L61.7437 53.6197L61.6549 52.001L61.9052 51.4507L62.3413 50.6656L63.8352 49.5568L65.1273 49.6134L66.5081 50.2852L68.0828 51.1836L69.4637 52.3571L70.8527 53.5145L72.1447 54.7852L73.7194 55.7079L75.0276 56.9704L76.1258 57.9174L76.3358 58.2088Z"
                    fill="currentColor"
                />
                <path
                    d="M77.4987 52.2276L76.0693 50.6737L75.7786 49.5811L76.1985 48.448L76.247 48.019L76.4973 47.8409L76.893 47.1449L77.1918 46.7969L78.7584 46.457L80.3816 46.6431L81.9562 47.5496L83.5067 48.4884L85.1783 49.1926L86.6964 50.18L88.2954 51.0217L89.9992 51.6611L91.5336 52.6404L92.7206 53.7087L93.1405 55.2789L93.0033 55.8616L92.7449 56.7195L91.5093 58.1116L90.2334 58.3221L88.7395 57.9579L87.0195 57.3994L85.4286 56.5334L83.8297 55.6836L82.3035 54.7123L80.5754 54.1296L79.0411 53.1665L77.7651 52.4623L77.4987 52.2276Z"
                    fill="currentColor"
                />
                <path
                    d="M93.7058 23.4794L95.7166 22.8562L96.8229 23.0667L97.6627 23.9327L98.0342 24.1674L98.0826 24.4668L98.5429 25.1224L98.7206 25.5514L98.3491 27.1134L97.4851 28.4974L95.9911 29.5253L94.473 30.5208L93.1244 31.7348L91.582 32.6737L90.1285 33.7582L88.8203 35.0289L87.2779 35.9839L85.8001 36.599L84.2093 36.3077L83.7409 35.9354L83.0868 35.3203L82.36 33.6044L82.7234 32.358L83.7005 31.1683L84.9441 29.8571L86.4057 28.7888L87.8593 27.7123L89.3936 26.7492L90.6614 25.4381L92.1957 24.4668L93.3747 23.617L93.7058 23.4794Z"
                    fill="currentColor"
                />
                <path
                    d="M89.1997 1.21414L90.3061 3.01091L90.3868 4.13591L89.765 5.17188L89.6277 5.58465L89.3451 5.71414L88.8363 6.32116L88.4649 6.60443L86.866 6.6368L85.3155 6.1431L83.9346 4.95335L82.5941 3.73123L81.084 2.73573L79.7839 1.46504L78.3788 0.331949L76.8203 -0.614994L75.504 -1.86949L74.543 -3.14017L74.4219 -4.75888L74.6642 -5.31733L75.0922 -6.1024L76.5699 -7.2355L77.8539 -7.20312L79.2509 -6.55564L80.8418 -5.67345L82.2388 -4.52417L83.6439 -3.39107L84.9602 -2.14467L86.543 -1.23819L87.8673 0.000113983L88.9898 0.930869L89.1997 1.21414Z"
                    fill="currentColor"
                />
                <path
                    d="M96.6049 55.6998L98.6964 55.4974L99.7461 55.9264L100.392 56.9462L100.707 57.2456L100.691 57.5532L101.014 58.2897L101.103 58.7429L100.416 60.1998L99.2939 61.3733L97.6143 62.0855L95.9346 62.7492L94.368 63.6638L92.6641 64.2708L91.0248 65.0316L89.4905 66.0109L87.7785 66.6422L86.2119 66.9417L84.7099 66.3346L84.3304 65.8652L83.8055 65.1368L83.4502 63.3077L84.0558 62.1665L85.251 61.1953L86.7368 60.1593L88.3842 59.4147L90.0235 58.6539L91.7193 58.0226L93.2294 56.9947L94.9252 56.3553L96.2576 55.7645L96.6049 55.6998Z"
                    fill="currentColor"
                />
                <path
                    d="M52.8931 15.5721L53.9752 17.3769L54.0398 18.51L53.3938 19.5298L53.2565 19.9426L52.9738 20.064L52.4489 20.671L52.0775 20.9462H50.4786L48.9281 20.4363L47.5715 19.2222L46.2552 17.9839L44.7612 16.9561L43.4773 15.6773L42.0883 14.5199L40.5459 13.5487L39.2458 12.2699L38.3091 10.983L38.2122 9.35623L38.4625 8.81397L38.8986 8.02889L40.3925 6.92008L41.6846 6.97674L43.0735 7.6485L44.6401 8.54688L46.021 9.72044L47.4099 10.8778L48.7101 12.1404L50.2767 13.0712L51.5849 14.3257L52.6831 15.2807L52.8931 15.5721Z"
                    fill="currentColor"
                />
                <path
                    d="M38.2606 8.74922L36.8394 10.3032L35.7735 10.6836L34.6106 10.3517L34.1745 10.3355L33.9807 10.1008L33.254 9.769L32.8906 9.48573L32.4303 7.94796L32.4787 6.32116L33.262 4.67008L34.0696 3.05138L34.6348 1.32745L35.4989 -0.275063L36.2095 -1.93424L36.7021 -3.69053L37.5581 -5.30114L38.5271 -6.57183L40.0534 -7.12219L40.6429 -7.03316L41.5231 -6.83082L43.0009 -5.71391L43.3158 -4.45942L43.0655 -2.93783L42.6455 -1.16535L41.9188 0.485728L41.2001 2.15299L40.3602 3.75551L39.9161 5.52799L39.0763 7.13861L38.4787 8.46594L38.2606 8.74922Z"
                    fill="currentColor"
                />
                <path
                    d="M67.7033 47.8005L66.492 49.5244L65.4826 50.0343L64.2874 49.8643L63.8594 49.9048L63.6333 49.6944L62.8662 49.4596L62.4624 49.233L61.8083 47.7681L61.6549 46.1413L62.2121 44.4012L62.8096 42.6935L63.1407 40.9129L63.7868 39.2132L64.2793 37.4731L64.5458 35.6683L65.1838 33.9605L65.9752 32.5766L67.4206 31.832L68.0182 31.84L68.9146 31.921L70.5296 32.8436L70.998 34.0496L70.9496 35.5873L70.7638 37.3922L70.2551 39.1323L69.7544 40.8724L69.1326 42.5721L68.9227 44.3931L68.3008 46.1008L67.8809 47.4929L67.7033 47.8005Z"
                    fill="currentColor"
                />
                <path
                    d="M48.0641 90.8014L46.6993 89.1989L46.449 88.0981L46.9093 86.9812L46.9739 86.5523L47.2323 86.3823L47.6522 85.6944L47.9671 85.3625L49.5499 85.0874L51.1569 85.3302L52.6993 86.3014L54.2094 87.2969L55.8567 88.0577L57.3345 89.1098L58.9011 90.0082L60.5808 90.7124L62.0747 91.7483L63.2214 92.8652L63.5848 94.4435L63.4233 95.0262L63.1245 95.876L61.8405 97.2195L60.5566 97.3814L59.0788 96.9525L57.383 96.3293L55.8244 95.4066L54.2578 94.5001L52.772 93.4722L51.0681 92.8248L49.5661 91.7969L48.3225 91.0523L48.0641 90.8014Z"
                    fill="currentColor"
                />
                <path
                    d="M182.97 11.3391L182.373 13.055L181.864 14.8436L181.525 16.6809L180.952 18.4534L179.918 20.7276L179.441 23.1881L178.602 25.608L176.817 24.8958L175.016 24.483L173.127 23.8922L173.668 21.9821L174.572 20.3311L175.032 18.5262L175.646 16.7699L176.478 14.1152L177.197 11.4201L177.592 9.75281L177.956 9.55048L179.498 10.198L181.226 10.8535L182.97 11.3391Z"
                    fill="currentColor"
                />
                <path
                    d="M176.567 1.25462L175.081 0.218645L173.498 -0.752578L171.834 -1.57812L170.276 -2.61409L168.37 -4.2247L166.133 -5.34161L164.042 -6.81463L165.205 -8.3443L166.085 -9.9711L167.159 -11.6303L168.855 -10.5943L170.195 -9.27506L171.802 -8.3443L173.32 -7.27596L175.654 -5.76247L178.044 -4.33801L179.546 -3.50438L179.643 -3.0997L178.602 -1.78046L177.503 -0.291247L176.567 1.25462Z"
                    fill="currentColor"
                />
                <path
                    d="M162.742 1.11702L162.039 -0.558336L161.215 -2.2256L160.246 -3.81193L159.479 -5.51967L158.72 -7.89916L157.428 -10.0359L156.435 -12.3992L158.227 -13.079L159.843 -13.9855L161.635 -14.811L162.515 -13.0305L162.952 -11.2013L163.816 -9.55024L164.534 -7.83442L165.705 -5.30924L166.973 -2.83262L167.797 -1.31913L167.659 -0.930639L166.085 -0.364092L164.365 0.307671L162.742 1.11702Z"
                    fill="currentColor"
                />
                <path
                    d="M137.862 6.45065L138.75 8.03698L139.759 9.59903L140.906 11.0721L141.851 12.6746L142.876 14.9569L144.403 16.9399L145.654 19.1737L143.95 20.0397L142.44 21.1242L140.761 22.1521L139.687 20.4848L139.049 18.7123L137.999 17.1746L137.094 15.5478L135.649 13.1683L134.107 10.8535L133.121 9.44526L133.21 9.04058L134.712 8.30407L136.352 7.43806L137.862 6.45065Z"
                    fill="currentColor"
                />
                <path
                    d="M134.656 8.53069L132.847 8.48214L130.998 8.54688L129.148 8.7816L127.283 8.7735L124.804 8.48214L122.325 8.7816L119.765 8.71685L119.902 6.79059L119.741 4.94526L119.724 2.97044L121.711 2.8976L123.552 3.26181L125.409 3.1485L127.259 3.19706L130.045 3.18088L132.823 3.04329L134.526 2.91379L134.833 3.19706L134.688 4.87242L134.591 6.71775L134.656 8.53069Z"
                    fill="currentColor"
                />
                <path
                    d="M105.213 -1.40007L103.687 -0.42075L102.193 0.679968L100.796 1.91019L99.2536 2.95425L97.0409 4.11162L95.1594 5.75461L93.0033 7.14669L92.0342 5.47943L90.8633 4.03878L89.7489 2.41198L91.3478 1.24652L93.0759 0.501911L94.5457 -0.639275L96.1042 -1.64287L98.3976 -3.22111L100.618 -4.89647L101.959 -5.97291L102.371 -5.90816L103.186 -4.44323L104.147 -2.8569L105.213 -1.40007Z"
                    fill="currentColor"
                />
                <path
                    d="M112.174 18.858L112.223 20.6791L112.384 22.5244L112.715 24.3616L112.812 26.2312L112.659 28.724L113.087 31.1926L113.159 33.7501L111.237 33.7258L109.404 33.9848L107.434 34.0981L107.264 32.1233L107.523 30.2537L107.313 28.4084L107.256 26.5469L107.095 23.7708L106.804 20.9947L106.586 19.287L106.852 18.9713L108.524 19.028H110.373L112.174 18.858Z"
                    fill="currentColor"
                />
                <path
                    d="M122.139 16.6566L122.478 18.4453L122.93 20.242L123.544 22.0064L123.932 23.8356L124.174 26.3203L124.981 28.6917L125.45 31.2088L123.552 31.4839L121.784 32.0262L119.862 32.4552L119.377 30.5289L119.337 28.6512L118.836 26.8544L118.497 25.0253L117.891 22.3059L117.181 19.6107L116.688 17.9677L116.906 17.6116L118.562 17.4012L120.395 17.1098L122.139 16.6566Z"
                    fill="currentColor"
                />
                <path
                    d="M103.348 29.0721L102.096 27.7609L100.731 26.5064L99.2536 25.3733L97.9292 24.0541L96.3626 22.1116L94.3922 20.5739L92.6157 18.7285L94.0531 17.4498L95.2321 16.0253L96.6049 14.6089L98.0665 15.9525L99.1324 17.5064L100.529 18.7285L101.813 20.0721L103.808 22.0064L105.883 23.8679L107.192 24.9767L107.208 25.3976L105.94 26.4821L104.567 27.7366L103.348 29.0721Z"
                    fill="currentColor"
                />
                <path
                    d="M162.596 12.3427L160.884 11.7438L159.1 11.2339L157.275 10.894L155.498 10.3194L153.229 9.28339L150.774 8.81396L148.359 7.96414L149.07 6.17547L149.482 4.37062L150.071 2.48482L151.977 3.019L153.625 3.92547L155.425 4.3868L157.178 5.00191L159.826 5.83555L162.515 6.55587L164.187 6.95245L164.389 7.31666L163.743 8.86252L163.081 10.5945L162.596 12.3427Z"
                    fill="currentColor"
                />
                <path
                    d="M152.874 -6.91175L151.315 -5.99719L149.773 -4.96121L148.327 -3.78765L146.736 -2.80834L144.483 -1.73999L142.529 -0.177941L140.325 1.11702L139.428 -0.582617L138.322 -2.07183L137.264 -3.74719L138.911 -4.84791L140.672 -5.51967L142.19 -6.59611L143.789 -7.53496L146.139 -9.01607L148.424 -10.6024L149.813 -11.6141L150.217 -11.5332L150.976 -10.0359L151.864 -8.41715L152.874 -6.91175Z"
                    fill="currentColor"
                />
                <path
                    d="M183.495 43.4704L182.591 41.9003L181.581 40.3382L180.418 38.8814L179.458 37.2789L178.416 35.0127L176.881 33.0379L175.606 30.8122L177.309 29.93L178.803 28.8373L180.483 27.7933L181.573 29.4525L182.219 31.2249L183.277 32.7546L184.198 34.3733L185.659 36.7366L187.218 39.0514L188.219 40.4516L188.13 40.8562L186.628 41.6008L185.005 42.4749L183.495 43.4704Z"
                    fill="currentColor"
                />
                <path
                    d="M186.37 38.1125L186.968 36.4048L187.476 34.6161L187.816 32.7789L188.389 31.0064L189.423 28.724L189.891 26.2717L190.739 23.8436L192.523 24.5559L194.324 24.9686L196.206 25.5595L195.673 27.4695L194.768 29.1206L194.308 30.9255L193.694 32.6818L192.863 35.3445L192.144 38.0316L191.748 39.707L191.385 39.9093L189.842 39.2618L188.114 38.6062L186.37 38.1125Z"
                    fill="currentColor"
                />
                <path
                    d="M122.066 0.898498L120.936 2.31487L119.862 3.82835L118.933 5.44706L117.803 6.92817L116.074 8.73303L114.815 10.894L113.216 12.8931L111.762 11.6305L110.204 10.6431L108.621 9.45335L109.768 7.83465L111.165 6.58015L112.198 5.0262L113.361 3.57745L115.025 1.35173L116.591 -0.95492L117.528 -2.39557L117.932 -2.46841L119.175 -1.34341L120.588 -0.145567L122.066 0.898498Z"
                    fill="currentColor"
                />
                <path
                    d="M135.374 21.9417L134.494 23.5199L133.687 25.1953L133.024 26.9435L132.152 28.5945L130.747 30.6584L129.851 32.9893L128.599 35.2312L126.968 34.2195L125.264 33.4992L123.512 32.5927L124.376 30.8041L125.547 29.3311L126.314 27.6314L127.226 26.0127L128.502 23.5442L129.673 21.0109L130.36 19.4327L130.747 19.3032L132.16 20.2097L133.743 21.1566L135.374 21.9417Z"
                    fill="currentColor"
                />
                <path
                    d="M124.982 69.2645L126.758 69.6368L128.591 69.9039L130.449 70.0091L132.282 70.349L134.664 71.0775L137.159 71.2312L139.662 71.7573L139.194 73.6188L139.016 75.4722L138.677 77.4147L136.715 77.1233L134.963 76.4435L133.121 76.2168L131.305 75.8365L128.567 75.3589L125.805 74.9866L124.101 74.8086L123.859 74.4767L124.295 72.858L124.723 71.0532L124.982 69.2645Z"
                    fill="currentColor"
                />
                <path
                    d="M109.606 68.6089L108.58 70.1062L107.619 71.6926L106.804 73.376L105.778 74.9381L104.187 76.8562L103.081 79.0981L101.628 81.2106L100.093 80.0532L98.4621 79.171L96.7986 78.1026L97.8241 76.403L99.1404 75.0514L100.053 73.4327L101.111 71.903L102.613 69.564L104.018 67.1602L104.85 65.6467L105.245 65.5496L106.57 66.5856L108.056 67.6782L109.606 68.6089Z"
                    fill="currentColor"
                />
                <path
                    d="M146.195 77.01L145.598 75.2942L144.879 73.5784L144.007 71.9354L143.353 70.1791L142.747 67.7591L141.592 65.5415L140.745 63.1215L142.586 62.5631L144.249 61.7618L146.09 61.0496L146.858 62.8787L147.172 64.7321L147.94 66.4318L148.545 68.1881L149.547 70.7861L150.661 73.3436L151.388 74.8976L151.226 75.2861L149.619 75.7393L147.859 76.3059L146.195 77.01Z"
                    fill="currentColor"
                />
                <path
                    d="M130.368 90.5828L129.407 89.0451L128.325 87.5316L127.105 86.1233L126.08 84.5613L124.941 82.3356L123.326 80.4336L121.961 78.2564L123.625 77.3095L125.078 76.1521L126.71 75.0433L127.864 76.6539L128.591 78.394L129.714 79.8832L130.699 81.4534L132.249 83.76L133.905 86.0019L134.963 87.3616L134.89 87.7663L133.428 88.5757L131.829 89.5226L130.368 90.5828Z"
                    fill="currentColor"
                />
                <path
                    d="M154.981 76.8886L156.629 76.1359L158.268 75.2699L159.826 74.2501L161.506 73.4327L163.856 72.6071L165.956 71.2555L168.289 70.1872L169.008 71.9758L169.961 73.5703L170.833 75.3347L169.081 76.2654L167.264 76.751L165.649 77.6656L163.961 78.4345L161.466 79.6728L159.027 81.0163L157.549 81.8823L157.153 81.7609L156.548 80.1908L155.829 78.483L154.981 76.8886Z"
                    fill="currentColor"
                />
                <path
                    d="M110.454 55.9992L112.126 55.3032L113.797 54.4938L115.388 53.5307L117.1 52.778L119.474 52.0334L121.622 50.7546L123.988 49.7753L124.65 51.5802L125.539 53.207L126.354 55.0037L124.57 55.8778L122.737 56.2987L121.089 57.1566L119.377 57.8607L116.842 59.01L114.354 60.2645L112.844 61.082L112.457 60.9444L111.908 59.358L111.254 57.626L110.454 55.9992Z"
                    fill="currentColor"
                />
                <path
                    d="M101.862 83.5577L103.533 82.8697L105.205 82.0523L106.796 81.0892L108.508 80.3364L110.882 79.5918L113.03 78.3131L115.396 77.3338L116.05 79.1386L116.947 80.7654L117.762 82.5703L115.978 83.4363L114.144 83.8571L112.497 84.715L110.777 85.4273L108.249 86.5685L105.762 87.823L104.252 88.6404L103.865 88.5028L103.315 86.9165L102.661 85.1845L101.862 83.5577Z"
                    fill="currentColor"
                />
                <path
                    d="M106.142 66.4075L106.085 64.5864L105.916 62.7411L105.577 60.9039L105.472 59.0343L105.617 56.5415L105.181 54.0811L105.1 51.5154L107.014 51.5397L108.847 51.2726L110.817 51.1431L110.995 53.1179L110.745 54.9875L110.971 56.8409L111.027 58.6944L111.205 61.4785L111.496 64.2465L111.73 65.9543L111.463 66.2699L109.792 66.2213L107.943 66.2294L106.142 66.4075Z"
                    fill="currentColor"
                />
                <path
                    d="M168.289 14.5523L166.731 15.4749L165.197 16.519L163.751 17.7007L162.176 18.6881L159.923 19.7645L157.977 21.3427L155.781 22.6458L154.868 20.9543L153.754 19.4731L152.696 17.8059L154.335 16.689L156.088 16.0091L157.598 14.9246L159.197 13.9776L161.538 12.4803L163.824 10.8859L165.197 9.86613L165.608 9.94706L166.376 11.4363L167.272 13.055L168.289 14.5523Z"
                    fill="currentColor"
                />
                <path
                    d="M148.658 45.9147L147.019 46.6998L145.396 47.5981L143.854 48.6503L142.19 49.492L139.856 50.358L137.781 51.7501L135.471 52.8508L134.72 51.0865L133.743 49.5082L132.831 47.7519L134.567 46.7969L136.376 46.2708L137.975 45.332L139.654 44.5307L142.117 43.2519L144.532 41.8679L146.002 40.9695L146.397 41.0909L147.027 42.6449L147.778 44.3364L148.658 45.9147Z"
                    fill="currentColor"
                />
                <path
                    d="M135.899 44.8544L135.835 43.0334L135.665 41.1881L135.326 39.3508L135.221 37.4893L135.366 34.9884L134.922 32.528L134.842 29.9623L136.763 29.9866L138.597 29.7195L140.559 29.59L140.745 31.5649L140.494 33.4345L140.712 35.2798L140.777 37.1413L140.955 39.9174L141.253 42.6935L141.479 44.3931L141.213 44.7168L139.541 44.6683L137.692 44.6764L135.899 44.8544Z"
                    fill="currentColor"
                />
                <path
                    d="M154.489 49.7753L153.277 48.4237L151.961 47.1125L150.524 45.9309L149.248 44.5631L147.754 42.564L145.832 40.9614L144.128 39.0514L145.606 37.8293L146.841 36.4453L148.263 35.0775L149.676 36.4695L150.685 38.064L152.034 39.3427L153.277 40.7267L155.199 42.7339L157.202 44.6683L158.47 45.8257V46.2384L157.162 47.2825L155.757 48.4803L154.489 49.7753Z"
                    fill="currentColor"
                />
                <path
                    d="M180.855 9.0163L182.365 8.0127L183.842 6.8958L185.223 5.63321L186.75 4.57296L188.946 3.37511L190.803 1.70785L192.935 0.291481L193.928 1.93447L195.116 3.35893L196.262 4.96954L194.679 6.15929L192.959 6.93627L191.506 8.09364L189.963 9.12152L187.702 10.7321L185.506 12.448L184.182 13.5406L183.77 13.4758L182.93 12.0271L181.945 10.4569L180.855 9.0163Z"
                    fill="currentColor"
                />
                <path
                    d="M159.608 52.349L161.232 53.1503L162.944 53.8706L164.72 54.4291L166.408 55.2141L168.54 56.5091L170.922 57.278L173.215 58.4111L172.295 60.1026L171.673 61.8508L170.857 63.6476L169.032 62.8868L167.506 61.7861L165.77 61.1062L164.106 60.2888L161.579 59.1395L158.995 58.1035L157.388 57.5046L157.226 57.1161L158.058 55.6593L158.914 54.0244L159.608 52.349Z"
                    fill="currentColor"
                />
                <path
                    d="M182.171 49.4354L181.493 51.1188L180.903 52.8751L180.475 54.6962L179.813 56.4444L178.682 58.6701L178.093 61.0981L177.132 63.4776L175.388 62.6845L173.603 62.1827L171.754 61.5109L172.384 59.6251L173.361 58.0145L173.902 56.2339L174.596 54.51L175.549 51.8958L176.397 49.2411L176.873 47.59L177.245 47.4039L178.755 48.1242L180.451 48.8607L182.171 49.4354Z"
                    fill="currentColor"
                />
                <path
                    d="M193.775 87.9525L192.039 87.4507L190.23 87.046L188.381 86.8113L186.58 86.3337L184.254 85.4354L181.775 85.1035L179.312 84.3913L179.926 82.5703L180.233 80.7411L180.709 78.823L182.647 79.2519L184.343 80.0613L186.168 80.4174L187.953 80.9354L190.642 81.6152L193.371 82.1818L195.059 82.4812L195.277 82.8373L194.72 84.4156L194.163 86.18L193.775 87.9525Z"
                    fill="currentColor"
                />
                <path
                    d="M199.04 62.8059L197.239 62.9839L195.406 63.2753L193.606 63.7366L191.756 63.9632L189.261 63.9875L186.838 64.5945L184.295 64.8454L184.182 62.9192L183.794 61.1062L183.536 59.1476L185.49 58.832L187.371 58.9614L189.196 58.6134L191.046 58.4354L193.799 58.0712L196.537 57.5856L198.217 57.2456L198.556 57.4884L198.62 59.1638L198.75 61.0172L199.04 62.8059Z"
                    fill="currentColor"
                />
                <path
                    d="M177.164 68.3499L177.431 70.1386L177.818 71.9596L178.376 73.7402L178.69 75.5775L178.844 78.0784L179.571 80.4659L179.958 83.0073L178.044 83.2096L176.26 83.6953L174.322 84.0514L173.902 82.117L173.934 80.2312L173.498 78.4183L173.223 76.5811L172.715 73.8454L172.093 71.126L171.665 69.4587L171.891 69.1107L173.563 68.957L175.396 68.7303L177.164 68.3499Z"
                    fill="currentColor"
                />
                <path
                    d="M166.658 45.9309L166.674 44.1179L166.577 42.2564L166.311 40.4111L166.287 38.5415L166.529 36.0568L166.19 33.5802L166.206 31.0145L168.128 31.1116L169.969 30.9174L171.939 30.8688L172.044 32.8517L171.713 34.7052L171.867 36.5667L171.843 38.4201L171.915 41.2043L172.101 43.9884L172.262 45.7043L171.98 46.0118L170.316 45.8985L168.467 45.8338L166.658 45.9309Z"
                    fill="currentColor"
                />
                <path
                    d="M154.359 36.6719L153.843 34.9318L153.205 33.1917L152.413 31.5001L151.84 29.7276L151.339 27.2753L150.29 25.0091L149.555 22.5487L151.42 22.0793L153.124 21.3508L154.989 20.7195L155.668 22.5891L155.902 24.4588L156.588 26.1908L157.113 27.9713L158.001 30.6098L158.995 33.2159L159.649 34.8104L159.471 35.1827L157.84 35.5631L156.055 36.0487L154.359 36.6719Z"
                    fill="currentColor"
                />
                <path
                    d="M171.035 14.9084L173.345 15.0217L174.903 16.6647V18.8985L173.999 20.5496L171.511 21.1809L169.121 19.6512L168.774 18.1539L169.371 16.0415L170.559 15.0379L171.035 14.9084Z"
                    fill="currentColor"
                />
                <path
                    d="M178.117 34.5918L178.464 36.8742L177.172 38.7438L174.984 39.189L173.191 38.6224L172.077 36.3077L173.094 33.653L174.491 33.0136L176.68 33.1836L177.899 34.1467L178.117 34.5918Z"
                    fill="currentColor"
                />
                <path
                    d="M188.211 29.3553L188.558 31.6458L187.266 33.5073L185.078 33.9525L183.285 33.394L182.171 31.0712L183.188 28.4246L184.585 27.7852L186.774 27.9471L187.985 28.9102L188.211 29.3553Z"
                    fill="currentColor"
                />
                <path
                    d="M193.137 41.6251L193.492 43.9156L192.192 45.7771L190.012 46.2222L188.211 45.6557L187.097 43.3409L188.114 40.6863L189.511 40.055L191.708 40.2168L192.919 41.18L193.137 41.6251Z"
                    fill="currentColor"
                />
                <path
                    d="M152.341 52.5352L150.104 53.1179L148.125 52.0091L147.463 49.8724L147.843 48.0271L150.031 46.6836L152.761 47.4363L153.536 48.7636L153.592 50.965L152.761 52.2681L152.341 52.5352Z"
                    fill="currentColor"
                />
                <path
                    d="M154.513 80.2717L152.276 80.8544L150.29 79.7456L149.627 77.6089L150.007 75.7636L152.195 74.4201L154.933 75.1728L155.708 76.5001L155.757 78.7016L154.925 80.0127L154.513 80.2717Z"
                    fill="currentColor"
                />
                <path
                    d="M154.174 36.1863L156.483 36.2996L158.05 37.9426V40.1764L157.137 41.8275L154.65 42.4587L152.26 40.9291L151.913 39.4318L152.51 37.3194L153.697 36.3158L154.174 36.1863Z"
                    fill="currentColor"
                />
                <path
                    d="M150.831 30.0757L152.591 31.573L152.825 33.8311L151.46 35.6035L149.732 36.3562L147.382 35.3284L146.421 32.6575L147.067 31.2573L148.828 29.9462L150.378 29.8814L150.831 30.0757Z"
                    fill="currentColor"
                />
                <path
                    d="M136.166 52.9641L137.926 54.4695L138.16 56.7276L136.796 58.5001L135.076 59.2528L132.718 58.2249L131.757 55.5541L132.403 54.1539L134.163 52.8427L135.714 52.778L136.166 52.9641Z"
                    fill="currentColor"
                />
                <path
                    d="M135.52 13.9938L137.28 15.4992L137.514 17.7573L136.15 19.5298L134.421 20.2744L132.072 19.2546L131.111 16.5757L131.749 15.1755L133.517 13.8724L135.068 13.7996L135.52 13.9938Z"
                    fill="currentColor"
                />
                <path
                    d="M131.942 8.62781L133.695 10.1332L133.937 12.3913L132.572 14.1557L130.844 14.9084L128.486 13.8805L127.533 11.2096L128.171 9.80947L129.94 8.50641L131.482 8.43357L131.942 8.62781Z"
                    fill="currentColor"
                />
                <path
                    d="M153.665 65.4039L152.559 67.4354L150.403 68.1395L148.392 67.1683L147.302 65.6386L147.81 63.1134L150.225 61.6161L151.719 61.9561L153.366 63.4129L153.754 64.9183L153.665 65.4039Z"
                    fill="currentColor"
                />
                <path
                    d="M165.52 63.4453L164.421 65.4848L162.265 66.1809L160.254 65.2177L159.164 63.68L159.673 61.1629L162.079 59.6656L163.581 59.9974L165.229 61.4543L165.616 62.9597L165.52 63.4453Z"
                    fill="currentColor"
                />
                <path
                    d="M169.759 81.8742L167.756 80.7249L167.102 78.5478L168.12 76.5568L169.678 75.4965L172.182 76.0712L173.611 78.5235L173.24 80.0127L171.746 81.6233L170.244 81.9794L169.759 81.8742Z"
                    fill="currentColor"
                />
                <path
                    d="M162.12 20.6062L163.355 22.573L162.911 24.7987L161.078 26.0775L159.213 26.2798L157.267 24.5963L157.145 21.7636L158.171 20.6143L160.246 19.894L161.748 20.2906L162.12 20.6062Z"
                    fill="currentColor"
                />
                <path
                    d="M159.019 -0.623085L160.246 1.33555L159.802 3.56127L157.977 4.84814L156.104 5.05048L154.166 3.36702L154.045 0.53429L155.07 -0.614992L157.145 -1.33532L158.639 -0.938733L159.019 -0.623085Z"
                    fill="currentColor"
                />
                <path
                    d="M123.835 32.5927L125.062 34.5514L124.618 36.7771L122.793 38.064L120.92 38.2663L118.982 36.5829L118.86 33.742L119.886 32.6008L121.961 31.8805L123.455 32.2771L123.835 32.5927Z"
                    fill="currentColor"
                />
                <path
                    d="M123.835 44.9677L125.062 46.9345L124.618 49.1602L122.793 50.439L120.92 50.6413L118.982 48.9579L118.86 46.1251L119.886 44.9758L121.961 44.2555L123.455 44.6521L123.835 44.9677Z"
                    fill="currentColor"
                />
                <path
                    d="M117.431 22.314L118.658 24.2807L118.214 26.5064L116.389 27.7852L114.516 27.9875L112.578 26.3041L112.457 23.4713L113.482 22.3221L115.558 21.6017L117.051 21.9983L117.431 22.314Z"
                    fill="currentColor"
                />
                <path
                    d="M175.808 45.5343L177.043 47.4929L176.599 49.7186L174.766 50.9974L172.9 51.1998L170.954 49.5244L170.833 46.6836L171.859 45.5424L173.934 44.814L175.436 45.2105L175.808 45.5343Z"
                    fill="currentColor"
                />
                <path
                    d="M181.832 65.8652L183.059 67.832L182.615 70.0577L180.782 71.3365L178.917 71.5388L176.97 69.8553L176.849 67.0226L177.875 65.8733L179.95 65.153L181.452 65.5496L181.832 65.8652Z"
                    fill="currentColor"
                />
                <path
                    d="M183.027 59.7303L184.254 61.689L183.81 63.9147L181.985 65.1935L180.112 65.3958L178.174 63.7204L178.052 60.8796L179.078 59.7303L181.153 59.01L182.647 59.4066L183.027 59.7303Z"
                    fill="currentColor"
                />
                <path
                    d="M186.766 13.5649L187.993 15.5235L187.549 17.7492L185.716 19.028L183.85 19.2303L181.904 17.555L181.783 14.7141L182.809 13.5649L184.884 12.8445L186.386 13.2411L186.766 13.5649Z"
                    fill="currentColor"
                />
                <path
                    d="M172.892 -1.27866L174.12 0.679975L173.676 2.90569L171.851 4.19257L169.977 4.3949L168.031 2.71145L167.91 -0.129378L168.935 -1.27056L171.011 -1.99089L172.513 -1.59431L172.892 -1.27866Z"
                    fill="currentColor"
                />
                <path
                    d="M108.459 7.40569L109.695 9.36432L109.243 11.59L107.418 12.8688L105.544 13.0712L103.606 11.3958L103.485 8.55497L104.511 7.41378L106.586 6.68537L108.08 7.08195L108.459 7.40569Z"
                    fill="currentColor"
                />
                <path
                    d="M111.746 -6.53945L112.973 -4.57272L112.529 -2.347L110.704 -1.06823L108.831 -0.865889L106.893 -2.54934L106.772 -5.38208L107.797 -6.53136L109.873 -7.25168L111.366 -6.8551L111.746 -6.53945Z"
                    fill="currentColor"
                />
                <path
                    d="M92.551 -4.05474L93.7865 -2.09611L93.3424 0.129611L91.5093 1.41648L89.6439 1.61882L87.6978 -0.0646332L87.5766 -2.90546L88.6022 -4.04665L90.6775 -4.76697L92.1796 -4.37039L92.551 -4.05474Z"
                    fill="currentColor"
                />
                <path
                    d="M126.685 -2.18514L127.913 -0.226505L127.469 1.99921L125.644 3.27799L123.77 3.48033L121.824 1.80497L121.703 -1.03586L122.737 -2.18514L124.804 -2.90546L126.306 -2.50888L126.685 -2.18514Z"
                    fill="currentColor"
                />
                <path
                    d="M190.133 75.1323L191.361 77.0909L190.916 79.3167L189.091 80.6035L187.218 80.8059L185.28 79.1224L185.159 76.2816L186.184 75.1404L188.26 74.4201L189.754 74.8167L190.133 75.1323Z"
                    fill="currentColor"
                />
                <path
                    d="M125.401 65.2582L126.637 67.2168L126.193 69.4426L124.36 70.7213L122.494 70.9237L120.548 69.2483L120.427 66.4075L121.453 65.2582L123.528 64.5379L125.03 64.9345L125.401 65.2582Z"
                    fill="currentColor"
                />
                <path
                    d="M102.249 81.1782L103.485 83.1368L103.041 85.3625L101.208 86.6494L99.3423 86.8517L97.3962 85.1683L97.275 82.3356L98.3006 81.1863L100.376 80.4659L101.878 80.8625L102.249 81.1782Z"
                    fill="currentColor"
                />
                <path
                    d="M120.92 76.2573L122.147 78.2159L121.703 80.4417L119.87 81.7204L118.004 81.9228L116.058 80.2474L115.937 77.4066L116.963 76.2573L119.038 75.537L120.54 75.9336L120.92 76.2573Z"
                    fill="currentColor"
                />
                <path
                    d="M104.567 59.5685L105.795 61.5352L105.35 63.7609L103.525 65.0397L101.652 65.242L99.7139 63.5586L99.5928 60.7258L100.618 59.5766L102.694 58.8562L104.188 59.2528L104.567 59.5685Z"
                    fill="currentColor"
                />
                <path
                    d="M134.704 76.7348L135.94 78.6935L135.496 80.9192L133.662 82.2061L131.797 82.4084L129.851 80.7249L129.73 77.8841L130.755 76.7429L132.831 76.0226L134.325 76.4192L134.704 76.7348Z"
                    fill="currentColor"
                />
                <path
                    d="M176.219 26.7978L177.132 28.6998L177.091 29.8248L176.357 30.7879L176.187 31.1845L175.888 31.2816L175.315 31.832L174.919 32.0748L173.32 31.9372L171.834 31.2816L170.591 29.9462L169.388 28.5945L167.991 27.4372L166.836 26.037L165.56 24.7582L164.114 23.6494L162.935 22.2573L162.112 20.8895L162.168 19.2708L162.467 18.7447L162.976 18.0082L164.567 17.037L165.843 17.215L167.159 18.0082L168.645 19.0523L169.913 20.3391L171.188 21.626L172.359 23.0019L173.845 24.0703L175.032 25.4462L176.042 26.4902L176.219 26.7978Z"
                    fill="currentColor"
                />
                <path
                    d="M162.419 5.92457L161.304 4.144L161.223 3.0109L161.845 1.97493L161.974 1.56216L162.257 1.43267L162.766 0.817559L163.129 0.534286L164.736 0.501911L166.287 0.97943L167.668 2.16918L169.016 3.38321L170.526 4.37871L171.834 5.63321L173.248 6.7663L174.806 7.70515L176.131 8.95965L177.1 10.2222L177.229 11.8409L176.978 12.3994L176.559 13.1926L175.089 14.3257L173.797 14.3014L172.4 13.6539L170.809 12.7798L169.412 11.6386L167.999 10.5055L166.674 9.2672L165.092 8.36882L163.759 7.1386L162.637 6.20785L162.419 5.92457Z"
                    fill="currentColor"
                />
                <path
                    d="M186.661 -2.12848L188.768 -2.1042L189.762 -1.56194L190.295 -0.477405L190.569 -0.145571L190.529 0.161983L190.763 0.922774L190.803 1.38411L189.972 2.76001L188.728 3.81216L186.984 4.33015L185.24 4.80767L183.584 5.55227L181.816 5.97313L180.112 6.55587L178.48 7.35713L176.712 7.79418L175.121 7.93177L173.692 7.16288L173.361 6.65299L172.925 5.87601L172.763 4.0145L173.49 2.94616L174.782 2.11252L176.373 1.24652L178.093 0.679968L179.805 0.0972348L181.557 -0.339815L183.172 -1.19773L184.925 -1.65097L186.305 -2.09611L186.661 -2.12848Z"
                    fill="currentColor"
                />
                <path
                    d="M148.19 4.57296L146.187 5.21235L145.073 5.0181L144.233 4.16019L143.862 3.92548L143.805 3.62602L143.337 2.97853L143.159 2.54958L143.514 0.987526L144.362 -0.40456L145.856 -1.45672L147.358 -2.46031L148.699 -3.68244L150.241 -4.63747L151.679 -5.7301L152.971 -7.01697L154.513 -7.98819L155.975 -8.61949L157.574 -8.33621L158.05 -7.96391L158.712 -7.36499L159.447 -5.64916L159.1 -4.40276L158.131 -3.20492L156.895 -1.87758L155.442 -0.801142L153.996 0.291484L152.478 1.2708L151.218 2.59004L149.692 3.57745L148.521 4.43537L148.19 4.57296Z"
                    fill="currentColor"
                />
                <path
                    d="M151.283 61.3652L149.353 62.207L148.222 62.1179L147.294 61.349L146.906 61.1629L146.817 60.8634L146.292 60.2645L146.066 59.8598L146.268 58.2654L146.971 56.8005L148.351 55.6026L149.74 54.4534L150.952 53.0936L152.381 51.9848L153.705 50.7546L154.868 49.3463L156.298 48.2213L157.695 47.4525L159.31 47.5658L159.818 47.8895L160.537 48.4237L161.442 50.0505L161.224 51.3212L160.384 52.6161L159.285 54.0568L157.953 55.2789L156.629 56.5091L155.207 57.6341L154.085 59.0829L152.672 60.2159L151.59 61.1953L151.283 61.3652Z"
                    fill="currentColor"
                />
                <path
                    d="M127.348 66.2699L125.862 64.7807L125.531 63.6962L125.91 62.5469L125.942 62.1098L126.193 61.9237L126.556 61.2114L126.847 60.8553L128.397 60.4668L130.02 60.5882L131.636 61.4381L133.21 62.3203L134.906 62.9597L136.465 63.8904L138.088 64.6755L139.816 65.2501L141.382 66.1809L142.61 67.2007L143.094 68.7465L142.973 69.3454L142.747 70.2114L141.56 71.644L140.292 71.903L138.79 71.5873L137.046 71.0936L135.423 70.2843L133.8 69.4992L132.241 68.5847L130.489 68.0667L128.922 67.1602L127.622 66.4965L127.348 66.2699Z"
                    fill="currentColor"
                />
                <path
                    d="M139.622 72.9147L141.181 71.4983L142.271 71.215L143.401 71.644L143.829 71.7007L144.007 71.9596L144.701 72.3562L145.041 72.6638L145.364 74.2339L145.17 75.8526L144.241 77.4309L143.288 78.9686L142.578 80.6359L141.576 82.1494L140.72 83.7438L140.066 85.4516L139.073 86.9731L137.999 88.1548L136.432 88.5676L135.843 88.4219L134.995 88.1467L133.614 86.9003L133.412 85.6215L133.8 84.1242L134.373 82.4084L135.253 80.8221L136.109 79.2276L137.094 77.7061L137.692 75.9821L138.669 74.4525L139.38 73.1737L139.622 72.9147Z"
                    fill="currentColor"
                />
                <path
                    d="M96.2415 45.2186L96.2819 43.1143L96.8229 42.1188L97.905 41.5927L98.2442 41.3176L98.551 41.358L99.3101 41.1314L99.7704 41.0909L101.135 41.9327L102.177 43.1872L102.686 44.9354L103.154 46.6917L103.881 48.3508L104.293 50.1233L104.866 51.8391L105.665 53.474L106.093 55.2546L106.215 56.8409L105.439 58.2735L104.931 58.5972L104.147 59.0343L102.298 59.18L101.232 58.4516L100.408 57.1485L99.5524 55.5541L98.9952 53.8302L98.4299 52.1062L97.9938 50.3499L97.1459 48.7312L96.7018 46.9668L96.2738 45.5748L96.2415 45.2186Z"
                    fill="currentColor"
                />
                <path
                    d="M121.299 56.9219L123.245 56.1206L124.368 56.2258L125.288 57.0109L125.668 57.2132L125.749 57.5127L126.265 58.1197L126.483 58.5244L126.249 60.1188L125.514 61.5757L124.117 62.7411L122.696 63.858L121.461 65.1935L120.007 66.2699L118.659 67.4758L117.471 68.8598L116.018 69.9525L114.605 70.6971L112.99 70.5514L112.489 70.2195L111.778 69.6692L110.914 68.0262L111.157 66.7555L112.021 65.4767L113.143 64.0523L114.508 62.8625L115.856 61.6566L117.302 60.564L118.449 59.1395L119.886 58.0388L120.984 57.0838L121.299 56.9219Z"
                    fill="currentColor"
                />
                <path
                    d="M117.035 69.653L119.127 69.4426L120.169 69.8715L120.823 70.8832L121.138 71.1908L121.121 71.4983L121.444 72.2267L121.541 72.6881L120.863 74.1368L119.741 75.3266L118.061 76.0388L116.381 76.7106L114.823 77.6251L113.119 78.2402L111.479 79.0091L109.953 79.9965L108.241 80.6278L106.675 80.9354L105.173 80.3284L104.793 79.867L104.268 79.1386L103.905 77.3095L104.502 76.1602L105.698 75.1971L107.175 74.153L108.823 73.4003L110.462 72.6314L112.158 72.0001L113.66 70.9642L115.356 70.3167L116.68 69.7258L117.035 69.653Z"
                    fill="currentColor"
                />
                <path
                    d="M131.975 57.5046L131.208 59.4713L130.36 60.2159L129.156 60.3373L128.753 60.483L128.478 60.3293L127.679 60.2888L127.234 60.1593L126.249 58.8967L125.7 57.3589L125.829 55.5379L125.991 53.7411L125.878 51.9282L126.104 50.1233L126.16 48.3104L125.983 46.4974L126.193 44.6845L126.621 43.1467L127.84 42.0784L128.43 41.9408L129.318 41.8032L131.103 42.305L131.854 43.3652L132.177 44.8706L132.435 46.6674L132.354 48.4803L132.298 50.2852L132.096 52.09L132.33 53.903L132.144 55.7079L132.072 57.1647L131.975 57.5046Z"
                    fill="currentColor"
                />
                <path
                    d="M103.945 48.3185L102.419 46.8697L102.056 45.7933L102.395 44.6359L102.419 44.1989L102.661 44.0046L103.001 43.2843L103.283 42.9201L104.826 42.4749L106.449 42.5478L108.088 43.349L109.687 44.1827L111.407 44.7654L112.99 45.6557L114.637 46.3922L116.381 46.9021L117.98 47.7843L119.232 48.7636L119.765 50.3014L119.668 50.9003L119.458 51.7744L118.319 53.2393L117.068 53.5388L115.55 53.2717L113.797 52.8346L112.15 52.0739L110.494 51.3373L108.912 50.4713L107.143 50.01L105.552 49.1521L104.228 48.537L103.945 48.3185Z"
                    fill="currentColor"
                />
                <path
                    d="M148.271 24.9848L146.607 26.2798L145.501 26.4821L144.411 25.9722L143.983 25.8832L143.821 25.6161L143.167 25.171L142.844 24.8392L142.642 23.2447L142.957 21.6422L143.991 20.1449L145.057 18.68L145.888 17.0613L147.003 15.6287L147.972 14.1071L148.747 12.4561L149.853 11.0073L151.008 9.9066L152.607 9.61523L153.181 9.80138L154.004 10.1332L155.288 11.4848L155.393 12.7717L154.901 14.2366L154.198 15.912L153.213 17.4255L152.236 18.9471L151.146 20.3958L150.419 22.0712L149.337 23.528L148.529 24.742L148.271 24.9848Z"
                    fill="currentColor"
                />
                <path
                    d="M98.0745 31.4192L97.4769 29.4039L97.703 28.2951L98.5752 27.4614L98.8174 27.0972L99.1243 27.0487L99.7784 26.5954L100.206 26.4255L101.757 26.8221L103.13 27.7043L104.139 29.2258L105.108 30.7555L106.295 32.1233L107.216 33.6854L108.274 35.1503L109.525 36.4776L110.462 38.0478L111.052 39.5289L110.737 41.1233L110.357 41.5846L109.735 42.2402L108.015 42.9363L106.78 42.5559L105.609 41.5604L104.309 40.2897L103.267 38.8086L102.209 37.3436L101.272 35.7897L99.9803 34.5028L99.0355 32.9489L98.2037 31.751L98.0745 31.4192Z"
                    fill="currentColor"
                />
                <path
                    d="M116.414 13.5649L115.113 11.9057L114.912 10.7969L115.42 9.69616L115.509 9.26721L115.776 9.11343L116.22 8.44976L116.551 8.12602L118.142 7.92368L119.741 8.23933L121.235 9.2753L122.704 10.3356L124.311 11.1692L125.749 12.278L127.267 13.2492L128.922 14.0181L130.368 15.1269L131.466 16.2843L131.757 17.8787L131.579 18.4534L131.24 19.287L129.899 20.5739L128.607 20.6872L127.154 20.1935L125.482 19.4974L123.964 18.5019L122.446 17.5307L121 16.4381L119.321 15.7177L117.875 14.6332L116.656 13.8239L116.414 13.5649Z"
                    fill="currentColor"
                />
                <path
                    d="M109.154 -1.06014L111.254 -1.16535L112.279 -0.687836L112.885 0.356229L113.184 0.671877L113.151 0.979431L113.442 1.72404L113.515 2.18537L112.764 3.60173L111.593 4.73483L109.881 5.36612L108.169 5.95695L106.57 6.79868L104.834 7.33285L103.162 8.0208L101.587 8.92727L99.8512 9.47763L98.2765 9.71234L96.7987 9.03249L96.4353 8.55497L95.9508 7.80227L95.6762 5.95695L96.3303 4.84004L97.5658 3.92547L99.1002 2.96234L100.78 2.29058L102.451 1.60263L104.171 1.04418L105.73 0.0891433L107.45 -0.477404L108.807 -1.01158L109.154 -1.06014Z"
                    fill="currentColor"
                />
                <path
                    d="M114.556 12.7555L116.567 13.3868L117.358 14.1962L117.56 15.3859L117.73 15.7825L117.593 16.0658L117.601 16.867L117.512 17.3203L116.309 18.3886L114.815 19.0361L112.998 19.028L111.189 18.9794L109.396 19.2061L107.579 19.0927L105.778 19.1575L103.986 19.4489L102.161 19.3598L100.602 19.0199L99.4634 17.8706L99.2938 17.296L99.1 16.4138L99.4796 14.5927L100.481 13.7753L101.967 13.3544L103.735 12.9902L105.544 12.9498L107.353 12.8931L109.154 12.974L110.947 12.626L112.755 12.6989L114.209 12.6746L114.556 12.7555Z"
                    fill="currentColor"
                />
                <path
                    d="M113.757 29.7438L115.073 28.1008L116.107 27.6476L117.286 27.8985L117.722 27.8823L117.932 28.1089L118.683 28.3922L119.07 28.6431L119.628 30.1485L119.684 31.7753L119.022 33.4749L118.319 35.1422L117.883 36.9066L117.124 38.5577L116.527 40.2654L116.155 42.046L115.412 43.7132L114.532 45.0487L113.046 45.7043L112.449 45.6476L111.56 45.5181L110.01 44.4983L109.606 43.2681L109.751 41.7303L110.05 39.9417L110.672 38.2339L111.27 36.5262L112.005 34.867L112.328 33.0703L113.054 31.403L113.555 30.0352L113.757 29.7438Z"
                    fill="currentColor"
                />
                <path
                    d="M123.383 44.644L121.307 45.0163L120.233 44.6683L119.506 43.7052L119.175 43.4219L119.159 43.1143L118.788 42.4102L118.659 41.965L119.224 40.4597L120.257 39.1971L121.873 38.3634L123.496 37.5703L124.99 36.5343L126.637 35.7897L128.212 34.8994L129.665 33.8068L131.321 33.046L132.863 32.617L134.405 33.1107L134.825 33.5397L135.399 34.2276L135.899 36.0244L135.391 37.2141L134.268 38.2744L132.871 39.4237L131.28 40.2978L129.706 41.18L128.066 41.9489L126.645 43.09L125.006 43.8589L123.722 44.555L123.383 44.644Z"
                    fill="currentColor"
                />
                <path
                    d="M163.032 71.6197L160.941 71.4255L159.996 70.8023L159.552 69.6854L159.302 69.3293L159.366 69.0217L159.197 68.2447L159.189 67.7834L160.133 66.4803L161.466 65.5415L163.242 65.1611L165.019 64.8293L166.731 64.2303L168.524 63.9552L170.276 63.5181L171.972 62.8463L173.765 62.555H175.363L176.72 63.4372L177.011 63.9632L177.382 64.7807L177.39 66.6422L176.583 67.6539L175.218 68.3742L173.563 69.1107L171.802 69.5316L170.05 69.9686L168.265 70.2681L166.594 70.9884L164.809 71.296L163.388 71.6278L163.032 71.6197Z"
                    fill="currentColor"
                />
                <path
                    d="M189.705 64.4165L191.708 63.7771L192.822 63.9713L193.67 64.8293L194.042 65.064L194.098 65.3634L194.558 66.0109L194.744 66.4399L194.389 68.0019L193.541 69.394L192.047 70.4462L190.545 71.4498L189.213 72.68L187.67 73.635L186.233 74.7276L184.941 76.0145L183.398 76.9938L181.937 77.617L180.338 77.3418L179.861 76.9695L179.199 76.3706L178.464 74.6548L178.812 73.4084L179.772 72.2105L181.008 70.8832L182.462 69.7987L183.907 68.7061L185.425 67.7348L186.685 66.4075L188.203 65.4201L189.382 64.5622L189.705 64.4165Z"
                    fill="currentColor"
                />
                <path
                    d="M161.127 85.7267L159.342 84.6017L158.777 83.6224L158.89 82.4165L158.825 81.9875L159.027 81.7447L159.221 80.9758L159.423 80.5631L160.852 79.8266L162.459 79.5838L164.219 80.0532L165.956 80.555L167.748 80.7897L169.476 81.3562L171.237 81.7528L173.046 81.9147L174.782 82.465L176.203 83.1854L177.019 84.5936L177.043 85.1926L177.011 86.0909L176.179 87.7582L175 88.2924L173.466 88.3248L171.657 88.2357L169.896 87.8149L168.136 87.4102L166.408 86.876L164.591 86.7627L162.855 86.2285L161.441 85.8886L161.127 85.7267Z"
                    fill="currentColor"
                />
                <path
                    d="M141.003 63.3805L139.347 64.6755L138.233 64.8778L137.143 64.3679L136.715 64.2789L136.562 64.0118L135.899 63.5667L135.576 63.2348L135.374 61.6404L135.689 60.0379L136.731 58.5406L137.789 57.0757L138.621 55.465L139.735 54.0244L140.712 52.5028L141.479 50.8517L142.586 49.403L143.749 48.3023L145.339 48.0109L145.913 48.1971L146.744 48.5289L148.02 49.8805L148.133 51.1674L147.633 52.6323L146.938 54.3077L145.945 55.8212L144.968 57.3427L143.878 58.7915L143.151 60.4668L142.069 61.9237L141.261 63.1377L141.003 63.3805Z"
                    fill="currentColor"
                />
                <path
                    d="M153.374 60.3859L154.085 58.403L154.925 57.6422L156.12 57.4884L156.524 57.3347L156.798 57.4803L157.598 57.5046L158.042 57.6179L159.059 58.8562L159.649 60.3778L159.568 62.207L159.447 64.0118L159.592 65.8248L159.415 67.6296L159.407 69.4426L159.625 71.2474L159.463 73.0685L159.059 74.6143L157.872 75.715L157.283 75.8607L156.403 76.0226L154.602 75.5613L153.827 74.5253L153.471 73.028L153.172 71.2312L153.205 69.4183L153.221 67.6134L153.382 65.8086L153.1 63.9956L153.245 62.1908L153.285 60.7339L153.374 60.3859Z"
                    fill="currentColor"
                />
                <path
                    d="M147.269 30.2375L147.851 32.2609L147.625 33.3697L146.753 34.1953L146.51 34.5595L146.203 34.608L145.549 35.0532L145.121 35.2312L143.563 34.8266L142.198 33.9444L141.197 32.4228L140.228 30.885L139.049 29.5172L138.128 27.9471L137.078 26.474L135.835 25.1467L134.898 23.5766L134.317 22.0954L134.632 20.501L135.019 20.0397L135.633 19.3841L137.361 18.6962L138.597 19.0766L139.767 20.0802L141.059 21.3508L142.093 22.832L143.143 24.305L144.08 25.8589L145.364 27.1539L146.308 28.7079L147.14 29.9057L147.269 30.2375Z"
                    fill="currentColor"
                />
                <path
                    d="M172.4 50.6332L173.482 52.4381L173.538 53.5712L172.9 54.5909L172.763 55.0037L172.472 55.1332L171.956 55.7321L171.584 56.0073L169.977 56.0154L168.435 55.5055L167.078 54.2834L165.754 53.0451L164.26 52.0172L162.976 50.7384L161.587 49.5811L160.053 48.6098L158.752 47.3311L157.808 46.0442L157.711 44.4255L157.969 43.8751L158.405 43.09L159.899 41.9812L161.191 42.0379L162.572 42.7097L164.147 43.608L165.528 44.7816L166.917 45.939L168.209 47.2016L169.783 48.1323L171.083 49.3949L172.19 50.3418L172.4 50.6332Z"
                    fill="currentColor"
                />
                <path
                    d="M173.563 44.6521L172.133 43.0981L171.843 42.0055L172.254 40.8724L172.311 40.4435L172.561 40.2654L172.949 39.5694L173.256 39.2213L174.822 38.8814L176.437 39.0676L178.02 39.974L179.563 40.9129L181.234 41.617L182.752 42.6044L184.351 43.4462L186.063 44.0856L187.589 45.0649L188.776 46.1332L189.204 47.6953L189.067 48.2861L188.801 49.144L187.565 50.5361L186.297 50.7465L184.803 50.3823L183.075 49.8158L181.484 48.9579L179.894 48.108L178.359 47.1368L176.631 46.5541L175.097 45.5909L173.821 44.8868L173.563 44.6521Z"
                    fill="currentColor"
                />
                <path
                    d="M189.77 15.9039L191.772 15.2807L192.887 15.4911L193.727 16.3571L194.09 16.5918L194.147 16.8913L194.607 17.5469L194.785 17.9758L194.413 19.5379L193.549 20.9219L192.047 21.9498L190.537 22.9453L189.188 24.1593L187.638 25.0981L186.192 26.1827L184.884 27.4534L183.334 28.4084L181.864 29.0235L180.273 28.7321L179.805 28.3598L179.143 27.7447L178.424 26.0289L178.779 24.7825L179.756 23.5927L181.008 22.2816L182.47 21.2133L183.923 20.1368L185.458 19.1737L186.725 17.8625L188.252 16.8913L189.439 16.0415L189.77 15.9039Z"
                    fill="currentColor"
                />
                <path
                    d="M185.264 -6.36139L186.37 -4.57273L186.451 -3.43963L185.821 -2.40366L185.692 -1.99089L185.409 -1.86139L184.892 -1.25438L184.529 -0.971107L182.93 -0.938733L181.371 -1.43244L179.999 -2.62219L178.658 -3.84431L177.148 -4.83981L175.848 -6.1105L174.435 -7.24359L172.884 -8.19053L171.568 -9.44503L170.599 -10.7157L170.478 -12.3344L170.728 -12.8929L171.148 -13.6779L172.626 -14.811L173.918 -14.7787L175.315 -14.1312L176.898 -13.249L178.295 -12.0997L179.7 -10.9666L181.016 -9.72021L182.607 -8.81373L183.931 -7.57542L185.046 -6.64467L185.264 -6.36139Z"
                    fill="currentColor"
                />
                <path
                    d="M192.669 48.1242L194.76 47.9219L195.802 48.3508L196.456 49.3706L196.763 49.6701L196.755 49.9776L197.07 50.7141L197.167 51.1674L196.48 52.6161L195.358 53.7978L193.678 54.51L191.999 55.1737L190.432 56.0882L188.72 56.6953L187.089 57.4561L185.554 58.4354L183.842 59.0667L182.276 59.3661L180.774 58.7591L180.386 58.2897L179.869 57.5613L179.514 55.7321L180.112 54.5909L181.315 53.6197L182.801 52.5838L184.448 51.8391L186.087 51.0784L187.783 50.4471L189.293 49.4192L190.989 48.7798L192.322 48.189L192.669 48.1242Z"
                    fill="currentColor"
                />
                <path
                    d="M148.957 7.98843L150.039 9.80138L150.096 10.9345L149.458 11.9543L149.321 12.367L149.038 12.4884L148.513 13.0954L148.142 13.3706H146.535L144.992 12.8607L143.636 11.6467L142.319 10.4084L140.825 9.38051L139.541 8.09364L138.152 6.94436L136.61 5.97314L135.31 4.69436L134.365 3.40749L134.276 1.78069L134.527 1.23843L134.963 0.453357L136.457 -0.655457L137.749 -0.598801L139.129 0.0648674L140.704 0.971342L142.085 2.1449L143.474 3.30228L144.766 4.56487L146.341 5.49562L147.641 6.75012L148.747 7.70516L148.957 7.98843Z"
                    fill="currentColor"
                />
                <path
                    d="M134.325 1.17368L132.895 2.72764L131.837 3.09994L130.675 2.7762L130.238 2.76001L130.045 2.5253L129.318 2.19346L128.946 1.91019L128.486 0.372422L128.543 -1.25438L129.318 -2.90546L130.134 -4.52416L130.691 -6.25618L131.555 -7.8506L132.273 -9.50977L132.766 -11.2661L133.622 -12.8767L134.591 -14.1474L136.109 -14.6977L136.707 -14.6087L137.579 -14.4145L139.065 -13.2895L139.38 -12.035L139.129 -10.5134L138.709 -8.74089L137.975 -7.08981L137.264 -5.42254L136.416 -3.82002L135.972 -2.04754L135.14 -0.436931L134.543 0.890407L134.325 1.17368Z"
                    fill="currentColor"
                />
                <path
                    d="M163.759 40.2249L162.548 41.9489L161.547 42.4587L160.351 42.2888L159.915 42.3293L159.689 42.1188L158.93 41.8841L158.526 41.6575L157.872 40.1926L157.711 38.5658L158.276 36.8257L158.866 35.1179L159.197 33.3373L159.851 31.6377L160.343 29.8976L160.602 28.0927L161.248 26.385L162.039 25.001L163.476 24.2564L164.082 24.2645L164.97 24.3454L166.585 25.2681L167.062 26.474L167.013 28.0118L166.828 29.8167L166.311 31.5568L165.818 33.2969L165.188 34.9965L164.979 36.8176L164.357 38.5253L163.937 39.9174L163.759 40.2249Z"
                    fill="currentColor"
                />
                <path
                    d="M143.498 81.8014L142.578 79.9075L142.61 78.7744L143.337 77.8113L143.514 77.4066L143.805 77.3095L144.378 76.7591L144.774 76.5163L146.373 76.6458L147.867 77.2933L149.11 78.6206L150.322 79.9722L151.719 81.1215L152.89 82.5136L154.174 83.7843L155.627 84.885L156.806 86.269L157.638 87.6368L157.59 89.2555L157.291 89.7816L156.79 90.5262L155.207 91.4974L153.923 91.3356L152.599 90.5424L151.113 89.5064L149.837 88.2195L148.553 86.9489L147.374 85.573L145.888 84.5127L144.701 83.1449L143.684 82.1008L143.498 81.8014Z"
                    fill="currentColor"
                />
                <path
                    d="M86.9064 115.446L86.3088 117.162L85.8082 118.951L85.4609 120.78L84.8876 122.56L83.862 124.835L83.3856 127.295L82.5377 129.715L80.753 129.003L78.9522 128.59L77.0707 127.999L77.6117 126.089L78.5162 124.438L78.9684 122.633L79.5821 120.877L80.4139 118.222L81.1326 115.527L81.5363 113.852L81.8916 113.649L83.4421 114.297L85.1702 114.961L86.9064 115.446Z"
                    fill="currentColor"
                />
                <path
                    d="M41.8058 110.558L42.6941 112.144L43.6954 113.706L44.8421 115.171L45.795 116.782L46.8205 119.056L48.3387 121.039L49.5985 123.273L47.8865 124.147L46.3845 125.231L44.6967 126.259L43.6227 124.592L42.9848 122.811L41.935 121.274L41.0305 119.655L39.5851 117.275L38.0427 114.952L37.0575 113.544L37.1463 113.14L38.6483 112.411L40.2876 111.545L41.8058 110.558Z"
                    fill="currentColor"
                />
                <path
                    d="M38.5998 112.63L36.7909 112.589L34.9336 112.646L33.0844 112.881L31.219 112.872L28.7479 112.589L26.2688 112.889L23.7089 112.816L23.8381 110.898L23.6847 109.052L23.6686 107.069L25.647 107.005L27.4963 107.361L29.3455 107.256L31.2028 107.304L33.9807 107.28L36.7586 107.142L38.4706 107.021L38.7694 107.304L38.6321 108.971L38.5271 110.825L38.5998 112.63Z"
                    fill="currentColor"
                />
                <path
                    d="M17.9594 96.9039L19.7602 96.7825L21.6013 96.5478L23.4264 96.1512L25.2756 95.9812L27.7709 96.046L30.2177 95.5199L32.7695 95.3499L32.8099 97.2762L33.141 99.1053L33.3348 101.072L31.3644 101.315L29.499 101.129L27.6578 101.412L25.8086 101.533L23.0468 101.809L20.2931 102.197L18.5973 102.48L18.2743 102.229L18.2582 100.554L18.1936 98.7007L17.9594 96.9039Z"
                    fill="currentColor"
                />
                <path
                    d="M8.6727 105.386L7.04956 104.593L5.32952 103.881L3.55295 103.33L1.85714 102.553L-0.274747 101.266L-2.65696 100.506L-4.95843 99.3886L-4.04592 97.6971L-3.43219 95.9489L-2.63274 94.1359L-0.799643 94.8967L0.734667 95.9893L2.47086 96.653L4.13437 97.4704L6.6781 98.6035L9.2622 99.6233L10.8773 100.214L11.0307 100.603L10.2151 102.068L9.3591 103.711L8.6727 105.386Z"
                    fill="currentColor"
                />
                <path
                    d="M16.1182 122.965L16.1667 124.778L16.3282 126.631L16.6592 128.469L16.7481 130.33L16.5946 132.831L17.0226 135.291L17.0953 137.857L15.1734 137.833L13.3403 138.084L11.378 138.205L11.2003 136.23L11.4587 134.361L11.2488 132.507L11.2003 130.654L11.0308 127.87L10.7481 125.102L10.5301 123.394L10.7966 123.078L12.4682 123.127H14.3174L16.1182 122.965Z"
                    fill="currentColor"
                />
                <path
                    d="M26.0831 120.764L26.4142 122.544L26.8664 124.349L27.4801 126.113L27.8678 127.934L28.11 130.427L28.9175 132.791L29.394 135.316L27.4882 135.591L25.7197 136.133L23.7978 136.562L23.3133 134.636L23.2729 132.75L22.7803 130.961L22.4331 129.132L21.8355 126.413L21.1168 123.718L20.6323 122.067L20.8422 121.711L22.5057 121.5L24.3308 121.209L26.0831 120.764Z"
                    fill="currentColor"
                />
                <path
                    d="M7.29192 132.936L6.03217 131.625L4.66744 130.363L3.18966 129.229L1.86531 127.918L0.30677 125.968L-1.67168 124.438L-3.44825 122.593L-2.01085 121.314L-0.823774 119.89L0.549029 118.465L2.00259 119.817L3.06853 121.371L4.46556 122.593L5.75761 123.936L7.74413 125.871L9.81949 127.732L11.1277 128.841L11.1438 129.254L9.87602 130.346L8.51129 131.593L7.29192 132.936Z"
                    fill="currentColor"
                />
                <path
                    d="M66.5404 116.45L64.8284 115.851L63.0438 115.341L61.2107 115.001L59.4422 114.418L57.1649 113.39L54.7181 112.913L52.3036 112.071L53.0061 110.282L53.4261 108.47L54.0075 106.584L55.9133 107.126L57.5687 108.032L59.3695 108.494L61.1138 109.109L63.7705 109.934L66.4515 110.655L68.1231 111.059L68.325 111.424L67.679 112.97L67.0249 114.702L66.5404 116.45Z"
                    fill="currentColor"
                />
                <path
                    d="M46.8286 99.3401L45.262 100.263L43.7196 101.291L42.2741 102.472L40.6913 103.452L38.4302 104.512L36.4841 106.074L34.2714 107.369L33.3751 105.669L32.2688 104.188L31.219 102.513L32.8583 101.412L34.6187 100.74L36.1368 99.6638L37.7358 98.7249L40.0857 97.2357L42.3791 95.6575L43.7599 94.6377L44.1718 94.7186L44.9309 96.216L45.8191 97.8427L46.8286 99.3401Z"
                    fill="currentColor"
                />
                <path
                    d="M90.3061 142.22L90.9037 140.504L91.4125 138.715L91.7516 136.886L92.333 135.105L93.3586 132.831L93.8351 130.371L94.6749 127.951L96.4595 128.663L98.2684 129.076L100.15 129.666L99.6089 131.577L98.7045 133.228L98.2442 135.032L97.6305 136.789L96.8068 139.443L96.0881 142.139L95.6843 143.814L95.3209 144.016L93.7785 143.369L92.0504 142.705L90.3061 142.22Z"
                    fill="currentColor"
                />
                <path
                    d="M26.0024 104.997L24.8718 106.414L23.8059 107.935L22.8691 109.554L21.7386 111.035L20.0105 112.84L18.7507 115.001L17.1518 117L15.7063 115.738L14.1397 114.742L12.557 113.56L13.7037 111.942L15.1007 110.679L16.1343 109.133L17.2972 107.684L18.9607 105.451L20.5354 103.152L21.464 101.711L21.8678 101.639L23.1114 102.764L24.5246 103.961L26.0024 104.997Z"
                    fill="currentColor"
                />
                <path
                    d="M39.3186 126.041L38.4303 127.627L37.6228 129.302L36.9687 131.05L36.0965 132.693L34.6834 134.757L33.7951 137.096L32.5434 139.338L30.9041 138.327L29.2002 137.598L27.4479 136.692L28.3119 134.903L29.4909 133.438L30.2581 131.738L31.1625 130.12L32.4384 127.643L33.6174 125.118L34.2957 123.54L34.6914 123.402L36.0965 124.309L37.6874 125.264L39.3186 126.041Z"
                    fill="currentColor"
                />
                <path
                    d="M72.2255 118.659L70.667 119.582L69.1327 120.626L67.6953 121.808L66.1125 122.795L63.8595 123.872L61.9214 125.442L59.7169 126.753L58.8124 125.053L57.698 123.572L56.6321 121.905L58.2714 120.796L60.0318 120.116L61.5419 119.032L63.1327 118.085L65.4746 116.587L67.7599 114.993L69.1407 113.973L69.5445 114.046L70.3117 115.543L71.208 117.162L72.2255 118.659Z"
                    fill="currentColor"
                />
                <path
                    d="M84.7906 113.115L86.3007 112.112L87.7866 110.995L89.1594 109.74L90.6937 108.672L92.8821 107.482L94.7394 105.815L96.8713 104.39L97.8646 106.041L99.0597 107.466L100.198 109.068L98.6156 110.266L96.9036 111.035L95.4501 112.201L93.8996 113.22L91.6385 114.839L89.442 116.547L88.1177 117.64L87.7058 117.583L86.866 116.134L85.8889 114.564L84.7906 113.115Z"
                    fill="currentColor"
                />
                <path
                    d="M58.2955 140.779L57.7787 139.039L57.1488 137.291L56.3494 135.607L55.776 133.827L55.2754 131.382L54.2256 129.108L53.4988 126.648L55.3561 126.178L57.06 125.458L58.9335 124.827L59.6118 126.688L59.846 128.566L60.5243 130.298L61.0573 132.078L61.9375 134.717L62.9308 137.323L63.5849 138.909L63.4072 139.29L61.7841 139.67L59.9914 140.148L58.2955 140.779Z"
                    fill="currentColor"
                />
                <path
                    d="M74.9711 119.015L77.2806 119.129L78.8472 120.772V123.006L77.9347 124.657L75.4475 125.288L73.0572 123.758L72.71 122.261L73.3157 120.14L74.4946 119.137L74.9711 119.015Z"
                    fill="currentColor"
                />
                <path
                    d="M82.0532 138.691L82.4004 140.981L81.1084 142.843L78.92 143.296L77.1272 142.729L76.0128 140.415L77.0303 137.76L78.4273 137.121L80.6158 137.291L81.8351 138.254L82.0532 138.691Z"
                    fill="currentColor"
                />
                <path
                    d="M92.1473 133.462L92.4946 135.745L91.2025 137.614L89.0141 138.059L87.2214 137.493L86.107 135.178L87.1245 132.524L88.5215 131.884L90.7099 132.054L91.9293 133.017L92.1473 133.462Z"
                    fill="currentColor"
                />
                <path
                    d="M54.7746 134.175L56.527 135.68L56.7612 137.938L55.3964 139.711L53.6764 140.455L51.3184 139.435L50.3655 136.756L51.0035 135.364L52.772 134.053L54.3143 133.988L54.7746 134.175Z"
                    fill="currentColor"
                />
                <path
                    d="M39.4639 118.101L41.2162 119.606L41.4504 121.856L40.0857 123.629L38.3657 124.381L36.0077 123.354L35.0467 120.683L35.6927 119.282L37.4532 117.971L39.0036 117.907L39.4639 118.101Z"
                    fill="currentColor"
                />
                <path
                    d="M35.8784 112.727L37.6388 114.232L37.873 116.49L36.5083 118.263L34.7802 119.015L32.4302 117.988L31.4693 115.317L32.1072 113.916L33.8757 112.605L35.4262 112.541L35.8784 112.727Z"
                    fill="currentColor"
                />
                <path
                    d="M66.064 124.713L67.2915 126.672L66.8473 128.898L65.0223 130.184L63.1488 130.387L61.2027 128.703L61.0816 125.863L62.1152 124.721L64.1825 124.001L65.6845 124.398L66.064 124.713Z"
                    fill="currentColor"
                />
                <path
                    d="M27.7709 136.7L29.0064 138.658L28.5623 140.884L26.7292 142.163L24.8638 142.365L22.9176 140.69L22.7965 137.849L23.8221 136.708L25.8974 135.979L27.3914 136.376L27.7709 136.7Z"
                    fill="currentColor"
                />
                <path
                    d="M21.3671 126.421L22.6026 128.38L22.1504 130.605L20.3254 131.892L18.46 132.095L16.5139 130.411L16.3927 127.57L17.4183 126.429L19.4937 125.709L20.9876 126.105L21.3671 126.421Z"
                    fill="currentColor"
                />
                <path
                    d="M90.7017 117.664L91.9292 119.622L91.485 121.848L89.66 123.135L87.7866 123.337L85.8485 121.654L85.7273 118.813L86.7529 117.672L88.8283 116.952L90.3222 117.348L90.7017 117.664Z"
                    fill="currentColor"
                />
                <path
                    d="M12.4036 111.505L13.631 113.471L13.1869 115.697L11.3538 116.976L9.48837 117.178L7.54222 115.495L7.42109 112.662L8.44666 111.513L10.522 110.792L12.024 111.189L12.4036 111.505Z"
                    fill="currentColor"
                />
                <path
                    d="M15.6821 97.5676L16.9176 99.5262L16.4735 101.752L14.6404 103.039L12.775 103.241L10.8288 101.558L10.7077 98.7168L11.7332 97.5757L13.8086 96.8553L15.3025 97.2519L15.6821 97.5676Z"
                    fill="currentColor"
                />
                <path
                    d="M30.6214 101.914L31.8489 103.872L31.4047 106.098L29.5797 107.385L27.7062 107.587L25.7681 105.904L25.647 103.063L26.6726 101.922L28.7479 101.202L30.2419 101.598L30.6214 101.914Z"
                    fill="currentColor"
                />
                <path
                    d="M80.1635 130.905L81.076 132.799L81.0276 133.932L80.3008 134.895L80.1231 135.291L79.8244 135.389L79.251 135.939L78.8553 136.182L77.2645 136.036L75.7705 135.389L74.5269 134.053L73.3318 132.702L71.9348 131.536L70.7719 130.144L69.496 128.865L68.0505 127.756L66.8715 126.364L66.0479 124.997L66.1044 123.37L66.4113 122.852L66.9119 122.107L68.5028 121.144L69.7867 121.314L71.103 122.107L72.5808 123.151L73.8486 124.446L75.1245 125.725L76.3035 127.109L77.7813 128.177L78.9684 129.545L79.9778 130.597L80.1635 130.905Z"
                    fill="currentColor"
                />
                <path
                    d="M66.3628 110.032L65.2403 108.243L65.1596 107.118L65.7814 106.082L65.9106 105.669L66.1932 105.54L66.702 104.925L67.0734 104.641L68.6723 104.601L70.2309 105.086L71.6118 106.276L72.9523 107.482L74.4704 108.478L75.7786 109.74L77.1837 110.865L78.7503 111.804L80.0666 113.059L81.0357 114.329L81.1649 115.948L80.9226 116.498L80.5027 117.291L79.033 118.433L77.7409 118.4L76.3439 117.761L74.7531 116.887L73.348 115.746L71.9348 114.613L70.6185 113.374L69.0277 112.476L67.6952 111.246L66.5728 110.315L66.3628 110.032Z"
                    fill="currentColor"
                />
                <path
                    d="M90.6049 101.979L92.7045 102.003L93.6977 102.545L94.2307 103.63L94.5134 103.961L94.4649 104.269L94.6991 105.03L94.7475 105.491L93.9077 106.859L92.6641 107.911L90.9198 108.437L89.1756 108.915L87.5201 109.651L85.7597 110.072L84.0477 110.655L82.4165 111.464L80.648 111.901L79.0572 112.031L77.6359 111.262L77.3049 110.76L76.8607 109.975L76.7073 108.122L77.426 107.045L78.718 106.22L80.3089 105.345L82.0289 104.787L83.7409 104.204L85.4932 103.759L87.1083 102.909L88.8606 102.448L90.2496 102.003L90.6049 101.979Z"
                    fill="currentColor"
                />
                <path
                    d="M50.3171 99.2429L49.3965 97.349L49.4369 96.216L50.1636 95.2528L50.3413 94.8562L50.632 94.7591L51.2053 94.2007L51.601 93.9579L53.1999 94.0954L54.6939 94.7429L55.9375 96.0703L57.1407 97.4219L58.5458 98.5712L59.7087 99.9632L60.9926 101.234L62.4462 102.335L63.6252 103.727L64.4569 105.086L64.4085 106.713L64.1097 107.239L63.601 107.976L62.0182 108.955L60.7423 108.785L59.4179 108L57.9321 106.964L56.6562 105.669L55.3722 104.399L54.1932 103.023L52.7074 101.962L51.5203 100.595L50.5028 99.5505L50.3171 99.2429Z"
                    fill="currentColor"
                />
                <path
                    d="M52.2068 129.092L50.5514 130.387L49.437 130.589L48.3468 130.079L47.9188 129.99L47.7654 129.723L47.1032 129.278L46.7802 128.938L46.5783 127.344L46.8933 125.749L47.935 124.244L48.9928 122.779L49.8246 121.168L50.939 119.736L51.9161 118.206L52.6833 116.555L53.7896 115.106L54.9524 114.014L56.5433 113.714L57.1166 113.9L57.9484 114.24L59.2243 115.592L59.3373 116.879L58.8366 118.336L58.1422 120.011L57.1489 121.532L56.1718 123.054L55.0816 124.495L54.3548 126.178L53.2728 127.627L52.4652 128.841L52.2068 129.092Z"
                    fill="currentColor"
                />
                <path
                    d="M0.93655 135.13L0.169395 133.171L0.290525 132.046L1.08998 131.14L1.29186 130.751L1.59065 130.678L2.20437 130.168L2.61622 129.958L4.19898 130.209L5.63638 130.97L6.78308 132.386L7.88132 133.827L9.18952 135.081L10.2474 136.554L11.4345 137.922L12.7992 139.136L13.8732 140.609L14.5919 142.033L14.4223 143.644L14.0832 144.146L13.526 144.85L11.8705 145.7L10.6108 145.433L9.35103 144.542L7.94592 143.401L6.775 142.017L5.58793 140.649L4.51391 139.193L3.11688 138.019L2.03479 136.562L1.09806 135.445L0.93655 135.13Z"
                    fill="currentColor"
                />
                <path
                    d="M20.3496 117.672L19.0576 116.013L18.8557 114.896L19.3644 113.803L19.4452 113.374L19.7117 113.22L20.1558 112.557L20.4869 112.233L22.0778 112.023L23.6767 112.338L25.1787 113.374L26.6403 114.443L28.2473 115.268L29.6847 116.385L31.2109 117.356L32.8583 118.125L34.3038 119.234L35.402 120.391L35.7008 121.986L35.5151 122.56L35.184 123.394L33.8354 124.681L32.5514 124.786L31.0898 124.3L29.4182 123.596L27.9081 122.609L26.3819 121.638L24.9364 120.545L23.2648 119.817L21.8113 118.732L20.6 117.931L20.3496 117.672Z"
                    fill="currentColor"
                />
                <path
                    d="M13.0899 103.047L15.1975 102.934L16.215 103.411L16.8207 104.455L17.1194 104.771L17.0952 105.086L17.3779 105.831L17.4505 106.284L16.7076 107.709L15.5286 108.834L13.8166 109.473L12.1128 110.056L10.5058 110.898L8.76957 111.432L7.10606 112.128L5.5233 113.034L3.7871 113.585L2.21242 113.811L0.742711 113.14L0.379322 112.654L-0.113272 111.901L-0.387833 110.064L0.266268 108.947L1.50987 108.032L3.0361 107.061L4.71576 106.39L6.38736 105.702L8.1074 105.151L9.66593 104.196L11.386 103.63L12.7426 103.095L13.0899 103.047Z"
                    fill="currentColor"
                />
                <path
                    d="M18.5004 116.854L20.503 117.494L21.2944 118.295L21.4963 119.485L21.6659 119.89L21.5367 120.173L21.5447 120.966L21.4478 121.419L20.2527 122.488L18.7588 123.135L16.9337 123.127L15.1249 123.078L13.3322 123.305L11.5233 123.2L9.71442 123.256L7.9217 123.556L6.10475 123.467L4.54622 123.127L3.39952 121.978L3.22994 121.395L3.03613 120.521L3.42375 118.7L4.42509 117.882L5.90287 117.461L7.67136 117.089L9.48023 117.049L11.2891 116.992L13.098 117.081L14.8826 116.725L16.6996 116.806L18.1531 116.782L18.5004 116.854Z"
                    fill="currentColor"
                />
                <path
                    d="M17.6929 133.843L19.0092 132.2L20.0428 131.755L21.2218 131.997L21.6579 131.989L21.8759 132.208L22.6189 132.491L23.0065 132.742L23.5717 134.247L23.6283 135.882L22.958 137.582L22.2636 139.249L21.8194 141.014L21.0684 142.665L20.4628 144.372L20.0913 146.153L19.3484 147.82L18.4682 149.156L16.9904 149.803L16.3847 149.755L15.5045 149.617L13.946 148.597L13.5503 147.367L13.6956 145.837L13.9944 144.041L14.6082 142.341L15.2138 140.633L15.9406 138.974L16.2636 137.177L16.9904 135.51L17.4991 134.142L17.6929 133.843Z"
                    fill="currentColor"
                />
                <path
                    d="M51.2053 134.345L51.7948 136.368L51.5687 137.477L50.6885 138.302L50.4463 138.666L50.1394 138.715L49.4853 139.16L49.0573 139.338L47.5069 138.934L46.1421 138.043L45.1327 136.522L44.1717 134.992L42.9847 133.616L42.0641 132.054L41.0143 130.581L39.7707 129.246L38.842 127.684L38.2525 126.194L38.5675 124.608L38.9551 124.139L39.5769 123.491L41.2969 122.803L42.5325 123.184L43.7034 124.179L44.9954 125.45L46.0371 126.939L47.0869 128.412L48.0156 129.966L49.3076 131.261L50.2525 132.807L51.0761 134.013L51.2053 134.345Z"
                    fill="currentColor"
                />
                <path
                    d="M93.7058 120.011L95.7166 119.388L96.8229 119.59L97.6627 120.456L98.0342 120.691L98.0826 120.998L98.5429 121.654L98.7206 122.075L98.3491 123.637L97.4851 125.021L95.9911 126.057L94.473 127.044L93.1244 128.258L91.582 129.205L90.1285 130.282L88.8203 131.552L87.2779 132.515L85.8001 133.131L84.2093 132.839L83.7409 132.459L83.0868 131.852L82.36 130.136L82.7234 128.89L83.7005 127.7L84.9441 126.381L86.4057 125.32L87.8593 124.236L89.3936 123.281L90.6614 121.97L92.1957 120.99L93.3747 120.14L93.7058 120.011Z"
                    fill="currentColor"
                />
                <path
                    d="M83.2483 98.1746L85.2348 98.8544L86.01 99.68L86.1796 100.878L86.3411 101.282L86.2039 101.558L86.1958 102.359L86.0908 102.804L84.8714 103.848L83.3613 104.463L81.5444 104.415L79.7355 104.326L77.9347 104.512L76.1259 104.366L74.3251 104.382L72.5243 104.641L70.7073 104.512L69.1569 104.14L68.0344 102.966L67.881 102.383L67.7033 101.501L68.1313 99.6881L69.1488 98.8949L70.6346 98.5064L72.4193 98.1746H74.2282L76.037 98.1584L77.8378 98.2798L79.6386 97.9722L81.4394 98.0856L82.901 98.0936L83.2483 98.1746Z"
                    fill="currentColor"
                />
                <path
                    d="M52.8931 112.095L53.9752 113.908L54.0398 115.033L53.3938 116.061L53.2565 116.474L52.9738 116.595L52.4489 117.194L52.0775 117.47L50.4786 117.478L48.9281 116.968L47.5715 115.754L46.2552 114.515L44.7612 113.488L43.4773 112.201L42.0883 111.043L40.5459 110.072L39.2458 108.793L38.3091 107.506L38.2122 105.888L38.4625 105.337L38.8986 104.552L40.3925 103.452L41.6846 103.5L43.0735 104.172L44.6401 105.078L46.021 106.244L47.4099 107.409L48.7101 108.672L50.2767 109.595L51.5849 110.857L52.6831 111.812L52.8931 112.095Z"
                    fill="currentColor"
                />
                <path
                    d="M51.2135 105.524L50.7048 107.563L49.9538 108.405L48.7748 108.68L48.3872 108.874L48.0964 108.761L47.3051 108.818L46.8448 108.745L45.7062 107.62L44.9713 106.163L44.8744 104.342L44.8098 102.529L44.4787 100.748L44.4706 98.9273L44.301 97.1224L43.8973 95.3499L43.8811 93.5208L44.1153 91.9426L45.1974 90.7285L45.7627 90.5262L46.6187 90.2753L48.4598 90.5505L49.332 91.4974L49.8407 92.9543L50.3172 94.7105L50.4706 96.5154L50.6321 98.3203L50.6644 100.125L51.1166 101.898L51.157 103.711L51.27 105.167L51.2135 105.524Z"
                    fill="currentColor"
                />
                <path
                    d="M67.7033 144.332L66.492 146.056L65.4826 146.566L64.2874 146.396L63.8594 146.436L63.6333 146.226L62.8662 145.991L62.4624 145.756L61.8083 144.291L61.6549 142.673L62.2121 140.933L62.8096 139.225L63.1407 137.436L63.7868 135.745L64.2793 134.005L64.5458 132.2L65.1838 130.484L65.9752 129.1L67.4206 128.355L68.0182 128.372L68.9146 128.452L70.5296 129.375L70.998 130.573L70.9496 132.119L70.7638 133.924L70.2551 135.664L69.7544 137.404L69.1326 139.104L68.9227 140.916L68.3008 142.624L67.8809 144.024L67.7033 144.332Z"
                    fill="currentColor"
                />
                <path
                    d="M182.97 98.9354L182.373 100.643L181.864 102.432L181.525 104.269L180.952 106.05L179.918 108.324L179.441 110.776L178.602 113.204L176.817 112.492L175.016 112.079L173.127 111.488L173.668 109.578L174.572 107.927L175.032 106.122L175.646 104.366L176.478 101.711L177.197 99.0163L177.592 97.3409L177.956 97.1386L179.498 97.7861L181.226 98.4498L182.97 98.9354Z"
                    fill="currentColor"
                />
                <path
                    d="M137.862 94.0469L138.75 95.6251L139.759 97.1953L140.906 98.6602L141.851 100.271L142.876 102.545L144.403 104.528L145.654 106.762L143.95 107.636L142.44 108.72L140.761 109.748L139.687 108.073L139.049 106.3L137.999 104.763L137.094 103.144L135.649 100.765L134.107 98.4417L133.121 97.0334L133.21 96.6287L134.712 95.9003L136.352 95.0343L137.862 94.0469Z"
                    fill="currentColor"
                />
                <path
                    d="M134.656 96.1188L132.847 96.0703L130.998 96.135L129.148 96.3697L127.283 96.3616L124.804 96.0784L122.325 96.3697L119.765 96.305L119.902 94.3868L119.741 92.5415L119.724 90.5586L121.711 90.4938L123.552 90.8499L125.409 90.7366L127.259 90.7933L130.045 90.769L132.823 90.6314L134.526 90.51L134.833 90.7933L134.688 92.4606L134.591 94.314L134.656 96.1188Z"
                    fill="currentColor"
                />
                <path
                    d="M112.174 106.454L112.223 108.267L112.384 110.121L112.715 111.958L112.812 113.819L112.659 116.32L113.087 118.781L113.159 121.346L111.237 121.314L109.404 121.573L107.434 121.694L107.264 119.72L107.523 117.85L107.313 115.997L107.256 114.143L107.095 111.359L106.804 108.591L106.586 106.883L106.852 106.568L108.524 106.616H110.373L112.174 106.454Z"
                    fill="currentColor"
                />
                <path
                    d="M122.139 104.253L122.478 106.033L122.93 107.838L123.544 109.603L123.932 111.424L124.174 113.916L124.981 116.28L125.45 118.805L123.552 119.08L121.784 119.622L119.862 120.051L119.377 118.125L119.337 116.239L118.836 114.443L118.497 112.622L117.891 109.902L117.181 107.207L116.688 105.556L116.906 105.2L118.562 104.989L120.395 104.698L122.139 104.253Z"
                    fill="currentColor"
                />
                <path
                    d="M103.348 116.417L102.096 115.114L100.731 113.852L99.2536 112.719L97.9292 111.407L96.3626 109.457L94.3922 107.927L92.6157 106.074L94.0531 104.803L95.2321 103.379L96.6049 101.954L98.0665 103.298L99.1324 104.86L100.529 106.082L101.813 107.417L103.808 109.36L105.883 111.221L107.192 112.33L107.208 112.743L105.94 113.836L104.567 115.082L103.348 116.417Z"
                    fill="currentColor"
                />
                <path
                    d="M162.596 99.939L160.884 99.3401L159.1 98.8302L157.275 98.4902L155.498 97.9075L153.229 96.8796L150.774 96.4021L148.359 95.5604L149.07 93.7717L149.482 91.9587L150.071 90.073L151.977 90.6152L153.625 91.5217L155.425 91.983L157.178 92.5981L159.826 93.4237L162.515 94.144L164.187 94.5487L164.389 94.9129L163.743 96.4588L163.081 98.1908L162.596 99.939Z"
                    fill="currentColor"
                />
                <path
                    d="M183.495 131.067L182.591 129.488L181.581 127.934L180.418 126.47L179.458 124.875L178.416 122.601L176.881 120.634L175.606 118.408L177.309 117.518L178.803 116.425L180.483 115.39L181.573 117.049L182.219 118.821L183.277 120.351L184.198 121.961L185.659 124.333L187.218 126.64L188.219 128.04L188.13 128.444L186.628 129.189L185.005 130.071L183.495 131.067Z"
                    fill="currentColor"
                />
                <path
                    d="M186.37 125.709L186.968 123.993L187.476 122.204L187.816 120.375L188.389 118.595L189.423 116.32L189.891 113.86L190.739 111.44L192.523 112.152L194.324 112.565L196.206 113.156L195.673 115.066L194.768 116.717L194.308 118.522L193.694 120.278L192.863 122.933L192.144 125.628L191.748 127.303L191.385 127.497L189.842 126.858L188.114 126.194L186.37 125.709Z"
                    fill="currentColor"
                />
                <path
                    d="M122.066 88.4866L120.936 89.903L119.862 91.4246L118.933 93.0433L117.803 94.5244L116.074 96.3293L114.815 98.4902L113.216 100.489L111.762 99.2267L110.204 98.2312L108.621 97.0496L109.768 95.4309L111.165 94.1683L112.198 92.6224L113.361 91.1737L115.025 88.9399L116.591 86.6413L117.528 85.2007L117.932 85.1278L119.175 86.2528L120.588 87.4507L122.066 88.4866Z"
                    fill="currentColor"
                />
                <path
                    d="M135.374 109.53L134.494 111.116L133.687 112.791L133.024 114.532L132.152 116.183L130.747 118.247L129.851 120.586L128.599 122.819L126.968 121.816L125.264 121.087L123.512 120.181L124.376 118.392L125.547 116.927L126.314 115.228L127.226 113.609L128.502 111.132L129.673 108.607L130.36 107.029L130.747 106.891L132.16 107.798L133.743 108.753L135.374 109.53Z"
                    fill="currentColor"
                />
                <path
                    d="M168.289 102.14L166.731 103.071L165.197 104.107L163.751 105.297L162.176 106.284L159.923 107.361L157.977 108.931L155.781 110.242L154.868 108.542L153.754 107.061L152.696 105.394L154.335 104.285L156.088 103.605L157.598 102.521L159.197 101.574L161.538 100.077L163.824 98.4821L165.197 97.4543L165.608 97.5352L166.376 99.0244L167.272 100.651L168.289 102.14Z"
                    fill="currentColor"
                />
                <path
                    d="M148.658 133.511L147.019 134.288L145.396 135.194L143.854 136.238L142.19 137.08L139.856 137.954L137.781 139.346L135.471 140.447L134.72 138.675L133.743 137.104L132.831 135.348L134.567 134.385L136.376 133.867L137.975 132.92L139.654 132.127L142.117 130.84L144.532 129.456L146.002 128.566L146.397 128.679L147.027 130.233L147.778 131.933L148.658 133.511Z"
                    fill="currentColor"
                />
                <path
                    d="M135.899 132.443L135.835 130.63L135.665 128.776L135.326 126.947L135.221 125.077L135.366 122.585L134.922 120.124L134.842 117.559L136.763 117.575L138.597 117.308L140.559 117.178L140.745 119.161L140.494 121.023L140.712 122.876L140.777 124.729L140.955 127.514L141.253 130.282L141.479 131.989L141.213 132.305L139.541 132.265L137.692 132.273L135.899 132.443Z"
                    fill="currentColor"
                />
                <path
                    d="M154.489 137.363L153.277 136.012L151.961 134.709L150.524 133.519L149.248 132.159L147.754 130.16L145.832 128.558L144.128 126.648L145.606 125.425L146.841 124.041L148.263 122.674L149.676 124.066L150.685 125.66L152.034 126.931L153.277 128.315L155.199 130.33L157.202 132.256L158.47 133.414V133.835L157.162 134.879L155.757 136.077L154.489 137.363Z"
                    fill="currentColor"
                />
                <path
                    d="M180.855 96.6044L182.365 95.6008L183.842 94.4839L185.223 93.2294L186.75 92.1611L188.946 90.9713L190.803 89.3041L192.935 87.8796L193.928 89.5307L195.116 90.9471L196.262 92.5577L194.679 93.7555L192.959 94.5244L191.506 95.6818L189.963 96.7097L187.702 98.3284L185.506 100.036L184.182 101.129L183.77 101.072L182.93 99.6233L181.945 98.0532L180.855 96.6044Z"
                    fill="currentColor"
                />
                <path
                    d="M166.658 133.527L166.674 131.706L166.577 129.853L166.311 128.007L166.287 126.138L166.529 123.653L166.19 121.168L166.206 118.603L168.128 118.7L169.969 118.514L171.939 118.465L172.044 120.448L171.713 122.301L171.867 124.155L171.843 126.016L171.915 128.8L172.101 131.585L172.262 133.292L171.98 133.6L170.316 133.487L168.467 133.422L166.658 133.527Z"
                    fill="currentColor"
                />
                <path
                    d="M154.359 124.268L153.843 122.528L153.205 120.78L152.413 119.096L151.84 117.316L151.339 114.872L150.29 112.597L149.555 110.137L151.42 109.667L153.124 108.947L154.989 108.316L155.668 110.177L155.902 112.055L156.588 113.787L157.113 115.568L158.001 118.206L158.995 120.812L159.649 122.399L159.471 122.779L157.84 123.159L156.055 123.637L154.359 124.268Z"
                    fill="currentColor"
                />
                <path
                    d="M171.035 102.505L173.345 102.618L174.903 104.261V106.495L173.999 108.146L171.511 108.777L169.121 107.247L168.774 105.75L169.371 103.63L170.559 102.626L171.035 102.505Z"
                    fill="currentColor"
                />
                <path
                    d="M178.117 122.18L178.464 124.47L177.172 126.332L174.984 126.777L173.191 126.219L172.077 123.904L173.094 121.249L174.491 120.61L176.68 120.78L177.899 121.743L178.117 122.18Z"
                    fill="currentColor"
                />
                <path
                    d="M188.211 116.952L188.558 119.234L187.266 121.104L185.078 121.549L183.285 120.982L182.171 118.667L183.188 116.013L184.585 115.373L186.774 115.543L187.985 116.506L188.211 116.952Z"
                    fill="currentColor"
                />
                <path
                    d="M193.137 129.213L193.492 131.504L192.192 133.365L190.012 133.818L188.211 133.252L187.097 130.937L188.114 128.282L189.511 127.643L191.708 127.813L192.919 128.776L193.137 129.213Z"
                    fill="currentColor"
                />
                <path
                    d="M152.341 140.131L150.104 140.706L148.125 139.605L147.463 137.469L147.843 135.623L150.031 134.28L152.761 135.024L153.536 136.352L153.592 138.553L152.761 139.864L152.341 140.131Z"
                    fill="currentColor"
                />
                <path
                    d="M154.174 123.782L156.483 123.896L158.05 125.539V127.773L157.137 129.424L154.65 130.055L152.26 128.525L151.913 127.028L152.51 124.907L153.697 123.904L154.174 123.782Z"
                    fill="currentColor"
                />
                <path
                    d="M150.831 117.664L152.591 119.169L152.825 121.427L151.46 123.2L149.732 123.944L147.382 122.925L146.421 120.246L147.067 118.854L148.828 117.542L150.378 117.478L150.831 117.664Z"
                    fill="currentColor"
                />
                <path
                    d="M135.52 101.59L137.28 103.087L137.514 105.345L136.15 107.118L134.421 107.871L132.072 106.843L131.111 104.172L131.749 102.772L133.517 101.461L135.068 101.396L135.52 101.59Z"
                    fill="currentColor"
                />
                <path
                    d="M131.942 96.216L133.695 97.7213L133.937 99.9794L132.572 101.752L130.844 102.505L128.486 101.477L127.533 98.8059L128.171 97.4057L129.94 96.0945L131.482 96.0298L131.942 96.216Z"
                    fill="currentColor"
                />
                <path
                    d="M162.12 108.202L163.355 110.161L162.911 112.387L161.078 113.674L159.213 113.876L157.267 112.193L157.145 109.352L158.171 108.211L160.246 107.49L161.748 107.887L162.12 108.202Z"
                    fill="currentColor"
                />
                <path
                    d="M146.922 85.314L148.158 87.2726L147.714 89.4983L145.88 90.7852L144.015 90.9875L142.069 89.3041L141.948 86.4633L142.973 85.3221L145.049 84.6017L146.551 84.9983L146.922 85.314Z"
                    fill="currentColor"
                />
                <path
                    d="M123.835 120.189L125.062 122.148L124.618 124.373L122.793 125.652L120.92 125.854L118.982 124.179L118.86 121.338L119.886 120.197L121.961 119.469L123.455 119.865L123.835 120.189Z"
                    fill="currentColor"
                />
                <path
                    d="M123.835 132.564L125.062 134.523L124.618 136.748L122.793 138.035L120.92 138.238L118.982 136.554L118.86 133.713L119.886 132.572L121.961 131.852L123.455 132.248L123.835 132.564Z"
                    fill="currentColor"
                />
                <path
                    d="M117.431 109.91L118.658 111.869L118.214 114.095L116.389 115.381L114.516 115.584L112.578 113.9L112.457 111.059L113.482 109.918L115.558 109.198L117.051 109.595L117.431 109.91Z"
                    fill="currentColor"
                />
                <path
                    d="M103.364 126.089L104.591 128.048L104.147 130.274L102.322 131.56L100.449 131.755L98.5107 130.079L98.3815 127.238L99.4151 126.097L101.482 125.369L102.984 125.774L103.364 126.089Z"
                    fill="currentColor"
                />
                <path
                    d="M175.808 133.122L177.043 135.081L176.599 137.307L174.766 138.594L172.9 138.796L170.954 137.113L170.833 134.28L171.859 133.131L173.934 132.41L175.436 132.807L175.808 133.122Z"
                    fill="currentColor"
                />
                <path
                    d="M186.766 101.153L187.993 103.112L187.549 105.337L185.716 106.624L183.85 106.827L181.904 105.143L181.783 102.302L182.809 101.161L184.884 100.441L186.386 100.837L186.766 101.153Z"
                    fill="currentColor"
                />
                <path
                    d="M162.297 85.2088L163.533 87.1674L163.089 89.3931L161.256 90.6719L159.39 90.8742L157.444 89.1989L157.323 86.358L158.349 85.2168L160.424 84.4884L161.926 84.885L162.297 85.2088Z"
                    fill="currentColor"
                />
                <path
                    d="M108.573 95.2124L109.8 97.171L109.356 99.3967L107.523 100.684L105.657 100.886L103.711 99.2025L103.59 96.3616L104.616 95.2204L106.691 94.5001L108.193 94.8967L108.573 95.2124Z"
                    fill="currentColor"
                />
                <path
                    d="M126.039 84.6503L127.267 86.6089L126.823 88.8347L124.998 90.1215L123.124 90.3239L121.186 88.6404L121.065 85.7996L122.09 84.6584L124.166 83.9381L125.66 84.3347L126.039 84.6503Z"
                    fill="currentColor"
                />
                <path
                    d="M176.219 114.394L177.132 116.288L177.091 117.421L176.357 118.384L176.187 118.781L175.888 118.878L175.315 119.428L174.919 119.671L173.32 119.525L171.834 118.878L170.591 117.542L169.388 116.191L167.991 115.025L166.836 113.633L165.56 112.354L164.114 111.246L162.935 109.854L162.112 108.486L162.168 106.859L162.467 106.341L162.976 105.596L164.567 104.633L165.843 104.803L167.159 105.596L168.645 106.64L169.913 107.935L171.188 109.214L172.359 110.598L173.845 111.666L175.032 113.034L176.042 114.086L176.219 114.394Z"
                    fill="currentColor"
                />
                <path
                    d="M162.419 94.492L161.304 92.7034L161.223 91.5703L161.845 90.5424L161.974 90.1215L162.257 89.992L162.766 89.385L163.129 89.1017L164.736 89.0613L166.287 89.5388L167.668 90.7285L169.016 91.9426L170.526 92.9381L171.834 94.1926L173.248 95.3257L174.806 96.2645L176.131 97.519L177.1 98.7897L177.229 100.408L176.978 100.959L176.559 101.752L175.089 102.885L173.797 102.861L172.4 102.213L170.809 101.347L169.412 100.198L167.999 99.073L166.674 97.8347L165.092 96.9363L163.759 95.698L162.637 94.7753L162.419 94.492Z"
                    fill="currentColor"
                />
                <path
                    d="M185.587 85.8967L187.694 85.921L188.688 86.4633L189.221 87.5478L189.495 87.8796L189.455 88.1872L189.689 88.948L189.729 89.4093L188.898 90.7852L187.654 91.8373L185.91 92.3553L184.165 92.8329L182.51 93.5694L180.741 93.9983L179.038 94.573L177.406 95.3823L175.638 95.8194L174.047 95.9489L172.618 95.18L172.287 94.6782L171.851 93.8931L171.689 92.0397L172.416 90.9713L173.708 90.1377L175.299 89.2636L177.019 88.7052L178.731 88.1224L180.483 87.6773L182.098 86.8275L183.85 86.3661L185.231 85.9291L185.587 85.8967Z"
                    fill="currentColor"
                />
                <path
                    d="M131.975 145.101L131.208 147.068L130.36 147.804L129.156 147.925L128.753 148.071L128.478 147.925L127.679 147.877L127.234 147.756L126.249 146.493L125.7 144.955L125.829 143.134L125.991 141.329L125.878 139.516L126.104 137.711L126.16 135.907L125.983 134.094L126.193 132.281L126.621 130.743L127.84 129.675L128.43 129.537L129.318 129.399L131.103 129.901L131.854 130.953L132.177 132.459L132.435 134.256L132.354 136.068L132.298 137.881L132.096 139.678L132.33 141.491L132.144 143.304L132.072 144.761L131.975 145.101Z"
                    fill="currentColor"
                />
                <path
                    d="M103.945 135.907L102.419 134.458L102.056 133.39L102.395 132.232L102.419 131.795L102.661 131.601L103.001 130.881L103.283 130.508L104.826 130.071L106.449 130.144L108.088 130.945L109.687 131.779L111.407 132.362L112.99 133.244L114.637 133.98L116.381 134.498L117.98 135.381L119.232 136.36L119.765 137.898L119.668 138.488L119.458 139.363L118.319 140.836L117.068 141.135L115.55 140.868L113.797 140.423L112.15 139.67L110.494 138.934L108.912 138.068L107.143 137.598L105.552 136.74L104.228 136.125L103.945 135.907Z"
                    fill="currentColor"
                />
                <path
                    d="M148.271 112.581L146.607 113.876L145.501 114.078L144.411 113.56L143.983 113.479L143.821 113.212L143.167 112.759L142.844 112.427L142.642 110.833L142.957 109.238L143.991 107.733L145.057 106.268L145.888 104.657L147.003 103.225L147.972 101.695L148.747 100.044L149.853 98.5954L151.008 97.5028L152.607 97.2034L153.181 97.3895L154.004 97.7294L155.288 99.073L155.393 100.368L154.901 101.825L154.198 103.5L153.213 105.022L152.236 106.543L151.146 107.984L150.419 109.667L149.337 111.116L148.529 112.33L148.271 112.581Z"
                    fill="currentColor"
                />
                <path
                    d="M97.0005 118.619L96.2253 116.66L96.3545 115.535L97.1458 114.629L97.3558 114.24L97.6546 114.167L98.2683 113.657L98.6802 113.447L100.263 113.698L101.7 114.459L102.847 115.875L103.945 117.316L105.253 118.57L106.311 120.043L107.498 121.411L108.855 122.625L109.929 124.098L110.656 125.523L110.486 127.133L110.147 127.635L109.59 128.339L107.934 129.189L106.667 128.922L105.407 128.032L104.002 126.89L102.831 125.506L101.652 124.139L100.578 122.682L99.1808 121.508L98.0907 120.051L97.162 118.934L97.0005 118.619Z"
                    fill="currentColor"
                />
                <path
                    d="M116.414 101.161L115.113 99.5019L114.912 98.385L115.42 97.2924L115.509 96.8634L115.776 96.7097L116.22 96.046L116.551 95.7222L118.142 95.5118L119.741 95.8275L121.235 96.8634L122.704 97.9237L124.311 98.7573L125.749 99.8742L127.267 100.845L128.922 101.614L130.368 102.715L131.466 103.881L131.757 105.475L131.579 106.05L131.24 106.883L129.899 108.17L128.607 108.275L127.154 107.782L125.482 107.086L123.964 106.098L122.446 105.119L121 104.034L119.321 103.306L117.875 102.221L116.656 101.42L116.414 101.161Z"
                    fill="currentColor"
                />
                <path
                    d="M110.099 85.4192L112.166 85.0226L113.248 85.3544L113.983 86.3014L114.322 86.5766L114.338 86.8841L114.726 87.5882L114.855 88.0334L114.314 89.5388L113.305 90.8176L111.698 91.6836L110.091 92.501L108.613 93.5532L106.974 94.3221L105.407 95.2366L103.97 96.3535L102.33 97.1386L100.796 97.5837L99.2455 97.1143L98.8175 96.6854L98.236 96.0136L97.7111 94.2249L98.2037 93.0271L99.302 91.9507L100.691 90.7852L102.258 89.8868L103.824 88.9722L105.455 88.1872L106.86 87.0298L108.492 86.2285L109.76 85.5163L110.099 85.4192Z"
                    fill="currentColor"
                />
                <path
                    d="M114.556 100.344L116.567 100.983L117.358 101.784L117.56 102.974L117.73 103.379L117.593 103.662L117.601 104.455L117.512 104.908L116.309 105.977L114.815 106.624L112.998 106.616L111.189 106.568L109.396 106.794L107.579 106.689L105.778 106.746L103.986 107.045L102.161 106.948L100.602 106.616L99.4634 105.467L99.2938 104.884L99.1 104.01L99.4796 102.189L100.481 101.372L101.967 100.951L103.735 100.578L105.544 100.538L107.353 100.481L109.154 100.57L110.947 100.214L112.755 100.295L114.209 100.271L114.556 100.344Z"
                    fill="currentColor"
                />
                <path
                    d="M113.757 117.332L115.073 115.689L116.107 115.244L117.286 115.487L117.722 115.479L117.932 115.697L118.683 115.98L119.07 116.231L119.628 117.737L119.684 119.372L119.022 121.071L118.319 122.738L117.883 124.495L117.124 126.154L116.527 127.854L116.155 129.642L115.412 131.309L114.532 132.645L113.046 133.292L112.449 133.244L111.56 133.106L110.01 132.086L109.606 130.856L109.751 129.318L110.05 127.53L110.672 125.83L111.27 124.122L112.005 122.463L112.328 120.666L113.054 118.999L113.555 117.631L113.757 117.332Z"
                    fill="currentColor"
                />
                <path
                    d="M123.383 132.24L121.307 132.604L120.233 132.256L119.506 131.293L119.175 131.018L119.159 130.711L118.788 130.006L118.659 129.561L119.224 128.056L120.257 126.793L121.873 125.952L123.496 125.158L124.99 124.122L126.637 123.386L128.212 122.496L129.665 121.395L131.321 120.634L132.863 120.213L134.405 120.699L134.825 121.136L135.399 121.824L135.899 123.621L135.391 124.81L134.268 125.863L132.871 127.012L131.28 127.886L129.706 128.776L128.066 129.537L126.645 130.678L125.006 131.455L123.722 132.143L123.383 132.24Z"
                    fill="currentColor"
                />
                <path
                    d="M147.269 117.834L147.851 119.857L147.625 120.966L146.753 121.791L146.51 122.156L146.203 122.196L145.549 122.649L145.121 122.819L143.563 122.423L142.198 121.532L141.197 120.011L140.228 118.481L139.049 117.105L138.128 115.543L137.078 114.07L135.835 112.735L134.898 111.173L134.317 109.684L134.632 108.097L135.019 107.628L135.633 106.98L137.361 106.292L138.597 106.665L139.767 107.668L141.059 108.939L142.093 110.428L143.143 111.901L144.08 113.447L145.364 114.75L146.308 116.296L147.14 117.502L147.269 117.834Z"
                    fill="currentColor"
                />
                <path
                    d="M172.4 138.221L173.482 140.034L173.538 141.167L172.9 142.187L172.763 142.6L172.472 142.721L171.956 143.32L171.584 143.604H169.977L168.435 143.094L167.078 141.88L165.754 140.641L164.26 139.613L162.976 138.327L161.587 137.177L160.053 136.206L158.752 134.927L157.808 133.632L157.711 132.014L157.969 131.471L158.405 130.686L159.899 129.577L161.191 129.626L162.572 130.298L164.147 131.204L165.528 132.378L166.917 133.535L168.209 134.798L169.783 135.729L171.083 136.983L172.19 137.938L172.4 138.221Z"
                    fill="currentColor"
                />
                <path
                    d="M173.563 132.24L172.133 130.694L171.843 129.602L172.254 128.469L172.311 128.032L172.561 127.854L172.949 127.157L173.256 126.809L174.822 126.478L176.437 126.656L178.02 127.57L179.563 128.509L181.234 129.205L182.752 130.201L184.351 131.042L186.063 131.674L187.589 132.661L188.776 133.729L189.204 135.291L189.067 135.882L188.801 136.74L187.565 138.132L186.297 138.343L184.803 137.97L183.075 137.412L181.484 136.546L179.894 135.704L178.359 134.733L176.631 134.15L175.097 133.187L173.821 132.483L173.563 132.24Z"
                    fill="currentColor"
                />
                <path
                    d="M189.77 103.5L191.772 102.877L192.887 103.079L193.727 103.945L194.09 104.18L194.147 104.488L194.607 105.135L194.785 105.564L194.413 107.126L193.549 108.51L192.047 109.546L190.537 110.533L189.188 111.747L187.638 112.694L186.192 113.771L184.884 115.041L183.334 116.005L181.864 116.62L180.273 116.328L179.805 115.948L179.143 115.341L178.424 113.625L178.779 112.379L179.756 111.189L181.008 109.87L182.47 108.809L183.923 107.725L185.458 106.77L186.725 105.459L188.252 104.479L189.439 103.63L189.77 103.5Z"
                    fill="currentColor"
                />
                <path
                    d="M148.957 95.5847L150.039 97.3895L150.096 98.5226L149.458 99.5424L149.321 99.9632L149.038 100.085L148.513 100.684L148.142 100.959L146.535 100.967L144.992 100.457L143.636 99.2348L142.319 97.9965L140.825 96.9767L139.541 95.6899L138.152 94.5325L136.61 93.5613L135.31 92.2825L134.365 90.9956L134.276 89.3769L134.527 88.8266L134.963 88.0415L136.457 86.9408L137.749 86.9893L139.129 87.6611L140.704 88.5595L142.085 89.733L143.474 90.8904L144.766 92.1611L146.341 93.0838L147.641 94.3463L148.747 95.3014L148.957 95.5847Z"
                    fill="currentColor"
                />
                <path
                    d="M163.759 127.821L162.548 129.545L161.547 130.055L160.351 129.885L159.915 129.925L159.689 129.715L158.93 129.472L158.526 129.246L157.872 127.781L157.711 126.162L158.276 124.422L158.866 122.714L159.197 120.925L159.851 119.234L160.343 117.486L160.602 115.681L161.248 113.973L162.039 112.589L163.476 111.845L164.082 111.861L164.97 111.942L166.585 112.864L167.062 114.062L167.013 115.608L166.828 117.413L166.311 119.153L165.818 120.893L165.188 122.593L164.979 124.406L164.357 126.113L163.937 127.514L163.759 127.821Z"
                    fill="currentColor"
                />
            </g>
            <defs>
                <clipPath id="clip0_11493_270764">
                    <rect width="193" height="135" fill="white" />
                </clipPath>
            </defs>
        </svg>
    );
}
PatternDigitalAssets.displayName = 'FonduePatternDigitalAssets';

const Memo = memo(PatternDigitalAssets);

export default Memo;
