# Fondue Design System by Frontify

<a href="https://github.com/Frontify/fondue/actions/workflows/continuous-integration.yml">
    <img src="https://github.com/Frontify/react-components/actions/workflows/continuous-integration.yml/badge.svg" alt="CI Status" />
</a>
<a href="https://snyk.io/test/github/Frontify/fondue">
    <img src="https://snyk.io/test/github/Frontify/fondue/badge.svg" alt="Known Vulnerabilities" />
</a>
<a href="https://github.com/Frontify/fondue/blob/main/README.md" title="latest">
    <img alt="latest" src="https://img.shields.io/npm/v/@frontify/fondue/latest.svg" />
</a>

## Using `@frontify/fondue`

1. Install fondue from npm

```shell
npm install @frontify/fondue
```

2. Load Fondue Stylesheet

```typescript
import '@frontify/fondue/style';
```

3. Use Components

```typescript
import { Button } from '@frontify/fondue';
```

Fondue provides two builds: ES modules and UMD modules. Documentation for the provided components and how to use them is available in [Storybook](https://fondue-components.frontify.com/).

## Contributing

See [Contribution Guidelines](CONTRIBUTING.md) for contributing and local development help.

## Important Links

-   [Storybook](https://storybook.js.org/docs/react/get-started/introduction) – Used for isolated development and documentation of Fondue components
-   [https://www.cypress.io/](Cypress) – Used for Testing in Fondue
-   [Frontify React Guidelines](https://www.notion.so/React-Architecture-0ce55540be0b48fa88a2c3848e35eb81) – Internal Coding Guidelines for Frontify
-   [Fondue Tokens](https://github.com/Frontify/fondue-tokens) – Design Tokens used at Frontify
-   [Tailwind](https://tailwindcss.com/docs) – Utility-first CSS framework used in Fondue
