# KotlinFirechat
This project is a basic chat application using Flux Architecture together with [Rx Java 2.0](https://github.com/ReactiveX/RxJava/tree/2.x) and [Dagger2](https://google.github.io/dagger/).

## Firebase Android Series
The repository works as a sample for Firebase Android Series. A series of articles published on medium that shows how to build an Android application with Kotlin and Firebase from scratch. Each chapter of the series comes together with a branch of this repository:
* [Introduction](https://proandroiddev.com/firebase-android-series-learning-firebase-from-zero-to-hero-3bacbdf8e048) 
* [Firebase Authentication](https://proandroiddev.com/firebase-android-series-authentication-74f209c59738) -> [Sample](https://github.com/FrangSierra/KotlinFirechat/tree/01-Auth)
* [Firebase Firestore](https://proandroiddev.com/firebase-android-series-firestore-17e8951c574e) -> [Sample](https://github.com/FrangSierra/KotlinFirechat/tree/02-Database)
* [Crashlytics](https://proandroiddev.com/firebase-android-series-crashlytics-29de3f507d6) -> [Sample](https://github.com/FrangSierra/KotlinFirechat/tree/03-Crashlytics)
* **Firebase Test Lab** -> Coming soon
* **Firebase Storage** -> Coming soon
* **Firebase Cloud Functions** -> Coming soon
* **Firebase Cloud Messaging** -> Coming soon
* **Firebase Dynamic Links** -> Coming soon
* **Firebase Performance** -> Coming soon
* **Firebase Analytics** -> Coming soon


## Flux Architecure
Flux is an Architecture which works pretty well with Firebase(It does aswell with Redux), it allows you to keep all the data in cache in a really easy mode, together with data persistence of Firebase it becomes a really strongh way of develop applications.

![alt tag](https://raw.githubusercontent.com/lgvalle/lgvalle.github.io/master/public/images/flux-graph-complete.png)
Graph by [Luis G. Valle](http://lgvalle.xyz/)

## Further Reading:
* [Facebook Flux Overview](https://facebook.github.io/flux/docs/overview.html)
* [Flux & Android](http://armueller.github.io/android/2015/03/29/flux-and-android.html)
* [Testing Flux Applications](https://facebook.github.io/flux/docs/testing-flux-applications.html#content)
* [Flux Step by Step](http://blogs.atlassian.com/2014/08/flux-architecture-step-by-step/)
* [What's different in Rx 2.0](https://github.com/ReactiveX/RxJava/wiki/What's-different-in-2.0)
* [Dependency Injection with Dagger 2](https://guides.codepath.com/android/Dependency-Injection-with-Dagger-2)
