# Mailspring SDK

- Mailspring SDK Guides
- [Introduction](/README.md)
- [Getting Started](/guides/GettingStarted.md)
- [Getting Started Part 2](/guides/GettingStarted-2.md)
- [Building a Package](/guides/PackageOverview.md)
- [Interface Concepts](/guides/InterfaceConcepts.md)
- [UI Components](/guides/React.md)
- [Application Architecture](/guides/Architecture.md)
- [Debugging Mailspring](/guides/Debugging.md)
- [Accessing the Database](/guides/Database.md)
- [Extending the Composer](/guides/ComposerExtensions.md)
- [Writing Tests](/guides/WritingSpecs.md)
- [Integration Testing](/guides/IntegrationTesting.md)
- [Developing on Windows](/guides/Windows.md)
- [FAQ](/guides/FAQ.md)

---

### Full Class Reference

- General

  - [Actions](/classes/Actions.md)
  - [BufferedProcess](/classes/BufferedProcess.md)
  - [ChangeFolderTask](/classes/ChangeFolderTask.md)
  - [ChangeLabelsTask](/classes/ChangeLabelsTask.md)
  - [ChangeMailTask](/classes/ChangeMailTask.md)
  - [Color](/classes/Color.md)
  - [Config](/classes/Config.md)
  - [Contenteditable](/classes/Contenteditable.md)
  - [KeyCommandsRegion](/classes/KeyCommandsRegion.md)
  - [AppEnvConstructor](/classes/AppEnvConstructor.md)
  - [QueryResultSet](/classes/QueryResultSet.md)
  - [QuerySubscriptionPool](/classes/QuerySubscriptionPool.md)
  - [StyleManager](/classes/StyleManager.md)
  - [Task](/classes/Task.md)
  - [TaskQueueStatusStore](/classes/TaskQueueStatusStore.md)
  - [ThemeManager](/classes/ThemeManager.md)

- Component Kit

  - [EventedIFrame](/classes/EventedIFrame.md)
  - [Flexbox](/classes/Flexbox.md)
  - [InjectedComponent](/classes/InjectedComponent.md)
  - [InjectedComponentSet](/classes/InjectedComponentSet.md)
  - [Menu](/classes/Menu.md)
  - [MenuItem](/classes/MenuItem.md)
  - [MenuNameEmailContent](/classes/MenuNameEmailContent.md)
  - [MultiselectActionBar](/classes/MultiselectActionBar.md)
  - [MultiselectList](/classes/MultiselectList.md)
  - [ResizableRegion](/classes/ResizableRegion.md)
  - [RetinaImg](/classes/RetinaImg.md)
  - [Spinner](/classes/Spinner.md)

- Extensions

  - [ComposerExtension](/classes/ComposerExtension.md)
  - [ContenteditableExtension](/classes/ContenteditableExtension.md)
  - [DraftStoreExtension](/classes/DraftStoreExtension.md)
  - [MessageStoreExtension](/classes/MessageStoreExtension.md)
  - [MessageViewExtension](/classes/MessageViewExtension.md)

- Models

  - [Contact](/classes/Contact.md)
  - [Message](/classes/Message.md)
  - [Model](/classes/Model.md)
  - [Thread](/classes/Thread.md)

- Stores

  - [AccountStore](/classes/AccountStore.md)
  - [ComponentRegistry](/classes/ComponentRegistry.md)
  - [ContactStore](/classes/ContactStore.md)
  - [FocusedContentStore](/classes/FocusedContentStore.md)
  - [TaskQueue](/classes/TaskQueue.md)
  - [WorkspaceStore](/classes/WorkspaceStore.md)

- Database

  - [Attribute](/classes/Attribute.md)
  - [AttributeBoolean](/classes/AttributeBoolean.md)
  - [AttributeCollection](/classes/AttributeCollection.md)
  - [AttributeDateTime](/classes/AttributeDateTime.md)
  - [AttributeJoinedData](/classes/AttributeJoinedData.md)
  - [AttributeNumber](/classes/AttributeNumber.md)
  - [AttributeObject](/classes/AttributeObject.md)
  - [AttributeServerId](/classes/AttributeServerId.md)
  - [AttributeString](/classes/AttributeString.md)
  - [DatabaseStore](/classes/DatabaseStore.md)
  - [Matcher](/classes/Matcher.md)
  - [ModelQuery](/classes/ModelQuery.md)
  - [SortOrder](/classes/SortOrder.md)

- Drafts

  - [DraftChangeSet](/classes/DraftChangeSet.md)
  - [DraftEditingSession](/classes/DraftEditingSession.md)
  - [DraftStore](/classes/DraftStore.md)

- AppEnv

  - [PackageManager](/classes/PackageManager.md)

- Atom
