# Ossus

Ossus is a framework for building documentation sites that focuses on being:

- **Simple**: Ossus gets you up and running with one line (`create-ossus`) and lets you get started writing markdown without having to fuss around with any dev work.
- **Customizable**: Ossus comes with pre-built components for layout that have extensive themeing variables that you can override. Ossus is also component based so you can replace any of the layout components with your own to get full power over your site.
- **Scalable**: Ossus is designed around large projects and has an expandable architecture to allow for projects of anysize to feel right at home.

## Built with

- **Next.js**: Ossus is built on top of [Next.js](https://nextjs.org/) to give you powerful SSR and static site exporting.
- **React**: Ossus is built with React so all of your knowledge about building UI's transfers.
- **Markdown**: Ossus renders markdown files into JSX so your site can look great without you having to code each page.

## Installation

Ossus is comprised of 3 packages:

- `ossus`
- `ossus-components`
- `ossus-scripts`

All three are avaliable as packages on NPM: `npm install --save ossus ossus-components ossus-scripts`;

We also provide a starter script so you can get setup with Ossus in one command, just run `npx create-ossus` in the directory you want to use.

More information can be found on our [documentation](https://ossus.fortellis.io).

## Contributing

We built Ossus because we couldn't find a framework out there that perfectly fit our needs at CDK Global. We hope that others will be able to get the value from it that we have, and we welcome contributions from the community!

### Code of Conduct

We have adopted a Code of Conduct that we expect all contributors to adhere to. Please read the [code of conduct](https://github.com/FortellisDev/Ossus/blob/master/CODE_OF_CONDUCT.md) before contributing so that you know what is allowed as a part of this community.

## License

Ossus is [MIT Licensed](https://github.com/FortellisDev/Ossus/blob/master/LICENSE)