var dispatcher = require('./dispatcher');
var constants = require('./constants');

var actions = {
	loadKeyboardLayout: function () {
		dispatcher.dispatch({
			type: constants.LOAD_KEYBOARD_LAYOUT
		});
	},

	// keybinding-changer

	keybindingChanger: {
		setView: function (index, data) {
			dispatcher.dispatch({
				type: constants.KEYBINDING_CHANGER_SET_VIEW,
				view: index,
				data: data
			});
		},
		setData: function (index, data) {
			dispatcher.dispatch({
				type: constants.KEYBINDING_CHANGER_SET_DATA,
				index: index,
				data: data
			});
		},
		save: function (options) {
			dispatcher.dispatch({
				type: constants.KEYBINDING_CHANGER_SAVE,
				options: options
			});
		},
		close: function () {
			dispatcher.dispatch({
				type: constants.KEYBINDING_CHANGER_CLOSE
			});
		},
		open: function (id) {
			dispatcher.dispatch({
				type: constants.KEYBINDING_CHANGER_OPEN,
				id: id
			});
		},
		reset: function () {
			dispatcher.dispatch({
				type: constants.KEYBINDING_CHANGER_RESET
			});
		}
	},

	// errorDialog

	errorDialog: {
		open: function (description) {
			dispatcher.dispatch({
				type: constants.ERROR_DIALOG_OPEN,
				description: description
			});
		},
		close: function () {
			dispatcher.dispatch({
				type: constants.ERROR_DIALOG_CLOSE
			});
		}
	},

	// preset

	preset: {
		export: function () {
			dispatcher.dispatch({
				type: constants.PRESET_EXPORT
			});
		},
		import: function () {
			dispatcher.dispatch({
				type: constants.PRESET_IMPORT
			});
		},
		importFile: function () {
			dispatcher.dispatch({
				type: constants.PRESET_IMPORT_FILE
			});
		},
		changeDescription: function (value) {
			dispatcher.dispatch({
				type: constants.PRESET_CHANGE_DESCRIPTION,
				value: value
			});
		},
		changeTitle: function (value) {
			dispatcher.dispatch({
				type: constants.PRESET_CHANGE_TITLE,
				value: value
			});
		}
	},

	// custom-code

	customCode: {
		update: function (value) {
			dispatcher.dispatch({
				type: constants.CUSTOM_CODE_UPDATE,
				value: value
			});
		}
	},

	// load

	loadPreset: function (id) {
		dispatcher.dispatch({
			type: constants.LOAD_PRESET,
			id: id
		});
	},

	loadCycle: function (id) {
		dispatcher.dispatch({
			type: constants.LOAD_CYCLE,
			id: id
		});
	},

	loadChatwheel: function (id) {
		dispatcher.dispatch({
			type: constants.LOAD_CHATWHEEL,
			id: id
		});
	},

	// changelog

	changelog: {
		open: function () {
			dispatcher.dispatch({
				type: constants.CHANGELOG_OPEN
			});
		}
	},

	// other

	changeLayout: function (id) {
		dispatcher.dispatch({
			type: constants.CHANGE_LAYOUT,
			id: id
		});
	},
	download: function () {
		dispatcher.dispatch({
			type: constants.DOWNLOAD
		});
	},
	activateTab: function (id) {
		dispatcher.dispatch({
			type: constants.ACTIVATE_TAB,
			id: id
		});
	},
	addLayout: function () {
		dispatcher.dispatch({
			type: constants.ADD_LAYOUT
		});
	},
	removeCurrentLayout: function () {
		dispatcher.dispatch({
			type: constants.REMOVE_CURRENT_LAYOUT
		});
	},
	importPreset: function () {
		dispatcher.dispatch({
			type: constants.IMPORT_PRESET
		});
	},
	exportPreset: function () {
		dispatcher.dispatch({
			type: constants.EXPORT_PRESET
		});
	},
	changeSetting: function (domain, id, value) {
		dispatcher.dispatch({
			type: constants.CHANGE_SETTING,
			id: id,
			value: value,
			domain: domain
		});
	},
	changeChatwheel: function (wheel, slot, value) {
		dispatcher.dispatch({
			type: constants.CHANGE_CHATWHEEL,
			wheel: wheel,
			slot: slot,
			value: value
		});
	},
	addChatwheel: function () {
		dispatcher.dispatch({
			type: constants.ADD_CHATWHEEL
		});
	},
	removeChatwheel: function (slot) {
		dispatcher.dispatch({
			type: constants.REMOVE_CHATWHEEL,
			slot: slot
		});
	},
	addCycle: function () {
		dispatcher.dispatch({
			type: constants.CYCLE_ADD
		});
	},
	removeCycle: function (id) {
		dispatcher.dispatch({
			type: constants.CYCLE_REMOVE,
			id: id
		});
	},
	addCycleItem: function (id) {
		dispatcher.dispatch({
			type: constants.CYCLE_ADD_ITEM,
			id: id
		});
	},
	moveCycleUp: function (id, slot) {
		dispatcher.dispatch({
			type: constants.CYCLE_MOVE_UP,
			id: id,
			slot: slot
		});
	},
	moveCycleDown: function (id, slot) {
		dispatcher.dispatch({
			type: constants.CYCLE_MOVE_DOWN,
			id: id,
			slot: slot
		});
	},
	removeCycleItem: function (id, slot) {
		dispatcher.dispatch({
			type: constants.CYCLE_REMOVE_ITEM,
			id: id,
			slot: slot
		});
	},
	removeDialogAbort: function () {
		dispatcher.dispatch({
			type: constants.REMOVE_DIALOG_ABORT
		});
	},
	removeDialogContinue: function () {
		dispatcher.dispatch({
			type: constants.REMOVE_DIALOG_CONTINUE
		});
	},
	showRemoveDialog: function (mode, id, child) {
		dispatcher.dispatch({
			type: constants.SHOW_REMOVE_DIALOG,
			mode: mode,
			id: id,
			child: child
		});
	},
	remapAltKey: function () {
		dispatcher.dispatch({
			type: constants.REMAP_ALT_KEY
		});
	}
};

module.exports = actions;
