# Manta Config Engine App

[![Join the chat at https://gitter.im/dodekeract/manta-config-engine][badge-gitter]][badge-gitter-link] [![MIT License][badge-license]][internal-license] [![Code Climate][badge-code-climate]][badge-code-climate-link] [![NPM Downloads][badge-npm-downloads]][badge-npm-downloads-link] [![NPM Dependencies][badge-npm-dependencies]][badge-npm-dependencies-link] [![Code Documentation][badge-inch-ci]][badge-inch-ci-link]

A [web-application][external-manta] using [Manta Config Engine][internal-manta] to generate [autoexec][external-autoexec] configurations for [Dota 2][external-dota-2].

![Layout Editor Keyboard][image-user-interface-layout-editor-keyboard]

## :warning: Warning

Since **Valve removed support for advanced autoexec**, this config is most likely completely unusuable. If you don't know **exactly** what you're doing, don't attempt to use it.

[Here](https://www.reddit.com/r/DotA2/comments/4kzld1/a_plea_to_valve_please_dont_kill_the_honest/) is an explanation of the situation.

In the unlikely case that anyone from Valve reads this: please re-consider your decision and just prevent multiple abilities/items per keypress. That would make awesome customization available again.

### Alternatives?

Here's a list of some relevant projects:

:no_entry: Disclaimer: **These projects MIGHT be forbidden by Valve and MAY lead to a VAC ban**.

- [@AveYo](https://github.com/AveYo)'s [D-OPTIMIZER](https://github.com/AveYo/D-OPTIMIZER) / [Project Arcana](http://steamcommunity.com/sharedfiles/filedetails/?id=408986743) (uses dota addons / vpk)
- [@Karrandalf](https://github.com/Karrandalf)'s [Project Oracle](https://github.com/Karrandalf/Dota2-TheCore-Config-Engine) (uses AutoHotkey)

## Table Of Contents

<!-- TOC depthFrom:2 depthTo:3 withLinks:1 updateOnSave:1 orderedList:0 -->

- [Table Of Contents](#table-of-contents)
- [Documentation](#documentation)
- [Features](#features)
- [Example Generated Autoexec](#example-generated-autoexec)
- [Installation](#installation)
	- [Via Git (recommended)](#via-git-recommended)
	- [Via NPM (experimental)](#via-npm-experimental)
- [License](#license)
- [Changelog](#changelog)

<!-- /TOC -->

## Documentation

The documentation for this project can be found [here][internal-documentation].

## Features

- Multiple layouts, which can be used for advanced key-combinations.
- Easy-to-use web-interface. Direct export to zip.
- Opensource - if you need a feature, implement it or submit a GitHub issue.
- Aims to use as few lines of `autoexec` as possible. Skips unused aliases & commands.
- Saves the preset to the browser's LocalStorage and includes `preset.json` in the zip-archive, which can be used to restore it in case it gets lost.
- Generates human-readable, commented code

## Example Generated Autoexec

````java
// generated using https://github.com/dodekeract/manta-config-engine
// graphical user-interface available at https://projects.dodekeract.com/manta/

// # Settings:
//---// Gameplay:
dota_hud_netgraph 1                         // Show Net Graph
dota_player_units_auto_attack 0             // Auto Attack
dota_player_units_auto_attack_after_spell 0 // Auto Attack After Spell
dota_player_auto_repeat_right_mouse 1       // Auto-Repeat Right Mouse
cl_dota_alt_unit_movetodirection 1          // Force Movement Direction
dota_force_right_click_attack 1             // Force Right-Click Attack
dota_player_multipler_orders 1              // Unified Unit Orders
dota_shop_view_mode 1                       // Always Show Grid-View
dota_always_show_player_names 1             // Show Player Names
dota_show_hero_finder 1                     // Show Hero Finder
dota_enable_range_finder 1                  // Show Range Finder
dota_camera_disable_zoom 1                  // Mousewheel Zoom
dota_reset_camera_on_spawn 0                // Move Camera On Respawn
dota_minimap_hero_scalar 1                  // Proximity Scale
dota_minimap_show_hero_icon 1               // Show Hero Icons
dota_minimap_always_draw_hero_icons 1       // Always Show Hero Icons
dota_minimap_hero_scalar_distance 20        // Proximity Scale Distance
dota_minimap_hero_scalar_minimum 400        // Proximity Scale Minimum

//---// Performance:
engine_no_focus_sleep 1 // Alt-Tab Idle
sv_forcepreload 1       // Force Server-Data Preload
cl_forcepreload 1       // Force Client-Data Preload

//---// Engine:
alias custom_load_indicator "playsound sounds/ui/coins_big.vsnd_c"

// # Chatwheels:
//---// Chatwheel 0:
alias +custom_chatwheel_0 "custom_chatwheel_0_0"                          // Prepare Chatwheel
alias custom_chatwheel_0_0 "chat_wheel_phrase_0 8; custom_chatwheel_0_1"  // ▶ Missing
alias custom_chatwheel_0_1 "chat_wheel_phrase_1 1; custom_chatwheel_0_2"  // ▶ Careful!
alias custom_chatwheel_0_2 "chat_wheel_phrase_2 2; custom_chatwheel_0_3"  // ▶ Get Back!
alias custom_chatwheel_0_3 "chat_wheel_phrase_3 3; custom_chatwheel_0_4"  // ▶ We need wards.
alias custom_chatwheel_0_4 "chat_wheel_phrase_4 29; custom_chatwheel_0_5" // ▶ Enemy returned
alias custom_chatwheel_0_5 "chat_wheel_phrase_5 54; custom_chatwheel_0_6" // ▶ Affirmative
alias custom_chatwheel_0_6 "chat_wheel_phrase_6 6; custom_chatwheel_0_7"  // ▶ Push now
alias custom_chatwheel_0_7 "chat_wheel_phrase_7 61; +chatwheel"           // ▶ Nice
alias -custom_chatwheel_0 "-chatwheel"                                    // Close Chatwheel

//---// Chatwheel 1:
alias +custom_chatwheel_1 "custom_chatwheel_1_0"                          // Prepare Chatwheel
alias custom_chatwheel_1_0 "chat_wheel_phrase_0 30; custom_chatwheel_1_1" // ▶ All enemy heroes missing!
alias custom_chatwheel_1_1 "chat_wheel_phrase_1 66; custom_chatwheel_1_2" // ▶ Game is hard
alias custom_chatwheel_1_2 "chat_wheel_phrase_2 78; custom_chatwheel_1_3" // ▶ I'm retreating
alias custom_chatwheel_1_3 "chat_wheel_phrase_3 41; custom_chatwheel_1_4" // ▶ We need detection
alias custom_chatwheel_1_4 "chat_wheel_phrase_4 79; custom_chatwheel_1_5" // ▶ Space created
alias custom_chatwheel_1_5 "chat_wheel_phrase_5 70; custom_chatwheel_1_6" // ▶ Relax, you're doing fine
alias custom_chatwheel_1_6 "chat_wheel_phrase_6 23; custom_chatwheel_1_7" // ▶ Bait
alias custom_chatwheel_1_7 "chat_wheel_phrase_7 68; +chatwheel"           // ▶ My bad
alias -custom_chatwheel_1 "-chatwheel"                                    // Close Chatwheel

// # Dependencies:
alias custom_ability_quickcast_0 "dota_ability_quickcast 0"                      // Quick-Cast Ability 1
alias custom_ability_selfcast_0 "dota_ability_execute 0; dota_ability_execute 0" // Self-Cast Ability 1

//---// Cycle 0:
alias custom_cycle_0 custom_cycle_0_0                                                    // Prepare Cycle
alias custom_cycle_0_0 "alias custom_cycle_0 custom_cycle_0_1; custom_cycle_0_command_0" // Cycle Through
alias custom_cycle_0_1 "alias custom_cycle_0 custom_cycle_0_2; custom_cycle_0_command_1" // Cycle Through
alias custom_cycle_0_2 "alias custom_cycle_0 custom_cycle_0_3; custom_cycle_0_command_2" // Cycle Through
alias custom_cycle_0_3 "alias custom_cycle_0 custom_cycle_0_0; custom_cycle_0_command_3" // Finish Cycle
alias custom_cycle_0_command_0 dota_health_per_vertical_marker 250                       // Command 1
alias custom_cycle_0_command_1 dota_health_per_vertical_marker 325                       // Command 2
alias custom_cycle_0_command_2 dota_health_per_vertical_marker 450                       // Command 3
alias custom_cycle_0_command_3 dota_health_per_vertical_marker 550                       // Command 4

alias custom_item_quickcast_0 "dota_item_quick_cast 0"                  // Quick-Cast Item 1
alias custom_item_selfcast_0 "dota_item_execute 0; dota_item_execute 0" // Self-Cast Item 1
alias +custom_layout_1 "exec layout-1.cfg"                              // Load Layout 2
alias -custom_layout_1 "exec layout-0.cfg"                              // Unload Layout 2

//---// View Base (Toggle):
alias +custom_view_base_toggle "custom_view_base_toggle_radiant"                                         // Set Default Base To Radiant
alias custom_view_base_toggle_dire "dota_camera_set_lookatpos 7000 6250; custom_view_base_toggle_0"      // Look At Dire Base
alias custom_view_base_toggle_radiant "dota_camera_set_lookatpos -7000 -6500; custom_view_base_toggle_1" // Look At Radiant Base
alias custom_view_base_toggle_0 "alias +custom_view_base_toggle custom_view_base_toggle_radiant"         // Set Radiant As Next Base
alias custom_view_base_toggle_1 "alias +custom_view_base_toggle custom_view_base_toggle_dire"            // Set Dire As Next Base
alias -custom_view_base_toggle "dota_recent_event; dota_recent_event; +dota_camera_follow"               // Jump Back

//---// View Rune (Toggle):
alias +custom_view_rune_toggle "custom_view_rune_toggle_top"                                           // Set Default Rune To Top
alias custom_view_rune_toggle_top "dota_camera_set_lookatpos -2225 1503; custom_view_rune_toggle_0"    // Look At Top Rune
alias custom_view_rune_toggle_bottom "dota_camera_set_lookatpos 2824 -2350; custom_view_rune_toggle_1" // Look At Bottom Rune
alias custom_view_rune_toggle_0 "alias +custom_view_rune_toggle custom_view_rune_toggle_bottom"        // Set Bottom As Next Rune
alias custom_view_rune_toggle_1 "alias +custom_view_rune_toggle custom_view_rune_toggle_top"           // Set Top As Next Rune
alias -custom_view_rune_toggle "dota_recent_event; dota_recent_event; +dota_camera_follow"             // Jump Back

// # Primary Layout:
exec layout-0.cfg

// # Load Indicator:
custom_load_indicator
````

## Installation

### Via Git (recommended)
- Install git & [Node.js][external-node]
- `git clone https://github.com/dodekeract/manta-config-engine-app`
- `npm install`

#### Running (git-only)

- `npm run start`

#### Applying Changes (git-only)

- `npm run apply`

#### Watching For Changes (git-only)

- `npm run watch`

### Via NPM (experimental)
- Install [Node.js][external-node]
- `npm install dota2-manta-config-engine-app -g`

#### Running (npm-only)
- `manta-config-engine-app` or `manta-config-engine-app portNumber`

## License
[MIT][internal-license]

## Changelog
[Changelog][internal-changelog]

[internal-changelog]:     https://github.com/dodekeract/manta-config-engine-app/tree/master/documentation/CHANGELOG.md
[internal-documentation]: https://github.com/dodekeract/manta-config-engine-app/tree/master/documentation/README.md
[internal-license]:       https://github.com/dodekeract/manta-config-engine-app/tree/master/documentation/LICENSE.md
[internal-manta]:         https://github.com/dodekeract/manta-config-engine

[image-user-interface-layout-editor-keyboard]: https://raw.githubusercontent.com/dodekeract/manta-config-engine-app/master/documentation/images/user-interface/layout-editor-keyboard.png

[badge-code-climate]:          https://codeclimate.com/github/dodekeract/manta-config-engine-app/badges/gpa.svg
[badge-code-climate-link]:     https://codeclimate.com/github/dodekeract/manta-config-engine-app
[badge-gitter]:                https://badges.gitter.im/Join%20Chat.svg
[badge-gitter-link]:           https://gitter.im/dodekeract/manta-config-engine
[badge-inch-ci]:               https://inch-ci.org/github/dodekeract/manta-config-engine-app.svg
[badge-inch-ci-link]:          https://inch-ci.org/github/dodekeract/manta-config-engine-app
[badge-license]:               https://img.shields.io/badge/license-MIT-blue.svg
[badge-npm-dependencies]:      https://david-dm.org/dodekeract/manta-config-engine-app.svg
[badge-npm-dependencies-link]: https://david-dm.org/dodekeract/manta-config-engine-app
[badge-npm-downloads]:         https://img.shields.io/npm/dt/dota2-manta-config-engine-app.svg
[badge-npm-downloads-link]:    https://npmjs.com/package/dota2-manta-config-engine-app

[external-node]:     https://nodejs.org
[external-dota-2]:   http://dota2.com
[external-manta]:    https://projects.dodekeract.com/manta/
[external-autoexec]: http://wiki.teamliquid.net/dota2/Console_Commands
