# Contributing Guide

## Issues

### Things To Add

Here is a list of things which could be useful, when added to your issue:

- description
- TL;DR (short description)
- [pastebin](https://pastebin.com) link to your preset
	- found in `preset.json` in the `.zip` download
	- alternatively use the [Preset Viewer](https://projects.dodekeract.com/manta/#/presets/view)
- code or autoexec samples (format like <code>\`this\`</code>)

### Useful Resources
- [how to write markdown](https://github.com/adam-p/markdown-here/wiki/Markdown-Cheatsheet)
- [submit code or presets](https://pastebin.com)

## Pull Requests

Please try to use the same code-style. Including, but not limited to:

- indentation with tabs
- alignment with spaces
- write `if`s like this:
```javascript
if (condition) {
	code;
} else if (condition) {
	code;
} else {
	code;
}
```
