# EarTrumpet

[![GitHub issues](https://img.shields.io/github/issues/File-New-Project/EarTrumpet?style=flat-square)](https://github.com/File-New-Project/EarTrumpet/issues) [![GitHub forks](https://img.shields.io/github/forks/File-New-Project/EarTrumpet?style=flat-square)](https://github.com/File-New-Project/EarTrumpet/network) [![GitHub stars](https://img.shields.io/github/stars/File-New-Project/EarTrumpet?style=flat-square)](https://github.com/File-New-Project/EarTrumpet/stargazers) [![GitHub license](https://img.shields.io/github/license/File-New-Project/EarTrumpet?style=flat-square)](https://github.com/File-New-Project/EarTrumpet/blob/master/LICENSE) [![Nuget package](https://img.shields.io/chocolatey/v/eartrumpet?style=flat-square)](https://chocolatey.org/packages/eartrumpet) ![Maintenance status](https://img.shields.io/maintenance/yes/2024?style=flat-square)

![EarTrumpet Screenshot](./Graphics/hero.gif)


## Awards

2022 Winner of the [Microsoft Store Community Choice Awards](https://blogs.windows.com/windowsdeveloper/2022/05/27/announcing-the-microsoft-store-app-awards-winners/#:~:text=open%20platform%20category) (Open Platform)
> Windows is an open platform for innovation. We know that not every customer uses Windows in the same way — some want to modify different parts of the UI or make some features more accessible for them. These are the apps you said turn Windows into your Windows.

## Media coverage

> [...] there are third-party solutions out there that do a much better job than what Windows offers by default. One such app is called EarTrumpet [...]
>
> &mdash; [TechQuickie (Jan 11, 2022)](https://www.youtube.com/watch?v=xQvp5HzY9xc)

> Microsoft's built-in Windows 11 audio management still isn't great. EarTrumpet overhauls it completely, with a system tray utility that gives you volume levels for every app and the ability to set custom inputs and outputs for those apps.
>
> &mdash; [The Verge (Dec 30, 2021)](https://www.theverge.com/22837232/windows-11-pc-best-apps-microsoft-2021)

> If you want fine-tuned control of your app and system volume, EarTrumpet is a must.
>
> &mdash; [Windows Central (Jun 19, 2018)](https://www.windowscentral.com/eartrumpet-review-best-audio-control-app-windows)

## Sponsors

<!-- sponsors --><a href="https://github.com/PykeMann"><img src="https://github.com/PykeMann.png" width="60px" alt="" title="" /></a><a href="https://github.com/audabas"><img src="https://github.com/audabas.png" width="60px" alt="Bastien Auda" title="Bastien Auda" /></a><!-- sponsors -->

## Features

* Visualize audio with multi-channel aware peaking
* Standalone volume mixer
* Move apps between playback devices
* Default playback device management
* Automatic updates via the Microsoft Store
* Support for light/dark mode and all accent colors
* Configurable hotkeys
* Modern context menus
* Growing multilingual support

## Internationalization

Thanks to our translators, we currently support 20+ languages. Are we missing your language? [Contribute a translation via Crowdin](https://crowdin.com/project/eartrumpet)!

### Translators

<!-- begin-translators -->
<img src="https://crowdin-static.downloads.crowdin.com/avatar/14872330/medium/d38d40292450e14db39f113194629c0c_default.png" width="60" alt="BlockyTheDev" title="BlockyTheDev" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13330267/medium/b159ba7979de040c86a4397a0a2115c6.png" width="60" alt="casungo" title="casungo" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/12749175/medium/b95993758d781b934c040afaf0d5416a_default.png" width="60" alt="cmhdream" title="cmhdream" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14308340/medium/bad9ca0853fe4d9770b19f99988ad7de_default.png" width="60" alt="cronhan" title="cronhan" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14670476/medium/7c2feaab8de1a13a5a45d75cc1b28273_default.png" width="60" alt="CrysoK" title="CrysoK" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13316318/medium/e0c4affb2a9a069c2d1b3cddf968a681.jpg" width="60" alt="Dekamir" title="Dekamir" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15327302/medium/51d366e487e262cc9594d6b7dd68b35b_default.png" width="60" alt="Denis21010" title="Denis21010" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15808639/medium/9de31b34118e395637343527bdee44da_default.png" width="60" alt="dkopec91" title="dkopec91" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15970109/medium/ba21a1e47818b358efda3b1713d8ae0a.png" width="60" alt="Drasil" title="Drasil" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/16628531/medium/0d041ba415436a324f4265a0c37dcdfa.png" width="60" alt="evasive" title="evasive" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14308282/medium/cac5243a5f30c5a57f40cf0a54db1122_default.png" width="60" alt="ewerkman" title="ewerkman" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/12919147/medium/3ec704edc2b1d72403757fb5bcedc208_default.png" width="60" alt="fashni" title="fashni" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15555685/medium/c26effff6ae343d5972fe8372a40d2d0.png" width="60" alt="FoxyLoon" title="FoxyLoon" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15267142/medium/b2026ac455aebad9dadb28d01a477e3e_default.png" width="60" alt="gbetsis" title="gbetsis" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14309406/medium/994b9ee8f483e039dc65ee5d4efba5b4_default.png" width="60" alt="GoldenTao" title="GoldenTao" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/16087014/medium/f7d9ed53665b661827e08b23a2295ff5_default.png" width="60" alt="heerxingen" title="heerxingen" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15783175/medium/7a55d8002ca14dc6f8a4199546c675a6_default.png" width="60" alt="ivoo_" title="ivoo_" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/16612717/medium/a28749450c7893af0a742392c37fd359_default.png" width="60" alt="jamilfarajov" title="jamilfarajov" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15097137/medium/8f2d8386e1185d8f302ed914d98c8488.png" width="60" alt="JordyEGNL" title="JordyEGNL" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14817870/medium/cb2eb004e1cd51f9e98e7c9436b64eb5_default.png" width="60" alt="jsunyermias" title="jsunyermias" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14630722/medium/1700b0fe117ee7026a6bff2aa37295a9_default.png" width="60" alt="JY3" title="JY3" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/12958483/medium/a18d9b484e0d449f3cdc9074ac3d7a0e_default.png" width="60" alt="kutiz" title="kutiz" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15398042/medium/f81c48ee9ae7db632a0e061a47563b3f.png" width="60" alt="Le_Roi_Fromage" title="Le_Roi_Fromage" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14813030/medium/644460ffb131e3d2083c28a75734f5b9_default.png" width="60" alt="luisvalles" title="luisvalles" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14810974/medium/3283d948785c0fb6c983138140b828a8_default.png" width="60" alt="luukverhagen96" title="luukverhagen96" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14677952/medium/c78ed52a3ce400b14f004fc782f9da92_default.png" width="60" alt="merah26" title="merah26" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15101593/medium/7ba86a681950eccf6be0e4e368979a7f_default.png" width="60" alt="noseran" title="noseran" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13946509/medium/fb250074d3e8e2ece44a96e1ce7c89f7_default.png" width="60" alt="Orofil" title="Orofil" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14232896/medium/80e76b2ea46645c0a82837f82f841470_default.png" width="60" alt="OsoFugitivo" title="OsoFugitivo" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15374728/medium/9dc09bcf3af4aea89ca137b3f3e196c9_default.png" width="60" alt="poipoi" title="poipoi" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14311344/medium/2b7a3a073dd0b90deea572db691cc734_default.png" width="60" alt="random.001" title="random.001" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13105668/medium/5a07864ec401e977450ada2d1d7f88de_default.png" width="60" alt="Randomname456" title="Randomname456" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15748955/medium/7626ec8c38a97c05d5da7f6feab1d583_default.png" width="60" alt="siprach" title="siprach" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13650547/medium/cf071114cd0cf19477b1a798f8f7ede8_default.png" width="60" alt="Tihsamikah" title="Tihsamikah" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14974199/medium/8ebcdd57e6d382411d3c883fe7f6a6a6_default.png" width="60" alt="weyh" title="weyh" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15967701/medium/642f4846085e28561dd2c1925943b3c3_default.png" width="60" alt="Yannick_Whorst" title="Yannick_Whorst" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13143242/medium/bbadb983963fa8490e4226b17a838d30.jpeg" width="60" alt="yinyue200" title="yinyue200" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13774501/medium/69b1d353773a662aff1633b0e4f2fddf_default.png" width="60" alt="zxcx" title="zxcx" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/9483/medium/f85c72e3a9f45b60de6c7d9d66534884_default.png" width="60" alt="chreddy" title="chreddy" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/12369651/medium/7fe177b1c102dad0579f1dc080abccd0.jpg" width="60" alt="gable" title="gable" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/12776255/medium/bc26f83e53902c22a2897526c38bc6ff_default.png" width="60" alt="RazvanS" title="RazvanS" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/12339223/medium/d87f31be32da1abf875cccc652c91dd7_default.png" width="60" alt="Taifuuni" title="Taifuuni" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15783935/medium/5f94215ab3295606027f337039073160.jpeg" width="60" alt="140bpmdubstep" title="140bpmdubstep" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15100557/medium/a17422cbc9cc74aff1bc268f3232400e.png" width="60" alt="alpdmrel" title="alpdmrel" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14797892/medium/73cc1c9edba3ec76b93d8a52889751b7_default.png" width="60" alt="Apolônio Serafim" title="Apolônio Serafim" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14665986/medium/83418b2b4bc3985746dcf8067f3cf729.jpeg" width="60" alt="Arcade" title="Arcade" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15238102/medium/7a8ca83aca2acc4f4fa212add6e90a20.jpeg" width="60" alt="Ariel Eytan" title="Ariel Eytan" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14561478/medium/4d3f3b4ff5d03bf3789f59bca14d119b.jpg" width="60" alt="Artan Imeri" title="Artan Imeri" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13600943/medium/06fea29b3b10610bc357e78cc8b8a81c.png" width="60" alt="Artem" title="Artem" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13038722/medium/44e66f4b32f8838ac6165e8d5760f701.jpg" width="60" alt="Artem Bazhenov" title="Artem Bazhenov" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13452961/medium/c1816f4fa3773e94fb8f97dbcf8aa030.jpg" width="60" alt="Bazsa" title="Bazsa" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15240128/medium/ad4390b99e497fd08669c8f9aa58a0cd.jpeg" width="60" alt="Berk Kırıkçı" title="Berk Kırıkçı" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/16626235/medium/1b681f1e2ff7676ad73d3914cfdeeaab.jpeg" width="60" alt="Cain" title="Cain" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14844934/medium/3e0ce84cd49f71bf1e102c6818b749c3.png" width="60" alt="Carl Oosthuizen" title="Carl Oosthuizen" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15432564/medium/7a66d241f43fc326d6e178d972ad60b2.jpeg" width="60" alt="Charles IdB" title="Charles IdB" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14074895/medium/b632b9964d4c4d7c368f2316e1cba408.png" width="60" alt="Corey" title="Corey" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15129337/medium/a5267425bc6d8c0ef636fd99716c50d9.png" width="60" alt="Daan Schroeten" title="Daan Schroeten" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13559595/medium/e7a36cb985b6faac8881c9d987526675.png" width="60" alt="Davin Risy A. H." title="Davin Risy A. H." /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13266874/medium/baa6126ab777c263dc67ad35bf307962.jpg" width="60" alt="Dimitris Traxiotis" title="Dimitris Traxiotis" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13578856/medium/251c7ade449c995d85a200c81559f5f4.jpg" width="60" alt="Donato" title="Donato" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14310562/medium/ddffb5e514dbe950aed40a1b5de9b9a7.jpg" width="60" alt="duk6046" title="duk6046" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13630281/medium/fb862b5ff55daaac221ddf332736a59a.jpeg" width="60" alt="Dy64" title="Dy64" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/12541873/medium/6b3ae953acf0b631623bd293bf87293c.png" width="60" alt="Edison Lee" title="Edison Lee" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15544785/medium/18860b133c4f8af7942eb753e5e5d557.jpeg" width="60" alt="Eduardo Junio" title="Eduardo Junio" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/16122704/medium/191ecfb3c4efbf969b2f97afd0c54132.jpeg" width="60" alt="Elias Torstensen" title="Elias Torstensen" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/12830604/medium/2a143b2c7cf0203d2a55c16a24b9d21f.jpg" width="60" alt="Emre" title="Emre" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14730934/medium/f863a2ca748957ffbc0ad9108a14cc92.jpg" width="60" alt="EN LYOWH" title="EN LYOWH" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14827072/medium/f8c4e92cdf974b21d4969750bf7734d5.png" width="60" alt="Enes 3078" title="Enes 3078" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14885042/medium/7e91c11908d9caa2fe71e1d88add03d2.png" width="60" alt="Epic gaming chair" title="Epic gaming chair" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/16572919/medium/5b0d7c6d7e786dc0f36f12f1a4a568f1.png" width="60" alt="Ettore Bernardi" title="Ettore Bernardi" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14364106/medium/28e1ec673d60ca2b816e35ee3a0b9e6f.png" width="60" alt="ExteriorCloth20" title="ExteriorCloth20" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14308338/medium/4bf9aa2f14d9c2885c08621b58c28915.jpeg" width="60" alt="Firefly74940" title="Firefly74940" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14308306/medium/7a507059aea640e6f6d3f82447831003.jpeg" width="60" alt="Fred Ahrens" title="Fred Ahrens" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13542306/medium/f83eed4a067b1420e23a93374f8c3201_default.png" width="60" alt="Gabriel Lima" title="Gabriel Lima" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13047529/medium/198ab9def084738aed803ccd4bb513c2.jpg" width="60" alt="Gabriele" title="Gabriele" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/12416181/medium/2864d29be808543d56f9e210a06ad934.jpg" width="60" alt="Göran" title="Göran" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/12974300/medium/32204f326bcb4f96462478242d42e080.JPG" width="60" alt="Guillaume Turchini" title="Guillaume Turchini" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15252782/medium/80a0857613f002c9342677a1e3bc633d.jpeg" width="60" alt="Gustavo Abreu" title="Gustavo Abreu" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/16423104/medium/17ab422688c11d2f67060a27a04dd4de.jpeg" width="60" alt="Hichem Fantar" title="Hichem Fantar" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14807610/medium/c116d37dacdba89e727a093458cfeed3.png" width="60" alt="hirin-byte" title="hirin-byte" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14777148/medium/eacad532662cec7444b39a04b6f8b781.png" width="60" alt="IDAぷろ" title="IDAぷろ" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14028282/medium/325e802fedad904f1260fdfc420ede8e.png" width="60" alt="iGerman00" title="iGerman00" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13811295/medium/9e5c76b6a10754546fc3103073ee3730.png" width="60" alt="iMiKE (Borizzz from XDA)" title="iMiKE (Borizzz from XDA)" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/12813062/medium/98c8a5adc56049856afa66b585626c29.jpg" width="60" alt="Izumi W." title="Izumi W." /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15727509/medium/10365e2a5116480e7e251e433d31c950.png" width="60" alt="Jabir Abdullah Haian" title="Jabir Abdullah Haian" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14632244/medium/1ac43a9aca06f037a3d672b86d295584.jpeg" width="60" alt="Jacek Majda" title="Jacek Majda" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13608356/medium/5a67767dc97df69d42e69e84aa7f8a28.jpg" width="60" alt="Jaiganésh Kumaran" title="Jaiganésh Kumaran" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/12842611/medium/48731ed87bd7950feb032e5a8ddcd9ab.jpg" width="60" alt="Jaime Muñoz Martín" title="Jaime Muñoz Martín" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14102781/medium/1b7a397ba4b6b75b70d4cd5bff01e805.png" width="60" alt="Jan Formela" title="Jan Formela" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14575810/medium/62411610dc7dcd65c6b70dcce6054a18.png" width="60" alt="Jerem Dlcn" title="Jerem Dlcn" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/12346627/medium/15087fbf50ddc9e2927bff8d45227d54.jpg" width="60" alt="Jeroen Maathuis" title="Jeroen Maathuis" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14858992/medium/156ee7e3baf40a3b061ef1a21a6948ea.png" width="60" alt="Jhongt796" title="Jhongt796" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13573718/medium/f6c2b81316684f96734a17d70f57ad5d.jpg" width="60" alt="Jiaa" title="Jiaa" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14699602/medium/515da61679e1065469fafe1dfa1dbb0a.jpeg" width="60" alt="johnyb0y" title="johnyb0y" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14665122/medium/4abd13b512be8b419f1df13784c09d93.jpeg" width="60" alt="Jose Calderon" title="Jose Calderon" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15904135/medium/529077dfebfec80e43eff73cc5f29c38.png" width="60" alt="Jules" title="Jules" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15399270/medium/d827910a3818fd05e49f13a9c735ce31.jpeg" width="60" alt="Kolala" title="Kolala" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14950449/medium/245040d1111d7e754eae46e3e17b4687.jpeg" width="60" alt="LastRagnarokkr" title="LastRagnarokkr" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/12732819/medium/f7c4901e999fc076ac8e081386f22a9a.png" width="60" alt="Leon San José Larsson" title="Leon San José Larsson" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/16142300/medium/4e8183bd05ab1054931145d38fa3275e.jpeg" width="60" alt="likegravity" title="likegravity" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14700644/medium/a3afbfe8ebc9b81b1fd4e77fb2f1dd15.jpeg" width="60" alt="Lilian ARAGO" title="Lilian ARAGO" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14165949/medium/6294dfb63294bd57da6208cbf79546de.png" width="60" alt="maboroshin" title="maboroshin" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13541741/medium/98b008c02279ab89bc1be4f8d022dbc5.jpg" width="60" alt="Marco P." title="Marco P." /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13517065/medium/623fcb5e60d02deb86ef01c00a9a618d.jpg" width="60" alt="Marco te Kortschot" title="Marco te Kortschot" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14191847/medium/41c2768c383d8d2113028c1b0cc9e53f_default.png" width="60" alt="Marian Dolinský" title="Marian Dolinský" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/29290/medium/212cdece08139291e40600ba9f984c33_default.png" width="60" alt="Martijn van B." title="Martijn van B." /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15826833/medium/3e196c7999fe781f4c69e36aec602157.jpeg" width="60" alt="Mat GMC7" title="Mat GMC7" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/12691360/medium/1972915fe8906cc80c37cc3e93c116f0_default.png" width="60" alt="Melcon Moraes" title="Melcon Moraes" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14677180/medium/85d459ce0f5acace6777b8995804b9ed.jpg" width="60" alt="Merloss" title="Merloss" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14308274/medium/18f21a28039e5d36454388d150840b19.jpeg" width="60" alt="Miguel Hurtado" title="Miguel Hurtado" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14593474/medium/0ee238ef2b9f6a8b60c1c5090de9e212.jpeg" width="60" alt="Mohammad Shughri" title="Mohammad Shughri" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15729861/medium/f64ee22471b56560676856e9237b6e27.jpeg" width="60" alt="muhammad sadq " title="muhammad sadq " /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13856939/medium/fa8d8cedef0ed56ad4d28a37bf19e389.jpeg" width="60" alt="Nikola Perović" title="Nikola Perović" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14735980/medium/ead5bccda5e9f1444871f861cf1465ef.jpeg" width="60" alt="Nil Calderó Vega" title="Nil Calderó Vega" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15386352/medium/7df214fbcaf299a2e03660481c2791d6.png" width="60" alt="Nissan-O" title="Nissan-O" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15434450/medium/bf2311cb92f429b2420bf4cbba2e5124.png" width="60" alt="notlin4" title="notlin4" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14308858/medium/2824f71dddf2973c4a5b531e44a6e6e5.jpg" width="60" alt="NTAuthority" title="NTAuthority" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/12926745/medium/1eac4c9f7271d3ce79cd5d9432604d9a.jpg" width="60" alt="Omar Mostafa" title="Omar Mostafa" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14888044/medium/e97ab716e09e8af9bb21e65f977d9970.png" width="60" alt="Pasvv19" title="Pasvv19" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14964547/medium/b9d000864d028e54d580d26331a1571e.jpeg" width="60" alt="Pavel Bibichenko" title="Pavel Bibichenko" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/2952/medium/ebf0ac39dcaa7069d771310e63bd32dc_default.png" width="60" alt="Peter Pin-guang Chen" title="Peter Pin-guang Chen" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15052449/medium/54e00aaf0028ee0132e5719604e1b1ed.jpeg" width="60" alt="Pol" title="Pol" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13998735/medium/18f97a8233b24aaa697f2f6890acd579.png" width="60" alt="Quartyn Walker" title="Quartyn Walker" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14308154/medium/303307459679a720572e4f315a990e32.png" width="60" alt="Rafael Rivera" title="Rafael Rivera" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/12929130/medium/5701b9d8cbe77ff718d46ac481042106.jpg" width="60" alt="Raul Andres del Canto Zahr" title="Raul Andres del Canto Zahr" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/12522483/medium/87a014f599e0caba500684e96c1d7ee4_default.png" width="60" alt="Rodrigo" title="Rodrigo" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13929217/medium/680fa5433ed52756443b29efb2150f48.jpg" width="60" alt="Rodrigo Garcia Martin" title="Rodrigo Garcia Martin" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13958355/medium/7bee7f23e1c63f2e614a539d2d544357.png" width="60" alt="Roman Matviiv" title="Roman Matviiv" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15209700/medium/b397494f3b30da776097521bd0d42a3b.jpg" width="60" alt="Sebastian Soldat" title="Sebastian Soldat" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13043045/medium/1832032ac5c873fdadc40920b37c1058.jpg" width="60" alt="Shahdan Turung" title="Shahdan Turung" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/16466045/medium/8db81342c9b72a258c4d18a508c930ed.jpeg" width="60" alt="Shahin Alam (shahin alam)" title="Shahin Alam (shahin alam)" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14676966/medium/5229af30e768be5ef251c2c13164dbbd_default.png" width="60" alt="somni" title="somni" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15919387/medium/c9c27be7d33780909fb770b0dcf74da4.jpeg" width="60" alt="Sophia Sarah" title="Sophia Sarah" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14405616/medium/d4bcf370dceb8161b924c3260e033ea6.png" width="60" alt="Spaanhede" title="Spaanhede" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13851339/medium/a794c857be32c2667344e09b8a74ecbd.jpeg" width="60" alt="Stanislav" title="Stanislav" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14229382/medium/e1fbedc7a13497d4ab2098411bb8d6cb.png" width="60" alt="Steve Y Sus Juegos" title="Steve Y Sus Juegos" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15445162/medium/32375d4cebe678e0e8af3e52ef3e8c80.jpeg" width="60" alt="Syuugo" title="Syuugo" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14824284/medium/61217f7dac49cff41ea578d0b449669e.jpeg" width="60" alt="Tci Gravifer Fang" title="Tci Gravifer Fang" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13888473/medium/4ffdd5a168c9f44ad841b16037743e0f.jpg" width="60" alt="Ten tu není" title="Ten tu není" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15346744/medium/9cdd79ccdc195fe4bf80d9fc55c0b392.jpeg" width="60" alt="Thatchai Sintra" title="Thatchai Sintra" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/12773928/medium/9212d427b61e4724e85bc03d48ead7d4.png" width="60" alt="Thiago Henrique da Silva" title="Thiago Henrique da Silva" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15881037/medium/c9edb062fe97f065c15f50b0e51de18e.png" width="60" alt="Thiago Ramos" title="Thiago Ramos" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13539607/medium/41693ad9493a7b911749c6cdcbf8d357_default.png" width="60" alt="u!^DEV" title="u!^DEV" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15100993/medium/bcb6ece4c1b5b08d32c1a3c0889b8f6e.jpeg" width="60" alt="Umang Chauhan" title="Umang Chauhan" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14679092/medium/589e4b1fec3cf774cbd6f2bad1fba733.jpeg" width="60" alt="WCONTI" title="WCONTI" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14702386/medium/9dcd47d206da5952ead87de3d692b6ec.jpeg" width="60" alt="Wessel Smid" title="Wessel Smid" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13309066/medium/22aba64233b225b1e73b700584f9ada7.jpg" width="60" alt="Yacine Boussoufa" title="Yacine Boussoufa" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13501302/medium/610cf496d138c51448bb14f7ea813ed7.jpeg" width="60" alt="Yaniv Levin" title="Yaniv Levin" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/16557429/medium/c8cc9cff2045b6f8655cbc9f62b91997.jpeg" width="60" alt="Yasoga Nanayakkarawasam" title="Yasoga Nanayakkarawasam" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14937273/medium/2c3b8a43cd5f93681a34d4c37a9d3e5f.png" width="60" alt="yrctw" title="yrctw" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/13828709/medium/2d6846dca4f720b6e1ac73ed5bd7e949.jpg" width="60" alt="YuDong" title="YuDong" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/16253718/medium/1bb79c548873635abfd4ff9d43199cd9.jpeg" width="60" alt="Λόρδος Πορτοκάλης" title="Λόρδος Πορτοκάλης" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15238672/medium/7e90a2f77e034e7463b1f1d24eedd645.png" width="60" alt="Вова Смірнов" title="Вова Смірнов" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14750132/medium/909fb18f45c4a69b8227ddbd7a7433e0.png" width="60" alt="Михаил Эпштейн" title="Михаил Эпштейн" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/15603175/medium/81923d48d6975b1cdc5f2bc0e084e74e.png" width="60" alt="י. פל." title="י. פל." /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/12960382/medium/efd52e2c41be32bfd52569ac15d228b7.jpg" width="60" alt="曹恩逢" title="曹恩逢" /> <img src="https://crowdin-static.downloads.crowdin.com/avatar/14810144/medium/92b0ea42c77ff3689d6bbd05dbb2c332.png" width="60" alt="王柏崴" title="王柏崴" />
<!-- end-translators -->

## Install

Install EarTrumpet from the [Microsoft Store](https://www.microsoft.com/store/apps/9nblggh516xp)

Or via command line using either
- [Windows Package Manager Client (winget)](https://github.com/microsoft/winget-cli) (`winget install File-New-Project.EarTrumpet`)
- Chocolatey (`choco install eartrumpet`)

## Experimental dev builds

Want to see what we were working on? Or help us test new features? [Install EarTrumpet from the dev channel.](https://install.eartrumpet.app/dev/EarTrumpet.Package.appinstaller) New builds are released automatically every time we commit to the `dev` branch, keeping you up to date on our progress.

## Documentation
* [Technical Information](./EarTrumpet/README.md)
* [Compiling EarTrumpet](./COMPILING.md)
* [Contributing to EarTrumpet](./CONTRIBUTING.md)
* [Information Collected And Transmitted By EarTrumpet](./PRIVACY.md)
* [Project License](./LICENSE)
* [Change Log](./CHANGELOG.md)

## Supported operating systems
- Windows 10 1803 (April 2018 Update)
- Windows 10 1809 (October 2018 Update)
- Windows 10 1903 (May 2019 Update)
- Windows 10 1909 (November 2019 Update)
- Windows 10 2004 (May 2020 Update)
- Windows 10 20H2 (October 2020 Update)
- Windows 10 21H1 (May 2021 Update)
- Windows 10 21H2 (November 2021 Update)
- Windows 10 22H2 (October 2022 Update)
- Windows 11

## Credits
- David Golden ([@GoldenTao](https://www.twitter.com/GoldenTao))
- Rafael Rivera ([@WithinRafael](https://www.twitter.com/WithinRafael))
- Dave Amenta ([@davux](https://www.twitter.com/davux))
- [Contributors](https://github.com/File-New-Project/EarTrumpet/graphs/contributors)

## Special thanks

"[Horn](https://thenounproject.com/icon/horn-125731/)" icon by Artjom Korman from [the Noun Project](https://thenounproject.com/)














