# Contributing to EarTrumpet
Thanks for your interest in contributing to EarTrumpet!

You can contribute to EarTrumpet with issues and pull requests (PRs). Simply filing issues for problems you encounter is a great way to contribute. Contributing code via the below workflow is greatly appreciated.

## Copyright

EarTrumpet copyright is held by "Rafael Rivera, David Golden, David "Dave" Amenta, and Contributors".

## Contribution Workflow

Before contributing code, we require the following workflow:

1. Create an issue for your work or reuse an existing issue on the topic, if there is one.

2. Get agreement from the team that your proposed change is OK. (You can alternatively email the `team@eartrumpet.app`.)

3. Clearly state that you are going to take on the bug/enhancement work and we will assign the task to you.

4. Create a fork of the repository on GitHub (if you don't already have one).

5. Create a branch from **dev** (`git checkout -b mybranch dev`).

6. Name the branch so that it clearly communicates your intentions, such as issue-123 or feature-456.

7. Build the repository with your changes. Make sure that the builds are clean in all configurations (i.e. `Debug`, `Release`, and `VSDebug`).

8. Commit and push your changes to your fork.

9. Create a pull request (PR) against our **dev** branch.

    ℹ It is OK for your PR to include a large number of commits. We will squash them on merge.

    ℹ It is also OK to create your PR as "[WIP]" before the implementation is done. This can be useful if you'd like to start the feedback process while you finish your implementation. State that this is the case in the initial PR comment.