
//日志输出类
var JSConsole=
{ 
    Chart:{ Log:console.log },      //图形日志
    Complier:{ Log:console.log },   //编译器日志
    JSTable:{ Log:console.log }      //表格日志
};




/*
   Copyright (c) 2018 jones
 
    http://www.apache.org/licenses/LICENSE-2.0

   开源项目 https://github.com/jones2000/HQChart
 
   jones_2000@163.com

   系统指标 (H5版本)
*/


/*
    指标数据脚本 系统内置指标都写在这里
    Name：指标名字
    Description：指标描述信息
    Args:参数 { Name:名字, Value=值 }
    IsMainIndex：是否是主图指标 true=主图指标 false=副图指标
    KLineType:K线设置 -1=主图不显示K线(只在主图有效) 0=在副图显示K线 1=在副图显示K线(收盘价线) 2=在副图显示K线(美国线)
    InstructionType: 1=专家指示  2=五彩K线
    FloatPrecision: 小数位数 缺省=2
    YSplitScale:  Y固定刻度 [1,8,10]
    YSpecificMaxMin: 固定Y轴最大最小值 { Max: 9, Min: 0, Count: 3 };
    StringFormat: 1=带单位万/亿 2=原始格式
    Condition: 限制条件 { Symbol:'Index'/'Stock'(只支持指数/股票),Period:[](支持的周期), Include:[](指定支持的股票,代码全部大写包括后缀)}
    OutName:动态输出变量名字 [{Name:原始变量名, DynamicName:动态名字格式}] 如 {Name:"MA1", DynamicName:"MA{M1}"};
*/

//周期条件枚举
var CONDITION_PERIOD=
{
    MINUTE_ID:101,            //分钟      走势图
    MULTIDAY_MINUTE_ID:102,   //多日分钟  走势图
    HISTORY_MINUTE_ID:103,    //历史分钟  走势图

    //K线周期
    KLINE_DAY_ID:0,
    KLINE_WEEK_ID:1,
    KLINE_TWOWEEK_ID:21,
    KLINE_MONTH_ID:2,
    KLINE_QUARTER_ID:9,
   
    KLINE_YEAR_ID:3,
    KLINE_MINUTE_ID:4,
    KLINE_5_MINUTE_ID:5,
    KLINE_15_MINUTE_ID:6,
    KLINE_30_MINUTE_ID:7,
    KLINE_60_MINUTE_ID:8,
};

//自定义的指标脚本
function CustomIndexScript()
{
    this.DataMap=new Map(); //key=指标id, value=data {ID:, Name：指标名字, Description：指标描述信息 Args:参数 ......}

    this.Get=function(id)
    {
        if (!this.DataMap.has(id)) return null;
        return this.DataMap.get(id);
    }

    this.Add=function(data)
    {
        this.DataMap.set(data.ID, data);
    }
}

var g_CustomIndex=new CustomIndexScript();

function JSIndexScript()
{
    this.DataMap=new Map(
        [
            ['MA', this.MA],['均线', this.MA],
            ["MA4", this.MA4],["MA5", this.MA5],["MA6", this.MA6],["MA7", this.MA7],["MA8", this.MA8],
            ['BOLL', this.BOLL],['BOLL副图', this.BOLL2],['BBI', this.BBI],
            ['DKX', this.DKX],['MIKE', this.MIKE],['PBX', this.PBX],
            ['ENE', this.ENE],['MACD', this.MACD],['KDJ', this.KDJ],["MACD2", this.MACD2],
            ['VOL', this.VOL],['RSI', this.RSI],['BRAR', this.BRAR],
            ['WR', this.WR],['BIAS', this.BIAS],['OBV', this.OBV],
            ['DMI', this.DMI],['CR', this.CR],['PSY', this.PSY],
            ['CCI', this.CCI],['DMA', this.DMA],['TRIX', this.TRIX],
            ['VR', this.VR],['EMV', this.EMV],['ROC', this.ROC],
            ['MTM', this.MTM],['FSL', this.FSL],['CYR', this.CYR],
            ['MASS', this.MASS],['WAD', this.WAD],['CHO', this.CHO],
            ['ADTM', this.ADTM],['HSL', this.HSL],['BIAS36', this.BIAS36],
            ['BIAS_QL', this.BIAS_QL],['DPO', this.DPO],['OSC', this.OSC],
            ['ATR', this.ATR],['NVI', this.NVI],['PVI', this.PVI],
            ['UOS', this.UOS],['CYW', this.CYW],['LON', this.LON],
            ['NDB', this.NDB],['SKDJ',this.SKDJ],['KD',this.KD],['FKX',this.FKX],
            ['DKCOL',this.DKCOL],['UDL',this.UDL],['MFI',this.MFI],['LWR',this.LWR],
            ['MARSI',this.MARSI],['CYD',this.CYD],['CYF',this.CYF],['TAPI',this.TAPI],
            ['VMACD',this.VMACD],['QACD',this.QACD],['VPT',this.VPT],['WVAD',this.WVAD],
            ['DBQR',this.DBQR],['JS',this.JS],['CYE',this.CYE],['QR',this.QR],['GDX',this.GDX],
            ['JLHB',this.JLHB],['PCNT',this.PCNT],['BTX', this.BTX],['AMO',this.AMO],
            ['VRSI',this.VRSI],['HSCOL',this.HSCOL],['DBQRV',this.DBQRV],['DBLB',this.DBLB],
            ['ACD',this.ACD],['EXPMA',this.EXPMA],['EXPMA_S',this.EXPMA_S],['HMA',this.HMA],
            ['LMA',this.LMA],['VMA',this.VMA],['AMV',this.AMV],['BBIBOLL',this.BBIBOLL],
            ['ALLIGAT',this.ALLIGAT],['ZX',this.ZX],['XS',this.XS],['XS2',this.XS2],
            ['SG-XDT',this.SG_XDT],['SG-SMX',this.SG_SMX],['SG-LB',this.SG_LB],['SG-PF',this.SG_PF],
            ['RAD',this.RAD],['SHT',this.SHT],['ZLJC',this.ZLJC],['ZLMM',this.ZLMM],['SLZT',this.SLZT],
            ['ADVOL',this.ADVOL],['CYC',this.CYC],['CYS',this.CYS],['CYQKL',this.CYQKL],
            ['SCR',this.SCR],['ASR',this.ASR],['SAR',this.SAR],['TJCJL',this.TJCJL],['量比',this.VOLRate],
            ['平均K线',this.HeikinAshi], ["ADL", this.ADL],["SQJZ", this.SQJZ],["XT", this.XT],["CFJT", this.CFJT],["CYX",this.CYX],
            ["WAVE",this.WAVE],
            ['VOL-TDX',this.VOL_TDX],
            ['EMPTY', this.EMPTY],  //什么都不显示的指标
            ['神奇九转', this.NineTurns],

            //通达信特色指标
            ["散户线", this.ShareholderCount],["NXTS", this.NXTS],["FKX", this.FKX],["两融资金", this.Margin4],
            ["ZSDB",this.ZSDB],

            ['CJL2', this.CJL],  //期货持仓量
            ['ASI', this.ASI],['DC', this.DC],['DEMA', this.DEMA],["VWAP", this.VWAP],

            ['飞龙四式', this.Dragon4_Main],['飞龙四式-附图', this.Dragon4_Fig],
            ['资金分析', this.FundsAnalysis],['融资占比',this.MarginProportion],['负面新闻', this.NewsNegative],
            ['涨跌趋势', this.UpDownAnalyze],['北上资金', this.HK2SHSZ],['股东人数', this.ShareHolder],

            ["两融余额", this.Margin2],["两融余额2", this.Margin3],

            ['Zealink-资金吸筹', this.Zealink_Index1], ['Zealink-牛熊区间', this.Zealink_Index2],['Zealink-持仓信号', this.Zealink_Index3],
            ['Zealink-增减持',this.Zealink_Index4],['Zealink-大宗交易', this.Zealink_Index5], ['Zealink-信托持股', this.Zealink_Index6],
            ['Zealink-官网新闻', this.Zealink_Index7], ['Zealink-高管要闻', this.Zealink_Index8],['Zealink-股权质押', this.Zealink_Index9],
            ['Zealink-操盘BS点', this.Zealink_Index10],['Zealink-操盘BS点2', this.Zealink_Index11],
            
            //外包指标
            ['放心股-操盘BS点',this.FXG_BSPoint],
            ['放心股-涨停多空线',this.FXG_INDEX],
            ['放心股-涨停吸筹区',this.FXG_INDEX2],
            ['放心股-量能黄金点',this.FXG_INDEX3],

            //五彩K线(函数COLOR_开头)
            ['五彩K线-十字星',this.COLOR_KSTAR1],['五彩K线-早晨之星',this.COLOR_KSTAR2],['五彩K线-黄昏之星',this.COLOR_KSTAR3],['五彩K线-长十字',this.COLOR_SHI1],
            ['五彩K线-身怀六甲',this.COLOR_K220],['五彩K线-三个白武士',this.COLOR_K300],['五彩K线-三只乌鸦',this.COLOR_K310],['五彩K线-光头阳线',this.COLOR_K380],
            ['五彩K线-光脚阴线',this.COLOR_K390],['五彩K线-垂死十字',this.COLOR_K134],['五彩K线-早晨十字星',this.COLOR_K140],['五彩K线-黄昏十字星',this.COLOR_K150],
            ['五彩K线-射击之星',this.COLOR_K160],['五彩K线-倒转锤头',this.COLOR_K165],['五彩K线-锤头',this.COLOR_K170],['五彩K线-吊颈',this.COLOR_K180],
            ['五彩K线-穿头破脚',this.COLOR_K190],['五彩K线-出水芙蓉',this.COLOR_CSFR],['五彩K线-乌云盖顶',this.COLOR_WYGD],['五彩K线-曙光初现',this.COLOR_SGCJ],
            ['五彩K线-十字胎',this.COLOR_SZTAI],['五彩K线-剑',this.COLOR_SWORD],['五彩K线-平顶',this.COLOR_PINGDING],['五彩K线-平底',this.COLOR_PINGDI],
            ['五彩K线-大阳烛',this.COLOR_DAYANZHU],['五彩K线-大阴烛',this.COLOR_DAYINGZHU],
            
            ['五彩K线-好友反攻',this.COLOR_HYFG],['五彩K线-跳空缺口',this.COLOR_TKQK],
            ['五彩K线-双飞乌鸦',this.COLOR_SFWY],['五彩K线-上升三部曲',this.COLOR_SSSBQ],['五彩K线-下跌三部曲',this.COLOR_XDSBQ],['五彩K线-长下影',this.COLOR_CHXY],
            ['五彩K线-长上影',this.COLOR_CHSY],['五彩K线-分离',this.COLOR_FENLI],

            //交易系统
            ['交易系统-BIAS',this.TRADE_BIAS],['交易系统-CCI',this.TRADE_CCI],['交易系统-DMI',this.TRADE_DMI],['交易系统-KD',this.TRADE_KD],
            ['交易系统-BOLL',this.TRADE_BOLL],['交易系统-KDJ',this.TRADE_KDJ],['交易系统-MA',this.TRADE_MA],['交易系统-MACD',this.TRADE_MACD],
            ['交易系统-MTM',this.TRADE_MTM],['交易系统-PSY',this.TRADE_PSY],['交易系统-ROC',this.TRADE_ROC],['交易系统-RSI',this.TRADE_RSI],
            ['交易系统-VR',this.TRADE_VR],['交易系统-DPSJ',this.TRADE_DPSJ],

            ['TEST', this.TEST] //测试用
        ]);
}

JSIndexScript.AddIndex=function(aryIndex)  //添加自定义指标
{
    for(var i in aryIndex)
    {
        g_CustomIndex.Add(aryIndex[i]);
    }
}

JSIndexScript.prototype.Get=function(id)
{
    var data=g_CustomIndex.Get(id);
    if (data) return data;

    var func=this.DataMap.get(id);
    if (func) return func();

    return null;
}

JSIndexScript.prototype.Search=function(name)
{
    var result=[];
    var reg = new RegExp(name,'i');
    this.DataMap.forEach(function(value,key)
    {
        if (key.indexOf('交易系统-')!=0 && key.indexOf('五彩K线-')!=0  && key.search(reg)>=0) 
            result.push(key);
    });

    return result;
}

JSIndexScript.prototype.MA=function()
{
    let data=
    {
        Name:'MA', Description:'均线', IsMainIndex:true, StringFormat:2,
        Args:[ { Name:'M1', Value:5}, { Name:'M2', Value:10 }, { Name:'M3', Value:20} ],
        OutName:[ {Name:'MA1',DynamicName:"MA{M1}" },  {Name:'MA2',DynamicName:"MA{M2}" },{Name:'MA3',DynamicName:"MA{M3}" }],
        Script: //脚本
'MA1:MA(CLOSE,M1);\n\
MA2:MA(CLOSE,M2);\n\
MA3:MA(CLOSE,M3);'

    };

    return data;
}

JSIndexScript.prototype.MA4=function()
{
    let data=
    {
        Name:'MA', Description:'均线', IsMainIndex:true, StringFormat:2,
        Args:[ { Name:'M1', Value:5}, { Name:'M2', Value:10 }, { Name:'M3', Value:20},{ Name:'M4', Value:60} ],
        OutName:[ {Name:'MA1',DynamicName:"MA{M1}" },  {Name:'MA2',DynamicName:"MA{M2}" },{Name:'MA3',DynamicName:"MA{M3}" },{Name:'MA4',DynamicName:"MA{M4}" } ],
        Script: //脚本
'MA1:MA(CLOSE,M1);\n\
MA2:MA(CLOSE,M2);\n\
MA3:MA(CLOSE,M3);\n\
MA4:MA(CLOSE,M4);'

    };

    return data;
}

JSIndexScript.prototype.MA5=function()
{
    let data=
    {
        Name:'MA', Description:'均线', IsMainIndex:true, StringFormat:2,
        Args:[ { Name:'M1', Value:5}, { Name:'M2', Value:10 }, { Name:'M3', Value:20} ,{ Name:'M4', Value:60} ,{ Name:'M5', Value:0}],
        OutName:[ {Name:'MA1',DynamicName:"MA{M1}" },  {Name:'MA2',DynamicName:"MA{M2}" },{Name:'MA3',DynamicName:"MA{M3}" },{Name:'MA4',DynamicName:"MA{M4}" },{Name:'MA5',DynamicName:"MA{M5}" } ],
        Script: //脚本
'MA1:MA(CLOSE,M1);\n\
MA2:MA(CLOSE,M2);\n\
MA3:MA(CLOSE,M3);\n\
MA4:MA(CLOSE,M4);\n\
MA5:MA(CLOSE,M5);'

    };

    return data;
}

JSIndexScript.prototype.MA6=function()
{
    let data=
    {
        Name:'MA', Description:'均线', IsMainIndex:true, StringFormat:2,
        Args:
        [ 
            { Name:'M1', Value:5}, { Name:'M2', Value:10 }, { Name:'M3', Value:20} , { Name:'M4', Value:60} ,
            { Name:'M5', Value:0},{ Name:'M6', Value:0}
        ],
        OutName:[ {Name:'MA1',DynamicName:"MA{M1}" },  {Name:'MA2',DynamicName:"MA{M2}" },{Name:'MA3',DynamicName:"MA{M3}" },{Name:'MA4',DynamicName:"MA{M4}" },
        {Name:'MA5',DynamicName:"MA{M5}" } ,{ Name:'MA6',DynamicName:"MA{M6}" } ],
        Script: //脚本
'MA1:MA(CLOSE,M1);\n\
MA2:MA(CLOSE,M2);\n\
MA3:MA(CLOSE,M3);\n\
MA4:MA(CLOSE,M4);\n\
MA5:MA(CLOSE,M5);\n\
MA6:MA(CLOSE,M6);'

    };

    return data;
}

JSIndexScript.prototype.MA7=function()
{
    let data=
    {
        Name:'MA', Description:'均线', IsMainIndex:true, StringFormat:2,
        Args:
        [ 
            { Name:'M1', Value:5}, { Name:'M2', Value:10 }, { Name:'M3', Value:20}, { Name:'M4', Value:60},
            { Name:'M5', Value:0},{ Name:'M6', Value:0} ,{ Name:'M7', Value:0 } 
        ],
        OutName:[ {Name:'MA1',DynamicName:"MA{M1}" },  {Name:'MA2',DynamicName:"MA{M2}" },{Name:'MA3',DynamicName:"MA{M3}" },{Name:'MA4',DynamicName:"MA{M4}" },
        {Name:'MA5',DynamicName:"MA{M5}" } ,{ Name:'MA6',DynamicName:"MA{M6}" } ,{ Name:'MA7',DynamicName:"MA{M7}" }],
        Script: //脚本
'MA1:MA(CLOSE,M1);\n\
MA2:MA(CLOSE,M2);\n\
MA3:MA(CLOSE,M3);\n\
MA4:MA(CLOSE,M4);\n\
MA5:MA(CLOSE,M5);\n\
MA6:MA(CLOSE,M6);\n\
MA7:MA(CLOSE,M7);'

    };

    return data;
}

JSIndexScript.prototype.MA8=function()
{
    let data=
    {
        Name:'MA', Description:'均线', IsMainIndex:true, StringFormat:2,
        Args:
        [ 
            { Name:'M1', Value:5}, { Name:'M2', Value:10 }, { Name:'M3', Value:20}, { Name:'M4', Value:60},
            { Name:'M5', Value:0},{ Name:'M6', Value:0} ,{ Name:'M7', Value:0 } ,{ Name:'M8', Value:0 } 
        ],
        OutName:[ {Name:'MA1',DynamicName:"MA{M1}" },  {Name:'MA2',DynamicName:"MA{M2}" },{Name:'MA3',DynamicName:"MA{M3}" },{Name:'MA4',DynamicName:"MA{M4}" },
        {Name:'MA5',DynamicName:"MA{M5}" } ,{ Name:'MA6',DynamicName:"MA{M6}" } ,{ Name:'MA7',DynamicName:"MA{M7}" },{ Name:'MA8',DynamicName:"MA{M8}" }],
        Script: //脚本
'MA1:MA(CLOSE,M1);\n\
MA2:MA(CLOSE,M2);\n\
MA3:MA(CLOSE,M3);\n\
MA4:MA(CLOSE,M4);\n\
MA5:MA(CLOSE,M5);\n\
MA6:MA(CLOSE,M6);\n\
MA7:MA(CLOSE,M7);\n\
MA8:MA(CLOSE,M8);'

    };

    return data;
}

JSIndexScript.prototype.BOLL=function()
{
    let data=
    {
        Name:'BOLL', Description:'布林线', IsMainIndex:true,
        Args:[ { Name:'M', Value:20} ],
        Script: //脚本
'BOLL:MA(CLOSE,M);\n\
UB:BOLL+2*STD(CLOSE,M);\n\
LB:BOLL-2*STD(CLOSE,M);'

    };

    return data;
}

JSIndexScript.prototype.BOLL2=function()
{
    let data=
    {
        Name:'BOLL2', Description:'布林线', IsMainIndex:false, KLineType:0,
        Args:[ { Name:'M', Value:20} ],
        Script: //脚本
'BOLL:MA(CLOSE,M);\n\
UB:BOLL+2*STD(CLOSE,M);\n\
LB:BOLL-2*STD(CLOSE,M);'

    };

    return data;
}


JSIndexScript.prototype.BBI=function()
{
    let data=
    {
        Name:'BBI', Description:'多空均线', IsMainIndex:true,
        Args:[ { Name:'M1', Value:3}, { Name:'M2', Value:6}, { Name:'M3', Value:12}, { Name:'M4', Value:24} ],
        Script: //脚本
        'BBI:(MA(CLOSE,M1)+MA(CLOSE,M2)+MA(CLOSE,M3)+MA(CLOSE,M4))/4;'

    };

    return data;
}


JSIndexScript.prototype.DKX=function()
{
    let data=
    {
        Name:'DKX', Description:'多空线', IsMainIndex:false,
        Args:[ { Name:'M', Value:10} ],
        Script: //脚本
'MID:=(3*CLOSE+LOW+OPEN+HIGH)/6;\n\
DKX:(20*MID+19*REF(MID,1)+18*REF(MID,2)+17*REF(MID,3)+\n\
16*REF(MID,4)+15*REF(MID,5)+14*REF(MID,6)+\n\
13*REF(MID,7)+12*REF(MID,8)+11*REF(MID,9)+\n\
10*REF(MID,10)+9*REF(MID,11)+8*REF(MID,12)+\n\
7*REF(MID,13)+6*REF(MID,14)+5*REF(MID,15)+\n\
4*REF(MID,16)+3*REF(MID,17)+2*REF(MID,18)+REF(MID,20))/210;\n\
MADKX:MA(DKX,M);'

    };

    return data;
}

JSIndexScript.prototype.MIKE=function()
{
    let data=
    {
        Name:'MIKE', Description:'麦克支撑压力', IsMainIndex:true,
        Args:[ { Name:'N', Value:10} ],
        Script: //脚本
'HLC:=REF(MA((HIGH+LOW+CLOSE)/3,N),1);\n\
HV:=EMA(HHV(HIGH,N),3);\n\
LV:=EMA(LLV(LOW,N),3);\n\
STOR:EMA(2*HV-LV,3);\n\
MIDR:EMA(HLC+HV-LV,3);\n\
WEKR:EMA(HLC*2-LV,3);\n\
WEKS:EMA(HLC*2-HV,3);\n\
MIDS:EMA(HLC-HV+LV,3);\n\
STOS:EMA(2*LV-HV,3);'

    };

    return data;
}

JSIndexScript.prototype.PBX=function()
{
    let data=
    {
        Name:'PBX', Description:'瀑布线', IsMainIndex:true,
        Args:[ { Name:'M1', Value:4}, { Name:'M2', Value:6}, { Name:'M3', Value:9}, { Name:'M4', Value:13},{ Name:'M5', Value:18},{ Name:'M6', Value:24} ],
        Script: //脚本
'PBX1:(EMA(CLOSE,M1)+MA(CLOSE,M1*2)+MA(CLOSE,M1*4))/3;\n\
PBX2:(EMA(CLOSE,M2)+MA(CLOSE,M2*2)+MA(CLOSE,M2*4))/3;\n\
PBX3:(EMA(CLOSE,M3)+MA(CLOSE,M3*2)+MA(CLOSE,M3*4))/3;\n\
PBX4:(EMA(CLOSE,M4)+MA(CLOSE,M4*2)+MA(CLOSE,M4*4))/3;\n\
PBX5:(EMA(CLOSE,M5)+MA(CLOSE,M5*2)+MA(CLOSE,M5*4))/3;\n\
PBX6:(EMA(CLOSE,M6)+MA(CLOSE,M6*2)+MA(CLOSE,M6*4))/3;'

    };

    return data;
}

JSIndexScript.prototype.ENE=function()
{
    let data=
    {
        Name:'ENE', Description:'轨道线', IsMainIndex:true,
        Args:[ { Name:'N', Value:25}, { Name:'M1', Value:6}, { Name:'M2', Value:6} ],
        Script: //脚本
'UPPER:(1+M1/100)*MA(CLOSE,N);\n\
LOWER:(1-M2/100)*MA(CLOSE,N);\n\
ENE:(UPPER+LOWER)/2;'

    };

    return data;
}

JSIndexScript.prototype.MACD=function()
{
    let data=
    {
        Name:'MACD', Description:'平滑异同平均', IsMainIndex:false,
        Args:[ { Name:'SHORT', Value:12}, { Name:'LONG', Value:26}, { Name:'MID', Value:9} ],
        Script: //脚本
'DIF:EMA(CLOSE,SHORT)-EMA(CLOSE,LONG);\n\
DEA:EMA(DIF,MID);\n\
MACD:(DIF-DEA)*2,COLORSTICK;'

    };

    return data;
}

//上下柱子
JSIndexScript.prototype.MACD2=function()
{
    let data=
    {
        Name:'MACD', Description:'平滑异同平均', IsMainIndex:false,
        Args:[ { Name:'SHORT', Value:12}, { Name:'LONG', Value:26}, { Name:'MID', Value:9} ],
        Script: //脚本
'DIF2:=EMA(CLOSE,SHORT)-EMA(CLOSE,LONG);\n\
DEA2:=EMA(DIF2,MID);\n\
MACD:(DIF2-DEA2)*2,COLORSTICK,LINETHICK50;\n\
DIF:DIF2;\n\
DEA:DEA2;'

    };

    return data;
}

JSIndexScript.prototype.KDJ=function()
{
    let data=
    {
        Name:'KDJ', Description:'随机指标', IsMainIndex:false,
        Args:[ { Name:'N', Value:9}, { Name:'M1', Value:3}, { Name:'M2', Value:3} ],
        Script: //脚本
'RSV:=(CLOSE-LLV(LOW,N))/(HHV(HIGH,N)-LLV(LOW,N))*100;\n\
K:SMA(RSV,M1,1);\n\
D:SMA(K,M2,1);\n\
J:3*K-2*D;'

    };

    return data;
}

JSIndexScript.prototype.VOL=function()
{
    let data=
    {
        Name:'VOL', Description:'成交量', IsMainIndex:false,FloatPrecision:0,
        Args:[ { Name:'M1', Value:5}, { Name:'M2', Value:10} ],
        OutName:[ {Name:'MA1',DynamicName:"MA{M1}" },  {Name:'MA2',DynamicName:"MA{M2}" }],
        Script: //脚本
'VOL:VOL,VOLSTICK;\n\
MA1:MA(VOL,M1);\n\
MA2:MA(VOL,M2);'

    };

    return data;
}

JSIndexScript.prototype.VOL_TDX=function()
{
    let data=
    {
        Name:'VOL-TDX', Description:'成交量(虚拟)', IsMainIndex:false,FloatPrecision:0,
        Args:[ { Name:'M1', Value:5}, { Name:'M2', Value:10} ],
        Script: //脚本
'TOTAL:=IF(PERIOD=1,5,IF(PERIOD=2,15,IF(PERIOD=3,30,IF(PERIOD=4,60,IF(PERIOD=5,TOTALFZNUM,1)))));\n\
MTIME:=MOD(FROMOPEN,TOTAL);\n\
CTIME:=IF(MTIME<0.5,TOTAL,MTIME);\n\
VVOL:IF((CURRBARSCOUNT=1 AND DYNAINFO(8)>1),VOL*(TOTAL+3)/(CTIME+3),DRAWNULL),NODRAW;\n\
STICKLINE((CURRBARSCOUNT=1 AND DYNAINFO(8)>1),VVOL,0,-1,-1),COLORYELLOW;\n\
VOLUME:VOL,VOLSTICK;\n\
MAVOL1:MA(VOLUME,M1);\n\
MAVOL2:MA(VOLUME,M2);'

    };

    return data;
}

JSIndexScript.prototype.RSI=function()
{
    let data=
    {
        Name:'RSI', Description:'相对强弱指标', IsMainIndex:false,
        Args:[ { Name:'N1', Value:6}, { Name:'N2', Value:12}, { Name:'N3', Value:24}  ],
        Script: //脚本
'LC:=REF(CLOSE,1);\n\
RSI1:SMA(MAX(CLOSE-LC,0),N1,1)/SMA(ABS(CLOSE-LC),N1,1)*100;\n\
RSI2:SMA(MAX(CLOSE-LC,0),N2,1)/SMA(ABS(CLOSE-LC),N2,1)*100;\n\
RSI3:SMA(MAX(CLOSE-LC,0),N3,1)/SMA(ABS(CLOSE-LC),N3,1)*100;'

    };

    return data;
}

JSIndexScript.prototype.BRAR=function()
{
    let data=
    {
        Name:'BRAR', Description:'情绪指标', IsMainIndex:false,
        Args:[ { Name:'N', Value:26} ],
        Script: //脚本
'BR:SUM(MAX(0,HIGH-REF(CLOSE,1)),N)/SUM(MAX(0,REF(CLOSE,1)-LOW),N)*100;\n\
AR:SUM(HIGH-OPEN,N)/SUM(OPEN-LOW,N)*100;'

    };

    return data;
}

JSIndexScript.prototype.WR=function()
{
    let data=
    {
        Name:'WR', Description:'威廉指标', IsMainIndex:false,
        Args:[ { Name:'N', Value:10}, { Name:'N1', Value:6} ],
        Script: //脚本
'WR1:100*(HHV(HIGH,N)-CLOSE)/(HHV(HIGH,N)-LLV(LOW,N));\n\
WR2:100*(HHV(HIGH,N1)-CLOSE)/(HHV(HIGH,N1)-LLV(LOW,N1));'

    };

    return data;
}

JSIndexScript.prototype.BIAS=function()
{
    let data=
    {
        Name:'BIAS', Description:'乖离率', IsMainIndex:false,
        Args:[ { Name:'N1', Value:6}, { Name:'N2', Value:12}, { Name:'N3', Value:24} ],
        Script: //脚本
'BIAS1 :(CLOSE-MA(CLOSE,N1))/MA(CLOSE,N1)*100;\n\
BIAS2 :(CLOSE-MA(CLOSE,N2))/MA(CLOSE,N2)*100;\n\
BIAS3 :(CLOSE-MA(CLOSE,N3))/MA(CLOSE,N3)*100;'

    };

    return data;
}

JSIndexScript.prototype.OBV=function()
{
    let data=
    {
        Name:'OBV', Description:'累积能量线', IsMainIndex:false,
        Args:[ { Name:'M', Value:30} ],
        Script: //脚本
'VA:=IF(CLOSE>REF(CLOSE,1),VOL,-VOL);\n\
OBV:SUM(IF(CLOSE==REF(CLOSE,1),0,VA),0);\n\
MAOBV:MA(OBV,M);'

    };

    return data;
}

JSIndexScript.prototype.DMI=function()
{
    let data=
    {
        Name:'DMI', Description:'趋向指标', IsMainIndex:false,
        Args:[ { Name:'N', Value:14}, { Name:'MM', Value:6} ],
        Script: //脚本
'MTR:=EXPMEMA(MAX(MAX(HIGH-LOW,ABS(HIGH-REF(CLOSE,1))),ABS(REF(CLOSE,1)-LOW)),N);\n\
HD :=HIGH-REF(HIGH,1);\n\
LD :=REF(LOW,1)-LOW;\n\
DMP:=EXPMEMA(IF(HD>0&&HD>LD,HD,0),N);\n\
DMM:=EXPMEMA(IF(LD>0&&LD>HD,LD,0),N);\n\
PDI: DMP*100/MTR;\n\
MDI: DMM*100/MTR;\n\
ADX: EXPMEMA(ABS(MDI-PDI)/(MDI+PDI)*100,MM);\n\
ADXR:EXPMEMA(ADX,MM);'

    };

    return data;
}

JSIndexScript.prototype.CR=function()
{
    let data=
    {
        Name:'CR', Description:'带状能量线', IsMainIndex:false,
        Args:[ { Name:'N', Value:26}, { Name:'M1', Value:10},{ Name:'M2', Value:20},{ Name:'M3', Value:40},{ Name:'M4', Value:62} ],
        Script: //脚本
'MID:=REF(HIGH+LOW,1)/2;\n\
CR:SUM(MAX(0,HIGH-MID),N)/SUM(MAX(0,MID-LOW),N)*100;\n\
MA1:REF(MA(CR,M1),M1/2.5+1);\n\
MA2:REF(MA(CR,M2),M2/2.5+1);\n\
MA3:REF(MA(CR,M3),M3/2.5+1);\n\
MA4:REF(MA(CR,M4),M4/2.5+1);'

    };

    return data;
}

JSIndexScript.prototype.PSY=function()
{
    let data=
    {
        Name:'PSY', Description:'心理线', IsMainIndex:false,
        Args:[ { Name:'N', Value:12}, { Name:'M', Value:6} ],
        Script: //脚本
'PSY:COUNT(CLOSE>REF(CLOSE,1),N)/N*100;\r\
PSYMA:MA(PSY,M);'

    };

    return data;
}

JSIndexScript.prototype.CCI=function()
{
    let data=
    {
        Name:'CCI', Description:'商品路径指标', IsMainIndex:false,
        Args:[ { Name:'N', Value:14} ],
        Script: //脚本
'TYP:=(HIGH+LOW+CLOSE)/3;\n\
CCI:(TYP-MA(TYP,N))/(0.015*AVEDEV(TYP,N));'

    };

    return data;
}

JSIndexScript.prototype.DMA=function()
{
    let data=
    {
        Name:'DMA', Description:'平均差', IsMainIndex:false,
        Args:[ { Name:'N1', Value:10},{ Name:'N2', Value:50},{ Name:'M', Value:10} ],
        Script: //脚本
'DIF:MA(CLOSE,N1)-MA(CLOSE,N2);\n\
DIFMA:MA(DIF,M);'

    };

    return data;
}

JSIndexScript.prototype.TRIX=function()
{
    let data=
    {
        Name:'TRIX', Description:'三重指数平均线', IsMainIndex:false,
        Args:[ { Name:'N', Value:12},{ Name:'M', Value:9} ],
        Script: //脚本
'MTR:=EMA(EMA(EMA(CLOSE,N),N),N);\n\
TRIX:(MTR-REF(MTR,1))/REF(MTR,1)*100;\n\
MATRIX:MA(TRIX,M) ;'

    };

    return data;
}

JSIndexScript.prototype.VR=function()
{
    let data=
    {
        Name:'VR', Description:'成交量变异率', IsMainIndex:false,
        Args:[ { Name:'N', Value:26},{ Name:'M', Value:6} ],
        Script: //脚本
'TH:=SUM(IF(CLOSE>REF(CLOSE,1),VOL,0),N);\n\
TL:=SUM(IF(CLOSE<REF(CLOSE,1),VOL,0),N);\n\
TQ:=SUM(IF(CLOSE==REF(CLOSE,1),VOL,0),N);\n\
VR:100*(TH*2+TQ)/(TL*2+TQ);\n\
MAVR:MA(VR,M);'

    };

    return data;
}

JSIndexScript.prototype.EMV=function()
{
    let data=
    {
        Name:'EMV', Description:'简易波动指标', IsMainIndex:false,
        Args:[ { Name:'N', Value:14},{ Name:'M', Value:9} ],
        Script: //脚本
'VOLUME:=MA(VOL,N)/VOL;\n\
MID:=100*(HIGH+LOW-REF(HIGH+LOW,1))/(HIGH+LOW);\n\
EMV:MA(MID*VOLUME*(HIGH-LOW)/MA(HIGH-LOW,N),N);\n\
MAEMV:MA(EMV,M);'

    };

    return data;
}

JSIndexScript.prototype.ROC=function()
{
    let data=
    {
        Name:'ROC', Description:'变动率指标', IsMainIndex:false,
        Args:[ { Name:'N', Value:12},{ Name:'M', Value:6} ],
        Script: //脚本
'ROC:100*(CLOSE-REF(CLOSE,N))/REF(CLOSE,N);\n\
MAROC:MA(ROC,M);'

    };

    return data;
}

JSIndexScript.prototype.MTM=function()
{
    let data=
    {
        Name:'MTM', Description:'动量线', IsMainIndex:false,
        Args:[ { Name:'N', Value:12},{ Name:'M', Value:6} ],
        Script: //脚本
'MTM:CLOSE-REF(CLOSE,N);\n\
MAMTM:MA(MTM,M);'

    };

    return data;
}

JSIndexScript.prototype.FSL=function()
{
    let data=
    {
        Name:'FSL', Description:'分水岭', IsMainIndex:false,
        Args:[ ],
        Script: //脚本
'SWL:(EMA(CLOSE,5)*7+EMA(CLOSE,10)*3)/10;\n\
SWS:DMA(EMA(CLOSE,12),MAX(1,100*(SUM(VOL,5)/(3*CAPITAL))));'

    };

    return data;
}

JSIndexScript.prototype.CYR=function()
{
    let data=
    {
        Name:'CYR', Description:'市场强弱', IsMainIndex:false,
        Args:[ { Name:'N', Value:13},{ Name:'M', Value:5}],
        Script: //脚本
'DIVE:=0.01*EMA(AMOUNT,N)/EMA(VOL,N);\n\
CYR:(DIVE/REF(DIVE,1)-1)*100;\n\
MACYR:MA(CYR,M);'

    };

    return data;
}

JSIndexScript.prototype.MASS=function()
{
    let data=
    {
        Name:'MASS', Description:'市场强弱', IsMainIndex:false,
        Args:[ { Name:'N1', Value:9},{ Name:'N2', Value:25}, { Name:'M', Value:6}],
        Script: //脚本
'MASS:SUM(MA(HIGH-LOW,N1)/MA(MA(HIGH-LOW,N1),N1),N2);\n\
MAMASS:MA(MASS,M);'

    };

    return data;
}

JSIndexScript.prototype.WAD=function()
{
    let data=
    {
        Name:'WAD', Description:'威廉多空力度线', IsMainIndex:false,
        Args:[ { Name:'M', Value:30}],
        Script: //脚本
'MIDA:=CLOSE-MIN(REF(CLOSE,1),LOW);\n\
MIDB:=IF(CLOSE<REF(CLOSE,1),CLOSE-MAX(REF(CLOSE,1),HIGH),0);\n\
WAD:SUM(IF(CLOSE>REF(CLOSE,1),MIDA,MIDB),0);\n\
MAWAD:MA(WAD,M);'

    };

    return data;
}

JSIndexScript.prototype.CHO=function()
{
    let data=
    {
        Name:'CHO', Description:'佳庆指标', IsMainIndex:false,
        Args:[ { Name:'N1', Value:10}, { Name:'N2', Value:20}, { Name:'M', Value:6}],
        Script: //脚本
'MID:=SUM(VOL*(2*CLOSE-HIGH-LOW)/(HIGH+LOW),0);\n\
CHO:MA(MID,N1)-MA(MID,N2);\n\
MACHO:MA(CHO,M);'

    };

    return data;
}

JSIndexScript.prototype.ADTM=function()
{
    let data=
    {
        Name:'ADTM', Description:'动态买卖气指标', IsMainIndex:false,
        Args:[ { Name:'N', Value:23}, { Name:'M', Value:8}],
        Script: //脚本
'DTM:=IF(OPEN<=REF(OPEN,1),0,MAX((HIGH-OPEN),(OPEN-REF(OPEN,1))));\n\
DBM:=IF(OPEN>=REF(OPEN,1),0,MAX((OPEN-LOW),(OPEN-REF(OPEN,1))));\n\
STM:=SUM(DTM,N);\n\
SBM:=SUM(DBM,N);\n\
ADTM:IF(STM>SBM,(STM-SBM)/STM,IF(STM==SBM,0,(STM-SBM)/SBM));\n\
MAADTM:MA(ADTM,M);'

    };

    return data;
}

JSIndexScript.prototype.HSL=function()
{
    let data=
    {
        Name:'HSL', Description:'换手线', IsMainIndex:false,
        Args:[ { Name:'N', Value:5} ],
        Script: //脚本
'HSL:IF((SETCODE==0||SETCODE==1),100*VOL,VOL)/(FINANCE(7)/100);\n\
MAHSL:MA(HSL,N);'

    };

    return data;
}

JSIndexScript.prototype.BIAS36=function()
{
    let data=
    {
        Name:'BIAS36', Description:'三六乖离', IsMainIndex:false,
        Args:[ { Name:'M', Value:6} ],
        Script: //脚本
'BIAS36:MA(CLOSE,3)-MA(CLOSE,6);\n\
BIAS612:MA(CLOSE,6)-MA(CLOSE,12);\n\
MABIAS:MA(BIAS36,M);'

    };

    return data;
}

JSIndexScript.prototype.BIAS_QL=function()
{
    let data=
    {
        Name:'BIAS_QL', Description:'乖离率-传统版', IsMainIndex:false,
        Args:[ { Name:'N', Value:6}, { Name:'M', Value:6} ],
        Script: //脚本
'BIAS :(CLOSE-MA(CLOSE,N))/MA(CLOSE,N)*100;\n\
BIASMA :MA(BIAS,M);'

    };

    return data;
}

JSIndexScript.prototype.DPO=function()
{
    let data=
    {
        Name:'DPO', Description:'区间震荡线', IsMainIndex:false,
        Args:[ { Name:'N', Value:20}, { Name:'M', Value:6} ],
        Script: //脚本
'DPO:CLOSE-REF(MA(CLOSE,N),N/2+1);\n\
MADPO:MA(DPO,M);'

    };

    return data;
}

JSIndexScript.prototype.OSC=function()
{
    let data=
    {
        Name:'OSC', Description:'变动速率线', IsMainIndex:false,
        Args:[ { Name:'N', Value:20}, { Name:'M', Value:6} ],
        Script: //脚本
'OSC:100*(CLOSE-MA(CLOSE,N));\n\
MAOSC:EXPMEMA(OSC,M);'

    };

    return data;
}

JSIndexScript.prototype.ATR=function()
{
    let data=
    {
        Name:'ATR', Description:'真实波幅', IsMainIndex:false,
        Args:[ { Name:'N', Value:14}],
        Script: //脚本
'MTR:MAX(MAX((HIGH-LOW),ABS(REF(CLOSE,1)-HIGH)),ABS(REF(CLOSE,1)-LOW));\n\
ATR:MA(MTR,N);'

    };

    return data;
}

JSIndexScript.prototype.NVI=function()
{
    let data=
    {
        Name:'ATR', Description:'负成交量', IsMainIndex:false,
        Args:[ { Name:'N', Value:72} ],
        Script: //脚本
'NVI:100*MULAR(IF(V<REF(V,1),C/REF(C,1),1),0);\n\
MANVI:MA(NVI,N);'

    };

    return data;
}

JSIndexScript.prototype.PVI=function()
{
    let data=
    {
        Name:'PVI', Description:'正成交量', IsMainIndex:false,
        Args:[ { Name:'N', Value:72} ],
        Script: //脚本
'NVI:100*MULAR(IF(V>REF(V,1),C/REF(C,1),1),0);\n\
MANVI:MA(NVI,N);'

    };

    return data;
}

JSIndexScript.prototype.UOS=function()
{
    let data=
    {
        Name:'UOS', Description:'终极指标', IsMainIndex:false,
        Args:[ { Name:'N1', Value:7} ,{ Name:'N2', Value:14},{ Name:'N3', Value:28},{ Name:'M', Value:6}],
        Script: //脚本
'TH:=MAX(HIGH,REF(CLOSE,1));\n\
TL:=MIN(LOW,REF(CLOSE,1));\n\
ACC1:=SUM(CLOSE-TL,N1)/SUM(TH-TL,N1);\n\
ACC2:=SUM(CLOSE-TL,N2)/SUM(TH-TL,N2);\n\
ACC3:=SUM(CLOSE-TL,N3)/SUM(TH-TL,N3);\n\
UOS:(ACC1*N2*N3+ACC2*N1*N3+ACC3*N1*N2)*100/(N1*N2+N1*N3+N2*N3);\n\
MAUOS:EXPMEMA(UOS,M);'

    };

    return data;
}

JSIndexScript.prototype.CYW=function()
{
    let data=
    {
        Name:'CYW', Description:'主力控盘', IsMainIndex:false,
        Args:[ ],
        Script: //脚本
'VAR1:=CLOSE-LOW;\n\
VAR2:=HIGH-LOW;\n\
VAR3:=CLOSE-HIGH;\n\
VAR4:=IF(HIGH>LOW,(VAR1/VAR2+VAR3/VAR2)*VOL,0);\n\
CYW: SUM(VAR4,10)/10000, COLORSTICK;'

    };

    return data;
}

JSIndexScript.prototype.LON=function()
{
    let data=
    {
        Name:'LON', Description:'龙系长线', IsMainIndex:false,
        Args:[ { Name:'N', Value:10} ],
        Script: //脚本
'LC := REF(CLOSE,1);\n\
VID := SUM(VOL,2)/(((HHV(HIGH,2)-LLV(LOW,2)))*100);\n\
RC := (CLOSE-LC)*VID;\n\
LONG := SUM(RC,0);\n\
DIFF := SMA(LONG,10,1);\n\
DEA := SMA(LONG,20,1);\n\
LON : DIFF-DEA;\n\
LONMA : MA(LON,10);\n\
LONT : LON, COLORSTICK;'

    };

    return data;
}

JSIndexScript.prototype.NDB = function () 
{
    let data =
    {
        Name: 'NDB', Description: '脑电波', IsMainIndex: false,
        Args: [{ Name: 'P1', Value: 5 }, { Name: 'P2', Value: 10 }],
        Script: //脚本
'HH:=IF(C/REF(C,1)>1.098 AND L>REF(H,1),2*C-REF(C,1)-H,2*C-H-L);\n\
V1:= BARSCOUNT(C) - 1;\n\
V2:= 2 * REF(C, V1) - REF(H, V1) - REF(L, V1);\n\
DK: SUM(HH, 0) + V2;\n\
MDK5: MA(DK, P1);\n\
MDK10: MA(DK, P2);'

    };

    return data;
}

JSIndexScript.prototype.SKDJ = function () 
{
    let data =
    {
        Name: 'SKDJ', Description: '慢速随机指标', IsMainIndex: false,
        Args: [{ Name: 'N', Value: 9 }, { Name: 'M', Value: 3 }],
        Script: //脚本
'LOWV:=LLV(LOW,N);\n\
HIGHV:=HHV(HIGH,N);\n\
RSV:=EMA((CLOSE-LOWV)/(HIGHV-LOWV)*100,M);\n\
K:EMA(RSV,M);\n\
D:MA(K,M);'

    };

    return data;
}

JSIndexScript.prototype.KD = function () 
{
    let data =
    {
        Name: 'KD', Description: '随机指标KD', IsMainIndex: false,
        Args: [{ Name: 'N', Value: 9 }, { Name: 'M1', Value: 3 },{ Name: 'M2', Value: 3 }],
        Script: //脚本
'RSV:=(CLOSE-LLV(LOW,N))/(HHV(HIGH,N)-LLV(LOW,N))*100;\n\
K:SMA(RSV,M1,1);\n\
D:SMA(K,M2,1);'

    };

    return data;
}

JSIndexScript.prototype.FKX=function()
{
    let data=
    {
        Name:'FKX', Description:'反K线', IsMainIndex:true,
        Args:[  ],
        Script: //脚本
            'DRAWKLINE(-LOW, -OPEN, -HIGH, -CLOSE);'
    };

    return data;
}

JSIndexScript.prototype.DKCOL = function () 
{
    let data =
    {
        Name: 'DKCOL', Description: '多空能量柱(适用于分时主图)', IsMainIndex: true,
        Args: [{ Name: 'N', Value: 5 }],
        Script: //脚本
'FF:=(C-REF(C,N))/REF(C,N);\n\
STICKLINE(FF>0,DYNAINFO(3),DYNAINFO(3)*(1+FF),0.5,0),COLORRED;\n\
STICKLINE(FF<0,DYNAINFO(3),DYNAINFO(3)*(1+FF),0.5,0),COLORGREEN;'

    };

    return data;
}

JSIndexScript.prototype.UDL = function () 
{
    let data =
    {
        Name: 'UDL', Description: '引力线', IsMainIndex: false,
        Args: [{ Name: 'N1', Value: 3 },{ Name: 'N2', Value: 5 },{ Name: 'N3', Value: 10 },{ Name: 'N4', Value: 20 },{ Name: 'M', Value: 6 }],
        Script: //脚本
'UDL:(MA(CLOSE,N1)+MA(CLOSE,N2)+MA(CLOSE,N3)+MA(CLOSE,N4))/4;\n\
MAUDL:MA(UDL,M);'

    };

    return data;
}

JSIndexScript.prototype.MFI = function () 
{
    let data =
    {
        Name: 'MFI', Description: '资金流量指标', IsMainIndex: false,
        Args: [{ Name: 'N', Value: 14 },{ Name: 'N2', Value: 6 }],
        Script: //脚本
'TYP := (HIGH + LOW + CLOSE)/3;\n\
V1:=SUM(IF(TYP>REF(TYP,1),TYP*VOL,0),N)/SUM(IF(TYP<REF(TYP,1),TYP*VOL,0),N);\n\
MFI:100-(100/(1+V1));'

    };

    return data;
}


JSIndexScript.prototype.LWR = function () 
{
    let data =
    {
        Name: 'LWR', Description: 'LWR威廉指标', IsMainIndex: false,
        Args: [{ Name: 'N', Value: 9 },{ Name: 'M1', Value: 3 },{ Name: 'M2', Value: 3 }],
        Script: //脚本
'RSV:= (HHV(HIGH,N)-CLOSE)/(HHV(HIGH,N)-LLV(LOW,N))*100;\n\
LWR1:SMA(RSV,M1,1);\n\
LWR2:SMA(LWR1,M2,1);'

    };

    return data;
}

JSIndexScript.prototype.MARSI = function () 
{
    let data =
    {
        Name: 'MARSI', Description: '相对强弱平均线', IsMainIndex: false,
        Args: [{ Name: 'M1', Value: 10 },{ Name: 'M2', Value: 6 }],
        Script: //脚本
'DIF:=CLOSE-REF(CLOSE,1);\n\
VU:=IF(DIF>=0,DIF,0);\n\
VD:=IF(DIF<0,-DIF,0);\n\
MAU1:=MEMA(VU,M1);\n\
MAD1:=MEMA(VD,M1);\n\
MAU2:=MEMA(VU,M2);\n\
MAD2:=MEMA(VD,M2);\n\
RSI10:MA(100*MAU1/(MAU1+MAD1),M1);\n\
RSI6:MA(100*MAU2/(MAU2+MAD2),M2);'

    };

    return data;
}

JSIndexScript.prototype.CYD = function () 
{
    let data =
    {
        Name: 'CYD', Description: '承接因子', IsMainIndex: false,
        Args: [{ Name: 'N', Value: 21 }],
        Script: //脚本
'CYDS:WINNER(CLOSE)/(VOL/CAPITAL);\n\
CYDN:WINNER(CLOSE)/MA(VOL/CAPITAL,N);'

    };

    return data;
}

JSIndexScript.prototype.CYF = function () 
{
    let data =
    {
        Name: 'CYF', Description: '市场能量', IsMainIndex: false,
        Args: [{ Name: 'N', Value: 21 }],
        Script: //脚本
'CYF:100-100/(1+EMA(HSL,N));'

    };

    return data;
}

JSIndexScript.prototype.TAPI = function () 
{
    let data =
    {
        Name: 'TAPI', Description: '加权指数成交值', IsMainIndex: false,
        Args: [{ Name: 'M', Value: 6 }],
        Script: //脚本
'TAPI:AMOUNT/INDEXC;\n\
MATAIP:MA(TAPI,M);'

    };

    return data;
}

JSIndexScript.prototype.VMACD = function () 
{
    let data =
    {
        Name: 'VMACD', Description: '量平滑异同平均', IsMainIndex: false,
        Args: [{ Name: 'SHORT', Value: 12 },{ Name: 'LONG', Value: 26 },{ Name: 'MID', Value: 9 }],
        Script: //脚本
'DIF:EMA(VOL,SHORT)-EMA(VOL,LONG);\n\
DEA:EMA(DIF,MID);\n\
MACD:DIF-DEA,COLORSTICK;'

    };

    return data;
}

JSIndexScript.prototype.QACD = function () 
{
    let data =
    {
        Name: 'QACD', Description: '快速异同平均', IsMainIndex: false,
        Args: [{ Name: 'N1', Value: 12 },{ Name: 'N2', Value: 26 },{ Name: 'M', Value: 9 }],
        Script: //脚本
'DIF:EMA(CLOSE,N1)-EMA(CLOSE,N2);\n\
MACD:EMA(DIF,M);\n\
DDIF:DIF-MACD;'

    };

    return data;
}

JSIndexScript.prototype.VPT = function () 
{
    let data =
    {
        Name: 'VPT', Description: '量价曲线', IsMainIndex: false,
        Args: [{ Name: 'N', Value: 51 },{ Name: 'M', Value: 6 }],
        Script: //脚本
'VPT:SUM(VOL*(CLOSE-REF(CLOSE,1))/REF(CLOSE,1),N);\n\
MAVPT:MA(VPT,M);'

    };

    return data;
}

JSIndexScript.prototype.WVAD = function () 
{
    let data =
    {
        Name: 'WVAD', Description: '威廉变异离散量', IsMainIndex: false,
        Args: [{ Name: 'N', Value: 24 },{ Name: 'M', Value: 6 }],
        Script: //脚本
'WVAD:SUM((CLOSE-OPEN)/(HIGH-LOW)*VOL,N)/10000;\n\
MAWVAD:MA(WVAD,M);'

    };

    return data;
}

JSIndexScript.prototype.DBQR = function () 
{
    let data =
    {
        Name: 'WVAD', Description: '对比强弱', IsMainIndex: false,
        Args: [{ Name: 'N', Value: 5 },{ Name: 'M1', Value: 10 },{ Name: 'M2', Value: 20 },{ Name: 'M3', Value: 60 }],
        Script: //脚本
'ZS:(INDEXC-REF(INDEXC,N))/REF(INDEXC,N);\n\
GG:(CLOSE-REF(CLOSE,N))/REF(CLOSE,N);\n\
MADBQR1:MA(GG,M1);\n\
MADBQR2:MA(GG,M2);\n\
MADBQR3:MA(GG,M3);'

    };

    return data;
}

JSIndexScript.prototype.JS = function () 
{
    let data =
    {
        Name: 'JS', Description: '加速线', IsMainIndex: false,
        Args: [{ Name: 'N', Value: 5 },{ Name: 'M1', Value: 5 },{ Name: 'M2', Value: 10 },{ Name: 'M3', Value: 20 }],
        Script: //脚本
'JS:100*(CLOSE-REF(CLOSE,N))/(N*REF(CLOSE,N));\n\
MAJS1:MA(JS,M1);\n\
MAJS2:MA(JS,M2);\n\
MAJS3:MA(JS,M3);'

    };

    return data;
}

JSIndexScript.prototype.CYE = function () 
{
    let data =
    {
        Name: 'CYE', Description: '市场趋势', IsMainIndex: false,
        Args: [ ],
        Script: //脚本
'MAL:=MA(CLOSE,5);\n\
MAS:=MA(MA(CLOSE,20),5);\n\
CYEL:(MAL-REF(MAL,1))/REF(MAL,1)*100;\n\
CYES:(MAS-REF(MAS,1))/REF(MAS,1)*100;'

    };

    return data;
}

JSIndexScript.prototype.QR = function () 
{
    let data =
    {
        Name: 'QR', Description: '强弱指标', IsMainIndex: false,
        Args: [{ Name: 'N', Value: 21 } ],
        Script: //脚本
'个股: (CLOSE-REF(CLOSE,N))/REF(CLOSE,N)*100; \n\
大盘: (INDEXC-REF(INDEXC,N))/REF(INDEXC,N)*100; \n\
强弱值:EMA(个股-大盘,2),COLORSTICK;'

    };

    return data;
}

JSIndexScript.prototype.GDX = function () 
{
    let data =
    {
        Name: 'GDX', Description: '轨道线', IsMainIndex: false,
        Args: [{ Name: 'N', Value: 30 } ,{ Name: 'M', Value: 9 }],
        Script: //脚本
'AA:=ABS((2*CLOSE+HIGH+LOW)/4-MA(CLOSE,N))/MA(CLOSE,N); \n\
轨道:DMA(CLOSE,AA);\n\
压力线:(1+M/100)*轨道; \n\
支撑线:(1-M/100)*轨道;'

    };

    return data;
}

JSIndexScript.prototype.JLHB = function () 
{
    let data =
    {
        Name: 'JLHB', Description: '绝路航标', IsMainIndex: false,
        Args: [{ Name: 'N', Value: 7 } ,{ Name: 'M', Value: 5 }],
        Script: //脚本
'VAR1:=(CLOSE-LLV(LOW,60))/(HHV(HIGH,60)-LLV(LOW,60))*80; \n\
B:SMA(VAR1,N,1); \n\
VAR2:SMA(B,M,1); \n\
绝路航标:IF(CROSS(B,VAR2) AND B<40,50,0);'

    };

    return data;
}

JSIndexScript.prototype.PCNT = function () 
{
    let data =
    {
        Name: 'PCNT', Description: '幅度比', IsMainIndex: false,
        Args: [{ Name: 'M', Value: 5 }],
        Script: //脚本
'PCNT:(CLOSE-REF(CLOSE,1))/CLOSE*100;\n\
MAPCNT:EXPMEMA(PCNT,M);'

    };

    return data;
}

JSIndexScript.prototype.BTX = function () 
{
    let data =
    {
        Name: 'BTX', Description: '宝塔线', IsMainIndex: false,
        Args: [],
        Script: //脚本
            'B1:=REF(C,1);\n\
B2:= REF(C, 2);\n\
SS:= IF(C > REF(C, 1) AND REF(C, 1) >= REF(C, 2), 1, IF(C < REF(C, 1) AND REF(C, 1) <= REF(C, 2), -1, IF(C > REF(C, 2) AND REF(C, 2) > REF(C, 1), 2, IF(C < REF(C, 2) AND REF(C, 2) < REF(C, 1), -2, 0))));\n\
SM:= IF(REF(SS, 1) <> 0, REF(SS, 1), IF(REF(SS, 2) <> 0, REF(SS, 2), IF(REF(SS, 3) <> 0, REF(SS, 3), IF(REF(SS, 5) <> 0, REF(SS, 5), IF(REF(SS, 6) <> 0, REF(SS, 6), IF(REF(SS, 7) <> 0, REF(SS, 7), 0))))));\n\
MC:= IF(REF(SS, 1) <> 0, B2, IF(SM > 0, MIN(B1, B2), MAX(B1, B2)));\n\
TOW1:= IF(C > REF(C, 1), C, REF(C, 1));\n\
TOW2:= IF((SS == -1 OR SS == -2) AND SM > 0, B2, TOW1);\n\
TOWER:= IF(TOW1 > TOW2, TOW1, TOW2);\n\
STICKLINE(SS == 1 OR SM >= 1 AND SS == 0, B1, C, 10, 1), COLORRED;\n\
STICKLINE(SS == -1 OR SM <= -1 AND SS == 0, B1, C, 10, 0), COLORCYAN;\n\
STICKLINE(SS == 2, B2, C, 10, 1), COLORRED;\n\
STICKLINE(SS == -2, B2, C, 10, 0), COLORCYAN;\n\
STICKLINE((SS == -1 OR SS == -2) AND SM > 0, B2, B1, 10, 1), COLORRED;\n\
STICKLINE((SS == 1 OR SS == 2) AND SM < 0, B2, B1, 10, 0), COLORCYAN;'
        };

    return data;
}

JSIndexScript.prototype.AMO = function () 
{
    let data =
    {
        Name: 'AMO', Description: '成交金额', IsMainIndex: false,
        Args: [{ Name: 'M1', Value: 5 },{ Name: 'M2', Value: 10 }],
        Script: //脚本
'AMOW:AMOUNT/10000.0,VOLSTICK;\n\
AMO1:MA(AMOW,M1);\n\
AMO2:MA(AMOW,M2);'

    };

    return data;
}

JSIndexScript.prototype.VRSI = function () 
{
    let data =
    {
        Name: 'VRSI', Description: '相对强弱量', IsMainIndex: false,
        Args: [{ Name: 'N1', Value: 6 },{ Name: 'N2', Value: 12 },{ Name: 'N3', Value: 24 }],
        Script: //脚本
'LC:=REF(VOL,1);\n\
RSI1:SMA(MAX(VOL-LC,0),N1,1)/SMA(ABS(VOL-LC),N1,1)*100;\n\
RSI2:SMA(MAX(VOL-LC,0),N2,1)/SMA(ABS(VOL-LC),N2,1)*100;\n\
RSI3:SMA(MAX(VOL-LC,0),N3,1)/SMA(ABS(VOL-LC),N3,1)*100;'

    };

    return data;
}

JSIndexScript.prototype.HSCOL = function () 
{
    let data =
    {
        Name: 'HSCOL', Description: '换手柱', IsMainIndex: false,
        Args: [{ Name: 'N', Value: 5 }],
        Script: //脚本
'HSCOL:IF((SETCODE==0||SETCODE==1),100*VOL,VOL)/(FINANCE(7)/100),VOLSTICK;\n\
MAHSL:MA(HSCOL,N);'

    };

    return data;
}

JSIndexScript.prototype.DBQRV = function () 
{
    let data =
    {
        Name: 'DBQRV', Description: '对比强弱量(需下载日线)', IsMainIndex: false,
        Args: [{ Name: 'N', Value: 5 }],
        Script: //脚本
'ZS:(INDEXV-REF(INDEXV,N))/REF(INDEXV,N);\n\
GG:(VOL-REF(VOL,N))/REF(VOL,N);'

    };

    return data;
}

JSIndexScript.prototype.DBLB = function () 
{
    let data =
    {
        Name: 'DBLB', Description: '对比量比(需下载日线)', IsMainIndex: false,
        Args: [{ Name: 'N', Value: 5 },{ Name: 'M', Value: 5 }],
        Script: //脚本
'GG:=VOL/SUM(REF(VOL,1),N);\n\
ZS:=INDEXV/SUM(REF(INDEXV,1),N);\n\
DBLB:GG/ZS;\n\
MADBLB:MA(DBLB,M);'

    };

    return data;
}

JSIndexScript.prototype.ACD = function () 
{
    let data =
    {
        Name: 'ACD', Description: '升降线', IsMainIndex: false,
        Args: [{ Name: 'M', Value: 20 }],
        Script: //脚本
'LC:=REF(CLOSE,1);\n\
DIF:=CLOSE-IF(CLOSE>LC,MIN(LOW,LC),MAX(HIGH,LC));\n\
ACD:SUM(IF(CLOSE==LC,0,DIF),0);\n\
MAACD:EXPMEMA(ACD,M);'

    };

    return data;
}

JSIndexScript.prototype.EXPMA = function () 
{
    let data =
    {
        Name: 'EXPMA', Description: '指数平均线', IsMainIndex: true,
        Args: [{ Name: 'M1', Value: 12 },{ Name: 'M2', Value: 50 }],
        Script: //脚本
'EXP1:EMA(CLOSE,M1);\n\
EXP2:EMA(CLOSE,M2);'

    };

    return data;
}

JSIndexScript.prototype.EXPMA_S = function () 
{
    let data =
    {
        Name: 'EXPMA_S', Description: '指数平均线-副图', IsMainIndex: false,
        Args: [{ Name: 'M1', Value: 12 },{ Name: 'M2', Value: 50 }],
        Script: //脚本
'EXP1:EMA(CLOSE,M1);\n\
EXP2:EMA(CLOSE,M2);'

    };

    return data;
}

JSIndexScript.prototype.HMA = function () 
{
    let data =
    {
        Name: 'HMA', Description: '高价平均线', IsMainIndex: true,
        Args: [{ Name: 'M1', Value: 6 },{ Name: 'M2', Value: 12 },{ Name: 'M3', Value: 30 },{ Name: 'M4', Value: 72 },{ Name: 'M5', Value: 144 }],
        Script: //脚本
'HMA1:MA(HIGH,M1);\n\
HMA2:MA(HIGH,M2);\n\
HMA3:MA(HIGH,M3);\n\
HMA4:MA(HIGH,M4);\n\
HMA5:MA(HIGH,M5);'

    };

    return data;
}

JSIndexScript.prototype.LMA = function () 
{
    let data =
    {
        Name: 'LMA', Description: '低价平均线', IsMainIndex: true,
        Args: [{ Name: 'M1', Value: 6 },{ Name: 'M2', Value: 12 },{ Name: 'M3', Value: 30 },{ Name: 'M4', Value: 72 },{ Name: 'M5', Value: 144 }],
        Script: //脚本
'LMA1:MA(LOW,M1);\n\
LMA2:MA(LOW,M2);\n\
LMA3:MA(LOW,M3);\n\
LMA4:MA(LOW,M4);\n\
LMA5:MA(LOW,M5);'

    };

    return data;
}

JSIndexScript.prototype.VMA = function () 
{
    let data =
    {
        Name: 'VMA', Description: '变异平均线', IsMainIndex: true,
        Args: [{ Name: 'M1', Value: 6 },{ Name: 'M2', Value: 12 },{ Name: 'M3', Value: 30 },{ Name: 'M4', Value: 72 },{ Name: 'M5', Value: 144 }],
        Script: //脚本
'VV:=(HIGH+OPEN+LOW+CLOSE)/4;\n\
VMA1:MA(VV,M1);\n\
VMA2:MA(VV,M2);\n\
VMA3:MA(VV,M3);\n\
VMA4:MA(VV,M4);\n\
VMA5:MA(VV,M5);'

    };

    return data;
}


JSIndexScript.prototype.AMV = function () 
{
    let data =
    {
        Name: 'AMV', Description: '成本价均线', IsMainIndex: false,
        Args: [{ Name: 'M1', Value: 6 },{ Name: 'M2', Value: 12 },{ Name: 'M3', Value: 30 },{ Name: 'M4', Value: 72 },{ Name: 'M5', Value: 144 }],
        Script: //脚本
'AMOV:=VOL*(OPEN+CLOSE)/2;\n\
AMV1:SUM(AMOV,M1)/SUM(VOL,M1);\n\
AMV2:SUM(AMOV,M2)/SUM(VOL,M2);\n\
AMV3:SUM(AMOV,M3)/SUM(VOL,M3);\n\
AMV4:SUM(AMOV,M4)/SUM(VOL,M4);'

    };

    return data;
}

JSIndexScript.prototype.BBIBOLL = function () 
{
    let data =
    {
        Name: 'BBIBOLL', Description: '多空布林线', IsMainIndex: true,
        Args: [{ Name: 'N', Value: 11 },{ Name: 'M', Value: 6 }],
        Script: //脚本
'CV:=CLOSE;\n\
BBIBOLL:(MA(CV,3)+MA(CV,6)+MA(CV,12)+MA(CV,24))/4;\n\
UPR:BBIBOLL+M*STD(BBIBOLL,N);\n\
DWN:BBIBOLL-M*STD(BBIBOLL,N);'

    };

    return data;
}

JSIndexScript.prototype.ALLIGAT = function () 
{
    let data =
    {
        Name: 'ALLIGAT', Description: '鳄鱼线', IsMainIndex: true,
        Args: [],
        Script: //脚本
'NN:=(H+L)/2;\n\
上唇:REF(MA(NN,5),3),COLOR40FF40;\n\
牙齿:REF(MA(NN,8),5),COLOR0000C0;\n\
下颚:REF(MA(NN,13),8),COLORFF4040;'

    };

    return data;
}

JSIndexScript.prototype.ZX = function () 
{
    let data =
    {
        Name: 'ZX', Description: '重心线', IsMainIndex: false,
        Args: [],
        Script: //脚本
'AV:0.01*AMOUNT/VOL;'

    };

    return data;
}

JSIndexScript.prototype.XS = function () 
{
    let data =
    {
        Name: 'XS', Description: '薛斯通道', IsMainIndex: true,
        Args: [{ Name: 'N', Value: 13 }],
        Script: //脚本
'VAR2:=CLOSE*VOL;\n\
VAR3:=EMA((EMA(VAR2,3)/EMA(VOL,3)+EMA(VAR2,6)/EMA(VOL,6)+EMA(VAR2,12)/EMA(VOL,12)+EMA(VAR2,24)/EMA(VOL,24))/4,N);\n\
SUP:1.06*VAR3;\n\
SDN:VAR3*0.94;\n\
VAR4:=EMA(CLOSE,9);\n\
LUP:EMA(VAR4*1.14,5);\n\
LDN:EMA(VAR4*0.86,5);'

    };

    return data;
}

JSIndexScript.prototype.XS2 = function () 
{
    let data =
    {
        Name: 'XS2', Description: '薛斯通道II', IsMainIndex: true,
        Args: [{ Name: 'N', Value: 102 },{ Name: 'M', Value: 7 }],
        Script: //脚本
'AA:=MA((2*CLOSE+HIGH+LOW)/4,5); \n\
通道1:AA*N/100; \n\
通道2:AA*(200-N)/100; \n\
CC:=ABS((2*CLOSE+HIGH+LOW)/4-MA(CLOSE,20))/MA(CLOSE,20); \n\
DD:=DMA(CLOSE,CC); \n\
通道3:(1+M/100)*DD; \n\
通道4:(1-M/100)*DD;'

    };

    return data;
}

JSIndexScript.prototype.SG_XDT = function () 
{
    let data =
    {
        Name: 'SG-XDT', Description: '心电图(需下载日线)', IsMainIndex: false,
        Args: [{ Name: 'P1', Value: 5 },{ Name: 'P2', Value: 10 }],
        Script: //脚本
'QR:CLOSE/INDEXC*1000;\n\
MQR1:MA(QR,5);\n\
MQR2:MA(QR,10);'

    };

    return data;
}

JSIndexScript.prototype.SG_SMX = function () 
{
    let data =
    {
        Name: 'SG-SMX', Description: '生命线(需下载日线)', IsMainIndex: false,
        Args: [{ Name: 'N', Value: 50 }],
        Script: //脚本
'H1:=HHV(HIGH,N);\n\
L1:=LLV(LOW,N);\n\
H2:=HHV(INDEXH,N);\n\
L2:=LLV(INDEXL,N);\n\
ZY:=CLOSE/INDEXC*2000;\n\
ZY1:EMA(ZY,3);\n\
ZY2:EMA(ZY,17);\n\
ZY3:EMA(ZY,34);'

    };

    return data;
}

JSIndexScript.prototype.SG_LB = function () 
{
    let data =
    {
        Name: 'SG-LB', Description: '量比(需下载日线)', IsMainIndex: false,
        Args: [],
        Script: //脚本
'ZY2:=VOL/INDEXV*1000;\n\
量比:ZY2;\n\
MA5:MA(ZY2,5);\n\
MA10:MA(ZY2,10);'

    };

    return data;
}

JSIndexScript.prototype.SG_PF = function () 
{
    let data =
    {
        Name: 'SG-PF', Description: '强势股评分(需下载日线)', IsMainIndex: false,
        Args: [],
        Script: //脚本
'ZY1:=CLOSE/INDEXC*1000;\n\
A1:=IF(ZY1>HHV(ZY1,3),10,0);\n\
A2:=IF(ZY1>HHV(ZY1,5),15,0);\n\
A3:=IF(ZY1>HHV(ZY1,10),20,0);\n\
A4:=IF(ZY1>HHV(ZY1,2),10,0);\n\
A5:=COUNT(ZY1>REF(ZY1,1) ,9)*5;\n\
强势股评分:A1+A2+A3+A4+A5;'

    };

    return data;
}

JSIndexScript.prototype.RAD = function () 
{
    let data =
    {
        Name: 'RAD', Description: '威力雷达(需下载日线)', IsMainIndex: false,
        Args: [{ Name: 'D', Value: 3 },{ Name: 'S', Value: 30 },{ Name: 'M', Value: 30 }],
        Script: //脚本
'SM:=(OPEN+HIGH+CLOSE+LOW)/4;\n\
SMID:=MA(SM,D);\n\
IM:=(INDEXO+INDEXH+INDEXL+INDEXC)/4;\n\
IMID:=MA(IM,D);\n\
SI1:=(SMID-REF(SMID,1))/SMID;\n\
II:=(IMID-REF(IMID,1))/IMID;\n\
RADER1:SUM((SI1-II)*2,S)*1000;\n\
RADERMA:SMA(RADER1,M,1);'

    };

    return data;
}

JSIndexScript.prototype.SHT = function () 
{
    let data =
    {
        Name: 'SHT', Description: '龙系短线', IsMainIndex: false,
        Args: [{ Name: 'N', Value: 5 }],
        Script: //脚本
'VAR1:=MA((VOL-REF(VOL,1))/REF(VOL,1),5);\n\
VAR2:=(CLOSE-MA(CLOSE,24))/MA(CLOSE,24)*100;\n\
MY: VAR2*(1+VAR1);\n\
SHT: MY, COLORSTICK;\n\
SHTMA: MA(SHT,N);'

    };

    return data;
}

JSIndexScript.prototype.ZLJC = function () 
{
    let data =
    {
        Name: 'ZLJC', Description: '主力进出', IsMainIndex: false,
        Args: [],
        Script: //脚本
'VAR1:=(CLOSE+LOW+HIGH)/3; \n\
VAR2:=SUM(((VAR1-REF(LOW,1))-(HIGH-VAR1))*VOL/100000/(HIGH-LOW),0); \n\
VAR3:=EMA(VAR2,1); \n\
JCS:VAR3; \n\
JCM:MA(VAR3,12); \n\
JCL:MA(VAR3,26);'

    };

    return data;
}

JSIndexScript.prototype.ZLMM = function () 
{
    let data =
    {
        Name: 'ZLMM', Description: '主力买卖', IsMainIndex: false,
        Args: [],
        Script: //脚本
'LC :=REF(CLOSE,1);\n\
RSI2:=SMA(MAX(CLOSE-LC,0),12,1)/SMA(ABS(CLOSE-LC),12,1)*100;\n\
RSI3:=SMA(MAX(CLOSE-LC,0),18,1)/SMA(ABS(CLOSE-LC),18,1)*100;\n\
MMS:MA(3*RSI2-2*SMA(MAX(CLOSE-LC,0),16,1)/SMA(ABS(CLOSE-LC),16,1)*100,3);\n\
MMM:EMA(MMS,8);\n\
MML:MA(3*RSI3-2*SMA(MAX(CLOSE-LC,0),12,1)/SMA(ABS(CLOSE-LC),12,1)*100,5);'

    };

    return data;
}

JSIndexScript.prototype.SLZT = function () 
{
    let data =
    {
        Name: 'SLZT', Description: '神龙在天', IsMainIndex: false,
        Args: [],
        Script: //脚本
'白龙: MA(CLOSE,125);\n\
黄龙: 白龙+2*STD(CLOSE,170);\n\
紫龙: 白龙-2*STD(CLOSE,145);\n\
青龙: SAR(125,1,7), LINESTICK;\n\
VAR2:=HHV(HIGH,70);\n\
VAR3:=HHV(HIGH,20);\n\
红龙: VAR2*0.83;\n\
蓝龙: VAR3*0.91;'

    };

    return data;
}

JSIndexScript.prototype.ADVOL = function () 
{
    let data =
    {
        Name: 'ADVOL', Description: '龙系离散量', IsMainIndex: false,
        Args: [],
        Script: //脚本
'A:=SUM(((CLOSE-LOW)-(HIGH-CLOSE))*VOL/10000/(HIGH-LOW),0);\n\
ADVOL:A;\n\
MA1:MA(A,30);\n\
MA2:MA(MA1,100);'

    };

    return data;
}

JSIndexScript.prototype.CYC = function () 
{
    let data =
    {
        Name: 'CYC', Description: '成本均线', IsMainIndex: true,
        Args: [{ Name: 'P1', Value: 5 },{ Name: 'P2', Value: 13 },{ Name: 'P3', Value: 34 }],
        Script: //脚本
'JJJ:=IF(DYNAINFO(8)>0.01,0.01*DYNAINFO(10)/DYNAINFO(8),DYNAINFO(3));\n\
DDD:=(DYNAINFO(5)<0.01 || DYNAINFO(6)<0.01);\n\
JJJT:=IF(DDD,1,(JJJ<(DYNAINFO(5)+0.01) && JJJ>(DYNAINFO(6)-0.01)));\n\
CYC1:IF(JJJT,0.01*EMA(AMOUNT,P1)/EMA(VOL,P1),EMA((HIGH+LOW+CLOSE)/3,P1));\n\
CYC2:IF(JJJT,0.01*EMA(AMOUNT,P2)/EMA(VOL,P2),EMA((HIGH+LOW+CLOSE)/3,P2));\n\
CYC3:IF(JJJT,0.01*EMA(AMOUNT,P3)/EMA(VOL,P3),EMA((HIGH+LOW+CLOSE)/3,P3));\n\
CYC4:IF(JJJT,DMA(AMOUNT/(100*VOL),100*VOL/FINANCE(7)),EMA((HIGH+LOW+CLOSE)/3,120));'

    };

    return data;
}

JSIndexScript.prototype.CYS = function () 
{
    let data =
    {
        Name: 'CYS', Description: '市场盈亏', IsMainIndex: false,
        Args: [],
        Script: //脚本
'CYC13:EMA(AMOUNT,13)/EMA(VOL,13);\n\
CYS:(CLOSE-CYC13)/CYC13*100;'

    };

    return data;
}

JSIndexScript.prototype.CYQKL = function () 
{
    let data =
    {
        Name: 'CYQKL', Description: '博弈K线长度', IsMainIndex: false,
        Args: [],
        Script: //脚本
'KL:100*(WINNER(CLOSE)-WINNER(OPEN));'

    };

    return data;
}

JSIndexScript.prototype.SCR = function () 
{
    let data =
    {
        Name: 'SCR', Description: '筹码集中度', IsMainIndex: false,
        Args: [{ Name: 'P1', Value: 90 }],
        Script: //脚本
'A:=P1+(100-P1)/2;\n\
B:=(100-P1)/2;\n\
CC:=COST(A);\n\
DD:=COST(B);\n\
SCR:(CC-DD)/(CC+DD)*100/2;'

    };

    return data;
}


JSIndexScript.prototype.ASR = function () 
{
    let data =
    {
        Name: 'ASR', Description: '浮筹比例', IsMainIndex: false,
        Args: [],
        Script: //脚本
'ASR:(WINNER(C*1.1)-WINNER(C*0.9))/WINNER(HHV(H,0))*100;'

    };

    return data;
}

JSIndexScript.prototype.SAR = function () 
{
    let data =
    {
        Name: 'SAR', Description: '抛物转向', IsMainIndex: true,
        Args: [{ Name: 'P', Value: 10 },{ Name: 'STEP', Value: 2 },{ Name: 'MAXP', Value: 20 }],
        Script: //脚本
'S:SAR(P,STEP,MAXP),CIRCLEDOT;'

    };

    return data;
}

JSIndexScript.prototype.TJCJL = function () 
{
    let data =
    {
        Name: '太极成交量', Description: '太极成交量', IsMainIndex: true,
        Args: [],
        Script: //脚本
'总手:VOL,NODRAW;\n\
DRAWTEXT_FIX(ISLASTBAR,0,0,0,"说明: 红色柱为吸货量,绿色为出货量,黄色为天量,蓝色为地量"),COLORGRAY;\n\
ZZ:=IF(REF(C,1)>REF(O,1) AND O>REF(C,1)*1.014 AND C<O*1.02,1,3);\n\
V5:=MA(V,5);\n\
V12:=MA(V,12);\n\
V34:=MA(V,34);\n\
C6:=MA(C,6);\n\
STICKLINE(VOL,0,VOL,3,0),COLORLIGRAY;\n\
STICKLINE(CROSS(C,C6) AND V>V5*1.2 AND V>V12*1.2 AND ZZ>2 AND C>H*0.975,0,VOL,3,0),COLORRED;\n\
STICKLINE(CROSS(C6,C) AND V>V5*1.2 AND V>V12*1.2,0,VOL,3,0),COLORGREEN;\n\
STICKLINE(VOL>MA(VOL,5)*2 AND V>V34*3 AND C<REF(C,1)*1.05,0,VOL,3,0),COLORYELLOW;\n\
STICKLINE(VOL<MA(VOL,5)/2 AND V<V12/2,0,VOL,3,0),COLORBLUE;\n\
STICKLINE(VOL>MA(VOL,5)*2 AND V>V34*3 AND C<REF(C,1)*1.05 AND CROSS(C,C6) AND V>V5*1.2 AND V>V12*1.2 AND ZZ>2 AND C>H*0.975,VOL*0.5,0,3,0),COLORRED;\n\
STICKLINE(VOL>MA(VOL,5)*2 AND V>V34*3 AND C<REF(C,1)*1.05 AND CROSS(C6,C) AND V>V5*1.2 AND V>V12*1.2,VOL*0.5,0,3,0),COLORRED;'

    };

    return data;
}

/*
    飞龙四式-主图
*/
JSIndexScript.prototype.Dragon4_Main = function () 
{
    let data =
    {
        Name: '飞龙四式', Description: '飞龙四式', IsMainIndex: true,
        Args: [{ Name: 'N1', Value: 5 }, { Name: 'N2', Value: 10 }, { Name: 'N3', Value: 50 }, { Name: 'N4', Value: 60 }],
        Script: //脚本
'蜻蜓点水:=EMA(CLOSE,N1),COLORGRAY;\n\
魔界:=EMA(CLOSE,N2),COLORGREEN;\n\
水:=EMA(CLOSE,N3),COLORRED;\n\
DRAWKLINE(HIGH,OPEN,LOW,CLOSE);\n\
生命线:MA(CLOSE,N4),COLORBLUE,LINETHICK2;\n\
DRAWBAND(魔界,\'RGB(186,225,250)\',水,\'RGB(253,194,124)\');\n\
DRAWBAND(蜻蜓点水,\'RGB(128,138,135)\',魔界,\'RGB(0,0,255)\');'

    };

    return data;
}

JSIndexScript.prototype.Dragon4_Fig=function()
{
    let data =
    {
        Name: '飞龙四式', Description: '飞龙四式', IsMainIndex: false,
        Args: [],
        Script: //脚本
'倍:VOL>=REF(V,1)*1.90 AND C>REF(C,1),COLORYELLOW;\n\
低:VOL<REF(LLV(VOL,13),1),COLORGREEN;\n\
地:VOL<REF(LLV(VOL,100),1),COLORMAGENTA; \n\
平:=ABS(VOL-HHV(REF(VOL,1),5))/HHV(REF(VOL,1),5)<=0.03 OR ABS(VOL-REF(VOL,1))/REF(VOL,1)<=0.03,NODRAW,COLORWHITE;\n\
倍缩:VOL<=REF(V,1)*0.5,COLORFF8000;\n\
梯量:COUNT(V>REF(V,1),3)==3 AND COUNT(C>O,3)==3,COLORBROWN;\n\
缩量涨:COUNT(C>REF(C,1),2)==2 AND COUNT(V<REF(V,1),2)==2,COLORBLUE;\n\
STICKLINE(C>=REF(C,1),V,0,2,0),COLORRED;\n\
STICKLINE(C<REF(C,1),V,0,2,0),COLORGREEN;\n\
STICKLINE(倍,0,V,2,0),COLORYELLOW;\n\
STICKLINE(低,0,V,2,0),COLORGREEN;\n\
STICKLINE(地,0,V,2,0),COLORLIMAGENTA;\n\
STICKLINE(平,0,V,2,0),COLORGRAY;\n\
STICKLINE(倍缩,0,V,2,0),COLORFF8000;\n\
STICKLINE(梯量,0,V,2,0),COLORBROWN;\n\
STICKLINE(缩量涨,0,V,2,0),COLORBLUE;'

    };

    return data;
}


/*
能图-资金分析
M:=55;
N:=34;
LC:=REF(CLOSE,1);
RSI:=((SMA(MAX((CLOSE - LC),0),3,1) / SMA(ABS((CLOSE - LC)),3,1)) * 100);
FF:=EMA(CLOSE,3);
MA15:=EMA(CLOSE,21); DRAWTEXT(CROSS(85,RSI),75,'▼'),COLORGREEN;
VAR1:=IF(YEAR>=2038 AND MONTH>=1,0,1);
VAR2:=REF(LOW,1)*VAR1;
VAR3:=SMA(ABS(LOW-VAR2),3,1)/SMA(MAX(LOW-VAR2,0),3,1)*100*VAR1;
VAR4:=EMA(IF(CLOSE*1.3,VAR3*10,VAR3/10),3)*VAR1;
VAR5:=LLV(LOW,30)*VAR1;
VAR6:=HHV(VAR4,30)*VAR1;
VAR7:=IF(MA(CLOSE,58),1,0)*VAR1;
VAR8:=EMA(IF(LOW<=VAR5,(VAR4+VAR6*2)/2,0),3)/618*VAR7*VAR1;
吸筹A:IF(VAR8>100,100,VAR8)*VAR1,COLORRED;
吸筹B:STICKLINE(吸筹A>-150,0,吸筹A,8,0),COLORRED;

散户线: 100*(HHV(HIGH,M)-CLOSE)/(HHV(HIGH,M)-LLV(LOW,M)),COLORFFFF00,LINETHICK2;
RSV:=(CLOSE-LLV(LOW,N))/(HHV(HIGH,N)-LLV(LOW,N))*100;
K:=SMA(RSV,3,1);
D:=SMA(K,3,1);
J:=3*K-2*D;
主力线:EMA(J,5),COLORFF00FF,LINETHICK2;
DRAWICON(CROSS(主力线,散户线),主力线,1);
DRAWICON(CROSS(散户线,主力线),主力线,2);
*/

JSIndexScript.prototype.FundsAnalysis=function()
{
    let data =
    {
        Name: '资金分析', Description: '资金分析', IsMainIndex: false,
        Args: [{ Name: 'M', Value: 55 }, { Name: 'N', Value: 34 }],
        Script: //脚本
'LC:=REF(CLOSE,1);\n\
RSI:=((SMA(MAX((CLOSE - LC),0),3,1) / SMA(ABS((CLOSE - LC)),3,1)) * 100);\n\
FF:=EMA(CLOSE,3);\n\
MA15:=EMA(CLOSE,21); DRAWTEXT(CROSS(85,RSI),75,\'▼\'),COLORGREEN;\n\
VAR1:=IF(YEAR>=2038 AND MONTH>=1,0,1);\n\
VAR2:=REF(LOW,1)*VAR1;\n\
VAR3:=SMA(ABS(LOW-VAR2),3,1)/SMA(MAX(LOW-VAR2,0),3,1)*100*VAR1;\n\
VAR4:=EMA(IF(CLOSE*1.3,VAR3*10,VAR3/10),3)*VAR1;\n\
VAR5:=LLV(LOW,30)*VAR1;\n\
VAR6:=HHV(VAR4,30)*VAR1;\n\
VAR7:=IF(MA(CLOSE,58),1,0)*VAR1;\n\
VAR8:=EMA(IF(LOW<=VAR5,(VAR4+VAR6*2)/2,0),3)/618*VAR7*VAR1;\n\
吸筹A:IF(VAR8>100,100,VAR8)*VAR1,COLORFB2F3B;\n\
{吸筹B}STICKLINE(吸筹A>-150,0,吸筹A,8,0),COLORFB2F3B;\n\
\n\
散户线: 100*(HHV(HIGH,M)-CLOSE)/(HHV(HIGH,M)-LLV(LOW,M)),COLORAA89BD,LINETHICK2;\n\
RSV:=(CLOSE-LLV(LOW,N))/(HHV(HIGH,N)-LLV(LOW,N))*100;\n\
K:=SMA(RSV,3,1);\n\
D:=SMA(K,3,1);\n\
J:=3*K-2*D;\n\
主力线:EMA(J,5),COLORF39800,LINETHICK2;\n\
DRAWICON(CROSS(主力线,散户线),主力线,1);\n\
DRAWICON(CROSS(散户线,主力线),主力线,2);'
    };

    return data; 
}

JSIndexScript.prototype.MarginProportion=function()
{
    let data =
    {
        Name: '融资占比(%)', Description: '融资占比', IsMainIndex: false, 
        Condition: { Period:[CONDITION_PERIOD.KLINE_DAY_ID] },
        Args: [],
        Script: //脚本
        '占比:MARGIN(2);'
    };

    return data; 
}

JSIndexScript.prototype.Margin2=function()
{
    let data =
    {
        Name: '两融余额', Description: '融资融券余额', IsMainIndex: false, 
        Condition: { Period:[CONDITION_PERIOD.KLINE_DAY_ID] },
        Args: [{ Name: 'N', Value: 5 }],
        Script: //脚本
        'T1:MARGIN(1);\n\
        T2:MA(MARGIN(1),N);'
    };

    return data; 
}

JSIndexScript.prototype.Margin3=function()
{
    let data =
    {
        Name: '两融余额', Description: '融资融券余额', IsMainIndex: false, 
        Condition: { Period:[CONDITION_PERIOD.KLINE_DAY_ID] },
        Args: [{ Name: 'N', Value: 5 }],
        Script: //脚本
        'T1:=MARGIN(1);\n\
        T2:=MA(MARGIN(1),N);\n\
        STICKLINE(T1-T2>=0,0,T1-T2,50,T1>T2),COLORRED;\n\
        STICKLINE(T1-T2<0,T1-T2,0,50,T1>T2),COLORGREEN;'
    };

    return data; 
}



JSIndexScript.prototype.FXG_BSPoint=function()
{
    let data =
    {
        Name: '操盘BS点', Description: '操盘BS点', IsMainIndex: true,
        Args: [],
        Script: //脚本
        'MA5:MA(CLOSE,5);\n\
        MA13:MA(CLOSE,13);\n\
        MA21:MA(CLOSE,21);\n\
        MA34:MA(CLOSE,34);\n\
        {MA55:MA(CLOSE,55),COLOR0000FF;}\n\
        {MA120:=MA(CLOSE,120),COLORFFFF00;}\n\
        天使:=EMA(C,2),COLOR000000;\n\
        魔鬼:=EMA(SLOPE(C,21)*20+C,42),COLOR000000;\n\
        买:=CROSS(天使,魔鬼);\n\
        卖:=CROSS(魔鬼,天使);\n\
        DRAWICON(买,L*0.97,13);\n\
        DRAWICON(卖,H*1.03,14);\n\
        DRAWKLINE_IF(天使>=魔鬼,HIGH,CLOSE,LOW,OPEN),COLORRED;\n\
        DRAWKLINE_IF(天使<魔鬼,HIGH,CLOSE,LOW,OPEN),COLORBLUE;\n\
        DRAWKLINE_IF(CROSS(天使,魔鬼),HIGH,CLOSE,LOW,OPEN),COLORYELLOW;\n\
        DRAWKLINE_IF(CROSS(魔鬼,天使),HIGH,CLOSE,LOW,OPEN),COLORBLACK;'
    };

    return data; 
}

JSIndexScript.prototype.FXG_INDEX=function()
{
    let data =
    {
        Name: '涨停多空线', Description: '涨停多空线', IsMainIndex: false,
        Args: [],
        Script: //脚本
'做多能量线: SMA((CLOSE-LLV(LOW,9))/(HHV(HIGH,9)-LLV(LOW,9))*100,5,1)-8,COLORRED,LINETHICK3;\n\
做空能量线: SMA((HHV(HIGH,36)-CLOSE)/(HHV(HIGH,36)-LLV(LOW,36))*100,2,1),COLORGREEN,LINETHICK3;\n\
20,POINTDOT,COLORF00FF0;\n\
50,POINTDOT,COLORGREEN;\n\
80,POINTDOT,COLORLIBLUE;'
    };

    return data; 
}

JSIndexScript.prototype.FXG_INDEX2=function()
{
    let data =
    {
        Name: '涨停吸筹区', Description: '涨停吸筹区', IsMainIndex: false,
        Args: [],
        Script: //脚本
'VAR0:=EMA(HHV(HIGH,500),21); \n\
VAR1:=EMA(HHV(HIGH,250),21);\n\
VAR2:=EMA(HHV(HIGH,90),21); \n\
VAR3:=EMA(LLV(LOW,500),21); \n\
VAR4:=EMA(LLV(LOW,250),21); \n\
VAR5:=EMA(LLV(LOW,90),21);\n\
\n\
VAR6:=EMA((VAR3*0.96+VAR4*0.96+VAR5*0.96+VAR0*0.558+VAR1*0.558+VAR2*0.558)/6,21); \n\
VAR7:=EMA((VAR3*1.25+VAR4*1.23+VAR5*1.2+VAR0*0.55+VAR1*0.55+VAR2*0.65)/6,21); \n\
VAR8:=EMA((VAR3*1.3+VAR4*1.3+VAR5*1.3+VAR0*0.68+VAR1*0.68+VAR2*0.68)/6,21); \n\
VAR9:=EMA((VAR6*3+VAR7*2+VAR8)/6*1.738,21); \n\
VAR10:=REF(LOW,1); \n\
VAR11:=SMA(ABS(LOW-VAR10),3,1)/SMA(MAX(LOW-VAR10,0),3,1)*100; \n\
VAR12:=EMA(IFF(CLOSE*1.35<=VAR9,VAR11*10,VAR11/10),3); \n\
VAR13:=LLV(LOW,30); \n\
VAR14:=HHV(VAR12,30); \n\
VAR15:=IFF(MA(CLOSE,58),1,0); \n\
VAR16:=EMA(IFF(LOW<=VAR13,(VAR12+VAR14*2)/2,0),3)/618*VAR15;\n\
\n\
资金入场:IFF(VAR16>0,VAR16,0),LINETHICK,LINETHICK2, COLORFF0000; \n\
\n\
A1:IFF(资金入场>0,资金入场*1.2,0),STICK,LINETHICK5, COLORFF0000;\n\
A2:IFF(资金入场>0,资金入场*0.8,0),STICK,LINETHICK5, COLORFF6600;\n\
A3:IFF(资金入场>0,资金入场*0.6,0),STICK,LINETHICK5, COLORFF9900;\n\
A4:IFF(资金入场>0,资金入场*0.4,0) ,STICK,LINETHICK5,COLORFFCC00;\n\
A5:IFF(资金入场>0,资金入场*0.2,0) ,STICK,LINETHICK5,COLORFFFF00;'
    };

    return data; 
}

JSIndexScript.prototype.FXG_INDEX3=function()
{
    let data =
    {
        Name: '量能黄金点', Description: '量能黄金点', IsMainIndex: false,FloatPrecision:0,
        Args: [],
        Script: //脚本
'A:=IFF((CLOSE>126.32),VOL,VOL); \n\
主力:=MA(A,4),COLORRED;\n\
游资:=MA(A,8),COLORYELLOW;\n\
大户:=MA(A,16),COLORF0F000;\n\
散户:=MA(A,32),COLOR00FF00;\n\
主比:=ABS(((主力)/(主力 + 游资 + 大户 + 散户))*(100)),LINESTICK,COLORRED;\n\
游比:=ABS(((游资)/(主力 + 游资 + 大户 + 散户))*(100)),LINESTICK,COLORYELLOW;\n\
大比:=ABS(((大户)/(主力 + 游资 + 大户 + 散户))*(100)),LINESTICK,COLORF0F000;\n\
散比:=ABS(((散户)/(主力 + 游资 + 大户 + 散户))*(100)),LINESTICK,COLOR00FF00;\n\
警戒线:MA(A,180),COLORFF66FF;\n\
STICKLINE((主力 > 0),0,主力,2.5,0),COLOR1020BB;\n\
STICKLINE((主力 > 0),0,主力,0.7,0),COLORRED;\n\
STICKLINE((游资 > 0),0,游资,2.5,0),COLOR009CFF;\n\
STICKLINE((游资 > 0),0,游资,0.7,0),COLORYELLOW;\n\
STICKLINE((大户 > 0),0,大户,2.5,0),COLORFF8800;\n\
STICKLINE((大户 > 0),0,大户,0.7,0),COLORLIBLUE;\n\
STICKLINE((散户 > 0),0,散户,2.5,0),COLOR00CA00;\n\
STICKLINE((散户 > 0),0,散户,0.7,0),COLORGREEN;'
    };

    return data; 
}


JSIndexScript.prototype.NewsNegative=function()
{
    let data=
        {
            Name: '负面新闻', Description: '负面新闻统计', IsMainIndex: false,FloatPrecision:0,
            Args: [{ Name: 'N', Value: 5 }, { Name: 'N2', Value: 10 }],
            Script: //脚本
'负面:NEWS(1);\n\
MA1:MA(负面,N);\n\
MA2:MA(负面,N2);'
        };

    return data;
}

JSIndexScript.prototype.UpDownAnalyze=function()
{
    let data=
    {
        Name: '涨跌趋势', Description: '涨跌趋势', IsMainIndex: false,FloatPrecision:0, 
        Condition: { Period:[CONDITION_PERIOD.MINUTE_ID, CONDITION_PERIOD.MULTIDAY_MINUTE_ID, CONDITION_PERIOD.KLINE_DAY_ID] },
        Args: [],
        Script: //脚本
"上涨家数:UPCOUNT('CNA.CI'),COLORRED;\n\
下跌家数:DOWNCOUNT('CNA.CI'),COLORGREEN;"
    };

    return data;
}

JSIndexScript.prototype.HK2SHSZ=function()
{
    let data=
    {
        Name: '北上资金', Description: '北上资金', IsMainIndex: false,FloatPrecision:0, 
        Condition: { Period:[CONDITION_PERIOD.MINUTE_ID,CONDITION_PERIOD.MULTIDAY_MINUTE_ID,CONDITION_PERIOD.KLINE_DAY_ID] },
        Args: [],
        Script: //脚本
            "净流入:HK2SHSZ(1),COLORSTICK;"
    };

    return data;
}

JSIndexScript.prototype.ShareHolder=function()
{
    let data=
    {
        Name: '股东人数', Description: '股东人数', IsMainIndex: false,FloatPrecision:0, 
        Condition: { Period:[ 
                                CONDITION_PERIOD.KLINE_DAY_ID,
                                CONDITION_PERIOD.KLINE_MONTH_ID,
                                CONDITION_PERIOD.KLINE_WEEK_ID,
                                CONDITION_PERIOD.KLINE_YEAR_ID] },
        Args: [],
        Script: //脚本
            "人数:FINANCE(100);"
    };

    return data;
}

JSIndexScript.prototype.VOLRate=function()
{
    let data=
    {
        Name: '量比', Description: '量比', IsMainIndex: false,  Condition: { Period:[CONDITION_PERIOD.MINUTE_ID, CONDITION_PERIOD.MULTIDAY_MINUTE_ID ] },
        Args: [],
        Script: //脚本
            "LIANGBI:VOLR;"
    };

    return data;
}

////////////////////////////////////////////////////////////////////////////////////////////////
//五彩K线

JSIndexScript.prototype.COLOR_KSTAR1=function()
{
    let data=
    {
        Name: '十字星', Description: '十字星', IsMainIndex: true, InstructionType:2,
        Script: //脚本
            'KSTAR:CLOSE==OPEN&&HIGH>LOW;'
    };

    return data;
}

JSIndexScript.prototype.COLOR_KSTAR2=function()
{
    let data=
    {
        Name: '早晨之星', Description: '早晨之星', IsMainIndex: true, InstructionType:2,
        Script: //脚本
            'KSTAR:(REF(CLOSE,2)/REF(OPEN,2)<0.95) && (REF(OPEN,1) < REF(CLOSE,2)) && (ABS(REF(OPEN,1)-REF(CLOSE,1))/REF(CLOSE,1)<0.03) && CLOSE/OPEN>1.05 && CLOSE>REF(CLOSE,2);'
    };

    return data;
}

JSIndexScript.prototype.COLOR_KSTAR3=function()
{
    let data=
    {
        Name: '黄昏之星', Description: '黄昏之星', IsMainIndex: true, InstructionType:2,
        Script: //脚本
            'KSTAR:REF(CLOSE,2)/REF(OPEN,2)>1.05 && REF(OPEN,1)>REF(CLOSE,2) && ABS(REF(OPEN,1)-REF(CLOSE,1))/REF(CLOSE,1)<0.03 && CLOSE/OPEN<0.95 && CLOSE<REF(CLOSE,2);'
    };

    return data;
}

JSIndexScript.prototype.COLOR_SHI1=function()
{
    let data=
    {
        Name: '长十字', Description: '长十字', IsMainIndex: true, InstructionType:2,
        Script: //脚本
            'KSTAR:CLOSE==OPEN&&HIGH/LOW>1.03;'
    };

    return data;
}

JSIndexScript.prototype.COLOR_K220=function()
{
    let data=
    {
        Name: '身怀六甲', Description: '身怀六甲', IsMainIndex: true, InstructionType:2,
        Script: //脚本
            'KSTAR:ABS(REF(CLOSE,1)-REF(OPEN,1))/REF(CLOSE,1)>0.04&&\n\
            ABS(CLOSE-OPEN)/CLOSE<0.005&&\n\
            MAX(CLOSE,OPEN)<MAX(REF(CLOSE,1),REF(OPEN,1))&&\n\
            MIN(CLOSE,OPEN)>MIN(REF(CLOSE,1),REF(OPEN,1));'
    };

    return data;
}

JSIndexScript.prototype.COLOR_K300=function()
{
    let data=
    {
        Name: '三个白武士', Description: '三个白武士', IsMainIndex: true, InstructionType:2,
        Script: //脚本
            'KSTAR:UPNDAY(CLOSE,3)&&NDAY(CLOSE,OPEN,3);'
    };

    return data;
}


JSIndexScript.prototype.COLOR_K310=function()
{
    let data=
    {
        Name: '三只乌鸦', Description: '三只乌鸦', IsMainIndex: true, InstructionType:2,
        Script: //脚本
            'KSTAR:DOWNNDAY(CLOSE,3)&&NDAY(OPEN,CLOSE,3);'
    };

    return data;
}

JSIndexScript.prototype.COLOR_K380=function()
{
    let data=
    {
        Name: '光头阳线', Description: '光头阳线', IsMainIndex: true, InstructionType:2,
        Script: //脚本
            'KSTAR:HIGH==CLOSE&&HIGH>LOW;'
    };

    return data;
}

JSIndexScript.prototype.COLOR_K390=function()
{
    let data=
    {
        Name: '光脚阴线', Description: '光脚阴线', IsMainIndex: true, InstructionType:2,
        Script: //脚本
            'KSTAR:LOW==CLOSE&&HIGH>LOW;'
    };

    return data;
}

JSIndexScript.prototype.COLOR_K134=function()
{
    let data=
    {
        Name: '垂死十字', Description: '垂死十字', IsMainIndex: true, InstructionType:2,
        Script: //脚本
            'KSTAR:CLOSE==OPEN&&CLOSE==LOW&&CLOSE<HIGH;'
    };

    return data;
}

JSIndexScript.prototype.COLOR_K140=function()
{
    let data=
    {
        Name: '早晨十字星', Description: '早晨十字星', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'KSTAR:REF(CLOSE,2)/REF(OPEN,2)<0.95&&\n\
REF(OPEN,1)<REF(CLOSE,2)&&\n\
REF(OPEN,1)==REF(CLOSE,1)&&\n\
CLOSE/OPEN>1.05&&CLOSE>REF(CLOSE,2);'
    };

    return data;
}

JSIndexScript.prototype.COLOR_K150=function()
{
    let data=
    {
        Name: '黄昏十字星', Description: '黄昏十字星', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'KSTAR:REF(CLOSE,2)/REF(OPEN,2)>1.05&&\n\
REF(OPEN,1)>REF(CLOSE,2)&&\n\
REF(OPEN,1)=REF(CLOSE,1)&&\n\
CLOSE/OPEN<0.95&&CLOSE<REF(CLOSE,2);'
    };

    return data;
}

JSIndexScript.prototype.COLOR_K160=function()
{
    let data=
    {
        Name: '射击之星', Description: '射击之星', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'KSTAR:MIN(OPEN,CLOSE)==LOW&&\n\
HIGH-LOW>3*(MAX(OPEN,CLOSE)-LOW)&&\n\
CLOSE>MA(CLOSE,5);'
    };

    return data;
}

JSIndexScript.prototype.COLOR_K165=function()
{
    let data=
    {
        Name: '倒转锤头', Description: '倒转锤头', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'KSTAR:MIN(OPEN,CLOSE)==LOW&&\n\
HIGH-LOW>3*(MAX(OPEN,CLOSE)-LOW)&&\n\
CLOSE<MA(CLOSE,5);'
    };

    return data;
}

JSIndexScript.prototype.COLOR_K170=function()
{
    let data=
    {
        Name: '锤头', Description: '锤头', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'OUT:HIGH==MAX(OPEN,CLOSE)&&\n\
HIGH-LOW>3*(HIGH-MIN(OPEN,CLOSE))&&\n\
CLOSE<MA(CLOSE,5);'
    };

    return data;
}

JSIndexScript.prototype.COLOR_K180=function()
{
    let data=
    {
        Name: '吊颈', Description: '吊颈', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'OUT:HIGH==MAX(OPEN,CLOSE)&&\n\
HIGH-LOW>3*(HIGH-MIN(OPEN,CLOSE))&&\n\
CLOSE>MA(CLOSE,5);'
    };

    return data;
}

JSIndexScript.prototype.COLOR_K190=function()
{
    let data=
    {
        Name: '穿头破脚', Description: '穿头破脚', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'OUT:(REF(CLOSE,1)/REF(OPEN,1)>1.03&&\n\
CLOSE/OPEN<0.96&&\n\
CLOSE<REF(OPEN,1)&&OPEN>REF(CLOSE,1))||\n\
(REF(CLOSE,1)/REF(OPEN,1)<0.97&&\n\
CLOSE/OPEN>1.04&&\n\
CLOSE>REF(OPEN,1)&&OPEN<REF(CLOSE,1));'
    };

    return data;
}

JSIndexScript.prototype.COLOR_SWORD=function()
{
    let data=
    {
        Name: '剑', Description: '剑', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'AA:=VOL>REF(VOL,1)||VOL>(CAPITAL*0.1);\n\
BB:=OPEN>=(REF(HIGH,1))&&REF(HIGH,1)>(REF(HIGH,2)*1.06);\n\
CC:=CLOSE>(REF(CLOSE,1))-(REF(CLOSE,1)*0.01);\n\
DD:=CLOSE<(HIGH*0.965) && HIGH>(OPEN*1.05);\n\
EE:=LOW<OPEN && LOW<CLOSE&&HIGH>(REF(CLOSE,1)*1.06);\n\
FF:=(HIGH-(MAX(OPEN,CLOSE)))/2>(MIN(OPEN,CLOSE))-LOW;\n\
GG:=(ABS(OPEN-CLOSE))/2<(MIN(OPEN,CLOSE)-LOW);\n\
SWORDO:AA&&BB&&CC&&DD&&EE&&FF&&GG;'
    };

    return data;
}

JSIndexScript.prototype.COLOR_CSFR=function()
{
    let data=
    {
        Name: '出水芙蓉', Description: '出水芙蓉', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'A:=CLOSE>OPEN;\n\
B:=A&&CLOSE>MA(CLOSE,S)&&CLOSE>MA(CLOSE,M)&&CLOSE>MA(CLOSE,LL);\n\
CC:=B&&OPEN<MA(CLOSE,M)&&OPEN<MA(CLOSE,LL);\n\
CSFRO:CC&&(CLOSE-OPEN)>0.0618*CLOSE;'
    };

    return data;
}

JSIndexScript.prototype.COLOR_WYGD=function()
{
    let data=
    {
        Name: '乌云盖顶', Description: '乌云盖顶', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'VAR1:BACKSET( \n\
REF(CLOSE,1)/REF(OPEN,1)>1.03 AND \n\
CLOSE/OPEN<0.97 AND \n\
OPEN>REF(CLOSE,1) AND CLOSE<REF(CLOSE,1), 3);'
    };

    return data;
}

JSIndexScript.prototype.COLOR_SGCJ=function()
{
    let data=
    {
        Name: '曙光初现', Description: '曙光初现', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'VAR1:BACKSET( \n\
REF(CLOSE,1)/REF(OPEN,1)<0.97 AND \n\
CLOSE/OPEN>1.03 AND \n\
OPEN<REF(CLOSE,1) AND CLOSE>REF(CLOSE,1), 3);'
    };

    return data;
}

JSIndexScript.prototype.COLOR_SZTAI=function()
{
    let data=
    {
        Name: '十字胎', Description: '十字胎', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'VAR1:BACKSET( ABS(REF(CLOSE,1)-REF(OPEN,1))/REF(CLOSE,1) > 0.04 AND \n\
CLOSE==OPEN AND CLOSE < MAX(REF(CLOSE,1),REF(OPEN,1)) AND \n\
CLOSE > MIN(REF(CLOSE,1),REF(OPEN,1)), 2);'
    };

    return data;
}

JSIndexScript.prototype.COLOR_PINGDING=function()
{
    let data=
    {
        Name: '平顶', Description: '平顶', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'VAR1:BACKSET(ABS(HIGH-REF(HIGH,1))/HIGH<0.001,2);'
    };

    return data;
}

JSIndexScript.prototype.COLOR_PINGDI=function()
{
    let data=
    {
        Name: '平底', Description: '平底', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'VAR1:BACKSET((ABS(LOW-REF(LOW,1))/LOW<0.001 AND \n\
ABS(REF(LOW,1)-REF(LOW,2))/REF(LOW,1)<=0.001),2);'
    };

    return data;
}

JSIndexScript.prototype.COLOR_DAYANZHU=function()
{
    let data=
    {
        Name: '大阳烛', Description: '大阳烛', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'VAR1:CLOSE/OPEN>1.05 AND HIGH/LOW < CLOSE/OPEN+0.018;'
    };

    return data;
}

JSIndexScript.prototype.COLOR_DAYINGZHU=function()
{
    let data=
    {
        Name: '大阴烛', Description: '大阴烛', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'VAR1:OPEN/CLOSE > 1.05 AND HIGH/LOW < OPEN/CLOSE+0.018;'
    };

    return data;
}

JSIndexScript.prototype.COLOR_HYFG=function()
{
    let data=
    {
        Name: '好友反攻', Description: '好友反攻', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'VAR1:BACKSET( (REF(CLOSE,1)<REF(OPEN,1) AND \n\
CLOSE>OPEN AND ABS(CLOSE-REF(CLOSE,1))/CLOSE<0.002),2);'
    };

    return data;
}

JSIndexScript.prototype.COLOR_TKQK=function()
{
    let data=
    {
        Name: '跳空缺口', Description: '跳空缺口', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'VAR1:BACKSET( HIGH<REF(LOW,1) OR LOW>REF(HIGH,1),2);'
    };

    return data;
}

JSIndexScript.prototype.COLOR_SFWY=function()
{
    let data=
    {
        Name: '双飞乌鸦', Description: '双飞乌鸦', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'VAR1:BACKSET( REF(CLOSE,1)<REF(OPEN,1) AND CLOSE<OPEN AND CLOSE/OPEN<0.98,1);'
    };

    return data;
}

JSIndexScript.prototype.COLOR_SSSBQ=function()
{
    let data=
    {
        Name: '上升三部曲', Description: '上升三部曲', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'VAR1:BACKSET( \n\
REF(CLOSE,4)/REF(OPEN,4)>1.03 AND \n\
REF(CLOSE,3)<REF(OPEN,3) AND \n\
REF(CLOSE,2)<REF(OPEN,2) AND \n\
REF(CLOSE,1)<REF(OPEN,1) AND \n\
REF(LOW,4)<REF(LOW,3) AND \n\
REF(LOW,4)<REF(LOW,2) AND \n\
REF(LOW,4)<REF(LOW,1) AND \n\
REF(HIGH,4)>REF(HIGH,3) AND \n\
REF(HIGH,4)>REF(HIGH,2) AND \n\
REF(HIGH,4)>REF(HIGH,1) AND \n\
CLOSE/OPEN>1.03 AND \n\
CLOSE>REF(CLOSE,4), 5);'
    };

    return data;
}

JSIndexScript.prototype.COLOR_XDSBQ=function()
{
    let data=
    {
        Name: '下跌三部曲', Description: '下跌三部曲', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'VAR1:BACKSET( \n\
REF(CLOSE,4)/REF(OPEN,4)<0.97 AND \n\
REF(CLOSE,3)>REF(OPEN,3) AND \n\
REF(CLOSE,2)>REF(OPEN,2) AND \n\
REF(CLOSE,1)>REF(OPEN,1) AND \n\
REF(LOW,4)<REF(LOW,3) AND \n\
REF(LOW,4)<REF(LOW,2) AND \n\
REF(LOW,4)<REF(LOW,1) AND \n\
REF(HIGH,4)>REF(HIGH,3) AND \n\
REF(HIGH,4)>REF(HIGH,2) AND \n\
REF(HIGH,4)>REF(HIGH,1) AND \n\
CLOSE/OPEN<0.97 AND \n\
CLOSE<REF(CLOSE,4), 5);'
    };

    return data;
}

JSIndexScript.prototype.COLOR_CHXY=function()
{
    let data=
    {
        Name: '长下影', Description: '长下影', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'VAR2:(MIN(CLOSE,OPEN)-LOW)/(HIGH-LOW)>0.667;'
    };

    return data;
}

JSIndexScript.prototype.COLOR_CHSY=function()
{
    let data=
    {
        Name: '长上影', Description: '长上影', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'VAR2:(HIGH-MAX(CLOSE,OPEN))/(HIGH-LOW)>0.667,COLORBLUE;'
    };

    return data;
}

JSIndexScript.prototype.COLOR_FENLI=function()
{
    let data=
    {
        Name: '分离', Description: '分离', IsMainIndex: true, InstructionType:2,
        Script: //脚本
'VAR1:BACKSET( OPEN==REF(OPEN,1) AND (CLOSE-OPEN)*(REF(CLOSE,1)-REF(OPEN,1))<0,2);'
    };

    return data;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//交易系统

JSIndexScript.prototype.TRADE_BIAS = function () 
{
    let data =
    {
        Name: 'BIAS', Description: '乖离率专家系统', IsMainIndex: true, InstructionType:1,
        Args: [{ Name: 'N', Value: 12 }, { Name: 'LL', Value: 6 },{ Name: 'LH', Value: 6 }],
        Script: //脚本
'BIAS:=(CLOSE-MA(CLOSE,N))/MA(CLOSE,N)*100;\n\
ENTERLONG:CROSS(-LL,BIAS);\n\
EXITLONG:CROSS(BIAS,LH);'

    };

    return data;
}

JSIndexScript.prototype.TRADE_CCI = function () 
{
    let data =
    {
        Name: 'CCI', Description: 'CCI专家系统', IsMainIndex: true, InstructionType:1,
        Args: [{ Name: 'N', Value: 14 }],
        Script: //脚本
'TYP:=(HIGH+LOW+CLOSE)/3;\n\
CCI:=(TYP-MA(TYP,N))/(0.015*AVEDEV(TYP,N));\n\
INDEX:=CCI;\n\
ENTERLONG:CROSS(INDEX,-100);\n\
EXITLONG:CROSS(100,INDEX);'
    };

    return data;
}

JSIndexScript.prototype.TRADE_DMI = function () 
{
    let data =
    {
        Name: 'DMI', Description: '趋向专家系统', IsMainIndex: true, InstructionType:1,
        Args: [{ Name: 'N', Value: 14 }],
        Script: //脚本
'MTR:=SUM(MAX(MAX(HIGH-LOW,ABS(HIGH-REF(CLOSE,1))),ABS(LOW-REF(CLOSE,1))),N);\n\
HD :=HIGH-REF(HIGH,1);\n\
LD :=REF(LOW,1)-LOW;\n\
PDM:=SUM(IF(HD>0&&HD>LD,HD,0),N);\n\
MDM:=SUM(IF(LD>0&&LD>HD,LD,0),N);\n\
PDI:=PDM*100/MTR;\n\
MDI:=MDM*100/MTR;\n\
ENTERLONG:CROSS(PDI,MDI);\n\
EXITLONG:CROSS(MDI,PDI);'
    };

    return data;
}

JSIndexScript.prototype.TRADE_KD = function () 
{
    let data =
    {
        Name: 'KD', Description: 'KD指标专家系统', IsMainIndex: true, InstructionType:1,
        Args: [{ Name: 'N', Value: 9 },{ Name: 'M1', Value: 3 },{ Name: 'M2', Value: 3 }],
        Script: //脚本
'WRSV:=(CLOSE-LLV(LOW,N))/(HHV(HIGH,N)-LLV(LOW,N))*100;\n\
WK:=SMA(WRSV,M1,1);\n\
D:=SMA(WK,M2,1);\n\
ENTERLONG:CROSS(WK,D)&&WK<20;\n\
EXITLONG:CROSS(D,WK)&&WK>80;'
    };

    return data;
}

JSIndexScript.prototype.TRADE_BOLL = function () 
{
    let data =
    {
        Name: 'BOLL', Description: '布林带专家系统', IsMainIndex: true, InstructionType:1,
        Args: [{ Name: 'N', Value: 20 }],
        Script: //脚本
'MID :=MA(CLOSE,N);\n\
UPPER:=MID+2*STD(CLOSE,N);\n\
LOWER:=MID-2*STD(CLOSE,N);\n\
ENTERLONG:CROSS(CLOSE,LOWER);\n\
EXITLONG:CROSS(CLOSE,UPPER);'
    };

    return data;
}

JSIndexScript.prototype.TRADE_KDJ = function () 
{
    let data =
    {
        Name: 'KDJ', Description: 'KDJ专家系统', IsMainIndex: true, InstructionType:1,
        Args: [{ Name: 'N', Value: 9 },{ Name: 'M1', Value: 3 }],
        Script: //脚本
'RSV:=(CLOSE-LLV(LOW,N))/(HHV(HIGH,N)-LLV(LOW,N))*100;\n\
K:=SMA(RSV,M1,1);\n\
D:=SMA(K,M1,1);\n\
J:=3*K-2*D;\n\
ENTERLONG:CROSS(J,0);\n\
EXITLONG:CROSS(100,J);'
    };

    return data;
}

JSIndexScript.prototype.TRADE_MA = function () 
{
    let data =
    {
        Name: 'MA', Description: '均线专家系统', IsMainIndex: true, InstructionType:1,
        Args: [{ Name: 'SHORT', Value: 5 },{ Name: 'LONG', Value: 20 }],
        Script: //脚本
'ENTERLONG:CROSS(MA(CLOSE,SHORT),MA(CLOSE,LONG));\n\
EXITLONG:CROSS(MA(CLOSE,LONG),MA(CLOSE,SHORT));'
    };

    return data;
}

JSIndexScript.prototype.TRADE_MACD = function () 
{
    let data =
    {
        Name: 'MACD', Description: 'MACD专家系统', IsMainIndex: true, InstructionType:1,
        Args: [{ Name: 'LONG', Value: 26 }, { Name: 'SHORT', Value: 12 }, { Name: 'M', Value: 9 }],
        Script: //脚本
'DIFF:=EMA(CLOSE,SHORT) - EMA(CLOSE,LONG);\n\
DEA  := EMA(DIFF,M);\n\
MACD := 2*(DIFF-DEA);\n\
ENTERLONG:CROSS(MACD,0);\n\
EXITLONG:CROSS(0,MACD);'
    };

    return data;
}

JSIndexScript.prototype.TRADE_MTM = function () 
{
    let data =
    {
        Name: 'MTM', Description: '动力指标专家系统', IsMainIndex: true, InstructionType:1,
        Args: [{ Name: 'N', Value: 6 }],
        Script: //脚本
'WMTM:=C-REF(C,N);\n\
ENTERLONG:CROSS(WMTM,0);\n\
EXITLONG:CROSS(0,WMTM);'
    };

    return data;
}

JSIndexScript.prototype.TRADE_PSY = function () 
{
    let data =
    {
        Name: 'PSY', Description: 'PSY心理线专家系统', IsMainIndex: true, InstructionType:1,
        Args: [{ Name: 'N', Value: 12 },{ Name: 'LL', Value: 10 },{ Name: 'LH', Value: 85 }],
        Script: //脚本
'MYPSY:=COUNT(CLOSE>REF(CLOSE,1),N)/N*100;\n\
ENTERLONG:CROSS(LL,MYPSY);\n\
EXITLONG:CROSS(MYPSY,LH);'
    };

    return data;
}

JSIndexScript.prototype.TRADE_ROC = function () 
{
    let data =
    {
        Name: 'ROC', Description: '变动速率专家系统', IsMainIndex: true, InstructionType:1,
        Args: [{ Name: 'N', Value: 12 },{ Name: 'M', Value: 6 }],
        Script: //脚本
'WROC:=MA(100*(CLOSE-REF(CLOSE,N))/REF(CLOSE,N),M);\n\
ENTERLONG:CROSS(WROC,0);\n\
EXITLONG:CROSS(0,WROC);'
    };

    return data;
}

JSIndexScript.prototype.TRADE_RSI = function () 
{
    let data =
    {
        Name: 'RSI', Description: '相对强弱专家系统', IsMainIndex: true, InstructionType:1,
        Args: [{ Name: 'N', Value: 6 },{ Name: 'LL', Value: 20 },{ Name: 'LH', Value: 80 }],
        Script: //脚本
'LC:=REF(CLOSE,1);\n\
WRSI:=SMA(MAX(CLOSE-LC,0),N,1)/SMA(ABS(CLOSE-LC),N,1)*100;\n\
ENTERLONG:CROSS(WRSI,LL);\n\
EXITLONG:CROSS(LH,WRSI);'
    };

    return data;
}

JSIndexScript.prototype.TRADE_VR = function () 
{
    let data =
    {
        Name: 'VR', Description: 'VR容量比率专家系统', IsMainIndex: true, InstructionType:1,
        Args: [{ Name: 'N', Value: 26 },{ Name: 'LL', Value: 70 },{ Name: 'LH', Value: 250 }],
        Script: //脚本
'WVR := SUM((IF(CLOSE>OPEN,VOL,0)+IF(CLOSE=OPEN,VOL/2,0)),N)/SUM((IF(CLOSE<OPEN,VOL,0)+IF(CLOSE=OPEN,VOL/2,0)),N)*100;\n\
ENTERLONG:CROSS(LL,WVR);\n\
EXITLONG:CROSS(WVR,LH);'
    };

    return data;
}

JSIndexScript.prototype.TRADE_DPSJ = function () 
{
    let data =
    {
        Name: 'DPSJ', Description: '大盘随机专家系统', IsMainIndex: true, InstructionType:1,
        Args: [{ Name: 'N1', Value: 18 },{ Name: 'N2', Value: 12 }],
        Script: //脚本
'RSV:=(INDEXC-LLV(INDEXL,N1))/(HHV(INDEXH,N1)-LLV(INDEXL,N1))*100;\n\
K:=SMA(RSV,N2,1);\n\
HSL:VOL/100/(FINANCE(7));\n\
ENTERLONG: CROSS(K,20);\n\
EXITLONG: (CROSS(HSL,5) OR CROSS(K,80));'
    };

    return data;
}


JSIndexScript.prototype.Zealink_Index1 = function () 
{
    let data =
    {
        Name: '资金吸筹', Description: '资金吸筹', IsMainIndex: false,
        Args: [],
        Script: //脚本
'VAR1:=REF((LOW+OPEN+CLOSE+HIGH)/4,1);  \n\
VAR2:= SMA(ABS(LOW - VAR1), 13, 1) / SMA(MAX(LOW - VAR1, 0), 10, 1);\n\
VAR3:= EMA(VAR2, 10);\n\
VAR4:= LLV(LOW, 33);\n\
VAR5:= EMA(IF(LOW <= VAR4, VAR3, 0), 3) * 0.2;\n\
主力进场: IF(VAR5 > REF(VAR5, 1), VAR5,0), COLORRED, NODRAW;\n\
洗盘: IF(VAR5 < REF(VAR5, 1),  VAR5,0), COLORYELLOW, NODRAW;\n\
STICKLINE(VAR5> REF(VAR5, 1),0, VAR5, 20, 0), COLORRED;\n\
STICKLINE(VAR5 < REF(VAR5, 1), 0, VAR5, 20, 0), COLORYELLOW;'
    };

    return data;
}

JSIndexScript.prototype.Zealink_Index2 = function () 
{
    let data =
    {
        Name: '牛熊区间', Description: '牛熊区间', IsMainIndex: false,YSpecificMaxMin:{Max:100,Min:1,Count:4},YSplitScale:[1,50,100],
        Args: [],
        Script: //脚本
'短高H:=(20*H+19*REF(H,1)+18*REF(H,2)+17*REF(H,3)+16*REF(H,4)+15*REF(H,5)+14*REF(H,6)\n\
+ 13 * REF(H, 7) + 12 * REF(H, 8) + 11 * REF(H, 9) + 10 * REF(H, 10) + 9 * REF(H, 11) + 8 * REF(H, 12)\n\
+ 7 * REF(H, 13) + 6 * REF(H, 14) + 5 * REF(H, 15) + 4 * REF(H, 16) + 3 * REF(H, 17) + 2 * REF(H, 18) +\n\
REF(H, 20))/ 210, COLORBLUE, LINETHICK1;\n\
短低L:= (20 * L + 19 * REF(L, 1) + 18 * REF(L, 2) + 17 * REF(L, 3) + 16 * REF(L, 4) + 15 * REF(L, 5) + 14 * REF(L, 6)\n\
+ 13 * REF(L, 7) + 12 * REF(L, 8) + 11 * REF(L, 9) + 10 * REF(L, 10) + 9 * REF(L, 11) + 8 * REF(L, 12)\n\
+ 7 * REF(L, 13) + 6 * REF(L, 14) + 5 * REF(L, 15) + 4 * REF(L, 16) + 3 * REF(L, 17) + 2 * REF(L, 18) +\n\
REF(L, 20)) / 210, COLORBLUE, LINETHICK1;\n\
D90H:= EMA(短高H, 90), COLORRED, LINETHICK1;\n\
D90L:= EMA(短低L, 90), COLORRED, LINETHICK1;\n\
D90差:= D90H - D90L;\n\
D90顶:= D90H + D90差 * 2, COLORRED, LINETHICK1;\n\
D90底:= D90L - D90差 * 2, COLORRED, LINETHICK1;\n\
高0:= (EMA(EMA(H, 25), 25) - EMA(EMA(L, 25), 25)) * 1 + EMA(EMA(H, 25), 25), LINETHICK1, COLORWHITE;\n\
低0:= EMA(EMA(L, 25), 25) - (EMA(EMA(H, 25), 25) - EMA(EMA(L, 25), 25)) * 1, LINETHICK1, COLORWHITE;\n\
多头定位:= 低0 >= D90底 AND 高0 >= D90顶;\n\
空头定位:= 高0 <= D90顶 AND 低0 <= D90底;\n\
震荡定位:= 低0 >= D90底 AND 高0 <= D90顶;\n\
牛市: IF(多头定位 == 1, 100, 1), COLORRED, NODRAW;\n\
熊市: IF(空头定位 == 1, 100, 1), COLORGREEN, NODRAW;\n\
震荡: IF(震荡定位 == 1, 100, 1), COLORGRAY, NODRAW;\n\
STICKLINE(多头定位 == 1, 100, 1, 100, 0), COLORRED;\n\
STICKLINE(空头定位 == 1, 100, 1, 100, 0), COLORGREEN;\n\
STICKLINE(震荡定位 == 1, 100, 1, 100, 0), COLORGRAY;'
    };

    return data;
}

JSIndexScript.prototype.Zealink_Index3 = function () 
{
    let data =
    {
        Name: '持仓信号', Description: '持仓信号', IsMainIndex: true,
        Args: [],
        Script: //脚本
'买线:=EMA(C,2);\n\
卖线:=EMA(SLOPE(C,30)*5+C,20); \n\
BU:=CROSS(买线,卖线);\n\
SEL:=CROSS(卖线,买线);\n\
\n\
STICKLINE(买线>=卖线 AND CLOSE>OPEN,LOW,HIGH,0,1),COLORRED;\n\
STICKLINE(买线>=卖线 AND CLOSE<OPEN,LOW,HIGH,0,1),COLORRED;\n\
STICKLINE(买线>=卖线 AND CLOSE>OPEN,CLOSE,OPEN,50,1),COLORRED;\n\
STICKLINE(买线>=卖线 AND CLOSE<OPEN,CLOSE,OPEN,50,0),COLORRED;\n\
STICKLINE(买线<卖线 AND CLOSE<OPEN,LOW,HIGH,0,1),COLORGREEN;\n\
STICKLINE(买线<卖线 AND CLOSE>OPEN,LOW,HIGH,0,1),COLORGREEN;\n\
STICKLINE(买线<卖线 AND CLOSE<OPEN,CLOSE,OPEN,50,0),COLORGREEN;\n\
STICKLINE(买线<卖线 AND CLOSE>OPEN,CLOSE,OPEN,50,1),COLORGREEN;\n\
\n\
HHJSJDA:=(3*CLOSE+OPEN+LOW+HIGH)/6;\n\
HHJSJDB:(19*HHJSJDA+19*REF(HHJSJDA,1)+18*REF(HHJSJDA,2)+17*REF(HHJSJDA,3)+16*REF(HHJSJDA,4)+15*REF(HHJSJDA,5)+14*REF(HHJSJDA,6)\n\
+13*REF(HHJSJDA,7)+12*REF(HHJSJDA,8)+11*REF(HHJSJDA,9)+10*REF(HHJSJDA,10)+9*REF(HHJSJDA,11)+8*REF(HHJSJDA,12)+7*REF(HHJSJDA,13)+6*REF(HHJSJDA,14)+5*REF(HHJSJDA,15)+4*REF(HHJSJDA,16)+3*REF(HHJSJDA,17)+2*REF\n\
(HHJSJDA,20)+REF(HHJSJDA,19))/210,COLORYELLOW;\n\
HHJSJDC:MA(HHJSJDB,5),COLORRED;\n\
\n\
SVAR11:=HHV(HIGH,34);\n\
SVAR14:=CLOSE-REF(CLOSE,1);\n\
SVAR15:=MAX(SVAR14,0);\n\
SVAR16:=ABS(SVAR14);\n\
SVAR17:=SMA(SVAR15,7,1)/SMA(SVAR16,7,1)*100;\n\
SVAR18:=SMA(SVAR15,13,1)/SMA(SVAR16,13,1)*100;\n\
SVAR19:=BARSCOUNT(CLOSE);\n\
SVAR20:=SMA(MAX(SVAR14,0),6,1)/SMA(ABS(SVAR14),6,1)*100;\n\
SVAR21:=(-200)*(HHV(HIGH,60)-CLOSE)/(HHV(HIGH,60)-LLV(LOW,60))+100;\n\
SVAR1A:=(CLOSE-LLV(LOW,15))/(HHV(HIGH,15)-LLV(LOW,15))*100;\n\
SVAR1B:=SMA((SMA(SVAR1A,4,1)-50)*2,3,1);\n\
SVAR1C:=(INDEXC-LLV(INDEXL,14))/(HHV(INDEXH,14)-LLV(INDEXL,14))*100;\n\
SVAR1D:=SMA(SVAR1C,4,1);\n\
SVAR1E:=SMA(SVAR1D,3,1);\n\
SVAR1F:=(HHV(HIGH,30)-CLOSE)/CLOSE*100;\n\
SVAR22:=SVAR20<=25 AND SVAR21<-95 AND SVAR1F>20 AND SVAR1B<-30 AND SVAR1E<30 AND SVAR11-CLOSE>=-0.25 AND SVAR17<22 AND SVAR18<28 AND SVAR19>50;\n\
BUY3:=CROSS(SVAR22,0.5) AND COUNT(SVAR22==1,10)==1;\n\
\n\
SVARF:=LOW*0.9;\n\
SVAR10X:=100-3*SMA((OPEN-LLV(LOW,75))/(HHV(HIGH,75)-LLV(LOW,75))*100,20,1)+2*SMA(SMA((OPEN-LLV(LOW,75))/(HHV(HIGH,75)-LLV(LOW,75))*100,20,1),15,1);\n\
SVAR11X:=SVARF<REF(SVAR10X,1) AND VOL>REF(VOL,1) AND CLOSE>REF(CLOSE,1);\n\
BUY2:=SVAR11X AND COUNT(SVAR11X,30)==1;\n\
\n\
VAR1:=(CLOSE+HIGH+LOW+OPEN)/4;\n\
VAR2:=SUMBARS(VOL,CAPITAL);\n\
VAR3:=HHV(VAR1,VAR2);\n\
VAR4:=LLV(VAR1,VAR2);\n\
VAR5:=(2*VAR1-VAR4-REF(VAR4,1))/(VAR3-VAR4);\n\
VAR6:=(VAR1-VAR4)/(VAR3-VAR4);\n\
VAR7:=IF(VAR1<=VAR4,VAR5*60,VAR6*60);\n\
VAR8:=600*(EMA(CLOSE,3)-EMA(LOW,30))/EMA(LOW,30);\n\
VAR9:=EMA(VAR8,7);\n\
VARC:=HHV(HIGH,9)-LLV(LOW,9);\n\
VARD:=HHV(HIGH,9)-CLOSE;\n\
VARE:=CLOSE-LLV(LOW,9);\n\
VARF:=VARD/VARC*100-70;\n\
VAR10:=(CLOSE-LLV(LOW,60))/(HHV(HIGH,60)-LLV(LOW,60))*100;\n\
VAR11:=(2*CLOSE+HIGH+LOW)/4;\n\
VAR12:=SMA(VARE/VARC*100,3,1);\n\
VAR13:=LLV(LOW,34);\n\
VAR14:=SMA(VAR12,3,1)-SMA(VARF,9,1);\n\
VAR15:=IF(VAR14>100,VAR14-100,0);\n\
VAR16:=HHV(HIGH,34);\n\
VAR17:=EMA((VAR11-VAR13)/(VAR16-VAR13)*100,8);\n\
VAR18:=EMA(VAR17,5);\n\
BUY:=STICKLINE(VAR17-VAR18>0,VAR17,VAR18,8,1),COLORRED;\n\
SELL:=STICKLINE(VAR17-VAR18<0,VAR17,VAR18,8,1),COLORGREEN;\n\
BUY1:=VAR17>VAR18 AND REF(VAR17,1)<REF(VAR18,1);\n\
SELL1:=VAR17<VAR18 AND REF(VAR17,1)>REF(VAR18,1);\n\
\n\
短高H:=(20*H+19*REF(H,1)+18*REF(H,2)+17*REF(H,3)+16*REF(H,4)+15*REF(H,5)+14*REF(H,6)\n\
+13*REF(H,7)+12*REF(H,8)+11*REF(H,9)+10*REF(H,10)+9*REF(H,11)+8*REF(H,12)\n\
+7*REF(H,13)+6*REF(H,14)+5*REF(H,15)+4*REF(H,16)+3*REF(H,17)+2*REF(H,18)+\n\
REF(H,20))/210,COLORBLUE,LINETHICK1;\n\
短低L:=(20*L+19*REF(L,1)+18*REF(L,2)+17*REF(L,3)+16*REF(L,4)+15*REF(L,5)+14*REF(L,6)\n\
+13*REF(L,7)+12*REF(L,8)+11*REF(L,9)+10*REF(L,10)+9*REF(L,11)+8*REF(L,12)\n\
+7*REF(L,13)+6*REF(L,14)+5*REF(L,15)+4*REF(L,16)+3*REF(L,17)+2*REF(L,18)+\n\
REF(L,20))/210,COLORBLUE,LINETHICK1;\n\
D90H:=EMA(短高H,90),COLORRED,LINETHICK1;\n\
D90L:=EMA(短低L,90),COLORRED,LINETHICK1;\n\
D90差:=D90H-D90L;\n\
D90顶:=D90H+D90差*2,COLORRED,LINETHICK1;\n\
D90底:=D90L-D90差*2,COLORRED,LINETHICK1;\n\
高0:=(EMA(EMA(H,25),25)-EMA(EMA(L,25),25))*1+EMA(EMA(H,25),25),LINETHICK1,COLORWHITE;\n\
低0:=EMA(EMA(L,25),25)-(EMA(EMA(H,25),25)-EMA(EMA(L,25),25))*1,LINETHICK1,COLORWHITE;\n\
多头定位:=低0>=D90底 AND 高0>=D90顶;\n\
空头定位:=高0<=D90顶 AND 低0<=D90底;\n\
震荡定位:=低0>=D90底 AND 高0<=D90顶;\n\
\n\
牛市:=多头定位==1;\n\
熊市:=空头定位==1;\n\
震荡:=震荡定位==1;\n\
\n\
非牛市:=熊市 OR 震荡;\n\
非熊市:=牛市 OR 震荡;\n\
\n\
BUY11:=BUY1 AND 非熊市;\n\
SELL11:=SELL1 AND 震荡定位==0;\n\
\n\
BUY111:=BUY11 AND COUNT(BUY11,10)<2;\n\
BUY0:=BUY111 AND COUNT(BUY111,21)==1;\n\
SELL111:=SELL11 AND COUNT(SELL11,10)<2;\n\
SELL0:=SELL111 AND COUNT(SELL111,10)==1;\n\
\n\
XK1:=EMA(100*(CLOSE-LLV(LOW,34))/(HHV(HIGH,34)-LLV(LOW,34)),3)/4;\n\
上穿:=REF(XK1,1)<5 AND XK1>=5;\n\
BUY4:=上穿 AND COUNT(XK1<2,12)<1;\n\
\n\
SELL2:=REF(XK1,1)<=22.5 AND XK1>22.5 AND COUNT(REF(XK1,1)>=22.5 AND XK1<22.5,5)>0;\n\
SELL3:=REF(XK1,1)>=21.5 AND XK1<21.5 AND COUNT(REF(XK1,1)>=22.5 AND XK1<22.5,12)>1;\n\
SELL4:=SELL2 OR SELL3 AND COUNT((SELL2 OR SELL3)==1,5)==1;\n\
\n\
SUPERDRAWTEXT(BUY0,L,"机会",2,10),COLORRED;\n\
SUPERDRAWTEXT(SELL0,H,"风险",1,10),COLORGREEN;\n\
SUPERDRAWTEXT(BUY2,L,"机会",2,10),COLORRED;\n\
SUPERDRAWTEXT(BUY4,L,"机会",2,10),COLORRED;\n\
SUPERDRAWTEXT(SELL4,H,"风险",1,10),COLORGREEN;'
    };

    return data;
}

JSIndexScript.prototype.Zealink_Index4 = function () 
{
    let data =
    {
        Name: '股东实际增减持', Description: '股东实际增减持', IsMainIndex: false, FloatPrecision:0,
        Args: [],
        Script: //脚本
'增持:NEWS(4),NODRAW,COLORRED;\n\
减持:NEWS(5),NODRAW,COLORGREEN;\n\
STICKLINE(增持>0,0,增持,1,0),COLORRED;\n\
STICKLINE(减持<0,0,减持,1,0),COLORGREEN;'
    };

    return data;
}

JSIndexScript.prototype.Zealink_Index5 = function () 
{
    let data =
    {
        Name: '大宗交易', Description: '大宗交易', IsMainIndex: false, FloatPrecision: 0,
        Args: [],
        Script: //脚本
            '交易次数:NEWS(7);'
    };

    return data;
}

JSIndexScript.prototype.Zealink_Index6 = function () 
{
    let data =
    {
        Name: '信托持股', Description: '信托持股', IsMainIndex: false, FloatPrecision: 0,
        Args: [],
        Script: //脚本
            '家数:NEWS(6);'
    };

    return data;
}

JSIndexScript.prototype.Zealink_Index7 = function () 
{
    let data =
    {
        Name: '官网新闻', Description: '官网新闻', IsMainIndex: false, FloatPrecision: 0,
        Args: [],
        Script: //脚本
            '个数:NEWS(8);'
    };

    return data;
}

JSIndexScript.prototype.Zealink_Index8 = function () 
{
    let data =
    {
        Name: '高管要闻', Description: '高管要闻', IsMainIndex: false, FloatPrecision: 0,
        Args: [],
        Script: //脚本
            '个数:NEWS(9);'
    };

    return data;
}

JSIndexScript.prototype.Zealink_Index9 = function () 
{
    let data =
    {
        Name: '股权质押', Description: '股权质押', IsMainIndex: false, FloatPrecision: 0,
        Args: [],
        Script: //脚本
            '次数:NEWS(10);'
    };

    return data;
}

JSIndexScript.prototype.Zealink_Index10 = function () 
{
    let data =
    {
        Name: '操盘BS点', Description: '操盘BS点', IsMainIndex: true, FloatPrecision: 0,
        Args: [],
        Script: //脚本
"JJ:=(CLOSE+HIGH+LOW)/3; \n\
A:=EMA(JJ,10); \n\
B:=REF(A,1);\n\
M1:=EMA(CLOSE,3);\n\
M2:=EMA(CLOSE,8); \n\
M3:=EMA(M2,13); \n\
M4:=EMA(M2,55); \n\
B1:=A>B AND REF(A,1)<REF(B,1);\n\
S1:=A<B AND REF(A,1)>REF(B,1);\n\
INDEXCLOSE:INDEXC,EXDATA;\n\
INDEXOPEN:INDEXO,EXDATA;\n\
DRAWICON(REF(B1,1),L*0.97,13);\n\
DRAWICON(REF(S1,1),H*1.03,14);"
    };

    return data;
}

JSIndexScript.prototype.Zealink_Index11 = function () 
{
    let data =
    {
        Name: '操盘BS点', Description: '操盘BS点', IsMainIndex: true, FloatPrecision: 0,
        Args: [],
        Script: //脚本
"JJ:=(CLOSE+HIGH+LOW)/3;\n\
A:=EMA(JJ,10);\n\
B:=REF(A,1);\n\
M1:=EMA(CLOSE,3);\n\
M2:=EMA(CLOSE,8); \n\
M3:=EMA(M2,13);\n\
M4:=EMA(M2,55);\n\
持股区域:=STICKLINE(A>B,A,B,2,0),COLORYELLOW; \n\
持币区域:=STICKLINE(A<B,A,B,2,0),COLORBLUE;\n\
\n\
VR1:=(C+O+REF(C,1))/3;\n\
VR3:=HHV(VR1,21);\n\
VR4:=LLV(VR1,21);\n\
VR5:=(2*VR1-VR4-REF(VR4,1))/(VR3-VR4);\n\
VR6:=(VR1-VR4)/(VR3-VR4);\n\
VR7:=IF(VR1<=VR4,VR5*60,VR6*60);\n\
VR8:=600*(EMA(C,3)-EMA(L,30))/EMA(L,30);\n\
VR9:=EMA(VR8,7);\n\
VRA:=(WINNER(120*C/100)-WINNER(100*C/100))*100;\n\
VRB:=(-100)*(WINNER(120*C/100)-WINNER(100*C/100))+5;\n\
VRC:=HHV(H,9)-LLV(L,9);\n\
VRD:=HHV(H,9)-C;\n\
VRE:=C-LLV(L,9);\n\
VRF:=VRD/VRC*100-70;\n\
VR10:=(C-LLV(L,60))/(HHV(H,60)-LLV(L,60))*100;\n\
VR11:=(2*C+H+L)/4;\n\
VR12:=SMA(VRE/VRC*100,3,1);\n\
VR13:=LLV(L,34);\n\
VR14:=SMA(VR12,3,1)-SMA(VRF,9,1);\n\
VR15:=IF(VR14>100,VR14-100,0);\n\
VR16:=HHV(H,34);\n\
VR17:=EMA((VR11-VR13)/(VR16-VR13)*100,8);\n\
VR18:=EMA(VR17,5);\n\
\n\
B1:=A>B AND REF(A,1)<REF(B,1);\n\
S1:=A<B AND REF(A,1)>REF(B,1);\n\
\n\
B9:=BARSLAST(REF(B1,1) AND (REF(VR17>VR18,1) OR MIN(VR17,VR18)>REF(MAX(VR17,VR18),1)));\n\
S9:=BARSLAST(REF(S1,1) AND (REF(VR17<VR18,1) OR MAX(VR17,VR18)<REF(MIN(VR17,VR18),1)));\n\
\n\
DRAWICON(REF(B1,1) AND (REF(VR17>VR18,1) OR MIN(VR17,VR18)>REF(MAX(VR17,VR18),1)) AND REF(B9,2)>=S9,L*0.97,13);\n\
DRAWICON(REF(S1,1) AND (REF(VR17<VR18,1) OR MAX(VR17,VR18)<REF(MIN(VR17,VR18),1)) AND REF(S9,1)>=B9,H*1.03,14);\n\
\n\
DRAWKLINE_IF(VR17>VR18,HIGH,CLOSE,LOW,OPEN),COLORRED;\n\
DRAWKLINE_IF(VR17<VR18,HIGH,CLOSE,LOW,OPEN),COLORBLUE;\n\
\n\
INDEXCLOSE:INDEXC,EXDATA;		//取指数的收盘价 回测的时候计算BATE系数用 "
    };

    return data;
}


JSIndexScript.prototype.HeikinAshi=function()
{
    let data =
    {
        Name: '平均K线', Description: 'Heikin-Ashi 平均K线', IsMainIndex: true, KLineType:-1,
        Args: [],
        Script: //脚本
"HCLOSE:(OPEN+HIGH+LOW+CLOSE)/4, NODRAW;\n\
HOPEN:(REF(OPEN,1)+REF(CLOSE,1))/2,NODRAW;\n\
HHIGH:MAX(HIGH,MAX(HOPEN,HCLOSE)),NODRAW;\n\
HLOW:MIN(LOW,MIN(HOPEN,HCLOSE)),NODRAW;\n\
DRAWKLINE(HHIGH,HOPEN,HLOW,HCLOSE);"
    }

    return data;
}


JSIndexScript.prototype.ADL=function()
{
    let data =
    {
        Name: '腾落指标', Description: '腾落指标', IsMainIndex: false, StringFormat:2,
        Condition: 
        { 
            Period:[CONDITION_PERIOD.KLINE_DAY_ID, CONDITION_PERIOD.KLINE_WEEK_ID, CONDITION_PERIOD.KLINE_TWOWEEK_ID,
                CONDITION_PERIOD.KLINE_MONTH_ID, CONDITION_PERIOD.KLINE_QUARTER_ID ,CONDITION_PERIOD.KLINE_YEAR_ID ],
            Include:["000001.SH", "000003.SH", "000016.SH", "000300.SH", "000905.SH", "399001.SZ", " 399005.SZ", "399006.SZ"] 
        },
        Args: [ { Name: 'M', Value: 7 } ],
        Script: //脚本
"ADL:SUM(ADVANCE-DECLINE,0);\n\
MAADL:MA(ADL,M);"
    }

    return data;
}

JSIndexScript.prototype.EMPTY = function () 
{
    let data =
    {
        Name: '', Description: '空指标', IsMainIndex: true,
        Args: [],
        Script: //脚本
            'VAR2:=C;'
    };

    return data;
}

JSIndexScript.prototype.CJL = function () 
{
    let data =
    {
        Name: 'CJL', Description: '期货持仓量', IsMainIndex: false,
        Args: [],
        Script: //脚本
"成交量:VOL,VOLSTICK;\n\
持仓量:VOLINSTK,LINEOVERLAY;"
    };

    return data;
}

JSIndexScript.prototype.ASI = function () 
{
    let data =
    {
        Name: 'ASI', Description: '振动升降指标', IsMainIndex: false,
        Args: [{ Name: 'N1', Value: 6 }],
        Script: //脚本
"X_1:=REF(CLOSE,1);\n\
X_2:=ABS(HIGH-X_1);\n\
X_3:=ABS(LOW-X_1);\n\
X_4:=ABS(HIGH-REF(LOW,1));\n\
X_5:=ABS(X_1-REF(OPEN,1));\n\
X_6:=IF(X_2>X_3 AND X_2>X_4,X_2+X_3/2+X_5/4,IF(X_3>X_4 AND X_3>X_2,X_3+X_2/2+X_5/4,X_4+X_5/4));\n\
X_7:=CLOSE-X_1+(CLOSE-OPEN)/2+X_1-REF(OPEN,1);\n\
X_8:=8*X_7/X_6*MAX(X_2,X_3);\n\
ASI:SUM(X_8,0),LINETHICK2;\n\
MASI:MA(ASI,N1),LINETHICK2;"
    };

    return data;
}

/*
History
The Donchian Channels (DC) indicator was created by the famous commodities trader Richard Donchian. Donchian would become known as The Father of Trend Following.

Calculation
For this example, a 20 day period is used which is a very commonly used timeframe.

Upper Channel = 20 Day High
Lower Channel = 20 Day Low
Middle Channel = (20 Day High + 20 Day Low)/2
*/
JSIndexScript.prototype.DC = function () 
{
    let data =
    {
        Name: 'DC', Description: '唐奇安通道', IsMainIndex: true,
        Args: [{ Name: 'N1', Value: 20 }],
        Script: //脚本
"UPPER:HHV(H,N1),COLORBLUE,LINETHICK2;\n\
LOWER:LLV(L,N1),COLORBLUE,LINETHICK2;\n\
MIDDLE:(UPPER+LOWER)/2,COLORRED,LINETHICK3;"
    };

    return data;
}

/*
双重指数移动均线(DEMA)由Patrick Mulloy开发并于1994年2月在"股票与商品期货的技术分析"杂志中出版。
用于平滑价格系列并被直接应用到金融证券的价格图表中。此外，它还用于平滑其他指标的价值。

DEMA的优势是在锯齿状的价格移动中清除错误信号并允许趋势强劲时保持仓位。

计算
该指标基于指数移动平均线 (EMA). 从EMA值中查看价格偏差错误：
err(i) = Price(i) - EMA(Price, N, i)

此处:
err(i) ― 当前EMA误差;
Price(i) ― 当前价格;
EMA(Price, N, i) ― 价格系列的以N为周期的EMA的当前值。

添加指数平均线错误值到价格指数移动平均数值，可以获得EDMA；
DEMA(i) = EMA(Price,N,i)+ EMA(err,N,i) = EMA(Price,N,i)+EMA(Price-EMA(Price,N,i),N,i) =
= 2*EMA(Price,N,i)-EMA(Price-EMA(Price,N,i),N,i)=2*EMA(Price,N,i)-EMA2(Price,N,i)

此处:
EMA(err, N, i) ― 误差err的指数均线的当前值;
EMA2(Price, N, i) ― 价格的二重连续平滑的当前值。
*/
JSIndexScript.prototype.DEMA = function () 
{
    let data =
    {
        Name: 'DEMA', Description: '双重指数移动均线', IsMainIndex: true,
        Args: [{ Name: 'N1', Value: 10 }],
        Script: //脚本
"ERR:=C-EMA(C,N1);\n\
DEMA:EMA(C,10)+EMA(ERR,N1);"
    };

    return data;
}

/*
Calculation
There are five steps in calculating VWAP:

Calculate the Typical Price for the period.
    [(High + Low + Close)/3)]
Multiply the Typical Price by the period Volume.
    (Typical Price x Volume)
Create a Cumulative Total of Typical Price.
    Cumulative(Typical Price x Volume)
Create a Cumulative Total of Volume.
    Cumulative(Volume)
Divide the Cumulative Totals.
    VWAP = Cumulative(Typical Price x Volume) / Cumulative(Volume)
*/

JSIndexScript.prototype.VWAP = function () 
{
    let data =
    {
        Name: 'VWAP', Description: '成交量加权平均价', IsMainIndex: true,
        Args: [{ Name: 'N1', Value: 10 }],
        Script: //脚本
"PRICE:=(H+L+C)/3;\n\
T2:=VOL*PRICE;\n\
VWAP:SUM(T2,0)/SUM(VOL,0);"
    };

    return data;
}

JSIndexScript.prototype.SQJZ = function () 
{
    let data =
    {
        Name: 'SQJZ', Description: '神奇九转', IsMainIndex: true,
        Script: //脚本
"B:=C<REF(C,4);\n\
N:=CURRBARSCOUNT;\n\
B1:=(N=6 AND REFXV(COUNT(B,6),5)=6) OR (N=7 AND REFXV(COUNT(B,7),6)=7) OR (N=8 AND REFXV(COUNT(B,8),7)=8) OR (N>=9 AND REFXV(COUNT(B,9),8)=9);\n\
DRAWNUMBER(B1 AND REF(B,1)=0,L,1),COLORMAGENTA;\n\
B2:=(N=5 AND REFXV(COUNT(B,6),4)=6) OR (N=6 AND REFXV(COUNT(B,7),5)=7) OR (N=7 AND REFXV(COUNT(B,8),6)=8) OR (N>=8 AND REFXV(COUNT(B,9),7)=9);\n\
DRAWNUMBER(B2 AND REF(B,2)=0,L,2),COLORMAGENTA;\n\
B8:=(N=1 AND COUNT(B,8)=8) OR (N>=2 AND REFXV(COUNT(B,9),1)=9);\n\
DRAWNUMBER(B8 AND REF(B,8)=0,L,8),COLORMAGENTA;\n\
B9:=(N>=1 AND COUNT(B,9)=9);\n\
DRAWNUMBER(B9 AND REF(B,9)=0,L,9),COLORBROWN;\n\
S:=C>REF(C,4);\n\
S1:=(N=6 AND REFXV(COUNT(S,6),5)=6) OR (N=7 AND REFXV(COUNT(S,7),6)=7) OR (N=8 AND REFXV(COUNT(S,8),7)=8) OR (N>=9 AND REFXV(COUNT(S,9),8)=9);\n\
DRAWNUMBER(S1 AND REF(S,1)=0,H,1),COLORMAGENTA,DRAWABOVE;\n\
S2:=(N=5 AND REFXV(COUNT(S,6),4)=6) OR (N=6 AND REFXV(COUNT(S,7),5)=7) OR (N=7 AND REFXV(COUNT(S,8),6)=8) OR (N>=8 AND REFXV(COUNT(S,9),7)=9);\n\
DRAWNUMBER(S2 AND REF(S,2)=0,H,2),COLORMAGENTA,DRAWABOVE;\n\
S8:=(N=1 AND COUNT(S,8)=8) OR (N>=2 AND REFXV(COUNT(S,9),1)=9);\n\
DRAWNUMBER(S8 AND REF(S,8)=0,H,8),COLORMAGENTA,DRAWABOVE;\n\
S9:=(N>=1 AND COUNT(S,9)=9);\n\
DRAWNUMBER(S9 AND REF(S,9)=0,H,9),COLORGREEN,DRAWABOVE;"
    };

    return data;
}

JSIndexScript.prototype.XT = function () 
{
    let data =
    {
        Name: 'XT', Description: '箱体', IsMainIndex: true,
        Args: [{ Name: 'N', Value: 10 }],
        Script: //脚本
"【箱顶】:PEAK(CLOSE,N,1)*0.98;\n\
【箱底】:TROUGH(CLOSE,N,1)*1.02;\n\
【箱高】:100*(【箱顶】-【箱底】)/【箱底】,NODRAW;"
    };

    return data;
}

JSIndexScript.prototype.CFJT = function () 
{
    let data =
    {
        Name: 'CFJT', Description: '财富阶梯', IsMainIndex: true,
        Script: //脚本
"突破:=REF(EMA(C,14),1);\n\
A1X:=(EMA(C,10)-突破)/突破*100;\n\
多方:=IF(A1X>=0,REF(EMA(C,10),BARSLAST(CROSS(A1X,0))+1),DRAWNULL);\n\
空方:=IF(A1X<0,REF(EMA(C,10),BARSLAST(CROSS(0,A1X))+1),DRAWNULL);\n\
STICKLINE(A1X>=0,多方,突破,110,0),COLORRED;\n\
STICKLINE(A1X<0,空方,突破,110,0),COLORGREEN;"
    };

    return data;
}

JSIndexScript.prototype.CYX = function () 
{
    let data =
    {
        Name: 'CYX', Description: '撑压线', IsMainIndex: true,
        Args: [{ Name: 'N', Value: 7 }],
        Script: //脚本
"Z1:=STRCAT(HYBLOCK,' ');\n\
Z2:=STRCAT(Z1,DYBLOCK);\n\
Z3:=STRCAT(Z2,' ');\n\
DRAWTEXT_FIX(ISLASTBAR,0,0,0,STRCAT(Z3,GNBLOCK)),COLOR00C0C0;\n\
A1:=REF(H,N)=HHV(H,2*N+1);\n\
B1:=FILTER(A1,N);\n\
C1:=BACKSET(B1,N+1);\n\
D1:=FILTER(C1,N);\n\
A2:=REF(L,N)=LLV(L,2*N+1);\n\
B2:=FILTER(A2,N);\n\
C2:=BACKSET(B2,N+1);\n\
D2:=FILTER(C2,N);\n\
E1:=(REF(LLV(L,2*N),1)+REF(HHV(H,2*N),1))/2;\n\
E2:=(H+L)/2;\n\
H1:=(D1 AND NOT(D2 AND E1>=E2)) OR ISLASTBAR OR BARSCOUNT(C)=1;\n\
L1:=(D2 AND NOT(D1 AND E1<E2));\n\
H2:=D1 AND NOT(D2 AND E1>=E2);\n\
X1:=REF(BARSLAST(H1),1)+1;\n\
F1:=BACKSET(H1 AND COUNT(L1,X1)>0,LLVBARS(IF(L1,L,10000),X1));\n\
G1:=F1>REF(F1,1);\n\
I1:=BACKSET(G1,2);\n\
LD:=I1>REF(I1,1);\n\
L2:=LD OR ISLASTBAR OR BARSCOUNT(C)=1;\n\
X2:=REF(BARSLAST(L2),1)+1;\n\
F2:=BACKSET(L2 AND COUNT(H2,X2)>0,HHVBARS(IF(H2,H,0),X2));\n\
G2:=F2>REF(F2,1);\n\
I2:=BACKSET(G2,2);\n\
HD:=I2>REF(I2,1);\n\
R1:=BACKSET(ISLASTBAR,BARSLAST(HD)+1);\n\
S1:=R1>REF(R1,1);\n\
T1:=BACKSET(ISLASTBAR,BARSLAST(LD)+1);\n\
U1:=T1>REF(T1,1);\n\
R2:=BACKSET(S1,REF(BARSLAST(HD),1)+2);\n\
S2:=R2>REF(R2,1);\n\
T2:=BACKSET(U1,REF(BARSLAST(LD),1)+2);\n\
U2:=T2>REF(T2,1);\n\
DRAWLINE(S2,H,S1,H,1),LINETHICK2,COLORRED;\n\
DRAWLINE(U2,L,U1,L,1),LINETHICK2,COLORGREEN;"
    };

    return data;
}

JSIndexScript.prototype.WAVE = function () 
{
    let data =
    {
        Name: 'WAVE', Description: '波浪分析', IsMainIndex: true,
        Args: [{ Name: 'N', Value: 5 }],
        Script: //脚本
"ZIG(3,N);"
    };

    return data;
}

JSIndexScript.prototype.ShareholderCount=function()
{
    let data =
    {
        Name: '散户线', Description: '散户线', IsMainIndex: false,
        Script: //脚本
"GPJYVALUE(1,1,1);"
    };

    return data;
}

JSIndexScript.prototype.NXTS=function()
{
    let data =
    {
        Name: 'NXTS', Description: '牛熊天数', IsMainIndex: false,
        Args: [{ Name: 'N', Value: 20 }],
        Script: //脚本
"Z:=ZIG(C,N);\n\
高点:=Z>REF(Z,1) AND Z>REFX(Z,1);\n\
低点:=Z<REF(Z,1) AND Z<REFX(Z,1);\n\
NG:=BARSLAST(高点);\n\
ND:=BARSLAST(低点);\n\
D0:=DATETODAY(DATE)-DATETODAY(REF(DATE,BARSSINCE(C)));\n\
DG:=DATETODAY(DATE)-DATETODAY(REF(DATE,NG));\n\
DD:=DATETODAY(DATE)-DATETODAY(REF(DATE,ND));\n\
N1:=(NG>ND OR COUNT(高点,0)=0) AND ND>0 AND (HHV(C,ND)-REF(C,ND))/REF(C,ND)>(N/100);\n\
N2:=NG<ND AND NG>0 AND (LLV(C,NG)-REF(C,NG))/REF(C,NG)>=-(N/100);\n\
N3:=NG<ND AND NG=0;\n\
N4:=COUNT(低点 OR 高点,0)=0 AND (HHV(C,0)-REF(C,BARSSINCE(C)))/REF(C,BARSSINCE(C))>(N/100);\n\
N5:=COUNT(低点,0)=0 AND NG>0 AND (LLV(C,NG)-REF(C,NG))/REF(C,NG)>=-(N/100);\n\
N6:=COUNT(低点,0)=0 AND NG=0;\n\
X1:=(NG<ND OR COUNT(低点,0)=0) AND NG>0 AND (LLV(C,NG)-REF(C,NG))/REF(C,NG)<-(N/100);\n\
X2:=NG>ND AND ND>0 AND (HHV(C,ND)-REF(C,ND))/REF(C,ND)<=(N/100);\n\
X3:=NG>ND AND ND=0;\n\
X4:=COUNT(高点 OR 低点,0)=0 AND (LLV(C,0)-REF(C,BARSSINCE(C)))/REF(C,BARSSINCE(C))<-(N/100);\n\
X5:=COUNT(高点,0)=0 AND ND>0 AND (HHV(C,ND)-REF(C,ND))/REF(C,ND)<=(N/100);\n\
X6:=COUNT(高点,0)=0 AND ND=0;\n\
牛市天数:IF(N4 OR N5 OR N6,D0,IF(N1 OR N2 OR N3,DD,0)),COLORRED;\n\
熊市天数:IF(X4 OR X5 OR X6,D0,IF(X1 OR X2 OR X3,DG,0)),COLORGREEN;"
    };

    return data;
}

JSIndexScript.prototype.FKX=function()
{
    let data =
    {
        Name: 'FKX', Description: '反K线', IsMainIndex: false,
        Script: //脚本
"DRAWKLINE(-LOW, -OPEN, -HIGH, -CLOSE);"
    };

    return data;
}

JSIndexScript.prototype.Margin4=function()
{
    let data =
    {
        Name: '两融资金', Description: '两融资金', IsMainIndex: false,
        Script: //脚本
"TMPV:=IF(FINANCE(3)==0,REF(SCJYVALUE(1,1,1),1),REF(GPJYVALUE(3,1,1),1));\n\
TMPV1:=IF(FINANCE(3)==0,SCJYVALUE(1,1,0),GPJYVALUE(3,1,0));\n\
两融:IF(TMPV==0 OR TMPV1==0,DRAWNULL,IF(FINANCE(3)==0,(SCJYVALUE(1,1,1)-REF(SCJYVALUE(1,1,1),1))/10000-(SCJYVALUE(1,2,1)-REF(SCJYVALUE(1,2,1),1))/10000,((GPJYVALUE(3,1,1)-REF(GPJYVALUE(3,1,1),1))-((GPJYVALUE(3,2,1)*C/10000-(REF(GPJYVALUE(3,2,1),1)*REF(C,1)/10000)))))),NODRAW;\n\
STICKLINE(两融>0,0,两融,2,0),COLORRED;\n\
STICKLINE(两融<0,0,两融,2,0),COLORCYAN;"
    };

    return data;
}

JSIndexScript.prototype.ZSDB=function()
{
    let data =
    {
        Name: 'ZSDB', Description: '指数对比(副图,需下载日线)', IsMainIndex: false,
        Script: //脚本
"A:=REF(INDEXC,1);\n\
指数涨幅:IF(A>0,(INDEXC-A)*100/A,0),NODRAW;\n\
DRAWKLINE(INDEXH,INDEXO,INDEXL,INDEXC);"
    };

    return data;
}

JSIndexScript.prototype.NineTurns=function()
{
    let data =
    {
        Name: '神奇九转', Description: '九转指标', IsMainIndex: true,
        Script: //脚本
"A1:=C>REF(C,4);\n\
A2:=C<REF(C,4);\n\
T1:=A2 AND REF(A1,1);\n\
T2:=A2 AND REF(T1,1);\n\
T3:=A2 AND REF(T2,1);\n\
T4:=A2 AND REF(T3,1);\n\
T5:=A2 AND REF(T4,1);\n\
T6:=A2 AND REF(T5,1);\n\
T7:=A2 AND REF(T6,1);\n\
T8:=A2 AND REF(T7,1);\n\
T9:=A2 AND REF(T8,1);\n\
T10:=A2 AND REF(T9,1);\n\
T11:=A2 AND REF(T10,1);\n\
T12:=A2 AND REF(T11,1);\n\
T13:=A2 AND REF(T12,1);\n\
T14:=A2 AND REF(T13,1);\n\
DRAWTEXT(T1,L*0.98,'1'),COLORGREEN;\n\
DRAWTEXT(T2,L*0.98,'2'),COLORGREEN;\n\
DRAWTEXT(T3,L*0.98,'3'),COLORGREEN;\n\
DRAWTEXT(T4,L*0.98,'4'),COLORGREEN;\n\
DRAWTEXT(T5,L*0.98,'5'),COLORGREEN;\n\
DRAWTEXT(T6,L*0.98,'6'),COLORGREEN;\n\
DRAWTEXT(T7,L*0.98,'7'),COLORGREEN;\n\
DRAWTEXT(T8,L*0.98,'8'),COLORGREEN;\n\
DRAWTEXT(T9,L*0.98,'9'),COLORBLUE;\n\
B1:=C<REF(C,4);\n\
B2:=C>REF(C,4);\n\
D1:=B2 AND REF(B1,1);\n\
D2:=B2 AND REF(D1,1);\n\
D3:=B2 AND REF(D2,1);\n\
D4:=B2 AND REF(D3,1);\n\
D5:=B2 AND REF(D4,1);\n\
D6:=B2 AND REF(D5,1);\n\
D7:=B2 AND REF(D6,1);\n\
D8:=B2 AND REF(D7,1);\n\
D9:=B2 AND REF(D8,1);\n\
D10:=B2 AND REF(D9,1);\n\
D11:=B2 AND REF(D10,1);\n\
D12:=B2 AND REF(D11,1);\n\
D13:=B2 AND REF(D12,1);\n\
D14:=B2 AND REF(D13,1);\n\
DRAWTEXT(D1,H*1.010,'1'),COLORBLUE;\n\
DRAWTEXT(D2,H*1.010,'2'),COLORBLUE;\n\
DRAWTEXT(D3,H*1.010,'3'),COLORBLUE;\n\
DRAWTEXT(D4,H*1.010,'4'),COLORBLUE;\n\
DRAWTEXT(D5,H*1.010,'5'),COLORBLUE;\n\
DRAWTEXT(D6,H*1.010,'6'),COLORBLUE;\n\
DRAWTEXT(D7,H*1.010,'7'),COLORBLUE;\n\
DRAWTEXT(D8,H*1.010,'8'),COLORBLUE;\n\
DRAWTEXT(D9,H*1.010,'9'),COLORGREEN;"
    };

    return data;
}



JSIndexScript.prototype.TEST = function () 
{
    let data =
        {
            Name: 'TEST', Description: '测试脚本', IsMainIndex: false,
            Args: [{ Name: 'N', Value: 10 }],
            Script: //脚本
                "DRAWCHANNEL(OPEN>C,H,L, 'RGB(255,94,102)', 2 ,'5,5','RGBA(58,20,62,0.3)' );"
        };

    return data;
}



/*
   Copyright (c) 2018 jones
 
    http://www.apache.org/licenses/LICENSE-2.0

   开源项目 https://github.com/jones2000/HQChart
 
   jones_2000@163.com

   封装行情类图形控件 (H5版本)
*/


//日志输出类
if (!JSConsole)
{
    var JSConsole=
    { 
        Chart:{ Log:console.log, Warn:console.warn },      //图形日志
        Complier:{ Log:console.log, Warn:console.warn }    //编译器日志
    };
}


function JSChart(divElement, bOffscreen)
{
    this.DivElement=divElement;
    this.DivToolElement=null;           //工具条
    this.JSChartContainer;              //画图控件

    //h5 canvas
    this.CanvasElement=document.createElement("canvas");
    this.CanvasElement.className='jschart-drawing';
    this.CanvasElement.id=Guid();
    this.CanvasElement.setAttribute("tabindex",0);
    if (this.CanvasElement.style) this.CanvasElement.style.outline='none';
    if(divElement.hasChildNodes())
    {
        JSConsole.Chart.Log("[JSChart::JSChart] divElement hasChildNodes", divElement.childNodes);
    }
    divElement.appendChild(this.CanvasElement);

    //离屏
    this.OffscreenCanvasElement;
    if (bOffscreen==true) this.OffscreenCanvasElement=document.createElement("canvas");

    //改参数div
    this.ModifyIndexDialog=new ModifyIndexDialog(divElement);
    this.ChangeIndexDialog=new ChangeIndexDialog(divElement);
    this.MinuteDialog=new MinuteDialog(divElement);

    this.OnSize=function(option) //{ Type:1 新版本OnSize }
    {
        //画布大小通过div获取
        var height=parseInt(this.DivElement.style.height.replace("px",""));
        if (this.ToolElement)
        {
            //TODO调整工具条大小
            height-=this.ToolElement.style.height.replace("px","");   //减去工具条的高度
        }

        this.CanvasElement.height=height;
        this.CanvasElement.width=parseInt(this.DivElement.style.width.replace("px",""));
        this.CanvasElement.style.width=this.CanvasElement.width+'px';
        this.CanvasElement.style.height=this.CanvasElement.height+'px';

        var pixelTatio = GetDevicePixelRatio(); //获取设备的分辨率
        this.CanvasElement.height*=pixelTatio;
        this.CanvasElement.width*=pixelTatio;

        if (this.OffscreenCanvasElement)
        {
            this.OffscreenCanvasElement.height=this.CanvasElement.height;
            this.OffscreenCanvasElement.width=this.CanvasElement.width;
        }

        JSConsole.Chart.Log(`[JSChart::OnSize] devicePixelRatio=${window.devicePixelRatio}, height=${this.CanvasElement.height}, width=${this.CanvasElement.width}`);

        if (this.JSChartContainer)
        {
            if (this.JSChartContainer.OnSize && option && option.Type==1) 
            {
                this.JSChartContainer.OnSize();
            }
            else
            {
                if (this.JSChartContainer.Frame) this.JSChartContainer.Frame.SetSizeChage(true);
                this.JSChartContainer.Draw();
            }
        } 
    }

    //手机屏需要调整 间距
    this.AdjustChartBorder=function(chart)
    {
        var pixelTatio = GetDevicePixelRatio(); //获取设备的分辨率

        chart.Frame.ChartBorder.Left*=pixelTatio;
        chart.Frame.ChartBorder.Right*=pixelTatio;
        chart.Frame.ChartBorder.Top*=pixelTatio;
        chart.Frame.ChartBorder.Bottom*=pixelTatio;
    }

    this.AdjustTitleHeight=function(chart)
    {
        var pixelTatio = GetDevicePixelRatio(); //获取设备的分辨率

        for(var i=0;i<chart.Frame.SubFrame.length;++i)
        {
            chart.Frame.SubFrame[i].Frame.ChartBorder.TitleHeight*=pixelTatio;
        }

        chart.ChartCorssCursor.TextHeight*=pixelTatio;  //十字光标文本信息高度
    }

    //历史K线图
    this.CreateKLineChartContainer=function(option)
    {
        var chart=null;
        if (option.Type==="历史K线图横屏") chart=new KLineChartHScreenContainer(this.CanvasElement);
        else chart=new KLineChartContainer(this.CanvasElement,this.OffscreenCanvasElement);

        if (option.NetworkFilter) chart.NetworkFilter=option.NetworkFilter;

        //创建改参数div
        chart.ModifyIndexDialog=this.ModifyIndexDialog;
        chart.ChangeIndexDialog=this.ChangeIndexDialog;
        chart.MinuteDialog=this.MinuteDialog;
        
        //右键菜单
        if (option.IsShowRightMenu==true) chart.RightMenu=new KLineRightMenu(this.DivElement);
        if (option.ScriptError) chart.ScriptErrorCallback=option.ScriptError;
        chart.SelectRectRightMenu=new KLineSelectRightMenu(this.DivElement);
        if (option.EnableScrollUpDown==true) chart.EnableScrollUpDown=option.EnableScrollUpDown;
        if (option.DisableMouse==true) chart.DisableMouse=option.DisableMouse;
        if (option.TouchMoveMinAngle) chart.TouchMoveMinAngle=option.TouchMoveMinAngle;
        if (option.EnableZoomUpDown) chart.EnableZoomUpDown=option.EnableZoomUpDown;
        if (IFrameSplitOperator.IsString(option.SplashTitle)) chart.LoadDataSplashTitle=option.SplashTitle;

        if (option.EnableYDrag)
        {
            var item=option.EnableYDrag;
            if (IFrameSplitOperator.IsBool(item.Left)) chart.EnableYDrag.Left=item.Left;
            if (IFrameSplitOperator.IsBool(item.Right)) chart.EnableYDrag.Right=item.Right;
        }

        if (option.KLine)   //k线图的属性设置
        {
            if (option.KLine.DragMode>=0) chart.DragMode=option.KLine.DragMode;
            if (option.KLine.Right>=0) chart.Right=option.KLine.Right;
            if (option.KLine.Period>=0) chart.Period=option.KLine.Period;
            if (option.KLine.MaxReqeustDataCount>0) chart.MaxReqeustDataCount=option.KLine.MaxReqeustDataCount;
            if (option.KLine.Info && option.KLine.Info.length>0) chart.SetKLineInfo(option.KLine.Info,false);
            if (option.KLine.IndexTreeApiUrl) chart.ChangeIndexDialog.IndexTreeApiUrl=option.KLine.IndexTreeApiUrl;
            if (option.KLine.KLineDoubleClick==false) chart.MinuteDialog=this.MinuteDialog=null;
            if (option.KLine.IndexTreeApiUrl!=null) chart.ChangeIndexDialog.IndexTreeApiUrl=option.KLine.IndexTreeApiUrl;
            if (option.KLine.IsShowTooltip==false) chart.IsShowTooltip=false;
            if (option.KLine.MaxRequestMinuteDayCount>0) chart.MaxRequestMinuteDayCount=option.KLine.MaxRequestMinuteDayCount;
            if (option.KLine.DrawType) chart.KLineDrawType=option.KLine.DrawType;
            if (option.KLine.FirstShowDate>19910101) chart.CustomShow={ Date:option.KLine.FirstShowDate, PageSize:option.KLine.PageSize };
            if (option.KLine.RightSpaceCount>0) chart.RightSpaceCount=option.KLine.RightSpaceCount;
            if (option.KLine.ZoomType>0) chart.ZoomType=option.KLine.ZoomType;
            if (option.KLine.DataWidth>=1) chart.KLineSize={ DataWidth:option.KLine.DataWidth };
        }

        if (option.EnableFlowCapital)
        {
            var item=option.EnableFlowCapital;
            if (item.BIT==true) chart.EnableFlowCapital.BIT=item.BIT;
        }

        if (IFrameSplitOperator.IsBool(option.EnableBorderDrag))
        {
            chart.EnableBorderDrag=option.EnableBorderDrag;
        }

        if (option.Page)
        {
            if (option.Page.Day && option.Page.Day.Enable==true) chart.Page.Day.Enable=true;
            if (option.Page.Minute && option.Page.Minute.Enable==true) chart.Page.Minute.Enable=true;
        }

        if (option.DragDownload)
        {
            if (option.DragDownload.Day && option.DragDownload.Day.Enable==true) chart.DragDownload.Day.Enable=true;
            if (option.DragDownload.Minute && option.DragDownload.Minute.Enable==true) chart.DragDownload.Minute.Enable=true;
        }

        if (option.Language)
        {
            if (option.Language==='CN') chart.LanguageID=JSCHART_LANGUAGE_ID.LANGUAGE_CHINESE_ID;
            else if(option.Language==='EN') chart.LanguageID=JSCHART_LANGUAGE_ID.LANGUAGE_ENGLISH_ID;
        }

        if (option.SourceDatatLimit) chart.SetSourceDatatLimit(option.SourceDatatLimit);

        if (option.DrawPicture) //画图工具
        {
            if (option.DrawPicture.StorageKey && chart.ChartDrawStorage) chart.ChartDrawStorage.Load(option.DrawPicture.StorageKey);
        }

        if (option.DrawTool)    //画图工具
        {
            if (option.DrawTool.StorageKey && chart.ChartDrawStorage) chart.ChartDrawStorage.Load(option.DrawTool.StorageKey);
        }

        if (option.StepPixel>0) chart.StepPixel=option.StepPixel;
        if (option.ZoomStepPixel>0) chart.ZoomStepPixel=option.ZoomStepPixel;
        if (option.IsApiPeriod==true) chart.IsApiPeriod=option.IsApiPeriod;

        if (!option.Windows || option.Windows.length<=0) return null;

        //创建子窗口
        chart.Create(option.Windows.length, option.Listener);

        if (option.Border)
        {
            if (IFrameSplitOperator.IsNumber(option.Border.Left)) chart.Frame.ChartBorder.Left=option.Border.Left;
            else option.Border.Left=chart.Frame.ChartBorder.Left;
            if (IFrameSplitOperator.IsNumber(option.Border.Right)) chart.Frame.ChartBorder.Right=option.Border.Right;
            else option.Border.Right=chart.Frame.ChartBorder.Right;
            if (IFrameSplitOperator.IsNumber(option.Border.Top)) chart.Frame.ChartBorder.Top=option.Border.Top;
            else option.Border.Top=chart.Frame.ChartBorder.Top;
            if (IFrameSplitOperator.IsNumber(option.Border.Bottom)) chart.Frame.ChartBorder.Bottom=option.Border.Bottom;
            else option.Border.Bottom=chart.Frame.ChartBorder.Bottom;
        }

        this.AdjustChartBorder(chart);

        if (option.KLine)
        {
            if (option.KLine.PageSize > 0)  //一屏显示的数据个数
            {
                let pageSize = chart.GetMaxMinPageSize();
                if (pageSize.Max>10 && pageSize.Max < option.KLine.PageSize) chart.PageSize = pageSize.Max;
                else if (pageSize.Min>10 && pageSize.Min> option.KLine.PageSize) chart.PageSize=pageSize.Min;
                else chart.PageSize = option.KLine.PageSize;
            }
        }

        //取消显示十字光标刻度信息
        if (option.IsCorssOnlyDrawKLine===true) chart.ChartCorssCursor.IsOnlyDrawKLine=option.IsCorssOnlyDrawKLine;
        if (option.CorssCursorTouchEnd===true) chart.CorssCursorTouchEnd = option.CorssCursorTouchEnd;
        if (option.IsClickShowCorssCursor==true) chart.IsClickShowCorssCursor=option.IsClickShowCorssCursor;
        if (option.CorssCursorInfo)
        {
            if (!isNaN(option.CorssCursorInfo.Left)) chart.ChartCorssCursor.ShowTextMode.Left=option.CorssCursorInfo.Left;
            if (!isNaN(option.CorssCursorInfo.Right)) chart.ChartCorssCursor.ShowTextMode.Right=option.CorssCursorInfo.Right;
            if (!isNaN(option.CorssCursorInfo.Bottom)) chart.ChartCorssCursor.ShowTextMode.Bottom=option.CorssCursorInfo.Bottom;
            if (option.CorssCursorInfo.IsShowCorss===false) chart.ChartCorssCursor.IsShowCorss=option.CorssCursorInfo.IsShowCorss;
            if (option.CorssCursorInfo.IsShowClose == true) chart.ChartCorssCursor.IsShowClose = option.CorssCursorInfo.IsShowClose;    //Y轴显示收盘价
            if (option.CorssCursorInfo.PressTime) chart.PressTime=option.CorssCursorInfo.PressTime; //长按显示十字光标的时间
            if (IFrameSplitOperator.IsNumber(option.CorssCursorInfo.HPenType)) chart.ChartCorssCursor.HPenType=option.CorssCursorInfo.HPenType;
            if (option.CorssCursorInfo.VPenType>0) chart.ChartCorssCursor.VPenType=option.CorssCursorInfo.VPenType;
            if (option.CorssCursorInfo.DateFormatType>0) chart.ChartCorssCursor.StringFormatX.DateFormatType=option.CorssCursorInfo.DateFormatType;
        }

        //保存十字光标文字高度
        option.CorssCursor={};
        option.CorssCursor.TitleHeight=chart.ChartCorssCursor.TextHeight;

        

        if (option.Frame)
        {
            for(var i=0;i<option.Frame.length;++i)
            {
                var item=option.Frame[i];
                if (!chart.Frame.SubFrame[i]) continue;
                var subFrame=chart.Frame.SubFrame[i].Frame;

                if (item.SplitCount) chart.Frame.SubFrame[i].Frame.YSplitOperator.SplitCount=item.SplitCount;
                if (item.StringFormat) chart.Frame.SubFrame[i].Frame.YSplitOperator.StringFormat=item.StringFormat;
                if (IFrameSplitOperator.IsNumber(item.FloatPrecision)) chart.Frame.SubFrame[i].Frame.YSplitOperator.FloatPrecision=item.FloatPrecision;
                if (item.Custom) chart.Frame.SubFrame[i].Frame.YSplitOperator.Custom=item.Custom;
                if (IFrameSplitOperator.IsNumber(item.SplitType)) chart.Frame.SubFrame[i].Frame.YSplitOperator.SplitType=item.SplitType;
                if (!isNaN(item.Height)) chart.Frame.SubFrame[i].Height = item.Height;
                if (item.IsShowLeftText===false || item.IsShowLeftText===true) 
                {
                    chart.Frame.SubFrame[i].Frame.IsShowYText[0]=item.IsShowLeftText;
                    chart.Frame.SubFrame[i].Frame.YSplitOperator.IsShowLeftText=item.IsShowLeftText;            //显示左边刻度
                }
                if (item.IsShowRightText===false || item.IsShowRightText===true) 
                {
                    chart.Frame.SubFrame[i].Frame.IsShowYText[1]=item.IsShowRightText;
                    chart.Frame.SubFrame[i].Frame.YSplitOperator.IsShowRightText=item.IsShowRightText;         //显示右边刻度
                }
                if (item.TopSpace>=0) chart.Frame.SubFrame[i].Frame.ChartBorder.TopSpace=item.TopSpace;
                if (item.BottomSpace>=0) chart.Frame.SubFrame[i].Frame.ChartBorder.BottomSpace=item.BottomSpace;

                if (item.RightTextPosition>0) chart.Frame.SubFrame[i].Frame.YTextPosition[1]=item.RightTextPosition;
                if (item.LeftTextPosition>0) chart.Frame.SubFrame[i].Frame.YTextPosition[0]=item.LeftTextPosition;

                if (item.IsShowXLine==false) chart.Frame.SubFrame[i].Frame.IsShowXLine=item.IsShowXLine;
                if (item.IsShowYLine==false) chart.Frame.SubFrame[i].Frame.IsShowYLine=item.IsShowYLine;
                if (IFrameSplitOperator.IsNumber(item.YTextBaseline)) chart.Frame.SubFrame[i].Frame.YTextBaseline=item.YTextBaseline;
                
                if (item.YCoordinateType>0) chart.Frame.SubFrame[0].Frame.YSplitOperator.CoordinateType=item.YCoordinateType;
                if (item.IsYReverse==true) chart.Frame.SubFrame[0].Frame.CoordinateType=1;  //反转坐标
                if (IFrameSplitOperator.IsNumber(item.PercentageTextFormat)) subFrame.YSplitOperator.PercentageTextFormat=item.PercentageTextFormat;    //百分比坐标格式

                if (item.DefaultYMaxMin) chart.Frame.SubFrame[i].Frame.YSplitOperator.DefaultYMaxMin=item.DefaultYMaxMin;
                if (IFrameSplitOperator.IsBool(item.EnableRemoveZero)) chart.Frame.SubFrame[i].Frame.YSplitOperator.EnableRemoveZero=item.EnableRemoveZero;
                if (IFrameSplitOperator.IsPlusNumber(item.MinYDistance)) chart.Frame.SubFrame[i].Frame.MinYDistance=item.MinYDistance;
                if (IFrameSplitOperator.IsNumber(item.BorderLine)) chart.Frame.SubFrame[i].Frame.BorderLine=item.BorderLine;
                if (IFrameSplitOperator.IsBool(item.IsShowIndexTitle)) chart.Frame.SubFrame[i].Frame.IsShowIndexTitle=item.IsShowIndexTitle;
                if (IFrameSplitOperator.IsBool(item.IsDrawTitleBottomLine)) subFrame.IsDrawTitleBottomLine=item.IsDrawTitleBottomLine;
            }
        }

        if (option.KLine) 
        {
            if (option.KLine.ShowKLine == false) chart.ChartPaint[0].IsShow = false;
            if (option.KLine.InfoPosition>0) chart.ChartPaint[0].InfoPosition=option.KLine.InfoPosition;
            if (option.KLine.IsShowMaxMinPrice == false) chart.ChartPaint[0].IsShowMaxMinPrice=option.KLine.IsShowMaxMinPrice;
        }

        if(option.KLineTitle)
        {
            if(option.KLineTitle.IsShowName==false) chart.TitlePaint[0].IsShowName=false;
            if(option.KLineTitle.IsShowSettingInfo==false) chart.TitlePaint[0].IsShowSettingInfo=false;
            if(option.KLineTitle.IsShow == false) chart.TitlePaint[0].IsShow = false;
        }

        //叠加股票
        
        if (option.Overlay)
        {
            for(var i=0;i<option.Overlay.length;++i)
            {
                var item=option.Overlay[i];
                chart.OverlaySymbol(item.Symbol,item);
            }
        }

        if (option.ExtendChart)
        {
            for(var i=0;i<option.ExtendChart.length;++i)
            {
                var item=option.ExtendChart[i];
                chart.CreateExtendChart(item.Name, item);
            }
        }

        //创建子窗口的指标
        let scriptData = new JSIndexScript();

        if (option.ColorIndex)    //五彩K线
        {
            var item=option.ColorIndex;
            let indexInfo=scriptData.Get(item.Index);
            if (indexInfo)
            {
                indexInfo.ID=item.Index;
                chart.ColorIndex=new ScriptIndex(indexInfo.Name, indexInfo.Script, indexInfo.Args,indexInfo);    //脚本执行
            }
        }

        if (option.TradeIndex)  //交易指标
        {
            var item=option.TradeIndex;
            let indexInfo=scriptData.Get(item.Index);
            if (indexInfo)
            {
                indexInfo.ID=item.Index;
                chart.TradeIndex=new ScriptIndex(indexInfo.Name, indexInfo.Script, indexInfo.Args,indexInfo);    //脚本执行
            }
        }

        for(var i=0;i<option.Windows.length;++i)
        {
            var item=option.Windows[i];
            if (item.Script)
            {
                chart.WindowIndex[i]=new ScriptIndex(item.Name,item.Script,item.Args,item);    //脚本执行
            }
            else if (item.JsonData)
            {
                chart.WindowIndex[i]=new JsonDataIndex(item.Name,item.Script,item.Args,item);    //脚本执行
            }
            else if (item.Local && item.Local.Data)
            {
                chart.WindowIndex[i]=new LocalJsonDataIndex(item.Local.Name,item.Local.Args,{JsonData:item.Local.Data});
            }
            else if (item.API)  //使用API挂接指标数据 API:{ Name:指标名字, Script:指标脚本可以为空, Args:参数可以为空, Url:指标执行地址 }
            {
                var apiItem=item.API;
                chart.WindowIndex[i]=new APIScriptIndex(apiItem.Name,apiItem.Script,apiItem.Args,item);
            }
            else
            {
                let indexItem=JSIndexMap.Get(item.Index);
                if (indexItem)
                {
                    chart.WindowIndex[i]=indexItem.Create();
                    chart.CreateWindowIndex(i);
                }
                else
                {
                    let indexInfo = scriptData.Get(item.Index);
                    if (!indexInfo) continue;

                    if (item.Lock) indexInfo.Lock=item.Lock;
                    indexInfo.ID=item.Index;
                    var args=indexInfo.Args;
                    if (item.Args) args=item.Args;
                    if (item.IsShortTitle) indexInfo.IsShortTitle=item.IsShortTitle;
                    if (item.TitleFont) indexInfo.TitleFont=item.TitleFont;
                    chart.WindowIndex[i] = new ScriptIndex(indexInfo.Name, indexInfo.Script, args,indexInfo);    //脚本执行
                    if (item.StringFormat>0) chart.WindowIndex[i].StringFormat=item.StringFormat;
                    if (item.FloatPrecision>=0) chart.WindowIndex[i].FloatPrecision=item.FloatPrecision;
                }

            }

            if (item.Modify!=null) chart.Frame.SubFrame[i].Frame.ModifyIndex=item.Modify;
            if (item.Change!=null) chart.Frame.SubFrame[i].Frame.ChangeIndex=item.Change;
            if (item.Close!=null) chart.Frame.SubFrame[i].Frame.CloseIndex=item.Close;
            if (item.Overlay!=null) chart.Frame.SubFrame[i].Frame.OverlayIndex=item.Overlay;
            if (item.IsDrawTitleBG==true)  chart.Frame.SubFrame[i].Frame.IsDrawTitleBG=item.IsDrawTitleBG;

            if (IFrameSplitOperator.IsNumber(item.TitleHeight)) chart.Frame.SubFrame[i].Frame.ChartBorder.TitleHeight=item.TitleHeight;
            else item.TitleHeight=chart.Frame.SubFrame[i].Frame.ChartBorder.TitleHeight;
            if (item.IsShowTitleArraw==false) chart.Frame.SubFrame[i].Frame.IsShowTitleArraw=false;
            if (item.IsShowIndexName==false) chart.Frame.SubFrame[i].Frame.IsShowIndexName=false;
            if (item.IsShowOverlayIndexName==false) chart.Frame.SubFrame[i].Frame.IsShowOverlayIndexName=false;
            if (item.IndexParamSpace>=0) chart.Frame.SubFrame[i].Frame.IndexParamSpace=item.IndexParamSpace;
        }
        
        //叠加指标宽度
        if (option.OverlayIndexFrameWidth>40) chart.OverlayIndexFrameWidth=option.OverlayIndexFrameWidth;

        //叠加指标
        if (IFrameSplitOperator.IsNonEmptyArray(option.OverlayIndex))
        {
            for(var i=0;i<option.OverlayIndex.length;++i)
            {
                var item=option.OverlayIndex[i];
                if (item.Windows>=chart.Frame.SubFrame.length) continue;
    
                var itemString = JSON.stringify(item);
                var obj = JSON.parse(itemString);
                if (item.Index) obj.IndexName=item.Index;
                if (item.Windows>=0) obj.WindowIndex=item.Windows;
                chart.CreateOverlayWindowsIndex(obj);
            }
    
        }
        
        this.AdjustTitleHeight(chart);

        return chart;
    }

    //自定义指数历史K线图
    this.CreateCustomKLineChartContainer=function(option)
    {
        var chart=new CustomKLineChartContainer(this.CanvasElement);

        //创建改参数div
        chart.ModifyIndexDialog=this.ModifyIndexDialog;
        chart.ChangeIndexDialog=this.ChangeIndexDialog;
        chart.MinuteDialog=this.MinuteDialog;
        
        //右键菜单
        if (option.IsShowRightMenu==true) chart.RightMenu=new KLineRightMenu(this.DivElement);

        if (option.KLine)   //k线图的属性设置
        {
            if (option.KLine.DragMode>=0) chart.DragMode=option.KLine.DragMode;
            if (option.KLine.Right>=0) chart.Right=option.KLine.Right;
            if (option.KLine.Period>=0) chart.Period=option.KLine.Period;
            if (option.KLine.MaxReqeustDataCount>0) chart.MaxReqeustDataCount=option.KLine.MaxReqeustDataCount;
            if (option.KLine.Info && option.KLine.Info.length>0) chart.SetKLineInfo(option.KLine.Info,false);
            if (option.KLine.IndexTreeApiUrl) chart.ChangeIndexDialog.IndexTreeApiUrl=option.KLine.IndexTreeApiUrl;
            if (option.KLine.KLineDoubleClick==false) chart.MinuteDialog=this.MinuteDialog=null;
            if (option.KLine.IndexTreeApiUrl!=null) chart.ChangeIndexDialog.IndexTreeApiUrl=option.KLine.IndexTreeApiUrl;
            if (option.KLine.PageSize>0)  chart.PageSize=option.KLine.PageSize;
            if (option.KLine.IsShowTooltip==false) chart.IsShowTooltip=false;
        }

        if (option.CustomStock) chart.CustomStock=option.CustomStock;
        if (option.QueryDate) chart.QueryDate=option.QueryDate;

        if (!option.Windows || option.Windows.length<=0) return null;

        //创建子窗口
        chart.Create(option.Windows.length);

        if (option.Border)
        {
            if (!isNaN(option.Border.Left)) chart.Frame.ChartBorder.Left=option.Border.Left;
            if (!isNaN(option.Border.Right)) chart.Frame.ChartBorder.Right=option.Border.Right;
            if (!isNaN(option.Border.Top)) chart.Frame.ChartBorder.Top=option.Border.Top;
        }

        if (option.IsShowCorssCursorInfo==false)    //取消显示十字光标刻度信息
        {
            chart.ChartCorssCursor.IsShowText=option.IsShowCorssCursorInfo;
        }

        if (option.Frame)
        {
            for(var i=0;i<option.Frame.length;++i)
            {
                var item=option.Frame[i];
                if (item.SplitCount) chart.Frame.SubFrame[i].Frame.YSplitOperator.SplitCount=item.SplitCount;
                if (item.StringFormat) chart.Frame.SubFrame[i].Frame.YSplitOperator.StringFormat=item.StringFormat;
            }
        }

        if(option.KLineTitle)
        {
            if(option.KLineTitle.IsShowName==false) chart.TitlePaint[0].IsShowName=false;
            if(option.KLineTitle.IsShowSettingInfo==false) chart.TitlePaint[0].IsShowSettingInfo=false;
        }

        //创建子窗口的指标
        let scriptData = new JSIndexScript();
        for(var i=0;i<option.Windows.length;++i)
        {
            var item=option.Windows[i];
            if (item.Script)
            {
                chart.WindowIndex[i]=new ScriptIndex(item.Name,item.Script,item.Args,item);    //脚本执行
            }
            else
            {
                let indexItem=JSIndexMap.Get(item.Index);
                if (indexItem)
                {
                    chart.WindowIndex[i]=indexItem.Create();
                    chart.CreateWindowIndex(i);
                }
                else
                {
                    let indexInfo = scriptData.Get(item.Index);
                    if (!indexInfo) continue;

                    if (item.Lock) indexInfo.Lock=item.Lock;
                    chart.WindowIndex[i] = new ScriptIndex(indexInfo.Name, indexInfo.Script, indexInfo.Args,indexInfo);    //脚本执行
                }
            }
           
            if (item.Modify!=null)
                chart.Frame.SubFrame[i].Frame.ModifyIndex=item.Modify;
            if (item.Change!=null)
                chart.Frame.SubFrame[i].Frame.ChangeIndex=item.Change;

            if (!isNaN(item.TitleHeight)) chart.Frame.SubFrame[i].Frame.ChartBorder.TitleHeight=item.TitleHeight;
        }

        return chart;
    }

    //分钟走势图
    this.CreateMinuteChartContainer=function(option)
    {
        var chart=null;
        if (option.Type==="分钟走势图横屏") chart=new MinuteChartHScreenContainer(this.CanvasElement);
        else chart=new MinuteChartContainer(this.CanvasElement);

        if (option.NetworkFilter) chart.NetworkFilter=option.NetworkFilter;

        chart.ModifyIndexDialog=this.ModifyIndexDialog;
        chart.ChangeIndexDialog=this.ChangeIndexDialog;

        var windowsCount=2;
        if (option.Windows && option.Windows.length>0) windowsCount+=option.Windows.length; //指标窗口从第3个窗口开始
        if (option.EnableScrollUpDown==true) chart.EnableScrollUpDown=option.EnableScrollUpDown;
        if (option.DisableMouse==true) chart.DisableMouse=option.DisableMouse;
        if (option.ScriptError) chart.ScriptErrorCallback=option.ScriptError;       //指标执行错误回调
        if (IFrameSplitOperator.IsString(option.SplashTitle)) chart.LoadDataSplashTitle=option.SplashTitle;

        if (option.Minute)   //分钟走势图属性设置
        {
            if (option.Minute.IsShowTooltip==false) chart.IsShowTooltip=false;
            if (option.Minute.DragMode>=0) chart.DragMode=option.Minute.DragMode;
        }

        if (option.Language)
        {
            if (option.Language==='CN') chart.LanguageID=JSCHART_LANGUAGE_ID.LANGUAGE_CHINESE_ID;
            else if(option.Language==='EN') chart.LanguageID=JSCHART_LANGUAGE_ID.LANGUAGE_ENGLISH_ID;
        }

        if (option.Info && option.Info.length>0) chart.SetMinuteInfo(option.Info,false);

        if (option.DrawTool)    //画图工具
        {
            if (option.DrawTool.StorageKey && chart.ChartDrawStorage) chart.ChartDrawStorage.Load(option.DrawTool.StorageKey);
        }

        if (option.BeforeOpen)  //集合竞价
        {
            var item=option.BeforeOpen;

            if (IFrameSplitOperator.IsBool(item.IsShow)) chart.IsShowBeforeData=item.IsShow;
            if (IFrameSplitOperator.IsNumber(item.Width)) chart.ExtendWidth.Left=item.Width;
        }

        if (option.AfterClose)  //收盘集合竞价
        {
            var item=option.AfterClose;
            if (IFrameSplitOperator.IsBool(item.IsShow)) chart.IsShowAfterData=item.IsShow;
            if (IFrameSplitOperator.IsNumber(item.Width)) chart.ExtendWidth.Right=item.Width;
        }

        chart.Create(windowsCount,option.Listener);                            //创建子窗口

        if (option.CorssCursorInfo)
        {
            if (!isNaN(option.CorssCursorInfo.Left)) chart.ChartCorssCursor.ShowTextMode.Left=option.CorssCursorInfo.Left;
            if (!isNaN(option.CorssCursorInfo.Right)) chart.ChartCorssCursor.ShowTextMode.Right=option.CorssCursorInfo.Right;
            if (!isNaN(option.CorssCursorInfo.Bottom)) chart.ChartCorssCursor.ShowTextMode.Bottom=option.CorssCursorInfo.Bottom;
            if (option.CorssCursorInfo.IsShowCorss===false) chart.ChartCorssCursor.IsShowCorss=option.CorssCursorInfo.IsShowCorss;
            if (option.CorssCursorInfo.RightTextFormat>0) chart.ChartCorssCursor.TextFormat.Right=option.CorssCursorInfo.RightTextFormat;
            if (option.CorssCursorInfo.IsOnlyDrawMinute == true) chart.ChartCorssCursor.IsOnlyDrawMinute = option.CorssCursorInfo.IsOnlyDrawMinute;    //Y轴显示收盘价
            if (IFrameSplitOperator.IsBool(option.CorssCursorInfo.IsFixXLastTime)) chart.ChartCorssCursor.IsFixXLastTime=option.CorssCursorInfo.IsFixXLastTime;
        }

        if (option.MinuteInfo) chart.CreateMinuteInfo(option.MinuteInfo);

        if (option.IsShowRightMenu==true) chart.RightMenu=new MinuteRightMenu(this.DivElement);

        if (option.DayCount>1) chart.DayCount=option.DayCount;

        if (option.Border)
        {
            if (!isNaN(option.Border.Left)) chart.Frame.ChartBorder.Left=option.Border.Left;
            if (!isNaN(option.Border.Right)) chart.Frame.ChartBorder.Right=option.Border.Right;
            if (!isNaN(option.Border.Top)) chart.Frame.ChartBorder.Top=option.Border.Top;
            if (!isNaN(option.Border.Bottom)) chart.Frame.ChartBorder.Bottom=option.Border.Bottom;
        }

        if (option.SplashTitle) chart.ChartSplashPaint.SplashTitle=option.SplashTitle;

        if (IFrameSplitOperator.IsBool(option.EnableBorderDrag))
        {
            chart.EnableBorderDrag=option.EnableBorderDrag;
        }

        this.AdjustChartBorder(chart);

        if (option.Frame)
        {
            for(var i=0;i<option.Frame.length;++i)
            {
                var item=option.Frame[i];
                if (!chart.Frame.SubFrame[i]) continue;
                if (item.SplitCount) chart.Frame.SubFrame[i].Frame.YSplitOperator.SplitCount=item.SplitCount;
                if (item.StringFormat) chart.Frame.SubFrame[i].Frame.YSplitOperator.StringFormat=item.StringFormat;
                if (item.IsShowLeftText==false) 
                {
                    chart.Frame.SubFrame[i].Frame.IsShowYText[0]=item.IsShowLeftText;
                    chart.Frame.SubFrame[i].Frame.YSplitOperator.IsShowLeftText=item.IsShowLeftText;            //显示左边刻度
                }
                if (item.IsShowRightText==false) 
                {
                    chart.Frame.SubFrame[i].Frame.IsShowYText[1]=item.IsShowRightText;
                    chart.Frame.SubFrame[i].Frame.YSplitOperator.IsShowRightText=item.IsShowRightText;         //显示右边刻度 
                }
                if (item.Height>=0) chart.Frame.SubFrame[i].Height = item.Height;
                if (item.Custom) chart.Frame.SubFrame[i].Frame.YSplitOperator.Custom=item.Custom;
                if (item.RightTextFormat>0) chart.Frame.SubFrame[i].Frame.YSplitOperator.RightTextFormat=item.RightTextFormat;
                if (IFrameSplitOperator.IsNumber(item.TitleHeight)) chart.Frame.SubFrame[i].Frame.ChartBorder.TitleHeight=item.TitleHeight;
                if (IFrameSplitOperator.IsNumber(item.BorderLine)) chart.Frame.SubFrame[i].Frame.BorderLine=item.BorderLine;
                if (IFrameSplitOperator.IsBool(item.EnableRemoveZero)) chart.Frame.SubFrame[i].Frame.YSplitOperator.EnableRemoveZero=item.EnableRemoveZero;
                if (IFrameSplitOperator.IsNumber(item.FloatPrecision)) chart.Frame.SubFrame[i].Frame.YSplitOperator.FloatPrecision=item.FloatPrecision;
                if (IFrameSplitOperator.IsNumber(item.YTextBaseline)) chart.Frame.SubFrame[i].Frame.YTextBaseline=item.YTextBaseline;
            }

            chart.UpdateXShowText();
        }

        if (option.ExtendChart)
        {
            for(var i=0;i<option.ExtendChart.length;++i)
            {
                var item=option.ExtendChart[i];
                chart.CreateExtendChart(item.Name, item);
            }
        }

        //叠加股票
        if (option.Overlay)
        {
            for(var i=0;i<option.Overlay.length;++i)
            {
                var item=option.Overlay[i];
                chart.OverlaySymbol(item.Symbol,item);
            }
        }

        if (option.MinuteLine)
        {
            if (option.MinuteLine.IsDrawAreaPrice==false) chart.ChartPaint[0].IsDrawArea=false;
            if (option.MinuteLine.IsShowLead==false) chart.IsShowLead=false;
            if (option.MinuteLine.IsShowAveragePrice==false) 
            {
                chart.ChartPaint[1].IsShow=false;
                chart.TitlePaint[0].IsShowAveragePrice=false;   //标题栏均线也不显示
                for(var i=0;i<chart.ExtendChartPaint.length;++i)
                {
                    var item=chart.ExtendChartPaint[i];
                    if (item.ClassName=="MinuteTooltipPaint")
                        item.IsShowAveragePrice=false;
                }
            }
            if (option.MinuteLine.SplitType>0) chart.Frame.SubFrame[0].Frame.YSplitOperator.SplitType=option.MinuteLine.SplitType;
        }

        if(option.MinuteTitle)
        {
            var item=option.MinuteTitle;
            if(IFrameSplitOperator.IsBool(item.IsShowName)) chart.TitlePaint[0].IsShowName=item.IsShowName;
            if(IFrameSplitOperator.IsBool(item.IsShowDate)) chart.TitlePaint[0].IsShowDate=item.IsShowDate;
            if(IFrameSplitOperator.IsBool(item.IsShowTime)) chart.TitlePaint[0].IsShowTime=item.IsShowTime;
            if(IFrameSplitOperator.IsBool(item.IsTitleShowLatestData)) chart.IsTitleShowLatestData=item.IsTitleShowLatestData;
            //if(option.KLineTitle.IsShow == false) chart.TitlePaint[0].IsShow = false;
        }

        if (option.CorssCursorTouchEnd===true) chart.CorssCursorTouchEnd = option.CorssCursorTouchEnd;
        if (option.IsShowBeforeData===true) chart.IsShowBeforeData=option.IsShowBeforeData;

        //分钟数据指标从第3个指标窗口设置
        if (IFrameSplitOperator.IsNonEmptyArray(option.Windows))
        {
            let scriptData = new JSIndexScript();
            for(var i=0;i<option.Windows.length;++i)
            {
                var index=2+i;
                var item=option.Windows[i];
                if (item.Script)
                {
                    chart.WindowIndex[index]=new ScriptIndex(item.Name,item.Script,item.Args,item);    //脚本执行
                }
                else if (item.API)  //使用API挂接指标数据 API:{ Name:指标名字, Script:指标脚本可以为空, Args:参数可以为空, Url:指标执行地址 }
                {
                    var apiItem=item.API;
                    chart.WindowIndex[index]=new APIScriptIndex(apiItem.Name,apiItem.Script,apiItem.Args,item);
                }
                else
                {
                    var indexItem=JSIndexMap.Get(item.Index);
                    if (indexItem)
                    {
                        chart.WindowIndex[index]=indexItem.Create();       //创建子窗口的指标
                        chart.CreateWindowIndex(index);
                    }
                    else
                    {
                        let indexInfo = scriptData.Get(item.Index);
                        if (!indexInfo) continue;
                        indexInfo.ID=item.Index;
                        var args=indexInfo.Args;
                        if (item.Args) args=item.Args;
                        chart.WindowIndex[index] = new ScriptIndex(indexInfo.Name, indexInfo.Script, args,indexInfo);    //脚本执行
                        if (item.StringFormat>0) chart.WindowIndex[index].StringFormat=item.StringFormat;
                        if (item.FloatPrecision>=0) chart.WindowIndex[index].FloatPrecision=item.FloatPrecision;
                    }
                }

                if (item.Modify!=null) chart.Frame.SubFrame[index].Frame.ModifyIndex=item.Modify;
                if (item.Change!=null) chart.Frame.SubFrame[index].Frame.ChangeIndex=item.Change;
                if (item.Close!=null) chart.Frame.SubFrame[index].Frame.CloseIndex=item.Close;
                if (!isNaN(item.TitleHeight)) chart.Frame.SubFrame[index].Frame.ChartBorder.TitleHeight=item.TitleHeight;
            }
        }

        this.AdjustTitleHeight(chart);

        //叠加指标
        if (IFrameSplitOperator.IsNonEmptyArray(option.OverlayIndex))
        {
            for(var i=0;i<option.OverlayIndex.length;++i)
            {
                var item=option.OverlayIndex[i];
                if (item.Windows>=chart.Frame.SubFrame.length) continue;
    
                var itemString = JSON.stringify(item);
                var obj = JSON.parse(itemString);
                if (item.Index) obj.IndexName=item.Index;
                if (item.Windows>=0) obj.WindowIndex=item.Windows;
                chart.CreateOverlayWindowsIndex(obj);
            }
        }
        
        return chart;
    }

    //历史分钟走势图
    this.CreateHistoryMinuteChartContainer=function(option)
    {
        var chart=new HistoryMinuteChartContainer(this.CanvasElement);

        var windowsCount=2;
        if (option.Windows && option.Windows.length>0) windowsCount+=option.Windows.length; //指标窗口从第3个窗口开始

        chart.Create(windowsCount);                            //创建子窗口

        if (option.IsShowCorssCursorInfo==false)    //取消显示十字光标刻度信息
        {
            chart.ChartCorssCursor.IsShowText=option.IsShowCorssCursorInfo;
        }

        if (option.Border)
        {
            if (!isNaN(option.Border.Left)) chart.Frame.ChartBorder.Left=option.Border.Left;
            if (!isNaN(option.Border.Right)) chart.Frame.ChartBorder.Right=option.Border.Right;
            if (!isNaN(option.Border.Top)) chart.Frame.ChartBorder.Top=option.Border.Top;
            if (!isNaN(option.Border.Bottom)) chart.Frame.ChartBorder.Bottom=option.Border.Bottom;
        }

        let scriptData = new JSIndexScript();
        if (option.Windows)
        {
            for(var i=0;i<option.Windows.length;++i)
            {
                var item=option.Windows[i];
                if (item.Script)
                {
                    chart.WindowIndex[2+parseInt(i)]=new ScriptIndex(item.Name,item.Script,item.Args);    //脚本执行
                }
                else
                {
                    var indexItem=JSIndexMap.Get(item.Index);
                    if (indexItem)
                    {
                        chart.WindowIndex[2+parseInt(i)]=indexItem.Create();       //创建子窗口的指标
                        chart.CreateWindowIndex(2+parseInt(i));
                    }
                    else
                    {
                        let indexInfo = scriptData.Get(item.Index);
                        if (!indexInfo) continue;

                        chart.WindowIndex[2+parseInt(i)] = new ScriptIndex(indexInfo.Name, indexInfo.Script, indexInfo.Args);    //脚本执行
                    }
                }

                if (!isNaN(item.TitleHeight)) chart.Frame.SubFrame[2+parseInt(i)].Frame.ChartBorder.TitleHeight=item.TitleHeight;
            }
        }

        chart.TradeDate=20181009;
        if (option.HistoryMinute.TradeDate) chart.TradeDate=option.HistoryMinute.TradeDate;
        if (option.HistoryMinute.IsShowName!=null) chart.TitlePaint[0].IsShowName=option.HistoryMinute.IsShowName;  //动态标题是否显示股票名称
        if (option.HistoryMinute.IsShowDate!=null) chart.TitlePaint[0].IsShowDate=option.HistoryMinute.IsShowDate;  //动态标题是否显示日期

        return chart;
    }

    this.CreateKLineTrainChartContainer=function(option)
    {
        var bHScreen=(option.Type=='K线训练横屏'? true:false);
        var chart=new KLineTrainChartContainer(this.CanvasElement,bHScreen);

        if (option.NetworkFilter) chart.NetworkFilter=option.NetworkFilter;
        if (option.IsApiPeriod==true) chart.IsApiPeriod=option.IsApiPeriod;

        //创建改参数div
        chart.ModifyIndexDialog=this.ModifyIndexDialog;
        chart.ChangeIndexDialog=this.ChangeIndexDialog;

        if (option.ScriptError) chart.ScriptErrorCallback=option.ScriptError;

        if (option.KLine)   //k线图的属性设置
        {
            if (option.KLine.Right>=0) chart.Right=option.KLine.Right;
            if (option.KLine.Period>=0) chart.Period=option.KLine.Period;
            if (option.KLine.MaxReqeustDataCount>0) chart.MaxReqeustDataCount=option.KLine.MaxReqeustDataCount;
            if (option.KLine.Info && option.KLine.Info.length>0) chart.SetKLineInfo(option.KLine.Info,false);
            if (option.KLine.PageSize>0)  chart.PageSize=option.KLine.PageSize;
            if (option.KLine.IsShowTooltip==false) chart.IsShowTooltip=false;
            if (option.KLine.MaxRequestMinuteDayCount>0) chart.MaxRequestMinuteDayCount=option.KLine.MaxRequestMinuteDayCount;
            if (option.KLine.DrawType) chart.KLineDrawType=option.KLine.DrawType;
            if (option.KLine.RightSpaceCount>0) chart.RightSpaceCount=option.KLine.RightSpaceCount;
        }

        if (option.Train)
        {
            if (option.Train.DataCount) chart.TrainDataCount=option.Train.DataCount;
            if (option.Train.Callback) chart.TrainCallback=option.Train.Callback;
            if (option.Train.StartDate) chart.TrainStartDate=option.Train.StartDate;
        }

        if (!option.Windows || option.Windows.length<=0) return null;

        //创建子窗口
        chart.Create(option.Windows.length);

        if (option.Border)
        {
            if (!isNaN(option.Border.Left)) chart.Frame.ChartBorder.Left=option.Border.Left;
            if (!isNaN(option.Border.Right)) chart.Frame.ChartBorder.Right=option.Border.Right;
            if (!isNaN(option.Border.Top)) chart.Frame.ChartBorder.Top=option.Border.Top;
            if (!isNaN(option.Border.Bottom)) chart.Frame.ChartBorder.Bottom=option.Border.Bottom;
        }

        this.AdjustChartBorder(chart);

        if (option.IsShowCorssCursorInfo==false) chart.ChartCorssCursor.IsShowText=option.IsShowCorssCursorInfo; //取消显示十字光标刻度信息
        if (option.IsCorssOnlyDrawKLine===true) chart.ChartCorssCursor.IsOnlyDrawKLine=option.IsCorssOnlyDrawKLine;
        if (option.CorssCursorTouchEnd===true) chart.CorssCursorTouchEnd = option.CorssCursorTouchEnd;
        if (option.IsClickShowCorssCursor==true) chart.IsClickShowCorssCursor=option.IsClickShowCorssCursor;
        if (option.CorssCursorInfo)
        {
            if (!isNaN(option.CorssCursorInfo.Left)) chart.ChartCorssCursor.ShowTextMode.Left=option.CorssCursorInfo.Left;
            if (!isNaN(option.CorssCursorInfo.Right)) chart.ChartCorssCursor.ShowTextMode.Right=option.CorssCursorInfo.Right;
            if (!isNaN(option.CorssCursorInfo.Bottom)) chart.ChartCorssCursor.ShowTextMode.Bottom=option.CorssCursorInfo.Bottom;
            if (option.CorssCursorInfo.IsShowCorss===false) chart.ChartCorssCursor.IsShowCorss=option.CorssCursorInfo.IsShowCorss;
            if (option.CorssCursorInfo.IsShowClose == true) chart.ChartCorssCursor.IsShowClose = option.CorssCursorInfo.IsShowClose;    //Y轴显示收盘价
            if (option.CorssCursorInfo.PressTime) chart.PressTime=option.CorssCursorInfo.PressTime; //长按显示十字光标的时间
            if (option.CorssCursorInfo.HPenType>0) chart.ChartCorssCursor.HPenType=option.CorssCursorInfo.HPenType;
            if (option.CorssCursorInfo.VPenType>0) chart.ChartCorssCursor.VPenType=option.CorssCursorInfo.VPenType;
        }

        //保存十字光标文字高度
        option.CorssCursor={};
        option.CorssCursor.TitleHeight=chart.ChartCorssCursor.TextHeight;

        if (option.Frame)
        {
            for(var i=0;i<option.Frame.length;++i)
            {
                var item=option.Frame[i];
                if (!chart.Frame.SubFrame[i]) continue;
                if (item.SplitCount) chart.Frame.SubFrame[i].Frame.YSplitOperator.SplitCount=item.SplitCount;
                if (item.StringFormat) chart.Frame.SubFrame[i].Frame.YSplitOperator.StringFormat=item.StringFormat;
                if (IFrameSplitOperator.IsNumber(item.FloatPrecision)) chart.Frame.SubFrame[i].Frame.YSplitOperator.FloatPrecision=item.FloatPrecision;
                if (item.Custom) chart.Frame.SubFrame[i].Frame.YSplitOperator.Custom=item.Custom;
                if (IFrameSplitOperator.IsNumber(item.SplitType)) chart.Frame.SubFrame[i].Frame.YSplitOperator.SplitType=item.SplitType;
                if (item.Height>0) chart.Frame.SubFrame[i].Height = item.Height;

                if (item.IsShowLeftText==false) chart.Frame.SubFrame[i].Frame.YSplitOperator.IsShowLeftText=item.IsShowLeftText;            //显示左边刻度
                if (item.IsShowRightText==false) chart.Frame.SubFrame[i].Frame.YSplitOperator.IsShowRightText=item.IsShowRightText;         //显示右边刻度 
            }
        }

        if (option.KLine) 
        {
            if (option.KLine.ShowKLine == false) chart.ChartPaint[0].IsShow = false;
            if (option.KLine.InfoPosition>0) chart.ChartPaint[0].InfoPosition=option.KLine.InfoPosition;
            if (option.KLine.IsShowMaxMinPrice == false) chart.ChartPaint[0].IsShowMaxMinPrice=option.KLine.IsShowMaxMinPrice;
        }

        if(option.KLineTitle)    //股票名称 日期 周期
        {
            if(option.KLineTitle.IsShowName==false) chart.TitlePaint[0].IsShowName=false;
            if(option.KLineTitle.IsShowSettingInfo==false) chart.TitlePaint[0].IsShowSettingInfo=false;
            if(option.KLineTitle.IsShow == false) chart.TitlePaint[0].IsShow = false;
        }

        if (option.ExtendChart)
        {
            for(var i=0;i<option.ExtendChart.length;++i)
            {
                var item=option.ExtendChart[i];
                chart.CreateExtendChart(item.Name, item);
            }
        }

        if (IFrameSplitOperator.IsNonEmptyArray(option.Windows))
        {
            //创建子窗口的指标
            let scriptData = new JSIndexScript();
            for(var i=0;i<option.Windows.length;++i)
            {
                var item=option.Windows[i];
                if (item.Script)
                {
                    chart.WindowIndex[i]=new ScriptIndex(item.Name,item.Script,item.Args,item);    //脚本执行
                }
                else
                {
                    let indexItem=JSIndexMap.Get(item.Index);
                    if (indexItem)
                    {
                        chart.WindowIndex[i]=indexItem.Create();
                        chart.CreateWindowIndex(i);
                    }
                    else
                    {
                        let indexInfo = scriptData.Get(item.Index);
                        if (!indexInfo) continue;

                        if (item.Lock) indexInfo.Lock=item.Lock;
                        chart.WindowIndex[i] = new ScriptIndex(indexInfo.Name, indexInfo.Script, indexInfo.Args,indexInfo);    //脚本执行
                    }

                }

                if (item.Modify!=null) chart.Frame.SubFrame[i].Frame.ModifyIndex=item.Modify;
                if (item.Change!=null) chart.Frame.SubFrame[i].Frame.ChangeIndex=item.Change;
                if (item.Close!=null) chart.Frame.SubFrame[i].Frame.CloseIndex=item.Close;

                if (!isNaN(item.TitleHeight)) chart.Frame.SubFrame[i].Frame.ChartBorder.TitleHeight=item.TitleHeight;
            }
        }

        this.AdjustTitleHeight(chart);
        
        return chart;
    }

    //深度图
    this.CreateDepthChartContainer=function(option)
    {
        var chart=null;
        chart=new DepthChartContainer(this.CanvasElement);
        if (option.NetworkFilter) chart.NetworkFilter=option.NetworkFilter;

        if (option.EnableScrollUpDown==true) chart.EnableScrollUpDown=option.EnableScrollUpDown;
        if (IFrameSplitOperator.IsPlusNumber(option.MaxVolRate)) chart.MaxVolRate=option.MaxVolRate;
        if (option.ZoomStepPixel>0) chart.ZoomStepPixel=option.ZoomStepPixel;

        chart.Create(option.Listener);  

        if (option.Border)
        {
            if (IFrameSplitOperator.IsNumber(option.Border.Left)) chart.Frame.ChartBorder.Left=option.Border.Left;
            else option.Border.Left=chart.Frame.ChartBorder.Left;
            if (IFrameSplitOperator.IsNumber(option.Border.Right)) chart.Frame.ChartBorder.Right=option.Border.Right;
            else option.Border.Right=chart.Frame.ChartBorder.Right;
            if (IFrameSplitOperator.IsNumber(option.Border.Top)) chart.Frame.ChartBorder.Top=option.Border.Top;
            else option.Border.Top=chart.Frame.ChartBorder.Top;
            if (IFrameSplitOperator.IsNumber(option.Border.Bottom)) chart.Frame.ChartBorder.Bottom=option.Border.Bottom;
            else option.Border.Bottom=chart.Frame.ChartBorder.Bottom;
        }

        this.AdjustChartBorder(chart);

        if (option.CorssCursorTouchEnd===true) chart.CorssCursorTouchEnd = option.CorssCursorTouchEnd;

        if (option.CorssCursorInfo)
        {
            var item=option.CorssCursorInfo;
            if (IFrameSplitOperator.IsNumber(item.HPenType)) chart.ChartCorssCursor.HPenType=item.HPenType;
            if (IFrameSplitOperator.IsNumber(item.VPenType)) chart.ChartCorssCursor.VPenType=item.VPenType;
            if (IFrameSplitOperator.IsBool(item.IsShowTooltip)) chart.ChartCorssCursor.IsShowTooltip=item.IsShowTooltip;
        }
        
        if (option.Frame)
        {
            var item=option.Frame
            if (item.SplitCount) chart.Frame.YSplitOperator.SplitCount=item.SplitCount;
            if (IFrameSplitOperator.IsNumber(item.SplitType)) chart.Frame.YSplitOperator.SplitType=item.SplitType;
            if (IFrameSplitOperator.IsNumber(item.Height)) chart.Frame.Height = item.Height;
            if (IFrameSplitOperator.IsNumber(item.YLineType)) chart.Frame.YSplitOperator.LineType=item.YLineType;
            if (IFrameSplitOperator.IsNumber(item.XLineType)) chart.Frame.XSplitOperator.LineType=item.XLineType;
            if (Array.isArray(item.IgnoreYValue)) chart.Frame.YSplitOperator.IgnoreYValue=item.IgnoreYValue;
            if (item.IsShowLeftText===false || item.IsShowLeftText===true) 
            {
                chart.Frame.IsShowYText[0]=item.IsShowLeftText;
                chart.Frame.YSplitOperator.IsShowLeftText=item.IsShowLeftText;            //显示左边刻度
            }
            if (item.IsShowRightText===false || item.IsShowRightText===true) 
            {
                chart.Frame.IsShowYText[1]=item.IsShowRightText;
                chart.Frame.YSplitOperator.IsShowRightText=item.IsShowRightText;          //显示右边刻度
            }

            if (item.IsShowXLine==false) chart.Frame.IsShowXLine=item.IsShowXLine;
            if (item.IsShowYLine==false) chart.Frame.IsShowYLine=item.IsShowYLine;
        }

        return chart;
    }

    //根据option内容绘制图形
    this.SetOption=function(option)
    {
        var chart=null;
        switch(option.Type)
        {
            case "历史K线图":
            case '历史K线图横屏':
                chart=this.CreateKLineChartContainer(option);
                break;
            case "自定义指数历史K线图":
                chart=this.CreateCustomKLineChartContainer(option);
                break;
            case "分钟走势图":
            case "分钟走势图横屏":
                chart=this.CreateMinuteChartContainer(option);
                break;
            case "历史分钟走势图":
                chart=this.CreateHistoryMinuteChartContainer(option);
                break;
            case 'K线训练':
            case 'K线训练横屏':
                chart=this.CreateKLineTrainChartContainer(option);
                break;
            case "深度图":
                chart=this.CreateDepthChartContainer(option);
                break;
            case "简单图形":
                return this.CreateSimpleChart(option);
            case "饼图":
            case '雷达图':
                return this.CreatePieChart(option);
            case '地图':
                return this.CreateMapChart(option);
            default:
                return false;
        }

        if (!chart) return false;

        //是否自动更新
        if (option.IsAutoUpdate!=null) chart.IsAutoUpdate=option.IsAutoUpdate;
        if (option.AutoUpdateFrequency>0) chart.AutoUpdateFrequency=option.AutoUpdateFrequency;
        //注册事件
        if (option.EventCallback)
        {
            for(var i=0;i<option.EventCallback.length;++i)
            {
                var item=option.EventCallback[i];
                chart.AddEventCallback(item);
            }
        }
        

        //设置股票代码
        if (!option.Symbol) 
        {
            chart.DrawEmpty();
            this.JSChartContainer=chart;
            this.DivElement.JSChart=this;   //div中保存一份
        }
        else
        {
            chart.Draw();
            chart.ChangeSymbol(option.Symbol);
    
            this.JSChartContainer=chart;
            this.DivElement.JSChart=this;   //div中保存一份
            this.JSChartContainer.Draw();
        }
    }

    this.CreateSimpleChart=function(option)
    {
        var chart=new SimlpleChartContainer(this.CanvasElement);
        if (option.MainDataControl) chart.MainDataControl=option.MainDataControl;

        chart.Create();

        if (option.Border)  //边框设置
        {
            if (!isNaN(option.Border.Left)) chart.Frame.ChartBorder.Left=option.Border.Left;
            if (!isNaN(option.Border.Right)) chart.Frame.ChartBorder.Right=option.Border.Right;
            if (!isNaN(option.Border.Top)) chart.Frame.ChartBorder.Top=option.Border.Top;
        }

        
        chart.Draw();
        chart.RequestData();

        this.JSChartContainer=chart;
        this.DivElement.JSChart=this;   //div中保存一份
        this.JSChartContainer.Draw();
    }

    //创建饼图
    this.CreatePieChart=function(option)
    {
        var chart=new PieChartContainer(this.CanvasElement);
        if (option.MainDataControl) chart.MainDataControl=option.MainDataControl;

        if(option.Radius) chart.Radius = option.Radius;
        
        chart.Create();

        if (option.Border)  //边框设置
        {
            if (!isNaN(option.Border.Left)) chart.Frame.ChartBorder.Left=option.Border.Left;
            if (!isNaN(option.Border.Right)) chart.Frame.ChartBorder.Right=option.Border.Right;
            if (!isNaN(option.Border.Top)) chart.Frame.ChartBorder.Top=option.Border.Top;
        }

        this.AdjustChartBorder(chart);

        if (option.Frame) 
        {
            if (option.Frame[0].IsShowBorder == false) chart.Frame.IsShowBorder = option.Frame[0].IsShowBorder;
        }
        
        chart.Draw();
        chart.RequestData();

        this.JSChartContainer=chart;
        this.DivElement.JSChart=this;   //div中保存一份
        this.JSChartContainer.Draw();
        
    }

    this.CreateMapChart=function(option)
    {
        var chart=new MapChartContainer(this.CanvasElement);
        if (option.MainDataControl) chart.MainDataControl=option.MainDataControl;

        chart.Create();

        if (option.Border)  //边框设置
        {
            if (!isNaN(option.Border.Left)) chart.Frame.ChartBorder.Left=option.Border.Left;
            if (!isNaN(option.Border.Right)) chart.Frame.ChartBorder.Right=option.Border.Right;
            if (!isNaN(option.Border.Top)) chart.Frame.ChartBorder.Top=option.Border.Top;
        }
        
        chart.Draw();
        chart.RequestData();

        this.JSChartContainer=chart;
        this.DivElement.JSChart=this;   //div中保存一份
        this.JSChartContainer.Draw();
    }

    //创建工具条
    this.CreateToolbar=function(option)
    {

    }

    //创建设置div窗口
    this.CreateSettingDiv=function(option)
    {

    }

    this.Focus=function()
    {
        if (this.CanvasElement) this.CanvasElement.focus();
    }

    //切换股票代码接口
    this.ChangeSymbol=function(symbol, option)
    {
        if (this.JSChartContainer) this.JSChartContainer.ChangeSymbol(symbol,option);
    }

    //K线切换指标
    this.ChangeIndex=function(windowIndex,indexName,option)
    {
        if (this.JSChartContainer && typeof(this.JSChartContainer.ChangeIndex)=='function')
            this.JSChartContainer.ChangeIndex(windowIndex,indexName,option);
    }

    this.AddIndexWindow=function(indexName,option)
    {
        if (this.JSChartContainer && typeof(this.JSChartContainer.AddIndexWindow)=='function')
            this.JSChartContainer.AddIndexWindow(indexName,option);
    }

    this.RemoveIndexWindow=function(id)
    {
        if (this.JSChartContainer && typeof(this.JSChartContainer.RemoveIndexWindow)=='function')
            this.JSChartContainer.RemoveIndexWindow(id);
    }

    this.ChangeScriptIndex=function(windowIndex,indexData,option)
    {
        if (this.JSChartContainer && typeof(this.JSChartContainer.ChangeScriptIndex)=='function')
            this.JSChartContainer.ChangeScriptIndex(windowIndex,indexData,option);
    }

    this.ChangePyScriptIndex=function(windowIndex, indexData)   //切换py指标
    {
        if (this.JSChartContainer && typeof(this.JSChartContainer.ChangePyScriptIndex)=='function')
            this.JSChartContainer.ChangePyScriptIndex(windowIndex,indexData);
    }

    this.GetIndexInfo=function()
    {
        if (this.JSChartContainer && typeof(this.JSChartContainer.GetIndexInfo)=='function')
            return this.JSChartContainer.GetIndexInfo();
        else 
            return [];
    }

    this.ChangeInstructionIndex=function(indexName) 
    {
        if (this.JSChartContainer && typeof(this.JSChartContainer.ChangeInstructionIndex)=='function')
            this.JSChartContainer.ChangeInstructionIndex(indexName);
    }

    this.ChangeInstructionScriptIndex=function(indexData)
    {
        if (this.JSChartContainer && typeof(this.JSChartContainer.ChangeInstructionIndex)=='function')
            this.JSChartContainer.ChangeInstructionScriptIndex(indexData);
    }

    this.CancelInstructionIndex=function()
    {
        if (this.JSChartContainer && typeof(this.JSChartContainer.CancelInstructionIndex)=='function')
            this.JSChartContainer.CancelInstructionIndex();
    }

    //K线周期切换
    this.ChangePeriod=function(period, option)
    {
        if (this.JSChartContainer && typeof(this.JSChartContainer.ChangePeriod)=='function')
            this.JSChartContainer.ChangePeriod(period, option);
    }

    //K线复权切换
    this.ChangeRight=function(right)
    {
        if (this.JSChartContainer && typeof(this.JSChartContainer.ChangeRight)=='function')
            this.JSChartContainer.ChangeRight(right);
    }

    //叠加股票
    this.OverlaySymbol=function(symbol,option)
    {
        if (this.JSChartContainer && typeof(this.JSChartContainer.OverlaySymbol)=='function')
            this.JSChartContainer.OverlaySymbol(symbol,option);
    }

    //删除一个叠加股票
    this.DeleteOverlaySymbol=function(symbol)
    {
        if (this.JSChartContainer && typeof(this.JSChartContainer.DeleteOverlaySymbol)=='function')
        this.JSChartContainer.DeleteOverlaySymbol(symbol);
    }

    //设置当前屏的起始日期 { Date:起始日期(必填), Time:起始时间(分钟K线必填) PageSize:一屏显示的数据个数(可选)}
    this.SetFirstShowDate=function(obj)
    {
        if (this.JSChartContainer && typeof(this.JSChartContainer.SetFirstShowDate)=='function')
            this.JSChartContainer.SetFirstShowDate(obj);
    }

    //K线切换类型 0=实心K线 1=收盘价线 2=美国线 3=空心K线 4=面积图
    this.ChangeKLineDrawType=function(drawType, isDraw)
    {
        if (this.JSChartContainer && typeof(this.JSChartContainer.ChangeKLineDrawType)=='function')
            this.JSChartContainer.ChangeKLineDrawType(drawType,isDraw);
    }
	
	//指标窗口个数
    this.ChangeIndexWindowCount = function(count, option)
    {
        if(this.JSChartContainer && typeof(this.JSChartContainer.ChangeIndexWindowCount) == 'function')
        {
            this.JSChartContainer.ChangeIndexWindowCount(count,option);
        }
    }
	
	//取消叠加
    this.ClearOverlaySymbol = function(){
        if(this.JSChartContainer && typeof(this.JSChartContainer.ClearOverlaySymbol) == 'function'){
            this.JSChartContainer.ClearOverlaySymbol();
        } 
    }

    this.DeleteKLineInfo=function(infoName)
    {
        if(this.JSChartContainer && typeof(this.JSChartContainer.DeleteKLineInfo) == 'function')
        {
            this.JSChartContainer.DeleteKLineInfo(infoName);
        } 
    }
    
    this.ClearKLineInfo=function()
    {
        if(this.JSChartContainer && typeof(this.JSChartContainer.ClearKLineInfo) == 'function')
        {
            this.JSChartContainer.ClearKLineInfo();
        } 
    }

    this.AddKLineInfo=function(infoName, bUpdate)
    {
        if(this.JSChartContainer && typeof(this.JSChartContainer.AddKLineInfo) == 'function')
        {
            this.JSChartContainer.AddKLineInfo(infoName,bUpdate);
        } 
    }

    this.ChangMainDataControl=function(dataControl)
    {
        if (this.JSChartContainer && typeof(this.JSChartContainer.SetMainDataConotrl)=='function') 
            this.JSChartContainer.SetMainDataConotrl(dataControl);
    }

    this.AddOverlayIndex=function(obj) //{WindowIndex:窗口ID, IndexName:指标ID, Identify:叠加指标ID(可选), API}
    {
        if (this.JSChartContainer && typeof(this.JSChartContainer.AddOverlayIndex)=='function') 
            this.JSChartContainer.AddOverlayIndex(obj);
    }

    this.DeleteOverlayWindowsIndex=function(identify)
    {
        if (this.JSChartContainer && typeof(this.JSChartContainer.DeleteOverlayWindowsIndex)=='function') 
            this.JSChartContainer.DeleteOverlayWindowsIndex(identify);
    }

    this.StopAutoUpdate=function()
    {
        if (this.JSChartContainer && typeof(this.JSChartContainer.StopAutoUpdate)=='function') 
            this.JSChartContainer.StopAutoUpdate();
    }

    this.ChartDestory=function()
    {
        if (this.JSChartContainer && typeof (this.JSChartContainer.ChartDestory) == 'function') 
        {
            this.JSChartContainer.ChartDestory();
        }
    }

    //设置深度图数据 depthData=[ {ID:深度图ID, Data:数据},]   bDraw=是否立即重绘
    this.SetDepthMapData=function(depthData, bDraw)
    {
        if (this.JSChartContainer && typeof(this.JSChartContainer.SetDepthMapData)=='function') 
            this.JSChartContainer.SetDepthMapData(depthData, bDraw);
    }

    //设置强制横屏
    this.ForceLandscape=function(bForceLandscape)
    {
        if (this.JSChartContainer) 
        {
            JSConsole.Chart.Log("[JSChart::ForceLandscape] bForceLandscape="+bForceLandscape);
            this.JSChartContainer.IsForceLandscape=bForceLandscape;
        }
    }

    //锁指标
    this.LockIndex=function(lockData)
    {
        if(this.JSChartContainer && typeof(this.JSChartContainer.LockIndex)=='function')
        {
            JSConsole.Chart.Log('[JSChart:LockIndex] lockData', lockData);
            this.JSChartContainer.LockIndex(lockData);
        }
    }

    //历史分钟数据 更改日期
    this.ChangeTradeDate=function(tradeDate)
    {
        if(this.JSChartContainer && typeof(this.JSChartContainer.ChangeTradeDate)=='function')
        {
            JSConsole.Chart.Log('[JSChart:ChangeTradeDate] date', tradeDate);
            this.JSChartContainer.ChangeTradeDate(tradeDate);
        }
    }

    //多日走势图
    this.ChangeDayCount=function(count)
    {
        if(this.JSChartContainer && typeof(this.JSChartContainer.ChangeDayCount)=='function')
        {
            JSConsole.Chart.Log('[JSChart:ChangeDayCount] count', count);
            this.JSChartContainer.ChangeDayCount(count);
        }
    }

    //集合竞价显示/隐藏
    this.ShowCallAuctionData=function(obj, option)
    {
        if(this.JSChartContainer && typeof(this.JSChartContainer.ShowCallAuctionData)=='function')
        {
            JSConsole.Chart.Log('[JSChart:ShowCallAuctionData] obj, option ', obj, option);
            this.JSChartContainer.ShowCallAuctionData(obj, option);
        }
    }

    //返回弹幕数据类
    this.StartAnimation=function(option)
    {
        if(this.JSChartContainer && typeof(this.JSChartContainer.StartAnimation)=='function')
        {
            JSConsole.Chart.Log('[JSChart:StartAnimation] start.');
            return this.JSChartContainer.StartAnimation(option);
        }
    }

    this.StopAnimation=function()
    {
        if(this.JSChartContainer && typeof(this.JSChartContainer.StopAnimation)=='function')
        {
            JSConsole.Chart.Log('[JSChart:StopAnimation] start.');
            return this.JSChartContainer.StopAnimation();
        }
    }

    this.SaveToImage = function (format,colorGB)    //format=保存的文件格式,  colorGB=背景色
    {
        if (this.JSChartContainer && typeof (this.JSChartContainer.SaveToImage) == 'function')
            return this.JSChartContainer.SaveToImage(format,colorGB);
    }

    this.SaveToImageUrl=function(obj, callback)
    {
        if (this.JSChartContainer && typeof (this.JSChartContainer.SaveToImageUrl) == 'function')
            return this.JSChartContainer.SaveToImageUrl(obj, callback);
    }

    //事件回调
    this.AddEventCallback=function(obj)
    {
        if(this.JSChartContainer && typeof(this.JSChartContainer.AddEventCallback)=='function')
        {
            JSConsole.Chart.Log('[JSChart:AddEventCallback] ', obj);
            this.JSChartContainer.AddEventCallback(obj);
        }
    }

    //设置语言 'EN', 'CN'
    this.SetLanguage=function(language)
    {
        if(this.JSChartContainer && typeof(this.JSChartContainer.SetLanguage)=='function')
        {
            JSConsole.Chart.Log('[JSChart:SetLanguage] ', language);
            this.JSChartContainer.SetLanguage(language);
        }
    }

    //切换指标模板
    this.ChangeIndexTemplate=function(option)
    {
        if(this.JSChartContainer && typeof(this.JSChartContainer.ChangeIndexTemplate)=='function')
        {
            JSConsole.Chart.Log('[JSChart:ChangeIndexTemplate] ', option);
            this.JSChartContainer.ChangeIndexTemplate(option);
        }
    }

    //画图工具
    this.SetChartDrawOption=function(option)
    {
        if(this.JSChartContainer && typeof(this.JSChartContainer.SetChartDrawOption)=='function')
        {
            JSConsole.Chart.Log('[JSChart:SetChartDrawOption] ', option);
            this.JSChartContainer.SetChartDrawOption(option);
        }
    }

    this.CreateChartDrawPicture=function(name,option)
    {
        if(this.JSChartContainer && typeof(this.JSChartContainer.CreateChartDrawPicture)=='function')
        {
            JSConsole.Chart.Log('[JSChart:CreateChartDrawPicture] ', name);
            this.JSChartContainer.CreateChartDrawPicture(name,option);
        }
    }

    //删除画图工具
    this.ClearChartDrawPicture=function(drawPicture)
    {
        if(this.JSChartContainer && typeof(this.JSChartContainer.ClearChartDrawPicture)=='function')
        {
            //JSConsole.Chart.Log('[JSChart:ClearChartDrawPicture] ', drawPicture);
            this.JSChartContainer.ClearChartDrawPicture(drawPicture);
        }
    }

    //重新加载配置
    this.ReloadResource=function(option)
    {
        if(this.JSChartContainer && typeof(this.JSChartContainer.ReloadResource)=='function')
        {
            JSConsole.Chart.Log('[JSChart:ReloadResource] ');
            this.JSChartContainer.ReloadResource(option);
        }
    }

    this.EnableSplashScreen=function(option)
    {
        if(this.JSChartContainer && typeof(this.JSChartContainer.EnableSplashScreen)=='function')
        {
            JSConsole.Chart.Log('[JSChart:EnableSplashScreen] ');
            this.JSChartContainer.EnableSplashScreen(option);
        }
    }
}

//初始化
JSChart.Init=function(divElement)
{
    var jsChartControl=new JSChart(divElement);
    jsChartControl.OnSize();

    return jsChartControl;
}

JSChart.SetDomain=function(domain,cacheDomain)
{
    if (domain) g_JSChartResource.Domain=domain;
    if (cacheDomain) g_JSChartResource.CacheDomain=cacheDomain;
}

JSChart.SetPyIndexDomain=function(domain)   //设置py指标计算api域名
{
    if  (domain) g_JSChartResource.PyIndexDomain=domain;
}

//自定义风格
JSChart.SetStyle=function(option)
{
    if (option) g_JSChartResource.SetStyle(option);
}

//value { EN:'', CH:'' }
JSChart.SetTextResource=function(key,value)
{
    g_JSChartLocalization.SetTextResource(key,value);
}

//获取本地化资源
JSChart.GetLocalization=function()  
{
    return g_JSChartLocalization;
}

//获取设备分辨率比
JSChart.GetDevicePixelRatio=function()
{
    return GetDevicePixelRatio();
}

JSChart.CreateGuid=function()
{
    return Guid();
}

JSChart.GetResource=function()  //获取颜色配置 (设置配必须啊在JSChart.Init()之前)
{
    return g_JSChartResource;
}

JSChart.GetMinuteTimeStringData=function()
{
    return g_MinuteTimeStringData;
}

JSChart.GetMinuteCoordinateData=function()
{
    return g_MinuteCoordinateData;
}

JSChart.GetKLineZoom=function() //K线缩放配置
{
    return ZOOM_SEED;
}

JSChart.GetDivTooltipDataFormat=function()  //div tooltip数据格式化
{
    return g_DivTooltipDataForamt;
}

JSChart.SetUSATimeType=function(type)    //设置 0=标准时间 1=夏令时间 3=美国时间
{
    g_NYMEXTimeData.TimeType=type;
    g_COMEXTimeData.TimeType=type;
    g_NYBOTTimeData.TimeType=type;
    g_CBOTTimeData.TimeType=type;
}

JSChart.GetChinaFuturesTimeData=function()  //获取国内期货交易时间配置
{
    return g_FuturesTimeData;
}

JSChart.AddPeriodCallback=function(obj)     //添加自定义周期方法 { Period:周期ID, Callback:回调 }
{
    g_DataPlus.AddPeriodCallback(obj);
}

JSChart.RemovePeriodCallback=function(obj) //添加自定义周期方法 { Period:周期ID, }
{
    g_DataPlus.RemovePeriodCallback(obj);
}

//注册一个新的画图工具 {Name:中文名字, ClassName:类名, Create:function()}
JSChart.RegisterDrawPicture=function(obj)  
{
    return IChartDrawPicture.RegisterDrawPicture(obj);
}

//注册一个新图标 {Name:, Text: , Color:, Family:}
JSChart.RegisterDrawPictureIonFont=function(obj)
{
    return IChartDrawPicture.RegisterIonFont(obj);
}

JSChart.GetInternalTimeData=function(name)  //内置品种交易时间
{
    switch(name)
    {
        case "NYMEXTimeData":
            return g_NYMEXTimeData;
        case "COMEXTimeData":
            return g_COMEXTimeData;
        case "NYBOTTimeData":
            return g_NYBOTTimeData;
        case "CBOTTimeData":
            return g_CBOTTimeData;
        case "LMETimeData":
            return g_LMETimeData;
        case "FuturesTimeData":
            return g_FuturesTimeData;
        default:
            return null;
    }
}

JSChart.RegisterExtendChartClass=function(name, option)
{
    g_ExtendChartPaintFactory.Add(name,option);
}

var JSCHART_EVENT_ID=
{
    RECV_KLINE_MATCH:1, //接收到形态匹配
    RECV_INDEX_DATA:2,  //接收指标数据
    RECV_HISTROY_DATA:3,//接收到历史数据
    RECV_TRAIN_MOVE_STEP:4, //接收K线训练,移动一次K线
    CHART_STATUS:5,          //每次Draw() 以后会调用
    BARRAGE_PLAY_END:6,      //单个弹幕播放完成
    RECV_OVERLAY_INDEX_DATA:7,//接收叠加指标数据
    DBCLICK_KLINE:8,            //双击K线图
    RECV_START_AUTOUPDATE:9,    //开始自动更新
    RECV_STOP_AUTOUPDATE:10,    //停止自动更新
    ON_CONTEXT_MENU:11,         //右键菜单事件
    ON_TITLE_DRAW:12,           //标题信息绘制事件
    ON_SELECT_RECT:13,          //区间选择事件通知
    RECV_MINUTE_DATA:14,        //分时图数据到达
    ON_CLICK_INDEXTITLE:15,     //点击指标标题事件
    RECV_KLINE_UPDATE_DATA:16,   //K线日,分钟更新数据到达
    ON_CLICK_DRAWPICTURE:17,    //点击画图工具 
    ON_FINISH_DRAWPICTURE:18,    //完成画图工具    
    ON_INDEXTITLE_DRAW:19,       //指标标题重绘事件
    ON_CUSTOM_VERTICAL_DRAW:20,  //自定义X轴绘制事件
    RECV_KLINE_MANUAL_UPDATE_DATA:21,   //手动更新K线事件
    ON_ENABLE_SPLASH_DRAW:22,           //开启/关闭过场动画事件

    ON_CLICK_CHART_PAINT:23,            //点击图形

    ON_DRAW_MINUTE_LAST_POINT:24,        //分时图绘制回调事件, 返回最后一个点的坐标
    ON_DRAW_DEPTH_TOOLTIP:25,            //绘制深度图tooltip事件
    ON_CLICK:26,                         //点击事件
    ON_PHONE_TOUCH:27,                   //手势点击事件 包含 TouchStart 和 TouchEnd

    ON_CLICKUP_CHART_PAINT:28,           //点击图形鼠标抬起

    ON_SPLIT_YCOORDINATE:29,             //分割Y轴及格式化刻度文字
    ON_DBCLICK:30,
    ON_SPLIT_XCOORDINATE:31             //分割X轴及格式化刻度文字
}

var JSCHART_OPERATOR_ID=
{
    OP_SCROLL_LEFT:1,   //往左移动
    OP_SCROLL_RIGHT:2,  //往右移动
    OP_ZOOM_OUT:3,  //缩小
    OP_ZOOM_IN:4,   //放大
    OP_GOTO_HOME:5, //最新一天数据
    OP_GOTO_END:6,  //第1天的数据

    OP_LEFT_ZOOM_OUT:7,   //左边缩小
    OP_LEFT_ZOOM_IN:8,    //左右放大

    OP_RIGHT_ZOOM_OUT:9,  //右边缩小
    OP_RIGHT_ZOOM_IN:10   //右边放大
}

var JSCHART_DRAG_ID=
{
    DISABLE_DRAG_ID:0,
    CLICK_TOUCH_MODE_ID:3   //长按十字光标显示保留/点击十字光标消失 (使用TouchStatus)
}

var JSCHART_BUTTON_ID=
{
    CLOSE_BEFOREOPEN_ID:1,  //关闭集合竞价
}



/*
    图形控件
*/
function JSChartContainer(uielement, OffscreenElement)
{
    this.ClassName='JSChartContainer';
    var _self = this;
    this.Frame;                                     //框架画法
    this.ChartPaint=new Array();                    //图形画法
    this.ChartPaintEx=[];                           //图形扩展画法
    this.ChartInfo=new Array();                     //K线|走势图上信息地雷
    this.ChartInfoPaint;                            //信息地理
    this.ExtendChartPaint=new Array();              //扩展画法
    this.TitlePaint=new Array();                    //标题画法
    this.OverlayChartPaint=new Array();             //叠加信息画法
    this.ChartDrawPicture=new Array();              //画图工具
    this.ChartDrawStorage;                          //画图工具保存
    this.ChartDrawOption={ IsLockScreen:false, Zoom:5 };   //画图工具设置 { IsLockScreen://是否锁住屏幕, Zoom: //线段|点放大倍数 }
    this.CurrentChartDrawPicture=null;              //当前的画图工具
    this.SelectChartDrawPicture=null;               //当前选中的画图
    this.EnableShowCorssCursor={ DrawPicture:true };  //DrawPicture=画图是否显示十字光标
    this.ChartPictureMenu;                          //画图工具 单个图形设置菜单
    this.ChartCorssCursor;                          //十字光标
    this.IsClickShowCorssCursor=false;              //手势点击显示十字光标
    this.ChartSplashPaint=null;                     //等待提示
    this.LoadDataSplashTitle="数据加载中";           //下载数据提示信息
    if (OffscreenElement) 
    {
        this.Canvas=OffscreenElement.getContext("2d");
        this.OffscreenCanvasElement=OffscreenElement;

        this.ShowCanvas=uielement.getContext("2d");
    }
    else
    {
        this.Canvas=uielement.getContext("2d");         //画布
        this.ShowCanvas=null;
    }
    
    this.UIElement=uielement;
    this.MouseDrag;
    this.PhoneTouchInfo;    //手机手势信息
    this.DragMode=1;                                //拖拽模式 0 禁止拖拽 1 数据拖拽 2 区间选择 3(CLICK_TOUCH_MODE_ID)=长按十字光标显示保留/点击十字光标消失 (使用TouchStatus)
    this.EnableBorderDrag=true;                     //是否可以拖拽边框调整指标框高度
    this.BorderDrag;    //{ Index:, }
    this.YDrag;         //{Index: }                 //y轴拖拽放大缩小
    this.TouchStatus={ CorssCursorShow:false },     //十字光标是否显示
    this.DragTimer;
    this.EnableScrollUpDown=false;                  //是否可以上下滚动图形(手机端才有)
    this.ClickChartTimer=null;                      //点击图形定时器,解决双击和单击K线事件

    this.CursorIndex=0;             //十字光标X轴索引
    this.LastPoint=new Point();     //鼠标位置
    this.IsForceLandscape=false;    //是否强制横屏
    this.CorssCursorTouchEnd = false;   //手离开屏幕自动隐藏十字光标
    this.IsTitleShowLatestData=false;     //十字/手势不在K线图上,标题显示最新一个数据
    this.StepPixel=4;                   //移动一个数据需要的像素
    this.ZoomStepPixel=5;               //放大缩小手势需要的最小像素
    this.TouchMoveMinAngle=70;          //左右移动最小角度
    this.EnableAnimation=false;         //是否开启动画

    //tooltip提示信息
    this.Tooltip=document.createElement("div");
    this.Tooltip.className='jschart-tooltip';
    this.Tooltip.style.background=g_JSChartResource.TooltipBGColor;
    this.Tooltip.style.opacity=g_JSChartResource.TooltipAlpha;
    this.Tooltip.style["pointer-events"]="none";
    this.Tooltip.id=Guid();
    uielement.parentNode.appendChild(this.Tooltip);
    this.IsShowTooltip=true;    //是否显示K线tooltip

    //区间选择
    this.SelectRect=document.createElement("div");
    this.SelectRect.className="jschart-selectrect";
    this.SelectRect.style.background=g_JSChartResource.SelectRectBGColor;
    this.SelectRect.style["pointer-events"]="none";
    //this.SelectRect.style.opacity=g_JSChartResource.SelectRectAlpha;
    this.SelectRect.id=Guid();
    this.SelectRect.oncontextmenu=function() { return false; }; //屏蔽选中区域系统右键菜单
    uielement.parentNode.appendChild(this.SelectRect);
    
    //区间选择右键菜单
    this.SelectRectRightMenu;   

    //坐标轴风格方法 double-更加数值型分割  price-更加股票价格分割
    this.FrameSplitData=new Map();
    this.FrameSplitData.set("double",new SplitData());
    this.FrameSplitData.set("price",new PriceSplitData());

    //事件回调
    this.mapEvent=new Map();   //通知外部调用 key:JSCHART_EVENT_ID value:{Callback:回调,}

    this.IsOnTouch = false;     //是否再操作数据
    this.TouchDrawCount = 0;    //手势绘制次数
    this.DisableMouse=false;    //禁止鼠标事件
    this.LanguageID=JSCHART_LANGUAGE_ID.LANGUAGE_CHINESE_ID;
    this.PressTime=500;

    this.NetworkFilter;         //网络请求回调 function(data, callback);
    this.LastMouseStatus={ }
    this.ClickDownPoint;         //鼠标点击坐标 {X, Y}, 鼠标放开以后清空为null
    this.IsDestroy=false;        //是否已经销毁了

    this.EnableYDrag={ Left:false, Right:false };   //是否可以拖拽Y轴,放大缩小Y轴最大最小值

    this.ChartDestory=function()    //销毁
    {
        this.IsDestroy=true;
        this.StopAutoUpdate();
    }

    //设置事件回调
    //{event:事件id, callback:回调函数}
    this.AddEventCallback=function(object)
    {
        if (!object || !object.event || !object.callback) return;

        var data={Callback:object.callback, Source:object};
        this.mapEvent.set(object.event,data);
    }

    this.RemoveEventCallback=function(eventid)
    {
        if (!this.mapEvent.has(eventid)) return;

        this.mapEvent.delete(eventid);
    }

    this.GetEventCallback=function(id)  //获取事件回调
    {
        if (!this.mapEvent.has(id)) return null;
        var item=this.mapEvent.get(id);
        return item;
    }

    //接收指标数据
    this.GetIndexEvent=function()
    {
        return this.GetEventCallback(JSCHART_EVENT_ID.RECV_INDEX_DATA);
    }

    this.GetOverlayIndexEvent=function()
    {
        return this.GetEventCallback(JSCHART_EVENT_ID.RECV_OVERLAY_INDEX_DATA);
    }

    //鼠标事件绑定
    uielement.onmousemove=(e)=>{ this.UIOnMouseMove(e);}
    uielement.oncontextmenu=(e)=> { return this.UIOnContextMenu(e); }
    uielement.ondblclick=(e)=>{ this.UIOnDblClick(e); }
    uielement.onmousedown=(e)=> { this.UIOnMouseDown(e); }
    uielement.onmouseout=(e)=>{ this.UIOnMounseOut(e); }

    this.UIOnMouseMove=function(e)
    {
        //JSConsole.Chart.Log('[JSChartContainer.UIOnMouseMove] e.clientX, e.clientY, left, top ',e.clientX, e.clientY, this.getBoundingClientRect().left,this.getBoundingClientRect().top);
        var pixelTatio = GetDevicePixelRatio(); //鼠标移动坐标是原始坐标 需要乘以放大倍速
        var x = (e.clientX-this.UIElement.getBoundingClientRect().left)*pixelTatio;
        var y = (e.clientY-this.UIElement.getBoundingClientRect().top)*pixelTatio;

        //加载数据中,禁用鼠标事件
        if (this.ChartSplashPaint && this.ChartSplashPaint.IsEnableSplash == true) return;
        if (this.DisableMouse==true) return;
        if (this.BorderDrag) return;
        if (this.YDrag) return;

        //保存最后一次鼠标移动信息
        var MoveStatus={ X:x, Y:y, IsInClient: this.IsMouseOnClient(x,y) };
        this.LastMouseStatus.OnMouseMove=MoveStatus;
        //JSConsole.Chart.Log("[JSChartContainer::UIOnMouseMove] MoveStatus", MoveStatus);

        this.OnMouseMove(x,y,e);
    }

    this.IsMouseOnClient=function(x,y)
    {
        var isInClient=false;
        this.Canvas.beginPath();
        this.Canvas.rect(this.Frame.ChartBorder.GetLeft(),this.Frame.ChartBorder.GetTop(),this.Frame.ChartBorder.GetWidth(),this.Frame.ChartBorder.GetHeight());
        isInClient=this.Canvas.isPointInPath(x,y);
        return isInClient;
    }

    this.UIOnContextMenu=function(e)
    {
        if (this.ChartSplashPaint && this.ChartSplashPaint.IsEnableSplash == true) return;

        var x = e.clientX-this.UIElement.getBoundingClientRect().left;
        var y = e.clientY-this.UIElement.getBoundingClientRect().top;

        if(typeof(this.OnRightMenu)=='function') this.OnRightMenu(x,y,e);   //右键菜单事件

        return false;
    }

    this.UIOnDblClick=function(e)
    {
        var pixelTatio = GetDevicePixelRatio();
        var x = (e.clientX-this.UIElement.getBoundingClientRect().left)*pixelTatio;
        var y = (e.clientY-this.UIElement.getBoundingClientRect().top)*pixelTatio;
        this.OnDoubleClick(x,y,e);
    }

    //是否在拖拽Y轴上
    this.TryYDrag=function(x,y)
    {
        if (!this.EnableYDrag) return null;
        if (!this.EnableYDrag.Left && !this.EnableYDrag.Right) return null;
        if (!this.Frame || !this.Frame.PtInFrameY) return null;

        var dragY=this.Frame.PtInFrameY(x,y);
        if (!dragY || dragY.Index<0) return null;

        if (dragY.Left && this.EnableYDrag.Left && this.Frame.IsEnableDragY(dragY.Index))
        {
            return dragY;
        }

        if (dragY.Right && this.EnableYDrag.Right && this.Frame.IsEnableDragY(dragY.Index))
        {
            return dragY;
        }

        return null;
    }

    //是否可以上下拖拽
    this.TryUpDownDray=function(x,y)
    {
        var windowIndex=this.Frame.PtInFrame(x,y);
        if (windowIndex<0) return null;

        var item=this.Frame.SubFrame[windowIndex];
        if (!item || !item.Frame) return null;

        var frame=item.Frame;
        if (!frame.YSplitOperator || !frame.YSplitOperator.FixedYMaxMin) return null;

        return { Index:windowIndex, X:x, Y:y };
    }

    this.UIOnMouseDown=function(e)
    {
        if (this.ChartSplashPaint && this.ChartSplashPaint.IsEnableSplash == true) return;

        this.ClickDownPoint={ X:e.clientX, Y:e.clientY };
        this.IsOnTouch=true;
        this.BorderDrag=null;
        this.YDrag=null;
        this.UpDownDrag=null;

        var pixelTatio = GetDevicePixelRatio();
        var x = (e.clientX-this.UIElement.getBoundingClientRect().left)*pixelTatio;
        var y = (e.clientY-this.UIElement.getBoundingClientRect().top)*pixelTatio;

        var button=this.Frame.PtInButtons(x,y);
        if (button && this.ClickFrameButton)
        {
            this.ClickFrameButton(button);
            return;
        }

        if (this.TryClickLock)
        {
            //JSConsole.Chart.Log('[uielement.onmousedown] left, top ',e.clientX, e.clientY, this.getBoundingClientRect().left,this.getBoundingClientRect().top);
            if (this.TryClickLock(x,y)) return;
        }

        this.HideSelectRect();
        if (this.SelectRectRightMenu) this.SelectRectRightMenu.Hide();
        if (this.ChartPictureMenu) this.ChartPictureMenu.Hide();

        if (this.EnableBorderDrag && this.Frame)
        {
            var dragBorder=this.Frame.PtInFrameBorder(x,y);
            if (dragBorder && dragBorder.Index>=0)
            {
                this.UIElement.style.cursor="n-resize";
                this.BorderDrag={ Index:dragBorder.Index };
                JSConsole.Chart.Log("[JSChartContainer::UIOnMouseDown] DragBorder ",dragBorder);
            }
        }

        //拖拽Y轴缩放
        var dragY=this.TryYDrag(x,y);
        if (dragY)
        {
            this.UIElement.style.cursor=dragY.Position==0 ? "n-resize":"row-resize";
            this.YDrag=dragY;
            JSConsole.Chart.Log("[JSChartContainer::UIOnMouseDown] dragY ",dragY);
        }
        else
        {
            var dragUpDown=this.TryUpDownDray(x,y);
            if (dragUpDown)
            {
                this.UIElement.style.cursor="pointer";
                this.UpDownDrag=dragUpDown;
                JSConsole.Chart.Log("[JSChartContainer::UIOnMouseDown] dragUpDown ",dragUpDown);
            }
        }

        if(this.DragMode==0) return;

        var drag=
        {
            "Click":{},
            "LastMove":{}  //最后移动的位置
        };

        drag.Click.X=e.clientX;
        drag.Click.Y=e.clientY;
        drag.LastMove.X=e.clientX;
        drag.LastMove.Y=e.clientY;

        this.MouseDrag=drag;
        this.SelectChartDrawPicture=null;

        if (this.BorderDrag)
        {

        }
        else if (this.YDrag || this.UpDownDrag)
        {

        }
        else if (this.CurrentChartDrawPicture)  //画图工具模式
        {
            var drawPicture=this.CurrentChartDrawPicture;
            if (drawPicture.Status==2)
                this.SetChartDrawPictureThirdPoint(drag.Click.X,drag.Click.Y);
            else
            {
                this.SetChartDrawPictureFirstPoint(drag.Click.X,drag.Click.Y);
                //只有1个点 直接完成
                if (this.FinishChartDrawPicturePoint()) this.DrawDynamicInfo();
            }
        }
        else    //是否在画图工具上
        {
            var drawPictrueData={};
            drawPictrueData.X=(e.clientX-this.UIElement.getBoundingClientRect().left)*pixelTatio;
            drawPictrueData.Y=(e.clientY-this.UIElement.getBoundingClientRect().top)*pixelTatio;
            if (this.GetChartDrawPictureByPoint(drawPictrueData))
            {
                if (drawPictrueData.ChartDrawPicture.EnableMove==true)
                {
                    drawPictrueData.ChartDrawPicture.Status=20;
                    drawPictrueData.ChartDrawPicture.ValueToPoint();
                    drawPictrueData.ChartDrawPicture.MovePointIndex=drawPictrueData.PointIndex;
                    this.CurrentChartDrawPicture=drawPictrueData.ChartDrawPicture;
                    this.SelectChartDrawPicture=drawPictrueData.ChartDrawPicture;
                }
                else
                {
                    this.CurrentChartDrawPicture=null;
                    this.SelectChartDrawPicture=null;
                }
               
                var event=this.GetEventCallback(JSCHART_EVENT_ID.ON_CLICK_DRAWPICTURE); //选中画图工具事件
                if (event && event.Callback)
                {
                    var sendData={ DrawPicture: drawPictrueData.ChartDrawPicture };
                    event.Callback(event,sendData,this);
                }
                else
                {
                    this.OnSelectChartPicture(drawPictrueData.ChartDrawPicture);    //选中画图工具事件
                }
            }
            else
            {
                if (this.ClickChartTimer!=null)
                {
                    clearTimeout(this.ClickChartTimer);
                    this.ClickChartTimer=null;
                }
                
                var self=this;
                var ptClick={ X:this.ClickDownPoint.X, Y:this.ClickDownPoint.Y };
                this.ClickChartTimer = setTimeout(function() 
                {
                    self.TryClickPaintEvent(JSCHART_EVENT_ID.ON_CLICK_CHART_PAINT,ptClick,e);
                }, 250);
                
            }
        }

        document.onmousemove=(e)=>{ this.DocOnMouseMove(e); }
        document.onmouseup=(e)=> { this.DocOnMouseUp(e); }
    }

    this.DocOnMouseMove=function(e)
    {
        //加载数据中,禁用鼠标事件
        if (this.ChartSplashPaint && this.IsEnableSplash == true) return;
        
        var drag=this.MouseDrag;
        if (!drag) return;

        var moveSetp=Math.abs(drag.LastMove.X-e.clientX);
        var moveSetpY=Math.abs(drag.LastMove.Y-e.clientY);

        if (this.BorderDrag && this.BorderDrag.Index>=0)
        {
            if(Math.abs(drag.LastMove.Y-e.clientY)<5) return;

            var yMove=e.clientY-drag.LastMove.Y;

            this.OnMoveFromeBorder(this.BorderDrag.Index, yMove);

            drag.LastMove.X=e.clientX;
            drag.LastMove.Y=e.clientY;
        }
        else if (this.YDrag && this.YDrag.Index>=0)
        {
            if(moveSetpY<5) return;

            var yMove=e.clientY-drag.LastMove.Y;

            //this.UIElement.style.cursor="n-resize";

            JSConsole.Chart.Log("[JSChartContainer::DocOnMouseMove] YDrag ",this.YDrag,yMove);
            this.OnZoomUpDownFrameY(this.YDrag, yMove);

            drag.LastMove.X=e.clientX;
            drag.LastMove.Y=e.clientY;
        }
        else if (this.CurrentChartDrawPicture)
        {
            var drawPicture=this.CurrentChartDrawPicture;
            if (drawPicture.Status==1 || drawPicture.Status==2)
            {
                if(Math.abs(drag.LastMove.X-e.clientX)<5 && Math.abs(drag.LastMove.Y-e.clientY)<5) return;
                if(this.SetChartDrawPictureSecondPoint(e.clientX,e.clientY))
                {
                    this.DrawDynamicInfo();
                }
            }
            else if (drawPicture.Status==3)
            {
                if(this.SetChartDrawPictureThirdPoint(e.clientX,e.clientY))
                {
                    this.DrawDynamicInfo();
                }
            }
            else if (drawPicture.Status==20)    //画图工具移动
            {
                if(Math.abs(drag.LastMove.X-e.clientX)<5 && Math.abs(drag.LastMove.Y-e.clientY)<5) return;

                if(this.MoveChartDrawPicture(e.clientX-drag.LastMove.X,e.clientY-drag.LastMove.Y))
                {
                    this.DrawDynamicInfo();
                }
            }

            drag.LastMove.X=e.clientX;
            drag.LastMove.Y=e.clientY;
        }
        else if (this.DragMode==1)  //数据左右拖拽
        {
            if (moveSetp<5 && moveSetpY<5) return;

            var bNeedDraw=false;
            var bUpDownY=false;
            if (moveSetpY>=5)
            {
                if (this.UpDownDrag && this.UpDownDrag.Index>=0)
                {
                    var yMove=e.clientY-drag.LastMove.Y;
                    JSConsole.Chart.Log("[JSChartContainer::DocOnMouseMove] UpDownDrag ",this.UpDownDrag,yMove);
                    this.UIElement.style.cursor="pointer";
                    if (this.OnUpDonwFrameY(this.UpDownDrag, yMove)) 
                    {
                        bNeedDraw=true;
                        bUpDownY=true;
                    }
                    drag.LastMove.Y=e.clientY;
                }
            }

            if (moveSetp>=5)
            {
                var isLeft=true;
                if (drag.LastMove.X<e.clientX) isLeft=false;//右移数据
    
                this.UIElement.style.cursor="pointer";
    
                if(this.DataMove(moveSetp,isLeft))
                {
                    this.UpdataDataoffset();
                    this.UpdatePointByCursorIndex();
                    this.UpdateFrameMaxMin();
                    this.ResetFrameXYSplit();
                    bNeedDraw=true;
                }
                else if (!bUpDownY)
                {
                    if (this.DragDownloadData) this.DragDownloadData();
                }
    
                drag.LastMove.X=e.clientX;
            }

            if (bNeedDraw) this.Draw();
        }
        else if (this.DragMode==2) //区间选择
        {
            var yMoveSetp=Math.abs(drag.LastMove.Y-e.clientY);

            if (moveSetp<5 && yMoveSetp<5) return;

            this.UIElement.style.cursor="default";

            var x=drag.Click.X-uielement.getBoundingClientRect().left;
            var y=drag.Click.Y-uielement.getBoundingClientRect().top;
            var x2=e.clientX-uielement.getBoundingClientRect().left;
            var y2=e.clientY-uielement.getBoundingClientRect().top;
            this.ShowSelectRect(x,y,x2,y2);

            drag.LastMove.X=e.clientX;
            drag.LastMove.Y=e.clientY;

        }
    }

    this.DocOnMouseUp=function(e)
    {
        //清空事件
        document.onmousemove=null;
        document.onmouseup=null;

        var bClearDrawPicture=true;
        if (this.CurrentChartDrawPicture)
        {
            var drawPicture=this.CurrentChartDrawPicture;
            if (drawPicture.Status==2 || drawPicture.Status==1 || drawPicture.Status==3)
            {
                drawPicture.PointStatus=drawPicture.Status;
                if (this.FinishChartDrawPicturePoint())
                    this.DrawDynamicInfo();
                else
                    bClearDrawPicture=false;
            }
            else if (drawPicture.Status==20)
            {
                if (this.FinishMoveChartDrawPicture())
                    this.DrawDynamicInfo();
            }
        }
        else if (this.DragMode==2)  //区间选择
        {
            var drag=this.MouseDrag;
            drag.LastMove.X=e.clientX;
            drag.LastMove.Y=e.clientY;

            var selectData=new SelectRectData();
            var pixelTatio = GetDevicePixelRatio();
            //区间起始位置 结束位子
            selectData.XStart=(drag.Click.X-uielement.getBoundingClientRect().left)*pixelTatio;
            selectData.YStart=(drag.Click.Y-uielement.getBoundingClientRect().top)*pixelTatio;
            selectData.XEnd=(drag.LastMove.X-uielement.getBoundingClientRect().left)*pixelTatio;
            selectData.YEnd=(drag.LastMove.Y-uielement.getBoundingClientRect().top)*pixelTatio;
            selectData.JSChartContainer=this;
            selectData.Stock={Symbol:this.Symbol, Name:this.Name};

            if (this.GetSelectRectData(selectData))
            {
                var event=this.GetEventCallback(JSCHART_EVENT_ID.ON_SELECT_RECT);
                if (event && event.Callback)
                {
                    var data=
                    { 
                        X:drag.LastMove.X-uielement.getBoundingClientRect().left,
                        Y:drag.LastMove.Y-uielement.getBoundingClientRect().top,
                        SelectData:selectData,                      //区间选择的数据 
                    };
                    event.Callback(event,data,this);
                }

                if (this.SelectRectRightMenu)
                {
                    e.data=
                    {
                        Chart:this,
                        X:drag.LastMove.X-uielement.getBoundingClientRect().left,
                        Y:drag.LastMove.Y-uielement.getBoundingClientRect().top,
                        SelectData:selectData,          //区间选择的数据
                    };
                    this.SelectRectRightMenu.DoModal(e);
                }
            }
            else
            {
                this.TryClickPaintEvent(JSCHART_EVENT_ID.ON_CLICKUP_CHART_PAINT,this.ClickDownPoint,e);
            }
        }
        else
        {
            this.TryClickPaintEvent(JSCHART_EVENT_ID.ON_CLICKUP_CHART_PAINT,this.ClickDownPoint,e);
            this.ClickEvent(e);
        }

        //清空数据
        JSConsole.Chart.Log('[KLineChartContainer::document.onmouseup]',e);
        this.UIElement.style.cursor="default";
        this.MouseDrag=null;
        this.ClickDownPoint=null;
        this.IsOnTouch=false;
        if (this.BorderDrag && this.BorderDrag.Index>=0) this.Frame.SaveSubFrameHeightRate();   //拖拽指标窗口高度以后保存
        this.BorderDrag=null;
        this.YDrag=null;
        this.UpDownDrag=null;
        if (bClearDrawPicture===true) this.CurrentChartDrawPicture=null;
    }

    this.UIOnMounseOut=function(e)
    {
        JSConsole.Chart.Log('[KLineChartContainer::UIOnMounseOut]',e);
        this.UIOnMouseMove(e);
    }

    //点击事件
    this.ClickEvent=function(e) 
    {
        var event=this.GetEventCallback(JSCHART_EVENT_ID.ON_CLICK);
        if (!event || !event.Callback) return false;
        if (this.ClickDownPoint.X!=e.clientX || this.ClickDownPoint.Y!=e.clientY) return false;
        var pixelTatio = GetDevicePixelRatio();
        var x=(e.clientX-uielement.getBoundingClientRect().left)*pixelTatio;
        var y=(e.clientY-uielement.getBoundingClientRect().top)*pixelTatio;
        var data= { X:e.clientX, Y:e.clientY, FrameID:-1 };
    
        var isInClient=false;
        this.Canvas.beginPath();
        this.Canvas.rect(this.Frame.ChartBorder.GetLeft(),this.Frame.ChartBorder.GetTop(),this.Frame.ChartBorder.GetWidth(),this.Frame.ChartBorder.GetHeight());
        isInClient=this.Canvas.isPointInPath(x,y);
        if (isInClient)
        {
            var yValueExtend={};
            var yValue=this.Frame.GetYData(y,yValueExtend);

            if (IFrameSplitOperator.IsNumber(yValueExtend.FrameID) && yValueExtend.FrameID>=0)
            {
                var xValue=this.Frame.GetXData(x);
                data.FrameID=yValueExtend.FrameID;
                data.Data={ X:xValue, Y:yValue } ;
            }
        }
        
        event.Callback(event, data, this);
        return true;
    }

    this.TryClickPaintEvent=function(eventID, ptClick, e)
    {
        var event=this.GetEventCallback(eventID);
        if (event && event.Callback)
        {
            if (ptClick.X==e.clientX && ptClick.Y==e.clientY)
            {
                var pixelTatio = GetDevicePixelRatio();
                var x = (e.clientX-uielement.getBoundingClientRect().left)*pixelTatio;
                var y = (e.clientY-uielement.getBoundingClientRect().top)*pixelTatio;

                var toolTip=new TooltipData();
                var stock=null;
                for(var i=0;i<this.ChartPaint.length;++i)
                {
                    var item=this.ChartPaint[i];
                    if (item.GetTooltipData(x,y,toolTip))
                    {
                        stock={ Symbol:this.Symbol, Name:this.Name };
                        break;
                    }
                }

                if (!toolTip.Data)
                {
                    for(var i=0;i<this.OverlayChartPaint.length;++i)
                    {
                        var item=this.OverlayChartPaint[i];
                        if (item.GetTooltipData(x,y,toolTip))
                        {
                            stock={ Symbol:toolTip.ChartPaint.Symbol, Name:toolTip.ChartPaint.Title };
                            break;
                        }
                    }
                }

                if (toolTip.Data)
                {
                    var data= { X:e.clientX, Y:e.clientY, Stock: stock, Tooltip:toolTip };
                    event.Callback(event, data, this);
                    return true;
                }
            }
        }

        return false;
    }


    //判断是单个手指
    this.IsPhoneDragging=function(e)
    {
        // JSConsole.Chart.Log(e);
        var changed=e.changedTouches.length;
        var touching=e.touches.length;

        return changed==1 && touching==1;
    }

    //是否是2个手指操所
    this.IsPhonePinching=function(e)
    {
        var changed=e.changedTouches.length;
        var touching=e.touches.length;

        return (changed==1 || changed==2) && touching==2;
    }

    this.PreventTouchEvent=function(e)
    {
        if (e.cancelable) e.preventDefault();
        e.stopPropagation();
    }

    this.GetToucheData=function(e, isForceLandscape)
    {
        var touches=new Array();
        var pixelTatio = GetDevicePixelRatio(); //获取设备的分辨率
        for(var i=0; i<e.touches.length; ++i)
        {
            var item=e.touches[i];
            if (isForceLandscape)
            {
                touches.push(
                    {
                        clientX:item.clientY*pixelTatio, clientY:item.clientX*pixelTatio, 
                        pageX:item.pageY*pixelTatio, pageY:item.pageX*pixelTatio
                    });
            }
            else
            {
                touches.push(
                    {
                        clientX:item.clientX*pixelTatio, clientY:item.clientY*pixelTatio, 
                        pageX:item.pageX*pixelTatio, pageY:item.pageY*pixelTatio
                    });
            }
        }

        return touches;
    }

    this.IsSingleTouch=function(e)  //是否是单点触屏
    {
        var touchCount=e.touches.length;

        return touchCount==1;
    }

    this.StopDragTimer=function()
    {
        if (IFrameSplitOperator.IsNumber(this.DragTimer))
        {
            clearTimeout(this.DragTimer);
            this.DragTimer=null;
        }
    }


    this.GetMoveAngle=function(pt,pt2)  //计算角度
    {
        var xMove=Math.abs(pt.X-pt2.X);
        var yMove=Math.abs(pt.Y-pt2.Y);
        var angle=Math.atan(xMove/yMove)*180/Math.PI;
        return angle;
    }

    //手机拖拽
    uielement.ontouchstart=(e)=> { this.OnTouchStart(e); } 
    uielement.ontouchmove=(e)=> {this.OnTouchMove(e); }
    uielement.ontouchend=(e)=> {this.OnTouchEnd(e); }    

    this.OnTouchStart=function(e)
    {
        if (this.ChartSplashPaint && this.ChartSplashPaint.IsEnableSplash == true) return;

        this.IsOnTouch=true;
        this.TouchDrawCount=0;
        this.PhonePinch=null;
        this.StopDragTimer();

        var isSingleTouch=this.IsSingleTouch(e);
        if (this.EnableScrollUpDown==false ||  !isSingleTouch || //多点触屏
            (this.DragMode==JSCHART_DRAG_ID.CLICK_TOUCH_MODE_ID && this.TouchStatus.CorssCursorShow==true)) //十字光标显示,不能滚动页面   
        {
            if (e.cancelable) e.preventDefault();
        }

        if (this.IsPhoneDragging(e))
        {
            if (this.TryClickLock || this.TryClickIndexTitle) //指标枷锁区域 , 指标标题点击
            {
                var touches = this.GetToucheData(e, this.IsForceLandscape);
                var pt=this.PointAbsoluteToRelative(touches[0].clientX, touches[0].clientY, true);
                var x = pt.X;
                var y = pt.Y;
                if (this.TryClickLock && this.TryClickLock(x, y)) return;
                if (this.TryClickIndexTitle && this.TryClickIndexTitle(x,y)) return;
            }

            var bStartTimer=true;
            if (this.ChartDrawOption.IsLockScreen)
            {
                bStartTimer=false;
            }
            else if (this.DragMode==JSCHART_DRAG_ID.CLICK_TOUCH_MODE_ID)
            {
                if (this.TouchStatus.CorssCursorShow==true) bStartTimer=false;
            }
            else if (this.DragMode==JSCHART_DRAG_ID.DISABLE_DRAG_ID)
            {
                bStartTimer=false;
            }
            else
            {
                if (!isSingleTouch) bStartTimer=false;
            }

            var drag=
            {
                "Click":{},
                "LastMove":{}  //最后移动的位置
            };

            var touches=this.GetToucheData(e,this.IsForceLandscape);

            drag.Click.X=touches[0].clientX;
            drag.Click.Y=touches[0].clientY;
            drag.LastMove.X=touches[0].clientX;
            drag.LastMove.Y=touches[0].clientY;

            this.MouseDrag=drag;
            this.PhoneTouchInfo={ Start:{X:touches[0].clientX, Y:touches[0].clientY }, End:{ X:touches[0].clientX, Y:touches[0].clientY } };
            if (this.SelectChartDrawPicture) this.SelectChartDrawPicture.IsSelected=false;
            this.SelectChartDrawPicture=null;
            var isDrawPictrue=false;
            if (this.CurrentChartDrawPicture)  //画图工具模式
            {
                var drawPicture=this.CurrentChartDrawPicture;
                if (drawPicture.Status==2)
                    this.SetChartDrawPictureThirdPoint(drag.Click.X,drag.Click.Y,true);
                else
                {
                    this.SetChartDrawPictureFirstPoint(drag.Click.X,drag.Click.Y,true);
                    //只有1个点 直接完成
                    if (this.FinishChartDrawPicturePoint()) this.DrawDynamicInfo({Corss:false, Tooltip:false});
                }

                if (e.cancelable) e.preventDefault();
                return;
            }
            else
            {
                var pt=this.PointAbsoluteToRelative(touches[0].clientX,touches[0].clientY, true);
                var drawPictrueData={ X:pt.X, Y:pt.Y };
                var pixelTatio = GetDevicePixelRatio(); //鼠标移动坐标是原始坐标 需要乘以放大倍速
                if (this.GetChartDrawPictureByPoint(drawPictrueData))
                {
                    drawPictrueData.ChartDrawPicture.Status=20;
                    drawPictrueData.ChartDrawPicture.ValueToPoint();
                    drawPictrueData.ChartDrawPicture.MovePointIndex=drawPictrueData.PointIndex;
                    drawPictrueData.ChartDrawPicture.IsSelected=true;
                    this.CurrentChartDrawPicture=drawPictrueData.ChartDrawPicture;
                    this.SelectChartDrawPicture=drawPictrueData.ChartDrawPicture;
                    let event=this.GetEventCallback(JSCHART_EVENT_ID.ON_CLICK_DRAWPICTURE); //选中画图工具事件
                    if (event && event.Callback)
                    {
                        let sendData={ DrawPicture: drawPictrueData.ChartDrawPicture };
                        event.Callback(event,sendData,this);
                    }

                    if (e.cancelable) e.preventDefault();
                    return;
                }
            }

            if (bStartTimer)
            {
                //长按2秒,十字光标
                var self=this;
                this.DragTimer=setTimeout(function()
                {
                    if (drag.Click.X==drag.LastMove.X && drag.Click.Y==drag.LastMove.Y) //手指没有移动，出现十字光标
                    {
                        var mouseDrag=self.MouseDrag;
                        self.MouseDrag=null;
                        if (self.DragMode==JSCHART_DRAG_ID.CLICK_TOUCH_MODE_ID) self.TouchStatus.CorssCursorShow=true;    //十字显示
                        self.MoveCorssCursor(drag.Click,e);//移动十字光标
                    }

                }, self.PressTime);
            }

            if (this.ChartDrawOption.IsLockScreen)
            {
                this.MouseDrag=null;
            }
            else if (this.DragMode==JSCHART_DRAG_ID.CLICK_TOUCH_MODE_ID)
            {

            }
            else if (this.DragMode==JSCHART_DRAG_ID.DISABLE_DRAG_ID)
            {
                this.MouseDrag=null;
                this.MoveCorssCursor(drag.Click,e);
            }
            else if (this.IsClickShowCorssCursor)
            {
                this.MoveCorssCursor(drag.Click,e);
            }
            
            this.TouchEvent({ EventID:JSCHART_EVENT_ID.ON_PHONE_TOUCH, FunctionName:"OnTouchStart"}, e);
        }
        else if (this.IsPhonePinching(e))
        {
            var phonePinch=
            {
                "Start":{},
                "Last":{}
            };

            var touches=this.GetToucheData(e,this.IsForceLandscape);

            phonePinch.Start={"X":touches[0].pageX,"Y":touches[0].pageY,"X2":touches[1].pageX,"Y2":touches[1].pageY};
            phonePinch.Last={"X":touches[0].pageX,"Y":touches[0].pageY,"X2":touches[1].pageX,"Y2":touches[1].pageY};

            this.PhonePinch=phonePinch;
            this.SelectChartDrawPicture=null;
        }
    }

    this.OnTouchMove=function(e)
    {
        if (this.ChartSplashPaint && this.ChartSplashPaint.IsEnableSplash == true) return;

        var touches=this.GetToucheData(e,this.IsForceLandscape);

        if (this.IsPhoneDragging(e))
        {
            var drag=this.MouseDrag;
            if (drag==null)
            {
                if (this.IsForceLandscape) y=uielement.getBoundingClientRect().width-touches[0].clientY;    //强制横屏Y计算
                if (!this.ChartDrawOption.IsLockScreen) this.MoveCorssCursor({X:touches[0].clientX, Y:touches[0].clientY},e);
            }
            else
            {
                var moveAngle=this.GetMoveAngle(drag.LastMove,{X:touches[0].clientX, Y:touches[0].clientY});
                var moveSetp=Math.abs(drag.LastMove.X-touches[0].clientX);
                var moveUpDown=Math.abs(drag.LastMove.Y-touches[0].clientY);
                moveSetp=parseInt(moveSetp);
                var isMoveCorssCursor=(this.DragMode==JSCHART_DRAG_ID.CLICK_TOUCH_MODE_ID && this.TouchStatus.CorssCursorShow==true); //是否移动十字光标

                //JSConsole.Chart.Log("[JSChartContainer::uielement.ontouchmove]  moveAngle , moveUpDown", moveAngle,moveUpDown);

                if (this.CurrentChartDrawPicture)
                {
                    var drawPicture=this.CurrentChartDrawPicture;
                    if (drawPicture.Status==1 || drawPicture.Status==2)
                    {
                        if(moveSetp<5 && moveUpDown<5) return;
                        if(this.SetChartDrawPictureSecondPoint(touches[0].clientX,touches[0].clientY,true))
                        {
                            this.DrawDynamicInfo();
                        }
                    }
                    else if (drawPicture.Status==3)
                    {
                        if(this.SetChartDrawPictureThirdPoint(touches[0].clientX,touches[0].clientY,true))
                        {
                            this.DrawDynamicInfo();
                        }
                    }
                    else if (drawPicture.Status==20)    //画图工具移动
                    {
                        if(moveSetp<5 && moveUpDown<5) return;

                        if(this.MoveChartDrawPicture(touches[0].clientX-drag.LastMove.X,touches[0].clientY-drag.LastMove.Y,true))
                        {
                            this.DrawDynamicInfo();
                        }
                    }

                    drag.LastMove.X=touches[0].clientX;
                    drag.LastMove.Y=touches[0].clientY;
                }
                else if (isMoveCorssCursor)  //点击模式下 十字光标显示 左右移动十字光标
                {
                    var mouseDrag=this.MouseDrag;
                    this.MouseDrag=null;
                    this.MoveCorssCursor(drag.Click,e); //移动十字光标
                }
                else if (this.DragMode==1 || isMoveCorssCursor==false)  //数据左右拖拽
                {
                    if ( ((moveUpDown>0 && moveSetp<=3) || moveAngle<=this.TouchMoveMinAngle) && this.EnableScrollUpDown==true ) 
                    {
                        this.StopDragTimer();
                        return;
                    }

                    if (moveSetp<5 || moveAngle<=this.TouchMoveMinAngle) 
                    {
                        this.PreventTouchEvent(e);
                        return;
                    }

                    var isLeft=true;
                    if (drag.LastMove.X<touches[0].clientX) isLeft=false;//右移数据

                    if(this.DataMove(moveSetp,isLeft))
                    {
                        this.UpdataDataoffset();
                        this.UpdatePointByCursorIndex();
                        this.UpdateFrameMaxMin();
                        this.ResetFrameXYSplit();
                        this.Draw();
                    }
                    else
                    {
                        if (this.DragDownloadData) this.DragDownloadData();
                    }

                    drag.LastMove.X=touches[0].clientX;
                    drag.LastMove.Y=touches[0].clientY;
                }
            }

            if (this.PhoneTouchInfo)
            {
                this.PhoneTouchInfo.End.X=touches[0].clientX;
                this.PhoneTouchInfo.End.Y=touches[0].clientY;
            }
        }
        else if (this.IsPhonePinching(e))
        {
            if (this.DragMode==JSCHART_DRAG_ID.DISABLE_DRAG_ID) return;

            this.PreventTouchEvent(e);
            var phonePinch=this.PhonePinch;
            if (!phonePinch) return;

            if (this.EnableZoomUpDown && this.EnableZoomUpDown.Touch===false) return;

            var yHeight=Math.abs(touches[0].pageY-touches[1].pageY);
            var yLastHeight=Math.abs(phonePinch.Last.Y-phonePinch.Last.Y2);
            var yStep=yHeight-yLastHeight;

            var xHeight=Math.abs(touches[0].pageX-touches[1].pageX);
            var xLastHeight=Math.abs(phonePinch.Last.X-phonePinch.Last.X2);
            var xStep=xHeight-xLastHeight;
            var minStep=this.ZoomStepPixel;
            if (Math.abs(yStep)<minStep && Math.abs(xStep)<minStep) return;
            var step=yStep;
            if (Math.abs(yStep)<minStep) step=xStep;

            if (step>0)    //放大
            {
                var cursorIndex={};
                cursorIndex.Index=parseInt(Math.abs(this.CursorIndex-0.5).toFixed(0));
                if (!this.Frame.ZoomUp(cursorIndex)) return;
                this.CursorIndex=cursorIndex.Index;
                this.UpdatePointByCursorIndex();
                this.UpdataDataoffset();
                this.UpdateFrameMaxMin();
                this.Draw();
                this.ShowTooltipByKeyDown();
                this.StopDragTimer();
            }
            else        //缩小
            {
                var cursorIndex={};
                cursorIndex.Index=parseInt(Math.abs(this.CursorIndex-0.5).toFixed(0));
                if (!this.Frame.ZoomDown(cursorIndex)) return;
                this.CursorIndex=cursorIndex.Index;
                this.UpdataDataoffset();
                this.UpdatePointByCursorIndex();
                this.UpdateFrameMaxMin();
                this.Draw();
                this.ShowTooltipByKeyDown();
                this.StopDragTimer();
            }

            phonePinch.Last={"X":touches[0].pageX,"Y":touches[0].pageY,"X2":touches[1].pageX,"Y2":touches[1].pageY};
        }

        this.PreventTouchEvent(e);
    }

    this.OnTouchEnd=function(e)
    {
        JSConsole.Chart.Log('[KLineChartContainer:OnTouchEnd]',e);
        if (this.ChartSplashPaint && this.ChartSplashPaint.IsEnableSplash == true) return;

        var bClearDrawPicture=true;
        if (this.CurrentChartDrawPicture)
        {
            var drawPicture=this.CurrentChartDrawPicture;
            if (drawPicture.Status==2 || drawPicture.Status==1 || drawPicture.Status==3)
            {
                drawPicture.PointStatus=drawPicture.Status;
                if (this.FinishChartDrawPicturePoint())
                    this.DrawDynamicInfo();
                else
                    bClearDrawPicture=false;
            }
            else if (drawPicture.Status==20)
            {
                if (this.FinishMoveChartDrawPicture())
                    this.DrawDynamicInfo();
            }
        }

        this.IsOnTouch = false;
        if (bClearDrawPicture===true) this.CurrentChartDrawPicture=null;
        this.StopDragTimer();
        this.TouchEvent({ EventID:JSCHART_EVENT_ID.ON_PHONE_TOUCH, FunctionName:"OnTouchEnd"}, e);
        this.OnTouchFinished();
        this.TouchDrawCount=0;
    }

    //手势事件
    this.TouchEvent=function(obj,e)
    {
        var eventID=obj.EventID;
        var event=this.GetEventCallback(eventID);
        if (!event || !event.Callback) return false;
        var drag=this.PhoneTouchInfo
        if (!drag || !drag.Start || !drag.End ) return false;
        var pixelTatio = GetDevicePixelRatio();
        var clientX=drag.End.X/pixelTatio;
        var clientY=drag.End.Y/pixelTatio;
        var x=drag.End.X-this.UIElement.getBoundingClientRect().left*pixelTatio;
        var y=drag.End.Y-this.UIElement.getBoundingClientRect().top*pixelTatio;
        var data= 
        { 
            X:clientX, Y:clientY, FrameID:-1, FunctionName:obj.FunctionName,
            Drag:
            { 
                Start:{ X:drag.Start.X/pixelTatio, Y:drag.Start.Y/pixelTatio }, 
                End:{ X:drag.End.X/pixelTatio, Y:drag.End.Y/pixelTatio } 
            } 
        };

        var isInClient=false;
        this.Canvas.beginPath();
        this.Canvas.rect(this.Frame.ChartBorder.GetLeft(),this.Frame.ChartBorder.GetTop(),this.Frame.ChartBorder.GetWidth(),this.Frame.ChartBorder.GetHeight());
        isInClient=this.Canvas.isPointInPath(x,y);

        if (isInClient)
        {
            var yValueExtend={};
            var yValue=this.Frame.GetYData(y,yValueExtend);

            if (IFrameSplitOperator.IsNumber(yValueExtend.FrameID) && yValueExtend.FrameID>=0)
            {
                var xValue=this.Frame.GetXData(x);
                data.FrameID=yValueExtend.FrameID;
                data.Data={ X:xValue, Y:yValue } ;
            }
        }

        event.Callback(event, data, this);
        return true;
    }

    this.MoveCorssCursor=function(point,e)
    {
        var pixelTatio = GetDevicePixelRatio();
        var x = point.X-this.UIElement.getBoundingClientRect().left*pixelTatio;
        var y = point.Y-this.UIElement.getBoundingClientRect().top*pixelTatio;
        if (this.DragMode==JSCHART_DRAG_ID.CLICK_TOUCH_MODE_ID) this.TouchStatus.CorssCursorShow=true;    //十字显示
        this.OnMouseMove(x,y,e,true);
    }

    this.DrawEmpty=function()
    {
        if (this.UIElement.width<=0 || this.UIElement.height<=0) return; 
        this.Canvas.clearRect(0,0,this.UIElement.width,this.UIElement.height);
        if (this.Frame)
        {
            this.Frame.ScreenImageData=null;
            this.Frame.Draw();
        }
    }

    this.Draw=function()
    {
        if (this.ChartCorssCursor) this.ChartCorssCursor.Status=0;
        if (this.UIElement.width<=0 || this.UIElement.height<=0) return; 

        this.Canvas.clearRect(0,0,this.UIElement.width,this.UIElement.height);
        var pixelTatio = GetDevicePixelRatio(); //获取设备的分辨率
        this.Canvas.lineWidth=pixelTatio;       //手机端需要根据分辨率比调整线段宽度

        if (this.ChartSplashPaint && this.ChartSplashPaint.IsEnableSplash)
        {
            this.Frame.Draw();
            this.ChartSplashPaint.Draw();
            return;
        }

        //框架
        this.Frame.SetDrawDepthMap(()=>
        {
            for(var i=0;i<this.ExtendChartPaint.length;++i)
            {
                var item=this.ExtendChartPaint[i];
                if (item.IsCallbackDraw) item.Draw();
            }
        });

        this.Frame.Draw();
        if (this.Frame.DrawCustomVertical) 
        {
            var eventCVericalDraw=this.GetEventCallback(JSCHART_EVENT_ID.ON_CUSTOM_VERTICAL_DRAW);
            this.Frame.DrawCustomVertical(eventCVericalDraw);
        }
        this.Frame.CalculateLock();

        //框架内图形
        for(var i=0;i<this.ChartPaint.length;++i)
        {
            var item=this.ChartPaint[i];
            if (item.IsDrawFirst)
                item.Draw();
        }

        for(var i=0; i<this.ChartPaint.length; ++i)
        {
            var item=this.ChartPaint[i];
            if (!item.IsDrawFirst)
                item.Draw();
        }

        for(var i=0;i<this.ChartPaintEx.length;++i)
        {
            var item=this.ChartPaintEx[i];
            item.Draw();
        }

        //叠加股票
        for(var i=0;i<this.OverlayChartPaint.length;++i)
        {
            var item=this.OverlayChartPaint[i];
            item.Draw();
        }

        if (this.Frame.DrawOveraly)
            this.Frame.DrawOveraly();   //画叠加指标

        //固定扩展图形
        for(var i=0;i<this.ExtendChartPaint.length;++i)
        {
            var item=this.ExtendChartPaint[i];
            if (item.IsCallbackDraw) continue;
            if (!item.IsDynamic && item.IsAnimation==false) item.Draw();
        }

        if (this.Frame.DrawInsideHorizontal) this.Frame.DrawInsideHorizontal();
        if (this.Frame.DrawCustomHorizontal) this.Frame.DrawCustomHorizontal();
        if (this.Frame.DrawEx) this.Frame.DrawEx( {Symbol:this.Symbol} );
        if (this.ChartInfoPaint) this.ChartInfoPaint.Draw();
        this.Frame.DrawLock();
        this.Frame.Snapshot();

        for(var i=0;i<this.ExtendChartPaint.length;++i) //动态扩展图形
        {
            var item=this.ExtendChartPaint[i];
            if (item.IsCallbackDraw) continue;
            if (item.IsDynamic && item.DrawAfterTitle===false) item.Draw();
        }

        if (this.LastPoint.X!=null || this.LastPoint.Y!=null)
        {
            if (this.ChartCorssCursor)
            {
                this.ChartCorssCursor.LastPoint=this.LastPoint;
                this.ChartCorssCursor.CursorIndex=this.CursorIndex;
                
                if (this.DragMode==JSCHART_DRAG_ID.CLICK_TOUCH_MODE_ID)
                {   //点击手势模式下
                    if (this.TouchStatus.CorssCursorShow==true) this.ChartCorssCursor.Draw();
                }
                else if (!(this.CorssCursorTouchEnd===true && this.MouseDrag) && !(this.CorssCursorTouchEnd==true && this.IsOnTouch==false)) 
                {   //移动端 拖拽数据的时候 不显示十字光标, 没有按屏的时候也不显示十字光标
                    this.ChartCorssCursor.Draw();
                }
            }
        }

        var drawStatus=this.GetDrawStatus();
        drawStatus.DrawName="Draw";
        var eventTitleDraw=this.GetEventCallback(JSCHART_EVENT_ID.ON_TITLE_DRAW);
        var eventIndexTitleDraw=this.GetEventCallback(JSCHART_EVENT_ID.ON_INDEXTITLE_DRAW);
        for(var i=0;i<this.TitlePaint.length;++i)
        {
            var item=this.TitlePaint[i];
            if (!item.IsDynamic) continue;

            item.CursorIndex=this.CursorIndex;
            if (item.ClassName=='DynamicChartTitlePainting') item.OnDrawEvent=eventIndexTitleDraw
            else item.OnDrawEvent=eventTitleDraw;

            if (item.OnDrawEvent) 
            {
                item.OnDrawEvent.FunctionName='Draw';
                item.OnDrawEvent.PointPosition=null;
            }

            item.DrawStatus=drawStatus;
            item.Draw();
        }

        for(var i=0;i<this.ExtendChartPaint.length;++i) //动态扩展图形
        {
            var item=this.ExtendChartPaint[i];
            if (item.IsCallbackDraw) continue;
            if (item.IsDynamic && item.DrawAfterTitle===true && item.IsAnimation==false) item.Draw();
        }

        if (this.EnableAnimation)
        {
            for(var i=0;i<this.ExtendChartPaint.length;++i) //动画
            {
                var item=this.ExtendChartPaint[i];
                if (item.IsAnimation===true) item.Draw();
            }
        }

        for(var i=0;i<this.ChartDrawPicture.length;++i)
        {
            var item=this.ChartDrawPicture[i];
            item.Draw();
        }

        if (this.CurrentChartDrawPicture && this.CurrentChartDrawPicture.Status!=10)
        {
            this.CurrentChartDrawPicture.Draw();
        }

        this.OffscreenToShowCanvas();

        //发送图形状态给外部
        if (this.mapEvent.has(JSCHART_EVENT_ID.CHART_STATUS))
        {
            var event=this.mapEvent.get(JSCHART_EVENT_ID.CHART_STATUS);
            
            var data={  };
            if (typeof(this.GetChartStatus)=='function') data=this.GetChartStatus();
            event.Callback(event,data,this);
        }

        ++this.TouchDrawCount;
    }

    this.OffscreenToShowCanvas=function()
    {
        if (!this.ShowCanvas) return;

        this.ShowCanvas.clearRect(0,0,this.UIElement.width,this.UIElement.height);
        this.ShowCanvas.drawImage(this.OffscreenCanvasElement,0,0);
    }

    this.GetDrawStatus=function()
    {
        var status=
        {
            Point:{ X:this.LastPoint.X, Y:this.LastPoint.Y }, 
            IsOnTouch:this.IsOnTouch,
            CorssCursorTouchEnd:this.CorssCursorTouchEnd,
            IsTitleShowLatestData:this.IsTitleShowLatestData,
            IsMinuteChart:(this.ClassName=="MinuteChartContainer" || this.ClassName=="MinuteChartHScreenContainer") ? true:false
        };

        status.FrameID=this.Frame.PtInFrame(this.LastPoint.X, this.LastPoint.Y);

        return status;
    }
    //画动态信息
    this.DrawDynamicInfo=function(option)
    {
        if (this.Frame.ScreenImageData==null) return;

        var isErase=false;
        if (this.ChartCorssCursor)
        {
            if (this.ChartCorssCursor.PointX!=null || this.ChartCorssCursor.PointY!=null)
                isErase=true;
        }

        isErase=true;   //每次都擦除背景
        if (isErase==false)
        {
            for(var i=0;i<this.ExtendChartPaint.length;++i)
            {
                var item=this.ExtendChartPaint[i];
                if (item.IsCallbackDraw) continue;
                if (item.IsDynamic && item.IsEraseBG) 
                {
                    isErase=true;
                    break;
                }
            }
        }

        if (isErase) this.Canvas.putImageData(this.Frame.ScreenImageData,0,0);


        for(var i=0;i<this.ExtendChartPaint.length;++i) //动态扩展图形
        {
            var item=this.ExtendChartPaint[i];
            if (item.IsCallbackDraw) continue;
            if (item.IsDynamic && item.DrawAfterTitle===false && item.IsAnimation==false) item.Draw();
        }

        if (this.ChartCorssCursor)
        {
            this.ChartCorssCursor.LastPoint=this.LastPoint;
            this.ChartCorssCursor.CursorIndex=this.CursorIndex;
            if (option && option.Corss==false)
            {

            }
            else if (this.DragMode==JSCHART_DRAG_ID.CLICK_TOUCH_MODE_ID)
            {
                if (this.TouchStatus.CorssCursorShow==true) this.ChartCorssCursor.Draw();
            }
            else if ( !(this.IsOnTouch===false && this.CorssCursorTouchEnd===true) && !this.CurrentChartDrawPicture)
            {
                this.ChartCorssCursor.Draw();
            }
            else if (this.IsOnTouch===true && (this.CurrentChartDrawPicture && this.EnableShowCorssCursor && this.EnableShowCorssCursor.DrawPicture==true))
            {
                this.ChartCorssCursor.Draw();
            }
        }

        var ptPosition=null;    //鼠标位置 null 无效 -1 在外面 >=0 对应的指标窗口中ID
        if (option && option.ParentFunction=='OnMouseMove' && option.Point)
        {
            ptPosition=this.Frame.PtInFrame(option.Point.X, option.Point.Y);
        }

        var drawStatus=this.GetDrawStatus();
        drawStatus.DrawName="DrawDynamicInfo";
        for(var i=0;i<this.TitlePaint.length;++i)
        {
            var item=this.TitlePaint[i];
            if (!item.IsDynamic) continue;

            item.CursorIndex=this.CursorIndex;
            if (item.OnDrawEvent) 
            {
                item.OnDrawEvent.FunctionName='DrawDynamicInfo';
                item.OnDrawEvent.PointPosition=ptPosition;
            }
            item.DrawStatus=drawStatus;

            if (item.ClassName=="DynamicMinuteTitlePainting")
            {
                if (option && IFrameSplitOperator.IsNumber(option.ClientPos) && option.Point)
                    item.PointInfo={ ClientPos:option.ClientPos, Point:{ X:option.Point.X, Y:option.Point.Y }};
                else 
                    item.PointInfo=null;
            }
            
            item.Draw();
        }

        for(var i=0;i<this.ExtendChartPaint.length;++i) //动态扩展图形   在动态标题以后画
        {
            var item=this.ExtendChartPaint[i];
            if (item.IsCallbackDraw) continue;
            if (item.ClassName=='KLineTooltipPaint' && option)
            {
                if (option.Tooltip==false) continue;
                if (option.Point) item.LatestPoint=option.Point;
            }
            else if (item.ClassName=="MinuteTooltipPaint" && option)
            {
                if (option.Point) item.LatestPoint=option.Point;
            }

            if (item.IsDynamic && item.DrawAfterTitle===true) item.Draw();
        }

        if (this.EnableAnimation)
        {
            for(var i=0;i<this.ExtendChartPaint.length;++i) //动画
            {
                var item=this.ExtendChartPaint[i];
                if (item.IsAnimation===true) item.Draw();
            }
        }

        for(var i=0;i<this.ChartDrawPicture.length;++i)
        {
            var item=this.ChartDrawPicture[i];
            item.Draw();
        }

        if (this.CurrentChartDrawPicture && this.CurrentChartDrawPicture.Status!=10)
        {
            this.CurrentChartDrawPicture.Draw();
        }

        this.OffscreenToShowCanvas();

        ++this.TouchDrawCount;
    }

    this.DrawAnimation=function()   //绘制动画 如弹幕
    {
        if (!this.EnableAnimation) return;

        if (this.Frame.ScreenImageData && !this.IsOnTouch)
        {
            for(var i=0;i<this.ExtendChartPaint.length;++i)
            {
                var item=this.ExtendChartPaint[i];
                if (item.IsAnimation===true) item.IsMoveStep=true;  //移动弹幕
            }

            this.DrawDynamicInfo();
        }
        
        var self=this;
        window.requestAnimationFrame(function() { self.DrawAnimation(); });
    }

    this.StartAnimation=function(option)
    {
        var bCreated=false; //是否已经创建了弹幕画法
        var barrageData=null;
        for(var i=0;i<this.ExtendChartPaint.length;++i)
        {
            var item=this.ExtendChartPaint[i];
            if (item.ClassName==='BarragePaint')
            {
                bCreated=true;
                barrageData=item.BarrageList;
                break;
            }
        }

        if (!bCreated)
        {
            var chart=new BarragePaint();
            chart.Canvas=this.Canvas;
            chart.ChartBorder=this.Frame.ChartBorder;
            chart.ChartFrame=this.Frame;
            chart.HQChart=this;
            chart.SetOption(option);
            this.ExtendChartPaint.push(chart);
            barrageData=chart.BarrageList;
        }

        this.EnableAnimation=true;
        var self=this;
        window.requestAnimationFrame(function() { self.DrawAnimation(); });

        return barrageData;
    }

    this.StopAnimation=function()
    {
        this.EnableAnimation=false;
        this.DrawDynamicInfo();
    }

    this.GetChartTooltipData=function(x,y,option)
    {
        var toolTip=new TooltipData();

        if (this.ChartInfoPaint)
        {
            if (this.ChartInfoPaint.GetTooltipData(x,y,toolTip)) 
                return toolTip;
        }

        for(var i=0;i<this.ChartPaint.length;++i)
        {
            var item=this.ChartPaint[i];
            if (item.GetTooltipData(x,y,toolTip))
                return toolTip;
        }

        for(var i=0;i<this.Frame.SubFrame.length;++i)
        {
            var subFrame=this.Frame.SubFrame[i];
            for(var j=0;j<subFrame.OverlayIndex.length;++j)
            {
                var overlayItem=subFrame.OverlayIndex[j];
                for(var k=0;k<overlayItem.ChartPaint.length;++k)
                {
                    var item=overlayItem.ChartPaint[k];
                    if (item.GetTooltipData(x,y,toolTip))
                        return toolTip;
                }
            }
        }

        for(var i=0;i<this.OverlayChartPaint.length;++i)
        {
            var item=this.OverlayChartPaint[i];
            if (item.GetTooltipData(x,y,toolTip))
                return toolTip;
        }
        
        return null;
    }

    this.OnMouseMove=function(x,y,e, isPhone)
    {
        this.LastPoint.X=x;
        this.LastPoint.Y=y;
        var mouseStatus=null;   //鼠标状态
        var frameID=this.Frame.PtInFrame(x,y);
        if (IFrameSplitOperator.IsNumber(frameID) && frameID>=0)    //在K线内部移动,调整K线索引
            this.CursorIndex=this.Frame.GetXData(x);

        if (this.EnableBorderDrag && this.Frame)
        {
            var dragBorder=this.Frame.PtInFrameBorder(x,y);
            if (dragBorder && dragBorder.Index>=0)
            {
                mouseStatus={ Cursor:"n-resize", Name:"DragBorder"};
                JSConsole.Chart.Log("[JSChartContainer::OnMouseMove] drag border ",dragBorder);
            }
        }

        if (this.EnableYDrag && this.Frame && !mouseStatus)
        {
            var dragY=this.TryYDrag(x,y);
            if (dragY)
            {
                mouseStatus={ Cursor:dragY.Position==0 ? "n-resize":"row-resize", Name:"DragY"};
                JSConsole.Chart.Log("[JSChartContainer::OnMouseMove] drag y ",dragY);
            }
        }

        var button=this.Frame.PtInButtons(x,y);
        if (button)
        {
            mouseStatus={ Cursor:"pointer", Name:"FrameButton"};
            JSConsole.Chart.Log("[JSChartContainer::OnMouseMove] frame button ", button);
        }

        var bDrawPicture=false; //是否正在画图
        if (this.CurrentChartDrawPicture)
        {
            if (this.CurrentChartDrawPicture.SetLastPoint) this.CurrentChartDrawPicture.SetLastPoint({X:x,Y:y});
            bDrawPicture=true;
        }
        else
        {
            var drawPictrueData={};
            drawPictrueData.X=x;
            drawPictrueData.Y=y;
            if (this.GetChartDrawPictureByPoint(drawPictrueData) && 
                drawPictrueData.ChartDrawPicture && drawPictrueData.ChartDrawPicture.EnableMove==true) 
            {
                
                if (drawPictrueData.PointIndex===100) this.UIElement.style.cursor="move";
                else this.UIElement.style.cursor="pointer";
                bDrawPicture=true;
            }
            else 
            {
                if (!this.MouseDrag) this.UIElement.style.cursor="default";
            }
        }

        var clientPos=this.PtInClient(x,y);
        var option={ ParentFunction:'OnMouseMove', Point:{X:x, Y:y}, IsPhone:isPhone===true, ClientPos:clientPos };
        this.DrawDynamicInfo(option);
        if (mouseStatus) this.UIElement.style.cursor=mouseStatus.Cursor;

        if (this.IsShowTooltip && bDrawPicture==false)
        {
            var toolTip=this.GetChartTooltipData(x,y);

            if (toolTip && toolTip.Data)
            {
                if (isPhone===true)
                {
                    var touche=e.touches[0];
                    var xTooltip = touche.clientX-this.UIElement.getBoundingClientRect().left;
                    var yTooltip = touche.clientY-this.UIElement.getBoundingClientRect().top;
                }
                else
                {
                    var xTooltip = e.clientX-this.UIElement.getBoundingClientRect().left;
                    var yTooltip = e.clientY-this.UIElement.getBoundingClientRect().top;
                }
                this.ShowTooltip(xTooltip,yTooltip,toolTip);
            }
            else
            {
                this.HideTooltip();
            }
        }
    }

    this.OnKeyDown=function(e)
    {
        if (this.ChartSplashPaint && this.ChartSplashPaint.IsEnableSplash == true) return;
        
        var keyID = e.keyCode ? e.keyCode :e.which;
        switch(keyID)
        {
            case 37: //left
                if (this.CursorIndex<=0.99999)
                {
                    if (!this.DataMoveLeft()) 
                    {   //左移数据到头了 触发下载新数据
                        if (this.DragDownloadData) this.DragDownloadData();
                        break;
                    }
                    this.UpdataDataoffset();
                    this.UpdatePointByCursorIndex();
                    this.UpdateFrameMaxMin();
                    this.Draw();
                    this.ShowTooltipByKeyDown();
                }
                else
                {
                    --this.CursorIndex;
                    this.UpdatePointByCursorIndex();
                    this.DrawDynamicInfo();
                    this.ShowTooltipByKeyDown();
                }
                break;
            case 39: //right
                var xPointcount=0;
                if (this.Frame.XPointCount) xPointcount=this.Frame.XPointCount;
                else xPointcount=this.Frame.SubFrame[0].Frame.XPointCount;
                if (this.CursorIndex+1>=xPointcount)
                {
                    if (!this.DataMoveRight()) break;
                    this.UpdataDataoffset();
                    this.UpdatePointByCursorIndex();
                    this.UpdateFrameMaxMin();
                    this.Draw();
                    this.ShowTooltipByKeyDown();
                }
                else
                {
                    //判断是否在最后一个数据上
                    var data=null;
                    if (this.Frame.Data) data=this.Frame.Data;
                    else data=this.Frame.SubFrame[0].Frame.Data;
                    if (!data) break;
                    if (this.CursorIndex+data.DataOffset+1>=data.Data.length) break;

                    ++this.CursorIndex;
                    this.UpdatePointByCursorIndex();
                    this.DrawDynamicInfo();
                    this.ShowTooltipByKeyDown();
                }
                break;
            case 38:    //up
                if (this.EnableZoomUpDown && this.EnableZoomUpDown.Keyboard===false) break;
                var cursorIndex={ ZoomType:this.ZoomType };
                cursorIndex.Index=parseInt(Math.abs(this.CursorIndex-0.5).toFixed(0));
                if (!this.Frame.ZoomUp(cursorIndex)) break;
                this.CursorIndex=cursorIndex.Index;
                this.UpdatePointByCursorIndex();
                this.UpdataDataoffset();
                this.UpdateFrameMaxMin();
                this.Draw();
                this.ShowTooltipByKeyDown();
                break;
            case 40:    //down
                if (this.EnableZoomUpDown && this.EnableZoomUpDown.Keyboard===false) break;
                var cursorIndex={ ZoomType:this.ZoomType };
                cursorIndex.Index=parseInt(Math.abs(this.CursorIndex-0.5).toFixed(0));
                if (!this.Frame.ZoomDown(cursorIndex)) break;
                this.CursorIndex=cursorIndex.Index;
                this.UpdataDataoffset();
                this.UpdatePointByCursorIndex();
                this.UpdateFrameMaxMin();
                this.Draw();
                this.ShowTooltipByKeyDown();
                break;
            case 46:    //del
                if (!this.SelectChartDrawPicture) break;
                var drawPicture=this.SelectChartDrawPicture;
                JSConsole.Chart.Log(drawPicture,"drawPicturedrawPicturedrawPicture")
                this.SelectChartDrawPicture=null;
                this.ClearChartDrawPicture(drawPicture);    //删除选中的画图工具
                break;
            default:
                return;
        }

        //不让滚动条滚动
        if(e.preventDefault) e.preventDefault();
        else e.returnValue = false;
    }

    this.OnDoubleClick=function(x,y,e)
    {
        //JSConsole.Chart.Log(e);
    }

    this.PtInClient=function(x,y)
    {
        this.Canvas.beginPath();
        if (this.Frame.IsHScreen===true)
        {
            var border=this.Frame.ChartBorder.GetHScreenBorder();
            this.Canvas.rect(border.Left,border.TopEx,border.Right-border.Left,border.BottomEx-border.TopEx);
        }
        else
        {
            var border=this.Frame.ChartBorder.GetBorder();
            if (border.DayBorder)   //多日分时+多日集合竞价
            {
                for(var i=0;i<border.DayBorder.length;++i)
                {
                    var client=border.DayBorder[i];
                    this.Canvas.beginPath();
                    this.Canvas.rect(client.LeftEx,border.TopEx,client.RightEx-client.LeftEx,border.BottomEx-border.TopEx);
                    if (this.Canvas.isPointInPath(x,y)) return 1;

                    //盘前
                    this.Canvas.beginPath();
                    this.Canvas.rect(client.Left,border.TopEx,client.LeftEx-client.Left,border.BottomEx-border.TopEx);
                    if (this.Canvas.isPointInPath(x,y)) 
                        return 200+parseInt(i);

                    //盘后
                    this.Canvas.beginPath();
                    this.Canvas.rect(client.RightEx,border.TopEx,client.Right-client.RightEx,border.BottomEx-border.TopEx);
                    if (this.Canvas.isPointInPath(x,y)) 
                        return 300+parseInt(i);
                }

                return -1;
            }

            this.Canvas.rect(border.LeftEx,border.Top,border.RightEx-border.LeftEx,border.Bottom-border.Top);
        }

        if (this.Canvas.isPointInPath(x,y)) return 1;

        if (this.Frame.ChartBorder.LeftExtendWidth>10)
        {
            this.Canvas.beginPath();
            if (this.Frame.IsHScreen===true)
            {
                this.Canvas.rect(border.Left,border.Top,border.Right-border.Left,border.TopEx-border.Top);
            }
            else
            {
                this.Canvas.rect(border.Left,border.Top,border.LeftEx-border.Left,border.Bottom-border.Top);
            }
    
            if (this.Canvas.isPointInPath(x,y)) return 2;
        }

        if (this.Frame.ChartBorder.RightExtendWidth>10)
        {
            this.Canvas.beginPath();
            if (this.Frame.IsHScreen===true)
            {
                this.Canvas.rect(border.Left,border.BottomEx,border.Right-border.Left,border.Bottom-border.BottomEx);
            }
            else
            {
                this.Canvas.rect(border.RightEx,border.Top,border.Right-border.RightEx,border.Bottom-border.Top);
            }
    
            if (this.Canvas.isPointInPath(x,y)) return 3;
        }

        return -1;
    }

    this.OnMoveFromeBorder=function(index, yMove)
    {
        if (!this.Frame) return;

        if (!this.Frame.OnMoveFromeBorder(index,yMove)) return ;

        //this.Frame.SetSizeChage(true);
        this.Frame.SetFrameBorderSizeChange();
        this.Frame.ReDrawToolbar();
        this.Draw();
    }

    this.OnZoomUpDownFrameY=function(obj, yMove)
    {
        if (!this.Frame) return;

        if (!this.Frame.OnZoomUpDownFrameY(obj,yMove)) return ;

        this.Frame.SetSizeChage(true);
        this.Draw();
    }

    this.OnUpDonwFrameY=function(obj, yMove)
    {
        if (!this.Frame) return false;

        if (!this.Frame.OnUpDonwFrameY(obj,yMove)) return false;

        this.Frame.SetSizeChage(true);

        return true;
    }

    this.CancelZoomUpDownFrameY=function(obj)
    {
        if (!this.Frame) return;

        if (!this.Frame.CancelZoomUpDownFrameY(obj)) return ;

        this.UpdateFrameMaxMin();
        this.Frame.SetSizeChage(true);
        this.Draw();
    }

    this.IsKLineContainer=function()
    {
        if (this.ClassName=='KLineChartContainer' || this.ClassName=='KLineChartHScreenContainer' ||
            this.ClassName=="KLineTrainChartContainer" || this.ClassName=="CustomKLineChartContainer" ) return true;

        return false;
    }

    this.UpdatePointByCursorIndex=function(type)    //type 1=根据十字光标更新 2=强制取消十字光标
    {
        var pt={X:null, Y:null};
        pt.X=this.Frame.GetXFromIndex(this.CursorIndex);
        var index=Math.abs(this.CursorIndex-0.5);
        if (this.IsKLineContainer()) index=this.CursorIndex;

        var data=this.Frame.Data;
        if (data.DataOffset+index<data.Data.length)
        {
            var close=data.Data[data.DataOffset+index].Close;
            pt.Y=this.Frame.GetYFromData(close);
        }
       
        if (type==1 && this.ChartCorssCursor)
        {
            if (this.ChartCorssCursor.Status==1)    //十字光标显示中, 不调整位置
            {

            }
            else
            {
                this.LastPoint.X=this.Frame.GetXFromIndex(this.CursorIndex);
                var index=Math.abs(this.CursorIndex-0.5);
                index=parseInt(index.toFixed(0));
                if (this.IsKLineContainer()) index=this.CursorIndex;
                this.LastPoint.Y=null;
            }
        }
        else if (type==2 && this.ChartCorssCursor)  //取消鼠标位置，十字光标就不显示了
        {
            this.LastPoint.Y=null;
            this.LastPoint.X=null;
        }
        else
        {
            this.LastPoint.X=pt.X;
            this.LastPoint.Y=pt.Y;
        }
    }

    this.ShowTooltipByKeyDown=function()
    {
        var index=Math.abs(this.CursorIndex-0.5);
        index=parseInt(index.toFixed(0));
        if (this.ClassName=='KLineChartContainer' || this.ClassName=='KLineTrainChartContainer') index=this.CursorIndex;

        var data=this.Frame.Data;
        var toolTip=new TooltipData();
        toolTip.Data=data.Data[data.DataOffset+index];
        toolTip.ChartPaint=this.ChartPaint[0];

        var pixelTatio = GetDevicePixelRatio();
        if (pixelTatio===0) pixelTatio=1;   //div 缩放还是使用原始坐标
        this.ShowTooltip(this.LastPoint.X/pixelTatio,this.LastPoint.Y/pixelTatio,toolTip);
    }

    this.ShowTooltip=function(x,y,toolTip)
    {
        if (!this.IsShowTooltip) return;

        var pixelTatio = GetDevicePixelRatio(); //获取设备的分辨率
        var xMove=15/pixelTatio;    //顶部坐标偏移位置
        if (toolTip.Type===0) //K线信息
        {
            var scrollPos=GetScrollPosition();
            var left = x;
            var top = y;

            var format=g_DivTooltipDataForamt.Create('HistoryDataStringFormat');
            format.Value=toolTip;
            format.Symbol=this.Symbol;
            format.LanguageID=this.LanguageID;
            if (!format.Operator()) return;
            var textHeight=format.LineCount*25; //每行的行高25
            if (format.Height>0) textHeight=format.Height;  //新版本高度有格式化类计算完成
            var width=format.Width;

            this.Tooltip.style.width = width+"px";
            this.Tooltip.style.height =textHeight+"px";
            //JSConsole.Chart.Log(`[JSChartContainer::ShowTooltip] left=${left} top=${top} xMove=${xMove}` );
            //if (toolTip.ChartPaint.Name=="Overlay-KLine")  this.Tooltip.style.height =220+"px";
            this.Tooltip.style.position = "absolute";
            //JSConsole.Chart.Log('[JSChartContainer::ShowTooltip] getBoundingClientRect() ',this.UIElement.getBoundingClientRect())
            if (left+width>this.UIElement.getBoundingClientRect().width)
                this.Tooltip.style.left = (left-width) + "px";
            else
                this.Tooltip.style.left = left + "px";
            
            if (top+xMove+textHeight>this.UIElement.getBoundingClientRect().height-5)
                this.Tooltip.style.top = (top-textHeight)+ "px";
            else this.Tooltip.style.top = (top + xMove)+ "px";
            
            this.Tooltip.className='jschart-tooltip';
            this.Tooltip.innerHTML=format.Text;
            this.Tooltip.style.display = "block";
        }
        else if (toolTip.Type===1)   //信息地雷提示信息
        {
            var scrollPos=GetScrollPosition();
            var left = x;
            var top = y;

            var format=g_DivTooltipDataForamt.Create('KLineInfoDataStringFormat');
            format.Value=toolTip;
            format.Symbol=this.Symbol;
            format.LanguageID=this.LanguageID;
            if (!format.Operator()) return;
            var width=format.Width;

            this.Tooltip.className='jchart-klineinfo-tooltip';
            this.Tooltip.style.position = "absolute";
            if(left+width>this.UIElement.getBoundingClientRect().width){
                this.Tooltip.style.left = (left-width) + "px";
            }else{
                this.Tooltip.style.left = left + "px";
            }
            
            this.Tooltip.style.top = (top +xMove)+ "px";
            this.Tooltip.style.width = width+"px";
            this.Tooltip.style.height =null;
            this.Tooltip.innerHTML=format.Text;
            this.Tooltip.style.display = "block";
        }
        else if (toolTip.Type==2)   //指标信息
        {
            var left = x;
            var top = y;
            
            var format=g_DivTooltipDataForamt.Create('KLineTradeDataStringFormat');
            format.Value=toolTip;
            format.Symbol=this.Symbol;
            format.LanguageID=this.LanguageID;
            if (!format.Operator()) return;
            var width=format.Width;

            this.Tooltip.className='jchart-klinetrade-tooltip';
            this.Tooltip.style.position = "absolute";
            this.Tooltip.style.left = left + "px";
            this.Tooltip.style.top = (top +xMove)+ "px";
            this.Tooltip.style.width = width+"px";
            this.Tooltip.style.height =null;
            this.Tooltip.innerHTML=format.Text;;
            this.Tooltip.style.display = "block";
        }
        else if (toolTip.Type==3)   //分时图异动信息
        {
            var left = x;
            var top = y;

            var format=g_DivTooltipDataForamt.Create('MinuteInfoDataStringFormat');
            format.Value=toolTip;
            format.Symbol=this.Symbol;
            format.LanguageID=this.LanguageID;
            if (!format.Operator()) return;
            var width=format.Width;

            this.Tooltip.className='jchart-minuteinfo-tooltip'; //分时图异动
            this.Tooltip.style.position = "absolute";
            this.Tooltip.style.left = left + "px";
            this.Tooltip.style.top = (top +xMove)+ "px";
            this.Tooltip.style.width = width+"px";
            this.Tooltip.style.height =null;
            this.Tooltip.innerHTML=format.Text;;
            this.Tooltip.style.display = "block";
        }
        else if (toolTip.Type==4)   //icon图标信息
        {
            var left = x;
            var top = y;

            var format=g_DivTooltipDataForamt.Create('IconDataStringFormat');
            format.Value=toolTip;
            format.Symbol=this.Symbol;
            format.LanguageID=this.LanguageID;
            if (!format.Operator()) return;
            var width=format.Width;

            this.Tooltip.className='jchart-iconinfo-tooltip'; //图标信息
            this.Tooltip.style.position = "absolute";
            this.Tooltip.style.left = left + "px";
            this.Tooltip.style.top = (top +xMove)+ "px";
            this.Tooltip.style.width = width+"px";
            this.Tooltip.style.height =null;
            this.Tooltip.innerHTML=format.Text;;
            this.Tooltip.style.display = "block";
        }
    }

    this.HideTooltip=function()
    {
        if (this.Tooltip.style.display!="none") this.Tooltip.style.display = "none";
    }

    this.ShowSelectRect=function(x,y,x2,y2)
    {
        var left = x;
        var top = y;

        var border=this.Frame.ChartBorder.GetBorder();

        var borderRight=border.Right;
        var borderLeft=border.Left;

        if (x>borderRight) x=borderRight;
        if (x2>borderRight) x2=borderRight;

        if (x<borderLeft) x=borderLeft;
        if (x2<borderLeft) x2=borderLeft;

        if (x>x2) left=x2;
        if (y>y2) top=y2;

        var width=Math.abs(x-x2);
        var height=Math.abs(y-y2);

        this.SelectRect.style.width = width+"px";
        this.SelectRect.style.height =height+"px";
        this.SelectRect.style.position = "absolute";
        this.SelectRect.style.left = left +"px";
        this.SelectRect.style.top = top +"px";
        this.SelectRect.style.display = "block";
    }

    this.UpdateSelectRect=function(start,end)
    {
        if (!this.ChartPaint[0].Data) return;

        var data=this.ChartPaint[0].Data;
        var offset=data.DataOffset;
        var fixedStart=start-offset;
        var fixedEnd=end-offset;
        var x=this.Frame.GetXFromIndex(fixedStart);
        var x2=this.Frame.GetXFromIndex(fixedEnd);

        JSConsole.Chart.Log('[JSChartContainer::UpdateSelectRect]',start,end,x,x2);
        var scrollPos=GetScrollPosition();
        this.SelectRect.style.left = x + scrollPos.Left+"px";
        this.SelectRect.style.width = (x2-x)+"px";
    }

    this.HideSelectRect=function()
    {
        this.SelectRect.style.display = "none";
    }

    this.ResetFrameXYSplit=function()
    {
        if (typeof(this.Frame.ResetXYSplit)=='function')
            this.Frame.ResetXYSplit();
    }

    this.UpdateFrameMaxMin=function()
    {
        var frameMaxMinData=new Array();

        var chartPaint=new Array();

        for(var i=0;i<this.ChartPaint.length;++i)
        {
            var item=this.ChartPaint[i];
            if (item.IsShow==false) continue;   //隐藏的图形不计算
            chartPaint.push(this.ChartPaint[i]);
        }

        for(var i=0;i<this.OverlayChartPaint.length;++i)
        {
            chartPaint.push(this.OverlayChartPaint[i]);
        }

        for(var i=0;i<chartPaint.length;++i)
        {
            var paint=chartPaint[i];
            var range=paint.GetMaxMin();
            if (range==null || range.Max==null || range.Min==null) continue;
            var frameItem=null;
            for(var j in frameMaxMinData)
            {
                if (frameMaxMinData[j].Frame==paint.ChartFrame)
                {
                    frameItem=frameMaxMinData[j];
                    break;
                }
            }

            if (frameItem)
            {
                if (frameItem.Range.Max<range.Max) frameItem.Range.Max=range.Max;
                if (frameItem.Range.Min>range.Min) frameItem.Range.Min=range.Min;
            }
            else
            {
                frameItem={ OverlayFrame:[] };
                frameItem.Frame=paint.ChartFrame;
                frameItem.Range=range;
                frameMaxMinData.push(frameItem);
            }
        }

        var mapFrame=new Map();
        for(var i=0;i<frameMaxMinData.length;++i)
        {
            var item=frameMaxMinData[i];
            mapFrame.set(item.Frame.Identify,item);
        }

        //叠加坐标Y轴使用主图指标， 最大最小值
        for(var i=0;i<this.Frame.SubFrame.length;++i)
        {
            var subFrame=this.Frame.SubFrame[i];
            for(var j=0;j<subFrame.OverlayIndex.length;++j)
            {
                var overlayItem=subFrame.OverlayIndex[j];
                var overlayFrame=overlayItem.Frame;
                if (overlayFrame.IsShareY!=true) continue;
                if (!overlayFrame.MainFrame) continue;
                if (!mapFrame.has(overlayFrame.MainFrame.Identify)) continue;

                var frameItem=mapFrame.get(overlayFrame.MainFrame.Identify);
                if (!frameItem) continue;
                frameItem.OverlayFrame.push(overlayFrame);
                for(var k in overlayItem.ChartPaint)
                {
                    var paint=overlayItem.ChartPaint[k];
                    var range=paint.GetMaxMin();
                    if (range==null || range.Max==null || range.Min==null) continue;

                    if (frameItem.Range.Max<range.Max) frameItem.Range.Max=range.Max;
                    if (frameItem.Range.Min>range.Min) frameItem.Range.Min=range.Min;
                }
            }
        }

        for(var i=0;i<frameMaxMinData.length;++i)
        {
            var item=frameMaxMinData[i];
            if (!item.Frame || !item.Range) continue;
            if (item.Range.Max==null || item.Range.Min==null) continue;
            if (item.Frame.YSpecificMaxMin)
            {
                item.Frame.HorizontalMax=item.Frame.YSpecificMaxMin.Max;
                item.Frame.HorizontalMin=item.Frame.YSpecificMaxMin.Min;
            }
            else
            {
                item.Frame.HorizontalMax=item.Range.Max;
                item.Frame.HorizontalMin=item.Range.Min;
            }
            item.Frame.XYSplit=true;

            for(var j in item.OverlayFrame)
            {
                item.OverlayFrame[j].XYSplit=true;
            }
        }

        

        //更新独立子坐标
        for(var i=0;i<this.Frame.SubFrame.length;++i)
        {
            var subFrame=this.Frame.SubFrame[i];
            for(var j=0;j<subFrame.OverlayIndex.length;++j)
            {
                var overlayItem=subFrame.OverlayIndex[j];
                if (overlayItem.Frame.IsShareY===true) continue;
                overlayItem.UpdateFrameMaxMin();
            }
        }
    }

    this.DataMoveLeft=function()
    {
        var data=null;
        if (!this.Frame.Data) data=this.Frame.Data;
        else data=this.Frame.SubFrame[0].Frame.Data;
        if (!data) return false;
        if (data.DataOffset<=0) return false;
        --data.DataOffset;
        return true;
    }

    this.DataMoveRight=function()
    {
        var data=null;
        if (!this.Frame.Data) data=this.Frame.Data;
        else data=this.Frame.SubFrame[0].Frame.Data;
        if (!data) return false;

        var xPointcount=0;
        if (this.Frame.XPointCount) xPointcount=this.Frame.XPointCount;
        else xPointcount=this.Frame.SubFrame[0].Frame.XPointCount;
        if (!xPointcount) return false;

        if (xPointcount+data.DataOffset>=data.Data.length) return false;

        ++data.DataOffset;
        return true;
    }

    this.UpdataDataoffset=function()
    {
        var data=null;
        if (this.Frame.Data)
            data=this.Frame.Data;
        else
            data=this.Frame.SubFrame[0].Frame.Data;

        if (!data) return;

        for(var i in this.ChartPaint)
        {
            var item =this.ChartPaint[i];
            if (!item.Data) continue;
            item.Data.DataOffset=data.DataOffset;
        }

        for(var i in this.OverlayChartPaint)
        {
            var item =this.OverlayChartPaint[i];
            if (!item.Data) continue;
            item.Data.DataOffset=data.DataOffset;
        }

        //叠加指标当前显示的数据偏移
        for (var i in this.Frame.SubFrame)
        {
            var subFrame=this.Frame.SubFrame[i];
            for(var j in subFrame.OverlayIndex)
            {
                var overlayItem=subFrame.OverlayIndex[j];
                for(var k in overlayItem.ChartPaint)
                {
                    var item=overlayItem.ChartPaint[k];
                    if (!item.Data) continue;
                    item.Data.DataOffset=data.DataOffset;
                }
            }
        }

    }

    this.DataMove=function(step,isLeft)
    {
        var moveStep=step;
        step=parseInt(step/this.StepPixel);  //除以4个像素
        if (step<=0) return false;

        var data=null;
        if (!this.Frame.Data) data=this.Frame.Data;
        else data=this.Frame.SubFrame[0].Frame.Data;
        if (!data) return false;

        var xPointcount=0;
        if (this.Frame.XPointCount) xPointcount=this.Frame.XPointCount;
        else xPointcount=this.Frame.SubFrame[0].Frame.XPointCount;
        if (!xPointcount) return false;

        if (this.Frame.SubFrame && this.Frame.SubFrame.length>0 && this.Frame.SubFrame[0].Frame)
        {
            var fristFrame=this.Frame.SubFrame[0].Frame;
            if (fristFrame.DataWidth<=1 || fristFrame.DistanceWidth<=1) //K线在缩放很小的时候 移动加速
                step=moveStep*this.StepPixel;
        }

        if (isLeft) //-->
        {
            if (this.RightSpaceCount>0)
            {
                if (xPointcount+data.DataOffset>=data.Data.length+this.RightSpaceCount-1) return false;
                data.DataOffset+=step;

                if (data.DataOffset+xPointcount>=data.Data.length+this.RightSpaceCount)
                    data.DataOffset=data.Data.length-(xPointcount-this.RightSpaceCount);
            }
            else
            {
                if (xPointcount+data.DataOffset>=data.Data.length) return false;
                data.DataOffset+=step;

                if (data.DataOffset+xPointcount>=data.Data.length)
                    data.DataOffset=data.Data.length-xPointcount;
            }
            return true;
        }
        else        //<--
        {
            if (data.DataOffset<=0) return false;

            data.DataOffset-=step;
            if (data.DataOffset<0) data.DataOffset=0;

            return true;
        }
    }

    //获取鼠标在当前子窗口id
    this.GetSubFrameIndex=function(x,y)
    {
        if (!this.Frame.SubFrame || this.Frame.SubFrame.length<=0) return -1;

        for(var i in this.Frame.SubFrame)
        {
            var frame=this.Frame.SubFrame[i].Frame;
            var left=frame.ChartBorder.GetLeft();
            var top=frame.ChartBorder.GetTop();
            var height=frame.ChartBorder.GetHeight();
            var width=frame.ChartBorder.GetWidth();

            this.Canvas.beginPath();
            this.Canvas.rect(left,top,width,height);
            if (this.Canvas.isPointInPath(x,y)) return parseInt(i);

        }
        return 0;
    }

    //根据X坐标获取数据索引
    this.GetDataIndexByPoint=function(x)
    {
        var frame=this.Frame;
        if (this.Frame.SubFrame && this.Frame.SubFrame.length>0) frame=this.Frame.SubFrame[0].Frame;

        var data=null;
        if (this.Frame.Data)
            data=this.Frame.Data;
        else
            data=this.Frame.SubFrame[0].Frame.Data;

        if (!data || !frame) return;

        var index=parseInt(frame.GetXData(x));

        //JSConsole.Chart.Log('x='+ x +' date='+data.Data[data.DataOffset+index].Date);
        return data.DataOffset+index;
    }

    //获取主数据
    this.GetSelectRectData=function(selectData)
    {
        if (Math.abs(selectData.XStart-selectData.XEnd)<5) return false;

        var startClientPos=this.PtInClient(selectData.XStart, selectData.YStart);
        var endClientPos=this.PtInClient(selectData.XEnd, selectData.YEnd);
        
        var data=null;
        if (this.Frame.Data)
            data=this.Frame.Data;
        else
            data=this.Frame.SubFrame[0].Frame.Data;

        if (!data) return false;

        var start=this.GetDataIndexByPoint(selectData.XStart);
        var end=this.GetDataIndexByPoint(selectData.XEnd);

        if (Math.abs(start-end)<2) return false;

        selectData.Data=data;
        if (start>end)
        {
            selectData.Start=end;
            selectData.End=start;
        }
        else
        {
            selectData.Start=start;
            selectData.End=end;
        }

        return true;
    }

    //获取当前的点对应的 画图工具的图形
    //data.X data.Y 鼠标位置  返回 data.ChartDrawPicture 数据在画图工具 data.PointIndex 在画图工具对应点索引
    this.GetChartDrawPictureByPoint=function(data)
    {
        for(var i in this.ChartDrawPicture)
        {
            var item =this.ChartDrawPicture[i];
            var pointIndex=item.IsPointIn(data.X,data.Y);
            if (pointIndex===false) continue;

            if (pointIndex>=0)
            {
                data.ChartDrawPicture=item;
                data.PointIndex=pointIndex;
                return true;
            }
        }

        return false;
    }

    // 保存图片
    this.SaveToImage = function (format,colorGB) 
    {
        if (this.UIElement.width<=0 || this.UIElement.height<=0) return null;
        if (this.ChartSplashPaint && this.ChartSplashPaint.IsEnableSplash) return null; // 数据加载中不能保存

        JSConsole.Chart.Log('[JSChartContainer::SaveToImage]', this.UIElement);
        var clrBG='rgb(255,255,255)';
        if (colorGB) clrBG=colorGB;
        this.Canvas.clearRect(0,0,this.UIElement.width,this.UIElement.height);
        this.Canvas.fillStyle=clrBG;
        this.Canvas.fillRect(0,0,this.UIElement.width,this.UIElement.height);   //画一个背景色, 不然是一个黑的背景
        var pixelTatio = GetDevicePixelRatio(); //获取设备的分辨率
        this.Canvas.lineWidth=pixelTatio;       //手机端需要根据分辨率比调整线段宽度

        this.Frame.Draw();  //框架

        for (var i in this.ChartPaint)  //框架内图形
        {
            var item=this.ChartPaint[i];
            if (item.IsDrawFirst)
                item.Draw();
        }

        for(var i in this.ChartPaint)
        {
            var item=this.ChartPaint[i];
            if (!item.IsDrawFirst)
                item.Draw();
        }

        for(var i in this.ChartPaintEx)
        {
            var item=this.ChartPaintEx[i];
            item.Draw();
        }

        for(var i in this.OverlayChartPaint)    //叠加股票
        {
            var item=this.OverlayChartPaint[i];
            item.Draw();
        }

        
        for(var i in this.ExtendChartPaint)     //固定扩展图形
        {
            var item=this.ExtendChartPaint[i];
            if (!item.IsDynamic && item.IsAnimation==false) item.Draw();
        }

        if (this.Frame.DrawInsideHorizontal) this.Frame.DrawInsideHorizontal();
        this.Frame.DrawLock();

        for(var i in this.ExtendChartPaint) //动态扩展图形
        {
            var item=this.ExtendChartPaint[i];
            if (item.IsDynamic && item.DrawAfterTitle===false) item.Draw();
        }

        if (this.LastPoint.X!=null || this.LastPoint.Y!=null)
        {
            if (this.ChartCorssCursor)  //十字光标不画 
            {
                this.ChartCorssCursor.LastPoint=this.LastPoint;
                this.ChartCorssCursor.CursorIndex=this.CursorIndex;
            }
        }

        for(var i in this.TitlePaint)
        {
            var item=this.TitlePaint[i];
            if (!item.IsDynamic) continue;

            item.CursorIndex=this.CursorIndex;
            item.Draw();
        }

        for(var i in this.ExtendChartPaint) //动态扩展图形
        {
            var item=this.ExtendChartPaint[i];
            if (item.IsDynamic && item.DrawAfterTitle===true && item.IsAnimation==false) item.Draw();
        }

        if (this.EnableAnimation)
        {
            for(var i in this.ExtendChartPaint)    //动画
            {
                var item=this.ExtendChartPaint[i];
                if (item.IsAnimation===true) item.Draw();
            }
        }

        for(var i in this.ChartDrawPicture)
        {
            var item=this.ChartDrawPicture[i];
            item.Draw();
        }

        if (this.CurrentChartDrawPicture && this.CurrentChartDrawPicture.Status!=10)
        {
            this.CurrentChartDrawPicture.Draw();
        }

        var dataURL=this.UIElement.toDataURL(format ? format:'image/png', 1.0);
        JSConsole.Chart.Log('[JSChartContainer::SaveToImage] data= ', dataURL);
        return dataURL;
    }


    this.SaveToImageUrl=function(obj,callback) //obj:{Format: 图片格式, ColorGB: 背景色}, callback:function(bSuccess,obj)
    {
        if (!obj) obj={Format:'image/png', ColorGB:'rgb(255,255,255)'};
        var imageData=this.SaveToImage(obj.Format, obj.ColorGB);
        var postData={"Base64":imageData, "BucketName":"downloadcache", "Path":"hqchart/hq_snapshot"};
        var url=g_JSChartResource.Domain+'/API/FileUploadForBase64';

        JSNetwork.HttpRequest({
            url: url,
            method: "POST",
            dataType: "json",
            data: postData,
            success: function (data) 
            {
                JSConsole.Chart.Log('[JSChartContainer::SaveToImageUrl] recv data', data);
                var result={Path:data.relativeurl, Domain:'https://opensourcedownload.zealink.com'};
                result.Url=`${result.Domain}/${result.Path}`;
                if (callback) callback(true,result,'');
            },
            error: function (request) 
            {
                JSConsole.Chart.Log('[JSChartContainer::SaveToImageUrl] error ', request);
                if (callback) callback(false,null,'upload failed');
            }
        });

    }

    this.SetLanguage=function(language)
    {
        var languageID=null;
        switch(language)
        {
            case 'EN':
                languageID=JSCHART_LANGUAGE_ID.LANGUAGE_ENGLISH_ID;
                break;
            case 'CN':
                languageID=JSCHART_LANGUAGE_ID.LANGUAGE_CHINESE_ID;
                break;
            default:
                console.warn(`[JSChartContainer::SetLanguage] language=${language} error`);
                return;
        }

        if (this.LanguageID==languageID) return;
        
        this.LanguageID=languageID;
        if (this.ChartCorssCursor && this.ChartCorssCursor.StringFormatY) this.ChartCorssCursor.StringFormatY.LanguageID=this.LanguageID;

        for(var i in this.TitlePaint)
        {
            var item=this.TitlePaint[i];
            if (item) item.LanguageID=this.LanguageID;
        }

        if (this.Frame && this.Frame.SetLanguage) this.Frame.SetLanguage(this.LanguageID);

        this.Frame.SetSizeChage(true);
        this.Draw();
    }

    this.ReloadTiltePaintResource=function(resource)  //重新加载配置
    {
        for(var i in this.TitlePaint)
        {
            var item=this.TitlePaint[i];
            if (item.ReloadResource) item.ReloadResource(resource);
        }
    }

    this.ReloadExtendChartPaintResource=function(resource)  //扩展画法重新加载配置
    {
        for(var i in this.ExtendChartPaint)
        {
            var item=this.ExtendChartPaint[i];
            if (item.ReloadResource) item.ReloadResource(resource);
        }
    }

    this.ReloadResource=function(option)
    {
        this.ReloadBorder(option);
        this.ReloadTiltePaintResource(option.Resource);
        this.ReloadChartPaint(option.Resource);
        this.ReloadFrame(option.Resource);
        this.ReloadExtendChartPaintResource(option.Resource);
        this.ReloadChartCorssCursor(option,option.Resource);

        if (option.Update && this.Update) this.Update( {UpdateCursorIndexType:2} );       //是否立即更新并重绘
        else if (option.Draw==true) this.Draw(); //是否立即重绘
    }

    this.ReloadBorder=function(option)  //根据页面缩放调整对应边框的尺长
    {
        if (!option) return;

        var pixelTatio = GetDevicePixelRatio(); //获取设备的分辨率
        if (option.Border)
        {
            var item=option.Border;
            if (IFrameSplitOperator.IsNumber(item.Left)) this.Frame.ChartBorder.Left=item.Left*pixelTatio;
            if (IFrameSplitOperator.IsNumber(item.Right)) this.Frame.ChartBorder.Right=item.Right*pixelTatio;
            if (IFrameSplitOperator.IsNumber(item.Top)) this.Frame.ChartBorder.Top=item.Top*pixelTatio;
            if (IFrameSplitOperator.IsNumber(item.Bottom)) this.Frame.ChartBorder.Bottom=item.Bottom*pixelTatio;
        }

        for(var i in option.Windows)
        {
            var item=option.Windows[i];
            if (i>=this.Frame.SubFrame.length) continue;
            var subFrame=this.Frame.SubFrame[i];
            var border=subFrame.Frame.ChartBorder;
            if (IFrameSplitOperator.IsNumber(item.TitleHeight)) border.TitleHeight=item.TitleHeight*pixelTatio;
        }

        for(var i in option.Frame)
        {
            var item=option.Frame[i];
            if (i>=this.Frame.SubFrame.length) continue;

            var subFrame=this.Frame.SubFrame[i];
            var border=subFrame.Frame.ChartBorder;
            if (item.TopSpace>=0) border.TopSpace=item.TopSpace*pixelTatio;
            if (item.BottomSpace>=0) border.BottomSpace=item.BottomSpace*pixelTatio;
        }
    }

    this.ReloadFrame=function(resource)
    {
        for(var i in this.Frame.SubFrame)
        {
            var item=this.Frame.SubFrame[i];
            var subFrame=item.Frame;
            if (subFrame && subFrame.ReloadResource) subFrame.ReloadResource(resource);
        }
    }

    this.ReloadChartPaint=function(resource)
    {
        for(var i in this.ChartPaint)
        {
            var item=this.ChartPaint[i];
            if (item && item.ReloadResource) item.ReloadResource(resource);
        }
    }

    this.ReloadChartCorssCursor=function(option, resource)
    {
        var pixelTatio = GetDevicePixelRatio(); //获取设备的分辨率
        if (option && option.CorssCursor)
        {
            var item=option.CorssCursor;
            if (IFrameSplitOperator.IsNumber(item.TitleHeight)) this.ChartCorssCursor.TextHeight=item.TitleHeight*pixelTatio;  //十字光标文本信息高度
        }

        if (this.ChartCorssCursor.ReloadResource) this.ChartCorssCursor.ReloadResource(resource);
    }

    this.SetDepthMapData=function(depthData, bDraw)
    {
        for(var i in depthData)
        {
            var item=depthData[i];
            for(var j in this.ExtendChartPaint)
            {
                var chart=this.ExtendChartPaint[j];
                if (chart.ID==item.ID)
                {
                    chart.Data=item.Data;
                    break;
                }
            }
        }

        if (bDraw) this.Draw();
    }

    //画图工具
    //把X, Y绝对位置转成的相对位置的点
    this.PointAbsoluteToRelative=function(x, y, isPhone)
    {
        var pt={ X:x, Y:y };
        var pixelTatio = GetDevicePixelRatio();             //x,y是原始坐标 需要乘以放大倍速
        var uiRect=this.UIElement.getBoundingClientRect();  //dom返回的是没有放大倍数的值

        if (isPhone)
        {
            pt.X=x-uiRect.left*pixelTatio;      //手机端 dom返回的是没有放大倍数的值
            pt.Y=y-uiRect.top*pixelTatio;
        }
        else
        {
            pt.X=(x-uiRect.left)*pixelTatio;
            pt.Y=(y-uiRect.top)*pixelTatio;
        }

        return pt;
    }

    this.SetChartDrawPictureFirstPoint=function(x,y, isPhone)
    {
        var drawPicture=this.CurrentChartDrawPicture;
        if (!drawPicture) return false;
        if (!this.Frame.SubFrame || this.Frame.SubFrame.length<=0) return false;

        //相对坐标
        var pt=this.PointAbsoluteToRelative(x, y, isPhone);
        var xFixed=pt.X;
        var yFixed=pt.Y;

        for(var i in this.Frame.SubFrame)
        {
            var frame=this.Frame.SubFrame[i].Frame;
            var left=frame.ChartBorder.GetLeft();
            var top=frame.ChartBorder.GetTopEx();
            var height=frame.ChartBorder.GetHeight();
            var width=frame.ChartBorder.GetWidth();

            this.Canvas.beginPath();
            this.Canvas.rect(left,top,width,height);
            if (this.Canvas.isPointInPath(xFixed,yFixed))
            {
                drawPicture.Frame=frame;
                break;
            }
        }

        if (!drawPicture.Frame) return false;

        drawPicture.Point[0]=new Point();
        drawPicture.Point[0].X=xFixed;
        drawPicture.Point[0].Y=yFixed;
        drawPicture.Status=1;   //第1个点完成
        return true;
    }

    this.SetChartDrawPictureSecondPoint=function(x,y,isPhone)
    {
        var drawPicture=this.CurrentChartDrawPicture;
        if (!drawPicture) return false;

        //相对坐标
        var pt=this.PointAbsoluteToRelative(x, y, isPhone);

        drawPicture.Point[1]=new Point();
        drawPicture.Point[1].X=pt.X;
        drawPicture.Point[1].Y=pt.Y;

        drawPicture.Status=2;   //设置第2个点
        return true;
    }

    //设置第3个点
    this.SetChartDrawPictureThirdPoint=function(x,y,isPhone)
    {
        var drawPicture=this.CurrentChartDrawPicture;
        if (!drawPicture) return false;

        //相对坐标
        var pt=this.PointAbsoluteToRelative(x, y, isPhone);

        drawPicture.Point[2]=new Point();
        drawPicture.Point[2].X=pt.X;
        drawPicture.Point[2].Y=pt.Y;

        drawPicture.Status=3;   //设置第3个点
        return true;
    }

    //xStep,yStep 移动的偏移量
    this.MoveChartDrawPicture=function(x,y,isPhone)
    {
        var drawPicture=this.CurrentChartDrawPicture;
        if (!drawPicture) return false;

        var pixelTatio = GetDevicePixelRatio(); //x,y 需要乘以放大倍速
        if (isPhone) pixelTatio=1;
        var xStep=x*pixelTatio;
        var yStep=y*pixelTatio;
        //JSConsole.Chart.Log("xStep="+xStep+" yStep="+yStep);
        drawPicture.Move(xStep,yStep);

        return true;
    }

    this.FinishChartDrawPicturePoint=function()
    {
        var drawPicture=this.CurrentChartDrawPicture;
        if (!drawPicture) return false;
        if (drawPicture.PointCount!=drawPicture.Point.length) return false;
        if (drawPicture.ClassName=="ChartDrawRuler")    //尺子不用保存的
        {
            this.CurrentChartDrawPicture=null;
            return true;
        }

        drawPicture.Status=10;  //完成
        drawPicture.PointToValue();

        this.ChartDrawPicture.push(drawPicture);
        this.CurrentChartDrawPicture=null;

        //通知上层画好了
        let event=this.GetEventCallback(JSCHART_EVENT_ID.ON_FINISH_DRAWPICTURE); //完成画图工具事件
        if (event && event.Callback)
        {
            let sendData={ DrawPicture: drawPicture };
            event.Callback(event,sendData,this);
        }
        else if (drawPicture.FinishedCallback) drawPicture.FinishedCallback(drawPicture);

        if (this.ChartDrawStorage) this.ChartDrawStorage.SaveDrawData(drawPicture);

        return true;
    }

    //选中画图工具 出现单个图形设置菜单
    this.OnSelectChartPicture=function(chart)
    {   
        JSConsole.Chart.Log('[JSChartContainer::OnSelectChartPicture',chart);
        if (!this.ChartPictureMenu) this.ChartPictureMenu=new ChartPictureSettingMenu(this.UIElement.parentNode);

        var event={ data: { ChartPicture:chart, HQChart:this}};
        this.ChartPictureMenu.DoModal(event);
    }

    this.FinishMoveChartDrawPicture=function()
    {
        var drawPicture=this.CurrentChartDrawPicture;
        if (!drawPicture) return false;
        if (drawPicture.PointCount!=drawPicture.Point.length) return false;

        drawPicture.Status=10;  //完成
        drawPicture.PointToValue();

        if (this.ChartDrawStorage) this.ChartDrawStorage.SaveDrawData(drawPicture);

        this.CurrentChartDrawPicture=null;
        return true;
    }

    //清空所有的画线工具
    this.ClearChartDrawPicture=function(drawPicture)
    {
        if (!drawPicture)
        {
            this.ChartDrawPicture=[];
            if (this.ChartDrawStorage) this.ChartDrawStorage.Clear();
            this.Draw();
        }
        else
        {
            for(var i in this.ChartDrawPicture)
            {
                if (this.ChartDrawPicture[i]==drawPicture)
                {
                    if (this.ChartDrawStorage) this.ChartDrawStorage.DeleteDrawData(drawPicture);
                    this.ChartDrawPicture.splice(i,1);
                    this.Draw();
                }
            }
        }
    }

    this.SetChartDrawOption=function(option)
    {
        if (IFrameSplitOperator.IsBool(option.IsLockScreen)) this.ChartDrawOption.IsLockScreen=option.IsLockScreen;
        if (IFrameSplitOperator.IsNumber(option.Zoom) && option.Zoom>=0)  this.ChartDrawOption.Zoom=option.Zoom;
    }

    //是否显示十字光标的十字线
    this.EnableShowCorssCursorLine=function(bShow)
    {
        if (!this.ChartCorssCursor) return;

        this.ChartCorssCursor.IsShowCorss=bShow;
    }

    //获取扩展画法
    this.GetExtendChartByClassName=function(name)
    {
        for(var i in this.ExtendChartPaint)
        {
            var item=this.ExtendChartPaint[i];
            if (item.ClassName==name) return { Index:i, Chart:item };
        }

        return null
    }

    //删除扩展画法
    this.DeleteExtendChart=function(data)
    {
        if (data.Index>=this.ExtendChartPaint.length) return;
        if (this.ExtendChartPaint[data.Index]!=data.Chart) return;

        if (typeof(data.Chart.Clear)=='function') data.Chart.Clear();
        this.ExtendChartPaint.splice(data.Index,1);
    }

    //全屏提示信息 { Title:提示信息, Draw:false/true 是否立即重绘, }
    this.EnableSplashScreen=function(option)
    {
        if (!this.ChartSplashPaint) return;
        if (!option) return;

        if (IFrameSplitOperator.IsString(option.Title)) this.ChartSplashPaint.SetTitle(option.Title);
        this.ChartSplashPaint.EnableSplash(true);

        if (option.Draw===false) return;
        this.Draw();
    }

    //增加一个指标窗口
    this.AddIndexWindow=function(indexName,option)
    {
        //查找系统指标
        let scriptData = new JSIndexScript();
        let indexInfo = scriptData.Get(indexName);
        if (!indexInfo) return;

        var index=this.Frame.SubFrame.length;
        var subFrame=this.CreateSubFrameItem(index);
        this.Frame.SubFrame[index]=subFrame;
        var titlePaint=new DynamicChartTitlePainting();
        titlePaint.Frame=this.Frame.SubFrame[index].Frame;
        titlePaint.Canvas=this.Canvas;
        titlePaint.LanguageID=this.LanguageID;
        titlePaint.GetEventCallback=(id)=> { return this.GetEventCallback(id); }
        this.TitlePaint[index+1]=titlePaint;

        if (option)
        {
            if (option.Window)
            {
                var item=option.Window;
                if (item.Modify!=null) subFrame.Frame.ModifyIndex=item.Modify;
                if (item.Change!=null) subFrame.Frame.ChangeIndex=item.Change;
                if (item.Close!=null) subFrame.Frame.CloseIndex=item.Close;
                if (item.Overlay!=null) subFrame.Frame.OverlayIndex=item.Overlay;
                if (item.IsDrawTitleBG==true)  subFrame.Frame.IsDrawTitleBG=item.IsDrawTitleBG;
            }
            
            if (IFrameSplitOperator.IsNumber(option.TitleHeight)) subFrame.Frame.ChartBorder.TitleHeight=option.TitleHeight;
            if (IFrameSplitOperator.IsBool(option.IsShowTitleArraw)) subFrame.Frame.IsShowTitleArraw=option.IsShowTitleArraw;
            if (IFrameSplitOperator.IsBool(option.IsShowIndexName)) subFrame.Frame.IsShowIndexName=option.IsShowIndexName;
            if (IFrameSplitOperator.IsBool(option.IsShowOverlayIndexName)) subFrame.Frame.IsShowOverlayIndexName=option.IsShowOverlayIndexName;
            if (IFrameSplitOperator.IsNumber(option.IndexParamSpace)) subFrame.Frame.IndexParamSpace=option.IndexParamSpace;
            if (IFrameSplitOperator.IsBool(option.IsShowXLine)) subFrame.Frame.IsShowXLine=option.IsShowXLine;
            if (IFrameSplitOperator.IsBool(option.IsShowYLine)) subFrame.Frame.IsShowYLine=option.IsShowYLine;
            if (IFrameSplitOperator.IsBool(option.IsShowIndexTitle)) subFrame.Frame.IsShowIndexTitle=option.IsShowIndexTitle;
        }

        //最后一个显示X轴坐标
        for(var i=0;i<this.Frame.SubFrame.length;++i)
        {
            var item=this.Frame.SubFrame[i].Frame;
            if (i==this.Frame.SubFrame.length-1) item.XSplitOperator.ShowText=true;
            else item.XSplitOperator.ShowText=false;
        }

        this.UpdataDataoffset();        //更新数据偏移  
        this.Frame.SetSizeChage(true);
        if (this.UpdateXShowText) this.UpdateXShowText();
        this.ResetFrameXYSplit();
        this.UpdateFrameMaxMin();          //调整坐标最大 最小值
        this.Draw();

        var indexData = 
        { 
            Name:indexInfo.Name, Script:indexInfo.Script, Args: indexInfo.Args, ID:indexName ,
            //扩展属性 可以是空
            KLineType:indexInfo.KLineType,  YSpecificMaxMin:indexInfo.YSpecificMaxMin,  YSplitScale:indexInfo.YSplitScale,
            FloatPrecision:indexInfo.FloatPrecision, Condition:indexInfo.Condition,StringFormat:indexInfo.StringFormat,
            OutName:indexInfo.OutName
        };

        if (option)
        {
            if (option.FloatPrecision>=0) indexData.FloatPrecision=option.FloatPrecision;
            if (option.StringFormat>0) indexData.StringFormat=option.StringFormat;
            if (option.Args) indexData.Args=option.Args;
        }

        this.WindowIndex[index] = new ScriptIndex(indexData.Name, indexData.Script, indexData.Args,indexData);    //脚本执行
        if (this.ClassName=="MinuteChartContainer" || this.ClassName=="MinuteChartHScreenContainer")
            var bindData=this.SourceData;
        else 
            var bindData=this.ChartPaint[0].Data;

        this.BindIndexData(index,bindData);     //执行脚本
    }
}

function GetDevicePixelRatio()
{
    if (typeof(window) =='undefined') return 1;
    return window.devicePixelRatio || 1;
}

function GetFontHeight(context, font, word)
{
    if (!context) return null;

    if (font) context.font=font;

    var text='擎';
    if (IFrameSplitOperator.IsString(word)) text=word;

    var fontInfo=context.measureText(text);
    var textHeight=fontInfo.fontBoundingBoxAscent + fontInfo.fontBoundingBoxDescent;
    if (!IFrameSplitOperator.IsNumber(textHeight)) textHeight=fontInfo.width+2*GetDevicePixelRatio();

    return textHeight;
}

function IsPhoneWeb()
{
    var userAgentInfo=navigator.userAgent;   
    const Agents =new Array("Android","iPhone","SymbianOS","Windows Phone","iPad","iPod");   
    for(var v=0;v<Agents.length;v++) 
    {      
        if(userAgentInfo.indexOf(Agents[v])>0) return true;
    }    
    return false; 
}

function OnKeyDown(e)   //键盘事件
{
    if(this.JSChartContainer && this.JSChartContainer.OnKeyDown)
        this.JSChartContainer.OnKeyDown(e);
}

function OnWheel(e)    //上下滚动事件
{
    if(this.JSChartContainer && this.JSChartContainer.OnWheel)
        this.JSChartContainer.OnWheel(e);
}

function ToFixed(number, precision)
{
    var b = 1;
    if (isNaN(number)) return number;
    if (number < 0) b = -1;
    var multiplier = Math.pow(10, precision);
    var value=Math.round(Math.abs(number) * multiplier) / multiplier * b;

    if (/^(\d+(?:\.\d+)?)(e)([\-]?\d+)$/.test(value))
        var s=value.toFixed2(precision);
    else 
        var s = value.toString();
    
    var rs = s.indexOf('.');
    if (rs < 0 && precision>0)
    {
        rs = s.length;
        s += '.';
    }

    while (s.length <= rs + precision)
    {
        s += '0';
    }

    

    return s;
}

Number.prototype.toFixed2=Number.prototype.toFixed; //备份下老的
Number.prototype.toFixed = function( precision )
{
    return ToFixed(this,precision);
}

function Guid()
{
    function S4()
    {
       return (((1+Math.random())*0x10000)|0).toString(16).substring(1);
    }
    return "guid" + (S4()+S4()+"-"+S4()+"-"+S4()+"-"+S4()+"-"+S4()+S4()+S4());
}

function GetScrollPosition()
{
    var scrollPos={};
    var scrollTop=0;
    var scrollLeft=0;
    if(document.documentElement && document.documentElement.scrollTop)
    {
        scrollTop=document.documentElement.scrollTop;
        scrollLeft=document.documentElement.scrollLeft;
    }else if(document.body)
    {
        scrollTop=document.body.scrollTop;
        scrollLeft=document.body.scrollLeft;
    }

    scrollPos.Top=scrollTop;
    scrollPos.Left=scrollLeft;
    return scrollPos;
}

//修正线段有毛刺
function ToFixedPoint(value)
{
    return parseInt(value)+0.5;
}

//修正粗线段毛刺
function ToFixedPoint2(width, value)
{
    var fixValue=(width % 2)===0 ? Math.floor(value):Math.floor(value) + 0.5;    //毛边修正
    return fixValue;
}

function ToFixedRect(value)
{
    // With a bitwise or.
    //rounded = (0.5 + somenum) | 0;
    // A double bitwise not.
    //rounded = ~~ (0.5 + somenum);
    // Finally, a left bitwise shift.
    //value*=GetDevicePixelRatio();
    var rounded;
    return rounded = (0.5 + value) << 0;
}



function Point()
{
    this.X;
    this.Y;
}

function SelectRectData()
{
    this.Data;                  //主数据
    this.JSChartContainer;      //行情控件

    this.Start; //数据起始位子
    this.End;   //数据结束位置

    this.XStart;//X坐标起始位置
    this.YStart;
    this.XEnd;  //X位置结束为止
    this.YEnd;
}

//坐标信息
function CoordinateInfo()
{
    this.Value;                                                 //坐标数据
    this.Message=[];                                            //坐标输出文字信息 0=左 1=右 2=内左 3=内右
    this.TextColor=g_JSChartResource.FrameSplitTextColor        //文字颜色
    this.Font=g_JSChartResource.FrameSplitTextFont;             //字体
    this.LineColor=g_JSChartResource.FrameSplitPen;             //线段颜色
    this.LineType=1;                                            //线段类型 -1 不画线段 2 虚线 8,9=集合竞价坐标
    this.ExtendData;                                            //扩展属性
                                                                //百分比 { PriceColor:, PercentageColor:, SplitColor:, Font: }
}


//边框信息
function ChartBorder()
{
    this.UIElement;

    //四周间距
    this.Left=50;
    this.Right=80;
    this.Top=50;
    this.Bottom=50;
    this.TitleHeight=24;    //标题高度
    this.TopSpace=0;
    this.BottomSpace=0;

    this.LeftExtendWidth=0;      //左边扩展图形宽度
    this.RightExtendWidth=0;

    this.MultiDayMinute={ Count:1, Left:0, Right:0 }  // { Count:天数, Left:, Right: }

    this.GetBorder=function()
    {
        var data=
        { 
            Left:this.Left, 
            LeftEx:this.Left+this.LeftExtendWidth,
            Right:this.UIElement.width-this.Right,
            RightEx:this.UIElement.width-this.Right-this.RightExtendWidth,

            Top:this.Top,
            TopEx:this.Top+this.TitleHeight+this.TopSpace,
            TopTitle:this.Top+this.TitleHeight,
            Bottom:this.UIElement.height-this.Bottom,
            BottomEx:this.UIElement.height-this.Bottom-this.BottomSpace,

            ChartWidth:this.UIElement.width,
            ChartHeight:this.UIElement.height
        };

        if (this.MultiDayMinute && this.MultiDayMinute.Count>1 && ( this.MultiDayMinute.Left>0 || this.MultiDayMinute.Right>0 ))
        {
            var frameWidth=this.UIElement.width-this.Left-this.Right;   //坐标框子宽度
            var dayWidth=frameWidth/this.MultiDayMinute.Count;   // 每天的框子的宽度

            var dayBorder=[];
            for(var i=0;i<this.MultiDayMinute.Count;++i)
            {
                var item={ Left:this.Left+dayWidth*i, Right:this.Left+dayWidth*(i+1) };
                item.LeftEx=item.Left+this.MultiDayMinute.Left;
                item.RightEx=item.Right-this.MultiDayMinute.Right;
                dayBorder.push(item);
            }

            data.DayBorder=dayBorder;
        }

        return data;
    }

    this.GetHScreenBorder=function()
    {
        var data=
        {
            Left:this.Left,
            LeftEx:this.Left+this.BottomSpace,

            Right:this.UIElement.width-this.Right,
            RightEx:this.UIElement.width-this.Right-this.TitleHeight- this.TopSpace,
            RightTitle:this.UIElement.width-this.Right-this.TitleHeight,

            Top:this.Top,
            TopEx:this.Top+this.LeftExtendWidth,
            Bottom:this.UIElement.height-this.Bottom,
            BottomEx:this.UIElement.height-this.Bottom-this.RightExtendWidth,

            ChartWidth:this.UIElement.width,
            ChartHeight:this.UIElement.height
        };

        return data;
    }

    this.GetChartWidth=function()
    {
        return this.UIElement.width;
    }

    this.GetChartHeight=function()
    {
        return this.UIElement.height;
    }

    this.GetLeft=function()
    {
        return this.Left+this.LeftExtendWidth;
    }

    this.GetRight=function()
    {
        return this.UIElement.width-this.Right-this.RightExtendWidth;
    }

    this.GetTop=function()
    {
        return this.Top;
    }

    this.GetTopEx=function()    //去掉标题，上面间距
    {
        return this.Top+this.TitleHeight+this.TopSpace;
    }

    this.GetTopTitle=function() //去掉标题
    {
        return this.Top+this.TitleHeight;
    }

    this.GetBottom=function()
    {
        return this.UIElement.height-this.Bottom;
    }

    this.GetBottomEx=function()
    {
        return this.UIElement.height-this.Bottom-this.BottomSpace;
    }

    this.GetWidth=function()
    {
        return this.UIElement.width-this.Left-this.Right-this.LeftExtendWidth-this.RightExtendWidth;
    }

    this.GetHeight=function()
    {
        return this.UIElement.height-this.Top-this.Bottom;
    }

    this.GetHeightEx=function() //去掉标题的高度, 上下间距
    {
        return this.UIElement.height-this.Top-this.Bottom-this.TitleHeight-this.TopSpace-this.BottomSpace;
    }

    this.GetRightEx=function()  //横屏去掉标题高度的 上面间距
    {
        return this.UIElement.width-this.Right-this.TitleHeight- this.TopSpace;
    }

    this.GetWidthEx=function()  //横屏去掉标题宽度 上下间距
    {
        return this.UIElement.width-this.Left-this.Right-this.TitleHeight- this.TopSpace - this.BottomSpace;
    }

    this.GetLeftEx = function () //横屏
    {
        return this.Left+this.BottomSpace;
    }

    this.GetRightTitle = function ()//横屏
    {
        return this.UIElement.width - this.Right - this.TitleHeight;
    }

    this.GetTitleHeight=function()
    {
        return this.TitleHeight;
    }
}

function IChartFramePainting()
{
    this.HorizontalInfo=new Array();    //Y轴
    this.VerticalInfo=new Array();      //X轴
    this.ClassName='IChartFramePainting';

    this.Canvas;                        //画布

    this.Identify;                      //窗口标识

    this.ChartBorder;
    this.PenBorder=g_JSChartResource.FrameBorderPen;        //边框颜色
    this.TitleBGColor=g_JSChartResource.FrameTitleBGColor;  //标题背景色
    this.IsShow=true;                   //是否显示
    this.SizeChange=true;               //大小是否改变
    this.XYSplit=true;                  //XY轴坐标信息改变

    this.HorizontalMax;                 //Y轴最大值
    this.HorizontalMin;                 //Y轴最小值
    this.XPointCount=10;                //X轴数据个数

    this.YSplitOperator;               //Y轴分割
    this.XSplitOperator;               //X轴分割
    this.Data;                         //主数据

    this.IsLocked=false;               //是否上锁
    this.LockPaint = null;

    this.YSpecificMaxMin=null;         //指定Y轴最大最小值
    this.IsShowBorder = true;          //是否显示边框
    this.IsShowTitleArraw=true;        //是否显示指标信息上涨下跌箭头
    this.IsShowIndexName=true;         //是否显示指标名字
    this.IsShowOverlayIndexName=true;  //是否显示叠加指标名字
    this.IndexParamSpace=2;            //指标参数数值显示间距
    this.IsShowIndexTitle=true;        //显示整个指标标题信息
    this.IsDrawTitleBottomLine=false;

    this.BorderLine=null;               //1=上 2=下 4=左 8=右
    this.Buttons=[];                    //按钮事件 


    this.PtInButtons=function(x,y) //坐标是否在按钮上
    {
        for(var i=0;i<this.Buttons.length;++i)
        {
            var item=this.Buttons[i];
            if (!item.Rect) continue;

            var rect=item.Rect;
            this.Canvas.beginPath();
            this.Canvas.rect(rect.Left,rect.Top,rect.Width,rect.Height);
            if (this.Canvas.isPointInPath(x,y))
            {
                return { ID:item.ID, Rect:rect };
            }

        }

        return null;
    }

    this.GetBorder=function()
    {
        if (this.IsHScreen) return this.ChartBorder.GetHScreenBorder();
        else return this.ChartBorder.GetBorder();
    }

    this.Draw=function()
    {
        this.Buttons=[];
        this.DrawFrame();
        this.DrawBorder();

        this.SizeChange=false;
        this.XYSplit=false;
    }

    this.DrawFrame=function() { }

    //画边框
    this.DrawBorder=function()
    {
        if (!this.IsShowBorder) return;

        var border=this.IsHScreen==true?this.ChartBorder.GetHScreenBorder():this.ChartBorder.GetBorder();

        var left=ToFixedPoint(border.Left);
        var top=ToFixedPoint(border.Top);
        var right=ToFixedPoint(border.Right);
        var bottom=ToFixedPoint(border.Bottom);
        var width=right-left;
        var height=bottom-top;

        //JSConsole.Chart.Log('[IChartFramePainting.DrawBorder] bottom',bottom);
        if (this.BorderLine==null)
        {
            this.Canvas.strokeStyle=this.PenBorder;
            this.Canvas.strokeRect(left,top,width,height);
        }
        else if (IFrameSplitOperator.IsPlusNumber(this.BorderLine)) //单独绘制每个边框
        {
            this.Canvas.strokeStyle=this.PenBorder;
            this.Canvas.beginPath();

            if ((this.BorderLine&1)>0) //上
            {
                this.Canvas.moveTo(left,top);
                this.Canvas.lineTo(right,top);
            }

            if ((this.BorderLine&2)>0)  //下
            {
                this.Canvas.moveTo(left,bottom);
                this.Canvas.lineTo(right,bottom);
            }

            if ((this.BorderLine&4)>0)  //左
            {
                this.Canvas.moveTo(left,top);
                this.Canvas.lineTo(left,bottom);
            }

            if ((this.BorderLine&8)>0)    //右
            {
                this.Canvas.moveTo(right,top);
                this.Canvas.lineTo(right,bottom);
            }
              
            this.Canvas.stroke();
        }

        
    }

    //画标题背景色
    this.DrawTitleBG=function()
    {
        if (this.ChartBorder.TitleHeight<=0) return;

        var border=this.GetBorder();

        var left=ToFixedPoint(border.Left);
        var top=ToFixedPoint(border.Top);
        var right=ToFixedPoint(border.Right);
        var bottom=ToFixedPoint(this.ChartBorder.GetTopTitle());
        var width=right-left;
        var height=bottom-top;

        this.Canvas.fillStyle=this.TitleBGColor;
        this.Canvas.fillRect(left,top,width,height);

        if (this.IsDrawTitleBottomLine)
        {
            this.Canvas.strokeStyle=this.PenBorder;
            this.Canvas.beginPath();
            this.Canvas.moveTo(left,ToFixedPoint(border.TopTitle));
            this.Canvas.lineTo(right,ToFixedPoint(border.TopTitle));
            this.Canvas.stroke();
        }
    }

    this.DrawLock=function()
    {
        if (this.IsLocked)
        {
            if (this.LockPaint == null)
                this.LockPaint = new ChartLock();
            this.LockPaint.Canvas=this.Canvas;
            this.LockPaint.ChartBorder=this.ChartBorder;
            this.LockPaint.ChartFrame=this;
            this.LockPaint.Draw(true);
        }
    }

    this.CalculateLock=function()
    {
        if (this.IsLocked)
        {
            if (this.LockPaint == null)
                this.LockPaint = new ChartLock();
            this.LockPaint.Canvas=this.Canvas;
            this.LockPaint.ChartBorder=this.ChartBorder;
            this.LockPaint.ChartFrame=this;
            this.LockPaint.Draw(false);
        }
    }

    //设施上锁
    this.SetLock=function(lockData)
    {
        if (!lockData)  //空数据不上锁
        {
            this.IsLocked=false;
            return;
        }

        this.IsLocked=true;
        if (!this.LockPaint) this.LockPaint=new ChartLock();    //创建锁

        if (lockData.Callback) this.LockPaint.Callback=lockData.Callback;       //回调
        if (lockData.IndexName) this.LockPaint.IndexName=lockData.IndexName;    //指标名字
        if (lockData.ID) this.LockPaint.LockID=lockData.ID;                     //锁ID
        if (lockData.BG) this.LockPaint.BGColor=lockData.BG;                    //背景色 
        if (lockData.Text) this.LockPaint.Title= lockData.Text;   
        if (lockData.TextColor) this.LockPaint.TextColor=lockData.TextColor;  
        if (lockData.Font) this.LockPaint.Font=lockData.Font;
        if (lockData.Count) this.LockPaint.LockCount=lockData.Count;
        if (lockData.MinWidth>0) this.LockPaint.MinWidth=lockData.MinWidth;
    }

    this.GetLockRect=function()
    {
        if (!this.IsLocked) return null;
        if (!this.LockPaint) return null; 
        return this.LockPaint.LockRect;
    }

    this.ReloadResource=function(resource)
    {
        if (!resource)
        {
            this.PenBorder=g_JSChartResource.FrameBorderPen;        //边框颜色
            this.TitleBGColor=g_JSChartResource.FrameTitleBGColor;  //标题背景色
        }

        for(var i in this.HorizontalInfo)
        {
            var item=this.HorizontalInfo[i];
            if (item.Font) item.Font=g_JSChartResource.FrameSplitTextFont;             //字体
            if (item.TextColor) item.TextColor=g_JSChartResource.FrameSplitTextColor        //文字颜色
            if (item.LineColor) item.LineColor=g_JSChartResource.FrameSplitPen;             //线段颜色
        }

        for(var i in this.VerticalInfo)
        {
            var item=this.VerticalInfo[i];
            if (item.Font) item.Font=g_JSChartResource.FrameSplitTextFont;             //字体
            if (item.TextColor) item.TextColor=g_JSChartResource.FrameSplitTextColor        //文字颜色
            if (item.LineColor) item.LineColor=g_JSChartResource.FrameSplitPen;             //线段颜色
        }
    }

    this.GetFontHeight=function(font)
    {
        return GetFontHeight(this.Canvas, font, "擎");
    }
}

//空框架只画边框
function NoneFrame()
{
    this.newMethod=IChartFramePainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName="NoneFrame";

    this.Snapshot=function()
    {

    }

    this.SetSizeChage=function(sizeChange)
    {
        this.SizeChange=sizeChange;

        //画布的位置
        this.Position={
            X:this.ChartBorder.UIElement.offsetLeft,
            Y:this.ChartBorder.UIElement.offsetTop,
            W:this.ChartBorder.UIElement.clientWidth,
            H:this.ChartBorder.UIElement.clientHeight
        };
    }
}

function AverageWidthFrame()
{
    this.newMethod=IChartFramePainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName="AverageWidthFrame";
    this.DataWidth=50*GetDevicePixelRatio();
    this.DistanceWidth=10*GetDevicePixelRatio();
    this.MinXDistance = 30*GetDevicePixelRatio();       //X轴刻度最小间距
    this.MinYDistance=12*GetDevicePixelRatio();         //Y轴刻度最小间距
    this.CoordinateType=0;  //坐标类型 0=普通坐标 1=反转坐标
    this.IsShowYText=[true,true];       //是否显示Y轴坐标坐标 [0=左侧] [1=右侧]
    this.XBottomOffset=g_JSChartResource.Frame.XBottomOffset;   //X轴文字显示向下偏移
    this.YTextTopOffset=g_JSChartResource.Frame.YTopOffset;         //Y轴顶部文字向下偏移
    this.YTextPosition=[0,0],       //是坐标否强制画在内部 [0=左侧] [1=右侧] 1=OUT" , 2=INSIDE
    this.IsShowXLine=true;              //是否显示X轴刻度线
    this.IsShowYLine=true;
    this.YInsideOffset=0;
    this.YTextBaseline=0;       //0=居中 1=上部 (目前就支持内部刻度)
    this.MultiTextFormat=0;    //多行刻度信息显示模式 0=显示第1行 1=价格/百分比 2=显示2行
    this.RightTextMaxWidth=0;

    this.ShortYLineLength=5;
    this.ShortXLineLength=5;
    this.DrawDepthMapCallback;      //绘制深度图

    this.DrawFrame=function()
    {
        if (this.XPointCount>0)
        {
            let dInterval=this.ChartBorder.GetWidth()/(6*this.XPointCount); //分6份, 数据4 间距2
            this.DistanceWidth=2*dInterval;
			this.DataWidth=4*dInterval;
        }

        this.DrawHorizontal();
        this.DrawVertical();
    }

    //isLimit 是否限制在当前坐标下
    this.GetYFromData=function(value, isLimit)
    {
        if (this.Logarithmic && this.GetYLogarithmicFromData)
        {
            return this.GetYLogarithmicFromData(value, isLimit);
        }

        if (isLimit===false)
        {
            if (this.CoordinateType==1)
            {
                var height=this.ChartBorder.GetHeightEx()*(value-this.HorizontalMin)/(this.HorizontalMax-this.HorizontalMin);
                return this.ChartBorder.GetTopEx()+height;
            }
            else
            {
                var height=this.ChartBorder.GetHeightEx()*(value-this.HorizontalMin)/(this.HorizontalMax-this.HorizontalMin);
                return this.ChartBorder.GetBottomEx()-height;
            }
        }
        else
        {
            if (this.CoordinateType==1)
            {
                if(value<=this.HorizontalMin) return this.ChartBorder.GetTopEx();
                if(value>=this.HorizontalMax) return this.ChartBorder.GetBottomEx();

                var height=this.ChartBorder.GetHeightEx()*(value-this.HorizontalMin)/(this.HorizontalMax-this.HorizontalMin);
                return this.ChartBorder.GetTopEx()+height;
            }
            else
            {
                if(value<=this.HorizontalMin) return this.ChartBorder.GetBottomEx();
                if(value>=this.HorizontalMax) return this.ChartBorder.GetTopEx();

                var height=this.ChartBorder.GetHeightEx()*(value-this.HorizontalMin)/(this.HorizontalMax-this.HorizontalMin);
                return this.ChartBorder.GetBottomEx()-height;
            }
        }
    }

    //画Y轴
    this.DrawHorizontal=function()
    {
        this.RightTextMaxWidth=0;
        if (!IFrameSplitOperator.IsNonEmptyArray(this.HorizontalInfo)) return;

        var border=this.ChartBorder.GetBorder();
        var left=border.Left;
        var right=border.Right
        var bottom = border.Bottom
        var top = this.ChartBorder.GetTopTitle();
        var borderRight=this.ChartBorder.Right;
        var borderLeft=this.ChartBorder.Left;

        var isDrawLeft=borderLeft>10 && this.IsShowYText[0]===true && this.YTextPosition[0]!=2;
        var isDrawRight=borderRight>10 && this.IsShowYText[1]===true && this.YTextPosition[1]!=2;

        var yPrev=null; //上一个坐标y的值
        var pixelRatio=GetDevicePixelRatio();
        var itemHeight=(border.BottomEx-border.TopEx)/this.HorizontalInfo.length;
        var aryMultiText=[];
        for(var i=this.HorizontalInfo.length-1; i>=0; --i)  //从上往下画分割线
        {
            var item=this.HorizontalInfo[i];
            var y=this.GetYFromData(item.Value);
            if (y!=null && yPrev!=null && Math.abs(y-yPrev)<this.MinYDistance) continue;  //两个坐标在近了 就不画了
            
            var yFixed=ToFixedPoint(y);
            if (y!=bottom && this.IsShowYLine)
            {
                this.Canvas.strokeStyle=item.LineColor;
                if (item.LineType==2)
                {
                    this.Canvas.save();
                    this.Canvas.setLineDash([5*pixelRatio,5*pixelRatio]);   //虚线
                    this.Canvas.beginPath();
                    this.Canvas.moveTo(left,yFixed);
                    this.Canvas.lineTo(right,yFixed);
                    this.Canvas.stroke();
                    this.Canvas.restore();
                }
                else if (item.LineType==3)  //只在刻度边上画一个短横线
                {

                }
                else if (item.LineType==8 || item.LineType==9)  //集合竞价不画线
                {

                }
                else if (item.LineType>0)
                {
                    if (g_JSChartResource.FrameYLineDash)
                    {
                        this.Canvas.setLineDash(g_JSChartResource.FrameYLineDash);   //虚线
                        this.Canvas.beginPath();
                        this.Canvas.moveTo(left,yFixed);
                        this.Canvas.lineTo(right,yFixed);
                        this.Canvas.stroke();
                        this.Canvas.setLineDash([]);
                    }
                    else
                    {
                        this.Canvas.beginPath();
                        this.Canvas.moveTo(left,yFixed);
                        this.Canvas.lineTo(right,yFixed);
                        this.Canvas.stroke();
                    }
                }
            }
            
            var yText=y;
            if (y >= bottom - 2) 
            {
                this.Canvas.textBaseline = 'bottom';
            }
            else if (y <= top + 2) 
            {
                this.Canvas.textBaseline = 'top';
                yText+=this.YTextTopOffset;
            }
            else 
            {
                this.Canvas.textBaseline = "middle";
            }

            //坐标信息 左边 间距小于10 不画坐标
            this.Canvas.strokeStyle=item.TextColor;
            this.Canvas.fillStyle=item.TextColor;

            if (item.Message[0]!=null && isDrawLeft)
            {
                if (item.Font!=null) this.Canvas.font=item.Font;

                this.Canvas.textAlign="right";
                this.Canvas.fillText(item.Message[0],left-2,yText);
            }

            //坐标信息 右边 间距小于10 不画坐标
            if (item.Message[1]!=null && isDrawRight)
            {
                if (item.Font!=null) this.Canvas.font=item.Font;

                var xText=right;
                if (item.LineType==3)
                {
                    var lineLength=this.ShortYLineLength*GetDevicePixelRatio();
                    this.Canvas.beginPath();
                    this.Canvas.moveTo(xText,yFixed);
                    this.Canvas.lineTo(xText+lineLength,yFixed);
                    this.Canvas.stroke();

                    xText+=lineLength;
                }

                this.Canvas.textAlign="left";
                if (Array.isArray(item.Message[1]))
                {
                    if (this.MultiTextFormat==1)    //显示1行 格式:价格/百分比
                    {
                        if (item.ExtendData)
                        {
                            if (item.ExtendData.Font) this.Canvas.font=item.ExtendData.Font;
                        }
                            
                        var textData=
                        { 
                            Text:
                            [ 
                                {Text:item.Message[1][0], Width:this.Canvas.measureText(item.Message[1][0]).width },
                                {Text:item.Message[1][1], Width:this.Canvas.measureText(item.Message[1][1]).width } 
                            ],
                            X:xText+2,
                            Y:yText,
                            TextBaseline:this.Canvas.textBaseline,
                            Item:item
                        }
                        aryMultiText.push(textData);
                    }
                    else if (this.MultiTextFormat==2)   //显示2行
                    {
                        this.Canvas.fillText(item.Message[1][0],xText+2,yText);
                        var lineHeight=this.Canvas.measureText('M').width;
                        if (itemHeight>lineHeight*2) this.Canvas.fillText(item.Message[1][1],xText+2,yText+lineHeight);
                    }
                    else    //显示第1行
                    {
                        this.Canvas.fillText(item.Message[1][0],xText+2,yText);
                    }
                }
                else
                {
                    this.Canvas.fillText(item.Message[1],xText+2,yText);
                }
                
            }

            yPrev=y;
        }

        if (IFrameSplitOperator.IsNonEmptyArray(aryMultiText) && this.MultiTextFormat==1) this.DrawHorizontalMuText(aryMultiText)
    }

    this.DrawHorizontalMuText=function(aryText)
    {
        var maxWidth=[null,null];
        for(var i=0;i<aryText.length;++i)
        {
            var item=aryText[i];
            var width=item.Text[0].Width;
            if (!IFrameSplitOperator.IsNumber(maxWidth[0])) maxWidth[0]=width;
            else if (maxWidth[0]<width) maxWidth[0]=width;

            width=item.Text[1].Width;
            if (!IFrameSplitOperator.IsNumber(maxWidth[1])) maxWidth[1]=width;
            else if (maxWidth[1]<width) maxWidth[1]=width;
        }

        for(var i=0;i<aryText.length;++i)
        {
            var item=aryText[i];
            var message=item.Item;

            this.Canvas.textBaseline=message.TextBaseline;
            if (message.ExtendData && message.ExtendData.Font) this.Canvas.font=message.ExtendData.Font;
            else if (message.Font) this.Canvas.font=message.Font;

            if (message.ExtendData && message.ExtendData.PercentageColor) this.Canvas.fillStyle=message.ExtendData.PercentageColor;
            else this.Canvas.fillStyle=message.TextColor;

            this.Canvas.textAlign="right";
            var x=item.X+maxWidth[1];
            this.Canvas.fillText(item.Text[1].Text,x,item.Y);

            if (message.ExtendData && message.ExtendData.SplitColor) this.Canvas.fillStyle=message.ExtendData.SplitColor;
            else this.Canvas.fillStyle=message.TextColor;

            this.Canvas.textAlign="left";
            var splitWidth=this.Canvas.measureText('/').width;
            this.Canvas.fillText('/',x,item.Y);

            if (message.ExtendData && message.ExtendData.PriceColor) this.Canvas.fillStyle=message.ExtendData.PriceColor;
            else this.Canvas.fillStyle=message.TextColor;

            this.Canvas.textAlign="right";
            var x=item.X+maxWidth[1]+maxWidth[0]+splitWidth;
            this.Canvas.fillText(item.Text[0].Text,x,item.Y);

            var textWidth=maxWidth[1]+maxWidth[0]+splitWidth*4;
            if (this.RightTextMaxWidth<textWidth) this.RightTextMaxWidth=textWidth;
        }
    }

    //画Y轴Message[2,3]两个内部刻度
    this.DrawInsideClientHorizontal=function()
    {
        var border=this.GetBorder();
        if (border.DayBorder && IFrameSplitOperator.IsNonEmptyArray(border.DayBorder))
        {
            var item=border.DayBorder[0];
            var left=item.LeftEx;
            var item=border.DayBorder[border.DayBorder.length-1];
            var right=item.RightEx;
            var bottom=border.Bottom;
            var top=border.TopTitle;
        }
        else
        {
            var left=border.LeftEx;
            var right=border.RightEx;
            var bottom=border.Bottom;
            var top=border.TopTitle;
        }
       

        var pixelTatio = GetDevicePixelRatio();
        var yPrev = null; //上一个坐标y的值
        var yInsideText=null;
        for (var i = this.HorizontalInfo.length - 1; i >= 0; --i)  //从上往下画分割线
        {
            var item = this.HorizontalInfo[i];
            var y = this.GetYFromData(item.Value);
            if (y != null && yPrev!=null && Math.abs(y - yPrev) < this.MinYDistance) continue;  //两个坐标在近了 就不画了

            if (item.Message[2]) 
            {
                if (item.Font != null) this.Canvas.font = item.Font;
                this.Canvas.fillStyle = item.TextColor;
                this.Canvas.textAlign = "left";
                var yText=y;
                if (y >= bottom - 2) 
                {
                    this.Canvas.textBaseline = 'bottom';
                }
                else if (y <= top + 2) 
                {
                    this.Canvas.textBaseline = 'top';
                    yText+=this.YTextTopOffset;
                }
                else 
                {
                    this.Canvas.textBaseline = "middle";
                }

                var textObj={ X:left, Y:yText, Text:{ BaseLine:this.Canvas.textBaseline, TextAlign: this.Canvas.textAlign, Font:this.Canvas.font, Value:item.Message[0]}} ;
                if (!this.IsOverlayMaxMin || !this.IsOverlayMaxMin(textObj))
                {
                    this.Canvas.fillText(item.Message[2], left + 1*pixelTatio, yText);
                    if (yInsideText==null || yInsideText>yText)
                    {
                        this.YInsideOffset=this.Canvas.measureText(item.Message[2]).width+4*GetDevicePixelRatio();
                        yInsideText=yText;
                    }
                        
                }
            }

            if (item.Message[3])
            {
                if (item.Font != null) this.Canvas.font = item.Font;
                this.Canvas.fillStyle = item.TextColor;
                this.Canvas.textAlign = "right";
                var yText=y;
                if (y >= bottom - 2) 
                {
                    this.Canvas.textBaseline = 'bottom';
                }
                else if (y <= top + 2) 
                {
                    this.Canvas.textBaseline = 'top';
                    yText+=this.YTextTopOffset;
                }
                else 
                {
                    this.Canvas.textBaseline = "middle";
                }
                var textWidth = this.Canvas.measureText(item.Message[3]).width;
                var textObj={ X:right-textWidth, Y:yText, Text:{ BaseLine:this.Canvas.textBaseline, TextAlign: this.Canvas.textAlign, Font:this.Canvas.font, Value:item.Message[1]}} ;
                if (!this.IsOverlayMaxMin || !this.IsOverlayMaxMin(textObj))
                    this.Canvas.fillText(item.Message[3], right - 1*pixelTatio, yText);
            }
            yPrev = y;
        }
    }

    //Y刻度画在左边内部
    this.DrawInsideHorizontal = function () 
    {
        if (this.IsHScreen===true) return;  //横屏不画
        if (this.IsShowYText[0]===false && this.IsShowYText[1]===false) return;

        this.DrawInsideClientHorizontal();

        var border=this.ChartBorder.GetBorder();

        var left = border.Left
        var right = border.Right;
        var bottom = border.Bottom;
        var top = border.TopTitle;
        var borderRight = this.ChartBorder.Right;
        var borderLeft = this.ChartBorder.Left;
        var titleHeight = this.ChartBorder.TitleHeight;

        var isDrawLeft= (borderLeft<10 || this.YTextPosition[0]==2) && this.IsShowYText[0]===true;
        var isDrawRight= (borderRight<10 || this.YTextPosition[1]==2) && this.IsShowYText[1]===true;

        if ( isDrawLeft || isDrawRight )
        {
            var pixelTatio = GetDevicePixelRatio();
            var yPrev = null; //上一个坐标y的值
            var yInsideText=null;
            for (var i = this.HorizontalInfo.length - 1; i >= 0; --i)  //从上往下画分割线
            {
                var item = this.HorizontalInfo[i];
                var y = this.GetYFromData(item.Value);
                if (y != null && yPrev!=null && Math.abs(y - yPrev) < this.MinYDistance) continue;  //两个坐标在近了 就不画了

                //坐标信息 左边 间距小于10 画在内部
                if (item.Message[0] != null && isDrawLeft) 
                {
                    if (item.Font != null) this.Canvas.font = item.Font;
                    this.Canvas.fillStyle = item.TextColor;
                    this.Canvas.textAlign = "left";
                    var yText=y;
                    if (y >= bottom - 2) 
                    {
                        this.Canvas.textBaseline = 'bottom';
                    }
                    else if (y <= top + 2) 
                    {
                        this.Canvas.textBaseline = 'top';
                        yText+=this.YTextTopOffset;
                    }
                    else 
                    {
                        if (this.YTextBaseline==1) this.Canvas.textBaseline = "bottom";
                        else this.Canvas.textBaseline = "middle";
                    }

                    var textObj={ X:left, Y:yText, Text:{ BaseLine:this.Canvas.textBaseline, TextAlign: this.Canvas.textAlign, Font:this.Canvas.font, Value:item.Message[0]}} ;
                    if (!this.IsOverlayMaxMin || !this.IsOverlayMaxMin(textObj))
                    {
                        this.Canvas.fillText(item.Message[0], left + 1*pixelTatio, yText);
                        if (yInsideText==null || yInsideText>yText)
                        {
                            this.YInsideOffset=this.Canvas.measureText(item.Message[0]).width+4*GetDevicePixelRatio();
                            yInsideText=yText;
                        }
                            
                    }
                }

                if (item.Message[1] != null && isDrawRight)
                {
                    if (item.Font != null) this.Canvas.font = item.Font;
                    this.Canvas.fillStyle = item.TextColor;
                    this.Canvas.textAlign = "right";
                    var yText=y;
                    if (y >= bottom - 2) 
                    {
                        this.Canvas.textBaseline = 'bottom';
                    }
                    else if (y <= top + 2) 
                    {
                        this.Canvas.textBaseline = 'top';
                        yText+=this.YTextTopOffset;
                    }
                    else 
                    {
                        if (this.YTextBaseline==1) this.Canvas.textBaseline = "bottom";
                        else this.Canvas.textBaseline = "middle";
                    }
                    
                    if (Array.isArray(item.Message[1])) var text=item.Message[1][0];
                    else var text=item.Message[1];

                    var textWidth = this.Canvas.measureText(text).width;
                    var textObj={ X:right-textWidth, Y:yText, Text:{ BaseLine:this.Canvas.textBaseline, TextAlign: this.Canvas.textAlign, Font:this.Canvas.font, Value:item.Message[1]}} ;
                    if (!this.IsOverlayMaxMin || !this.IsOverlayMaxMin(textObj))
                        this.Canvas.fillText(text, right - 1*pixelTatio, yText);
                }
                yPrev = y;
            }
        }
    }

    this.GetXFromIndex=function(index)
    {
        var count=this.XPointCount;

        if (count==1)
        {
            if (index==0) return this.ChartBorder.GetLeft();
            else return this.ChartBorder.GetRight();
        }
        else if (count<=0)
        {
            return this.ChartBorder.GetLeft();
        }
        else if (index>=count)
        {
            return this.ChartBorder.GetRight();
        }
        else
        {
            var offset=this.ChartBorder.GetLeft()+this.ChartBorder.GetWidth()*index/count;
            return offset;
        }
    }

    //画X轴
    this.DrawVertical=function()
    {
        var border=this.GetBorder();
        var top=border.TopTitle;
        var bottom=border.Bottom;
        var right=border.RightEx;
        var pixelRatio = GetDevicePixelRatio(); //获取设备的分辨率
        //JSConsole.Chart.Log('[AverageWidthFrame.DrawVertical] bottom',bottom);
        if (this.ChartBorder.Bottom<=5*GetDevicePixelRatio()) return;   //高度不够 不显示

        var xPrev=null; //上一个坐标x的值
        var textRightPrev=null; //上一次刻度输出右边x坐标
        for(var i in this.VerticalInfo)
        {
            var x=this.GetXFromIndex(this.VerticalInfo[i].Value);
            if (x>right) break;
            if (xPrev!=null && Math.abs(x-xPrev)<this.MinXDistance) continue;
            
            var item=this.VerticalInfo[i];
            var xFixed=ToFixedPoint(x);
            if (this.IsShowXLine)
            {
                if (item.LineType==2)   //虚线
                {
                    this.Canvas.strokeStyle=this.VerticalInfo[i].LineColor;
                    this.Canvas.setLineDash([5*pixelRatio,5*pixelRatio]);   
                    this.Canvas.beginPath();
                    this.Canvas.moveTo(xFixed,top);
                    this.Canvas.lineTo(xFixed,bottom);
                    this.Canvas.stroke();
                    this.Canvas.setLineDash([]);
                }
                else if (item.LineType==3)
                {

                }
                else if (item.LineType>0)   //实线
                {
                    if (g_JSChartResource.FrameXLineDash)
                    {
                        this.Canvas.strokeStyle=this.VerticalInfo[i].LineColor;
                        this.Canvas.setLineDash(g_JSChartResource.FrameXLineDash);   //虚线
                        this.Canvas.beginPath();
                        this.Canvas.moveTo(xFixed,top);
                        this.Canvas.lineTo(xFixed,bottom);
                        this.Canvas.stroke();
                        this.Canvas.setLineDash([]);
                    }
                    else
                    {
                        this.Canvas.strokeStyle=this.VerticalInfo[i].LineColor;
                        this.Canvas.beginPath();
                        this.Canvas.moveTo(xFixed,top);
                        this.Canvas.lineTo(xFixed,bottom);
                        this.Canvas.stroke();
                    }
                }
            }
            

            if (this.VerticalInfo[i].Message[0]!=null)
            {
                if (this.VerticalInfo[i].Font!=null)
                    this.Canvas.font=this.VerticalInfo[i].Font;
                
                var textLeft=0;
                this.Canvas.fillStyle=item.TextColor;
                this.Canvas.strokeStyle=item.TextColor;
                var testWidth=this.Canvas.measureText(this.VerticalInfo[i].Message[0]).width;
                if (x<testWidth/2)
                {
                    this.Canvas.textAlign="left";
                    this.Canvas.textBaseline="top";
                    textLeft=x;
                }
                else if ((x + testWidth / 2) >= this.ChartBorder.GetChartWidth())
                {
                    this.Canvas.textAlign = "right";
                    this.Canvas.textBaseline="top";
                    textLeft=x-testWidth;
                }
                else
                {
                    this.Canvas.textAlign="center";
                    this.Canvas.textBaseline="top";
                    textLeft=x-(testWidth/2);
                }
                
                if (textRightPrev==null || textLeft>textRightPrev)
                {
                    var yText=bottom;
                    if (item.LineType==3)
                    {
                        var lineLength=this.ShortXLineLength*pixelRatio;
                        this.Canvas.beginPath();
                        this.Canvas.moveTo(xFixed,yText);
                        this.Canvas.lineTo(xFixed,yText+lineLength);
                        this.Canvas.stroke();

                        yText+=lineLength+2*pixelRatio;
                    }

                    this.Canvas.fillText(this.VerticalInfo[i].Message[0],x,yText+this.XBottomOffset);
                    textRightPrev=textLeft+testWidth;
                }
            }

            xPrev=x;
        }
    }

    //Y坐标转y轴数值
    this.GetYData=function(y,isLimit)
    {
        if (this.Logarithmic && this.GetYLogarithmicFromData)
        {
            return this.GetYLogarithmicData(y);
        }

        if (this.CoordinateType==1) //反转坐标
        {
            if (isLimit==false)
            {
                return (y-this.ChartBorder.GetTopEx())/this.ChartBorder.GetHeightEx()*(this.HorizontalMax-this.HorizontalMin)+this.HorizontalMin;
            }
            else
            {
                if (y<this.ChartBorder.GetTopEx()) return this.HorizontalMin;
                if (y>this.ChartBorder.GetBottomEx()) return this.HorizontalMax;
    
                return (y-this.ChartBorder.GetTopEx())/this.ChartBorder.GetHeightEx()*(this.HorizontalMax-this.HorizontalMin)+this.HorizontalMin;
            }
        }
        else
        {
            if (isLimit==false)
            {
                return (this.ChartBorder.GetBottomEx()-y)/this.ChartBorder.GetHeightEx()*(this.HorizontalMax-this.HorizontalMin)+this.HorizontalMin;
            }
            else
            {
                if (y<this.ChartBorder.GetTopEx()) return this.HorizontalMax;
                if (y>this.ChartBorder.GetBottomEx()) return this.HorizontalMin;
    
                return (this.ChartBorder.GetBottomEx()-y)/this.ChartBorder.GetHeightEx()*(this.HorizontalMax-this.HorizontalMin)+this.HorizontalMin;
            }
        }
    }

    //X坐标转x轴数值
    this.GetXData=function(x)
    {
        if (x<=this.ChartBorder.GetLeft()) return 0;
		if (x>=this.ChartBorder.GetRight()) return this.XPointCount;

		return (x-this.ChartBorder.GetLeft())*(this.XPointCount*1.0/this.ChartBorder.GetWidth());
    }

    this.DrawCustomItem=function(item) //显示自定义刻度
    {
        //if (this.IsHScreen===true) return;  //横屏不画
        if (!item.Message[1] && !item.Message[0]) return;
        if (item.Value>this.HorizontalMax || item.Value<this.HorizontalMin) return;

        var left = this.ChartBorder.GetLeft();
        var right = this.ChartBorder.GetRight();
        var bottom = this.ChartBorder.GetBottom();
        var top = this.ChartBorder.GetTopTitle();
        var borderRight = this.ChartBorder.Right;
        var borderLeft = this.ChartBorder.Left;
        var titleHeight = this.ChartBorder.TitleHeight;

        if (this.IsHScreen)
        {
            borderLeft=this.ChartBorder.Top;
            borderRight=this.ChartBorder.Bottom;
            top=this.ChartBorder.GetTop();
            bottom=this.ChartBorder.GetBottom();
        }

        var pixelTatio = GetDevicePixelRatio();
        var defaultTextHeight=18*pixelTatio;
        var textHeight=defaultTextHeight;
        
        var y = this.GetYFromData(item.Value);

        if (item.Message[0])    // 左
        {
            if (borderLeft<10)
            {
                if (item.Font != null) this.Canvas.font = item.Font;
                this.Canvas.textAlign = "left";
                this.Canvas.textBaseline = "middle";
                var textWidth = this.Canvas.measureText(item.Message[0]).width+2*pixelTatio;
                var fontHeight=this.GetFontHeight();
                textHeight=fontHeight>defaultTextHeight? fontHeight:defaultTextHeight;
                var bgColor=item.LineColor;
                var rgb=this.RGBToStruct(item.LineColor);
                if (rgb) bgColor=`rgba(${rgb.R}, ${rgb.G}, ${rgb.B}, ${g_JSChartResource.FrameLatestPrice.BGAlpha})`;   //内部刻度 背景增加透明度
                this.Canvas.fillStyle=bgColor;

                if (this.IsHScreen)
                {
                    var bgTop=top;
                    var textLeft=y-textHeight/2-1*pixelTatio;
                    this.Canvas.fillRect(textLeft,bgTop,textHeight,textWidth);
                    this.DrawHScreenText({X:y, Y:bgTop}, {Text:item.Message[0], Color:item.TextColor, XOffset:1*pixelTatio, YOffset:2*pixelTatio});
                    this.DrawLine(bgTop+textWidth,bottom,y,item.LineColor,item.LineType);
                }
                else
                {
                    var bgTop=y-textHeight/2-1*pixelTatio;
                    var textLeft=left + 1*pixelTatio
                    this.Canvas.fillRect(textLeft,bgTop,textWidth,textHeight);
                    this.Canvas.fillStyle = item.TextColor;
                    this.Canvas.fillText(item.Message[0], textLeft + 1*pixelTatio, y);
                    this.DrawLine(textLeft+textWidth,right,y,item.LineColor,item.LineType);
                }
            }
            else
            {
                if (item.Font != null) this.Canvas.font = item.Font;
                this.Canvas.textAlign = "right";
                this.Canvas.textBaseline = "middle";
                var textWidth = this.Canvas.measureText(item.Message[0]).width+2*pixelTatio;
                var fontHeight=this.GetFontHeight();
                textHeight=fontHeight>defaultTextHeight? fontHeight:defaultTextHeight;
                this.Canvas.fillStyle=item.LineColor;
                if (this.IsHScreen)
                {
                    var bgTop=top-textWidth;
                    var textLeft=y-textHeight/2-1*pixelTatio;
                    this.Canvas.fillRect(textLeft,bgTop,textHeight,textWidth);
                    this.DrawHScreenText({X:y, Y:bgTop}, {Text:item.Message[0], Color:item.TextColor, XOffset:1*pixelTatio, YOffset:2*pixelTatio});
                    this.DrawLine(bgTop+textWidth,bottom,y,item.LineColor,item.LineType);
                }
                else
                {
                    var bgTop=y-textHeight/2-1*pixelTatio;
                    this.Canvas.fillRect(left-textWidth,bgTop,textWidth,textHeight);
                    this.Canvas.fillStyle = item.TextColor;
                    this.Canvas.fillText(item.Message[0], left - 1*pixelTatio, y);
                    this.DrawLine(left,right,y,item.LineColor,item.LineType);
                }
            }
        }
        else if (item.Message[1])   //右
        {
            if (borderRight<10)
            {
                if (item.Font != null) this.Canvas.font = item.Font;
                this.Canvas.textAlign = "left";
                this.Canvas.textBaseline = "middle";
                var textWidth = this.Canvas.measureText(item.Message[1]).width+2*pixelTatio;
                var fontHeight=this.GetFontHeight();
                textHeight=fontHeight>defaultTextHeight? fontHeight:defaultTextHeight;
                var bgColor=item.LineColor;
                var rgb=this.RGBToStruct(item.LineColor);
                if (rgb) bgColor=`rgba(${rgb.R}, ${rgb.G}, ${rgb.B}, ${g_JSChartResource.FrameLatestPrice.BGAlpha})`;   //内部刻度 背景增加透明度
                this.Canvas.fillStyle=bgColor;
                if (this.IsHScreen)
                {
                    var bgTop=bottom-textWidth;
                    var textLeft=y-textHeight/2-1*pixelTatio;
                    this.Canvas.fillRect(textLeft,bgTop,textHeight,textWidth);
                    this.DrawHScreenText({X:y, Y:bgTop}, {Text:item.Message[1], Color:item.TextColor, XOffset:1*pixelTatio, YOffset:2*pixelTatio});
                    this.DrawLine(top,bgTop,y,item.LineColor,item.LineType);
                }
                else
                {
                    var bgTop=y-textHeight/2-1*pixelTatio;
                    var textLeft=right-textWidth;
                    this.Canvas.fillRect(textLeft,bgTop,textWidth,textHeight);  //文本背景区域
                    this.Canvas.fillStyle = item.TextColor;
                    this.Canvas.fillText(item.Message[1], textLeft + 1*pixelTatio, y);
                    this.DrawLine(left,textLeft,y,item.LineColor,item.LineType);
                }
            }
            else
            {
                if (item.Font != null) this.Canvas.font = item.Font;
                this.Canvas.textAlign = "left";
                this.Canvas.textBaseline = "middle";
                var textWidth = this.Canvas.measureText(item.Message[1]).width+2*pixelTatio;
                var fontHeight=this.GetFontHeight();
                textHeight=fontHeight>defaultTextHeight? fontHeight:defaultTextHeight;
                this.Canvas.fillStyle=item.LineColor;
                if (this.IsHScreen)
                {
                    var bgTop=bottom;
                    var textLeft=y-textHeight/2-1*pixelTatio;
                    this.Canvas.fillRect(textLeft,bgTop,textHeight,textWidth);
                    this.DrawHScreenText({X:y, Y:bgTop}, {Text:item.Message[1], Color:item.TextColor, XOffset:1*pixelTatio, YOffset:2*pixelTatio});
                    this.DrawLine(top,bgTop,y,item.LineColor,item.LineType);
                }
                else
                {
                    var bgTop=y-textHeight/2-1*pixelTatio;
                    this.Canvas.fillRect(right,bgTop,textWidth,textHeight);
                    this.Canvas.fillStyle = item.TextColor;
                    this.Canvas.fillText(item.Message[1], right + 1*pixelTatio, y);
                    this.DrawLine(left,right,y,item.LineColor,item.LineType);
                }
            }
        }
    }

    this.DrawDotLine=function(left,right,y, color)
    {
        var pixelTatio = GetDevicePixelRatio();
        this.Canvas.save();
        this.Canvas.strokeStyle=color;
        this.Canvas.setLineDash([5*pixelTatio,5*pixelTatio]);   //虚线
        this.Canvas.beginPath();
        if (this.IsHScreen)
        {
            this.Canvas.moveTo(ToFixedPoint(y),left);
            this.Canvas.lineTo(ToFixedPoint(y),right);
        }
        else
        {
            this.Canvas.moveTo(left,ToFixedPoint(y));
            this.Canvas.lineTo(right,ToFixedPoint(y));
        }
        this.Canvas.stroke();
        this.Canvas.restore();
    }

    this.DrawLine=function(left,right,y, color,lineType)
    {
        if (lineType==-1) return;

        if (lineType==0)
        {
            this.Canvas.strokeStyle=color;
            this.Canvas.beginPath();
            if (this.IsHScreen)
            {
                this.Canvas.moveTo(ToFixedPoint(y),left);
                this.Canvas.lineTo(ToFixedPoint(y),right);
            }
            else
            {
                this.Canvas.moveTo(left,ToFixedPoint(y));
                this.Canvas.lineTo(right,ToFixedPoint(y));
            }
            this.Canvas.stroke();
        }
        else
        {
            this.DrawDotLine(left,right,y, color);
        }
    }

    this.DrawHScreenText=function(center,data)
    {
        this.Canvas.textAlign = "left";
        this.Canvas.textBaseline = "middle";
        this.Canvas.fillStyle = data.Color;

        this.Canvas.save();
        this.Canvas.translate(center.X, center.Y);
        this.Canvas.rotate(90 * Math.PI / 180);
        this.Canvas.fillText(data.Text, data.XOffset, data.YOffset);
        this.Canvas.restore();
    }

    this.RGBToStruct=function(rgb)
    {
        if(/^(rgb|RGB)/.test(rgb))
        {
            var aColor = rgb.replace(/(?:\(|\)|rgb|RGB)*/g,"").split(",");
            var result={};
            if (aColor.length!=3) return null;

            result.R = Number(aColor[0]);
            result.G = Number(aColor[1]);
            result.B = Number(aColor[2]);
            return result;
        }
       
        return null;
    }
}

function MinuteFrame()
{
    this.newMethod=AverageWidthFrame;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName="MinuteFrame";
    this.DataWidth=1*GetDevicePixelRatio();
    this.DistanceWidth=1*GetDevicePixelRatio();
    this.MinuteCount=243;   //每天的分钟个数
    this.BeforeBGColor=g_JSChartResource.Minute.Before.BGColor;  //集合竞价背景
    this.MultiDayBorderPen=g_JSChartResource.FrameBorderPen;
    this.CustomHorizontalInfo=[];
    this.RightFrame=null;   //右侧多重坐标
    this.ToolbarID=Guid();  //工具条Div id
    this.ReDrawToolbar=false;
    this.DayCount=1;        //显示天数

    this.ModifyIndex=true;      //是否显示'改参数'菜单
    this.ChangeIndex=true;      //是否显示'换指标'菜单
    this.CloseIndex=true;       //是否显示'关闭指标窗口'菜单

    this.ModifyIndexEvent;   //改参数 点击事件
    this.ChangeIndexEvent;   //换指标 点击事件
    this.ToolbarRect=null;   //保存工具条的位置
    this.IsShowPositionTitle=false; //是否显示持仓标题

    this.LastCalculateStatus={ Width:0, XPointCount:0 };    //最后一次计算宽度的状态
    this.BeforeCloseIcon=
    {
        Family:g_JSChartResource.Minute.Before.CloseIcon.Family,
        Text:g_JSChartResource.Minute.Before.CloseIcon.Text,
        Color:g_JSChartResource.Minute.Before.CloseIcon.Color,
        Size:g_JSChartResource.Minute.Before.CloseIcon.Size
    };

    this.BeforeOpenVerticalInfo=[];      //盘前集合竞价X轴
    this.AfterCloseVerticalInfo=[];      //收盘集合竞价X轴

    this.DrawFrame=function()
    {
        this.SplitXYCoordinate();

        this.DrawBeforeDataBG();

        this.YInsideOffset=0;
        this.DrawTitleBG();
        this.DrawHorizontal();
        this.DrawVertical();

        if (this.SizeChange==true || this.ReDrawToolbar==true) 
        {
            this.DrawToolbar();  //大小变动才画工具条
            this.ReDrawToolbar=false;
        }
    }

    //画边框
    this.SuperDrawBorder=this.DrawBorder;
    this.DrawBorder=function()
    {
        if (!this.IsShowBorder) return;
        this.SuperDrawBorder();

        if (this.Identify==1)   //走势图和成交量中间用粗线分割开
        {
            var border=this.ChartBorder.GetBorder();
            var left=ToFixedPoint(border.Left);
            var top=ToFixedPoint(border.Top);
            var right=ToFixedPoint(border.Right);
    
            this.Canvas.strokeStyle=this.PenBorder;
            this.Canvas.beginPath();
            this.Canvas.moveTo(left,top);
            this.Canvas.lineTo(right,top);
            this.Canvas.save();
            this.Canvas.lineWidth=2 * GetDevicePixelRatio();
            this.Canvas.stroke();
            this.Canvas.restore();
        }
    }

    this.DrawVolTitle=function(symbol)
    {
        if (!MARKET_SUFFIX_NAME.IsShowMinuteVolTitle(symbol)) return;

        if (this.Identify==1)   //显示"成交量"
        {
            var pixelRatio=GetDevicePixelRatio();
            var left=this.ChartBorder.GetLeft()+2*pixelRatio+this.YInsideOffset;

            var top=this.ChartBorder.GetTopEx()+2*pixelRatio;

            this.Canvas.textAlign='left';
            this.Canvas.textBaseline='top';
            if (g_JSChartResource.Minute.VolBarColor || g_JSChartResource.Minute.VolTitleColor)
            {
                if (g_JSChartResource.Minute.VolBarColor) this.Canvas.fillStyle=g_JSChartResource.Minute.VolBarColor
                else this.Canvas.fillStyle=g_JSChartResource.Minute.VolTitleColor;
                var languageID=this.YSplitOperator.LanguageID;
                var text=g_JSChartLocalization.GetText('MVol-Vol',languageID);
                this.Canvas.fillText(text,left,top);
                left+=this.Canvas.measureText(text).width;
                left+=6*GetDevicePixelRatio();
            }
            
            if (this.IsShowPositionTitle)
            {
                text=g_JSChartLocalization.GetText('MVol-Position',languageID);
                this.Canvas.fillStyle=g_JSChartResource.Minute.PositionColor;
                this.Canvas.fillText(text,left,top);
            }
        }
    }

    this.DrawToolbar=function()
    {
        if (this.Identify<2) return;
        if (!this.ChartBorder.UIElement) return;

        var divToolbar=document.getElementById(this.ToolbarID);
        if (divToolbar && this.SizeChange==false && this.ReDrawToolbar==false) return;

        if (!divToolbar)
        {
            divToolbar=document.createElement("div");
            divToolbar.className='klineframe-toolbar';
            divToolbar.id=this.ToolbarID;
            divToolbar.oncontextmenu = function() { return false;}; //屏蔽右键系统菜单
            //为divToolbar添加属性identify
            divToolbar.setAttribute("identify",this.Identify.toString());
            this.ChartBorder.UIElement.parentNode.appendChild(divToolbar);
        }

        if (!this.ModifyIndex && !this.ChangeIndex && !this.OverlayIndex)
        {
            if (divToolbar.style.display!='none')
                divToolbar.style.display='none';
            return;
        }

        //使用外城div尺寸 画图尺寸是被放大的
        var pixelTatio = GetDevicePixelRatio();
        var chartWidth=parseInt(this.ChartBorder.UIElement.parentElement.style.width.replace("px",""));  
        var chartHeight=parseInt(this.ChartBorder.UIElement.parentElement.style.height.replace("px",""));
        //JSConsole.Chart.Log('[KLineFrame::DrawToolbar] ',chartWidth,chartHeight,pixelTatio);

        var toolbarWidth=100;
        var toolbarHeight=this.ChartBorder.GetTitleHeight();
        var left=chartWidth-(this.ChartBorder.Right/pixelTatio)-toolbarWidth;
        var top=this.ChartBorder.GetTop()/pixelTatio;

        if (this.ToolbarRect)
        {
            //尺寸变动移动才重新设置DOM
            if (this.ToolbarRect.Left==left && this.ToolbarRect.Top==top && 
                this.ToolbarRect.Width==toolbarWidth && this.ToolbarRect.Height==toolbarHeight/pixelTatio)
            {
                return;
            }
        }

        this.ToolbarRect={ Left:left, Top:top, Width:toolbarWidth, Height:toolbarHeight/pixelTatio };

        const modifyButton=`<span class='index_param icon iconfont icon-index_param' id='modifyindex' style='cursor:pointer;margin-left:2px;margin-right:2px;' title='调整指标参数'></span>`;
        const changeButton=`<span class='index_change icon iconfont icon-change_index' id='changeindex' style='cursor:pointer;margin-left:2px;margin-right:2px;' title='切换指标'></span>`;
        const closeButton=`<span class='index_close icon iconfont icon-close' id='closeindex' style='cursor:pointer;margin-left:2px;margin-right:2px;' title='关闭指标窗口'></span>`;

        var spanIcon=modifyButton+changeButton;
        if (this.CloseIndex)
        {
            spanIcon+=closeButton;
        }

        //var scrollPos=GetScrollPosition();
        //left = left+scrollPos.Left;
        //top = top+scrollPos.Top;
        divToolbar.style.left = left + "px";
        divToolbar.style.top = top + "px";
        divToolbar.style.width=toolbarWidth+"px";                   //宽度先不调整吧
        divToolbar.style.height=(toolbarHeight/pixelTatio)+'px';    //只调整高度
        divToolbar.innerHTML=spanIcon;

        var chart=this.ChartBorder.UIElement.JSChartContainer;
        var identify=this.Identify;
        if (!this.ModifyIndex)  //隐藏'改参数'
            $("#"+divToolbar.id+" .index_param").hide();
        else if (typeof(this.ModifyIndexEvent)=='function')  //绑定点击事件
            $("#"+divToolbar.id+" .index_param").click(
                {
                    Chart:this.ChartBorder.UIElement.JSChartContainer,
                    Identify:this.Identify
                },this.ModifyIndexEvent);

        if (!this.ChangeIndex)  //隐藏'换指标'
        {
            $("#"+divToolbar.id+" .index_change").hide();
        }  
        else if (typeof(this.ChangeIndexEvent)=='function')
        {
            $("#"+divToolbar.id+" .index_change").click(
                {
                    Chart:this.ChartBorder.UIElement.JSChartContainer,
                    Identify:this.Identify,
                    IsOverlay:false
                },this.ChangeIndexEvent);
        }

        $("#"+divToolbar.id+" .index_close").click(
            {
                Chart:this.ChartBorder.UIElement.JSChartContainer,
                Identify:this.Identify
            },
            function(event)
            {
                var hqChart=event.data.Chart;
                var id=event.data.Identify;
                hqChart.RemoveIndexWindow(id);
            });

        divToolbar.style.display = "block";
    }

    this.ClearToolbar=function()
    {
        var divToolbar=document.getElementById(this.ToolbarID);
        if (!divToolbar) return;
        this.ChartBorder.UIElement.parentNode.removeChild(divToolbar);
    }

    this.DrawMultiDayBeforeDataBG=function(border)
    {
        var dayBorder=border.DayBorder;
        var top=ToFixedPoint(border.Top);
        var bottom=ToFixedPoint(border.Bottom);
        var height=bottom-top;
        this.Canvas.fillStyle=this.BeforeBGColor;
        this.Canvas.strokeStyle=this.MultiDayBorderPen;
        for(var i in dayBorder)
        {
            var drawCount=0;
            var item=dayBorder[i];
            var left=ToFixedPoint(item.Left);
            var right=ToFixedPoint(item.LeftEx);
            var width=right-left;
            if (width>3) 
            {
                this.Canvas.fillRect(left,top,width,height);
                ++drawCount;
            }

            var left=ToFixedPoint(item.RightEx);
            var right=ToFixedPoint(item.Right);
            var width=right-left;
            if (width>3) 
            {
                this.Canvas.fillRect(left,top,width,height);
                ++drawCount;
            }

            if (drawCount==2 && i!=dayBorder.length-1)
            {
                this.Canvas.beginPath();
                this.Canvas.moveTo(right,top);
                this.Canvas.lineTo(right,bottom);
                this.Canvas.stroke();
            }
        }
    }

    this.DrawCallAuctionVertical=function(verticalInfo, callAuctionData, border, isBeforeClose)
    {
        if (!callAuctionData) return;

        var top=border.TopTitle;
        var bottom=border.Bottom;
        var left=border.Left;
        var right=border.LeftEx;
        var pixelRatio = GetDevicePixelRatio(); //获取设备的分辨率

        var xPrev=null;         //上一个坐标x的值
        var textRightPrev=null; //上一次刻度输出右边x坐标

        for(var i in verticalInfo)
        {
            var item=verticalInfo[i];
            var x=this.GetLeftExtendXFromIndex(item.Value,callAuctionData);
            if (x>right) break;
            if (xPrev!=null && Math.abs(x-xPrev)<this.MinXDistance) continue;
            
            var xFixed=ToFixedPoint(x);
            if (this.IsShowXLine)
            {
                if (item.LineType==2)   //虚线
                {
                    this.Canvas.strokeStyle=item.LineColor;
                    this.Canvas.setLineDash([5*pixelRatio,5*pixelRatio]);   
                    this.Canvas.beginPath();
                    this.Canvas.moveTo(xFixed,top);
                    this.Canvas.lineTo(xFixed,bottom);
                    this.Canvas.stroke();
                    this.Canvas.setLineDash([]);
                }
                else if (item.LineType==3)
                {

                }
                else if (item.LineType>0)   //实线
                {
                    if (g_JSChartResource.FrameXLineDash)
                    {
                        this.Canvas.strokeStyle=item.LineColor;
                        this.Canvas.setLineDash(g_JSChartResource.FrameXLineDash);   //虚线
                        this.Canvas.beginPath();
                        this.Canvas.moveTo(xFixed,top);
                        this.Canvas.lineTo(xFixed,bottom);
                        this.Canvas.stroke();
                        this.Canvas.setLineDash([]);
                    }
                    else
                    {
                        this.Canvas.strokeStyle=item.LineColor;
                        this.Canvas.beginPath();
                        this.Canvas.moveTo(xFixed,top);
                        this.Canvas.lineTo(xFixed,bottom);
                        this.Canvas.stroke();
                    }
                }
            }
            

            if (item.Message[0]!=null && this.ChartBorder.Bottom>5*pixelRatio)
            {
                if (item.Font!=null) this.Canvas.font=item.Font;
                
                var textLeft=0;
                this.Canvas.fillStyle=item.TextColor;
                this.Canvas.strokeStyle=item.TextColor;
                var testWidth=this.Canvas.measureText(item.Message[0]).width;
                if (x<testWidth/2)
                {
                    this.Canvas.textAlign="left";
                    this.Canvas.textBaseline="top";
                    textLeft=x;
                }
                else if ((x + testWidth / 2) >= border.ChartWidth)
                {
                    this.Canvas.textAlign = "right";
                    this.Canvas.textBaseline="top";
                    textLeft=x-testWidth;
                }
                else
                {
                    this.Canvas.textAlign="center";
                    this.Canvas.textBaseline="top";
                    textLeft=x-(testWidth/2);
                }
                
                if (textRightPrev==null || textLeft>textRightPrev)
                {
                    var yText=bottom;
                    if (item.LineType==3)
                    {
                        var lineLength=this.ShortXLineLength*pixelRatio;
                        this.Canvas.beginPath();
                        this.Canvas.moveTo(xFixed,yText);
                        this.Canvas.lineTo(xFixed,yText+lineLength);
                        this.Canvas.stroke();

                        yText+=lineLength+2*pixelRatio;
                    }

                    this.Canvas.fillText(item.Message[0],x,yText+this.XBottomOffset);
                    textRightPrev=textLeft+testWidth;
                }
            }

            xPrev=x;
        }
    }

    //画集合竞价背景
    this.DrawBeforeDataBG=function()
    {
        var border=this.ChartBorder.GetBorder();
        if (border.DayBorder)
        {
            this.DrawMultiDayBeforeDataBG(border);
            return;
        }

        if (this.ChartBorder.LeftExtendWidth<10 && this.ChartBorder.RightExtendWidth<10) return;
        //if (this.Identify>=2) return;

        var top=ToFixedPoint(border.Top);
        var bottom=ToFixedPoint(border.Bottom);
        this.Canvas.fillStyle=this.BeforeBGColor;

        if (this.ChartBorder.LeftExtendWidth>10)
        {
            var left=ToFixedPoint(border.Left);
            var right=ToFixedPoint(this.ChartBorder.GetLeft());
            var width=right-left;
            var height=bottom-top;
            
            this.Canvas.fillRect(left,top,width,height);

            //绘制关闭图标
            if (this.Identify==0)
            {
                this.Canvas.font=this.BeforeCloseIcon.Size+'px '+this.BeforeCloseIcon.Family;
                this.Canvas.fillStyle=this.BeforeCloseIcon.Color;
                this.Canvas.textAlign = 'left';
                this.Canvas.textBaseline='top';
                this.Canvas.fillText(this.BeforeCloseIcon.Text,border.Left,border.TopEx);

                var rect={ Left:border.Left, Top:border.TopEx, Width:this.BeforeCloseIcon.Size, Height:this.BeforeCloseIcon.Size };
                this.Buttons.push( { Rect:rect, Name:"集合竞价关闭按钮" , ID:JSCHART_BUTTON_ID.CLOSE_BEFOREOPEN_ID });
            }

            this.DrawCallAuctionVertical(this.BeforeOpenVerticalInfo, this.YSplitOperator.BeforeOpenData, border, true);
        }

        if (this.ChartBorder.RightExtendWidth>10)
        {
            this.Canvas.fillStyle=this.BeforeBGColor;
            var left=ToFixedPoint(this.ChartBorder.GetRight());
            var right=ToFixedPoint(border.Right);
            var width=right-left;
            var height=bottom-top;

            this.Canvas.fillRect(left,top,width,height);
        }
    }

    //分割x,y轴坐标信息
    this.SplitXYCoordinate=function()
    {
        if (this.XYSplit==false) return;
        if (this.YSplitOperator!=null) this.YSplitOperator.Operator();
        if (this.XSplitOperator!=null) this.XSplitOperator.Operator();
    }

    this.GetMultiDayXFromIndex=function(index, border)
    {
        var dayBorder=border.DayBorder;
        var minuteIndex=index%this.MinuteCount;
        var dayIndex=parseInt(index/this.MinuteCount);
        if (dayIndex>=dayBorder.length) dayIndex=dayBorder.length-1;

        var client=dayBorder[dayIndex];
        var count=this.MinuteCount-1;

        if (minuteIndex>=count) 
        {
            return client.RightEx;
        }
        else
        {
            var width=(client.RightEx-client.LeftEx);
            var offset=client.LeftEx+width*minuteIndex/count;
            return offset;
        }
    }

    this.GetXFromIndex=function(index)
    {
        var count=this.XPointCount-1;
        var border=this.ChartBorder.GetBorder();
        if (border.DayBorder) return this.GetMultiDayXFromIndex(index, border);

        if (count==1)
        {
            if (index==0) return border.LeftEx;
            else return border.RightEx;
        }
        else if (count<=0)
        {
            return border.LeftEx;
        }
        else if (index>=count)
        {
            return border.RightEx;
        }
        else
        {
            var width=(border.RightEx-border.LeftEx);
            var offset=border.LeftEx+width*index/count;
            return offset;
        }
    }

    this.GetMultiDayXData=function(x,border)
    {
        var dayBorder=border.DayBorder;
        for(var i=0;i<dayBorder.length;++i)
        {
            var client=dayBorder[i];
            if (x>=client.Left && x<=client.Right)
            {
                var count=this.MinuteCount-1;
                var dayMinuteCount=this.MinuteCount*i;
                if (x<=client.LeftEx) return 0+dayMinuteCount;
                if (x>=client.RightEx) return count+dayMinuteCount;

                var width=client.RightEx-client.LeftEx;
                return (x-client.LeftEx)*(count*1.0/width)+dayMinuteCount;
            }
        }
    }

    //X坐标转x轴数值
    this.GetXData=function(x)
    {
        var count=this.XPointCount-1;
        if (count<0) count=0;

        var border=this.ChartBorder.GetBorder();
        if (border.DayBorder) return this.GetMultiDayXData(x, border);

        if (x<=border.LeftEx) return 0;
        if (x>=border.RightEx) return count;

        var width=border.RightEx-border.LeftEx;
        return (x-border.LeftEx)*(count*1.0/width);
    }

    this.DrawCustomHorizontal=function()    //Y轴刻度定制显示
    {
        for(var i in this.CustomHorizontalInfo)
        {
            var item=this.CustomHorizontalInfo[i];
            switch(item.Type)
            {
                case 0:
                case 1:
                    this.DrawCustomItem(item);  //自定义刻度
                    break;
            }
        }
    }

    this.GetLeftExtendXFromIndex=function(index, obj)
    {
        var count=obj.TotalCount-1;

        var border=this.ChartBorder.GetBorder();
        if (border.DayBorder) return this.GetLeftExtendMultiDayXFromIndex(index, obj, border);

        var left=border.Left;
        var width=this.ChartBorder.LeftExtendWidth;

        var offset=left+width*index/count;
        return offset;
    }

    this.GetLeftExtendMultiDayXFromIndex=function(index, obj, border)
    {
        var dayBorder=border.DayBorder;
        var client=dayBorder[obj.Index];
        var count=obj.TotalCount-1;

        var left=client.Left;
        var right=client.LeftEx;
        var width=right-left;

        var offset=left+width*index/count;
        return offset;
    }

    this.GetLeftExtendMultiDayXData=function(x, obj, border)
    {
        var dayBorder=border.DayBorder;
        for(var i in dayBorder)
        {
            var client=dayBorder[i];
            if (x>=client.Left && x<=client.LeftEx)
            {
                var count=obj[i].TotalCount-1;
                var left=client.Left;
                var right=client.LeftEx;

                var width=right-left;
                var index=(x-left)*(count*1.0/width);

                return { DayIndex:parseInt(i), DataIndex:index };
            }
        }
    }

    this.GetLeftExtendXData=function(x, obj)
    {
        var border=this.ChartBorder.GetBorder();
        if (border.DayBorder) return this.GetLeftExtendMultiDayXData(x, obj, border);

        var count=obj.TotalCount-1;
        if (count<0) count=0;

        var left=border.Left;
        var right=border.LeftEx;

        if (x<=left) return 0;
        if (x>=right) return count;

        var width=right-left;
        return (x-left)*(count*1.0/width);
    }

    this.GetLeftExtendYFromData=function(value,isLimit,obj)
    {
        if (!obj || !obj.Range) return this.GetYFromData(value,isLimit);

        var range=obj.Range;
        var border=this.ChartBorder.GetBorder();
        var height=border.BottomEx-border.TopEx;
        var offset=height*(value-range.Min)/(range.Max-range.Min);
        return border.BottomEx-offset;
    }

    this.GetLeftExtendYData=function(y, isLimit, obj)
    {
        if (!obj || !obj.Range) return this.GetYData(y,isLimit);

        var range=obj.Range;
        var border=this.ChartBorder.GetBorder();
        var height=border.BottomEx-border.TopEx;
        return (border.BottomEx-y)/height*(range.Max-range.Min)+range.Min;
    }

    this.GetRightExtendMultiDayXFromIndex=function(index, obj, border)
    {
        var dayBorder=border.DayBorder;
        var client=dayBorder[obj.Index];
        var count=obj.TotalCount-1;

        var left=client.RightEx;
        var right=client.Right;
        var width=right-left;

        var offset=left+width*index/count;
        return offset;
    }

    this.GetRightExtendXFromIndex=function(index, obj)
    {
        var count=obj.TotalCount-1;

        var border=this.ChartBorder.GetBorder();
        if (border.DayBorder) return this.GetRightExtendMultiDayXFromIndex(index, obj, border);

        var left=border.RightEx;
        var width=this.ChartBorder.RightExtendWidth;

        var offset=left+width*index/count;
        return offset;
    }

    this.GetRightExtendYFromData=function(value,isLimit,obj)
    {
        return this.GetLeftExtendYFromData(value,isLimit,obj)
    }

    this.GetRightExtendYData=function(y, isLimit, obj)
    {
        if (!obj || !obj.Range) return this.GetYData(y,isLimit);

        return this.GetLeftExtendYData(y, isLimit, obj);
    }

    this.GetRightExtendMultiDayXData=function(x, obj, border)
    {
        var dayBorder=border.DayBorder;
        for(var i in dayBorder)
        {
            var client=dayBorder[i];
            if (x>=client.RightEx && x<=client.Right)
            {
                var count=obj[i].TotalCount-1;
                var left=client.RightEx;
                var right=client.Right;

                var width=right-left;
                var index=(x-left)*(count*1.0/width);

                return { DayIndex:parseInt(i), DataIndex:index };
            }
        }
    }

    this.GetRightExtendXData=function(x, obj)
    {
        var border=this.ChartBorder.GetBorder();
        if (border.DayBorder) return this.GetRightExtendMultiDayXData(x, obj, border);

        var count=obj.TotalCount-1;
        if (count<0) count=0;

        var left=border.RightEx;
        var right=border.Right;

        if (x<=left) return 0;
        if (x>=right) return count;

        var width=right-left;
        return (x-left)*(count*1.0/width);
    }
}

//走势图 横屏框架
function MinuteHScreenFrame()
{
    this.newMethod=MinuteFrame;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName="MinuteHScreenFrame";
    this.IsHScreen=true;        //是否是横屏

    //画标题背景色
    this.DrawTitleBG=function()
    {
        if (this.ChartBorder.TitleHeight<=0) return;

        var border=this.ChartBorder.GetHScreenBorder();
        var left=ToFixedPoint(border.RightEx);
        var top=ToFixedPoint(border.Top);
        var bottom=ToFixedPoint(border.Bottom);
        var width=this.ChartBorder.TitleHeight;
        var height=bottom-top;

        this.Canvas.fillStyle=this.TitleBGColor;
        this.Canvas.fillRect(left,top,width,height);
    }

    this.DrawToolbar=function()
    {
        return;
    }

    //画集合竞价背景
    this.DrawBeforeDataBG=function()
    {
        if (this.ChartBorder.LeftExtendWidth<10 && this.ChartBorder.RightExtendWidth<10) return;
        var border=this.ChartBorder.GetHScreenBorder();

        var left=ToFixedPoint(border.Left);
        var right=ToFixedPoint(border.Right);
        this.Canvas.fillStyle=this.BeforeBGColor;
        
        if (this.ChartBorder.LeftExtendWidth>10)
        {
            var top=ToFixedPoint(border.Top);
            var bottom=ToFixedPoint(border.TopEx);
            var width=right-left;
            var height=bottom-top;
            
            this.Canvas.fillRect(left,top,width,height);
        }

        if (this.ChartBorder.RightExtendWidth>10)
        {
            var top=border.BottomEx;
            var bottom=border.Bottom;
            var width=right-left;
            var height=bottom-top;

            this.Canvas.fillRect(left,top,width,height);
        }
    }

    //Y坐标转y轴数值
    this.GetYData=function(x)
    {
        var border=this.ChartBorder.GetHScreenBorder();
        if (x<border.LeftEx) return this.HorizontalMin;
		if (x>border.RightEx) return this.HorizontalMax;

        var width=border.RightEx-border.LeftEx;
		return (x-border.LeftEx)/width*(this.HorizontalMax-this.HorizontalMin)+this.HorizontalMin;
    }

    //X坐标转x轴数值
    this.GetXData=function(y)
    {
        var border=this.ChartBorder.GetHScreenBorder();
        var count=this.XPointCount-1;
        if (count<0) count=0;

        if (y<=border.TopEx) return 0;
		if (y>=border.BottomEx) return count;

        var height=(border.BottomEx-border.TopEx);
		return (y-border.TopEx)*(count*1.0/height);
    }

    this.GetXFromIndex=function(index)
    {
        var count=this.XPointCount-1;
        var border=this.ChartBorder.GetHScreenBorder();
        if (count==1)
        {
            if (index==0) return border.TopEx;
            else return border.BottomEx;
        }
        else if (count<=0)
        {
            return border.TopEx;
        }
        else if (index>=count)
        {
            return border.BottomEx;
        }
        else
        {
            var height=border.BottomEx-border.TopEx;
            var offset=border.TopEx+height*index/count;
            return offset;
        }
    }

    
    this.GetYFromData=function(value)
    {
        var border=this.ChartBorder.GetHScreenBorder();
        if(value<=this.HorizontalMin) return border.LeftEx;
        if(value>=this.HorizontalMax) return border.RightEx;

        var width=(border.RightEx-border.LeftEx)*(value-this.HorizontalMin)/(this.HorizontalMax-this.HorizontalMin);
        return border.LeftEx+width;
    }

    this.DrawVolTitle=function(symbol)
    {
        if (!MARKET_SUFFIX_NAME.IsShowMinuteVolTitle(symbol)) return;

        if (this.Identify==1)   //显示"成交量"
        {
            var pixelRatio=GetDevicePixelRatio();
            var left=this.ChartBorder.GetRight()-2*pixelRatio;
            var top=this.ChartBorder.GetTopEx()+2*pixelRatio;

            var xText=left,yText=top;
            this.Canvas.save();
            this.Canvas.translate(xText, yText);
            this.Canvas.rotate(90 * Math.PI / 180);

            var x=this.YInsideOffset,y=0;
            this.Canvas.textAlign='left';
            this.Canvas.textBaseline='top';
            if (g_JSChartResource.Minute.VolBarColor || g_JSChartResource.Minute.VolTitleColor)
            {
                if (g_JSChartResource.Minute.VolBarColor) this.Canvas.fillStyle=g_JSChartResource.Minute.VolBarColor
                else this.Canvas.fillStyle=g_JSChartResource.Minute.VolTitleColor;
                var languageID=this.YSplitOperator.LanguageID;
                var text=g_JSChartLocalization.GetText('MVol-Vol',languageID);
                this.Canvas.fillText(text,x,y);
                x+=this.Canvas.measureText(text).width;
                x+=6*GetDevicePixelRatio();
            }
            
            if (this.IsShowPositionTitle)
            {
                text=g_JSChartLocalization.GetText('MVol-Position',languageID);
                this.Canvas.fillStyle=g_JSChartResource.Minute.PositionColor;
                this.Canvas.fillText(text,x,y);
            }

            this.Canvas.restore();
        }
    }

    //画Y轴
    this.DrawHorizontal=function()
    {
        var border=this.ChartBorder.GetHScreenBorder();

        var top=border.Top;
        var bottom=border.Bottom;
        var left=border.Left;
        var right=border.Right;
        var borderTop=this.ChartBorder.Top;
        var borderBottom=this.ChartBorder.Bottom;

        var yPrev=null; //上一个坐标y的值
        for(var i=this.HorizontalInfo.length-1; i>=0; --i)  //从左往右画分割线
        {
            var item=this.HorizontalInfo[i];
            var y=this.GetYFromData(item.Value);
            if (y!=null && Math.abs(y-yPrev)<this.MinYDistance) continue;  //两个坐标在近了 就不画了

            this.Canvas.strokeStyle=item.LineColor;
            this.Canvas.beginPath();
            this.Canvas.moveTo(ToFixedPoint(y),top);
            this.Canvas.lineTo(ToFixedPoint(y),bottom);
            this.Canvas.stroke();

            if (y >= right - 2) 
            {
                this.Canvas.textBaseline = 'top';
                y = right;
            }
            else if (y <= left + 2) 
            {
                this.Canvas.textBaseline = 'bottom';
                y=left;
                if (y != null && Math.abs(y - yPrev) < 2*this.MinYDistance) continue;  //两个坐标在近了 就不画了
            }
            else 
            {
                this.Canvas.textBaseline = "middle";
            }

            //坐标信息 左边 间距小于10 不画坐标
            if (item.Message[0]!=null && borderTop>10)
            {
                if (item.Font!=null) this.Canvas.font=item.Font;

                this.Canvas.fillStyle=item.TextColor;
                this.Canvas.textAlign="right";

                var xText=y,yText=top;
                this.Canvas.save();
                this.Canvas.translate(xText, yText);
                this.Canvas.rotate(90 * Math.PI / 180);
                this.Canvas.fillText(item.Message[0], -2, 0);
                this.Canvas.restore();
            }

            //坐标信息 右边 间距小于10 不画坐标
            if (item.Message[1]!=null && borderBottom>10)
            {
                if (item.Font!=null) this.Canvas.font=item.Font;

                this.Canvas.fillStyle=item.TextColor;
                this.Canvas.textAlign="left";
               
                var xText=y,yText=bottom;
                this.Canvas.save();
                this.Canvas.translate(xText, yText);
                this.Canvas.rotate(90 * Math.PI / 180);
                this.Canvas.fillText(item.Message[1], 2, 0);
                this.Canvas.restore();
            }

            yPrev=y;
        }
    }

    this.DrawInsideClientHorizontal=function()
    {
        var border=this.GetBorder();
        var left=border.Left;
        var right=border.Right;
        var bottom=border.BottomEx;
        var top=border.TopEx;

        var pixelTatio = GetDevicePixelRatio();
        var yPrev = null; //上一个坐标y的值
        var yInsideText=null;
        for (var i = this.HorizontalInfo.length - 1; i >= 0; --i)  //从上往下画分割线
        {
            var item = this.HorizontalInfo[i];
            if (!item || !item.Message[2] || !item.Message[3]) continue;
            var y = this.GetYFromData(item.Value);
            if (y != null && yPrev!=null && Math.abs(y - yPrev) < this.MinYDistance) continue;  //两个坐标在近了 就不画了

            if (y >= right - 2) 
            {
                this.Canvas.textBaseline = 'top';
                y = right;
            }
            else if (y <= left + 2) 
            {
                this.Canvas.textBaseline = 'bottom';
                y=left;
                if (y != null && Math.abs(y - yPrev) < 2*this.MinYDistance) continue;  //两个坐标在近了 就不画了
            }
            else 
            {
                this.Canvas.textBaseline = "middle";
            }

            if (item.Message[2]) 
            {
                if (item.Font != null) this.Canvas.font = item.Font;
                this.Canvas.fillStyle = item.TextColor;
                this.Canvas.textAlign = "left";

                var xText=y,yText=top;
                this.Canvas.save();
                this.Canvas.translate(xText, yText);
                this.Canvas.rotate(90 * Math.PI / 180);
                this.Canvas.fillText(item.Message[2], 2, 0);
                this.Canvas.restore();
            }

            if (item.Message[3])
            {
                if (item.Font != null) this.Canvas.font = item.Font;
                this.Canvas.fillStyle = item.TextColor;
                this.Canvas.textAlign = "right";

                var xText=y,yText=bottom;
                this.Canvas.save();
                this.Canvas.translate(xText, yText);
                this.Canvas.rotate(90 * Math.PI / 180);
                this.Canvas.fillText(item.Message[3], -2, 0);
                this.Canvas.restore();
                
            }
            yPrev = y;
        }
    }

    //画X轴
    this.DrawVertical=function()
    {
        var border=this.ChartBorder.GetHScreenBorder();
        var left=border.Left;
        var right=border.Right;
        var bottom=border.Bottom;

        var xPrev=null; //上一个坐标x的值
        for(var i in this.VerticalInfo)
        {
            var x=this.GetXFromIndex(this.VerticalInfo[i].Value);
            if (x>bottom) break;
            if (xPrev!=null && Math.abs(x-xPrev)<this.MinXDistance) continue;

            this.Canvas.strokeStyle=this.VerticalInfo[i].LineColor;
            this.Canvas.beginPath();
            this.Canvas.moveTo(left,ToFixedPoint(x));
            this.Canvas.lineTo(right,ToFixedPoint(x));
            this.Canvas.stroke();

            if (this.VerticalInfo[i].Message[0]!=null)
            {
                if (this.VerticalInfo[i].Font!=null)
                    this.Canvas.font=this.VerticalInfo[i].Font;

                this.Canvas.fillStyle=this.VerticalInfo[i].TextColor;
                var testWidth=this.Canvas.measureText(this.VerticalInfo[i].Message[0]).width;
                if (x<testWidth/2)
                {
                    this.Canvas.textAlign="left";
                    this.Canvas.textBaseline="top";
                }
                else if ((x + testWidth / 2) >= this.ChartBorder.GetChartHeight())
                {
                    this.Canvas.textAlign = "right";
                    this.Canvas.textBaseline = "top";
                }
                else
                {
                    this.Canvas.textAlign="center";
                    this.Canvas.textBaseline="top";
                }

                var xText=left,yText=x;
                this.Canvas.save();
                this.Canvas.translate(xText, yText);
                this.Canvas.rotate(90 * Math.PI / 180);
                this.Canvas.fillText(this.VerticalInfo[i].Message[0], 0, 0);
                this.Canvas.restore();
            }

            xPrev=x;
        }
    }

    //Y刻度画在左边内部
    this.DrawInsideHorizontal = function () 
    {
        if (this.IsShowYText[0]===false && this.IsShowYText[1]===false) return;

        this.DrawInsideClientHorizontal();

        var border=this.ChartBorder.GetHScreenBorder();
        var left = border.Left;
        var right = border.RightEx;
        var top=border.Top;
        var bottom=border.Bottom;
        var borderTop=this.ChartBorder.Top;
        var borderBottom=this.ChartBorder.Bottom;
        var titleHeight = this.ChartBorder.TitleHeight;
        var pixelTatio = GetDevicePixelRatio();
        
        if ( (borderTop<10*pixelTatio && this.IsShowYText[0]===true) || (borderBottom<10*pixelTatio && this.IsShowYText[1]===true) )
        {
            var pixelTatio = GetDevicePixelRatio();
            var yPrev = null; //上一个坐标y的值
            var yInsideText=null;
            for (var i = this.HorizontalInfo.length - 1; i >= 0; --i)  //从上往下画分割线
            {
                var item = this.HorizontalInfo[i];
                var y = this.GetYFromData(item.Value);
                if (y != null && yPrev!=null && Math.abs(y - yPrev) < this.MinYDistance) continue;  //两个坐标在近了 就不画了

                //坐标信息 左边 间距小于10 画在内部
                if (item.Message[0] != null && borderTop < 10*pixelTatio && this.IsShowYText[0]===true) 
                {
                    if (item.Font != null) this.Canvas.font = item.Font;
                    this.Canvas.fillStyle = item.TextColor;
                    this.Canvas.textAlign = "left";
                    if (y >= right - 2) this.Canvas.textBaseline = 'top';
                    else if (y <= left + 2) this.Canvas.textBaseline = 'bottom';
                    else this.Canvas.textBaseline = "middle";

                    var textObj={ X:left, Y:y, Text:{ BaseLine:this.Canvas.textBaseline, TextAlign: this.Canvas.textAlign, Font:this.Canvas.font, Value:item.Message[0]}} ;
                    var xText=y,yText=top;
                    this.Canvas.save();
                    this.Canvas.translate(xText, yText);
                    this.Canvas.rotate(90 * Math.PI / 180);
                    this.Canvas.fillText(item.Message[0], 2*pixelTatio, 0);
                    this.Canvas.restore();

                    if (yInsideText==null || yInsideText<xText)
                    {
                        this.YInsideOffset=this.Canvas.measureText(item.Message[0]).width+4*GetDevicePixelRatio();
                        yInsideText=xText;
                    }
                }

                if (item.Message[1] != null && borderBottom < 10*pixelTatio && this.IsShowYText[1]===true)
                {
                    if (item.Font != null) this.Canvas.font = item.Font;
                    this.Canvas.fillStyle = item.TextColor;
                    this.Canvas.textAlign = "right";
                    if (y >= right - 2) this.Canvas.textBaseline = 'top';
                    else if (y <= left + 2) this.Canvas.textBaseline = 'bottom';
                    else this.Canvas.textBaseline = "middle";
                    var textWidth = this.Canvas.measureText(item.Message[1]).width;
                    var textObj={ X:right-textWidth, Y:y, Text:{ BaseLine:this.Canvas.textBaseline, TextAlign: this.Canvas.textAlign, Font:this.Canvas.font, Value:item.Message[1]}} ;

                    var xText=y,yText=bottom;
                    this.Canvas.save();
                    this.Canvas.translate(xText, yText);
                    this.Canvas.rotate(90 * Math.PI / 180);
                    this.Canvas.fillText(item.Message[1], -2*pixelTatio, 0);
                    this.Canvas.restore();
                }
                yPrev = y;
            }
        }
    }

    this.GetLeftExtendXFromIndex=function(index, obj)
    {
        var count=obj.TotalCount-1;

        var border=this.ChartBorder.GetHScreenBorder();
        var left=border.Top;
        var width=this.ChartBorder.LeftExtendWidth;

        var offset=left+width*index/count;
        return offset;
    }

    this.GetLeftExtendXData=function(y, obj)
    {
        var count=obj.TotalCount-1;
        if (count<0) count=0;

        var border=this.ChartBorder.GetHScreenBorder();
        var left=border.Top;
        var right=border.TopEx;

        if (y<=left) return 0;
        if (y>=right) return count;

        var width=right-left;
        return (y-left)*(count*1.0/width);
    }

    this.GetLeftExtendYFromData=function(value,isLimit,obj)
    {
        if (!obj || !obj.Range) return this.GetYFromData(value,isLimit);

        var range=obj.Range;
        var border=this.ChartBorder.GetHScreenBorder();
        var width=border.RightEx-border.LeftEx;
        var offset=width*(value-range.Min)/(range.Max-range.Min);
        return border.LeftEx+offset;
    }

    this.GetLeftExtendYData=function(x, isLimit, obj)
    {
        if (!obj || !obj.Range) return this.GetYData(y,isLimit);

        var range=obj.Range;
        var border=this.ChartBorder.GetHScreenBorder();
        var width=border.RightEx-border.LeftEx;
        return (x-border.LeftEx)/width*(range.Max-range.Min)+range.Min;
    }

    this.GetRightExtendXFromIndex=function(index, obj)
    {
        var count=obj.TotalCount-1;

        var border=this.ChartBorder.GetHScreenBorder();
        var left=border.BottomEx;
        var width=this.ChartBorder.RightExtendWidth;

        var offset=left+width*index/count;
        return offset;
    }

    this.GetRightExtendXData=function(y, obj)
    {
        var count=obj.TotalCount-1;
        if (count<0) count=0;

        var border=this.ChartBorder.GetHScreenBorder();
        var left=border.BottomEx;
        var right=border.Bottom;

        if (y<=left) return 0;
        if (y>=right) return count;

        var width=right-left;
        return (y-left)*(count*1.0/width);
    }

    this.GetRightExtendYFromData=function(value,isLimit,obj)
    {
        if (!obj || !obj.Range) return this.GetYFromData(value,isLimit);

        return this.GetLeftExtendYFromData(value,isLimit,obj);
    }


}

function OverlayMinuteFrame()
{
    this.newMethod=MinuteFrame;     //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName="OverlayMinuteFrame";
    this.IsShow=true;               //坐标是否显示
    this.IsShareY=false;            //使用和主框架公用Y轴

    this.Draw=function()
    {
        this.SplitXYCoordinate();
        if (this.IsShow)
        {

        }

        this.SizeChange=false;
        this.XYSplit=false;
    }

    //分割x,y轴坐标信息
    this.SplitXYCoordinate=function()
    {
        if (this.XYSplit==false) return;

        if (this.IsShareY)  //和主图指标共享Y轴坐标
        {
            this.HorizontalMax=this.MainFrame.HorizontalMax;
            this.HorizontalMin=this.MainFrame.HorizontalMin;
            this.HorizontalInfo=[];
            for(var i in this.MainFrame.HorizontalInfo)
            {
                var item=this.MainFrame.HorizontalInfo[i];
                this.HorizontalInfo.push(item);
            }
        }
        else    //独立Y轴坐标
        {
            if (this.YSplitOperator!=null) this.YSplitOperator.Operator();
        }
        
        // if (this.XSplitOperator!=null) this.XSplitOperator.Operator(); 子坐标和主坐标X轴一致 所以不用计算
    }
}

function OverlayMinuteHScreenFrame()
{
    this.newMethod=MinuteHScreenFrame;     //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName="OverlayMinuteHScreenFrame";
    this.IsShow=true;                   //坐标是否显示

    this.Draw=function()
    {
        this.SplitXYCoordinate();
        if (this.IsShow)
        {

        }

        this.SizeChange=false;
        this.XYSplit=false;
    }

    //分割x,y轴坐标信息
    this.SplitXYCoordinate=function()
    {
        if (this.XYSplit==false) return;

        if (this.IsShareY)  //和主图指标共享Y轴坐标
        {
            this.HorizontalMax=this.MainFrame.HorizontalMax;
            this.HorizontalMin=this.MainFrame.HorizontalMin;
            this.HorizontalInfo=[];
            for(var i in this.MainFrame.HorizontalInfo)
            {
                var item=this.MainFrame.HorizontalInfo[i];
                this.HorizontalInfo.push(item);
            }
        }
        else    //独立Y轴坐标
        {
            if (this.YSplitOperator!=null) this.YSplitOperator.Operator();
        }
        
        // if (this.XSplitOperator!=null) this.XSplitOperator.Operator(); 子坐标和主坐标X轴一致 所以不用计算
    }
}

//K线框架
function KLineFrame()
{
    this.newMethod=AverageWidthFrame;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='KLineFrame';
    this.ToolbarID=Guid();  //工具条Div id

    this.ModifyIndex=true;      //是否显示'改参数'菜单
    this.ChangeIndex=true;      //是否显示'换指标'菜单
    this.CloseIndex=true;       //是否显示'关闭指标窗口'菜单
    this.OverlayIndex=false;    //是否显示叠加指标

    this.ModifyIndexEvent;   //改参数 点击事件
    this.ChangeIndexEvent;   //换指标 点击事件
    this.ToolbarRect=null;   //保存工具条的位置
    this.ReDrawToolbar=false;

    this.LastCalculateStatus={ Width:0, XPointCount:0 };    //最后一次计算宽度的状态

    this.CustomHorizontalInfo=[];   //定制Y轴刻度
    this.IsDrawTitleBG=false;

    this.CustomVerticalInfo=[];     //定制X轴刻度 Type:0,  Date:, Time: ,        Line:{ Color:线段颜色, Type:线段类型 0 直线 1 虚线 }
                                    //           Type:1,  Space: 第几个空白间距,  Line:{ Color:线段颜色, Type:线段类型 0 直线 1 虚线 }
    this.DrawCustomVerticalEvent;
    this.RightSpaceCount=0;

    this.Logarithmic=null; //{Up:上部 , Donw:下部 , OpenPrice:第一个开盘价}

    this.DrawToolbar=function()
    {
        if (typeof($)=="undefined") return;
        
        if (!this.ChartBorder.UIElement || !this.ChartBorder.UIElement.parentNode) return;

        var divToolbar=document.getElementById(this.ToolbarID);
        if (divToolbar && this.SizeChange==false && this.ReDrawToolbar==false)  return;

        if (!divToolbar)
        {
            
            divToolbar=document.createElement("div");
            divToolbar.className='klineframe-toolbar';
            divToolbar.id=this.ToolbarID;
            divToolbar.oncontextmenu = function() { return false;}; //屏蔽右键系统菜单
            //为divToolbar添加属性identify
            divToolbar.setAttribute("identify",this.Identify.toString());
            this.ChartBorder.UIElement.parentNode.appendChild(divToolbar);
        }

        if (!this.ModifyIndex && !this.ChangeIndex && !this.OverlayIndex && !this.CloseIndex)
        {
            if (divToolbar.style.display!='none')
                divToolbar.style.display='none';
            return;
        }

        //使用外城div尺寸 画图尺寸是被放大的
        var pixelTatio = GetDevicePixelRatio();
        var chartWidth=parseInt(this.ChartBorder.UIElement.parentElement.style.width.replace("px",""));  
        var chartHeight=parseInt(this.ChartBorder.UIElement.parentElement.style.height.replace("px",""));
        //JSConsole.Chart.Log('[KLineFrame::DrawToolbar] ',chartWidth,chartHeight,pixelTatio);

        var toolbarWidth=100;
        var toolbarHeight=this.ChartBorder.GetTitleHeight();
        var left=chartWidth-(this.ChartBorder.Right/pixelTatio)-toolbarWidth;
        var top=this.ChartBorder.GetTop()/pixelTatio;

        if (this.ToolbarRect)
        {
            //尺寸变动移动才重新设置DOM
            if (this.ToolbarRect.Left==left && this.ToolbarRect.Top==top && 
                this.ToolbarRect.Width==toolbarWidth && this.ToolbarRect.Height==toolbarHeight/pixelTatio)
            {
                return;
            }
        }

        this.ToolbarRect={ Left:left, Top:top, Width:toolbarWidth, Height:toolbarHeight/pixelTatio };

        const modifyButton=`<span class='index_param icon iconfont icon-index_param' id='modifyindex' style='cursor:pointer;margin-left:2px;margin-right:2px;' title='调整指标参数'></span>`;
        const changeButton=`<span class='index_change icon iconfont icon-change_index' id='changeindex' style='cursor:pointer;margin-left:2px;margin-right:2px;' title='切换指标'></span>`;
        const overlayButton=`<span class='index_overlay icon iconfont icon-overlay_index' id='overlayindex' style='cursor:pointer;margin-left:2px;margin-right:2px;' title='叠加指标'></span>`;
        const closeButton=`<span class='index_close icon iconfont icon-close' id='closeindex' style='cursor:pointer;margin-left:2px;margin-right:2px;' title='关闭指标窗口'></span>`;

        var spanIcon=modifyButton+changeButton+overlayButton;

        if (this.Identify!==0 && this.CloseIndex)  //第1个窗口不能关闭
        {
            spanIcon+=closeButton;
        }

        //var scrollPos=GetScrollPosition();
        //left = left+scrollPos.Left;
        //top = top+scrollPos.Top;
        divToolbar.style.left = left + "px";
        divToolbar.style.top = top + "px";
        divToolbar.style.width=toolbarWidth+"px";                   //宽度先不调整吧
        divToolbar.style.height=(toolbarHeight/pixelTatio)+'px';    //只调整高度
        divToolbar.innerHTML=spanIcon;

        var chart=this.ChartBorder.UIElement.JSChartContainer;
        var identify=this.Identify;
        if (!this.ModifyIndex)  //隐藏'改参数'
            $("#"+divToolbar.id+" .index_param").hide();
        else if (typeof(this.ModifyIndexEvent)=='function')  //绑定点击事件
            $("#"+divToolbar.id+" .index_param").click(
                {
                    Chart:this.ChartBorder.UIElement.JSChartContainer,
                    Identify:this.Identify
                },this.ModifyIndexEvent);

        if (!this.ChangeIndex)  //隐藏'换指标'
        {
            $("#"+divToolbar.id+" .index_change").hide();
        }  
        else if (typeof(this.ChangeIndexEvent)=='function')
        {
            $("#"+divToolbar.id+" .index_change").click(
                {
                    Chart:this.ChartBorder.UIElement.JSChartContainer,
                    Identify:this.Identify,
                    IsOverlay:false
                },this.ChangeIndexEvent);
        }

        if (!this.OverlayIndex)
        {
            $("#"+divToolbar.id+" .index_overlay").hide();
        }
        else
        {
            $("#"+divToolbar.id+" .index_overlay").click(
                {
                    Chart:this.ChartBorder.UIElement.JSChartContainer,
                    Identify:this.Identify,
                    IsOverlay:true
                },this.ChangeIndexEvent);
        }
        
        $("#"+divToolbar.id+" .index_close").click(
            {
                Chart:this.ChartBorder.UIElement.JSChartContainer,
                Identify:this.Identify
            },
            function(event)
            {
                var hqChart=event.data.Chart;
                var id=event.data.Identify;
                hqChart.RemoveIndexWindow(id);
            });

        divToolbar.style.display = "block";
    }

    this.ClearToolbar=function()
    {
        var divToolbar=document.getElementById(this.ToolbarID);
        if (!divToolbar) return;
        this.ChartBorder.UIElement.parentNode.removeChild(divToolbar);
    }

    this.DrawFrame=function()
    {
        this.SplitXYCoordinate();

        if (this.SizeChange==true) 
        {
            this.CalculateDataWidth();
            if (this.Logarithmic) this.SplitLogarithmicXYCoordinate();
        }

        if (this.DrawDepthMapCallback) this.DrawDepthMapCallback();

        this.DrawTitleBG();
        this.DrawHorizontal();
        this.DrawVertical();

        if (this.SizeChange==true || this.ReDrawToolbar==true) 
        {
            this.DrawToolbar();  //大小变动才画工具条
            this.ReDrawToolbar=false;
        }
    }

    //isLimit 是否限制在当前屏坐标下
    this.GetXFromIndex=function(index,isLimit)
    {
        if (isLimit===false)
        {
            if (index>=0)
            {
                var offset=this.ChartBorder.GetLeft()+g_JSChartResource.FrameLeftMargin+this.DistanceWidth/2+this.DataWidth/2;
                for(var i=1;i<=index;++i)
                {
                    offset+=this.DistanceWidth+this.DataWidth;
                }
            }
            else
            {
                var offset=this.ChartBorder.GetLeft()-(this.DistanceWidth/2+this.DataWidth+this.DistanceWidth);
                var absIndex=Math.abs(index);
                for(var i=1;i<absIndex;++i)
                {
                    offset-=(this.DistanceWidth+this.DataWidth);
                }
            }
        }
        else
        {
            if (index < 0) index = 0;
            if (index > this.xPointCount - 1) index = this.xPointCount - 1;

            var offset=this.ChartBorder.GetLeft()+g_JSChartResource.FrameLeftMargin+this.DistanceWidth/2+this.DataWidth/2;
            for(var i=1;i<=index;++i)
            {
                offset+=this.DistanceWidth+this.DataWidth;
            }
        }

        return offset;
    }

    //X坐标转x轴数值 isLimit=是否限制在当前屏坐标下
    this.GetXData=function(x,isLimit)
    {
        var distanceWidth=this.DistanceWidth;
        var dataWidth=this.DataWidth;
        var left=this.ChartBorder.GetLeft()+g_JSChartResource.FrameLeftMargin;

        if (isLimit==false)
        {
            if (x<this.ChartBorder.GetLeft())
            {
                var index=-1;
                var xPoint=this.ChartBorder.GetLeft()-(distanceWidth/2+dataWidth+distanceWidth);
                while(index>-10000)
                {
                    if (xPoint<=x) 
                        break;
                    xPoint-=(dataWidth+distanceWidth);
                    --index;
                }
    
                return index;
            }
            else
            {
                var index=0;
                var xPoint=left+distanceWidth/2+dataWidth+distanceWidth;
                while(index<10000)  //自己算x的数值
                {
                    if (xPoint>=x) break;
                    xPoint+=(dataWidth+distanceWidth);
                    ++index;
                }

                return index;
            }
        }
        else
        {
            if (x<=this.ChartBorder.GetLeft()) return 0;
            if (x>=this.ChartBorder.GetRight()) return this.XPointCount-1;
            
            var right=this.ChartBorder.GetRight()-g_JSChartResource.FrameRightMargin;
            var index=0;
            var xPoint=left+distanceWidth/2+dataWidth+distanceWidth;
            while(xPoint<right && index<10000 && index+1<this.XPointCount)  //自己算x的数值
            {
                if (xPoint>=x) break;
                xPoint+=(dataWidth+distanceWidth);
                ++index;
            }

            //var test=(x-this.ChartBorder.GetLeft())*(this.XPointCount*1.0/this.ChartBorder.GetWidth());
            return index;
        }
    }

    //计算数据宽度
    this.CalculateDataWidth=function()
    {
        if (this.XPointCount<2) return;

        //JSConsole.Chart.Log(`[KLineFrame::CalculateDataWidth] ZoomIndex=${this.ZoomIndex}, XPointCount=${this.XPointCount}, DataWidth=${this.DataWidth}, DistanceWidth=${this.DistanceWidth}`);
        var width=this.GetFrameWidth()-g_JSChartResource.FrameMargin;

        if (this.ZoomIndex>=0 && this.LastCalculateStatus.Width==width && this.LastCalculateStatus.XPointCount==this.XPointCount) //宽度没变 尝试使用原来的柱子宽度
        {
            var caclWidth=(this.DistanceWidth/2+g_JSChartResource.FrameLeftMargin)+(this.DataWidth + this.DistanceWidth)*(this.XPointCount-1);
            var caclWidth2=(this.DataWidth + this.DistanceWidth) * this.XPointCount;
            if (caclWidth<= width) //当前的柱子宽度够用 就不调整了
                return;
        }

        this.LastCalculateStatus.Width=width;
        this.LastCalculateStatus.XPointCount=this.XPointCount;
        for(var i=0;i<ZOOM_SEED.length;++i)
        {
            if((ZOOM_SEED[i][0] + ZOOM_SEED[i][1]) * this.XPointCount < width)
            {
                this.ZoomIndex=i;
                this.DataWidth = ZOOM_SEED[i][0];
                this.DistanceWidth = ZOOM_SEED[i][1];
                this.TrimKLineDataWidth(width);
                JSConsole.Chart.Log('[KLineFrame::CalculateDataWidth] ZOOM_SEED, DataWidth, DistanceWidth, XPointCount', ZOOM_SEED[this.ZoomIndex], this.DataWidth,this.DistanceWidth,this.XPointCount);
                return;
            }
        }

        //太多了 就平均分了
        this.ZoomIndex=ZOOM_SEED.length-1;
        this.DataWidth=width/this.XPointCount;
        this.DistanceWidth=0;
    }

    this.OnSize=function(obj)
    {
        var width=this.GetFrameWidth()-g_JSChartResource.FrameMargin;
        var xPointCount=0;
        var y=this.DistanceWidth/2+g_JSChartResource.FrameLeftMargin+(this.DataWidth+this.DistanceWidth);
        for(;y<width; y+=(this.DataWidth+this.DistanceWidth), ++xPointCount)
        {
            
        }

        obj.CurCount=this.XPointCount;
        obj.CalcCount=xPointCount;
        obj.DataWidth=this.DataWidth;
        obj.DistanceWidth=this.DistanceWidth;
        obj.Changed=false;

        this.LastCalculateStatus.Width=width;
        if (obj.CurCount==obj.CalcCount) return obj;

        this.XPointCount=xPointCount;
        this.LastCalculateStatus.XPointCount=this.XPointCount;
        if (this.Data)
        {
            this.Data.DataOffset+=(obj.CurCount-obj.CalcCount);
            if (this.Data.DataOffset<0) this.Data.DataOffset=0;
            obj.Changed=true;
        }
        return obj;
    }

    this.SetDataWidth=function(dataWidth)
    {
        var zoomIndex=ZOOM_SEED.length-1;
        for(var i in ZOOM_SEED)
        {
            var item=ZOOM_SEED[i];
            if (item[0]<=dataWidth) 
            {
                zoomIndex=parseInt(i)-1;
                break;
            }
        }

        this.ZoomIndex=zoomIndex;
        this.DataWidth=ZOOM_SEED[this.ZoomIndex][0];
        this.DistanceWidth=ZOOM_SEED[this.ZoomIndex][1];
        var width=this.GetFrameWidth()-g_JSChartResource.FrameMargin;
        var xPointCount=0;
        var y=this.DistanceWidth/2+g_JSChartResource.FrameLeftMargin+(this.DataWidth+this.DistanceWidth);
        for(;y<=width; y+=(this.DataWidth+this.DistanceWidth), ++xPointCount) { }

        this.XPointCount=xPointCount;
        this.LastCalculateStatus.XPointCount=this.XPointCount;
        this.LastCalculateStatus.Width=width;

        var obj={ XPointCount:this.XPointCount, DataWidth:this.DataWidth, DistanceWidth:this.DistanceWidth };
        return obj;
    }

    this.TrimKLineDataWidth=function(width)
    {
        var dataWidth=ZOOM_SEED[this.ZoomIndex][0];
        var distanceWidth=ZOOM_SEED[this.ZoomIndex][1];
        if (dataWidth==1 && distanceWidth==0) 
        {
            this.DataWidth=width/this.XPointCount;
            return;
        }

        while(true)
        {
            if((this.DistanceWidth + this.DataWidth) * this.XPointCount + this.DistanceWidth > width)
            {
                this.DistanceWidth -= 0.01;
                break;
            }
            this.DistanceWidth += 0.01;
        }
    }

    //当前坐标信息 是否覆盖最大 最小值输出
    this.IsOverlayMaxMin=function(obj) 
    {
        if (!this.ChartKLine) return false;
        if (!this.ChartKLine.Max || !this.ChartKLine.Min) return false;

        var textWidth=this.Canvas.measureText(obj.Text.Value).width+4;    //刻度文字宽度
        if (obj.Text.TextAlign==='right') obj.X-=textWidth;
        var max=this.ChartKLine.Max, min=this.ChartKLine.Min;
        var isOverlayMax=false, isOverlayMin=false;
        const textHeight=20;    //字体高度
        if (max.X>=obj.X && max.X<=obj.X+textWidth) //最大值X 坐标不在 刻度文字范围内
        {
            var y1=max.Y+textHeight, y2=max.Y-textHeight;
            if ( (y1>=obj.Y-textHeight && y1<=obj.Y+textHeight) || (y2>=obj.Y-textHeight && y2<=obj.Y+textHeight))
                isOverlayMax=true; 
        }

        if (isOverlayMax==true) return true;

        if (min.X>=obj.X && min.X<=obj.X+textWidth)
        {
            var y1=min.Y+textHeight, y2=min.Y-textHeight;
            if ( (y1>=obj.Y-textHeight && y1<=obj.Y+textHeight) || (y2>=obj.Y-textHeight && y2<=obj.Y+textHeight))
                isOverlayMin=true; 
        }

        return isOverlayMax || isOverlayMin;
    }

    //分割x,y轴坐标信息
    this.SplitXYCoordinate=function()
    {
        if (this.XYSplit==false) return;
        if (this.YSplitOperator!=null) this.YSplitOperator.Operator();
        if (this.XSplitOperator!=null) this.XSplitOperator.Operator();
        if (this.Logarithmic) this.SplitLogarithmicXYCoordinate();
    }

    this.SplitLogarithmicXYCoordinate=function()
    {
        var up=this.Logarithmic.Up;
        var down=this.Logarithmic.Down;
        var logHeight=0;    //对数额外高度
        var count=0;
        var maxCount=Math.max(up.length, down.length);

        var aryLogHeight=[];
        for(var i=0;i<maxCount;++i)
        {
            aryLogHeight[i]=i*2;
        }

        for(var i=0, j=aryLogHeight.length-1; i<up.length; ++i,--j)
        {
            var item=up[i];
            item.LogHeight=aryLogHeight[j];
            logHeight+=item.LogHeight;
            ++count;
        }

        for(var i=0, j=aryLogHeight.length-1;i<down.length; ++i,--j)
        {
            var item=down[i];
            item.LogHeight=aryLogHeight[j];
            logHeight+=item.LogHeight;
            ++count;
        }

        var heightRate=2*GetDevicePixelRatio(); 
        var top=this.ChartBorder.GetTopEx();
        var bottom=this.ChartBorder.GetBottomEx();
        var height=(bottom-top);
        var perHeight=(height-logHeight*heightRate)/count;
        if (perHeight<0) 
        {
            perHeight=0;
            heightRate=height/logHeight;
        }

        if (this.CoordinateType==1) //反转坐标
        {
            var itemTop=top;
            for(var i=down.length-1;i>=0;--i)   //上部
            {
                var item=down[i];
                item.Height=perHeight+(heightRate*item.LogHeight);
                item.Top=itemTop;
                item.Bottom=item.Top+item.Height;
                itemTop=item.Bottom;
            }

            var itemBottom=bottom;
            for(var i=up.length-1;i>=0;--i) //下部
            {   
                var item=up[i];
                item.Height=perHeight+(heightRate*item.LogHeight)
                item.Bottom=itemBottom;
                item.Top=itemBottom-item.Height;
                itemBottom=item.Top;
            }
        }
        else
        {
            var itemTop=top;
            for(var i=up.length-1;i>=0;--i)
            {
                var item=up[i];
                item.Height=perHeight+(heightRate*item.LogHeight);
                item.Top=itemTop;
                item.Bottom=item.Top+item.Height;
                itemTop=item.Bottom;
            }
    
            var itemBottom=bottom;
            for(var i=down.length-1;i>=0;--i)
            {
                var item=down[i];
                item.Height=perHeight+(heightRate*item.LogHeight)
                item.Bottom=itemBottom;
                item.Top=itemBottom-item.Height;
                itemBottom=item.Top;
            }
        }
        JSConsole.Chart.Log("[KLineFrame::SplitLogarithmicXYCoordinate]", this.Logarithmic);
    }

    this.GetYLogarithmicFromData=function(value, isLimit)
    {
        if (this.CoordinateType==1)
        {
            if(value<=this.HorizontalMin) return this.ChartBorder.GetTopEx();
            if(value>=this.HorizontalMax) return this.ChartBorder.GetBottomEx();

            if (value>this.Logarithmic.OpenPrice)
            {
                var up=this.Logarithmic.Up;
                for(var i in up)
                {
                    var item=up[i];
                    if (value>=item.Start && value<=item.End)
                    {
                        var itemHeight=item.Bottom-item.Top;
                        var height=itemHeight*(value-item.Start)/(item.End-item.Start);
                        return item.Top+height;
                    }
                }
            }
            else
            {
                var down=this.Logarithmic.Down;
                for(var i in down)
                {
                    var item=down[i];
                    if (value>=item.Start && value<=item.End)
                    {
                        var itemHeight=item.Bottom-item.Top;
                        var height=itemHeight*(value-item.Start)/(item.End-item.Start);
                        return item.Top+height;
                    }
                }
            }
        }
        else
        {
            if(value<=this.HorizontalMin) return this.ChartBorder.GetBottomEx();
            if(value>=this.HorizontalMax) return this.ChartBorder.GetTopEx();

            if (value>this.Logarithmic.OpenPrice)
            {
                var up=this.Logarithmic.Up;
                for(var i in up)
                {
                    var item=up[i];
                    if (value>=item.Start && value<=item.End)
                    {
                        var itemHeight=item.Bottom-item.Top;
                        var height=itemHeight*(value-item.Start)/(item.End-item.Start);
                        return item.Bottom-height;
                    }
                }
            }
            else
            {
                var down=this.Logarithmic.Down;
                for(var i in down)
                {
                    var item=down[i];
                    if (value>=item.Start && value<=item.End)
                    {
                        var itemHeight=item.Bottom-item.Top;
                        var height=itemHeight*(value-item.Start)/(item.End-item.Start);
                        return item.Bottom-height;
                    }
                }
            }
        }
    }

    this.GetYLogarithmicData=function(y)
    {
        if (this.CoordinateType==1) //反转坐标
        {
            if (y<this.ChartBorder.GetTopEx()) return this.HorizontalMin;
            if (y>this.ChartBorder.GetBottomEx()) return this.HorizontalMax;

            var up=this.Logarithmic.Up;
            for(var i in up)
            {
                var item=up[i];
                if (y>=item.Top && y<=item.Bottom)
                {
                    return (y-item.Top)/item.Height*(item.End-item.Start)+item.Start;
                }
            }

            var down=this.Logarithmic.Down;
            for(var i in down)
            {
                var item=down[i];
                if (y>=item.Top && y<=item.Bottom)
                {
                    return (y-item.Top)/item.Height*(item.End-item.Start)+item.Start;
                }
            }
        }
        else
        {
            if (y<this.ChartBorder.GetTopEx()) return this.HorizontalMax;
            if (y>this.ChartBorder.GetBottomEx()) return this.HorizontalMin;

            var up=this.Logarithmic.Up;
            for(var i in up)
            {
                var item=up[i];
                if (y>=item.Top && y<=item.Bottom)
                {
                    return (item.Bottom-y)/item.Height*(item.End-item.Start)+item.Start;
                }
            }

            var down=this.Logarithmic.Down;
            for(var i in down)
            {
                var item=down[i];
                if (y>=item.Top && y<=item.Bottom)
                {
                    return (item.Bottom-y)/item.Height*(item.End-item.Start)+item.Start;
                }
            }
        }
    }

    this.CalculateCount=function(zoomIndex)
    {
        var width=this.GetFrameWidth()-g_JSChartResource.FrameMargin;
        return parseInt(width/(ZOOM_SEED[zoomIndex][0] + ZOOM_SEED[zoomIndex][1]));
    }

    this.ZoomUp=function(cursorIndex)
    {
        if (this.ZoomIndex<=0) return false;
        if (this.Data.DataOffset<0) return false;
        var dataCount=this.Data.Data.length;
        var maxDataCount=dataCount+this.RightSpaceCount;

        var rightSpaceCount=0;
        var lastDataIndex = this.Data.DataOffset + this.XPointCount - 1;    //最右边的数据索引
        var lastCursorIndex=this.Data.DataOffset + cursorIndex.Index;
        if (lastDataIndex>=dataCount) 
        {
            rightSpaceCount=lastDataIndex-(this.Data.Data.length-1);    //计算右边预留空间
            lastDataIndex=this.Data.Data.length-1;
            if (rightSpaceCount>this.RightSpaceCount) rightSpaceCount=this.RightSpaceCount;
        }

        var xPointCount=this.CalculateCount(this.ZoomIndex-1);
        JSConsole.Chart.Log(`[KLineFrame::ZoomUp] old status. XPointCount=${xPointCount} ZoomIndex=${this.ZoomIndex} DataCount= ${this.Data.Data.length} rightSpaceCount=${rightSpaceCount}`);

        var isShowAll=false;
        --this.ZoomIndex;
        if (cursorIndex.IsLockRight==true) //固定右边
        {
            var rightDataIndex=this.Data.DataOffset + this.XPointCount;    //最右边的数据索引
            if (xPointCount>rightDataIndex)
            {
                xPointCount=rightDataIndex;
                this.XPointCount=xPointCount;
                this.Data.DataOffset=0;
            }
            else
            {
                var dataOffset=lastDataIndex - (xPointCount-rightSpaceCount)+1;
                this.XPointCount=xPointCount;
                this.Data.DataOffset=dataOffset;
                if (this.Data.DataOffset<0) this.Data.DataOffset=0;
            }
        }
        else if (xPointCount>=maxDataCount) 
        {
            //xPointCount=maxDataCount;
            //this.XPointCount=xPointCount;
            this.Data.DataOffset=0;
            this.XPointCount=xPointCount;
            isShowAll=true;
            JSConsole.Chart.Log(`[KLineFrame::ZoomUp] Show all data. XPointCount=${xPointCount} ZoomIndex=${this.ZoomIndex} DataCount= ${dataCount}`);
        }
        else
        {
            var dataOffset=lastDataIndex - (xPointCount-rightSpaceCount)+1;
            if (cursorIndex.ZoomType==1)    //以十字光标为中心左右放大
            {
                var moveOffset=(this.XPointCount-xPointCount)+1;
                var leftOffset=parseInt(cursorIndex.Index/this.XPointCount*moveOffset);
                var rightOffset=moveOffset-leftOffset;
                var offset=this.Data.DataOffset+leftOffset;
                if (offset<dataCount) dataOffset=this.Data.DataOffset+leftOffset;
            }

            this.XPointCount=xPointCount;
            this.Data.DataOffset=dataOffset;
            if (this.Data.DataOffset<0) this.Data.DataOffset=0;

            JSConsole.Chart.Log(`[KLineFrame::ZoomUp] calculate. XPointCount=${xPointCount} ZoomIndex=${this.ZoomIndex} DataCount= ${dataCount} DataOffset=${this.Data.DataOffset}`);
        }
       
        this.DataWidth = ZOOM_SEED[this.ZoomIndex][0];
        this.DistanceWidth = ZOOM_SEED[this.ZoomIndex][1];
        if (!isShowAll)
        {
            var width=this.GetFrameWidth()-g_JSChartResource.FrameMargin;
            this.TrimKLineDataWidth(width);
        }
        this.LastCalculateStatus.XPointCount=this.XPointCount;
        cursorIndex.Index=lastCursorIndex-this.Data.DataOffset;

        return true;
    }

    this.ZoomDown=function(cursorIndex) //缩小
    {
        if (this.ZoomIndex+1>=ZOOM_SEED.length) return false;
        if (this.Data.DataOffset<0) return false;
        var dataCount=this.Data.Data.length;
        var maxDataCount=dataCount+this.RightSpaceCount;
        //if (this.XPointCount>=maxDataCount) return false;

        var rightSpaceCount=0;
        var lastDataIndex = this.Data.DataOffset + this.XPointCount - 1;    //最右边的数据索引
        if (lastDataIndex>=this.Data.Data.length) 
        {
            rightSpaceCount=lastDataIndex-(this.Data.Data.length-1);    //计算右边预留空间
            lastDataIndex=this.Data.Data.length-1;
            if (rightSpaceCount>this.RightSpaceCount) rightSpaceCount=this.RightSpaceCount;
        }

        var xPointCount=this.CalculateCount(this.ZoomIndex+1);
        var lastCursorIndex=this.Data.DataOffset + cursorIndex.Index;

        JSConsole.Chart.Log(`[KLineFrame::ZoomDown] old status. XPointCount=${xPointCount} ZoomIndex=${this.ZoomIndex} DataCount= ${this.Data.Data.length} lastCursorIndex=${lastCursorIndex} rightSpaceCount=${rightSpaceCount}`);

        var isShowAll=false;
        ++this.ZoomIndex;
        if (cursorIndex.IsLockRight==true) //固定右边
        {
            var rightDataIndex=this.Data.DataOffset + this.XPointCount;    //最右边的数据索引
            if (xPointCount>rightDataIndex)
            {
                xPointCount=rightDataIndex;
                this.XPointCount=xPointCount;
                this.Data.DataOffset=0;
            }
            else
            {
                var dataOffset=lastDataIndex - (xPointCount-rightSpaceCount)+1;
                this.XPointCount=xPointCount;
                this.Data.DataOffset=dataOffset;
                if (this.Data.DataOffset<0) this.Data.DataOffset=0;
            }
        }
        else if (xPointCount>=maxDataCount)     //所有数据无法显示完一屏
        {
            //xPointCount=maxDataCount;
            this.XPointCount=xPointCount;
            this.Data.DataOffset=0;
            isShowAll=true; //数据铺满全屏, 不需要调整宽度
            JSConsole.Chart.Log(`[KLineFrame::ZoomDown] Show all data. XPointCount=${xPointCount} ZoomIndex=${this.ZoomIndex} DataCount= ${dataCount}`);
        }
        else
        {
            var dataOffset=lastDataIndex - (xPointCount-rightSpaceCount)+1;
            if (cursorIndex.ZoomType==1)    //当前十字光标位置左右同时缩小
            {
                var moveOffset=(xPointCount-this.XPointCount)+1;
                var leftOffset=parseInt(cursorIndex.Index/this.XPointCount*moveOffset);
                var rightOffset=moveOffset-leftOffset;
                var dataOffset=this.Data.DataOffset-leftOffset;
                if (dataOffset+(xPointCount-this.RightSpaceCount)>=dataCount) dataOffset=this.Data.DataOffset-moveOffset;
            }

            this.XPointCount=xPointCount;
            this.Data.DataOffset=dataOffset;
            if (this.Data.DataOffset<0) this.Data.DataOffset=0;

            JSConsole.Chart.Log(`[KLineFrame::ZoomDown] calculate. XPointCount=${xPointCount} ZoomIndex=${this.ZoomIndex} DataCount= ${dataCount} DataOffset=${this.Data.DataOffset}`);
        }

        this.DataWidth = ZOOM_SEED[this.ZoomIndex][0];
        this.DistanceWidth = ZOOM_SEED[this.ZoomIndex][1];
        if (!isShowAll) 
        {
            var width=this.GetFrameWidth()-g_JSChartResource.FrameMargin;
            this.TrimKLineDataWidth(width);
        }
        this.LastCalculateStatus.XPointCount=this.XPointCount;
        cursorIndex.Index=lastCursorIndex-this.Data.DataOffset;

        return true;
    }

    this.GetFrameWidth=function()
    {
        if (this.IsHScreen) 
        {
            var border=this.ChartBorder.GetHScreenBorder();
            return border.BottomEx-border.TopEx;
            //return this.ChartBorder.GetHeight();
        }
        else
        {
            var border=this.ChartBorder.GetBorder();
            return border.RightEx-border.LeftEx;
            //return this.ChartBorder.GetWidth();
        }
    }

    this.DrawCustomHorizontal=function()    //Y轴刻度定制显示
    {
        for(var i in this.CustomHorizontalInfo)
        {
            var item=this.CustomHorizontalInfo[i];
            switch(item.Type)
            {
                case 0: //最新价格刻度
                case 1: //固定价格刻度
                    this.DrawCustomItem(item);  
                    break;
            }
        }
    }

    this.DrawCustomVerticalItem=function(item)
    {
        this.Canvas.save(); 
        if (item.Data.Line.Type==1) this.Canvas.setLineDash([5,5]);   //虚线
        this.Canvas.strokeStyle=item.Data.Line.Color;
        this.Canvas.beginPath();
        if (item.IsHScreen)
        {
            this.Canvas.moveTo(item.Top,ToFixedPoint(item.X));
            this.Canvas.lineTo(item.Bottom,ToFixedPoint(item.X));
        }
        else
        {
            this.Canvas.moveTo(ToFixedPoint(item.X),item.Top);
            this.Canvas.lineTo(ToFixedPoint(item.X),item.Bottom);
        }
        this.Canvas.stroke();
        this.Canvas.restore();
    }

    this.DrawCustomVertical=function()  //X轴定制刻度显示
    {
        if (!this.CustomVerticalInfo) return;
        if (this.CustomVerticalInfo.length<=0) return;
        if (!this.Data) return;

        var isHScreen=this.IsHScreen;
        var top=this.ChartBorder.GetTopEx();
        var bottom=this.ChartBorder.GetBottomEx();
       
        var dataWidth=this.DataWidth;
        var distanceWidth=this.DistanceWidth;
        var xOffset=this.ChartBorder.GetLeft()+distanceWidth/2.0+2.0;

        if (isHScreen) 
        {
            xOffset=this.ChartBorder.GetTop()+distanceWidth/2.0+2.0;
            top=this.ChartBorder.GetLeftEx();
            bottom=this.ChartBorder.GetRightEx();
        }

        var j=0;
        for(var i=this.Data.DataOffset;i<this.Data.Data.length && j<this.XPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var kItem=this.Data.Data[i];
            for(var k in this.CustomVerticalInfo)
            {
                var item=this.CustomVerticalInfo[k];
                if (item.Type!=0) continue;

                if (IFrameSplitOperator.IsNumber(item.Time))
                {
                    if (kItem.Date!=item.Date || kItem.Time!=item.Time) continue;
                }
                else
                {
                    if (kItem.Date!=item.Date) continue;
                }

                var left=xOffset;
                var right=xOffset+dataWidth;
                var x=left+(right-left)/2;  

                var DrawData={X:x, Top:top, Bottom:bottom, Data:item , IsHScreen:isHScreen};
                this.DrawCustomVerticalItem(DrawData);
                if (this.DrawCustomVerticalEvent) 
                    this.DrawCustomVerticalEvent.Callback(this.DrawCustomVerticalEvent, DrawData, this);

                break;
            }
        }

        for(var i=1;j<this.XPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            for(var k in  this.CustomVerticalInfo)
            {
                var item=this.CustomVerticalInfo[k];
                if (item.Type!=1) continue;
                if (item.Space!=i) continue;

                var left=xOffset;
                var right=xOffset+dataWidth;
                var x=left+(right-left)/2; 
                
                var DrawData={X:x, Top:top, Bottom:bottom, Data:item,IsHScreen:isHScreen };
                this.DrawCustomVerticalItem(DrawData);
                if (this.DrawCustomVerticalEvent) 
                    this.DrawCustomVerticalEvent.Callback(this.DrawCustomVerticalEvent, DrawData, this);

                break;
            }
        }
    }
}

function OverlayKLineFrame()
{
    this.newMethod=KLineFrame;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='OverlayKLineFrame';

    this.MainFrame=null;    //主框架
    this.IsShareY=false;    //使用和主框架公用Y轴
    this.RightOffset=50;
    this.PenBorder=g_JSChartResource.OverlayFrame.BolderPen; //'rgb(0,0,0)'
    this.IsShow=true;   //坐标是否显示
    this.Title=null;
    this.TitleColor=g_JSChartResource.OverlayFrame.TitleColor;
    this.TitleFont=g_JSChartResource.OverlayFrame.TitleFont;

    this.Draw=function()
    {
        this.SplitXYCoordinate();

        if (this.IsShow)
        {
            this.DrawVertical();
            this.DrawHorizontal();
            this.DrawTitle();
        }
        
        this.SizeChange=false;
        this.XYSplit=false;
    }

    this.DrawTitle=function()   //画标题
    {
        if (!this.Title) return;
        var border=this.ChartBorder.GetBorder();
        var top = this.ChartBorder.GetTopTitle();
        var bottom = border.Bottom;
        var right=border.Right;
        right+=this.RightOffset;

        this.Canvas.fillStyle=this.TitleColor;
        this.Canvas.font=this.TitleFont;
        this.Canvas.textAlign="center";
        this.Canvas.textBaseline="top";

        var xText=right-2,yText=top+(bottom-top)/2;
        this.Canvas.save();
        this.Canvas.translate(xText, yText);
        this.Canvas.rotate(90 * Math.PI / 180);
        this.Canvas.fillText(this.Title, 0, 0);
        this.Canvas.restore();
    }

    //分割x,y轴坐标信息
    this.SplitXYCoordinate=function()
    {
        if (this.XYSplit==false) return;

        if (this.IsShareY)  //和主图指标共享Y轴坐标
        {
            this.HorizontalMax=this.MainFrame.HorizontalMax;
            this.HorizontalMin=this.MainFrame.HorizontalMin;
            this.HorizontalInfo=[];
            for(var i in this.MainFrame.HorizontalInfo)
            {
                var item=this.MainFrame.HorizontalInfo[i];
                this.HorizontalInfo.push(item);
            }

            this.CoordinateType=this.MainFrame.CoordinateType;
        }
        else    //独立Y轴坐标
        {
            if (this.YSplitOperator!=null) this.YSplitOperator.Operator();
        }
        
        // if (this.XSplitOperator!=null) this.XSplitOperator.Operator(); 子坐标和主坐标X轴一致 所以不用计算
    }

    //画Y轴
    this.DrawHorizontal=function()
    {
        var border=this.ChartBorder.GetBorder();
        var left=border.Left;
        var right=border.Right;
        var bottom = border.Bottom;
        var top = this.ChartBorder.GetTopTitle();
        var borderRight=this.ChartBorder.Right;
        right+=this.RightOffset;

        var yPrev=null; //上一个坐标y的值
        for(var i=this.HorizontalInfo.length-1; i>=0; --i)  //从上往下画分割线
        {
            var item=this.HorizontalInfo[i];
            var y=this.GetYFromData(item.Value);
            if (y!=null && Math.abs(y-yPrev)<this.MinYDistance) continue;  //两个坐标在近了 就不画了

            if (y >= bottom - 2) this.Canvas.textBaseline = 'bottom';
            else if (y <= top + 2) this.Canvas.textBaseline = 'top';
            else this.Canvas.textBaseline = "middle";

            this.Canvas.strokeStyle=this.PenBorder;
            this.Canvas.beginPath();
            this.Canvas.moveTo(right-2,ToFixedPoint(y));
            this.Canvas.lineTo(right,ToFixedPoint(y));
            this.Canvas.stroke();

            //坐标信息 右边 间距小于10 不画坐标
            if (item.Message[1]!=null && borderRight>10)
            {
                if (item.Font!=null) this.Canvas.font=item.Font;

                var text=item.Message[1];
                if (Array.isArray(item.Message[1])) text=item.Message[1][0];
               
                this.Canvas.fillStyle=item.TextColor;
                this.Canvas.textAlign="left";
                this.Canvas.fillText(text,right+2,y);
            }

            yPrev=y;
        }
    }

    //画X轴
    this.DrawVertical=function()
    {
        var border=this.ChartBorder.GetBorder();
        var top=border.TopEx;
        //var left=this.ChartBorder.GetLeft();
        var right=border.Right;
        var bottom=border.BottomEx;
        right+=this.RightOffset;

        this.Canvas.strokeStyle=this.PenBorder;
        this.Canvas.beginPath();
        this.Canvas.moveTo(ToFixedPoint(right),ToFixedPoint(top));
        this.Canvas.lineTo(ToFixedPoint(right),ToFixedPoint(bottom));
        this.Canvas.stroke();
    }
}

//K线横屏框架
function KLineHScreenFrame()
{
    this.newMethod=KLineFrame;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='KLineHScreenFrame';
    this.IsHScreen=true;        //是否是横屏

    //画标题背景色
    this.DrawTitleBG=function()
    {
        if (this.ChartBorder.TitleHeight<=0) return;

        var border=this.ChartBorder.GetHScreenBorder();
        var left=ToFixedPoint(border.RightTitle);
        var top=ToFixedPoint(border.Top);
        var bottom=ToFixedPoint(border.Bottom);
        var width=this.ChartBorder.TitleHeight;
        var height=bottom-top;

        this.Canvas.fillStyle=this.TitleBGColor;
        this.Canvas.fillRect(left,top,width,height);
    }

    this.DrawToolbar=function()
    {
        return;
    }

    this.GetYFromData=function(value,isLimit)
    {
        var border=this.ChartBorder.GetHScreenBorder();
        if (isLimit===false)
        {
            var width=(border.RightEx-border.LeftEx)*(value-this.HorizontalMin)/(this.HorizontalMax-this.HorizontalMin);
            return border.LeftEx+width;
        }
        else
        {
            if(value<=this.HorizontalMin) return border.LeftEx;
            if(value>=this.HorizontalMax) return border.RightEx;
    
            var width=(border.RightEx-border.LeftEx)*(value-this.HorizontalMin)/(this.HorizontalMax-this.HorizontalMin);
            return border.LeftEx+width;
        }
    }

    //画Y轴
    this.DrawHorizontal=function()
    {
        var border=this.ChartBorder.GetHScreenBorder();
        var top=border.Top;
        var bottom=border.Bottom;
        var borderTop=this.ChartBorder.Top;
        var borderBottom=this.ChartBorder.Bottom;
        var left=border.Left;
        var right=border.Right;

        var yPrev=null; //上一个坐标y的值
        var pixelTatio = GetDevicePixelRatio(); //获取设备的分辨率

        var isDrawLeft=borderTop>10*pixelTatio && this.IsShowYText[0]===true && this.YTextPosition[0]!=2;
        var isDrawRight=borderBottom>10*pixelTatio && this.IsShowYText[1]===true && this.YTextPosition[1]!=2;

        for(var i=this.HorizontalInfo.length-1; i>=0; --i)  //从左往右画分割线
        {
            var item=this.HorizontalInfo[i];
            var y=this.GetYFromData(item.Value);
            if (y!=null && Math.abs(y-yPrev)<this.MinYDistance) continue;  //两个坐标在近了 就不画了

            if (y!=left)
            {
                if (item.LineType==2)
                {
                    this.Canvas.strokeStyle=item.LineColor;
                    this.Canvas.setLineDash([5*pixelTatio,5*pixelTatio]);   //虚线
                    this.Canvas.beginPath();
                    this.Canvas.moveTo(ToFixedPoint(y),top);
                    this.Canvas.lineTo(ToFixedPoint(y),bottom);
                    this.Canvas.stroke();
                    this.Canvas.setLineDash([]);
                }
                else if (item.LineType>0)
                {
                    this.Canvas.strokeStyle=item.LineColor;
                    if (g_JSChartResource.FrameYLineDash)
                    {
                        this.Canvas.setLineDash(g_JSChartResource.FrameYLineDash);   //虚线
                        this.Canvas.beginPath();
                        this.Canvas.moveTo(ToFixedPoint(y),top);
                        this.Canvas.lineTo(ToFixedPoint(y),bottom);
                        this.Canvas.stroke();
                        this.Canvas.setLineDash([]);
                    }
                    else
                    {
                        this.Canvas.beginPath();
                        this.Canvas.moveTo(ToFixedPoint(y),top);
                        this.Canvas.lineTo(ToFixedPoint(y),bottom);
                        this.Canvas.stroke();
                    }
                }
            }
            
            //坐标信息 左边 间距小于10 不画坐标
            if (item.Message[0]!=null && isDrawLeft)
            {
                if (item.Font!=null) this.Canvas.font=item.Font;

                this.Canvas.fillStyle=item.TextColor;
                this.Canvas.textAlign="right";
                this.Canvas.textBaseline="middle";

                var xText=y,yText=top;
                this.Canvas.save();
                this.Canvas.translate(xText, yText);
                this.Canvas.rotate(90 * Math.PI / 180);
                this.Canvas.fillText(item.Message[0], -2, 0);
                this.Canvas.restore();
            }

            //坐标信息 右边 间距小于10 不画坐标
            if (item.Message[1]!=null && isDrawRight)
            {
                if (item.Font!=null) this.Canvas.font=item.Font;

                this.Canvas.fillStyle=item.TextColor;
                this.Canvas.textAlign="left";
                this.Canvas.textBaseline="middle";
                var xText=y,yText=bottom;
                this.Canvas.save();
                this.Canvas.translate(xText, yText);
                this.Canvas.rotate(90 * Math.PI / 180);
                this.Canvas.fillText(item.Message[1], 2, 0);
                this.Canvas.restore();
            }

            yPrev=y;
        }
    }

    //Y刻度画在左边内部
    this.DrawInsideHorizontal = function () 
    {
        if (this.IsShowYText[0]===false && this.IsShowYText[1]===false) return;

        var left = this.ChartBorder.GetLeft();
        var right = this.ChartBorder.GetRightEx();
        var top=this.ChartBorder.GetTop();
        var bottom=this.ChartBorder.GetBottom();
        var borderTop=this.ChartBorder.Top;
        var borderBottom=this.ChartBorder.Bottom;
        var titleHeight = this.ChartBorder.TitleHeight;
        var pixelTatio = GetDevicePixelRatio();
        
        var isDrawLeft= (borderTop<10*pixelTatio || this.YTextPosition[0]==2) && this.IsShowYText[0]===true;
        var isDrawRight= (borderBottom<10*pixelTatio || this.YTextPosition[1]==2) && this.IsShowYText[1]===true;

        if ( isDrawLeft || isDrawRight )
        {
            var pixelTatio = GetDevicePixelRatio();
            var yPrev = null; //上一个坐标y的值
            for (var i = this.HorizontalInfo.length - 1; i >= 0; --i)  //从上往下画分割线
            {
                var item = this.HorizontalInfo[i];
                var y = this.GetYFromData(item.Value);
                if (y != null && yPrev!=null && Math.abs(y - yPrev) < this.MinYDistance) continue;  //两个坐标在近了 就不画了

                //坐标信息 左边 间距小于10 画在内部
                if (item.Message[0] != null && isDrawLeft) 
                {
                    if (item.Font != null) this.Canvas.font = item.Font;
                    this.Canvas.fillStyle = item.TextColor;
                    this.Canvas.textAlign = "left";
                    if (y >= right - 2) this.Canvas.textBaseline = 'top';
                    else if (y <= left + 2) this.Canvas.textBaseline = 'bottom';
                    else this.Canvas.textBaseline = "middle";

                    var textObj={ X:left, Y:y, Text:{ BaseLine:this.Canvas.textBaseline, TextAlign: this.Canvas.textAlign, Font:this.Canvas.font, Value:item.Message[0]}} ;
                    var xText=y,yText=top;
                    this.Canvas.save();
                    this.Canvas.translate(xText, yText);
                    this.Canvas.rotate(90 * Math.PI / 180);
                    this.Canvas.fillText(item.Message[0], -2, 0);
                    this.Canvas.restore();
                }

                if (item.Message[1] != null && isDrawRight)
                {
                    if (item.Font != null) this.Canvas.font = item.Font;
                    this.Canvas.fillStyle = item.TextColor;
                    this.Canvas.textAlign = "right";
                    if (y >= right - 2) this.Canvas.textBaseline = 'top';
                    else if (y <= left + 2) this.Canvas.textBaseline = 'bottom';
                    else this.Canvas.textBaseline = "middle";
                    var textWidth = this.Canvas.measureText(item.Message[1]).width;
                    var textObj={ X:right-textWidth, Y:y, Text:{ BaseLine:this.Canvas.textBaseline, TextAlign: this.Canvas.textAlign, Font:this.Canvas.font, Value:item.Message[1]}} ;

                    var xText=y,yText=bottom;
                    this.Canvas.save();
                    this.Canvas.translate(xText, yText);
                    this.Canvas.rotate(90 * Math.PI / 180);
                    this.Canvas.fillText(item.Message[1], 2, 0);
                    this.Canvas.restore();
                }
                yPrev = y;
            }
        }
    }

    this.GetXFromIndex=function(index)
    {
        if (index < 0) index = 0;
	    if (index > this.xPointCount - 1) index = this.xPointCount - 1;

        var border=this.ChartBorder.GetHScreenBorder();
        var offset=border.TopEx+ g_JSChartResource.FrameLeftMargin + this.DistanceWidth/2+this.DataWidth/2;
        for(var i=1;i<=index;++i)
        {
            offset+=this.DistanceWidth+this.DataWidth;
        }

        return offset;
    }

    //画X轴
    this.DrawVertical=function()
    {
        var border=this.ChartBorder.GetHScreenBorder();
        var left=border.Left;
        var right=border.RightTitle;
        var bottom=border.Bottom;
        var pixelRatio = GetDevicePixelRatio(); //获取设备的分辨率
        var xPrev=null; //上一个坐标x的值
        for(var i in this.VerticalInfo)
        {
            var x=this.GetXFromIndex(this.VerticalInfo[i].Value);
            if (x>=bottom) break;
            if (xPrev!=null && Math.abs(x-xPrev)<80) continue;

            var item=this.VerticalInfo[i];
            if (item.LineType==2)
            {
                this.Canvas.strokeStyle=this.VerticalInfo[i].LineColor;
                this.Canvas.setLineDash([5*pixelRatio,5*pixelRatio]);   //虚线
                this.Canvas.beginPath();
                this.Canvas.moveTo(left,ToFixedPoint(x));
                this.Canvas.lineTo(right,ToFixedPoint(x));
                this.Canvas.stroke();
                this.Canvas.setLineDash([]);
            }
            else if (item.LineType>0)
            {
                this.Canvas.strokeStyle=this.VerticalInfo[i].LineColor;
                if (g_JSChartResource.FrameXLineDash)
                {
                    this.Canvas.setLineDash(g_JSChartResource.FrameXLineDash);   //虚线
                    this.Canvas.beginPath();
                    this.Canvas.moveTo(left,ToFixedPoint(x));
                    this.Canvas.lineTo(right,ToFixedPoint(x));
                    this.Canvas.stroke();
                    this.Canvas.setLineDash([]);
                }
                else    //实线
                {
                    this.Canvas.beginPath();
                    this.Canvas.moveTo(left,ToFixedPoint(x));
                    this.Canvas.lineTo(right,ToFixedPoint(x));
                    this.Canvas.stroke();
                } 
            }
            

            if (this.VerticalInfo[i].Message[0]!=null)
            {
                if (this.VerticalInfo[i].Font!=null)
                    this.Canvas.font=this.VerticalInfo[i].Font;

                this.Canvas.fillStyle=this.VerticalInfo[i].TextColor;
                var testWidth=this.Canvas.measureText(this.VerticalInfo[i].Message[0]).width;
                if (x<testWidth/2)
                {
                    this.Canvas.textAlign="left";
                    this.Canvas.textBaseline="top";
                }
                else
                {
                    this.Canvas.textAlign="center";
                    this.Canvas.textBaseline="top";
                }

                var xText=left,yText=x;
                this.Canvas.save();
                this.Canvas.translate(xText, yText);
                this.Canvas.rotate(90 * Math.PI / 180);
                this.Canvas.fillText(this.VerticalInfo[i].Message[0], 0, this.XBottomOffset);
                this.Canvas.restore();
            }

            xPrev=x;
        }
    }

    //Y坐标转y轴数值
    this.GetYData=function(x)
    {
        var border=this.ChartBorder.GetHScreenBorder();
        if (x<border.LeftEx) return this.HorizontalMin;
		if (x>border.RightEx) return this.HorizontalMax;

        var width=border.RightEx-border.LeftEx;
		return (x-border.LeftEx)/width*(this.HorizontalMax-this.HorizontalMin)+this.HorizontalMin;
    }

    //X坐标转x轴数值
    this.GetXData=function(y)
    {
        var border=this.ChartBorder.GetHScreenBorder();
        if (y<=border.TopEx) return 0;
		if (y>=border.BottomEx) return this.XPointCount-1;

        var left=border.TopEx;
        var right=border.BottomEx;
        var distanceWidth=this.DistanceWidth;
        var dataWidth=this.DataWidth;

        var index=0;
        var xPoint=left+distanceWidth/2+ dataWidth+distanceWidth;
        while(xPoint<right && index<10000 && index+1<this.XPointCount)  //自己算x的数值
        {
            if (xPoint>y) break;
            xPoint+=(dataWidth+distanceWidth);
            ++index;
        }
        return index;

		//return (y-this.ChartBorder.GetTop())*(this.XPointCount*1.0/this.ChartBorder.GetHeight());
    }

    //计算数据宽度
    /*
    this.CalculateDataWidth=function()
    {
        if (this.XPointCount<2) return;

        var width=this.ChartBorder.GetHeight()-g_JSChartResource.FrameMargin;

        for(var i=0;i<ZOOM_SEED.length;++i)
        {
            if((ZOOM_SEED[i][0] + ZOOM_SEED[i][1]) * this.XPointCount < width)
            {
                this.ZoomIndex=i;
                this.DataWidth = ZOOM_SEED[i][0];
                this.DistanceWidth = ZOOM_SEED[i][1];
                if (i == 0) break;      // 如果是最大的缩放因子，不再调整数据宽度

                this.TrimKLineDataWidth(width);
                return;
            }
        }
    }
    */

    /*
    this.ZoomUp=function(cursorIndex)
    {
        if (this.ZoomIndex<=0) return false;
        if (this.Data.DataOffset<0) return false;
        var dataCount=this.Data.Data.length;
        var maxDataCount=dataCount+this.RightSpaceCount;
        if (this.XPointCount>=dataCount) return false;

        var rightSpaceCount=0;
        var lastDataIndex = this.Data.DataOffset + this.XPointCount - 1;    //最右边的数据索引
        var lastCursorIndex=this.Data.DataOffset + cursorIndex.Index;
        if (lastDataIndex>=dataCount) 
        {
            rightSpaceCount=lastDataIndex-(dataCount-1);    //计算右边预留空间
            lastDataIndex=dataCount-1;
            if (rightSpaceCount>this.RightSpaceCount) rightSpaceCount=this.RightSpaceCount;
        }
        
        var xPointCount=this.CalculateCount(this.ZoomIndex-1);
        JSConsole.Chart.Log(`[KLineHScreenFrame::ZoomUp] old status. XPointCount=${xPointCount} ZoomIndex=${this.ZoomIndex} DataCount= ${this.Data.Data.length} rightSpaceCount=${rightSpaceCount}`);
        
        --this.ZoomIndex;
        if (xPointCount>=maxDataCount) 
        {
            xPointCount=maxDataCount;
            this.XPointCount=xPointCount;
            this.Data.DataOffset=0;

            JSConsole.Chart.Log(`[KLineHScreenFrame::ZoomUp] Show all data. XPointCount=${xPointCount} ZoomIndex=${this.ZoomIndex} DataCount= ${dataCount}`);
        }
        else
        {
            this.XPointCount=xPointCount;
            this.Data.DataOffset = lastDataIndex - (this.XPointCount-rightSpaceCount)+1;

            JSConsole.Chart.Log(`[KLineHScreenFrame::ZoomUp] calculate. XPointCount=${xPointCount} ZoomIndex=${this.ZoomIndex} DataCount= ${dataCount} DataOffset=${this.Data.DataOffset}`);
        }

        this.DataWidth = ZOOM_SEED[this.ZoomIndex][0];
	    this.DistanceWidth = ZOOM_SEED[this.ZoomIndex][1];
        var width=this.ChartBorder.GetHeight()-g_JSChartResource.FrameMargin;
        this.TrimKLineDataWidth(width);
        this.LastCalculateStatus.XPointCount=this.XPointCount;
        cursorIndex.Index=lastCursorIndex-this.Data.DataOffset;

        return true;
    }

    this.ZoomDown=function(cursorIndex)
    {
        if (this.ZoomIndex+1>=ZOOM_SEED.length) return false;
        if (this.Data.DataOffset<0) return false;
        var dataCount=this.Data.Data.length;
        var maxDataCount=dataCount+this.RightSpaceCount;
        if (this.XPointCount>=dataCount) return false;

        var rightSpaceCount=0;
        var lastDataIndex = this.Data.DataOffset + this.XPointCount - 1;    //最右边的数据索引
        if (lastDataIndex>=this.Data.Data.length) 
        {
            rightSpaceCount=lastDataIndex-(this.Data.Data.length-1);    //计算右边预留空间
            lastDataIndex=this.Data.Data.length-1;
            if (rightSpaceCount>this.RightSpaceCount) rightSpaceCount=this.RightSpaceCount;
        }

        var xPointCount=this.CalculateCount(this.ZoomIndex+1);
        var lastCursorIndex=this.Data.DataOffset + cursorIndex.Index;
        JSConsole.Chart.Log(`[KLineHScreenFrame::ZoomDown] old status. XPointCount=${xPointCount} ZoomIndex=${this.ZoomIndex} DataCount= ${this.Data.Data.length} lastCursorIndex=${lastCursorIndex} rightSpaceCount=${rightSpaceCount}`);

        ++this.ZoomIndex;
        if (xPointCount>=maxDataCount) 
        {
            xPointCount=maxDataCount;
            this.XPointCount=xPointCount;
            this.Data.DataOffset=0;
            
            JSConsole.Chart.Log(`[KLineHScreenFrame::ZoomDown] Show all data. XPointCount=${xPointCount} ZoomIndex=${this.ZoomIndex} DataCount= ${dataCount}`);
        }
        else
        {
            this.XPointCount=xPointCount;
            this.Data.DataOffset = lastDataIndex - (this.XPointCount-rightSpaceCount)+1;

            JSConsole.Chart.Log(`[KLineHScreenFrame::ZoomDown] calculate. XPointCount=${xPointCount} ZoomIndex=${this.ZoomIndex} DataCount= ${dataCount} DataOffset=${this.Data.DataOffset}`);
        }

        this.DataWidth = ZOOM_SEED[this.ZoomIndex][0];
	    this.DistanceWidth = ZOOM_SEED[this.ZoomIndex][1];
        var width=this.ChartBorder.GetHeight()-g_JSChartResource.FrameMargin;
        this.TrimKLineDataWidth(width);
        this.LastCalculateStatus.XPointCount=this.XPointCount;
        cursorIndex.Index=lastCursorIndex-this.Data.DataOffset;

        return true;
    }
    */
}


function OverlayKLineHScreenFrame()
{
    this.newMethod=KLineHScreenFrame;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='OverlayKLineHScreenFrame';
    this.MainFrame=null;    //主框架
    this.IsShareY=false;    //使用和主框架公用Y轴
    this.RightOffset=50;
    this.PenBorder=g_JSChartResource.OverlayFrame.BolderPen; //'rgb(0,0,0)'
    this.IsShow=true;   //坐标是否显示
    this.Title=null;
    this.TitleColor=g_JSChartResource.OverlayFrame.TitleColor;
    this.TitleFont=g_JSChartResource.OverlayFrame.TitleFont;

    this.Draw=function()
    {
        this.SplitXYCoordinate();

        if (this.IsShow)
        {
            this.DrawVertical();
            this.DrawHorizontal();
            this.DrawTitle();
        }
        
        this.SizeChange=false;
        this.XYSplit=false;
    }

    this.DrawTitle=function()   //画标题
    {
        /*
        if (!this.Title) return;
        var top = this.ChartBorder.GetTopTitle();
        var bottom = this.ChartBorder.GetBottom();
        var right=this.ChartBorder.GetRight();
        right+=this.RightOffset;

        this.Canvas.fillStyle=this.TitleColor;
        this.Canvas.font=this.TitleFont;
        this.Canvas.textAlign="center";
        this.Canvas.textBaseline="top";

        var xText=right-2,yText=top+(bottom-top)/2;
        this.Canvas.save();
        this.Canvas.translate(xText, yText);
        this.Canvas.rotate(90 * Math.PI / 180);
        this.Canvas.fillText(this.Title, 0, 0);
        this.Canvas.restore();
        */
    }

    //分割x,y轴坐标信息
    this.SplitXYCoordinate=function()
    {
        if (this.XYSplit==false) return;
        if (this.IsShareY)  //和主图指标共享Y轴坐标
        {
            this.HorizontalMax=this.MainFrame.HorizontalMax;
            this.HorizontalMin=this.MainFrame.HorizontalMin;
            this.HorizontalInfo=[];
            for(var i in this.MainFrame.HorizontalInfo)
            {
                var item=this.MainFrame.HorizontalInfo[i];
                this.HorizontalInfo.push(item);
            }
        }
        else
        {
            if (this.YSplitOperator!=null) this.YSplitOperator.Operator();
        }
        // if (this.XSplitOperator!=null) this.XSplitOperator.Operator(); 子坐标和主坐标X轴一致 所以不用计算
    }

    //画Y轴
    this.DrawHorizontal=function()
    {
        /*
        var left=this.ChartBorder.GetLeft();
        var right=this.ChartBorder.GetRight();
        var bottom = this.ChartBorder.GetBottom();
        var top = this.ChartBorder.GetTopTitle();
        var borderRight=this.ChartBorder.Right;
        right+=this.RightOffset;

        var yPrev=null; //上一个坐标y的值
        for(var i=this.HorizontalInfo.length-1; i>=0; --i)  //从上往下画分割线
        {
            var item=this.HorizontalInfo[i];
            var y=this.GetYFromData(item.Value);
            if (y!=null && Math.abs(y-yPrev)<this.MinYDistance) continue;  //两个坐标在近了 就不画了

            if (y >= bottom - 2) this.Canvas.textBaseline = 'bottom';
            else if (y <= top + 2) this.Canvas.textBaseline = 'top';
            else this.Canvas.textBaseline = "middle";

            this.Canvas.strokeStyle=this.PenBorder;
            this.Canvas.beginPath();
            this.Canvas.moveTo(right-2,ToFixedPoint(y));
            this.Canvas.lineTo(right,ToFixedPoint(y));
            this.Canvas.stroke();

            //坐标信息 右边 间距小于10 不画坐标
            if (item.Message[1]!=null && borderRight>10)
            {
                if (item.Font!=null) this.Canvas.font=item.Font;

                this.Canvas.fillStyle=item.TextColor;
                this.Canvas.textAlign="left";
                this.Canvas.fillText(item.Message[1],right+2,y);
            }

            yPrev=y;
        }
        */
    }

    //画X轴
    this.DrawVertical=function()
    {
        /*
        var top=this.ChartBorder.GetTopEx();
        //var left=this.ChartBorder.GetLeft();
        var right=this.ChartBorder.GetRight();
        var bottom=this.ChartBorder.GetBottomEx();
        right+=this.RightOffset;

        this.Canvas.strokeStyle=this.PenBorder;
        this.Canvas.beginPath();
        this.Canvas.moveTo(ToFixedPoint(right),ToFixedPoint(top));
        this.Canvas.lineTo(ToFixedPoint(right),ToFixedPoint(bottom));
        this.Canvas.stroke();
        */
    }
}

function SubFrameItem()
{
    this.Frame;
    this.Height;
    this.OverlayIndex=[];   //叠加指标
    this.Interval=60;       //子坐标间间距
}

function OverlayIndexItem()
{
    this.Frame;
    this.ChartPaint=[];
    this.Identify=Guid();
    this.Scprit;        //脚本

    this.UpdateFrameMaxMin=function()   //调整坐标最大 最小值
    {
        var value={ Max:null, Min:null }
        if (this.Frame.IsShareY)    //共享Y轴坐标
        {
            this.Frame.XYSplit=true;
            return;
        }

        if (this.Frame.YSpecificMaxMin) //固定坐标
        {
            value.Max=this.Frame.YSpecificMaxMin.Max;
            value.Min=this.Frame.YSpecificMaxMin.Min;
        }
        else
        {
            for(var i in this.ChartPaint)
            {
                var paint=this.ChartPaint[i];
                var range=paint.GetMaxMin();

                if (IFrameSplitOperator.IsNumber(range.Max))
                {
                    if (value.Max==null || value.Max<range.Max) value.Max=range.Max;
                }

                if (IFrameSplitOperator.IsNumber(range.Min))
                {
                    if (value.Min==null || value.Min>range.Min) value.Min=range.Min;
                }
            }
        }

        if (value.Max!=null && value.Min!=null)
        {
            this.Frame.HorizontalMax=value.Max;
            this.Frame.HorizontalMin=value.Min;
            this.Frame.XYSplit=true;
        }
    }
}

//行情框架
function HQTradeFrame()
{
    this.SubFrame=new Array();              //SubFrameItem 数组
    this.SizeChange=true;                   //大小是否改变
    this.ChartBorder;
    this.Canvas;                            //画布
    this.ScreenImageData;                   //截图
    this.Data;                              //主数据
    this.Position;                          //画布的位置
    this.SizeChange=true;
    this.MinSubFrameHeight=g_JSChartResource.DragSubFrameBorder.MinFrameHeight;
    this.DragBorderHeight=g_JSChartResource.DragSubFrameBorder.TopBorderHeight; //拖拽边框高度

    this.OnMoveFromeBorder=function(index, yMove)
    {
        if (this.SubFrame.length<=0) return false;

        var topFrame=this.SubFrame[index];
        var bottomFrame=null;
        for(var i=index+1;i<this.SubFrame.length;++i)
        {
            var item=this.SubFrame[i];
            if (item.Height>0)
            {
                bottomFrame=item;
                break;
            }
        }

        if (!topFrame || !bottomFrame) return false;

        var bottomBackup=topFrame.Frame.ChartBorder.Bottom;
        var topBackup=bottomFrame.Frame.ChartBorder.Top;

        topFrame.Frame.ChartBorder.Bottom-=yMove;
        bottomFrame.Frame.ChartBorder.Top+=yMove;

        var height=topFrame.Frame.ChartBorder.GetHeightEx();
        var height2=bottomFrame.Frame.ChartBorder.GetHeightEx();
        
        //缩小的时候 小于最小高度 不处理
        if ((height<this.MinSubFrameHeight && yMove<0) || (height2<this.MinSubFrameHeight && yMove>0)) 
        {
            topFrame.Frame.ChartBorder.Bottom=bottomBackup;
            bottomFrame.Frame.ChartBorder.Top=topBackup;
            return false;
        }
        
        return true;
    }

    this.ReDrawToolbar=function()
    {
        for(var i in this.SubFrame)
        {
            this.SubFrame[i].Frame.ReDrawToolbar=true;
        }
    }

    this.SetFrameBorderSizeChange=function()
    {
        var firstFrame=this.SubFrame[0];
        if (!firstFrame || !firstFrame.Frame) return;

        var splitOper=firstFrame.Frame.YSplitOperator;  
        if (!splitOper) return;
        if (splitOper.CoordinateType==2) //对数坐标 需要重新计算Y轴分割
        {
            firstFrame.Frame.XYSplit=true;
        }
    }

    this.CancelZoomUpDownFrameY=function(obj)
    {
        var index=obj.Index;
        if (this.SubFrame.length<=0) return false;
        if (!this.SubFrame[index]) return false;

        var subFrame=this.SubFrame[index];
        var frame=subFrame.Frame;
        var splitOper=frame.YSplitOperator;

        if (splitOper.FixedYMaxMin)
        {
            splitOper.FixedYMaxMin=null;
            frame.XYSplit=true;
            for(var i in subFrame.OverlayIndex)
            {
                var item=subFrame.OverlayIndex[i];
                if (item.Frame.IsShareY) item.Frame.XYSplit=true;
            }
            
            JSConsole.Chart.Log(`[HQTradeFrame::CancelZoomUpDownFrameY]`);
            return true;
        }

        return false;
    }

    this.OnZoomUpDownFrameY=function(obj, yMove)
    {
        var index=obj.Index;
        if (this.SubFrame.length<=0) return false;
        if (!this.SubFrame[index]) return false;

        var subFrame=this.SubFrame[index];
        var frame=subFrame.Frame;
        var top=frame.ChartBorder.GetTopEx();
        var bottom=frame.ChartBorder.GetBottomEx();

        var maxValue=frame.HorizontalMax;
        var minValue=frame.HorizontalMin;

        var moveStep=(maxValue-minValue)*Math.abs(yMove)/(bottom-top);

        var splitOper=frame.YSplitOperator;

        var newFixedYMaxMin={ Max:maxValue, Min:minValue };
        if (obj.Position==1)
        {
            var step=yMove>0 ? -moveStep:moveStep;
            newFixedYMaxMin.Max+=step;
        }
        else if (obj.Position==2)
        {
            var step=yMove>0 ? -moveStep:moveStep;
            newFixedYMaxMin.Min+=step;
        }
        else if (obj.Position==0)
        {
            var step=yMove>0 ? moveStep:-moveStep;
            newFixedYMaxMin.Max+=step;
            newFixedYMaxMin.Min-=step;
        }
        else
        {
            return false;
        }

        if (newFixedYMaxMin.Max>newFixedYMaxMin.Min) 
        {
            splitOper.FixedYMaxMin=newFixedYMaxMin;
            frame.XYSplit=true;

            for(var i in subFrame.OverlayIndex)
            {
                var item=subFrame.OverlayIndex[i];
                if (item.Frame.IsShareY) item.Frame.XYSplit=true;
            }
            
            JSConsole.Chart.Log(`[HQTradeFrame::OnZoomUpDownFrameY] Max=${newFixedYMaxMin.Max}, Min=${newFixedYMaxMin.Min}`);
            return true;
        }

        return false;
    }

    this.OnUpDonwFrameY=function(obj, yMove)
    {
        var index=obj.Index;
        if (this.SubFrame.length<=0) return false;
        if (!this.SubFrame[index]) return false;

        var subFrame=this.SubFrame[index];
        var frame=subFrame.Frame;
        var top=frame.ChartBorder.GetTopEx();
        var bottom=frame.ChartBorder.GetBottomEx();
        var splitOper=frame.YSplitOperator;
        if (!splitOper) return false;

        var maxValue=frame.HorizontalMax;
        var minValue=frame.HorizontalMin;

        var moveStep=(maxValue-minValue)*Math.abs(yMove)/(bottom-top);
        var step=yMove>0 ? -moveStep:moveStep;
        var newFixedYMaxMin={ Max:maxValue, Min:minValue };
        newFixedYMaxMin.Max-=step;
        newFixedYMaxMin.Min-=step;

        splitOper.FixedYMaxMin=newFixedYMaxMin;
        frame.XYSplit=true;

        for(var i in subFrame.OverlayIndex)
        {
            var item=subFrame.OverlayIndex[i];
            if (item.Frame.IsShareY) item.Frame.XYSplit=true;
        }
        
        JSConsole.Chart.Log(`[HQTradeFrame::OnUpDonwFrameY] Max=${newFixedYMaxMin.Max}, Min=${newFixedYMaxMin.Min}`);
        return true;
    }

    //保存高度比例
    this.SaveSubFrameHeightRate=function()
    {
        var height=this.ChartBorder.GetHeight();

        for(var i in this.SubFrame)
        {
            var item=this.SubFrame[i];
            var subHeight=item.Frame.ChartBorder.GetHeight();
            var rate=(subHeight/height)*100;
            item.Height=rate;
        }
    }

    this.CalculateChartBorder=function()    //计算每个子框架的边框信息
    {
        if (this.SubFrame.length<=0) return;

        var top=this.ChartBorder.GetTop();
        var height=this.ChartBorder.GetHeight();
        var totalHeight=0;

        for(var i in this.SubFrame)
        {
            var item=this.SubFrame[i];
            totalHeight+=item.Height;
        }

        for(var i in this.SubFrame)
        {
            var item=this.SubFrame[i];
            item.Frame.ChartBorder.Top=top;
            item.Frame.ChartBorder.Left=this.ChartBorder.Left;
            item.Frame.ChartBorder.Right=this.ChartBorder.Right;
            item.Frame.ChartBorder.LeftExtendWidth=this.ChartBorder.LeftExtendWidth;
            item.Frame.ChartBorder.RightExtendWidth=this.ChartBorder.RightExtendWidth;
            var frameHeight=height*(item.Height/totalHeight)+top;
            item.Frame.ChartBorder.Bottom=this.ChartBorder.GetChartHeight()-frameHeight;
            top=frameHeight;
        }
    }

    this.SetExtendWidth=function(obj)
    {
        if (!obj) return;
        var leftWidth=null, rightWidth=null;
        if (IFrameSplitOperator.IsNumber(obj.Left)) 
        {
            leftWidth=obj.Left;
            this.ChartBorder.LeftExtendWidth=leftWidth;
        }

        if (IFrameSplitOperator.IsNumber(obj.Right)) 
        {
            rightWidth=obj.Right;
            this.ChartBorder.RightExtendWidth=rightWidth;
        }

        for(var i in this.SubFrame)
        {
            var item=this.SubFrame[i];
            if (leftWidth!=null) item.Frame.ChartBorder.LeftExtendWidth=leftWidth;
            if (rightWidth!=null) item.Frame.ChartBorder.RightExtendWidth=rightWidth;
        }
    }

    this.CalculateChartBorder2=function()   //计算每个子框架的边框信息(思维导图用)
    {
        if (this.SubFrame.length<=0) return;

        var top=this.ChartBorder.Top;
        var bottom=this.ChartBorder.Bottom;
        var height=this.ChartBorder.GetHeight();
        var totalHeight=0;

        for(var i in this.SubFrame)
        {
            var item=this.SubFrame[i];
            totalHeight+=item.Height;
        }

        var tempHeight=0;
        for(var i in this.SubFrame)
        {
            var item=this.SubFrame[i];
            item.Frame.ChartBorder.Top=top;
            item.Frame.ChartBorder.Left=this.ChartBorder.Left;
            item.Frame.ChartBorder.Right=this.ChartBorder.Right;
            item.Frame.ChartBorder.X=this.ChartBorder.X;
            item.Frame.ChartBorder.Y=this.ChartBorder.Y;
            item.Frame.ChartBorder.Width=this.ChartBorder.Width;
            item.Frame.ChartBorder.Height=this.ChartBorder.Height;
            var frameHeight=height*(item.Height/totalHeight);
            tempHeight+=frameHeight;
            bottom=this.ChartBorder.Bottom+(height-tempHeight);
            item.Frame.ChartBorder.Bottom=bottom;
            top+=frameHeight;
        }
    }

    this.Draw=function()
    {
        if (this.SizeChange===true) this.CalculateChartBorder();

        for(var i in this.SubFrame)
        {
            var item=this.SubFrame[i];
            if (item.Height<=0) continue;

            item.Frame.Draw();

            var rightOffset=item.Interval;
            if (item.Frame.RightTextMaxWidth>rightOffset) rightOffset=item.Frame.RightTextMaxWidth;
            for(var j in item.OverlayIndex)
            {
                var overlayItem=item.OverlayIndex[j];
                //把主坐标部分设置给子坐标下来
                overlayItem.Frame.DataWidth=item.Frame.DataWidth;
                overlayItem.Frame.DistanceWidth=item.Frame.DistanceWidth;
                overlayItem.Frame.XPointCount=item.Frame.XPointCount;
                if (overlayItem.ChartPaint.length>0 && overlayItem.Frame) 
                {
                    overlayItem.Frame.RightOffset=rightOffset;
                    overlayItem.Frame.Draw();
                    rightOffset+=item.Interval;
                }
            }
        }

        this.SizeChange=false;
    }

    this.DrawOveraly=function()
    {
        for(var i in this.SubFrame)
        {
            var item=this.SubFrame[i];
            for(var j in item.OverlayIndex)
            {
                var overlayItem=item.OverlayIndex[j];
                for(var k in overlayItem.ChartPaint)
                {
                    if (overlayItem.ChartPaint[k].IsShow)
                        overlayItem.ChartPaint[k].Draw();
                }
            }
        }
    }

    this.DrawLock=function()
    {
        for (var i in this.SubFrame)
        {
            var item = this.SubFrame[i];
            item.Frame.DrawLock();
        }
    }

    this.CalculateLock=function()
    {
        for (var i in this.SubFrame)
        {
            var item = this.SubFrame[i];
            item.Frame.CalculateLock();
        }
    }

    this.DrawInsideHorizontal = function () 
    {
        for (var i in this.SubFrame) 
        {
          var item = this.SubFrame[i];
          if (item.Frame.DrawInsideHorizontal) item.Frame.DrawInsideHorizontal();
        }
    }

    this.DrawCustomHorizontal=function()    //定制坐标
    {
        for (var i in this.SubFrame) 
        {
          var item = this.SubFrame[i];
          if (item.Frame.DrawCustomHorizontal) item.Frame.DrawCustomHorizontal();
        }
    }

    this.DrawEx=function(option)
    {
        for(var i in this.SubFrame)
        {
            var item = this.SubFrame[i];
            if ((item.Frame.ClassName=="MinuteFrame"||item.Frame.ClassName=="MinuteHScreenFrame")  && i==1)
            {
                item.Frame.DrawVolTitle(option.Symbol);
            }
        }
    }

    this.DrawCustomVertical=function(event)
    {
        for (var i in this.SubFrame) 
        {
          var item = this.SubFrame[i];
          item.Frame.DrawCustomVerticalEvent=event;
          if (item.Frame.DrawCustomVertical) item.Frame.DrawCustomVertical();
        }
    }

    this.SetSizeChage=function(sizeChange)
    {
        this.SizeChange=sizeChange;

        for(var i in this.SubFrame)
        {
            var item=this.SubFrame[i];
            item.Frame.SizeChange=sizeChange;

            for(var j in item.OverlayIndex)
            {
                var overlayItem=item.OverlayIndex[j];
                if (overlayItem.Frame) overlayItem.Frame.SizeChange=sizeChange;
            }
        }

        //画布的位置
        if (this.ChartBorder.UIElement)
        {
            this.Position={
                X:this.ChartBorder.UIElement.offsetLeft,
                Y:this.ChartBorder.UIElement.offsetTop,
                W:this.ChartBorder.UIElement.clientWidth,
                H:this.ChartBorder.UIElement.clientHeight
            };
        }
    }

    this.SetDrawDepthMap=function(callback)
    {
        for(var i in this.SubFrame)
        {
            var item=this.SubFrame[i];
            item.Frame.DrawDepthMapCallback=callback;
        }
    }

    //图形快照
    this.Snapshot=function()
    {
        this.ScreenImageData=this.Canvas.getImageData(0,0,this.ChartBorder.GetChartWidth(),this.ChartBorder.GetChartHeight());
    }

    this.GetXData=function(x)
    {
        return this.SubFrame[0].Frame.GetXData(x);
    }

    this.GetYData=function(y,outObject) //outObject 可以保存返回的额外数据
    {
        var frame;
        for(var i in this.SubFrame)
        {
            var item=this.SubFrame[i];
            var left=item.Frame.ChartBorder.GetLeft();
            var top=item.Frame.ChartBorder.GetTopEx();
            var width=item.Frame.ChartBorder.GetWidth();
            var height=item.Frame.ChartBorder.GetHeightEx();

            item.Frame.Canvas.beginPath();
            item.Frame.Canvas.rect(left,top,width,height);
            if (item.Frame.Canvas.isPointInPath(left,y))
            {
                frame=item.Frame;
                if (outObject) outObject.FrameID=parseInt(i);   //转成整形
                break;
            }
        }

        if (frame!=null) 
        {
            if (frame.RightFrame) outObject.RightYValue=frame.RightFrame.GetYData(y);    //右侧子坐标

            var yValue=frame.GetYData(y);
            if (frame.YSplitOperator.CoordinateType==1) //百分比坐标 右边显示百分比信息
            {
                var  firstOpenPrice=frame.YSplitOperator.GetFirstOpenPrice();
                outObject.RightYValue=((yValue-firstOpenPrice)/firstOpenPrice*100).toFixed(2)+'%';
            }
            return yValue;
        }
    }

    this.PtInFrame=function(x,y)    //鼠标哪个指标窗口
    {
        for(var i=0; i<this.SubFrame.length; ++i)
        {
            var item=this.SubFrame[i];
            var left=item.Frame.ChartBorder.GetLeft();
            var top=item.Frame.ChartBorder.GetTop();
            var width=item.Frame.ChartBorder.GetWidth();
            var height=item.Frame.ChartBorder.GetHeight();

            item.Frame.Canvas.beginPath();
            item.Frame.Canvas.rect(left,top,width,height);
            if (item.Frame.Canvas.isPointInPath(x,y))
            {
                return i;   //转成整形
            }
        }

        return -1;
    }

    this.PtInButtons=function(x,y)
    {
        for(var i in this.SubFrame)
        {
            var item=this.SubFrame[i];
            var button=item.Frame.PtInButtons(x,y);
            if (button) return button;
        }

        return null
    }

    this.GetXFromIndex=function(index)
    {
        return this.SubFrame[0].Frame.GetXFromIndex(index);
    }

    this.GetYFromData=function(value)
    {
        return this.SubFrame[0].Frame.GetYFromData(value);
    }

    this.ZoomUp=function(cursorIndex)
    {
        var result=this.SubFrame[0].Frame.ZoomUp(cursorIndex);
        this.UpdateAllFrame();
        return result;
    }

    this.ZoomDown=function(cursorIndex)
    {
        var result=this.SubFrame[0].Frame.ZoomDown(cursorIndex);
        this.UpdateAllFrame();
        return result;
    }

    //设置重新计算刻度坐标
    this.ResetXYSplit=function()
    {
        for(let i in this.SubFrame)
        {
            this.SubFrame[i].Frame.XYSplit=true;
        }
    }

    this.SetLanguage=function(languageID)
    {
        for(let i in this.SubFrame)
        {
            var item=this.SubFrame[i];
            if (item && item.Frame )
            {
                if (item.Frame.YSplitOperator) item.Frame.YSplitOperator.LanguageID=languageID;
                if (item.Frame.XSplitOperator) item.Frame.XSplitOperator.LanguageID=languageID;
            }
        }
    }

    this.GetCurrentPageSize=function()  //获取当前页显示的数据个数
    {
        if (this.SubFrame.length<=0) return null;
        var item=this.SubFrame[0];
        if (!item || !item.Frame) return null;

        return item.Frame.XPointCount;
    }

    this.OnSize=function()
    {
        var obj={};
        this.SubFrame[0].Frame.OnSize(obj);
        this.UpdateAllFrame();
        return obj;
    }

    this.SetDataWidth=function(dataWidth)
    {
        var obj=this.SubFrame[0].Frame.SetDataWidth(dataWidth);
        this.UpdateAllFrame();
        return obj;
    }

    this.UpdateAllFrame=function()
    {
        var mainFrame=this.SubFrame[0].Frame;
        for(var i=0;i<this.SubFrame.length;++i)
        {
            var item=this.SubFrame[i];
            if (i>0)    //第1个窗口主坐标已经算好了
            {
                item.Frame.XPointCount= mainFrame.XPointCount;
                item.Frame.ZoomIndex= mainFrame.ZoomIndex;
                item.Frame.DataWidth= mainFrame.DataWidth;
                item.Frame.DistanceWidth= mainFrame.DistanceWidth;
                item.Frame.LastCalculateStatus.Width=mainFrame.LastCalculateStatus.Width;
                item.Frame.LastCalculateStatus.XPointCount=mainFrame.LastCalculateStatus.XPointCount;
            }

            for(var j in item.OverlayIndex)
            {
                var overlayItem=this.SubFrame[i].OverlayIndex[j];
                overlayItem.Frame.XPointCount= mainFrame.XPointCount;
                overlayItem.Frame.ZoomIndex= mainFrame.ZoomIndex;
                overlayItem.Frame.DataWidth= mainFrame.DataWidth;
                overlayItem.Frame.DistanceWidth= mainFrame.DistanceWidth;
                overlayItem.Frame.LastCalculateStatus.Width=mainFrame.LastCalculateStatus.Width;
                overlayItem.Frame.LastCalculateStatus.XPointCount=mainFrame.LastCalculateStatus.XPointCount;
            }
        }
    }

    //鼠标是否在边框上
    this.PtInFrameBorder=function(x,y)
    {
        var height=this.DragBorderHeight;
        for(var i=0;i<this.SubFrame.length-1;++i)
        {
            var item=this.SubFrame[i];
            if (item.Frame.Heigh<=0) continue;
            var bottom=item.Frame.ChartBorder.GetBottom();
            var left=item.Frame.ChartBorder.GetLeft();
            var right=item.Frame.ChartBorder.GetRight();

            item.Frame.Canvas.beginPath();
            item.Frame.Canvas.rect(left,bottom-height/2,(right-left),height);
            if (item.Frame.Canvas.isPointInPath(x,y))
            {
                return { Index:i, Bottom:true };
            }
        }
        return null;
    }

    this.IsEnableDragY=function(index)
    {
        if (!this.SubFrame) return false;
        var item=this.SubFrame[index];
        if (!item || !item.Frame || !item.Frame.YSplitOperator) return false;
        var split=item.Frame.YSplitOperator;
        if (typeof(split.IsEnableDragY)!='function') return false;

        return split.IsEnableDragY();
    }

    this.PtInFrameY=function(x,y)
    {
        for(var i=0;i<this.SubFrame.length;++i)
        {
            var item=this.SubFrame[i];
            if (item.Frame.Heigh<=0) continue;
            var rightWidth=item.Frame.ChartBorder.Right;

            var border=item.Frame.ChartBorder.GetBorder();
            var bottom=border.Bottom;
            var top=border.TopTitle;
            var left=border.Left;
            var right=border.Right;

            var maxTopHegith=30;
            var barHegith=(bottom-top);
            if (barHegith/3>maxTopHegith)
            {
                var barTop=top+maxTopHegith;
                var barBottom=bottom-maxTopHegith;
            }
            else
            {
                var internal=barHegith/3;
                var barTop=top+internal;
                var barBottom=bottom-internal;
            }

            var position=0;
            if (y<barTop) position=1;
            else if (y>barBottom) position=2;

            if (rightWidth>=10)
            {
                item.Frame.Canvas.beginPath();
                item.Frame.Canvas.rect(right,top,rightWidth,(bottom-top));
                if (item.Frame.Canvas.isPointInPath(x,y))
                {
                    return { Index:i, Right:true, Left:false , Position:position };    //Position 1=上面 2 下面 0=中间(TODO)
                }
            }

            var leftWidth=item.Frame.ChartBorder.Left;
            if (leftWidth>=10)
            {
                item.Frame.Canvas.beginPath();
                item.Frame.Canvas.rect(0,top,leftWidth,(bottom-top));
                if (item.Frame.Canvas.isPointInPath(x,y))
                {
                    return { Index:i, Right:false, Left:true, Position:position };
                }
            }
 
        }
        return null;
    }

    this.SetDayCount=function(dayCount)
    {
        this.ChartBorder.MultiDayMinute.Count=dayCount;
        for(var i=0;i<this.SubFrame.length;++i)
        {
            var item=this.SubFrame[i];
            if (!item.Frame) continue;

            item.Frame.DayCount=dayCount;
            item.Frame.ChartBorder.MultiDayMinute.Count=dayCount;
        }
    }

    //设置多日分时宽度
    this.SetMultiDayMinuteWidth=function(obj)
    {
        if (!obj) return;
        if (IFrameSplitOperator.IsNumber(obj.Left)) this.ChartBorder.MultiDayMinute.Left=obj.Left;
        if (IFrameSplitOperator.IsNumber(obj.Right)) this.ChartBorder.MultiDayMinute.Right=obj.Right;

        for(var i=0;i<this.SubFrame.length;++i)
        {
            var item=this.SubFrame[i];
            if (!item.Frame) continue;

            if (IFrameSplitOperator.IsNumber(obj.Left)) item.Frame.ChartBorder.MultiDayMinute.Left=obj.Left;
            if (IFrameSplitOperator.IsNumber(obj.Right)) item.Frame.ChartBorder.MultiDayMinute.Right=obj.Right;
        }
    }
}

//行情框架横屏
function HQTradeHScreenFrame()
{
    this.newMethod=HQTradeFrame;   //派生
    this.newMethod();
    delete this.newMethod;

    this.IsHScreen=true;        //是否是横屏

    this.CalculateChartBorder=function()    //计算每个子框架的边框信息
    {
        if (this.SubFrame.length<=0) return;
        var border=this.ChartBorder.GetHScreenBorder();
        var right=this.ChartBorder.Right;
        var left=border.Right;
        var width=border.Right-border.Left;
        var totalHeight=0;

        for(var i in this.SubFrame)
        {
            var item=this.SubFrame[i];
            totalHeight+=item.Height;
        }

        for(var i in this.SubFrame)
        {
            var item=this.SubFrame[i];
            item.Frame.ChartBorder.Top=this.ChartBorder.Top;
            item.Frame.ChartBorder.Bottom=this.ChartBorder.Bottom;

            var frameWidth=width*(item.Height/totalHeight);
            item.Frame.ChartBorder.Right=right;
            item.Frame.ChartBorder.Left=left-frameWidth;
            
            right+=frameWidth;
            left-=frameWidth;
        }
    }

    this.GetYData=function(x,outObject)
    {
        var frame;
        for(var i in this.SubFrame)
        {
            var item=this.SubFrame[i];
            var left=item.Frame.ChartBorder.GetLeftEx();
            var top=item.Frame.ChartBorder.GetTop();
            var width=item.Frame.ChartBorder.GetWidthEx();
            var height=item.Frame.ChartBorder.GetHeight();

            item.Frame.Canvas.beginPath();
            item.Frame.Canvas.rect(left,top,width,height);
            if (item.Frame.Canvas.isPointInPath(x,top))
            {
                frame=item.Frame;
                if (outObject) outObject.FrameID=i;
                break;
            }
        }

        if (frame!=null) return frame.GetYData(x);
    }
}

//深度图框架
function DepthChartFrame()
{
    this.newMethod=AverageWidthFrame;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ScreenImageData;                   //截图
    this.Position;                          //画布的位置
    this.ClassName="DepthChartFrame";

    //X轴价格 最大,最小
    this.VerticalRange={ Max:88, Min:8, Center:null, MaxDiffer:null, Differ:null, Step:0.05 };
    this.AskPrice;
    this.BidPrice;
    this.MinZoom=0.05;  //最小缩放

    this.SetPriceList=function(aryAskPrice, aryBidPrice)
    {
        this.AskPrice=aryAskPrice;
        this.BidPrice=aryBidPrice;
    }

    this.DrawFrame=function()
    {
        this.SplitXYCoordinate();
        this.DrawHorizontal();
        this.DrawVertical();
    }

    this.GetXFromIndex=function(value)
    {
        var left=this.ChartBorder.GetLeft();
        var right=this.ChartBorder.GetRight();
        var width=this.ChartBorder.GetWidth();
        var offset=width*(value-this.VerticalRange.Min)/(this.VerticalRange.Max-this.VerticalRange.Min);
        return left+offset;
    }

    this.GetXData=function(x)
    {
        var left=this.ChartBorder.GetLeft();
        var right=this.ChartBorder.GetRight();
        var width=this.ChartBorder.GetWidth();

        return (x-left)/width*(this.VerticalRange.Max-this.VerticalRange.Min)+this.VerticalRange.Min;
    }

    this.GetXFromPrice=function(price)
    {
        var isAskPrice=false;
        var find=this.GetPrice(this.BidPrice, price);
        if (find==null) 
        {
            find=this.GetPrice(this.AskPrice, price);
            isAskPrice=true;
        }

        if (find==null) 
        {
            if (this.BidPrice && Array.isArray(this.BidPrice) && this.BidPrice.length>0)
            {
                var minPrice=this.BidPrice[0];
                if (price<minPrice) 
                {
                    isAskPrice=false;
                    find= minPrice;
                }
            }
        }

        if (find==null)   
        {      
            if (this.AskPrice && Array.isArray(this.AskPrice) && this.AskPrice.length>0)
            {
                var maxPrice=this.AskPrice[this.AskPrice.length-1];
                if (price>maxPrice) 
                {
                    isAskPrice=true;
                    find=maxPrice;
                }
            }
        }

        if (find==null) return null;

        var x=this.GetXFromIndex(find);

        return { X:x, Price:find, IsAsk:isAskPrice };
    }

    this.GetPrice=function(aryPrice, price)
    {
        if (!aryPrice || !Array.isArray(aryPrice) || aryPrice.length<=0) return null;

        if (price<aryPrice[0] || price>aryPrice[aryPrice.length-1]) return null;

        var lastPrice=null;
        for(var i in aryPrice)
        {
            var item=aryPrice[i];
            if (price==item)
            {
                return item;
            }

            if (price<item)
                return lastPrice;

            lastPrice=item;
        }
    }

    //分割x,y轴坐标信息
    this.SplitXYCoordinate=function()
    {
        if (this.XYSplit==false) return;
        if (this.YSplitOperator!=null) this.YSplitOperator.Operator();
        if (this.XSplitOperator!=null) this.XSplitOperator.Operator();
    }

    //图形快照
    this.Snapshot=function()
    {
        this.ScreenImageData=this.Canvas.getImageData(0,0,this.ChartBorder.GetChartWidth(),this.ChartBorder.GetChartHeight());
    }

    this.SetSizeChage=function(sizeChange)
    {
        this.SizeChange=sizeChange;

        //画布的位置
        this.Position={
            X:this.ChartBorder.UIElement.offsetLeft,
            Y:this.ChartBorder.UIElement.offsetTop,
            W:this.ChartBorder.UIElement.clientWidth,
            H:this.ChartBorder.UIElement.clientHeight
        };
    }

    this.SetDrawDepthMap=function(callback)
    {
        
    }

    this.PtInFrame=function(x,y)    //鼠标哪个指标窗口
    {
        var left=this.ChartBorder.GetLeft();
        var top=this.ChartBorder.GetTop();
        var width=this.ChartBorder.GetWidth();
        var height=this.ChartBorder.GetHeight();

        this.Canvas.beginPath();
        this.Canvas.rect(left,top,width,height);
        if (this.Canvas.isPointInPath(x,y))
            return 0;

        return -1;
    }

    this.PtInFrameBorder=function(x,y)
    {
        return null;
    }

    this.ZoomUp=function()  //放大
    {
        var xRange=this.VerticalRange;
        var differ=xRange.Differ;
        var minDiffer=xRange.MaxDiffer*this.MinZoom;
        if (differ<minDiffer) return false;

        var offsetDiffer=xRange.Differ*xRange.Step;
        differ-=offsetDiffer;
        xRange.Differ=differ;
        xRange.Min=xRange.Center-xRange.Differ;
        xRange.Max=xRange.Center+xRange.Differ;

        return true;
    }

    this.ZoomDown=function() //缩小
    {
        var xRange=this.VerticalRange;
        var differ=xRange.Differ;
        if (differ==xRange.MaxDiffer) return false;

        var offsetDiffer=xRange.Differ*xRange.Step;
        differ+=offsetDiffer;
        if (differ>xRange.MaxDiffer) differ=xRange.MaxDiffer;

        xRange.Differ=differ;
        xRange.Min=xRange.Center-xRange.Differ;
        xRange.Max=xRange.Center+xRange.Differ;

        return true;
    }
}


function SimpleChartFrame()
{
    this.newMethod=AverageWidthFrame;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ScreenImageData;                   //截图
    this.Position;                          //画布的位置

    this.DrawFrame=function()
    {
        if (this.XPointCount>0)
        {
            let dInterval=this.ChartBorder.GetWidth()/(6*this.XPointCount); //分6份, 数据4 间距2
            this.DistanceWidth=2*dInterval;
			this.DataWidth=4*dInterval;
        }

        this.SplitXYCoordinate();
        this.DrawHorizontal();
        this.DrawVertical();
    }

    this.GetXFromIndex=function(index)
    {
        if (index < 0) index = 0;
	    if (index > this.xPointCount - 1) index = this.xPointCount - 1;

        var offset=this.ChartBorder.GetLeft()+2+this.DistanceWidth/2+this.DataWidth/2;
        for(var i=1;i<=index;++i)
        {
            offset+=this.DistanceWidth+this.DataWidth;
        }

        return offset;
    }

    //分割x,y轴坐标信息
    this.SplitXYCoordinate=function()
    {
        if (this.XYSplit==false) return;
        if (this.YSplitOperator!=null) this.YSplitOperator.Operator();
        if (this.XSplitOperator!=null) this.XSplitOperator.Operator();
    }

    //图形快照
    this.Snapshot=function()
    {
        this.ScreenImageData=this.Canvas.getImageData(0,0,this.ChartBorder.GetChartWidth(),this.ChartBorder.GetChartHeight());
    }

    this.SetSizeChage=function(sizeChange)
    {
        this.SizeChange=sizeChange;

        //画布的位置
        this.Position={
            X:this.ChartBorder.UIElement.offsetLeft,
            Y:this.ChartBorder.UIElement.offsetTop,
            W:this.ChartBorder.UIElement.clientWidth,
            H:this.ChartBorder.UIElement.clientHeight
        };
    }

    this.SetDrawDepthMap=function(callback)
    {
        
    }

    this.PtInFrame=function(x,y)    //鼠标哪个指标窗口
    {
        var left=this.ChartBorder.GetLeft();
        var top=this.ChartBorder.GetTop();
        var width=this.ChartBorder.GetWidth();
        var height=this.ChartBorder.GetHeight();

        this.Canvas.beginPath();
        this.Canvas.rect(left,top,width,height);
        if (this.Canvas.isPointInPath(x,y))
            return 0;

        return -1;
    }

    this.PtInFrameBorder=function(x,y)
    {
        return null;
    }
}


//历史K线数据
function HistoryData()
{
    this.Date;
    this.YClose;
    this.Open;
    this.Close;
    this.High;
    this.Low;
    this.Vol;
    this.Amount;
    this.Time;      //mmhh 或者 mmhhss
    this.FlowCapital=0;   //流通股本
    this.Position=null;   //持仓量

    //期货
    this.YFClose=null;   //前结算价
    this.FClose=null;    //结算价

    //指数才有的数据
    this.Stop;  //停牌家数
    this.Up;    //上涨
    this.Down;  //下跌
    this.Unchanged; //平盘

    this.ExtendData;    //扩展数据
}

//数据复制
HistoryData.Copy=function(data)
{
    var newData=new HistoryData();
    newData.Date=data.Date;
    newData.YClose=data.YClose;
    newData.Open=data.Open;
    newData.Close=data.Close;
    newData.High=data.High;
    newData.Low=data.Low;
    newData.Vol=data.Vol;
    newData.Amount=data.Amount;
    newData.Time=data.Time;
    newData.FlowCapital=data.FlowCapital;

    newData.Position=data.Position;
    newData.YFClose=data.YFClose;
    newData.FClose=data.FClose;

    newData.Stop=data.Stop;
    newData.Up=data.Up;
    newData.Down=data.Down;
    newData.Unchanged=data.Unchanged;

    return newData;
}

//把数据 src 复制到 dest中
HistoryData.CopyTo=function(dest,src)
{
    dest.Date=src.Date;
    dest.YClose=src.YClose;
    dest.Open=src.Open;
    dest.Close=src.Close;
    dest.High=src.High;
    dest.Low=src.Low;
    dest.Vol=src.Vol;
    dest.Amount=src.Amount;
    dest.Time=src.Time;
    dest.FlowCapital=src.FlowCapital;

    dest.Position=src.Position;
    dest.YFClose=src.YFClose;
    dest.FClose=src.FClose;

    dest.Stop=src.Stop;
    dest.Up=src.Up;
    dest.Down=src.Down;
    dest.Unchanged=src.Unchanged;
}

//数据复权拷贝
HistoryData.CopyRight=function(data,seed)
{
    var newData=new HistoryData();
    newData.Date=data.Date;
    newData.YClose=data.YClose*seed;
    newData.Open=data.Open*seed;
    newData.Close=data.Close*seed;
    newData.High=data.High*seed;
    newData.Low=data.Low*seed;

    newData.Vol=data.Vol;
    newData.Amount=data.Amount;
    newData.FlowCapital=data.FlowCapital;
    newData.Position=data.Position;
    newData.YFClose=data.YFClose;
    newData.FClose=data.FClose;

    return newData;
}

function MinuteData()
{
    this.Close;
    this.Open;
    this.High;
    this.Low;
    this.Vol;           //量
    this.Amount;        //金额
    this.DateTime;
    this.Increase;      //涨幅
    this.Risefall;      //涨跌
    this.AvPrice;       //均价
    this.Lead=null;     //领先指标
    this.Time;          //时间
    this.Date;              //日期
    this.Position=null;     //持仓量
}

//盘前集合竞价
function BeforeOpenData()
{
    this.Time;
    this.Date;
    this.Price;     //匹配的价格
    this.AvPrice;   //均价
    this.Vol=[];    //[0]=匹配量 [1]=未匹配量
    this.ColorID;   //0=平盘 1=红 2=绿  3 ...自定义颜色     
}

//收盘集合竞价
function AfterCloseData()
{
    this.Time;
    this.Date;
    this.Price;     //匹配的价格
    this.AvPrice;   //均价
    this.Vol=[];    //[0]=匹配量 [1]=未匹配量
    this.ColorID;   //0=平盘 1=红 2=绿  3 ...自定义颜色     
}

//单指标数据
function SingleData()
{
    this.Date;  //日期
    this.Time;  //时间
    this.Value; //数据  (可以是一个数组)
}

var KLINE_INFO_TYPE=
{
    INVESTOR:1,         //互动易
    ANNOUNCEMENT:2,     //公告
    PFORECAST:3,        //业绩预告

    ANNOUNCEMENT_QUARTER_1:4,   //一季度报
    ANNOUNCEMENT_QUARTER_2:5,   //半年报
    ANNOUNCEMENT_QUARTER_3:6,   //2季度报
    ANNOUNCEMENT_QUARTER_4:7,   //年报

    RESEARCH:8,                 //调研
    BLOCKTRADING:9,             //大宗交易
    TRADEDETAIL:10,              //龙虎榜

    //公告预留类型
    ANNOUNCEMENT_EX_START:100,
    ANNOUNCEMENT_EX_END:200,
}

function KLineInfoData()
{
    this.ID;
    this.Date;
    this.Title;
    this.InfoType;
    this.ExtendData;    //扩展数据
}

//外部数据计算方法接口
function DataPlus () 
{ 
    this.PeriodCallback=new Map();

    this.GetPeriodCallback=function(period)
    {
        if (!this.PeriodCallback.has(period)) return null;
        
        return this.PeriodCallback.get(period);
    }

    this.AddPeriodCallback=function(obj)
    {
        if (!IFrameSplitOperator.IsNumber(obj.Period) || !obj.Callback) return;

        var item={ Period:obj.Period, Callback:obj.Callback };
        this.PeriodCallback.set(obj.Period, item);
    }

    this.RemovePeriodCallback=function(obj)
    {
        if (!this.PeriodCallback.has(obj.ID)) return;
        this.PeriodCallback.delete(obj.ID);
    }
}; 

DataPlus.GetMinutePeriodData=null;

var g_DataPlus=new DataPlus();

/*
DataPlus.GetMinutePeriodData=function(period,data,self)
{

}
*/

function ChartData()
{
    this.Data=new Array();
    this.DataOffset=0;                        //数据偏移
    this.Period=0;                            //周期 0 日线 1 周线 2 月线 3年线
    this.Right=0;                             //复权 0 不复权 1 前复权 2 后复权
    this.Symbol;                              //股票代码

    this.Data2=new Array();                   //第1组数据 走势图:历史分钟数据

    this.GetCloseMA=function(dayCount)
    {
        var result=new Array();
        for (var i = 0, len = this.Data.length; i < len; i++)
        {
            if (i < dayCount)
            {
                result[i]=null;
                continue;
            }

            var sum = 0;
            for (var j = 0; j < dayCount; j++)
            {
                sum += this.Data[i - j].Close;
            }
            result[i]=sum / dayCount;
        }
        return result;
    }

    this.GetVolMA=function(dayCount)
    {
    var result=new Array();
    for (var i = 0, len = this.Data.length; i < len; i++)
    {
        if (i < dayCount)
        {
            result[i]=null;
            continue;
        }

        var sum = 0;
        for (var j = 0; j < dayCount; j++)
        {
            sum += this.Data[i - j].Vol;
        }
        result[i]=sum / dayCount;
    }
    return result;
    }

    this.GetAmountMA=function(dayCount)
    {
        var result=new Array();
        for (var i = 0, len = this.Data.length; i < len; i++)
        {
            if (i < dayCount)
            {
                result[i]=null;
                continue;
            }

            var sum = 0;
            for (var j = 0; j < dayCount; j++)
            {
                sum += this.Data[i - j].Amount;
            }
            result[i]=sum / dayCount;
        }
        return result;
    }

    //获取收盘价
    this.GetClose=function()
    {
        var result=new Array();
        for(var i in this.Data)
        {
            result[i]=this.Data[i].Close;
        }

        return result;
    }

    this.GetYClose=function()
    {
        var result=new Array();
        for(var i in this.Data)
        {
            result[i]=this.Data[i].YClose;
        }

        return result;
    }

    this.GetHigh=function()
    {
        var result=new Array();
        for(var i in this.Data)
        {
            result[i]=this.Data[i].High;
        }

        return result;
    }

    this.GetLow=function()
    {
        var result=new Array();
        for(var i in this.Data)
        {
            result[i]=this.Data[i].Low;
        }

        return result;
    }

    this.GetOpen=function()
    {
        var result=new Array();
        for(var i in this.Data)
        {
            result[i]=this.Data[i].Open;
        }

        return result;
    }

    this.GetVol=function(unit)
    {
        var value=1;
        if (IFrameSplitOperator.IsNumber(unit)>0) value=unit;
        var result=new Array();
        for(var i in this.Data)
        {
            result[i]=this.Data[i].Vol/value;
        }

        return result;
    }

    this.GetAmount=function()
    {
        var result=new Array();
        for(var i in this.Data)
        {
            result[i]=this.Data[i].Amount;
        }

        return result;
    }

    this.GetPosition=function()
    {
        var result=new Array();
        for(var i in this.Data)
        {
            result[i]=this.Data[i].Position;
        }

        return result;
    }

    this.GetSettlementPrice=function()  //结算价
    {
        var result=new Array();
        for(var i in this.Data)
        {
            result[i]=this.Data[i].FClose;
        }

        return result;
    }

    this.GetIsEqual=function()
    {
        var result=[];
        for(var i in this.Data)
        {
            var item=this.Data[i];
            result[i]=(item.Close==item.Open? 1:0);
        }

        return result;
    }

    this.GetIsUp=function()
    {
        var result=[];
        for(var i in this.Data)
        {
            var item=this.Data[i];
            result[i]=(item.Close>item.Open? 1:0);
        }

        return result;
    }

    this.GetIsDown=function()
    {
        var result=[];
        for(var i in this.Data)
        {
            var item=this.Data[i];
            result[i]=(item.Close<item.Open? 1:0);
        }

        return result;
    }

    this.GetLead=function()
    {
        var result=new Array();
        for(var i in this.Data)
        {
            result[i]=this.Data[i].Lead;
        }

        return result;
    }

    this.GetDate=function()
    {
        var result=new Array();
        for(var i in this.Data)
        {
            result[i]=this.Data[i].Date;
        }

        return result;
    }

    this.GetTime=function()
    {
        var result=new Array();
        for(var i in this.Data)
        {
            result[i]=this.Data[i].Time;
        }

        return result;
    }

    this.GetUp=function()   //上涨家数
    {
        var result=[];
        for(var i in this.Data)
        {
            result[i]=this.Data[i].Up;
        }

        return result;
    }

    this.GetDown=function() //下跌家数
    {
        var result=[];
        for(var i in this.Data)
        {
            result[i]=this.Data[i].Down;
        }

        return result;
    }

    this.GetYear=function()
    {
        var result=new Array();
        for(var i in this.Data)
        {
            result[i]=parseInt(this.Data[i].Date/10000);
        }

        return result;
    }

    this.GetMonth=function()
    {
        var result=new Array();
        for(var i in this.Data)
        {
            result[i]=parseInt(this.Data[i].Date%10000/100);
        }

        return result;
    }

    //分时图均价
    this.GetAvPrice=function()
    {
        var result=new Array();
        for(var i in this.Data)
        {
            var value=this.Data[i].AvPrice;
            if (IFrameSplitOperator.IsNumber(value))
                result[i]=value;
            else 
                result[i]=0;
        }

        return result;
    }

    //获取数据日期和时间范围
    this.GetDateRange=function()
    {
        if (!this.Data || this.Data.length<=0) return null;

        var start=this.Data[0];
        var end=this.Data[this.Data.length-1];
        var range={ Start:{Date:start.Date}, End:{Date:end.Date} };
        if (IFrameSplitOperator.IsNumber(start.Time)) range.Start.Time=start.Time;
        if (IFrameSplitOperator.IsNumber(end.Time)) range.End.Time=end.Time;

        return range;
    }

    //计算分钟
    this.GetMinutePeriodData=function(period)
    {
        if (DataPlus.GetMinutePeriodData) return DataPlus.GetMinutePeriodData(period,this.Data,this);

        var result = new Array();
        var periodDataCount = 5;
        if (period == 5)
            periodDataCount = 5;
        else if (period == 6)
            periodDataCount = 15;
        else if (period == 7)
            periodDataCount = 30;
        else if (period == 8)
            periodDataCount = 60;
        else if (period==11)
            periodDataCount=120;
        else if (period==12)
            periodDataCount=240;
        else if (period>CUSTOM_MINUTE_PERIOD_START && period<=CUSTOM_MINUTE_PERIOD_END)
        {
            periodDataCount=period-CUSTOM_MINUTE_PERIOD_START;
            return this.GetMinuteCustomPeriodData(periodDataCount);
        }
        else
            return this.Data;
        var bFirstPeriodData = false;
        var newData = null;
        var preTime=null;   //上一次的计算时间
        for (var i = 0; i < this.Data.length; )
        {
            bFirstPeriodData = true;
            for (var j = 0; j < periodDataCount && i < this.Data.length; ++i)
            {
                if (bFirstPeriodData)
                {
                    newData = new HistoryData();
                    result.push(newData);
                    bFirstPeriodData = false;
                }
                var minData = this.Data[i];
                if (minData == null)
                {
                    ++j;
                    continue;    
                } 
                if (minData.Time==925 && (preTime==null || preTime!=924))  //9：25, 9:30 不连续就不算个数
                {

                }
                else if (minData.Time == 930 && (preTime==null || preTime!=929) )
                {

                }
                else if (minData.Time == 1300 && (preTime==null || preTime!=1259) ) //1点的数据 如果不是连续的 就不算个数
                {

                }
                else
                    ++j;
                newData.Date = minData.Date;
                newData.Time = minData.Time;
                preTime=newData.Time;
                if (minData.Open==null || minData.Close==null)
                    continue;
                if (newData.Open==null || newData.Close==null)
                {
                    newData.Open=minData.Open;
                    newData.High=minData.High;
                    newData.Low=minData.Low;
                    newData.YClose=minData.YClose;
                    newData.Close=minData.Close;
                    newData.Vol=minData.Vol;
                    newData.Amount=minData.Amount;    
                    newData.FlowCapital=minData.FlowCapital;  
                    newData.Position=minData.Position;
                    newData.YFClose=minData.YFClose;
                    newData.FClose=minData.FClose;
                }
                else
                {
                    if (newData.High<minData.High) 
                        newData.High=minData.High;
                    if (newData.Low>minData.Low) 
                        newData.Low=minData.Low;
                    newData.Close=minData.Close;
                    newData.Vol+=minData.Vol;
                    if (minData.Amount!=null) newData.Amount+=minData.Amount;
                    newData.Position=minData.Position;
                    newData.FlowCapital=minData.FlowCapital;  
                    newData.FClose=minData.FClose;
                }

                if (i+1 < this.Data.length) //判断下一个数据是否是不同日期的
                {
                    var nextItem=this.Data[i+1];
                    if (nextItem && nextItem.Date!=minData.Date)    //不同日期的, 周期结束
                    {
                        ++i;
                        break;
                    }
                }
            }
        }
        return result;
    }

    //自定义分钟
    this.GetMinuteCustomPeriodData=function(count)
    {
        var result = new Array();
        var periodDataCount = count;
        var bFirstPeriodData = false;
        var newData = null;
        for (var i = 0; i < this.Data.length; )
        {
            bFirstPeriodData = true;
            for (var j = 0; j < periodDataCount && i < this.Data.length; ++i, ++j)
            {
                if (bFirstPeriodData)
                {
                    newData = new HistoryData();
                    result.push(newData);
                    bFirstPeriodData = false;
                }
                var minData = this.Data[i];
                if (minData == null) continue;    
                
                newData.Date = minData.Date;
                newData.Time = minData.Time;
                if (minData.Open==null || minData.Close==null) continue;
                if (newData.Open==null || newData.Close==null)
                {
                    newData.Open=minData.Open;
                    newData.High=minData.High;
                    newData.Low=minData.Low;
                    newData.YClose=minData.YClose;
                    newData.Close=minData.Close;
                    newData.Vol=minData.Vol;
                    newData.Amount=minData.Amount;    
                    newData.FlowCapital=minData.FlowCapital; 
                    newData.Position=minData.Position; 
                    newData.YFClose=minData.YFClose; 
                    newData.FClose=minData.FClose; 
                }
                else
                {
                    if (newData.High<minData.High)  newData.High=minData.High;
                    if (newData.Low>minData.Low) newData.Low=minData.Low;
                    newData.Close=minData.Close;
                    newData.Vol+=minData.Vol;
                    if (minData.Amount!=null) newData.Amount+=minData.Amount;   //null数据不相加
                    newData.Position=minData.Position;
                    newData.FlowCapital=minData.FlowCapital;  
                    newData.FClose=minData.FClose; 
                }
            }
        }
        return result;
    }
    //计算周,月,年
    this.GetDayPeriodData=function(period)
    {
        if (period>CUSTOM_DAY_PERIOD_START && period<=CUSTOM_DAY_PERIOD_END)
            return this.GetDayCustomPeriodData(period-CUSTOM_DAY_PERIOD_START);
        
        var isBit=MARKET_SUFFIX_NAME.IsBIT(this.Symbol);

        var result=new Array();
        var index=0;
        var startDate=0;
        var weekCount=2;
        var newData=null;
        for(var i in this.Data)
        {
            var isNewData=false;
            var dayData=this.Data[i];

            switch(period)
            {
                case 1: //周线
                    if (isBit)  var fridayDate=ChartData.GetSunday(dayData.Date); //数字货币全年的
                    else var fridayDate=ChartData.GetFirday(dayData.Date);
                    
                    if (fridayDate!=startDate)
                    {
                        isNewData=true;
                        startDate=fridayDate;
                    }
                    break;
                case 21: //双周
                    if (isBit)  var fridayDate=ChartData.GetSunday(dayData.Date); //数字货币全年的
                    else var fridayDate=ChartData.GetFirday(dayData.Date);

                    if (fridayDate!=startDate)
                    {
                        ++weekCount;
                        if (weekCount>=2) 
                        {
                            isNewData=true;
                            weekCount=0;
                        }
                        startDate=fridayDate;
                    }
                    break;
                case 2: //月线
                    if (parseInt(dayData.Date/100)!=parseInt(startDate/100))
                    {
                        isNewData=true;
                        startDate=dayData.Date;
                    }
                    break;
                case 3: //年线
                    if (parseInt(dayData.Date/10000)!=parseInt(startDate/10000))
                    {
                        isNewData=true;
                        startDate=dayData.Date;
                    }
                    break;
                case 22://半年:
                    var halfYear=ChartData.GetHalfYear(dayData.Date);
                    if (halfYear!=startDate)
                    {
                        isNewData=true;
                        startDate=halfYear;
                    }
                    break;
                case 9: //季线
                    var now=ChartData.GetQuarter(dayData.Date);
                    now=parseInt(dayData.Date/10000)*10+now;
                    var last=ChartData.GetQuarter(startDate);
                    last=parseInt(startDate/10000)*10+last;
                    if (now!=last)
                    {
                        isNewData=true;
                        startDate=dayData.Date;
                    }
                    break;
            }

            if (isNewData)
            {
                newData=new HistoryData();
                newData.Date=dayData.Date;
                result.push(newData);

                if (dayData.Open==null || dayData.Close==null) continue;

                newData.Open=dayData.Open;
                newData.High=dayData.High;
                newData.Low=dayData.Low;
                newData.YClose=dayData.YClose;
                newData.Close=dayData.Close;
                newData.Vol=dayData.Vol;
                newData.Amount=dayData.Amount;
                newData.FlowCapital=dayData.FlowCapital;
                newData.Position=dayData.Position; 
                newData.YFClose=dayData.YFClose; 
                newData.FClose=dayData.FClose; 
            }
            else
            {
                if (newData==null) continue;
                if (dayData.Open==null || dayData.Close==null) continue;

                if (newData.Open==null || newData.Close==null)
                {
                    newData.Open=dayData.Open;
                    newData.High=dayData.High;
                    newData.Low=dayData.Low;
                    newData.YClose=dayData.YClose;
                    newData.Close=dayData.Close;
                    newData.Vol=dayData.Vol;
                    newData.Amount=dayData.Amount;
                    newData.FlowCapital=dayData.FlowCapital;
                    newData.Position=dayData.Position; 
                    newData.YFClose=dayData.YFClose; 
                    newData.FClose=dayData.FClose; 
                }
                else
                {
                    if (newData.High<dayData.High) newData.High=dayData.High;
                    if (newData.Low>dayData.Low) newData.Low=dayData.Low;

                    newData.Close=dayData.Close;
                    newData.Vol+=dayData.Vol;
                    if (dayData.Amount!=null) newData.Amount+=dayData.Amount;
                    newData.Position=dayData.Position;
                    newData.FlowCapital=dayData.FlowCapital;
                    newData.Date=dayData.Date;
                    newData.FClose=dayData.FClose; 
                }
            }
        }

        return result;
    }

    this.GetDayCustomPeriodData=function(count)
    {
        var result = [];
        var periodDataCount = count;
        var bFirstPeriodData = false;
        var newData = null;
        for (var i = 0; i < this.Data.length; )
        {
            bFirstPeriodData = true;
            for (var j = 0; j < periodDataCount && i < this.Data.length; ++i, ++j)
            {
                if (bFirstPeriodData)
                {
                    newData = new HistoryData();
                    result.push(newData);
                    bFirstPeriodData = false;
                }
                var dayData = this.Data[i];
                if (dayData == null) continue;    
                
                newData.Date = dayData.Date;
                
                if (dayData.Open==null || dayData.Close==null) continue;
                if (newData.Open==null || newData.Close==null)
                {
                    newData.Open=dayData.Open;
                    newData.High=dayData.High;
                    newData.Low=dayData.Low;
                    newData.YClose=dayData.YClose;
                    newData.Close=dayData.Close;
                    newData.Vol=dayData.Vol;
                    newData.Amount=dayData.Amount;    
                    newData.FlowCapital=dayData.FlowCapital;  
                    newData.Position=dayData.Position;  
                    newData.YFClose=dayData.YFClose; 
                    newData.FClose=dayData.FClose; 
                }
                else
                {
                    if (newData.High<dayData.High)  newData.High=dayData.High;
                    if (newData.Low>dayData.Low) newData.Low=dayData.Low;
                    newData.Close=dayData.Close;
                    newData.Vol+=dayData.Vol;
                    if (dayData.Amount!=null) newData.Amount+=dayData.Amount;
                    newData.Position=dayData.Position;
                    newData.FlowCapital=dayData.FlowCapital;
                    newData.FClose=dayData.FClose;  
                }
            }
        }
        return result;
    }

    //周期数据 1=周 2=月 3=年
    this.GetPeriodData=function(period)
    {
        //外部自定义周期计算函数
        var itemCallback=g_DataPlus.GetPeriodCallback(period);
        if (itemCallback) return itemCallback.Callback(period,this.Data,this);

        if (MARKET_SUFFIX_NAME.IsBIT(this.Symbol))
        {
            if (period==5 || period==6 || period==7 || period==8 || (period>CUSTOM_MINUTE_PERIOD_START && period<=CUSTOM_MINUTE_PERIOD_END)) //分钟K线
            {
                var periodDataCount = 5;
                if (period == 5)
                    periodDataCount = 5;
                else if (period == 6)
                    periodDataCount = 15;
                else if (period == 7)
                    periodDataCount = 30;
                else if (period == 8)
                    periodDataCount = 60;
                else if (period==11)
                    periodDataCount = 120;
                else if (period==12)
                    periodDataCount = 240;
                else if (period>CUSTOM_MINUTE_PERIOD_START && period<=CUSTOM_MINUTE_PERIOD_END)
                    periodDataCount=period-CUSTOM_MINUTE_PERIOD_START;

                return this.GetMinuteCustomPeriodData(periodDataCount);
            }
        }

        //if (period==1 || period==2 || period==3 || period==9 || period==21 || period==22 || (period>CUSTOM_DAY_PERIOD_START && period<=CUSTOM_DAY_PERIOD_END)) 
        if (ChartData.IsDayPeriod(period,false)) return this.GetDayPeriodData(period);
        
        //if (period==5 || period==6 || period==7 || period==8 || period==11 || period==12 || (period>CUSTOM_MINUTE_PERIOD_START && period<=CUSTOM_MINUTE_PERIOD_END)) return this.GetMinutePeriodData(period);
        if (ChartData.IsMinutePeriod(period,false)) return this.GetMinutePeriodData(period);
    }

    //复权  0 不复权 1 前复权 2 后复权
    this.GetRightDate=function(right)
    {
        var result=[];
        if (this.Data.length<=0) return result;

        if (right==1)
        {
            var index=this.Data.length-1;
            var seed=1; //复权系数
            var yClose=this.Data[index].YClose;

            result[index]=HistoryData.Copy(this.Data[index]);

            for(--index; index>=0; --index)
            {
                if (yClose!=this.Data[index].Close) break;
                result[index]=HistoryData.Copy(this.Data[index]);
                yClose=this.Data[index].YClose;
            }

            for(; index>=0; --index)
            {
                var value=this.Data[index].Close;
                if(yClose!=value && value!=0)
                    seed *= yClose/value;

                result[index]=HistoryData.CopyRight(this.Data[index],seed);

                yClose=this.Data[index].YClose;
            }
        }
        else if (right==2)
        {
            var index=0;
            var seed=1;
            var close=this.Data[index].Close;
            result[index]=HistoryData.Copy(this.Data[index]);

            for(++index;index<this.Data.length;++index)
            {
                if (close!=this.Data[index].YClose) break;
                result[index]=HistoryData.Copy(this.Data[index]);
                close=this.Data[index].Close;
            }

            for(;index<this.Data.length;++index)
            {
                if(close!=this.Data[index].YClose)
                    seed *= close/this.Data[index].YClose;

                result[index]=HistoryData.CopyRight(this.Data[index],seed);

                close=this.Data[index].Close;
            }
        }

        return result;
    }

    this.GetRightData=this.GetRightDate;

    //叠加数据和主数据拟合,去掉主数据没有日期的数据
    this.GetOverlayData=function(overlayData, bApiPeriod)
    {
        var result=[];

        for(var i=0,j=0;i<this.Data.length;)
        {
            var date=this.Data[i].Date;

            if (j>=overlayData.length)
            {
                result[i]=new HistoryData();
                result[i].Date=date;
                ++i;
                continue;;
            }

            var overlayDate=overlayData[j].Date;

            if (overlayDate==date)
            {
                result[i]=new HistoryData();
                result[i].Date=overlayData[j].Date;
                result[i].YClose=overlayData[j].YClose;
                result[i].Open=overlayData[j].Open;
                result[i].High=overlayData[j].High;
                result[i].Low=overlayData[j].Low;
                result[i].Close=overlayData[j].Close;
                result[i].Vol=overlayData[j].Vol;
                result[i].Amount=overlayData[j].Amount;

                //涨跌家数数据
                result[i].Stop=overlayData[j].Stop;
                result[i].Up=overlayData[j].Up;
                result[i].Down=overlayData[j].Down;
                result[i].Unchanged=overlayData[j].Unchanged;

                ++j;
                ++i;
            }
            else if (overlayDate<date)
            {
                ++j;
            }
            else
            {
                result[i]=new HistoryData();
                result[i].Date=date;
                ++i;
            }
        }

        return result;
    }

    this.GetOverlayMinuteData=function(overlayData, bApiPeriod)
    {
        var result=[];

        for(var i=0,j=0;i<this.Data.length;)
        {
            var date=this.Data[i].Date;
            var time=this.Data[i].Time;

            if (j>=overlayData.length)
            {
                result[i]=new HistoryData();
                result[i].Date=date;
                result[i].Time=time;
                ++i;
                continue;;
            }

            var overlayDate=overlayData[j].Date;
            var overlayTime=overlayData[j].Time;

            if (overlayDate==date && overlayTime==time)
            {
                result[i]=new HistoryData();
                result[i].Date=overlayData[j].Date;
                result[i].Time=overlayData[j].Time;
                result[i].YClose=overlayData[j].YClose;
                result[i].Open=overlayData[j].Open;
                result[i].High=overlayData[j].High;
                result[i].Low=overlayData[j].Low;
                result[i].Close=overlayData[j].Close;
                result[i].Vol=overlayData[j].Vol;
                result[i].Amount=overlayData[j].Amount;

                //涨跌家数数据
                result[i].Stop=overlayData[j].Stop;
                result[i].Up=overlayData[j].Up;
                result[i].Down=overlayData[j].Down;
                result[i].Unchanged=overlayData[j].Unchanged;

                ++j;
                ++i;
            }
            else if (overlayDate<date || (overlayDate==date && overlayTime<time))
            {
                ++j;
            }
            else
            {
                result[i]=new HistoryData();
                result[i].Date=date;
                result[i].Time=time;
                ++i;
            }
        }

        return result;
    }

    /*
        技术指标数据方法
    */
    //以主图数据 拟合,返回 SingleData 数组
    this.GetFittingData=function(overlayData)
    {
        var result=new Array();

        for(var i=0,j=0;i<this.Data.length;)
        {
            var date=this.Data[i].Date;

            if (j>=overlayData.length)
            {
                result[i]=null;
                ++i;
                continue;;
            }

            var overlayDate=overlayData[j].Date;

            if (overlayDate==date)
            {
                var item=new SingleData();
                item.Date=overlayData[j].Date;
                item.Value=overlayData[j].Value;
                result[i]=item;
                ++j;
                ++i;
            }
            else if (overlayDate<date)
            {
                ++j;
            }
            else
            {
                result[i]=new SingleData();
                result[i].Date=date;
                ++i;
            }
        }

        return result;
    }

    // 缺省数据使用 emptyValue填充
    this.GetFittingData2=function(overlayData,emptyValue)
    {
        var result=new Array();

        for(var i=0,j=0;i<this.Data.length;)
        {
            var date=this.Data[i].Date;

            if (j>=overlayData.length)
            {
                result[i]=new SingleData();
                result[i].Date=date;
                result[i].Value=emptyValue;
                ++i;
                continue;;
            }

            var overlayDate=overlayData[j].Date;

            if (overlayDate==date)
            {
                var item=new SingleData();
                item.Date=overlayData[j].Date;
                item.Value=overlayData[j].Value;
                result[i]=item;
                ++j;
                ++i;
            }
            else if (overlayDate<date)
            {
                ++j;
            }
            else
            {
                result[i]=new SingleData();
                result[i].Date=date;
                result[i].Value=emptyValue;
                ++i;
            }
        }

        return result;
    }

    //日期转化 对应数据索引
    this.GetDateIndex=function(data)
    {
        for(var i=0,j=0;i<this.Data.length;)
        {
            var date=this.Data[i].Date;

            if (j>=data.length) break;

            var dateItem=data[j];

            if (dateItem.Date==date)
            {
                dateItem.Index=i;
                ++j;
            }
            else if (dateItem.Date<date)
            {
                ++j;
            }
            else
            {
                ++i;
            }
        }
    }

    //日期 时间转化 对应数据索引
    this.GetDateTimeIndex=function(data)
    {
        for(var i=0,j=0;i<this.Data.length;)
        {
            var date=this.Data[i].Date;
            var time=this.Data[i].Time;

            if (j>=data.length) break;

            var dateTimeItem=data[j];

            if (dateTimeItem.Date==date && dateTimeItem.Time==time)
            {
                dateTimeItem.Index=i;
                ++j;
            }
            else if (dateTimeItem.Date<date || (dateTimeItem.Date==date && dateTimeItem.Time<time))
            {
                ++j;
            }
            else
            {
                ++i;
            }
        }
    }

    //  分钟数据拟合
    this.GetMinuteFittingData=function(overlayData)
    {
        var result=[];
        for(var i=0,j=0;i<this.Data.length;)
        {
            var date=this.Data[i].Date;
            var time=this.Data[i].Time;

            if (j>=overlayData.length)
            {
                result[i]=null;
                ++i;
                continue;;
            }

            var overlayDate=overlayData[j].Date;
            var overlayTime=overlayData[j].Time;
            const overlayItem=overlayData[j];

            if (overlayDate==date && overlayTime==time)
            {
                var item=new SingleData();
                item.Date=overlayItem.Date;
                item.Time=overlayItem.Time;
                item.Value=overlayItem.Value;
                result[i]=item;
                ++j;
                ++i;
            }
            else if (overlayDate<date || (overlayDate==date && overlayTime<time))
            {
                ++j;
            }
            else
            {
                var item=new SingleData();
                item.Date=date;
                item.Time=time;
                result[i]=item;
                ++i;
            }
        }

        return result;
    }


    //把财报数据拟合到主图数据,返回 SingleData 数组
    this.GetFittingFinanceData=function(financeData)
    {
        var result=[];

        for(var i=0,j=0;i<this.Data.length;)
        {
            var date=this.Data[i].Date;

            if (j<financeData.length)
            {
                var fDate=financeData[j].Date;
                if (date<fDate)
                {
                    ++i;
                    continue;
                }
            }
            
            if (j+1<financeData.length)
            {
                if (financeData[j].Date<date && financeData[j+1].Date<=date)
                {
                    ++j;
                    continue;
                }
            }

            var item=new SingleData();
            item.Date=date;
            if (j<financeData.length)
            {
                item.Value=financeData[j].Value;
                item.FinanceDate=financeData[j].Date;   //财务日期 调试用
            }
            else
            {
                item.Value=null;
                item.FinanceDate=null;
            }
            result[i]=item;

            ++i;
        }

        return result;
    }

    //财务数据拟合到分钟数据上 返回 SingleData 数组
    this.GetMinuteFittingFinanceData=function(financeData)
    {
        var result=[];
        if (!Array.isArray(financeData) || financeData.length<=0) return result;

        var i=0;
        var firstItem=financeData[0];
        for(i=0;i<this.Data.length;++i)
        {
            var date=this.Data[i].Date;
            var time=this.Data[i].Time;
            if (date>firstItem.Date || (date==firstItem.Date && time>=firstItem.Time))
            {
                break;
            }    
        }

        for(var j=0;i<this.Data.length;)
        {
            var date=this.Data[i].Date;
            var time=this.Data[i].Time;

            if (j+1<financeData.length)
            {
                if ((financeData[j].Date<date && financeData[j+1].Date<=date) ||
                    (financeData[j].Date==date && financeData[j].Time<time && financeData[j+1].Time<=time) )
                {
                    ++j;
                    continue;
                }
            }

            var item=new SingleData();
            item.Date=date;
            item.Time=time;
            if (j<financeData.length)
            {
                item.Value=financeData[j].Value;
                item.FinanceDate=financeData[j].Date;   //财务日期 调试用
                item.FinanceTime=financeData[j].Time;   //财务日期 调试用
            }
            else
            {
                item.Value=null;
                item.FinanceDate=null;
                item.FinanceTime=null;
            }
            result[i]=item;

            ++i;
        }

        return result;
    }

    //日线拟合交易数据, 不做平滑处理
    this.GetFittingTradeData=function(tradeData, nullValue, bExactMatch)
    {
        var result=[];
        var bMatch=false;

        for(var i=0,j=0;i<this.Data.length;)
        {
            var date=this.Data[i].Date;

            if (j<tradeData.length)
            {
                if (tradeData[j].Date>date)
                {
                    var item=new SingleData();
                    item.Date=date;
                    item.Value=nullValue;
                    result[i]=item;
                    ++i;
                    continue;
                }
            }

            if (j+1<tradeData.length)
            {
                if (tradeData[j].Date<date && tradeData[j+1].Date<=date)
                {
                    ++j;
                    bMatch=false;
                    continue;
                }
            }

            var item=new SingleData();
            item.Date=date;
            item.Value=nullValue;
            item.FinanceDate=null;
            if (j<tradeData.length)
            {
                var tradeItem=tradeData[j];
                if (this.Period==0 && bExactMatch===true) //日线完全匹配
                {
                    if (tradeItem.Date==item.Date)
                    {
                        item.Value=tradeItem.Value;
                        item.FinanceDate=tradeItem.Date;   //财务日期 调试用
                        bMatch=true;
                    }
                }
                else    //其他日线周期
                {
                    if (bMatch==false)
                    {
                        item.Value=tradeItem.Value;
                        item.FinanceDate=tradeItem.Date;   //财务日期 调试用
                        bMatch=true;
                    }
                }
            }
           
            result[i]=item;
            ++i;
        }

        return result;
    }

    this.GetMinuteFittingTradeData=function(tradeData, nullValue,bExactMatch)
    {
        var result=[];
        var bMatch=false;

        for(var i=0,j=0;i<this.Data.length;)
        {
            var date=this.Data[i].Date;
            var time=this.Data[i].Time;

            if (j<tradeData.length)
            {
                if (tradeData[j].Date>date || (tradeData[j].Date==date && tradeData[j].Time>time))
                {
                    var item=new SingleData();
                    item.Date=date;
                    item.Time=time;
                    item.Value=nullValue;
                    result[i]=item;
                    ++i;
                    continue;
                }
            }

            if (j+1<tradeData.length)
            {
                if ( (tradeData[j].Date<date && tradeData[j+1].Date<=date) || 
                    (tradeData[j].Date==date && tradeData[j].Time<time && tradeData[j+1].Time<=time) )
                {
                    ++j;
                    bMatch=false;
                    continue;
                }
            }

            var item=new SingleData();
            item.Date=date;
            item.FinanceDate=null;
            item.Time=time;
            item.Value=nullValue;
            if (j<tradeData.length)
            {
                var tradeItem=tradeData[j];
                if (this.Period==4 && bExactMatch===true) //1分钟线完全匹配
                {
                    if (tradeItem.Date==item.Date && tradeItem.Time==item.Time)  //完全匹配
                    {
                        item.Value=tradeItem.Value;
                        item.FinanceDate=tradeItem.Date;   //财务日期 调试用
                        item.FinanceTime=tradeItem.Time;
                        bMatch=true;
                    }
                }
                else    //其他日线周期
                {
                    if (bMatch==false)
                    {
                        item.Value=tradeItem.Value;
                        item.FinanceDate=tradeItem.Date;   //财务日期 调试用
                        item.FinanceTime=tradeItem.Time;
                        bMatch=true;
                    }
                }
            }

            result[i]=item;
            ++i;
        }

        return result;
    }

    //市值计算 financeData.Value 是股数
    this.GetFittingMarketValueData=function(financeData)
    {
        var result=[];

        for(var i=0,j=0;i<this.Data.length;)
        {
            var date=this.Data[i].Date;
            var price=this.Data[i].Close;

            if (j+1<financeData.length)
            {
                if (financeData[j].Date<date && financeData[j+1].Date<=date)
                {
                    ++j;
                    continue;
                }
            }

            var item=new SingleData();
            item.Date=date;
            item.Value=financeData[j].Value*price;  //市值计算 收盘价*股数
            item.FinanceDate=financeData[j].Date;   //财务日期 调试用
            result[i]=item;

            ++i;
        }

        return result;
    }

    //月线数据拟合
    this.GetFittingMonthData=function(overlayData)
    {
        var result=new Array();

        var preDate=null;
        for(var i=0,j=0;i<this.Data.length;)
        {
            var date=this.Data[i].Date;

            if (j>=overlayData.length)
            {
                result[i]=null;
                ++i;
                continue;;
            }

            var overlayDate=overlayData[j].Date;

            if (overlayDate==date)
            {
                var item=new SingleData();
                item.Date=overlayData[j].Date;
                item.Value=overlayData[j].Value;
                item.Text=overlayData[j].Text;
                result[i]=item;
                ++j;
                ++i;
            }
            else if (preDate!=null && preDate<overlayDate && date>overlayDate)
            {
                var item=new SingleData();
                item.Date=date;
                item.OverlayDate=overlayData[j].Date;
                item.Value=overlayData[j].Value;
                item.Text=overlayData[j].Text;
                result[i]=item;
                ++j;
                ++i;
            }
            else if (overlayDate<date)
            {
                ++j;
            }
            else
            {
                result[i]=new SingleData();
                result[i].Date=date;
                ++i;
            }

            preDate=date;
        }

        return result;
    }

    this.GetValue=function()
    {
        var result=[];
        for(var i in this.Data)
        {
            if (this.Data[i] && this.Data[i].Value!=null)
            { 
                var item=this.Data[i].Value;
                if (!isNaN(item))
                    result[i]=item;
                else if (item instanceof Array)   //支持数组
                    result[i]=item;
                else
                    result[i]=null;
            }
            else
                result[i]=null;
        }

        return result;
    }

    this.GetObject=function()
    {
        var result=[];
        for(var i in this.Data)
        {
            if (this.Data[i] && this.Data[i].Value)
            { 
                var item=this.Data[i].Value;
                result[i]=item;
            }
            else
                result[i]=null;
        }

        return result;
    }

    this.GetPeriodSingleData=function(period)
    {
        var result=new Array();
        var index=0;
        var startDate=0;
        var weekCount=2;
        var newData=null;
        for(var i in this.Data)
        {
            var isNewData=false;
            var dayData=this.Data[i];
            if (dayData==null || dayData.Date==null) continue;

            switch(period)
            {
                case 1: //周线
                    var fridayDate=ChartData.GetFirday(dayData.Date);
                    if (fridayDate!=startDate)
                    {
                        isNewData=true;
                        startDate=fridayDate;
                    }
                    break;
                case 21: //双周
                    var fridayDate=ChartData.GetFirday(dayData.Date);
                    if (fridayDate!=startDate)
                    {
                        ++weekCount;
                        if (weekCount>=2) 
                        {
                            isNewData=true;
                            weekCount=0;
                        }
                        startDate=fridayDate;
                    }
                    break;
                case 2: //月线
                    if (parseInt(dayData.Date/100)!=parseInt(startDate/100))
                    {
                        isNewData=true;
                        startDate=dayData.Date;
                    }
                    break;
                case 3: //年线
                    if (parseInt(dayData.Date/10000)!=parseInt(startDate/10000))
                    {
                        isNewData=true;
                        startDate=dayData.Date;
                    }
                    break;
                case 9: //季线
                    var now=ChartData.GetQuarter(dayData.Date);
                    now=parseInt(dayData.Date/10000)*10+now;
                    var last=ChartData.GetQuarter(startDate);
                    last=parseInt(startDate/10000)*10+last;
                    if (now!=last)
                    {
                        isNewData=true;
                        startDate=dayData.Date;
                    }
                    break;
            }

            if (isNewData)
            {
                newData=new SingleData();
                newData.Date=dayData.Date;
                newData.Value=dayData.Value;
                result.push(newData);
            }
            else
            {
                if (newData==null) continue;
                if (dayData.Value==null || isNaN(dayData.Value)) continue;
                if (newData.Value==null || isNaN(newData.Value)) newData.Value=dayData.Value;
            }
        }

        return result;
    }

    /*
        分钟数据方法
        this.GetClose()     每分钟价格
        this.GetVol()       每分钟成交量
    */

    //分钟均线
    this.GetMinuteAvPrice=function()
    {
        var result=new Array();
        for(var i in this.Data)
        {
            result[i]=this.Data[i].AvPrice;
        }

        return result;
    }

    this.MergeMinuteData=function(data) //合并数据
    {
        var sourceFirstItem=this.Data[0];
        var firstItemID=0;
        var firstItem=null;
        for(var i=0;i<data.length;++i)  //查找比原始数据起始位置大的数据位置
        {
            var item=data[i];
            if (item.Date>sourceFirstItem.Date)
            {
                firstItemID=i;
                firstItem=item;
                break;
            }

            if (item.Date==sourceFirstItem.Date && item.Time>=sourceFirstItem.Time)
            {
                firstItemID=i;
                firstItem=item;
                break;
            }
        }

        if (firstItem==null) return false;

        var index=null;
        var bFind=false;    //第1个数据是否完全匹配
        for(var i=this.Data.length-1; i>=0;--i)
        {
            var date=this.Data[i].Date;
            var time=this.Data[i].Time;

            if (firstItem.Date>date || (firstItem.Date==date  &&  firstItem.Time>=time) )
            {
                index=i;
                if (firstItem.Date==date && firstItem.Time==time) bFind=true;
                break;
            }
        }

        if (index==null) return false;

        var j=index;        //原始数据插入位置
        var i=firstItemID;  //合并数据起始位置
        if (bFind==true)    //第1个数据匹配,覆盖
        {
            var item=data[i];
            if (j-1>0 && !item.YClose) item.YClose=this.Data[j-1].Close;   //前收盘如果没有就是上一记录的收盘
            var newItem=HistoryData.Copy(item);
            this.Data[j]=newItem;
            ++j;
            ++i;
        }
        else            //从下一个数据开始插入
        {
            ++j;
        }

        for(;i<data.length; )
        {
            var item=data[i];
            if (j>=this.Data.length-1)
            {
                if (j-1>0 && !item.YClose) item.YClose=this.Data[j-1].YClose;   //前收盘如果没有就是上一记录的收盘
                var newItem=HistoryData.Copy(item);
                this.Data[j]=newItem;
                ++j;
                ++i;
            }
            else
            {
                var oldItem=this.Data[j];
                if (oldItem.Date==item.Date && oldItem.Time==item.Time) //更新数据
                {
                    HistoryData.CopyTo(oldItem,item);
                    ++j;
                    ++i;
                }
                else
                {
                    ++j;
                }
            }
        }

        //JSConsole.Chart.Log('[ChartData::MergeMinuteData] ', this.Data, data);

        return true;
    }

    //跨周期转化
    this.ConverPeriod=function(data, curPeriod, changePeriod) //把数据用data, 日期时间不变, curPeriod=当前周期  changePeriod=需要转换周期
    {
        var result=[];
        var tempItem=null;
        var isMinute=ChartData.IsMinutePeriod(curPeriod,true);
        var isMinute2=ChartData.IsMinutePeriod(changePeriod,true);
        var isMimToMin=isMinute && isMinute2;
        var isMinToDay=isMinute && !isMinute2;
        var isDayToDay=!isMinute && !isMinute2;

        for(var i=0,j=0; i<this.Data.length; ++i)
        {
            var item=this.Data[i];  //原始数据
            for(;j<data.length;++j)
            {
                var periodItem=data[j];

                if (isMimToMin)  //都是分钟数据
                {
                    if ( (periodItem.Date>item.Date) || (periodItem.Date==item.Date && periodItem.Time>=item.Time) )
                    {
                        tempItem=periodItem;
                        break;
                    }
                }
                else if (isMinToDay || isDayToDay)    //分钟 => 日线, 日线 => 日线
                {
                    if (periodItem.Date>=item.Date)
                    {
                        tempItem=periodItem;
                        break;
                    }
                }
            }
            
            var newItem=null;
            if (tempItem) 
            {
                newItem=HistoryData.Copy(tempItem);
                newItem.PDate=tempItem.Date;
                newItem.PTime=tempItem.Time;
            }
            else newItem=new HistoryData();
            
            newItem.Date=item.Date;
            if (isMimToMin || isMinToDay) newItem.Time=item.Time;
            result.push(newItem);
        }

        JSConsole.Chart.Log('[ChartData::ConverPeriod] result', result);
        return result;
    }

    this.GetRef=function(n)
    {
        let result=[];

        for(var i=0 ;i<this.Data.length; ++i )
        {
            result[i]=null;
            var itemDate=this.Data[i];  //原始数据

            if (i-n<0) 
            {
                var newData=new HistoryData();
                newData.Date=itemDate.Date;
                newData.Time=itemDate.Time;
                result[i]=newData;
                continue;
            }

            var itemData=this.Data[i-n];
            var newData=HistoryData.Copy(itemData);
            newData.Date=itemDate.Date;
            newData.Time=itemDate.Time;

            result[i]=newData;
        }

        return result;
    }

    //拟合其他K线数据指标   
    this.FitKLineIndex=function(kLineData, outVar, peirod, indexPeriod)
    {
        var count=this.Data.length;         //原始K线数据
        var indexCount=kLineData.length;    //拟合K线数据
        var isMinutePeriod=[ChartData.IsMinutePeriod(peirod,true), ChartData.IsMinutePeriod(indexPeriod,true) ]; //0=原始K线 1=需要拟合的K线
        var isDayPeriod=[ChartData.IsDayPeriod(peirod,true), ChartData.IsDayPeriod(indexPeriod,true)  ];   //0=原始K线 1=需要拟合的K线
        var firstItem=ChartData.GetKLineDataTime(this.Data[0]);

        //计算拟合以后的数据索引
        var aryFixDataID=[];
        var indexStart=indexCount;
        for(var i=0;i<indexCount;++i)
        {
            var item=ChartData.GetKLineDataTime(kLineData[i]);

            if ( (isDayPeriod[0] && isDayPeriod[1]) || (isMinutePeriod[0] && isDayPeriod[1]) )   //日线(拟合) => 日线(原始)    日线(拟合 => 分钟(原始)
            {
                if (item.Date>=firstItem.Date)
                {
                    indexStart = i;
                    break;
                }
            }
            else if (isMinutePeriod[0] && isMinutePeriod[1]) //分钟(拟合 => 分钟(原始)
            {
                if (item.Date>firstItem.Date)
                {
                    indexStart = i;
                    break;
                }

                if (item.Date == firstItem.Date && item.Time >= firstItem.Time )
                {
                    indexStart = i;
                    break;
                }
            }
        }

        for(var i=0, j=indexStart; i<count; )
        {
            var item=ChartData.GetKLineDataTime(this.Data[i]);
            if (j>=indexCount)
            {
                var fitItem={ Date:item.Date, Time:item.Time, Index:-1 };
                aryFixDataID[i]=fitItem;
                ++i;
                continue;
            }

            var destItem=ChartData.GetKLineDataTime(kLineData[j]);
            if ( (isDayPeriod[0] && isDayPeriod[1]) || (isMinutePeriod[0] && isDayPeriod[1]) )  //日线(拟合) => 日线(原始)    日线(拟合 => 分钟(原始)
            {
                if (destItem.Date == item.Date)
                {
                    var fitItem={ Date:item.Date, Time:item.Time, Index:j, Data2:destItem.Date, Time2:destItem.Time };
                    aryFixDataID[i]=fitItem;
                    ++i;
                }
                else 
                {
                    if (j+1<indexCount)
                    {
                        var nextDestItem=ChartData.GetKLineDataTime(kLineData[j+1]);
                        if ( destItem.Date<=item.Date && nextDestItem.Date>item.Date )
                        {
                            var fitItem={ Date:item.Date, Time:item.Time, Index:j+1, Data2:nextDestItem.Date, Time2:nextDestItem.Time };
                            aryFixDataID[i]=fitItem;
                            ++i;
                        }
                        else if (nextDestItem.Date <= item.Date )
                        {
                            ++j;
                        }
                        else
                        {
                            var fitItem={ Date:item.Date, Time:item.Time, Index:-1 };
                            aryFixDataID[i]=fitItem;
                            ++i;
                        }
                    }
                    else
                    {
                        ++j;
                    }
                }
            }
            else if (isMinutePeriod[0] && isMinutePeriod[1])    //分钟(拟合 => 分钟(原始)
            {
                if (destItem.Date == item.Date && destItem.Time == item.Time)
                {
                    var fitItem={ Date:item.Date, Time:item.Time, Index:j, Data2:destItem.Date, Time2:destItem.Time };
                    aryFixDataID[i]=fitItem;
                    ++i;
                }
                else
                {
                    if (j+1<indexCount)
                    {
                        var nextDestItem=ChartData.GetKLineDataTime(kLineData[j+1]);
                        if ( (destItem.Date<item.Date && nextDestItem.Date>item.Date) || 
                            (destItem.Date == item.Date && destItem.Time < item.Time && nextDestItem.Date == item.Date && nextDestItem.Time > item.Time) ||
                            (destItem.Date == item.Date && destItem.Time < item.Time && nextDestItem.Date > item.Date) ||
                            (destItem.Date < item.Date && nextDestItem.Date == item.Date && nextDestItem.Time > item.Time) )
                        {
                            var fitItem={ Date:item.Date, Time:item.Time, Index:j+1, Data2:nextDestItem.Date, Time2:nextDestItem.Time };
                            aryFixDataID[i]=fitItem;
                            ++i;
                        }
                        else if (nextDestItem.Date < item.Date || (nextDestItem.Date == item.Date && nextDestItem.Time <= item.Time) )
                        {
                            ++j;
                        }
                        else
                        {
                            var fitItem={ Date:item.Date, Time:item.Time, Index:-1 };
                            aryFixDataID[i]=fitItem;
                            ++i;
                        }
                    }
                    else
                    {
                        ++j;
                    }
                }
            }
        }

        //拟合数据
        var result=[];
        for(var i in outVar)
        {
            var item=outVar[i];
            if (Array.isArray(item.Data)) 
            {
                var data=[];
                result[i]={ Data:data, Name:item.Name } ;
                for(var j=0;j<aryFixDataID.length;++j)
                {
                    var dataItem=aryFixDataID[j];
                    data[j]=null;
                    if ( dataItem && dataItem.Index>=0 && dataItem.Index<item.Data.length )
                        data[j]=item.Data[dataItem.Index];
                }
            }
            else 
            {
                result[i]={ Data:item.Data, Name:item.Name} ;
            }
        }

        return result;
    }

    //获取数据索引
    this.FindDataIndexByDateTime=function(aryDateTime) //aryDateTime=[ { Date:, Time:, Index:-1 }, ......]
    {
        var findCount=0;
        for(var i in aryDateTime)
        {
            aryDateTime[i].Index=-1;
        }

        for(var i in this.Data)
        {
            var item=this.Data[i];
            for(var j in aryDateTime)
            {
                var findItem=aryDateTime[j];
                if (findItem.Index>=0) continue;

                if (IFrameSplitOperator.IsNumber(findItem.Time))
                {
                    if (findItem.Date==item.Date && findItem.Time==item.Time)
                    {
                        findItem.Index=parseInt(i);
                        ++findCount;
                        break;
                    }
                }
                else
                {
                    if (findItem.Date==item.Date)
                    {
                        findItem.Index=parseInt(i);
                        ++findCount;
                        break;
                    }
                }

                if (findCount>=aryDateTime.length) break;
            }
        }
    }

    //深拷贝数据
    this.CloneData=function(className)
    {
        var result=[];
        if (className=="HistoryData")
        {
            for(var i in this.Data)
            {
                var item=this.Data[i];
                var newItem=HistoryData.Copy(item);
                result.push(newItem);
            }
        }
        return result;
    }

    this.GetAPIDataIndex=function(date,time)
    {
        var result=[];
        if (date && time)
        {
            var count=this.Data.length;         //原始K线数据
            var indexCount=date.length;         //拟合数据
            var firstItem=ChartData.GetKLineDataTime(this.Data[0]);
            var indexStart=indexCount;  //拟合数据的起始位置

            var indexStart=indexCount;  //拟合数据的起始位置
            for(var i=0;i<indexCount;++i)
            {
                var itemDate=date[i];
                var itemTime=time[i];
    
               if (itemDate>firstItem.Date || (itemDate == firstItem.Date && itemTime >= firstItem.Time))
                {
                    indexStart = i;
                    break;
                }
            }

            for(var i=0, j=indexStart; i<count; )
            {
                var item=this.Data[i];
                if (j>=indexCount)
                {
                    var fitItem={ KDate:item.Date, KTime:item.Time, KIndex:i, Index:-1 };
                    result[i]=fitItem;
                    ++i;
                    continue;
                }

                var itemDate=date[j];
                var itemTime=time[j];
                if (itemDate == item.Date && itemTime == item.Time)
                {
                    var fitItem={ KDate:item.Date, KTime:item.Time, KIndex:i, Index:j, Data:itemDate, Time:itemTime };
                    result[i]=fitItem;
                    ++i;
                }
                else
                {
                    if (j+1<indexCount)
                    {
                        var nextItemDate=date[j+1];
                        var nextItemTime=time[j+1];

                        if ( (itemDate<item.Date && nextItemDate>item.Date) || 
                            (itemDate == item.Date && itemTime < item.Time && nextItemDate == item.Date && nextItemTime > item.Time) ||
                            (itemDate == item.Date && itemTime < item.Time && nextItemDate > item.Date) ||
                            (itemDate < item.Date && nextItemDate == item.Date && nextItemTime > item.Time) )
                        {
                            var fitItem={ KDate:item.Date, KTime:item.Time, KIndex:i, Index:j, Data:itemDate, Time:itemTime };
                            result[i]=fitItem;
                            ++i;
                        }
                        else if (nextItemDate < item.Date || (nextItemDate == item.Date && nextItemTime <= item.Time) )
                        {
                            ++j;
                        }
                        else
                        {
                            var fitItem={ KDate:item.Date, KTime:item.Time, KIndex:i, Index:-1 };
                            result[i]=fitItem;
                            ++i;
                        }
                    }
                    else
                    {
                        ++j;
                    }
                }
            }
        }
        else if (date)
        {
            var count=this.Data.length;         //原始K线数据
            var indexCount=date.length;         //拟合数据
            var firstItem=ChartData.GetKLineDataTime(this.Data[0]);

            var indexStart=indexCount;  //拟合数据的起始位置
            for(var i=0;i<indexCount;++i)
            {
                var item=date[i];
    
                if (item>=firstItem.Date)
                {
                    indexStart = i;
                    break;
                }
            }

            for(var i=0, j=indexStart; i<count; )
            {
                var item=this.Data[i];
                if (j>=indexCount)
                {
                    var fitItem={ KDate:item.Date, KIndex:i, Index:-1 };
                    result[i]=fitItem;
                    ++i;
                    continue;
                }

                var destDate=date[j];
                if (destDate == item.Date)
                {
                    var fitItem={ KDate:item.Date, KIndex:i, Index:j, Data:destDate };
                    result[i]=fitItem;
                    ++i;
                }
                else 
                {
                    if (j+1<indexCount)
                    {
                        var nextDestDate=date[j+1];
                        if ( destDate<=item.Date && nextDestDate>item.Date )
                        {
                            var fitItem={ KDate:item.Date, KIndex:i, Index:j, Data:destDate };
                            result[i]=fitItem;
                            ++i;
                        }
                        else if (nextDestDate <= item.Date )
                        {
                            ++j;
                        }
                        else
                        {
                            var fitItem={ KDate:item.Date, KIndex:i, Index:-1 };
                            result[i]=fitItem;
                            ++i;
                        }
                    }
                    else
                    {
                        ++j;
                    }
                }
            }
        }
        return result;
    }

    //K线数据拟合
    this.FixKData=function(aryKData, period)
    {
        if (ChartData.IsDayPeriod(period,true))
        {
            return this.FixKData_Day(aryKData);
        }
        else if (ChartData.IsMinutePeriod(period,true))
        {
            return this.FixKData_Minute(aryKData);
        }
        
        return null;
    }

    this.FixKData_Day=function(aryKData)
    {
        var result=[];
        var nOverlayDataCount=aryKData.length;
        for(var i=0,j=0; i<this.Data.length;)
        {
            var kItem=this.Data[i];
            if (j<nOverlayDataCount)
            {
                var fItem=aryKData[j];
                if (fItem.Date>kItem.Date)
                {
                    ++i;
                    continue;
                }
            }

            if (j+1<nOverlayDataCount)
            {
                var fItem = aryKData[j];
                var fItem2 = aryKData[j + 1];

                if (fItem.Date < kItem.Date && fItem2.Date <= kItem.Date)
                {
                    ++j;
                    continue;
                }
            }

            var item=new HistoryData();
            item.Date=kItem.Date;
            var index=j<nOverlayDataCount ? j : nOverlayDataCount-1;
            var fItem=aryKData[index];

            item.Close = fItem.Close;
			item.High = fItem.High;
			item.Low = fItem.Low;
			item.Open = fItem.Open;
			item.YClose = fItem.YClose;
			item.Amount = fItem.Amount;
            item.Vol = fItem.Vol;
            item.ExDate = fItem.Date;   //对应叠加数据的日期 调试用

            result[i]=item;
            ++i;
        }

        return result;
    }

    this.FixKData_Minute=function(aryKData)
    {
        var result=[];
        var nOverlayDataCount=aryKData.length;
        for(var i=0,j=0; i<this.Data.length;)
        {
            var kItem=this.Data[i];
            var kDateTime=ChartData.DateTimeToNumber(kItem);

            if (j<nOverlayDataCount)
            {
                var fItem=aryKData[j];
                var fDateTime=ChartData.DateTimeToNumber(fItem);
                if (fDateTime>kDateTime)
                {
                    ++i;
                    continue;
                }
            }

            if (j+1<nOverlayDataCount)
            {
                var fItem = aryKData[j];
                var fItem2 = aryKData[j + 1];
                var fDateTime=ChartData.DateTimeToNumber(fItem);
                var fDateTime2=ChartData.DateTimeToNumber(fItem2);

                if (fDateTime < kDateTime && fDateTime2 <= kDateTime)
                {
                    ++j;
                    continue;
                }
            }

            var item=new HistoryData();
            item.Date=kItem.Date;
            item.Time=kItem.Time;
            var index=j<nOverlayDataCount ? j : nOverlayDataCount-1;
            var fItem=aryKData[index];

            item.Close = fItem.Close;
			item.High = fItem.High;
			item.Low = fItem.Low;
			item.Open = fItem.Open;
			item.YClose = fItem.YClose;
			item.Amount = fItem.Amount;
            item.Vol = fItem.Vol;
            item.ExDate = fItem.Date;   //对应叠加数据的日期 调试用
            item.ExTime=fItem.Time;     //对应叠加数据的日期 调试用

            result[i]=item;
            ++i;
        }

        return result;
    }
}

ChartData.DateTimeToNumber=function(kItem)
{
    return kItem.Date*10000+kItem.Time;
}

ChartData.GetKLineDataTime=function(kLineItem)   //获取K线的 日期和时间 如果时间没有就用0
{
    var result={ Date:kLineItem.Date, Time:0 };
    if (IFrameSplitOperator.IsNumber(kLineItem.Time)) result.Time=kLineItem.Time;

    return result;
}

ChartData.GetFirday=function(value)
{
    var date=new Date(parseInt(value/10000),(value/100%100-1),value%100);
    var day=date.getDay();
    if (day==5) return value;

    var timestamp=date.getTime();
    if (day<5)
    {
        var prevTimestamp=(24*60*60*1000)*(5-day);
        timestamp+=prevTimestamp;
    }
    else
    {
        var prevTimestamp=(24*60*60*1000)*(day-5);
        timestamp-=prevTimestamp;
    }

    date.setTime(timestamp);
    var fridayDate= date.getFullYear()*10000+(date.getMonth()+1)*100+date.getDate();
    var week=date.getDay();
    return fridayDate;

}

ChartData.GetSunday=function(value)
{
    var date=new Date(parseInt(value/10000),(value/100%100-1),value%100);
    var day=date.getDay();
    if (day==0) return value;

    var timestamp=date.getTime();
    if (day>0)
    {
        var prevTimestamp=(24*60*60*1000)*(7-day);
        timestamp+=prevTimestamp;
    }

    date.setTime(timestamp);
    var sundayDate= date.getFullYear()*10000+(date.getMonth()+1)*100+date.getDate();
    var week=date.getDay();
    return sundayDate;
}

ChartData.GetQuarter=function(value)
{
    var month=parseInt(value%10000/100);
    if (month==1 || month==2 || month==3) return 1;
    else if (month==4 || month==5 || month==6) return 2;
    else if (month==7 || month==8 || month==9) return 3;
    else if (month==10 || month==11 || month==12) return 4;
    else return 0;
}

ChartData.GetHalfYear=function(value)
{
    var year=parseInt(value/10000);
    var day=value%10000;
    if (day<=630) return year*10000+630;
    return year*10000+1231;
}

//是否是日线周期  0=日线 1=周线 2=月线 3=年线 9=季线 21=双周 22=半年 [40001-50000) 自定义日线 (isIncludeBase 是否包含基础日线周期)
var CUSTOM_DAY_PERIOD_START=40000, CUSTOM_DAY_PERIOD_END=49999;
ChartData.IsDayPeriod=function(period, isIncludeBase)
{
    if (period==1 || period==2 || period==3 || period==9 || period==21 || period==22) return true;
    if (period>CUSTOM_DAY_PERIOD_START && period<=CUSTOM_DAY_PERIOD_END) return true;
    if (period==0 && isIncludeBase==true) return true;

    return false;
}

//是否是分钟周期 4=1分钟 5=5分钟 6=15分钟 7=30分钟 8=60分钟 11=120分钟 12=240分钟 [20001-30000) 自定义分钟 (isIncludeBase 是否包含基础1分钟周期)
var CUSTOM_MINUTE_PERIOD_START=20000, CUSTOM_MINUTE_PERIOD_END=29999;
ChartData.IsMinutePeriod=function(period,isIncludeBase)
{
    if (period==5 || period==6 || period==7 || period==8 ||period==11 || period==12) return true;
    if (period>CUSTOM_MINUTE_PERIOD_START && period<=CUSTOM_MINUTE_PERIOD_END) return true;
    if (period==4 && isIncludeBase==true) return true;

    return false;
}

//是否是秒周期 [30001-32000)
var CUSTOM_SECOND_PERIOD_START=30000, CUSTOM_SECOND_PERIOD_END=32000;
ChartData.IsSecondPeriod=function(period)
{
    if (period>CUSTOM_SECOND_PERIOD_START && period<=CUSTOM_SECOND_PERIOD_END) return true;
    return false;
}


//是否是分笔图 10=分笔
ChartData.IsTickPeriod=function(period)
{
    return period==10;
}

//获取周期名字
ChartData.GetPeriodName=function(period)
{
    var mapName=new Map(
    [
        [0, '日线'],[1, '周线'],[2, '月线'],[3, '年线'],[9, '季线'], [21,'双周'],[22,"半年"],
        [4, '1分'], [5, '5分'], [6, '15分'],[7, '30分'],[8, '60分'],[11, '2小时'],[12, '4小时'],
        [10, '分笔']
    ]);

    if (mapName.has(period)) return mapName.get(period);

    return '';
}


function TooltipData()              //提示信息
{
    this.ChartPaint;
    this.Data;
    this.Type=0;
}

function Rect(x,y,width,height)
{
    this.X=x,
    this.Y=y;
    this.Width=width;
    this.Height=height;
}

//图新画法接口类
function IChartPainting()
{
    this.Canvas;                        //画布
    this.ChartBorder;                   //边框信息
    this.ChartFrame;                    //框架画法
    this.Name;                          //名称
    this.ClassName='IChartPainting';    //类名
    this.Data=new ChartData();          //数据区

    this.NotSupportMessage=null;
    this.MessageFont=g_JSChartResource.Index.NotSupport.Font;
    this.MessageColor=g_JSChartResource.Index.NotSupport.TextColor;
    this.IsDrawFirst=false;
    this.IsShow=true;

    this.Draw=function()
    {

    }

    this.GetBorder=function()
    {
        if (this.ChartFrame.IsHScreen) return this.ChartBorder.GetHScreenBorder();
        return this.ChartBorder.GetBorder();
    }

    this.ClipClient=function(isHScreen)          //裁剪客户端
    {
        if (isHScreen==true)
        {
            var left=this.ChartBorder.GetLeftEx();
            var right=this.ChartBorder.GetRightEx();
            var top=this.ChartBorder.GetTop();
            var bottom=this.ChartBorder.GetBottom();
        }
        else
        {
            var left=this.ChartBorder.GetLeft();
            var right=this.ChartBorder.GetRight();
            var top=this.ChartBorder.GetTopEx();
            var bottom=this.ChartBorder.GetBottomEx();
        }

        this.Canvas.beginPath();
        this.Canvas.rect(left,top,(right-left),(bottom-top));
        //this.Canvas.stroke(); //调试用
        this.Canvas.clip();
    }

    this.GetYFromData=function(value,isLimit)
    {
        return this.ChartFrame.GetYFromData(value,isLimit);
    }

    this.IsMinuteFrame=function()
    {
        var isMinute=(this.ChartFrame.ClassName=="MinuteFrame" || this.ChartFrame.ClassName=="MinuteHScreenFrame" ||
            this.ChartFrame.ClassName=="OverlayMinuteFrame" || this.ChartFrame.ClassName=="OverlayMinuteHScreenFrame" );

        return isMinute
    }

    this.DrawNotSupportmessage=function()
    {
        this.Canvas.font=this.MessageFont;
        this.Canvas.fillStyle=this.MessageColor;

        var left=this.ChartBorder.GetLeft();
        var width=this.ChartBorder.GetWidth();
        var top=this.ChartBorder.GetTopEx();
        var height=this.ChartBorder.GetHeightEx();

        var x=left+width/2;
        var y=top+height/2;

        this.Canvas.textAlign="center";
        this.Canvas.textBaseline="middle";
        this.Canvas.fillText(this.NotSupportMessage,x,y);
    }

    this.GetTooltipData=function(x,y,tooltip)
    {
        return false;
    }

    this.GetMaxMin=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var range={};
        range.Min=null;
        range.Max=null;

        if(!this.Data || !this.Data.Data) return range;

        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i];
            if (value==null || isNaN(value)) continue;

            if (range.Max==null) range.Max=value;
            if (range.Min==null) range.Min=value;

            if (range.Max<value) range.Max=value;
            if (range.Min>value) range.Min=value;
        }

        return range;
    }

    this.GetDynamicFont=function(dataWidth, distanceWidth,  maxSize, minSize, zoom, fontname)    //根据宽度自动获取对应字体
    {
        var pixelTatio = GetDevicePixelRatio();
        maxSize*=pixelTatio;
        minSize*=pixelTatio;

        if (maxSize==minSize)   //固定大小
        {
            var font=`${maxSize.toFixed(0)}px ${fontname}` ;
            return font;
        }

        var fontSize=(dataWidth+distanceWidth);
        if (zoom)
        {
            if (zoom.Type==0) 
            {
                if (zoom.Value>0) fontSize=(dataWidth*zoom.Value);
            }
            else if (zoom.Type==1)
            {
                if (zoom.Value>0) fontSize=(dataWidth+distanceWidth)*zoom.Value;
            }
            else if (zoom.Type==2)
            {
                if (IFrameSplitOperator.IsNumber(zoom.Value)) 
                    fontSize=(dataWidth+distanceWidth) + (2*zoom.Value)*pixelTatio;
            }
        }

        if (fontSize<minSize) fontSize=minSize;
        else if (fontSize>maxSize) fontSize=maxSize;

        var font=`${fontSize.toFixed(0)}px ${fontname}` ;

        /*
        if (dataWidth < 5) font =4*pixelTatio + 'px Arial';           //字体根据数据宽度动态调整
        else if (dataWidth < 7) font = 6*pixelTatio +'px Arial';
        else if (dataWidth < 9) font = 8*pixelTatio +'px Arial';
        else if (dataWidth < 11) font =10*pixelTatio +'px Arial';
        else if (dataWidth < 13) font =12*pixelTatio +'px Arial';
        else if (dataWidth < 15) font =14*pixelTatio + 'px Arial';
        else font =16*pixelTatio + 'px Arial';
        */
        
        return font;
    }

    this.GetLockRect=function()
    {
        return this.ChartFrame.GetLockRect();
    }

    this.SetFillStyle=function(color, x0, y0, x1, y1)
    {
        if (Array.isArray(color))
        {
            let gradient = this.Canvas.createLinearGradient(x0, y0, x1, y1);
            var offset=1/(color.length);
            for(var i in color)
            {
                gradient.addColorStop(i*offset, color[i]);
            }
            this.Canvas.fillStyle=gradient;
        }
        else
        {
            this.Canvas.fillStyle=color;
        }
    }

    this.GetDynamicIconSize=function(dataWidth, distanceWidth, maxSize, minSize, zoom)
    {
        var pixelTatio = GetDevicePixelRatio();
        maxSize*=pixelTatio;
        minSize*=pixelTatio;

        if (maxSize==minSize) return maxSize;

        var iconSize=(dataWidth+distanceWidth)-2*pixelTatio;

        if (zoom)
        {
            if (zoom.Type==0) 
            {
                if (zoom.Value>0) iconSize=(dataWidth*zoom.Value);
            }
            else if (zoom.Type==1)
            {
                if (zoom.Value>0) iconSize=(dataWidth+distanceWidth)*zoom.Value;
            }
            else if (zoom.Type==2)
            {
                if (IFrameSplitOperator.IsNumber(zoom.Value)) 
                    iconSize=(dataWidth+distanceWidth) + (2*zoom.Value)*pixelTatio;
            }
        }

        if (iconSize<minSize) iconSize=minSize;
        else if (iconSize>maxSize) iconSize=maxSize;

        return iconSize;
    }

}


//缩放因子
/*
var ZOOM_SEED=
[
    [49,10],	[46,9],		[43,8],
    [41,7.5],	[39,7],		[37,6],
    [31,5.5],	[27,5],		[23,4.5],
    [21,4],		[18,3.5],	[16,3],
    [13,2.5],	[11,2],		[8,1.5],
    [6,1],		[3,0.6],	[2.2,0.5],
    //太多了卡,
    //[1.1,0.3],
    //[0.9,0.2],	[0.7,0.15],
    //[0.6,0.12],	[0.5,0.1],	[0.4,0.08],
    //[0.3,0.06],	[0.2,0.04],	[0.1,0.02]
];
*/


var ZOOM_SEED=  //0=柱子宽度  1=间距
[
    [48,10],	[44,10], 
    [40,9],     [36,9],	
    [32,8],     [28,8],	
    [24,7],     [20,7], 
    [18,6],     [16,6],
    [14,5],     [12,5],
    [8,4], [6,4], [4,4], 

    [3,3],
    [3,1], [2,1], [1,1], [1,0],

    //[0.5,0],[0.4,0],[0.3,0],[0.2,0],[0.1,0]
];


//K线画法 支持横屏
function ChartKLine()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='ChartKLine';    //类名
    this.Symbol;        //股票代码
    this.DrawType=0;    // 0=实心K线柱子  1=收盘价线 2=美国线 3=空心K线柱子 4=收盘价面积图
    this.CloseLineColor=g_JSChartResource.CloseLineColor;
    this.CloseLineAreaColor=g_JSChartResource.CloseLineAreaColor;
    this.CloseLineWidth=g_JSChartResource.CloseLineWidth;
    this.UpColor=g_JSChartResource.UpBarColor;
    this.DownColor=g_JSChartResource.DownBarColor;
    this.UnchagneColor=g_JSChartResource.UnchagneBarColor;          //平盘
    this.ColorData;             //五彩K线颜色 >0：g_JSChartResource.UpBarColor 其他：g_JSChartResource.DownBarColor
    this.TradeData;             //交易系统 包含买卖数据{Buy:, Sell:, Name:指标名称 }
    this.TradeIcon=g_JSChartResource.KLine.TradeIcon;
    this.TooltipRect=[];                    //2位数组 0 数据序号 1 区域
    this.InfoTooltipRect=[];                //2维数组 0 数据,  1 区域
    this.TradeIconTooltipRect=[];           //2维数组 0 数据,  1 区域

    this.IsShowMaxMinPrice=true;                 //是否显示最大最小值
    this.IsShowKTooltip=true;                    //是否显示K线tooltip
    this.TextFont=g_JSChartResource.KLine.MaxMin.Font;
    this.TextColor=g_JSChartResource.KLine.MaxMin.Color;

    this.InfoData;      //信息地雷 key=日期  value=信息数据
    this.InfoPosition=0;    // 0=K线上 1 底部

    this.PtMax;     //最大值的位置
    this.PtMin;     //最小值的位置

    this.TickSymbol='╳';    //分笔显示的图标
    this.TickFontName='arial';
    this.Period;            //周期
    this.ShowRange={ };     //K线显示范围 { Start:, End:,  DataCount:, ShowCount: }

    this.ReloadResource=function(resource)
    {
        this.TextFont=g_JSChartResource.KLine.MaxMin.Font;
        this.TextColor=g_JSChartResource.KLine.MaxMin.Color;

        this.CloseLineColor=g_JSChartResource.CloseLineColor;
        this.CloseLineAreaColor=g_JSChartResource.CloseLineAreaColor;
        this.CloseLineWidth=g_JSChartResource.CloseLineWidth;

        this.UpColor=g_JSChartResource.UpBarColor;
        this.DownColor=g_JSChartResource.DownBarColor;
        this.UnchagneColor=g_JSChartResource.UnchagneBarColor;          //平盘
    }

    this.DrawAKLine=function()  //美国线
    {
        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var xPointCount=this.ChartFrame.XPointCount;

        if (isHScreen)
        {
            var border=this.ChartBorder.GetHScreenBorder();
            var xOffset=border.TopEx+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
            var chartright=border.BottomEx;
        }
        else
        {
            var border=this.ChartBorder.GetBorder();
            var xOffset=border.LeftEx+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
            var chartright=border.RightEx;
        }

        var upColor=this.UpColor;
        var downColor=this.DownColor;
        var unchagneColor=this.UnchagneColor; 

        var ptMax={X:null,Y:null,Value:null,Align:'left'};
        var ptMin={X:null,Y:null,Value:null,Align:'left'};
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var data=this.Data.Data[i];
            if (data.Open==null || data.High==null || data.Low==null || data.Close==null) continue;

            var left=xOffset;
            var right=xOffset+dataWidth;
            if (right>chartright) break;
            var x=left+(right-left)/2;
            var yLow=this.GetYFromData(data.Low,false);
            var yHigh=this.GetYFromData(data.High,false);
            var yOpen=this.GetYFromData(data.Open,false);
            var yClose=this.GetYFromData(data.Close,false);

            if (ptMax.Value==null || ptMax.Value<data.High)     //求最大值
            {
                ptMax.X=x;
                ptMax.Y=yHigh;
                ptMax.Value=data.High;
                ptMax.Align=j<xPointCount/2?'left':'right';
            }

            if (ptMin.Value==null || ptMin.Value>data.Low)      //求最小值
            {
                ptMin.X=x;
                ptMin.Y=yLow;
                ptMin.Value=data.Low;
                ptMin.Align=j<xPointCount/2?'left':'right';
            }

            if (data.Open<data.Close) this.Canvas.strokeStyle=this.UpColor; //阳线
            else if (data.Open>data.Close) this.Canvas.strokeStyle=this.DownColor; //阳线
            else this.Canvas.strokeStyle=this.UnchagneColor; //平线

            if (this.ColorData) ///五彩K线颜色设置
            {
                if (i<this.ColorData.length)
                    upColor=downColor=unchagneColor=(this.ColorData[i]>0?this.UpColor:this.DownColor);
                else
                    upColor=downColor=unchagneColor=this.DownColor;
            }

            this.Canvas.beginPath();   //最高-最低
            if (isHScreen)
            {
                this.Canvas.moveTo(yHigh,ToFixedPoint(x));
                this.Canvas.lineTo(yLow,ToFixedPoint(x));
            }
            else
            {
                this.Canvas.moveTo(ToFixedPoint(x),yHigh);
                this.Canvas.lineTo(ToFixedPoint(x),yLow);
            }
            
            this.Canvas.stroke();

            if (dataWidth>=4)
            {
                this.Canvas.beginPath();    //开盘
                if (isHScreen)
                {
                    this.Canvas.moveTo(ToFixedPoint(yOpen),left);
                    this.Canvas.lineTo(ToFixedPoint(yOpen),x);
                }
                else
                {
                    this.Canvas.moveTo(left,ToFixedPoint(yOpen));
                    this.Canvas.lineTo(x,ToFixedPoint(yOpen));
                }
                this.Canvas.stroke();

                this.Canvas.beginPath();    //收盘
                if (isHScreen)
                {
                    this.Canvas.moveTo(ToFixedPoint(yClose),right);
                    this.Canvas.lineTo(ToFixedPoint(yClose),x);
                }
                else
                {
                    this.Canvas.moveTo(right,ToFixedPoint(yClose));
                    this.Canvas.lineTo(x,ToFixedPoint(yClose));
                }
                this.Canvas.stroke();
            }

            if(this.Data.DataType==0)
            {
                var infoItem={Xleft:left,XRight:right, YMax:yHigh, XCenter:x, YMin:yLow, DayData:data, Index:j};
                this.DrawInfo(infoItem);
            }
        }

        this.PtMax=ptMax;
        this.PtMin=ptMin;
    }

    this.DrawCloseArea=function()   //收盘价面积图
    {
        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var xPointCount=this.ChartFrame.XPointCount;

        if (isHScreen)
        {
            var border=this.ChartBorder.GetHScreenBorder();
            var xOffset=border.TopEx+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
            var chartright=border.BottomEx;
        }
        else
        {
            var border=this.ChartBorder.GetBorder();
            var xOffset=border.LeftEx+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
            var chartright=border.RightEx;
        }
        

        var bFirstPoint=true;
        var firstPoint=null;
       
        this.Canvas.beginPath();
        this.Canvas.strokeStyle=this.CloseLineColor;
        if (IFrameSplitOperator.IsNumber(this.CloseLineWidth)) this.Canvas.lineWidth=this.CloseLineWidth;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var data=this.Data.Data[i];
            if (data.Open==null || data.High==null || data.Low==null || data.Close==null) continue;

            var left=xOffset;
            var right=xOffset+dataWidth;
            if (right>chartright) break;
            var x=left+(right-left)/2;
            var yClose=this.GetYFromData(data.Close,false);

            if (bFirstPoint)
            {
                if (isHScreen) 
                {
                    this.Canvas.moveTo(yClose,x);
                    firstPoint={ X:yClose, Y:x };
                }
                else 
                {
                    this.Canvas.moveTo(x,yClose);
                    firstPoint={ X:x, Y:yClose };
                }
                bFirstPoint=false;
            }
            else
            {
                if (isHScreen) this.Canvas.lineTo(yClose,x);
                else this.Canvas.lineTo(x,yClose);
            }
        }

        if (bFirstPoint) return;

        this.Canvas.stroke();
        if (isHScreen)
        {
            this.Canvas.lineTo(border.Left,x);
            this.Canvas.lineTo(border.Left,firstPoint.Y);
        }
        else
        {
            this.Canvas.lineTo(x,border.Bottom);
            this.Canvas.lineTo(firstPoint.X,border.Bottom);
        }
        this.Canvas.closePath();
        if (Array.isArray(this.CloseLineAreaColor))
        {
            if (isHScreen)
            {
                let gradient = this.Canvas.createLinearGradient(this.ChartBorder.GetRightEx(),this.ChartBorder.GetTop(), this.ChartBorder.GetLeft(),this.ChartBorder.GetTop());
                gradient.addColorStop(0, this.CloseLineAreaColor[0]);
                gradient.addColorStop(1, this.CloseLineAreaColor[1]);
                this.Canvas.fillStyle=gradient;
            }
            else
            {
                let gradient = this.Canvas.createLinearGradient(firstPoint.X,this.ChartBorder.GetTopEx(), firstPoint.X,this.ChartBorder.GetBottom());
                gradient.addColorStop(0, this.CloseLineAreaColor[0]);
                gradient.addColorStop(1, this.CloseLineAreaColor[1]);
                this.Canvas.fillStyle=gradient;
            }
        }
        else
        {
            this.Canvas.fillStyle=this.CloseLineAreaColor;
        }
        this.Canvas.fill();
    }

    this.DrawCloseLine=function()   //收盘价线
    {
        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var xPointCount=this.ChartFrame.XPointCount;

        if (isHScreen)
        {
            var border=this.ChartBorder.GetHScreenBorder();
            var xOffset=border.TopEx+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
            var chartright=border.BottomEx;
        }
        else
        {
            var border=this.ChartBorder.GetBorder();
            var xOffset=border.LeftEx+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
            var chartright=border.RightEx;
        }
        
        var bFirstPoint=true;
        this.Canvas.beginPath();
        this.Canvas.strokeStyle=this.CloseLineColor;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var data=this.Data.Data[i];
            if (data.Open==null || data.High==null || data.Low==null || data.Close==null) continue;

            var left=xOffset;
            var right=xOffset+dataWidth;
            if (right>chartright) break;
            var x=left+(right-left)/2;
            var yClose=this.GetYFromData(data.Close,false);

            if (bFirstPoint)
            {
                if (isHScreen) this.Canvas.moveTo(yClose,x);
                else this.Canvas.moveTo(x,yClose);
                bFirstPoint=false;
            }
            else
            {
                if (isHScreen) this.Canvas.lineTo(yClose,x);
                else this.Canvas.lineTo(x,yClose);
            }
        }

        if (bFirstPoint==false) this.Canvas.stroke();
    }

    this.DrawKBar=function()        //蜡烛头
    {
        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var border=this.ChartBorder.GetBorder();
        var xOffset=border.LeftEx+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
        var chartright=border.RightEx;
        var xPointCount=this.ChartFrame.XPointCount;

        if (isHScreen) 
        {
            var border=this.ChartBorder.GetHScreenBorder();
            xOffset=border.TopEx+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
            chartright=border.BottomEx;
        }

        var ptMax={X:null,Y:null,Value:null,Align:'left'};
        var ptMin={X:null,Y:null,Value:null,Align:'left'};
        
        var upColor=this.UpColor;
        var downColor=this.DownColor;
        var unchagneColor=this.UnchagneColor; 

        this.ShowRange.Start=this.Data.DataOffset;
        this.ShowRange.End=this.ShowRange.Start;
        this.ShowRange.DataCount=0;
        this.ShowRange.ShowCount=xPointCount;

        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth),++this.ShowRange.DataCount)
        {
            var data=this.Data.Data[i];
            this.ShowRange.End=i;
            if (data.Open==null || data.High==null || data.Low==null || data.Close==null) continue;

            var left=xOffset;
            var right=xOffset+dataWidth;
            if (right>chartright) break;
            var x=left+(right-left)/2;
            var yLow=this.GetYFromData(data.Low, false);
            var yHigh=this.GetYFromData(data.High, false);
            var yOpen=this.GetYFromData(data.Open, false);
            var yClose=this.GetYFromData(data.Close, false);
            var y=yHigh;

            if (ptMax.Value==null || ptMax.Value<data.High)     //求最大值
            {
                ptMax.X=x;
                ptMax.Y=yHigh;
                ptMax.Value=data.High;
                ptMax.Align=j<xPointCount/2?'left':'right';
            }

            if (ptMin.Value==null || ptMin.Value>data.Low)      //求最小值
            {
                ptMin.X=x;
                ptMin.Y=yLow;
                ptMin.Value=data.Low;
                ptMin.Align=j<xPointCount/2?'left':'right';
            }

            if (this.ColorData) ///五彩K线颜色设置
            {
                if (i<this.ColorData.length)
                    upColor=downColor=unchagneColor=(this.ColorData[i]>0?this.UpColor:this.DownColor);
                else
                    upColor=downColor=unchagneColor=this.DownColor;
            }

            if (data.Open<data.Close)       //阳线
            {
                if (dataWidth>=4)
                {
                    this.Canvas.strokeStyle=upColor;
                    if (data.High>data.Close)   //上影线
                    {
                        this.Canvas.beginPath();
                        if (isHScreen)
                        {
                            this.Canvas.moveTo(ToFixedPoint(y),ToFixedPoint(x));
                            this.Canvas.lineTo(ToFixedPoint(this.DrawType==3?Math.max(yClose,yOpen):yClose),ToFixedPoint(x));
                        }
                        else
                        {
                            this.Canvas.moveTo(ToFixedPoint(x),ToFixedPoint(y));
                            this.Canvas.lineTo(ToFixedPoint(x),ToFixedPoint(this.DrawType==3?Math.min(yClose,yOpen):yClose));
                        }
                        this.Canvas.stroke();
                        y=yClose;
                    }
                    else
                    {
                        y=yClose;
                    }

                    this.Canvas.fillStyle=upColor;
                    if (isHScreen)
                    {
                        if (Math.abs(yOpen-y)<1)  
                        {
                            this.Canvas.fillRect(ToFixedRect(y),ToFixedRect(left),1,ToFixedRect(dataWidth));    //高度小于1,统一使用高度1
                        }
                        else 
                        {
                            if (this.DrawType==3) //空心柱
                            {
                                this.Canvas.beginPath();
                                this.Canvas.rect(ToFixedPoint(y),ToFixedPoint(left),ToFixedRect(yOpen-y),ToFixedRect(dataWidth));
                                this.Canvas.stroke();
                            }
                            else
                            {
                                this.Canvas.fillRect(ToFixedRect(y),ToFixedRect(left),ToFixedRect(yOpen-y),ToFixedRect(dataWidth));
                            }
                        }
                    }
                    else
                    {
                        if (Math.abs(yOpen-y)<1)  
                        {
                            this.Canvas.fillRect(ToFixedRect(left),ToFixedRect(y),ToFixedRect(dataWidth),1);    //高度小于1,统一使用高度1
                        }
                        else 
                        {
                            if (this.DrawType==3) //空心柱
                            {
                                this.Canvas.beginPath();
                                this.Canvas.rect(ToFixedPoint(left),ToFixedPoint(y),ToFixedRect(dataWidth),ToFixedRect(yOpen-y));
                                this.Canvas.stroke();
                            }
                            else
                            {
                                this.Canvas.fillRect(ToFixedRect(left),ToFixedRect(Math.min(y,yOpen)),ToFixedRect(dataWidth),ToFixedRect(Math.abs(yOpen-y)));
                            }
                        }
                    }

                    if (data.Open>data.Low) //下影线
                    {
                        this.Canvas.beginPath();
                        if (isHScreen)
                        {
                            this.Canvas.moveTo(ToFixedPoint(this.DrawType==3?Math.min(yClose,yOpen):y),ToFixedPoint(x));
                            this.Canvas.lineTo(ToFixedPoint(yLow),ToFixedPoint(x));
                        }
                        else
                        {
                            this.Canvas.moveTo(ToFixedPoint(x),ToFixedPoint(this.DrawType==3?Math.max(yClose,yOpen):y));
                            this.Canvas.lineTo(ToFixedPoint(x),ToFixedPoint(yLow));
                        }
                        this.Canvas.stroke();
                    }
                }
                else
                {
                    this.Canvas.beginPath();
                    if (isHScreen)
                    {
                        this.Canvas.moveTo(yHigh,ToFixedPoint(x));
                        this.Canvas.lineTo(yLow,ToFixedPoint(x));
                    }
                    else
                    {
                        this.Canvas.moveTo(ToFixedPoint(x),yHigh);
                        this.Canvas.lineTo(ToFixedPoint(x),yLow);
                    }
                    this.Canvas.strokeStyle=upColor;
                    this.Canvas.stroke();
                }
            }
            else if (data.Open>data.Close)  //阴线
            {
                if (dataWidth>=4)
                {
                    this.Canvas.strokeStyle=downColor;
                    if (data.High>data.Close)   //上影线
                    {
                        this.Canvas.beginPath();
                        if (isHScreen)
                        {
                            this.Canvas.moveTo(ToFixedPoint(y),ToFixedPoint(x));
                            this.Canvas.lineTo(ToFixedPoint(yOpen),ToFixedPoint(x));
                        }
                        else
                        {
                            this.Canvas.moveTo(ToFixedPoint(x),ToFixedPoint(y));
                            this.Canvas.lineTo(ToFixedPoint(x),ToFixedPoint(yOpen));
                        }
                        this.Canvas.stroke();
                        y=yOpen;
                    }
                    else
                    {
                        y=yOpen
                    }

                    this.Canvas.fillStyle=downColor;
                    if (isHScreen)
                    {
                        if (Math.abs(yClose-y)<1) this.Canvas.fillRect(ToFixedRect(y),ToFixedRect(left),1,ToFixedRect(dataWidth));    //高度小于1,统一使用高度1
                        else this.Canvas.fillRect(ToFixedRect(y),ToFixedRect(left),ToFixedRect(yClose-y),ToFixedRect(dataWidth));
                    }
                    else
                    {
                        if (Math.abs(yClose-y)<1) this.Canvas.fillRect(ToFixedRect(left),ToFixedRect(y),ToFixedRect(dataWidth),1);    //高度小于1,统一使用高度1
                        else this.Canvas.fillRect(ToFixedRect(left),ToFixedRect(Math.min(y,yClose)),ToFixedRect(dataWidth),ToFixedRect(Math.abs(yClose-y)));
                    }

                    if (data.Open>data.Low) //下影线
                    {
                        this.Canvas.beginPath();
                        if (isHScreen)
                        {
                            this.Canvas.moveTo(ToFixedPoint(y),ToFixedPoint(x));
                            this.Canvas.lineTo(ToFixedPoint(yLow),ToFixedPoint(x));
                        }
                        else
                        {
                            this.Canvas.moveTo(ToFixedPoint(x),ToFixedPoint(y));
                            this.Canvas.lineTo(ToFixedPoint(x),ToFixedPoint(yLow));
                        }
                        this.Canvas.stroke();
                    }
                }
                else
                {
                    this.Canvas.beginPath();
                    if (isHScreen)
                    {
                        this.Canvas.moveTo(yHigh,ToFixedPoint(x));
                        this.Canvas.lineTo(yLow,ToFixedPoint(x));
                    }
                    else
                    {
                        this.Canvas.moveTo(ToFixedPoint(x),yHigh);
                        this.Canvas.lineTo(ToFixedPoint(x),yLow);
                    }
                    this.Canvas.strokeStyle=downColor;
                    this.Canvas.stroke();
                }
            }
            else // 平线
            {
                if (dataWidth>=4)
                {
                    this.Canvas.strokeStyle=unchagneColor;
                    this.Canvas.beginPath();
                    if (data.High>data.Close)   //上影线
                    {
                        if (isHScreen)
                        {
                            this.Canvas.moveTo(y,ToFixedPoint(x));
                            this.Canvas.lineTo(yOpen,ToFixedPoint(x));
                        }
                        else
                        {
                            this.Canvas.moveTo(ToFixedPoint(x),y);
                            this.Canvas.lineTo(ToFixedPoint(x),yOpen);
                        }
                        y=yOpen;
                    }
                    else
                    {
                        y=yOpen;
                    }

                    if (isHScreen)
                    {
                        this.Canvas.moveTo(ToFixedPoint(y),ToFixedPoint(left));
                        this.Canvas.lineTo(ToFixedPoint(y),ToFixedPoint(right));
                    }
                    else
                    {
                        this.Canvas.moveTo(ToFixedPoint(left),ToFixedPoint(y));
                        this.Canvas.lineTo(ToFixedPoint(right),ToFixedPoint(y));
                    }

                    if (data.Open>data.Low) //下影线
                    {
                        if (isHScreen)
                        {
                            this.Canvas.moveTo(ToFixedPoint(y),ToFixedPoint(x));
                            this.Canvas.lineTo(ToFixedPoint(yLow),ToFixedPoint(x));
                        }
                        else
                        {
                            this.Canvas.moveTo(ToFixedPoint(x),ToFixedPoint(y));
                            this.Canvas.lineTo(ToFixedPoint(x),ToFixedPoint(yLow));
                        }
                    }

                    this.Canvas.stroke();
                }
                else
                {
                    this.Canvas.beginPath();
                    if (isHScreen)
                    {
                        this.Canvas.moveTo(yHigh,ToFixedPoint(x));
                        this.Canvas.lineTo(yLow,ToFixedPoint(x));
                    }
                    else
                    {
                        this.Canvas.moveTo(ToFixedPoint(x),yHigh);
                        this.Canvas.lineTo(ToFixedPoint(x),yLow);
                    }
                    this.Canvas.strokeStyle=unchagneColor;
                    this.Canvas.stroke();
                }
            }
            
            if (this.IsShowKTooltip && !isHScreen)    //添加tooltip区域
            {
                var yTop=Math.min(yOpen,yClose);
                var yBottom=Math.max(yOpen,yClose);
                if (Math.abs(yOpen-yClose)<5)   //高度太小了, 上下各+5px
                {
                    yTop=Math.min(yHigh,yTop-5);
                    yBottom=Math.max(yLow,yBottom+5);
                }
                var rect=new Rect(left,yTop,dataWidth,yBottom-yTop);
                //this.Canvas.fillStyle="rgb(0,0,100)";
                //this.Canvas.fillRect(rect.X,rect.Y,rect.Width,rect.Height);
                this.TooltipRect.push([i,rect]);    //[0]数据索引 [1]数据区域
            }

            if(this.Data.DataType==0)
            {
                var infoItem={Xleft:left,XRight:right, XCenter:x, YMax:yHigh, YMin:yLow, DayData:data, Index:j};
                this.DrawInfo(infoItem);
            }
        }

        this.PtMax=ptMax;
        this.PtMin=ptMin;
    }

    this.DrawTrade=function()       //交易系统
    {
        if (!this.TradeData) return;

        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var xOffset=this.ChartBorder.GetLeft()+distanceWidth/2.0+2.0;
        var chartright=this.ChartBorder.GetRight();
        var xPointCount=this.ChartFrame.XPointCount;

        if (isHScreen) 
        {
            xOffset=this.ChartBorder.GetTop()+distanceWidth/2.0+2.0;
            chartright=this.ChartBorder.GetBottom();
        }

        var sellData=this.TradeData.Sell;
        var buyData=this.TradeData.Buy;
        var arrowWidth=dataWidth;
        if (arrowWidth>10) arrowWidth=10;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var data=this.Data.Data[i];
            if (data.Open==null || data.High==null || data.Low==null || data.Close==null) continue;

            var buy=false,sell=false;
            if (sellData && i<sellData.length) sell=sellData[i]>0;
            if (buyData && i<buyData.length) buy=buyData[i]>0;
            if (!sell && !buy) continue;

            var left=xOffset;
            var right=xOffset+dataWidth;
            if (right>chartright) break;
            var x=left+(right-left)/2;
            var yLow=this.GetYFromData(data.Low,false);
            var yHigh=this.GetYFromData(data.High,false);
            var yOpen=this.GetYFromData(data.Open,false);
            var yClose=this.GetYFromData(data.Close,false);
            var y=yHigh;

            if (buy)
            {
                this.Canvas.fillStyle=this.UpColor;
                this.Canvas.strokeStyle=this.UnchagneColor;
                this.Canvas.beginPath();
                if (isHScreen)
                {
                    this.Canvas.moveTo(yLow-1,x);
                    this.Canvas.lineTo(yLow-arrowWidth-1,x-arrowWidth/2);
                    this.Canvas.lineTo(yLow-arrowWidth-1,x+arrowWidth/2);
                }
                else
                {
                    this.Canvas.moveTo(x,yLow+1);
                    this.Canvas.lineTo(x-arrowWidth/2,yLow+arrowWidth+1);
                    this.Canvas.lineTo(x+arrowWidth/2,yLow+arrowWidth+1);
                }
                this.Canvas.closePath();
                this.Canvas.fill();
                this.Canvas.stroke();
            }

            if (sell)
            {
                this.Canvas.fillStyle=this.DownColor;
                this.Canvas.strokeStyle=this.UnchagneColor;
                this.Canvas.beginPath();
                if (isHScreen)
                {
                    this.Canvas.moveTo(yHigh+1,x);
                    this.Canvas.lineTo(yHigh+arrowWidth+1,x-arrowWidth/2);
                    this.Canvas.lineTo(yHigh+arrowWidth+1,x+arrowWidth/2);
                }
                else
                {
                    this.Canvas.moveTo(x,yHigh-1);
                    this.Canvas.lineTo(x-arrowWidth/2,yHigh-arrowWidth-1);
                    this.Canvas.lineTo(x+arrowWidth/2,yHigh-arrowWidth-1);
                }
                this.Canvas.closePath();
                this.Canvas.fill();
                this.Canvas.stroke();
            }
        }
    }

    this.DrawTick=function()        //分笔图
    {
        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var xOffset=this.ChartBorder.GetLeft()+distanceWidth/2.0+2.0;
        if (isHScreen) xOffset=this.ChartBorder.GetTop()+distanceWidth/2.0+2.0;
        var chartright=this.ChartBorder.GetRight();
        if (isHScreen) chartright=this.ChartBorder.GetBottom();
        var xPointCount=this.ChartFrame.XPointCount;

        var fontSize=parseInt(dataWidth);
        if (fontSize<=1) fontSize=2;
        else if (fontSize>=18) fontSize=18;
        var bFirstPoint=true;
        this.Canvas.beginPath();
        this.Canvas.font=fontSize*GetDevicePixelRatio()+'px '+this.TickFontName;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var data=this.Data.Data[i];
            if (data.Open==null || data.High==null || data.Low==null || data.Close==null) continue;

            var left=xOffset;
            var right=xOffset+dataWidth;
            if (right>chartright) break;
            var x=left+(right-left)/2;
            var yClose=this.ChartFrame.GetYFromData(data.Close);

            if (data.Flag===0) this.Canvas.fillStyle=this.UpColor;
            else if (data.Flag==1) this.Canvas.fillStyle=this.DownColor;
            else this.Canvas.fillStyle=this.UnchagneColor;

            this.Canvas.textAlign='center'
            this.Canvas.textBaseline='middle';
            if (isHScreen)  this.Canvas.fillText(this.TickSymbol,yClose,x);
            else this.Canvas.fillText(this.TickSymbol,x,yClose);
        }
    }

    this.Draw=function()
    {
        this.TooltipRect=[];
        this.InfoTooltipRect=[];
        this.TradeIconTooltipRect=[];
        this.PtMax={X:null,Y:null,Value:null,Align:'left'}; //清空最大
        this.PtMin={X:null,Y:null,Value:null,Align:'left'}; //清空最小

        this.ChartFrame.ChartKLine={Max:null, Min:null };   //保存K线上 显示最大最小值坐标

        if (!this.IsShow) return;

        if (ChartData.IsTickPeriod(this.Period))    //分笔图
        {
            this.Canvas.save();
            this.ClipClient(this.ChartFrame.IsHScreen);

            if (this.DrawType==1)
                this.DrawCloseLine();
            else
                this.DrawTick();

            this.Canvas.restore();
            return;
        }

        this.Canvas.save();
        this.ClipClient(this.ChartFrame.IsHScreen);

        if (this.DrawType==1) 
        {
            this.DrawCloseLine();
            this.Canvas.restore();
            return;
        }
        else if (this.DrawType==2)
        {
            this.DrawAKLine();
        }
        else if (this.DrawType==4)
        {
            this.DrawCloseArea();
        }
        else
        {
            this.DrawKBar();
        }

        if (this.TradeIcon) this.DrawTradeIcon()
        else this.DrawTrade();
        this.Canvas.restore();

        if (this.IsShowMaxMinPrice)     //标注最大值最小值
        {
            if (this.ChartFrame.IsHScreen===true) this.HScreenDrawMaxMinPrice(this.PtMax,this.PtMin);
            else this.DrawMaxMinPrice(this.PtMax,this.PtMin);
        }
    }

    this.DrawMaxMinPrice=function(ptMax,ptMin)
    {
        if (ptMax.X==null || ptMax.Y==null || ptMax.Value==null) return;
        if (ptMin.X==null || ptMin.Y==null || ptMin.Value==null) return;

        var defaultfloatPrecision=GetfloatPrecision(this.Symbol);
        this.Canvas.font=this.TextFont;
        this.Canvas.fillStyle=this.TextColor;
        var top=this.ChartBorder.GetTopEx();
        var bottom=this.ChartBorder.GetBottomEx();

        var ptTop=ptMax;
        if (this.ChartFrame.CoordinateType==1)  //反转坐标
        {
            if (ptMax.Y<ptMin.Y) ptTop=ptMin;
            this.Canvas.textBaseline='top';
        }
        else
        {
            if (ptMax.Y>ptMin.Y) ptTop=ptMin;
            this.Canvas.textBaseline='bottom';
        }
        
        this.Canvas.textAlign=ptTop.Align;
        var left=ptTop.Align=='left'?ptTop.X:ptTop.X;
        var text=ptTop.Value.toFixed(defaultfloatPrecision);
        if (ptTop.Align=='left') text='←'+text;
        else text=text+'→';
        if (ptTop.Y>(top-2))
        {
            this.Canvas.fillText(text,left,ptTop.Y);
            this.ChartFrame.ChartKLine.Max={X:left, Y:ptTop.Y, Text: { BaseLine:'bottom'}};
        }
        
        var ptBottom=ptMin;
        if (this.ChartFrame.CoordinateType==1)
        {
            if (ptMin.Y>ptMax.Y) ptBottom=ptMax;
            this.Canvas.textBaseline='bottom';
        }
        else
        {
            if (ptMax.Y>ptMin.Y) ptTop=ptMin;
            this.Canvas.textBaseline='top';
        }
        this.Canvas.textAlign=ptBottom.Align;
        
        var left=ptBottom.Align=='left'?ptBottom.X:ptBottom.X;
        var text=ptMin.Value.toFixed(defaultfloatPrecision);
        if (ptBottom.Align=='left') text='←'+text;
        else  text=text+'→';
        if (ptBottom.Y<(bottom+1))
        {
            this.Canvas.fillText(text,left,ptBottom.Y);
            this.ChartFrame.ChartKLine.Min={X:left, Y:ptBottom.Y, Text:{ BaseLine:'top'}};
        }
    }

    this.HScreenDrawMaxMinPrice=function(ptMax,ptMin)   //横屏模式下显示最大最小值
    {
        if (ptMax.X==null || ptMax.Y==null || ptMax.Value==null) return;
        if (ptMin.X==null || ptMin.Y==null || ptMin.Value==null) return;

        var defaultfloatPrecision=GetfloatPrecision(this.Symbol);
        var xText=ptMax.Y;
        var yText=ptMax.X;
        this.Canvas.save(); 
        this.Canvas.translate(xText, yText);
        this.Canvas.rotate(90 * Math.PI / 180);

        this.Canvas.font=this.TextFont;
        this.Canvas.fillStyle=this.TextColor;
        this.Canvas.textAlign=ptMax.Align;
        this.Canvas.textBaseline='bottom';
        var text=ptMax.Value.toFixed(defaultfloatPrecision);
        if (ptMax.Align=='left') text='←'+text;
        else  text=text+'→';
        this.Canvas.fillText(text,0,0);
        this.Canvas.restore();

        
        var xText=ptMin.Y;
        var yText=ptMin.X;
        this.Canvas.save(); 
        this.Canvas.translate(xText, yText);
        this.Canvas.rotate(90 * Math.PI / 180);

        this.Canvas.font=this.TextFont;
        this.Canvas.fillStyle=this.TextColor;
        this.Canvas.textAlign=ptMin.Align;
        this.Canvas.textBaseline='top';
        var text=ptMin.Value.toFixed(defaultfloatPrecision);
        if (ptMin.Align=='left') text='←'+text;
        else text=text+'→';
        this.Canvas.fillText(text,0,0);
        this.Canvas.restore();
    }

    //画某一天的信息地雷
    this.DrawInfo=function(item)
    {
        if (!this.InfoData || this.InfoData.length<=0) return;

        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var bottom=this.ChartBorder.GetBottom();
        var top=this.ChartBorder.GetTop();

        var infoData=this.InfoData.get(item.DayData.Date.toString());
        if (!infoData || infoData.Data.length<=0) return;

        var pixelTatio = GetDevicePixelRatio(); //获取设备的分辨率
        var iconSize=dataWidth+distanceWidth;
        var minIconSize=18*pixelTatio;
        var bShowNum=true;
        if (iconSize<=15) bShowNum=false;
        if (iconSize<minIconSize) iconSize=minIconSize;
        
        var text='', title='';
        var mapImage=new Map();
        var iconTop=item.YMax+1*pixelTatio;
        var iconBottom=item.YMin+1*pixelTatio+iconSize;
        var drawTop=true;
        var yOffset=0;
        for(var i in infoData.Data)
        {
            var infoItem=infoData.Data[i];
            var imageInfo=mapImage.get(infoItem.InfoType);
            if (!imageInfo)
            {
                var icon=JSKLineInfoMap.GetIconFont(infoItem.InfoType);
                this.Canvas.fillStyle=icon.Color;
                this.Canvas.font=iconSize+'px '+icon.Family;

                if (isHScreen)
                {
                    this.Canvas.textBaseline="middle";
                    this.Canvas.textAlign="left";
                    this.Canvas.fillText(icon.HScreenText,iconTop,item.XCenter,iconSize);

                    var iconRect=new Rect(item.XCenter-iconSize/2,iconTop-iconSize,iconSize,iconSize);
                    var infoCache={ Data:new Array(infoItem), Rect:iconRect, Type:infoItem.InfoType, TextRect:{X:iconTop, Y:item.XCenter} };
                    mapImage.set(infoItem.InfoType,infoCache);

                    iconTop+=iconSize;
                }
                else
                {
                    this.Canvas.textBaseline="bottom";
                    this.Canvas.textAlign="center";
                    if (this.InfoPosition===1) 
                    {
                        var yBottom=bottom+yOffset;
                        this.Canvas.fillText(icon.Text,item.XCenter,yBottom,iconSize);
                        var iconRect=new Rect(item.XCenter-iconSize/2,yBottom-iconSize,iconSize,iconSize);
                        var infoCache={ Data:new Array(infoItem), Rect:iconRect, Type:infoItem.InfoType, TextRect:{X:item.XCenter, Y:yBottom} };
                        mapImage.set(infoItem.InfoType,infoCache);
                        yOffset-=iconSize;
                    }
                    else
                    {
                        if (drawTop)
                        {
                            this.Canvas.fillText(icon.Text,item.XCenter,iconTop,iconSize);
                            var iconRect=new Rect(item.XCenter-iconSize/2,iconTop-iconSize,iconSize,iconSize);
                            var infoCache={ Data:new Array(infoItem), Rect:iconRect, Type:infoItem.InfoType, TextRect:{X:item.XCenter, Y:iconTop} };
                            mapImage.set(infoItem.InfoType,infoCache);
                            iconTop-=iconSize;
                            if (iconTop-iconSize<top ) drawTop=false;
                        }
                        else    //上面显示不下,就显示在下面
                        {
                            this.Canvas.fillText(icon.Text,item.XCenter,iconBottom,iconSize);
                            var iconRect=new Rect(item.XCenter-iconSize/2,iconBottom-iconSize,iconSize,iconSize);
                            var infoCache={ Data:new Array(infoItem), Rect:iconRect, Type:infoItem.InfoType, TextRect:{X:item.XCenter, Y:iconBottom} };
                            mapImage.set(infoItem.InfoType,infoCache);
                            iconBottom+=iconSize;
                        }
                    }
                }
            }
            else
            {
                imageInfo.Data.push(infoItem);
            }
        }

        var numText;
        if (g_JSChartResource.KLine.NumIcon) 
        {
            if (isHScreen) numText=g_JSChartResource.KLine.NumIcon.HScreenText;
            else numText=g_JSChartResource.KLine.NumIcon.Text;
        }
        for(var item of mapImage)
        {
            var value=item[1];
            if (value.Data.length>=2 && numText && bShowNum) //太小了 就不显示了
            {
                var iconID=value.Data.length;
                if (iconID>=numText.length) iconID=0;
                this.Canvas.fillStyle=g_JSChartResource.KLine.NumIcon.Color;
                var text=numText[iconID];
                this.Canvas.fillText(text,value.TextRect.X,value.TextRect.Y,iconSize);
            }

            if (!isHScreen) this.InfoTooltipRect.push(value);   //横屏没有tooltip
        }
    }

    //画交易图标
    this.DrawTradeIcon=function()
    {
        if (!this.TradeData) return;

        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var xOffset=this.ChartBorder.GetLeft()+distanceWidth/2.0+2.0;
        var chartright=this.ChartBorder.GetRight();
        var xPointCount=this.ChartFrame.XPointCount;

        if (isHScreen) 
        {
            xOffset=this.ChartBorder.GetTop()+distanceWidth/2.0+2.0;
            chartright=this.ChartBorder.GetBottom();
        }

        var sellData=this.TradeData.Sell;
        var buyData=this.TradeData.Buy;
        var iconSize=dataWidth+distanceWidth;
        var pixelTatio = GetDevicePixelRatio(); //获取设备的分辨率
        var iconSizeMax=24*pixelTatio,iconSizeMin=12*pixelTatio;
        if (iconSize<iconSizeMin) iconSize=iconSizeMin;
        else if (iconSize>iconSizeMax) iconSize=iconSizeMax;
        this.Canvas.font=iconSize+'px '+this.TradeIcon.Family;

        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var data=this.Data.Data[i];
            if (data.Open==null || data.High==null || data.Low==null || data.Close==null) continue;

            var buy=false,sell=false;
            if (sellData && i<sellData.length) sell=sellData[i]>0;
            if (buyData && i<buyData.length) buy=buyData[i]>0;
            if (!sell && !buy) continue;

            var left=xOffset;
            var right=xOffset+dataWidth;
            if (right>chartright) break;
            var x=left+(right-left)/2;
            var yLow=this.GetYFromData(data.Low,false);
            var yHigh=this.GetYFromData(data.High,false);
            var yOpen=this.GetYFromData(data.Open,false);
            var yClose=this.GetYFromData(data.Close,false);
            var y=yHigh;

            if (buy)
            {
                this.Canvas.fillStyle=this.TradeIcon.Buy.Color;
                
                if (isHScreen)
                {
                    this.Canvas.textAlign='right';
                    this.Canvas.textBaseline='middle';
                    this.Canvas.fillText(this.TradeIcon.Buy.HScreenText,yLow,x);
                }
                else
                {
                    this.Canvas.textAlign='center';
                    this.Canvas.textBaseline='top';
                    this.Canvas.fillText(this.TradeIcon.Buy.Text,x,yLow);

                    var iconRect=new Rect(x-iconSize/2,yLow,iconSize,iconSize);
                    var iconData={ Data:{ Type:1, KData:data, Name:this.TradeData.Name, Param:this.TradeData.Param }, Rect:iconRect, TextRect:{X:x, Y:yLow} };
                    this.TradeIconTooltipRect.push(iconData); 
                }
            }

            if (sell)
            {
                this.Canvas.fillStyle=this.TradeIcon.Sell.Color;
                if (isHScreen)
                {
                    this.Canvas.textAlign='left';
                    this.Canvas.textBaseline='middle';
                    this.Canvas.fillText(this.TradeIcon.Sell.HScreenText,yHigh,x);
                }
                else
                {
                    this.Canvas.textAlign='center';
                    this.Canvas.textBaseline='bottom';
                    this.Canvas.fillText(this.TradeIcon.Sell.Text,x,yHigh);

                    var iconRect=new Rect(x-iconSize/2,yHigh-iconSize,iconSize,iconSize);
                    var iconData={ Data:{ Type:2, KData:data, Name:this.TradeData.Name,Param:this.TradeData.Param }, Rect:iconRect, TextRect:{X:x, Y:yHigh} };
                    this.TradeIconTooltipRect.push(iconData); 
                }
            }
        }
    }

    this.GetTooltipData=function(x,y,tooltip)
    {
        for(var i in this.TradeIconTooltipRect)
        {
            var item=this.TradeIconTooltipRect[i];
            if (!item.Rect) continue;
            var rect=item.Rect;
            this.Canvas.beginPath();
            this.Canvas.rect(rect.X,rect.Y,rect.Width,rect.Height);
            if (this.Canvas.isPointInPath(x,y))
            {
                JSConsole.Chart.Log('[ChartKLine::GetTooltipData] trade icon ', item);
                tooltip.Data=item;
                tooltip.ChartPaint=this;
                tooltip.Type=2; //指标
                return true;
            }
        }

        for(var i in this.InfoTooltipRect)
        {
            var item=this.InfoTooltipRect[i];
            if (!item.Rect) continue;
            var rect=item.Rect;
            this.Canvas.beginPath();
            this.Canvas.rect(rect.X,rect.Y,rect.Width,rect.Height);
            if (this.Canvas.isPointInPath(x,y))
            {
                //JSConsole.Chart.Log('[ChartKLine::GetTooltipData] info ', item);
                tooltip.Data=item;
                tooltip.ChartPaint=this;
                tooltip.Type=1; //信息地雷
                return true;
            }
        }

        for(var i in this.TooltipRect)
        {
            var rect=this.TooltipRect[i][1];
            this.Canvas.beginPath();
            this.Canvas.rect(rect.X,rect.Y,rect.Width,rect.Height);
            if (this.Canvas.isPointInPath(x,y))
            {
                var index=this.TooltipRect[i][0];
                tooltip.Data=this.Data.Data[index];
                tooltip.ChartPaint=this;
                tooltip.Type=0; //K线信息
                return true;
            }
        }

        return false;
    }

    //计算当天显示数据的最大最小值
    this.GetMaxMin=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var range={};
        range.Max=null;
        range.Min=null;
        if (this.DrawType==1 || this.DrawType==4 )    // 1=收盘价线 4=收盘价面积图
        {
            for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
            {
                var data=this.Data.Data[i];
                if (!IFrameSplitOperator.IsNumber(data.Close)) continue;

                if (range.Max==null) range.Max=data.Close;
                if (range.Min==null) range.Min=data.Close;

                if (range.Max<data.Close) range.Max=data.Close;
                if (range.Min>data.Close) range.Min=data.Close;
            }
        }
        else
        {
            for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
            {
                var data=this.Data.Data[i];
                if (data.Open==null || data.High==null || data.Low==null || data.Close==null) continue;

                
                if (range.Max==null) range.Max=data.High;
                if (range.Min==null) range.Min=data.Low;

                if (range.Max<data.High) range.Max=data.High;
                if (range.Min>data.Low) range.Min=data.Low;
            }
        }

        return range;
    }

    //获取所有的价格
    this.GetAllPrice=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var setPrice=new Set();
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var data=this.Data.Data[i];
            if (data.Open==null || data.High==null || data.Low==null || data.Close==null) continue;

            var value=data.Close;
            setPrice.add(value);
        }

        var aryPrice=[];
        for(var item of setPrice) 
        {
            aryPrice.push(item);
        }

        aryPrice.sort(function(a,b) { return a-b; });   //排序 升序

        return aryPrice;
    }
}

function ChartColorKline()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='ChartColorKline';    //类名
    this.Symbol;        //股票代码
    this.Color='rgb(0,255,44)';
    this.DrawType=0;    //0=实心K线柱子  3=空心K线柱子 
    this.KLineColor;    //Map key=K线索引 value=设置

    this.Draw=function()
    {
        if (!this.IsShow) return;
        if (!this.KLineColor) return;
        this.DrawBar();
    }

    this.DrawUpBarItem=function(data, xOffset, dataWidth, option)
    {
        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var left=xOffset;
        var right=xOffset+dataWidth;
        var x=left+(right-left)/2;

        var yLow=this.ChartFrame.GetYFromData(data.Low);
        var yHigh=this.ChartFrame.GetYFromData(data.High);
        var yOpen=this.ChartFrame.GetYFromData(data.Open);
        var yClose=this.ChartFrame.GetYFromData(data.Close);
        var y=yHigh;

        if (dataWidth>=4)
        {
            if (data.High>data.Close)   //上影线
            {
                this.Canvas.beginPath();
                if (isHScreen)
                {
                    this.Canvas.moveTo(ToFixedPoint(y),ToFixedPoint(x));
                    this.Canvas.lineTo(ToFixedPoint(this.DrawType==3?Math.max(yClose,yOpen):yClose),ToFixedPoint(x));
                }
                else
                {
                    this.Canvas.moveTo(ToFixedPoint(x),ToFixedPoint(y));
                    this.Canvas.lineTo(ToFixedPoint(x),ToFixedPoint(this.DrawType==3?Math.min(yClose,yOpen):yClose));
                }
                this.Canvas.stroke();
                y=yClose;
            }
            else
            {
                y=yClose;
            }

            if (isHScreen)
            {
                if (Math.abs(yOpen-y)<1)  
                {
                    this.Canvas.fillRect(ToFixedRect(y),ToFixedRect(left),1,ToFixedRect(dataWidth));    //高度小于1,统一使用高度1
                }
                else 
                {
                    if (this.DrawType==3) //空心柱
                    {
                        this.Canvas.beginPath();
                        this.Canvas.rect(ToFixedPoint(y),ToFixedPoint(left),ToFixedRect(yOpen-y),ToFixedRect(dataWidth));
                        this.Canvas.stroke();
                    }
                    else
                    {
                        this.Canvas.fillRect(ToFixedRect(y),ToFixedRect(left),ToFixedRect(yOpen-y),ToFixedRect(dataWidth));
                    }
                }
            }
            else
            {
                if (Math.abs(yOpen-y)<1)  
                {
                    this.Canvas.fillRect(ToFixedRect(left),ToFixedRect(y),ToFixedRect(dataWidth),1);    //高度小于1,统一使用高度1
                }
                else 
                {
                    if (this.DrawType==3) //空心柱
                    {
                        this.Canvas.beginPath();
                        this.Canvas.rect(ToFixedPoint(left),ToFixedPoint(y),ToFixedRect(dataWidth),ToFixedRect(yOpen-y));
                        this.Canvas.stroke();
                    }
                    else
                    {
                        this.Canvas.fillRect(ToFixedRect(left),ToFixedRect(Math.min(y,yOpen)),ToFixedRect(dataWidth),ToFixedRect(Math.abs(yOpen-y)));
                    }
                }
            }

            if (data.Open>data.Low) //下影线
            {
                this.Canvas.beginPath();
                if (isHScreen)
                {
                    this.Canvas.moveTo(ToFixedPoint(this.DrawType==3?Math.min(yClose,yOpen):y),ToFixedPoint(x));
                    this.Canvas.lineTo(ToFixedPoint(yLow),ToFixedPoint(x));
                }
                else
                {
                    this.Canvas.moveTo(ToFixedPoint(x),ToFixedPoint(this.DrawType==3?Math.max(yClose,yOpen):y));
                    this.Canvas.lineTo(ToFixedPoint(x),ToFixedPoint(yLow));
                }
                this.Canvas.stroke();
            }
        }
        else
        {
            this.Canvas.beginPath();
            if (isHScreen)
            {
                this.Canvas.moveTo(yHigh,ToFixedPoint(x));
                this.Canvas.lineTo(yLow,ToFixedPoint(x));
            }
            else
            {
                this.Canvas.moveTo(ToFixedPoint(x),yHigh);
                this.Canvas.lineTo(ToFixedPoint(x),yLow);
            }
            this.Canvas.stroke();
        }
    }

    this.DrawDownBarItem=function(data, xOffset, dataWidth, option)
    {
        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var left=xOffset;
        var right=xOffset+dataWidth;
        var x=left+(right-left)/2;

        var yLow=this.ChartFrame.GetYFromData(data.Low);
        var yHigh=this.ChartFrame.GetYFromData(data.High);
        var yOpen=this.ChartFrame.GetYFromData(data.Open);
        var yClose=this.ChartFrame.GetYFromData(data.Close);
        var y=yHigh;

        if (dataWidth>=4)
        {
            if (data.High>data.Close)   //上影线
            {
                this.Canvas.beginPath();
                if (isHScreen)
                {
                    this.Canvas.moveTo(ToFixedPoint(y),ToFixedPoint(x));
                    this.Canvas.lineTo(ToFixedPoint(yOpen),ToFixedPoint(x));
                }
                else
                {
                    this.Canvas.moveTo(ToFixedPoint(x),ToFixedPoint(y));
                    this.Canvas.lineTo(ToFixedPoint(x),ToFixedPoint(yOpen));
                }
                this.Canvas.stroke();
                y=yOpen;
            }
            else
            {
                y=yOpen
            }

            if (isHScreen)
            {
                if (Math.abs(yClose-y)<1) this.Canvas.fillRect(ToFixedRect(y),ToFixedRect(left),1,ToFixedRect(dataWidth));    //高度小于1,统一使用高度1
                else this.Canvas.fillRect(ToFixedRect(y),ToFixedRect(left),ToFixedRect(yClose-y),ToFixedRect(dataWidth));
            }
            else
            {
                if (Math.abs(yClose-y)<1) this.Canvas.fillRect(ToFixedRect(left),ToFixedRect(y),ToFixedRect(dataWidth),1);    //高度小于1,统一使用高度1
                else this.Canvas.fillRect(ToFixedRect(left),ToFixedRect(Math.min(y,yClose)),ToFixedRect(dataWidth),ToFixedRect(Math.abs(yClose-y)));
            }

            if (data.Open>data.Low) //下影线
            {
                this.Canvas.beginPath();
                if (isHScreen)
                {
                    this.Canvas.moveTo(ToFixedPoint(y),ToFixedPoint(x));
                    this.Canvas.lineTo(ToFixedPoint(yLow),ToFixedPoint(x));
                }
                else
                {
                    this.Canvas.moveTo(ToFixedPoint(x),ToFixedPoint(y));
                    this.Canvas.lineTo(ToFixedPoint(x),ToFixedPoint(yLow));
                }
                this.Canvas.stroke();
            }
        }
        else
        {
            this.Canvas.beginPath();
            if (isHScreen)
            {
                this.Canvas.moveTo(yHigh,ToFixedPoint(x));
                this.Canvas.lineTo(yLow,ToFixedPoint(x));
            }
            else
            {
                this.Canvas.moveTo(ToFixedPoint(x),yHigh);
                this.Canvas.lineTo(ToFixedPoint(x),yLow);
            }
            this.Canvas.stroke();
        }
    }

    this.DrawUnChangeBarItem=function(data, xOffset, dataWidth, option)
    {
        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var left=xOffset;
        var right=xOffset+dataWidth;
        var x=left+(right-left)/2;

        var yLow=this.ChartFrame.GetYFromData(data.Low);
        var yHigh=this.ChartFrame.GetYFromData(data.High);
        var yOpen=this.ChartFrame.GetYFromData(data.Open);
        var yClose=this.ChartFrame.GetYFromData(data.Close);
        var y=yHigh;

        if (dataWidth>=4)
        {
            this.Canvas.beginPath();
            if (data.High>data.Close)   //上影线
            {
                if (isHScreen)
                {
                    this.Canvas.moveTo(y,ToFixedPoint(x));
                    this.Canvas.lineTo(yOpen,ToFixedPoint(x));
                }
                else
                {
                    this.Canvas.moveTo(ToFixedPoint(x),y);
                    this.Canvas.lineTo(ToFixedPoint(x),yOpen);
                }
                y=yOpen;
            }
            else
            {
                y=yOpen;
            }

            if (isHScreen)
            {
                this.Canvas.moveTo(ToFixedPoint(y),ToFixedPoint(left));
                this.Canvas.lineTo(ToFixedPoint(y),ToFixedPoint(right));
            }
            else
            {
                this.Canvas.moveTo(ToFixedPoint(left),ToFixedPoint(y));
                this.Canvas.lineTo(ToFixedPoint(right),ToFixedPoint(y));
            }

            if (data.Open>data.Low) //下影线
            {
                if (isHScreen)
                {
                    this.Canvas.moveTo(ToFixedPoint(y),ToFixedPoint(x));
                    this.Canvas.lineTo(ToFixedPoint(yLow),ToFixedPoint(x));
                }
                else
                {
                    this.Canvas.moveTo(ToFixedPoint(x),ToFixedPoint(y));
                    this.Canvas.lineTo(ToFixedPoint(x),ToFixedPoint(yLow));
                }
            }

            this.Canvas.stroke();
        }
        else
        {
            this.Canvas.beginPath();
            if (isHScreen)
            {
                this.Canvas.moveTo(yHigh,ToFixedPoint(x));
                this.Canvas.lineTo(yLow,ToFixedPoint(x));
            }
            else
            {
                this.Canvas.moveTo(ToFixedPoint(x),yHigh);
                this.Canvas.lineTo(ToFixedPoint(x),yLow);
            }
            this.Canvas.stroke();
        }
    }

    this.DrawBar=function()
    {
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var xOffset=this.ChartBorder.GetLeft()+distanceWidth/2.0+2.0;
        var chartright=this.ChartBorder.GetRight();
        var xPointCount=this.ChartFrame.XPointCount;

        if (this.IsHScreen) 
        {
            xOffset=this.ChartBorder.GetTop()+distanceWidth/2.0+2.0;
            chartright=this.ChartBorder.GetBottom();
        }

        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var data=this.Data.Data[i];
            if (data.Open==null || data.High==null || data.Low==null || data.Close==null) continue;
            if (!this.KLineColor.has(i)) continue;
            var itemOption=this.KLineColor.get(i);

            var left=xOffset;
            var right=xOffset+dataWidth;
            if (right>chartright) break;

            if (itemOption.Color)
            {
                this.Canvas.strokeStyle=itemOption.Color;
                this.Canvas.fillStyle=itemOption.Color;
            }
            else
            {
                this.Canvas.strokeStyle=this.Color;
                this.Canvas.fillStyle=this.Color;
            }

            if (data.Open<data.Close)   //阳线
            {
                this.DrawUpBarItem(data,xOffset,dataWidth,itemOption);
            }
            else if (data.Open>data.Close)  //阴线
            {
                this.DrawDownBarItem(data,xOffset,dataWidth,itemOption);
            }
            else    //平线
            {
                this.DrawUnChangeBarItem(data,xOffset,dataWidth,itemOption);
            }
        }
    }

    this.GetMaxMin=function()
    {
        var range={Max:null,Min:null };
        return range;
    }
}

//K线叠加 支持横屏
var OVERLAY_STATUS_ID=
{
    STATUS_NONE_ID:0,           //空闲状态
    STATUS_REQUESTDATA_ID:1,    //请求数据
    STATUS_RECVDATA_ID:2,       //接收到数据
    STATUS_FINISHED_ID:3,       //数据下载完成
};

function ChartOverlayKLine()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='ChartOverlayKLine';    //类名
    this.Color="rgb(65,105,225)";
    this.MainData;                  //主图K线数据
    this.SourceData;                //叠加的原始数据
    this.Title;
    this.DrawType=0;
    this.CustomDrawType=null;       //图形类型
    this.Status=OVERLAY_STATUS_ID.STATUS_NONE_ID;
    this.IsDelete=false;            //是否已经删除

    this.SetOption=function(option)
    {
        if (!option) return;
        if (IFrameSplitOperator.IsNumber(option.DrawType)) this.CustomDrawType=option.DrawType;
    }

    this.DrawKBar=function(firstOpen)   //firstOpen 当前屏第1个显示数据
    {
        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var xOffset=this.ChartBorder.GetLeft()+distanceWidth/2.0+2.0;
        if (isHScreen) xOffset=this.ChartBorder.GetTop()+distanceWidth/2.0+2.0;
        var chartright=this.ChartBorder.GetRight();
        if (isHScreen) chartright=this.ChartBorder.GetBottom();
        var xPointCount=this.ChartFrame.XPointCount;

        var drawType=this.DrawType;
        if (this.CustomDrawType!=null) drawType=this.CustomDrawType;

        var isFristDraw=true;
        var firstOverlayOpen=null;

        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var data=this.Data.Data[i];
            if (!data || data.Open==null || data.High==null || data.Low==null || data.Close==null) continue;

            if (firstOverlayOpen==null) firstOverlayOpen=data.Open;

            if (isFristDraw)
            {
                this.Canvas.strokeStyle=this.Color;
                this.Canvas.fillStyle=this.Color;
                this.Canvas.beginPath();
                isFristDraw=false;
            }

            var left=xOffset;
            var right=xOffset+dataWidth;
            if (right>chartright) break;
            var x=left+(right-left)/2;
            var yLow=this.GetYFromData(data.Low/firstOverlayOpen*firstOpen,false);
            var yHigh=this.GetYFromData(data.High/firstOverlayOpen*firstOpen,false);
            var yOpen=this.GetYFromData(data.Open/firstOverlayOpen*firstOpen,false);
            var yClose=this.GetYFromData(data.Close/firstOverlayOpen*firstOpen,false);
            var y=yHigh;

            if (data.Open<data.Close)       //阳线
            {
                if (dataWidth>=4)
                {
                    if (data.High>data.Close)   //上影线
                    {
                        if (isHScreen)
                        {
                            this.Canvas.moveTo(ToFixedPoint(y),ToFixedPoint(x));
                            this.Canvas.lineTo(ToFixedPoint(this.DrawType==3?Math.max(yClose,yOpen):yClose),ToFixedPoint(x));
                        }
                        else
                        {
                            this.Canvas.moveTo(ToFixedPoint(x),ToFixedPoint(y));
                            this.Canvas.lineTo(ToFixedPoint(x),ToFixedPoint(this.DrawType==3?Math.min(yClose,yOpen):yClose));
                        }
                        y=yClose;
                    }
                    else
                    {
                        y=yClose;
                    }

                    if (isHScreen)
                    {
                        if (Math.abs(yOpen-y)<1)  
                        {
                            this.Canvas.fillRect(ToFixedRect(y),ToFixedRect(left),1,ToFixedRect(dataWidth));    //高度小于1,统一使用高度1
                        }
                        else 
                        {
                            if (drawType==3) this.Canvas.rect(ToFixedPoint(y),ToFixedPoint(left),ToFixedRect(yOpen-y),ToFixedRect(dataWidth));   //空心柱
                            else this.Canvas.fillRect(ToFixedRect(y),ToFixedRect(left),ToFixedRect(yOpen-y),ToFixedRect(dataWidth));
                        }
                    }
                    else
                    {
                        if (Math.abs(yOpen-y)<1)  
                        {
                            this.Canvas.fillRect(ToFixedRect(left),ToFixedRect(y),ToFixedRect(dataWidth),1);    //高度小于1,统一使用高度1
                        }
                        else 
                        {
                            if (drawType==3) this.Canvas.rect(ToFixedPoint(left),ToFixedPoint(y),ToFixedRect(dataWidth),ToFixedRect(yOpen-y));   //空心柱
                            else this.Canvas.fillRect(ToFixedRect(left),ToFixedRect(y),ToFixedRect(dataWidth),ToFixedRect(yOpen-y));
                        }
                    }

                    if (data.Open>data.Low)
                    {
                        if (isHScreen)
                        {
                            this.Canvas.moveTo(ToFixedPoint(this.DrawType==3?Math.min(yClose,yOpen):y),ToFixedPoint(x));
                            this.Canvas.lineTo(ToFixedPoint(yLow),ToFixedPoint(x));
                        }
                        else
                        {
                            this.Canvas.moveTo(ToFixedPoint(x),ToFixedPoint(this.DrawType==3?Math.max(yClose,yOpen):y));
                            this.Canvas.lineTo(ToFixedPoint(x),ToFixedPoint(yLow));
                        }
                    }
                }
                else
                {
                    if (isHScreen)
                    {
                        this.Canvas.moveTo(yHigh,ToFixedPoint(x));
                        this.Canvas.lineTo(yLow,ToFixedPoint(x));
                    }
                    else
                    {
                        this.Canvas.moveTo(ToFixedPoint(x),yHigh);
                        this.Canvas.lineTo(ToFixedPoint(x),yLow);
                    }
                }
            }
            else if (data.Open>data.Close)  //阴线
            {
                if (dataWidth>=4)
                {
                    if (data.High>data.Close)   //上影线
                    {
                        if (isHScreen)
                        {
                            this.Canvas.moveTo(ToFixedPoint(y),ToFixedPoint(x));
                            this.Canvas.lineTo(ToFixedPoint(yOpen),ToFixedPoint(x));
                        }
                        else
                        {
                            this.Canvas.moveTo(ToFixedPoint(x),ToFixedPoint(y));
                            this.Canvas.lineTo(ToFixedPoint(x),ToFixedPoint(yOpen));
                        }
                        y=yOpen;
                    }
                    else
                    {
                        y=yOpen
                    }

                    if (isHScreen)
                    {
                        if (Math.abs(yClose-y)<1) this.Canvas.fillRect(ToFixedRect(y),ToFixedRect(left),1,ToFixedRect(dataWidth));    //高度小于1,统一使用高度1
                        else this.Canvas.fillRect(ToFixedRect(y),ToFixedRect(left),ToFixedRect(yClose-y),ToFixedRect(dataWidth));
                    }
                    else
                    {
                        if (Math.abs(yClose-y)<1) this.Canvas.fillRect(ToFixedRect(left),ToFixedRect(y),ToFixedRect(dataWidth),1);    //高度小于1,统一使用高度1
                        else this.Canvas.fillRect(ToFixedRect(left),ToFixedRect(y),ToFixedRect(dataWidth),ToFixedRect(yClose-y));
                    }

                    if (data.Open>data.Low) //下影线
                    {
                        if (isHScreen)
                        {
                            this.Canvas.moveTo(ToFixedPoint(y),ToFixedPoint(x));
                            this.Canvas.lineTo(ToFixedPoint(yLow),ToFixedPoint(x));
                        }
                        else
                        {
                            this.Canvas.moveTo(ToFixedPoint(x),ToFixedPoint(y));
                            this.Canvas.lineTo(ToFixedPoint(x),ToFixedPoint(yLow));
                        }
                    }
                }
                else
                {
                    if (isHScreen)
                    {
                        this.Canvas.moveTo(yHigh,ToFixedPoint(x));
                        this.Canvas.lineTo(yLow,ToFixedPoint(x));
                    }
                    else
                    {
                        this.Canvas.moveTo(ToFixedPoint(x),yHigh);
                        this.Canvas.lineTo(ToFixedPoint(x),yLow);
                    } 
                }
            }
            else // 平线
            {
                if (dataWidth>=4)
                {
                    if (data.High>data.Close)   //上影线
                    {
                        if (isHScreen)
                        {
                            this.Canvas.moveTo(y,ToFixedPoint(x));
                            this.Canvas.lineTo(yOpen,ToFixedPoint(x));
                        }
                        else
                        {
                            this.Canvas.moveTo(ToFixedPoint(x),y);
                            this.Canvas.lineTo(ToFixedPoint(x),yOpen);
                        }

                        y=yOpen;
                    }
                    else
                    {
                        y=yOpen;
                    }

                    if (isHScreen)
                    {
                        this.Canvas.moveTo(ToFixedPoint(y),ToFixedPoint(left));
                        this.Canvas.lineTo(ToFixedPoint(y),ToFixedPoint(right));
                    }
                    else
                    {
                        this.Canvas.moveTo(ToFixedPoint(left),ToFixedPoint(y));
                        this.Canvas.lineTo(ToFixedPoint(right),ToFixedPoint(y));
                    }

                    if (data.Open>data.Low) //下影线
                    {
                        if (isHScreen)
                        {
                            this.Canvas.moveTo(ToFixedPoint(y),ToFixedPoint(x));
                            this.Canvas.lineTo(ToFixedPoint(yLow),ToFixedPoint(x));
                        }
                        else
                        {
                            this.Canvas.moveTo(ToFixedPoint(x),ToFixedPoint(y));
                            this.Canvas.lineTo(ToFixedPoint(x),ToFixedPoint(yLow));
                        }
                    }
                }
                else
                {
                    if (isHScreen)
                    {
                        this.Canvas.moveTo(yHigh,ToFixedPoint(x));
                        this.Canvas.lineTo(yLow,ToFixedPoint(x));
                    }
                    else
                    {
                        this.Canvas.moveTo(ToFixedPoint(x),yHigh);
                        this.Canvas.lineTo(ToFixedPoint(x),yLow);
                    }
                }
            }

            //添加tooltip区域
            {
                var yTop=Math.min(yLow,yHigh,yOpen,yClose);
                var yBottom=Math.max(yLow,yHigh,yOpen,yClose);
                var rect=new Rect(left,yTop,dataWidth,yBottom-yTop);
                //this.Canvas.fillStyle="rgb(0,0,100)";
                //this.Canvas.fillRect(rect.X,rect.Y,rect.Width,rect.Height);
                this.TooltipRect.push([i,rect]);    //[0]数据索引 [1]数据区域
            }
        }

        if (isFristDraw==false) this.Canvas.stroke();
    }

    this.DrawAKLine=function(firstOpen) //美国线
    {
        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var xOffset=this.ChartBorder.GetLeft()+distanceWidth/2.0+2.0;
        if (isHScreen) xOffset=this.ChartBorder.GetTop()+distanceWidth/2.0+2.0;
        var chartright=this.ChartBorder.GetRight();
        if (isHScreen) chartright=this.ChartBorder.GetBottom();
        var xPointCount=this.ChartFrame.XPointCount;

        var firstOverlayOpen=null;
        this.Canvas.strokeStyle=this.Color;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var data=this.Data.Data[i];
            if (data.Open==null || data.High==null || data.Low==null || data.Close==null) continue;

            if (firstOverlayOpen==null) firstOverlayOpen=data.Open;
            var left=xOffset;
            var right=xOffset+dataWidth;
            if (right>chartright) break;
            var x=left+(right-left)/2;
            var yLow=this.GetYFromData(data.Low/firstOverlayOpen*firstOpen,false);
            var yHigh=this.GetYFromData(data.High/firstOverlayOpen*firstOpen,false);
            var yOpen=this.GetYFromData(data.Open/firstOverlayOpen*firstOpen,false);
            var yClose=this.GetYFromData(data.Close/firstOverlayOpen*firstOpen,false);

            this.Canvas.beginPath();   //最高-最低
            if (isHScreen)
            {
                this.Canvas.moveTo(yHigh,ToFixedPoint(x));
                this.Canvas.lineTo(yLow,ToFixedPoint(x));
            }
            else
            {
                this.Canvas.moveTo(ToFixedPoint(x),yHigh);
                this.Canvas.lineTo(ToFixedPoint(x),yLow);
            }
            
            this.Canvas.stroke();

            if (dataWidth>=4)
            {
                this.Canvas.beginPath();    //开盘
                if (isHScreen)
                {
                    this.Canvas.moveTo(ToFixedPoint(yOpen),left);
                    this.Canvas.lineTo(ToFixedPoint(yOpen),x);
                }
                else
                {
                    this.Canvas.moveTo(left,ToFixedPoint(yOpen));
                    this.Canvas.lineTo(x,ToFixedPoint(yOpen));
                }
                this.Canvas.stroke();

                this.Canvas.beginPath();    //收盘
                if (isHScreen)
                {
                    this.Canvas.moveTo(ToFixedPoint(yClose),right);
                    this.Canvas.lineTo(ToFixedPoint(yClose),x);
                }
                else
                {
                    this.Canvas.moveTo(right,ToFixedPoint(yClose));
                    this.Canvas.lineTo(x,ToFixedPoint(yClose));
                }
                this.Canvas.stroke();
            }
        }

    }

    this.DrawCloseLine=function(firstOpen)  //收盘价线
    {
        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var xOffset=this.ChartBorder.GetLeft()+distanceWidth/2.0+2.0;
        if (isHScreen) xOffset=this.ChartBorder.GetTop()+distanceWidth/2.0+2.0;
        var chartright=this.ChartBorder.GetRight();
        if (isHScreen) chartright=this.ChartBorder.GetBottom();
        var xPointCount=this.ChartFrame.XPointCount;

        var firstOverlayOpen=null;
        var bFirstPoint=true;
        this.Canvas.strokeStyle=this.Color;
        this.Canvas.beginPath();
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var data=this.Data.Data[i];
            if (data.Open==null || data.High==null || data.Low==null || data.Close==null) continue;

            if (firstOverlayOpen==null) firstOverlayOpen=data.Open;
            var left=xOffset;
            var right=xOffset+dataWidth;
            if (right>chartright) break;
            var x=left+(right-left)/2;
            var yClose=this.GetYFromData(data.Close/firstOverlayOpen*firstOpen,false);

            if (bFirstPoint)
            {
                if (isHScreen) this.Canvas.moveTo(yClose,x);
                else this.Canvas.moveTo(x,yClose);
                bFirstPoint=false;
            }
            else
            {
                if (isHScreen) this.Canvas.lineTo(yClose,x);
                else this.Canvas.lineTo(x,yClose);
            }
        }

        if (bFirstPoint==false) this.Canvas.stroke();
    }

    this.Draw=function()
    {
        this.TooltipRect=[];
        this.InfoTooltipRect=[];
        if (!this.MainData || !this.Data) return;

        var xPointCount=this.ChartFrame.XPointCount;
        var firstOpen=null; //主线数据第1个开盘价
        for(var i=this.Data.DataOffset,j=0;i<this.MainData.Data.length && j<xPointCount;++i,++j)
        {
            var data=this.MainData.Data[i];
            if (data.Open==null || data.High==null || data.Low==null || data.Close==null) continue;
            firstOpen=data.Open;
            break;
        }

        if (firstOpen==null) return;

        var drawType=this.DrawType;
        if (this.CustomDrawType!=null) drawType=this.CustomDrawType;

        this.Canvas.save();
        this.ClipClient(this.ChartFrame.IsHScreen);

        if (drawType==1) this.DrawCloseLine(firstOpen);
        else if (drawType==2) this.DrawAKLine(firstOpen);
        else this.DrawKBar(firstOpen);

        this.Canvas.restore();
    }

    this.GetMaxMin=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var range={};
        range.Max=null;
        range.Min=null;

        if (!this.MainData || !this.Data) return range;

        var firstOpen=null; //主线数据第1个收盘价
        for(var i=this.Data.DataOffset,j=0;i<this.MainData.Data.length && j<xPointCount;++i,++j)
        {
            var data=this.MainData.Data[i];
            if (data.Open==null || data.High==null || data.Low==null || data.Close==null) continue;
            firstOpen=data.Close;
            break;
        }

        if (firstOpen==null) return range;

        var firstOverlayOpen=null;
        var high,low;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var data=this.Data.Data[i];
            if (!data || data.Open==null || data.High==null || data.Low==null || data.Close==null) continue;
            if (firstOverlayOpen==null) firstOverlayOpen=data.Open;

            high=data.High/firstOverlayOpen*firstOpen;
            low=data.Low/firstOverlayOpen*firstOpen;
            if (range.Max==null) range.Max=high;
            if (range.Min==null) range.Min=low;

            if (range.Max<high) range.Max=high;
            if (range.Min>low) range.Min=low;
        }

        return range;
    }

    this.GetTooltipData=function(x,y,tooltip)
    {
        for(var i in this.TooltipRect)
        {
            var rect=this.TooltipRect[i][1];
            this.Canvas.beginPath();
            this.Canvas.rect(rect.X,rect.Y,rect.Width,rect.Height);
            if (this.Canvas.isPointInPath(x,y))
            {
                var index=this.TooltipRect[i][0];
                tooltip.Data=this.Data.Data[index];
                tooltip.ChartPaint=this;
                return true;
            }
        }
        return false;
    }
}

//分钟成交量 支持横屏
function ChartMinuteVolumBar()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='ChartMinuteVolumBar';    //类名

    this.UpColor = g_JSChartResource.UpBarColor;            //上涨
    this.DownColor = g_JSChartResource.DownBarColor;        //下跌
    this.UnchangeColor=g_JSChartResource.UnchagneBarColor;  //平盘

    this.CustomColor=g_JSChartResource.Minute.VolBarColor;   //自定义颜色

    this.YClose;    //前收盘
    this.Symbol;
    this.BeforeOpenData;    //盘前数据
    this.AfterCloseData;    //盘后数据  
    this.BeforeVolColor=g_JSChartResource.Minute.Before.VolColor;

    this.MultiDayBeforeOpenData;    //多日分时图 盘前数据 数组 1天一个
    this.MultiDayAfterCloseData;    //多日分时图 盘后数据 数组 1天一个

    this.Draw=function()
    {
        var isHScreen = (this.ChartFrame.IsHScreen === true);
        
        if (isHScreen) 
        {
            var border=this.ChartBorder.GetHScreenBorder();
            var chartright = border.BottomEx;
        }
        else
        {
            var border=this.ChartBorder.GetBorder();
            var chartright=border.RightEx;
        }

        this.DrawBeforeOpen();
        this.DrawMultiDayBeforeOpen();

        var xPointCount=this.ChartFrame.XPointCount;
        var yBottom=this.ChartFrame.GetYFromData(0);
        var yPrice=this.YClose; //上一分钟的价格
        var data=this.Data;
        var bShowColorBar=MARKET_SUFFIX_NAME.IsShowMinuteColorVolBar(this.Symbol);

        if (bShowColorBar) this.Canvas.strokeStyle=this.CustomColor;
        for(var i=data.DataOffset,j=0;i<data.Data.length && j<xPointCount;++i,++j)
        {
            var item = data.Data[i];
            var vol=null;
            if (!item) continue;
            var price=null;

            vol=item.Vol;
            price=item.Close;
            
            if (!vol) continue;

            var y=this.ChartFrame.GetYFromData(vol);
            var x=this.ChartFrame.GetXFromIndex(i);
            if (x>chartright) break;

            //价格>=上一分钟价格 红色 否则绿色
            if (!bShowColorBar) this.Canvas.strokeStyle = price >= yPrice ? this.UpColor:this.DownColor;
            this.Canvas.beginPath();
            if (isHScreen)
            {
                this.Canvas.moveTo(y,ToFixedPoint(x));
                this.Canvas.lineTo(yBottom,ToFixedPoint(x));
            }
            else
            {
                this.Canvas.moveTo(ToFixedPoint(x),y);
                this.Canvas.lineTo(ToFixedPoint(x),yBottom);
            }
            this.Canvas.stroke();
            if (price) yPrice=price;
        }

        this.DrawAfterClose();
        this.DrawMultiDayAfterClose();
    }

    this.DrawBeforeOpen=function()
    {
        if (this.ChartBorder.LeftExtendWidth<10) return;
        if (!this.BeforeOpenData) return;

        this.DrawCallAuction(-1,this.BeforeOpenData,true);
    }

    this.DrawAfterClose=function()
    {
        if (this.ChartBorder.RightExtendWidth<10) return;
        if (!this.AfterCloseData) return;

        this.DrawCallAuction(-1,this.AfterCloseData,false);
    }

    this.DrawMultiDayBeforeOpen=function()
    {
        if (this.ChartBorder.MultiDayMinute.Count<=1 || this.ChartBorder.MultiDayMinute.Left<=0) return;
        if (!this.MultiDayBeforeOpenData) return;

        for(var i in this.MultiDayBeforeOpenData)
        {
            var dayItem=this.MultiDayBeforeOpenData[i];
            this.DrawCallAuction(parseInt(i), dayItem, true);
        }
    }

    this.DrawMultiDayAfterClose=function()
    {
        if (this.ChartBorder.MultiDayMinute.Count<=1 || this.ChartBorder.MultiDayMinute.Right<=0) return;
        if (!this.MultiDayAfterCloseData) return;

        for(var i in this.MultiDayAfterCloseData)
        {
            var dayItem=this.MultiDayAfterCloseData[i];
            this.DrawCallAuction(parseInt(i), dayItem, false);
        }
    }

    this.DrawCallAuction=function(indexDay, callAutionData, isBeforeOpen)
    {
        if (!callAutionData) return;

        callAutionData.Index=indexDay;
        var border=this.GetBorder();
        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var yPrice=this.YClose;             //上一分钟的价格
        var yBottom=this.ChartFrame.GetYFromData(0);
        if (callAutionData.Ver==1.0)
        {
            for(var i in callAutionData.Data)
            {
                var item=callAutionData.Data[i];
                if (!item || !IFrameSplitOperator.IsNumber(item.Vol[0])) continue;

                if (isBeforeOpen)
                {
                    var x=this.ChartFrame.GetLeftExtendXFromIndex(i,callAutionData);
                    var y=this.ChartFrame.GetLeftExtendYFromData(item.Vol[0]);
                }
                else
                {
                    var x=this.ChartFrame.GetRightExtendXFromIndex(i,callAutionData);
                    var y=this.ChartFrame.GetRightExtendYFromData(item.Vol[0]);
                }
                

                this.Canvas.strokeStyle = item.Price >= yPrice ? this.UpColor:this.DownColor;
                this.Canvas.beginPath();
                if (isHScreen)
                {
                    this.Canvas.moveTo(y,ToFixedPoint(x));
                    this.Canvas.lineTo(yBottom,ToFixedPoint(x));
                }
                else
                {
                    this.Canvas.moveTo(ToFixedPoint(x),y);
                    this.Canvas.lineTo(ToFixedPoint(x),yBottom);
                }
                this.Canvas.stroke();
                if (item.Price) yPrice=item.Price;
            }
        }
        else if (callAutionData.Ver==2.0 || callAutionData.Ver==3.0)
        {
            var range={ Max: callAutionData.VolMax, Min:callAutionData.VolMin }
            
            for(var i in callAutionData.Data)
            {
                var item=callAutionData.Data[i];
                if (!item) continue;
                if (IFrameSplitOperator.IsPlusNumber(item.Vol[0])) 
                {
                    if (isBeforeOpen)
                    {
                        var x=this.ChartFrame.GetLeftExtendXFromIndex(i,callAutionData);
                        var y=this.ChartFrame.GetLeftExtendYFromData(item.Vol[0],false, { Range:range });
                    }
                    else
                    {
                        var x=this.ChartFrame.GetRightExtendXFromIndex(i,callAutionData);
                        var y=this.ChartFrame.GetRightExtendYFromData(item.Vol[0],false, { Range:range });
                    }
                    
                    this.Canvas.strokeStyle = this.GetBarColor(item.ColorID);

                    this.Canvas.beginPath();
                    if (isHScreen)
                    {
                        this.Canvas.moveTo(y,ToFixedPoint(x));
                        this.Canvas.lineTo(yBottom,ToFixedPoint(x));
                    }
                    else
                    {
                        this.Canvas.moveTo(ToFixedPoint(x),y);
                        this.Canvas.lineTo(ToFixedPoint(x),yBottom);
                    }
                    this.Canvas.stroke();
                }

                if (IFrameSplitOperator.IsPlusNumber(item.Vol[1])) 
                {
                    if (isBeforeOpen)
                    {
                        var x=this.ChartFrame.GetLeftExtendXFromIndex(i,callAutionData);
                        var y=this.ChartFrame.GetLeftExtendYFromData(item.Vol[1],false, { Range:range });
                    }
                    else
                    {
                        var x=this.ChartFrame.GetRightExtendXFromIndex(i,callAutionData);
                        var y=this.ChartFrame.GetRightExtendYFromData(item.Vol[1],false, { Range:range });
                    }
                    
                    this.Canvas.strokeStyle = this.GetBarColor(item.ColorID);
                    this.Canvas.beginPath();
                    if (isHScreen)
                    {
                        y-=yBottom;
                        y=border.RightEx-y;
                        this.Canvas.moveTo(y,ToFixedPoint(x));
                        this.Canvas.lineTo(border.RightEx,ToFixedPoint(x));
                    }
                    else
                    {
                        y-=yBottom;
                        y=border.TopEx-y;
                        this.Canvas.moveTo(ToFixedPoint(x),y);
                        this.Canvas.lineTo(ToFixedPoint(x),border.TopEx);
                    }
                    this.Canvas.stroke();
                }
            }
        }
    }

    this.GetBarColor=function(id)
    {
        switch(id)
        {
            case 0:
                return this.UnchangeColor;
            case 1:
                return this.UpColor;
            case 2:
                return this.DownColor;
        }

        if (this.BeforeVolColor && Array.isArray(this.BeforeVolColor))
        {
            var index=id-3;
            if (index>=0 && index<this.BeforeVolColor.length)
                return this.BeforeVolColor[index];
        }

        return this.UnchangeColor;
    }

    this.GetMaxMin=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var range={};
        range.Min=0;
        range.Max=null;

        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var item = this.Data.Data[i];
            if (!item || !item.Vol) continue;
            if (range.Max == null) range.Max = item.Vol;
            if (range.Max < item.Vol) range.Max = item.Vol;
        }

        return range;
    }
}

function ChartErrorMessage()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='ChartErrorMessage';    //类名

    this.Draw=function()
    {
        if (!this.IsShow) return;
        if (this.NotSupportMessage) this.DrawNotSupportmessage();
    }
}

//线段 支持横屏
function ChartLine()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='ChartLine';    //类名
    this.Color="rgb(255,193,37)";   //线段颜色
    this.LineWidth;                 //线段宽度
    this.DrawType=0;                //画图方式  0=无效数平滑  1=无效数不画断开
    this.IsDotLine=false;           //虚线

    this.Draw=function()
    {
        if (!this.IsShow)
            return;
        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        if (!this.Data || !this.Data.Data) return;

        switch(this.DrawType)
        {
            case 0:
                return this.DrawLine();
            case 1: 
                return this.DrawStraightLine();
        }
    }

    this.DrawLine=function()
    {
        var bHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var chartright=this.ChartBorder.GetRight();
        if (bHScreen) chartright=this.ChartBorder.GetBottom();
        var xPointCount=this.ChartFrame.XPointCount;
        
        this.Canvas.save();
        if (this.LineWidth>0) this.Canvas.lineWidth=this.LineWidth * GetDevicePixelRatio();
        if (this.IsDotLine) this.Canvas.setLineDash(g_JSChartResource.DOTLINE.LineDash); //画虚线
        var bFirstPoint=true;
        var drawCount=0;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i];
            if (value==null) continue;

            var x=this.ChartFrame.GetXFromIndex(j);
            var y=this.GetYFromData(value);

            if (x>chartright) break;

            if (bFirstPoint)
            {
                this.Canvas.strokeStyle=this.Color;
                this.Canvas.beginPath();
                if (bHScreen) this.Canvas.moveTo(y,x);  //横屏坐标轴对调
                else this.Canvas.moveTo(x,y);
                bFirstPoint=false;
            }
            else
            {
                if (bHScreen) this.Canvas.lineTo(y,x);
                else this.Canvas.lineTo(x,y);
            }

            ++drawCount;
        }

        if (drawCount>0) this.Canvas.stroke();
        this.Canvas.restore();
    }

    //无效数不画
    this.DrawStraightLine=function()
    {
        var bHScreen=(this.ChartFrame.IsHScreen===true);
        var isMinute=this.IsMinuteFrame();
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var xPointCount=this.ChartFrame.XPointCount;

        if (bHScreen)
        {
            var border=this.ChartBorder.GetHScreenBorder();
            var chartright=border.BottomEx;
            var xOffset=border.TopEx+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
        }
        else
        {
            var border=this.ChartBorder.GetBorder();
            var xOffset=border.LeftEx+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
            var chartright=border.RightEx;
        }

        var lockRect=this.GetLockRect();
        if (lockRect)
        {
            if (bHScreen) chartright=lockRect.Top;
            else chartright=lockRect.Left;
        }

        this.Canvas.save();
        this.ClipClient(bHScreen);
        if (this.LineWidth>0) this.Canvas.lineWidth=this.LineWidth * GetDevicePixelRatio();
        this.Canvas.strokeStyle=this.Color;
        if (this.IsDotLine) this.Canvas.setLineDash(g_JSChartResource.DOTLINE.LineDash); //画虚线

        var bFirstPoint=true;
        var drawCount=0;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        //for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i];
            if (value==null) 
            {
                if (drawCount>0) this.Canvas.stroke();
                bFirstPoint=true;
                drawCount=0;
                continue;
            }

            if (isMinute)
            {
                var x=this.ChartFrame.GetXFromIndex(j);
            }
            else
            {
                var left=xOffset;
                var right=xOffset+dataWidth;
                if (right>chartright) break;
                var x=left+(right-left)/2;
            }
            
            var y=this.GetYFromData(value,false);

            if (x>chartright) break;

            if (bFirstPoint)
            {
                this.Canvas.beginPath();
                if (bHScreen) this.Canvas.moveTo(y,x);  //横屏坐标轴对调
                else this.Canvas.moveTo(x,y);
                bFirstPoint=false;
            }
            else
            {
                if (bHScreen) this.Canvas.lineTo(y,x);
                else this.Canvas.lineTo(x,y);
            }

            ++drawCount;
        }

        if (drawCount>0) this.Canvas.stroke();
        this.Canvas.restore();
    }
}

//子线段
function ChartSubLine()
{
    this.newMethod=ChartLine;       //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='ChartSubLine';     //类名
    this.Color="rgb(255,193,37)";   //线段颜色
    this.LineWidth;                 //线段宽度
    this.DrawType=0;                //画图方式  0=无效数平滑  1=无效数不画断开
    this.IsDotLine=false;           //虚线

    this.SubFrame={ Max:null,Min:null };

    this.Draw=function()
    {
        if (!this.IsShow) return;
        if (!this.Data || !this.Data.Data) return;

        this.CalculateDataMaxMin();

        switch(this.DrawType)
        {
            case 0:
                return this.DrawLine();
            case 1: 
                return this.DrawStraightLine();
        }
    }

    this.GetYFromData=function(value)
    {
        var bHScreen = (this.ChartFrame.IsHScreen === true);

        if (bHScreen)
        {
            if (value <= this.SubFrame.Min) return this.ChartBorder.GetLeftEx();
            if (value >= this.SubFrame.Max) return this.ChartBorder.GetRightEx();

            var width = this.ChartBorder.GetWidthEx() * (value - this.SubFrame.Min) / (this.SubFrame.Max - this.SubFrame.Min);
            return this.ChartBorder.GetLeftEx() + width;
        }
        else
        {
            if(value<=this.SubFrame.Min) return this.ChartBorder.GetBottomEx();
            if(value>=this.SubFrame.Max) return this.ChartBorder.GetTopEx();
    
            var height=this.ChartBorder.GetHeightEx()*(value-this.SubFrame.Min)/(this.SubFrame.Max-this.SubFrame.Min);
            return this.ChartBorder.GetBottomEx()-height;
        }
    }

    this.CalculateDataMaxMin=function()
    {
        this.SubFrame={ Max:null,Min:null };

        var bHScreen=(this.ChartFrame.IsHScreen===true);
        var chartright=this.ChartBorder.GetRight();
        if (bHScreen) chartright=this.ChartBorder.GetBottom();
        var xPointCount=this.ChartFrame.XPointCount;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i];
            if (value==null) continue;

            var x=this.ChartFrame.GetXFromIndex(j);
            if (x>chartright) break;

            if (this.SubFrame.Min==null || this.SubFrame.Min>value) this.SubFrame.Min=value;
            if (this.SubFrame.Max==null || this.SubFrame.Max<value) this.SubFrame.Max=value;
        }
    }

    this.GetMaxMin=function()   //数据不参与坐标轴最大最小值计算
    {
        var range={Min:null, Max:null};
        return range;
    }
}

//叠加线段
function ChartOverlayLine()
{
    this.newMethod=ChartLine;   //派生
    this.newMethod();
    delete this.newMethod;

    this.MainData=new ChartData();  //主数据

    this.Draw=function()
    {
        if (!this.Data || !this.Data.Data) return;
        if (!this.MainData || !this.MainData.Data) return;

        switch(this.DrawType)
        {
            case 0:
                return this.DrawLine();
            case 1: 
                return this.DrawStraightLine();
        }
    }

    //获取第1个有效数据
    this.GetFirstVaildIndex=function()
    {
        var startIndex=this.Data.DataOffset;
        for(var i=startIndex, j=0 ; i<this.MainData.Data.length && i<this.Data.Data.length; ++i,++j )
        {
            var value=this.MainData.Data[i];
            var overlayValue=this.Data.Data[i];
            if (IFrameSplitOperator.IsNumber(value) && IFrameSplitOperator.IsNumber(overlayValue)) 
                return { Index:j, DataOffset:i, OverlayValue:overlayValue, MainValue:value };
        }

        return null;
    }

    //无效数不画
    this.DrawStraightLine=function()
    {
        var firstData=this.GetFirstVaildIndex();
        if (!firstData) return;

        var bHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var chartright=this.ChartBorder.GetRight();
        if (bHScreen) chartright=this.ChartBorder.GetBottom();
        var xPointCount=this.ChartFrame.XPointCount;
        var lockRect=this.GetLockRect();
        if (lockRect)
        {
            if (bHScreen) chartright=lockRect.Top;
            else chartright=lockRect.Left;
        }

        this.Canvas.save();
        if (this.LineWidth>0) this.Canvas.lineWidth=this.LineWidth * GetDevicePixelRatio();
        this.Canvas.strokeStyle=this.Color;
        if (this.IsDotLine) this.Canvas.setLineDash([3,5]); //画虚线

        var bFirstPoint=true;
        var drawCount=0,rate=0;
        for(var i=firstData.DataOffset,j=firstData.Index;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i];
            if (value==null) 
            {
                if (drawCount>0) this.Canvas.stroke();
                bFirstPoint=true;
                drawCount=0;
                continue;
            }

            var x=this.ChartFrame.GetXFromIndex(j);
            var diff=value-firstData.OverlayValue;
            if (firstData.OverlayValue!=0) rate= 1+ diff/Math.abs(firstData.OverlayValue);
            else rate=1+diff;
            var fixedValue=firstData.MainValue*rate;
            //var fixedValue=value/firstData.OverlayValue*firstData.MainValue;
            var y=this.GetYFromData(fixedValue);

            if (x>chartright) break;

            if (bFirstPoint)
            {
                this.Canvas.beginPath();
                if (bHScreen) this.Canvas.moveTo(y,x);  //横屏坐标轴对调
                else this.Canvas.moveTo(x,y);
                bFirstPoint=false;
            }
            else
            {
                if (bHScreen) this.Canvas.lineTo(y,x);
                else this.Canvas.lineTo(x,y);
            }

            ++drawCount;
        }

        if (drawCount>0) this.Canvas.stroke();
        this.Canvas.restore();
    }

    this.GetMaxMin=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var range={};
        range.Min=null;
        range.Max=null;

        var firstData=this.GetFirstVaildIndex();
        if (!firstData) return range;

        for(var i=firstData.DataOffset,j=firstData.Index; i<this.Data.Data.length && j<xPointCount; ++i,++j)
        {
            var overlayValue=this.Data.Data[i];
            if (!IFrameSplitOperator.IsNumber(overlayValue)) continue;

            var diff=overlayValue-firstData.OverlayValue;
            if (firstData.OverlayValue!=0) rate= 1+ diff/Math.abs(firstData.OverlayValue);
            else rate=1+diff;
            var value=firstData.MainValue*rate;
            //var value=overlayValue/firstData.OverlayValue*firstData.MainValue;

            if (range.Max==null) range.Max=value;
            if (range.Min==null) range.Min=value;

            if (range.Max<value) range.Max=value;
            if (range.Min>value) range.Min=value;
        }

        return range;
    }
}

//彩色线段
function ChartPartLine()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='ChartPartLine';     //类名
    this.LineWidth;                     //线段宽度            

    this.Draw=function()
    {
        if (!this.IsShow) return;
        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        if (!this.Data || !this.Data.Data) return;

        this.DrawLine();
    }

    this.DrawLine=function()
    {
        var bHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var chartright=this.ChartBorder.GetRight();
        if (bHScreen) chartright=this.ChartBorder.GetBottom();
        var xPointCount=this.ChartFrame.XPointCount;
        
        this.Canvas.save();
        if (this.LineWidth>0) this.Canvas.lineWidth=this.LineWidth * GetDevicePixelRatio();
        var bFirstPoint=true;
        var drawCount=0;
        var lastColor;
        var lastPoint={X:null,Y:null};
        var isPerNull=false;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var item=this.Data.Data[i];
            if (item==null || item.Value==null) 
            {
                lastPoint.X=null;
                lastPoint.Y=null;
                isPerNull=true;
                continue;
            }

            var value=item.Value;
            var color=item.RGB;
            var x=this.ChartFrame.GetXFromIndex(j);
            var y=this.ChartFrame.GetYFromData(value);

            if (x>chartright) break;

            if (color!=lastColor || isPerNull==true)
            {
                if (lastColor && drawCount>0) this.Canvas.stroke();

                drawCount=0;
                lastColor=color;
                this.Canvas.strokeStyle=color;
                this.Canvas.beginPath();

                if (lastPoint.X!=null && lastPoint.Y!=null) //接着上一个点连线
                {
                    if (bHScreen) this.Canvas.moveTo(lastPoint.Y,lastPoint.X);  //横屏坐标轴对调
                    else this.Canvas.moveTo(lastPoint.X,lastPoint.Y);

                    if (bHScreen) this.Canvas.lineTo(y,x);
                    else this.Canvas.lineTo(x,y);

                    ++drawCount;
                }
                else
                {
                    if (bHScreen) this.Canvas.moveTo(y,x);  //横屏坐标轴对调
                    else this.Canvas.moveTo(x,y);
                }
            }
            else
            {
                if (bHScreen) this.Canvas.lineTo(y,x);
                else this.Canvas.lineTo(x,y);
                ++drawCount;
            }

            lastPoint.X=x;
            lastPoint.Y=y;
            isPerNull=false;
        }

        if (drawCount>0) this.Canvas.stroke();
        this.Canvas.restore();
    }

    this.GetMaxMin=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var range={};
        range.Min=null;
        range.Max=null;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var item = this.Data.Data[i];
            if (!item || !item.Value) continue;
            if (range.Max == null || range.Max<item.Value) range.Max = item.Value;
            if (range.Min == null || range.Min>item.Value) range.Min = item.Value;
        }

        return range;
    }
}

//斜率线 DRAWSL()
function ChartSlopeLine()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='ChartSlopeLine';     //类名
    this.Color="rgb(255,193,37)";        //线段颜色
    this.IsDotLine=false;
    this.LineWidth;
    this.Option;    //[ { Slope:slope, Length:len, Direct:direct } ]

    this.Draw=function()
    {
        if (!this.IsShow) return;
        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        if (!this.Data || !this.Data.Data) return;

        this.Canvas.save();
        this.Canvas.strokeStyle=this.Color;
        if (this.IsDotLine) this.Canvas.setLineDash(g_JSChartResource.DOTLINE.LineDash); //画虚线
        
        var left=this.ChartBorder.GetLeft();
        var top=this.ChartBorder.GetTopEx();
        var right=this.ChartBorder.GetRight();
        var bottom=this.ChartBorder.GetBottom();

        var chartright=this.ChartBorder.GetRight();
        var xPointCount=this.ChartFrame.XPointCount;

        this.Canvas.beginPath();
        this.Canvas.rect(left,top,(right-left),(bottom-top));
        this.Canvas.clip();

        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i];
            if (!IFrameSplitOperator.IsNumber(value)) continue; 
            var option=this.Option[i];
            if (!option) continue;
           
            var x=this.ChartFrame.GetXFromIndex(j);
            var y=this.ChartFrame.GetYFromData(value);
            var z=option.Length*g_JSChartResource.DRAWSL.PixelWidth;
            if (x>chartright) break;

            var x2=Math.sqrt((z*z)/(1+option.Slope*option.Slope));
            var y2=x2*option.Slope;

            this.Canvas.beginPath();
            if (option.Direct==2)
            {
                this.Canvas.moveTo(x-x2,y+y2);
                this.Canvas.lineTo(x+x2,y-y2);
            }
            else if (option.Direct==1)
            {
                this.Canvas.moveTo(x,y);
                this.Canvas.lineTo(x-x2,y+y2);
            }
            else
            {
                this.Canvas.moveTo(x,y);
                this.Canvas.lineTo(x+x2,y-y2);
            }
            
            this.Canvas.stroke();
        }

        this.Canvas.restore();
    }
}


//POINTDOT 圆点 支持横屏
function ChartPointDot()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='ChartPointDot';    //类名
    this.Color="rgb(255,193,37)";   //线段颜色
    this.Radius=1;                  //点半径

    this.Draw=function()
    {
        if (!this.IsShow) return;

        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        if (!this.Data || !this.Data.Data) return;

        var bHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var chartright=this.ChartBorder.GetRight();
        if (bHScreen===true) chartright=this.ChartBorder.GetBottom();
        var xPointCount=this.ChartFrame.XPointCount;

        this.Canvas.save();
        this.Canvas.fillStyle=this.Color;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i];
            if (value==null) continue;

            var x=this.ChartFrame.GetXFromIndex(j);
            var y=this.ChartFrame.GetYFromData(value);

            if (x>chartright) break;

            this.Canvas.beginPath();
            if (bHScreen) this.Canvas.arc(y, x, this.Radius, 0, Math.PI*2, true);
            else this.Canvas.arc(x, y, this.Radius, 0, Math.PI*2, true);
            this.Canvas.closePath();
            this.Canvas.fill();
        }

        this.Canvas.restore();
    }
}

//通达信语法  STICK 支持横屏
function ChartStick()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.Color="rgb(255,193,37)";   //线段颜色
    this.LineWidth;                 //线段宽度
    this.ClassName='ChartStick';

    this.DrawLine=function()
    {
        if (!this.Data || !this.Data.Data) return;

        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var chartright=this.ChartBorder.GetRight();
        if (isHScreen===true) chartright=this.ChartBorder.GetBottom();
        var xPointCount=this.ChartFrame.XPointCount;

        this.Canvas.save();
        if (this.LineWidth>0) this.Canvas.lineWidth=this.LineWidth * GetDevicePixelRatio();
        var bFirstPoint=true;
        var drawCount=0;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i];
            if (value==null) continue;

            var x=this.ChartFrame.GetXFromIndex(j);
            var y=this.ChartFrame.GetYFromData(value);

            if (x>chartright) break;

            if (bFirstPoint)
            {
                this.Canvas.strokeStyle=this.Color;
                this.Canvas.beginPath();
                if (isHScreen) this.Canvas.moveTo(y,x);
                else this.Canvas.moveTo(x,y);
                bFirstPoint=false;
            }
            else
            {
                if (isHScreen) this.Canvas.lineTo(y,x);
                else this.Canvas.lineTo(x,y);
            }

            ++drawCount;
        }

        if (drawCount>0) this.Canvas.stroke();
        this.Canvas.restore();
    }

    this.DrawStick=function()
    {
        if (!this.Data || !this.Data.Data) return;
        var bHScreen=(this.ChartFrame.IsHScreen===true);
        var chartright=this.ChartBorder.GetRight();
        if (bHScreen) chartright=this.ChartBorder.GetBottom();
        var xPointCount=this.ChartFrame.XPointCount;
        var yBottom=this.ChartBorder.GetBottom();
        var xLeft=this.ChartBorder.GetLeft();

        this.Canvas.save();
        this.Canvas.strokeStyle=this.Color;
        if (this.LineWidth) this.Canvas.lineWidth=this.LineWidth * GetDevicePixelRatio();
        var lineWidth=this.Canvas.lineWidth;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i];
            if (value==null) continue;

            var x=this.ChartFrame.GetXFromIndex(j);
            var y=this.ChartFrame.GetYFromData(value);

            if (x>chartright) break;

            this.Canvas.beginPath();
            if (bHScreen)
            {
                this.Canvas.moveTo(xLeft,x);  
                this.Canvas.lineTo(y,x);
                this.Canvas.stroke();
            }
            else
            {
                var xFix=ToFixedPoint2(lineWidth, x);
                this.Canvas.moveTo(xFix,y);  
                this.Canvas.lineTo(xFix,yBottom);
            }
            this.Canvas.stroke();
        }

        this.Canvas.restore();
    }

    this.Draw=function()
    {
        if (!this.IsShow) return;

        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        if (!this.Data || !this.Data.Data) return;

        this.DrawStick();
    }
}

//通达信语法 LINESTICK 支持横屏
function ChartLineStick()
{
    this.newMethod=ChartStick;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='ChartLineStick';

    this.Draw=function()
    {
        if (!this.IsShow) return;

        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        this.DrawStick();
        this.DrawLine();
    }
}

//通达信语法 VOLSTICK 支持横屏
function ChartVolStick()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.UpColor=g_JSChartResource.UpBarColor;
    this.DownColor=g_JSChartResource.DownBarColor;
    this.HistoryData;               //历史数据
    this.KLineDrawType=0;
    this.ClassName='ChartVolStick';

    this.Draw=function()
    {
        if (this.ChartFrame.IsHScreen===true) 
        {
            this.HScreenDraw();
            return;
        }

        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var border=this.ChartBorder.GetBorder();
        var xOffset=border.LeftEx+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
        var chartright=border.RightEx;
        var xPointCount=this.ChartFrame.XPointCount;
        var lockRect=this.GetLockRect();
        if (lockRect) chartright=lockRect.Left;

        var yBottom=this.ChartFrame.GetYFromData(0);

        if (dataWidth>=4)
        {
            yBottom=ToFixedRect(yBottom);
            for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
            {
                var value=this.Data.Data[i];
                var kItem=this.HistoryData.Data[i];
                if (value==null || kItem==null) continue;

                var left=xOffset;
                var right=xOffset+dataWidth;
                if (right>chartright) break;

                var y=this.ChartFrame.GetYFromData(value);
                var bUp=false;
                if (kItem.Close>=kItem.Open)
                {
                    this.Canvas.fillStyle=this.UpColor;
                    bUp=true;
                }
                else
                {
                    this.Canvas.fillStyle=this.DownColor;
                }
                
                var height=ToFixedRect(Math.abs(yBottom-y)>=1?yBottom-y:1);//高度调整为整数, 如果小于1, 统一使用1
                y=yBottom-height;
                if (bUp && (this.KLineDrawType==1 || this.KLineDrawType==2 || this.KLineDrawType==3)) //空心柱子
                {
                    this.Canvas.strokeStyle=this.UpColor;
                    this.Canvas.beginPath();
                    this.Canvas.rect(ToFixedPoint(left),ToFixedPoint(y),ToFixedRect(dataWidth),height);
                    this.Canvas.stroke();
                }
                else
                {
                    this.Canvas.fillRect(ToFixedRect(left),y,ToFixedRect(dataWidth),height);
                }
            }
        }
        else    //太细了直接话线
        {
            for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
            {
                var value=this.Data.Data[i];
                var kItem=this.HistoryData.Data[i];
                if (value==null || kItem==null) continue;

                var y=this.ChartFrame.GetYFromData(value);
                var x=this.ChartFrame.GetXFromIndex(j);
                if (x>chartright) break;

                if (kItem.Close>=kItem.Open)
                    this.Canvas.strokeStyle=this.UpColor;
                else
                    this.Canvas.strokeStyle=this.DownColor;

                var x=this.ChartFrame.GetXFromIndex(j);
                this.Canvas.beginPath();
                this.Canvas.moveTo(ToFixedPoint(x),y);
                this.Canvas.lineTo(ToFixedPoint(x),yBottom);
                this.Canvas.stroke();
            }
        }
    }

    this.HScreenDraw=function() //横屏画法
    {
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var border=this.ChartBorder.GetHScreenBorder();
        var xOffset=border.TopEx+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
        var chartBottom=border.BottomEx;
        var xPointCount=this.ChartFrame.XPointCount;
        var lockRect=this.GetLockRect();
        if (lockRect) chartBottom=lockRect.Top;

        var yBottom=this.ChartFrame.GetYFromData(0);

        if (dataWidth>=4)
        {
            yBottom=ToFixedRect(yBottom);
            for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
            {
                var value=this.Data.Data[i];
                var kItem=this.HistoryData.Data[i];
                if (value==null || kItem==null) continue;

                var left=xOffset;
                var right=xOffset+dataWidth;
                if (right>chartBottom) break;

                var y=this.ChartFrame.GetYFromData(value);
                var bUp=false;
                if (kItem.Close>=kItem.Open)
                {
                    bUp=true;
                    this.Canvas.fillStyle=this.UpColor;
                }
                else
                {
                    this.Canvas.fillStyle=this.DownColor;
                }
                
                var height=ToFixedRect(y-yBottom);  //高度调整为整数
                if (bUp && (this.KLineDrawType==1 || this.KLineDrawType==2 || this.KLineDrawType==3)) //空心柱子
                {
                    this.Canvas.strokeStyle=this.UpColor;
                    this.Canvas.beginPath();
                    this.Canvas.rect(ToFixedPoint(yBottom),ToFixedPoint(left),height,ToFixedRect(dataWidth));
                    this.Canvas.stroke();
                }
                else
                {
                    this.Canvas.fillRect(yBottom,ToFixedRect(left),height,ToFixedRect(dataWidth));
                }
            }
        }
        else    //太细了直接话线
        {
            for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
            {
                var value=this.Data.Data[i];
                var kItem=this.HistoryData.Data[i];
                if (value==null || kItem==null) continue;

                var y=this.ChartFrame.GetYFromData(value);
                var x=this.ChartFrame.GetXFromIndex(j);
                if (x>chartBottom) break;

                if (kItem.Close>kItem.Open)
                    this.Canvas.strokeStyle=this.UpColor;
                else
                    this.Canvas.strokeStyle=this.DownColor;

                var x=this.ChartFrame.GetXFromIndex(j);
                this.Canvas.beginPath();
                this.Canvas.moveTo(y,ToFixedPoint(x));
                this.Canvas.lineTo(yBottom,ToFixedPoint(x));
                this.Canvas.stroke();
            }
        }
    }

    this.GetMaxMin=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var range={};
        range.Min=0;
        range.Max=null;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i];
            if (range.Max==null) range.Max=value;

            if (range.Max<value) range.Max=value;
        }

        return range;
    }
}

// VERTLINE(HIGH>=HHV(HIGH,20),1)表示在创20天新高画垂直虚线。
// 支持横屏
function ChartVericaltLine()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='ChartVericaltLine';    //类名
    this.LineWidth=2;
    this.LineCap;

    this.Draw=function()
    {
        var isHScreen=this.ChartFrame.IsHScreen==true;
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var border=this.GetBorder();
        var xPointCount=this.ChartFrame.XPointCount;

        if (isHScreen)
        {
            var top=border.RightEx;
            var bottom=border.LeftEx;
            var xOffset=border.TopEx+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
        }
        else
        {
            var top=border.TopEx;
            var bottom=border.BottomEx;
            var xOffset=border.LeftEx+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
        }

        this.Canvas.save();
        this.Canvas.strokeStyle=this.Color;
        if (this.LineType) this.Canvas.setLineDash(this.LineType);
        if (this.LineCap) this.Canvas.lineCap = this.LineCap;
        
        this.Canvas.beginPath();
        var lineWidth=this.Canvas.lineWidth;
        if (this.LineWidth>0) 
        {
            lineWidth=this.LineWidth * GetDevicePixelRatio();
            this.Canvas.lineWidth=lineWidth;
        }
        var drawCount=0;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var item=this.Data.Data[i];
            if (!item) continue;

            var center=xOffset+dataWidth/2;
            center=ToFixedPoint2(lineWidth, center);
            if (isHScreen)
            {
                this.Canvas.moveTo(top,center);
                this.Canvas.lineTo(bottom,center);
            }
            else
            {
                this.Canvas.moveTo(center, top);
                this.Canvas.lineTo(center,bottom);
            }
            
            ++drawCount;
        }

        if (drawCount>0) this.Canvas.stroke();

        this.Canvas.restore();
    }

    this.GetMaxMin=function()
    {
        return { Min:null, Max:null };
    }
}

//HORLINE 支持横屏 
function ChartHorizontalLine()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='ChartHorizontalLine';    //类名
    this.LineWidth=2;
    this.LineCap;
    this.ExtendType=0;   //1=表示向左延长，2=表示向右延长，3=表示左右延长

    this.Draw=function()
    {
        var isHScreen=this.ChartFrame.IsHScreen==true;
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var border=this.GetBorder();
        
        var xPointCount=this.ChartFrame.XPointCount;
        if (isHScreen)
        {
            var left=border.TopEx;
            var right=border.BottomEx;
            var xOffset=border.TopEx+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
        }
        else
        {
            var left=border.LeftEx
            var right=border.RightEx;
            var xOffset=border.LeftEx+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
        }
        
        this.Canvas.save();
        this.Canvas.strokeStyle=this.Color;
        if (this.LineType) this.Canvas.setLineDash(this.LineType);
        if (this.LineCap) this.Canvas.lineCap = this.LineCap;
        
        this.Canvas.beginPath();
        var lineWidth=this.Canvas.lineWidth;
        if (this.LineWidth>0) 
        {
            lineWidth=this.LineWidth * GetDevicePixelRatio();
            this.Canvas.lineWidth=lineWidth;
        }
        var drawCount=0;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var item=this.Data.Data[i];
            if (!item) continue;
            if (!IFrameSplitOperator.IsNumber(item)) continue;

            var y=this.ChartFrame.GetYFromData(item);
            y=ToFixedPoint2(lineWidth, y);
            var center=xOffset+dataWidth/2;
            center=ToFixedPoint2(lineWidth, center);
            if (this.ExtendType==3) //左右延长
            {
                if (isHScreen)
                {
                    this.Canvas.moveTo(y, left);
                    this.Canvas.lineTo(y, right);
                }
                else
                {
                    this.Canvas.moveTo(left, y);
                    this.Canvas.lineTo(right, y);
                }
                
            }
            else if (this.ExtendType==1) //左延长
            {
                if (isHScreen)
                {
                    this.Canvas.moveTo(y, left);
                    this.Canvas.lineTo(y, center);
                }
                else
                {
                    this.Canvas.moveTo(left, y);
                    this.Canvas.lineTo(center, y);
                }
                
            }
            else    //右延长
            {
                if (isHScreen)
                {
                    this.Canvas.moveTo(y, center);
                    this.Canvas.lineTo(y, right);
                }
                else
                {
                    this.Canvas.moveTo(center, y);
                    this.Canvas.lineTo(right, y);
                }
                
            }

            ++drawCount;
        }

        if (drawCount>0) this.Canvas.stroke();

        this.Canvas.restore();
    }
}



//线段 多数据(一个X点有多条Y数据) 支持横屏
function ChartLineMultiData()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='ChartLineMultiData';    //类名
    this.Color="rgb(255,193,37)"; //线段颜色

    this.Draw=function()
    {
        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        if (!this.Data || !this.Data.Data) return;

        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var chartright=this.ChartBorder.GetRight();
        if (isHScreen) chartright=this.ChartBorder.GetBottom();
        var xPointCount=this.ChartFrame.XPointCount;

        var bFirstPoint=true;
        var drawCount=0;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var aryValue=this.Data.Data[i];
            if (aryValue==null) continue;

            var x=this.ChartFrame.GetXFromIndex(j);
            if (x>chartright) break;

            for(var index in aryValue)
            {
                var value =aryValue[index].Value;
                
                var y=this.ChartFrame.GetYFromData(value);

                if (bFirstPoint)
                {
                    this.Canvas.strokeStyle=this.Color;
                    this.Canvas.beginPath();
                    if (isHScreen) this.Canvas.moveTo(y,x);
                    else this.Canvas.moveTo(x,y);
                    bFirstPoint=false;
                }
                else
                {
                    if (isHScreen) this.Canvas.lineTo(y,x);
                    else this.Canvas.lineTo(x,y);
                }

                ++drawCount;
            }
        }

        if (drawCount>0)
            this.Canvas.stroke();
    }

    this.GetMaxMin=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var range={};
        range.Min=null;
        range.Max=null;

        if(!this.Data || !this.Data.Data) return range;

        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var aryValue=this.Data.Data[i];
            if (aryValue==null) continue;

            for(var index in aryValue)
            {
                var value=aryValue[index].Value;
                if (range.Max==null) range.Max=value;
                if (range.Min==null) range.Min=value;

                if (range.Max<value) range.Max=value;
                if (range.Min>value) range.Min=value;
            }
        }

        return range;
    }
}

//柱子 支持横屏
function ChartStickLine()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='ChartStickLine';    //类名
    this.Color="rgb(255,193,37)";               //线段颜色
    this.BarType=0;                     //柱子类型 0=实心 1=空心 -1=画虚线空心柱
    this.LineDotted=[3,3];              //虚线设置
    this.Width=0;                       //柱子宽度 0=1 3,50=k线宽度 101=K线宽度+间距宽度

    this.SetEmptyBar=function()         //设置空心柱子
    {
        if (this.BarType!=1 && this.BarType!=-1) return false;

        this.Canvas.lineWidth=GetDevicePixelRatio();
        this.Canvas.strokeStyle=this.Color;
        var emptyBGColor=g_JSChartResource.EmptyBarBGColor;
        if (emptyBGColor) this.Canvas.fillStyle=emptyBGColor;
        if (this.BarType==-1)   //虚线
        {
            this.Canvas.setLineDash(this.LineDotted);   //虚线
        }

        return true;
    }

    this.IsEmptyBar=function()
    {
        return (this.BarType==1 || this.BarType==-1);
    }

    this.Draw=function()
    {
        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        if (!this.Data || !this.Data.Data) return;

        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var chartright=this.ChartBorder.GetRight();
        var zoomIndex=this.ChartFrame.ZoomIndex;
        if (isHScreen) chartright=this.ChartBorder.GetBottom();
        var xPointCount=this.ChartFrame.XPointCount;
        var xOffset=this.ChartBorder.GetLeft()+distanceWidth/2.0+2.0;
        if (isHScreen) xOffset=this.ChartBorder.GetTop()+distanceWidth/2.0+2.0;

        this.Canvas.save();
        var bFillBar=false;
        var bFillKLine=false;
        var emptyBGColor=g_JSChartResource.EmptyBarBGColor;

        if(this.Width==0)
        {
            this.SetEmptyBar();
        }
        else if (this.Width==3 || this.Width==50)   //3和50 K线宽度
        {
            if (dataWidth>=4)
            {
                bFillKLine=true; 
                this.SetEmptyBar();
                if (!this.IsEmptyBar()) this.Canvas.fillStyle=this.Color; 
                this.Canvas.strokeStyle=this.Color;
            }
            else    //太细了 画竖线
            {
                this.Canvas.lineWidth=GetDevicePixelRatio();
                this.Canvas.strokeStyle=this.Color;
            }  
        }
        else if (this.Width==101)
        {
            var lineWidth=dataWidth+distanceWidth+1*GetDevicePixelRatio();
            this.Canvas.lineWidth=lineWidth;
            this.Canvas.strokeStyle=this.Color;
        }
        else if (this.Width<=3)
        {
            var minWidth=2*GetDevicePixelRatio();
            var barWidth=dataWidth*(this.Width/3);
            if (barWidth<minWidth) barWidth=minWidth;
            this.SetEmptyBar();
            if (!this.IsEmptyBar()) this.Canvas.fillStyle=this.Color;
            bFillBar=true;
        }
        else
        {
            var barWidth=this.Width*GetDevicePixelRatio()+dataWidth;
            this.SetEmptyBar();
            if (!this.IsEmptyBar()) this.Canvas.fillStyle=this.Color;
            bFillBar=true;
        }

        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var value=this.Data.Data[i];
            if (value==null) continue;

            var price=value.Value;
            var price2=value.Value2;
            if (price2==null) price2=0;

            var x=this.ChartFrame.GetXFromIndex(j);
            var y=this.ChartFrame.GetYFromData(price);
            var y2=this.ChartFrame.GetYFromData(price2);

            if (x>chartright) break;

            if (bFillBar)
            {
                if (isHScreen)
                {
                    var left=x-barWidth/2;
                    var width=barWidth;
                    if (this.IsEmptyBar()) //空心
                    {
                        this.Canvas.beginPath();
                        this.Canvas.rect(ToFixedPoint(Math.min(y,y2)),ToFixedPoint(left),ToFixedRect(Math.abs(y-y2)),ToFixedRect(width));
                        this.Canvas.stroke();
                    }
                    else
                    {
                        this.Canvas.fillRect(ToFixedRect(Math.min(y,y2)),ToFixedRect(left),ToFixedRect(Math.abs(y-y2)),ToFixedRect(width));
                    }
                }
                else
                {
                    var left=x-barWidth/2;
                    var width=barWidth;
                    if (left+width>chartright) width=chartright-left; //不要超过右边框子
                    if (this.IsEmptyBar()) //空心
                    {
                        if (emptyBGColor)
                            this.Canvas.fillRect(ToFixedRect(left),ToFixedRect(Math.min(y,y2)),ToFixedRect(width),ToFixedRect(Math.abs(y-y2)));

                        this.Canvas.beginPath();
                        this.Canvas.rect(ToFixedPoint(left),ToFixedPoint(Math.min(y,y2)),ToFixedRect(width),ToFixedRect(Math.abs(y-y2)));
                        this.Canvas.stroke();
                    }
                    else
                    {
                        this.Canvas.fillRect(ToFixedRect(left),ToFixedRect(Math.min(y,y2)),ToFixedRect(width),ToFixedRect(Math.abs(y-y2)));
                    }
                }
            }
            else if (bFillKLine)
            {
                if (this.IsEmptyBar())    //空心
                {
                    if (isHScreen)
                    {
                        this.Canvas.beginPath();
                        this.Canvas.rect(ToFixedPoint(Math.min(y,y2)),ToFixedPoint(xOffset),ToFixedRect(Math.abs(y-y2)),ToFixedRect(dataWidth));
                        this.Canvas.stroke();
                    }
                    else
                    {
                        if (emptyBGColor)
                            this.Canvas.fillRect(ToFixedRect(xOffset),ToFixedRect(Math.min(y,y2)),ToFixedRect(dataWidth),ToFixedRect(Math.abs(y-y2)));

                        this.Canvas.beginPath();
                        this.Canvas.rect(ToFixedPoint(xOffset),ToFixedPoint(Math.min(y,y2)),ToFixedRect(dataWidth),ToFixedRect(Math.abs(y-y2)));
                        this.Canvas.stroke();
                    }
                }
                else
                {
                    if (isHScreen) 
                        this.Canvas.fillRect(ToFixedRect(Math.min(y,y2)),ToFixedRect(xOffset),ToFixedRect(Math.abs(y-y2)),ToFixedRect(dataWidth));
                    else 
                        this.Canvas.fillRect(ToFixedRect(xOffset),ToFixedRect(Math.min(y,y2)),ToFixedRect(dataWidth),ToFixedRect(Math.abs(y-y2)));
                }
            }
            else
            {
                if (isHScreen)
                {
                    this.Canvas.beginPath();
                    this.Canvas.moveTo(y,ToFixedPoint(x));
                    this.Canvas.lineTo(y2,ToFixedPoint(x));
                    this.Canvas.stroke();
                }
                else
                {
                    var xFix=parseInt(x.toString())+0.5;
                    this.Canvas.beginPath();
                    this.Canvas.moveTo(xFix,y);  
                    this.Canvas.lineTo(xFix,y2);
                    this.Canvas.stroke();
                }
            }
        }

        this.Canvas.restore();
    }

    this.GetMaxMin=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var range={};
        range.Min=null;
        range.Max=null;

        if(!this.Data || !this.Data.Data) return range;

        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var data=this.Data.Data[i];
            if (data == null) continue;
            var value2=data.Value2;
            if (value2==null) value2=0;
            if (data==null || isNaN(data.Value) ||isNaN(value2)) continue;

            var valueMax=Math.max(data.Value,value2);
            var valueMin=Math.min(data.Value,value2);
            
            if (range.Max==null) range.Max=valueMax;
            if (range.Min==null) range.Min=valueMin;

            if (range.Max<valueMax) range.Max=valueMax;
            if (range.Min>valueMin) range.Min=valueMin;
        }

        return range;
    }
}

function ChartText()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='ChartText';    //类名
    this.TextFont="14px 微软雅黑";

    this.Draw=function()
    {
        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        if (!this.Data || !this.Data.Data) return;

        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var chartright=this.ChartBorder.GetRight();
        var xPointCount=this.ChartFrame.XPointCount;

        for(var i in this.Data.Data)
        {
            var value=this.Data.Data[i];
            if (value==null) continue;

            var price=value.Value;
            var position=value.Position;

            if (position=='Left')
            {
                var x=this.ChartFrame.GetXFromIndex(0);
                var y=this.ChartFrame.GetYFromData(price);

                if (x>chartright) continue;

                this.Canvas.textAlign='left';
                this.Canvas.textBaseline='middle';
                this.Canvas.fillStyle=value.Color;
                this.Canvas.font=this.TextFont;
                this.Canvas.fillText(value.Message,x,y);
            }

        }

    }

    this.GetMaxMin=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var range={};
        range.Min=null;
        range.Max=null;

        if(!this.Data || !this.Data.Data) return range;

        for(var i in this.Data.Data)
        {
            var data=this.Data.Data[i];
            if (data==null || isNaN(data.Value)) continue;

            var value=data.Value;
            
            if (range.Max==null) range.Max=value;
            if (range.Min==null) range.Min=value;

            if (range.Max<value) range.Max=value;
            if (range.Min>value) range.Min=value;
        }

        return range;
    }
}

/*
    文字输出 支持横屏
    数组(Data)不为null的数据中输出 this.Text文本
*/
function ChartSingleText()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='ChartSingleText';    //类名
    this.Color="rgb(255,193,37)";           //线段颜色
    this.TextFont="14px 微软雅黑";           //线段宽度
    this.Text;
    this.TextAlign='left';
    this.Direction=0;       //0=middle 1=bottom 2=top
    this.YOffset=0;         //连线      
    this.Position;          //指定输出位置
    this.IconFont;          //Iconfont
    this.IconSize=
    { 
        Max: g_JSChartResource.DRAWICON.Icon.MaxSize, Min:g_JSChartResource.DRAWICON.Icon.MinSize, //图标的最大最小值
        Zoom:{ Type:g_JSChartResource.DRAWICON.Icon.Zoom.Type , Value:g_JSChartResource.DRAWICON.Icon.Zoom.Value }, //放大倍数
        YOffset:g_JSChartResource.DRAWICON.Icon.YOffset //Direction==2的向下偏移
    };  

    this.TextSize=
    {
        Max: g_JSChartResource.DRAWICON.Text.MaxSize, Min:g_JSChartResource.DRAWICON.Text.MinSize, //字体的最大最小值
        Zoom:{ Type:g_JSChartResource.DRAWICON.Text.Zoom.Type , Value:g_JSChartResource.DRAWICON.Text.Zoom.Value }, //放大倍数
        FontName:g_JSChartResource.DRAWICON.Text.FontName,
        YOffset:g_JSChartResource.DRAWICON.Text.YOffset
    }

    this.ReloadResource=function(resource)
    {
        if (this.Name=="DRAWTEXT")
        {
            this.TextSize=
            {
                Max: g_JSChartResource.DRAWTEXT.MaxSize, Min:g_JSChartResource.DRAWTEXT.MinSize, //字体的最大最小值
                Zoom:{ Type:g_JSChartResource.DRAWTEXT.Zoom.Type , Value:g_JSChartResource.DRAWTEXT.Zoom.Value }, //放大倍数
                FontName:g_JSChartResource.DRAWTEXT.FontName,
                YOffset:g_JSChartResource.DRAWTEXT.YOffset
            }
        }
        else if (this.Name=="DRAWNUMBER")
        {
            this.TextSize=
            {
                Max: g_JSChartResource.DRAWNUMBER.MaxSize, Min:g_JSChartResource.DRAWNUMBER.MinSize, //字体的最大最小值
                Zoom:{ Type:g_JSChartResource.DRAWNUMBER.Zoom.Type , Value:g_JSChartResource.DRAWNUMBER.Zoom.Value }, //放大倍数
                FontName:g_JSChartResource.DRAWNUMBER.FontName,
                YOffset:g_JSChartResource.DRAWNUMBER.YOffset
            }
        }
    }

    this.SuperGetMaxMin=this.GetMaxMin;
    this.GetMaxMin=function()
    {
        if ( this.Name=="DRAWTEXT_FIX" || this.Name=='DRAWNUMBER_FIX')  //固定位置的 没有大小值
        {
            return { Min:null,Max:null };
        }
        else if (this.Name=="DRAWTEXTREL" || this.Name=="DRAWTEXTABS")
        {
            return { Min:null,Max:null };
        }
        else
        {
            return this.SuperGetMaxMin();
        }
    }

    this.DrawRectText=function()
    {
        if (!this.DrawData) return;
        var isHScreen=(this.ChartFrame.IsHScreen===true)
        var border=this.ChartFrame.GetBorder();
        

        if (this.Name=="DRAWTEXTREL")
        {
            if (isHScreen)
            {
                var height=border.RightTitle-border.LeftEx;
                var width=border.BottomEx-border.TopEx;
                var x=this.DrawData.Point.X/1000*width+border.TopEx;
                var y=border.RightTitle-this.DrawData.Point.Y/1000*width;
            }
            else
            {
                var width=border.RightEx-border.LeftEx;
                var height=border.BottomEx-border.TopTitle;
                var x=this.DrawData.Point.X/1000*width+border.LeftEx;
                var y=this.DrawData.Point.Y/1000*height+border.TopTitle;
            }
            
        }
        else if (this.Name=="DRAWTEXTABS")
        {
            if (isHScreen)
            {
                var x=this.DrawData.Point.X+border.TopEx;
                var y=border.RightTitle-this.DrawData.Point.Y;
            }
            else
            {
                var x=this.DrawData.Point.X+border.LeftEx;
                var y=this.DrawData.Point.Y+border.TopTitle;
            }
        }
        else
        {
            return;
        }

        if (this.Direction==1) this.Canvas.textBaseline='bottom';
        else if (this.Direction==2) this.Canvas.textBaseline='top';
        else this.Canvas.textBaseline='middle';
        this.Canvas.textAlign='left';
        this.Canvas.font=this.TextFont;
        this.Canvas.fillStyle=this.Color;
        this.DrawText(this.DrawData.Text,x,y,isHScreen);
    }

    this.Draw=function()
    {
        if (!this.IsShow) return;

        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        if (this.Name=="DRAWTEXTREL" || this.Name=="DRAWTEXTABS")
        {
            this.DrawRectText();
            return;
        }

        if (this.Position) 
        {
            this.DrawPosition();
            return;
        }

        if (!this.Data || !this.Data.Data) return;

        var isHScreen=(this.ChartFrame.IsHScreen===true)
        var isMinute=this.IsMinuteFrame();
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var xOffset=this.ChartBorder.GetLeft()+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
        var chartright=this.ChartBorder.GetRight();
        var top=this.ChartBorder.GetTopEx();
        var bottom=this.ChartBorder.GetBottomEx();
        if (isHScreen) 
        {
            chartright=this.ChartBorder.GetBottom();
            top=this.ChartBorder.GetRightEx();
            bottom=this.ChartBorder.GetLeftEx();
            xOffset=this.ChartBorder.GetTop()+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
        }
        var xPointCount=this.ChartFrame.XPointCount;

        var isArrayText=Array.isArray(this.Text);
        var pixelTatio = GetDevicePixelRatio();
        
        if (this.Direction==1) this.Canvas.textBaseline='bottom';
        else if (this.Direction==2) this.Canvas.textBaseline='top';
        else this.Canvas.textBaseline='middle';

        if (this.IconFont)
        {
            this.Color=this.IconFont.Color;
            this.Text=this.IconFont.Text;

            var iconSize=this.GetDynamicIconSize(dataWidth,distanceWidth,this.IconSize.Max,this.IconSize.Min,this.IconSize.Zoom);
            this.Canvas.font=iconSize+'px '+this.IconFont.Family;
        }
        else
        {
            this.TextFont=this.GetDynamicFont(dataWidth,distanceWidth,this.TextSize.Max,this.TextSize.Min,this.TextSize.Zoom,this.TextSize.FontName);
            this.Canvas.font=this.TextFont;
        }

        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        //for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i];
            if (value==null) continue;

            if (isMinute)
            {
                var x=this.ChartFrame.GetXFromIndex(j);
            }
            else
            {
                var left=xOffset;
                var right=xOffset+dataWidth;
                if (right>chartright) break;
                var x=left+(right-left)/2;
            }
            
            var y=this.ChartFrame.GetYFromData(value);

            if (x>chartright) break;

            this.Canvas.textAlign=this.TextAlign;
            this.Canvas.fillStyle=this.Color;
            
            if (this.YOffset>0 && this.Direction>0)
            {
                var yPrice=y;

                this.Canvas.setLineDash([5,10]);
                this.Canvas.strokeStyle=this.Color;
                this.Canvas.beginPath();
                if (isHScreen)
                {
                    if (this.Direction==1) 
                    {
                        y=top-this.YOffset*pixelTatio;
                        yPrice+=5*pixelTatio;
                    }
                    else 
                    {
                        y=bottom+this.YOffset*pixelTatio;
                        yPrice-=5*pixelTatio;
                    }
                    this.Canvas.moveTo(ToFixedPoint(yPrice),ToFixedPoint(x));
                    this.Canvas.lineTo(ToFixedPoint(y),ToFixedPoint(x));
                }
                else
                {
                    if (this.Direction==1) 
                    {
                        y=top+this.YOffset*pixelTatio;
                        yPrice+=5*pixelTatio;
                    }
                    else 
                    {
                        y=bottom-this.YOffset*pixelTatio;
                        yPrice-=5*pixelTatio;
                    }

                    this.Canvas.moveTo(ToFixedPoint(x),ToFixedPoint(yPrice));
                    this.Canvas.lineTo(ToFixedPoint(x),ToFixedPoint(y));
                }
                this.Canvas.stroke();
                this.Canvas.setLineDash([]);
            }

            if (isArrayText)
            {
                var text=this.Text[i];
                if (!text) continue;
                if (this.Name=='DRAWNUMBER')
                {
                    if (this.Direction==1) y-=g_JSChartResource.DRAWABOVE.YOffset*pixelTatio;
                    else if (this.Direction==2) y+=this.TextSize.YOffset*pixelTatio;
                }
                this.DrawText(text,x,y,isHScreen);
            }
            else
            {
                if (this.Name=='DRAWICON')
                {
                    if (this.Direction==1) y-=g_JSChartResource.DRAWABOVE.YOffset*pixelTatio;
                    else if (this.Direction==2) 
                    {
                        if (this.IconFont) y+=this.IconSize.YOffset*pixelTatio;
                        else y+=this.TextSize.YOffset*pixelTatio;
                    }
                }
                else if (this.Name=="DRAWTEXT")
                {
                    if (this.Direction==1) y-=g_JSChartResource.DRAWABOVE.YOffset*pixelTatio;
                    else if (this.Direction==2) y+=this.TextSize.YOffset*pixelTatio;
                }
                //JSConsole.Chart.Log('[ChartSingleText::Draw] ',this.Direction,this.Text)
                this.DrawText(this.Text,x,y,isHScreen);
            }
        }
    }

    this.DrawPosition=function()    //绘制在指定位置上
    {
        if (!this.Text) return;
        var isHScreen=(this.ChartFrame.IsHScreen===true)
        if (isHScreen)
        {
            var y=this.ChartBorder.GetRightEx()-this.ChartBorder.GetWidthEx()*this.Position.Y;
            var x=this.ChartBorder.GetTop()+this.ChartBorder.GetHeight()*this.Position.X;
        }
        else
        {
            var x=this.ChartBorder.GetLeft()+this.ChartBorder.GetWidth()*this.Position.X;
            var y=this.ChartBorder.GetTopEx()+this.ChartBorder.GetHeightEx()*this.Position.Y;
        }

        this.Canvas.fillStyle=this.Color;

        //TYPE:0为左对齐,1为右对齐.
        if (this.Position.Type==0) this.Canvas.textAlign='left';
        else if (this.Position.Type==1) this.Canvas.textAlign='right';
        else this.Canvas.textAlign='center';

        if (this.Direction==1) this.Canvas.textBaseline='bottom';
        else if (this.Direction==2) this.Canvas.textBaseline='top';
        else this.Canvas.textBaseline='middle';

        if (Array.isArray(this.Text))
        {
            if (!this.Data || !this.Data.Data) return;
            var xPointCount=this.ChartFrame.XPointCount;
            for(var i=this.Data.DataOffset,j=0; i<this.Data.Data.length && j<xPointCount; ++i,++j)
            {
                var text=this.Text[i];
                if (text)
                {
                    this.DrawText(text,x,y,isHScreen);
                    break;
                }
            }
        }
        else
        {
            this.DrawText(this.Text,x,y,isHScreen);
        }
    }

    this.DrawText=function(text,x,y,isHScreen)
    {
        if (isHScreen)
        {
            this.Canvas.save(); 
            this.Canvas.translate(y, x);
            this.Canvas.rotate(90 * Math.PI / 180);
            this.Canvas.fillText(text,0,0);
            this.Canvas.restore();
        }
        else
        {
            this.Canvas.fillText(text,x,y);
            /*
            var textWidth=this.Canvas.measureText(text).width;
            var rectSize=textWidth*2;
            var xRect,yRect;
            if (this.Direction==1)  yRect=y-rectSize;   //底部
            else if (this.Direction==2) yRect=y;    //顶部
            else yRect=y-rectSize/2; //居中

            if (this.TextAlign=='left') xRect=x;
            else if (this.TextAlign=='right') xRect=x-rectSize;
            else xRect=x-rectSize/2;

            this.Canvas.fillStyle=this.Color;
            this.Canvas.fillRect(xRect,yRect,rectSize,rectSize);

            this.Canvas.fillStyle='rgb(255,255,255)';
            this.Canvas.fillText(text,x,y);
            */
            
        }
    }
}

//直线 水平直线 只有1个数据
function ChartStraightLine()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='ChartStraightLine';    //类名
    this.Color="rgb(255,193,37)";   //线段颜色

    this.Draw=function()
    {
        if (!this.Data || !this.Data.Data) return;
        if (this.Data.Data.length!=1) return;

        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var chartright=this.ChartBorder.GetRight();
        var xPointCount=this.ChartFrame.XPointCount;

        var yValue=this.Data.Data[0];
        var y=this.ChartFrame.GetYFromData(yValue);
        var xLeft=this.ChartFrame.GetXFromIndex(0);
        var xRight=this.ChartFrame.GetXFromIndex(xPointCount-1);

        var yFix=parseInt(y.toString())+0.5;
        this.Canvas.beginPath();
        this.Canvas.moveTo(xLeft,yFix);
        this.Canvas.lineTo(xRight,yFix);
        this.Canvas.strokeStyle=this.Color;
        this.Canvas.stroke();
    }

    this.GetMaxMin=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var range={};
        range.Min=null;
        range.Max=null;

        if (!this.Data || !this.Data.Data) return range;
        if (this.Data.Data.length!=1) return range;

        range.Min=this.Data.Data[0];
        range.Max=this.Data.Data[0];

        return range;
    }
}

/*  
    水平面积 只有1个数据
    Data 数据结构 
    Value, Value2  区间最大最小值
    Color=面积的颜色
    Title=标题 TitleColor=标题颜色
    支持横屏
*/
function ChartStraightArea() 
{
    this.newMethod = IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='ChartStraightArea';    //类名
    this.Color = "rgb(255,193,37)";   //线段颜色
    this.Font ='11px 微软雅黑';

    this.Draw = function () 
    {
        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        if (!this.Data || !this.Data.Data) return;

        if (this.ChartFrame.IsHScreen===true)
        {
            this.HScreenDraw();
            return;
        }

        var dataWidth = this.ChartFrame.DataWidth;
        var distanceWidth = this.ChartFrame.DistanceWidth;
        var chartright = this.ChartBorder.GetRight();
        var bottom = this.ChartBorder.GetBottom();
        var left = this.ChartBorder.GetLeft();
        var xPointCount = this.ChartFrame.XPointCount;

        var xRight = this.ChartFrame.GetXFromIndex(xPointCount - 1);

        for(let i in this.Data.Data)
        {
            let item=this.Data.Data[i];
            if (item==null || isNaN(item.Value) || isNaN(item.Value2)) continue;
            if (item.Color==null) continue;

            let valueMax=Math.max(item.Value,item.Value2);
            let valueMin=Math.min(item.Value,item.Value2);

            var yTop=this.ChartFrame.GetYFromData(valueMax);
            var yBottom=this.ChartFrame.GetYFromData(valueMin);

            this.Canvas.fillStyle = item.Color;
            this.Canvas.fillRect(ToFixedRect(left), ToFixedRect(yTop), ToFixedRect(xRight - left), ToFixedRect(yBottom - yTop));

            if(item.Title && item.TitleColor)
            {
              this.Canvas.textAlign = 'right';
              this.Canvas.textBaseline = 'middle';
              this.Canvas.fillStyle = item.TitleColor;
              this.Canvas.font = this.Font;
              let y = yTop + (yBottom - yTop)/2;
              this.Canvas.fillText(item.Title, xRight, y);
            }
        }
    }

    this.HScreenDraw=function()
    {
        var bottom = this.ChartBorder.GetBottom();
        var top=this.ChartBorder.GetTop();
        var height=this.ChartBorder.GetHeight();

        for(let i in this.Data.Data)
        {
            let item=this.Data.Data[i];
            if (item==null || isNaN(item.Value) || isNaN(item.Value2)) continue;
            if (item.Color==null) continue;

            let valueMax=Math.max(item.Value,item.Value2);
            let valueMin=Math.min(item.Value,item.Value2);

            var yTop=this.ChartFrame.GetYFromData(valueMax);
            var yBottom=this.ChartFrame.GetYFromData(valueMin);

            this.Canvas.fillStyle = item.Color;
            this.Canvas.fillRect(ToFixedRect(yBottom), ToFixedRect(top), ToFixedRect(yTop-yBottom),ToFixedRect(height));

            if(item.Title && item.TitleColor)
            {
                var xText=yTop + (yBottom - yTop)/2;
                var yText=bottom;
                this.Canvas.save(); 
                this.Canvas.translate(xText, yText);
                this.Canvas.rotate(90 * Math.PI / 180);

                this.Canvas.textAlign = 'right';
                this.Canvas.textBaseline = 'middle';
                this.Canvas.fillStyle = item.TitleColor;
                this.Canvas.font = this.Font;
                this.Canvas.fillText(item.Title, 0, -2);

                this.Canvas.restore();
            }
        }
    }

    this.GetMaxMin=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var range={};
        range.Min=null;
        range.Max=null;

        if (!this.Data || !this.Data.Data) return range;
        
        for (let i in this.Data.Data)
        {
          let item = this.Data.Data[i];
            if (item==null || isNaN(item.Value) || isNaN(item.Value2)) continue;

            let valueMax=Math.max(item.Value,item.Value2);
            let valueMin=Math.min(item.Value,item.Value2);

            if (range.Max==null) range.Max=valueMax;
            if (range.Min==null) range.Min=valueMin;

            if (range.Max<valueMax) range.Max=valueMax;
            if (range.Min>valueMin) range.Min=valueMin;
        }

        return range;
    }
}

//分钟线 支持横屏
function ChartMinutePriceLine()
{
    this.newMethod=ChartLine;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='ChartMinutePriceLine';    //类名
    this.YClose;
    this.IsDrawArea=true;    //是否画价格面积图
    this.AreaColor='rgba(0,191,255,0.1)';
    this.IsShowLead=false;
    this.LeadData;
    this.UpColor=g_JSChartResource.UpBarColor;
    this.DownColor=g_JSChartResource.DownBarColor;

    this.BeforeOpenData;    //盘前数据 Data:[] 数据, TotalCount:一共的数据个数
    this.BeforeLineColor=g_JSChartResource.Minute.Before.LineColor;
    this.BeforeAvPriceColor=g_JSChartResource.Minute.Before.AvPriceColor;
    this.BeforePoint={ Color:g_JSChartResource.Minute.Before.Point.Color, Radius:g_JSChartResource.Minute.Before.Point.Radius };

    this.AfterCloseData;    //盘后数据

    this.MultiDayBeforeOpenData;    //多日分时图 盘前数据 数组 1天一个
    this.MultiDayAfterCloseData;    //多日分时图 盘后数据 数组 1天一个

    this.ColorLineData;     //自定义价格线分段颜色
    this.Source;            //原始分钟数据

    this.Draw=function()
    {
        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        if (!this.IsShow) return;

        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var chartright=this.ChartBorder.GetRight();
        if (isHScreen===true) chartright=this.ChartBorder.GetBottom();
        var xPointCount=this.ChartFrame.XPointCount;
        var minuteCount=this.ChartFrame.MinuteCount;
        var bottom=this.ChartBorder.GetBottomEx();
        var left=this.ChartBorder.GetLeftEx();
        var data=this.Data;

        this.DrawBeforeOpen();   //盘前
        this.DrawMultiDayBeforeOpen();

        if (this.IsShowLead) this.DrawLead();   //领先指标

        if (!data) return;

        var bFirstPoint=true;
        var ptFirst={}; //第1个点
        var ptLast={};  //最后一个点
        var drawCount=0;
        for(var i=data.DataOffset,j=0;i<data.Data.length && j<xPointCount;++i,++j)
        {
            var value=null;
            value=data.Data[i];
            if (value==null) continue;

            var x=this.ChartFrame.GetXFromIndex(j);
            var y=this.ChartFrame.GetYFromData(value);

            if (bFirstPoint)
            {
                this.Canvas.strokeStyle=this.Color;
                this.Canvas.beginPath();
                if (isHScreen) this.Canvas.moveTo(y,x);
                else this.Canvas.moveTo(x,y);
                bFirstPoint=false;
                ptFirst={X:x,Y:y};
            }
            else
            {
                if (isHScreen) this.Canvas.lineTo(y,x);
                else this.Canvas.lineTo(x,y);
            }

            ptLast.X=x;
            ptLast.Y=y;
            ptLast.Price=value;

            ++drawCount;

            if (drawCount>=minuteCount) //上一天的数据和这天地数据线段要断开
            {
                bFirstPoint=true;
                this.Canvas.stroke();
                if (this.IsDrawArea)   //画面积
                {
                    if (isHScreen)
                    {
                        this.Canvas.lineTo(left,x);
                        this.Canvas.lineTo(left,ptFirst.X);
                        this.SetFillStyle(this.AreaColor,this.ChartBorder.GetRightEx(),bottom,this.ChartBorder.GetLeftEx(),bottom);
                    }
                    else
                    {
                        this.Canvas.lineTo(x,bottom);
                        this.Canvas.lineTo(ptFirst.X,bottom);
                        this.SetFillStyle(this.AreaColor, left,this.ChartBorder.GetTopEx(), left,bottom);
                    }
                    
                    this.Canvas.fill();
                }
                drawCount=0;
            }
        }

        if (drawCount>0)
        {
            this.Canvas.stroke();
            if (this.IsDrawArea)   //画面积
            {
                if (isHScreen)
                {
                    this.Canvas.lineTo(left,x);
                    this.Canvas.lineTo(left,ptFirst.X);
                    this.SetFillStyle(this.AreaColor,this.ChartBorder.GetRightEx(),bottom,this.ChartBorder.GetLeftEx(),bottom);
                }
                else
                {
                    this.Canvas.lineTo(x,bottom);
                    this.Canvas.lineTo(ptFirst.X,bottom);
                    this.SetFillStyle(this.AreaColor,left,this.ChartBorder.GetTopEx(), left,bottom);
                }

                this.Canvas.fill();
            }
        }

        this.DrawColorLine();
        this.DrawAfterClose();      //收盘集合竞价
        this.DrawMultiDayAfterClose();

        if (this.HQChart)
        {
            var event=this.HQChart.GetEventCallback(JSCHART_EVENT_ID.ON_DRAW_MINUTE_LAST_POINT);
            if (event)
            {
                var data={ LastPoint:{X:ptLast.X, Y:ptLast.Y}, Price:ptLast.Price };
                event.Callback(event,data,this);
            }
        }
    }

    //画领先指标
    this.DrawLead=function()
    {
        if (!this.LeadData) return;

        var isHScreen=(this.ChartFrame.IsHScreen===true);
        //if (isHScreen) return;
        //var dataWidth=this.ChartFrame.DataWidth;
        //var distanceWidth=this.ChartFrame.DistanceWidth;
        //var chartright=this.ChartBorder.GetRight();
       
        var xPointCount=this.ChartFrame.XPointCount;
        var minuteCount=this.ChartFrame.MinuteCount;
        var bottom=this.ChartBorder.GetBottomEx();
        var top=this.ChartBorder.GetTopEx();
        if (isHScreen===true) top=this.ChartBorder.GetRightEx();

        if (xPointCount>minuteCount) return;

        var aryLead=[]; //{X: Value:}
        var max=null, min=null;
        var yCenter=this.ChartFrame.GetYFromData(this.YClose);
        var leadHeight=(yCenter-top)/3;
        var data=this.LeadData;
        for(var i=data.DataOffset,j=0;i<data.Data.length && j<xPointCount;++i,++j)
        {
            var value=data.Data[i];
            if (!IFrameSplitOperator.IsNumber(value)) continue;
            if (value==0) continue;
            var x=this.ChartFrame.GetXFromIndex(j);

            if (max==null || max<value) max=value;
            if (min==null || min>value) min=value;

            aryLead.push({X:x, Value:value})
        }

        if (aryLead.length<=0) return;
        var maxValue=Math.max(Math.abs(max),Math.abs(min));

        for(var i in aryLead)
        {
            var item=aryLead[i];
            if (item.Value>0) this.Canvas.strokeStyle=this.UpColor;
            else this.Canvas.strokeStyle=this.DownColor;

            var y=yCenter-(item.Value*leadHeight/maxValue);
            var x=ToFixedPoint(item.X);
            this.Canvas.beginPath();
            if (isHScreen===true)
            {
                this.Canvas.moveTo(yCenter,x);
                this.Canvas.lineTo(y,x);
            }
            else
            { 
                this.Canvas.moveTo(x,yCenter);
                this.Canvas.lineTo(x,y);
            }
            this.Canvas.stroke();
        }
    }

    this.DrawBeforeOpen=function()
    {
        if (this.ChartBorder.LeftExtendWidth<10) return;
        if (!this.BeforeOpenData) return;

        this.DrawCallAuction(-1, this.BeforeOpenData, true); 
    }

    this.DrawAfterClose=function()
    {
        if (this.ChartBorder.RightExtendWidth<10) return;
        if (!this.AfterCloseData) return;

        this.DrawCallAuction(-1, this.AfterCloseData, false); 
    }

    this.DrawMultiDayBeforeOpen=function()
    {
        if (this.ChartBorder.MultiDayMinute.Count<=1 || this.ChartBorder.MultiDayMinute.Left<=0) return;
        if (!this.MultiDayBeforeOpenData) return;

        for(var i in this.MultiDayBeforeOpenData)
        {
            var dayItem=this.MultiDayBeforeOpenData[i];
            this.DrawCallAuction(parseInt(i), dayItem, true);
        }
    }

    this.DrawMultiDayAfterClose=function()
    {
        if (this.ChartBorder.MultiDayMinute.Count<=1 || this.ChartBorder.MultiDayMinute.Right<=0) return;
        if (!this.MultiDayAfterCloseData) return;

        for(var i in this.MultiDayAfterCloseData)
        {
            var dayItem=this.MultiDayAfterCloseData[i];
            this.DrawCallAuction(parseInt(i), dayItem, false);
        }
    }

    this.DrawCallAuction=function(indexDay, callAutionData, isBeforeOpen)
    {
        if (!callAutionData) return;

        callAutionData.Index=indexDay;
        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var bFirstPoint=true;
        var drawCount=0;
        var callAutionInfo={ TotalCount:callAutionData.TotalCount };
        if (callAutionData.Ver==3.0)   //均线
        {
            for(var i in callAutionData.Data)
            {
                var item=callAutionData.Data[i];
                if (!item || !IFrameSplitOperator.IsNumber(item.AvPrice)) continue;
    
                if (isBeforeOpen)
                {
                    var x=this.ChartFrame.GetLeftExtendXFromIndex(i,callAutionData);
                    var y=this.ChartFrame.GetLeftExtendYFromData(item.AvPrice);
                }
                else
                {
                    var x=this.ChartFrame.GetRightExtendXFromIndex(i,callAutionData);
                    var y=this.ChartFrame.GetRightExtendYFromData(item.AvPrice);
                }
                
                if (bFirstPoint)
                {
                    this.Canvas.strokeStyle=this.BeforeAvPriceColor;
                    this.Canvas.beginPath();
                    if (isHScreen) this.Canvas.moveTo(y,x);
                    else this.Canvas.moveTo(x,y);
                    bFirstPoint=false;
                }
                else
                {
                    if (isHScreen) this.Canvas.lineTo(y,x);
                    else this.Canvas.lineTo(x,y);
                }
    
                ++drawCount;
            }
    
            if (drawCount>0)
            {
                this.Canvas.stroke();
            }
        }

        var bFirstPoint=true;
        var drawCount=0;
        var aryPoint=[];
        for(var i in callAutionData.Data)
        {
            var item=callAutionData.Data[i];
            if (!item || !IFrameSplitOperator.IsNumber(item.Price)) 
            {
                if (i==0 && isBeforeOpen && IFrameSplitOperator.IsNumber(this.YClose))
                {
                    var x=this.ChartFrame.GetLeftExtendXFromIndex(i,callAutionData);
                    var y=this.ChartFrame.GetLeftExtendYFromData(this.YClose);

                    this.Canvas.strokeStyle=this.BeforeLineColor;
                    this.Canvas.beginPath();
                    if (isHScreen) this.Canvas.moveTo(y,x);
                    else this.Canvas.moveTo(x,y);
                    bFirstPoint=false;
                }

                continue;
            }

            if (isBeforeOpen)
            {
                var x=this.ChartFrame.GetLeftExtendXFromIndex(i,callAutionData);
                var y=this.ChartFrame.GetLeftExtendYFromData(item.Price);
            }
            else
            {
                var x=this.ChartFrame.GetRightExtendXFromIndex(i,callAutionData);
                var y=this.ChartFrame.GetRightExtendYFromData(item.Price);
            }

            if (bFirstPoint)
            {
                this.Canvas.strokeStyle=this.BeforeLineColor;
                this.Canvas.beginPath();
                if (isHScreen) this.Canvas.moveTo(y,x);
                else this.Canvas.moveTo(x,y);
                bFirstPoint=false;

                aryPoint.push({X:x, Y:y });
            }
            else
            {
                if (isHScreen) this.Canvas.lineTo(y,x);
                else this.Canvas.lineTo(x,y);

                aryPoint.push({X:x, Y:y });
            }

            ++drawCount;
        }

        if (drawCount>0)
        {
            this.Canvas.stroke();
        }

        if (callAutionData.Ver==2.0 && this.BeforePoint.Radius>0)
        {
            this.Canvas.fillStyle=this.BeforePoint.Color;
            for(var i in aryPoint)
            {
                var item=aryPoint[i];

                this.Canvas.beginPath();
                if (isHScreen)  this.Canvas.arc(item.Y, item.X, this.BeforePoint.Radius, 0, 2 * Math.PI);
                else  this.Canvas.arc(item.X, item.Y, this.BeforePoint.Radius, 0, 2 * Math.PI);
                this.Canvas.fill();
            }
            
        }
    }

    this.FindColorLineItem=function(minuteItem)
    {
        if (!minuteItem || !this.ColorLineData) return null;

        for(var i in this.ColorLineData)
        {
            var item=this.ColorLineData[i];
            if (item.Date==minuteItem.Date && (minuteItem.Time>=item.Start && minuteItem.Time<=item.End))
            {
                return item;
            }
        }

        return null;
    }

    this.DrawColorLine=function()
    {
        if (!this.ColorLineData|| !this.Source || !this.Data) return;
        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var border=this.ChartBorder.GetBorder();
        var xPointCount=this.ChartFrame.XPointCount;
        var minuteCount=this.ChartFrame.MinuteCount;
        var data=this.Data;

        var bFirstPoint=true;
        var ptLast={};  //最后一个点
        var ptFirst={};
        var drawCount=0;
        var preColor=null;
        this.Canvas.save();

        for(var i=data.DataOffset,j=0;i<data.Data.length && j<xPointCount;++i,++j)
        {
            var value=null;
            value=data.Data[i];
            var item=this.Source.Data[i];
            if (!value || !item) continue;

            var colorItem=this.FindColorLineItem(item);
            if (!colorItem)
            {
                if (drawCount>0)
                {
                    this.Canvas.stroke();
                    bFirstPoint=true;
                }
                continue;
            }

            if (preColor && preColor!=colorItem.Color)
            {
                this.Canvas.stroke();
                bFirstPoint=true;

                /*
                this.Canvas.strokeStyle=colorItem.Color;
                this.Canvas.beginPath();
                if (isHScreen) this.Canvas.moveTo(ptLast.Y,ptLast.X);
                else this.Canvas.moveTo(ptLast.X,ptLast.Y);
                bFirstPoint=false;
                preColor=colorItem.Color;
                */
            }

            var x=this.ChartFrame.GetXFromIndex(j);
            var y=this.ChartFrame.GetYFromData(value);

            if (bFirstPoint)
            {
                this.Canvas.strokeStyle=colorItem.Color;
                if (IFrameSplitOperator.IsNumber(colorItem.LineWidth))
                    this.Canvas.lineWidth=colorItem.LineWidth;

                this.Canvas.beginPath();
                if (isHScreen) this.Canvas.moveTo(y,x);
                else this.Canvas.moveTo(x,y);
                bFirstPoint=false;
                ptFirst={X:x,Y:y};
                preColor=colorItem.Color;
            }
            else
            {
                if (isHScreen) this.Canvas.lineTo(y,x);
                else this.Canvas.lineTo(x,y);
            }

            ptLast.X=x;
            ptLast.Y=y;
            ptLast.Price=value;

            ++drawCount;
        }

        if (drawCount>0)
        {
            this.Canvas.stroke();
        }

        this.Canvas.restore();
    }

    this.GetMaxMin=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var range={};
        if (this.YClose==null) return range;
        if (!this.IsShow) return range;

        range.Min=this.YClose;
        range.Max=this.YClose;

        if (this.ChartBorder.LeftExtendWidth>10 && this.BeforeOpenData)
        {
            for(var i in this.BeforeOpenData.Data)
            {
                var item=this.BeforeOpenData.Data[i];
                if (!item) continue;
                if (IFrameSplitOperator.IsNumber(item.Price))
                {
                    if (range.Max==null) range.Max=item.Price;
                    if (range.Min==null) range.Min=item.Price;
    
                    if (range.Max<item.Price) range.Max=item.Price;
                    if (range.Min>item.Price) range.Min=item.Price;
                }
                
                //集合竞价均线统计
                if (this.BeforeOpenData.Ver==3.0 && IFrameSplitOperator.IsNumber(item.AvPrice))
                {
                    if (range.Max==null) range.Max=item.AvPrice;
                    if (range.Min==null) range.Min=item.AvPrice;
    
                    if (range.Max<item.AvPrice) range.Max=item.AvPrice;
                    if (range.Min>item.AvPrice) range.Min=item.AvPrice;
                }
            }
        }
        

        var data=this.Data;
        for(var i=data.DataOffset,j=0;i<data.Data.length && j<xPointCount;++i,++j)
        {
            var value=null;
            value=data.Data[i];
            
            if (value==null) continue;

            if (range.Max==null) range.Max=value;
            if (range.Min==null) range.Min=value;

            if (range.Max<value) range.Max=value;
            if (range.Min>value) range.Min=value;
        }

        if (range.Max==this.YClose && range.Min==this.YClose)
        {
            range.Max=this.YClose+this.YClose*0.1;
            range.Min=this.YClose-this.YClose*0.1;
            return range;
        }

        var distance=Math.max(Math.abs(this.YClose-range.Max),Math.abs(this.YClose-range.Min));
        range.Max=this.YClose+distance;
        range.Min=this.YClose-distance;

        return range;
    }
}

//分钟线叠加 支持横屏
function ChartOverlayMinutePriceLine()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.Color="rgb(65,105,225)";
    this.MainData;                  //主图数据
    this.MainYClose;                //主图股票的前收盘价
    this.SourceData;                //原始数据

    this.ClassName="ChartOverlayMinutePriceLine";
    this.Title;
    this.Symbol;                    //叠加的股票代码
    this.YClose;                    //叠加的股票前收盘
    this.Status=OVERLAY_STATUS_ID.STATUS_NONE_ID;

    this.Draw=function()
    {
        if (!this.Data) return;
        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var chartright=this.ChartBorder.GetRight();
        if (isHScreen===true) chartright=this.ChartBorder.GetBottom();
        var xPointCount=this.ChartFrame.XPointCount;
        var minuteCount=this.ChartFrame.MinuteCount;

        var bFirstPoint=true;
        var drawCount=0;
        var xOffset=0;
        for(var i=this.Data.DataOffset+xOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i].Close;
            if (value==null) continue;
            var showValue=value/this.YClose*this.MainYClose;

            var x=this.ChartFrame.GetXFromIndex(j);
            var y=this.ChartFrame.GetYFromData(showValue);

            if (bFirstPoint)
            {
                this.Canvas.strokeStyle=this.Color;
                this.Canvas.beginPath();
                if (isHScreen) this.Canvas.moveTo(y,x);
                else this.Canvas.moveTo(x,y);
                bFirstPoint=false;
            }
            else
            {
                if (isHScreen) this.Canvas.lineTo(y,x);
                else this.Canvas.lineTo(x,y);
            }

            ++drawCount;

            if (drawCount>=minuteCount) //上一天的数据和这天地数据线段要断开
            {
                bFirstPoint=true;
                this.Canvas.stroke();
                drawCount=0;
            }
        }

        if (drawCount>0) this.Canvas.stroke();
    }

    this.GetMaxMin=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var range={};
        if (this.YClose==null) return range;

        range.Min=this.MainYClose;
        range.Max=this.MainYClose;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i].Close;
            if (value==null) continue;
            var value=value/this.YClose*this.MainYClose;
            if (range.Max==null) range.Max=value;
            if (range.Min==null) range.Min=value;

            if (range.Max<value) range.Max=value;
            if (range.Min>value) range.Min=value;
        }

        if (range.Max==this.MainYClose && range.Min==this.MainYClose)
        {
            range.Max=this.MainYClose+this.MainYClose*0.1;
            range.Min=this.MainYClose-this.MainYClose*0.1;
            return range;
        }

        var distance=Math.max(Math.abs(this.MainYClose-range.Max),Math.abs(this.MainYClose-range.Min));
        range.Max=this.MainYClose+distance;
        range.Min=this.MainYClose-distance;

        //JSConsole.Chart.Log(`[ChartOverlayMinutePriceLine::GetMaxMin] max=${range.Max} min=${range.Min}`);
        return range;
    }
}

//分钟信息地雷 支持横屏
function ChartMinuteInfo()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName="ChartMinuteInfo";
    this.Data=new Map()  //Map key=date-time, value=[{Date, Time, Title, Type, ID:}]
    this.SourceData;
    this.ChartMinutePrice;
    this.YClose;
    this.HQChartBorder;

    this.TextColor=g_JSChartResource.MinuteInfo.TextColor;
    this.Font=g_JSChartResource.MinuteInfo.Font;
    this.PointColor=g_JSChartResource.MinuteInfo.PointColor;
    this.LineColor=g_JSChartResource.MinuteInfo.LineColor;
    this.TextBGColor=g_JSChartResource.MinuteInfo.TextBGColor;
    this.PixelTatio = GetDevicePixelRatio(); //获取设备的分辨率
    this.TextHeight=20;

    this.TextRectCache=[];
    this.InfoDrawCache=[];
    this.FrameBottom;
    this.FrameTop;
    this.FrameLeft;
    this.FrameRight;
    this.YOffset=5;
    this.IsHScreen=false;
    this.IsDrawFull=false;   //是否全屏画

    this.TooltipRect=[];    //Rect 

    this.SetOption=function(option)
    {
        if (option.TextColor) this.TextColor=option.TextColor;
        if (option.TextBGColor) this.TextBGColor=option.TextBGColor;
        if (option.Font) this.Font=option.Font;
        if (option.PointColor) this.PointColor=option.PointColor;
        if (option.LineColor) this.LineColor=option.LineColor;
        if (option.TextHeight>0) this.TextHeight=option.TextHeight;
        if (option.IsDrawFull==true) this.IsDrawFull=true;
    }

    this.Draw=function()
    {
        this.TooltipRect=[];
        if (!this.ChartMinutePrice) return;
        if (!this.Data || this.Data.size<=0) return;

        this.TextRectCache=[];
        this.InfoDrawCache=[];
        this.PixelTatio=GetDevicePixelRatio();
        this.YOffset=5*this.PixelTatio;
        this.IsHScreen=(this.ChartFrame.IsHScreen===true);
        
        var xPointCount=this.ChartFrame.XPointCount;
        var minuteCount=this.ChartFrame.MinuteCount;

        this.FrameBottom=this.ChartBorder.GetBottom();
        if (this.IsDrawFull && this.HQChartBorder) this.FrameBottom=this.HQChartBorder.GetBottom();
        this.FrameTop=this.ChartBorder.GetTop();
        this.FrameLeft=this.ChartBorder.GetLeft();
        this.FrameRight=this.ChartBorder.GetRight();
        if (this.IsHScreen)
        {
            this.FrameRight=this.ChartBorder.GetBottom();
            this.FrameLeft=this.ChartBorder.GetTop();
            this.FrameBottom=this.ChartBorder.GetLeft();
            this.FrameTop=this.ChartBorder.GetRight();
        }

        this.YClose=this.ChartMinutePrice.YClose;

        var data=this.ChartMinutePrice.Source;

        for(var i=data.DataOffset,j=0;i<data.Data.length && j<xPointCount;++i,++j)
        {
            var item=data.Data[i];
            if (!item) continue;

            var dateTime=item.DateTime;
            if (!this.Data.has(dateTime)) continue;
            if (this.IsHScreen) 
                this.CalcuateInfoHScreenPosition(this.Data.get(dateTime), j, item);
            else 
                this.CalcuateInfoPosition(this.Data.get(dateTime), j, item);
        }

        for(var i in this.InfoDrawCache)
        {
            var item=this.InfoDrawCache[i];
            this.DrawInfoLines(item);
        }

        for(var i in this.InfoDrawCache)
        {
            var item=this.InfoDrawCache[i];
            this.DrawInfoText(item);
            if (!this.IsHScreen) 
            {
                var rtBorder=item.Border;
                var textRect=new Rect(rtBorder.X,rtBorder.Y,rtBorder.Width,rtBorder.Height);
                var tooltipData={ Data:{ Item:item }, Rect:textRect };
                this.TooltipRect.push(tooltipData);
            }
        }

        this.TextRectCache=[];
        this.InfoDrawCache=[];
    }

    this.CalcuateInfoPosition=function(infoItem, index, minuteItem)
    {
        if (!infoItem  || !infoItem.Data || infoItem.Data.length<=0) return;

        var showItem=infoItem.Data[0];
        this.Canvas.font = this.Font;
        var textWidth=this.Canvas.measureText(showItem.Title).width+4*this.PixelTatio;
        var textHeight=this.TextHeight*this.PixelTatio;

        var x=this.ChartFrame.GetXFromIndex(index);
        var y;
        if (IFrameSplitOperator.IsNumber(showItem.Price)) y=this.ChartFrame.GetYFromData(showItem.Price);
        else y=this.ChartFrame.GetYFromData(minuteItem.Close);
        x=ToFixedPoint(x);

        var isDrawLeft=x<(this.FrameLeft+Math.abs(this.FrameLeft-this.FrameRight)/2);

        var ARRAY_OFFSET=[2,4,6,8,3,5,7];
        var offset=textHeight+ARRAY_OFFSET[index%ARRAY_OFFSET.length]*this.PixelTatio;
        var yData= 
        { 
            Y: 
            [
                {Value:y+(textHeight+this.YOffset), Offset: offset},
                {Value:y-(2*textHeight+this.YOffset), Offset:-offset}
            ]
        };

        if (minuteItem.Close<this.YClose) 
            yData.Y=yData.Y.reverse();
        
        var rtBorder={X:x, Y:null, Width:textWidth,Height:textHeight};
        if (!isDrawLeft) rtBorder.X-=rtBorder.Width;

        this.FixTextRect(rtBorder,yData);
        var InfoDrawItem= {  Border:rtBorder, Start:{X:x,Y:y}, IsLeft:isDrawLeft, Title:showItem.Title, Date:showItem.Date, Time:showItem.Time };
        if (showItem.Content) InfoDrawItem.Content=showItem.Content;
        if (showItem.Link) InfoDrawItem.Link=showItem.Link;
        if (showItem.Color) InfoDrawItem.Color=showItem.Color;
        if (showItem.BGColor) InfoDrawItem.BGColor=showItem.BGColor;

        this.InfoDrawCache.push(InfoDrawItem);
        this.TextRectCache.push(rtBorder);
    }

    this.CalcuateInfoHScreenPosition=function(infoItem, index, minuteItem)
    {
        if (!infoItem  || !infoItem.Data || infoItem.Data.length<=0) return;

        var showItem=infoItem.Data[0];
        this.Canvas.font = this.Font;
        var textHeight=this.Canvas.measureText(showItem.Title).width+4*this.PixelTatio;
        var textWidth=this.TextHeight*this.PixelTatio;

        var y=this.ChartFrame.GetXFromIndex(index);
        var x;
        if (IFrameSplitOperator.IsNumber(showItem.Price)) x=this.ChartFrame.GetYFromData(showItem.Price);
        else x=this.ChartFrame.GetYFromData(minuteItem.Close);
        y=ToFixedPoint(y);

        var isDrawLeft=y<(this.FrameLeft+Math.abs(this.FrameLeft-this.FrameRight)/2);

        var ARRAY_OFFSET=[2,4,6,8,3,5,7];
        var offset=textWidth+ARRAY_OFFSET[index%ARRAY_OFFSET.length]*this.PixelTatio;
        var xData= 
        { 
            X: 
            [
                {Value:x+(textWidth+this.YOffset), Offset: offset},
                {Value:x-(2*textWidth+this.YOffset), Offset:-offset}
            ]
        };

        if (minuteItem.Close>this.YClose) 
            xData.X=xData.X.reverse();
        
        var rtBorder={X:null, Y:y, Width:textWidth,Height:textHeight};
        if (!isDrawLeft) rtBorder.Y-=rtBorder.Height;
        
        this.FixHScreenTextRect(rtBorder,xData);
        var InfoDrawItem={ Border:rtBorder, Start:{X:x,Y:y}, IsLeft:isDrawLeft, Title:showItem.Title };

        this.InfoDrawCache.push(InfoDrawItem);
        this.TextRectCache.push(rtBorder);
    }

    this.DrawInfoLines=function(item)
    {
        var rtBorder=item.Border;
        var isDrawLeft=item.IsLeft;
        this.Canvas.strokeStyle=this.LineColor;
        this.Canvas.beginPath();
        this.Canvas.moveTo(ToFixedPoint(item.Start.X),item.Start.Y);
        if (isDrawLeft) 
        {
            this.Canvas.lineTo(ToFixedPoint(item.Start.X),rtBorder.Y);
        }
        else 
        {
            if (this.IsHScreen) this.Canvas.lineTo(rtBorder.X,rtBorder.Y+rtBorder.Height);
            else this.Canvas.lineTo(ToFixedPoint(item.Start.X),rtBorder.Y);
        }
        this.Canvas.stroke();

        this.Canvas.fillStyle = this.PointColor;
        this.Canvas.beginPath();
        this.Canvas.arc(item.Start.X,item.Start.Y, 5, 0, 2 * Math.PI);
        this.Canvas.closePath();
        this.Canvas.fill();
    }

    this.DrawInfoText=function(item)
    {
        var rtBorder=item.Border;
        var x=rtBorder.X, y=rtBorder.Y;
        if (item.BGColor) this.Canvas.fillStyle=item.BGColor
        else this.Canvas.fillStyle=this.TextBGColor;
        this.Canvas.fillRect(x, y, rtBorder.Width,rtBorder.Height);

        this.Canvas.strokeStyle=this.LineColor;
        this.Canvas.beginPath();
        this.Canvas.rect(x,y,rtBorder.Width,rtBorder.Height);
        this.Canvas.stroke();

        if (this.IsHScreen)
        {
            this.Canvas.save(); 
            this.Canvas.translate(rtBorder.X,rtBorder.Y);
            this.Canvas.rotate(90 * Math.PI / 180);
            x=0;y=0;
        }

        this.Canvas.textAlign = 'left'
        this.Canvas.textBaseline = 'middle';
        if (item.Color) this.Canvas.fillStyle=item.Color;
        else this.Canvas.fillStyle = this.TextColor;
        this.Canvas.font = this.Font;
        if (this.IsHScreen) this.Canvas.fillText(item.Title, x+2*this.PixelTatio, y-rtBorder.Width/2);
        else this.Canvas.fillText(item.Title, x+2*this.PixelTatio, y+rtBorder.Height/2);

        if (this.IsHScreen) this.Canvas.restore();
    }

    this.FixTextRect=function(rect,yData) 
    {
        for(var k in yData.Y)
        {
            var yItem=yData.Y[k];
            rect.Y=yItem.Value;

            var y;
            for(var j=0;j<10;++j)
            {
                var isOverlap=false;
                for(var i in this.TextRectCache)
                {
                    var item=this.TextRectCache[i];
                    if (this.IsOverlap(item, rect))
                    {
                        isOverlap=true;
                        break;
                    }
                }

                if (isOverlap==false) return;

                y=rect.Y;
                y+=yItem.Offset;
                if (y+rect.Height>this.FrameBottom || y<this.FrameTop) break;

                rect.Y=y;
            }
        }
    }

    this.FixHScreenTextRect=function(rect,xData) 
    {
        for(var k in xData.X)
        {
            var xItem=xData.X[k];
            rect.X=xItem.Value;

            var x;
            for(var j=0;j<10;++j)
            {
                var isOverlap=false;
                for(var i in this.TextRectCache)
                {
                    var item=this.TextRectCache[i];
                    if (this.IsOverlap(item, rect))
                    {
                        isOverlap=true;
                        break;
                    }
                }

                if (isOverlap==false) return;

                x=rect.X;
                x+=xItem.Offset;
                if (x+rect.Width<this.FrameBottom || x>this.FrameTop) break;

                rect.X=x;
            }
        }
    }

    this.IsOverlap=function(rc1, rc2)
    {
        if (rc1.X + rc1.Width  > rc2.X &&rc2.X + rc2.Width  > rc1.X &&rc1.Y + rc1.Height > rc2.Y &&rc2.Y + rc2.Height > rc1.Y)
            return true;
        else
            return false;
    }

    this.GetMaxMin=function()
    {
        var range={Min:null, Max:null};
        return range;
    }

    this.GetTooltipData=function(x,y,tooltip)
    {
        for(var i in this.TooltipRect)
        {
            var item=this.TooltipRect[i];
            if (!item.Rect) continue;
            var rect=item.Rect;
            this.Canvas.beginPath();
            this.Canvas.rect(rect.X,rect.Y,rect.Width,rect.Height);
            if (this.Canvas.isPointInPath(x,y))
            {
                //JSConsole.Chart.Log('[ChartMinuteInfo::GetTooltipData] info ', item);
                tooltip.Data=item;
                tooltip.ChartPaint=this;
                tooltip.Type=3; //异动信息
                return true;
            }
        }

        return false;
    }
}

//MACD森林线 支持横屏
function ChartMACD()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName="ChartMACD";
    this.UpColor=g_JSChartResource.UpBarColor;
    this.DownColor=g_JSChartResource.DownBarColor;
    this.LineWidth=1;

    this.Draw=function()
    {
        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        if (this.ChartFrame.IsHScreen===true)
        {
            this.HScreenDraw();
            return;
        }

        var isMinute=this.IsMinuteFrame();
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var border=this.ChartBorder.GetBorder();
        var xOffset=border.LeftEx+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
        var chartright=border.RightEx;
        var xPointCount=this.ChartFrame.XPointCount;
        var lockRect=this.GetLockRect();
        if (lockRect) chartright=lockRect.Left;

        var bFirstPoint=true;
        var drawCount=0;
        var yBottom=this.ChartFrame.GetYFromData(0);
        
        var lineWidth=this.LineWidth*GetDevicePixelRatio();
        if (this.LineWidth==50) lineWidth=dataWidth;
        else if (lineWidth>dataWidth) lineWidth=dataWidth;
        
        var backupLineWidth=this.Canvas.lineWidth;
        this.Canvas.lineWidth=lineWidth;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        //for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i];
            if (value==null) continue;

            if (isMinute)
            {
                var x=this.ChartFrame.GetXFromIndex(j);
            }
            else
            {
                var left=xOffset;
                var right=xOffset+dataWidth;
                if (right>chartright) break;
                var x=left+(right-left)/2;
            }
            var y=this.ChartFrame.GetYFromData(value);

            if (x>chartright) break;

            var xFix=ToFixedPoint2(lineWidth, x); //毛边修正
            this.Canvas.beginPath();
            this.Canvas.moveTo(xFix,yBottom);
            this.Canvas.lineTo(xFix,y);

            if (value>=0) this.Canvas.strokeStyle=this.UpColor;
            else this.Canvas.strokeStyle=this.DownColor;
            this.Canvas.stroke();
            this.Canvas.closePath();
        }

        this.Canvas.lineWidth=backupLineWidth;
    }

    this.HScreenDraw=function()
    {
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var border=this.ChartBorder.GetHScreenBorder();
        var chartright=border.BottomEx;
        var xPointCount=this.ChartFrame.XPointCount;
        var lockRect=this.GetLockRect();
        if (lockRect) chartright=lockRect.Top;

        var yBottom=this.ChartFrame.GetYFromData(0);

        var lineWidth=this.LineWidth*GetDevicePixelRatio();
        if (this.LineWidth==50) lineWidth=dataWidth;
        else if (lineWidth>dataWidth) lineWidth=dataWidth;

        var backupLineWidth=this.Canvas.lineWidth;
        this.Canvas.lineWidth=lineWidth;
        
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i];
            if (value==null) continue;

            var x=this.ChartFrame.GetXFromIndex(j);
            var y=this.ChartFrame.GetYFromData(value);

            if (x>chartright) break;

            this.Canvas.beginPath();
            this.Canvas.moveTo(yBottom,ToFixedPoint(x));
            this.Canvas.lineTo(y,ToFixedPoint(x));

            if (value>=0) this.Canvas.strokeStyle=this.UpColor;
            else this.Canvas.strokeStyle=this.DownColor;
            this.Canvas.stroke();
            this.Canvas.closePath();
        }

        this.Canvas.lineWidth=backupLineWidth;
    }
}

//柱子
function ChartBar()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName="ChartBar";
    this.UpBarColor=g_JSChartResource.UpBarColor;
    this.DownBarColor=g_JSChartResource.DownBarColor;

    this.Draw=function()
    {
        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var chartright=this.ChartBorder.GetRight();
        var xPointCount=this.ChartFrame.XPointCount;
        var xOffset=this.ChartBorder.GetLeft()+distanceWidth/2.0+2.0;

        var bFirstPoint=true;
        var drawCount=0;
        var yBottom=this.ChartFrame.GetYFromData(0);
        if (dataWidth>=4)
        {
            yBottom=ToFixedRect(yBottom);   //调整为整数
            for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
            {
                var value=this.Data.Data[i];
                if (value==null || value==0) continue;

                var left=xOffset;
                var right=xOffset+dataWidth;
                if (right>chartright) break;

                var x=this.ChartFrame.GetXFromIndex(j);
                var y=this.ChartFrame.GetYFromData(value);


                if (value>0) this.Canvas.fillStyle=this.UpBarColor;
                else this.Canvas.fillStyle=this.DownBarColor;

                //高度调整为整数
                var height=ToFixedRect(Math.abs(yBottom-y));
                if(yBottom-y>0) y=yBottom-height;
                else y=yBottom+height;
                this.Canvas.fillRect(ToFixedRect(left),y,ToFixedRect(dataWidth),height);
            }
        }
        else    //太细了 直接画柱子
        {
            for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
            {
                var value=this.Data.Data[i];
                if (value==null || value==0) continue;

                var left=xOffset;
                var right=xOffset+dataWidth;
                if (right>chartright) break;

                var x=this.ChartFrame.GetXFromIndex(j);
                var y=this.ChartFrame.GetYFromData(value);

                if (value>0) this.Canvas.strokeStyle=this.UpBarColor;
                else this.Canvas.strokeStyle=this.DownBarColor;

                this.Canvas.beginPath();
                this.Canvas.moveTo(ToFixedPoint(x),y);
                this.Canvas.lineTo(ToFixedPoint(x),yBottom);
                this.Canvas.stroke();
            }
        }
    }

    this.GetMaxMin=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var range={};
        range.Min=0;
        range.Max=null;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i];
            if (range.Max==null) range.Max=value;
            if (range.Max<value) range.Max=value;
        }

        return range;
    }
}
// 面积图
function ChartBand()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;
    this.IsDrawFirst = true;

    this.ClassName="ChartBand";
    this.FirstColor = g_JSChartResource.Index.LineColor[0];
    this.SecondColor = g_JSChartResource.Index.LineColor[1];

    this.Draw=function()
    {
        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var xPointCount=this.ChartFrame.XPointCount;
        var xOffset=this.ChartBorder.GetLeft()+distanceWidth/2.0+2.0;
        var x = 0;
        var y = 0;
        var y2 = 0;
        var firstlinePoints = [];
        var secondlinePoints = [];
        for(var i=this.Data.DataOffset,j=0; i<this.Data.Data.length && j<xPointCount;++i, ++j, xOffset+=(dataWidth+distanceWidth))
        {
            firstlinePoints = [];
            secondlinePoints = [];
            for(;i<this.Data.Data.length && j<xPointCount;++i, ++j, xOffset+=(dataWidth+distanceWidth))
            {
                var value=this.Data.Data[i];
                if (value==null || value.Value==null || value.Value2 == null) break;
                x=this.ChartFrame.GetXFromIndex(j);
                y=this.ChartFrame.GetYFromData(value.Value);
                y2 = this.ChartFrame.GetYFromData(value.Value2);
                firstlinePoints.push({x:x,y:y});
                secondlinePoints.push({x:x,y:y2});
            }

            if (firstlinePoints.length>1 && secondlinePoints.length>1)
            {
                this.DrawBand(firstlinePoints, secondlinePoints);
            }
        }
    }

    this.DrawBand=function(aryFrist, arySecond)
    {
        this.Canvas.save();
        this.Canvas.beginPath();
        for(var i=0;i<aryFrist.length;++i)
        {
            if (i == 0)
                this.Canvas.moveTo(aryFrist[i].x, aryFrist[i].y);
            else
                this.Canvas.lineTo(aryFrist[i].x, aryFrist[i].y);
        }

        for (var i = arySecond.length-1; i >= 0; --i)
        {
            this.Canvas.lineTo(arySecond[i].x, arySecond[i].y);
        }  
        this.Canvas.closePath();
        this.Canvas.clip();

        this.Canvas.moveTo(aryFrist[0].x, this.ChartBorder.GetBottom());
        for (var i = 0; i < aryFrist.length; ++i)
        {
            this.Canvas.lineTo(aryFrist[i].x, aryFrist[i].y);
        }
        this.Canvas.lineTo(aryFrist[aryFrist.length-1].x, this.ChartBorder.GetBottom());
        this.Canvas.closePath();
        this.Canvas.fillStyle = this.FirstColor;
        this.Canvas.fill();

        this.Canvas.beginPath();
        this.Canvas.moveTo(arySecond[0].x, this.ChartBorder.GetBottom());
        for (var i = 0; i < arySecond.length; ++i)
        {
            this.Canvas.lineTo(arySecond[i].x, arySecond[i].y);
        }
        this.Canvas.lineTo(arySecond[arySecond.length-1].x, this.ChartBorder.GetBottom());
        this.Canvas.closePath();
        this.Canvas.fillStyle = this.SecondColor;
        this.Canvas.fill();
        
        this.Canvas.restore();
    }


    this.GetMaxMin=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var range={};
        range.Min=null;
        range.Max=null;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i];
            if (value==null || value.Value==null || value.Value2 == null) continue;
            var maxData = value.Value>value.Value2?value.Value:value.Value2;
            var minData = value.Value<value.Value2?value.Value:value.Value2;
            if (range.Max==null) 
                range.Max = maxData;
            else if (range.Max < maxData)
                range.Max = maxData;
            
            if (range.Min==null)
                range.Min = minData;
            else if (range.Min > minData)
                range.Min = minData; 
        }

        return range;
    }
}

// 线段围成的面积图 支持横屏
function ChartLineArea()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;
    this.IsDrawFirst = true;    //面积图在K线前面画,否则回挡住K线的

    this.ClassName="ChartLineArea";
    this.Color='rgb(56,67,99)';
    this.IsHScreen=false;

    this.Draw=function()
    {
        this.IsHScreen=(this.ChartFrame.IsHScreen===true);

        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        if (!this.Data || !this.Data.Data) return;

        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var xPointCount=this.ChartFrame.XPointCount;
        var xOffset=this.ChartBorder.GetLeft()+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
        var x = 0, y = 0, y2 = 0;
        var aryPoint=[];
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var value=this.Data.Data[i];
            aryPoint[i]=null;
            if (value==null || value.Value==null || value.Value2 == null) continue;
            x=this.ChartFrame.GetXFromIndex(j);
            y=this.ChartFrame.GetYFromData(value.Value);
            y2 = this.ChartFrame.GetYFromData(value.Value2);

            if (this.IsHScreen)
                aryPoint[i]={ Line:{ X:y, Y:x }, Line2:{ X:y2, Y:x }};
            else
                aryPoint[i]={ Line:{ X:x, Y:y }, Line2:{ X:x, Y:y2 }};
        }

        this.Canvas.fillStyle = this.Color;
        var firstPoint=true;
        var pointCount=0;
        var aryLine2=[];
        for(var i in aryPoint)
        {
            var item=aryPoint[i];
            if (!item)
            {
                if (pointCount>0)
                {
                    for(var j=aryLine2.length-1; j>=0; --j)
                    {
                        var item2=aryLine2[j];
                        this.Canvas.lineTo(item2.Line2.X, item2.Line2.Y);
                    }
                    this.Canvas.closePath();
                    this.Canvas.fill();
                }

                firstPoint=true;
                pointCount=0;
                aryLine2=[];
                continue;
            }

            if (firstPoint)
            {
                this.Canvas.beginPath();
                this.Canvas.moveTo(item.Line.X, item.Line.Y);
                firstPoint=false;
            }
            else
            {
                this.Canvas.lineTo(item.Line.X, item.Line.Y);
            }

            aryLine2.push(item);
            ++pointCount;
        }

        if (pointCount>0)
        {
            for(var j=aryLine2.length-1; j>=0; --j)
            {
                var item2=aryLine2[j];
                this.Canvas.lineTo(item2.Line2.X, item2.Line2.Y);
            }
            this.Canvas.closePath();
            this.Canvas.fill();
        }
    }

    this.GetMaxMin=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var range={};
        range.Min=null;
        range.Max=null;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i];
            if (!value || value.Value==null || value.Value2 == null) continue;

            var maxData = value.Value>value.Value2?value.Value:value.Value2;
            var minData = value.Value<value.Value2?value.Value:value.Value2;

            if (range.Max==null)  range.Max = maxData;
            else if (range.Max < maxData) range.Max = maxData;
            
            if (range.Min==null) range.Min = minData;
            else if (range.Min > minData) range.Min = minData; 
        }

        return range;
    }
}

// 线段围成的面积图 支持横屏
function ChartFillRGN()
{
    this.newMethod=ChartLineArea;   //派生
    this.newMethod();
    delete this.newMethod;
    this.IsDrawFirst = true;    //面积图在K线前面画,否则回挡住K线的
    this.IsHScreen=false;

    this.ClassName="ChartFillRGN";

    this.DrawRGB=function(aryPoint)
    {
        var firstPoint=true;
        var pointCount=0;
        var aryLine2=[];
        var color=null;
        for(var i in aryPoint)
        {
            var item=aryPoint[i];
            if (!item || (color && item.Color!=color) )
            {
                if (pointCount>0)
                {
                    for(var j=aryLine2.length-1; j>=0; --j)
                    {
                        var item2=aryLine2[j];
                        this.Canvas.lineTo(item2.Line2.X, item2.Line2.Y);
                    }
                    this.Canvas.closePath();
                    this.Canvas.fillStyle = color;
                    this.Canvas.fill();
                }

                firstPoint=true;
                pointCount=0;
                aryLine2=[];
                color=null;
            }

            if (!item) continue;

            if (firstPoint)
            {
                this.Canvas.beginPath();
                this.Canvas.moveTo(item.Line.X, item.Line.Y);
                firstPoint=false;
                color=item.Color;
            }
            else
            {
               this.Canvas.lineTo(item.Line.X, item.Line.Y);
            }

            aryLine2.push(item);
            ++pointCount;
        }

        if (pointCount>0)
        {
            for(var j=aryLine2.length-1; j>=0; --j)
            {
                var item2=aryLine2[j];
                this.Canvas.lineTo(item2.Line2.X, item2.Line2.Y);
            }
            this.Canvas.closePath();
            this.Canvas.fillStyle = color;
            this.Canvas.fill();
        }
    }

    this.Draw=function()
    {
        this.IsHScreen=(this.ChartFrame.IsHScreen===true);

        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        if (!this.Data || !this.Data.Data) return;

        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var xPointCount=this.ChartFrame.XPointCount;
        var xOffset=this.ChartBorder.GetLeft()+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
        var x = 0, y = 0, y2 = 0;
        var aryPoint=[];    //点坐标
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var value=this.Data.Data[i];
            aryPoint[i]=null;
            if (value==null || value.Value==null || value.Value2 == null || !value.Color) continue;

            x=this.ChartFrame.GetXFromIndex(j);
            y=this.ChartFrame.GetYFromData(value.Value);
            y2 = this.ChartFrame.GetYFromData(value.Value2);

            if (this.IsHScreen)
                aryPoint[i]={ Line:{ X:y, Y:x }, Line2:{ X:y2, Y:x }, Color:value.Color };
            else
                aryPoint[i]={ Line:{ X:x, Y:y }, Line2:{ X:x, Y:y2 }, Color:value.Color };
        }

        this.DrawRGB(aryPoint);
    }
}

//支持横屏
//用法:FLOATRGN(PRICE,WIDTH,COND1,COLOR1,COND2,COLOR2...),以PRICE为基础填充宽度为WIDTH像素的区域,WIDTH为负则向下填充,当COND1条件满足时,用COLOR1颜色,当COND2条件满足时,用COLOR2颜色,否则不填充,从COND1之后的参数均可以省略,最多可以有10组条件
//例如:FLOATRGN(CLOSE,VOL/HHV(VOL,10)*15,CLOSE>OPEN,RGB(255,0,0),1,RGB(0,255,0)) 表示沿收盘价填充宽度为成交量的区域,区域最大宽度为15像素,阳线时用红色,阴线时用绿色。
function ChartFLOATRGN()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;
    this.IsDrawFirst = false;    //面积图在K线前面画,否则回挡住K线的

    this.ClassName="ChartFLOATRGN";
    this.Color='rgb(56,67,99)';
    this.IsHScreen=false;

    this.Draw=function()
    {
        this.IsHScreen=(this.ChartFrame.IsHScreen===true);

        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        if (!this.Data || !this.Data.Data) return;

        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var xPointCount=this.ChartFrame.XPointCount;
        var xOffset=this.ChartBorder.GetLeft()+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;

        var x = 0, y = 0, y2 = 0;
        var aryPoint=[];    //点坐标
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var item=this.Data.Data[i];
            aryPoint[i]=null;
            if (!item || !IFrameSplitOperator.IsNumber(item.Value)|| !IFrameSplitOperator.IsNumber(item.Value2) || !item.Color) continue;

            x=this.ChartFrame.GetXFromIndex(j);
            y=this.ChartFrame.GetYFromData(item.Value);

            if (this.IsHScreen)
                aryPoint[i]={ Line:{ X:y, Y:x }, Line2:{ X:y+item.Value2*GetDevicePixelRatio(), Y:x }, Color:item.Color };
            else
                aryPoint[i]={ Line:{ X:x, Y:y }, Line2:{ X:x, Y:y-item.Value2*GetDevicePixelRatio() }, Color:item.Color };
        }

        //计算左右位置的点
        var preItem=null;
        for(var i in aryPoint)
        {
            var item=aryPoint[i];
            if (preItem && item)
            {
                if (this.IsHScreen)
                {
                    var xWidth=(item.Line.Y-preItem.Line.Y);
                    x=preItem.Line.Y+xWidth/2;
                    y=preItem.Line.X+(item.Line.X-preItem.Line.X)/2;
                    y2=preItem.Line2.X+(item.Line2.X-preItem.Line2.X)/2;

                    preItem.RightLine={X:y, Y:x};
                    preItem.RightLine2={X:y2, Y:x};
                    item.LeftLine={X:y, Y:x};
                    item.LeftLine2={X:y2, Y:x};
                }
                else
                {
                    var xWidth=(item.Line.X-preItem.Line.X);
                    x=preItem.Line.X+xWidth/2;
                    y=preItem.Line.Y+(item.Line.Y-preItem.Line.Y)/2;
                    y2=preItem.Line2.Y+(item.Line2.Y-preItem.Line2.Y)/2;
                    preItem.RightLine={X:x, Y:y};
                    preItem.RightLine2={X:x, Y:y2};
                    item.LeftLine={X:x, Y:y};
                    item.LeftLine2={X:x, Y:y2};
                }
            }

            preItem=item;  //上一个点
        }

        this.DrawRGB(aryPoint);
    }

    this.DrawRGB=function(aryPoint)
    {
        var firstPoint=true;
        var pointCount=0;
        var aryLine2=[];
        var color=null;

        if (this.IsHScreen)
        {
            var left=this.ChartBorder.GetLeftEx();
            var right=this.ChartBorder.GetRightEx();
            var top=this.ChartBorder.GetTop();
            var bottom=this.ChartBorder.GetBottom();
        }
        else
        {
            var left=this.ChartBorder.GetLeft();
            var right=this.ChartBorder.GetRight();
            var top=this.ChartBorder.GetTopEx();
            var bottom=this.ChartBorder.GetBottomEx();
        }
        

        this.Canvas.save();
        this.Canvas.beginPath();
        this.Canvas.rect(left,top,(right-left),(bottom-top));
        this.Canvas.clip();

        for(var i in aryPoint)
        {
            var item=aryPoint[i];
            if (!item || (color && item.Color!=color) )
            {
                if (pointCount>0)
                {
                    var lastItem=aryLine2[aryLine2.length-1];
                    var firstItem=aryLine2[0];
                    if (lastItem.RightLine)
                    {
                        this.Canvas.lineTo(lastItem.RightLine.X, lastItem.RightLine.Y);
                        this.Canvas.lineTo(lastItem.RightLine2.X, lastItem.RightLine2.Y);
                    }

                    for(var j=aryLine2.length-1; j>=0; --j)
                    {
                        var item2=aryLine2[j];
                        this.Canvas.lineTo(item2.Line2.X, item2.Line2.Y);
                    }

                    if (firstItem.LeftLine2)
                    {
                        this.Canvas.lineTo(firstItem.LeftLine2.X, firstItem.LeftLine2.Y);
                    }
                    
                    this.Canvas.closePath();
                    this.Canvas.fillStyle = color;
                    this.Canvas.fill();
                }

                firstPoint=true;
                pointCount=0;
                aryLine2=[];
                color=null;
            }

            if (!item) continue;

            if (firstPoint)
            {
                this.Canvas.beginPath();
                if (item.LeftLine)
                {
                    this.Canvas.moveTo(item.LeftLine.X, item.LeftLine.Y);
                    this.Canvas.lineTo(item.Line.X, item.Line.Y);
                }
                else 
                {
                    this.Canvas.moveTo(item.Line.X, item.Line.Y);
                }
                firstPoint=false;
                color=item.Color;
            }
            else
            {
                this.Canvas.lineTo(item.Line.X, item.Line.Y);
            }

            aryLine2.push(item);
            ++pointCount;
        }

        if (pointCount>0)
        {
            var lastItem=aryLine2[aryLine2.length-1];
            var firstItem=aryLine2[0];
            if (lastItem.RightLine)
            {
                this.Canvas.lineTo(lastItem.RightLine.X, lastItem.RightLine.Y);
                this.Canvas.lineTo(lastItem.RightLine2.X, lastItem.RightLine2.Y);
            }

            for(var j=aryLine2.length-1; j>=0; --j)
            {
                var item2=aryLine2[j];
                this.Canvas.lineTo(item2.Line2.X, item2.Line2.Y);
            }

            if (firstItem.LeftLine2)
            {
                this.Canvas.lineTo(firstItem.LeftLine2.X, firstItem.LeftLine2.Y);
            }
            
            this.Canvas.closePath();
            this.Canvas.fillStyle = color;
            this.Canvas.fill();
        }

        this.Canvas.restore();
    }

    this.GetMaxMin=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var range={};
        range.Min=null;
        range.Max=null;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var item=this.Data.Data[i];
            if (!item || !IFrameSplitOperator.IsNumber(item.Value)) continue;
            var value=item.Value;
            
            if (range.Max==null) range.Max = value;
            else if (range.Max < value) range.Max = value;
            
            if (range.Min==null) range.Min = value;
            else if (range.Min > value) range.Min = value; 
        }

        return range;
    }
}

//线段围城的顶部或底部面积图 TODO:支持横屏
function ChartFillBGRGN()
{
    this.newMethod=ChartFillRGN;   //派生
    this.newMethod();
    delete this.newMethod;
    this.IsDrawFirst = true;    //面积图在K线前面画,否则回挡住K线的
    this.IsHScreen=false;

    this.ClassName="ChartFillBGRGN";


    this.DrawVerticalRGN=function()
    {
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var xPointCount=this.ChartFrame.XPointCount;
        var xOffset=this.ChartBorder.GetLeft()+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
        var top=this.ChartBorder.GetTopEx();
        var bottom=this.ChartBorder.GetBottomEx();

        var y=top, y2=bottom;

        var aryPoint=[];    //点坐标
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var value=this.Data.Data[i];
            aryPoint[i]=null;
            if (!value || !value.Color) continue;

            x=this.ChartFrame.GetXFromIndex(j);

            if (this.IsHScreen)
                aryPoint[i]={ Line:{ X:y, Y:x }, Line2:{ X:y2, Y:x }, Color:value.Color };
            else
                aryPoint[i]={ Line:{ X:x, Y:y }, Line2:{ X:x, Y:y2 }, Color:value.Color };
        }

        this.DrawRGB(aryPoint);
    }

    this.Draw=function()
    {
        this.IsHScreen=(this.ChartFrame.IsHScreen===true);

        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        if (!this.Data || !this.Data.Data) return;

        if (this.Name=="FILLVERTICALRGN")
        {
            this.DrawVerticalRGN();
            return;
        }

        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var xPointCount=this.ChartFrame.XPointCount;
        var xOffset=this.ChartBorder.GetLeft()+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
        var top=this.ChartBorder.GetTopEx();
        var bottom=this.ChartBorder.GetBottomEx();
        var x = 0, y = 0, y2 = top;
        if (this.Name=="FILLBOTTOMRGN")  y2=bottom;

        var aryPoint=[];    //点坐标
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var value=this.Data.Data[i];
            aryPoint[i]=null;
            if (value==null || value.Value==null || !value.Color) continue;

            x=this.ChartFrame.GetXFromIndex(j);
            y=this.ChartFrame.GetYFromData(value.Value);

            if (this.IsHScreen)
                aryPoint[i]={ Line:{ X:y, Y:x }, Line2:{ X:y2, Y:x }, Color:value.Color };
            else
                aryPoint[i]={ Line:{ X:x, Y:y }, Line2:{ X:x, Y:y2 }, Color:value.Color };
        }

        this.DrawRGB(aryPoint);
    }

    this.DrawRGB=function(aryPoint)
    {
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var halfWidth=(distanceWidth+dataWidth)/2;
        var firstPoint=true;
        var pointCount=0;
        var aryLine2=[];
        var color=null;
        for(var i in aryPoint)
        {
            var item=aryPoint[i];
            if (!item || (color && item.Color!=color) )
            {
                if (pointCount>0)
                {
                    for(var j=aryLine2.length-1; j>=0; --j)
                    {
                        var item2=aryLine2[j];
                        this.Canvas.lineTo(item2.Line2.X+halfWidth, item2.Line2.Y);
                        this.Canvas.lineTo(item2.Line2.X-halfWidth, item2.Line2.Y);
                    }
                    this.Canvas.closePath();
                    this.Canvas.fillStyle = color;
                    this.Canvas.fill();
                }

                firstPoint=true;
                pointCount=0;
                aryLine2=[];
                color=null;
            }

            if (!item) continue;

            if (firstPoint)
            {
                this.Canvas.beginPath();
                this.Canvas.moveTo(item.Line.X-halfWidth, item.Line.Y);
                this.Canvas.lineTo(item.Line.X+halfWidth, item.Line.Y);
                firstPoint=false;
                color=item.Color;
            }
            else
            {
                this.Canvas.lineTo(item.Line.X-halfWidth, item.Line.Y);
                this.Canvas.lineTo(item.Line.X+halfWidth, item.Line.Y);
            }

            aryLine2.push(item);
            ++pointCount;
        }

        if (pointCount>0)
        {
            for(var j=aryLine2.length-1; j>=0; --j)
            {
                var item2=aryLine2[j];
                this.Canvas.lineTo(item2.Line2.X+halfWidth, item2.Line2.Y);
                this.Canvas.lineTo(item2.Line2.X-halfWidth, item2.Line2.Y);
            }
            this.Canvas.closePath();
            this.Canvas.fillStyle = color;
            this.Canvas.fill();
        }
    }

    this.GetMaxMin=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var range={};
        range.Min=null;
        range.Max=null;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i];
            if (!value || value.Value==null ) continue;

            var value=value.Value;

            if (range.Max==null)  range.Max = value;
            else if (range.Max < value) range.Max = value;
            
            if (range.Min==null) range.Min = value;
            else if (range.Min > value) range.Min = value; 
        }

        return range;
    }
}

// 通道面积图 支持横屏
function ChartChannel()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;
    this.IsDrawFirst = true;

    this.ClassName="ChartChannel";
    this.IsHScreen=false;   //是否是横屏
    this.PointCount=0;
    this.DataWidth=0;
    this.DistanceWidth=0;
    this.ChartRight=0;      //可以绘制的最右边
    this.LineColor='RGB(255,0,0)';
    this.LineDotted=[3,3];
    this.AreaColor='RGB(255,222,173)';
    this.LineWidth=1;

    this.CalculateData=function()   //把数据通过nul值分割开, 并计算坐标
    {
        var data=[];
        var lineData=[];
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<this.PointCount;++i,++j)
        {
            var item=this.Data.Data[i];
            if (!item || !IFrameSplitOperator.IsNumber(item.Value) || !IFrameSplitOperator.IsNumber(item.Value2))
            {
                if (lineData.length>0) 
                {
                    data.push(lineData);
                    lineData=[];    //创建新的一组数据
                }

                continue;
            }

            var x=this.ChartFrame.GetXFromIndex(j);
            if (x>this.ChartRight) break;
            var y=this.ChartFrame.GetYFromData(item.Value);
            var y2=this.ChartFrame.GetYFromData(item.Value2);

            lineData.push({X:x, Y:y,Y2:y2});
        }
        
        if (lineData.length>0) data.push(lineData);
        return data;
    }

    this.DrawArea=function(lineData)
    {
        if (lineData.length<=0) return;
        this.Canvas.beginPath();

        var drawCount=0;
        var firstItem=lineData[0];
        if (this.IsHScreen) this.Canvas.moveTo(firstItem.Y,firstItem.X);
        else this.Canvas.moveTo(firstItem.X,firstItem.Y);
        for(var i=1;i<lineData.length;++i)
        {
            var item=lineData[i];
            if (this.IsHScreen) this.Canvas.lineTo(item.Y,item.X);
            else this.Canvas.lineTo(item.X,item.Y);
            ++drawCount;
        }

        for(var i=lineData.length-1;i>=0;--i)
        {
            var item=lineData[i];
            if (this.IsHScreen) this.Canvas.lineTo(item.Y2,item.X);
            else this.Canvas.lineTo(item.X,item.Y2);
            ++drawCount;
        }

        this.Canvas.closePath();
        this.Canvas.fillStyle = this.AreaColor;
        this.Canvas.fill();
    }

    this.DrawLine=function(lineData)
    {
        this.Canvas.strokeStyle=this.LineColor;
        for(var k=0;k<2;++k)
        {
            var bFirstPoint=true;
            var drawCount=0;
            for(var i=0;i<lineData.length;++i)
            {
                var item=lineData[i];

                if (bFirstPoint)
                {
                    this.Canvas.beginPath();
                    if (this.IsHScreen) this.Canvas.moveTo(k===0?item.Y:item.Y2,item.X);
                    else this.Canvas.moveTo(item.X, k===0?item.Y:item.Y2 );
                    bFirstPoint=false;
                }
                else
                {
                    if (this.IsHScreen) this.Canvas.lineTo(k===0?item.Y:item.Y2,item.X);
                    else this.Canvas.lineTo(item.X,k===0?item.Y:item.Y2);
                }

                ++drawCount;
            }
            if (drawCount>0) this.Canvas.stroke();
        }
    }

    this.Draw=function()
    {
        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        this.IsHScreen=(this.ChartFrame.IsHScreen===true);
        this.PointCount=this.ChartFrame.XPointCount;
        this.DataWidth=this.ChartFrame.DataWidth;
        this.DistanceWidth=this.ChartFrame.DistanceWidth;
        if (this.IsHScreen) this.ChartRight=this.ChartBorder.GetBottom();
        else this.ChartRight=this.ChartBorder.GetRight();

        var drawData=this.CalculateData();
        if (!drawData || drawData.length<=0) return;

        this.Canvas.save();
        this.Canvas.lineWidth=this.LineWidth*GetDevicePixelRatio();
        this.Canvas.setLineDash(this.LineDotted);   //虚线
        for(var i=0;i<drawData.length;++i)
        {
            var lineData=drawData[i];
            this.DrawArea(lineData);
            this.DrawLine(lineData);
        }
        this.Canvas.restore();
    }

    this.GetMaxMin=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var range={Min:null, Max:null};
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i];
            if (value==null || value.Value==null || value.Value2 == null) continue;
            var maxData = value.Value>value.Value2?value.Value:value.Value2;
            var minData = value.Value<value.Value2?value.Value:value.Value2;
            if (range.Max==null) 
                range.Max = maxData;
            else if (range.Max < maxData)
                range.Max = maxData;
            
            if (range.Min==null)
                range.Min = minData;
            else if (range.Min > minData)
                range.Min = minData; 
        }

        return range;
    }
}

//填充背景 支持横屏
function ChartBackground()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName="ChartBackground";
    this.Color=null;
    this.ColorAngle=0;  //0 竖向 1 横向
    this.IsDrawFirst = true;    //面积图在K线前面画,否则回挡住K线的

    this.Draw=function()
    {
        if (!this.IsShow) return;
        if (!this.Color) return;
        if (this.Color.length<=0) return;

        this.IsHScreen=(this.ChartFrame.IsHScreen===true);

        if (this.Color.length==2)
        {
            if (this.IsHScreen)
            {
                if (this.ColorAngle==0)
                {
                    var ptStart={ X:this.ChartBorder.GetRight(), Y:this.ChartBorder.GetTopEx() };
                    var ptEnd={ X:this.ChartBorder.GetLeft(), Y:this.ChartBorder.GetTopEx() };
                }
                else
                {
                    var ptStart={ X:this.ChartBorder.GetLeft(), Y:this.ChartBorder.GetTopEx() };
                    var ptEnd={ X:this.ChartBorder.GetLeft(), Y:this.ChartBorder.GetBottomEx() };
                }
            }
            else
            {
                if (this.ColorAngle==0)
                {
                    var ptStart={ X:this.ChartBorder.GetLeft(), Y:this.ChartBorder.GetTopEx() };
                    var ptEnd={ X:this.ChartBorder.GetLeft(), Y:this.ChartBorder.GetBottomEx() };
                }
                else
                {
                    var ptStart={ X:this.ChartBorder.GetLeft(), Y:this.ChartBorder.GetTopEx() };
                    var ptEnd={ X:this.ChartBorder.GetRight(), Y:this.ChartBorder.GetTopEx() };
                }
            }
            
            let gradient = this.Canvas.createLinearGradient(ptStart.X,ptStart.Y, ptEnd.X,ptEnd.Y);
            gradient.addColorStop(0, this.Color[0]);
            gradient.addColorStop(1, this.Color[1]);
            this.Canvas.fillStyle=gradient;
        }
        else if (this.Color.length==1)
        {
            this.Canvas.fillStyle=this.Color[0];
        }
        else
        {
            return;
        }

        if (this.Name=="DRAWGBK2" || this.Name=="KLINE_BG")
        {
            this.DrawRegion();
            return;
        }

        if (this.IsHScreen)
        {
            var left=this.ChartBorder.GetLeftEx();
            var top=this.ChartBorder.GetTop();
            var width=this.ChartBorder.GetWidthEx();
            var height=this.ChartBorder.GetHeight();
        }
        else
        {
            var left=this.ChartBorder.GetLeft();
            var top=this.ChartBorder.GetTopEx();
            var width=this.ChartBorder.GetWidth();
            var height=this.ChartBorder.GetHeightEx();
        }
        this.Canvas.fillRect(left, top,width, height);
    }

    this.DrawRegion=function()
    {
        var xPointCount=this.ChartFrame.XPointCount;
        var xOffset=this.ChartBorder.GetLeft()+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var top=this.ChartBorder.GetTopEx();
        var bottom=this.ChartBorder.GetBottomEx();
        if (this.IsHScreen)
        {
            top=this.ChartBorder.GetRightEx();
            bottom=this.ChartBorder.GetLeftEx();
        }

        var aryPoint=[];    //点坐标
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var value=this.Data.Data[i];
            aryPoint[i]=null;
            if (!IFrameSplitOperator.IsNumber(value) || value<=0) continue;

            var x=this.ChartFrame.GetXFromIndex(j);
            var y=this.ChartFrame.GetYFromData(value.Value);

            if (this.IsHScreen)
                aryPoint[i]={ Line:{ X:bottom, Y:x }, Line2:{ X:top, Y:x } };
            else
                aryPoint[i]={ Line:{ X:x, Y:top }, Line2:{ X:x, Y:bottom } };
        }

        this.DrawBG(aryPoint);
    }

    this.DrawBG=function(aryPoint)
    {
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var halfWidth=(distanceWidth+dataWidth)/2;
        var firstPoint=true;
        var pointCount=0;
        var aryLine2=[];
        var color=null;
        for(var i in aryPoint)
        {
            var item=aryPoint[i];
            if (!item || (color && item.Color!=color) )
            {
                if (pointCount>0)
                {
                    for(var j=aryLine2.length-1; j>=0; --j)
                    {
                        var item2=aryLine2[j];
                        if (this.IsHScreen)
                        {
                            this.Canvas.lineTo(item2.Line2.X, item2.Line2.Y+halfWidth);
                            this.Canvas.lineTo(item2.Line2.X, item2.Line2.Y-halfWidth);
                        }
                        else
                        {
                            this.Canvas.lineTo(item2.Line2.X+halfWidth, item2.Line2.Y);
                            this.Canvas.lineTo(item2.Line2.X-halfWidth, item2.Line2.Y);
                        }
                    }
                    this.Canvas.closePath();
                    this.Canvas.fill();
                }

                firstPoint=true;
                pointCount=0;
                aryLine2=[];
                color=null;
            }

            if (!item) continue;

            if (firstPoint)
            {
                this.Canvas.beginPath();
                if (this.IsHScreen)
                {
                    this.Canvas.moveTo(item.Line.X, item.Line.Y-halfWidth);
                    this.Canvas.lineTo(item.Line.X, item.Line.Y+halfWidth);
                }
                else
                {
                    this.Canvas.moveTo(item.Line.X-halfWidth, item.Line.Y);
                    this.Canvas.lineTo(item.Line.X+halfWidth, item.Line.Y);
                }
                firstPoint=false;
                color=item.Color;
            }
            else
            {
                if (this.IsHScreen)
                {
                    this.Canvas.lineTo(item.Line.X, item.Line.Y-halfWidth);
                    this.Canvas.lineTo(item.Line.X, item.Line.Y+halfWidth);
                }
                else
                {
                    this.Canvas.lineTo(item.Line.X-halfWidth, item.Line.Y);
                    this.Canvas.lineTo(item.Line.X+halfWidth, item.Line.Y);
                }
            }

            aryLine2.push(item);
            ++pointCount;
        }

        if (pointCount>0)
        {
            for(var j=aryLine2.length-1; j>=0; --j)
            {
                var item2=aryLine2[j];
                if (this.IsHScreen)
                {
                    this.Canvas.lineTo(item2.Line2.X, item2.Line2.Y+halfWidth);
                    this.Canvas.lineTo(item2.Line2.X, item2.Line2.Y-halfWidth);
                }
                else
                {
                    this.Canvas.lineTo(item2.Line2.X+halfWidth, item2.Line2.Y);
                    this.Canvas.lineTo(item2.Line2.X-halfWidth, item2.Line2.Y);
                }
            }
            this.Canvas.closePath();
            this.Canvas.fill();
        }
    }

    this.GetMaxMin=function()
    {
        return { Min:null, Max:null };
    }
}

//画矩形
function ChartRectangle()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName="ChartRectangle";

    this.Color=[];
    this.Rect;
    this.BorderColor=g_JSChartResource.FrameBorderPen;

    this.Draw=function()
    {
        if (!this.IsShow) return;
        if (!this.Color || !this.Rect) return;
        if (this.Color.length<=0) return;

        this.Canvas.strokeStyle=this.BorderColor;
        var bFill=false;
        if (this.Color.length==2)
        {
            /*  TODO 渐变下次做吧
            if (this.ColorAngle==0)
            {
                var ptStart={ X:this.ChartBorder.GetLeft(), Y:this.ChartBorder.GetTopEx() };
                var ptEnd={ X:this.ChartBorder.GetLeft(), Y:this.ChartBorder.GetBottomEx() };
            }
            else
            {
                var ptStart={ X:this.ChartBorder.GetLeft(), Y:this.ChartBorder.GetTopEx() };
                var ptEnd={ X:this.ChartBorder.GetRight(), Y:this.ChartBorder.GetTopEx() };
            }

            let gradient = this.Canvas.createLinearGradient(ptStart.X,ptStart.Y, ptEnd.X,ptEnd.Y);
            gradient.addColorStop(0, this.Color[0]);
            gradient.addColorStop(1, this.Color[1]);
            this.Canvas.fillStyle=gradient;
            */

            this.Canvas.fillStyle=this.Color[0];
            bFill=true;
        }
        else if (this.Color.length==1)
        {
            if (this.Color[0])
            {
                this.Canvas.fillStyle=this.Color[0];
                bFill=true;
            }
        }
        else
        {
            return;
        }

        var chartWidth=this.ChartBorder.GetWidth();
        var chartHeight=this.ChartBorder.GetHeightEx();
        var left=this.Rect.Left/1000*chartWidth;
        var top=this.Rect.Top/1000*chartHeight;
        var right=this.Rect.Right/1000*chartWidth;
        var bottom=this.Rect.Bottom/1000*chartHeight;

        left=this.ChartBorder.GetLeft()+left
        top=this.ChartBorder.GetTopEx()+top;
        right=this.ChartBorder.GetLeft()+right;
        bottom=this.ChartBorder.GetTopEx()+bottom;
        var width=Math.abs(left-right);
        var height=Math.abs(top-bottom);
        if (bFill) this.Canvas.fillRect(left, top,width, height);
        this.Canvas.rect(ToFixedPoint(left), ToFixedPoint(top),ToFixedRect(width), ToFixedRect(height));
        this.Canvas.stroke();
    }
}

// 文字+线段输出
function ChartTextLine()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName="ChartTextLine";

    this.Text;  //Text=内容 Color
    this.Line;  //Type=线段类型 0=不画 1=直线 2=虚线, Color
    this.Price;

    this.Draw=function()
    {
        if (!this.IsShow) return;
        if (!this.Text || !this.Line || !IFrameSplitOperator.IsNumber(this.Price)) return;

        this.IsHScreen=(this.ChartFrame.IsHScreen===true);
        var left=this.ChartBorder.GetLeft();
        var right=this.ChartBorder.GetRight();
        var bottom=this.ChartBorder.GetBottomEx();
        var top=this.ChartBorder.GetTopEx();
        var y=this.ChartFrame.GetYFromData(this.Price);
        var textWidth=0;
        if (this.Text.Title)
        {
            var x=left+2*GetDevicePixelRatio();
            var yText=y;
            this.Canvas.textAlign = 'left';
            this.Canvas.textBaseline = 'middle';
            var offsetY=8*GetDevicePixelRatio();
            if (y-offsetY<top) 
            {
                this.Canvas.textBaseline='top';
                yText=top;
            }
            else if (y+offsetY>bottom) 
            {
                this.Canvas.textBaseline='bottom';
                yText=bottom;
            }
            
            this.Canvas.fillStyle = this.Text.Color;
            this.Canvas.font = this.Text.Font;
            this.Canvas.fillText(this.Text.Title, x, yText);
            textWidth=this.Canvas.measureText(this.Text.Title).width+4*GetDevicePixelRatio();
        }

        if (this.Line.Type>0)
        {
            if (this.Line.Type==2)  //虚线
            {
                this.Canvas.save();
                this.Canvas.setLineDash([3,5]);   //虚线
            }

            var x=left+textWidth;
            this.Canvas.strokeStyle=this.Line.Color;
            this.Canvas.beginPath();
            this.Canvas.moveTo(x,ToFixedPoint(y));
            this.Canvas.lineTo(right,ToFixedPoint(y));
            this.Canvas.stroke();

            if (this.Line.Type==2)
            {
                this.Canvas.restore();
            }
        }

    }

    this.GetMaxMin=function()
    {
        var range={Min:null, Max:null};
        if (IFrameSplitOperator.IsNumber(this.Price))
        {
            range.Min=this.Price;
            range.Max=this.Price;
        }
        
        return range;
    }
}

// 柱子集合  支持横屏
function ChartMultiBar()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;
    
    this.ClassName="ChartMultiBar";
    this.Bars=[];   // [ {Point:[ {Index, Value, Value2 }, ], Color:, Width: , Type: 0 实心 1 空心 }, ] 
    this.IsHScreen=false;

    this.Draw=function()
    {
        if (!this.IsShow) return;
        if (!this.Data || this.Data.length<=0) return;

        this.IsHScreen=(this.ChartFrame.IsHScreen===true);
        var xPointCount=this.ChartFrame.XPointCount;
        var offset=this.Data.DataOffset;
        var dataWidth=this.ChartFrame.DataWidth;
        var pixelRatio=GetDevicePixelRatio();

        var drawBars=[];
        for(var i in this.Bars)
        {
            var item=this.Bars[i];
            var drawPoints={ Point:[], Color:item.Color, Width:dataWidth, Type:0 };
            if (item.Type>0) drawPoints.Type=item.Type;
            if (item.Width>0) 
            {
                drawPoints.Width=item.Width*pixelRatio;
                if (drawPoints.Width>dataWidth) drawPoints.Width=dataWidth;
            }
            else
            {
                if(drawPoints.Width<4) drawPoints.Width=1*pixelRatio;
            }

            for(var j in item.Point)
            {
                var point=item.Point[j];
                if (!IFrameSplitOperator.IsNumber(point.Index)) continue;

                var index=point.Index-offset;
                if (index>=0 && index<xPointCount)
                {
                    var x=this.ChartFrame.GetXFromIndex(index);
                    var y=this.ChartFrame.GetYFromData(point.Value);
                    var y2=this.ChartFrame.GetYFromData(point.Value2);
                    drawPoints.Point.push({X:x, Y:y, Y2:y2});
                }
            }

            if (drawPoints.Point.length>0) drawBars.push(drawPoints)
        }

        for(var i in drawBars)
        {
            var item=drawBars[i];
            if (item.Width>=4) 
            {
                if (item.Type==1) this.DrawHollowBar(item);
                else this.DrawFillBar(item);
            }
            else 
            {
                this.DrawLineBar(item);
            }
        }
    }

    this.DrawLineBar=function(bar)
    {
        this.Canvas.strokeStyle=bar.Color;
        var backupLineWidth=this.Canvas.lineWidth;
        this.Canvas.lineWidth=bar.Width;
        for(var i in bar.Point)
        {
            var item=bar.Point[i];

            this.Canvas.beginPath();
            if (this.IsHScreen)
            {
                this.Canvas.moveTo(ToFixedPoint(item.Y),ToFixedPoint(item.X));
                this.Canvas.lineTo(ToFixedPoint(item.Y2),ToFixedPoint(item.X));
            }
            else
            {
                this.Canvas.moveTo(ToFixedPoint(item.X),ToFixedPoint(item.Y));
                this.Canvas.lineTo(ToFixedPoint(item.X),ToFixedPoint(item.Y2));
            }
            
            this.Canvas.stroke();
        }

        this.Canvas.lineWidth=backupLineWidth;
    }

    this.DrawFillBar=function(bar)
    {
        this.Canvas.fillStyle=bar.Color;
        for(var i in bar.Point)
        {
            var item=bar.Point[i];
            var x=item.X-(bar.Width/2);
            var y=Math.min(item.Y,item.Y2);
            var barWidth=bar.Width;
            var barHeight=Math.abs(item.Y-item.Y2);
            if (this.IsHScreen)
                this.Canvas.fillRect(ToFixedRect(y),ToFixedRect(x),ToFixedRect(barHeight),ToFixedRect(barWidth));
            else 
                this.Canvas.fillRect(ToFixedRect(x),ToFixedRect(y),ToFixedRect(barWidth),ToFixedRect(barHeight));
        }
    }

    this.DrawHollowBar=function(bar)    //空心柱子
    {
        this.Canvas.strokeStyle=bar.Color;
        var backupLineWidth=1;
        for(var i in bar.Point)
        {
            var item=bar.Point[i];
            var x=item.X-(bar.Width/2);
            var y=Math.min(item.Y,item.Y2);
            var barWidth=bar.Width;
            var barHeight=Math.abs(item.Y-item.Y2);
            this.Canvas.beginPath();
            if (this.IsHScreen)
                this.Canvas.rect(ToFixedPoint(y),ToFixedPoint(x),ToFixedRect(barHeight),ToFixedRect(barWidth));
            else
                this.Canvas.rect(ToFixedPoint(x),ToFixedPoint(y),ToFixedRect(barWidth),ToFixedRect(barHeight));

            this.Canvas.stroke();
        }

        this.Canvas.lineWidth=backupLineWidth;
    }

    this.GetMaxMin=function()
    {
        var range={ Min:null, Max:null };
        var xPointCount=this.ChartFrame.XPointCount;
        var start=this.Data.DataOffset;
        var end=start+xPointCount;
        for(var i in this.Bars)
        {
            var item=this.Bars[i];
            for(var j in item.Point)
            {
                var point=item.Point[j];
                if (point.Index>=start && point.Index<end)
                {
                    var minValue=Math.min(point.Value,point.Value2);
                    var maxValue=Math.max(point.Value,point.Value2);
                    if (range.Max==null) range.Max=maxValue;
                    else if (range.Max<maxValue) range.Max=maxValue;
                    if (range.Min==null) range.Min=minValue;
                    else if (range.Min>minValue) range.Min=minValue;
                }
            }
        }

        return range;
    }
}

// 线段集合 支持横屏
function ChartMultiLine()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;
    
    this.ClassName="ChartMultiLine";
    this.Lines=[];   // [ {Point:[ {Index, Value }, ], Color:  }, ] 
    this.LineDash;
    this.IsHScreen=false;

    //箭头配置
    this.ArrawAngle=35;     //三角斜边一直线夹角
    this.ArrawLength=10;    //三角斜边长度
    this.ArrawLineWidth=5;  //箭头粗细
    this.Arrow={ Start:false, End:false };  //Start=是否绘制开始箭头 <-   End=是否绘制结束箭头 ->

    this.Draw=function()
    {
        if (!this.IsShow) return;
        if (!this.Data || this.Data.length<=0) return;

        this.IsHScreen=(this.ChartFrame.IsHScreen===true);
        var xPointCount=this.ChartFrame.XPointCount;
        var offset=this.Data.DataOffset;

        var drawLines=[];
        var arrowLines=[];
        for(var i in this.Lines)
        {
            var line=this.Lines[i];
            var drawPoints={ Point:[], Color:line.Color };
            var drawArrowPoints={ Start:[], End:[] };
            if (line.BGColor) drawPoints.BGColor=line.BGColor;
            for(var j in line.Point)
            {
                var point=line.Point[j];
                if (!IFrameSplitOperator.IsNumber(point.Index)) continue;

                var index=point.Index-offset;
                if (index>=0 && index<xPointCount)
                {
                    var x=this.ChartFrame.GetXFromIndex(index);
                    var y=this.ChartFrame.GetYFromData(point.Value);
                    var pointItem={X:x, Y:y, End:false};
                    drawPoints.Point.push(pointItem);

                    if (j==0 || j==1) drawArrowPoints.Start.push(pointItem);    //起始点
                    if (j==line.Point.length-1 || j==line.Point.length-2) drawArrowPoints.End.push(pointItem);  //结束点
                }
                else
                {
                    if (drawPoints.Point.length>0) drawPoints.Point[drawPoints.Point.length-1].End=true;  //点断开
                }
            }

            if (drawPoints.Point.length>=2) 
            {
                drawLines.push(drawPoints);
                arrowLines.push(drawArrowPoints);
            }
        }

        this.Canvas.save();
        for(var i in drawLines)
        {
            if (this.LineDash) this.Canvas.setLineDash(this.LineDash);
            var item=drawLines[i];
            this.DrawLine(item, arrowLines[i]);
        }
        this.Canvas.restore();
    }

    this.DrawLine=function(line, arrow)
    {
        if (line.BGColor)   //背景色
        {
            this.Canvas.fillStyle=line.BGColor;
            for(var i in line.Point)
            {
                var item=line.Point[i];
                if (i==0)
                {
                    this.Canvas.beginPath();
                    if (this.IsHScreen) this.Canvas.moveTo(item.Y,item.X);
                    else this.Canvas.moveTo(item.X,item.Y);
                }
                else
                {
                    if (this.IsHScreen) this.Canvas.lineTo(item.Y,item.X);
                    else this.Canvas.lineTo(item.X,item.Y);
                }
            }
            this.Canvas.closePath();
            this.Canvas.fill();
        }

        this.Canvas.strokeStyle=line.Color;
        var drawCount=0;
        for(var i in line.Point)
        {
            var item=line.Point[i];
            if (drawCount==0)
            {
                this.Canvas.beginPath();
                if (this.IsHScreen) this.Canvas.moveTo(item.Y,item.X);
                else this.Canvas.moveTo(item.X,item.Y);
                ++drawCount;
            }
            else
            {
                if (this.IsHScreen) this.Canvas.lineTo(item.Y,item.X);
                else this.Canvas.lineTo(item.X,item.Y);
                ++drawCount;
            }

            if (item.End==true) //点断了 要重新画
            {
                if (drawCount>0) this.Canvas.stroke();
                drawCount=0;
            }
        }

        if (drawCount>0) this.Canvas.stroke();

        //绘制箭头
        if (arrow.End.length==2 && this.Arrow.End==true)    
            this.DrawArrow(arrow.End[0],arrow.End[1]);

        if (arrow.Start.length==2 && this.Arrow.Start==true)
            this.DrawArrow(arrow.Start[1],arrow.Start[0]);
       
    }

    this.DrawArrow=function(ptStart,ptEnd)
    {
        //计算箭头
        var theta=this.ArrawAngle;       //三角斜边一直线夹角
        var headlen=this.ArrawLength;    //三角斜边长度
        var angle = Math.atan2(ptStart.Y - ptEnd.Y, ptStart.X - ptEnd.X) * 180 / Math.PI,
        angle1 = (angle + theta) * Math.PI / 180,
        angle2 = (angle - theta) * Math.PI / 180,
        topX = headlen * Math.cos(angle1),
        topY = headlen * Math.sin(angle1),
        botX = headlen * Math.cos(angle2),
        botY = headlen * Math.sin(angle2);

        this.Canvas.beginPath();
        var arrowX = ptEnd.X + topX;
        var arrowY = ptEnd.Y + topY;
        this.Canvas.moveTo(arrowX,arrowY);

        this.Canvas.lineTo(ptEnd.X, ptEnd.Y);

        arrowX = ptEnd.X + botX;
        arrowY = ptEnd.Y + botY;
        this.Canvas.lineTo(arrowX,arrowY);

        this.Canvas.setLineDash([]);
        this.Canvas.lineWidth=this.ArrawLineWidth*GetDevicePixelRatio();
        this.Canvas.stroke();
    }

    this.GetMaxMin=function()
    {
        var range={ Min:null, Max:null };
        var xPointCount=this.ChartFrame.XPointCount;
        var start=this.Data.DataOffset;
        var end=start+xPointCount;

        for(var i in this.Lines)
        {
            var line=this.Lines[i];
            for(var j in line.Point)
            {
                var point=line.Point[j];
                if (point.Index>=start && point.Index<end)
                {
                    if (range.Max==null) range.Max=point.Value;
                    else if (range.Max<point.Value) range.Max=point.Value;
                    if (range.Min==null) range.Min=point.Value;
                    else if (range.Min>point.Value) range.Min=point.Value;
                }
            }
        }

        return range;
    }
}

// 多文本集合 支持横屏
function ChartMultiText()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName="ChartMultiText";
    this.Texts=[];  //[ {Index:, Value:, Text:, Color:, Font: , Baseline:, Line:{ Color:, Dash:[虚线点], KData:"H/L", Offset:[5,10], Width:线粗细 }} ]
    this.Font=g_JSChartResource.DefaultTextFont;
    this.Color=g_JSChartResource.DefaultTextColor;
    this.IsHScreen=false;   //是否横屏

    this.Draw=function()
    {
        if (!this.IsShow) return;
        if (!this.Data || this.Data.length<=0) return;
        if (!this.Texts) return;

        this.IsHScreen=(this.ChartFrame.IsHScreen===true);
        var xPointCount=this.ChartFrame.XPointCount;
        var offset=this.Data.DataOffset;
        var left=this.ChartBorder.GetLeft();
        var right=this.ChartBorder.GetRight();

        if (this.IsHScreen)
        {
            left=this.ChartBorder.GetTop();
            right=this.ChartBorder.GetBottom();
        }

        for(var i in this.Texts)
        {
            var item=this.Texts[i];

            if (!item.Text) continue;
            if (!IFrameSplitOperator.IsNumber(item.Index)) continue;

            var index=item.Index-offset;
            if (index>=0 && index<xPointCount)
            {
                var x=this.ChartFrame.GetXFromIndex(index);
                var y=this.ChartFrame.GetYFromData(item.Value);

                if (item.Color)  this.Canvas.fillStyle = item.Color;
                else this.Canvas.fillStyle = this.Color;
                if (item.Font) this.Canvas.font = item.Font;
                else this.Canvas.font=this.Font;

                var textWidth=this.Canvas.measureText(item.Text).width;
                this.Canvas.textAlign='center';
                if (x+textWidth/2>=right) 
                {
                    this.Canvas.textAlign='right';
                    x=right;
                }
                else if (x-textWidth/2<left)
                {
                    this.Canvas.textAlign = 'left';
                    x=left;
                }
                if (item.Baseline==1) this.Canvas.textBaseline='top';
                else if (item.Baseline==2) this.Canvas.textBaseline='bottom';
                else this.Canvas.textBaseline = 'middle';

                if (this.IsHScreen)
                {
                    this.Canvas.save(); 
                    this.Canvas.translate(y, x);
                    this.Canvas.rotate(90 * Math.PI / 180);
                    this.Canvas.fillText(item.Text,0,0);
                    this.Canvas.restore();
                }
                else
                {
                    this.Canvas.fillText(item.Text, x, y);
                }

                if (item.Line)
                {
                    var kItem=this.Data.Data[item.Index];
                    var price=item.Line.KData=="H"? kItem.High:kItem.Low;
                    var yPrice=this.ChartFrame.GetYFromData(price);
                    var yText=y;
                    if (Array.isArray(item.Line.Offset) && item.Line.Offset.length==2)
                    {
                        if (yText>yPrice) //文字在下方
                        {
                            yText-=item.Line.Offset[1];
                            yPrice+=item.Line.Offset[0]
                        }
                        else if (yText<yPrice)
                        {
                            yText+=item.Line.Offset[1];
                            yPrice-=item.Line.Offset[0]
                        }
                    }
                    this.Canvas.save();
                    if (item.Line.Dash) this.Canvas.setLineDash(item.Line.Dash);    //虚线
                    if (item.Line.Width>0) this.Canvas.lineWidth=item.Line.Width;   //线宽
                    this.Canvas.strokeStyle = item.Line.Color;
                    this.Canvas.beginPath();
                    if (this.IsHScreen)
                    {
                        this.Canvas.moveTo(yText, ToFixedPoint(x));
                        this.Canvas.lineTo(yPrice,ToFixedPoint(x));
                    }
                    else
                    {
                        this.Canvas.moveTo(ToFixedPoint(x),yText);
                        this.Canvas.lineTo(ToFixedPoint(x),yPrice);
                    }
                    
                    this.Canvas.stroke();
                    this.Canvas.restore();
                }
            }
        }
    }

    this.GetMaxMin=function()
    {
        var range={ Min:null, Max:null };
        if (!this.Texts) return range;

        var xPointCount=this.ChartFrame.XPointCount;
        var start=this.Data.DataOffset;
        var end=start+xPointCount;

        for(var i in this.Texts)
        {
            var item=this.Texts[i];
            if (item.Index>=start && item.Index<end)
            {
                if (range.Max==null) range.Max=item.Value;
                else if (range.Max<item.Value) range.Max=item.Value;
                if (range.Min==null) range.Min=item.Value;
                else if (range.Min>item.Value) range.Min=item.Value;
            }
        }

        return range;
    }
}

// 图标集合 支持横屏
function ChartMultiSVGIcon()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName="ChartMultiSVGIcon";
    this.Icon;  //[ {Index:, Value:, Symbol:, Color:, Baseline:, Line:{ Color:, Dash:[虚线点], KData:"H/L", Offset:[5,10], Width:线粗细 } } ]
    this.IconSize={ Max: g_JSChartResource.DRAWICON.Icon.MaxSize, Min:g_JSChartResource.DRAWICON.Icon.MinSize ,    //图标的最大最小值
        Zoom:{ Type:g_JSChartResource.DRAWICON.Icon.Zoom.Type , Value:g_JSChartResource.DRAWICON.Icon.Zoom.Value } //放大倍数
    }; 
    this.Family;
    this.Color=g_JSChartResource.DefaultTextColor;
    this.IsHScreen=false;
    this.IconRect=[];   //0=序号,1=区域

    this.Draw=function()
    {
        this.IconRect=[];
        if (!this.IsShow) return;
        if (!this.Data || this.Data.length<=0) return;
        if (!this.Family || !this.Icon) return;
        if (!IFrameSplitOperator.IsNonEmptyArray(this.Icon)) return;

        this.IsHScreen=(this.ChartFrame.IsHScreen===true);
        var xPointCount=this.ChartFrame.XPointCount;
        var offset=this.Data.DataOffset;
        this.DataWidth=this.ChartFrame.DataWidth;
        this.DistanceWidth=this.ChartFrame.DistanceWidth;

        var border=this.GetBorder();
        if (this.IsHScreen)
        {
            var left=border.TopEx;
            var right=border.BottomEx;
        }
        else
        {
            var left=border.LeftEx;
            var right=border.RightEx;
        }

        var fontSize=this.GetDynamicIconSize(this.DataWidth,this.DistanceWidth,this.IconSize.Max,this.IconSize.Min,this.IconSize.Zoom);
        this.Canvas.font=fontSize+'px '+this.Family;

        for(var i=0; i<this.Icon.length; ++i)
        {
            var item=this.Icon[i];
            if (!IFrameSplitOperator.IsNumber(item.Index)) continue;

            var index=item.Index-offset;
            if (index>=0 && index<xPointCount)
            {
                var x=this.ChartFrame.GetXFromIndex(index);
                var y=this.ChartFrame.GetYFromData(item.Value);

                if (item.Color)  this.Canvas.fillStyle = item.Color;
                else this.Canvas.fillStyle = this.Color;

                var textWidth=this.Canvas.measureText(item.Text).width;
                this.Canvas.textAlign='center';
                var rtIcon=new Rect(x-fontSize/2,y-fontSize/2,fontSize,fontSize);
                if (x+textWidth/2>=right) 
                {
                    this.Canvas.textAlign='right';
                    x+=this.DataWidth/2;
                    rtIcon.X=x-fontSize;
                }
                else if (x-textWidth/2<left)
                {
                    this.Canvas.textAlign = 'left';
                    x-=this.DataWidth/2;
                    rtIcon.X=x;
                }

                if (item.Baseline==1) 
                {
                    this.Canvas.textBaseline='top';
                    rtIcon.Y=y;
                }
                else if (item.Baseline==2) 
                {
                    this.Canvas.textBaseline='bottom';
                    rtIcon.Y=y-fontSize;
                }
                else 
                {
                    this.Canvas.textBaseline = 'middle';
                    rtIcon.Y=y-fontSize/2;
                }

                if (this.IsHScreen)
                {
                    this.Canvas.save(); 
                    this.Canvas.translate(y, x);
                    this.Canvas.rotate(90 * Math.PI / 180);
                    this.Canvas.fillText(item.Symbol,0,0);
                    this.Canvas.restore();
                }
                else
                {
                    this.Canvas.fillText(item.Symbol, x, y);
                    if (item.Text) this.IconRect.push({ Index:i, Rect:rtIcon , Item:item });
                }

                if (item.Line)
                {
                    var kItem=this.Data.Data[item.Index];
                    var price=item.Line.KData=="H"? kItem.High:kItem.Low;
                    var yPrice=this.ChartFrame.GetYFromData(price);
                    var yText=y;
                    if (Array.isArray(item.Line.Offset) && item.Line.Offset.length==2)
                    {
                        if (yText>yPrice) //文字在下方
                        {
                            yText-=item.Line.Offset[1];
                            yPrice+=item.Line.Offset[0]
                        }
                        else if (yText<yPrice)
                        {
                            yText+=item.Line.Offset[1];
                            yPrice-=item.Line.Offset[0]
                        }
                    }
                    this.Canvas.save();
                    if (item.Line.Dash) this.Canvas.setLineDash(item.Line.Dash);    //虚线
                    if (item.Line.Width>0) this.Canvas.lineWidth=item.Line.Width;   //线宽
                    this.Canvas.strokeStyle = item.Line.Color;
                    this.Canvas.beginPath();
                    if (this.IsHScreen)
                    {
                        this.Canvas.moveTo(yText, ToFixedPoint(x));
                        this.Canvas.lineTo(yPrice,ToFixedPoint(x));
                    }
                    else
                    {
                        this.Canvas.moveTo(ToFixedPoint(x),yText);
                        this.Canvas.lineTo(ToFixedPoint(x),yPrice);
                    }
                    
                    this.Canvas.stroke();
                    this.Canvas.restore();
                }
            }
        }
    }

    this.GetTooltipData=function(x,y,tooltip)
    {
        if (!IFrameSplitOperator.IsNonEmptyArray(this.IconRect)) return false;
        for(var i=0; i<this.IconRect.length; ++i)
        {
            var item=this.IconRect[i];
            if (!item.Rect) continue;
            var rect=item.Rect;
            this.Canvas.beginPath();
            this.Canvas.rect(rect.X,rect.Y,rect.Width,rect.Height);
            if (this.Canvas.isPointInPath(x,y))
            {
                JSConsole.Chart.Log('[ChartMultiSVGIcon::GetTooltipData] icon ', item);
                tooltip.Data=item;
                tooltip.ChartPaint=this;
                tooltip.Type=4; //指标
                return true;
            }
        }

        return false;
    }

    this.GetMaxMin=function()
    {
        var range={ Min:null, Max:null };
        var xPointCount=this.ChartFrame.XPointCount;
        var start=this.Data.DataOffset;
        var end=start+xPointCount;

        for(var i in this.Icon)
        {
            var item=this.Icon[i];
            if (item.Index>=start && item.Index<end)
            {
                if (range.Max==null) range.Max=item.Value;
                else if (range.Max<item.Value) range.Max=item.Value;
                if (range.Min==null) range.Min=item.Value;
                else if (range.Min>item.Value) range.Min=item.Value;
            }
        }

        return range;
    }
}

// 多dom节点
function ChartMultiHtmlDom()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName="ChartMultiHtmlDom";
    this.Texts=[];  //[ {Index:, Value:, Text: ] Text=dom内容
    this.IsHScreen=false;   //是否横屏
    this.DrawCallback;  //function(op, obj)  op:1=开始 2=结束 3=绘制单个数据
    this.DrawItem=[];
    this.EnableDraw=true;   //是否允许绘制
    this.HQChart;

    this.Draw=function()
    {
        if (!this.EnableDraw) return;

        this.DrawItem=[];
        if (this.DrawCallback) this.DrawCallback(1, {Self:this} );

        this.DrawDom();

        if (this.DrawCallback) this.DrawCallback(2, { Self:this, DrawItem:this.DrawItem } );
    }

    this.DrawDom=function()
    {
        if (!this.IsShow) return;
        if (!this.Data || this.Data.length<=0) return;

        this.IsHScreen=(this.ChartFrame.IsHScreen===true);
        var xPointCount=this.ChartFrame.XPointCount;
        var offset=this.Data.DataOffset;
        var top=this.ChartBorder.GetTopEx();
        var bottom=this.ChartBorder.GetBottomEx();
        var pixelTatio = GetDevicePixelRatio();
        if (this.HQChart)
        {
            var elementLeft=this.HQChart.UIElement.getBoundingClientRect().left;
            var elementTop=this.HQChart.UIElement.getBoundingClientRect().top;
        }
        else
        {
            var elementLeft=null,elementTop=null;
        }
        

        for(var i in this.Texts)
        {
            var item=this.Texts[i];

            if (!item.Text) continue;
            if (!IFrameSplitOperator.IsNumber(item.Index)) continue;

            var isMinuteFrame=this.IsMinuteFrame();

            var index=item.Index-offset;
            var kItem=this.Data.Data[item.Index];   //K线数据
            var obj={ KData:kItem, Item:item, IsShow:false, Self:this };
            if (index>=0 && index<xPointCount)
            {
                var x=this.ChartFrame.GetXFromIndex(index);
                if (item.Value=="Top")
                {
                    var y=top;
                }
                else if (item.Value=="Bottom")
                {
                    var y=bottom;
                }
                else
                {
                    var y=this.ChartFrame.GetYFromData(item.Value);
                }

                obj.X=x/pixelTatio;
                obj.Y=y/pixelTatio;
                obj.UIElement={Left:elementLeft, Top:elementTop};
                obj.IsShow=true;
            }

            this.DrawItem.push(obj);
            if (this.DrawCallback) this.DrawCallback(3, obj);

            if (item.Line)
            {
                if (isMinuteFrame)
                {
                    var price=this.Data.Data[item.Index];
                }
                else
                {
                    var kItem=this.Data.Data[item.Index];
                    var price=item.Line.KData=="H"? kItem.High:kItem.Low;
                }
                
                var yPrice=this.ChartFrame.GetYFromData(price);
                var yText=y;
                if (Array.isArray(item.Line.Offset) && item.Line.Offset.length==2)
                {
                    if (yText>yPrice) //文字在下方
                    {
                        yText-=item.Line.Offset[1];
                        yPrice+=item.Line.Offset[0]
                    }
                    else if (yText<yPrice)
                    {
                        yText+=item.Line.Offset[1];
                        yPrice-=item.Line.Offset[0]
                    }
                }
                this.Canvas.save();
                if (item.Line.Dash) this.Canvas.setLineDash(item.Line.Dash);    //虚线
                var pixelRatio=GetDevicePixelRatio();
                var lineWidth=1*pixelRatio;
                if (item.Line.Width>0) lineWidth=item.Line.Width*pixelRatio;
                this.Canvas.lineWidth=lineWidth;   //线宽
                this.Canvas.strokeStyle = item.Line.Color;
                this.Canvas.beginPath();
                if (this.IsHScreen)
                {
                    this.Canvas.moveTo(yText, ToFixedPoint(x));
                    this.Canvas.lineTo(yPrice,ToFixedPoint(x));
                }
                else
                {
                    this.Canvas.moveTo(ToFixedPoint2(lineWidth,x),yText);
                    this.Canvas.lineTo(ToFixedPoint2(lineWidth,x),yPrice);
                }
                
                this.Canvas.stroke();
                this.Canvas.restore();
            }
        }
    }

    this.GetMaxMin=function()
    {
        var range={ Min:null, Max:null };
        var xPointCount=this.ChartFrame.XPointCount;
        var start=this.Data.DataOffset;
        var end=start+xPointCount;

        for(var i in this.Texts)
        {
            var item=this.Texts[i];
            if (!IFrameSplitOperator.IsNumber(item.Index)) continue;
            if (item.Index>=start && item.Index<end)
            {
                if (range.Max==null) range.Max=item.Value;
                else if (range.Max<item.Value) range.Max=item.Value;
                if (range.Min==null) range.Min=item.Value;
                else if (range.Min>item.Value) range.Min=item.Value;
            }
        }

        return range;
    }
}

//锁  支持横屏
function ChartLock()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName="ChartLock";
    this.WidthDiv = 0.2;  // 框子宽度占比
    this.LockCount = 20; // 锁最新的几个数据
    this.BGColor = g_JSChartResource.LockBGColor;
    this.TextColor = g_JSChartResource.LockTextColor;
    this.Font = g_JSChartResource.DefaultTextFont;
    this.Title = '🔒开通权限';
    this.LockRect=null; //上锁区域
    this.LockID;        //锁ID
    this.Callback;      //回调
    this.IndexName;     //指标名字
    this.MinWidth=null;  //最小宽度

    this.Draw=function(isDraw)
    {
        this.LockRect=null;
        if (this.NotSupportMessage)
        {
            this.DrawNotSupportmessage();
            return;
        }

        if (this.ChartFrame.IsHScreen===true)
        {
            this.HScreenDraw(isDraw);
            return;
        }

        var xOffset = this.ChartBorder.GetRight();
        var lOffsetWidth = 0;
        if (this.ChartFrame.Data != null)
        {
            var dataWidth=this.ChartFrame.DataWidth;
            var distanceWidth=this.ChartFrame.DistanceWidth;
            xOffset=this.ChartBorder.GetLeft()+distanceWidth/2.0+2.0;
            var chartright=this.ChartBorder.GetRight();
            var xPointCount=this.ChartFrame.XPointCount;
            for(var i=this.ChartFrame.Data.DataOffset,j=0;i<this.ChartFrame.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
            {
                var data=this.ChartFrame.Data.Data[i];
                if (data.Open==null || data.High==null || data.Low==null || data.Close==null) continue;

                var left=xOffset;
                var right=xOffset+dataWidth;
                if (right>chartright) break;
            }
            lOffsetWidth = (dataWidth + distanceWidth) * this.LockCount;    
        }
        if (lOffsetWidth == 0)
        {
            lOffsetWidth = (xOffset - this.ChartBorder.GetLeft()) * this.WidthDiv;
        }
        var lLeft = xOffset - lOffsetWidth;
        if (lLeft < this.ChartBorder.GetLeft())
            lLeft = this.ChartBorder.GetLeft();
        var lHeight = this.ChartBorder.GetBottom() - this.ChartBorder.GetTop();
        var lWidth = this.ChartBorder.GetRight() - lLeft;

        if (this.MinWidth>10 && lWidth<this.MinWidth) 
        {
            lWidth=this.MinWidth;
            lLeft=this.ChartBorder.GetRight()-lWidth;
            if (lLeft < this.ChartBorder.GetLeft()) lLeft = this.ChartBorder.GetLeft();
        }

        if (isDraw)
        {
            this.Canvas.fillStyle = this.BGColor;
            this.Canvas.fillRect(lLeft, this.ChartBorder.GetTop(), lWidth, lHeight);
            var xCenter = lLeft + lWidth / 2;
            var yCenter = this.ChartBorder.GetTop() + lHeight / 2;
            this.Canvas.textAlign = 'center';
            this.Canvas.textBaseline = 'middle';
            this.Canvas.fillStyle = this.TextColor;
            this.Canvas.font = this.Font;
            this.Canvas.fillText(this.Title, xCenter, yCenter);
        }

        this.LockRect={Left:lLeft,Top:this.ChartBorder.GetTop(),Width:lWidth,Heigh:lHeight};    //保存上锁区域
    }

    this.HScreenDraw=function(isDraw)
    {
        var xOffset = this.ChartBorder.GetBottom();

        var lOffsetWidth = 0;
        if (this.ChartFrame.Data != null)
        {
            var dataWidth=this.ChartFrame.DataWidth;
            var distanceWidth=this.ChartFrame.DistanceWidth;
            xOffset=this.ChartBorder.GetTop()+distanceWidth/2.0+2.0;
            var chartright=this.ChartBorder.GetBottom();
            var xPointCount=this.ChartFrame.XPointCount;
            //求最后1个数据的位置
            for(var i=this.ChartFrame.Data.DataOffset,j=0;i<this.ChartFrame.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
            {
                var data=this.ChartFrame.Data.Data[i];
                if (data.Open==null || data.High==null || data.Low==null || data.Close==null) continue;

                var left=xOffset;
                var right=xOffset+dataWidth;
                if (right>chartright) break;
            }
            lOffsetWidth = (dataWidth + distanceWidth) * this.LockCount;    
        }
        if (lOffsetWidth == 0)
        {
            lOffsetWidth = (xOffset - this.ChartBorder.GetTop()) * this.WidthDiv;
        }

        var lLeft = xOffset - lOffsetWidth;
        if (lLeft < this.ChartBorder.GetTop()) lLeft = this.ChartBorder.GetTop();
        var lHeight =  this.ChartBorder.GetRight()-this.ChartBorder.GetLeft();
        var lWidth = this.ChartBorder.GetBottom() - lLeft;
        this.Canvas.fillStyle = this.BGColor;
        this.Canvas.fillRect(this.ChartBorder.GetLeft(), lLeft,lHeight,lWidth);

        var xCenter = this.ChartBorder.GetLeft() + lHeight / 2;
        var yCenter = lLeft + lWidth / 2;
        this.Canvas.save(); 
        this.Canvas.translate(xCenter, yCenter);
        this.Canvas.rotate(90 * Math.PI / 180);
        this.Canvas.textAlign = 'center';
        this.Canvas.textBaseline = 'middle';
        this.Canvas.fillStyle = this.TextColor;
        this.Canvas.font = this.Font;
        this.Canvas.fillText(this.Title, 0, 0);
        this.Canvas.restore();

        this.LockRect={Left:this.ChartBorder.GetLeft(),Top:lLeft,Width:lHeight,Heigh:lWidth};    //保存上锁区域
    }

    //x,y是否在上锁区域
    this.GetTooltipData=function(x,y,tooltip)
    {
        if (this.LockRect==null) return false;

        this.Canvas.beginPath();
        this.Canvas.rect(this.LockRect.Left,this.LockRect.Top,this.LockRect.Width,this.LockRect.Heigh);
        if (this.Canvas.isPointInPath(x,y))
        {
            tooltip.Data={ ID:this.LockID, Callback:this.Callback, IndexName:this.IndexName };
            tooltip.ChartPaint=this;
            return true;
        }
        
        return false;
    }
}

//买卖盘
function ChartBuySell()
{
    this.newMethod=ChartSingleText;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName="ChartBuySell";
    this.TextFont=g_JSChartResource.KLineTrain.Font;                //"bold 14px arial";           //买卖信息字体
    this.LastDataIcon=g_JSChartResource.KLineTrain.LastDataIcon;    //{Color:'rgb(0,0,205)',Text:'↓'};
    this.BuyIcon=g_JSChartResource.KLineTrain.BuyIcon;              //{Color:'rgb(0,0,205)',Text:'B'};
    this.SellIcon=g_JSChartResource.KLineTrain.SellIcon;            //{Color:'rgb(0,0,205)',Text:'S'};
    this.BuySellData=new Map();                                     //Key=数据索引index Value:Data:[ { Op: 买/卖 0=buy 1=sell, Date:, Time, Price: Vol:}, ] 
    this.IconFont=g_JSChartResource.KLineTrain.IconFont;

    this.AddTradeItem=function(tradeItem)
    {
        if (this.BuySellData.has(tradeItem.Key))
        {
            var Trade=this.BuySellData.get(tradeItem.Key);
            Trade.Data.push(tradeItem);
        }
        else
        {
            this.BuySellData.set(tradeItem.Key, { Data:[tradeItem] });
        }
    }

    this.ClearTradeData=function()
    {
        this.BuySellData=new Map(); 
    }

    this.Draw=function()
    {
        if (!this.Data || !this.Data.Data) return;

        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var dataWidth=this.ChartFrame.DataWidth;
        var distanceWidth=this.ChartFrame.DistanceWidth;
        var chartright=this.ChartBorder.GetRight();
        if (isHScreen===true) chartright=this.ChartBorder.GetBottom();
        var xPointCount=this.ChartFrame.XPointCount;

        if (this.IconFont)
        {
            var pixelTatio = GetDevicePixelRatio(); //获取设备的分辨率
            var iconSize=dataWidth+distanceWidth;
            var minIconSize=18*pixelTatio;
            if (iconSize<minIconSize) iconSize=minIconSize;
            this.Canvas.font=iconSize+'px '+this.IconFont.Family;
        }
        else
        {
            this.Canvas.font=this.TextFont;
        }
        
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var value=this.Data.Data[i];
            if (value==null) continue;
            var x=this.ChartFrame.GetXFromIndex(j);
            if (x>chartright) break;

            if (i==this.Data.Data.length-1)
            {
                //最后一个位置 画一个箭头
                var x=this.ChartFrame.GetXFromIndex(j);
                var yHigh=this.ChartFrame.GetYFromData(value.High);
                this.Canvas.textAlign='center';
                this.Canvas.textBaseline='bottom';
                if (this.IconFont)
                {
                    this.Canvas.fillStyle=this.IconFont.Last.Color
                    this.DrawText(this.IconFont.Last.Text,x,yHigh,isHScreen);
                }
                else
                {
                    this.Canvas.fillStyle=this.LastDataIcon.Color;
                    this.Canvas.font=this.TextFont;
                    this.DrawText(this.LastDataIcon.Text,x,yHigh,isHScreen);
                }
            }

            var key=i;
            if (!this.BuySellData.has(key)) continue;

            var trade=this.BuySellData.get(key);
            var yHigh=this.ChartFrame.GetYFromData(value.High);
            var yLow=this.ChartFrame.GetYFromData(value.Low);
            var drawInfo=[false, false];    //0=buy 1=sell
            for(var k in trade.Data)
            {
                if (drawInfo[0]==true && drawInfo[1]==true) break;  //买卖图标只画一次

                var bsItem=trade.Data[k];
                if (bsItem.Op==0 && drawInfo[0]==false)   //买 标识在最低价上
                {
                    this.Canvas.textAlign='center';
                    this.Canvas.textBaseline='top';
                    if (this.IconFont)
                    {
                        this.Canvas.fillStyle=this.IconFont.Buy.Color
                        this.DrawText(this.IconFont.Buy.Text,x,yLow,isHScreen);
                    }
                    else
                    {
                        this.Canvas.fillStyle=this.BuyIcon.Color;
                        this.DrawText(this.BuyIcon.Text,x,yLow,isHScreen);
                    }

                    drawInfo[0]=true;
                }
                else if (bsItem.Op==1 && drawInfo[1]==false)   //卖 标识在最高价上
                {
                    this.Canvas.textAlign='center';
                    this.Canvas.textBaseline='bottom';
                    if (this.IconFont)
                    {
                        this.Canvas.fillStyle=this.IconFont.Sell.Color
                        this.DrawText(this.IconFont.Sell.Text,x,yHigh,isHScreen);
                    }
                    else
                    {
                        this.Canvas.fillStyle=this.SellIcon.Color;
                        this.DrawText(this.SellIcon.Text,x,yHigh,isHScreen);
                    }

                    drawInfo[1]=true;
                }
            }
        }   
    }
}

//深度图
function ChartOrderbookDepth()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName="ChartOrderbookDepth";
    this.Data=null;

    this.AskColor={ Line:g_JSChartResource.DepthChart.AskColor.Line, Area:g_JSChartResource.DepthChart.AskColor.Area }      //卖
    this.BidColor={ Line:g_JSChartResource.DepthChart.BidColor.Line, Area:g_JSChartResource.DepthChart.BidColor.Area }      //买
    this.LineWidth=g_JSChartResource.DepthChart.LineWidth;

    this.Draw=function()
    {
        if (!this.Data) return;

        var lineWidthBackup=this.Canvas.lineWidth;
        this.Canvas.lineWidth=this.LineWidth * GetDevicePixelRatio();
        this.DrawArea(this.Data.Bids, this.BidColor.Line, this.BidColor.Area, true);
        this.DrawArea(this.Data.Asks, this.AskColor.Line, this.AskColor.Area, false);
        this.Canvas.lineWidth=lineWidthBackup;
    }

    this.DrawArea=function(aryData, colorLine, colorArea, isLeft)
    {
        var xRange=this.ChartFrame.VerticalRange;
        var aryPoint=[];
        for(var i in aryData)
        {
            var item=aryData[i];
            if (isLeft)
            {
                if (item.Price<xRange.Min) break;
            }
            else
            {
                if (item.Price>xRange.Max) break;
            }

            var x=this.ChartFrame.GetXFromIndex(item.Price);
            var y=this.ChartFrame.GetYFromData(item.Vol);
            aryPoint.push({X:x,Y:y});
        }
        if (aryPoint.length<=1) return;

        var left=this.ChartBorder.GetLeft();
        var bottom=this.ChartBorder.GetBottom();
        var right=this.ChartBorder.GetRight();

        this.Canvas.beginPath();
        this.Canvas.moveTo(aryPoint[0].X, bottom);
        for(var i in aryPoint)
        {
            var item=aryPoint[i];
            this.Canvas.lineTo(item.X,item.Y);
        }

        this.Canvas.lineTo(isLeft?left:right,aryPoint[aryPoint.length-1].Y);
        this.Canvas.lineTo(isLeft?left:right,bottom);
        this.Canvas.lineTo(aryPoint[0].X,bottom);
        this.Canvas.closePath();
        this.Canvas.fillStyle = colorArea;
        this.Canvas.fill();

        this.Canvas.beginPath();
        this.Canvas.moveTo(aryPoint[0].X, bottom);
        for(var i in aryPoint)
        {
            var item=aryPoint[i];
            this.Canvas.lineTo(item.X,item.Y);
        }
        this.Canvas.lineTo(isLeft?left:right,aryPoint[aryPoint.length-1].Y);
        this.Canvas.strokeStyle=colorLine;
        this.Canvas.stroke();
    }

    this.GetMaxMin=function()
    {
        var range={ Min:null, Max:null, XMin:null, XMax:null };
        var xRange=this.ChartFrame.VerticalRange;

        for(var i in this.Data.Asks)
        {
            var item=this.Data.Asks[i];
            if (item.Price>xRange.Max) break;
            
            if (range.XMin==null || range.XMin>item.Price) range.XMin=item.Price;
            if (range.XMax==null || range.XMax<item.Price) range.XMax=item.Price;
            if (range.Min==null || range.Min>item.Vol) range.Min=item.Vol;
            if (range.Max==null || range.Max<item.Vol) range.Max=item.Vol;
        }

        for(var i in this.Data.Bids)
        {
            var item=this.Data.Bids[i];
            if (item.Price<xRange.Min) break;

            if (range.XMin==null || range.XMin>item.Price) range.XMin=item.Price;
            if (range.XMax==null || range.XMax<item.Price) range.XMax=item.Price;
            if (range.Min==null || range.Min>item.Vol) range.Min=item.Vol;
            if (range.Max==null || range.Max<item.Vol) range.Max=item.Vol;
        }

        return range;
    }
}

/*
    饼图
*/
function ChartPie()
{   
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.Radius = 100; //半径默认值
    this.Distance = 30; //指示线超出圆饼的距离
    this.txtLine = 20; // 文本下划线
    this.paddingX = 20 / 3;// 设置文本的移动
    
    // return;
    this.Draw=function()
    {
        if (!this.Data || !this.Data.Data || !(this.Data.Data.length>0)) return this.DrawEmptyData();

        let left=this.ChartBorder.GetLeft();
        let right=this.ChartBorder.GetRight();
        let top=this.ChartBorder.GetTop();
        let bottom=this.ChartBorder.GetBottom();
        let width=this.ChartBorder.GetWidth();
        let height=this.ChartBorder.GetHeight();

        if(isNaN(this.Radius)){
            let str = this.Radius.replace("%","");
            str = str/100;
            if(width >= height){
                this.Radius = str*height;
            }
            if(width < height) this.Radius = str*width;
        }


        this.Canvas.save();
        this.Canvas.translate(width/2,height/2);

        let totalValue=0;   //求和
        for(let i in this.Data.Data)
        {
            totalValue += this.Data.Data[i].Value;
        }
        let start = 0;
        let end = 0;
        //画饼图
        for(let i in this.Data.Data)
        {
            let item =this.Data.Data[i];
            let rate=(item.Value/totalValue).toFixed(2); //占比
            //JSConsole.Chart.Log('[ChartPie::Draw]', i, rate, item);

            // 绘制扇形
            this.Canvas.beginPath();
            this.Canvas.moveTo(0,0);

            end += rate*2*Math.PI;//终止角度
            this.Canvas.strokeStyle = "white";
            this.Canvas.fillStyle = item.Color;
            this.Canvas.arc(0,0,this.Radius,start,end);
            this.Canvas.fill();
            this.Canvas.closePath();
            this.Canvas.stroke();
            
            // 绘制直线
            this.Canvas.beginPath();
            this.Canvas.strokeStyle = item.Color;
            this.Canvas.moveTo(0,0);
            let x = (this.Radius + this.Distance)*Math.cos(end- (end-start)/2);
            let y = (this.Radius + this.Distance)*Math.sin(end - (end-start)/2);
            this.Canvas.lineTo(x,y);
            // JSConsole.Chart.Log(x,y,"xy")
            
            // 绘制横线
            let txtLine = this.txtLine;
            let paddingX = this.paddingX;
            this.Canvas.textAlign = 'left';
            if( end - (end-start)/2 < 1.5*Math.PI && end - (end-start)/2 > 0.5*Math.PI ){
                
                txtLine = - this.txtLine;
                paddingX = - this.paddingX;
                this.Canvas.textAlign = 'right';
            }
            this.Canvas.lineTo( x + txtLine, y );
            this.Canvas.stroke();

             // 写文字
             if(item.Text){
                 this.Canvas.fillText( item.Text, x + txtLine + paddingX, y );
             }else{
                 let text = `${item.Name}:${item.Value}`;
                 this.Canvas.fillText( text, x + txtLine + paddingX, y );
             }
            

            start += rate*2*Math.PI;//起始角度
        }

        this.Canvas.restore();
    }

    //空数据
    this.DrawEmptyData=function()
    {
        JSConsole.Chart.Log('[ChartPie::DrawEmptyData]')
    }
}


/*
    雷达图
*/
function ChartRadar()
{
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.BorderPoint=[];    //边框点
    this.DataPoint=[];      //数据点
    this.CenterPoint={};
    this.StartAngle=0;
    this.Color='rgb(198,198,198)';
    this.AreaColor='rgba(242,154,118,0.4)';    //面积图颜色
    this.AreaLineColor='rgb(242,154,118)';
    this.TitleFont=24*GetDevicePixelRatio()+'px 微软雅黑';
    this.TitleColor='rgb(102,102,102)';
    this.BGColor = ['rgb(255,255,255)', 'rgb(224,224,224)']//背景色

    this.DrawBorder=function()  //画边框
    {
        if (this.BorderPoint.length<=0) return;

        this.Canvas.font=this.TitleFont;
        this.Canvas.strokeStyle = this.Color;
        const aryBorder=[1,0.8,0.6,0.4,0.2];
        for (let j in aryBorder)
        {
            var rate = aryBorder[j];
            var isFirstDraw=true;
            for(let i in this.BorderPoint)
            {
                var item=this.BorderPoint[i];
                item.X = this.CenterPoint.X + item.Radius * Math.cos(item.Angle * Math.PI / 180) * rate;
                item.Y = this.CenterPoint.Y + item.Radius * Math.sin(item.Angle * Math.PI / 180) * rate;
                if (isFirstDraw)
                {
                    this.Canvas.beginPath();
                    this.Canvas.moveTo(item.X,item.Y);
                    isFirstDraw=false;
                }
                else
                {
                    this.Canvas.lineTo(item.X,item.Y);
                }
            }

            this.Canvas.closePath();
            this.Canvas.stroke();
            this.Canvas.fillStyle = this.BGColor[j%2==0?0:1];
            this.Canvas.fill();
        }

        this.Canvas.beginPath();
        for(let i in this.BorderPoint)
        {
            var item=this.BorderPoint[i];
            item.X = this.CenterPoint.X + item.Radius * Math.cos(item.Angle * Math.PI / 180);
            item.Y = this.CenterPoint.Y + item.Radius * Math.sin(item.Angle * Math.PI / 180);
            this.Canvas.moveTo(this.CenterPoint.X,this.CenterPoint.Y);
            this.Canvas.lineTo(item.X,item.Y);
            this.DrawText(item);
        }
        this.Canvas.stroke();
    }

    this.DrawArea=function()
    {
        if (!this.DataPoint || this.DataPoint.length<=0) return;

        this.Canvas.fillStyle = this.AreaColor;
        this.Canvas.strokeStyle = this.AreaLineColor;
        this.Canvas.beginPath();
        var isFirstDraw=true;
        for(let i in this.DataPoint)
        {
            var item=this.DataPoint[i];
            if (isFirstDraw)
            {
                this.Canvas.beginPath();
                this.Canvas.moveTo(item.X,item.Y);
                isFirstDraw=false;
            }
            else
            {
                this.Canvas.lineTo(item.X,item.Y);
            }
        }

        this.Canvas.closePath();
        this.Canvas.fill();
        this.Canvas.stroke();
    }

    this.DrawText=function(item)
    {
        if (!item.Text) return;
          
        //JSConsole.Chart.Log(item.Text, item.Angle);
        this.Canvas.fillStyle = this.TitleColor;
        var xText = item.X, yText = item.Y;

        //显示每个角度的位置
        if (item.Angle > 0 && item.Angle < 45) {
            this.Canvas.textAlign = 'left';
            this.Canvas.textBaseline = 'middle';
            xText += 2;
        }
        else if (item.Angle >= 0 && item.Angle < 90) {
            this.Canvas.textAlign = 'left';
            this.Canvas.textBaseline = 'top';
            xText += 2;
        }
        else if (item.Angle >= 90 && item.Angle < 135) {
            this.Canvas.textAlign = 'right';
            this.Canvas.textBaseline = 'top';
            xText -= 2;
        }
        else if (item.Angle >= 135 && item.Angle < 180) {
            this.Canvas.textAlign = 'right';
            this.Canvas.textBaseline = 'top';
            xText -= 2;
        }
        else if (item.Angle >= 180 && item.Angle < 225) {
            this.Canvas.textAlign = 'right';
            this.Canvas.textBaseline = 'middle';
            xText -= 2;
        }
        else if (item.Angle >= 225 && item.Angle <= 270) {
            this.Canvas.textAlign = 'center';
            this.Canvas.textBaseline = 'bottom';
        }
        else if (item.Angle > 270 && item.Angle < 315) {
            this.Canvas.textAlign = 'left';
            this.Canvas.textBaseline = 'bottom';
            xText += 2;
        }
        else {
            this.Canvas.textAlign = 'left';
            this.Canvas.textBaseline = 'middle';
            xText += 2;
        }

        this.Canvas.fillText(item.Text, xText, yText);
    }

    this.Draw=function()
    {
        this.BorderPoint=[];
        this.DataPoint=[];
        this.CenterPoint={};
        if (!this.Data || !this.Data.Data || !(this.Data.Data.length>0))
            this.CalculatePoints(null);
        else 
            this.CalculatePoints(this.Data.Data);

        this.DrawBorder();
        this.DrawArea();
    }

    this.CalculatePoints=function(data)
    {
        let left=this.ChartBorder.GetLeft();
        let right=this.ChartBorder.GetRight();
        let top=this.ChartBorder.GetTop();
        let bottom=this.ChartBorder.GetBottom();
        let width=this.ChartBorder.GetWidth();
        let height=this.ChartBorder.GetHeight();

        let ptCenter={X:left+width/2, Y:top+height/2};  //中心点
        let radius=Math.min(width/2,height/2)-2         //半径
        let count=Math.max(5,data?data.length:0);
        let averageAngle=360/count;
        for(let i=0;i<count;++i)
        {
            let ptBorder = { Index: i, Radius: radius, Angle: i * averageAngle + this.StartAngle };
            let angle = ptBorder.Angle;

            if (data && i<data.length)
            {
                var item=data[i];
                let ptData={Index:i,Text:item.Text};
                ptBorder.Text=item.Name;
                if (!item.Value)
                {
                    ptData.X=ptCenter.X;
                    ptData.Y=ptCenter.Y;
                } 
                else
                {
                    var value=item.Value;
                    if (value>=1) value=1;
                    var dataRadius=radius*value;
                    ptData.X=ptCenter.X+dataRadius*Math.cos(angle*Math.PI/180);
                    ptData.Y=ptCenter.Y+dataRadius*Math.sin(angle*Math.PI/180);
                }

                this.DataPoint.push(ptData);
            }

            this.BorderPoint.push(ptBorder);
        }

        this.CenterPoint=ptCenter;
    }

    //空数据
    this.DrawEmptyData=function()
    {
        JSConsole.Chart.Log('[ChartPie::DrawEmptyData]')
    }
}

/*
    中国地图
*/


function ChartChinaMap()
{   
    this.newMethod=IChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ImageData=null;
    this.Left;
    this.Top;
    this.Width;
    this.Height;
    this.ImageWidth;
    this.ImageHeight;

    this.DefaultColor=[217,222,239];

    this.Color=
    [
        {Name:'海南',       Color:'rgb(217,222,223)'},
        {Name:'内蒙古',     Color:'rgb(217,222,225)'},
        {Name:'新疆',       Color:'rgb(217,222,226)'},
        {Name:'青海',       Color:'rgb(217,222,227)'},
        {Name:'西藏',       Color:'rgb(217,222,228)'},
        {Name:'云南',       Color:'rgb(217,222,229)'},
        {Name:'黑龙江',     Color:'rgb(217,222,230)'},
        {Name:'吉林',       Color:'rgb(217,222,231)'},
        {Name:'辽宁',       Color:'rgb(217,222,232)'},
        {Name:'河北',       Color:'rgb(217,222,233)'},
        {Name:'山东',       Color:'rgb(217,222,234)'},
        {Name:'江苏',       Color:'rgb(217,222,235)'},
        {Name:'浙江',       Color:'rgb(217,222,236)'},
        {Name:'福建',       Color:'rgb(217,222,237)'},
        {Name:'广东',       Color:'rgb(217,222,238)'},
        {Name:'广西',       Color:'rgb(217,222,239)'},
        {Name:'贵州',       Color:'rgb(217,222,240)'},
        {Name:'湖南',       Color:'rgb(217,222,241)'},
        {Name:'江西',       Color:'rgb(217,222,242)'},
        {Name:'安徽',       Color:'rgb(217,222,243)'},
        {Name:'湖北',       Color:'rgb(217,222,244)'},
        {Name:'重庆',       Color:'rgb(217,222,245)'},
        {Name:'四川',       Color:'rgb(217,222,246)'},
        {Name:'甘肃',       Color:'rgb(217,222,247)'},
        {Name:'陕西',       Color:'rgb(217,222,248)'},
        {Name:'山西',       Color:'rgb(217,222,249)'},
        {Name:'河南',       Color:'rgb(217,222,250)'}
    ];

    this.Draw=function()
    {
        let left=this.ChartBorder.GetLeft()+1;
        let right=this.ChartBorder.GetRight()-1;
        let top=this.ChartBorder.GetTop()+1;
        let bottom=this.ChartBorder.GetBottom()-1;
        let width=this.ChartBorder.GetWidth()-2;
        let height=this.ChartBorder.GetHeight()-2;

        let imageWidth=CHINA_MAP_IMAGE.width;
        let imageHeight=CHINA_MAP_IMAGE.height;

        let drawImageWidth=imageWidth;
        let drawImageHeight=imageHeight;

        if (height<drawImageHeight || width<drawImageWidth) 
        {
            this.ImageData=null;
            return;
        }

        if (this.Left!=left || this.Top!=top || this.Width!=width || this.Height!=height || this.ImageWidth!=imageWidth || this.ImageHeight!=imageHeight)
        {
            this.ImageData=null;

            this.ImageWidth=imageWidth;
            this.ImageHeight=imageHeight;
            this.Left=left;
            this.Top=top;
            this.Width=width;
            this.Height=height;

            JSConsole.Chart.Log(imageWidth,imageHeight);
        }
        
        if (this.ImageData==null)
        {
            this.Canvas.drawImage(CHINA_MAP_IMAGE,0,0,imageWidth,imageHeight,left,top,drawImageWidth,drawImageHeight);
            this.ImageData=this.Canvas.getImageData(left,top,drawImageWidth,drawImageHeight);

            let defaultColorSet=new Set();  //默认颜色填充的色块
            let colorMap=new Map();         //定义颜色填充的色块

            let nameMap=new Map();
            if (this.Data.length>0)
            {
                for(let i in this.Data)
                {
                    let item=this.Data[i];
                    nameMap.set(item.Name,item.Color)
                }
            }

            JSConsole.Chart.Log(this.Data);
            for(let i in this.Color)
            {
                let item=this.Color[i];
                if (nameMap.has(item.Name))
                {
                    colorMap.set(item.Color,nameMap.get(item.Name));
                }
                else
                {
                    defaultColorSet.add(item.Color);
                }
            }

            var color;
            for (let i=0;i<this.ImageData.data.length;i+=4)
            {
                color='rgb('+ this.ImageData.data[i] + ',' + this.ImageData.data[i+1] + ',' + this.ImageData.data[i+2] + ')';

                if (defaultColorSet.has(color))
                {
                    this.ImageData.data[i]=this.DefaultColor[0];
                    this.ImageData.data[i+1]=this.DefaultColor[1];
                    this.ImageData.data[i+2]=this.DefaultColor[2];
                }
                else if (colorMap.has(color))
                {
                    let colorValue=colorMap.get(color);
                    this.ImageData.data[i]=colorValue[0];
                    this.ImageData.data[i+1]=colorValue[1];
                    this.ImageData.data[i+2]=colorValue[2];
                }
            }
            this.Canvas.clearRect(left,top,drawImageWidth,drawImageHeight);
            this.Canvas.putImageData(this.ImageData,left,top,0,0,drawImageWidth,drawImageHeight);
        }
        else
        {
            this.Canvas.putImageData(this.ImageData,left,top,0,0,drawImageWidth,drawImageHeight);
        }
    }
}

/*
    扩展图形
*/

function ExtendChartPaintFactory()
{
    this.DataMap=new Map(
        [
            ["FrameSplitPaint", {Create:function() { return new FrameSplitPaint(); }  }]
        ]
    );

    this.Create=function(name)
    {
        if (!this.DataMap.has(name)) return null;

        var item=this.DataMap.get(name);
        return item.Create();
    }

    this.Add=function(name, option)
    {
        this.DataMap.set(name, { Create:option.Create } );
    }
}

var g_ExtendChartPaintFactory=new ExtendChartPaintFactory();

function IExtendChartPainting()
{
    this.Canvas;                        //画布
    this.ChartBorder;                   //边框信息
    this.ChartFrame;                    //框架画法
    this.Name;                          //名称
    this.Data;                          //数据区
    this.IsDynamic=false;
    this.IsAnimation=false;             //是否是动画
    this.ClassName='IExtendChartPainting';
    this.SizeChange=true;               //大小是否改变
    this.IsEraseBG=false;               //是否每次画的时候需要擦除K线图背景
    this.DrawAfterTitle=false;          //是否在动态标题画完以后再画,防止动态标题覆盖
    this.IsCallbackDraw=false;          //在回调函数里绘制, 不在Draw()中绘制

    //上下左右间距
    this.Left=5;
    this.Right=5;
    this.Top=5;
    this.Bottom=5;

    this.Draw=function()
    {

    }

    //设置参数接口
    this.SetOption=function(option)
    {

    }

    this.GetFontHeight=function(font)
    {
        return GetFontHeight(this.Canvas, font, "擎");
    }

}

//K线Tooltip, 显示在左边或右边
function KLineTooltipPaint()
{
    this.newMethod=IExtendChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.IsDynamic=true;
    this.IsEraseBG=true;
    this.DrawAfterTitle=true;
    this.ClassName='KLineTooltipPaint';
    this.BorderColor=g_JSChartResource.TooltipPaint.BorderColor;    //边框颜色
    this.BGColor=g_JSChartResource.TooltipPaint.BGColor;            //背景色
    this.TitleColor=g_JSChartResource.TooltipPaint.TitleColor;      //标题颜色
    this.DateTimeColor=g_JSChartResource.TooltipPaint.DateTimeColor;      //日期时间颜色
    this.VolColor=g_JSChartResource.TooltipPaint.VolColor;       //标题成交量
    this.AmountColor=g_JSChartResource.TooltipPaint.AmountColor;    //成交金额
    this.LatestPoint;               //手势位置
    this.ShowPosition=0;            //显示位置 0=左 1=右

    this.Left=1*GetDevicePixelRatio();
    this.Top=5*GetDevicePixelRatio();
    
    this.Width=50;
    this.Height=100;
    this.LineHeight=15*GetDevicePixelRatio(); //行高

    this.Font=[g_JSChartResource.TooltipPaint.TitleFont];

    this.HQChart;
    this.KLineTitlePaint;
    this.IsHScreen=false;   //是否横屏
    this.LanguageID=JSCHART_LANGUAGE_ID.LANGUAGE_CHINESE_ID;

    this.ReloadResource=function(resource)
    {
        this.BorderColor=g_JSChartResource.TooltipPaint.BorderColor;    //边框颜色
        this.BGColor=g_JSChartResource.TooltipPaint.BGColor;            //背景色
        this.TitleColor=g_JSChartResource.TooltipPaint.TitleColor;      //标题颜色
        this.DateTimeColor=g_JSChartResource.TooltipPaint.DateTimeColor;      //日期时间颜色
        this.VolColor=g_JSChartResource.TooltipPaint.VolColor;       //标题成交量
        this.AmountColor=g_JSChartResource.TooltipPaint.AmountColor;    //成交金额
    }

    this.GetLeft=function()
    {
        if (this.IsHScreen) 
        {
            return this.ChartBorder.GetRightEx()-this.Height-this.Top;
        }
        else
        {
            if (this.ShowPosition==0)
                return this.ChartBorder.GetLeft()+this.Left;
            else 
                return this.ChartBorder.GetRight()-this.Width-this.Left;
        }
    }

    this.GetTop=function()
    {
        if (this.IsHScreen) 
        {
            if (this.ShowPosition==0)
                return this.ChartBorder.GetTop()+this.Left;
            else
                return this.ChartBorder.GetBottom()-this.Width-this.Left;
        }
        else
        {
            return this.ChartBorder.GetTopEx()+this.Top;
        }
    }

    this.IsEnableDraw=function()
    {
        if (!this.HQChart || !this.HQChart.TitlePaint || !this.HQChart.TitlePaint[0]) return false;
        if (this.HQChart.DragMode==JSCHART_DRAG_ID.CLICK_TOUCH_MODE_ID)
        {
            if (this.HQChart.TouchStatus.CorssCursorShow==false) return false;
        }
        else if (!this.HQChart.IsOnTouch) 
        {
            return false;
        }

        if (this.HQChart.CurrentChartDrawPicture) return false;   //画图工具操作的时候 不显示

        return true;
    }

    this.Draw=function()
    {
        if (!this.IsEnableDraw()) return;

        this.KLineTitlePaint=this.HQChart.TitlePaint[0];
        var klineData=this.KLineTitlePaint.GetCurrentKLineData();
        if (!klineData) return;

        var lineCount=8;    //显示函数
        var upperSymbol;
        if (this.HQChart.Symbol) upperSymbol=this.HQChart.Symbol.toUpperCase();
        if (this.ClassName==='MinuteTooltipPaint') 
        {
            lineCount=7;
            if (MARKET_SUFFIX_NAME.IsFutures(upperSymbol)) ++lineCount;    //期货多一个持仓量
        }
        else 
        {
            if (IFrameSplitOperator.IsNumber(klineData.Time) ) ++lineCount;     //分钟K线多一列时间
            if (MARKET_SUFFIX_NAME.IsSHSZStockA(this.HQChart.Symbol) && klineData.FlowCapital>0) ++lineCount;
            if (MARKET_SUFFIX_NAME.IsFutures(upperSymbol) && IFrameSplitOperator.IsNumber(klineData.Position)) ++lineCount;    //持仓
        }

        //this.TitleColor=this.KLineTitlePaint.UnchagneColor;
        this.IsHScreen=this.ChartFrame.IsHScreen===true;
        this.Canvas.font=this.Font[0];
        var defaultfloatPrecision=GetfloatPrecision(this.HQChart.Symbol);//价格小数位数
        var maxText=' 擎: 9999.99亿 ';
        if (defaultfloatPrecision>=5) maxText=` 擎: ${99.99.toFixed(defaultfloatPrecision)} `;  //小数位数太多了
        this.Width=this.Canvas.measureText(maxText).width;
        var lineHeight=this.GetFontHeight();
        if (lineHeight>this.LineHeight) this.LineHeight=lineHeight;
        this.Height=this.LineHeight*lineCount+2*GetDevicePixelRatio()*2;
        if (klineData && klineData.High>0)  //最大值显示宽度
        {
            maxText=` 擎: ${klineData.High.toFixed(defaultfloatPrecision)} `;
            var textWidth=this.Canvas.measureText(maxText).width;
            if (textWidth>this.Width) this.Width=textWidth;
        }

        this.CalculateShowPosition();
        this.DrawBG();
        this.DrawTooltipData(klineData);
        this.DrawBorder();
    }

    //判断显示位置
    this.CalculateShowPosition=function()
    {
        this.ShowPosition=0;
        if (!this.LatestPoint) return;

        if(this.IsHScreen)
        {
            var top=this.ChartBorder.GetTop();
            var height=this.ChartBorder.GetHeight();
            var yCenter=top+height/2;
            if (this.LatestPoint.Y<yCenter) this.ShowPosition=1;
        }
        else
        {
            var left=this.ChartBorder.GetLeft();
            var width=this.ChartBorder.GetWidth();
            var xCenter=left+width/2;
            if (this.LatestPoint.X<xCenter) this.ShowPosition=1;
        }
    }

    this.DrawTooltipData=function(item)
    {
        //JSConsole.Chart.Log('[KLineTooltipPaint::DrawKLineData] ', item);
        var upperSymbol;
        if (this.HQChart.Symbol) upperSymbol=this.HQChart.Symbol.toUpperCase();
        var defaultfloatPrecision=GetfloatPrecision(this.HQChart.Symbol);//价格小数位数
        var left=this.GetLeft()+2*GetDevicePixelRatio();
        var top=this.GetTop()+3*GetDevicePixelRatio();
        
        if (this.IsHScreen)
        {
            this.Canvas.save(); 
            var x=this.GetLeft()+this.Height, y=this.GetTop();

            this.Canvas.translate(x, y);
            this.Canvas.rotate(90 * Math.PI / 180);

            //x, y 作为原点
            left=2*GetDevicePixelRatio();
            top=3*GetDevicePixelRatio();
        }

        this.Canvas.textBaseline="top";
        this.Canvas.textAlign="left";
        this.Canvas.font=this.Font[0];
        var labelWidth=this.Canvas.measureText('擎: ').width;

        var text=IFrameSplitOperator.FormatDateString(item.Date);
        this.Canvas.fillStyle=this.DateTimeColor;
        this.Canvas.fillText(text, left,top);

        var period=this.HQChart.Period;
        if (ChartData.IsMinutePeriod(period,true) && IFrameSplitOperator.IsNumber(item.Time))
        {
            top+=this.LineHeight;  
            text=IFrameSplitOperator.FormatTimeString(item.Time);
            this.Canvas.fillText(text, left,top);
        }
        else if (ChartData.IsSecondPeriod(period) && IFrameSplitOperator.IsNumber(item.Time))
        {
            top+=this.LineHeight;  
            text=IFrameSplitOperator.FormatTimeString(item.Time,'HH:MM:SS');
            this.Canvas.fillText(text, left,top);
        }

        top+=this.LineHeight;  
        this.Canvas.fillStyle=this.TitleColor;
        text=g_JSChartLocalization.GetText('Tooltip-Open',this.LanguageID);
        this.Canvas.fillText(text, left,top);
        var color=this.KLineTitlePaint.GetColor(item.Open,item.YClose);
        text=item.Open.toFixed(defaultfloatPrecision);
        this.Canvas.fillStyle=color;
        this.Canvas.fillText(text,left+labelWidth,top);

        top+=this.LineHeight;   
        this.Canvas.fillStyle=this.TitleColor;
        text=g_JSChartLocalization.GetText('Tooltip-High',this.LanguageID);
        this.Canvas.fillText(text, left,top);
        var color=this.KLineTitlePaint.GetColor(item.High,item.YClose);
        var text=item.High.toFixed(defaultfloatPrecision);
        this.Canvas.fillStyle=color;
        this.Canvas.fillText(text,left+labelWidth,top);

        top+=this.LineHeight;
        this.Canvas.fillStyle=this.TitleColor;
        text=g_JSChartLocalization.GetText('Tooltip-Low',this.LanguageID);
        this.Canvas.fillText(text, left,top);
        var color=this.KLineTitlePaint.GetColor(item.Low,item.YClose);
        var text=item.Low.toFixed(defaultfloatPrecision);
        this.Canvas.fillStyle=color;
        this.Canvas.fillText(text,left+labelWidth,top);

        top+=this.LineHeight;
        this.Canvas.fillStyle=this.TitleColor;
        text=g_JSChartLocalization.GetText('Tooltip-Close',this.LanguageID);
        this.Canvas.fillText(text, left,top);
        var color=this.KLineTitlePaint.GetColor(item.Close,item.YClose);
        var text=item.Close.toFixed(defaultfloatPrecision);
        this.Canvas.fillStyle=color;
        this.Canvas.fillText(text,left+labelWidth,top);

        top+=this.LineHeight;
        this.Canvas.fillStyle=this.TitleColor;
        text=g_JSChartLocalization.GetText('Tooltip-Increase',this.LanguageID);
        this.Canvas.fillText(text, left,top);
        if (item.YFClose>0 && MARKET_SUFFIX_NAME.IsChinaFutures(upperSymbol))
        {
            var value=(item.Close-item.YFClose)/item.YFClose*100;
            var color = this.KLineTitlePaint.GetColor(value, 0);
            var text = value.toFixed(2)+'%';
        }
        else if (item.YClose>0)
        {
            var value=(item.Close-item.YClose)/item.YClose*100;
            var color = this.KLineTitlePaint.GetColor(value, 0);
            var text = value.toFixed(2)+'%';
        }
        else
        {
            var text='--.--';
            var color=this.KLineTitlePaint.GetColor(0, 0);
        }
        this.Canvas.fillStyle=color;
        this.Canvas.fillText(text,left+labelWidth,top);

        
        top+=this.LineHeight;
        text=g_JSChartLocalization.GetText('Tooltip-Vol',this.LanguageID);
        this.Canvas.fillStyle=this.TitleColor;
        this.Canvas.fillText(text, left,top);
        var text=IFrameSplitOperator.FromatIntegerString(item.Vol,2,this.LanguageID);
        this.Canvas.fillStyle=this.VolColor;
        this.Canvas.fillText(text,left+labelWidth,top);

        if (IFrameSplitOperator.IsNumber(item.Amount))
        {
            
            top+=this.LineHeight;
            text=g_JSChartLocalization.GetText('Tooltip-Amount',this.LanguageID);
            this.Canvas.fillStyle=this.TitleColor;
            this.Canvas.fillText(text, left,top);
            var text=IFrameSplitOperator.FormatValueString(item.Amount,2,this.LanguageID);
            this.Canvas.fillStyle=this.AmountColor;
            this.Canvas.fillText(text,left+labelWidth,top);
        }

        //换手率
        if (MARKET_SUFFIX_NAME.IsSHSZStockA(this.HQChart.Symbol) && item.FlowCapital>0)
        {
            top+=this.LineHeight;
            text=g_JSChartLocalization.GetText('Tooltip-Exchange',this.LanguageID);
            this.Canvas.fillStyle=this.TitleColor;
            this.Canvas.fillText(text, left,top);
            var value=item.Vol/item.FlowCapital*100;
            var text=value.toFixed(2)+'%';
            this.Canvas.fillText(text,left+labelWidth,top);
        }

        //持仓量
        var upperSymbol=this.HQChart.Symbol.toUpperCase();
        if (MARKET_SUFFIX_NAME.IsFutures(upperSymbol) && IFrameSplitOperator.IsNumber(item.Position))
        {
            this.Canvas.fillStyle=this.TitleColor;
            top+=this.LineHeight;
            text=g_JSChartLocalization.GetText('Tooltip-Position',this.LanguageID);
            this.Canvas.fillText(text, left,top);
            var text=IFrameSplitOperator.FromatIntegerString(item.Position,2,this.LanguageID);
            this.Canvas.fillText(text,left+labelWidth,top);
        }

        if (this.IsHScreen) this.Canvas.restore();
    }

    this.DrawBorder=function()
    {
        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var left=this.GetLeft();
        var top=this.GetTop();
        this.Canvas.strokeStyle=this.BorderColor;
        if (isHScreen)  this.Canvas.strokeRect(ToFixedPoint(left),ToFixedPoint(top),this.Height,this.Width);
        else this.Canvas.strokeRect(ToFixedPoint(left),ToFixedPoint(top),ToFixedRect(this.Width),ToFixedRect(this.Height));
    }

    this.DrawBG=function()
    {
        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var left=this.GetLeft();
        var top=this.GetTop();
        this.Canvas.fillStyle=this.BGColor;
        if (isHScreen)   this.Canvas.fillRect(left,top,this.Height,this.Width);
        else  this.Canvas.fillRect(left,top,this.Width,this.Height);
    }

    //设置参数接口
    this.SetOption=function(option)
    {
        if (option.LineHeight>0) this.LineHeight=option.LineHeight*GetDevicePixelRatio();
        if (option.BGColor) this.BGColor=option.BGColor;
        if (option.LanguageID>0) this.LanguageID=option.LanguageID;
    }
}

function MinuteTooltipPaint()
{
    this.newMethod=KLineTooltipPaint;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='MinuteTooltipPaint';
    this.Left=1*GetDevicePixelRatio();
    this.Top=1*GetDevicePixelRatio();
    this.YClose;
    this.IsShowAveragePrice=true;   //是否显示均价

    this.GetTop=function()
    {
        if (this.IsHScreen) 
        {
            var border=this.ChartBorder.GetHScreenBorder();
            if (this.ShowPosition==0)
                return border.TopEx+this.Left;
            else
                return border.BottomEx-this.Width-this.Left;
        }
        else
        {
            var border=this.ChartBorder.GetBorder();
            return border.Top+this.Top;
        }
    }

    this.GetLeft=function()
    {
        if (this.IsHScreen) 
        {
            var border=this.ChartBorder.GetHScreenBorder();
            return border.Right-this.Height-this.Top;
        }
        else
        {
            var border=this.ChartBorder.GetBorder();
            if (this.ShowPosition==0)
                return border.LeftEx+this.Left;
            else 
                return border.RightEx-this.Width-this.Left;
        }
    }

    this.DrawTooltipData=function(item)
    {
        //JSConsole.Chart.Log('[KLineTooltipPaint::DrawKLineData] ', item);
        if (!this.HQChart.Symbol) return;
        
        var defaultfloatPrecision=GetfloatPrecision(this.HQChart.Symbol);//价格小数位数
        var left=this.GetLeft()+2*GetDevicePixelRatio();
        var top=this.GetTop()+3*GetDevicePixelRatio();
        this.YClose=this.KLineTitlePaint.YClose;
        var upperSymbol=this.HQChart.Symbol.toUpperCase();
        
        if (this.IsHScreen)
        {
            this.Canvas.save(); 
            var x=this.GetLeft()+this.Height, y=this.GetTop();

            this.Canvas.translate(x, y);
            this.Canvas.rotate(90 * Math.PI / 180);

            //x, y 作为原点
            left=2*GetDevicePixelRatio();
            top=3*GetDevicePixelRatio();
        }

        this.Canvas.textBaseline="top";
        this.Canvas.textAlign="left";
        this.Canvas.font=this.Font[0];
        var labelWidth=this.Canvas.measureText('擎: ').width;

        var aryDateTime=item.DateTime.split(' ');
        if (aryDateTime && aryDateTime.length==2)
        {
            var text=IFrameSplitOperator.FormatDateString(aryDateTime[0]);
            this.Canvas.fillStyle=this.TitleColor;
            this.Canvas.fillText(text, left,top);

            top+=this.LineHeight;  
            text=IFrameSplitOperator.FormatTimeString(aryDateTime[1]);
            this.Canvas.fillText(text, left,top);
        }

        var close=item.Close;
        var increase=item.Increase;
        var vol=item.Vol;
        var amount=item.Amount;
        if (item.Before)    //读取盘前数据
        {
            close=item.Before.Close;
            increase=item.Before.Increase;
            vol=item.Before.Vol;
            amount=item.Before.Amount;
        }

        //最新价格
        top+=this.LineHeight;
        this.Canvas.fillStyle=this.TitleColor;
        text=g_JSChartLocalization.GetText('Tooltip-Price',this.LanguageID);
        this.Canvas.fillText(text, left,top);
        var color=this.KLineTitlePaint.GetColor(close,this.YClose);
        var text=close.toFixed(defaultfloatPrecision);
        this.Canvas.fillStyle=color;
        this.Canvas.fillText(text,left+labelWidth,top);

        var isShowAvPrice=true;
        if (item.Before) isShowAvPrice=false;   //集合竞价均价
        else if (MARKET_SUFFIX_NAME.IsForeignExchange(upperSymbol)) isShowAvPrice=false;     //外汇没有均价
        else if (MARKET_SUFFIX_NAME.IsET(upperSymbol) && !MARKET_SUFFIX_NAME.IsETShowAvPrice(upperSymbol)) isShowAvPrice=false;

        //均价
        if (isShowAvPrice && IFrameSplitOperator.IsNumber(item.AvPrice) && this.IsShowAveragePrice)   
        {
            top+=this.LineHeight;
            this.Canvas.fillStyle=this.TitleColor;
            text=g_JSChartLocalization.GetText('Tooltip-AvPrice',this.LanguageID);
            this.Canvas.fillText(text, left,top);
            var color=this.KLineTitlePaint.GetColor(item.AvPrice,this.YClose);
            var text=item.AvPrice.toFixed(defaultfloatPrecision);
            this.Canvas.fillStyle=color;
            this.Canvas.fillText(text,left+labelWidth,top);
        }

        //涨幅
        top+=this.LineHeight;
        this.Canvas.fillStyle=this.TitleColor;
        text=g_JSChartLocalization.GetText('Tooltip-Increase',this.LanguageID);
        this.Canvas.fillText(text, left,top);
        var value=(close-this.YClose)/this.YClose*100;
        var color = this.KLineTitlePaint.GetColor(value, 0);
        var text = value.toFixed(2)+'%';
        this.Canvas.fillStyle=color;
        this.Canvas.fillText(text,left+labelWidth,top);

        //成交量
        if (IFrameSplitOperator.IsNumber(vol))
        {
            this.Canvas.fillStyle=this.TitleColor;
            top+=this.LineHeight;
            text=g_JSChartLocalization.GetText('Tooltip-Vol',this.LanguageID);
            this.Canvas.fillText(text, left,top);
            var text=IFrameSplitOperator.FromatIntegerString(vol,2,this.LanguageID);
            this.Canvas.fillText(text,left+labelWidth,top);
        }

        //成交金额
        if (IFrameSplitOperator.IsNumber(amount))
        {
            top+=this.LineHeight;
            text=g_JSChartLocalization.GetText('Tooltip-Amount',this.LanguageID);
            this.Canvas.fillText(text, left,top);
            var text=IFrameSplitOperator.FormatValueString(amount,2,this.LanguageID);
            this.Canvas.fillText(text,left+labelWidth,top);
        }

        if (IFrameSplitOperator.IsNumber(item.Position))
        {
            top+=this.LineHeight;
            text=g_JSChartLocalization.GetText('Tooltip-Position',this.LanguageID);
            this.Canvas.fillText(text, left,top);
            var text=IFrameSplitOperator.FormatValueString(item.Position,2,this.LanguageID);
            this.Canvas.fillText(text,left+labelWidth,top);
        }

        if (this.IsHScreen) this.Canvas.restore();
    }
}

//股票信息
function StockInfoExtendChartPaint()
{
    this.newMethod=IExtendChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.Left=80;
    this.Right=1;
    this.Top=1;
    this.Bottom=1;

    this.BorderColor=g_JSChartResource.FrameBorderPen;

    this.Symbol;
    this.Name;

    this.TitleFont=["14px 微软雅黑"];

    this.Draw=function()
    {
        var left=this.ChartBorder.GetRight()+this.Left;
        var right=this.ChartBorder.GetChartWidth()-this.Right;
        var y=this.Top+18;
        var middle=left+(right-left)/2;

        if (this.Symbol && this.Name)
        {
            this.Canvas.font=this.TitleFont[0];

            this.Canvas.textAlign="right";
            this.Canvas.textBaseline="bottom";
            this.Canvas.fillText(this.Symbol,middle-2,y);

            this.Canvas.textAlign="left";
            this.Canvas.fillText(this.Name,middle+2,y);
        }
        ;
        this.Canvas.strokeStyle=this.BorderColor;
        this.Canvas.moveTo(left,y);
        this.Canvas.lineTo(right,y);
        this.Canvas.stroke();

        y+=30;

        this.DrawBorder();
    }

    this.DrawBorder=function()
    {
        var left=this.ChartBorder.GetRight()+this.Left;
        var right=this.ChartBorder.GetChartWidth()-this.Right;
        var top=this.Top;
        var bottom=this.ChartBorder.GetChartHeight()-this.Bottom;

        this.Canvas.strokeStyle=this.BorderColor;
        this.Canvas.strokeRect(left,top,(right-left),(bottom-top));
    }
}

//筹码分布
function StockChip()
{
    this.newMethod=IExtendChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.Name='筹码分布';
    this.ClassName='StockChip';

    this.HQChart;
    this.PenBorder=g_JSChartResource.FrameBorderPen;    //边框
    this.ColorProfit='rgb(255,0,0)';            //盈利的线段
    this.ColorNoProfit='rgb(90,141,248)';       //非盈利
    this.ColorAveragePrice='rgb(0,139,0)';   //平均价线
    this.ColorBG='rgb(190,190,190)';           //筹码背景线段颜色

    this.PixelRatio=GetDevicePixelRatio();
    this.ShowType=0;    //0=所有筹码  1=周期前  2=周期内
    this.IsDynamic=true;
    this.ClientRect={};
    this.Font=g_JSChartResource.TitleFont;
    this.InfoColor=g_JSChartResource.StockChip.InfoColor;
    this.DayInfoColor=g_JSChartResource.StockChip.DayInfoColor;
    this.LineHeight=16;
    this.Left=50*this.PixelRatio;         //左边间距
    this.IsShowX=false;  //是否显示X刻度 成交量
    this.ShowXCount=3;
    this.Width=150*this.PixelRatio;       //筹码图宽度
    this.CalculateType=0;   //0=平均分布 1=三角分布
    this.PriceZoom=100;     //价格放大倍数

    this.ButtonID=Guid();  //工具条Div id

    this.DAY_COLOR=
    [
        ['rgb(255,0,0)','rgb(255,128,128)','rgb(255,0,128)','rgb(255,100,0)','rgb(192,128,0)','rgb(255,192,0)'],
        ['rgb(120,80,225)','rgb(160,160,225)','rgb(80,80,255)','rgb(120,120,255)','rgb(32,64,192)','rgb(0,64,128)'],
    ];

    this.SetOption=function(option)
    {
        if (!option) return;
        if (option.ShowType>0) this.ShowType=option.ShowType;
        if (option.IsShowX) this.IsShowX=option.IsShowX;
        if (option.ShowXCount>0) this.ShowXCount=option.ShowXCount;
        if (option.Width>100) this.Width=option.Width*GetDevicePixelRatio();
        if (option.CalculateType>0) this.CalculateType=option.CalculateType;
        if (IFrameSplitOperator.IsNumber(option.PriceZoom)) this.PriceZoom=option.PriceZoom;
    }

    this.ReloadResource=function(resource)
    {
        this.PenBorder=g_JSChartResource.FrameBorderPen;
        this.Font=g_JSChartResource.TitleFont;
        this.InfoColor=g_JSChartResource.StockChip.InfoColor;
        this.DayInfoColor=g_JSChartResource.StockChip.DayInfoColor;
    }
    
    this.Draw=function()
    {
        this.PixelRatio=GetDevicePixelRatio();
        var left=ToFixedPoint(this.ChartBorder.GetRight()+this.Left);
        var top=ToFixedPoint(this.ChartBorder.GetTop());
        var right=ToFixedPoint(left+this.Width-1*this.PixelRatio);
        var bottom=ToFixedPoint(this.ChartBorder.GetBottom());
        var width=right-left;
        var height=bottom-top;
        this.ClientRect={Left:left,Top:top,Width:width,Height:height};

        if (this.CalculateChip())
        {
            this.DrawFrame();
            this.DrawAllChip();
            if (this.ShowType==1|| this.ShowType==2) this.DrawDayChip();

            this.CalculateCast();   //计算成本  
            this.DrawChipInfo();      
        }
        else
        {
            JSConsole.Chart.Log('[StockChip::Draw] no data');
        }

        this.DrawBorder();
        if (this.SizeChange==true) this.DrawButton();

        this.SizeChange=false;
    }

    this.DrawChipInfo=function()    
    {
        var bottom=this.ClientRect.Top+this.ClientRect.Height-1;
        var left=this.ClientRect.Left+2;
        var right=this.ClientRect.Left+this.ClientRect.Width;

        this.Canvas.font=this.Font;
        this.Canvas.fillStyle=this.InfoColor;
        this.Canvas.textBaseline='bottom';
        this.Canvas.textAlign='left';

        var lineHeight=this.LineHeight*GetDevicePixelRatio();
        var text='70%成本价'+ this.Data.Cast[1].MinPrice.toFixed(2)+'-'+this.Data.Cast[1].MaxPrice.toFixed(2)+'集中'+this.Data.Cast[1].Rate.toFixed(2)+'%';
        this.Canvas.fillText(text,left,bottom);
        bottom-=lineHeight;

        text='90%成本价'+ this.Data.Cast[0].MinPrice.toFixed(2)+'-'+this.Data.Cast[0].MaxPrice.toFixed(2)+'集中'+this.Data.Cast[0].Rate.toFixed(2)+'%';;
        this.Canvas.fillText(text,left,bottom);
        bottom-=lineHeight;

        text='平均成本：'+this.Data.ChipInfo.AveragePrice.toFixed(2)+'元';
        this.Canvas.fillText(text,left,bottom);
        bottom-=lineHeight;

        text=+this.Data.YPrice.toFixed(2)+'处获利盘：'+this.Data.ChipInfo.YProfitRate.toFixed(2)+'%';
        this.Canvas.fillText(text,left,bottom);
        bottom-=lineHeight;

        text='获利比例：';
        this.Canvas.fillText(text,left,bottom);
        var textWidth=this.Canvas.measureText(text).width+2;
        var barLeft=left+textWidth;
        var barWidth=(right-5-barLeft);
        this.Canvas.strokeStyle=this.ColorNoProfit;
        this.Canvas.strokeRect(barLeft,bottom-lineHeight,barWidth,lineHeight);
        this.Canvas.strokeStyle=this.ColorProfit;
        this.Canvas.strokeRect(barLeft,bottom-lineHeight,barWidth*(this.Data.ChipInfo.ProfitRate/100),lineHeight);
        text=this.Data.ChipInfo.ProfitRate.toFixed(2)+'%';
        this.Canvas.textAlign='center';
        this.Canvas.fillText(text,barLeft+barWidth/2,bottom);
        bottom-=lineHeight;

        this.Canvas.textAlign='left';
        text='成本分布,日期：'+IFrameSplitOperator.FormatDateString(this.Data.SelectData.Date);
        if (this.Data.SelectData.Time) text+=' '+IFrameSplitOperator.FormatTimeString(this.Data.SelectData.Time);
        this.Canvas.fillText(text,left,bottom);
        bottom-=lineHeight;

        if (this.ShowType!=1 && this.ShowType!=2) return;

        var right=this.ClientRect.Left+this.ClientRect.Width-1;
        this.Canvas.textAlign='right';
        var textWidth=50;
        this.Data.DayChip.sort(function(a,b){return b.Day-a.Day;})
        for(var i in this.Data.DayChip)
        {
            var item=this.Data.DayChip[i];
            var rate=0;
            if (this.Data.ChipInfo && this.Data.ChipInfo.Vol>0) rate=item.Vol/this.Data.ChipInfo.Vol*100;
            text=item.Day+'周期'+(this.ShowType==1?'前':'内')+'成本'+(IFrameSplitOperator.IsNumber(rate)? (rate.toFixed(2)+'%'):"--.--%");
            if (i==0) textWidth=this.Canvas.measureText(text).width+8;
            this.Canvas.fillStyle=item.Color;
            this.Canvas.fillRect(right-textWidth,bottom-lineHeight,textWidth,lineHeight);

            this.Canvas.fillStyle=this.DayInfoColor;
            this.Canvas.fillText(text,right,bottom);
            bottom-=lineHeight;
        }
    }

    this.DrawDayChip=function()
    {
        var KLineFrame=this.HQChart.Frame.SubFrame[0].Frame;
        for(var i in this.Data.DayChip)
        {
            var aryPoint=[];
            var chipData=this.Data.DayChip[i].Chip;
            if (!chipData) continue;
            var totalVol=0;
            for(var j=0;j<chipData.length;++j)
            {
                var vol=chipData[j];
                if(!vol) continue;
                totalVol+=vol;
                var price=(j+this.Data.MinPrice)/100;
                var y=KLineFrame.GetYFromData(price);
                var x=(vol/this.Data.MaxVol)*this.ClientRect.Width+this.ClientRect.Left;
                aryPoint.push({X:x,Y:y});
            }
            this.Data.DayChip[i].Vol=totalVol;
            this.DrawArea(aryPoint,this.Data.DayChip[i].Color);
        }
    }

    this.Clear=function()
    {
        var divButton=document.getElementById(this.ButtonID);
        if (divButton) this.ChartBorder.UIElement.parentNode.removeChild(divButton);
    }

    this.DrawButton=function()  //顶部按钮
    {
        var divButton=document.getElementById(this.ButtonID);
        if (!divButton)
        {
            divButton=document.createElement("div");
            divButton.className='klineframe-button';
            divButton.id=this.ButtonID;
            //为divToolbar添加属性identify
            // divButton.setAttribute("identify",this.Identify.toString());
            this.ChartBorder.UIElement.parentNode.appendChild(divButton);
        }

        var pixelTatio = this.PixelRatio;
        var left=this.ClientRect.Left;
        var right=this.ClientRect.Left+this.ClientRect.Width;
        var chartRight=this.ChartBorder.GetChartWidth();
        var toolbarWidth=right-left;
        var toolbarHeight=this.ChartBorder.GetTitleHeight();
        // var left=this.ChartBorder.GetRight();
        var top=this.ChartBorder.GetTop()/pixelTatio;

        const spanStyle="<span class='{iconclass}' id='{iconid}' title='{icontitle}' style='cursor:pointer;display:inline-block;color:{iconcolor};font-size:{iconsize}px'></span>";
        const ICON_LIST=
        [
            {Class:'chip_default icon iconfont icon-chip_default', ID:'chip_default',Color:['#808080','#FF0000'],Title:'默认筹码分布图'},
            {Class:'chip_long icon iconfont icon-chip_date',ID:'chip_long',Color:['#808080','#FF8000'],Title:'远期筹码分布图'},
            {Class:'chip_recent icon iconfont icon-chip_date',ID:'chip_recent', Color:['#808080','#0000CC'],Title:'近期筹码分布图'}
        ];

        var spanHtml='';
        for(var i in ICON_LIST)
        {
            var item=ICON_LIST[i];
            var spanItem=spanStyle;
            spanItem=spanItem.replace('{iconclass}',item.Class);
            spanItem=spanItem.replace('{iconid}',item.ID);
            spanItem=spanItem.replace('{iconcolor}',item.Color[i==this.ShowType?1:0]);
            spanItem=spanItem.replace('{iconsize}',toolbarHeight);
            spanItem=spanItem.replace('{icontitle}',item.Title);

            if (spanHtml.length>0) spanHtml+='&nbsp;&nbsp;';
            spanHtml+=spanItem;
        }

        divButton.style.right = Math.floor((chartRight-right+2)/pixelTatio) + "px";
        divButton.style.top = top + "px";
        //divButton.style.width=toolbarWidth+"px";
        divButton.style.height=toolbarHeight+'px';
        divButton.innerHTML=spanHtml;

        var self = this;
        for(var i in ICON_LIST)
        {
            var item=ICON_LIST[i];
            $("#"+this.ButtonID+" ."+item.ID).click(
                {
                    IconID:item.ID,
                    ShowType:i
                },
                function (event) 
                {
                    var id=event.data.IconID;
                    var showType=event.data.ShowType;
                    self.ShowType=showType;
                    if (self.HQChart) self.HQChart.Draw();

                    for(var i in ICON_LIST)
                    {
                        var item=ICON_LIST[i];
                        var style=$("#"+self.ButtonID+" ."+item.ID)[0].style;
                        style['color']=item.Color[i==showType?1:0];
                    }
                }
            )
        }
    }

    this.DrawAllChip=function()
    {
        var KLineFrame=this.HQChart.Frame.SubFrame[0].Frame;
        var selectPrice=this.Data.SelectData.Close;
        var aryProfitPoint=[];
        var aryNoProfitPoint=[];
        var totalVol=0,totalAmount=0,totalProfitVol=0, totalYProfitVol=0;   //总的成交量, 总的成交金额, 总的盈利的成交量
        var yPrice=this.Data.YPrice;

        var maxPrice=KLineFrame.HorizontalMax;
        var minPrice=KLineFrame.HorizontalMin;

        var MaxVol=1;
        for(var i=0;i<this.Data.AllChip.length;++i)
        {
            var vol=this.Data.AllChip[i];
            if(!vol) continue;
            var price=(i+this.Data.MinPrice)/this.PriceZoom;
            totalVol+=vol;
            totalAmount+=price*vol;

            if (price<yPrice) totalYProfitVol+=vol;     //获利的成交量
            if (price<selectPrice) totalProfitVol+=vol; //鼠标当前位置 获利的成交量

            if (price<=maxPrice && price>=minPrice)
            {
                if (MaxVol<vol) MaxVol=vol;
            }
        }
        this.Data.MaxVol=MaxVol;    //把成交量最大值替换成 当前屏成交量最大值
        
        for(var i=0;i<this.Data.AllChip.length;++i)
        {
            var vol=this.Data.AllChip[i];
            if(!vol) continue;
            var price=(i+this.Data.MinPrice)/this.PriceZoom;
            if (price>maxPrice || price<minPrice) continue;

            var y=KLineFrame.GetYFromData(price);
            var x=(vol/this.Data.MaxVol)*this.ClientRect.Width+this.ClientRect.Left;
           
            if (price<selectPrice) aryProfitPoint.push({X:x,Y:y});
            else aryNoProfitPoint.push({X:x,Y:y});
        }

        this.Data.ChipInfo=
        {
            Vol:totalVol, AveragePrice:totalAmount/totalVol, ProfitVol:totalProfitVol, 
            ProfitRate:totalVol>0?totalProfitVol/totalVol*100:0,
            YProfitRate:totalVol>0?totalYProfitVol/totalVol*100:0
        };

        if (this.ShowType==0)
        {
            this.DrawLines(aryProfitPoint,this.ColorProfit);
            this.DrawLines(aryNoProfitPoint,this.ColorNoProfit);
            var averagePrice=this.Data.ChipInfo.AveragePrice;
            if (averagePrice>0 && averagePrice<=maxPrice && averagePrice>=minPrice) 
            {
                averagePrice=averagePrice.toFixed(2);
                this.DrawAveragePriceLine(aryProfitPoint,aryNoProfitPoint,KLineFrame.GetYFromData(averagePrice),this.ColorAveragePrice);
            }
        }
        else    //在火焰山模式下, 筹码用一个颜色
        {
            this.DrawLines(aryProfitPoint,this.ColorBG);
            this.DrawLines(aryNoProfitPoint,this.ColorBG);
        }
    }

    this.CalculateCast=function()   //计算 90% 70%的成本价
    {
        if (!this.Data.ChipInfo || !this.Data.ChipInfo.Vol) return;

        var aryCast=
        [
            {Start:0.05,End:0.95, MaxPrice:0, MinPrice:0, Rate:0},
            {Start:0.15,End:0.85, MaxPrice:0, MinPrice:0, Rate:0}
        ];

        var averagePrice=this.Data.ChipInfo.AveragePrice;
        var totalProfitVol=this.Data.ChipInfo.ProfitVol;
        var tempVol=0;
        for(var i=0, castCount=0;i<this.Data.AllChip.length;++i)
        {
            if (castCount==4) break;
            var vol=this.Data.AllChip[i];
            if (vol<=0) continue;

            var price=(i+this.Data.MinPrice)/this.PriceZoom;
            tempVol+=vol;
            var rate=tempVol/totalProfitVol;
            
            for(var j in aryCast)
            {
                var itemCast=aryCast[j];
                if (itemCast.MinPrice<=0 && rate>itemCast.Start)
                {
                    itemCast.MinPrice=price;
                    ++castCount;
                }

                if (itemCast.MaxPrice<=0 && rate>itemCast.End)
                {
                    itemCast.MaxPrice=price;
                    ++castCount;
                }
            }
        }

        for(var i in aryCast)
        {
            var item=aryCast[i];
            var addPrice=item.MaxPrice+item.MinPrice;
            if (addPrice) item.Rate=Math.abs(item.MaxPrice-item.MinPrice)/addPrice*100;
        }

        this.Data.Cast=aryCast;
    }

    this.DrawArea=function(aryPoint,color)
    {
        if (aryPoint.length<=0) return;

        this.Canvas.fillStyle=color;
        this.Canvas.beginPath();
        this.Canvas.moveTo(this.ClientRect.Left,aryPoint[0].Y);
        for(var i in aryPoint)
        {
            var item=aryPoint[i];
            this.Canvas.lineTo(item.X,item.Y);
        }
        this.Canvas.lineTo(this.ClientRect.Left,aryPoint[aryPoint.length-1].Y);
        this.Canvas.fill();
    }

    this.DrawLines=function(aryPoint,color)
    {
        if (aryPoint.length<=0) return;
        this.Canvas.strokeStyle=color;
        this.Canvas.beginPath();
        for(var i in aryPoint)
        {
            var item=aryPoint[i];
            this.Canvas.moveTo(this.ClientRect.Left,item.Y);
            this.Canvas.lineTo(item.X,item.Y);
        }
        this.Canvas.stroke();
    }

    this.DrawAveragePriceLine=function(aryProfitPoint,aryNoProfitPoint,y,color)
    {
        for(var i in aryProfitPoint)
        {
            var item=aryProfitPoint[i];
            if (item.Y==y)
            {
                this.Canvas.strokeStyle=color;
                this.Canvas.beginPath();
                this.Canvas.moveTo(this.ClientRect.Left,item.Y);
                this.Canvas.lineTo(item.X,item.Y);
                this.Canvas.stroke();
                return;
            }
        }

        for(var i in aryNoProfitPoint)
        {
            var item=aryNoProfitPoint[i];
            if (item.Y==y)
            {
                this.Canvas.strokeStyle=color;
                this.Canvas.beginPath();
                this.Canvas.moveTo(this.ClientRect.Left,item.Y);
                this.Canvas.lineTo(item.X,item.Y);
                this.Canvas.stroke();
                return;
            }
        }
    }

    this.DrawBorder=function()
    {
        this.Canvas.strokeStyle=this.PenBorder;
        this.Canvas.strokeRect(this.ClientRect.Left,this.ClientRect.Top,this.ClientRect.Width,this.ClientRect.Height);
    }

    this.EvenlyDistribute=function(aryChip, data)    //平均分布 data={Low, High, Vol, MaxVol, MaxPrice, MinPrice }
    {
        var low=data.Low, high=data.High, maxPrice=data.MaxPrice, minPrice=data.MinPrice, maxVol=1;
        if ( (high-low)== 0) return;
        var averageVol=data.Vol/(high-low);

        for(var j=low;j<=high && j<=maxPrice;++j)
        {
            var index=j-minPrice;
            aryChip[index]+=averageVol;
            if (maxVol<aryChip[index]) maxVol=aryChip[index];
        }

        data.MaxVol=maxVol;
    }

    this.TriangleDistribute=function(aryChip, data)  //三角分布
    {
        var low=data.Low, high=data.High, maxPrice=data.MaxPrice, minPrice=data.MinPrice, maxVol=1;
        var ANGLE = 45, PI=3.1415926535;
        var middlePrice = (high - low) / 2.0 + low;

        var totalValue=0;
        var aryVol=[];
        for(var i=low+1, j=1 ;i<=middlePrice;++i,++j)
        {
            var y = Math.tan(ANGLE* PI / 180)*j;

            totalValue+=y;
            aryVol.push({Index:i-minPrice, Value:y});
        }

        for(var i=high-1, j=1 ;i>middlePrice;--i,++j)
        {
            var y = Math.tan(ANGLE* PI / 180)*j;

            totalValue+=y
            aryVol.push({Index:i-minPrice, Value:y});
        }

        if (totalValue>0)
        {
            for(var i=0;i<aryVol.length;++i)
            {
                var item=aryVol[i];
                aryChip[item.Index]+=item.Value*data.Vol/totalValue;
                if (maxVol<aryChip[item.Index]) maxVol=aryChip[item.Index];
            }

            data.MaxVol=maxVol;
        }
    }

    this.CalculateDistribute=function(aryChip, data)
    {
        if (this.CalculateType==1) this.TriangleDistribute(aryChip, data);
        else this.EvenlyDistribute(aryChip, data);
    }

    this.CalculateChip=function()   //计算筹码
    {
        if (!this.HQChart) return false;
        if (!this.HQChart.FlowCapitalReady) return false;
        var symbol=this.HQChart.Symbol;
        if (!symbol) return false;
        if (MARKET_SUFFIX_NAME.IsSHSZIndex(symbol)) return false;   //指数暂时不支持移动筹码

        var bindData=this.HQChart.ChartPaint[0].Data;
        //if (bindData.Period>=4) return false;   //分钟K线不支持, 没时间做,以后再做吧
        var count=bindData.DataOffset+parseInt(this.HQChart.CursorIndex);
        if (count>=bindData.Data.length) count=bindData.Data.length-1;
        var selData=bindData.Data[count];
        var yPrice=selData.Close;

        var mouseY=this.HQChart.LastPoint.Y;
        if (mouseY) yPrice=this.HQChart.Frame.SubFrame[0].Frame.GetYData(mouseY);
        
        //JSConsole.Chart.Log("[StockChip::CalculateChip]",count,this.HQChart.CursorIndex,selData);
        const rate=1;
        var aryVol=[];
        var seed=1,vol,maxPrice,minPrice;
        for(let i=count;i>=0;--i)
        {
            var item=bindData.Data[i];
            var changeRate=1;   //换手率
            if (item.FlowCapital>0) changeRate=item.Vol/item.FlowCapital;
            if (i==count) vol=item.Vol*changeRate;
            else vol=item.Vol*seed;
            var dataItem={Vol:vol,High:item.High,Low:item.Low};
            aryVol.push(dataItem);
            seed*=(1-changeRate*rate);

            if (!maxPrice || maxPrice<item.High) maxPrice=item.High;
            if (!minPrice || minPrice>item.Low) minPrice=item.Low;
        }

        //JSConsole.Chart.Log("[StockChip::CalculateChip]",maxPrice,minPrice);
        if (!maxPrice || !minPrice) return true;

        var priceZoom=this.PriceZoom;

        maxPrice=parseInt(maxPrice*priceZoom);
        minPrice=parseInt(minPrice*priceZoom);

        var dataCount=maxPrice-minPrice;
        var aryChip=new Array()
        for(let i=0;i<=dataCount;++i)
        {
            aryChip.push(0);
        }

        var dayChip=[];
        var distributeData;
        if (this.ShowType==2)
        {
            var dayChip=
            [
                {Day:100, Color:this.DAY_COLOR[1][5]}, {Day:60, Color:this.DAY_COLOR[1][4]}, {Day:30, Color:this.DAY_COLOR[1][3]},
                {Day:20, Color:this.DAY_COLOR[1][2]}, {Day:10, Color:this.DAY_COLOR[1][1]}, {Day:5, Color:this.DAY_COLOR[1][0]}
            ];
            for(let i in aryVol)
            {
                var item=aryVol[i];
                var high=parseInt(item.High*priceZoom);
                var low=parseInt(item.Low*priceZoom);
                var averageVol=item.Vol;
                if (high-low>0) averageVol=item.Vol/(high-low);
                if (averageVol<=0.000000001) continue;

                for(var k=0;k<dayChip.length;++k)
                {
                    if (i==dayChip[k].Day) 
                    {
                        dayChip[k].Chip=aryChip.slice(0);
                        break;
                    }
                }

                distributeData={Low:low, High:high, Vol:item.Vol, MaxPrice:maxPrice, MinPrice:minPrice};
                this.CalculateDistribute(aryChip, distributeData );
            }
        }
        else if (this.ShowType==1)
        {
            var dayChip=
            [
                {Day:5, Color:this.DAY_COLOR[0][0]},{Day:10, Color:this.DAY_COLOR[0][1]},{Day:20, Color:this.DAY_COLOR[0][2]},
                {Day:30, Color:this.DAY_COLOR[0][3]},{Day:60, Color:this.DAY_COLOR[0][4]},{Day:100, Color:this.DAY_COLOR[0][5]}
            ];

            for(let i=aryVol.length-1;i>=0;--i)
            {
                var item=aryVol[i];
                var high=parseInt(item.High*priceZoom);
                var low=parseInt(item.Low*priceZoom);
                var averageVol=item.Vol;
                if (high-low>0) averageVol=item.Vol/(high-low);
                if (averageVol<=0.000000001) continue;

                for(var k=0;k<dayChip.length;++k)
                {
                    if (i==dayChip[k].Day) 
                    {
                        dayChip[k].Chip=aryChip.slice(0);
                        break;
                    }
                }
                
                distributeData={Low:low, High:high, Vol:item.Vol, MaxPrice:maxPrice, MinPrice:minPrice};
                this.CalculateDistribute(aryChip, distributeData);
            }
        }
        else
        {
            for(let i in aryVol)
            {
                var item=aryVol[i];
                var high=parseInt(item.High*priceZoom);
                var low=parseInt(item.Low*priceZoom);
                var averageVol=item.Vol;
                if (high-low>0) averageVol=item.Vol/(high-low);
                if (averageVol<=0.000000001) continue;

                distributeData={Low:low, High:high, Vol:item.Vol, MaxPrice:maxPrice, MinPrice:minPrice};
                this.CalculateDistribute(aryChip, distributeData);
            }
        }

        this.Data={AllChip:aryChip, MaxVol:distributeData.MaxVol, MaxPrice:maxPrice, MinPrice:minPrice,SelectData:selData, DayChip:dayChip, YPrice:yPrice};
        return true;
    }

    this.DrawFrame=function()  //X轴成交量坐标
    {
        if (this.IsShowX==false) return;
        if (this.Data.MaxVol<=0) return;

        var isDrawXFrame=this.HQChart.Frame.SubFrame.length===1 ? false:true;         //是否画X轴,如果只有1个窗口就不画
        var KLineFrame=this.HQChart.Frame.SubFrame[0].Frame;
        var chartBorder=KLineFrame.ChartBorder;
        var bottom=ToFixedPoint(chartBorder.GetBottomEx()+1);
        if (!isDrawXFrame) bottom=this.ClientRect.Top+this.ClientRect.Height;
        var left=this.ClientRect.Left;
        var right=left+this.ClientRect.Width;

        this.Canvas.strokeStyle=this.PenBorder;
        this.Canvas.beginPath();
        if (isDrawXFrame)
        {
            this.Canvas.moveTo(left,bottom);
            this.Canvas.lineTo(right,bottom);
        }
        
        var showCount=this.ShowXCount;
        var maxValue=this.Data.MaxVol;
        var perValue=Math.floor(maxValue/showCount);
        this.Canvas.font=this.Font;
        this.Canvas.textBaseline='top';
        this.Canvas.fillStyle=this.InfoColor;
        var xOffset=10*GetDevicePixelRatio();
        for(var i=1;i<=showCount;++i)
        {
            var vol=perValue*i;
            var x=(vol/this.Data.MaxVol)*this.ClientRect.Width+this.ClientRect.Left;
            x=ToFixedPoint(x);
            if (i==showCount)   //最后一个刻度不要画线了
            {
                this.Canvas.textAlign='right';
                var text=IFrameSplitOperator.FormatValueString(maxValue, 1);
                this.Canvas.fillText(text,x,bottom+2);
            }
            else
            {
                this.Canvas.moveTo(x,this.ClientRect.Top);
                this.Canvas.lineTo(x,bottom);
               
                this.Canvas.textAlign='center';
               
                var text=IFrameSplitOperator.FormatValueString(vol, 1);
                var textWidth=this.Canvas.measureText(text).width;
                this.Canvas.fillText(text,Math.floor(x-textWidth*0.25),bottom+2);
            }
        }

        this.Canvas.stroke();
    }
}

//画图工具条
function DrawToolsButton()
{
    this.newMethod=IExtendChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='DrawToolsButton';
    this.HQChart;
    this.ID=Guid();
    this.ToolsDiv;
    // this.Color='rgb(105,105,105)';    //颜色
    this.Color = "#696969";        //input type="color"不支持rgb的颜色格式

    //this.Left=5;
    this.Top=5*GetDevicePixelRatio();
    this.Width=45*GetDevicePixelRatio();         //宽度

    this.SetOption=function(option)
    {
        var pixelRatio=GetDevicePixelRatio();
        if (!option) return;
        if (option.Width>10) this.Width=option.Width*pixelRatio;
    }

    this.Clear=function()
    {
        if (this.ToolsDiv) this.ChartBorder.UIElement.parentNode.removeChild(this.ToolsDiv);
    }

    this.Draw = function () {
        if (this.SizeChange == false) return;

        //工具列表
        const TOOL_LIST =
            [
                [
                    { HTML: { Title: '线段', IClass: 'iconfont icon-draw_line', ID: 'icon-segment' }, Name: '线段' },
                    { HTML: { Title: '尺子', IClass: 'iconfont icon-ruler', ID: 'icon_ruler' }, Name: '尺子' },
                    { HTML: { Title: '射线', IClass: 'iconfont icon-draw_rays', ID: 'icon-beam' }, Name: '射线' },
                    { HTML: { Title: '标价线', IClass: 'iconfont icon-price_line', ID: 'icon-price-line' }, Name: '标价线' },
                    { HTML: { Title: '垂直线', IClass: 'iconfont icon-vertical_line', ID: 'icon-vertical-line' }, Name: '垂直线' },
                    { HTML: { Title: '箭头', IClass: 'iconfont icon-draw_rays', ID: 'icon-beam2' }, Name: '箭头' },
                    { HTML: { Title: '趋势线', IClass: 'iconfont icon-draw_trendline', ID: 'icon-trendline' }, Name: '趋势线' },
                    { HTML: { Title: '水平线', IClass: 'iconfont icon-draw_hline', ID: 'icon-hline' }, Name: '水平线' },
                    { HTML: { Title: '水平线段', IClass: 'iconfont icon-draw_hlinesegment', ID: 'icon-hlineseg' }, Name: '水平线段' },
                    { HTML: { Title: '平行射线', IClass: 'iconfont icon-draw_p_rays_lines', ID: 'icon-rayslineseg' }, Name: '平行射线' },
                    { HTML: { Title: '平行线', IClass: 'iconfont icon-draw_parallel_lines', ID: 'icon-parallellines' }, Name: '平行线' },
                    { HTML: { Title: '平行通道', IClass: 'iconfont icon-draw_parallelchannel', ID: 'icon-parallelchannel' }, Name: '平行通道' },
                    { HTML: { Title: '价格通道线', IClass: 'iconfont icon-draw_pricechannel', ID: 'icon-pricechannel' }, Name: '价格通道线' },
                    { HTML: { Title: 'M头W底', IClass: 'iconfont icon-draw_wavemw', ID: 'icon-wavemw' }, Name: 'M头W底' },
                    { HTML: { Title: '头肩型', IClass: 'iconfont icon-draw_head_shoulders_bt', ID: 'icon-Head-Shoulders' }, Name: '头肩型' },
                    { HTML: { Title: '波浪尺', IClass: 'iconfont icon-waveruler', ID: 'icon-wave-ruler' }, Name: '波浪尺' },
                    { HTML: { Title: 'AB波浪尺', IClass: 'iconfont icon-waveruler', ID: 'icon-wave-ruler' }, Name: 'AB波浪尺' },
                    { HTML: { Title: '箱型线', IClass: 'iconfont icon-draw_box', ID: 'icon-drawbox' }, Name: '箱型线' },
                ],
                [
                    { HTML: { Title: '圆弧', IClass: 'iconfont icon-draw_arc', ID: 'icon-arc' }, Name: '圆弧线' },
                    { HTML: { Title: '矩形', IClass: 'iconfont icon-rectangle', ID: 'icon-rect' }, Name: '矩形' },
                    { HTML: { Title: '平行四边形', IClass: 'iconfont icon-draw_quadrangle', ID: 'icon-quad' }, Name: '平行四边形' },
                    { HTML: { Title: '三角形', IClass: 'iconfont icon-draw_triangle', ID: 'icon-triangle' }, Name: '三角形' },
                    { HTML: { Title: '圆', IClass: 'iconfont icon-draw_circle', ID: 'icon-circle' }, Name: '圆' },
                    { HTML: { Title: '对称角度', IClass: 'iconfont icon-draw_symangle', ID: 'icon-symangle' }, Name: '对称角度' },
                ],
                [
                    { HTML: { Title: '文本', IClass: 'iconfont icon-draw_text', ID: 'icon-text' }, Name: '文本' },
                    { HTML: { Title: '向上箭头', IClass: 'iconfont icon-arrow_up', ID: 'icon-arrowup' }, Name: 'icon-arrow_up' },
                    { HTML: { Title: '向下箭头', IClass: 'iconfont icon-arrow_down', ID: 'icon-arrowdown' }, Name: 'icon-arrow_down' },
                    { HTML: { Title: '向左箭头', IClass: 'iconfont icon-arrow_left', ID: 'icon-arrowleft' }, Name: 'icon-arrow_left' },
                    { HTML: { Title: '向右箭头', IClass: 'iconfont icon-arrow_right', ID: 'icon-arrowright' }, Name: 'icon-arrow_right' },
                ],
                [
                    { HTML: { Title: '江恩角度线', IClass: 'iconfont icon-draw_gannfan', ID: 'icon-gannfan' }, Name: '江恩角度线' },
                    { HTML: { Title: '斐波那契周期线', IClass: 'iconfont icon-draw_fibonacci', ID: 'icon-fibonacci' }, Name: '斐波那契周期线' },
                    { HTML: { Title: '阻速线', IClass: 'iconfont icon-draw_resline', ID: 'icon-resline' }, Name: '阻速线' },
                    { HTML: { Title: '黄金分割', IClass: 'iconfont icon-draw_goldensection', ID: 'icon-goldensection' }, Name: '黄金分割' },
                    { HTML: { Title: '百分比线', IClass: 'iconfont icon-draw_percentage', ID: 'icon-percentage' }, Name: '百分比线' },
                    { HTML: { Title: '波段线', IClass: 'iconfont icon-draw_waveband', ID: 'icon-waveband' }, Name: '波段线' },
                    { HTML: { Title: '线形回归线', IClass: 'iconfont icon-linear_3', ID: 'icon-waveband2' }, Name: '线形回归线' },
                    { HTML: { Title: '线形回归带', IClass: 'iconfont icon-linear_1', ID: 'icon-waveband3' }, Name: '线形回归带' },
                    { HTML: { Title: '延长线形回归带', IClass: 'iconfont icon-linear_2', ID: 'icon-waveband5' }, Name: '延长线形回归带' },
                ],
                [{ HTML: { Title: '全部删除', IClass: 'iconfont icon-recycle_bin', ID: 'icon-delete' }, Name: '全部删除' }]
            ];

        var hqChart = this.HQChart;

        if (!this.ToolsDiv) {
            var div = document.createElement("div");
            div.className = 'drawtools';
            div.id = this.ID;

            var spanList = "";  //一层菜单
            var menuTwoList = ""; //二层菜单
            var menuOne = new Array();
            TOOL_LIST.forEach(function(item,index){
                menuOne.push(item[0]);
            });
            for (var i = 0; i < TOOL_LIST.length; i++) {
                var itemOut = menuOne[i];
                var itemIn = TOOL_LIST[i];
                var menuTwoStr = "";
                var contentArrow = "";
                for (var j = 0; j < itemIn.length; j++) {
                    var currentItem = itemIn[j];
                    var menuTwoName = currentItem.Name;
                    if(menuTwoName.indexOf('up') > -1){
                        menuTwoName = "向上箭头";
                    }else if(menuTwoName.indexOf('down') > -1){
                        menuTwoName = "向下箭头";
                    }else if(menuTwoName.indexOf('left') > -1){
                        menuTwoName = "向左箭头";
                    }else if(menuTwoName.indexOf('right') > -1){
                        menuTwoName = "向右箭头";
                    }
                    menuTwoStr += '<p class="menuTwoItem ' + currentItem.HTML.ID + '">' + menuTwoName + '<i class="' + currentItem.HTML.IClass + '" title="' + currentItem.HTML.Title + '"></i></p>';
                }
                if (i !== TOOL_LIST.length - 1) { //不是“全部删除”项
                    menuTwoList = '<div class="menuTwo">' + menuTwoStr + '</div>';
                    contentArrow = '<i class="contentArrow iconfont icon-menu_arraw_left"></i>';
                } else {
                    menuTwoList = "";
                    contentArrow = "";
                }

                var spanNode = '<div class="icon-image ' + 'first-' + itemOut.HTML.ID + '"><i class="' + itemOut.HTML.IClass + '" title="' + itemOut.HTML.Title + '"></i>' + menuTwoList + contentArrow +'</div>';
                spanList += spanNode;
            }
            this.ChartBorder.UIElement.parentNode.appendChild(div);

            div.innerHTML = spanList;
            this.ToolsDiv = div;
            
            for (var i in TOOL_LIST) {
                var item = TOOL_LIST[i][0];
                $('#' + this.ID + " .first-" + item.HTML.ID).hover(function(){  //箭头的旋转过渡
                    $(".drawtools").find(".contentArrow").hide();
                    $(this).find(".contentArrow").removeClass("trans").show();
                });
                $('#' + this.ID + " .first-" + item.HTML.ID+" .contentArrow").click(function(event){ //点击三角展示二级菜单
                    event.stopPropagation();
                    $(".drawtools").find(".menuTwo").hide();
                    $(this).siblings('.menuTwo').show();
                });
                $('#' + this.ID + " .first-" + item.HTML.ID+" .trans").click(function(){ //点击三角隐藏二级菜单
                    event.stopPropagation();
                    $(this).siblings('.menuTwo').hide();
                });
                
                
                if (item.Name == '全部删除') {
                    $('#' + this.ID + " .first-icon-delete").click(function () {
                        $(".drawtools").find(".menuTwo").hide();
                        $(this).siblings().removeClass('active');
                        $(this).addClass('active');
                        hqChart.ClearChartDrawPicture();
                        $(".subTolls").css("display", "none");
                    });
                }
                else {
                    $('#' + this.ID + " .first-" + menuOne[i].HTML.ID).click( //一层菜单类名是：“first-”+item.HTML.ID
                        {
                            // DrawName: menuOne[i].Name,  //把画法名字传进去
                            CurrentIndex:i
                        },
                        function (event) {
                            $(".drawtools").find(".menuTwo").hide();
                            $(this).siblings().removeClass('active');
                            $(this).addClass('active');
                            hqChart.CreateChartDrawPicture(menuOne[event.data.CurrentIndex].Name);
                        }
                    );
                    for (var j in TOOL_LIST[i]) {
                        var itemTwo = TOOL_LIST[i][j];
                        let classname = itemTwo.HTML.IClass;  //闭包问题
                        $('#' + this.ID + ' .' + itemTwo.HTML.ID).hover(function(event){
                            event.stopPropagation();
                            $(this).closest('.icon-image').find(".contentArrow").addClass("trans");
                        });
                        $('#' + this.ID + ' .' + itemTwo.HTML.ID).click(//二层菜单
                            {
                                DrawName: itemTwo.Name,  //把画法名字传进去
                                CurrentIndex:i,
                                CurrentData:itemTwo
                            },
                            function (event) {
                                event.stopPropagation();
                                $(this).closest('.icon-image').find(".contentArrow").hide();
                                $(this).siblings().removeClass("current");
                                $(this).addClass("current");
                                $(this).closest('.icon-image').children('i').eq(0).removeClass().addClass(classname,"active").attr('title',event.data.CurrentData.HTML.Title);
                                menuOne.splice(event.data.CurrentIndex,1,event.data.CurrentData);
                                $(this).parent().hide();
                                hqChart.CreateChartDrawPicture(event.data.DrawName);
                            }
                        );
                    }
                }
            }

        }
        var curID = this.ID;
        $(document).click(function(event){
            if(!($("#"+curID).is(event.target)) && ($("#"+curID).has(event.target).length === 0)){
                $("#"+curID+" .menuTwo").hide();
                $("#"+curID+" .contentArrow").hide();
            }
        });
        var scrollPos = GetScrollPosition();
        var pixelRatio=GetDevicePixelRatio();
        // var left=this.ChartBorder.GetChartWidth()-this.Right-this.ToolsWidth;
        var left=ToFixedPoint(this.ChartBorder.GetRight()+this.Left);
        // var top = this.Top+this.ChartBorder.UIElement.getBoundingClientRect().top+scrollPos.Top;
        var top = this.ChartBorder.GetTop();
        this.ToolsDiv.style.left = left/pixelRatio + "px";
        this.ToolsDiv.style.top = top/pixelRatio + "px";
        this.ToolsDiv.style.width = (this.Width-5)/pixelRatio + "px";
        this.ToolsDiv.style.height = 'auto';
        this.ToolsDiv.style.position = "absolute";
        this.ToolsDiv.style.display = "block";
        // this.ToolsDiv.style.paddingLeft = "10px";

        this.SizeChange == true;
    }
}


//窗口分割
function FrameSplitPaint()
{
    this.newMethod=IExtendChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='FrameSplitPaint';
    this.LineColor='rgb(255,0,0)';
    this.TextColor="rgb(255,0,0)";
    this.LineWidth=2;
    this.Font='bold '+18*GetDevicePixelRatio() +"px 微软雅黑";
    this.TextTopOffset=10*GetDevicePixelRatio();

    //设置参数接口
    this.SetOption=function(option)
    {
        if (option)
        {
            if (option.LineColor) this.LineColor=option.LineColor;
            if (option.TextColor) this.TextColor=option.TextColor;
            if (option.Font) this.Font=option.Font;
            if (IFrameSplitOperator.IsNumber(option.LineWidth)) this.LineWidth=option.LineWidth;
            if (IFrameSplitOperator.IsNumber(option.TextTopOffset)) this.TextTopOffset=option.TextTopOffset;
        }
    }

    this.Draw=function()
    {
        if (!this.HQChart) return;
        if (this.HQChart.Period!=0 && this.HQChart.Period!=1) return;

        if (!this.HQChart.ChartPaint[0]) return;
        var data=this.HQChart.ChartPaint[0].Data;
        if (!data) return;
        this.Data=data;
        if (!this.ChartFrame || !this.ChartFrame.SubFrame) return;
        var subFrame=this.ChartFrame.SubFrame[0].Frame;
        if (!subFrame) return;

        var isHScreen=(subFrame.IsHScreen===true);
        var dataWidth=subFrame.DataWidth;
        var distanceWidth=subFrame.DistanceWidth;
        var xPointCount=subFrame.XPointCount;

        var lineWidth=this.LineWidth * GetDevicePixelRatio();

        if (isHScreen)
        {
            var border=this.ChartBorder.GetHScreenBorder();
            var xOffset=border.TopEx+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
            var chartright=border.BottomEx;
        }
        else
        {
            var border=this.ChartBorder.GetBorder();
            var xOffset=border.LeftEx+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
            var chartright=border.RightEx;
            var drawHeight=border.ChartHeight-border.TopTitle-5*GetDevicePixelRatio();
        }

        this.Canvas.save();
        this.Canvas.lineWidth=lineWidth;
        this.Canvas.font=this.Font;
        this.Canvas.textAlign='center';
        this.Canvas.textBaseline='top';
        var preQuarter={ Left:border.LeftEx, Top:ToFixedPoint2(lineWidth,border.TopTitle), Height:drawHeight, LineWidth:lineWidth };
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var item=this.Data.Data[i];
            if (!item) continue;
            
            var dateInfo=this.GetQuarter(item.Date);
            if (!dateInfo) continue;

            var left=xOffset;
            var right=xOffset+dataWidth;
            if (right>chartright) break;
            var x=left+(right-left)/2;


            if (!preQuarter.DateInfo)
            {
                preQuarter.DateInfo=dateInfo;
                preQuarter.Right=x;
            }
            else
            {
                var preDateInfo=preQuarter.DateInfo;
                if (preDateInfo.Year!=dateInfo.Year || preDateInfo.Quarter!=dateInfo.Quarter)
                {
                    preQuarter.Right=x;
                    this.DrawQuarter(preQuarter);

                    preQuarter.Left=x;
                    preQuarter.Right=null;
                    preQuarter.DateInfo=dateInfo;
                }
                else
                {
                    preQuarter.Right=x;
                }
            }
        }

        this.DrawQuarter(preQuarter);

        this.Canvas.restore();
    }

    this.DrawQuarter=function(quarterInfo)
    {
        if (!IFrameSplitOperator.IsNumber(quarterInfo.Left) || !IFrameSplitOperator.IsNumber(quarterInfo.Right)) return;

        var left=ToFixedPoint2(quarterInfo.LineWidth,quarterInfo.Left);
        var right=ToFixedPoint2(quarterInfo.LineWidth,quarterInfo.Right);
        var drawWidth=right-left;
        this.Canvas.strokeStyle=this.LineColor;
        this.Canvas.strokeRect(left, quarterInfo.Top, drawWidth, quarterInfo.Height);

        var date=quarterInfo.DateInfo;
        var shortYear=date.Year%100;
        if (shortYear<10) var strYear='0'+shortYear;
        else var strYear=shortYear.toString();
        var text=`${strYear}年${date.Quarter}季度`;
        var textWidth = this.Canvas.measureText(text).width;
        if (textWidth<(drawWidth+5))
        {
            var x=left+drawWidth/2;
            var y=quarterInfo.Top+this.TextTopOffset;
            this.Canvas.fillStyle=this.TextColor;
            this.Canvas.fillText(text,x,y);
        }
    }

    this.GetQuarter=function(date)
    {
        if (!IFrameSplitOperator.IsNumber(date)) return null;

        var year=parseInt(date/10000);
        var month=parseInt((date%10000)/100);

        switch(month)
        {
            case 1:
            case 2:
            case 3:
                var quarter=1;
                break;
            case 4:
            case 5:
            case 6:
                var quarter=2;
                break;
            case 7:
            case 8:
            case 9:
                var quarter=3;
                break;
            case 10:
            case 11:
            case 12:
                var quarter=4;
                break;
            default:
                return null;
        }

        return { Year:year, Month:month, Quarter:quarter };
    }
}


//深度图 支持横屏
/*
    数据格式:
    [ 
        { 
            Data:[ {X,Y}, ],
            Type: 1=Up 2=Down 0=Default,
            LineColor:
            AreaColor:
            TextColor:
            Range:{X:{Max,Min:}, Y:{Max:,Min:} }
            Height:高度 百分比,
            Order:"ASC", //DESC=降序 ASC=升序
            IsShowCorssCursor:true/false;         //是否显示十字光标的提示信息
        },
    ]
*/

function DepthMapPaint()
{
    this.newMethod=IExtendChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='DepthMapPaint';

    this.LineColor="rgba(0,139,0,0.6)";
    this.AreaColor=["rgba(0,139,0,0.5)","rgba(0,139,0,0.4)","rgba(0,139,0,0.3)",'rgba(0,139,0,0.2)'];
    this.TextColor="rgba(0,0,0)";
    this.TextBGColor="rgba(0,139,0)";

    this.Width=200*GetDevicePixelRatio();
    this.FrameID=0;
    this.ID=Guid(); //唯一的ID

    this.IsDynamic=false;
    this.IsCallbackDraw=true;   //在回调函数里绘制, 不在Draw()中绘制

    this.YRange;    //Y值范围

    /*
    this.Data=[
       { 
           Data: [ {X:100,Y:20}, {X:110,Y:30}, {X:120,Y:40},{X:130,Y:50} ],
           Type:1,
           Range:{ X:{Max:130, Min:100}, Y:{ Max:50, Min:0} },
           Height:0.5,
           LineColor:'rgba(255,106,106,0.6)',
           AreaColor:['rgba(255,106,106,0.5)','rgba(255,106,106,0.4)','rgba(255,106,106,0.3)','rgba(255,106,106,0.2)'],
           IsASC:false, //true=升序 false=降序
       },
       { 
            Data: [ {X:100,Y:20}, {X:110,Y:30}, {X:120,Y:40},{X:130,Y:50} ],
            Type:2,
            Range:{ X:{Max:130, Min:100}, Y:{ Max:50, Min:0} },
            Height:0.5,
            IsASC:true, //true=升序 false=降序
        },
        {
            Data:[ {X:11.60, Y:50}, {X:11.65, Y:80}, {X:11.68, Y:85},{X:11.70, Y:55}],
            Type:0,
            Range:{ Y:{ Max:100, Min:0} },

            LineColor:'rgba(255,165,0,0.6)',
            AreaColor:['rgba(255,165,0,0.5)','rgba(255,165,0,0.4)','rgba(255,165,0,0.3)','rgba(255,165,0,0.2)']
        }
    ];
    */

    this.SetOption=function(option) //设置
    {
        if (option.FrameID>0) this.FrameID=option.FrameID;
        if (option.Width>0) this.Width=option.Width;
        if (IFrameSplitOperator.IsObjectExist(option.ID)) this.ID=option.ID;
        if (option.IsShowCorssCursor) this.IsShowCorssCursor=option.IsShowCorssCursor;
    }

    this.Draw=function()
    {
        if (!this.Data) return;
        if (!this.ChartFrame || !this.ChartFrame.SubFrame || this.ChartFrame.SubFrame.length<=this.FrameID) return;

        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var frame=this.ChartFrame.SubFrame[this.FrameID].Frame;
        var chartBorder=frame.ChartBorder;

        var height=chartBorder.GetHeightEx();
        var left=chartBorder.GetRight();
        var top=chartBorder.GetTopEx();
        var bottom=chartBorder.GetBottomEx();
        var width=this.Width;
        if (width>this.ChartBorder.Right) width=this.ChartBorder.Right;

        if (isHScreen)
        {
            left=chartBorder.GetBottom();
            top=chartBorder.GetRight();
            bottom=chartBorder.GetLeft();
            var width=this.Width;
            if (width>this.ChartBorder.Bottom) width=this.ChartBorder.Bottom;
        }

        var rtClient={ Left:left, Top:top, Right:left+width, Bottom:bottom, Height:height, Width:width };
        this.YRange={ Max:null, Min:0 };
        for(var i in this.Data)
        {
            var item=this.Data[i];
            this.CalculateYRange(item, this.YRange);
        }

        for(var i in this.Data)
        {
            var item=this.Data[i];
            if (item.Height>0 && item.Height<=1) rtClient.Height=height*item.Height;
            else rtClient.Height=height;
            
            if (item.Type==1)
            {
                rtClient.Top=top;
                rtClient.Bottom=top+rtClient.Height;
                this.DrawUpArea(item,rtClient);
            }
            else if (item.Type==2)
            {
                rtClient.Bottom=bottom;
                rtClient.Top=rtClient.Bottom-rtClient.Height;
                this.DrawDownArea(item,rtClient);
            }
            else
            {
                rtClient.Top=top;
                rtClient.Bottom=bottom;
                this.DrawDefaultArea(item,rtClient);
            }
        }
    }

    this.CalculateYRange=function(drawData, yRange)
    {
        for(var i in drawData.Data)
        {
            var item=drawData.Data[i];
            if (yRange.Max==null || yRange.Max<item.Y) yRange.Max=item.Y;
            if (yRange.Min==null || yRange.Min>item.Y) yRange.Min=item.Y;
        }
    }


    this.GetXFromData=function(value, rtClient, minMax)    //获取X轴坐标
    {
        var width = rtClient.Width * (value - minMax.Min) / (minMax.Max - minMax.Min);
        return rtClient.Left + width;
    }

    this.GetYFromData=function(value, rtClient, minMax, isASC)
    {
        if (isASC)
        {
            var height = rtClient.Height * (value - minMax.Min) / (minMax.Max - minMax.Min);
            return rtClient.Bottom - height;
        }
        else
        {
            var height = rtClient.Height * (value - minMax.Min) / (minMax.Max - minMax.Min);
            return rtClient.Top + height;
        }
    }

    this.DrawDefaultArea=function(drawData, rtClient)
    {
        var frame=this.ChartFrame.SubFrame[this.FrameID].Frame;
        var yRange=(drawData.Range && drawData.Range.Y) ? drawData.Range.Y : this.YRange;

        var aryPoint=[];
        for(var i in drawData.Data)
        {
            var item=drawData.Data[i];
            var x=this.GetXFromData(item.Y,rtClient,yRange);
            if (item.X>frame.HorizontalMax || item.X<frame.HorizontalMin) continue;
            var y=frame.GetYFromData(item.X);

            aryPoint.push({X:x,Y:y});
        }

        var lineColor=drawData.LineColor? drawData.LineColor: this.LineColor;
        var areaColor=drawData.AreaColor? drawData.AreaColor: this.AreaColor;
        if (aryPoint.length>0) this.DrawLine(aryPoint,lineColor, areaColor,rtClient);
    }

    this.DrawUpArea=function(drawData,rtClient)
    {
        var aryPoint=[];
        for(var i in drawData.Data)
        {
            var item=drawData.Data[i];
            var x=this.GetXFromData(item.Y,rtClient,drawData.Range.Y);
            var y=this.GetYFromData(item.X,rtClient,drawData.Range.X,drawData.IsASC);

            aryPoint.push({X:x,Y:y});
        }

        var lineColor=drawData.LineColor? drawData.LineColor: this.LineColor;
        var areaColor=drawData.AreaColor? drawData.AreaColor: this.AreaColor;
        if (aryPoint.length>0) this.DrawLine(aryPoint,lineColor, areaColor,rtClient);
    }

    this.DrawDownArea=function(drawData,rtClient)
    {
        var aryPoint=[];
        for(var i in drawData.Data)
        {
            var item=drawData.Data[i];
            var x=this.GetXFromData(item.Y,rtClient,drawData.Range.Y);
            var y=this.GetYFromData(item.X,rtClient,drawData.Range.X,drawData.IsASC);

            aryPoint.push({X:x,Y:y});
        }

        var lineColor=drawData.LineColor? drawData.LineColor: this.LineColor;
        var areaColor=drawData.AreaColor? drawData.AreaColor: this.AreaColor;
        if (aryPoint.length>0) this.DrawLine(aryPoint,lineColor, areaColor,rtClient);
    }

    this.DrawLine=function(aryPoint,lineColor, areaColor,rtClient)
    {
        var isHScreen=(this.ChartFrame.IsHScreen===true);
        var bFirstPoint=true;
        var drawCount=0;
        this.Canvas.strokeStyle=lineColor;
        
        for(var i in aryPoint)
        {
            var item=aryPoint[i];
            if (bFirstPoint)
            {
                this.Canvas.beginPath();
                if (isHScreen) this.Canvas.moveTo(item.Y,item.X);
                else this.Canvas.moveTo(item.X,item.Y);
                bFirstPoint=false;
            }
            else
            {
                if (isHScreen) this.Canvas.lineTo(item.Y,item.X);
                else this.Canvas.lineTo(item.X,item.Y);
            }

            ++drawCount;
        }

        if (drawCount>0) this.Canvas.stroke();

        //面积
        var firstPoint=aryPoint[0];
        var lastPoint=aryPoint[aryPoint.length-1];
        if (isHScreen)
        {
            this.Canvas.lineTo(lastPoint.Y,rtClient.Left);
            this.Canvas.lineTo(firstPoint.Y,rtClient.Left);
        }
        else
        {
            this.Canvas.lineTo(rtClient.Left,lastPoint.Y);
            this.Canvas.lineTo(rtClient.Left,firstPoint.Y);
        }
        this.Canvas.closePath();

        if (Array.isArray(areaColor))
        {
            if (isHScreen)
            {
                let gradient = this.Canvas.createLinearGradient(this.ChartBorder.GetRightEx(),this.ChartBorder.GetTop(), this.ChartBorder.GetLeft(),this.ChartBorder.GetTop());
                gradient.addColorStop(0, areaColor[0]);
                gradient.addColorStop(1, areaColor[1]);
                this.Canvas.fillStyle=gradient;
            }
            else
            {
                let gradient = this.Canvas.createLinearGradient(rtClient.Right,rtClient.Top, rtClient.Left,rtClient.Top);
                var offset=1/areaColor.length;
                for(var i in areaColor)
                {
                    gradient.addColorStop(i*offset, areaColor[i]);
                }
                this.Canvas.fillStyle=gradient;
            }
        }
        else
        {
            this.Canvas.fillStyle=areaColor;
        }
        
        this.Canvas.fill();
        
    }

    this.GetYValueByXValue=function(x,floatPrecision)
    {
        var aryXValue=[];
        var value=0;
        var zoom=ZOOM_VALUE[floatPrecision];
        for(var i in this.Data)
        {
            var item=this.Data[i];
            if (item.Type!=0 || !item.Data || item.Data.length<0 || item.IsShowCorssCursor==false) continue;

            var bFind=false;
            for(var j in item.Data)
            {
                var dataItem=item.Data[j];
                value=parseInt(dataItem.X*zoom);
                if (value==x) 
                {
                    bFind=true;
                    var findItem=
                    { 
                        X:dataItem.X, Y:dataItem.Y, 
                        TextColor:item.TextColor? item.TextColor: this.TextColor,
                        TextBGColor:item.TextBGColor? item.TextBGColor: this.TextBGColor  
                    };
                    if (dataItem.YText) findItem.YText=dataItem.YText;

                    aryXValue.push(findItem);
                    break;
                }
            }

            if (!bFind)
            {
                var first=item.Data[0];
                var last=item.Data[item.Data.length-1];
                if (x>first.X*zoom && x<last.X*zoom)
                {
                    aryXValue.push( 
                    { 
                        X:null, Y:null, 
                        TextColor:item.TextColor? item.TextColor: this.TextColor,
                        TextBGColor:item.TextBGColor? item.TextBGColor: this.TextBGColor  
                    } ); 
                }
            }
        }

        return aryXValue;
    }
}


//背景图 支持横屏
function BackgroundPaint()
{
    this.newMethod=IExtendChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='BackgroundPaint';

    this.IsDynamic=false;
    this.IsCallbackDraw=true;   //在回调函数里绘制, 不在Draw()中绘制

    this.FrameID=0;
    this.Data;      //背景数据 { Start:, End:, Color:[] }
    this.ID=Guid(); //唯一的ID

    /*
    this.Data=
    [ 
        { Start:{ Date:20181201 }, End:{ Date:20181230 }, Color:'rgb(44,55,44)' } , 
        { Start:{ Date:20190308 }, End:{ Date:20190404 }, Color:['rgb(44,55,255)','rgb(200,55,255)'] } 
    ]
    */

    this.ChartSubFrame;
    this.ChartBorder;
    this.KData;
    this.Period;
    this.XPointCount=0;

    this.SetOption=function(option) //设置
    {
        if (option.FrameID>0) this.FrameID=option.FrameID;
        if (IFrameSplitOperator.IsObjectExist(option.ID)) this.ID=option.ID;
    }

    this.Draw=function()
    {
        if (!this.Data || !this.HQChart) return;
        if (!this.ChartFrame || !this.ChartFrame.SubFrame || this.ChartFrame.SubFrame.length<=this.FrameID) return;
        var klineChart=this.HQChart.ChartPaint[0];
        if (!klineChart || !klineChart.Data) return;

        this.ChartSubFrame=this.ChartFrame.SubFrame[this.FrameID].Frame;
        this.ChartBorder=this.ChartSubFrame.ChartBorder;
        this.KData=klineChart.Data;
        this.Period=this.HQChart.Period;
        if (!this.KData || this.KData.Data.length<=0) return;

        var isHScreen=(this.ChartSubFrame.IsHScreen===true);
        this.XPointCount=this.ChartSubFrame.XPointCount;
        var xPointCount=this.ChartSubFrame.XPointCount;
        
        var firstKItem=this.KData.Data[this.KData.DataOffset];
        var endIndex=this.KData.DataOffset+xPointCount-1;
        if (endIndex>=this.KData.Data.length) endIndex=this.KData.Data.length-1;
        var endKItem=this.KData.Data[endIndex];
        var showData=this.GetShowData(firstKItem,endKItem);
        if (!showData || showData.length<=0) return;

        var kLineMap=this.BuildKLineMap();
        var bottom=this.ChartBorder.GetBottomEx();
        var top=this.ChartBorder.GetTopEx();
        var height=this.ChartBorder.GetHeightEx();
        if (isHScreen)
        {
            top=this.ChartBorder.GetRightEx();
            bottom=this.ChartBorder.GetLeftEx();
            height=this.ChartBorder.GetWidthEx(); 
        }

        for(var i in showData)
        {
            var item=showData[i];
            var rt=this.GetBGCoordinate(item,kLineMap);
            if (!rt) continue;

            if (Array.isArray(item.Color))
            {
                var gradient;
                if (isHScreen) gradient = this.Canvas.createLinearGradient(bottom,rt.Left, top, rt.Left);
                else gradient = this.Canvas.createLinearGradient(rt.Left,top, rt.Left,bottom);
                var offset=1/item.Color.length;
                for(var i in item.Color)
                {
                    gradient.addColorStop(i*offset, item.Color[i]);
                }
                this.Canvas.fillStyle=gradient;
            }
            else
            {
                this.Canvas.fillStyle=item.Color;
            }

            if (isHScreen) this.Canvas.fillRect(ToFixedRect(bottom),ToFixedRect(rt.Left),ToFixedRect(height),ToFixedRect(rt.Width));
            else this.Canvas.fillRect(ToFixedRect(rt.Left),ToFixedRect(top),ToFixedRect(rt.Width),ToFixedRect(height));
        }
    }

    this.GetShowData=function(first, end)
    {
        var aryData=[];
        for(var i in this.Data)
        {
            var item=this.Data[i];
            var showItem={ };
            if (item.Start.Date>=first.Date && item.Start.Date<=end.Date) showItem.Start=item.Start;
            if (item.End.Date>=first.Date && item.End.Date<=end.Date) showItem.End=item.End;
            if (showItem.Start || showItem.End) 
            {
                showItem.Color=item.Color;
                aryData.push(showItem);
            }
        }

        //JSConsole.Chart.Log('[BackgroundPaint::GetShowData]  aryData ', aryData);
        return aryData;
    }

    this.BuildKLineMap=function()
    {
        var isHScreen=(this.ChartSubFrame.IsHScreen===true);
        var dataWidth=this.ChartSubFrame.DataWidth;
        var distanceWidth=this.ChartSubFrame.DistanceWidth;
        var xOffset=this.ChartBorder.GetLeft()+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
        if (isHScreen) xOffset=this.ChartBorder.GetTop()+distanceWidth/2.0+g_JSChartResource.FrameLeftMargin;
        var chartright=this.ChartBorder.GetRight();
        if (isHScreen) chartright=this.ChartBorder.GetBottom();

        var mapKLine={ Data:new Map() ,Start:null, End:null } ; //Key: date / date time, Value:索引
        for(var i=this.KData.DataOffset,j=0; i<this.KData.Data.length && j<this.XPointCount; ++i,++j,xOffset+=(dataWidth+distanceWidth))
        {
            var kItem=this.KData.Data[i];
            var left=xOffset;
            var right=xOffset+dataWidth;
            if (right>chartright) break;
            var x=left+(right-left)/2;

            if (j==0) mapKLine.XLeft=left;
            mapKLine.XRight=right;

            var value={ Index:i, ShowIndex:j , X:x, Right:right, Left:left, Date:kItem.Date };
            if (ChartData.IsMinutePeriod(this.Period,true))
            {
                var key=`Date:${kItem.Date} Time:${kItem.Time}`;
                value.Time=kItem.Time;
            }
            else
            {
                var key=`Date:${kItem.Date}`;
            }
               
            mapKLine.Data.set(key,value);

            //保存下起始和结束位置
            if (j==0) mapKLine.Start=value;
            mapKLine.End=value;
        }

        return mapKLine;
    }

    this.GetBGCoordinate=function(item,kLineMap)
    {
        var xLeft=null, xRight=null;
        var isMinutePeriod=ChartData.IsMinutePeriod(this.Period,true);
        var bSingleDate=false;
        //JSConsole.Chart.Log('[BackgroundPaint::GetBGCoordinate]  item ', item);
        if (isMinutePeriod)
        {
            if (item.Start && item.End && item.Start.Date==item.End.Date && item.Start.Time==item.End.Time) bSingleDate=true;
        }
        else
        {
            if (item.Start && item.End && item.Start.Date==item.End.Date) bSingleDate=true;
        }

        if (bSingleDate)
        {
            if (isMinutePeriod)
                var key=`Date:${item.Start.Date} Time:${item.Start.Time}`;
            else 
                var key=`Date:${item.Start.Date}`;

            if (!kLineMap.Data.has(key)) return null;
            var findItem=kLineMap.Data.get(key);
            xLeft=findItem.Left;
            xRight=findItem.Right;
            return { Left:xLeft, Right:xRight, Width:xRight-xLeft };
        }
        
        if (item.Start)
        {
            if (isMinutePeriod)
                var key=`Date:${item.Start.Date} Time:${item.Start.Time}`;
            else 
                var key=`Date:${item.Start.Date}`;

            if (kLineMap.Data.has(key)) 
            {
                var findItem=kLineMap.Data.get(key);
                xLeft=findItem.Left;
            }
            else 
            {
                if (isMinutePeriod)
                {
                    if (item.Start.Date<kLineMap.Start.Date || (item.Start.Date==kLineMap.Start.Date && item.Start.Time<=kLineMap.Start.Time) ) 
                    {
                        xLeft=kLineMap.Start.Left;
                    }
                    else
                    {
                        for(var kItem of kLineMap.Data)
                        {
                            var value=kItem[1];
                            if (value.Date>item.Start.Date || (value.Date==item.Start.Date && value.Time>item.Start.Time))
                            {
                                xLeft=value.Left;
                                break;
                            }
                        }
                    }
                }
                else
                {
                    if (item.Start.Date<=kLineMap.Start.Date) 
                    {
                        xLeft=kLineMap.Start.Left;
                    }
                    else
                    {
                        for(var kItem of kLineMap.Data)
                        {
                            var value=kItem[1];
                            if (value.Date>item.Start.Date)
                            {
                                xLeft=value.Left;
                                break;
                            }
                        }
                    }
                }
            }
        }
        else
        {
            xLeft=kLineMap.XLeft;
        }

        if (item.End)
        {
            if (isMinutePeriod)
                var key=`Date:${item.End.Date} Time:${item.End.Time}`;
            else 
                var key=`Date:${item.End.Date}`;

            if (kLineMap.Data.has(key))
            {
                var findItem=kLineMap.Data.get(key);
                xRight=findItem.Right;
            }
            else
            {
                if (isMinutePeriod)
                {
                    if (item.End.Date<kLineMap.End.Date || (item.End.Date==kLineMap.End.Date && item.End.Time>=kLineMap.End.Time) ) 
                    {
                        xRight=kLineMap.End.Right;
                    }
                    else
                    {
                        var previousX=null;
                        for(var kItem of kLineMap.Data)
                        {
                            var value=kItem[1];
                            if (value.Date>item.End.Date || (value.Date==item.End.Date && value.Time>item.End.Time) )
                            {
                                xRight=previousX;
                                break;
                            }
                            previousX=value.Right;
                        }
                    }
                }
                else
                {
                    if (item.End.Date<=kLineMap.End.Date) 
                    {
                        xRight=kLineMap.End.Right;
                    }
                    else
                    {
                        var previousX=null;
                        for(var kItem of kLineMap.Data)
                        {
                            var value=kItem[1];
                            if (value.Date>item.End.Date)
                            {
                                xRight=previousX;
                                break;
                            }
                            previousX=value.Right;
                        }
                    }
                }
            }
        }
        else
        {
            xRight=kLineMap.XRight;
        }

        if (xLeft==null || xRight==null) return null;

        return { Left:xLeft, Right:xRight, Width:xRight-xLeft };
    }
}


//弹幕数据 { X:X偏移, Y:Y偏移, Text:内容, Color:颜色 }
function BarrageList()
{
    this.PlayList=[];   //正在播放队列
    this.Cache=[];      //没有播放的弹幕数据
    this.MinLineHeight=40*GetDevicePixelRatio();
    this.Height;        //高度
    this.Step=1;

    //{Canves:画布, Right:右边坐标, Left:左边坐标, Font:默认字体 }
    this.GetPlayList=function(obj)
    {
        var canves=obj.Canves;
        var right=obj.Right;
        var left=obj.Left;
        var width=right-left;
        var isMoveStep=obj.IsMoveStep;

        var list=[];
        var yOffset=0;
        for(var i=0;i<this.PlayList.length;++i)
        {
            var ary=this.PlayList[i];
            var lineHeight=this.MinLineHeight;
            if (ary.Height>this.MinLineHeight) lineHeight=ary.Height;

            var bAddNewItem=true;  //是否需要加入新弹幕
            var bRemoveFirst=false; //是否删除第1个数据
            for(var j=0;j<ary.Data.length;++j)
            {
                var item=ary.Data[j];
                var playItem={ X:item.X, Y:yOffset, Text:item.Text, Color:item.Color, Height:lineHeight, Font:item.Font, Info:item.Info };
                list.push(playItem);

                if (!isMoveStep) continue;
                
                if(j==ary.Data.length-1 && this.Cache.length>0)    //最后一个数据了 判断是否需要增加弹幕
                {
                    bAddNewItem=false;
                    if (!item.TextWidth)
                    {
                        if (item.Font && item.Font.Name) canves.font=item.Font.Name;
                        else canves.font=obj.Font;
                        item.TextWidth=canves.measureText(playItem.Text+'擎擎').width;
                    }
                    
                    if (item.X>=item.TextWidth) 
                        bAddNewItem=true;
                }
                else if (j==0)
                {
                    bRemoveFirst=false;
                    if (!item.TextWidth)
                    {
                        if (item.Font && item.Font.Name) canves.font=item.Font.Name;
                        else canves.font=obj.Font;
                        item.TextWidth=canves.measureText(playItem.Text+'擎擎').width;
                    }

                    if (item.X>width+item.TextWidth) bRemoveFirst=true;
                }

                item.X+=this.Step;
            }

            if(isMoveStep && bAddNewItem && this.Cache.length>0)    //最后一个数据了 判断是否需要增加弹幕
            {
                var cacheItem=this.Cache.shift();
                var newItem={ X:0, Text:cacheItem.Text, Color:cacheItem.Color , Font:cacheItem.Font, Info:cacheItem.Info };
                ary.Data.push(newItem);
            }

            if (isMoveStep && bRemoveFirst && ary.Data.length>0)
            {
                var removeItem=ary.Data.shift();
                this.OnItemPlayEnd(obj.HQChart,removeItem);
            }

            yOffset+=lineHeight;
        }

        return list;
    }

    //根据高度计算播放队列个数
    this.CacluatePlayLine=function(height)
    {
        this.Height=height;
        var lineCount=parseInt(height/this.MinLineHeight);
        if (this.PlayList.length<lineCount)
        {
            var addCount=lineCount-this.PlayList.length;
            for(var i=0;i<addCount;++i)
            {
                this.PlayList.push({Data:[]});
            }
        }
        else if (this.PlayList.length>lineCount)
        {
            var removeCount=this.PlayList.length-lineCount;
            for(var i=0;i<removeCount;++i)
            {
                var ary=this.PlayList.pop();
                for(var j=0;j<ary.Data.length;++j)
                {
                    var item=ary.Data[j];
                    var cacheItem={ Text:item.Text, Color:item.Color, Font:item.Font, Info:item.Info };
                    this.Cache.unshift(cacheItem);
                }
            }
        }

        JSConsole.Chart.Log(`[BarrageList::CacluatePlayLine] LineCount=${this.PlayList.length} Height=${this.Height}` )
    }

    //添加弹幕
    this.AddBarrage=function(barrageData)
    {
        for(var i in barrageData)
        {
            var item=barrageData[i];
            this.Cache.push(item);
        }
    }

    this.OnItemPlayEnd=function(hqChart, item)  //单挑弹幕播放完毕
    {
        //监听事件
        if (!hqChart.mapEvent.has(JSCHART_EVENT_ID.BARRAGE_PLAY_END)) return;
        var event=hqChart.mapEvent.get(JSCHART_EVENT_ID.BARRAGE_PLAY_END);
        if (!event.Callback) return;

        event.Callback(event,item,this);
    }

    this.Count=function() { return this.Cache.length; } //未播放的弹幕个数
}

//弹幕
function BarragePaint()
{
    this.newMethod=IExtendChartPainting;   //派生
    this.newMethod();
    delete this.newMethod;

    this.ClassName='BarragePaint';
    this.IsAnimation=true;
    this.IsEraseBG=true;
    this.HQChart;

    this.Font=g_JSChartResource.Barrage.Font;
    this.TextColor=g_JSChartResource.Barrage.Color;
    this.FontHeight=g_JSChartResource.Barrage.Height;

    this.BarrageList=new BarrageList();  //字幕列表
    this.IsMoveStep=false;


    //设置参数接口
    this.SetOption=function(option)
    {
        if (option)
        {
            if (option.Step>0) this.BarrageList.Step=option.Step;
            if (option.MinLineHeight) this.Barrage.MinLineHeight=option.MinLineHeight;
        }
    }

    this.DrawHScreen=function()
    {
        var height=this.ChartBorder.GetWidth();
        var left=this.ChartBorder.GetTop();
        var right=this.ChartBorder.GetBottom();
        var top=this.ChartBorder.GetRightEx();
        var wdith=this.ChartBorder.GetChartWidth();

        if (height!=this.BarrageList.Height)
            this.BarrageList.CacluatePlayLine(height);

        this.Canvas.textBaseline="middle";
        this.Canvas.textAlign="left";

        var play=this.BarrageList.GetPlayList({Canves:this.Canvas, Right:right, Left:left, Font:this.Font, IsMoveStep:this.IsMoveStep, HQChart:this.HQChart});
        this.IsMoveStep=false;
        if (!play) return;

        this.Canvas.save(); 
        this.Canvas.translate(this.ChartBorder.GetChartHeight(), 0);
        this.Canvas.rotate(90 * Math.PI / 180);

        for(var i=0;i<play.length;++i)
        {
            var item=play[i];
            if (item.Color) this.Canvas.fillStyle=item.Color;
            else this.Canvas.fillStyle=this.TextColor;
            if (item.Font) this.Canvas.font=item.Font.Name;
            else this.Canvas.font=this.Font;

            var fontHeight=this.FontHeight;
            if (item.Font && item.Font.Height>0) fontHeight=item.Font.Height;
            var yOffset=item.Y+parseInt((item.Height-fontHeight)/2);

            this.Canvas.fillText(item.Text, right-item.X,top+yOffset);
        }

        this.Canvas.restore();
    }

    this.Draw=function()
    {
        if (this.ChartFrame.IsHScreen)
        {
            this.DrawHScreen();
            return;
        }

        var left=this.ChartBorder.GetLeft();
        var right=this.ChartBorder.GetRight();
        var top=this.ChartBorder.GetTopEx();
        var height=this.ChartBorder.GetHeight();

        if (height!=this.BarrageList.Height)
            this.BarrageList.CacluatePlayLine(height);

        this.Canvas.textBaseline="middle";
        this.Canvas.textAlign="left";

        var play=this.BarrageList.GetPlayList({Canves:this.Canvas, Right:right, Left:left, Font:this.Font, IsMoveStep:this.IsMoveStep, HQChart:this.HQChart});
        this.IsMoveStep=false;
        if (!play) return;

        for(var i=0;i<play.length;++i)
        {
            var item=play[i];
            if (item.Color) this.Canvas.fillStyle=item.Color;
            else this.Canvas.fillStyle=this.TextColor;
            if (item.Font) this.Canvas.font=item.Font.Name;
            else this.Canvas.font=this.Font;

            var fontHeight=this.FontHeight;
            if (item.Font && item.Font.Height>0) fontHeight=item.Font.Height;
            var yOffset=item.Y+parseInt((item.Height-fontHeight)/2);

            this.Canvas.fillText(item.Text, right-item.X,top+yOffset);
        }
    }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//坐标分割
//
//
////////////////////////////////////////////////////////////////////////////////////////////////////
function IFrameSplitOperator()
{
    this.ChartBorder;                   //边框信息
    this.Frame;                         //框架信息
    this.FrameSplitData;                //坐标轴分割方法
    this.SplitCount=5;                  //刻度个数
    this.StringFormat=0;                //刻度字符串格式
    this.IsShowLeftText=true;           //显示左边刻度 
    this.IsShowRightText=true;          //显示右边刻度
    this.LanguageID=JSCHART_LANGUAGE_ID.LANGUAGE_CHINESE_ID;
    this.GetEventCallback;              //事件回调

    //////////////////////
    // data.Min data.Max data.Interval data.Count
    //
    this.IntegerCoordinateSplit=function(data)
    {
        var splitItem=this.FrameSplitData.Find(data.Interval);
        if (!splitItem) return false;

        if (data.Interval==splitItem.FixInterval) return true;

        var fixMax=data.Max, fixMin=data.Min;

        var maxValue=data.Max/splitItem.FixInterval;
        var minValue=data.Min/splitItem.FixInterval;
        //调整到整数倍数,不能整除的 +1
        if (IFrameSplitOperator.IsFloat(maxValue)) fixMax=parseInt((maxValue+0.5).toFixed(0))*splitItem.FixInterval;
        if (IFrameSplitOperator.IsFloat(minValue)) fixMin=parseInt((minValue-0.5).toFixed(0))*splitItem.FixInterval;

        if (data.Min==0) fixMin=0;  //最小值是0 不用调整了.
        if (fixMin<0 && data.Min>0) fixMin=0;   //都是正数的, 最小值最小调整为0

        var count=0;
        for(var i=fixMin;(i-fixMax)<0.00000001;i+=splitItem.FixInterval)
        {
            ++count;
        }

        data.Interval=splitItem.FixInterval;
        data.Max=fixMax;
        data.Min=fixMin;
        data.Count=count;

        return true;
    }

    this.Filter = function (aryInfo,keepZero) 
    {
        if (this.SplitCount <= 0 || aryInfo.length <= 0 || aryInfo.length <= this.SplitCount) return aryInfo;

        //分割线比预设的多, 过掉一些
        var filter = parseInt(aryInfo.length / this.SplitCount);
        if (filter <= 1) filter = 2;
        var data = [];
        for (var i = 0; i < aryInfo.length; i += filter) 
        {
            if (i + filter >= aryInfo.length && i != aryInfo.length - 1) //最后一个数据放进去
            {
                data.push(aryInfo[aryInfo.length - 1]);
            }
            else 
            {
                data.push(aryInfo[i]);
            }
        }

        if (this.SplitCount == 2 && data.length>2) //之显示第1个和最后一个刻度
        {
            for(var i=1;i<data.length-1;++i)
            {
                var item=data[i];
                item.Message[0]=null;
                item.Message[1]=null;
            }
        }

        if (keepZero)   //如果不存在0轴,增加一个0轴,刻度信息部显示
        {
            var bExsitZero=false;
            for(var i=0;i<data;++i)
            {
                var item=data[i];
                if (Math.abs(item.Value) < 0.00000001) 
                {
                    bExsitZero=true;
                    break;
                }
            }

            if (bExsitZero==false)
            {
                var zeroCoordinate = new CoordinateInfo();
                zeroCoordinate.Value = 0;
                zeroCoordinate.Message[0] = null
                zeroCoordinate.Message[1] = null;
                data.push(zeroCoordinate);
            }
        }

        return data;
    }

    this.RemoveZero = function (aryInfo)   //移除小数后面多余的0
    {
        //所有的数字小数点后面都0,才会去掉
        var isAllZero = [true, true, true, true];
        for (var i in aryInfo) 
        {
            var item = aryInfo[i];
            var message = item.Message[0];
            if (!this.IsDecimalZeroEnd(message)) isAllZero[0] = false;

            var message = item.Message[1];
            if (!this.IsDecimalZeroEnd(message)) isAllZero[1] = false;

            var message = item.Message[2];
            if (!this.IsDecimalZeroEnd(message)) isAllZero[2] = false;

            var message = item.Message[3];
            if (!this.IsDecimalZeroEnd(message)) isAllZero[3] = false;
        }

        if (isAllZero[0] == false && isAllZero[1] == false && isAllZero[2]==false && isAllZero[3]==false) return;
        for (var i in aryInfo) 
        {
            var item = aryInfo[i];
            if (isAllZero[0]) 
            {
                var message = item.Message[0];
                if (message!=null)
                {
                    if (typeof (message) == 'number') message = message.toString();
                    item.Message[0] = message.replace(/[.][0]+/g, '');
                }
            }

            if (isAllZero[1])
            {
                var message = item.Message[1];
                if (message!=null)
                {
                    if (typeof (message) == 'number') message = message.toString();
                    item.Message[1] = message.replace(/[.][0]+/g, '');
                }
            }

            if (isAllZero[2])
            {
                var message = item.Message[2];
                if (message!=null)
                {
                    if (typeof (message) == 'number') message = message.toString();
                    item.Message[2] = message.replace(/[.][0]+/g, '');
                }
            }

            if (isAllZero[3])
            {
                var message = item.Message[3];
                if (message!=null)
                {
                    if (typeof (message) == 'number') message = message.toString();
                    item.Message[3] = message.replace(/[.][0]+/g, '');
                }
            }
        }
    }

    this.IsDecimalZeroEnd = function (text)   //是否是0结尾的小数
    {
        if (text==null) return true;
        if (typeof(text)=='number') text=text.toString();
        if (text=='0') return true;
        
        var pos = text.search(/[.]/);
        if (pos < 0) return false;

        for (var i = pos + 1; i < text.length; ++i) 
        {
            var char = text.charAt(i);
            if (char >= '1' && char <= '9') return false;
        }

        return true;
    }
    
}

//字符串格式化 千分位分割
IFrameSplitOperator.FormatValueThousandsString=function(value,floatPrecision)
{
    if (value==null || isNaN(value))
    {
        if (floatPrecision>0)
        {
            var nullText='-.';
            for(var i=0;i<floatPrecision;++i)
                nullText+='-';
            return nullText;
        }

        return '--';
    }

    var result='';
    var num=value.toFixed(floatPrecision);
    if(floatPrecision>0){
        var numFloat = num.split('.')[1];
        var numM = num.split('.')[0];
        while (numM.length > 3)
        {
            result = ',' + numM.slice(-3) + result;
            numM = numM.slice(0, numM.length - 3);
        }
        if (numM) { result = numM + result + '.' + numFloat; }
    }else{
        while (num.length > 3)
        {
            result = ',' + num.slice(-3) + result;
            num = num.slice(0, num.length - 3);
        }
        if (num) { result = num + result; }
    }
    
    return result;
}

//数据输出格式化 floatPrecision=小数位数
IFrameSplitOperator.FormatValueString=function(value, floatPrecision,languageID)
{
    if (value==null || isNaN(value))
    {
        if (floatPrecision>0)
        {
            var nullText='-.';
            for(var i=0;i<floatPrecision;++i)
                nullText+='-';
            return nullText;
        }

        return '--';
    }

    if (value<0.00000000001 && value>-0.00000000001)
    {
        return "0";
    }

    var absValue = Math.abs(value);
    if (languageID===JSCHART_LANGUAGE_ID.LANGUAGE_ENGLISH_ID)
    {
        if (absValue < 10000)
            return value.toFixed(floatPrecision);
        else if (absValue < 1000000)
            return (value/1000).toFixed(floatPrecision)+"K";
        else if (absValue < 1000000000)
            return (value/1000000).toFixed(floatPrecision)+"M";
        else if (absValue < 1000000000000)
            return (value/1000000000).toFixed(floatPrecision)+"B";
        else 
            return (value/1000000000000).toFixed(floatPrecision)+"T";
    }
    else
    {
        if (absValue < 10000)
            return value.toFixed(floatPrecision);
        else if (absValue < 100000000)
            return (value/10000).toFixed(floatPrecision)+"万";
        else if (absValue < 1000000000000)
            return (value/100000000).toFixed(floatPrecision)+"亿";
        else
            return (value/1000000000000).toFixed(floatPrecision)+"万亿";
    }

    return '';
}

//整形输出格式化 floatPrecision=小数位数
IFrameSplitOperator.FromatIntegerString=function(value, floatPrecision,languageID)
{
    if (value<10000 && IFrameSplitOperator.IsInteger(value)) floatPrecision=0;  //<10000的整形 去掉小数位数
    return IFrameSplitOperator.FormatValueString(value, floatPrecision,languageID);
}

IFrameSplitOperator.NumberToString=function(value)
{
    if (value<10) return '0'+value.toString();
    return value.toString();
}

IFrameSplitOperator.FormatDateString=function(value,format, languageID)
{
    var year=parseInt(value/10000);
    var month=parseInt(value/100)%100;
    var day=value%100;

    switch(format)
    {
        case 'MM-DD':
            return IFrameSplitOperator.NumberToString(month) + '-' + IFrameSplitOperator.NumberToString(day);
        case "YYYY/MM/DD":
            return year.toString() + '/' + IFrameSplitOperator.NumberToString(month) + '/' + IFrameSplitOperator.NumberToString(day);
        case "YYYY/MM/DD/W":
            {
                var date=new Date(year,month-1,day);
                var week=g_JSChartLocalization.GetText(WEEK_NAME[date.getDay()],languageID);
                return year.toString() + '/' + IFrameSplitOperator.NumberToString(month) + '/' + IFrameSplitOperator.NumberToString(day)+"/"+ week.toString();
            }
        default:
            return year.toString() + '-' + IFrameSplitOperator.NumberToString(month) + '-' + IFrameSplitOperator.NumberToString(day);
    }
}

IFrameSplitOperator.FormatTimeString=function(value, format)    //format hh:mm:ss
{
    if (format=='HH:MM:SS')
    {
        var hour=parseInt(value/10000);
        var minute=parseInt((value%10000)/100);
        var second=value%100;
        return IFrameSplitOperator.NumberToString(hour)+':'+ IFrameSplitOperator.NumberToString(minute) + ':' + IFrameSplitOperator.NumberToString(second);
    }
    else if (format=='HH:MM')
    {
        var hour=parseInt(value/100);
        var minute=value%100;
        return IFrameSplitOperator.NumberToString(hour)+':'+ IFrameSplitOperator.NumberToString(minute);
    }
    else
    {
        if (value<10000)
        {
            var hour=parseInt(value/100);
            var minute=value%100;
            return IFrameSplitOperator.NumberToString(hour)+':'+ IFrameSplitOperator.NumberToString(minute);
        }
        else
        {
            var hour=parseInt(value/10000);
            var minute=parseInt((value%10000)/100);
            var second=value%100;
            return IFrameSplitOperator.NumberToString(hour)+':'+ IFrameSplitOperator.NumberToString(minute) + ':' + IFrameSplitOperator.NumberToString(second);
        }
    }
}

//报告格式化
IFrameSplitOperator.FormatReportDateString=function(value)
{
    var year=parseInt(value/10000);
    var month=parseInt(value/100)%100;
    var monthText;
    switch(month)
    {
        case 3:
            monthText="一季度报";
            break;
        case 6:
            monthText="半年报";
            break;
        case 9:
            monthText="三季度报";
            break;
        case 12:
            monthText="年报";
            break;
    }

    return year.toString()+ monthText;
}

IFrameSplitOperator.FormatDateTimeString=function(value,isShowDate,isShowTime)
{
    var aryValue=value.split(' ');
    if (aryValue.length<2) return "";
    var result="";

    if (isShowDate)
    {
        var date=parseInt(aryValue[0]);
        var year=parseInt(date/10000);
        var month=parseInt(date%10000/100);
        var day=date%100;
        var text=year.toString() +'-'+ (month<10? ('0'+month.toString()) :month.toString()) +'-'+ (day<10? ('0'+day.toString()):day.toString());
        result+=text;
    }

    if (isShowTime)
    {
        var time=parseInt(aryValue[1]);
        var minute=time%100;
        var hour=parseInt(time/100);
        var text=(hour<10? ('0'+hour.toString()):hour.toString()) + ':' + (minute<10?('0'+minute.toString()):minute.toString());
        if (result.length>0) result+=" ";
        result+=text;
    }
    
    return result;
}

//字段颜色格式化
IFrameSplitOperator.FormatValueColor = function (value, value2) 
{
    if (value != null && value2 == null)  //只传一个值的 就判断value正负
    {
        if (value == 0) return 'PriceNull';
        else if (value > 0) return 'PriceUp';
        else return 'PriceDown';
    }

    //2个数值对比 返回颜色
    if (value == null || value2 == null) return 'PriceNull';
    if (value == value2) return 'PriceNull';
    else if (value > value2) return 'PriceUp';
    else return 'PriceDown';
}

IFrameSplitOperator.IsNumber=function(value)
{
    if (value==null) return false;
    if (isNaN(value)) return false;

    return true;
}

//判断是否是正数
IFrameSplitOperator.IsPlusNumber=function(value)
{
    if (value==null) return false;
    if (isNaN(value)) return false;

    return value>0;
}

//是否是整形
IFrameSplitOperator.IsInteger=function(x) 
{
    return (typeof x === 'number') && (x % 1 === 0);
}

//判断字段是否存在
IFrameSplitOperator.IsObjectExist=function(obj)
{
    if (obj===undefined) return false;
    if (obj==null) return false;
    
    return true;
}

//是否时bool
IFrameSplitOperator.IsBool=function(value)
{
    if (value===true || value===false) return true;
    return false;
}

IFrameSplitOperator.IsString=function(value)
{
    if (value && typeof(value)=='string') return true;
    return false;
}

//是否是非空的数组
IFrameSplitOperator.IsNonEmptyArray=function(ary)
{
    if (!ary) return;
    if (!Array.isArray(ary)) return;

    return ary.length>0;
}

IFrameSplitOperator.IsFloat=function(value)
{
    if (value===undefined) return false;
    if (value==null) return false;
    if (isNaN(value)) return false;

    return value!=parseInt(value);
}

IFrameSplitOperator.RemoveZero=function(strValue)
{
    while(strValue.length>0)
    {
        var index=strValue.length-1;
        var ch=strValue[index];
        if (ch=="0")
        {
            strValue=strValue.substr(0,index);
        }
        else if (ch==".")
        {
            strValue=strValue.substr(0,index);
            break;
        }
        else
        {
            break;
        }
    }

    return strValue;
}

function FrameSplitKLinePriceY()
{
    this.newMethod=IFrameSplitOperator;   //派生
    this.newMethod();
    delete this.newMethod;
    this.CoordinateType=0;  //坐标类型 0=普通坐标  1=百分比坐标 (右边坐标刻度) 2=对数对标 3=等比坐标 4=等分坐标 5=黄金分割
    this.Symbol;
    this.Data;              //K线数据 (计算百分比坐标)
    this.FrameSplitData2;                //坐标轴分割方法(计算百分比刻度)
    this.FloatPrecision=null;   //小数位数 (设置了就使用这个位数,否则使用品种对应的小数位数)

    this.Period;            //周期
    this.KLineChart;
    this.Custom=[]; //[{Type:0}];   定制刻度 0=显示最后的价格刻度
    this.SplitType=0;       //0=自动分割  1=固定分割 2=分笔图价格分割

    this.DefaultYMaxMin;    //{ Max:null, Min:null };    //指定最大,最小, Y轴范围必须比最大值大， 比最小值小
    this.FixedYMaxMin;      //{ Max, Min} 固定Y轴最大最小值
    this.LastMaxMin;        //当前显示的最高最低范围

    this.PercentageTextFormat=0;    //0=显示第1行  1=显示2行 2=单行格式: 价格/百分比

    this.IsEnableDragY=function()
    {
        return this.CoordinateType==0 || this.CoordinateType==1;
    }

    this.Operator=function()
    {
        var splitData={};
        splitData.Max=this.Frame.HorizontalMax;
        splitData.Min=this.Frame.HorizontalMin;
        splitData.Count=this.SplitCount;

        if (splitData.Max==splitData.Min)   //如果一样上下扩大下
		{
			splitData.Max+=splitData.Max*0.01;
			splitData.Min-=splitData.Min*0.01
		}

        var isFixedMaxMin=(this.FixedYMaxMin && IFrameSplitOperator.IsNumber(this.FixedYMaxMin.Max) && IFrameSplitOperator.IsNumber(this.FixedYMaxMin.Min));
        if (isFixedMaxMin)
        {
            splitData.Max=this.FixedYMaxMin.Max;
            splitData.Min=this.FixedYMaxMin.Min;
        }
        else if (this.DefaultYMaxMin)    //指定最小的Y轴范围
        {
            var range=this.DefaultYMaxMin;
            if (IFrameSplitOperator.IsNumber(range.Max))
            {
                if (splitData.Min>range.Max) splitData.Min=range.Max;
                else if (splitData.Max<range.Max) splitData.Max=range.Max;
            }

            if (IFrameSplitOperator.IsNumber(range.Min))
            {
                if (splitData.Max<range.Min) splitData.Max=range.Min;
                else if (splitData.Min>range.Min) splitData.Min=range.Min;
            }
        }

        splitData.Interval=(splitData.Max-splitData.Min)/(splitData.Count-1);
        var pixelTatio = GetDevicePixelRatio();             //获取设备的分辨率
        var width=this.Frame.ChartBorder.GetChartWidth();   //画布的宽度
        var isPhoneModel=width<450*pixelTatio;
        var defaultfloatPrecision=GetfloatPrecision(this.Symbol);
        if (isPhoneModel && MARKET_SUFFIX_NAME.IsSHSZIndex(this.Symbol)) defaultfloatPrecision = 0;    //手机端指数不显示小数位数,太长了
        if (this.FloatPrecision!=null) defaultfloatPrecision=this.FloatPrecision;
        JSConsole.Chart.Log(`[FrameSplitKLinePriceY::Operator] Max=${splitData.Max} Min=${splitData.Min} Count=${splitData.Count} isPhoneModel=${isPhoneModel} defaultfloatPrecision=${defaultfloatPrecision} `);

        this.Frame.Logarithmic=null;
        this.Frame.MultiTextFormat=0;
        var bFilter=true;   //是否需要通过高度过滤刻度
        splitData.IsFixedMaxMin=isFixedMaxMin;
        splitData.IsFilter=bFilter;
        if (ChartData.IsTickPeriod(this.Period))
        {
            this.SplitTickData(splitData,defaultfloatPrecision);
            bFilter=splitData.IsFilter;
        }
        else if (FrameSplitKLinePriceY.SplitCustom)
        {
            FrameSplitKLinePriceY.SplitCustom(this,splitData,defaultfloatPrecision);    //自定义分割
            bFilter=false;
        }
        else
        {
            switch(this.CoordinateType)
            {
                case 1:
                    if (!this.SplitPercentage(splitData,defaultfloatPrecision,isFixedMaxMin))
                    {
                        this.SplitDefault(splitData,defaultfloatPrecision,isFixedMaxMin);
                    }
                    else
                    {
                        this.Frame.MultiTextFormat=this.PercentageTextFormat;
                        bFilter=false;
                    }
                    break;
                case 3: //等比坐标 +10%/-10% 涨幅分割
                    if (!this.SplitIncrease(splitData,defaultfloatPrecision))
                        this.SplitDefault(splitData,defaultfloatPrecision);
                    else
                        bFilter=false;
                    break;
                case 4: //等分坐标
                    this.SplitAverage(splitData,defaultfloatPrecision);
                    bFilter=false;
                    break;
                case 5: //黄金分割
                    this.SplitGoldenSection(splitData,defaultfloatPrecision);
                    bFilter=false;
                    break;
                case 2: //对数坐标
                    if (this.SplitLogarithmic(splitData,defaultfloatPrecision))
                    {
                        bFilter=false;
                    }
                    else
                    {
                        this.SplitDefault(splitData,defaultfloatPrecision);
                    }
                    break;
                default:
                    if (this.SplitType==1) 
                    {
                        this.SplitFixed(splitData,defaultfloatPrecision);
                        bFilter=false;
                    }
                    else 
                    {
                        this.SplitDefault(splitData,defaultfloatPrecision,isFixedMaxMin);
                    }
                    break;
            }
        }

        this.CustomCoordinate(defaultfloatPrecision);
        if (bFilter) this.Frame.HorizontalInfo = this.Filter(this.Frame.HorizontalInfo,false);
        this.Frame.HorizontalMax=splitData.Max;
        this.Frame.HorizontalMin=splitData.Min;

        JSConsole.Chart.Log(`[FrameSplitKLinePriceY::Operator] fixed . Max=${splitData.Max} Min=${splitData.Min} Count=${splitData.Count}`);

        if (this.GetEventCallback)
        {
            var event=this.GetEventCallback(JSCHART_EVENT_ID.ON_SPLIT_YCOORDINATE);
            if (event && event.Callback)
            {
                var data={ID:this.Frame.Identify, Frame:this.Frame };
                event.Callback(event,data,this);
            }
        }
    }

    this.SplitTickData=function(splitData,floatPrecision)
    {
        switch(this.CoordinateType)
        {
            case 1: //百分比
                if (!this.SplitPercentage(splitData,floatPrecision,splitData.IsFixedMaxMin))
                {
                    this.SplitDefault(splitData,floatPrecision,splitData.IsFixedMaxMin);
                }
                else
                {
                    this.Frame.MultiTextFormat=this.PercentageTextFormat;
                    splitData.IsFilter=false;
                }
                break;
            default:
                if (this.SplitType==3) 
                {
                    this.SplitTickPrice(splitData,floatPrecision);
                }
                else 
                {
                    this.SplitDefault(splitData, floatPrecision, splitData.IsFixedMaxMin);
                }
        }
    }

    this.SplitTickPrice=function(splitData,floatPrecision)
    {
        var aryPrice=this.KLineChart.GetAllPrice();

        this.Frame.HorizontalInfo=[];
        for(var i in aryPrice)
        {
            var value=aryPrice[i];
            this.Frame.HorizontalInfo[i]= new CoordinateInfo();
            this.Frame.HorizontalInfo[i].Value=value;
            if (this.IsShowLeftText) this.Frame.HorizontalInfo[i].Message[0]=value.toFixed(floatPrecision);
            if (this.IsShowRightText) this.Frame.HorizontalInfo[i].Message[1]=value.toFixed(floatPrecision);
        }
    }

    this.SplitPercentage=function(splitData,floatPrecision,isFixedMaxMin)    //百分比坐标
    {
        var firstOpenPrice=this.GetFirstOpenPrice();
        if (!IFrameSplitOperator.IsNumber(firstOpenPrice)) return false;

        splitData.Max=(splitData.Max-firstOpenPrice)/firstOpenPrice;
        splitData.Min=(splitData.Min-firstOpenPrice)/firstOpenPrice;
        splitData.Interval=(splitData.Max-splitData.Min)/(splitData.Count-1);
        if (!isFixedMaxMin) this.IntegerCoordinateSplit2(splitData);

        var textColor;
        if (g_JSChartResource.Frame && g_JSChartResource.Frame.PercentageText)
        {
            var item=g_JSChartResource.Frame.PercentageText;
            textColor={PriceColor:item.PriceColor, PercentageColor:item.PercentageColor, SplitColor:item.SplitColor, Font:item.Font };
        }   

        var aryHorizontal=[];
        for(var value=0;value<=splitData.Max; value+=splitData.Interval)
        {
            var price=(value+1)*firstOpenPrice;
            var item=new CoordinateInfo();
            item.Value=price;
            if (this.IsShowLeftText) item.Message[0]=price.toFixed(floatPrecision);     //左边价格坐标  
            
            if (this.IsShowRightText) 
            {
                var strPrice=price.toFixed(floatPrecision);
                var text=(value*100).toFixed(2);    //右边百分比
                text=IFrameSplitOperator.RemoveZero(text);
                text+='%';
                item.Message[1]=[text,strPrice];
                item.ExtendData=textColor;
            }
            aryHorizontal.push(item);
        }

        for(var value=-splitData.Interval;value>=splitData.Min;value-=splitData.Interval)
        {
            var price=(value+1)*firstOpenPrice;
            var item=new CoordinateInfo();
            item.Value=price;
            if (this.IsShowLeftText) item.Message[0]=price.toFixed(floatPrecision);   //左边价格坐标      
            if (this.IsShowRightText) 
            {
                var strPrice=price.toFixed(floatPrecision);
                var text=(value*100).toFixed(2);    //右边百分比
                text=IFrameSplitOperator.RemoveZero(text);
                text+='%';
                item.Message[1]=[text,strPrice];  
                item.ExtendData=textColor;
            }
            aryHorizontal.push(item);
        }

        aryHorizontal.sort((left, right)=> 
        {
            return left.Value - right.Value;
        });

        this.Frame.HorizontalInfo=aryHorizontal;

        splitData.Min=(1+splitData.Min)*firstOpenPrice; //最大最小值调整
        splitData.Max=(1+splitData.Max)*firstOpenPrice;
        return true;
    }

    //等比坐标 当前屏最后第2根K线的收盘加为基准, 上下涨幅10%分割
    this.SplitIncrease=function(splitData,floatPrecision)    
    {
        var basePrice=this.GetLast2ndClose();
        if (!IFrameSplitOperator.IsNumber(basePrice)) return false;
        this.IntegerCoordinateSplit(splitData);
        this.Frame.HorizontalInfo=[];

        var increase=g_JSChartResource.FrameSplitIncrease.Increase;
        var aryHorizontal=[];
        for(var price=basePrice; price<splitData.Max; price=price*(1+increase))
        {
            var item= new CoordinateInfo();
            item.Value=price;
            var text=price.toFixed(floatPrecision);
            if (this.IsShowLeftText) item.Message[0]=text;  
            if (this.IsShowRightText) item.Message[1]=text;
            aryHorizontal.push(item);
        }

        for(var price=basePrice*0.9;price>splitData.Min; price=price*(1-increase))
        {
            var item= new CoordinateInfo();
            item.Value=price;
            var text=price.toFixed(floatPrecision);
            if (this.IsShowLeftText) item.Message[0]=text;  
            if (this.IsShowRightText) item.Message[1]=text;
            aryHorizontal.push(item);
        }

        this.Frame.HorizontalInfo=aryHorizontal;
        return true;
    }

    //等分坐标：以画面显示的最高价、最低价为基准，对这个区域N等分，显示分割的数值线
    this.SplitAverage=function(splitData,floatPrecision)
    {
        var max=splitData.Max;
        var min=splitData.Min;
        //this.IntegerCoordinateSplit(splitData);
        this.Frame.HorizontalInfo=[];
        var count=g_JSChartResource.FrameSplitAverage.Count;
        var interval=(max-min)/count;

        for(var i=0;i<=count;++i)
        {
            var item=new CoordinateInfo();
            item.Value=min+interval*i;
            var text=item.Value.toFixed(floatPrecision);
            if (this.IsShowLeftText)  item.Message[0]=text;
            if (this.IsShowRightText)   item.Message[1]=text;

            this.Frame.HorizontalInfo[i]=item;
        }
    }

    this.SplitGoldenSection=function(splitData,floatPrecision)
    {
        var max=splitData.Max;
        var min=splitData.Min;
        //this.IntegerCoordinateSplit(splitData);
        this.Frame.HorizontalInfo=[];

        var aryHorizontal=[];
        var GOLDEN_ARRAY=g_JSChartResource.FrameGoldenSection.Golden;
        for(var i in GOLDEN_ARRAY)
        {
            var value=(max-min)*GOLDEN_ARRAY[i]+min;
            item=new CoordinateInfo();
            item.Value=value;
            var text=value.toFixed(floatPrecision);
            if (this.IsShowLeftText)  item.Message[0]=text;
            if (this.IsShowRightText)   item.Message[1]=text;
            aryHorizontal.push(item);
        }

        this.Frame.HorizontalInfo=aryHorizontal;
    }

    this.SplitLogarithmic=function(splitData,floatPrecision) //对数坐标
    {
        var minInterval=g_JSChartResource.FrameLogarithmic.MinInterval;       //最小间距
        var firstOpenPrice=this.GetFirstOpenPrice();    //获取当前屏第1个K线的开盘价
        if (!IFrameSplitOperator.IsNumber(firstOpenPrice)) return false;
        var height=this.ChartBorder.GetHeightEx();

        var ARRAY_INCREASE=[0.01, 0.02, 0.04, 0.08, 0.1, 0.2];
        var increase=ARRAY_INCREASE[ARRAY_INCREASE.length-1];
        for(var i=0; i<ARRAY_INCREASE.length;++i)
        {
            var value=ARRAY_INCREASE[i];
            var interval=(firstOpenPrice*value)*(height/(splitData.Max-splitData.Min));
            if (interval>minInterval)
            {
                increase=value;
                break;
            }
        }

        var aryUp=[];
        var price=firstOpenPrice;
        var i=increase;
        do
        {
            var item={ Start:price };
            price=firstOpenPrice*(1+i);
            item.End=price;
            aryUp.push(item);

            i+=increase;
        } while(price<splitData.Max);
        var max=price;

        var aryDown=[];
        var price=firstOpenPrice;
        var i=increase;
        do
        {
            var item={ End:price };
            price=firstOpenPrice*(1-i);
            item.Start=price;
            aryDown.push(item);

            i+=increase;
        } while(price>splitData.Min);
        var min=price;

        splitData.Max=max;
        splitData.Min=min;
        
        JSConsole.Chart.Log("[FrameSplitKLinePriceY::SplitLogarithmic] up, down", aryUp, aryDown);

        this.Frame.HorizontalInfo=[];
        var item=new CoordinateInfo();
        item.Value=firstOpenPrice;
        item.Font=g_JSChartResource.FrameLogarithmic.OpenPriceFont;
        var strText=item.Value.toFixed(floatPrecision);
        if (this.IsShowLeftText) item.Message[0]=strText;     //左边价格坐标      
        if (this.IsShowRightText) item.Message[1]=strText;    //右边价格坐标 
        this.Frame.HorizontalInfo.push(item);

        for(var i in aryUp)
        {
            var item=new CoordinateInfo();
            item.Value=aryUp[i].End;
            var strText=item.Value.toFixed(floatPrecision);
            if (this.IsShowLeftText) item.Message[0]=strText;     //左边价格坐标      
            if (this.IsShowRightText) item.Message[1]=strText;    //右边价格坐标 
            this.Frame.HorizontalInfo.push(item);
        }

        for(var i in aryDown)
        {
            var item=new CoordinateInfo();
            item.Value=aryDown[i].End;
            var strText=item.Value.toFixed(floatPrecision);
            if (this.IsShowLeftText) item.Message[0]=strText;     //左边价格坐标      
            if (this.IsShowRightText) item.Message[1]=strText;    //右边价格坐标 
            this.Frame.HorizontalInfo.splice(0,0,item);
        }

        this.Frame.Logarithmic={ Up:aryUp, Down:aryDown, OpenPrice:firstOpenPrice };
        return true;
    }

    this.SplitDefault=function(splitData,floatPrecision,isFixedMaxMin)       //默认坐标
    {
        //固定最大最小值 不自动调整范围
        if (!isFixedMaxMin) this.IntegerCoordinateSplit(splitData);
       
        this.Frame.HorizontalInfo=[];
        for(var i=0,value=splitData.Min;i<splitData.Count;++i,value+=splitData.Interval)
        {
            this.Frame.HorizontalInfo[i]= new CoordinateInfo();
            this.Frame.HorizontalInfo[i].Value=value;
            if (this.IsShowLeftText)  this.Frame.HorizontalInfo[i].Message[0]=value.toFixed(floatPrecision);
            if (this.IsShowRightText)   this.Frame.HorizontalInfo[i].Message[1]=value.toFixed(floatPrecision);
        }
    }

    this.SplitFixed=function(splitData,floatPrecision)      //固定分割坐标
    {
        this.Frame.HorizontalInfo=[];
        for(var i=0,value=splitData.Min;i<splitData.Count;++i,value+=splitData.Interval)
        {
            this.Frame.HorizontalInfo[i]= new CoordinateInfo();
            this.Frame.HorizontalInfo[i].Value=value;
            if (this.IsShowLeftText)  this.Frame.HorizontalInfo[i].Message[0]=value.toFixed(floatPrecision);
            if (this.IsShowRightText)   this.Frame.HorizontalInfo[i].Message[1]=value.toFixed(floatPrecision);
        }
    }

    this.CustomCoordinate=function(floatPrecision)
    {
        this.Frame.CustomHorizontalInfo=[];
        for(var i in this.Custom)
        {
            var item=this.Custom[i];
            if (item.Type==0)
            {
                var dec=floatPrecision;
                //外部设置小数位数
                if (IFrameSplitOperator.IsNumber(item.FloatPrecision) && item.FloatPrecision>=0) dec=item.FloatPrecision;
                var latestItem=this.GetLatestPrice(dec,item);
                if (latestItem) this.Frame.CustomHorizontalInfo.push(latestItem);
            }
            else if (item.Type==1)
            {
                this.CustomFixedCoordinate(item);
            }
        }
    }

    this.GetLatestPrice=function(floatPrecision,option)
    {
        if (!this.Data || !this.Data.Data) return null;
        if (this.Data.Data.length<=0) return null;
        var latestItem=this.Data.Data[this.Data.Data.length-1];
        var info=new CoordinateInfo();
        info.Type=0;
        info.Value=latestItem.Close;
        info.TextColor=g_JSChartResource.FrameLatestPrice.TextColor;
        info.LineType=2;    //虚线
        if (option.Position=='left') info.Message[0]=latestItem.Close.toFixed(floatPrecision);
        else info.Message[1]=latestItem.Close.toFixed(floatPrecision);
        if (latestItem.Close>latestItem.Open) info.LineColor=g_JSChartResource.FrameLatestPrice.UpBarColor;
        else if (latestItem.Close<latestItem.Open) info.LineColor=g_JSChartResource.FrameLatestPrice.DownBarColor;
        else info.LineColor=g_JSChartResource.FrameLatestPrice.UnchagneBarColor;

        if (IFrameSplitOperator.IsNumber(option.LineType)) info.LineType=option.LineType;
        if (option.IsShowLine==false) info.LineType=-1;

        return info;
    }

    this.GetFirstOpenPrice=function()   //获取显示第1个数据的开盘价
    {
        if (!this.Data) return null;

        var xPointCount=this.Frame.XPointCount;
        for(var i=this.Data.DataOffset,j=0;i<this.Data.Data.length && j<xPointCount;++i,++j)
        {
            var data=this.Data.Data[i];
            if (data.Open==null || data.High==null || data.Low==null || data.Close==null) continue;

            if (ChartData.IsTickPeriod(this.Period)) 
                return data.YClose;
            else
                return data.Open;
        }

        return null;
    }

    this.GetLast2ndClose=function() //获取最后第2根K线收盘加
    {
        if (!this.Data) return null;
        if (this.Data.Data.length<=0) return null;

        var xPointCount=this.Frame.XPointCount;
        var endIndex=this.Data.DataOffset+xPointCount-1;
        if (endIndex>=this.Data.Data.length) endIndex=this.Data.Data.length-1;
        var price=null;
        for(var i=endIndex, count=0; i>=0 && i<this.Data.Data.length; --i)
        {
            var data=this.Data.Data[i];
            if (data.Open==null || data.High==null || data.Low==null || data.Close==null) continue;

            if (count==0) price=data.Open;
            else if (count==1) price=data.Close;

            ++count;
            if (count>=2) break;
        }

        return price;
    }

    this.CustomFixedCoordinate=function(option)    //固定坐标刻度
    {
        var defaultfloatPrecision=GetfloatPrecision(this.Symbol);
        for(var i in option.Data)
        {
            var item=option.Data[i];
            var info=new CoordinateInfo();
            info.Type=1;
            info.TextColor=item.TextColor;
            info.LineColor=item.Color;
            info.LineType=2;    //虚线
            if (IFrameSplitOperator.IsNumber(option.LineType)) info.LineType=option.LineType;
            if (option.IsShowLine==false) info.LineType=-1;

            info.Value=item.Value;
            var text;
            if (item.Text) text=item.Text;
            else text=info.Value.toFixed(defaultfloatPrecision);
            if (option.Position=='left') info.Message[0]=text;
            else info.Message[1]=text;

            this.Frame.CustomHorizontalInfo.push(info);
        }
    }

    //////////////////////
    // data.Min data.Max data.Interval data.Count
    //
    this.IntegerCoordinateSplit2=function(data)
    {
        var splitItem=this.FrameSplitData2.Find(data.Interval);
        if (!splitItem) return false;

        if (data.Interval==splitItem.FixInterval) return true;

        //调整到整数倍数,不能整除的 +1
        var fixMax=parseInt((data.Max/(splitItem.FixInterval)+0.5).toFixed(0))*splitItem.FixInterval;
        var fixMin=parseInt((data.Min/(splitItem.FixInterval)-0.5).toFixed(0))*splitItem.FixInterval;
        if (data.Min==0) fixMin=0;  //最小值是0 不用调整了.
        if (fixMin<0 && data.Min>0) fixMin=0;   //都是正数的, 最小值最小调整为0

        var count=0;
        for(var i=fixMin;(i-fixMax)<0.00000001;i+=splitItem.FixInterval)
        {
            ++count;
        }

        data.Interval=splitItem.FixInterval;
        data.Max=fixMax;
        data.Min=fixMin;
        data.Count=count;

        return true;
    }
}

function FrameSplitY()
{
    this.newMethod=IFrameSplitOperator;   //派生
    this.newMethod();
    delete this.newMethod;

    this.SplitCount=3;                        //刻度个数
    this.FloatPrecision = 2;                  //坐标小数位数(默认2)
    this.FLOATPRECISION_RANGE=[1,0.1,0.01,0.001,0.0001];
    this.SplitType=0;       //0=自动分割  1=固定分割
    this.Custom=[];         //[{Type:0}]; 定制刻度
    this.DefaultYMaxMin;    //{ Max:null, Min:null };    //指定最大,最小, Y轴范围必须比最大值大， 比最小值小
    this.EnableRemoveZero=true;
    this.LineType=null;     //线段样式
    this.IgnoreYValue = null;                 //在这个数组里的数字不显示在刻度上 
    this.FixedYMaxMin;      //{ Max, Min} 固定Y轴最大最小值

    this.IsBeforeData=false;
    this.BeforeOpenData;

    this.IsAfterData=false;
    this.AfterCloseData;

    this.MultiDayBeforeOpenData;
    this.MultiDayAfterCloseData;

    this.IsEnableDragY=function()
    {
        return true;
    }

    this.GetFloatPrecision=function(value,floatPrecision)
    {
        if (value>this.FLOATPRECISION_RANGE[0]) return floatPrecision;
        if (floatPrecision<0) return 2;
        for(;floatPrecision<this.FLOATPRECISION_RANGE.length;++floatPrecision)
        {
            if (value>this.FLOATPRECISION_RANGE[floatPrecision]) break;
        }

        return floatPrecision;
    }

    this.Operator=function()
    {
        var splitData={};
        splitData.Max=this.Frame.HorizontalMax;
        splitData.Min=this.Frame.HorizontalMin;
        
        var isFixedMaxMin=(this.FixedYMaxMin && IFrameSplitOperator.IsNumber(this.FixedYMaxMin.Max) && IFrameSplitOperator.IsNumber(this.FixedYMaxMin.Min));
        if (isFixedMaxMin)
        {
            splitData.Max=this.FixedYMaxMin.Max;
            splitData.Min=this.FixedYMaxMin.Min;
        }
        else if (this.DefaultYMaxMin)    //指定最小的Y轴范围
        {
            var range=this.DefaultYMaxMin;
            if (IFrameSplitOperator.IsNumber(range.Max))
            {
                if (splitData.Min>range.Max) splitData.Min=range.Max;
                else if (splitData.Max<range.Max) splitData.Max=range.Max;
            }

            if (IFrameSplitOperator.IsNumber(range.Min))
            {
                if (splitData.Max<range.Min) splitData.Max=range.Min;
                else if (splitData.Min>range.Min) splitData.Min=range.Min;
            }
        }

        if(this.Frame.YSpecificMaxMin)
        {
            splitData.Count=this.Frame.YSpecificMaxMin.Count;
            splitData.Interval=(splitData.Max-splitData.Min)/(splitData.Count-1);
        }
        else if (this.SplitType==1 || isFixedMaxMin)
        {
            splitData.Count=this.SplitCount;
            splitData.Interval=(splitData.Max-splitData.Min)/(splitData.Count-1);
        }
        else
        {
            splitData.Count=this.SplitCount;
            splitData.Interval=(splitData.Max-splitData.Min)/(splitData.Count-1);
            this.IntegerCoordinateSplit(splitData);
        }

        this.Frame.HorizontalInfo=[];

        if (this.Frame.YSplitScale) //固定坐标
        {
            for(var i in this.Frame.YSplitScale)
            {
                var value=this.Frame.YSplitScale[i];
                var coordinate=new CoordinateInfo();
                coordinate.Value=value;
                if (IFrameSplitOperator.IsNumber(this.LineType)) coordinate.LineType=this.LineType;

                var absValue=Math.abs(value);
                if (absValue<0.0000000001) 
                {
                    coordinate.Message[1]=0;
                }
                else if (absValue<this.FLOATPRECISION_RANGE[this.FLOATPRECISION_RANGE.length-1]) 
                {
                    coordinate.Message[1] = value.toExponential(2).toString();
                }
                else
                {
                    var floatPrecision=this.GetFloatPrecision(absValue,this.FloatPrecision); //数据比小数位数还小, 调整小数位数
                    coordinate.Message[1] = IFrameSplitOperator.FormatValueString(value, floatPrecision,this.LanguageID);
                }

                coordinate.Message[0]=coordinate.Message[1];

                if (this.IsShowLeftText==false) this.Frame.HorizontalInfo[i].Message[0]=null;
                if (this.IsShowRightText==false) this.Frame.HorizontalInfo[i].Message[1]=null;

                this.Frame.HorizontalInfo.push(coordinate);
            }
        }
        else
        {
            for(var i=0,value=splitData.Min;i<splitData.Count;++i,value+=splitData.Interval)
            {
                var coordinate=new CoordinateInfo();
                this.Frame.HorizontalInfo[i]= coordinate;
                coordinate.Value=value;
                if (IFrameSplitOperator.IsNumber(this.LineType)) coordinate.LineType=this.LineType;

                if (this.StringFormat==1)   //手机端格式 如果有万,亿单位了 去掉小数
                {
                    var floatPrecision=this.FloatPrecision;
                    if (!isNaN(value) && Math.abs(value) > 1000) floatPrecision=0;
                    this.Frame.HorizontalInfo[i].Message[1]=IFrameSplitOperator.FormatValueString(value,floatPrecision,this.LanguageID);
                }
                else
                {
                    var absValue=Math.abs(value);
                    if (absValue<0.0000000001) 
                    {
                        this.Frame.HorizontalInfo[i].Message[1]=0;
                    }
                    else if (absValue<this.FLOATPRECISION_RANGE[this.FLOATPRECISION_RANGE.length-1]) 
                    {
                        this.Frame.HorizontalInfo[i].Message[1] = value.toExponential(2).toString();
                    }
                    else
                    {
                        var floatPrecision=this.GetFloatPrecision(absValue,this.FloatPrecision); //数据比小数位数还小, 调整小数位数
                        this.Frame.HorizontalInfo[i].Message[1] = IFrameSplitOperator.FormatValueString(value, floatPrecision,this.LanguageID);
                    }
                }
                
                this.Frame.HorizontalInfo[i].Message[0]=this.Frame.HorizontalInfo[i].Message[1];
                if (this.IsShowLeftText==false) this.Frame.HorizontalInfo[i].Message[0]=null;
                if (this.IsShowRightText==false) this.Frame.HorizontalInfo[i].Message[1]=null;
                //this.Frame.HorizontalInfo[i].Font="14px 微软雅黑";
                //this.Frame.HorizontalInfo[i].TextColor="rgb(100,0,200)";
                //this.Frame.HorizontalInfo[i].LineColor="rgb(220,220,220)";
            }
        }

        this.FilterIgnoreYValue();

        this.CustomCoordinate();
        if (this.SplitType!=1) this.Frame.HorizontalInfo = this.Filter(this.Frame.HorizontalInfo,(splitData.Max>0 && splitData.Min<0));
        if (this.EnableRemoveZero) this.RemoveZero(this.Frame.HorizontalInfo);
        this.Frame.HorizontalMax=splitData.Max;
        this.Frame.HorizontalMin=splitData.Min;

        this.RightFrameSplitY();
        this.CallAcutionSplitY(this.SplitCount,splitData);

        if (this.GetEventCallback)
        {
            var event=this.GetEventCallback(JSCHART_EVENT_ID.ON_SPLIT_YCOORDINATE);
            if (event && event.Callback)
            {
                var data={ID:this.Frame.Identify, Frame:this.Frame };
                event.Callback(event,data,this);
            }
        }
    }

    this.FilterIgnoreYValue = function () 
    {
        if (!this.IgnoreYValue || this.IgnoreYValue.length <= 0) return;

        var setValue = new Set(this.IgnoreYValue);
        this.Frame.HorizontalInfo = this.Frame.HorizontalInfo.filter(item => !setValue.has(item.Value));
    }

    this.CallAcutionSplitY=function(count,splitData)
    {
        if (this.Frame.Identify!=1) return null;
        var aryCallAcution=this.GetCallAcutionSplitY(count,splitData);
        if (!aryCallAcution) return;

        for(var i in this.Frame.HorizontalInfo) //把显示的数据迁移到 Message[2] Message[3]
        {
            var item=this.Frame.HorizontalInfo[i];
            if (aryCallAcution.IsBeforeData)
            {
                item.Message[2]=item.Message[0];    
                item.Message[0]=null;
            }

            if (aryCallAcution.IsAfterData)
            {
                item.Message[3]=item.Message[1];
                item.Message[1]=null;
            }
        }

        //集合竞价的坐标插入最后
        for(var i in aryCallAcution.HorizontalInfo)
        {
            var item=aryCallAcution.HorizontalInfo[i];
            this.Frame.HorizontalInfo.push(item);
        }
    }

    this.GetCallAcutionSplitY=function(count,splitData)
    {
        if (this.Frame.Identify!=1) return null;

        var isBeforeData=(this.IsBeforeData==true && this.BeforeOpenData && (this.BeforeOpenData.Ver==2.0 || this.BeforeOpenData.Ver==3.0));
        var isAfterData=(this.IsAfterData==true && this.AfterCloseData && (this.AfterCloseData.Ver==2.0 || this.AfterCloseData.Ver==3.0));

        if (isBeforeData || isAfterData)
        {
            var intervalY=(splitData.Max-splitData.Min)/(count-1);
            if (isBeforeData) var intervalLeft=(this.BeforeOpenData.VolMax-this.BeforeOpenData.VolMin)/(count-1);
            if (isAfterData)  var intervalRight=(this.AfterCloseData.VolMax-this.AfterCloseData.VolMin)/(count-1);

            var aryHorizontalInfo=[];
            for(var i=0;i<count;++i)
            {
                var item=new CoordinateInfo();
                var yValue=intervalY*i;
                item.Value=yValue;
                item.LineType=8;
                if (isBeforeData)
                {
                    var leftValue=intervalLeft*i;
                    item.Message[0]=leftValue.toFixed(0);
                }

                if (isAfterData)
                {
                    var rightValue=intervalRight*i;
                    item.Message[1]=rightValue.toFixed(0);
                }                
                aryHorizontalInfo.push(item);
            }
            return { HorizontalInfo:aryHorizontalInfo,  IsBeforeData:isBeforeData, IsAfterData:isAfterData };
        }

        var isMultiDayBeforeData=false;
        var intervalLeft=null;
        if (this.MultiDayBeforeOpenData && IFrameSplitOperator.IsNonEmptyArray(this.MultiDayBeforeOpenData))
        {
            isMultiDayBeforeData=true;
            var firstDayData=this.MultiDayBeforeOpenData[0];
            if (firstDayData.Ver==2.0 || firstDayData.Ver==3.0)
            {
                var intervalLeft=(firstDayData.VolMax-firstDayData.VolMin)/(count-1);
            }
        }

        var isMultiDayAfterData=false;
        var intervalRight=null;
        if (this.MultiDayAfterCloseData && IFrameSplitOperator.IsNonEmptyArray(this.MultiDayAfterCloseData))
        {
            isMultiDayAfterData=true;
            var firstDayData=this.MultiDayAfterCloseData[0];
            if (firstDayData.Ver==2.0 || firstDayData.Ver==3.0)
            {
                var intervalRight=(firstDayData.VolMax-firstDayData.VolMin)/(count-1);
            }
        }

        if (isMultiDayBeforeData || isMultiDayAfterData)
        {
            var intervalY=(splitData.Max-splitData.Min)/(count-1);
            var aryHorizontalInfo=[];
            for(var i=0;i<count;++i)
            {
                var item=new CoordinateInfo();
                var yValue=intervalY*i;
                item.Value=yValue;
                item.LineType=9;
                if (intervalLeft!=null)
                {
                    var leftValue=intervalLeft*i;
                    item.Message[0]=leftValue.toFixed(0);
                }

                if (intervalRight!=null)
                {
                    var rightValue=intervalRight*i;
                    item.Message[1]=rightValue.toFixed(0);
                }                
                aryHorizontalInfo.push(item);
            }
            return { HorizontalInfo:aryHorizontalInfo,  IsBeforeData:isMultiDayBeforeData, IsAfterData:isMultiDayAfterData };
        }

        return null;
    }

    this.RightFrameSplitY=function()
    {
        if (!this.Frame.RightFrame) return;

        var rightFrame=this.Frame.RightFrame;
        for(var i in this.Frame.HorizontalInfo)
        {
            var item=this.Frame.HorizontalInfo[i];
            var y=this.Frame.GetYFromData(item.Value);
            var yValue=rightFrame.GetYData(y);
            item.Message[1] = IFrameSplitOperator.FormatValueString(yValue, this.FloatPrecision,this.LanguageID);
        }
    }

    this.CustomCoordinate=function()
    {
        this.Frame.CustomHorizontalInfo=[];
        for(var i in this.Custom)
        {
            var item=this.Custom[i];
            if (item.Type==0)
            {
                
            }
            else if (item.Type==1)
            {
                this.CustomFixedCoordinate(item);
            }
        }
    }

    this.CustomFixedCoordinate=function(option)    //固定坐标刻度
    {
        var defaultfloatPrecision=2;
        for(var i in option.Data)
        {
            var item=option.Data[i];
            var info=new CoordinateInfo();
            info.Type