Jan 15, 2024

---

For full documentation visit [mkdocs.org](https://www.mkdocs.org).

## Commands

* `mkdocs new [dir-name]` - Create a new project.
* `mkdocs serve` - Start the live-reloading docs server.
* `mkdocs build` - Build the documentation site.
* `mkdocs -h` - Print help message and exit.

## Project layout

```bash
mkdocs.yml    # The configuration file.
docs/
    index.md  # The documentation homepage.
    ...       # Other markdown pages, images and other files.
```

### Installation MkDocs

To install MkDocs, run the following command from the command line:

```bash
pip install mkdocs
```

### Installation theme

Install the theme using PIP:

```bash
pip install mkdocs-simple-blog
```

### Activating theme

After the theme is installed, edit your `mkdocs.yml` file and set the theme name to `simple-blog`:

```yml
theme:
    name: simple-blog
```

## Getting Help

We use GitHub issues for tracking bugs and feature requests and have limited bandwidth to address them. If you need anything, I ask you to please follow our templates for opening issues or discussions.

- 🐛 [Bug Report](https://github.com/FernandoCelmer/mkdocs-simple-blog/issues/new/choose)
- 📕 [Documentation Issue](https://github.com/FernandoCelmer/mkdocs-simple-blog/issues/new/choose)
- 🚀 [Feature Request](https://github.com/FernandoCelmer/mkdocs-simple-blog/issues/new/choose)
- 💬 [General Question](https://github.com/FernandoCelmer/mkdocs-simple-blog/issues/new/choose)

## Commit Style

- ⚙️ FEATURE
- 📝 PEP8
- 📌 ISSUE
- 🪲 BUG
- 📘 DOCS
- 📦 PyPI
- ❤️️ TEST
- ⬆️ CI/CD
- ⚠️ SECURITY

## License
![GitHub](https://img.shields.io/github/license/FernandoCelmer/mkdocs-simple-blog?style=flat-square)

This project is licensed under the terms of the MIT license.
