﻿using System.Windows;
using System.Windows.Controls;
using MvvmDialogs;

namespace Demo.NonModalCustomDialog;

public class CurrentTimeCustomDialog : IWindow
{
    private readonly CurrentTimeDialog dialog;

    public CurrentTimeCustomDialog()
    {
        dialog = new CurrentTimeDialog();
    }

    object IWindow.DataContext
    {
        get => dialog.DataContext;
        set => dialog.DataContext = value;
    }

    bool? IWindow.DialogResult
    {
        get => dialog.DialogResult;
        set => dialog.DialogResult = value;
    }

    ContentControl IWindow.Owner
    {
        get => dialog.Owner;
        set => dialog.Owner = (Window)value;
    }

    bool? IWindow.ShowDialog()
    {
        return dialog.ShowDialog();
    }

    void IWindow.Show()
    {
        dialog.Show();
    }
}