/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.ml;

import org.opencv.core.Mat;
import org.opencv.core.TermCriteria;
import org.opencv.ml.StatModel;

public class SVM
extends StatModel {
    public static final int C_SVC = 100;
    public static final int NU_SVC = 101;
    public static final int ONE_CLASS = 102;
    public static final int EPS_SVR = 103;
    public static final int NU_SVR = 104;
    public static final int CUSTOM = -1;
    public static final int LINEAR = 0;
    public static final int POLY = 1;
    public static final int RBF = 2;
    public static final int SIGMOID = 3;
    public static final int CHI2 = 4;
    public static final int INTER = 5;
    public static final int C = 0;
    public static final int GAMMA = 1;
    public static final int P = 2;
    public static final int NU = 3;
    public static final int COEF = 4;
    public static final int DEGREE = 5;

    protected SVM(long l) {
        super(l);
    }

    public Mat getClassWeights() {
        Mat mat = new Mat(SVM.getClassWeights_0(this.nativeObj));
        return mat;
    }

    public Mat getSupportVectors() {
        Mat mat = new Mat(SVM.getSupportVectors_0(this.nativeObj));
        return mat;
    }

    public Mat getUncompressedSupportVectors() {
        Mat mat = new Mat(SVM.getUncompressedSupportVectors_0(this.nativeObj));
        return mat;
    }

    public static SVM create() {
        SVM sVM = new SVM(SVM.create_0());
        return sVM;
    }

    public TermCriteria getTermCriteria() {
        TermCriteria termCriteria = new TermCriteria(SVM.getTermCriteria_0(this.nativeObj));
        return termCriteria;
    }

    public double getC() {
        double d = SVM.getC_0(this.nativeObj);
        return d;
    }

    public double getCoef0() {
        double d = SVM.getCoef0_0(this.nativeObj);
        return d;
    }

    public double getDecisionFunction(int n, Mat mat, Mat mat2) {
        double d = SVM.getDecisionFunction_0(this.nativeObj, n, mat.nativeObj, mat2.nativeObj);
        return d;
    }

    public double getDegree() {
        double d = SVM.getDegree_0(this.nativeObj);
        return d;
    }

    public double getGamma() {
        double d = SVM.getGamma_0(this.nativeObj);
        return d;
    }

    public double getNu() {
        double d = SVM.getNu_0(this.nativeObj);
        return d;
    }

    public double getP() {
        double d = SVM.getP_0(this.nativeObj);
        return d;
    }

    public int getKernelType() {
        int n = SVM.getKernelType_0(this.nativeObj);
        return n;
    }

    public int getType() {
        int n = SVM.getType_0(this.nativeObj);
        return n;
    }

    public void setC(double d) {
        SVM.setC_0(this.nativeObj, d);
    }

    public void setClassWeights(Mat mat) {
        SVM.setClassWeights_0(this.nativeObj, mat.nativeObj);
    }

    public void setCoef0(double d) {
        SVM.setCoef0_0(this.nativeObj, d);
    }

    public void setDegree(double d) {
        SVM.setDegree_0(this.nativeObj, d);
    }

    public void setGamma(double d) {
        SVM.setGamma_0(this.nativeObj, d);
    }

    public void setKernel(int n) {
        SVM.setKernel_0(this.nativeObj, n);
    }

    public void setNu(double d) {
        SVM.setNu_0(this.nativeObj, d);
    }

    public void setP(double d) {
        SVM.setP_0(this.nativeObj, d);
    }

    public void setTermCriteria(TermCriteria termCriteria) {
        SVM.setTermCriteria_0(this.nativeObj, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
    }

    public void setType(int n) {
        SVM.setType_0(this.nativeObj, n);
    }

    @Override
    protected void finalize() throws Throwable {
        SVM.delete(this.nativeObj);
    }

    private static native long getClassWeights_0(long var0);

    private static native long getSupportVectors_0(long var0);

    private static native long getUncompressedSupportVectors_0(long var0);

    private static native long create_0();

    private static native double[] getTermCriteria_0(long var0);

    private static native double getC_0(long var0);

    private static native double getCoef0_0(long var0);

    private static native double getDecisionFunction_0(long var0, int var2, long var3, long var5);

    private static native double getDegree_0(long var0);

    private static native double getGamma_0(long var0);

    private static native double getNu_0(long var0);

    private static native double getP_0(long var0);

    private static native int getKernelType_0(long var0);

    private static native int getType_0(long var0);

    private static native void setC_0(long var0, double var2);

    private static native void setClassWeights_0(long var0, long var2);

    private static native void setCoef0_0(long var0, double var2);

    private static native void setDegree_0(long var0, double var2);

    private static native void setGamma_0(long var0, double var2);

    private static native void setKernel_0(long var0, int var2);

    private static native void setNu_0(long var0, double var2);

    private static native void setP_0(long var0, double var2);

    private static native void setTermCriteria_0(long var0, int var2, int var3, double var4);

    private static native void setType_0(long var0, int var2);

    private static native void delete(long var0);
}

