/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

public class TermCriteria {
    public static final int COUNT = 1;
    public static final int MAX_ITER = 1;
    public static final int EPS = 2;
    public int type;
    public int maxCount;
    public double epsilon;

    public TermCriteria(int n, int n2, double d) {
        this.type = n;
        this.maxCount = n2;
        this.epsilon = d;
    }

    public TermCriteria() {
        this(0, 0, 0.0);
    }

    public TermCriteria(double[] dArray) {
        this.set(dArray);
    }

    public void set(double[] dArray) {
        if (dArray != null) {
            this.type = dArray.length > 0 ? (int)dArray[0] : 0;
            this.maxCount = dArray.length > 1 ? (int)dArray[1] : 0;
            this.epsilon = dArray.length > 2 ? dArray[2] : 0.0;
        } else {
            this.type = 0;
            this.maxCount = 0;
            this.epsilon = 0.0;
        }
    }

    public TermCriteria clone() {
        return new TermCriteria(this.type, this.maxCount, this.epsilon);
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.type);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.maxCount);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.epsilon);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TermCriteria)) {
            return false;
        }
        TermCriteria termCriteria = (TermCriteria)object;
        return this.type == termCriteria.type && this.maxCount == termCriteria.maxCount && this.epsilon == termCriteria.epsilon;
    }

    public String toString() {
        return "{ type: " + this.type + ", maxCount: " + this.maxCount + ", epsilon: " + this.epsilon + "}";
    }
}

