/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import java.util.Arrays;
import java.util.List;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Range;

public class MatOfInt4
extends Mat {
    private static final int _depth = 4;
    private static final int _channels = 4;

    public MatOfInt4() {
    }

    protected MatOfInt4(long l) {
        super(l);
        if (!this.empty() && this.checkVector(4, 4) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public static MatOfInt4 fromNativeAddr(long l) {
        return new MatOfInt4(l);
    }

    public MatOfInt4(Mat mat) {
        super(mat, Range.all());
        if (!this.empty() && this.checkVector(4, 4) < 0) {
            throw new IllegalArgumentException("Incompatible Mat");
        }
    }

    public MatOfInt4(int ... nArray) {
        this.fromArray(nArray);
    }

    public void alloc(int n) {
        if (n > 0) {
            super.create(n, 1, CvType.makeType(4, 4));
        }
    }

    public void fromArray(int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        int n = nArray.length / 4;
        this.alloc(n);
        this.put(0, 0, nArray);
    }

    public int[] toArray() {
        int n = this.checkVector(4, 4);
        if (n < 0) {
            throw new RuntimeException("Native Mat has unexpected type or size: " + this.toString());
        }
        int[] nArray = new int[n * 4];
        if (n == 0) {
            return nArray;
        }
        this.get(0, 0, nArray);
        return nArray;
    }

    public void fromList(List<Integer> list) {
        if (list == null || list.size() == 0) {
            return;
        }
        Integer[] integerArray = list.toArray(new Integer[0]);
        int[] nArray = new int[integerArray.length];
        for (int i = 0; i < integerArray.length; ++i) {
            nArray[i] = integerArray[i];
        }
        this.fromArray(nArray);
    }

    public List<Integer> toList() {
        int[] nArray = this.toArray();
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = nArray[i];
        }
        return Arrays.asList(integerArray);
    }
}

