/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import java.util.Arrays;
import java.util.List;
import org.opencv.core.CvType;
import org.opencv.core.DMatch;
import org.opencv.core.Mat;
import org.opencv.core.Range;

public class MatOfDMatch
extends Mat {
    private static final int _depth = 5;
    private static final int _channels = 4;

    public MatOfDMatch() {
    }

    protected MatOfDMatch(long l) {
        super(l);
        if (!this.empty() && this.checkVector(4, 5) < 0) {
            throw new IllegalArgumentException("Incompatible Mat: " + this.toString());
        }
    }

    public static MatOfDMatch fromNativeAddr(long l) {
        return new MatOfDMatch(l);
    }

    public MatOfDMatch(Mat mat) {
        super(mat, Range.all());
        if (!this.empty() && this.checkVector(4, 5) < 0) {
            throw new IllegalArgumentException("Incompatible Mat: " + this.toString());
        }
    }

    public MatOfDMatch(DMatch ... dMatchArray) {
        this.fromArray(dMatchArray);
    }

    public void alloc(int n) {
        if (n > 0) {
            super.create(n, 1, CvType.makeType(5, 4));
        }
    }

    public void fromArray(DMatch ... dMatchArray) {
        if (dMatchArray == null || dMatchArray.length == 0) {
            return;
        }
        int n = dMatchArray.length;
        this.alloc(n);
        float[] fArray = new float[n * 4];
        for (int i = 0; i < n; ++i) {
            DMatch dMatch = dMatchArray[i];
            fArray[4 * i + 0] = dMatch.queryIdx;
            fArray[4 * i + 1] = dMatch.trainIdx;
            fArray[4 * i + 2] = dMatch.imgIdx;
            fArray[4 * i + 3] = dMatch.distance;
        }
        this.put(0, 0, fArray);
    }

    public DMatch[] toArray() {
        int n = (int)this.total();
        DMatch[] dMatchArray = new DMatch[n];
        if (n == 0) {
            return dMatchArray;
        }
        float[] fArray = new float[n * 4];
        this.get(0, 0, fArray);
        for (int i = 0; i < n; ++i) {
            dMatchArray[i] = new DMatch((int)fArray[4 * i + 0], (int)fArray[4 * i + 1], (int)fArray[4 * i + 2], fArray[4 * i + 3]);
        }
        return dMatchArray;
    }

    public void fromList(List<DMatch> list) {
        DMatch[] dMatchArray = list.toArray(new DMatch[0]);
        this.fromArray(dMatchArray);
    }

    public List<DMatch> toList() {
        DMatch[] dMatchArray = this.toArray();
        return Arrays.asList(dMatchArray);
    }
}

