/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import org.opencv.core.CvType;
import org.opencv.core.Point;
import org.opencv.core.Range;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;

public class Mat {
    public final long nativeObj;

    public Mat(long l) {
        if (l == 0L) {
            throw new UnsupportedOperationException("Native object address is NULL");
        }
        this.nativeObj = l;
    }

    public Mat() {
        this.nativeObj = Mat.n_Mat();
    }

    public Mat(int n, int n2, int n3) {
        this.nativeObj = Mat.n_Mat(n, n2, n3);
    }

    public Mat(Size size, int n) {
        this.nativeObj = Mat.n_Mat(size.width, size.height, n);
    }

    public Mat(int n, int n2, int n3, Scalar scalar) {
        this.nativeObj = Mat.n_Mat(n, n2, n3, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public Mat(Size size, int n, Scalar scalar) {
        this.nativeObj = Mat.n_Mat(size.width, size.height, n, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public Mat(Mat mat, Range range, Range range2) {
        this.nativeObj = Mat.n_Mat(mat.nativeObj, range.start, range.end, range2.start, range2.end);
    }

    public Mat(Mat mat, Range range) {
        this.nativeObj = Mat.n_Mat(mat.nativeObj, range.start, range.end);
    }

    public Mat(Mat mat, Rect rect) {
        this.nativeObj = Mat.n_Mat(mat.nativeObj, rect.y, rect.y + rect.height, rect.x, rect.x + rect.width);
    }

    public Mat adjustROI(int n, int n2, int n3, int n4) {
        Mat mat = new Mat(Mat.n_adjustROI(this.nativeObj, n, n2, n3, n4));
        return mat;
    }

    public void assignTo(Mat mat, int n) {
        Mat.n_assignTo(this.nativeObj, mat.nativeObj, n);
    }

    public void assignTo(Mat mat) {
        Mat.n_assignTo(this.nativeObj, mat.nativeObj);
    }

    public int channels() {
        int n = Mat.n_channels(this.nativeObj);
        return n;
    }

    public int checkVector(int n, int n2, boolean bl) {
        int n3 = Mat.n_checkVector(this.nativeObj, n, n2, bl);
        return n3;
    }

    public int checkVector(int n, int n2) {
        int n3 = Mat.n_checkVector(this.nativeObj, n, n2);
        return n3;
    }

    public int checkVector(int n) {
        int n2 = Mat.n_checkVector(this.nativeObj, n);
        return n2;
    }

    public Mat clone() {
        Mat mat = new Mat(Mat.n_clone(this.nativeObj));
        return mat;
    }

    public Mat col(int n) {
        Mat mat = new Mat(Mat.n_col(this.nativeObj, n));
        return mat;
    }

    public Mat colRange(int n, int n2) {
        Mat mat = new Mat(Mat.n_colRange(this.nativeObj, n, n2));
        return mat;
    }

    public Mat colRange(Range range) {
        Mat mat = new Mat(Mat.n_colRange(this.nativeObj, range.start, range.end));
        return mat;
    }

    public int dims() {
        int n = Mat.n_dims(this.nativeObj);
        return n;
    }

    public int cols() {
        int n = Mat.n_cols(this.nativeObj);
        return n;
    }

    public void convertTo(Mat mat, int n, double d, double d2) {
        Mat.n_convertTo(this.nativeObj, mat.nativeObj, n, d, d2);
    }

    public void convertTo(Mat mat, int n, double d) {
        Mat.n_convertTo(this.nativeObj, mat.nativeObj, n, d);
    }

    public void convertTo(Mat mat, int n) {
        Mat.n_convertTo(this.nativeObj, mat.nativeObj, n);
    }

    public void copyTo(Mat mat) {
        Mat.n_copyTo(this.nativeObj, mat.nativeObj);
    }

    public void copyTo(Mat mat, Mat mat2) {
        Mat.n_copyTo(this.nativeObj, mat.nativeObj, mat2.nativeObj);
    }

    public void create(int n, int n2, int n3) {
        Mat.n_create(this.nativeObj, n, n2, n3);
    }

    public void create(Size size, int n) {
        Mat.n_create(this.nativeObj, size.width, size.height, n);
    }

    public Mat cross(Mat mat) {
        Mat mat2 = new Mat(Mat.n_cross(this.nativeObj, mat.nativeObj));
        return mat2;
    }

    public long dataAddr() {
        long l = Mat.n_dataAddr(this.nativeObj);
        return l;
    }

    public int depth() {
        int n = Mat.n_depth(this.nativeObj);
        return n;
    }

    public Mat diag(int n) {
        Mat mat = new Mat(Mat.n_diag(this.nativeObj, n));
        return mat;
    }

    public Mat diag() {
        Mat mat = new Mat(Mat.n_diag(this.nativeObj, 0));
        return mat;
    }

    public static Mat diag(Mat mat) {
        Mat mat2 = new Mat(Mat.n_diag(mat.nativeObj));
        return mat2;
    }

    public double dot(Mat mat) {
        double d = Mat.n_dot(this.nativeObj, mat.nativeObj);
        return d;
    }

    public long elemSize() {
        long l = Mat.n_elemSize(this.nativeObj);
        return l;
    }

    public long elemSize1() {
        long l = Mat.n_elemSize1(this.nativeObj);
        return l;
    }

    public boolean empty() {
        boolean bl = Mat.n_empty(this.nativeObj);
        return bl;
    }

    public static Mat eye(int n, int n2, int n3) {
        Mat mat = new Mat(Mat.n_eye(n, n2, n3));
        return mat;
    }

    public static Mat eye(Size size, int n) {
        Mat mat = new Mat(Mat.n_eye(size.width, size.height, n));
        return mat;
    }

    public Mat inv(int n) {
        Mat mat = new Mat(Mat.n_inv(this.nativeObj, n));
        return mat;
    }

    public Mat inv() {
        Mat mat = new Mat(Mat.n_inv(this.nativeObj));
        return mat;
    }

    public boolean isContinuous() {
        boolean bl = Mat.n_isContinuous(this.nativeObj);
        return bl;
    }

    public boolean isSubmatrix() {
        boolean bl = Mat.n_isSubmatrix(this.nativeObj);
        return bl;
    }

    public void locateROI(Size size, Point point) {
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        Mat.locateROI_0(this.nativeObj, dArray, dArray2);
        if (size != null) {
            size.width = dArray[0];
            size.height = dArray[1];
        }
        if (point != null) {
            point.x = dArray2[0];
            point.y = dArray2[1];
        }
    }

    public Mat mul(Mat mat, double d) {
        Mat mat2 = new Mat(Mat.n_mul(this.nativeObj, mat.nativeObj, d));
        return mat2;
    }

    public Mat mul(Mat mat) {
        Mat mat2 = new Mat(Mat.n_mul(this.nativeObj, mat.nativeObj));
        return mat2;
    }

    public static Mat ones(int n, int n2, int n3) {
        Mat mat = new Mat(Mat.n_ones(n, n2, n3));
        return mat;
    }

    public static Mat ones(Size size, int n) {
        Mat mat = new Mat(Mat.n_ones(size.width, size.height, n));
        return mat;
    }

    public void push_back(Mat mat) {
        Mat.n_push_back(this.nativeObj, mat.nativeObj);
    }

    public void release() {
        Mat.n_release(this.nativeObj);
    }

    public Mat reshape(int n, int n2) {
        Mat mat = new Mat(Mat.n_reshape(this.nativeObj, n, n2));
        return mat;
    }

    public Mat reshape(int n) {
        Mat mat = new Mat(Mat.n_reshape(this.nativeObj, n));
        return mat;
    }

    public Mat row(int n) {
        Mat mat = new Mat(Mat.n_row(this.nativeObj, n));
        return mat;
    }

    public Mat rowRange(int n, int n2) {
        Mat mat = new Mat(Mat.n_rowRange(this.nativeObj, n, n2));
        return mat;
    }

    public Mat rowRange(Range range) {
        Mat mat = new Mat(Mat.n_rowRange(this.nativeObj, range.start, range.end));
        return mat;
    }

    public int rows() {
        int n = Mat.n_rows(this.nativeObj);
        return n;
    }

    public Mat setTo(Scalar scalar) {
        Mat mat = new Mat(Mat.n_setTo(this.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]));
        return mat;
    }

    public Mat setTo(Scalar scalar, Mat mat) {
        Mat mat2 = new Mat(Mat.n_setTo(this.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], mat.nativeObj));
        return mat2;
    }

    public Mat setTo(Mat mat, Mat mat2) {
        Mat mat3 = new Mat(Mat.n_setTo(this.nativeObj, mat.nativeObj, mat2.nativeObj));
        return mat3;
    }

    public Mat setTo(Mat mat) {
        Mat mat2 = new Mat(Mat.n_setTo(this.nativeObj, mat.nativeObj));
        return mat2;
    }

    public Size size() {
        Size size = new Size(Mat.n_size(this.nativeObj));
        return size;
    }

    public long step1(int n) {
        long l = Mat.n_step1(this.nativeObj, n);
        return l;
    }

    public long step1() {
        long l = Mat.n_step1(this.nativeObj);
        return l;
    }

    public Mat submat(int n, int n2, int n3, int n4) {
        Mat mat = new Mat(Mat.n_submat_rr(this.nativeObj, n, n2, n3, n4));
        return mat;
    }

    public Mat submat(Range range, Range range2) {
        Mat mat = new Mat(Mat.n_submat_rr(this.nativeObj, range.start, range.end, range2.start, range2.end));
        return mat;
    }

    public Mat submat(Rect rect) {
        Mat mat = new Mat(Mat.n_submat(this.nativeObj, rect.x, rect.y, rect.width, rect.height));
        return mat;
    }

    public Mat t() {
        Mat mat = new Mat(Mat.n_t(this.nativeObj));
        return mat;
    }

    public long total() {
        long l = Mat.n_total(this.nativeObj);
        return l;
    }

    public int type() {
        int n = Mat.n_type(this.nativeObj);
        return n;
    }

    public static Mat zeros(int n, int n2, int n3) {
        Mat mat = new Mat(Mat.n_zeros(n, n2, n3));
        return mat;
    }

    public static Mat zeros(Size size, int n) {
        Mat mat = new Mat(Mat.n_zeros(size.width, size.height, n));
        return mat;
    }

    protected void finalize() throws Throwable {
        Mat.n_delete(this.nativeObj);
        super.finalize();
    }

    public String toString() {
        return "Mat [ " + this.rows() + "*" + this.cols() + "*" + CvType.typeToString(this.type()) + ", isCont=" + this.isContinuous() + ", isSubmat=" + this.isSubmatrix() + ", nativeObj=0x" + Long.toHexString(this.nativeObj) + ", dataAddr=0x" + Long.toHexString(this.dataAddr()) + " ]";
    }

    public String dump() {
        return Mat.nDump(this.nativeObj);
    }

    public int put(int n, int n2, double ... dArray) {
        int n3 = this.type();
        if (dArray == null || dArray.length % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (dArray == null ? 0 : dArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        return Mat.nPutD(this.nativeObj, n, n2, dArray.length, dArray);
    }

    public int put(int n, int n2, float[] fArray) {
        int n3 = this.type();
        if (fArray == null || fArray.length % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (fArray == null ? 0 : fArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        if (CvType.depth(n3) == 5) {
            return Mat.nPutF(this.nativeObj, n, n2, fArray.length, fArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
    }

    public int put(int n, int n2, int[] nArray) {
        int n3 = this.type();
        if (nArray == null || nArray.length % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (nArray == null ? 0 : nArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        if (CvType.depth(n3) == 4) {
            return Mat.nPutI(this.nativeObj, n, n2, nArray.length, nArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
    }

    public int put(int n, int n2, short[] sArray) {
        int n3 = this.type();
        if (sArray == null || sArray.length % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (sArray == null ? 0 : sArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        if (CvType.depth(n3) == 2 || CvType.depth(n3) == 3) {
            return Mat.nPutS(this.nativeObj, n, n2, sArray.length, sArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
    }

    public int put(int n, int n2, byte[] byArray) {
        int n3 = this.type();
        if (byArray == null || byArray.length % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (byArray == null ? 0 : byArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        if (CvType.depth(n3) == 0 || CvType.depth(n3) == 1) {
            return Mat.nPutB(this.nativeObj, n, n2, byArray.length, byArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
    }

    public int get(int n, int n2, byte[] byArray) {
        int n3 = this.type();
        if (byArray == null || byArray.length % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (byArray == null ? 0 : byArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        if (CvType.depth(n3) == 0 || CvType.depth(n3) == 1) {
            return Mat.nGetB(this.nativeObj, n, n2, byArray.length, byArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
    }

    public int get(int n, int n2, short[] sArray) {
        int n3 = this.type();
        if (sArray == null || sArray.length % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (sArray == null ? 0 : sArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        if (CvType.depth(n3) == 2 || CvType.depth(n3) == 3) {
            return Mat.nGetS(this.nativeObj, n, n2, sArray.length, sArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
    }

    public int get(int n, int n2, int[] nArray) {
        int n3 = this.type();
        if (nArray == null || nArray.length % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (nArray == null ? 0 : nArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        if (CvType.depth(n3) == 4) {
            return Mat.nGetI(this.nativeObj, n, n2, nArray.length, nArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
    }

    public int get(int n, int n2, float[] fArray) {
        int n3 = this.type();
        if (fArray == null || fArray.length % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (fArray == null ? 0 : fArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        if (CvType.depth(n3) == 5) {
            return Mat.nGetF(this.nativeObj, n, n2, fArray.length, fArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
    }

    public int get(int n, int n2, double[] dArray) {
        int n3 = this.type();
        if (dArray == null || dArray.length % CvType.channels(n3) != 0) {
            throw new UnsupportedOperationException("Provided data element number (" + (dArray == null ? 0 : dArray.length) + ") should be multiple of the Mat channels count (" + CvType.channels(n3) + ")");
        }
        if (CvType.depth(n3) == 6) {
            return Mat.nGetD(this.nativeObj, n, n2, dArray.length, dArray);
        }
        throw new UnsupportedOperationException("Mat data type is not compatible: " + n3);
    }

    public double[] get(int n, int n2) {
        return Mat.nGet(this.nativeObj, n, n2);
    }

    public int height() {
        return this.rows();
    }

    public int width() {
        return this.cols();
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    private static native long n_Mat();

    private static native long n_Mat(int var0, int var1, int var2);

    private static native long n_Mat(double var0, double var2, int var4);

    private static native long n_Mat(int var0, int var1, int var2, double var3, double var5, double var7, double var9);

    private static native long n_Mat(double var0, double var2, int var4, double var5, double var7, double var9, double var11);

    private static native long n_Mat(long var0, int var2, int var3, int var4, int var5);

    private static native long n_Mat(long var0, int var2, int var3);

    private static native long n_adjustROI(long var0, int var2, int var3, int var4, int var5);

    private static native void n_assignTo(long var0, long var2, int var4);

    private static native void n_assignTo(long var0, long var2);

    private static native int n_channels(long var0);

    private static native int n_checkVector(long var0, int var2, int var3, boolean var4);

    private static native int n_checkVector(long var0, int var2, int var3);

    private static native int n_checkVector(long var0, int var2);

    private static native long n_clone(long var0);

    private static native long n_col(long var0, int var2);

    private static native long n_colRange(long var0, int var2, int var3);

    private static native int n_dims(long var0);

    private static native int n_cols(long var0);

    private static native void n_convertTo(long var0, long var2, int var4, double var5, double var7);

    private static native void n_convertTo(long var0, long var2, int var4, double var5);

    private static native void n_convertTo(long var0, long var2, int var4);

    private static native void n_copyTo(long var0, long var2);

    private static native void n_copyTo(long var0, long var2, long var4);

    private static native void n_create(long var0, int var2, int var3, int var4);

    private static native void n_create(long var0, double var2, double var4, int var6);

    private static native long n_cross(long var0, long var2);

    private static native long n_dataAddr(long var0);

    private static native int n_depth(long var0);

    private static native long n_diag(long var0, int var2);

    private static native long n_diag(long var0);

    private static native double n_dot(long var0, long var2);

    private static native long n_elemSize(long var0);

    private static native long n_elemSize1(long var0);

    private static native boolean n_empty(long var0);

    private static native long n_eye(int var0, int var1, int var2);

    private static native long n_eye(double var0, double var2, int var4);

    private static native long n_inv(long var0, int var2);

    private static native long n_inv(long var0);

    private static native boolean n_isContinuous(long var0);

    private static native boolean n_isSubmatrix(long var0);

    private static native void locateROI_0(long var0, double[] var2, double[] var3);

    private static native long n_mul(long var0, long var2, double var4);

    private static native long n_mul(long var0, long var2);

    private static native long n_ones(int var0, int var1, int var2);

    private static native long n_ones(double var0, double var2, int var4);

    private static native void n_push_back(long var0, long var2);

    private static native void n_release(long var0);

    private static native long n_reshape(long var0, int var2, int var3);

    private static native long n_reshape(long var0, int var2);

    private static native long n_row(long var0, int var2);

    private static native long n_rowRange(long var0, int var2, int var3);

    private static native int n_rows(long var0);

    private static native long n_setTo(long var0, double var2, double var4, double var6, double var8);

    private static native long n_setTo(long var0, double var2, double var4, double var6, double var8, long var10);

    private static native long n_setTo(long var0, long var2, long var4);

    private static native long n_setTo(long var0, long var2);

    private static native double[] n_size(long var0);

    private static native long n_step1(long var0, int var2);

    private static native long n_step1(long var0);

    private static native long n_submat_rr(long var0, int var2, int var3, int var4, int var5);

    private static native long n_submat(long var0, int var2, int var3, int var4, int var5);

    private static native long n_t(long var0);

    private static native long n_total(long var0);

    private static native int n_type(long var0);

    private static native long n_zeros(int var0, int var1, int var2);

    private static native long n_zeros(double var0, double var2, int var4);

    private static native void n_delete(long var0);

    private static native int nPutD(long var0, int var2, int var3, int var4, double[] var5);

    private static native int nPutF(long var0, int var2, int var3, int var4, float[] var5);

    private static native int nPutI(long var0, int var2, int var3, int var4, int[] var5);

    private static native int nPutS(long var0, int var2, int var3, int var4, short[] var5);

    private static native int nPutB(long var0, int var2, int var3, int var4, byte[] var5);

    private static native int nGetB(long var0, int var2, int var3, int var4, byte[] var5);

    private static native int nGetS(long var0, int var2, int var3, int var4, short[] var5);

    private static native int nGetI(long var0, int var2, int var3, int var4, int[] var5);

    private static native int nGetF(long var0, int var2, int var3, int var4, float[] var5);

    private static native int nGetD(long var0, int var2, int var3, int var4, double[] var5);

    private static native double[] nGet(long var0, int var2, int var3);

    private static native String nDump(long var0);
}

