/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.calib3d;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfDouble;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.MatOfPoint3f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Size;
import org.opencv.core.TermCriteria;
import org.opencv.utils.Converters;

public class Calib3d {
    public static final int CALIB_USE_INTRINSIC_GUESS = 1;
    public static final int CALIB_RECOMPUTE_EXTRINSIC = 2;
    public static final int CALIB_CHECK_COND = 4;
    public static final int CALIB_FIX_SKEW = 8;
    public static final int CALIB_FIX_K1 = 16;
    public static final int CALIB_FIX_K2 = 32;
    public static final int CALIB_FIX_K3 = 64;
    public static final int CALIB_FIX_K4 = 128;
    public static final int CALIB_FIX_INTRINSIC = 256;
    public static final int CV_ITERATIVE = 0;
    public static final int CV_EPNP = 1;
    public static final int CV_P3P = 2;
    public static final int CV_DLS = 3;
    public static final int LMEDS = 4;
    public static final int RANSAC = 8;
    public static final int RHO = 16;
    public static final int SOLVEPNP_ITERATIVE = 0;
    public static final int SOLVEPNP_EPNP = 1;
    public static final int SOLVEPNP_P3P = 2;
    public static final int SOLVEPNP_DLS = 3;
    public static final int SOLVEPNP_UPNP = 4;
    public static final int CALIB_CB_ADAPTIVE_THRESH = 1;
    public static final int CALIB_CB_NORMALIZE_IMAGE = 2;
    public static final int CALIB_CB_FILTER_QUADS = 4;
    public static final int CALIB_CB_FAST_CHECK = 8;
    public static final int CALIB_CB_SYMMETRIC_GRID = 1;
    public static final int CALIB_CB_ASYMMETRIC_GRID = 2;
    public static final int CALIB_CB_CLUSTERING = 4;
    public static final int CALIB_FIX_ASPECT_RATIO = 2;
    public static final int CALIB_FIX_PRINCIPAL_POINT = 4;
    public static final int CALIB_ZERO_TANGENT_DIST = 8;
    public static final int CALIB_FIX_FOCAL_LENGTH = 16;
    public static final int CALIB_FIX_K5 = 4096;
    public static final int CALIB_FIX_K6 = 8192;
    public static final int CALIB_RATIONAL_MODEL = 16384;
    public static final int CALIB_THIN_PRISM_MODEL = 32768;
    public static final int CALIB_FIX_S1_S2_S3_S4 = 65536;
    public static final int CALIB_TILTED_MODEL = 262144;
    public static final int CALIB_FIX_TAUX_TAUY = 524288;
    public static final int CALIB_SAME_FOCAL_LENGTH = 512;
    public static final int CALIB_ZERO_DISPARITY = 1024;
    public static final int CALIB_USE_LU = 131072;
    public static final int FM_7POINT = 1;
    public static final int FM_8POINT = 2;
    public static final int FM_LMEDS = 4;
    public static final int FM_RANSAC = 8;

    public static Mat findEssentialMat(Mat mat, Mat mat2, Mat mat3, int n, double d, double d2, Mat mat4) {
        Mat mat5 = new Mat(Calib3d.findEssentialMat_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, d, d2, mat4.nativeObj));
        return mat5;
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, Mat mat3, int n, double d, double d2) {
        Mat mat4 = new Mat(Calib3d.findEssentialMat_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, n, d, d2));
        return mat4;
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, Mat mat3) {
        Mat mat4 = new Mat(Calib3d.findEssentialMat_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj));
        return mat4;
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, double d, Point point, int n, double d2, double d3, Mat mat3) {
        Mat mat4 = new Mat(Calib3d.findEssentialMat_3(mat.nativeObj, mat2.nativeObj, d, point.x, point.y, n, d2, d3, mat3.nativeObj));
        return mat4;
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2, double d, Point point, int n, double d2, double d3) {
        Mat mat3 = new Mat(Calib3d.findEssentialMat_4(mat.nativeObj, mat2.nativeObj, d, point.x, point.y, n, d2, d3));
        return mat3;
    }

    public static Mat findEssentialMat(Mat mat, Mat mat2) {
        Mat mat3 = new Mat(Calib3d.findEssentialMat_5(mat.nativeObj, mat2.nativeObj));
        return mat3;
    }

    public static Mat findFundamentalMat(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, int n, double d, double d2, Mat mat) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        Mat mat2 = new Mat(Calib3d.findFundamentalMat_0(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, n, d, d2, mat.nativeObj));
        return mat2;
    }

    public static Mat findFundamentalMat(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, int n, double d, double d2) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        Mat mat = new Mat(Calib3d.findFundamentalMat_1(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, n, d, d2));
        return mat;
    }

    public static Mat findFundamentalMat(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        Mat mat = new Mat(Calib3d.findFundamentalMat_2(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj));
        return mat;
    }

    public static Mat findHomography(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, int n, double d, Mat mat, int n2, double d2) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        Mat mat2 = new Mat(Calib3d.findHomography_0(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, n, d, mat.nativeObj, n2, d2));
        return mat2;
    }

    public static Mat findHomography(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2, int n, double d) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        Mat mat = new Mat(Calib3d.findHomography_1(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj, n, d));
        return mat;
    }

    public static Mat findHomography(MatOfPoint2f matOfPoint2f, MatOfPoint2f matOfPoint2f2) {
        MatOfPoint2f matOfPoint2f3 = matOfPoint2f;
        MatOfPoint2f matOfPoint2f4 = matOfPoint2f2;
        Mat mat = new Mat(Calib3d.findHomography_2(matOfPoint2f3.nativeObj, matOfPoint2f4.nativeObj));
        return mat;
    }

    public static Mat getOptimalNewCameraMatrix(Mat mat, Mat mat2, Size size, double d, Size size2, Rect rect, boolean bl) {
        double[] dArray = new double[4];
        Mat mat3 = new Mat(Calib3d.getOptimalNewCameraMatrix_0(mat.nativeObj, mat2.nativeObj, size.width, size.height, d, size2.width, size2.height, dArray, bl));
        if (rect != null) {
            rect.x = (int)dArray[0];
            rect.y = (int)dArray[1];
            rect.width = (int)dArray[2];
            rect.height = (int)dArray[3];
        }
        return mat3;
    }

    public static Mat getOptimalNewCameraMatrix(Mat mat, Mat mat2, Size size, double d) {
        Mat mat3 = new Mat(Calib3d.getOptimalNewCameraMatrix_1(mat.nativeObj, mat2.nativeObj, size.width, size.height, d));
        return mat3;
    }

    public static Mat initCameraMatrix2D(List<MatOfPoint3f> list, List<MatOfPoint2f> list2, Size size, double d) {
        ArrayList<Mat> arrayList = new ArrayList<Mat>(list != null ? list.size() : 0);
        Mat mat = Converters.vector_vector_Point3f_to_Mat(list, arrayList);
        ArrayList<Mat> arrayList2 = new ArrayList<Mat>(list2 != null ? list2.size() : 0);
        Mat mat2 = Converters.vector_vector_Point2f_to_Mat(list2, arrayList2);
        Mat mat3 = new Mat(Calib3d.initCameraMatrix2D_0(mat.nativeObj, mat2.nativeObj, size.width, size.height, d));
        return mat3;
    }

    public static Mat initCameraMatrix2D(List<MatOfPoint3f> list, List<MatOfPoint2f> list2, Size size) {
        ArrayList<Mat> arrayList = new ArrayList<Mat>(list != null ? list.size() : 0);
        Mat mat = Converters.vector_vector_Point3f_to_Mat(list, arrayList);
        ArrayList<Mat> arrayList2 = new ArrayList<Mat>(list2 != null ? list2.size() : 0);
        Mat mat2 = Converters.vector_vector_Point2f_to_Mat(list2, arrayList2);
        Mat mat3 = new Mat(Calib3d.initCameraMatrix2D_1(mat.nativeObj, mat2.nativeObj, size.width, size.height));
        return mat3;
    }

    public static Rect getValidDisparityROI(Rect rect, Rect rect2, int n, int n2, int n3) {
        Rect rect3 = new Rect(Calib3d.getValidDisparityROI_0(rect.x, rect.y, rect.width, rect.height, rect2.x, rect2.y, rect2.width, rect2.height, n, n2, n3));
        return rect3;
    }

    public static double[] RQDecomp3x3(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6) {
        double[] dArray = Calib3d.RQDecomp3x3_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj);
        return dArray;
    }

    public static double[] RQDecomp3x3(Mat mat, Mat mat2, Mat mat3) {
        double[] dArray = Calib3d.RQDecomp3x3_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
        return dArray;
    }

    public static boolean findChessboardCorners(Mat mat, Size size, MatOfPoint2f matOfPoint2f, int n) {
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        boolean bl = Calib3d.findChessboardCorners_0(mat.nativeObj, size.width, size.height, matOfPoint2f2.nativeObj, n);
        return bl;
    }

    public static boolean findChessboardCorners(Mat mat, Size size, MatOfPoint2f matOfPoint2f) {
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        boolean bl = Calib3d.findChessboardCorners_1(mat.nativeObj, size.width, size.height, matOfPoint2f2.nativeObj);
        return bl;
    }

    public static boolean findCirclesGrid(Mat mat, Size size, Mat mat2, int n) {
        boolean bl = Calib3d.findCirclesGrid_0(mat.nativeObj, size.width, size.height, mat2.nativeObj, n);
        return bl;
    }

    public static boolean findCirclesGrid(Mat mat, Size size, Mat mat2) {
        boolean bl = Calib3d.findCirclesGrid_1(mat.nativeObj, size.width, size.height, mat2.nativeObj);
        return bl;
    }

    public static boolean solvePnP(MatOfPoint3f matOfPoint3f, MatOfPoint2f matOfPoint2f, Mat mat, MatOfDouble matOfDouble, Mat mat2, Mat mat3, boolean bl, int n) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        MatOfDouble matOfDouble2 = matOfDouble;
        boolean bl2 = Calib3d.solvePnP_0(matOfPoint3f2.nativeObj, matOfPoint2f2.nativeObj, mat.nativeObj, matOfDouble2.nativeObj, mat2.nativeObj, mat3.nativeObj, bl, n);
        return bl2;
    }

    public static boolean solvePnP(MatOfPoint3f matOfPoint3f, MatOfPoint2f matOfPoint2f, Mat mat, MatOfDouble matOfDouble, Mat mat2, Mat mat3) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        MatOfDouble matOfDouble2 = matOfDouble;
        boolean bl = Calib3d.solvePnP_1(matOfPoint3f2.nativeObj, matOfPoint2f2.nativeObj, mat.nativeObj, matOfDouble2.nativeObj, mat2.nativeObj, mat3.nativeObj);
        return bl;
    }

    public static boolean solvePnPRansac(MatOfPoint3f matOfPoint3f, MatOfPoint2f matOfPoint2f, Mat mat, MatOfDouble matOfDouble, Mat mat2, Mat mat3, boolean bl, int n, float f, double d, Mat mat4, int n2) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        MatOfDouble matOfDouble2 = matOfDouble;
        boolean bl2 = Calib3d.solvePnPRansac_0(matOfPoint3f2.nativeObj, matOfPoint2f2.nativeObj, mat.nativeObj, matOfDouble2.nativeObj, mat2.nativeObj, mat3.nativeObj, bl, n, f, d, mat4.nativeObj, n2);
        return bl2;
    }

    public static boolean solvePnPRansac(MatOfPoint3f matOfPoint3f, MatOfPoint2f matOfPoint2f, Mat mat, MatOfDouble matOfDouble, Mat mat2, Mat mat3) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        MatOfDouble matOfDouble2 = matOfDouble;
        boolean bl = Calib3d.solvePnPRansac_1(matOfPoint3f2.nativeObj, matOfPoint2f2.nativeObj, mat.nativeObj, matOfDouble2.nativeObj, mat2.nativeObj, mat3.nativeObj);
        return bl;
    }

    public static boolean stereoRectifyUncalibrated(Mat mat, Mat mat2, Mat mat3, Size size, Mat mat4, Mat mat5, double d) {
        boolean bl = Calib3d.stereoRectifyUncalibrated_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, size.width, size.height, mat4.nativeObj, mat5.nativeObj, d);
        return bl;
    }

    public static boolean stereoRectifyUncalibrated(Mat mat, Mat mat2, Mat mat3, Size size, Mat mat4, Mat mat5) {
        boolean bl = Calib3d.stereoRectifyUncalibrated_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, size.width, size.height, mat4.nativeObj, mat5.nativeObj);
        return bl;
    }

    public static double calibrateCamera(List<Mat> list, List<Mat> list2, Size size, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4, int n, TermCriteria termCriteria) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        Mat mat4 = Converters.vector_Mat_to_Mat(list2);
        Mat mat5 = new Mat();
        Mat mat6 = new Mat();
        double d = Calib3d.calibrateCamera_0(mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat.nativeObj, mat2.nativeObj, mat5.nativeObj, mat6.nativeObj, n, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
        Converters.Mat_to_vector_Mat(mat5, list3);
        mat5.release();
        Converters.Mat_to_vector_Mat(mat6, list4);
        mat6.release();
        return d;
    }

    public static double calibrateCamera(List<Mat> list, List<Mat> list2, Size size, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4, int n) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        Mat mat4 = Converters.vector_Mat_to_Mat(list2);
        Mat mat5 = new Mat();
        Mat mat6 = new Mat();
        double d = Calib3d.calibrateCamera_1(mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat.nativeObj, mat2.nativeObj, mat5.nativeObj, mat6.nativeObj, n);
        Converters.Mat_to_vector_Mat(mat5, list3);
        mat5.release();
        Converters.Mat_to_vector_Mat(mat6, list4);
        mat6.release();
        return d;
    }

    public static double calibrateCamera(List<Mat> list, List<Mat> list2, Size size, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        Mat mat4 = Converters.vector_Mat_to_Mat(list2);
        Mat mat5 = new Mat();
        Mat mat6 = new Mat();
        double d = Calib3d.calibrateCamera_2(mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat.nativeObj, mat2.nativeObj, mat5.nativeObj, mat6.nativeObj);
        Converters.Mat_to_vector_Mat(mat5, list3);
        mat5.release();
        Converters.Mat_to_vector_Mat(mat6, list4);
        mat6.release();
        return d;
    }

    public static double sampsonDistance(Mat mat, Mat mat2, Mat mat3) {
        double d = Calib3d.sampsonDistance_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
        return d;
    }

    public static double stereoCalibrate(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, int n, TermCriteria termCriteria) {
        Mat mat9 = Converters.vector_Mat_to_Mat(list);
        Mat mat10 = Converters.vector_Mat_to_Mat(list2);
        Mat mat11 = Converters.vector_Mat_to_Mat(list3);
        double d = Calib3d.stereoCalibrate_0(mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, n, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
        return d;
    }

    public static double stereoCalibrate(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, int n) {
        Mat mat9 = Converters.vector_Mat_to_Mat(list);
        Mat mat10 = Converters.vector_Mat_to_Mat(list2);
        Mat mat11 = Converters.vector_Mat_to_Mat(list3);
        double d = Calib3d.stereoCalibrate_1(mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, n);
        return d;
    }

    public static double stereoCalibrate(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8) {
        Mat mat9 = Converters.vector_Mat_to_Mat(list);
        Mat mat10 = Converters.vector_Mat_to_Mat(list2);
        Mat mat11 = Converters.vector_Mat_to_Mat(list3);
        double d = Calib3d.stereoCalibrate_2(mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj);
        return d;
    }

    public static double calibrate(List<Mat> list, List<Mat> list2, Size size, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4, int n, TermCriteria termCriteria) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        Mat mat4 = Converters.vector_Mat_to_Mat(list2);
        Mat mat5 = new Mat();
        Mat mat6 = new Mat();
        double d = Calib3d.calibrate_0(mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat.nativeObj, mat2.nativeObj, mat5.nativeObj, mat6.nativeObj, n, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
        Converters.Mat_to_vector_Mat(mat5, list3);
        mat5.release();
        Converters.Mat_to_vector_Mat(mat6, list4);
        mat6.release();
        return d;
    }

    public static double calibrate(List<Mat> list, List<Mat> list2, Size size, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4, int n) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        Mat mat4 = Converters.vector_Mat_to_Mat(list2);
        Mat mat5 = new Mat();
        Mat mat6 = new Mat();
        double d = Calib3d.calibrate_1(mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat.nativeObj, mat2.nativeObj, mat5.nativeObj, mat6.nativeObj, n);
        Converters.Mat_to_vector_Mat(mat5, list3);
        mat5.release();
        Converters.Mat_to_vector_Mat(mat6, list4);
        mat6.release();
        return d;
    }

    public static double calibrate(List<Mat> list, List<Mat> list2, Size size, Mat mat, Mat mat2, List<Mat> list3, List<Mat> list4) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        Mat mat4 = Converters.vector_Mat_to_Mat(list2);
        Mat mat5 = new Mat();
        Mat mat6 = new Mat();
        double d = Calib3d.calibrate_2(mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat.nativeObj, mat2.nativeObj, mat5.nativeObj, mat6.nativeObj);
        Converters.Mat_to_vector_Mat(mat5, list3);
        mat5.release();
        Converters.Mat_to_vector_Mat(mat6, list4);
        mat6.release();
        return d;
    }

    public static double stereoCalibrate(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, int n, TermCriteria termCriteria) {
        Mat mat7 = Converters.vector_Mat_to_Mat(list);
        Mat mat8 = Converters.vector_Mat_to_Mat(list2);
        Mat mat9 = Converters.vector_Mat_to_Mat(list3);
        double d = Calib3d.stereoCalibrate_3(mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, n, termCriteria.type, termCriteria.maxCount, termCriteria.epsilon);
        return d;
    }

    public static double stereoCalibrate(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, int n) {
        Mat mat7 = Converters.vector_Mat_to_Mat(list);
        Mat mat8 = Converters.vector_Mat_to_Mat(list2);
        Mat mat9 = Converters.vector_Mat_to_Mat(list3);
        double d = Calib3d.stereoCalibrate_4(mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, n);
        return d;
    }

    public static double stereoCalibrate(List<Mat> list, List<Mat> list2, List<Mat> list3, Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6) {
        Mat mat7 = Converters.vector_Mat_to_Mat(list);
        Mat mat8 = Converters.vector_Mat_to_Mat(list2);
        Mat mat9 = Converters.vector_Mat_to_Mat(list3);
        double d = Calib3d.stereoCalibrate_5(mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj);
        return d;
    }

    public static float rectify3Collinear(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, List<Mat> list, List<Mat> list2, Size size, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11, Mat mat12, Mat mat13, Mat mat14, Mat mat15, Mat mat16, Mat mat17, double d, Size size2, Rect rect, Rect rect2, int n) {
        Mat mat18 = Converters.vector_Mat_to_Mat(list);
        Mat mat19 = Converters.vector_Mat_to_Mat(list2);
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        float f = Calib3d.rectify3Collinear_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat18.nativeObj, mat19.nativeObj, size.width, size.height, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, mat12.nativeObj, mat13.nativeObj, mat14.nativeObj, mat15.nativeObj, mat16.nativeObj, mat17.nativeObj, d, size2.width, size2.height, dArray, dArray2, n);
        if (rect != null) {
            rect.x = (int)dArray[0];
            rect.y = (int)dArray[1];
            rect.width = (int)dArray[2];
            rect.height = (int)dArray[3];
        }
        if (rect2 != null) {
            rect2.x = (int)dArray2[0];
            rect2.y = (int)dArray2[1];
            rect2.width = (int)dArray2[2];
            rect2.height = (int)dArray2[3];
        }
        return f;
    }

    public static int decomposeHomographyMat(Mat mat, Mat mat2, List<Mat> list, List<Mat> list2, List<Mat> list3) {
        Mat mat3 = new Mat();
        Mat mat4 = new Mat();
        Mat mat5 = new Mat();
        int n = Calib3d.decomposeHomographyMat_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj);
        Converters.Mat_to_vector_Mat(mat3, list);
        mat3.release();
        Converters.Mat_to_vector_Mat(mat4, list2);
        mat4.release();
        Converters.Mat_to_vector_Mat(mat5, list3);
        mat5.release();
        return n;
    }

    public static int estimateAffine3D(Mat mat, Mat mat2, Mat mat3, Mat mat4, double d, double d2) {
        int n = Calib3d.estimateAffine3D_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, d, d2);
        return n;
    }

    public static int estimateAffine3D(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        int n = Calib3d.estimateAffine3D_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
        return n;
    }

    public static int recoverPose(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, double d, Point point, Mat mat6) {
        int n = Calib3d.recoverPose_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, d, point.x, point.y, mat6.nativeObj);
        return n;
    }

    public static int recoverPose(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, double d, Point point) {
        int n = Calib3d.recoverPose_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, d, point.x, point.y);
        return n;
    }

    public static int recoverPose(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5) {
        int n = Calib3d.recoverPose_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj);
        return n;
    }

    public static int recoverPose(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7) {
        int n = Calib3d.recoverPose_3(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj);
        return n;
    }

    public static int recoverPose(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6) {
        int n = Calib3d.recoverPose_4(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj);
        return n;
    }

    public static void Rodrigues(Mat mat, Mat mat2, Mat mat3) {
        Calib3d.Rodrigues_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void Rodrigues(Mat mat, Mat mat2) {
        Calib3d.Rodrigues_1(mat.nativeObj, mat2.nativeObj);
    }

    public static void calibrationMatrixValues(Mat mat, Size size, double d, double d2, double[] dArray, double[] dArray2, double[] dArray3, Point point, double[] dArray4) {
        double[] dArray5 = new double[1];
        double[] dArray6 = new double[1];
        double[] dArray7 = new double[1];
        double[] dArray8 = new double[2];
        double[] dArray9 = new double[1];
        Calib3d.calibrationMatrixValues_0(mat.nativeObj, size.width, size.height, d, d2, dArray5, dArray6, dArray7, dArray8, dArray9);
        if (dArray != null) {
            dArray[0] = dArray5[0];
        }
        if (dArray2 != null) {
            dArray2[0] = dArray6[0];
        }
        if (dArray3 != null) {
            dArray3[0] = dArray7[0];
        }
        if (point != null) {
            point.x = dArray8[0];
            point.y = dArray8[1];
        }
        if (dArray4 != null) {
            dArray4[0] = dArray9[0];
        }
    }

    public static void composeRT(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11, Mat mat12, Mat mat13, Mat mat14) {
        Calib3d.composeRT_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, mat12.nativeObj, mat13.nativeObj, mat14.nativeObj);
    }

    public static void composeRT(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6) {
        Calib3d.composeRT_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj);
    }

    public static void computeCorrespondEpilines(Mat mat, int n, Mat mat2, Mat mat3) {
        Calib3d.computeCorrespondEpilines_0(mat.nativeObj, n, mat2.nativeObj, mat3.nativeObj);
    }

    public static void convertPointsFromHomogeneous(Mat mat, Mat mat2) {
        Calib3d.convertPointsFromHomogeneous_0(mat.nativeObj, mat2.nativeObj);
    }

    public static void convertPointsToHomogeneous(Mat mat, Mat mat2) {
        Calib3d.convertPointsToHomogeneous_0(mat.nativeObj, mat2.nativeObj);
    }

    public static void correctMatches(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5) {
        Calib3d.correctMatches_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj);
    }

    public static void decomposeEssentialMat(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Calib3d.decomposeEssentialMat_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void decomposeProjectionMatrix(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6, Mat mat7, Mat mat8) {
        Calib3d.decomposeProjectionMatrix_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj);
    }

    public static void decomposeProjectionMatrix(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Calib3d.decomposeProjectionMatrix_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void drawChessboardCorners(Mat mat, Size size, MatOfPoint2f matOfPoint2f, boolean bl) {
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        Calib3d.drawChessboardCorners_0(mat.nativeObj, size.width, size.height, matOfPoint2f2.nativeObj, bl);
    }

    public static void filterSpeckles(Mat mat, double d, int n, double d2, Mat mat2) {
        Calib3d.filterSpeckles_0(mat.nativeObj, d, n, d2, mat2.nativeObj);
    }

    public static void filterSpeckles(Mat mat, double d, int n, double d2) {
        Calib3d.filterSpeckles_1(mat.nativeObj, d, n, d2);
    }

    public static void matMulDeriv(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Calib3d.matMulDeriv_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void projectPoints(MatOfPoint3f matOfPoint3f, Mat mat, Mat mat2, Mat mat3, MatOfDouble matOfDouble, MatOfPoint2f matOfPoint2f, Mat mat4, double d) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfDouble matOfDouble2 = matOfDouble;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        Calib3d.projectPoints_0(matOfPoint3f2.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, matOfDouble2.nativeObj, matOfPoint2f2.nativeObj, mat4.nativeObj, d);
    }

    public static void projectPoints(MatOfPoint3f matOfPoint3f, Mat mat, Mat mat2, Mat mat3, MatOfDouble matOfDouble, MatOfPoint2f matOfPoint2f) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfDouble matOfDouble2 = matOfDouble;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        Calib3d.projectPoints_1(matOfPoint3f2.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, matOfDouble2.nativeObj, matOfPoint2f2.nativeObj);
    }

    public static void reprojectImageTo3D(Mat mat, Mat mat2, Mat mat3, boolean bl, int n) {
        Calib3d.reprojectImageTo3D_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, bl, n);
    }

    public static void reprojectImageTo3D(Mat mat, Mat mat2, Mat mat3, boolean bl) {
        Calib3d.reprojectImageTo3D_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, bl);
    }

    public static void reprojectImageTo3D(Mat mat, Mat mat2, Mat mat3) {
        Calib3d.reprojectImageTo3D_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public static void stereoRectify(Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11, int n, double d, Size size2, Rect rect, Rect rect2) {
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        Calib3d.stereoRectify_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, n, d, size2.width, size2.height, dArray, dArray2);
        if (rect != null) {
            rect.x = (int)dArray[0];
            rect.y = (int)dArray[1];
            rect.width = (int)dArray[2];
            rect.height = (int)dArray[3];
        }
        if (rect2 != null) {
            rect2.x = (int)dArray2[0];
            rect2.y = (int)dArray2[1];
            rect2.width = (int)dArray2[2];
            rect2.height = (int)dArray2[3];
        }
    }

    public static void stereoRectify(Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11) {
        Calib3d.stereoRectify_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj);
    }

    public static void triangulatePoints(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5) {
        Calib3d.triangulatePoints_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj);
    }

    public static void validateDisparity(Mat mat, Mat mat2, int n, int n2, int n3) {
        Calib3d.validateDisparity_0(mat.nativeObj, mat2.nativeObj, n, n2, n3);
    }

    public static void validateDisparity(Mat mat, Mat mat2, int n, int n2) {
        Calib3d.validateDisparity_1(mat.nativeObj, mat2.nativeObj, n, n2);
    }

    public static void distortPoints(Mat mat, Mat mat2, Mat mat3, Mat mat4, double d) {
        Calib3d.distortPoints_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, d);
    }

    public static void distortPoints(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Calib3d.distortPoints_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void estimateNewCameraMatrixForUndistortRectify(Mat mat, Mat mat2, Size size, Mat mat3, Mat mat4, double d, Size size2, double d2) {
        Calib3d.estimateNewCameraMatrixForUndistortRectify_0(mat.nativeObj, mat2.nativeObj, size.width, size.height, mat3.nativeObj, mat4.nativeObj, d, size2.width, size2.height, d2);
    }

    public static void estimateNewCameraMatrixForUndistortRectify(Mat mat, Mat mat2, Size size, Mat mat3, Mat mat4) {
        Calib3d.estimateNewCameraMatrixForUndistortRectify_1(mat.nativeObj, mat2.nativeObj, size.width, size.height, mat3.nativeObj, mat4.nativeObj);
    }

    public static void initUndistortRectifyMap(Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, int n, Mat mat5, Mat mat6) {
        Calib3d.initUndistortRectifyMap_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, n, mat5.nativeObj, mat6.nativeObj);
    }

    public static void projectPoints(MatOfPoint3f matOfPoint3f, MatOfPoint2f matOfPoint2f, Mat mat, Mat mat2, Mat mat3, Mat mat4, double d, Mat mat5) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        Calib3d.projectPoints_2(matOfPoint3f2.nativeObj, matOfPoint2f2.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, d, mat5.nativeObj);
    }

    public static void projectPoints(MatOfPoint3f matOfPoint3f, MatOfPoint2f matOfPoint2f, Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        MatOfPoint3f matOfPoint3f2 = matOfPoint3f;
        MatOfPoint2f matOfPoint2f2 = matOfPoint2f;
        Calib3d.projectPoints_3(matOfPoint3f2.nativeObj, matOfPoint2f2.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void stereoRectify(Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11, int n, Size size2, double d, double d2) {
        Calib3d.stereoRectify_2(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, n, size2.width, size2.height, d, d2);
    }

    public static void stereoRectify(Mat mat, Mat mat2, Mat mat3, Mat mat4, Size size, Mat mat5, Mat mat6, Mat mat7, Mat mat8, Mat mat9, Mat mat10, Mat mat11, int n) {
        Calib3d.stereoRectify_3(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, size.width, size.height, mat5.nativeObj, mat6.nativeObj, mat7.nativeObj, mat8.nativeObj, mat9.nativeObj, mat10.nativeObj, mat11.nativeObj, n);
    }

    public static void undistortImage(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Size size) {
        Calib3d.undistortImage_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, size.width, size.height);
    }

    public static void undistortImage(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Calib3d.undistortImage_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    public static void undistortPoints(Mat mat, Mat mat2, Mat mat3, Mat mat4, Mat mat5, Mat mat6) {
        Calib3d.undistortPoints_0(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj, mat6.nativeObj);
    }

    public static void undistortPoints(Mat mat, Mat mat2, Mat mat3, Mat mat4) {
        Calib3d.undistortPoints_1(mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
    }

    private static native long findEssentialMat_0(long var0, long var2, long var4, int var6, double var7, double var9, long var11);

    private static native long findEssentialMat_1(long var0, long var2, long var4, int var6, double var7, double var9);

    private static native long findEssentialMat_2(long var0, long var2, long var4);

    private static native long findEssentialMat_3(long var0, long var2, double var4, double var6, double var8, int var10, double var11, double var13, long var15);

    private static native long findEssentialMat_4(long var0, long var2, double var4, double var6, double var8, int var10, double var11, double var13);

    private static native long findEssentialMat_5(long var0, long var2);

    private static native long findFundamentalMat_0(long var0, long var2, int var4, double var5, double var7, long var9);

    private static native long findFundamentalMat_1(long var0, long var2, int var4, double var5, double var7);

    private static native long findFundamentalMat_2(long var0, long var2);

    private static native long findHomography_0(long var0, long var2, int var4, double var5, long var7, int var9, double var10);

    private static native long findHomography_1(long var0, long var2, int var4, double var5);

    private static native long findHomography_2(long var0, long var2);

    private static native long getOptimalNewCameraMatrix_0(long var0, long var2, double var4, double var6, double var8, double var10, double var12, double[] var14, boolean var15);

    private static native long getOptimalNewCameraMatrix_1(long var0, long var2, double var4, double var6, double var8);

    private static native long initCameraMatrix2D_0(long var0, long var2, double var4, double var6, double var8);

    private static native long initCameraMatrix2D_1(long var0, long var2, double var4, double var6);

    private static native double[] getValidDisparityROI_0(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    private static native double[] RQDecomp3x3_0(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native double[] RQDecomp3x3_1(long var0, long var2, long var4);

    private static native boolean findChessboardCorners_0(long var0, double var2, double var4, long var6, int var8);

    private static native boolean findChessboardCorners_1(long var0, double var2, double var4, long var6);

    private static native boolean findCirclesGrid_0(long var0, double var2, double var4, long var6, int var8);

    private static native boolean findCirclesGrid_1(long var0, double var2, double var4, long var6);

    private static native boolean solvePnP_0(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12, int var13);

    private static native boolean solvePnP_1(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native boolean solvePnPRansac_0(long var0, long var2, long var4, long var6, long var8, long var10, boolean var12, int var13, float var14, double var15, long var17, int var19);

    private static native boolean solvePnPRansac_1(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native boolean stereoRectifyUncalibrated_0(long var0, long var2, long var4, double var6, double var8, long var10, long var12, double var14);

    private static native boolean stereoRectifyUncalibrated_1(long var0, long var2, long var4, double var6, double var8, long var10, long var12);

    private static native double calibrateCamera_0(long var0, long var2, double var4, double var6, long var8, long var10, long var12, long var14, int var16, int var17, int var18, double var19);

    private static native double calibrateCamera_1(long var0, long var2, double var4, double var6, long var8, long var10, long var12, long var14, int var16);

    private static native double calibrateCamera_2(long var0, long var2, double var4, double var6, long var8, long var10, long var12, long var14);

    private static native double sampsonDistance_0(long var0, long var2, long var4);

    private static native double stereoCalibrate_0(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20, long var22, long var24, int var26, int var27, int var28, double var29);

    private static native double stereoCalibrate_1(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20, long var22, long var24, int var26);

    private static native double stereoCalibrate_2(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20, long var22, long var24);

    private static native double calibrate_0(long var0, long var2, double var4, double var6, long var8, long var10, long var12, long var14, int var16, int var17, int var18, double var19);

    private static native double calibrate_1(long var0, long var2, double var4, double var6, long var8, long var10, long var12, long var14, int var16);

    private static native double calibrate_2(long var0, long var2, double var4, double var6, long var8, long var10, long var12, long var14);

    private static native double stereoCalibrate_3(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20, int var22, int var23, int var24, double var25);

    private static native double stereoCalibrate_4(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20, int var22);

    private static native double stereoCalibrate_5(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14, double var16, long var18, long var20);

    private static native float rectify3Collinear_0(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, double var16, double var18, long var20, long var22, long var24, long var26, long var28, long var30, long var32, long var34, long var36, long var38, long var40, double var42, double var44, double var46, double[] var48, double[] var49, int var50);

    private static native int decomposeHomographyMat_0(long var0, long var2, long var4, long var6, long var8);

    private static native int estimateAffine3D_0(long var0, long var2, long var4, long var6, double var8, double var10);

    private static native int estimateAffine3D_1(long var0, long var2, long var4, long var6);

    private static native int recoverPose_0(long var0, long var2, long var4, long var6, long var8, double var10, double var12, double var14, long var16);

    private static native int recoverPose_1(long var0, long var2, long var4, long var6, long var8, double var10, double var12, double var14);

    private static native int recoverPose_2(long var0, long var2, long var4, long var6, long var8);

    private static native int recoverPose_3(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    private static native int recoverPose_4(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void Rodrigues_0(long var0, long var2, long var4);

    private static native void Rodrigues_1(long var0, long var2);

    private static native void calibrationMatrixValues_0(long var0, double var2, double var4, double var6, double var8, double[] var10, double[] var11, double[] var12, double[] var13, double[] var14);

    private static native void composeRT_0(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16, long var18, long var20, long var22, long var24, long var26);

    private static native void composeRT_1(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void computeCorrespondEpilines_0(long var0, int var2, long var3, long var5);

    private static native void convertPointsFromHomogeneous_0(long var0, long var2);

    private static native void convertPointsToHomogeneous_0(long var0, long var2);

    private static native void correctMatches_0(long var0, long var2, long var4, long var6, long var8);

    private static native void decomposeEssentialMat_0(long var0, long var2, long var4, long var6);

    private static native void decomposeProjectionMatrix_0(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    private static native void decomposeProjectionMatrix_1(long var0, long var2, long var4, long var6);

    private static native void drawChessboardCorners_0(long var0, double var2, double var4, long var6, boolean var8);

    private static native void filterSpeckles_0(long var0, double var2, int var4, double var5, long var7);

    private static native void filterSpeckles_1(long var0, double var2, int var4, double var5);

    private static native void matMulDeriv_0(long var0, long var2, long var4, long var6);

    private static native void projectPoints_0(long var0, long var2, long var4, long var6, long var8, long var10, long var12, double var14);

    private static native void projectPoints_1(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void reprojectImageTo3D_0(long var0, long var2, long var4, boolean var6, int var7);

    private static native void reprojectImageTo3D_1(long var0, long var2, long var4, boolean var6);

    private static native void reprojectImageTo3D_2(long var0, long var2, long var4);

    private static native void stereoRectify_0(long var0, long var2, long var4, long var6, double var8, double var10, long var12, long var14, long var16, long var18, long var20, long var22, long var24, int var26, double var27, double var29, double var31, double[] var33, double[] var34);

    private static native void stereoRectify_1(long var0, long var2, long var4, long var6, double var8, double var10, long var12, long var14, long var16, long var18, long var20, long var22, long var24);

    private static native void triangulatePoints_0(long var0, long var2, long var4, long var6, long var8);

    private static native void validateDisparity_0(long var0, long var2, int var4, int var5, int var6);

    private static native void validateDisparity_1(long var0, long var2, int var4, int var5);

    private static native void distortPoints_0(long var0, long var2, long var4, long var6, double var8);

    private static native void distortPoints_1(long var0, long var2, long var4, long var6);

    private static native void estimateNewCameraMatrixForUndistortRectify_0(long var0, long var2, double var4, double var6, long var8, long var10, double var12, double var14, double var16, double var18);

    private static native void estimateNewCameraMatrixForUndistortRectify_1(long var0, long var2, double var4, double var6, long var8, long var10);

    private static native void initUndistortRectifyMap_0(long var0, long var2, long var4, long var6, double var8, double var10, int var12, long var13, long var15);

    private static native void projectPoints_2(long var0, long var2, long var4, long var6, long var8, long var10, double var12, long var14);

    private static native void projectPoints_3(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void stereoRectify_2(long var0, long var2, long var4, long var6, double var8, double var10, long var12, long var14, long var16, long var18, long var20, long var22, long var24, int var26, double var27, double var29, double var31, double var33);

    private static native void stereoRectify_3(long var0, long var2, long var4, long var6, double var8, double var10, long var12, long var14, long var16, long var18, long var20, long var22, long var24, int var26);

    private static native void undistortImage_0(long var0, long var2, long var4, long var6, long var8, double var10, double var12);

    private static native void undistortImage_1(long var0, long var2, long var4, long var6);

    private static native void undistortPoints_0(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void undistortPoints_1(long var0, long var2, long var4, long var6);
}

