/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.hal;

import edu.wpi.first.wpilibj.hal.AllianceStationID;
import edu.wpi.first.wpilibj.hal.ControlWord;
import edu.wpi.first.wpilibj.hal.JNIWrapper;
import java.nio.ByteBuffer;

public class HAL
extends JNIWrapper {
    public static int kMaxJoystickAxes = 12;
    public static int kMaxJoystickPOVs = 12;

    public static native void waitForDSData();

    public static native int initialize(int var0);

    public static native void observeUserProgramStarting();

    public static native void observeUserProgramDisabled();

    public static native void observeUserProgramAutonomous();

    public static native void observeUserProgramTeleop();

    public static native void observeUserProgramTest();

    public static void report(int resource, int instanceNumber) {
        HAL.report(resource, instanceNumber, 0, "");
    }

    public static void report(int resource, int instanceNumber, int context) {
        HAL.report(resource, instanceNumber, context, "");
    }

    public static native int report(int var0, int var1, int var2, String var3);

    private static native int nativeGetControlWord();

    public static void getControlWord(ControlWord controlWord) {
        int word = HAL.nativeGetControlWord();
        controlWord.update((word & 1) != 0, (word >> 1 & 1) != 0, (word >> 2 & 1) != 0, (word >> 3 & 1) != 0, (word >> 4 & 1) != 0, (word >> 5 & 1) != 0);
    }

    private static native int nativeGetAllianceStation();

    public static AllianceStationID getAllianceStation() {
        switch (HAL.nativeGetAllianceStation()) {
            case 0: {
                return AllianceStationID.Red1;
            }
            case 1: {
                return AllianceStationID.Red2;
            }
            case 2: {
                return AllianceStationID.Red3;
            }
            case 3: {
                return AllianceStationID.Blue1;
            }
            case 4: {
                return AllianceStationID.Blue2;
            }
            case 5: {
                return AllianceStationID.Blue3;
            }
        }
        return null;
    }

    public static native short getJoystickAxes(byte var0, float[] var1);

    public static native short getJoystickPOVs(byte var0, short[] var1);

    public static native int getJoystickButtons(byte var0, ByteBuffer var1);

    public static native int setJoystickOutputs(byte var0, int var1, short var2, short var3);

    public static native int getJoystickIsXbox(byte var0);

    public static native int getJoystickType(byte var0);

    public static native String getJoystickName(byte var0);

    public static native int getJoystickAxisType(byte var0, byte var1);

    public static native double getMatchTime();

    public static native boolean getSystemActive();

    public static native boolean getBrownedOut();

    public static native int setErrorData(String var0);

    public static native int sendError(boolean var0, int var1, boolean var2, String var3, String var4, String var5, boolean var6);
}

