/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.command;

import edu.wpi.first.wpilibj.NamedSendable;
import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.command.IllegalUseOfCommandException;
import edu.wpi.first.wpilibj.command.Scheduler;
import edu.wpi.first.wpilibj.tables.ITable;
import java.util.Enumeration;

public abstract class Subsystem
implements NamedSendable {
    private boolean m_initializedDefaultCommand = false;
    private Command m_currentCommand;
    private boolean m_currentCommandChanged;
    private Command m_defaultCommand;
    private String m_name;
    private ITable m_table;

    public Subsystem(String name) {
        this.m_name = name;
        Scheduler.getInstance().registerSubsystem(this);
    }

    public Subsystem() {
        this.m_name = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        Scheduler.getInstance().registerSubsystem(this);
        this.m_currentCommandChanged = true;
    }

    protected abstract void initDefaultCommand();

    protected void setDefaultCommand(Command command) {
        if (command == null) {
            this.m_defaultCommand = null;
        } else {
            boolean found = false;
            Enumeration requirements = command.getRequirements();
            while (requirements.hasMoreElements()) {
                if (!requirements.nextElement().equals(this)) continue;
                found = true;
            }
            if (!found) {
                throw new IllegalUseOfCommandException("A default command must require the subsystem");
            }
            this.m_defaultCommand = command;
        }
        if (this.m_table != null) {
            if (this.m_defaultCommand != null) {
                this.m_table.putBoolean("hasDefault", true);
                this.m_table.putString("default", this.m_defaultCommand.getName());
            } else {
                this.m_table.putBoolean("hasDefault", false);
            }
        }
    }

    protected Command getDefaultCommand() {
        if (!this.m_initializedDefaultCommand) {
            this.m_initializedDefaultCommand = true;
            this.initDefaultCommand();
        }
        return this.m_defaultCommand;
    }

    void setCurrentCommand(Command command) {
        this.m_currentCommand = command;
        this.m_currentCommandChanged = true;
    }

    void confirmCommand() {
        if (this.m_currentCommandChanged) {
            if (this.m_table != null) {
                if (this.m_currentCommand != null) {
                    this.m_table.putBoolean("hasCommand", true);
                    this.m_table.putString("command", this.m_currentCommand.getName());
                } else {
                    this.m_table.putBoolean("hasCommand", false);
                }
            }
            this.m_currentCommandChanged = false;
        }
    }

    public Command getCurrentCommand() {
        return this.m_currentCommand;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getSmartDashboardType() {
        return "Subsystem";
    }

    @Override
    public void initTable(ITable table) {
        this.m_table = table;
        if (table != null) {
            if (this.m_defaultCommand != null) {
                table.putBoolean("hasDefault", true);
                table.putString("default", this.m_defaultCommand.getName());
            } else {
                table.putBoolean("hasDefault", false);
            }
            if (this.m_currentCommand != null) {
                table.putBoolean("hasCommand", true);
                table.putString("command", this.m_currentCommand.getName());
            } else {
                table.putBoolean("hasCommand", false);
            }
        }
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }
}

