/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Counter;
import edu.wpi.first.wpilibj.DigitalInput;
import edu.wpi.first.wpilibj.DigitalOutput;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.PIDSourceType;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;

public class Ultrasonic
extends SensorBase
implements PIDSource,
LiveWindowSendable {
    private static final double kPingTime = 9.999999999999999E-6;
    private static final double kSpeedOfSoundInchesPerSec = 13560.0;
    private static Ultrasonic m_firstSensor = null;
    private static boolean m_automaticEnabled = false;
    private DigitalInput m_echoChannel;
    private DigitalOutput m_pingChannel = null;
    private boolean m_allocatedChannels;
    private boolean m_enabled = false;
    private Counter m_counter = null;
    private Ultrasonic m_nextSensor = null;
    private static Thread m_task = null;
    private Unit m_units;
    private static int m_instances = 0;
    protected PIDSourceType m_pidSource = PIDSourceType.kDisplacement;
    private ITable m_table;

    private synchronized void initialize() {
        if (m_task == null) {
            m_task = new UltrasonicChecker();
        }
        boolean originalMode = m_automaticEnabled;
        this.setAutomaticMode(false);
        this.m_nextSensor = m_firstSensor;
        m_firstSensor = this;
        this.m_counter = new Counter(this.m_echoChannel);
        this.m_counter.setMaxPeriod(1.0);
        this.m_counter.setSemiPeriodMode(true);
        this.m_counter.reset();
        this.m_enabled = true;
        this.setAutomaticMode(originalMode);
        HAL.report(37, ++m_instances);
        LiveWindow.addSensor("Ultrasonic", this.m_echoChannel.getChannel(), (LiveWindowSendable)this);
    }

    public Ultrasonic(int pingChannel, int echoChannel, Unit units) {
        this.m_pingChannel = new DigitalOutput(pingChannel);
        this.m_echoChannel = new DigitalInput(echoChannel);
        this.m_allocatedChannels = true;
        this.m_units = units;
        this.initialize();
    }

    public Ultrasonic(int pingChannel, int echoChannel) {
        this(pingChannel, echoChannel, Unit.kInches);
    }

    public Ultrasonic(DigitalOutput pingChannel, DigitalInput echoChannel, Unit units) {
        if (pingChannel == null || echoChannel == null) {
            throw new NullPointerException("Null Channel Provided");
        }
        this.m_allocatedChannels = false;
        this.m_pingChannel = pingChannel;
        this.m_echoChannel = echoChannel;
        this.m_units = units;
        this.initialize();
    }

    public Ultrasonic(DigitalOutput pingChannel, DigitalInput echoChannel) {
        this(pingChannel, echoChannel, Unit.kInches);
    }

    @Override
    public synchronized void free() {
        boolean wasAutomaticMode = m_automaticEnabled;
        this.setAutomaticMode(false);
        if (this.m_allocatedChannels) {
            if (this.m_pingChannel != null) {
                this.m_pingChannel.free();
            }
            if (this.m_echoChannel != null) {
                this.m_echoChannel.free();
            }
        }
        if (this.m_counter != null) {
            this.m_counter.free();
            this.m_counter = null;
        }
        this.m_pingChannel = null;
        this.m_echoChannel = null;
        if (this == m_firstSensor) {
            m_firstSensor = this.m_nextSensor;
            if (m_firstSensor == null) {
                this.setAutomaticMode(false);
            }
        } else {
            Ultrasonic s = m_firstSensor;
            while (s != null) {
                if (this == s.m_nextSensor) {
                    s.m_nextSensor = s.m_nextSensor.m_nextSensor;
                    break;
                }
                s = s.m_nextSensor;
            }
        }
        if (m_firstSensor != null && wasAutomaticMode) {
            this.setAutomaticMode(true);
        }
    }

    public void setAutomaticMode(boolean enabling) {
        if (enabling == m_automaticEnabled) {
            return;
        }
        m_automaticEnabled = enabling;
        if (enabling) {
            Ultrasonic u = m_firstSensor;
            while (u != null) {
                u.m_counter.reset();
                u = u.m_nextSensor;
            }
            m_task.start();
        } else {
            try {
                m_task.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                ex.printStackTrace();
            }
            Ultrasonic u = m_firstSensor;
            while (u != null) {
                u.m_counter.reset();
                u = u.m_nextSensor;
            }
        }
    }

    public void ping() {
        this.setAutomaticMode(false);
        this.m_counter.reset();
        this.m_pingChannel.pulse(9.999999999999999E-6);
    }

    public boolean isRangeValid() {
        return this.m_counter.get() > 1;
    }

    public double getRangeInches() {
        if (this.isRangeValid()) {
            return this.m_counter.getPeriod() * 13560.0 / 2.0;
        }
        return 0.0;
    }

    public double getRangeMM() {
        return this.getRangeInches() * 25.4;
    }

    @Override
    public void setPIDSourceType(PIDSourceType pidSource) {
        if (!pidSource.equals((Object)PIDSourceType.kDisplacement)) {
            throw new IllegalArgumentException("Only displacement PID is allowed for ultrasonics.");
        }
        this.m_pidSource = pidSource;
    }

    @Override
    public PIDSourceType getPIDSourceType() {
        return this.m_pidSource;
    }

    @Override
    public double pidGet() {
        switch (this.m_units) {
            case kInches: {
                return this.getRangeInches();
            }
            case kMillimeters: {
                return this.getRangeMM();
            }
        }
        return 0.0;
    }

    public void setDistanceUnits(Unit units) {
        this.m_units = units;
    }

    public Unit getDistanceUnits() {
        return this.m_units;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean enable) {
        this.m_enabled = enable;
    }

    @Override
    public String getSmartDashboardType() {
        return "Ultrasonic";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.getRangeInches());
        }
    }

    @Override
    public void startLiveWindowMode() {
    }

    @Override
    public void stopLiveWindowMode() {
    }

    private class UltrasonicChecker
    extends Thread {
        private UltrasonicChecker() {
        }

        @Override
        public synchronized void run() {
            Ultrasonic ultrasonic = null;
            while (m_automaticEnabled) {
                if (ultrasonic == null) {
                    ultrasonic = m_firstSensor;
                }
                if (ultrasonic == null) {
                    return;
                }
                if (ultrasonic.isEnabled()) {
                    ultrasonic.m_pingChannel.pulse(9.999999999999999E-6);
                }
                ultrasonic = ultrasonic.m_nextSensor;
                Timer.delay(0.1);
            }
        }
    }

    public static enum Unit {
        kInches,
        kMillimeters;

    }
}

