/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.SolenoidBase;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.hal.SolenoidJNI;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;

public class Solenoid
extends SolenoidBase
implements LiveWindowSendable {
    private final int m_channel;
    private int m_solenoidHandle;
    private ITable m_table;
    private ITableListener m_tableListener;

    public Solenoid(int channel) {
        this(Solenoid.getDefaultSolenoidModule(), channel);
    }

    public Solenoid(int moduleNumber, int channel) {
        super(moduleNumber);
        this.m_channel = channel;
        Solenoid.checkSolenoidModule(this.m_moduleNumber);
        Solenoid.checkSolenoidChannel(this.m_channel);
        int portHandle = SolenoidJNI.getPortWithModule(this.m_moduleNumber, (byte)this.m_channel);
        this.m_solenoidHandle = SolenoidJNI.initializeSolenoidPort(portHandle);
        LiveWindow.addActuator("Solenoid", this.m_moduleNumber, this.m_channel, this);
        HAL.report(34, this.m_channel, this.m_moduleNumber);
    }

    @Override
    public synchronized void free() {
        SolenoidJNI.freeSolenoidPort(this.m_solenoidHandle);
        this.m_solenoidHandle = 0;
        if (this.m_table != null) {
            this.m_table.removeTableListener(this.m_tableListener);
        }
        super.free();
    }

    public void set(boolean on) {
        SolenoidJNI.setSolenoid(this.m_solenoidHandle, on);
    }

    public boolean get() {
        return SolenoidJNI.getSolenoid(this.m_solenoidHandle);
    }

    public boolean isBlackListed() {
        int value = this.getPCMSolenoidBlackList() & 1 << this.m_channel;
        return value != 0;
    }

    @Override
    public String getSmartDashboardType() {
        return "Solenoid";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putBoolean("Value", this.get());
        }
    }

    @Override
    public void startLiveWindowMode() {
        this.set(false);
        this.m_tableListener = (source, key, value, isNew) -> this.set((Boolean)value);
        this.m_table.addTableListener("Value", this.m_tableListener, true);
    }

    @Override
    public void stopLiveWindowMode() {
        this.set(false);
        this.m_table.removeTableListener(this.m_tableListener);
    }
}

