/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.PWM;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;

public class Servo
extends PWM {
    private static final double kMaxServoAngle = 180.0;
    private static final double kMinServoAngle = 0.0;
    protected static final double kDefaultMaxServoPWM = 2.4;
    protected static final double kDefaultMinServoPWM = 0.6;
    private ITable m_table;
    private ITableListener m_tableListener;

    public Servo(int channel) {
        super(channel);
        this.setBounds(2.4, 0.0, 0.0, 0.0, 0.6);
        this.setPeriodMultiplier(PWM.PeriodMultiplier.k4X);
        LiveWindow.addActuator("Servo", this.getChannel(), (LiveWindowSendable)this);
        HAL.report(33, this.getChannel());
    }

    public void set(double value) {
        this.setPosition(value);
    }

    public double get() {
        return this.getPosition();
    }

    public void setAngle(double degrees) {
        if (degrees < 0.0) {
            degrees = 0.0;
        } else if (degrees > 180.0) {
            degrees = 180.0;
        }
        this.setPosition((degrees - 0.0) / this.getServoAngleRange());
    }

    public double getAngle() {
        return this.getPosition() * this.getServoAngleRange() + 0.0;
    }

    private double getServoAngleRange() {
        return 180.0;
    }

    @Override
    public String getSmartDashboardType() {
        return "Servo";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.get());
        }
    }

    @Override
    public void startLiveWindowMode() {
        this.m_tableListener = new ITableListener(){

            public void valueChanged(ITable itable, String key, Object value, boolean bln) {
                Servo.this.set((Double)value);
            }
        };
        this.m_table.addTableListener("Value", this.m_tableListener, true);
    }

    @Override
    public void stopLiveWindowMode() {
        this.m_table.removeTableListener(this.m_tableListener);
    }
}

