/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.hal.AnalogJNI;
import edu.wpi.first.wpilibj.hal.ConstantsJNI;
import edu.wpi.first.wpilibj.hal.DIOJNI;
import edu.wpi.first.wpilibj.hal.PDPJNI;
import edu.wpi.first.wpilibj.hal.PWMJNI;
import edu.wpi.first.wpilibj.hal.PortsJNI;
import edu.wpi.first.wpilibj.hal.RelayJNI;
import edu.wpi.first.wpilibj.hal.SolenoidJNI;

public abstract class SensorBase {
    public static final int kSystemClockTicksPerMicrosecond = ConstantsJNI.getSystemClockTicksPerMicrosecond();
    public static final int kDigitalChannels = PortsJNI.getNumDigitalChannels();
    public static final int kAnalogInputChannels = PortsJNI.getNumAnalogInputs();
    public static final int kAnalogOutputChannels = PortsJNI.getNumAnalogOutputs();
    public static final int kSolenoidChannels = PortsJNI.getNumSolenoidChannels();
    public static final int kPwmChannels = PortsJNI.getNumPWMChannels();
    public static final int kRelayChannels = PortsJNI.getNumRelayHeaders();
    public static final int kPDPChannels = PortsJNI.getNumPDPChannels();
    public static final int kPDPModules = PortsJNI.getNumPDPModules();
    public static final int kPCMModules = PortsJNI.getNumPCMModules();
    private static int m_defaultSolenoidModule = 0;

    public static void setDefaultSolenoidModule(int moduleNumber) {
        SensorBase.checkSolenoidModule(moduleNumber);
        m_defaultSolenoidModule = moduleNumber;
    }

    protected static void checkSolenoidModule(int moduleNumber) {
        if (!SolenoidJNI.checkSolenoidModule(moduleNumber)) {
            StringBuilder buf = new StringBuilder();
            buf.append("Requested solenoid module is out of range. Minimum: 0, Maximum: ").append(kPCMModules).append(", Requested: ").append(moduleNumber);
            throw new IndexOutOfBoundsException(buf.toString());
        }
    }

    protected static void checkDigitalChannel(int channel) {
        if (!DIOJNI.checkDIOChannel(channel)) {
            StringBuilder buf = new StringBuilder();
            buf.append("Requested DIO channel is out of range. Minimum: 0, Maximum: ").append(kDigitalChannels).append(", Requested: ").append(channel);
            throw new IndexOutOfBoundsException(buf.toString());
        }
    }

    protected static void checkRelayChannel(int channel) {
        if (!RelayJNI.checkRelayChannel(channel)) {
            StringBuilder buf = new StringBuilder();
            buf.append("Requested relay channel is out of range. Minimum: 0, Maximum: ").append(kRelayChannels).append(", Requested: ").append(channel);
            throw new IndexOutOfBoundsException(buf.toString());
        }
    }

    protected static void checkPWMChannel(int channel) {
        if (!PWMJNI.checkPWMChannel(channel)) {
            StringBuilder buf = new StringBuilder();
            buf.append("Requested PWM channel is out of range. Minimum: 0, Maximum: ").append(kPwmChannels).append(", Requested: ").append(channel);
            throw new IndexOutOfBoundsException(buf.toString());
        }
    }

    protected static void checkAnalogInputChannel(int channel) {
        if (!AnalogJNI.checkAnalogInputChannel(channel)) {
            StringBuilder buf = new StringBuilder();
            buf.append("Requested analog input channel is out of range. Minimum: 0, Maximum: ").append(kAnalogInputChannels).append(", Requested: ").append(channel);
            throw new IndexOutOfBoundsException(buf.toString());
        }
    }

    protected static void checkAnalogOutputChannel(int channel) {
        if (!AnalogJNI.checkAnalogOutputChannel(channel)) {
            StringBuilder buf = new StringBuilder();
            buf.append("Requested analog output channel is out of range. Minimum: 0, Maximum: ").append(kAnalogOutputChannels).append(", Requested: ").append(channel);
            throw new IndexOutOfBoundsException(buf.toString());
        }
    }

    protected static void checkSolenoidChannel(int channel) {
        if (!SolenoidJNI.checkSolenoidChannel(channel)) {
            StringBuilder buf = new StringBuilder();
            buf.append("Requested solenoid channel is out of range. Minimum: 0, Maximum: ").append(kSolenoidChannels).append(", Requested: ").append(channel);
            throw new IndexOutOfBoundsException(buf.toString());
        }
    }

    protected static void checkPDPChannel(int channel) {
        if (!PDPJNI.checkPDPChannel(channel)) {
            StringBuilder buf = new StringBuilder();
            buf.append("Requested PDP channel is out of range. Minimum: 0, Maximum: ").append(kPDPChannels).append(", Requested: ").append(channel);
            throw new IndexOutOfBoundsException(buf.toString());
        }
    }

    protected static void checkPDPModule(int module) {
        if (!PDPJNI.checkPDPModule(module)) {
            StringBuilder buf = new StringBuilder();
            buf.append("Requested PDP module is out of range. Minimum: 0, Maximum: ").append(kPDPModules).append(", Requested: ").append(module);
            throw new IndexOutOfBoundsException(buf.toString());
        }
    }

    public static int getDefaultSolenoidModule() {
        return m_defaultSolenoidModule;
    }

    public void free() {
    }
}

