/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AccumulatorResult;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.hal.SPIJNI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SPI
extends SensorBase {
    private static int devices = 0;
    private byte m_port;
    private int m_bitOrder;
    private int m_clockPolarity;
    private int m_dataOnTrailing;

    public SPI(Port port) {
        this.m_port = (byte)port.value;
        SPIJNI.spiInitialize(this.m_port);
        HAL.report(35, ++devices);
    }

    @Override
    public void free() {
        SPIJNI.spiClose(this.m_port);
    }

    public final void setClockRate(int hz) {
        SPIJNI.spiSetSpeed(this.m_port, hz);
    }

    public final void setMSBFirst() {
        this.m_bitOrder = 1;
        SPIJNI.spiSetOpts(this.m_port, this.m_bitOrder, this.m_dataOnTrailing, this.m_clockPolarity);
    }

    public final void setLSBFirst() {
        this.m_bitOrder = 0;
        SPIJNI.spiSetOpts(this.m_port, this.m_bitOrder, this.m_dataOnTrailing, this.m_clockPolarity);
    }

    public final void setClockActiveLow() {
        this.m_clockPolarity = 1;
        SPIJNI.spiSetOpts(this.m_port, this.m_bitOrder, this.m_dataOnTrailing, this.m_clockPolarity);
    }

    public final void setClockActiveHigh() {
        this.m_clockPolarity = 0;
        SPIJNI.spiSetOpts(this.m_port, this.m_bitOrder, this.m_dataOnTrailing, this.m_clockPolarity);
    }

    public final void setSampleDataOnFalling() {
        this.m_dataOnTrailing = 1;
        SPIJNI.spiSetOpts(this.m_port, this.m_bitOrder, this.m_dataOnTrailing, this.m_clockPolarity);
    }

    public final void setSampleDataOnRising() {
        this.m_dataOnTrailing = 0;
        SPIJNI.spiSetOpts(this.m_port, this.m_bitOrder, this.m_dataOnTrailing, this.m_clockPolarity);
    }

    public final void setChipSelectActiveHigh() {
        SPIJNI.spiSetChipSelectActiveHigh(this.m_port);
    }

    public final void setChipSelectActiveLow() {
        SPIJNI.spiSetChipSelectActiveLow(this.m_port);
    }

    public int write(byte[] dataToSend, int size) {
        ByteBuffer dataToSendBuffer = ByteBuffer.allocateDirect(size);
        dataToSendBuffer.put(dataToSend);
        return SPIJNI.spiWrite(this.m_port, dataToSendBuffer, (byte)size);
    }

    public int write(ByteBuffer dataToSend, int size) {
        if (!dataToSend.isDirect()) {
            throw new IllegalArgumentException("must be a direct buffer");
        }
        if (dataToSend.capacity() < size) {
            throw new IllegalArgumentException("buffer is too small, must be at least " + size);
        }
        return SPIJNI.spiWrite(this.m_port, dataToSend, (byte)size);
    }

    public int read(boolean initiate, byte[] dataReceived, int size) {
        ByteBuffer dataReceivedBuffer = ByteBuffer.allocateDirect(size);
        ByteBuffer dataToSendBuffer = ByteBuffer.allocateDirect(size);
        int retVal = initiate ? SPIJNI.spiTransaction(this.m_port, dataToSendBuffer, dataReceivedBuffer, (byte)size) : SPIJNI.spiRead(this.m_port, dataReceivedBuffer, (byte)size);
        dataReceivedBuffer.get(dataReceived);
        return retVal;
    }

    public int read(boolean initiate, ByteBuffer dataReceived, int size) {
        if (!dataReceived.isDirect()) {
            throw new IllegalArgumentException("must be a direct buffer");
        }
        if (dataReceived.capacity() < size) {
            throw new IllegalArgumentException("buffer is too small, must be at least " + size);
        }
        if (initiate) {
            ByteBuffer dataToSendBuffer = ByteBuffer.allocateDirect(size);
            return SPIJNI.spiTransaction(this.m_port, dataToSendBuffer, dataReceived, (byte)size);
        }
        return SPIJNI.spiRead(this.m_port, dataReceived, (byte)size);
    }

    public int transaction(byte[] dataToSend, byte[] dataReceived, int size) {
        ByteBuffer dataToSendBuffer = ByteBuffer.allocateDirect(size);
        dataToSendBuffer.put(dataToSend);
        ByteBuffer dataReceivedBuffer = ByteBuffer.allocateDirect(size);
        int retVal = SPIJNI.spiTransaction(this.m_port, dataToSendBuffer, dataReceivedBuffer, (byte)size);
        dataReceivedBuffer.get(dataReceived);
        return retVal;
    }

    public int transaction(ByteBuffer dataToSend, ByteBuffer dataReceived, int size) {
        if (!dataToSend.isDirect()) {
            throw new IllegalArgumentException("dataToSend must be a direct buffer");
        }
        if (dataToSend.capacity() < size) {
            throw new IllegalArgumentException("dataToSend is too small, must be at least " + size);
        }
        if (!dataReceived.isDirect()) {
            throw new IllegalArgumentException("dataReceived must be a direct buffer");
        }
        if (dataReceived.capacity() < size) {
            throw new IllegalArgumentException("dataReceived is too small, must be at least " + size);
        }
        return SPIJNI.spiTransaction(this.m_port, dataToSend, dataReceived, (byte)size);
    }

    public void initAccumulator(double period, int cmd, int xferSize, int validMask, int validValue, int dataShift, int dataSize, boolean isSigned, boolean bigEndian) {
        SPIJNI.spiInitAccumulator(this.m_port, (int)(period * 1000000.0), cmd, (byte)xferSize, validMask, validValue, (byte)dataShift, (byte)dataSize, isSigned, bigEndian);
    }

    public void freeAccumulator() {
        SPIJNI.spiFreeAccumulator(this.m_port);
    }

    public void resetAccumulator() {
        SPIJNI.spiResetAccumulator(this.m_port);
    }

    public void setAccumulatorCenter(int center) {
        SPIJNI.spiSetAccumulatorCenter(this.m_port, center);
    }

    public void setAccumulatorDeadband(int deadband) {
        SPIJNI.spiSetAccumulatorDeadband(this.m_port, deadband);
    }

    public int getAccumulatorLastValue() {
        return SPIJNI.spiGetAccumulatorLastValue(this.m_port);
    }

    public long getAccumulatorValue() {
        return SPIJNI.spiGetAccumulatorValue(this.m_port);
    }

    public int getAccumulatorCount() {
        return SPIJNI.spiGetAccumulatorCount(this.m_port);
    }

    public double getAccumulatorAverage() {
        return SPIJNI.spiGetAccumulatorAverage(this.m_port);
    }

    public void getAccumulatorOutput(AccumulatorResult result) {
        if (result == null) {
            throw new IllegalArgumentException("Null parameter `result'");
        }
        ByteBuffer value = ByteBuffer.allocateDirect(8);
        value.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer count = ByteBuffer.allocateDirect(8);
        count.order(ByteOrder.LITTLE_ENDIAN);
        SPIJNI.spiGetAccumulatorOutput(this.m_port, value.asLongBuffer(), count.asLongBuffer());
        result.value = value.asLongBuffer().get(0);
        result.count = count.asLongBuffer().get(0);
    }

    public static enum Port {
        kOnboardCS0(0),
        kOnboardCS1(1),
        kOnboardCS2(2),
        kOnboardCS3(3),
        kMXP(4);

        public int value;

        private Port(int value) {
            this.value = value;
        }
    }
}

