/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.MotorSafety;
import edu.wpi.first.wpilibj.MotorSafetyHelper;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.hal.RelayJNI;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import java.util.Objects;

public class Relay
extends SensorBase
implements MotorSafety,
LiveWindowSendable {
    private MotorSafetyHelper m_safetyHelper;
    private final int m_channel;
    private int m_forwardHandle = 0;
    private int m_reverseHandle = 0;
    private Direction m_direction;
    private ITable m_table;
    private ITableListener m_tableListener;

    private void initRelay() {
        SensorBase.checkRelayChannel(this.m_channel);
        int portHandle = RelayJNI.getPort((byte)this.m_channel);
        if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kForward) {
            this.m_forwardHandle = RelayJNI.initializeRelayPort(portHandle, true);
            HAL.report(30, this.m_channel);
        }
        if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kReverse) {
            this.m_reverseHandle = RelayJNI.initializeRelayPort(portHandle, false);
            HAL.report(30, this.m_channel + 128);
        }
        this.m_safetyHelper = new MotorSafetyHelper(this);
        this.m_safetyHelper.setSafetyEnabled(false);
        LiveWindow.addActuator("Relay", this.m_channel, (LiveWindowSendable)this);
    }

    public Relay(int channel, Direction direction) {
        this.m_channel = channel;
        this.m_direction = Objects.requireNonNull(direction, "Null Direction was given");
        this.initRelay();
        this.set(Value.kOff);
    }

    public Relay(int channel) {
        this(channel, Direction.kBoth);
    }

    @Override
    public void free() {
        try {
            RelayJNI.setRelay(this.m_forwardHandle, false);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            RelayJNI.setRelay(this.m_reverseHandle, false);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        RelayJNI.freeRelayPort(this.m_forwardHandle);
        RelayJNI.freeRelayPort(this.m_reverseHandle);
        this.m_forwardHandle = 0;
        this.m_reverseHandle = 0;
    }

    public void set(Value value) {
        switch (value) {
            case kOff: {
                if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kForward) {
                    RelayJNI.setRelay(this.m_forwardHandle, false);
                }
                if (this.m_direction != Direction.kBoth && this.m_direction != Direction.kReverse) break;
                RelayJNI.setRelay(this.m_reverseHandle, false);
                break;
            }
            case kOn: {
                if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kForward) {
                    RelayJNI.setRelay(this.m_forwardHandle, true);
                }
                if (this.m_direction != Direction.kBoth && this.m_direction != Direction.kReverse) break;
                RelayJNI.setRelay(this.m_reverseHandle, true);
                break;
            }
            case kForward: {
                if (this.m_direction == Direction.kReverse) {
                    throw new InvalidValueException("A relay configured for reverse cannot be set to forward");
                }
                if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kForward) {
                    RelayJNI.setRelay(this.m_forwardHandle, true);
                }
                if (this.m_direction != Direction.kBoth) break;
                RelayJNI.setRelay(this.m_reverseHandle, false);
                break;
            }
            case kReverse: {
                if (this.m_direction == Direction.kForward) {
                    throw new InvalidValueException("A relay configured for forward cannot be set to reverse");
                }
                if (this.m_direction == Direction.kBoth) {
                    RelayJNI.setRelay(this.m_forwardHandle, false);
                }
                if (this.m_direction != Direction.kBoth && this.m_direction != Direction.kReverse) break;
                RelayJNI.setRelay(this.m_reverseHandle, true);
                break;
            }
        }
    }

    public Value get() {
        if (RelayJNI.getRelay(this.m_forwardHandle)) {
            if (RelayJNI.getRelay(this.m_reverseHandle)) {
                return Value.kOn;
            }
            if (this.m_direction == Direction.kForward) {
                return Value.kOn;
            }
            return Value.kForward;
        }
        if (RelayJNI.getRelay(this.m_reverseHandle)) {
            if (this.m_direction == Direction.kReverse) {
                return Value.kOn;
            }
            return Value.kReverse;
        }
        return Value.kOff;
    }

    public int getChannel() {
        return this.m_channel;
    }

    @Override
    public void setExpiration(double timeout) {
        this.m_safetyHelper.setExpiration(timeout);
    }

    @Override
    public double getExpiration() {
        return this.m_safetyHelper.getExpiration();
    }

    @Override
    public boolean isAlive() {
        return this.m_safetyHelper.isAlive();
    }

    @Override
    public void stopMotor() {
        this.set(Value.kOff);
    }

    @Override
    public boolean isSafetyEnabled() {
        return this.m_safetyHelper.isSafetyEnabled();
    }

    @Override
    public void setSafetyEnabled(boolean enabled) {
        this.m_safetyHelper.setSafetyEnabled(enabled);
    }

    @Override
    public String getDescription() {
        return "Relay ID " + this.getChannel();
    }

    public void setDirection(Direction direction) {
        if (direction == null) {
            throw new NullPointerException("Null Direction was given");
        }
        if (this.m_direction == direction) {
            return;
        }
        this.free();
        this.m_direction = direction;
        this.initRelay();
    }

    @Override
    public String getSmartDashboardType() {
        return "Relay";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            if (this.get() == Value.kOn) {
                this.m_table.putString("Value", "On");
            } else if (this.get() == Value.kForward) {
                this.m_table.putString("Value", "Forward");
            } else if (this.get() == Value.kReverse) {
                this.m_table.putString("Value", "Reverse");
            } else {
                this.m_table.putString("Value", "Off");
            }
        }
    }

    @Override
    public void startLiveWindowMode() {
        this.m_tableListener = new ITableListener(){

            public void valueChanged(ITable itable, String key, Object value, boolean bln) {
                String val = (String)value;
                if (val.equals("Off")) {
                    Relay.this.set(Value.kOff);
                } else if (val.equals("On")) {
                    Relay.this.set(Value.kOn);
                } else if (val.equals("Forward")) {
                    Relay.this.set(Value.kForward);
                } else if (val.equals("Reverse")) {
                    Relay.this.set(Value.kReverse);
                }
            }
        };
        this.m_table.addTableListener("Value", this.m_tableListener, true);
    }

    @Override
    public void stopLiveWindowMode() {
        this.m_table.removeTableListener(this.m_tableListener);
    }

    public static enum Direction {
        kBoth,
        kForward,
        kReverse;

    }

    public static enum Value {
        kOff,
        kOn,
        kForward,
        kReverse;

    }

    public class InvalidValueException
    extends RuntimeException {
        public InvalidValueException(String message) {
            super(message);
        }
    }
}

