/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.networktables.NetworkTable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import edu.wpi.first.wpilibj.tables.TableKeyNotDefinedException;
import java.util.Vector;

public class Preferences {
    private static final String TABLE_NAME = "Preferences";
    private static Preferences instance;
    private final NetworkTable m_table;
    private final ITableListener m_listener = new ITableListener(){

        public void valueChanged(ITable table, String key, Object value, boolean isNew) {
        }

        public void valueChangedEx(ITable table, String key, Object value, int flags) {
            table.setPersistent(key);
        }
    };

    public static synchronized Preferences getInstance() {
        if (instance == null) {
            instance = new Preferences();
        }
        return instance;
    }

    private Preferences() {
        this.m_table = NetworkTable.getTable((String)TABLE_NAME);
        this.m_table.addTableListenerEx(this.m_listener, 5);
        HAL.report(28, 0);
    }

    public Vector getKeys() {
        Vector<String> keys = new Vector<String>();
        for (String key : this.m_table.getKeys()) {
            keys.add(key);
        }
        return keys;
    }

    public void putString(String key, String value) {
        if (value == null) {
            throw new NullPointerException("Value is null");
        }
        this.m_table.putString(key, value);
        this.m_table.setPersistent(key);
    }

    public void putInt(String key, int value) {
        this.m_table.putNumber(key, (double)value);
        this.m_table.setPersistent(key);
    }

    public void putDouble(String key, double value) {
        this.m_table.putNumber(key, value);
        this.m_table.setPersistent(key);
    }

    public void putFloat(String key, float value) {
        this.m_table.putNumber(key, (double)value);
        this.m_table.setPersistent(key);
    }

    public void putBoolean(String key, boolean value) {
        this.m_table.putBoolean(key, value);
        this.m_table.setPersistent(key);
    }

    public void putLong(String key, long value) {
        this.m_table.putNumber(key, (double)value);
        this.m_table.setPersistent(key);
    }

    public boolean containsKey(String key) {
        return this.m_table.containsKey(key);
    }

    public void remove(String key) {
        this.m_table.delete(key);
    }

    public String getString(String key, String backup) {
        return this.m_table.getString(key, backup);
    }

    public int getInt(String key, int backup) {
        try {
            return (int)this.m_table.getNumber(key);
        }
        catch (TableKeyNotDefinedException ex) {
            return backup;
        }
    }

    public double getDouble(String key, double backup) {
        return this.m_table.getDouble(key, backup);
    }

    public boolean getBoolean(String key, boolean backup) {
        return this.m_table.getBoolean(key, backup);
    }

    public float getFloat(String key, float backup) {
        try {
            return (float)this.m_table.getNumber(key);
        }
        catch (TableKeyNotDefinedException ex) {
            return backup;
        }
    }

    public long getLong(String key, long backup) {
        try {
            return (long)this.m_table.getNumber(key);
        }
        catch (TableKeyNotDefinedException ex) {
            return backup;
        }
    }

    @Deprecated
    public void save() {
    }
}

