/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.GenericHID;
import edu.wpi.first.wpilibj.JoystickBase;
import edu.wpi.first.wpilibj.hal.HAL;

public class Joystick
extends JoystickBase {
    static final byte kDefaultXAxis = 0;
    static final byte kDefaultYAxis = 1;
    static final byte kDefaultZAxis = 2;
    static final byte kDefaultTwistAxis = 2;
    static final byte kDefaultThrottleAxis = 3;
    static final int kDefaultTriggerButton = 1;
    static final int kDefaultTopButton = 2;
    private final DriverStation m_ds = DriverStation.getInstance();
    private final byte[] m_axes;
    private final byte[] m_buttons;
    private int m_outputs;
    private short m_leftRumble;
    private short m_rightRumble;

    public Joystick(int port) {
        this(port, AxisType.kNumAxis.value, ButtonType.kNumButton.value);
        this.m_axes[AxisType.kX.value] = 0;
        this.m_axes[AxisType.kY.value] = 1;
        this.m_axes[AxisType.kZ.value] = 2;
        this.m_axes[AxisType.kTwist.value] = 2;
        this.m_axes[AxisType.kThrottle.value] = 3;
        this.m_buttons[ButtonType.kTrigger.value] = 1;
        this.m_buttons[ButtonType.kTop.value] = 2;
        HAL.report(24, port);
    }

    protected Joystick(int port, int numAxisTypes, int numButtonTypes) {
        super(port);
        this.m_axes = new byte[numAxisTypes];
        this.m_buttons = new byte[numButtonTypes];
    }

    @Override
    public final double getX(GenericHID.Hand hand) {
        return this.getRawAxis(this.m_axes[AxisType.kX.value]);
    }

    @Override
    public final double getY(GenericHID.Hand hand) {
        return this.getRawAxis(this.m_axes[AxisType.kY.value]);
    }

    @Override
    public final double getZ(GenericHID.Hand hand) {
        return this.getRawAxis(this.m_axes[AxisType.kZ.value]);
    }

    @Override
    public double getTwist() {
        return this.getRawAxis(this.m_axes[AxisType.kTwist.value]);
    }

    @Override
    public double getThrottle() {
        return this.getRawAxis(this.m_axes[AxisType.kThrottle.value]);
    }

    @Override
    public double getRawAxis(int axis) {
        return this.m_ds.getStickAxis(this.getPort(), axis);
    }

    public double getAxis(AxisType axis) {
        switch (axis) {
            case kX: {
                return this.getX();
            }
            case kY: {
                return this.getY();
            }
            case kZ: {
                return this.getZ();
            }
            case kTwist: {
                return this.getTwist();
            }
            case kThrottle: {
                return this.getThrottle();
            }
        }
        return 0.0;
    }

    public int getAxisCount() {
        return this.m_ds.getStickAxisCount(this.getPort());
    }

    @Override
    public boolean getTrigger(GenericHID.Hand hand) {
        return this.getRawButton(this.m_buttons[ButtonType.kTrigger.value]);
    }

    @Override
    public boolean getTop(GenericHID.Hand hand) {
        return this.getRawButton(this.m_buttons[ButtonType.kTop.value]);
    }

    @Override
    public int getPOV(int pov) {
        return this.m_ds.getStickPOV(this.getPort(), pov);
    }

    @Override
    public int getPOVCount() {
        return this.m_ds.getStickPOVCount(this.getPort());
    }

    public boolean getBumper(GenericHID.Hand hand) {
        return false;
    }

    @Override
    public boolean getRawButton(int button) {
        return this.m_ds.getStickButton(this.getPort(), (byte)button);
    }

    public int getButtonCount() {
        return this.m_ds.getStickButtonCount(this.getPort());
    }

    public boolean getButton(ButtonType button) {
        switch (button) {
            case kTrigger: {
                return this.getTrigger();
            }
            case kTop: {
                return this.getTop();
            }
        }
        return false;
    }

    public double getMagnitude() {
        return Math.sqrt(Math.pow(this.getX(), 2.0) + Math.pow(this.getY(), 2.0));
    }

    public double getDirectionRadians() {
        return Math.atan2(this.getX(), -this.getY());
    }

    public double getDirectionDegrees() {
        return Math.toDegrees(this.getDirectionRadians());
    }

    public int getAxisChannel(AxisType axis) {
        return this.m_axes[axis.value];
    }

    public void setAxisChannel(AxisType axis, int channel) {
        this.m_axes[axis.value] = (byte)channel;
    }

    public boolean getIsXbox() {
        return this.m_ds.getJoystickIsXbox(this.getPort());
    }

    public int getAxisType(int axis) {
        return this.m_ds.getJoystickAxisType(this.getPort(), axis);
    }

    @Override
    public GenericHID.HIDType getType() {
        return GenericHID.HIDType.values()[this.m_ds.getJoystickType(this.getPort())];
    }

    @Override
    public String getName() {
        return this.m_ds.getJoystickName(this.getPort());
    }

    @Override
    public void setOutput(int outputNumber, boolean value) {
        this.m_outputs = this.m_outputs & ~(1 << outputNumber - 1) | (value ? 1 : 0) << outputNumber - 1;
        HAL.setJoystickOutputs((byte)this.getPort(), this.m_outputs, this.m_leftRumble, this.m_rightRumble);
    }

    @Override
    public void setOutputs(int value) {
        this.m_outputs = value;
        HAL.setJoystickOutputs((byte)this.getPort(), this.m_outputs, this.m_leftRumble, this.m_rightRumble);
    }

    @Override
    public void setRumble(GenericHID.RumbleType type, double value) {
        if (value < 0.0) {
            value = 0.0;
        } else if (value > 1.0) {
            value = 1.0;
        }
        if (type == GenericHID.RumbleType.kLeftRumble) {
            this.m_leftRumble = (short)(value * 65535.0);
        } else {
            this.m_rightRumble = (short)(value * 65535.0);
        }
        HAL.setJoystickOutputs((byte)this.getPort(), this.m_outputs, this.m_leftRumble, this.m_rightRumble);
    }

    public static enum ButtonType {
        kTrigger(0),
        kTop(1),
        kNumButton(2);

        public final int value;

        private ButtonType(int value) {
            this.value = value;
        }
    }

    public static enum AxisType {
        kX(0),
        kY(1),
        kZ(2),
        kTwist(3),
        kThrottle(4),
        kNumAxis(5);

        public final int value;

        private AxisType(int value) {
            this.value = value;
        }
    }
}

