/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.RobotBase;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;

public class IterativeRobot
extends RobotBase {
    private boolean m_disabledInitialized = false;
    private boolean m_autonomousInitialized = false;
    private boolean m_teleopInitialized = false;
    private boolean m_testInitialized = false;
    private boolean m_rpFirstRun = true;
    private boolean m_dpFirstRun = true;
    private boolean m_apFirstRun = true;
    private boolean m_tpFirstRun = true;
    private boolean m_tmpFirstRun = true;

    @Override
    public void startCompetition() {
        HAL.report(22, 1);
        this.robotInit();
        HAL.observeUserProgramStarting();
        LiveWindow.setEnabled(false);
        while (true) {
            this.m_ds.waitForData();
            if (this.isDisabled()) {
                if (!this.m_disabledInitialized) {
                    LiveWindow.setEnabled(false);
                    this.disabledInit();
                    this.m_disabledInitialized = true;
                    this.m_autonomousInitialized = false;
                    this.m_teleopInitialized = false;
                    this.m_testInitialized = false;
                }
                HAL.observeUserProgramDisabled();
                this.disabledPeriodic();
            } else if (this.isTest()) {
                if (!this.m_testInitialized) {
                    LiveWindow.setEnabled(true);
                    this.testInit();
                    this.m_testInitialized = true;
                    this.m_autonomousInitialized = false;
                    this.m_teleopInitialized = false;
                    this.m_disabledInitialized = false;
                }
                HAL.observeUserProgramTest();
                this.testPeriodic();
            } else if (this.isAutonomous()) {
                if (!this.m_autonomousInitialized) {
                    LiveWindow.setEnabled(false);
                    this.autonomousInit();
                    this.m_autonomousInitialized = true;
                    this.m_testInitialized = false;
                    this.m_teleopInitialized = false;
                    this.m_disabledInitialized = false;
                }
                HAL.observeUserProgramAutonomous();
                this.autonomousPeriodic();
            } else {
                if (!this.m_teleopInitialized) {
                    LiveWindow.setEnabled(false);
                    this.teleopInit();
                    this.m_teleopInitialized = true;
                    this.m_testInitialized = false;
                    this.m_autonomousInitialized = false;
                    this.m_disabledInitialized = false;
                }
                HAL.observeUserProgramTeleop();
                this.teleopPeriodic();
            }
            this.robotPeriodic();
        }
    }

    public void robotInit() {
        System.out.println("Default IterativeRobot.robotInit() method... Overload me!");
    }

    public void disabledInit() {
        System.out.println("Default IterativeRobot.disabledInit() method... Overload me!");
    }

    public void autonomousInit() {
        System.out.println("Default IterativeRobot.autonomousInit() method... Overload me!");
    }

    public void teleopInit() {
        System.out.println("Default IterativeRobot.teleopInit() method... Overload me!");
    }

    public void testInit() {
        System.out.println("Default IterativeRobot.testInit() method... Overload me!");
    }

    public void robotPeriodic() {
        if (this.m_rpFirstRun) {
            System.out.println("Default IterativeRobot.robotPeriodic() method... Overload me!");
            this.m_rpFirstRun = false;
        }
    }

    public void disabledPeriodic() {
        if (this.m_dpFirstRun) {
            System.out.println("Default IterativeRobot.disabledPeriodic() method... Overload me!");
            this.m_dpFirstRun = false;
        }
    }

    public void autonomousPeriodic() {
        if (this.m_apFirstRun) {
            System.out.println("Default IterativeRobot.autonomousPeriodic() method... Overload me!");
            this.m_apFirstRun = false;
        }
    }

    public void teleopPeriodic() {
        if (this.m_tpFirstRun) {
            System.out.println("Default IterativeRobot.teleopPeriodic() method... Overload me!");
            this.m_tpFirstRun = false;
        }
    }

    public void testPeriodic() {
        if (this.m_tmpFirstRun) {
            System.out.println("Default IterativeRobot.testPeriodic() method... Overload me!");
            this.m_tmpFirstRun = false;
        }
    }
}

