/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.PIDSourceType;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.interfaces.Gyro;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;

public abstract class GyroBase
extends SensorBase
implements Gyro,
PIDSource,
LiveWindowSendable {
    private PIDSourceType m_pidSource = PIDSourceType.kDisplacement;
    private ITable m_table;

    @Override
    public void setPIDSourceType(PIDSourceType pidSource) {
        this.m_pidSource = pidSource;
    }

    @Override
    public PIDSourceType getPIDSourceType() {
        return this.m_pidSource;
    }

    @Override
    public double pidGet() {
        switch (this.m_pidSource) {
            case kRate: {
                return this.getRate();
            }
            case kDisplacement: {
                return this.getAngle();
            }
        }
        return 0.0;
    }

    @Override
    public String getSmartDashboardType() {
        return "Gyro";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.getAngle());
        }
    }

    @Override
    public void startLiveWindowMode() {
    }

    @Override
    public void stopLiveWindowMode() {
    }
}

