/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.SolenoidBase;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.hal.SolenoidJNI;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;

public class DoubleSolenoid
extends SolenoidBase
implements LiveWindowSendable {
    private byte m_forwardMask;
    private byte m_reverseMask;
    private int m_forwardHandle = 0;
    private int m_reverseHandle = 0;
    private ITable m_table;
    private ITableListener m_tableListener;

    public DoubleSolenoid(int forwardChannel, int reverseChannel) {
        this(DoubleSolenoid.getDefaultSolenoidModule(), forwardChannel, reverseChannel);
    }

    public DoubleSolenoid(int moduleNumber, int forwardChannel, int reverseChannel) {
        super(moduleNumber);
        DoubleSolenoid.checkSolenoidModule(this.m_moduleNumber);
        DoubleSolenoid.checkSolenoidChannel(forwardChannel);
        DoubleSolenoid.checkSolenoidChannel(reverseChannel);
        int portHandle = SolenoidJNI.getPortWithModule(this.m_moduleNumber, (byte)forwardChannel);
        this.m_forwardHandle = SolenoidJNI.initializeSolenoidPort(portHandle);
        try {
            portHandle = SolenoidJNI.getPortWithModule(this.m_moduleNumber, (byte)reverseChannel);
            this.m_reverseHandle = SolenoidJNI.initializeSolenoidPort(portHandle);
        }
        catch (RuntimeException ex) {
            SolenoidJNI.freeSolenoidPort(this.m_forwardHandle);
            this.m_forwardHandle = 0;
            this.m_reverseHandle = 0;
            throw ex;
        }
        this.m_forwardMask = (byte)(1 << forwardChannel);
        this.m_reverseMask = (byte)(1 << reverseChannel);
        HAL.report(34, forwardChannel, this.m_moduleNumber);
        HAL.report(34, reverseChannel, this.m_moduleNumber);
        LiveWindow.addActuator("DoubleSolenoid", this.m_moduleNumber, forwardChannel, this);
    }

    @Override
    public synchronized void free() {
        SolenoidJNI.freeSolenoidPort(this.m_forwardHandle);
        SolenoidJNI.freeSolenoidPort(this.m_reverseHandle);
        super.free();
    }

    public void set(Value value) {
        boolean forward = false;
        boolean reverse = false;
        switch (value) {
            case kOff: {
                forward = false;
                reverse = false;
                break;
            }
            case kForward: {
                forward = true;
                reverse = false;
                break;
            }
            case kReverse: {
                forward = false;
                reverse = true;
                break;
            }
            default: {
                throw new AssertionError((Object)("Illegal value: " + (Object)((Object)value)));
            }
        }
        SolenoidJNI.setSolenoid(this.m_forwardHandle, forward);
        SolenoidJNI.setSolenoid(this.m_reverseHandle, reverse);
    }

    public Value get() {
        boolean valueForward = SolenoidJNI.getSolenoid(this.m_forwardHandle);
        boolean valueReverse = SolenoidJNI.getSolenoid(this.m_reverseHandle);
        if (valueForward) {
            return Value.kForward;
        }
        if (valueReverse) {
            return Value.kReverse;
        }
        return Value.kOff;
    }

    public boolean isFwdSolenoidBlackListed() {
        byte blackList = this.getPCMSolenoidBlackList();
        return (blackList & this.m_forwardMask) != 0;
    }

    public boolean isRevSolenoidBlackListed() {
        byte blackList = this.getPCMSolenoidBlackList();
        return (blackList & this.m_reverseMask) != 0;
    }

    @Override
    public String getSmartDashboardType() {
        return "Double Solenoid";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putString("Value", this.get().name().substring(1));
        }
    }

    @Override
    public void startLiveWindowMode() {
        this.set(Value.kOff);
        this.m_tableListener = (source, key, value, isNew) -> {
            if ("Reverse".equals(value.toString())) {
                this.set(Value.kReverse);
            } else if ("Forward".equals(value.toString())) {
                this.set(Value.kForward);
            } else {
                this.set(Value.kOff);
            }
        };
        this.m_table.addTableListener("Value", this.m_tableListener, true);
    }

    @Override
    public void stopLiveWindowMode() {
        this.set(Value.kOff);
        this.m_table.removeTableListener(this.m_tableListener);
    }

    public static enum Value {
        kOff,
        kForward,
        kReverse;

    }
}

