/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DigitalSource;
import edu.wpi.first.wpilibj.hal.DIOJNI;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;

public class DigitalInput
extends DigitalSource
implements LiveWindowSendable {
    private int m_channel = 0;
    private int m_handle = 0;
    private ITable m_table;

    public DigitalInput(int channel) {
        DigitalInput.checkDigitalChannel(channel);
        this.m_channel = channel;
        this.m_handle = DIOJNI.initializeDIOPort(DIOJNI.getPort((byte)channel), true);
        LiveWindow.addSensor("DigitalInput", channel, (LiveWindowSendable)this);
        HAL.report(13, channel);
    }

    @Override
    public void free() {
        if (this.m_interrupt != 0) {
            this.cancelInterrupts();
        }
        DIOJNI.freeDIOPort(this.m_handle);
    }

    public boolean get() {
        return DIOJNI.getDIO(this.m_handle);
    }

    @Override
    public int getChannel() {
        return this.m_channel;
    }

    @Override
    public int getAnalogTriggerTypeForRouting() {
        return 0;
    }

    @Override
    public boolean isAnalogTrigger() {
        return false;
    }

    @Override
    public int getPortHandleForRouting() {
        return this.m_handle;
    }

    @Override
    public String getSmartDashboardType() {
        return "Digital Input";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putBoolean("Value", this.get());
        }
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void startLiveWindowMode() {
    }

    @Override
    public void stopLiveWindowMode() {
    }
}

