/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.hal.CompressorJNI;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;

public class Compressor
extends SensorBase
implements LiveWindowSendable {
    private int m_compressorHandle;
    private byte m_module;
    private ITable m_table = null;

    public Compressor(int module) {
        this.m_module = (byte)module;
        this.m_compressorHandle = CompressorJNI.initializeCompressor((byte)module);
    }

    public Compressor() {
        this(Compressor.getDefaultSolenoidModule());
    }

    public void start() {
        this.setClosedLoopControl(true);
    }

    public void stop() {
        this.setClosedLoopControl(false);
    }

    public boolean enabled() {
        return CompressorJNI.getCompressor(this.m_compressorHandle);
    }

    public boolean getPressureSwitchValue() {
        return CompressorJNI.getCompressorPressureSwitch(this.m_compressorHandle);
    }

    public double getCompressorCurrent() {
        return CompressorJNI.getCompressorCurrent(this.m_compressorHandle);
    }

    public void setClosedLoopControl(boolean on) {
        CompressorJNI.setCompressorClosedLoopControl(this.m_compressorHandle, on);
    }

    public boolean getClosedLoopControl() {
        return CompressorJNI.getCompressorClosedLoopControl(this.m_compressorHandle);
    }

    public boolean getCompressorCurrentTooHighFault() {
        return CompressorJNI.getCompressorCurrentTooHighFault(this.m_compressorHandle);
    }

    public boolean getCompressorCurrentTooHighStickyFault() {
        return CompressorJNI.getCompressorCurrentTooHighStickyFault(this.m_compressorHandle);
    }

    public boolean getCompressorShortedStickyFault() {
        return CompressorJNI.getCompressorShortedStickyFault(this.m_compressorHandle);
    }

    public boolean getCompressorShortedFault() {
        return CompressorJNI.getCompressorShortedFault(this.m_compressorHandle);
    }

    public boolean getCompressorNotConnectedStickyFault() {
        return CompressorJNI.getCompressorNotConnectedStickyFault(this.m_compressorHandle);
    }

    public boolean getCompressorNotConnectedFault() {
        return CompressorJNI.getCompressorNotConnectedFault(this.m_compressorHandle);
    }

    public void clearAllPCMStickyFaults() {
        CompressorJNI.clearAllPCMStickyFaults(this.m_module);
    }

    @Override
    public void startLiveWindowMode() {
    }

    @Override
    public void stopLiveWindowMode() {
    }

    @Override
    public String getSmartDashboardType() {
        return "Compressor";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putBoolean("Enabled", this.enabled());
            this.m_table.putBoolean("Pressure Switch", this.getPressureSwitchValue());
        }
    }
}

