/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AnalogInput;
import edu.wpi.first.wpilibj.AnalogTriggerOutput;
import edu.wpi.first.wpilibj.hal.AnalogJNI;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.util.BoundaryException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class AnalogTrigger {
    protected int m_port;
    protected int m_index;
    protected AnalogInput m_analogInput = null;
    protected boolean m_ownsAnalog = false;

    public AnalogTrigger(int channel) {
        this(new AnalogInput(channel));
        this.m_ownsAnalog = true;
    }

    public AnalogTrigger(AnalogInput channel) {
        this.m_analogInput = channel;
        ByteBuffer index = ByteBuffer.allocateDirect(4);
        index.order(ByteOrder.LITTLE_ENDIAN);
        this.m_port = AnalogJNI.initializeAnalogTrigger(channel.m_port, index.asIntBuffer());
        this.m_index = index.asIntBuffer().get(0);
        HAL.report(7, channel.getChannel());
    }

    public void free() {
        AnalogJNI.cleanAnalogTrigger(this.m_port);
        this.m_port = 0;
        if (this.m_ownsAnalog && this.m_analogInput != null) {
            this.m_analogInput.free();
        }
    }

    public void setLimitsRaw(int lower, int upper) {
        if (lower > upper) {
            throw new BoundaryException("Lower bound is greater than upper");
        }
        AnalogJNI.setAnalogTriggerLimitsRaw(this.m_port, lower, upper);
    }

    public void setLimitsVoltage(double lower, double upper) {
        if (lower > upper) {
            throw new BoundaryException("Lower bound is greater than upper bound");
        }
        AnalogJNI.setAnalogTriggerLimitsVoltage(this.m_port, lower, upper);
    }

    public void setAveraged(boolean useAveragedValue) {
        AnalogJNI.setAnalogTriggerAveraged(this.m_port, useAveragedValue);
    }

    public void setFiltered(boolean useFilteredValue) {
        AnalogJNI.setAnalogTriggerFiltered(this.m_port, useFilteredValue);
    }

    public int getIndex() {
        return this.m_index;
    }

    public boolean getInWindow() {
        return AnalogJNI.getAnalogTriggerInWindow(this.m_port);
    }

    public boolean getTriggerState() {
        return AnalogJNI.getAnalogTriggerTriggerState(this.m_port);
    }

    public AnalogTriggerOutput createOutput(AnalogTriggerOutput.AnalogTriggerType type) {
        return new AnalogTriggerOutput(this, type);
    }

    public class AnalogTriggerException
    extends RuntimeException {
        public AnalogTriggerException(String message) {
            super(message);
        }
    }
}

