/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.hal.AnalogJNI;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;

public class AnalogOutput
extends SensorBase
implements LiveWindowSendable {
    private int m_port;
    private int m_channel;
    private ITable m_table;

    public AnalogOutput(int channel) {
        this.m_channel = channel;
        SensorBase.checkAnalogOutputChannel(channel);
        int portHandle = AnalogJNI.getPort((byte)channel);
        this.m_port = AnalogJNI.initializeAnalogOutputPort(portHandle);
        LiveWindow.addSensor("AnalogOutput", channel, (LiveWindowSendable)this);
        HAL.report(49, channel);
    }

    @Override
    public void free() {
        AnalogJNI.freeAnalogOutputPort(this.m_port);
        this.m_port = 0;
        this.m_channel = 0;
    }

    public int getChannel() {
        return this.m_channel;
    }

    public void setVoltage(double voltage) {
        AnalogJNI.setAnalogOutput(this.m_port, voltage);
    }

    public double getVoltage() {
        return AnalogJNI.getAnalogOutput(this.m_port);
    }

    @Override
    public String getSmartDashboardType() {
        return "Analog Output";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("Value", this.getVoltage());
        }
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void startLiveWindowMode() {
    }

    @Override
    public void stopLiveWindowMode() {
    }
}

