/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.SPI;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.hal.HAL;
import edu.wpi.first.wpilibj.interfaces.Accelerometer;
import edu.wpi.first.wpilibj.livewindow.LiveWindow;
import edu.wpi.first.wpilibj.livewindow.LiveWindowSendable;
import edu.wpi.first.wpilibj.tables.ITable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ADXL362
extends SensorBase
implements Accelerometer,
LiveWindowSendable {
    private static final byte kRegWrite = 10;
    private static final byte kRegRead = 11;
    private static final byte kPartIdRegister = 2;
    private static final byte kDataRegister = 14;
    private static final byte kFilterCtlRegister = 44;
    private static final byte kPowerCtlRegister = 45;
    private static final byte kFilterCtl_Range2G = 0;
    private static final byte kFilterCtl_Range4G = 64;
    private static final byte kFilterCtl_Range8G = -128;
    private static final byte kFilterCtl_ODR_100Hz = 3;
    private static final byte kPowerCtl_UltraLowNoise = 32;
    private static final byte kPowerCtl_AutoSleep = 4;
    private static final byte kPowerCtl_Measure = 2;
    private SPI m_spi;
    private double m_gsPerLSB;
    private ITable m_table;

    public ADXL362(Accelerometer.Range range) {
        this(SPI.Port.kOnboardCS1, range);
    }

    public ADXL362(SPI.Port port, Accelerometer.Range range) {
        this.m_spi = new SPI(port);
        this.m_spi.setClockRate(3000000);
        this.m_spi.setMSBFirst();
        this.m_spi.setSampleDataOnFalling();
        this.m_spi.setClockActiveLow();
        this.m_spi.setChipSelectActiveLow();
        ByteBuffer transferBuffer = ByteBuffer.allocateDirect(3);
        transferBuffer.put(0, (byte)11);
        transferBuffer.put(1, (byte)2);
        this.m_spi.transaction(transferBuffer, transferBuffer, 3);
        if (transferBuffer.get(2) != -14) {
            this.m_spi.free();
            this.m_spi = null;
            DriverStation.reportError("could not find ADXL362 on SPI port " + port.value, false);
            return;
        }
        this.setRange(range);
        transferBuffer.put(0, (byte)10);
        transferBuffer.put(1, (byte)45);
        transferBuffer.put(2, (byte)34);
        this.m_spi.write(transferBuffer, 3);
        HAL.report(53, port.value);
        LiveWindow.addSensor("ADXL362", port.value, (LiveWindowSendable)this);
    }

    @Override
    public void free() {
        this.m_spi.free();
    }

    @Override
    public void setRange(Accelerometer.Range range) {
        int value;
        switch (range) {
            case k2G: {
                value = 0;
                this.m_gsPerLSB = 0.001;
                break;
            }
            case k4G: {
                value = 64;
                this.m_gsPerLSB = 0.002;
                break;
            }
            case k8G: 
            case k16G: {
                value = -128;
                this.m_gsPerLSB = 0.004;
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)range) + " unsupported");
            }
        }
        byte[] commands = new byte[]{10, 44, (byte)(3 | value)};
        this.m_spi.write(commands, commands.length);
    }

    @Override
    public double getX() {
        return this.getAcceleration(Axes.kX);
    }

    @Override
    public double getY() {
        return this.getAcceleration(Axes.kY);
    }

    @Override
    public double getZ() {
        return this.getAcceleration(Axes.kZ);
    }

    public double getAcceleration(Axes axis) {
        if (this.m_spi == null) {
            return 0.0;
        }
        ByteBuffer transferBuffer = ByteBuffer.allocateDirect(4);
        transferBuffer.put(0, (byte)11);
        transferBuffer.put(1, (byte)(14 + axis.value));
        this.m_spi.transaction(transferBuffer, transferBuffer, 4);
        transferBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return (double)transferBuffer.getShort(2) * this.m_gsPerLSB;
    }

    public AllAxes getAccelerations() {
        AllAxes data = new AllAxes();
        if (this.m_spi != null) {
            ByteBuffer dataBuffer = ByteBuffer.allocateDirect(8);
            dataBuffer.put(0, (byte)11);
            dataBuffer.put(1, (byte)14);
            this.m_spi.transaction(dataBuffer, dataBuffer, 8);
            dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
            data.XAxis = (double)dataBuffer.getShort(2) * this.m_gsPerLSB;
            data.YAxis = (double)dataBuffer.getShort(4) * this.m_gsPerLSB;
            data.ZAxis = (double)dataBuffer.getShort(6) * this.m_gsPerLSB;
        }
        return data;
    }

    @Override
    public String getSmartDashboardType() {
        return "3AxisAccelerometer";
    }

    @Override
    public void initTable(ITable subtable) {
        this.m_table = subtable;
        this.updateTable();
    }

    @Override
    public void updateTable() {
        if (this.m_table != null) {
            this.m_table.putNumber("X", this.getX());
            this.m_table.putNumber("Y", this.getY());
            this.m_table.putNumber("Z", this.getZ());
        }
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public void startLiveWindowMode() {
    }

    @Override
    public void stopLiveWindowMode() {
    }

    public static class AllAxes {
        public double XAxis;
        public double YAxis;
        public double ZAxis;
    }

    public static enum Axes {
        kX(0),
        kY(2),
        kZ(4);

        public final byte value;

        private Axes(byte value) {
            this.value = value;
        }
    }
}

