/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables;

import edu.wpi.first.wpilibj.networktables.ConnectionInfo;
import edu.wpi.first.wpilibj.networktables.EntryInfo;
import edu.wpi.first.wpilibj.networktables.NetworkTablesJNI;
import edu.wpi.first.wpilibj.networktables.PersistentException;
import edu.wpi.first.wpilibj.networktables2.type.ArrayData;
import edu.wpi.first.wpilibj.networktables2.type.BooleanArray;
import edu.wpi.first.wpilibj.networktables2.type.NumberArray;
import edu.wpi.first.wpilibj.networktables2.type.StringArray;
import edu.wpi.first.wpilibj.tables.IRemote;
import edu.wpi.first.wpilibj.tables.IRemoteConnectionListener;
import edu.wpi.first.wpilibj.tables.ITable;
import edu.wpi.first.wpilibj.tables.ITableListener;
import edu.wpi.first.wpilibj.tables.TableKeyNotDefinedException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class NetworkTable
implements ITable,
IRemote {
    public static final char PATH_SEPARATOR = '/';
    public static final int DEFAULT_PORT = 1735;
    private static boolean client = false;
    private static boolean enableDS = true;
    private static boolean running = false;
    private static int port = 1735;
    private static String persistentFilename = "networktables.ini";
    private final String path;
    private final String pathWithSep;
    private static IRemote staticRemote = new IRemote(){

        @Override
        public void addConnectionListener(IRemoteConnectionListener listener, boolean immediateNotify) {
            NetworkTable.addGlobalConnectionListener(listener, immediateNotify);
        }

        @Override
        public void removeConnectionListener(IRemoteConnectionListener listener) {
            NetworkTable.removeGlobalConnectionListener(listener);
        }

        @Override
        public boolean isConnected() {
            ConnectionInfo[] conns = NetworkTablesJNI.getConnections();
            return conns.length > 0;
        }

        @Override
        public boolean isServer() {
            return !client;
        }
    };
    private static final Hashtable<IRemoteConnectionListener, ConnectionListenerAdapter> globalConnectionListenerMap = new Hashtable();
    private final Hashtable<IRemoteConnectionListener, ConnectionListenerAdapter> connectionListenerMap = new Hashtable();
    private final Hashtable<ITableListener, List<ListenerBase>> listenerMap = new Hashtable();
    public static final int PERSISTENT = 1;

    private static synchronized void checkInit() {
        if (running) {
            throw new IllegalStateException("Network tables has already been initialized");
        }
    }

    public static synchronized void initialize() {
        if (running) {
            NetworkTable.shutdown();
        }
        if (client) {
            NetworkTablesJNI.startClient();
            if (enableDS) {
                NetworkTablesJNI.startDSClient(port);
            }
        } else {
            NetworkTablesJNI.startServer(persistentFilename, "", port);
        }
        running = true;
    }

    public static synchronized void shutdown() {
        if (!running) {
            return;
        }
        if (client) {
            NetworkTablesJNI.stopDSClient();
            NetworkTablesJNI.stopClient();
        } else {
            NetworkTablesJNI.stopServer();
        }
        running = false;
    }

    public static synchronized void setServerMode() {
        if (!client) {
            return;
        }
        NetworkTable.checkInit();
        client = false;
    }

    public static synchronized void setClientMode() {
        if (client) {
            return;
        }
        NetworkTable.checkInit();
        client = true;
    }

    public static synchronized void setTeam(int team) {
        String[] addresses = new String[]{"10." + team / 100 + "." + team % 100 + ".2", "172.22.11.2", "roboRIO-" + team + "-FRC.local", "roboRIO-" + team + "-FRC.lan", "roboRIO-" + team + "-FRC.frc-field.local"};
        NetworkTable.setIPAddress(addresses);
    }

    public static synchronized void setIPAddress(String address) {
        String[] addresses = new String[]{address};
        NetworkTable.setIPAddress(addresses);
    }

    public static synchronized void setIPAddress(String[] addresses) {
        int[] ports = new int[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            ports[i] = port;
        }
        NetworkTablesJNI.setServer(addresses, ports);
        if (addresses.length > 0 && (addresses[0].equals("localhost") || addresses[0].equals("127.0.0.1"))) {
            NetworkTablesJNI.stopDSClient();
        } else if (enableDS) {
            NetworkTablesJNI.startDSClient(port);
        }
    }

    public static synchronized void setPort(int aport) {
        if (port == aport) {
            return;
        }
        NetworkTable.checkInit();
        port = aport;
    }

    public static synchronized void setDSClientEnabled(boolean enabled) {
        enableDS = enabled;
        if (enableDS) {
            NetworkTablesJNI.startDSClient(port);
        } else {
            NetworkTablesJNI.stopDSClient();
        }
    }

    public static synchronized void setPersistentFilename(String filename) {
        if (persistentFilename.equals(filename)) {
            return;
        }
        NetworkTable.checkInit();
        persistentFilename = filename;
    }

    public static void setNetworkIdentity(String name) {
        NetworkTablesJNI.setNetworkIdentity(name);
    }

    public static boolean[] toNative(Boolean[] arr) {
        boolean[] out = new boolean[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = arr[i];
        }
        return out;
    }

    public static double[] toNative(Number[] arr) {
        double[] out = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = arr[i].doubleValue();
        }
        return out;
    }

    public static Boolean[] fromNative(boolean[] arr) {
        Boolean[] out = new Boolean[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = arr[i];
        }
        return out;
    }

    public static Double[] fromNative(double[] arr) {
        Double[] out = new Double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            out[i] = arr[i];
        }
        return out;
    }

    public static synchronized NetworkTable getTable(String key) {
        if (!running) {
            NetworkTable.initialize();
        }
        if (key.isEmpty() || key.charAt(0) == '/') {
            return new NetworkTable(key);
        }
        return new NetworkTable('/' + key);
    }

    NetworkTable(String path) {
        this.path = path;
        this.pathWithSep = path + '/';
    }

    public String toString() {
        return "NetworkTable: " + this.path;
    }

    public static ConnectionInfo[] connections() {
        return NetworkTablesJNI.getConnections();
    }

    @Override
    public boolean isConnected() {
        ConnectionInfo[] conns = NetworkTablesJNI.getConnections();
        return conns.length > 0;
    }

    @Override
    public boolean isServer() {
        return !client;
    }

    public static synchronized void addGlobalConnectionListener(IRemoteConnectionListener listener, boolean immediateNotify) {
        ConnectionListenerAdapter adapter = globalConnectionListenerMap.get(listener);
        if (adapter != null) {
            throw new IllegalStateException("Cannot add the same listener twice");
        }
        adapter = new ConnectionListenerAdapter(staticRemote, listener);
        adapter.uid = NetworkTablesJNI.addConnectionListener(adapter, immediateNotify);
        globalConnectionListenerMap.put(listener, adapter);
    }

    public static synchronized void removeGlobalConnectionListener(IRemoteConnectionListener listener) {
        ConnectionListenerAdapter adapter = globalConnectionListenerMap.get(listener);
        if (adapter != null) {
            NetworkTablesJNI.removeConnectionListener(adapter.uid);
            globalConnectionListenerMap.remove(listener);
        }
    }

    @Override
    public synchronized void addConnectionListener(IRemoteConnectionListener listener, boolean immediateNotify) {
        ConnectionListenerAdapter adapter = this.connectionListenerMap.get(listener);
        if (adapter != null) {
            throw new IllegalStateException("Cannot add the same listener twice");
        }
        adapter = new ConnectionListenerAdapter(this, listener);
        adapter.uid = NetworkTablesJNI.addConnectionListener(adapter, immediateNotify);
        this.connectionListenerMap.put(listener, adapter);
    }

    @Override
    public synchronized void removeConnectionListener(IRemoteConnectionListener listener) {
        ConnectionListenerAdapter adapter = this.connectionListenerMap.get(listener);
        if (adapter != null) {
            NetworkTablesJNI.removeConnectionListener(adapter.uid);
            this.connectionListenerMap.remove(listener);
        }
    }

    @Override
    public void addTableListener(ITableListener listener) {
        this.addTableListenerEx(listener, 20);
    }

    @Override
    public void addTableListener(ITableListener listener, boolean immediateNotify) {
        int flags = 20;
        if (immediateNotify) {
            flags |= 1;
        }
        this.addTableListenerEx(listener, flags);
    }

    @Override
    public synchronized void addTableListenerEx(ITableListener listener, int flags) {
        List<ListenerBase> adapters = this.listenerMap.get(listener);
        if (adapters == null) {
            adapters = new ArrayList<ListenerBase>();
            this.listenerMap.put(listener, adapters);
        }
        TableListenerAdapter adapter = new TableListenerAdapter(this.path.length() + 1, this, listener);
        adapter.uid = NetworkTablesJNI.addEntryListener(this.pathWithSep, adapter, flags);
        adapters.add(adapter);
    }

    @Override
    public void addTableListener(String key, ITableListener listener, boolean immediateNotify) {
        int flags = 20;
        if (immediateNotify) {
            flags |= 1;
        }
        this.addTableListenerEx(key, listener, flags);
    }

    @Override
    public synchronized void addTableListenerEx(String key, ITableListener listener, int flags) {
        List<ListenerBase> adapters = this.listenerMap.get(listener);
        if (adapters == null) {
            adapters = new ArrayList<ListenerBase>();
            this.listenerMap.put(listener, adapters);
        }
        String fullKey = this.pathWithSep + key;
        KeyListenerAdapter adapter = new KeyListenerAdapter(key, fullKey, this, listener);
        adapter.uid = NetworkTablesJNI.addEntryListener(fullKey, adapter, flags);
        adapters.add(adapter);
    }

    @Override
    public void addSubTableListener(ITableListener listener) {
        this.addSubTableListener(listener, false);
    }

    @Override
    public synchronized void addSubTableListener(ITableListener listener, boolean localNotify) {
        List<ListenerBase> adapters = this.listenerMap.get(listener);
        if (adapters == null) {
            adapters = new ArrayList<ListenerBase>();
            this.listenerMap.put(listener, adapters);
        }
        SubListenerAdapter adapter = new SubListenerAdapter(this.path.length() + 1, this, listener);
        int flags = 5;
        if (localNotify) {
            flags |= 2;
        }
        adapter.uid = NetworkTablesJNI.addEntryListener(this.pathWithSep, adapter, flags);
        adapters.add(adapter);
    }

    @Override
    public synchronized void removeTableListener(ITableListener listener) {
        List<ListenerBase> adapters = this.listenerMap.get(listener);
        if (adapters != null) {
            for (int i = 0; i < adapters.size(); ++i) {
                NetworkTablesJNI.removeEntryListener(adapters.get((int)i).uid);
            }
            adapters.clear();
        }
    }

    @Override
    public ITable getSubTable(String key) {
        return new NetworkTable(this.pathWithSep + key);
    }

    @Override
    public boolean containsKey(String key) {
        return NetworkTablesJNI.containsKey(this.pathWithSep + key);
    }

    @Override
    public boolean containsSubTable(String key) {
        EntryInfo[] entries = NetworkTablesJNI.getEntries(this.pathWithSep + key + '/', 0);
        return entries.length != 0;
    }

    @Override
    public Set<String> getKeys(int types) {
        HashSet<String> keys = new HashSet<String>();
        int prefixLen = this.path.length() + 1;
        for (EntryInfo entry : NetworkTablesJNI.getEntries(this.pathWithSep, types)) {
            String relativeKey = entry.name.substring(prefixLen);
            if (relativeKey.indexOf(47) != -1) continue;
            keys.add(relativeKey);
        }
        return keys;
    }

    @Override
    public Set<String> getKeys() {
        return this.getKeys(0);
    }

    @Override
    public Set<String> getSubTables() {
        HashSet<String> keys = new HashSet<String>();
        int prefixLen = this.path.length() + 1;
        for (EntryInfo entry : NetworkTablesJNI.getEntries(this.pathWithSep, 0)) {
            String relativeKey = entry.name.substring(prefixLen);
            int endSubTable = relativeKey.indexOf(47);
            if (endSubTable == -1) continue;
            keys.add(relativeKey.substring(0, endSubTable));
        }
        return keys;
    }

    @Override
    public boolean putNumber(String key, double value) {
        return NetworkTablesJNI.putDouble(this.pathWithSep + key, value);
    }

    @Override
    public boolean setDefaultNumber(String key, double defaultValue) {
        return NetworkTablesJNI.setDefaultDouble(this.pathWithSep + key, defaultValue);
    }

    @Override
    @Deprecated
    public double getNumber(String key) throws TableKeyNotDefinedException {
        return NetworkTablesJNI.getDouble(this.pathWithSep + key);
    }

    @Override
    public double getNumber(String key, double defaultValue) {
        return NetworkTablesJNI.getDouble(this.pathWithSep + key, defaultValue);
    }

    @Override
    public boolean putString(String key, String value) {
        return NetworkTablesJNI.putString(this.pathWithSep + key, value);
    }

    @Override
    public boolean setDefaultString(String key, String defaultValue) {
        return NetworkTablesJNI.setDefaultString(this.pathWithSep + key, defaultValue);
    }

    @Override
    @Deprecated
    public String getString(String key) throws TableKeyNotDefinedException {
        return NetworkTablesJNI.getString(this.pathWithSep + key);
    }

    @Override
    public String getString(String key, String defaultValue) {
        return NetworkTablesJNI.getString(this.pathWithSep + key, defaultValue);
    }

    @Override
    public boolean putBoolean(String key, boolean value) {
        return NetworkTablesJNI.putBoolean(this.pathWithSep + key, value);
    }

    @Override
    public boolean setDefaultBoolean(String key, boolean defaultValue) {
        return NetworkTablesJNI.setDefaultBoolean(this.pathWithSep + key, defaultValue);
    }

    @Override
    @Deprecated
    public boolean getBoolean(String key) throws TableKeyNotDefinedException {
        return NetworkTablesJNI.getBoolean(this.pathWithSep + key);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return NetworkTablesJNI.getBoolean(this.pathWithSep + key, defaultValue);
    }

    @Override
    public boolean putBooleanArray(String key, boolean[] value) {
        return NetworkTablesJNI.putBooleanArray(this.pathWithSep + key, value);
    }

    @Override
    public boolean putBooleanArray(String key, Boolean[] value) {
        return this.putBooleanArray(key, NetworkTable.toNative(value));
    }

    @Override
    public boolean setDefaultBooleanArray(String key, boolean[] defaultValue) {
        return NetworkTablesJNI.setDefaultBooleanArray(this.pathWithSep + key, defaultValue);
    }

    @Override
    public boolean setDefaultBooleanArray(String key, Boolean[] defaultValue) {
        return NetworkTablesJNI.setDefaultBooleanArray(this.pathWithSep + key, NetworkTable.toNative(defaultValue));
    }

    @Override
    @Deprecated
    public boolean[] getBooleanArray(String key) throws TableKeyNotDefinedException {
        return NetworkTablesJNI.getBooleanArray(this.pathWithSep + key);
    }

    @Override
    public boolean[] getBooleanArray(String key, boolean[] defaultValue) {
        return NetworkTablesJNI.getBooleanArray(this.pathWithSep + key, defaultValue);
    }

    @Override
    public Boolean[] getBooleanArray(String key, Boolean[] defaultValue) {
        try {
            return NetworkTable.fromNative(this.getBooleanArray(key));
        }
        catch (TableKeyNotDefinedException e) {
            return defaultValue;
        }
    }

    @Override
    public boolean putNumberArray(String key, double[] value) {
        return NetworkTablesJNI.putDoubleArray(this.pathWithSep + key, value);
    }

    @Override
    public boolean putNumberArray(String key, Double[] value) {
        return this.putNumberArray(key, NetworkTable.toNative(value));
    }

    @Override
    public boolean setDefaultNumberArray(String key, double[] defaultValue) {
        return NetworkTablesJNI.setDefaultDoubleArray(this.pathWithSep + key, defaultValue);
    }

    @Override
    public boolean setDefaultNumberArray(String key, Double[] defaultValue) {
        return NetworkTablesJNI.setDefaultDoubleArray(this.pathWithSep + key, NetworkTable.toNative(defaultValue));
    }

    @Override
    @Deprecated
    public double[] getNumberArray(String key) throws TableKeyNotDefinedException {
        return NetworkTablesJNI.getDoubleArray(this.pathWithSep + key);
    }

    @Override
    public double[] getNumberArray(String key, double[] defaultValue) {
        return NetworkTablesJNI.getDoubleArray(this.pathWithSep + key, defaultValue);
    }

    @Override
    public Double[] getNumberArray(String key, Double[] defaultValue) {
        try {
            return NetworkTable.fromNative(this.getNumberArray(key));
        }
        catch (TableKeyNotDefinedException e) {
            return defaultValue;
        }
    }

    @Override
    public boolean putStringArray(String key, String[] value) {
        return NetworkTablesJNI.putStringArray(this.pathWithSep + key, value);
    }

    @Override
    public boolean setDefaultStringArray(String key, String[] defaultValue) {
        return NetworkTablesJNI.setDefaultStringArray(this.pathWithSep + key, defaultValue);
    }

    @Override
    @Deprecated
    public String[] getStringArray(String key) throws TableKeyNotDefinedException {
        return NetworkTablesJNI.getStringArray(this.pathWithSep + key);
    }

    @Override
    public String[] getStringArray(String key, String[] defaultValue) {
        return NetworkTablesJNI.getStringArray(this.pathWithSep + key, defaultValue);
    }

    @Override
    public boolean putRaw(String key, byte[] value) {
        return NetworkTablesJNI.putRaw(this.pathWithSep + key, value);
    }

    @Override
    public boolean setDefaultRaw(String key, byte[] defaultValue) {
        return NetworkTablesJNI.setDefaultRaw(this.pathWithSep + key, defaultValue);
    }

    @Override
    public boolean putRaw(String key, ByteBuffer value, int len) {
        if (!value.isDirect()) {
            throw new IllegalArgumentException("must be a direct buffer");
        }
        if (value.capacity() < len) {
            throw new IllegalArgumentException("buffer is too small, must be at least " + len);
        }
        return NetworkTablesJNI.putRaw(this.pathWithSep + key, value, len);
    }

    @Override
    @Deprecated
    public byte[] getRaw(String key) throws TableKeyNotDefinedException {
        return NetworkTablesJNI.getRaw(this.pathWithSep + key);
    }

    @Override
    public byte[] getRaw(String key, byte[] defaultValue) {
        return NetworkTablesJNI.getRaw(this.pathWithSep + key, defaultValue);
    }

    @Override
    public boolean putValue(String key, Object value) throws IllegalArgumentException {
        if (value instanceof Boolean) {
            return NetworkTablesJNI.putBoolean(this.pathWithSep + key, (Boolean)value);
        }
        if (value instanceof Number) {
            return NetworkTablesJNI.putDouble(this.pathWithSep + key, ((Number)value).doubleValue());
        }
        if (value instanceof String) {
            return NetworkTablesJNI.putString(this.pathWithSep + key, (String)value);
        }
        if (value instanceof byte[]) {
            return NetworkTablesJNI.putRaw(this.pathWithSep + key, (byte[])value);
        }
        if (value instanceof boolean[]) {
            return NetworkTablesJNI.putBooleanArray(this.pathWithSep + key, (boolean[])value);
        }
        if (value instanceof double[]) {
            return NetworkTablesJNI.putDoubleArray(this.pathWithSep + key, (double[])value);
        }
        if (value instanceof Boolean[]) {
            return NetworkTablesJNI.putBooleanArray(this.pathWithSep + key, NetworkTable.toNative((Boolean[])value));
        }
        if (value instanceof Number[]) {
            return NetworkTablesJNI.putDoubleArray(this.pathWithSep + key, NetworkTable.toNative((Number[])value));
        }
        if (value instanceof String[]) {
            return NetworkTablesJNI.putStringArray(this.pathWithSep + key, (String[])value);
        }
        if (value instanceof BooleanArray) {
            return NetworkTablesJNI.putBooleanArray(this.pathWithSep + key, NetworkTable.toNative((Boolean[])((ArrayData)value).getDataArray()));
        }
        if (value instanceof NumberArray) {
            return NetworkTablesJNI.putDoubleArray(this.pathWithSep + key, NetworkTable.toNative((Double[])((ArrayData)value).getDataArray()));
        }
        if (value instanceof StringArray) {
            return NetworkTablesJNI.putStringArray(this.pathWithSep + key, (String[])((ArrayData)value).getDataArray());
        }
        throw new IllegalArgumentException("Value of type " + value.getClass().getName() + " cannot be put into a table");
    }

    @Override
    @Deprecated
    public void retrieveValue(String key, Object externalData) throws TableKeyNotDefinedException {
        Object value = this.getValue(key);
        if (value instanceof boolean[] && externalData instanceof BooleanArray) {
            ((ArrayData)externalData).setDataArray(NetworkTable.fromNative((boolean[])value));
        } else if (value instanceof double[] && externalData instanceof NumberArray) {
            ((ArrayData)externalData).setDataArray(NetworkTable.fromNative((double[])value));
        } else if (value instanceof String[] && externalData instanceof StringArray) {
            ((ArrayData)externalData).setDataArray((String[])value);
        } else {
            throw new TableKeyNotDefinedException(key);
        }
    }

    @Override
    @Deprecated
    public Object getValue(String key) throws TableKeyNotDefinedException {
        return NetworkTablesJNI.getValue(this.pathWithSep + key);
    }

    @Override
    public Object getValue(String key, Object defaultValue) {
        return NetworkTablesJNI.getValue(this.pathWithSep + key, defaultValue);
    }

    @Override
    public void setPersistent(String key) {
        this.setFlags(key, 1);
    }

    @Override
    public void clearPersistent(String key) {
        this.clearFlags(key, 1);
    }

    @Override
    public boolean isPersistent(String key) {
        return (this.getFlags(key) & 1) != 0;
    }

    @Override
    public void setFlags(String key, int flags) {
        NetworkTablesJNI.setEntryFlags(this.pathWithSep + key, this.getFlags(key) | flags);
    }

    @Override
    public void clearFlags(String key, int flags) {
        NetworkTablesJNI.setEntryFlags(this.pathWithSep + key, this.getFlags(key) & ~flags);
    }

    @Override
    public int getFlags(String key) {
        return NetworkTablesJNI.getEntryFlags(this.pathWithSep + key);
    }

    @Override
    public void delete(String key) {
        NetworkTablesJNI.deleteEntry(this.pathWithSep + key);
    }

    public static void globalDeleteAll() {
        NetworkTablesJNI.deleteAllEntries();
    }

    public static void flush() {
        NetworkTablesJNI.flush();
    }

    public static void setUpdateRate(double interval) {
        NetworkTablesJNI.setUpdateRate(interval);
    }

    public static void savePersistent(String filename) throws PersistentException {
        NetworkTablesJNI.savePersistent(filename);
    }

    public static String[] loadPersistent(String filename) throws PersistentException {
        return NetworkTablesJNI.loadPersistent(filename);
    }

    @Override
    @Deprecated
    public boolean putInt(String key, int value) {
        return this.putNumber(key, value);
    }

    @Override
    @Deprecated
    public int getInt(String key) throws TableKeyNotDefinedException {
        return (int)this.getNumber(key);
    }

    @Override
    @Deprecated
    public int getInt(String key, int defaultValue) throws TableKeyNotDefinedException {
        try {
            return (int)this.getNumber(key);
        }
        catch (NoSuchElementException ex) {
            return defaultValue;
        }
    }

    @Override
    @Deprecated
    public boolean putDouble(String key, double value) {
        return this.putNumber(key, value);
    }

    @Override
    @Deprecated
    public double getDouble(String key) throws TableKeyNotDefinedException {
        return this.getNumber(key);
    }

    @Override
    @Deprecated
    public double getDouble(String key, double defaultValue) {
        return this.getNumber(key, defaultValue);
    }

    private class SubListenerAdapter
    extends ListenerBase
    implements NetworkTablesJNI.EntryListenerFunction {
        private final int prefixLen;
        private final ITable targetSource;
        private final ITableListener targetListener;
        private final Set<String> notifiedTables;

        public SubListenerAdapter(int prefixLen, ITable targetSource, ITableListener targetListener) {
            this.notifiedTables = new HashSet<String>();
            this.prefixLen = prefixLen;
            this.targetSource = targetSource;
            this.targetListener = targetListener;
        }

        @Override
        public void apply(int uid, String key, Object value, int flags) {
            String relativeKey = key.substring(this.prefixLen);
            int endSubTable = relativeKey.indexOf(47);
            if (endSubTable == -1) {
                return;
            }
            String subTableKey = relativeKey.substring(0, endSubTable);
            if (this.notifiedTables.contains(subTableKey)) {
                return;
            }
            this.notifiedTables.add(subTableKey);
            this.targetListener.valueChangedEx(this.targetSource, subTableKey, this.targetSource.getSubTable(subTableKey), flags);
        }
    }

    private class KeyListenerAdapter
    extends ListenerBase
    implements NetworkTablesJNI.EntryListenerFunction {
        private final String relativeKey;
        private final String fullKey;
        private final ITable targetSource;
        private final ITableListener targetListener;

        public KeyListenerAdapter(String relativeKey, String fullKey, ITable targetSource, ITableListener targetListener) {
            this.relativeKey = relativeKey;
            this.fullKey = fullKey;
            this.targetSource = targetSource;
            this.targetListener = targetListener;
        }

        @Override
        public void apply(int uid, String key, Object value, int flags) {
            if (!key.equals(this.fullKey)) {
                return;
            }
            this.targetListener.valueChangedEx(this.targetSource, this.relativeKey, value, flags);
        }
    }

    private class TableListenerAdapter
    extends ListenerBase
    implements NetworkTablesJNI.EntryListenerFunction {
        private final int prefixLen;
        private final ITable targetSource;
        private final ITableListener targetListener;

        public TableListenerAdapter(int prefixLen, ITable targetSource, ITableListener targetListener) {
            this.prefixLen = prefixLen;
            this.targetSource = targetSource;
            this.targetListener = targetListener;
        }

        @Override
        public void apply(int uid, String key, Object value, int flags) {
            String relativeKey = key.substring(this.prefixLen);
            if (relativeKey.indexOf(47) != -1) {
                return;
            }
            this.targetListener.valueChangedEx(this.targetSource, relativeKey, value, flags);
        }
    }

    private static class ConnectionListenerAdapter
    extends ListenerBase
    implements NetworkTablesJNI.ConnectionListenerFunction {
        private final IRemote targetSource;
        private final IRemoteConnectionListener targetListener;

        public ConnectionListenerAdapter(IRemote targetSource, IRemoteConnectionListener targetListener) {
            this.targetSource = targetSource;
            this.targetListener = targetListener;
        }

        @Override
        public void apply(int uid, boolean connected, ConnectionInfo conn) {
            if (connected) {
                this.targetListener.connectedEx(this.targetSource, conn);
            } else {
                this.targetListener.disconnectedEx(this.targetSource, conn);
            }
        }
    }

    private static class ListenerBase {
        public int uid;

        private ListenerBase() {
        }
    }
}

