/*
 * Decompiled with CFR 0.152.
 */
package org.usfirst.frc.team5800.robot.superclasses;

import edu.wpi.first.wpilibj.buttons.Button;
import org.usfirst.frc.team5800.robot.Robot;
import org.usfirst.frc.team5800.robot.base.commands.CommandBase;
import org.usfirst.frc.team5800.robot.superclasses.Subsystem5800;

public abstract class Command5800
extends CommandBase {
    protected Command5800 commandParallel;
    protected Command5800 commandSequential;
    public boolean startedInAuto = false;
    private boolean isWhileHeld = false;
    private Button button;

    public Command5800(Subsystem5800 requiredSystem) {
        if (requiredSystem != null) {
            this.requires(requiredSystem);
        }
    }

    @Override
    protected abstract void execute();

    protected abstract boolean isDone();

    protected abstract void onCompletion();

    protected void onStart() {
    }

    @Override
    protected void interrupted() {
        this.end();
    }

    @Override
    protected final void initialize() {
        if (this.commandParallel != null) {
            this.commandParallel.start();
        }
        this.startedInAuto = Robot.isAuto;
        this.onStart();
    }

    @Override
    protected final boolean isFinished() {
        return this.isWhileHeld && !this.button.get() || this.isDone();
    }

    @Override
    protected final void end() {
        if (this.commandSequential != null && (!this.startedInAuto || Robot.isAuto)) {
            this.commandSequential.start();
        }
        this.onCompletion();
    }

    public final Command5800 setParallel(Command5800 ... commands) {
        if (commands.length > 1) {
            Command5800[] newCommands = new Command5800[commands.length - 1];
            for (int a = 1; a < commands.length; ++a) {
                newCommands[a - 1] = commands[a];
            }
            if (this.commandParallel != null) {
                this.commandParallel.setParallel(commands[0].setSequential(newCommands));
            } else {
                this.commandParallel = commands[0].setSequential(newCommands);
            }
        } else if (this.commandParallel != null) {
            this.commandParallel.setParallel(commands[0]);
        } else {
            this.commandParallel = commands[0];
        }
        return this;
    }

    public final Command5800 setSequential(Command5800 ... commands) {
        if (commands.length > 1) {
            Command5800[] newCommands = new Command5800[commands.length - 1];
            for (int a = 1; a < commands.length; ++a) {
                newCommands[a - 1] = commands[a];
            }
            if (this.commandSequential != null) {
                this.commandSequential.setParallel(commands[0].setSequential(newCommands));
            } else {
                this.commandSequential = commands[0].setSequential(newCommands);
            }
        } else if (this.commandSequential != null) {
            this.commandSequential.setParallel(commands[0]);
        } else {
            this.commandSequential = commands[0];
        }
        return this;
    }

    public final Command5800 setCancelWhenReleased(Button button) {
        this.isWhileHeld = true;
        this.button = button;
        return this;
    }
}

