/*
 * Decompiled with CFR 0.152.
 */
package org.usfirst.frc.team5800.robot.base.commands.drive;

import org.usfirst.frc.team5800.robot.superclasses.Command5800;

public class CommandTurnDegrees
extends Command5800 {
    int degreesToTurn;
    int pulsesToTurn;
    double leftValue;
    double rightValue;
    int error;
    double originalDegrees;

    public CommandTurnDegrees(int degrees, double l, double r) {
        super(driver);
        this.degreesToTurn = degrees - 6;
        this.leftValue = l;
        this.rightValue = r;
        this.setTimeout(0.1);
    }

    @Override
    protected void onStart() {
        CommandTurnDegrees.sensors.driveEncoderL.reset();
        CommandTurnDegrees.sensors.driveEncoderR.reset();
        CommandTurnDegrees.sensors.gyro.reset();
    }

    @Override
    protected void execute() {
        driver.tankDrive(this.leftValue, this.rightValue);
    }

    @Override
    protected boolean isDone() {
        int degreesTurned = (int)CommandTurnDegrees.sensors.gyro.getAngle();
        return Math.abs(degreesTurned) >= Math.abs(this.degreesToTurn) && this.isTimedOut();
    }

    @Override
    protected void onCompletion() {
    }
}

